<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_formal_white', language 'de', version '5.0'.
 *
 * @package     theme_formal_white
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['blockcolumnwidth'] = 'Spaltenbreite der Blöcke';
$string['blockcolumnwidthdesc'] = 'Diese Option bestimmt die Spaltenbreite für Blöcke. <strong>Mit Werten unter 200px (blockcolumnwidth-2*blockpadding) kann der Kalenderblock nicht richtig angezeigt werden.</strong>';
$string['blockcontentbgc'] = 'Hintergrundfarbe Blöcke';
$string['blockcontentbgcdesc'] = 'Diese Option legt die Hintergrundfarbe für die Blockinhalte fest.';
$string['blockpadding'] = 'Seitenabstand der Blöcke';
$string['blockpaddingdesc'] = 'Diese Option legt den Abstand zwischen den Blöcken und zum Spaltenrand fest.';
$string['blueberry'] = 'Blueberry';
$string['choosereadme'] = '<div class="clearfix">
<div class="theme_screenshot">
<h2>Formal White</h2>
<img src="formal_white/pix/screenshot.gif" />
<h3>Forum zur Designdiskussion:</h3>
<p><a href="http://moodle.org/mod/forum/view.php?id=46">http://moodle.org/mod/forum/view.php?id=46</a></p>
<h3>Danksagungen (Designs):</h3>
<p><a href="http://docs.moodle.org/en/Theme_credits">http://docs.moodle.org/en/Theme_credits</a></p>
<h3>Dokumentationen:</h3>
<p><a href="http://docs.moodle.org/de/Designs">http://docs.moodle.org/de/Designs</a></p>
<h3>Fehler melden:</h3>
<p><a href="http://tracker.moodle.org">http://tracker.moodle.org</a></p>
</div>
<div class="theme_description">
<h2>Über Formal White</h2>
<p>Formal White ist ein Drei-Spalten-Design mit variabler Breite für Moodle 2.0.</p>
<h2>Hinweise</h2>
<p>Dieses Design basiert auf den beiden in Moodle enthaltenen Grunddesigns Base und Canvas. Wenn Sie Änderungen vornehmen wollen, empfehlen wir unbedingt, vorher immer eine Kopie zu erstellen und diese umzubenennen. So wird verhindert, dass Ihre Änderungen bei einem Update von Moodle verloren gehen; Sollte Ihnen ein Fehler in den Änderungen unterlaufen, haben Sie so ebenfalls noch eine funktionierende Sicherheitskopie. Weitere Informationen zum Bearbeiten von Designs finden Sie in den <a href="http://docs.moodle.org/de/Designs">Design-Dokumentationen</a>.</p>
<h2>Autor</h2>
<p>Dieses Design wurde für Moodle 2.0 erstellt und wird weiter unterstützt von MediaTouch 2000. </p>
<h2>Lizenz</h2>
<p>Alle in Moodle enthaltenen Grunddesigns stehen unter der <a href="http://www.gnu.org/licenses/gpl.html">GNU General Public License</a>.</p>
</div>
</div>';
$string['configtitle'] = 'Formal White-Einstellungen';
$string['creditstomoodleorg'] = 'Hinweis auf Moodle.org zeigen';
$string['creditstomoodleorgdesc'] = 'Moodle-Logo unten auf der Seite zeigen';
$string['ctmo_ineverypage'] = 'auf jeder Seite';
$string['ctmo_no'] = 'nie';
$string['ctmo_onfrontpageonly'] = 'nur auf der Startseite';
$string['customcss'] = 'CSS-Anpassungen';
$string['customcssdesc'] = 'Die CSS-Anpassungen werden auf jeder Seite benutzt. Das Design kann so einfach geändert werden. Wenn Sie z.B. die Farbe der Links ändern möchten, geben Sie folgenden Code ein:
<pre>a:link, a:visited, a:hover, a:active, a:focus {color:blue;}</pre>';
$string['customlogourl'] = 'Eigenes Logo';
$string['customlogourldesc'] = 'Wenn Sie das Logo ändern möchten, geben Sie eine URL zum Logo an, z.B. http://www.meinserver.de/verzeichnis/logo.png oder ../pfad/logo.png. Das Standardlogo hat das Format .png und ist transparent, 200px breit und 50px hoch.';
$string['displayheading'] = 'Kopfzeilentext anzeigen';
$string['displaylogo'] = 'Logo anzeigen';
$string['fontsizereference'] = 'Textgröße';
$string['fontsizereferencedesc'] = 'Mit dieser Option kann die Textgröße für dieses Design festgelegt werden. Es ist nicht empfehlenswert, den Wert größer als 13px zu setzen, da andernfalls in einigen Blöcken Probleme auftreten könnten.';
$string['footnote'] = 'Fußzeile';
$string['footnotedesc'] = 'Der Inhalt dieses Feldes wird auf jeder Seite als Fußzeile angezeigt.';
$string['framemargin'] = 'Rahmenabstand';
$string['framemargindesc'] = 'Abstand zwischen dem Rahmen und dem Rand des Browserfensters. Die Option wird ignoriert, wenn \'{$a}\' eingestellt ist.';
$string['frontpagelogourl'] = 'Eigenes Logo für die Startseite';
$string['frontpagelogourldesc'] = 'Wenn Sie das Logo der Startseite ändern möchten, geben Sie eine URL zum Logo an, z.B. http://www.meinserver.de/verzeichnis/logo.png oder ../pfad/logo.png. Das Standardlogo der Startseite hat das Format .png und ist transparent, 300px breit und 80px hoch.';
$string['headerbgc'] = 'Hintergrundfarbe Kopfbereich';
$string['headerbgcdesc'] = 'Diese Option legt die Hintergrundfarbe für den Kopfbereich fest.';
$string['headercontent'] = 'Kopfbereich';
$string['headercontentdesc'] = 'Wählen Sie, ob im Kopfbereich das Logo oder der Kopfzeilentext angezeigt werden soll.';
$string['lblockcolumnbgc'] = 'Hintergrundfarbe links';
$string['lblockcolumnbgcdesc'] = 'Diese Option legt die Hintergrundfarbe für die linke Spalte fest.';
$string['lemon'] = 'Lemon';
$string['lime'] = 'Lime';
$string['mink'] = 'Mink';
$string['noframe'] = 'Kein äußerer Rahmen';
$string['noframedesc'] = 'Wenn diese Option aktiviert ist, wird das Design ohne den umgebenden äußeren Rahmen angezeigt, also wie in Moodle 1.9.';
$string['orange'] = 'Orange';
$string['peach'] = 'Peach';
$string['pluginname'] = 'Formal White';
$string['rblockcolumnbgc'] = 'Hintergrundfarbe rechts';
$string['rblockcolumnbgcdesc'] = 'Diese Option legt die Hintergrundfarbe für die rechte Spalte fest. Wenn Sie dieses Feld leer lassen, wird hier ebenfalls die Farbe für die linke Spalte benutzt.';
$string['region-side-post'] = 'Rechts';
$string['region-side-pre'] = 'Links';
$string['silver'] = 'Silver';
$string['trendcolor'] = 'Farbeindruck';
$string['trendcolordesc'] = 'Wählen Sie die Farbrichtung des Designs.';
