<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'admin', language 'de', version '5.0'.
 *
 * @package     admin
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'Kein Zugriff';
$string['accountlocked'] = 'Ihr Nutzerkonto ist gesperrt. Ein Link zum Entsperren wurde per E-Mail gesendet.';
$string['accounts'] = 'Nutzerkonten';
$string['accountunlocked'] = 'Ihr Nutzerkonto ist entsperrt. Sie können sich anmelden.';
$string['addcategory'] = 'Kursbereich hinzufügen';
$string['additionalhtml'] = 'Zusätzliches HTML';
$string['additionalhtml_desc'] = 'Die folgenden Felder erlauben die Eingabe von HTML-Code, der automatisch auf jeder Seite eingefügt wird. Vorgesehen sind Anweisungen innerhalb des &lt;head&gt;-Bereichs, direkt am Anfang des &lt;body&gt;-Bereichs und direkt am Ende des &lt;body&gt;-Bereichs. <br /><br />Auf diese Weise können nutzerdefinierte Kopf- oder Fußzeilen auf jeder Seite eingefügt werden. Zur Einbindung von externen Diensten wie Google Analytics ist es sehr einfach, die notwendigen Anweisungen einzutragen und unabhängig vom gewählten Design zu benutzen.';
$string['additionalhtml_heading'] = 'Zusätzlicher HTML-Code für jede Seite
';
$string['additionalhtmlfooter'] = 'Vor dem Schließen von &lt;body&gt;';
$string['additionalhtmlfooter_desc'] = 'Dieser HTML-Code wird auf jeder Seite direkt vor dem Ende des &lt;body&gt;-Bereichs eingefügt';
$string['additionalhtmlhead'] = 'Innerhalb von &lt;head&gt;';
$string['additionalhtmlhead_desc'] = 'Dieser HTML-Code wird auf jeder Seite innerhalb des &lt;head&gt;-Bereichs eingefügt';
$string['additionalhtmltopofbody'] = 'Nach dem Öffnen von &lt;body&gt;';
$string['additionalhtmltopofbody_desc'] = 'Dieser HTML-Code wird auf jeder Seite direkt am Anfang des &lt;body&gt;-Bereichs eingefügt';
$string['admincategory'] = 'Bereich: {$a}';
$string['adminseesall'] = 'Administrator/innen sehen alles';
$string['adminseesallevents'] = 'Administrator/innen sehen alle Termine';
$string['adminseesownevents'] = 'Administrator/innen sehen nur eigene Termine';
$string['advancedfeatures'] = 'Zusatzoptionen';
$string['agedigitalconsentverification'] = 'Altersfeststellung für Datenverarbeitung';
$string['agedigitalconsentverification_desc'] = 'Überprüfung des digitalen Einwilligungsalters, bevor die Anmeldeseite für zur Selbstregistrierung angezeigt wird. Dies soll Ihre Website vor Minderjährigen schützen, die sich ohne Zustimmung der Erziehungsberechtigten anmelden. Zur weiteren Hilfe werden <a target="_blank" href="{$a}">Kontaktdaten für den Support</a> bereitgestellt.';
$string['ageofdigitalconsentmap'] = 'Altersfeststellung';
$string['ageofdigitalconsentmap_desc'] = 'Das Alters, ab dem Nutzer/innen selber ihre Zustimmung zur Verarbeitung von Daten geben dürfen, ist gesetzlich festgelegt. Geben Sie jedes Alter in einer neuen Zeile mit folgendem Format ein: Ländercode, Alter (getrennt durch ein Komma). Das Standardalter wird durch * anstelle des Ländercodes angezeigt. Ländercodes entsprechen der Norm ISO 3166-2.';
$string['allcountrycodes'] = 'Alle Ländercodes';
$string['allowattachments'] = 'Anhänge erlauben';
$string['allowbeforeblock'] = 'Zugelassene IP-Adressen vorrangig behandeln';
$string['allowbeforeblockdesc'] = 'Zumeist wird die Liste der gesperrten IP-Adressen zuerst berücksichtigt. Falls diese Einstellung aktiviert ist, hat die Liste der zugelassenen IP-Adressen Vorrang.';
$string['allowcategorythemes'] = 'Designwechsel im Kursbereich erlauben';
$string['allowcohortthemes'] = 'Designs für globale Gruppen erlauben';
$string['allowcoursethemes'] = 'Designwechsel im Kurs erlauben';
$string['allowedemaildomains'] = 'Erlaubte E-Mail-Domains';
$string['allowediplist'] = 'Zugelassene IP-Adressen';
$string['allowemailaddresses'] = 'E-Mail-Domains vorgeben';
$string['allowemojipicker'] = 'Emoji-Auswahl';
$string['allowframembedding'] = 'Frame-Einbettung erlauben';
$string['allowframembedding_help'] = 'Diese Option ermöglicht das Einbetten dieser Website als Frame in einem fremden System. Das Einschalten dieser Option wird nur bei der Verwendung des Einschreibe-Plugins \'Veröffentlichen als LTI-Tool\' empfohlen. Ansonsten sollte die Option aus Sicherheitsgründen deaktiviert sein. In der Moodle App wird diese Einstellung ignoriert, was das Embedding im Frame hier immer zulässt.';
$string['allowguestmymoodle'] = 'Dashboard für Gäste erlauben';
$string['allowindexing'] = 'Indizierung durch Suchmaschinen erlauben';
$string['allowindexing_desc'] = 'Diese Option legt fest, ob Suchmaschinen die Website indizieren dürfen. "Überall" erlaubt wirklich überall zu suchen, auch wenn die Einstellung "Login erforderlich" aktiviert ist. Mit "Überall außer Anmeldeseiten" reduzieren Sie das Risiko von Spam, denn  Anmeldeseiten könnten während der Indizierung gerade persönliche Angaben enthalten. "Nirgends" verhindert die Indizierung jeder Seite. Beachten Sie, dass mit der Einstellung lediglich ein Tag im Header der Website geschrieben wird, den alle Suchmaschinen respektieren sollten (aber nicht immer tun!).';
$string['allowindexingeverywhere'] = 'Überall';
$string['allowindexingexceptlogin'] = 'Überall außer Anmeldeseiten';
$string['allowindexingnowhere'] = 'Nirgends';
$string['allowobjectembed'] = 'object/embed erlauben';
$string['allowthemechangeonurl'] = 'Designwechsel über URL erlauben';
$string['allowuserblockhiding'] = 'Minimierung von Blöcken erlauben';
$string['allowusermailcharset'] = 'E-Mail-Zeichensatz wählbar';
$string['allowuserswitchrolestheycantassign'] = 'Rollenwechsel für Nutzer/innen erlauben, die kein Recht zur Rollenzuweisung besitzen';
$string['allowuserthemes'] = 'Designwechsel für Nutzer/innen erlauben';
$string['alternativefullnameformat'] = 'Vollständiger Name - Alternative';
$string['alternativefullnameformat_desc'] = 'Diese Option legt fest, wie Namen für Nutzer/innen angezeigt werden, die über die Berechtigung  \'viewfullname\' verfügen. Dies sind normalerweise: Manager/innen, Trainer/innen sowie Trainer/innen ohne Bearbeitungsrecht. Es können die gleichen Platzhalter verwendet werden wie für die Einstellungen zum \'Vollständigen Namen\'.';
$string['always'] = 'Immer';
$string['appearance'] = 'Darstellung';
$string['aspellpath'] = 'Pfad zu aspell';
$string['asyncbackupdisabled'] = 'Diese Website ist derzeit für synchrone Sicherungen konfiguriert. Asynchrone Sicherungen sorgen für ein besseres Nutzererlebnis und erlauben es Nutzer/innen. an anderer Stelle weiterzuarbeiten. Asynchrone Sicherungen werden für alle Websites von Moodle LMS 4.5 LTS aktiviert. Synchrone Sicherungen werden aus Moodle LMS der Version nach 4.5 LTS entfernt.';
$string['authentication'] = 'Authentifizierung';
$string['authpreventaccountcreation'] = 'Accounterstellung während Authentifizierung verhindern';
$string['authpreventaccountcreation_help'] = 'Wenn sich Nutzer/innen authentifizieren, werden auf der Website automatisch Nutzerkonten angelegt, falls diese noch nicht existieren. Diese Option sollte aktiviert werden, wenn eine externe Datenbank wie z.B. LDAP zur Authentifizierung genutzt wird und sich nur bereits existierende Nutzer/innen authentifizieren sollen. Neue Nutzerkonten müssen dann von Hand oder Nutzerupload per cvs angelegt werden. Hinweis: diese Einstellung gilt nicht für die MNet-Authentifizierung.';
$string['authsettings'] = 'Übersicht';
$string['autolang'] = 'Sprache erkennen';
$string['autolangusercreation'] = 'Bei Kontoerstellung die Browsersprache als bevorzugte Sprache festlegen';
$string['autologinguests'] = 'Gäste automatisch einloggen';
$string['availableto'] = 'Verfügbar für';
$string['availabletoanyone'] = 'Verfügbar für alle, die die Website besuchen';
$string['availabletoauthenticated'] = 'Beschränkt auf authentifizierte Nutzer/innen';
$string['backgroundcolour'] = 'Transparenzfarbe';
$string['backup_shortname'] = 'Kurstitel als Name für Sicherungsdatei verwenden';
$string['backup_shortnamehelp'] = 'Den Kurstitel und nicht die Kurs-ID-Nummer als Teil der Bezeichnung der Sicherungsdatei verwenden.';
$string['backups'] = 'Sicherung';
$string['badwordsconfig'] = 'Geben Sie eine kommagetrennte Liste der Wörter ein, die zensiert werden sollen.';
$string['badwordsdefault'] = 'Wenn die eigene Liste leer ist, wird die Wörterliste aus dem Sprachpaket verwendet.';
$string['badwordslist'] = 'Liste mit unerwünschten Wörtern';
$string['blockediplist'] = 'Gesperrte IP-Adressen';
$string['blockinstances'] = 'Instanzen';
$string['blockmultiple'] = 'Mehrfach';
$string['blockprotect'] = 'Instanzen schützen';
$string['blockprotect_help'] = 'Wenn Sie bestimmte Blöcke sperren, kann niemand solche Blöcke neu hinzufügen oder löschen. Sie können die Blöcke natürlich entsperren, falls Sie solche Blöcke bearbeiten müssen.

Dies soll dazu dienen, Blöcke wie Navigation oder Einstellungen zu schützen, die nur sehr schwer wiederherzustellen sind, wenn sie aus Versehen gelöscht wurden.';
$string['blockprotectblock'] = 'Instanzen von {$a} schützen';
$string['blockprotected'] = '{$a} Instanzen sind geschützt.';
$string['blocksettings'] = 'Übersicht';
$string['blockunprotectblock'] = 'Instanzen von {$a} entsperren';
$string['blockunprotected'] = '{$a} Instanzen sind nun entsperrt.';
$string['bloglevel'] = 'Blogsichtbarkeit';
$string['bookmarkadded'] = 'Lesezeichen hinzugefügt';
$string['bookmarkalreadyexists'] = 'Sie haben diese Seite bereits als Lesezeichen gespeichert.';
$string['bookmarkdeleted'] = 'Lesezeichen gelöscht';
$string['bookmarkthispage'] = 'Seite als Lesezeichen speichern';
$string['cacheapplication'] = 'Anwendungs-Cache';
$string['cacheapplicationhelp'] = 'Elemente im Cache werden für alle Nutzer/innen geteilt und verfallen erst nach einer gewissen Zeit';
$string['cachejs'] = 'JavaScript Cache';
$string['cachejs_help'] = 'Bei JavaScript führen Komprimierung und Caching zu höherer Leistung. Diese Option sollte für Produktivsysteme unbedingt aktiviert sein. Entwickler/innen möchten die Option eventuell deaktivieren.';
$string['cacherequest'] = 'Abfrage-Cache';
$string['cacherequesthelp'] = 'Nutzerbezogener Cache, der abläuft, wenn die Abfrage beendet ist. Er ersetzt Bereiche, wo Moodle statische Speicher verwendet.';
$string['cachesession'] = 'Session-Cache';
$string['cachesessionhelp'] = 'Nutzerbezogener Cache, der die Session beschleunigt und mit dem Abmelden gelöscht wird.';
$string['cachesettings'] = 'Cache-Einstellungen';
$string['cachetemplates'] = 'Cache-Templates';
$string['cachetemplates_help'] = 'Das Template-Caching verbessert das Ladeverhalten und ist für produktive Websites dringend empfohlen.  Entwickler/innen werden diese Option ggfs. deaktivieren.';
$string['caching'] = 'Caching';
$string['calendar_weekend'] = 'Tage am Wochenende';
$string['calendarexportsalt'] = 'Exportschlüssel für den Kalender';
$string['calendarsettings'] = 'Kalender';
$string['calendartype'] = 'Kalendertyp';
$string['calendartype_desc'] = 'Wählen Sie einen Kalendertyp für die gesamte Website. Diese Einstellung kann in den Kurseinstellungen oder in den persönlichen Nutzerprofilen geändert werden.';
$string['campaign'] = 'Kampagne';
$string['cannotdeletemodfilter'] = 'Der Filter \'{$a->filter}\' kann nicht deinstalliert werden, weil er Teil des Moduls \'{$a->module}\' ist.';
$string['cannotuninstall'] = '{$a} kann nicht deinstalliert werden.';
$string['categoryemail'] = 'E-Mail';
$string['cfgwwwrootslashwarning'] = 'In der Datei config.php ist die Einstellung für $CFG->wwwroot  falsch eingetragen. Das Zeichen \'/\' am Ende muss gelöscht werden.';
$string['cfgwwwrootwarning'] = 'In der Datei config.php ist die Einstellung für $CFG->wwwroot  falsch eingetragen. Der Text passt nicht zu der URL, mit der die Seite aufgerufen wurde.';
$string['change'] = 'Ändern';
$string['checkboxno'] = 'Nein';
$string['checkboxyes'] = 'Ja';
$string['checkupgradepending'] = 'Aktualisieren';
$string['choosefiletoedit'] = 'Wählen Sie eine Datei zum Bearbeiten';
$string['cleanup'] = 'Aufräumarbeiten';
$string['clianswerno'] = 'n';
$string['cliansweryes'] = 'y';
$string['cliexitgraceful'] = 'Warten Sie bitte ...';
$string['cliexitnow'] = 'Sofort beenden';
$string['cliincorrectvalueerror'] = 'Fehler: Falscher Wert "{$a->value}" für "{$a->option}"';
$string['cliincorrectvalueretry'] = 'Falscher Wert - bitte nochmal';
$string['clistatusdisabled'] = 'Status: deaktiviert';
$string['clistatusenabled'] = 'Status: aktiviert';
$string['clistatusenabledlater'] = 'Der CLI Wartungsmodus wird aktiviert in {$a}';
$string['clitypevalue'] = 'Wert eingeben';
$string['clitypevaluedefault'] = 'Wert eingeben oder Standardwert benutzen ({$a})';
$string['cliunknowoption'] = 'Nicht erkannte Optionen:
  {$a}
Hilfe wird über die Option --help angezeigt.';
$string['cliupgradecompletenomaintenanceupgrade'] = 'So löschen Sie die verbleibende Caches nach der Umstellung des Nutzertraffic auf neuen Code:

   php admin/cli/purge_caches.php --muc
   php admin/cli/purge_caches.php --js
   php admin/cli/purge_caches.php --filter
   php admin/cli/purge_caches.php --other

Sie sollten diese Bereinigungen isoliert mit Pausen zwischen den Befehlen durchführen, um Lastspitzen auf dem Webserver zu vermeiden.';
$string['cliupgradedefault'] = 'Neue Einstellung: {$a}';
$string['cliupgradedefaultheading'] = 'Neue Standardwerte setzen';
$string['cliupgradedefaultverbose'] = 'Neue Einstellung: {$a->name}, Standardwert: {$a->defaultsetting}';
$string['cliupgradefinished'] = 'Die Aktualisierung von {$a->oldversion} nach {$a->newversion} wurde erfolgreich beendet.';
$string['cliupgrademaintenancenotrequired'] = 'Diese Aktualisierung funktioniert NICHT im Wartungsmodus für Nutzer/innen.';
$string['cliupgrademaintenancerequired'] = 'Diese Aktualisierung funktioniert im Wartungsmodus für Nutzer/innen.';
$string['cliupgradenoneed'] = 'Für die installierte Version {$a} ist kein Upgrade notwendig.';
$string['cliupgradepending'] = 'Eine Aktualisierung ist steht an';
$string['cliupgradesetlock'] = 'Die Aktualisierung wurde nur für die CLI-Ausführung gesperrt.';
$string['cliupgradeunsetlock'] = 'Bestehende CLI-Ausführungssperre für die Aktualisierung wurde entfernt.';
$string['cliyesnoprompt'] = 'y (yes=ja) oder n (no=nein) eingeben';
$string['close'] = 'Schließen';
$string['cohort_customfield'] = 'Nutzerdefinierte Felder für globale Gruppen';
$string['commentsperpage'] = 'Angezeigte Kommentare pro Seite';
$string['commonactivitysettings'] = 'Grundeinstellungen';
$string['commonfiltersettings'] = 'Grundeinstellungen';
$string['commonsettings'] = 'Grundeinstellungen';
$string['componentinstalled'] = 'Komponente installiert';
$string['computedfromlogs'] = 'Logdaten seit {$a}';
$string['condifmodeditdefaults'] = 'Diese Einträge werden benutzt, wenn eine Aktivität oder ein Material neu angelegt wird.';
$string['confeditorhidebuttons'] = 'Wählen Sie die Optionen, die im HTML-Editor verborgen sein sollen.';
$string['configallcountrycodes'] = 'Diese Länderliste wird an unterschiedlichen Stellen benutzt, z.B. im Nutzerprofil.
Falls das Feld leer bleibt, wird die gesamte Liste aus der Datei countries.php im englischen Sprachpaket benutzt.
Dies ist die Liste gemäß ISO 3166-1.
Über eine kommagetrennte Liste können Sie die Auswahlmöglichkeiten einschränken, z.B. \'GB,FR,ES\'.
Falls Sie weitere Codes ergänzen möchten, so müssen Sie diese Codes in der Datei countries.php in Ihrem Sprachpaket hinzufügen.';
$string['configallowassign'] = 'Wählen Sie für jede Rolle in der linken Spalte aus, welche Rollen sie anderen zuweisen dürfen.';
$string['configallowattachments'] = 'Diese Option legt fest, ob E-Mail-Mitteilungen auch Anhänge haben können (z.B. Badges).';
$string['configallowcategorythemes'] = 'Wenn diese Option aktiviert ist, können Designs auf Kategorieebene gesetzt werden. Dies wirkt sich gleichzeitig auf alle Unterkategorien und Kurse aus, falls diese nicht wiederum eigene Designs verwenden. Achtung: Kategoriedesigns können zu einer Reduzierung der Arbeitsgeschwindigkeit führen!!';
$string['configallowcohortthemes'] = 'Wenn diese Option aktiviert ist, kann einer globalen Gruppe ein Design zugewiesen werden. Dies betrifft dann Nutzer/innen, die genau einer globalen Gruppe zugeordnet sind oder wenn alle globalen Gruppen das gleiche Design verwenden.';
$string['configallowcoursethemes'] = 'Wenn diese Option aktiviert ist, wird die Auswahl kursspezifischer Designs erlaubt. Ein Kursdesign hat Vorrang vor allen anderen Designfestlegungen (Website, Kursbereich, Nutzer/in, globale Gruppe oder URL-definierte Designs).';
$string['configallowedemaildomains'] = 'Liste der E-Mail-Domains, die bei ausgehenden E-Mails als Absender (From:) angezeigt werden dürfen. Der Standardwert \'leer\' setzt die Nicht-Antworten-Adresse als Absender für alle ausgehenden E-Mails.

Die Verwendung von Wildcards, wie z.B. *.mail.de, ist zulässig und lässt alle E-Mail-Adressen mit beliebigen Subdomains von mail.de, nicht jedoch mail.de selber zu. Dazu ist ein separater Eintrag erforderlich.';
$string['configallowemailaddresses'] = 'Um neue E-Mail-Adressen auf bestimmte E-Mail-Domains zu beschränken, listen Sie diese hier durch Leerzeichen getrennt auf. Alle anderen Domains werden abgelehnt. Um Subdomains zuzulassen, fügen Sie die E-Mail-Domain mit einem vorangestellten Punkt hinzu. Um eine Root-Domain zusammen mit ihren Subdomains zuzulassen, fügen Sie die Domain zweimal hinzu – einmal mit einem vorangestellten Punkt und einmal ohne.';
$string['configallowemojipicker'] = 'Mit der Emoji-Auswahl in den Atto-Werkzeugen können Nutzer/innen Emojis (z.B. Smilies oder Symbolbilder) auswählen und in Mitteilungen hinzufügen.';
$string['configallowemojipickerincompatible'] = 'Ihre aktuelle Datenbankkonfiguration unterstützt Emojis nicht richtig. Um die Emoji-Auswahl zu aktivieren, müssen Sie <a href="https://docs.moodle.org/en/MySQL_full_unicode_support">Ihre Datenbank für die vollständige Unicode-Unterstützung aktualisieren</a>.';
$string['configallowguestmymoodle'] = 'Diese Option erlaubt Gästen den Zugriff auf das Dashboard. Andernfalls werden Gäste auf die Startseite geleitet.';
$string['configallowobjectembed'] = 'Aus Sicherheitsgründen dürfen Teilnehmer/innen keine Multimedia-Objekte in HTML-Code einbetten und dabei die HTML-Tags &lt;embed&gt; und &lt;object&gt; verwenden. Multimedia-Objekte können jedoch weiterhin mit dem Multimedia-Filter angezeigt werden. Wenn Sie diese HTML-Tags zulassen möchten, aktivieren Sie diese Option.';
$string['configallowoverride'] = 'Die linksseitig genannten Rolleninhaber dürfen alle nach rechts markierten Rollen ändern';
$string['configallowoverride2'] = 'Wählen Sie für jede Rolle in der linken Spalte aus, für welche Rollen sie Überschreibungen vornehmen können.<br />Nutzer/innen müssen außerdem eines der Rechte moodle/role:override oder moodle/role:safeoverride haben.';
$string['configallowswitch'] = 'Wählen Sie für jede Rolle in der linken Spalte aus, zu welcher Rolle sie wechseln können.<br />Nutzer/innen müssen außerdem über das Recht moodle/role:switchroles verfügen.';
$string['configallowthemechangeonurl'] = 'Wenn diese Option aktiviert ist, kann das Design jeder Seite über den URL-Zusatz \'theme={themename}\' geändert werden, z.B. als  moodledomain.de/?theme=afterburner oder als moodledomain.de/course/view.php?id=2&theme=afterburner';
$string['configallowuserblockhiding'] = 'Möchten Sie das Minimieren von Blöcken erlauben? Die Blöcke werden dabei bis auf die Kopfzeile reduziert. Diese Option verwendet JavaScript und Cookies, um den Status jedes einzelnen Blocks zu speichern. Jede Person beeinflusst ausschließlich ihre eigene Nutzeransicht.';
$string['configallowusermailcharset'] = 'Diese Option legt fest, ob Nutzer/innen den E-Mail-Zeichensatz in ihren persönlichen Einstellungen selber festlegen können.';
$string['configallowuserswitchrolestheycantassign'] = 'Im Regelfall besteht für das Recht zum Rollenwechsel die Notwendigkeit, dass jemand das Recht moodle/role:assign besitzt. Falls diese Einstellung aktiviert ist, entfällt diese Notwendigkeit. <br />Die verfügbaren Rollen, die im Dropdown-Menü "Rolle wechseln..." angezeigt werden, sind nur durch die Einstellungen in der Tabelle "Rollenzuweisungen erlauben" beschränkt. Es wird unbedingt empfohlen, dass diese Tabelle niemandem erlaubt, zu höheren Rollen mit mehr Rechten zu wechseln als ihm ursprünglich zugewiesen wurden.';
$string['configallowuserthemes'] = 'Die Einstellung erlaubt allen Nutzer/innen, ein eigenes Design auszuwählen. Damit wird das Design der Website überschrieben, aber keine kursspezifische Design-Vorgabe.';
$string['configallowview'] = 'Wählen Sie für jede Rolle in der linken Spalte aus, welche Rollen sie anzeigen, suchen und filtern können.';
$string['configallusersaresitestudents'] = 'Mit dieser Option legen Sie den Zugriff zu den Lernaktivitäten auf der Startseite fest.
Wenn Sie \'Ja\' auswählen, können alle Nutzer/innen der Website die Aktivitäten auf der Startseite ausführen. Wenn Sie \'Nein\' auswählen, können nur diejenigen, die in mindestens einem Kurs als Teilnehmer/innen eingetragen sind, die Aktivitäten auf der Startseite ausführen. Administrator/innen und speziell zugewiesene Trainer/innen dürfen die Aktivitäten auf der Startseite erstellen und bearbeiten.';
$string['configauthenticationplugins'] = 'Wählen Sie die Authentifizierungsverfahren aus, die Sie benutzen möchten, und ordnen Sie diese in eine Reihenfolge der Nutzung.</br>
<b>Hinweis:</b> Bei einer späteren Deaktivierung von Authentifizierungsverfahren kann es passieren, dass Nutzer/innen mit dem deaktivierten Verfahren keinen Zugang mehr erhalten. Prüfen Sie dies sorgfältig.</br>';
$string['configautolang'] = 'Die Standardsprache wird über die Browsereinstellungen abgeleitet. Wenn die Option deaktiviert ist, wird die Standardsprache für die Website verwendet.';
$string['configautolangusercreation'] = 'Wenn diese Option aktiviert ist und beim ersten Anmelden automatisch ein Nutzerkonto erstellt wird (z.B. bei LDAP- oder OAuth2-Authentifizierung), wird die Browsersprache als bevorzugte Sprache für ds Nutzerkonto festgelegt. Andernfalls wird die Standardsprache der Instanz als bevorzugte Sprache für das Nutzerkonto festgelegt.';
$string['configautologinguests'] = 'Sollen Personen automatisch als Gäste eingeloggt werden, wenn sie Kurse mit Gastzugang öffnen?';
$string['configbloglevel'] = 'Diese Einstellung erlaubt es, die Sichtbarkeit von Blogeinträgen für dieses Moodle zu beschränken. Beachten Sie, dass die Einstellung den Maximalrahmen beim Lesen festlegt, nicht aber den Blogtyp beim Schreiben ändert. Sie können das Blogsystem auch vollständig deaktivieren.';
$string['configcalendarcustomexport'] = 'Eigenen Datumsbereich beim Kalenderexport aktivieren';
$string['configcalendarexportsalt'] = 'Dieser Zufallstext (hash salt) wird benutzt, um die Sicherheit von Authentifikationstoken für den Kalenderexport zu erhöhen. Beachten Sie, dass alle aktuellen Token ungültig werden, wenn Sie diesen Text ändern.';
$string['configcookiesecure'] = 'Wenn Ihr Server über HTTPS-Verbindungen erreicht wird, ist es empfehlenswert die Funktion zum Übertragen sicherer Cookies zu aktivieren. Wenn die Funktion aktiviert st, müssen Sie sicherstellen, dass der Server nicht über HTTP-Verbindungen erreichbar ist bzw. eine Umleitung an https:// Adressen besteht und idealerweise HSTS-Header versendet werden. Falls die <em>wwwroot</em> Adresse nicht mit https:// beginnt wird die Einstellung automatisch wieder deaktiviert.';
$string['configcountry'] = 'Diese Option legt das Land fest, das als Vorgabe für neue Nutzerkonten eingetragen ist. Wenn Nutzer/innen ihr Land selber eintragen sollen, lassen Sie das Feld leer.';
$string['configcoursegraceperiodafter'] = 'Definition früherer Kurse als Kurse, die vor einer bestimmten Anzahl an Tagen beendet wurden.';
$string['configcoursegraceperiodbefore'] = 'Definition zukünftiger Kurse als Kurse, die in einer bestimmten Anzahl von Tagen beginnen werden.';
$string['configcourseoverviewfilesext'] = 'Liste von Dateitypen, die als Bilddatei für die Kursbeschreibung erlaubt sind (Komma getrennt)';
$string['configcourseoverviewfileslimit'] = 'Diese Option legt fest, wie viele Dateien maximal in einer Kursbeschreibung verwendet werden dürfen. Die erste hinzugefügte Bilddatei wird als Kursbild in der Kursübersicht auf den Dashboards angezeigt. Alle weiteren Bilddateien werden ausschließlich in der Kursliste angezeigt.';
$string['configcourserequestnotify'] = 'Anmeldename der Person, die bei einer Kursanfrage benachrichtigt werden soll';
$string['configcourserequestnotify2'] = 'Nutzer/innen, die benachrichtigt werden sollen, wenn ein Kurs angefordert wird. Es werden nur Nutzer/innen gelistet, die eine Kursanfrage annehmen dürfen.';
$string['configcoursesperpage'] = 'Geben Sie die Anzahl von Kursen an, die pro Seite in einer Kursliste gezeigt werden sollen.';
$string['configcourseswithsummarieslimit'] = 'Diese Option legt fest, wie viele Kurse mit Beschreibung in einer Kursübersicht maximal angezeigt werden. Bei einer größeren Kursanzahl wird eine andere Darstellung gewählt.';
$string['configcronclionly'] = 'Die Ausführung von Cron im Webbrowser könnte vertrauliche Informationen anzeigen. Sie sollten deswegen Cron ausschließlich über die Befehlszeile erlauben oder im Webbrowser zusätzlich ein Cron-Kennwort zu verlangen.';
$string['configcronremotepassword'] = 'Diese Option legt fest, dass das Script cron.php nicht im Webbrowser aufgerufen werden kann, ohne das Kennwort folgendermaßen an die URL anzuhängen: <pre>
https://www.beispiel.de/admin/cron.php?password=geheim
</pre>Falls das Feld leer ist, wird kein Kennwort benötigt.';
$string['configcurlcache'] = 'Speicherzeit für cURL Cache (in Sekunden)';
$string['configcustommenuitems'] = 'Das nutzerdefinierte Menü wird auf allen Seiten in der Kopfzeile angezeigt.
Geben Sie jeden Menüpunkt in einer neuen Zeile ein. Verwenden Sie folgendes Format: Menütext, Link-URL (optional, nicht für einen Hauptpunkt mit Unterpunkten), Tooltipp (optional), Sprachcode oder kommagetrennte Liste von Sprachcodes (optional, um die Zeile nur in der Sprache anzuzeigen), jeweils getrennt durch senkrechte Striche |.
Zeilen, die mit einem Bindestrich beginnen, erscheinen als Unterpunkte unter dem vorherigen Hauptpunkt. ### bildet eine Trennlinie. Zum Beispiel:
<pre>
Kurse
-Alle Kurse|/course/
-Kurssuche|/course/search.php
-###
-FAQ|https://example.org/faq
-Preguntas más frecuentes|https://example.org/pmf||es
Mobile App|https://example.org/app|Laden Sie unsere App herunter
</pre>';
$string['configcustomusermenuitems'] = 'Sie können die Menüpunkte des Nutzermenüs konfigurieren (mit Ausnahme des Logout, das automatisch hinzugefügt wird).

 Jede Menüzeile wird durch das Zeichen | getrennt und besteht aus 1.) einem Text im Format identifier,component" oder einfachem Text, 2.) einer URL.  Trennungen können durch Eingabe einer Linie bzw. einem oder mehreren #-Zeichen eingegeben werden.';
$string['configdbsessions'] = 'Bei der Aktivierung dieser Einstellung wird die Datenbank verwendet, um Informationen über aktuelle Sessions abzuspeichern. Das ist sinnvoll bei sehr großen Anwendungen oder Anwendungen, die über mehrere Cluster von Servern verteilt arbeiten. Meist kann die Einstellung deaktiviert bleiben. Bei einer Einstellungsänderung werden alle aktuellen Nutzer/innen ausgeloggt (auch die Administrator/innen). Falls Sie MySQL benutzen, stellen Sie sicher, dass \'max_allowed_packet\' in der Datei my.cnf (oder my.ini) mindestens 4M ist.
Andere Treiber für Sessions können direkt in der config.php angepasst werden. Vorlagen finden Sie dazu in der config-dist.php-Datei. Diese Option wird nicht mehr angezeigt wenn Einstellungen in der config.php vorgenommen wurden.';
$string['configdebug'] = 'Wenn Sie diese Funktion einschalten, werden die Fehlermeldungen von PHP erweitert, so dass mehr Warnungen ausgegeben werden. Dies ist nur für Entwickler/innen nützlich.';
$string['configdebugdisplay'] = 'Wenn diese Option aktiviert ist, werden Fehlermeldungen direkt auf der HTML-Seite angezeigt. Auftretende Fehler stören dann aber XHTML, JavaScript, Cookies und HTTP-Header. Wenn die Option deaktiviert ist, werden alle Fehlermeldungen in die Logdaten des Webservers geschrieben. Die PHP-Variable error_log enthält den Pfad zur Logdatei.';
$string['configdebugpageinfo'] = 'Wenn diese Option aktiviert ist, werden Seiteninformationen in der Fußzeile angezeigt.';
$string['configdebugvalidators'] = 'Aktivieren Sie diese Option, um Links zu externen Validierungsservern in der Fußzeile anzuzeigen. Möglicherweise müssen Sie einen neuen Nutzer mit dem Anmeldenamen <em>w3cvalidator</em> erstellen und den Gastzugang freischalten. Diese Änderungen erlauben unauthorisierte Serverzugriffe und sollten nicht auf Produktivsystemen eingeschaltet werden!';
$string['configdefaulthomepage'] = 'Auf welche Seite sollen Nutzer/innen umgeleitet werden, nachdem sie sich auf der Website angemeldet haben? Die Einstellung legt auch den ersten Link in der Navigation für Nutzer/innen von Classic-basierten Themen fest.';
$string['configdefaultrequestcategory'] = 'Kurse, die von Nutzer/innen mit dem Recht, neue Kurse im Systemkontext anzufordern, werden in diese Kategorie eingeordnet, falls Nutzer/innen keinen anderen Kursbereich auswählen oder auswählen können.

Beantragte Kurse werden automatisch in diesem Kursbereich angelegt, falls kein anderer Kursbereich angegeben wurde.';
$string['configdefaultrequestedcategory'] = 'Voreingestellter Kursbereich, in dem beantragte Kurse angelegt werden.';
$string['configdefaultuserroleid'] = 'Angemeldete Nutzer/innen erhalten für die gesamte Website automatisch die hier angegebene Rolle zugewiesen, u.z. zusätzlich zu anderen Rollenzuweisungen. Dafür ist vorerst die Rolle "Authentifizierte/r Nutzer/in" eingestellt. Achten Sie darauf, dass Sie mit Ihrer Einstellung keine Konflikte mit anderen Rollen schaffen und dass die Nutzer/innen sinnvolle Dinge tun können, z.B. ihr Nutzerprofil verwalten, den eigenen Kalender verwalten oder Blogeinträge schreiben.';
$string['configdeleteincompleteusers'] = 'Nach dieser Zeit werden alle Nutzerkonten gelöscht, bei denen der Vorname, der Nachname oder die E-Mail-Adresse fehlt.';
$string['configdeleteunconfirmed'] = 'Bei bestimmten Authentifizierungsmethoden, wie etwa der E-Mail-basierten Selbstregistrierung, müssen Nutzer/innen ihr Konto innerhalb einer bestimmten Zeit bestätigen. Nach dieser Zeit werden alle alten unbestätigten Konten gelöscht.';
$string['configdenyemailaddresses'] = 'Um E-Mail-Adressen bestimmter Domains zu sperren, tragen Sie die Domainnamen hier in diese Liste ein. Alle anderen Domains werden akzeptiert. Um Subdomains zu sperren, wird der Domainname mit einem führenden Punkt (.) angegeben. <strong>hotmail.de yahoo.co.uk .live.com</strong>.';
$string['configdisableuserimages'] = 'Nutzer/innen verbieten, ihre Profilbilder ändern zu können.';
$string['configdisplayloginfailures'] = 'Erfolglose Anmeldeversuche anzeigen';
$string['configdndallowtextandlinks'] = 'Mit dieser Option kann das Einfügen von Texten und Links per Drag&drop auf eine Kursseite aktiviert werden. Beachten Sie, dass das Einfügen von Text per Drag&drop im Firefox oder zwischen verschiedenen Browsern unzuverlässig ist und dazu führen kann, dass keine oder beschädigte Daten hochgeladen werden.';
$string['configdoclang'] = 'Diese Spracheinstellung wird in den Links zu Dokumentationsseiten verwendet.';
$string['configdocroot'] = 'Pfad zu MoodleDocs. Über den Link \'MoodleDocs für diese Seite\' im Fußbereich wird eine kontextabhängige Dokumentation zu jeder Seite angeboten. Wenn das Feld leer ist, wird der Link nicht angezeigt.';
$string['configdoctonewwindow'] = 'Wenn diese Option aktiviert ist, werden die Links zur Moodle-Dokumentation in einem neuen Fenster angezeigt';
$string['configduration_high'] = 'Dieser Wert ist zu groß. Der maximale Wert ist {$a}.';
$string['configduration_low'] = 'Dieser Wert ist zu klein. Der minimale Wert ist {$a}.';
$string['configeditordictionary'] = 'Dieser Wert wird verwendet, wenn aspell kein Wörterbuch für die nutzergewählte Sprache hat.';
$string['configeditorfontlist'] = 'Zeichensätze auswählen, die im Editormenü erscheinen sollen';
$string['configemailchangeconfirmation'] = 'Wenn Nutzer/innen in ihrem Profil die E-Mail-Adresse ändern, dann ist eine E-Mail-Bestätigung notwendig';
$string['configemaildkimselector'] = 'Der DKIM-Selektor ist beliebig und Ihre DNS-Records müssen damit übereinstimmen.';
$string['configemailfromvia'] = 'Via-Info in den Absender ausgehender E-Mails einfügen. Der Empfänger wird damit informiert, von welcher Website die E-Mail gesendet wurde. Dies soll helfen, eine versehentliche Antwort an die Nicht-Antworten-Adresse zu verhindern.';
$string['configemailheaders'] = 'Raw E-Mail-Header, die zu allen ausgehenden E-Mails hinzugefügt werden.';
$string['configemailsubjectprefix'] = 'Prefix für den Betreff aller versendeten E-Mails';
$string['configenableanalytics'] = 'Analytics-Modelle, z.B. "Teilnehmer/innen, bei denen das Risiko eines Schulabbruchs besteht" oder "Bevorstehende Aktivitäten", können Vorhersagen erstellen, Erkenntnisbenachrichtigungen senden und weitere Aktionen anbieten, z.B. Nutzermitteilungen versenden.';
$string['configenableblogs'] = 'Diese Option aktiviert für alle Nutzer/innen einen eigenen Blog.';
$string['configenablecalendarexport'] = 'Exportieren oder Abonnieren von Kalendern erlauben';
$string['configenablecomments'] = 'Kommentare aktivieren';
$string['configenablecourserequests'] = 'Wenn diese Option aktiviert ist, können Nutzer/innen mit dem Recht (moodle/course:request) neue Kurse anfordern. Diese Funktion ist für keine der Standardrollen zulässig und kann im System- oder Kategoriekontext angewendet werden.';
$string['configenablemobilewebservice'] = 'Für die Moodle-App sind mobile Webdienste erforderlich. Wenn Ihre Website HTTPS verwendet, sind mobile Webdienste standardmäßig aktiviert. Weitere Infos finden Sie unter {$a}.';
$string['configenablerssfeeds'] = 'Diese Option aktiviert RSS Feeds für die gesamte Website. Zusätzlich ist erforderlich, die RSS Feeds in den einzelnen Modulen zu aktivieren. Öffnen Sie dazu in der Administration die Moduleinstellungen.';
$string['configenablerssfeedsdisabled'] = 'Diese Option ist nicht verfügbar, weil RSS Feeds für alle Seiten deaktiviert sind. Um diese zu aktivieren, öffnen Sie die Variableneinstellung in der Administration.';
$string['configenablerssfeedsdisabled2'] = 'RSS Feeds sind aktuell für die Website deaktiviert. Sie können über \'Website-Administration > Zusatzoptionen\' aktiviert werden.';
$string['configenablestats'] = 'Wenn diese Option aktiviert ist, werden per Cron die Logdaten analysiert und Statistiken erstellt. Je nach Serverlast könnte der Vorgang einige Zeit dauern. Die Funktion erstellt Datenlisten und Graphen für Kurse und die gesamte Website.';
$string['configenabletrusttext'] = 'Standardmäßig bereinigt Moodle alle Texte, die von Nutzer/innen eingegeben werden. Dabei werden fehlerhafte Skripte oder Medien entfernt, die ein Sicherheitsrisiko darstellen könnten. Das Trusted-Content-System bietet Nutzer/innen, denen Sie besonders vertrauen, erweiterte Inhalte auch ohne Filterung in den Beiträgen zu verwenden. Um dieses System zu aktivieren, müssen Sie zuerst diese Einstellung aktivieren und anschließend einer bestimmten Rolle das Trusted-Content-Recht erlauben. Texte, die von den betreffenden Nutzer/innen geschrieben oder hochgeladen werden, sind als vertrauenswürdig markiert und werden vor der Anzeige nicht bereinigt.';
$string['configenablewebservices'] = 'Webservices können anderen Systemen wie der Moodle-App erlauben, sich in der Website anzumelden und Aktionen auszuführen. Aus Sicherheitsgründen sollte die Einstellung deaktiviert werden, wenn Sie keine solche App, kein externes Tool oder keinen externen Dienst verwenden.';
$string['configenablewsdocumentation'] = 'Aktiviert die automatische Erstellung einer Dokumentation zu den Webservices. Nutzer/innen können auf ihre eigene Dokumentation für die Sicherheitsschlüssel über \'{$a}\' zugreifen. Es wird ausschließlich die Dokumentation für die aktivierten Protokolle angezeigt.';
$string['configerrorlevel'] = 'Wählen Sie die Menge der PHP-Warnungen, die angezeigt werden sollen. \'Normal\' ist meist eine gute Wahl.';
$string['configexportlookahead'] = 'Zahl der Tage in der Zukunft deren Termine exportiert werden sollen.';
$string['configexportlookback'] = 'Zahl der Tage in der Vergangenheit deren Termine exportiert werden sollen.';
$string['configextendedusernamechars'] = 'Wenn diese Option aktiviert ist, sind beliebige Zeichen (keine Großbuchstaben) in den Anmeldenamen zulässig. Andernfalls sind nur alphanumerische Zeichen erlaubt, außerdem Unterstrich (_), Bindestrich (-), Punkt (.) und das at-Symbol (@).';
$string['configextramemorylimit'] = 'Einige Skripte wie Suche, Sicherung, Wiederherstellung oder Cron erfordern mehr Arbeitsspeicher. Tragen Sie höhere Werte für große Websites ein.';
$string['configfilterall'] = 'Filter über alle Begriffe (inkl. aller Überschriften, Titel, Navigation, usw.). Im Zusammenhang mit dem Filter "Mehrsprachiger Inhalt" könnte eine Aktivierung nützlich sein, aber den Server stark belasten und zur Reduzierung der Arbeitsgeschwindigkeit führen.';
$string['configfiltermatchoneperpage'] = 'Der Filter für die automatische Verlinkung soll nur das erste Vorkommen eines Begriffes auf einer Seite verlinken. Wiederholt auf einer Seite auftretende Begriffe werden nur einmal verlinkt.';
$string['configfiltermatchonepertext'] = 'Automatische Verknüpfungsfilter generieren einen Link für die erste übereinstimmende Textinstanz, die in jedem Textelement auf der Seite gefunden wird. Weitere Vorkommen werden ignoriert. Diese Einstellung hat keine Auswirkung, wenn "Einmal pro Seite filtern" aktiviert ist.';
$string['configfilternavigationwithsystemcontext'] = 'Die normale Filterung ist an den Kontext gebunden, in dem sie verwendet wird (z.B. Kurskontext). Für die Website-Navigation kann aber das explizite Filtern aller Elemente mit Website-Kontext zu Leistungsverbesserungen führen, wenn die Filterung "Inhalt und Überschriften" verwendet wird.';
$string['configfilteruploadedfiles'] = 'Beim Aktivieren dieser Option werden alle hochgeladenen HTML- und Textdateien über den Filter bearbeitet, bevor sie angezeigt werden.';
$string['configforcelogin'] = 'Normalerweise können Startseite und Kursübersicht (nicht jedoch die Kurse) angezeigt werden, ohne dass man angemeldet ist. Aktivieren Sie diese Option, wenn eine Anmeldung zwingend sein soll, um irgendetwas auf der Website sehen zu können.';
$string['configforceloginforprofiles'] = 'Diese Option legt fest, dass Nutzerprofile ausschließlich für angemeldete Personen sichtbar sind, nicht für Gäste oder Suchmaschinen. Wenn Sie die Option ausschalten, sind die Nutzerprofile und deren Inhalte weltweit abrufbar und könnten zur Veröffentlichung von anstößigen Inhalten oder Werbung (Spam) missbraucht werden.';
$string['configfrontpage'] = 'Die ausgewählten Elemente werden auf der Startseite angezeigt.';
$string['configfrontpagecourselimit'] = 'Max. Anzahl von Kursen';
$string['configfrontpagecourselimithelp'] = 'Maximale Anzahl von Kursen, die in der Kursliste auf der Startseite gezeigt werden.';
$string['configfrontpageloggedin'] = 'Die ausgewählten Elemente werden auf der Startseite angezeigt, wenn Nutzer/innen angemeldet sind.';
$string['configfullnamedisplay'] = 'Diese Option legt fest, wie Namen vollständig angezeigt werden sollen. Der Standardwert \'language\' verwendet den Eintrag \'fullnamedisplay\' aus dem jeweiligen Sprachpaket. Manche Sprachen haben unterschiedliche Regeln.

Für die meisten einsprachigen Websites ist die Einstellung \'firstname lastname\' am besten geeignet, aber Sie könnten auch den Vor- oder den Nachnamen ausblenden. Mögliche Platzhalter sind: firstname, lastname, firstnamephonetic, lastnamephonetic, middlename, alternatename.';
$string['configgeoipfile'] = 'Pfad zur binären Datei GeoIP-City. Diese Datei ist kein Bestandteil von Moodle und muss separat von <a href="https://www.maxmind.com/">MaxMind</a> bezogen werden. Die Ortsdatenbank GeoIP-City gibt es als kommerzielle oder als freie Version. Sie müssen sich registrieren, um die City-Datenbankdatei herunterzuladen, und zwar unter <a href="https://dev.maxmind.com/geoip/geoip2/geolite2/" >https://dev.maxmind.com/geoip/geoip2/geolite2/</a>. Sobald Sie sich registriert und die Datei heruntergeladen haben, speichern Sie sie in das Verzeichnis "{$a}" auf Ihrem Server.';
$string['configgetremoteaddrconf'] = 'Wenn Ihr Server hinter einem Reverse Proxy steht, können sie mit diesen Einträgen festlegen, welche HTTP-Header vertraut wird, dass sie die Remote-IP Adresse enthalten. Die Header werden in der angegebenen Reihenfolge ausgelesen. Die erste verfügbare wird verwandt.';
$string['configgradebookroles'] = 'Diese Einstellung erlaubt Ihnen die Kontrolle, wer in den Bewertungen erscheint. Teilnehmer/innen müssen zuerst eine der Rollen in einem Kurs einnehmen, bevor sie in den Bewertungen dieses Kurses angezeigt werden.';
$string['configgradeexport'] = 'Wählen Sie ein bevorzugtes Exportformat für die Bewertungen aus. Das gewählte Plugin wird dann das Feld "zuletzt exportiert" in jeder Bewertung setzen und benutzen. Dies wird beispielsweise die exportierten Daten als "neu" oder "geändert" markieren. Wenn Sie nicht sicher sind, wählen Sie nichts aus.';
$string['configgradeexportdefault'] = 'Wählen Sie das standardmäßige Format zum Exportieren von Bewertungen.';
$string['confighiddenuserfields'] = 'Markieren Sie die Felder, deren Inhalte vor anderen Nutzer/innen, nicht aber vor Trainer/innen und Administrator/innen verborgen werden sollen. Dies erhöht den Datenschutz. Mit gedrückter strg/cmd-Taste können Sie auch mehrere Felder auswählen.';
$string['configidnumber'] = 'Diese Option legt fest, ob (a) nicht nach einer ID-Nummer gefragt wird, (b) zwar nach einer ID-Nummer gefragt wird, aber das Feld leer bleiben kann oder (c) nach einer zwingenden Eingabe einer ID-Nummer gefragt wird. Eine eingegebene ID-Nummer wird im Nutzerprofil angezeigt.';
$string['configintro'] = 'Auf dieser Seite können Sie zahlreiche Variablen konfigurieren, die Einstellungen von Moodle auf dem Server beeinflussen. Überlegen Sie nicht zu lange - die Standard-Einstellungen funktionieren normalerweise sehr gut. Sie können jederzeit später alle Einstellungen ändern.';
$string['configintroadmin'] = 'Sie müssen eine/n Hauptadministrator/in einrichten, der die vollständige Kontrolle über die Website hat. Achten Sie darauf, unbedingt einen sicheren Anmeldenamen, ein sicheres Kennwort sowie eine gültige E-Mail-Adresse anzugeben. Weitere Administrator/innen können Sie später festlegen.';
$string['configintrosite'] = 'Diese Seite erlaubt es Ihnen, die Startseite und den Namen der Webseite festzulegen. Sie können die Einstellungen später jederzeit bearbeiten.';
$string['configiplookup'] = 'Wenn Sie auf eine IP-Adresse (z.B. 123.45.67.98) in den Logdaten klicken, dann sollten Sie auf einer Übersicht den Ort gezeigt bekommen, von wo aus der Zugriff erfolgte. Es existieren für diese Aufgabe unterschiedliche Module, aber jedes hat spezifische Vor- und Nachteile.';
$string['configkeeptagnamecase'] = 'Diese Option legt fest, dass die Schreibweise von Tags erhalten bleibt, so wie sie erstmalig eingegeben wurden.';
$string['configlang'] = 'Wählen Sie die Standardsprache für die gesamte Website. Nutzer/innen können ihre eigene Sprache über das Sprachmenü wählen oder in ihrem persönlichen Profil anpassen.';
$string['configlanglist'] = 'Wenn Sie das Feld leer lassen, werden alle installierten Sprachen im Sprachmenü angezeigt. Alternativ können Sie das Sprachmenü verkürzen, indem Sie eine durch Kommas getrennte Liste von Sprachcodes eingeben, z.B. de,en,es,fr,it. Zusätzlich können Sie die angezeigten Namen anpassen, indem Sie folgendes Format verwenden: Sprachcode|Sprachname, z.B. en_kids|English,de_kids|Deutsch.';
$string['configlangmenu'] = 'Diese Option legt fest, ob Sie das Sprachmenü auf der Startseite und auf der Anmeldeseiten anzeigen möchten. Dies schränkt die Möglichkeit nicht ein, dass alle Nutzer/innen ihre bevorzugte Sprache im Nutzerprofil einstellen können.';
$string['configlangstringcache'] = 'Alle Texte des Sprachpakets sind zur Leistungsoptimierung zwischengespeichert. Wenn Sie Texte lokal ändern, müssen Sie die Zwischenspeicherung deaktivieren, um die Änderungen sofort wirksam zu machen. Normalerweise sollte die Option aber aktiviert sein.';
$string['configlatinexcelexport'] = 'Wählen Sie die Kodierung für die Excel-Exporte.';
$string['configlocale'] = 'Wählen Sie eine Einstellung für \'locale\', die für die gesamte Website gelten soll - dies wird die Anzeige der deutschen Umlaute und jedes Datums beeinflussen. Die für die Einstellung notwendigen Dateien müssen auf Ihrem Server installiert sein. Für ein deutschsprachiges System wird z.B. de_DE.UTF-8 eingetragen. Normalerweise sollte das Feld leer bleiben können.';
$string['configlockrequestcategory'] = 'Beantragte Kurse werden nur im festgelegten Kursbereich angelegt. Dies ist eine Legacy-Einstellung. Es ist besser, die Einstellung nicht zu verwenden und stattdessen das Recht zuzuweisen, Kurse im entsprechenden Kontext des Kursbereichs anzufordern.';
$string['configloglifetime'] = 'Die Zeitdauer gibt an, für welchen Zeitraum die Logdaten von Nutzeraktivitäten gespeichert werden. Ältere Logdaten werden automatisch gelöscht. Speichern Sie die Logdaten nur so lange, wie sie unbedingt benötigt werden. Wenn Sie bei Ihrem Server Leistungseinbrüche feststellen, sollten Sie den Zeitraum reduzieren. Werte kleiner als 30 werden nicht empfohlen, weil dann die Statistiken nicht mehr richtig arbeiten können.';
$string['configlookahead'] = 'Tage in der Vorschau';
$string['configmailnewline'] = 'Zeichen für die Zeilenschaltung in E-Mails. Gemäß RFC 822bis ist CRLF notwendig. Leider wandeln einige E-Mail-Server automatisch LF in CRLF um, andere konvertieren CRLF falsch in CRCRLF und wieder andere weisen E-Mails mit reinem LF zurück (z.B. qmail). Probieren Sie unterschiedliche Einstellungen aus, falls Probleme mit dem E-Mail-Versand auftreten oder doppelte Zeilenschaltungen vorkommen.';
$string['configmaxbytes'] = 'Der Wert \'maxbytes\' legt die maximale Dateigröße zum Hochladen von Dateien fest, u.z. für die gesamte Website. Der einstellbare Wert ist limitiert durch die PHP-Einstellungen \'post_max_size\' und \'upload_max_filesize\' sowie die Apache-Einstellung \'LimitRequestBody\'. Der Wert \'maxbytes\' schränkt seinerseits alle auf dem Server zulässigen Dateigrößen auf Kurs- oder Modulebene ein.';
$string['configmaxconsecutiveidentchars'] = 'Kennwörter dürfen maximal diese Zahl aufeinanderfolgender gleicher Zeichen haben. Der Wert \'0\' deaktiviert die Prüfung.';
$string['configmaxeditingtime'] = 'Hiermit bestimmen Sie die Zeitdauer, in der Beiträge in Foren, Glossaren bearbeitet werden dürfen. Normalerweise sind 30 Minuten ein guter Wert.';
$string['configmaxevents'] = 'Ereignisse in der Vorausschau';
$string['configmaxusersperpage'] = 'Maximale Anzahl von Personen, die bei der Nutzerauswahl in Kursen, Gruppen oder Webservices angezeigt werden';
$string['configmessaging'] = 'Diese Option aktiviert das Mitteilungssystem systemweit für alle Nutzer/innen.';
$string['configmessagingallowemailoverride'] = 'Nutzer/innen erlauben, sich Systemnachrichten an andere E-Mail-Adressen senden zu lassen als im Profil angegeben.';
$string['configmessagingallusers'] = 'Wenn diese Option aktiviert ist, können Nutzer/innen bei der Suche alle registrierten Personen im System sehen. Wenn die Option deaktiviert ist, wird die Suche auf Personen aus den eigenen Kursen beschränkt. Jede Person kann selber in ihrem persönlichen Profil festlegen, ob sie Mitteilungen nur von eigenen Kontakten, von Teilnehmer/innen eigener Kurse oder von der gesamten Website empfangen möchte.';
$string['configmessagingdefaultpressenter'] = 'Ob Senden mit Eingabetaste als Voreinstellung in den Nutzereinstellungen gesetzt ist.';
$string['configmessagingdeleteallnotificationsdelay'] = 'Ungelesene und gelesene Systemnachrichten können gelöscht werden, um Platz zu sparen. Diese Einstellung legt die Zeitdauer fest, nach der eine Systemnachricht gelöscht wird. Die Frist wird auf dem Erstellungsdatum der Systemnachricht berechnet.';
$string['configmessagingdeletereadnotificationsdelay'] = 'Gelesene Systemnachrichten können gelöscht werden, um Platz zu sparen. Diese Einstellung legt die Zeitdauer fest, nach der eine Systemnachricht gelöscht wird.';
$string['configminpassworddigits'] = 'Kennwörter müssen mindestens die angegebene Zahl von Ziffern enthalten.';
$string['configminpasswordlength'] = 'Kennwörter müssen mindestens die angegebene Zahl von Zeichen enthalten.';
$string['configminpasswordlower'] = 'Kennwörter müssen mindestens die angegebene Zahl von Kleinbuchstaben enthalten.';
$string['configminpasswordnonalphanum'] = 'Kennwörter müssen mindestens die angegebene Zahl von Sonderzeichen enthalten.';
$string['configminpasswordupper'] = 'Kennwörter müssen mindestens die angegebene Zahl von Großbuchstaben enthalten.';
$string['configmypagelocked'] = 'Diese Option schützt die eingerichtete Seite vor Änderungen durch Nicht-Administrator/innen';
$string['confignavcourselimit'] = 'Die Zahl legt die Anzahl der Kurse fest, die Nutzer/innen maximal in der Navigation angezeigt werden.';
$string['confignavshowallcourses'] = 'Diese Einstellung legt fest, dass Nutzer/innen zusätzlich zu "Meine Kurse" (Liste von Kursen, in denen sie eingeschrieben sind) auch Kurse (Liste aller Kurse) in der Navigation sehen.';
$string['confignavshowcategories'] = 'Kursbereiche in Navigationsleiste und Navigationsblöcken anzeigen. Diese Einstellung wirkt sich nicht auf die Anzeige der eingeschriebenen Kurse im Bereich \'Meine Kurse\' aus, wo die Kurse immer ohne Kursbereiche gelistet werden.';
$string['confignoreplyaddress'] = 'E-Mails werden manchmal auf Veranlassung einer Person gesendet, z.B. bei Forumsbeiträgen. Tragen Sie in dieses Feld eine E-Mail-Adresse ein, die immer dann eingesetzt wird, wenn niemand die persönliche E-Mail-Adresse sehen oder für Antworten benutzen soll. Diese Einstellung wird auch als (nur für die Übertragung relevanter und für den Empfänger im Normalfall unsichtbarer) "Envelope Sender" der E-Mail genutzt.';
$string['confignotifyloginfailures'] = 'Systemnachrichten zu Login-Fehlern können an ausgewählte Nutzer/innen gesendet werden. Dazu muss ein interner Logstore (z.B. Standard-Logstore) aktiviert sein.';
$string['confignotifyloginthreshold'] = 'Nach wie vielen erfolglosen Anmeldeversuchen hintereinander für ein Nutzerkonto oder über eine IP-Adresse soll eine Systemnachricht gesendet werden?';
$string['confignotloggedinroleid'] = 'Nicht auf der Website eingeloggte Nutzer/innen werden behandelt, als ob sie diese Rolle hätten. Die Rolle \'Gast\' ist in der Regel brauchbar. Sie können aber auch neue Rollen erstellen, die mehr oder weniger Einschränkungen vornehmen. Viele Aktivitäten, z.B. Beiträge schreiben oder Tests durchführen, erfordern aber immer eine richtige Anmeldung.';
$string['configopentowebcrawlers'] = 'Wenn diese Option aktiviert ist, können Suchmaschinen Ihre Website als Gast besuchen. Außerdem wird jede Person automatisch als Gast eingeloggt, die über eine Suchmaschine auf Ihre Website kommt. Natürlich kann nur auf Kurse zugegriffen werden, die einen Gastzugang (ohne Kennwort) zulassen.';
$string['configoverride'] = 'In der config.php festgelegt';
$string['configpasswordpolicy'] = 'Wenn diese Option aktiviert ist, werden Nutzerkennwörter anhand der in den folgenden Einstellungen angegebenen Kennwortrichtlinie überprüft. Das Aktivieren der Kennwortrichtlinie wirkt sich erst dann auf vorhandene Nutzer/innen aus, wenn diese ihr Kennwort ändern möchten, ändern müssen oder die Einstellung "Kennwort bei Anmeldung prüfen" aktiviert ist.';
$string['configpasswordpolicycheckonlogin'] = 'Wenn diese Option aktiviert ist, werden Nutzerkennwörter bei jeder Anmeldung anhand der Kennwortrichtlinie überprüft. Wenn die Überprüfung fehlschlägt, müssen Nutzer/innen ihr Kennwort ändern, bevor sie fortfahren können.
Es ist hilfreich, diese Einstellung nach dem Aktualisieren der Kennwortrichtlinie zu aktivieren.';
$string['configpasswordresettime'] = 'Diese Option legt die maximale Zeitdauer fest, um die Anforderung einer Kennwortrücksetzung zu bestätigen, bevor diese verfällt. Normalerweise sind 30 Minuten ausreichend.';
$string['configpathtodu'] = 'Pfad für du, meistens /usr/bin/du. Mit dieser Option werden Seiten mit Verzeichnissen und vielen Dateien schneller angezeigt.';
$string['configpathtophp'] = 'Pfad für PHP CLI. Meistens /usr/bin/php. Wenn Sie dies eingeben können Cron-Skripte über die Admin-Oberfläche ausgeführt werden.';
$string['configperfdebug'] = 'Wenn die Option aktiviert ist, werden Performance-Infos in der Fußzeile des Standarddesigns angezeigt.';
$string['configprofileroles'] = 'Rollen, die in Nutzerprofilen und auf der Teilnehmer/innenseiten sichtbar sind';
$string['configprofilesforenrolledusersonly'] = 'Um eine unerwünschte Nutzung durch Spammer zu vermeiden, sind die Profilbeschreibungen von Nutzer/innen ohne vorhandene Kurseinschreibung gesperrt. Neue Nutzer/innen müssen sich in mindestens einem Kurs eingeschrieben haben, um eine Profilbeschreibung hinzufügen zu können.';
$string['configprotectusernames'] = 'Diese Option legt fest, dass keine Hinweise für vergessene Anmeldenamen und Kennwörter angezeigt werden.';
$string['configproxybypass'] = 'Liste von (teilweisen) Hostnamen oder IP-Adressen, die den Proxy umgehen sollen. Trennen Sie die einzelnen Einträge durch Kommas, ohne Leerzeichen. Beispiel: 192.168.0.0/16,*.mydomain.com.';
$string['configproxyfixunsafe_help'] = 'Dies versucht, interne Aufrufe zu beheben, die nicht über den Proxy gehen, indem der MoodleBot-Nutzeragent hinzugefügt und der Proxy verwendet wird.';
$string['configproxyhost'] = 'Wenn dieser <b>Server</b> für den Internetzugriff einen Proxy (z.B. eine Firewall) benötigt, tragen Sie hier den Hostnamen und den Port des Proxys ein. Andernfalls lassen Sie das Feld leer.';
$string['configproxylogunsafe_help'] = 'Dies versucht, interne Aufrufe zu protokollieren, die nicht über den Proxy gehen.';
$string['configproxypassword'] = 'Für den Internetzugang ist eventuell ein Kennwort nötig. Lassen Sie das Feld leer, falls der Proxy kein Kennwort verlangt. Die PHP-Extension cURL ist notwendig!';
$string['configproxyport'] = 'Falls dieser Server einen Proxy benutzt, geben Sie hier bitte den Proxy-Port an.';
$string['configproxytype'] = 'Typ des Web-Proxys. Für die Unterstützung von SOCKS5 ist PHP5 und die PHP-Extension cURL notwendig!';
$string['configproxyuser'] = 'Für den Internet-Zugriff muss eventuell ein Anmeldename eingegeben werden. Lassen Sie das Feld leer, falls der Proxy keinen Anmeldenamen verlangt. Die PHP-Extension cURL ist notwendig!';
$string['configrecaptchaprivatekey'] = 'Dieser Code (Secret Key) dient der Kommunikation zwischen Moodle und dem Recaptcha-Server.  Sie erhalten den Code unter <a target="_blank" href="https://www.google.com/recaptcha">Google reCAPTCHA</a>.';
$string['configrecaptchapublickey'] = 'Die Zeichenfolge (Website-Schlüssel) wird verwendet, um das reCAPTCHA-Element im Anmeldeformular und im Website-Support-Formular anzuzeigen. reCAPTCHA-Schlüssel können von <a target="_blank" href="https://www.google.com/recaptcha">Google reCAPTCHA</a> bezogen werden.';
$string['configrequestedstudentname'] = 'Begriff für Teilnehmer/in in beantragten Kursen';
$string['configrequestedstudentsname'] = 'Begriff für Teilnehmer/innen in beantragten Kursen';
$string['configrequestedteachername'] = 'Begriff für Trainer/in in beantragten Kursen';
$string['configrequestedteachersname'] = 'Begriff für Trainer/innen in beantragten Kursen';
$string['configreverseproxyignore'] = 'Wenn sich Ihr Server hinter mehreren Reverse-Proxys befindet, die an den X-Forwarded-For-Header angehängt werden, müssen Sie eine kommagetrennte Liste von IP-Adressen oder Subnetzen der zu ignorierenden Reverse-Proxys angeben. Nur so können Sie die richtige IP-Adresse von Nutzer/innen feststellen.';
$string['configsectioninterface'] = 'Gestaltung';
$string['configsectionmail'] = 'E-Mail';
$string['configsectionmaintenance'] = 'Wartung';
$string['configsectionmisc'] = 'Verschiedenes';
$string['configsectionoperatingsystem'] = 'Betriebssystem';
$string['configsectionpermissions'] = 'Rechte';
$string['configsectionrequestedcourse'] = 'Kursanträge';
$string['configsectionsecurity'] = 'Sicherheit';
$string['configsectionstats'] = 'Statistiken';
$string['configsectionuser'] = 'Nutzer/in
';
$string['configsecureforms'] = 'Moodle kann eine erhöhte Sicherheitsstufe für Daten aus Web-Formularen nutzen. Sofern dies eingeschaltet ist, wird die Variable HTTP_REFERER gegen die Adresse des aktuellen Formulars geprüft.
In einigen wenigen Fällen kann das Probleme verursachen, wenn der Nutzer eine Firewall benutzt (z.B. Zonealarm), die so konfiguriert ist, dass der HTTP_REFERER nicht mitgesendet wird.
Das Ergebnis ist, dass Sie bei einem Formular nicht weiterkommen.
Sofern Nutzer/innen z.B. Probleme mit der Zugangsseite haben, sollten Sie diese Einstellung deaktivieren - allerdings ist Ihre Seite so offener für Brute-Force-Attacken. Im Zweifelsfall belassen Sie es bei \'Ja\'.';
$string['configservicespage'] = 'Geben Sie die URL einer Dienste- und Support-Seite ein oder lassen Sie sie leer, um auf Moodle-Services auf moodle.com zu verlinken. Dieser Link wird ausschließlich für Administrator/innen angezeigt.';
$string['configsessioncookie'] = 'Diese Einstellung beeinflusst die Namen der Cookies, die für Moodle-Zugriffe benutzt werden. Dieser Eintrag ist sinnvoll, um die Überlagerung der Cookies zu verhindern, wenn mehrere Moodle-Systeme auf der gleichen Website installiert sind.';
$string['configsessioncookiedomain'] = 'Diese Einstellung erlaubt es Ihnen, die Domain zu verändern, von der Moodle-Cookies benutzbar sind. Dies ist nützlich für Moodle-Anpassungen (z.B. Plugins zur Authentifikation oder zum Einschreiben), die Informationen bezüglich der Moodle-Session mit Programmen auf einer anderen Subdomain teilen müssen.<br /><strong>ACHTUNG: Es wird dringend empfohlen, diese Einstellung leer zu lassen und nicht zu verändern - ein falscher Wert könnte dazu führen, dass alle Logins auf diese Website zurückgewiesen werden!! </strong>';
$string['configsessioncookiepath'] = 'Es könnte notwendig sein, ein Ziel für die Rücksendung von Moodle-Cookies anzugeben. Dafür können Sie hier ein Unterverzeichnis Ihrer Website definieren. Andernfalls sollte die Grundeinstellung \'/\' ausreichend sein.';
$string['configsessiontimeout'] = 'Wenn auf dieser Website angemeldete Personen lange Zeit inaktiv sind (z.B. keine Seiten laden), werden sie automatisch abgemeldet. Diese Variable legt die betreffende Zeitspanne fest.';
$string['configsessiontimeoutwarning'] = 'Wenn auf dieser Website angemeldete Personen lange Zeit inaktiv sind (z.B. keine Seiten laden), erhalten sie eine Warnung, dass ihre Sitzung bald endet. Diese Variable legt die Dauer dieser Zeitspanne fest.';
$string['configsessiontimeoutwarningcheck'] = 'Die Warnungzeit muss kürzer sein als die Zeitüberschreitung an Inaktivität.';
$string['configshowcommentscount'] = 'Kommentarzähler anzeigen, danach kostet es nur eine weitere Anfrage, um die Kommentarlinks zu zeigen';
$string['configshowicalsource'] = 'Quelleninformationen bei iCal-Terminen anzeigen';
$string['configshowsiteparticipantslist'] = 'Alle Teilnehmer/innen und Trainer/innen der Website werden in der Nutzergesamtliste geführt. Wer soll diese Liste sehen dürfen?';
$string['configsitedefaultlicense'] = 'Standardlizenz';
$string['configsitedefaultlicensehelp'] = 'Die Standardlizenz regelt die Veröffentlichung von Inhalte auf dieser Website';
$string['configsitemailcharset'] = 'Diese Option legt fest, ob alle E-Mails mit dem Standard-Zeichensatz versandt werden.';
$string['configsitemaxcategorydepth'] = 'Maximale Bereichstiefe';
$string['configsitemaxcategorydepthhelp'] = 'Diese Option legt die maximale Verschachtelungstiefe von Kursunterbereichen fest, die in der Kursliste angezeigt werden. Tiefere Kursunterbereiche können über Links aufgeklappt werden.';
$string['configslasharguments'] = '\'Slash-Parameter\' (unter Benutzung von <em>PATH_INFO</em>) sind notwendig für Lernpakete (SCORM) und für alle Ressourcen, die aus mehreren Dateien bestehen. Wenn Ihr Browser keine \'Slash-Parameter\' unterstützt und Sie das auch nicht ändern können, deaktivieren Sie die Option, wobei dann einige Dinge nicht funktionieren.
<br />Hinweis: In künftigen Moodle-Versionen wird die Verwendung von \'Slash-Parametern\' verpflichtend sein.';
$string['configsmtpauthtype'] = 'Diese Option legt die Art der Authentifizierung für den SMTP-Server fest.';
$string['configsmtphosts'] = '<p>Tragen Sie einen oder mehrere lokale SMTP-Server ein, die für den E-Mail-Versand benutzt werden sollen (z.B. \'mail.server.de\' oder \'mail1.server.de;mail2.server.de\').</p>
<p>Falls Ihr Server einen Nicht-Standard-Port benutzt (also nicht Port 25), verwenden Sie zur Eingabe die Syntax [server]:[port] (z.B. mail.server.de:587).  Für sichere Verbindungen, normalerweise über Port 465 (SSL) oder 587 (TLS), geben Sie auch das Sicherheitsprotokoll an.</p
<p>Wenn das Feld frei bleibt, wird für den E-Mail-Versand die Standardmethode von PHP verwendet. Dies führt sehr häufig zur Nichtzustellung von E-Mails, da diese nicht autorisiert sind.</p>';
$string['configsmtpmaxbulk'] = 'Maximale Anzahl von Nachrichten pro SMTP-Session. Die Gruppierung von Nachrichten sollte den Versand von E-Mails beschleunigen. Mit Werten kleiner als 2 wird für jede E-Mail eine neue SMTP-Session gestartet.';
$string['configsmtpoauthservice'] = 'Wählen Sie den OAuth2 -Dienst aus, der so konfiguriert ist, dass sie mit dem SMTP-Server sprechen. Wenn der Dienst noch nicht vorhanden ist, müssen Sie ihn erstellen. Beachten Sie bitte: Diese Einstellung wird nur ausgeführt, wenn der SMTP-Authorisierungstyp auf XOAuth2 gesetzt ist.';
$string['configsmtpsecure'] = 'Wenn der SMTP-Server eine sichere Verbindung verlangt, geben Sie hier das richtige Sicherheitsprotokoll an.';
$string['configsmtpuser'] = 'Wenn Sie einen SMTP-Server angegeben haben und der Server Zugangsdaten erfordert, dann tragen Sie hier Anmeldenamen und Kennwort ein.';
$string['configstartwday'] = 'Beginn der Woche';
$string['configstatsfirstrun'] = 'Die Einstellung legt den Zeitraum fest, um den die auszuwertenden Logdaten zurückliegen dürfen. Wenn Sie sehr viele Aktivitäten in den Kursen haben oder sich einen Server mit anderen Anwendungen teilen, sollten Sie keinen zu langen Zeitraum wählen. Die Auswertung erfordert eine hohe Serverleistung. (Hinweis: für diese Einstellung gilt: 1 Monat = 28 Tage. In der grafischen Auswertung und den Berichten ist 1 Monat = 1 Kalendermonat.)';
$string['configstatsmaxruntime'] = 'Die Berechnung der Statistiken kann sehr viel Rechenleistung erfordern. Verwenden Sie eine Kombination aus diesem Feld und dem nächsten, um festzulegen zu welchem Zeitpunkt und für welchen Zeitraum die Berechnung erfolgen soll.';
$string['configstatsmaxruntime2'] = 'Die Berechnung der Statistiken kann sehr aufwendig sein. Besonders durch die maximale Dauer für Prozesse wird hier eine Begrenzung gesetzt. Mit einem CronJob können daher höchstens 31 Tage der Statistik berechnet werden.';
$string['configstatsmaxruntime3'] = 'Die Berechnung der Statistiken kann auf dem Server sehr viel Last erzeugen. Daher können Sie hier festlegen wie viel Zeit täglich dafür höchstens eingesetzt werden soll. Weiter unten legen Sie fest für wie viel Tage innerhalb eines Cron-Job-Durchlaufs die Berechnung der Statistiken erfolgen soll.';
$string['configstatsruntimedays'] = 'Wenn Sie die Statistik-Funktion aktivieren werden für einen zurückliegenden Zeitraum statistische Berechnungen durchgeführt. Damit dadurch die Serverbelastung nicht zu hoch wird, können Sie hier festlegen, dass pro Cron-Job-Durchlauf nur für eine bestimmte Zahl von Tagen die Berechnung erfolgt. Ist die Statistik-Ermittlung auf dem aktuellen Stand erfolgt wird jeweils für einen Tag die Statistik ergänzt';
$string['configstatsruntimestart'] = 'Zu welchem Zeitpunkt soll die Berechnung der Statistiken begonnen werden? Bitte wählen Sie unterschiedliche Zeitpunkte, wenn auf einen physikalischen Server mehrere Moodle-Instanzen laufen.';
$string['configstatsuserthreshold'] = 'Kurse mit einer geringeren Zahl von Nutzer/innen als in diesem Wert angegeben, werden beim Erstellen von Kursstatistiken nicht berücksichtigt.';
$string['configstrictformsrequired'] = 'Wenn diese Option aktiviert ist, wird die alleinige Eingabe eines Leerzeichens oder Zeilenumbruchs in Pflichtfeldern von Formularen verhindert.';
$string['configstripalltitletags'] = 'Wenn diese Option deaktiviert ist, dürfen HTML-Tags in den Aktivitätsnamen verwendet werden, z.B. zur Formatierung.';
$string['configsupportavailability'] = 'Diese Option legt fest, wer über die Fußzeile Zugriff auf den Website-Support hat.';
$string['configsupportemail'] = 'Wenn SMTP auf dieser Site konfiguriert ist und keine Support-Seite eingerichtet ist, erhält diese E-Mail-Adresse Nachrichten, die über das Support-Formular gesendet werden. Wenn das Senden nicht funktioniert, wird diese E-Mail-Adresse angemeldeten Nutzer/innen angezeigt.';
$string['configsupportname'] = 'Der Name der Person oder anderen Entität, die über das Supportformular oder die Supportseite Unterstützung leistet.';
$string['configsupportpage'] = 'Geben Sie die URL einer Support-Seite ein oder lassen Sie sie leer, um auf ein Kontaktformular zu verlinken. Dieser Link wird in der Fußzeile gezeigt.';
$string['configtempdatafoldercleanup'] = 'Temporäre Dateien werden aus dem Bereich moodledata gelöscht, wenn sie älter als die ausgewählte Zeit sind.';
$string['configthemedesignermode'] = 'Aus Performancegründen werden Bilder und CSS-Dateien eines Designs im Browser und auf dem Server zwischengespeichert (gecacht). Schalten Sie diese Option an, wenn Sie neue Designs entwickeln oder optimieren, damit die Daten nicht in den Cache geschrieben werden.  Achtung: Die Aktivierung des Design-Entwickler-Modus wirkt sich negativ auf die Serverleistung aus! Der Theme-Cache kann auch manuell über die Theme-Auswahlseite gelöscht werden.';
$string['configthemelist'] = 'Wenn das Feld leer ist, können alle  installierten Designs ausgewählt werden. Die Einträge im Designmenü können über eine Liste festgelegt werden (Komma getrennt, z.B. formal_white,leatherbound,standard)';
$string['configtimezone'] = 'Diese Option legt eine Zeitzone für die Zeitanzeige fest. Cronjobs und andere Servereinstellungen werden in dieser Zeitzone festgelegt. Sie sollten die Einstellung ändern, wenn \'Ungültige Zeitzone\' angezeigt wird.';
$string['configuseblogassociations'] = 'Soll es für Nutzer/innen möglich sein, ihre Blogeinträge über die Zuordnung an Kurse und Kursmodule zu organisieren?';
$string['configusesitenameforsitepages'] = 'Wenn diese Option aktiviert ist, wird in der Navigation die Kurzbezeichnung der Website anstelle von \'Website\' gezeigt.';
$string['configusetags'] = 'Diese Option aktiviert Tags für die gesamte Website. Mit Tags lassen sich Dinge markieren, verschlagworten und kategorisieren.';
$string['configvariables'] = 'Variablen konfigurieren';
$string['configverifychangedemail'] = 'Diese Option aktiviert die Prüfung bei der Änderung von E-Mail-Adressen, ob sie von vorgegebenen oder zurückzuweisenden E-Mail- Domains stammen. Ist die Funktion deaktiviert, erfolgt die Prüfung nur bei der Neuanlage von Nutzerkonten.';
$string['configvisiblecourses'] = 'Kurse werden in verborgenen Kursbereichen normal angezeigt.';
$string['configwarning'] = 'Vorsicht bei der Veränderung dieser Einstellungen! <br />Ungeeignete Werte könnten Probleme verursachen.';
$string['configyuicomboloading'] = 'Diese Option aktiviert eine Ladeoptimierung für die YUI Libraries. Zur Performance-Steigerung sollte die Einstellung auf Produktivsystemen aktiviert sein.';
$string['confirmation'] = 'Bestätigung';
$string['confirmationpending'] = 'Bestätigung ausstehend';
$string['confirmcontextlock'] = '{$a->contextname} ist derzeit nicht eingefroren. Durch das Einfrieren wird der Kontext schreibgeschützt, so dass keine  Änderungen vorgenommen werden können. Möchten Sie wirklich fortfahren?';
$string['confirmcontextunlock'] = '{$a->contextname} ist derzeit eingefroren. Das Freigeben ermöglicht es,  dass Änderungen am Kontext vorgenommen werden können. Möchten Sie wirklich fortfahren?';
$string['confirmdeletecomments'] = 'Möchten Sie die ausgewählten Kommentare wirklich löschen?';
$string['confirmed'] = 'Bestätigt';
$string['contactsitesupport'] = 'Website-Support';
$string['contenttypeuninstalling'] = '{$a->count} Inhalte werden von {$a->type} unterstützt. Sie werden gelöscht werden. Möchten Sie den Vorgang fortsetzen?';
$string['contextlockappliestoadmin'] = 'Einfrieren von Kontexten gilt für Administrator/innen';
$string['contextlockappliestoadmin_desc'] = 'Wenn diese Option deaktiviert ist, können Administrator/innen auch eingefrorene Kontexte ändern.';
$string['contextlocking'] = 'Einfrieren von Kontexten';
$string['contextlocking_desc'] = 'Diese Option sperrt den Schreibzugriff (read-only) für ausgewählte Kategorien, Kurse, Aktivitäten oder Blöcke.';
$string['cookiesecure'] = 'Nur sichere Cookies';
$string['country'] = 'Land';
$string['course_customfield'] = 'Nutzerdefinierte Kursfelder';
$string['coursecolor'] = 'Farbe {$a}';
$string['coursecolorheading_desc'] = 'Jeder Kurs wird im Dashboard mit einem Bild angezeigt. Wenn in den Kurseinstellungen kein Bild hinterlegt ist, wird für den Kurs ein Farbmuster zufällig gesetzt. Die Farben für die Farbmuster können hier gewählt werden.';
$string['coursecolorsettings'] = 'Kurskartenfarben';
$string['coursecontact'] = 'Kursverwaltung';
$string['coursecontact_desc'] = 'Diese Einstellung legt fest, wer zur Verwaltung eines Kurses angezeigt wird. Wem eine der hier angekreuzten Rollen für den Kurs zugewiesen wurde, dessen Name wird in der Beschreibung aufgelistet.';
$string['coursecontactduplicates'] = 'Alle Rollen des Kontakts für Kurse anzeigen';
$string['coursecontactduplicates_desc'] = 'Wenn die Funktion aktiv ist werden bei Nutzern, die in den Kursen mehrere Rollen innehaben alle Rollen angezeigt, sofern sie als Kontakt ausgewiesen werden. Wenn Sie die Funktion nicht nutzen wird nur diejenige Rolle angezeigt, die in der Auflistung der Rollen an der ersten Stelle steht.';
$string['coursecreationguide'] = 'URL zur Anleitung für die Moodle-Kurserstellung';
$string['coursecreationguide_help'] = 'Diese Einstellung definiert den Pfad zu einer Schnellstartanleitung mit kurzen Videos und allgemeinen Tipps zum Erstellen von Kursen. Ein Link zur Anleitung wird auf der Seite "Meine Kurse" angezeigt, wenn keine anzuzeigenden Kurse vorhanden sind. Nur Nutzer/innen mit der Berechtigung zum Erstellen von Kursen sehen diesen Link.';
$string['coursegraceperiodafter'] = 'Nachfrist für vergangene Kurse';
$string['coursegraceperiodbefore'] = 'Frist für zukünftige Kurse';
$string['courselistshortnames'] = 'Lange Kursnamen anzeigen';
$string['courselistshortnames_desc'] = 'In der Kursliste werden sowohl die kurzen wie auch die langen Kursnamen angezeigt. Nach der Aktivierung dieser Einstellung wird der Text \'courseextendednamedisplay\' verwendet, den Sie über die Sprachverwaltung anpassen können.';
$string['coursemgmt'] = 'Kurse und Kursbereiche verwalten';
$string['courseoverview'] = 'Kursbeschreibung';
$string['courserequestnotify'] = 'Systemnachricht zur Kursanfrage';
$string['courserequestnotifyemail'] = 'Nutzer/in {$a->user} hat einen neuen Kurs <a href="{$a->link}">{$a->link}</a> angefordert.';
$string['courserequests'] = 'Kursanträge';
$string['courserequestspending'] = 'Offene Kursanträge';
$string['courses'] = 'Kurse';
$string['coursesperpage'] = 'Kurse pro Seite';
$string['courseswithsummarieslimit'] = 'Maximale Kursanzahl mit Beschreibung';
$string['creatornewroleid'] = 'Rolle für Kursersteller/in in neuen Kursen';
$string['creatornewroleid_help'] = 'Falls ein/e Nutzer/in nicht bereits das Recht besitzt, den neuen Kurs zu verwalten, wird die Person mit dieser Rolle automatisch in den Kurs eingeschrieben.';
$string['cron'] = 'Cron';
$string['cron_enabled'] = 'Cron aktivieren';
$string['cron_enabled_desc'] = 'Wenn diese Option deaktiviert wird, kann das System keine neuen Hintergrundprozesse starten. Diese Option ist nur zur vorübergehenden Verwendung vorgesehen, z.B. vor einem Neustart des Servers. Wenn Sie es für längere Zeit nicht verwenden, funktionieren wichtige Funktionen nicht mehr.';
$string['cron_help'] = 'Der Cronjob gewährleistet, dass alle Moodle-Module ihre ausstehenden Aufgaben regelmäßig ausführen, z.B. arbeitet der Versand der E-Mails aus Moodle-Foren über diesen Mechanismus. Das Script sollte möglichst jede Minute ausgeführt werden.';
$string['cron_keepalive'] = 'Am Leben erhalten';
$string['cron_keepalive_desc'] = 'Die Zeitdauer für das Abrufen zusätzlicher Tasks. Diese Einstellung soll sicherstellen, dass cron immer läuft. Wenn Sie dedizierte Tasks ausführen, setzen Sie den Wert auf 0. Andernfalls setzen Sie den Wert ähnlich wie das Parallelitätslimit für Ad-hoc-Tasks. Vermeiden Sie längere Zeiten. Die maximale Zeit beträgt 15 Minuten.';
$string['cron_link'] = 'admin/cron';
$string['cronclionly'] = 'Cron nur über die Befehlszeile ausführen';
$string['cronerrorclionly'] = 'Der Internetzugriff für diese Seite wurde deaktiviert.';
$string['cronerrorpassword'] = 'Sie haben kein gültiges Kennwort angegeben.';
$string['croninfrequent'] = 'Die Zeit zwischen den letzten beiden Aufrufen des Cron-Scripts war {$a->actual}, sollte aber nur {$a->expected} sein. Es wird empfohlen, die Konfiguration zu ändern und es in kürzeren Abständen auszuführen.';
$string['cronremotepassword'] = 'Kennwort für cron';
$string['cronwarning'] = 'Das <a href="{$a->url}">admin/cron.php script</a> wurde in den letzten {$a->actual} nicht ausgeführt, sollte aber jede {$a->expected} laufen.';
$string['cronwarningcli'] = 'Das Script <code>admin/cli/cron.php</code> wurde in den letzten {$a->actual} nicht ausgeführt, sollte aber jede {$a->expected} laufen.';
$string['cronwarningnever'] = 'Das <code>admin/cli/cron.php</code> Script wurde noch nie ausgeführt, sollte aber jede {$a->expected} laufen.';
$string['cronwarningneverweb'] = 'Das <a href="{$a->url}">Skript admin/cron.php</a> wurde noch nie ausgeführt und sollte jede {$a->expected} ausgeführt werden.';
$string['ctyperequired'] = 'Die PHP-Extension ctype wird benötigt, um die Geschwindigkeit der Website zu steigern und die Mehrsprachkompatibilität zu anzubieten.';
$string['curlcache'] = 'cURL cache TTL';
$string['curlrequired'] = 'Die PHP-Extension cURL wird benötigt, um mit Moodle-Repositories zu kommunizieren';
$string['curlsecurityallowedport'] = 'Liste von erlaubten Ports für cURL';
$string['curlsecurityallowedportsyntax'] = 'Liste von Ports, mit denen sich cURL verbinden darf. Gültige Ports sind ausschließlich Ganzzahlen. Setzen Sie jeden Eintrag in eine neue Zeile. Wenn das Feld leer ist, sind alle Ports erlaubt. Wenn Sie Einträge vornehmen, sollten fast immer sowohl 443 als auch 80 für cURL angegeben werden, um die Verbindung zu den Standard-HTTPS- und HTTP-Ports zu erlauben.';
$string['curlsecurityblockedhosts'] = 'Liste von geblockten Hosts für cURL';
$string['curlsecurityblockedhostssyntax'] = 'Verwenden Sie für jeden Eintrag eine neue Zeile. Erlaubt sind vollständige IPv4- oder IPv6-Adressen (z.B. 192.168.10.1, 0:0:0:0:0:0:0:1, ::1, fe80::), die einen einzelnen Host adressieren. Erlaubt sind auch die CIDR-Notation (z.B. 231.54.211.0/20 or fe80::/64) oder eine Auswahl von IP-Adressen (z.B. 231.3.56.10-20 oder fe80::1111-bbbb), wobei ausschließlich die letzte Gruppe der Adresse so angesprochen werden kann. Außerdem sind Domainnamen (z.B. localhost oder example.com) oder Domainnamen mit Platzhalter (z.B. *.example.com oder *.sub.example.com</b>) erlaubt. Leere Zeilen sind nicht erlaubt.';
$string['curlsecurityurlblocked'] = 'Die URL wird geblockt.';
$string['curltimeoutkbitrate'] = 'Bitrate für die Berechnung von curl Timeouts (Kbps)';
$string['curltimeoutkbitrate_help'] = 'Beim Download von Dateien aus dem Internet wird ein Timeout ausgelöst, wenn die Geschwindigkeit zu gering wird. Als Teil der Berechnung wird die Dateigröße wird mit Hilfe von HTTP HEAD-Anfragen bestimmt. 0 deaktiviert alle HEAD-Anfragen.';
$string['currenttheme'] = 'Aktuelles Design';
$string['customcheck'] = 'Weitere Prüfungen';
$string['custommenu'] = 'Zusätzliches Menü';
$string['custommenuitems'] = 'Einträge im zusätzlichen Menü';
$string['customusermenuitems'] = 'Einträge im Nutzermenü';
$string['datarootsecurityerror'] = '<p><strong>Sicherheitswarnung!</strong></p><p>Ihr Verzeichnis dataroot liegt an der falschen Stelle auf dem Webserver, so dass sensible Dateien für alle im Internet zugänglich sind. Angreifer könnten dieses Problem ausnutzen, um unauthorisierten administrativen Zugriff auf Ihre Website zu erhalten!</p>
<p>Sie <em>müssen</em> das Verzeichnis dataroot \'{$a}\' an eine andere Stelle bewegen, die nicht in Ihrem öffentlichen Webverzeichnis liegt, und anschließend die Einstellung <code>$CFG->dataroot</code> in der Datei config.php entsprechend anpassen.</p>';
$string['datarootsecuritywarning'] = 'Ihre Einstellungen sind möglicherweise unsicher. Bitte stellen Sie sicher, dass das Verzeichnis dataroot \'{$a}\' nicht direkt aus dem Internet aufrufbar ist.';
$string['dbprefixtoolong'] = 'Das Datenbankpräfix Ihrer Website ($CFG->prefix) ist zu lang ({$a->current} Zeichen). Die maximal zulässige Anzahl von Zeichen beträgt {$a->maximum}.';
$string['dbsessions'] = 'Sitzungsinformationen in der Datenbank speichern';
$string['debug'] = 'Debug-Modus';
$string['debugall'] = 'ALLE: Alle PHP-Mitteilungen anzeigen';
$string['debugdeveloper'] = 'DEVELOPER: PHP-Mitteilungen für Entwickler/innen anzeigen';
$string['debugdisplay'] = 'Debug-Mitteilungen anzeigen';
$string['debugging'] = 'Debugging';
$string['debugminimal'] = 'MINIMAL: Nur schwerwiegende Fehler anzeigen';
$string['debugnone'] = 'KEINE: Keine Fehler oder Warnungen anzeigen';
$string['debugnormal'] = 'NORMAL: Fehler, Warnungen und Bemerkungen anzeigen';
$string['debugpageinfo'] = 'Seiteninformation anzeigen';
$string['debugsqltrace'] = 'Herkunft der SQL-Aufrufe anzeigen';
$string['debugsqltrace1'] = 'Nur eine Aufrufzeile anzeigen';
$string['debugsqltrace100'] = 'Vollständige Stapelverfolgung anzeigen';
$string['debugsqltrace2'] = '2 Zeilen der Stapelverfolgung anzeigen';
$string['debugsqltrace_desc'] = 'Diese Option legt fest, ob die PHP-Stapelverfolgung teilweise oder vollständig als Kommentar in SQL eingefügt wird.';
$string['debugstringids'] = 'Herkunft der Texte anzeigen';
$string['debugstringids_desc'] = 'Diese Option soll bei der Übersetzung helfen. Wenn die Option aktiviert und der Parameter ?strings=1 oder &strings=1 an eine aufgerufene URL angehängt ist, werden Sprachdatei und Text-ID neben jedem ausgegebenen Text angezeigt.';
$string['debugtemplateinfo'] = 'Vorlageninformationen anzeigen';
$string['debugtemplateinfo_desc'] = 'Wenn die Option aktiviert ist, werden die verwendeten Vorlagen als Kommentare im HTML-Code angezeigt. Nach einer Änderung müssen Sie die Caches löschen. Nur zum vorübergehenden Debuggen verwenden, da es zu HTML-Validierungsfehlern führt und Seitenskripte beschädigen kann. Es könnte außerdem Core-Funktionen beeinträchtigen!';
$string['debugvalidators'] = 'Prüflinks anzeigen';
$string['defaultcity'] = 'Stadt/Ort';
$string['defaultcity_help'] = 'Wenn Sie in diesem Feld eine Stadt bzw. einen Ort eintragen, wird diese Eingabe als Voreinstellung beim Anlegen neuer Nutzerkonten verwendet.';
$string['defaultformatnotset'] = 'Fehler beim Standardformat für Kurse. Kontrollieren Sie die Einstellungen.';
$string['defaulthomepage'] = 'Startseite für Nutzer/innen';
$string['defaultrequestcategory'] = 'Kursbereich für beantragte Kurse';
$string['defaultsettinginfo'] = 'Standard: {$a}';
$string['defaultuserroleid'] = 'Rolle für Nutzer/innen';
$string['deletedplugintypesdetected'] = 'Ein gelöschtes Plugin "{$a}" wurde erkannt. Dieses Plugin hätte während des Veraltungszeitraums migriert/deinstalliert werden sollen. Dies ist jetzt ein nicht unterstützter Plugin-Typ und die Installation/Aktualisierung kann nicht fortgesetzt werden, bis dieses Plugin deinstalliert ist.';
$string['deleteduserx'] = 'Gelöschtes Nutzerkonto {$a}';
$string['deleteincompleteusers'] = 'Unvollständige Nutzerkonten löschen';
$string['deleteunconfirmed'] = 'Unbestätigte Nutzerkonten löschen';
$string['deleteuser'] = 'Nutzerkonto löschen';
$string['density'] = 'LaTeX Größe';
$string['denyemailaddresses'] = 'E-Mail-Domains zurückweisen';
$string['development'] = 'Entwicklung';
$string['devicetype'] = 'Gerätetyp';
$string['devlibdirpresent'] = 'Verzeichnisse mit Entwicklungsbibliotheken, insbesondere <em>/vendor</em> und <em>/node_modules</em>, sollten nicht auf öffentlichen Seiten angezeigt werden. Weitere Informationen finden Sie im <a href="{$a->moreinfourl}"> Sicherheitsübersichtbericht </a>.';
$string['disabled'] = 'Deaktiviert';
$string['disableplugin'] = '{$a} deaktivieren';
$string['disableuserimages'] = 'Nutzerbilder deaktivieren';
$string['displayerrorswarning'] = 'Die Aktivierung der PHP-Einstellung <em>display_errors</em> wird für produktive Websites nicht empfohlen, weil einige der Fehlermeldungen sensible Infos zu Ihrer Serverumgebung preisgeben könnten.';
$string['displayloginfailures'] = 'Login-Fehler anzeigen';
$string['divertallemails'] = 'E-Mail-Umleitung';
$string['divertallemailsdetail'] = 'Diese Option dient als Sicherheitsmaßnahme in Entwicklungsumgebungen für den Test von E-Mails und sollte nicht in produktiven Plattformen verwendet werden.';
$string['divertallemailsexcept'] = 'Ausnahmen für die E-Mail-Umleitung';
$string['divertallemailsexcept_desc'] = 'Eine Liste von Ausnahmeregeln für E-Mails, entweder durch Kommas oder durch neue Zeilen getrennt. Jede Regel wird als regulärer Ausdruck interpretiert, z.B.
<pre>simone@acme.com
.*@acme.com
fred(\\+.*)?@acme.com
</pre>';
$string['divertallemailsto'] = 'Alle E-Mails umleiten';
$string['divertallemailsto_desc'] = 'Ist diese Option aktiviert, werden alle E-Mails stattdessen an diese eine E-Mail-Adresse umgeleitet.';
$string['dndallowtextandlinks'] = 'Drag&drop für Text und Links';
$string['doclang'] = 'Sprache für Dokumentation';
$string['docroot'] = 'Basisadresse zur Dokumentation';
$string['doctonewwindow'] = 'In neuem Fenster öffnen';
$string['doesnotfit'] = 'Anzeigeeinstellungen für E-Mails';
$string['doesnotfitdetail'] = 'Anzeigeeinstellungen für E-Mails, die Moodle verlassen';
$string['download'] = 'Download';
$string['downloadcoursecontentallowed'] = 'Option "Kursinhalt herunterladen" verfügbar';
$string['downloadcoursecontentallowed_desc'] = 'Gibt an, ob die Funktion zum Herunterladen von Kursinhalten für Kurse verfügbar ist. Wenn verfügbar, kann das Herunterladen von Kursinhalten über die Einstellung "Kursinhalt herunterladen aktivieren" in den Kurseinstellungen aktiviert/deaktiviert werden (die Standardeinstellung hierfür kann in <a href={$a} target="_blank">Grundeinstellungen</a> festgelegt werden).';
$string['durationunits'] = 'Wartezeit';
$string['edithelpdocs'] = 'Hilfetexte bearbeiten';
$string['editlang'] = 'Bearbeiten';
$string['editorbackgroundcolor'] = 'Hintergrundfarbe';
$string['editordictionary'] = 'Wörterbuch für den Editor';
$string['editorfontfamily'] = 'Zeichensatzart';
$string['editorfontlist'] = 'Zeichensatzliste';
$string['editorfontsize'] = 'Schriftgröße';
$string['editorhidebuttons'] = 'Verborgene Tasten';
$string['editorkillword'] = 'Word-Format-Filter';
$string['editorspelling'] = 'Rechtschreibprüfung für den Editor';
$string['editorspellinghelp'] = 'Diese Einstellung aktiviert bzw. deaktiviert die Rechtschreibprüfung. Wenn sie aktiviert ist, muss <strong>aspell</strong> auf dem Server installiert sein.';
$string['editstrings'] = 'Menütexte bearbeiten';
$string['emailchangeconfirmation'] = 'Bestätigung der E-Mail-Änderung';
$string['emaildkim'] = 'E-Mail-Signierung mit DomainKeys Identified Mail (DKIM)';
$string['emaildkiminfo'] = 'Wenn sowohl der DKIM-Selektor gesetzt ist als auch eine private Zertifikatsdatei gefunden wird, die mit der "Von"-Adressendomäne der E-Mail in $CFG->dataroot/dkim/[domain]/[selector].private übereinstimmt, wird die E-Mail signiert. In den meisten Fällen (z.B. wenn allowedemaildomains leer ist) wird nur ein einziges Zertifikat in <pre>{$a->path}</pre> benötigt. Weitere Einzelheiten zur Einrichtung finden Sie in der Dokumentation <a href="{$a->docs}">E-Mail-Konfiguration</a>.';
$string['emaildkimselector'] = 'DKIM-Selektor';
$string['emailfromvia'] = 'Via-Info für E-Mails';
$string['emailheaders'] = 'E-Mail-Header';
$string['emailsubjectprefix'] = 'Präfix für E-Mail-Betreff';
$string['emoticonalt'] = 'Alternativtext';
$string['emoticoncomponent'] = 'Komponente';
$string['emoticonimagename'] = 'Bildname';
$string['emoticons'] = 'Emoticons';
$string['emoticons_desc'] = 'Dieses Formular definiert die Emoticons (oder Smileys) für Ihre Website. Um eine Zeile aus der Tabelle zu entfernen, löschen Sie die Werte und speichern Sie das Formular ab. Um ein neues Emoticon hinzuzufügen, füllen Sie die Felder in der letzten leeren Tabellenzeile aus. Um alle Felder auf die Standardwerte zurückzusetzen, klicken Sie auf den entsprechenden Link.

* Text (erforderlich) - Dieser Text wird durch ein Bild des Emoticons ersetzt. Der Text muss mindestens zwei Zeichen lang sein.
* Bildname (erforderlich) - Dateiname des Bildes ohne Erweiterung, inclusive Pfad relativ zum Verzeichnis \'pix\'.
* Komponente (erforderlich) - Komponente, die das Symbol in Moodle bereitstellt.
* Alternativtext (optional) - Der alternative Text kann String-ID und Komponente des Emoticons anzeigen.';
$string['emoticonsreset'] = 'Emoticons auf Standardwerte zurücksetzen';
$string['emoticontext'] = 'Text';
$string['emptysettingvalue'] = 'Leer';
$string['enableanalytics'] = 'Analytics';
$string['enableblogs'] = 'Blogs aktivieren';
$string['enablecalendarexport'] = 'Kalender-Export aktivieren';
$string['enablecomments'] = 'Kommentare aktivieren';
$string['enablecommunicationsubsystem'] = 'Kommunikationsprovider aktivieren';
$string['enablecommunicationsubsystem_desc'] = 'Integration von Kommunikationsprovidern wie Matrix erlauben, damit Trainer/innen und Teilnehmer/innen  einfacher kommunizieren können. Sie können diese Integrationen in den <a href="settings.php?section=managecommunicationproviders">Plugins</a> verwalten.';
$string['enablecourserelativedates'] = 'Relative Daten für Kurs aktivieren';
$string['enablecourserelativedates_desc'] = 'Zulassen, dass Daten im Kurs relativ zum Startdatum des Nutzers verwendet werden.';
$string['enablecourserequests'] = 'Kursanträge erlauben';
$string['enabled'] = 'Aktiviert';
$string['enabledashboard'] = 'Dashboard aktivieren';
$string['enabledashboard_help'] = 'Das Dashboard zeigt standardmäßig Timeline, Kalender und kürzlich verwendete Objekte. Sie können ein verändertes standardmäßiges Dashboard für alle setzen und den Nutzer/innen eigene Veränderungen erlauben. Wenn diese Option deaktiviert ist, müssen Sie "Startseite für Nutzer/innen" auf einen anderen Wert als Dashboard setzen.';
$string['enableglobalsearch'] = 'Globale Suche aktivieren';
$string['enableglobalsearch_desc'] = 'Diese Option aktiviert einen regelmäßigen Task zur Indizierung und Synchronisierung.';
$string['enablegravatar'] = 'Gravatar aktivieren';
$string['enablegravatar_help'] = 'Wenn diese Option aktiviert ist, versucht Moodle ein Profilbild von Gravatar anzuzeigen, falls Nutzer/innen selber kein eigenes Profilbild hochgeladen haben.';
$string['enablemobilewebservice'] = 'Webservice für mobile Endgeräte aktivieren';
$string['enablepdfexportfont'] = 'PDF-Schriftarten aktivieren';
$string['enablepdfexportfont_desc'] = 'Wenn in Ihrer Website Kurse in Sprachen gibt, die für generierte PDF-Dateien andere Schriftarten benötigen, können Sie mit dieser Option die Schriftart in den Kurseinstellungen festlegen. Sie müssen verfügbare Schriftarten als $cfg->pdfexportfont in config.php angeben.';
$string['enableplugin'] = '{$a} aktivieren';
$string['enablerecordcache'] = 'Datencache erlauben';
$string['enablerssfeeds'] = 'RSS Feeds aktivieren';
$string['enablesearchareas'] = 'Suchbereiche aktivieren';
$string['enablesharingtomoodlenet'] = 'Freigabe für MoodleNet aktivieren (ausgehend)';
$string['enablesharingtomoodlenet_desc'] = 'Ermöglichen Sie es Nutzer/innen, Kursinhalte für eine konfigurierte MoodleNet-Instanz freizugeben, wenn sie über das entsprechende Recht verfügen.';
$string['enablestats'] = 'Statistiken aktivieren';
$string['enabletrusttext'] = 'Trusted-Content-System aktivieren';
$string['enableuserfeedback'] = 'Feedback zur Software aktivieren';
$string['enableuserfeedback_desc'] = 'Wenn diese Option aktiviert ist, wird im Dashboard und in der Fußzeile der Link "Feedback geben" angezeigt, damit Nutzer/innen ein Feedback zur Software an das Moodle HQ geben können. Wenn die Option "Nächste Feedback-Erinnerung" aktiviert ist, wird Nutzer/innen im angegebenen Intervall auch eine Erinnerung im Dashboard angezeigt. Wenn Sie "Nächste Erinnerung zum Feedback" auf "Nie" setzen, wird die Dashboard-Erinnerung deaktiviert, während der Link "Feedback zur Software geben" in der Fußzeile verbleibt.';
$string['enablewebservices'] = 'Webservices aktivieren';
$string['enablewsdocumentation'] = 'Dokumentation zu Webservices';
$string['encryptedpassword_edit'] = 'Neuen Wert angeben';
$string['encryptedpassword_set'] = '(gesetzt und verschlüsselt)';
$string['enroladminnewcourse'] = 'Administrator/in automatisch in neue Kurse einschreiben';
$string['enroladminnewcourse_help'] = 'Wenn Administrator/innen neue Kurse anlegen, sollen sie dann automatisch eingeschrieben und der Kurserstellerrolle zugewiesen werden?';
$string['enrolinstancedefaults'] = 'Standardeinstellungen zur Einschreibung';
$string['enrolinstancedefaults_desc'] = 'Standardeinstellungen zur Einschreibung in neue Kurse';
$string['enrolmultipleusers'] = 'Nutzer/innen einschreiben';
$string['ensureauroraversion'] = 'Ihre Website läuft auf der Amazon Aurora-Datenbank-Engine. Die MySQL-Version in Amazon Aurora muss mit der Moodle-Version kompatibel sein, die Sie installieren oder auf die Sie aktualisieren. Überprüfen Sie die Kompatibilität in <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraMySQLReleaseNotes/AuroraMySQL.Updates.30Updates.html">Datenbank-Engine-Updates für Amazon Aurora MySQL Version 3</a>.';
$string['entitytasklog'] = 'Task-Logdaten';
$string['environment'] = 'Serverumgebung';
$string['environmenterrortodo'] = 'Sie müssen zunächst alle Probleme mit der Serverumgebung beheben, bevor Sie mit der Installation von Moodle fortfahren können.';
$string['environmenterrorupgrade'] = 'Hinweis: Sie sollten unbedingt die Probleme mit der Serverumgebung beheben, bevor Sie mit der Aktualisierung fortfahren. Falls Sie die Aktualisierung trotzdem durchführen und die Anforderungen missachten, könnten Fehler entstehen, eventuell auch Datenverluste. Möchten Sie wirklich weiter fortfahren?';
$string['environmentmariadbwrongdbtype'] = 'Falscher $CFG->dbtype. Sie müssen den Eintrag in der Datei config.php von \'mysqli\' nach \'mariadb\' ändern.';
$string['environmentmustfixsetting'] = 'Die PHP-Einstellung muss geändert werden';
$string['environmentok'] = 'Die Serverumgebung erfüllt alle notwendigen Anforderungen.';
$string['environmentrecommendcustomcheck'] = 'Wenn dieser Test fehlschlägt, dann ist möglicherweise ein Problem vorhanden.';
$string['environmentrecommendinstall'] = 'sollte installiert und aktiviert sein';
$string['environmentrecommendversion'] = 'empfohlen: {$a->needed} - installiert: {$a->current}';
$string['environmentrequirecustomcheck'] = 'Dieser Test muss erfolgreich verlaufen.';
$string['environmentrequireinstall'] = 'muss installiert und aktiviert sein';
$string['environmentrequireversion'] = 'notwendig: {$a->needed} - installiert: {$a->current}';
$string['environmentsettingok'] = 'Empfohlene Einstellung gefunden';
$string['environmentshouldfixcustomcheck'] = 'sollte für optimale Ergebnisse aktiviert sein';
$string['environmentshouldfixsetting'] = 'Die PHP-Einstellung sollte geändert werden';
$string['environmentxmlerror'] = 'Fehler beim Auslesen der Serverumgebungsdaten ({$a->error_code})';
$string['errordeletingconfig'] = 'Fehler beim Löschen der Konfigurationsdaten für das Plugin \'{$a}\'';
$string['errorsetting'] = 'Einige Einstellungen konnten nicht gespeichert werden:';
$string['errorwithsettings'] = 'Einige Einstellungen wurden wegen eines Fehlers nicht geändert:';
$string['eventshandlersinuse'] = 'Die folgenden Plugins verwenden veraltete Handler für die  Events 1 API: \'{$a}\'. Aktualisieren Sie diese Plugins bitte, um die Events 2 API zu verwenden. Siehe https://docs.moodle.org/dev/Events_API#Event_dispatching_and_observers.';
$string['everyonewhocan'] = 'Alle, die \'{$a}\' können';
$string['exceptions'] = 'Ausnahmen';
$string['execpathnotallowed'] = 'Das Setzen von Systempfaden ist in der config.php deaktiviert.';
$string['experimental'] = 'Experimentell';
$string['experimentalsettings'] = 'Experimentelle Einstellungen';
$string['extendedusernamechars'] = 'Sonderzeichen in Anmeldenamen';
$string['extramemorylimit'] = 'Eigene PHP-Memory-Begrenzung';
$string['fatalsessionautostart'] = '<p>Schwerwiegender Konfigurationsfehler - bitte benachrichtigen Sie Ihre/n Server-Administrator/in</p> <p>Um ordnungsgemäß zu arbeiten, ist für Moodle eine Änderung in den PHP-Einstellungen notwendig.<br /><code> session.auto_start=off</code> muss gesetzt sein!<br />Diese Einstellung wird auf den Server geändert, u.z.  in der Datei <code>php.ini</code>, in der Apache/IIS Konfiguration oder in der Datei  <code>.htaccess</code>.</p>';
$string['favicon'] = 'Favicon';
$string['favicon_desc'] = 'Das Favicon wird im Browser-Tab neben dem Seitentitel angezeigt. Wenn kein nutzerdefiniertes Favicon bereitgestellt ist, wird ein Favicon von Moodle angezeigt.';
$string['feedbacksettings'] = 'Feedback-Einstellungen';
$string['fileconversioncleanuptask'] = 'Temporäre Einträge der Dateikonvertierung bereinigen';
$string['filecreated'] = 'Neue Datei angelegt';
$string['filescleanupperiod'] = 'Bereinigung gelöschter Dateien';
$string['filescleanupperiod_help'] = 'Wie oft Dateien, die gelöscht wurden tatsächlich gelöscht werden. Dies betrifft Dateien für die kein Kontext mehr existiert. Hinweis:  Die Einstellung kann zu Problemen mit fehlenden Dateien führen falls die Option zur Einbindung von Dateien in automatischen Backups deaktiviert wurde. Falls dann ein Kurs erst gesichert, dann der Kurs gelöscht wurde und später aus der Sicherung wiederhergestellt wird, fehlen die Bezüge zu Dateien, da sie nicht in die Sicherung aufgenommen wurden.';
$string['filesizeunits'] = 'Einheit für Dateigrößen';
$string['filestoredin'] = 'Verzeichnis zum Speichern der Sprachdateien :';
$string['filestoredinhelp'] = 'Wo soll die Datei gespeichert werden';
$string['filterall'] = 'Alle Begriffe filtern';
$string['filtermatchoneperpage'] = 'Filter einmal pro Seite anwenden';
$string['filtermatchonepertext'] = 'Filter einmal pro Text anwenden';
$string['filternavigationwithsystemcontext'] = 'Navigation mit Systemkontext filtern';
$string['filters'] = 'Filter';
$string['filtersettings'] = 'Übersicht';
$string['filtersettingsgeneral'] = 'Generelle Filtereinstellungen';
$string['filteruploadedfiles'] = 'Filter für hochgeladene Dateien';
$string['forceclean'] = 'Content-Bereinigung überall';
$string['forceclean_desc'] = 'Eingefügte Inhalte werden normalerweise vor der Anzeige gereinigt, um alles zu entfernen, was eine Sicherheitsbedrohung darstellen könnte. Bestimmte Stellen wie Aktivitätsbeschreibungen, Textfelder, Textseiten oder Textblöcke werden jedoch nicht gereinigt, damit Skripte, Medien, Inline-Frames usw. hinzugefügt werden können. Wenn diese Einstellung aktiviert ist, werden alle Inhalte gereinigt. Dies kann dazu führen, dass vorhandene Inhalte nicht mehr korrekt angezeigt werden.';
$string['forcelogin'] = 'Anmeldung notwendig';
$string['forceloginforprofileimage'] = 'Anmeldung notwendig, um Profilbilder anzuzeigen';
$string['forceloginforprofileimage_help'] = 'Diese Option legt fest, dass Nutzer/innen eingeloggt sein müssen, um Profilbilder sehen zu können. Bei E-Mail-Nachrichten wird nur das Standardbild eingesetzt.';
$string['forceloginforprofiles'] = 'Anmeldung notwendig, um Profile anzuzeigen';
$string['forcetimezone'] = 'Zeitzone festlegen';
$string['formatuninstallwithcourses'] = 'Das Format \'{$a->format}\' wird in {$a->count} Kursen verwendet. Das Format dieser Kurse wird auf \'{$a->defaultformat}\' (Standardformat dieser Website) geändert, wobei formatspezifische Daten verloren gehen könnten. Möchten Sie den Vorgang fortsetzen?';
$string['frontpage'] = 'Startseite';
$string['frontpagebackup'] = 'Sicherung der Startseite';
$string['frontpagedefaultrole'] = 'Standardrolle für Startseite';
$string['frontpagefilters'] = 'Filter für Startseite';
$string['frontpageloggedin'] = 'Startseite nach Anmeldung';
$string['frontpageoverrides'] = 'Rechteänderungen für Startseite';
$string['frontpagequestions'] = 'Fragen der Startseite';
$string['frontpagerestore'] = 'Wiederherstellung';
$string['frontpageroles'] = 'Rollen für Startseite';
$string['frontpagesettings'] = 'Einstellungen der Startseite';
$string['fullnamedisplay'] = 'Vollständiger Name';
$string['fullnamedisplayprivate'] = 'Vollständiger Name - angepasst';
$string['gdrequired'] = 'Die PHP-Extension GD wird zur Bildumwandlung benötigt.';
$string['generalsettings'] = 'Grundeinstellungen';
$string['geoipdbedition'] = 'GeoIP Database Edition';
$string['geoipdbedition_desc'] = 'Wählen Sie die gewünschte Edition der GeoIP-Datenbank zum Download aus. Beachten Sie bitte, dass für die Nutzung der GeoIP2-City-Datenbank eine kostenpflichtige Lizenz erforderlich ist.';
$string['geoipfile'] = 'GeoIP City DB';
$string['geoipmaxmindaccid'] = 'MaxMind Konto-ID';
$string['geoipmaxmindaccid_desc'] = 'Die Konto-ID des beim MaxMind-API-Service erstellten Kontos.';
$string['geoipmaxmindlicensekey'] = 'MaxMind License Key';
$string['geoipmaxmindlicensekey_desc'] = 'Der Lizenzschlüssel des beim MaxMind-API-Service erstellten Kontos.';
$string['geopluginapikey'] = 'GeoPlugin API Key';
$string['geopluginapikey_desc'] = 'Der API-Key für den Zugriff auf den GeoPlugin-Dienst. Holen Sie sich Ihren eigenen Schlüssel auf der <a href="https://www.geoplugin.com/" target="_blank"> geoplugin.com </a>.';
$string['getremoteaddrconf'] = 'Geloggte IP-Adressen Quelle';
$string['globalsearch'] = 'Globale Suche';
$string['globalsearchmanage'] = 'Globale Suche verwalten';
$string['googlemapkey3'] = 'Google Maps API V3 Key';
$string['googlemapkey3_help'] = 'Um die Lokalisierung von IP-Adressen über Google-Maps zu ermöglichen, benötigen Sie einen API Key von Google. Sie erhalten diesen Schlüssel kostenfrei unter: <a href="https://developers.google.com/maps/documentation/javascript/tutorial#api_key" target="_blank">https://developers.google.com/maps/documentation/javascript/tutorial#api_key</a>';
$string['gotofirst'] = 'Zum ersten fehlenden Text springen';
$string['gradebook'] = 'Bewertungen';
$string['gradebookroles'] = 'Bewertete Rollen';
$string['gradeexport'] = 'Exportformat für die Bewertungen';
$string['gradeexportdefault'] = 'Standardmäßiger Export für Bewertungen';
$string['gravatardefaulturl'] = 'Gravatar Standardbild';
$string['gravatardefaulturl_help'] = 'Gravatar benötigt ein Standardbild, wenn für ein bestimmtes Nutzerkonto kein Bild gefunden werden kann. Geben Sie die vollständige URL des Bildes an. Codes zur Generierung von Standardbildern finden Sie unter <a href="https://docs.gravatar.com/api/avatars/images/">Gravatar für Entwickler – Avatar-Anfragen</a>.';
$string['group_customfield'] = 'Nutzerdefinierte Gruppenfelder';
$string['groupenrolmentkeypolicy'] = 'Regeln für Einschreibekennwort zu Gruppen';
$string['groupenrolmentkeypolicy_desc'] = 'Diese Option legt fest, dass für Einschreibekennwörter zu Gruppen die gleichen Regeln gelten wie für Nutzerkennwörter.';
$string['grouping_customfield'] = 'Nutzerdefinierte Gruppierungsfelder';
$string['guestroleid'] = 'Rolle für Gäste';
$string['guestroleid_help'] = 'Diese Rolle wird Gästen automatisch zugewiesen. Sie wird außerdem vorübergehend vergeben, wenn Nutzer/innen über den \'Gastzugang\' einen Kurs betreten, sich dort aber nicht einschreiben.';
$string['h5pgetcontenttypestask'] = 'H5P-Inhaltstypen von h5p.org herunterladen';
$string['helpadminseesall'] = 'Sollen Administrator/innen alle Kalendereinträge sehen oder nur diejenigen aus Kursen, in die sie selber eingeschrieben sind? Unabhängig von der gewählten Option können Administrator/innen die Termine für jeden Kurskalender verwalten, indem sie zuerst zum Kurs navigieren und dann direkt auf den Kurskalender zugreifen.';
$string['helpcalendarcustomexport'] = 'Eigenen Datumsbereich beim Kalenderexport aktivieren. Damit diese Opton wirksam wird, müssen Kalenderexporte generell aktiviert sein.';
$string['helpexportlookahead'] = 'Wie viele Tage im voraus sollen Termine beim Kalenderexport berücksichtigt werden?';
$string['helpexportlookback'] = 'Wie viele Tage in der Vergangenheit sollen Termine beim Kalenderexport berücksichtigt werden?';
$string['helpforcetimezone'] = 'Sie können die Zeitzone festlegen. Alternativ können Sie allen Personen erlauben, ihre eigene Zeitzone zu wählen.';
$string['helpshowicalsource'] = 'Wenn diese Option aktiviert ist, werden Name und Link bei iCal-importierten Terminen gezeigt.';
$string['helpsitemaintenance'] = 'Der Wartungsmodus sperrt die Website für Arbeiten am System, für Installationen von Updates und Zusatzmodulen. Die Anmeldung ist ausschließlich für Administrator/innen möglich.';
$string['helpstartofweek'] = 'An welchem Tag soll die Woche im Kalender beginnen?';
$string['helpupcominglookahead'] = 'Wie viele Tage im Voraus sollen künftige Termine gesucht werden?';
$string['helpupcomingmaxevents'] = 'Wie viele Termine sollen maximal als künftige Termine angezeigt werden?';
$string['helpweekenddays'] = 'Welche Tage der Woche sollen als Wochenende farbig hervorgehoben werden?';
$string['hiddenuserfields'] = 'Nutzerfelder verbergen';
$string['hidefromall'] = 'Für alle verbergen';
$string['hidefromnone'] = 'Für niemanden verbergen';
$string['hidefromstudents'] = 'Für Teilnehmer/innen verbergen';
$string['hookcallbacknotcallable'] = 'Dieser Rückruf ist nicht abrufbar. Dies könnte daran liegen, dass die Klasse oder Methode nicht existiert oder dass die Methode nicht öffentlich ist.';
$string['hookcallbacks'] = 'Rückrufe';
$string['hookcallbacks_help'] = 'Die Liste der Rückrufe, die aufgerufen werden, wenn der Haken versandt wird.

Die angezeigte Reihenfolge ist die Reihenfolge, in der Rückrufe aufgerufen werden.

Ein Rückruf mit einer höheren Priorität wird vor einem mit niedrigerer Priorität aufgerufen.';
$string['hookclassmissing'] = 'Hook Class nicht gefunden';
$string['hookclassmissing_desc'] = 'Der Hook Discovery Agent hat eine Klasse zurückgegeben, die nicht existiert.';
$string['hookconfigoverride'] = 'Überschrieben';
$string['hookconfigoverride_help'] = 'Die Definition dieses Rückrufs wurde in der Website -Konfigurationsdatei config.php überschrieben';
$string['hookdeprecates'] = 'Veraltete Rückrufe';
$string['hookdescription'] = 'Beschreibung';
$string['hookdescriptionmissing'] = 'Hook hat keine Beschreibungsmethode';
$string['hookname'] = 'Hook';
$string['hooksoverview'] = 'Hooks-Übersicht';
$string['hookunknown'] = 'Hook nicht gefunden';
$string['hookunknown_desc'] = 'Das Objekt, auf das dieser Rückruf hört, ist nicht verfügbar. Es kann entfernt oder umbenannt oder in dieser Version von Moodle nicht verfügbar sein.';
$string['hostname'] = 'Hostname';
$string['htmleditor'] = 'HTML-Editor';
$string['htmleditorsettings'] = 'Einstellungen für den HTML-Editor';
$string['htmlsettings'] = 'HTML-Einstellungen';
$string['http'] = 'HTTP';
$string['httpsecurity'] = 'HTTP-Sicherheit';
$string['iconvrequired'] = 'Die PHP-Extension ICONV muss installiert sein';
$string['igbinary322buggyversion'] = 'Die auf der Website installierte Erweiterung php-igbinary kann zu Problemen führen, wenn sie mit PHP 7.2 läuft. Es wird empfohlen, entweder auf php-igbinary 3.2.5 oder höher zu aktualisieren, oder alternativ auf PHP 7.3 oder höher zu aktualisieren.';
$string['ignore'] = 'Ignorieren';
$string['importantupdates_content'] = 'In Moodle 5.0 wurden die Aktivitäten Chat und Umfrage aus dem Moodle Core entfernt. Sie sind als Plugins in den <a href="https://moodle.org/plugins/">Moodle Plugins</a> verfügbar. Wenn Sie Chat oder Umfrage weiter auf Ihrer Website nutzen möchten, können Sie diese beim Upgrade auf Moodle 5.0 als Plugins installieren.';
$string['importantupdates_title'] = 'Wichtige Aktualisierung bei Chat und Umfrage';
$string['includemoduleuserdata'] = 'Nutzerdaten aus Modulen einbeziehen';
$string['incompatibleblocks'] = 'Inkompatible Blöcke';
$string['incompleteunicodesupport'] = 'Die aktuelle Konfiguration von MySQL oder MariaDB verwendet \'utf8\'. Dieser Zeichensatz unterstützt keine vier Byte-Zeichen, wie sie z.B. für einige Emoji notwendig sind. Der Versuch, diese Zeichen zu verwenden, führt zu einem Fehler beim Aktualisieren eines Datensatzes, und alle Informationen, die an die Datenbank gesendet werden, gehen verloren. Es wird empfohlen, die Einstellungen auf \'utf8mb4\' zu ändern. Weitere Informationen finden Sie in der Dokumentation.';
$string['indexdata'] = 'Indizierungsdaten';
$string['indexinginfo'] = 'Zur Indizierung der Website wird der regelmäßige Task \'Global Search Indexing\' empfohlen.';
$string['installhijacked'] = 'Die Installation muss von der ursprünglichen IP-Adresse aus abgeschlossen werden.';
$string['installsessionerror'] = 'Die PHP Session kann nicht initialisiert werden. Prüfen Sie bitte, ob Ihr Browser Cookies akzeptiert.';
$string['intlrecommended'] = 'Die PHP-Extension Intl gewährleistet die Internationalisierung, etwa eine lokalisierte Sortierung';
$string['intlrequired'] = 'Die PHP Extension intl ist notwendig, um die Internationalisierung zu unterstützen, etwa beim Sortieren von lokalen Begriffen oder bei internationalen Domainnamen.';
$string['invalidagedigitalconsent'] = 'Die Altersangabe ist nicht gültig: {$a}';
$string['invalidforgottenpasswordurl'] = 'Die URL zum Zurücksetzen von vergessenen Kennwörtern ist nicht gültig.';
$string['invalidsection'] = 'Ungültiger Abschnitt';
$string['invalidthemepreset'] = 'Die ausgewählte Vorlagendatei ist mit diesem Design nicht kompatibel. Der SCSS-Kompilierungsfehler war: "{$a}"';
$string['invaliduserchangeme'] = 'Der Anmeldename "changeme" ist reserviert. Wählen Sie einen anderen Anmeldenamen.';
$string['ipblocked'] = 'Diese Website ist im Moment nicht verfügbar.';
$string['ipblocker'] = 'IP-Blocker';
$string['ipblockersyntax'] = 'Schreiben Sie jeden IP-Eintrag in eine neue Zeile. Gültig sind vollständige IP-Adressen für ein einzelnes Gerät (z.B. <b>192.168.10.1</b>) oder eine teilweise Angabe (z.B. <b>192.168.</b>) für alle IP-Adressen, die mit diesen Zahlen beginnen. Ebenfalls gültig sind IP-Adressbereiche (z.B. <b>192.168.10.20-50</b>) für alle IP-Adressen im Bereich (hier 20 bis 50) oder IP-Adressen in der CIDR-Schreibweise (z.B. <b>231.54.211.0/20</b>). Die Angabe von Domainnamen (z.B. \'beispiel.de\') ist nicht erlaubt. Leere Zeilen und Inhalte nach einem \'#\' Zeichen werden ignoriert.';
$string['iplookup'] = 'IP-Adressen-Suche';
$string['iplookupgeoplugin'] = 'Der Dienst <a href="https://www.geoplugin.com">geoPlugin</a> wird derzeit zum Nachschlagen geografischer Informationen verwendet. Für genauere Ergebnisse empfehlen wir die Installation einer lokalen Kopie der MaxMind GeoIP-City-Datenbank.';
$string['iplookupinfo'] = 'Der kostenlose Online-Server NetGeo wird zum Nachschlagen von IP-Adress-Standorten verwendet. Die Datenbank wird jedoch nicht mehr gepflegt und kann falsche Daten zurückgeben. Es wird empfohlen, eine lokale Kopie einer GeoIP-Datenbank von MaxMind zu installieren.<br />
Wenn ein Google Maps API V3-Schlüssel angegeben wird, wird der IP-Adress-Standort mithilfe von Google Maps angezeigt. Sie benötigen ein Google-Konto und müssen einen Google Maps API-Schlüssel beantragen. Wenn kein Google Maps API V3-Schlüssel angegeben wird, wird der IP-Adress-Standort mithilfe von OpenStreetMap angezeigt.';
$string['iplookupmaxmindnote'] = 'Dieses Produkt enthält GeoIP City Data von MaxMind, verfügbar unter <a href="https://www.maxmind.com">https://www.maxmind.com</a>.';
$string['iscustomadminwarnings'] = 'Es wurde festgestellt, dass Ihre Website ein nutzerdefiniertes Verzeichnis für die Administration verwendet. Diese Funktion wird nicht mehr unterstützt und wird nach Moodle 4.2 entfernt.';
$string['ishttpswarning'] = 'Diese Website wird nicht über HTTPS abgesichert. Es wird dringend empfohlen, die Website auf HTTPS umzustellen, um die Sicherheit zu erhöhen und die Integration anderer Systeme zu verbessern.';
$string['keeptagnamecase'] = 'Schreibweise von Tags beibehalten';
$string['lang'] = 'Sprache';
$string['langcache'] = 'Sprachmenü-Cache
';
$string['langcache_desc'] = 'Cache für Sprachmenü. Wenn diese Option aktiviert ist, wird eine Liste der in Moodle aktivierten Sprachpakete zwischengespeichert. Der Cache wird automatisch aktualisiert, wenn Sie ein Sprachpaket über die Sprachverwaltung installieren oder löschen. Falls Sie ein Sprachpaket manuell auf den Server kopieren, müssen Sie auch den Sprachcache löschen.';
$string['langlist'] = 'Sprachen im Sprachmenü';
$string['langmenu'] = 'Sprachmenü';
$string['langmenuinsecurelayout'] = 'Sprachmenü im sicheren Layout anzeigen';
$string['langmenuinsecurelayout_desc'] = 'Wenn diese Option aktiviert ist, können Nutzer/innen ihre Sprache ändern, wenn sie einen Test oder eine andere Aktivität im sicheren Layout versuchen.';
$string['langpackwillbeupdated'] = 'Hinweis: Bei der Aktualisierung wird auch versucht, die Sprachpakete zu erneuern.';
$string['langstringcache'] = 'Sprachcache';
$string['languagesettings'] = 'Einstellungen';
$string['latinexcelexport'] = 'Excel-Kodierung';
$string['legacyfilesaddallowed'] = '\'Alte Kursdateien\' erweiterbar';
$string['legacyfilesaddallowed_help'] = 'Falls ein Verzeichnis \'Alte Kursdateien\' im Kurs vorhanden ist, dürfen dort weitere Dateien, Verzeichnisse und Unterverzeichnisse hinzugefügt werden.';
$string['legacyfilesinnewcourses'] = '\'Alte Kursdateien\' in neuen Kursen';
$string['legacyfilesinnewcourses_help'] = 'Zunächst ist das Verzeichnis \'Alte Kursdateien\' nur in Kursen verfügbar, die aus Moodle 1.9.x importiert wurden. Beachten Sie bitte, dass einige Features (z.B. Sicherung und Wiederherstellung einzelner Aktivitäten) nicht zu dieser Option kompatibel sind.';
$string['libcurlwarning'] = 'Es wurde festgestellt, dass libcurl das CURLOPT_PROTOCOL nicht unterstützt.  Aus Sicherheitsgründen sollte die libcurl-Installation aktualisiert werden.';
$string['licensesettings'] = 'Lizenzeinstellungen';
$string['linkadmincategories'] = 'Adminbereiche verlinken';
$string['linkadmincategories_help'] = 'Wenn diese Option aktiviert ist, werden die Einstellungen für die verschiedenen Administrationsbereiche als Links auf den Übersichtsseiten bereitgestellt.';
$string['loading'] = 'Lädt';
$string['localetext'] = '"locale" für die Website';
$string['localstringcustomization'] = 'Lokales Sprachpaket anpassen';
$string['location'] = 'Lokales';
$string['locationsettings'] = 'Einstellungen';
$string['locked'] = 'Gesperrt';
$string['lockoutduration'] = 'Kontosperrdauer';
$string['lockoutduration_desc'] = 'Die Kontosperrung wird automatisch nach dieser Zeit aufgehoben.';
$string['lockoutemailbody'] = 'Guten Tag {$a->firstname} {$a->lastname}

Ihr Nutzerkonto mit dem Anmeldenamen \'{$a->username}\' auf dem Server \'{$a->sitename}\' wurde nach mehreren ungültigen Anmeldeversuchen gesperrt.

Um das Konto zu entsperren, öffnen Sie bitte die folgende Webadresse:

{$a->link}

In den meisten Fällen sollte ein klickbarer Link angezeigt werden. Sollte ein Klick nicht funktionieren, kopieren Sie die Adresse in das Adressfeld Ihres Webbrowsers.

Falls Sie Hilfe benötigen, wenden Sie sich an {$a->admin}.

Ihr E-Learning-Team';
$string['lockoutemailsubject'] = 'Ihr Konto auf \'{$a}\' wurde gesperrt.';
$string['lockouterrorunlock'] = 'Ungültige Daten zur Kontofreigabe';
$string['lockoutthreshold'] = 'Schwelle zur Kontosperrung';
$string['lockoutthreshold_desc'] = 'Nach wie vielen erfolglosen Anmeldeversuchen soll ein Nutzerkonto vorübergehend gesperrt werden? Mit dieser Option werden Angriffe auf Ihr System erschwert.';
$string['lockoutwindow'] = 'Beobachtungszeit zur Kontosperrung';
$string['lockoutwindow_desc'] = 'Beobachtungszeit zur Kontosperrung. Wenn während dieser Zeit keine weiteren Fehlversuche erfolgten, wird der Zähler nach dieser Zeit zurückgesetzt.';
$string['lockrequestcategory'] = 'Kursbereichsauswahl sperren';
$string['log'] = 'Logdaten';
$string['logguests'] = 'Gastzugang loggen';
$string['logguests_help'] = 'Diese Einstellung legt fest, ob die Aktionen über den Gastzugang unabhängig von den anderen Nutzerkonten geloggt werden soll. Es wird dringend empfohlen, bei produktiven Websites diese Einstellung zu aktivieren, auch wenn zur Verringerung der Serverlast die Deaktivierung von Logdaten für den Gastzugang erwogen wird.';
$string['logininfoinsecurelayout'] = 'Angemeldete Person im sicheren Layout anzeigen';
$string['logininfoinsecurelayout_desc'] = 'Wenn diese Option aktiviert ist, wird der vollständige Name einer Person in der Navigation angezeigt, wenn sie einen Test oder eine andere Aktivität im sicheren Layout versucht.';
$string['loginpageautofocus'] = 'Autofokus auf Login';
$string['loginpageautofocus_help'] = 'Das Aktivieren dieser Option verbessert die Nutzbarkeit der Anmeldeseite, aber ein Autofokus auf bestimmte Felder könnte Probleme hinsichtlich der Barrierefreiheit verursachen.';
$string['loglifetime'] = 'Logdaten speichern';
$string['logo'] = 'Logo';
$string['logo_desc'] = 'Ein großformatiges Logo kann als Erkennungszeichen auf der Startseite verwendet werden. Dieses Bild sollte hochauflösend sein, da es für die Verwendung skaliert und aus Leistung im Cache zwischengespeichert wird. Logos, die breiter als hoch sind, liefern meist bessere Ergebnisse.';
$string['logocompact'] = 'Kleines Logo';
$string['logocompact_desc'] = 'Eine kompakte Version des obigen Logos wird hier hochgeladen, z.B. Emblem, Schild oder Symbol. Das Bild sollte auch in kleinen Größen klar erkennbar sein.';
$string['logossettings'] = 'Logos';
$string['logstorenotrequired'] = 'Logdatenspeicherung nicht notwendig';
$string['logstoressupported'] = 'Logdaten für diesen Bericht';
$string['longtimewarning'] = '<b>Beachten Sie bitte, dass dieser Vorgang sehr lange dauern kann.</b>';
$string['mailnewline'] = 'Zeichen für die Zeilenschaltung';
$string['maintenancemode'] = 'Wartungsmodus';
$string['maintenancemodeisscheduled'] = 'Die Website wird in {$a->min} Minuten {$a->sec} Sekunden in den Wartungsmodus geschaltet.';
$string['maintenancemodeisscheduledlong'] = 'Die Website wird in {$a->hour} Stunden {$a->min} Minuten  {$a->sec} Sekunden in den Wartungsmodus geschaltet.';
$string['maintfileopenerror'] = 'Fehler beim Aktivieren des Wartungsmodus';
$string['maintinprogress'] = 'Die Wartung dauert eine Weile ....';
$string['managecontextlock'] = 'Diesen Kontext einfrieren';
$string['managecontextlocklocked'] = '{$a->contextname} und alle untergeordneten Kontexte sind jetzt eingefroren.';
$string['managecontextlockunlocked'] = '{$a->contextname} und alle untergeordneten Kontexte sind jetzt freigegeben.';
$string['managecontextunlock'] = 'Diesen Kontext freigeben';
$string['managecustomfields'] = 'Nutzerdefinierte Feldtypen verwalten';
$string['manageformats'] = 'Kursformate verwalten';
$string['manageformatsgotosettings'] = 'Standardformat kann geändert werden in \'{$a}\'';
$string['managelang'] = 'Verwalten';
$string['manageqbanks'] = 'Fragensammlungsplugins verwalten';
$string['manageqbehaviours'] = 'Frageverhalten verwalten';
$string['manageqtypes'] = 'Fragetypen verwalten';
$string['maturity100'] = 'Beta';
$string['maturity150'] = 'Release Candidate';
$string['maturity200'] = 'Stable Version';
$string['maturity50'] = 'Alpha';
$string['maturityallowunstable'] = 'Hinweis: dieses Script kann mit der Option --allow-unstable ausgeführt werden';
$string['maturitycoreinfo'] = 'Diese Website arbeitet mit einer Entwicklerversion: \'{$a}\'';
$string['maturitycorewarning'] = 'Das Moodle, das Sie gerade installieren oder aktualisieren möchten, ist als \'{$a}\' markiert und noch nicht für den produktiven Einsatz vorgesehen. Verwenden Sie für einen produktiven Einsatz unbedingt ein Moodle aus einem STABLE-Zweig.';
$string['maxbytes'] = 'Maximale Dateigröße';
$string['maxcharacter'] = 'Maximal {$a} Zeichen';
$string['maxconsecutiveidentchars'] = 'Aufeinander folgende identische Zeichen';
$string['maxeditingtime'] = 'Maximale Zeit zur Beitragsbearbeitung';
$string['maxsizeperdownloadcoursefile'] = 'Maximale Größe pro Datei';
$string['maxsizeperdownloadcoursefile_desc'] = 'Die maximale Größe jeder Datei beim Kursinhalt herunterladen. Dateien, die diese Größe überschreiten, werden beim Download nicht berücksichtigt.';
$string['maxtimelimit'] = 'Maximale Laufzeit';
$string['maxtimelimit_desc'] = 'Diese Option legt die maximale Laufzeit (in Sekunden) für PHP-Scripte fest, die Moodle ohne Anzeige erlaubt. Wenn der Wert 0 gesetzt ist, werden die Standardwerte von Moodle benutzt. Sollten Sie einen Frontend-Server mit eigenem Zeitlimit benutzen, müssen Sie diesen Wert niedriger setzen, um PHP-Fehler protokollieren zu können. Diese Option wird nicht auf CLI-Scripte angewendet.';
$string['maxusersperpage'] = 'Maximale Nutzeranzahl pro Seite';
$string['mbstringrecommended'] = 'Die Installation der optionalen Bibliothek MBSTRING wird zur Leistungsverbesserung dringend empfohlen. Dies ist besonders wichtig, wenn Sie Sprachen mit anderen als lateinischen Zeichensätzen verwenden.';
$string['mbstringrequired'] = 'Die Installation der Bibliothek mbstring ist erforderlich, um die Leistung der Website zu verbessern, insbesondere zur Unterstützung von nicht-lateinische Sprachen.';
$string['mediapluginavi'] = '.avi Filter aktivieren';
$string['mediapluginflv'] = '.flv Filter aktivieren';
$string['mediapluginimg'] = 'Automatische Einbettung von verlinkten Bildern aktivieren';
$string['mediapluginmov'] = '.mov Filter aktivieren';
$string['mediapluginmp3'] = '.mp3 Filter aktivieren';
$string['mediapluginmpg'] = '.mpg Filter aktivieren';
$string['mediapluginogg'] = '.ogg Filter aktivieren';
$string['mediapluginogv'] = '.ogv Filter aktivieren';
$string['mediapluginram'] = '.ram Filter aktivieren';
$string['mediapluginrm'] = '.rm Filter aktivieren';
$string['mediapluginrpm'] = '.rpm Filter aktivieren';
$string['mediapluginwmv'] = '.wmv Filter aktivieren';
$string['mediapluginyoutube'] = 'YouTube Link-Filter aktivieren';
$string['messaging'] = 'Mitteilungen aktivieren';
$string['messagingallowemailoverride'] = 'E-Mail-Adresse für Systemnachrichten überschreiben';
$string['messagingallusers'] = 'Mitteilungen systemweit erlauben';
$string['messagingcategory'] = 'Mitteilungen';
$string['messagingdefaultpressenter'] = 'Senden mit Eingabetaste als Voreinstellung';
$string['messagingdeleteallnotificationsdelay'] = 'Alle Systemnachrichten löschen';
$string['messagingdeletereadnotificationsdelay'] = 'Gelesene Systemnachrichten löschen';
$string['messagingssettings'] = 'Mitteilungseinstellungen';
$string['minpassworddigits'] = 'Ziffern';
$string['minpasswordlength'] = 'Kennwortlänge';
$string['minpasswordlower'] = 'Kleinbuchstaben';
$string['minpasswordnonalphanum'] = 'Sonderzeichen';
$string['minpasswordupper'] = 'Großbuchstaben';
$string['misc'] = 'Verschiedenes';
$string['mlbackendsettings'] = 'Backend-Einstellungen für Machine Learning';
$string['mnetrestore_extusers'] = '<strong>Achtung:</strong> Die Sicherungsdatei enthält externe Moodle-Nutzerkonten, die bei der Wiederherstellung angelegt werden.';
$string['mnetrestore_extusers_admin'] = '<strong>Achtung: </strong>Diese Sicherungsdatei scheint von einer anderen Moodle-Instanz zu stammen und externe Nutzerkonten aus dem Moodle-Netzwerk zu enthalten. Die Wiederherstellung wird versuchen, die Moodle-Netzwerk-Hosts für alle erzeugten Nutzer/innen anzupassen. Die nicht passenden Nutzerkonten werden automatisch auf die interne Authentifizierung gesetzt (anstelle von MNET) und in der Logdatei festgehalten.';
$string['mnetrestore_extusers_mismatch'] = '<strong>Achtung:</strong> Die Sicherungsdatei wurde in einem anderen Moodle erzeugt und enthält externe Nutzerkonten aus dem Moodle-Netzwerk, die evtl. nicht wiederhergestellt werden können. Diese Aktion wird nicht unterstützt. Nur wenn Sie sicher sind, dass die Sicherung aus diesem Moodle stammt oder dass alle Nutzerkonten aus dem Moodle-Netzwerk verfügbar sind, können Sie die Wiederherstellung fortsetzen.';
$string['mnetrestore_extusers_noadmin'] = '<strong>Achtung: </strong>Diese Sicherungsdatei scheint von einer anderen Moodle-Instanz zu stammen und externe Nutzerkonten aus dem Moodle-Netzwerk zu enthalten. Sie sind nicht berechtigt, diese Art von Wiederherstellung durchzuführen. Bitte nehmen Sie Kontakt mit dem/der Administrator/in Ihrer Website auf oder führen Sie alternativ die Wiederherstellung für den Kurs ohne Nutzerinformationen (Module, Dateien, ...) durch.';
$string['mnetrestore_extusers_switchuserauth'] = 'Der externe Nutzer {$a->username} aus dem Moodle-Netzwerk (von {$a->mnethosturl} kommend) wechselte zum lokal authentifizierten Nutzer {$a->auth}';
$string['mobilenotconfiguredwarning'] = 'Moodle Mobile App ist nicht aktiviert.';
$string['modassignmentinuse'] = 'Ihre Website verwendet immer noch das Plugin "Aufgabe 2.2". Vor dem Upgrade müssen Sie 1) alle Aktivitäten "Aufgabe 2.2" sichern, die Sie behalten möchten, und als Aktivitäten "Aufgabe" wiederherstellen. Anschließend müssen Sie 2) alle Daten von Aufgabe 2.2 aus der Datenbank löschen.';
$string['modassignmentsubpluginsexist'] = 'Es könnten Subplugins für "Aufgabe 2.2" vorhanden sein. Das Verzeichnis mod/assignment und alle enthaltenen Subplugins müssen vor dem Upgrade entfernt werden.';
$string['modeditdefaults'] = 'Grundeinstellungen für die Aktivität';
$string['modsettings'] = 'Übersicht';
$string['modulesecurity'] = 'Modul-Sicherheit';
$string['moodlebrandedapp'] = 'Individuell angepasste Mobile App';
$string['moodlebrandedappreference'] = 'Alternativ können Sie eine <a href="https://moodle.com/branded-app">individuelle Moodle-App</a> für Ihre Institution bestellen.';
$string['mustenablestats'] = 'Die Statistiken wurden für die Website nicht aktiviert.';
$string['mycourses'] = 'Meine Kurse';
$string['mydashboard'] = 'Standard Systemdashboard';
$string['mymoodle'] = 'Dashboard';
$string['mypage'] = 'Dashboard für alle anpassen';
$string['mypagelocked'] = 'Standardseite sperren';
$string['myprofile'] = 'Profilseite für alle anpassen';
$string['navadduserpostslinks'] = 'Links zu Nutzerbeiträgen einfügen';
$string['navadduserpostslinks_help'] = 'Bei jedem Nutzer werden zwei Links in die Navigation für Forenthemen und Diskussionsbeiträge des Nutzers auf der Startseite und in seinen Kursen eingefügt.';
$string['navcourselimit'] = 'Kursgrenze';
$string['navfilter'] = 'Filter nutzerdefiniertes Menü';
$string['navfilter_desc'] = 'Verarbeiten Sie das nutzerdefinierte Menü durch Moodle-Filter, die auf <strong>Inhalt und Überschriften</strong> angewendet werden. Nützlich zum Aktivieren dynamischer nutzerdefinierter Menüelemente.';
$string['navigationupgrade'] = 'Diese Aktualisierung liefert zwei neue Navigationsblöcke, die einige bisherige Blöcke (Administration, Kurse, Aktivitäten und Personen) ablösen. Wenn Sie spezielle Zugriffsrechte für diese Blöcke gesetzt haben, sollten Sie unbedingt prüfen, ob sich alles so verhält wie Sie es wünschen.';
$string['navshowallcourses'] = 'Alle Kurse anzeigen';
$string['navshowcategories'] = 'Kursbereiche anzeigen';
$string['navshowfrontpagemods'] = 'Aktivitäten der Startseite in Navigation anzeigen';
$string['navshowfrontpagemods_help'] = 'Wenn diese Option aktiviert ist, werden alle Aktivitäten der Startseite in der Navigation unter \'Website\' angezeigt. Diese Einstellung funktioniert nur bei Designs, die von Classic abgeleitet sind.';
$string['navshowfullcoursenames'] = 'Vollständige Kursnamen anzeigen';
$string['navshowfullcoursenames_help'] = 'Wenn diese Option aktiviert ist, werden in der Navigation die vollständigen Kursnamen angezeigt, andernfalls nur die kurzen Kursnamen.';
$string['navshowmycoursecategories'] = 'Meine Kursbereiche anzeigen';
$string['navshowmycoursecategories_help'] = 'Wenn diese Option aktiviert ist, werden die persönlichen Kurse unter "Meine Kurse" in Kategorien im Navigationsblock angezeigt (nur klassische Designs).';
$string['navsortmycourseshiddenlast'] = 'Meine verborgenen Kurse hinten einsortieren';
$string['navsortmycourseshiddenlast_help'] = 'Diese Option legt fest, dass alle verborgenen Kurse nach den sichtbaren Kursen aufgeführt (für Nutzer/innen, die verborgene Kurse anzeigen können). Andernfalls werden alle Kurse unabhängig von ihrer Sichtbarkeit gemäß der Einstellung "Meine Kurse sortieren" aufgelistet.';
$string['navsortmycoursessort'] = 'Anordnung von Kursen im Navigationsblock';
$string['navsortmycoursessort_help'] = 'Sollen Kurse in der unter "Website-Administration > Kurse > Kurse und Kategorien" festgelegten Sortierreihenfolge oder alphabetisch nach Kurseinstellung aufgelistet werden? Diese Einstellung gilt nur für Designs, die auf Classic basieren.';
$string['never'] = 'Nie';
$string['neverdeleteruns'] = 'Durchläufe nicht löschen';
$string['newestdocindexed'] = 'Neuestes Dokument indiziert';
$string['nobookmarksforuser'] = 'Sie haben keine Lesezeichen.';
$string['nodatabase'] = 'Keine Datenbank';
$string['noemaileverwarning'] = '<strong>Hinweis:</strong> Alle ausgehenden E-Mails wurden deaktiviert.';
$string['nohttpsformobilewarning'] = 'Es wird empfohlen, HTTPS mit einem gültigen Zertifikat zu aktivieren. Moodle Mobile versucht immer zuerst, eine gesicherte Verbindung zu verwenden.';
$string['nomissingstrings'] = 'Keine fehlenden Texte';
$string['none'] = 'Keine';
$string['nonewsettings'] = 'Bei der Aktualisierung wurden keine neuen Einstellungen hinzugefügt.';
$string['nonexistentbookmark'] = 'Das gesuchte Lesezeichen gibt es nicht.';
$string['noreplyaddress'] = 'Nicht-Antworten-Adresse';
$string['noreplydomain'] = 'No-Reply und Domain';
$string['noreplydomaindetail'] = 'Einstellungen für No-Reply und Domain-Konfiguration';
$string['noresults'] = 'Keine Ergebnisse gefunden.';
$string['noroles'] = 'Keine Rollen';
$string['nosupportedlogstore'] = 'Nicht unterstützte Logdaten gefunden';
$string['noteunneededblocks'] = 'Hinweis: Blöcke, die angezeigt werden sollen, werden im Menü "Block hinzufügen" in einem Kurs nicht aufgeführt, wenn sie in der Designeinstellung "Nicht benötigte Blöcke" eingetragen sind.';
$string['notifications'] = 'Systemnachrichten';
$string['notifyloginfailures'] = 'E-Mail bei Login-Fehlern an';
$string['notifyloginthreshold'] = 'Schwelle zur E-Mail-Systemnachricht';
$string['notloggedinroleid'] = 'Rolle für Besucher/innen';
$string['numberofmissingstrings'] = 'Anzahl der fehlenden Texte: {$a}';
$string['numberofstrings'] = 'Gesamtzahl der Texte: {$a->strings}<br />Fehlende Texte: {$a->missing} ({$a->missingpercent}&nbsp;%)';
$string['oauthrefreshtokenexpired'] = 'Das Aktualisierungstoken für den OAuth-2-Dienst {$a->issuer} auf Ihrer Website {$a->siteurl} ist abgelaufen. Dies schränkt die Funktionalität aller Plugins ein, die diesen Dienst nutzen. Um das Problem zu beheben, rufen Sie die Konfigurationsseite der OAuth-2-Dienste auf und klicken Sie in der Tabellenzeile für diesen Dienst auf das Symbol "Systemkonto verbinden". Achten Sie darauf, dass Sie sich jedes Mal mit demselben Dienstkonto für das OAuth-2-System anmelden.';
$string['oauthrefreshtokenexpiredshort'] = 'Das OAuth-Aktualisierungstoken für {$a->issuer} auf der Website {$a->siteurl} ist abgelaufen.';
$string['onlynoreply'] = 'Nur bei einer Nicht-Antworten-Adresse';
$string['opcacherecommended'] = 'PHP Opcode Caching verbessert die Leistung und senkt den Speicherbedarf. Die PHP-Extension OPcache wird voll unterstützt.';
$string['opensslrecommended'] = 'Die Installation der optionalen OpenSSL Bibliothek wird dringend empfohlen. Dadurch wird die Moodle-Netzwerk-Funktionalität ermöglicht.';
$string['opensslrequired'] = 'Die PHP Extension OpenSSL ist für Moodle notwendig, um stärkere Krypto-Dienste bereit zu stellen.';
$string['opentowebcrawlers'] = 'Offen für Suchmaschinen';
$string['optionalmaintenancemessage'] = 'Optionale Wartungsinfos';
$string['order1'] = 'Erstens';
$string['order2'] = 'Zweitens';
$string['order3'] = 'Drittens';
$string['order4'] = 'Viertens';
$string['outgoingmailconfig'] = 'Ausgehende E-Mails';
$string['overridetossl'] = 'Https für Login ist nun veraltet. Diese Instanz erfordert nun SSL. Um die Warnung zu entfernen, muss der  Eintrag für den wwwroot in der Datei config.php auf https://umgestellt werden.';
$string['pageinfodebugsummary'] = 'Diese Seite ist: {$a}';
$string['passwordchangelogout'] = 'Nach einer Kennwortänderung abmelden';
$string['passwordchangelogout_desc'] = 'Wenn diese Option aktiviert ist und wenn das Kennwort geändert wird, werden alle Browsersessions abgebrochen, außer derjenigen, in der das neue Kennwort eingegeben wurde. Diese Einstellung hat keine Auswirkungen auf die Kennwortänderungen per Bulk-Upload.';
$string['passwordchangetokendeletion'] = 'Nutzertoken bei Kennwortänderung löschen';
$string['passwordchangetokendeletion_desc'] = 'Die Option legt fest, dass alle Nutzertoken für Webservices bei einer Kennwortänderung gelöscht werden.';
$string['passwordpolicy'] = 'Kennwortregeln';
$string['passwordpolicycheckonlogin'] = 'Überprüfen Sie das Kennwort beim Anmelden';
$string['passwordresettime'] = 'Max. Zeit zur Bestätigung einer Kennwortrücksetzung';
$string['passwordreuselimit'] = 'Wiederholungsbeschränkung für Kennwörter';
$string['passwordreuselimit_desc'] = 'Diese Option legt fest, wie oft Nutzer/innen ein anderes Kennwort verwenden müssen, bevor sie ein altes Kennwort wiederbenutzen dürfen. Die Hashwerte der bisher benutzten Kennwörter werden intern gespeichert. Diese Option funktioniert nicht mit allen externen Authentifizierungen.';
$string['pathtodot'] = 'Pfad zu dot';
$string['pathtodot_help'] = 'Pfad zu dot, üblicherweise /usr/bin/dot. Unter Windows meist C:\\Program Files (x86)\\Graphviz2.38\\bin\\dot.exe. Und unter Mac /opt/local/bin/dot. Um Grafiken aus DOT-Dateien generieren zu können, muss das Programm dot installiert und hier darauf verwiesen sein.';
$string['pathtodu'] = 'Pfad zu du';
$string['pathtogs'] = 'Pfad zu ghostscript';
$string['pathtogs_help'] = 'In den meisten Linux-Installationen kann die Einstellung \'/usr/bin/gs\' bleiben. Bei Windows könnte die Einstellung  \'c:\\gs\\bin\\gswin32c.exe\'  richtig sein. Der Pfad darf keine Leerzeichen enthalten. Falls nötig, kopieren Sie die Dateien \'gswin32c.exe\' und \'gsdll32.dll\' in ein neues Verzeichnis ohne Leerzeichen im Pfad.';
$string['pathtopdftoppm'] = 'Pfad zu pdftoppm';
$string['pathtopdftoppm_help'] = '<a href="https://poppler.freedesktop.org/">Poppler</a> ist eine PDF-Rendering-Bibliothek, die das Tool pdftoppm zum Konvertieren von PDF-Dateien in png enthält. Die Leistung ist allgemein besser als bei der Verwendung von Ghostscript, insbesondere bei großen Dateien. Falls verfügbar, wird pdftoppm gegenüber Ghostscript bevorzugt. Bei den meisten Linux-Installationen kann der Pfad als /usr/bin/pdftoppm belassen werden. Andernfalls müssen Sie die Pakete poppler-utils oder poppler abhängig von Ihrer Linux-Distribution installieren. Bei Windows wird es von Cygwin-Installationen bereitgestellt.';
$string['pathtopgdump'] = 'Pfad zu pg_dump';
$string['pathtopgdumpdesc'] = 'Sie benötigen diese Einstellung nur, wenn mehr als ein pg_dump auf dem System vorhanden ist (z.B. wenn mehr als eine Version von PostgreSQL installiert ist).';
$string['pathtopgdumpinvalid'] = 'Ungültiger Pfad zu pg_dump - entweder ist der Pfad falsch oder nicht ausführbar';
$string['pathtophp'] = 'Pfad zu PHP CLI';
$string['pathtopsql'] = 'Pfad zu psql';
$string['pathtopsqldesc'] = 'Sie benötigen diese Einstellung nur, wenn mehr als ein psql auf dem System vorhanden ist (z.B. wenn mehr als eine Version von PostgreSQL installiert ist).';
$string['pathtopsqlinvalid'] = 'Ungültiger Pfad zu psql - entweder ist der Pfad falsch oder nicht ausführbar';
$string['pathtopython'] = 'Pfad zu Python';
$string['pathtopythondesc'] = 'Pfad zu einer ausführbaren Python-Binärdatei. Python 2 und Python 3 sind möglich.';
$string['pathtosassc'] = 'Pfad zu SassC';
$string['pathtosassc_help'] = 'Wenn Sie den Pfad zur ausführbaren SassC-Datei angeben, wird der SASS-Compiler in der PHP-Implementierung von Moodle auf SassC umgestellt. Weitere Informationen finden Sie unter https://github.com/sass/sassc.';
$string['pcreunicodewarning'] = 'Die PHP-Extension PCRE sollte installiert und kompatibel zu UTF-8 zu sein.';
$string['perfdebug'] = 'Performance';
$string['perfdebugdeferred'] = 'Warten bis das Script beendet ist, um das Performance-Debugging anzuzeigen …';
$string['performance'] = 'Performance';
$string['pgcluster'] = 'PostgreSQL Cluster';
$string['pgclusterdescription'] = 'PostgreSQL Versions-/Cluster-Parameter für Befehlszeilenoperationen. Wenn Sie nur eine PostgreSQL auf Ihrem System verwenden oder sich nicht sicher sind, lassen Sie das Feld leer.';
$string['phpfloatproblem'] = 'Unerwartetes Problem bei der Verarbeitung von PHP-Dezimalzahlen (float) aufgetreten - {$a}';
$string['pid'] = 'PID';
$string['pleaserefreshregistration'] = 'Ihre Website ist registriert. Die Registrierung wurde zuletzt am {$a} aktualisiert. <br />Über die automatische Website-Registierung werden Ihre Daten regelmäßig aktualisiert. Sie können die Registrierung aber auch jederzeit manuell aktualisieren.';
$string['pleaserefreshregistrationnewdata'] = 'Die Registrierungsinformationen wurden geändert. Bestätigen Sie dies bitte durch Anklicken des Buttons \'Registrierung aktualisieren\'.';
$string['pleaserefreshregistrationunknown'] = 'Ihre Website ist registriert, aber das Registrierungsdatum ist unbekannt. Aktualisieren Sie deswegen Ihre Registrierung manuell oder aktivieren Sie die automatische Website-Registierung.';
$string['plugin'] = 'Plugin';
$string['plugin_disabled'] = '{$a} ist deaktiviert';
$string['plugin_enabled'] = '{$a} ist aktiviert';
$string['plugins'] = 'Plugins';
$string['pluginscheck'] = 'Plugin Abhängigkeitprüfung';
$string['pluginscheckfailed'] = 'Die Abhängigkeitprüfung ist fehlgeschlagen für {$a->pluginslist}';
$string['pluginschecktodo'] = 'Bevor Sie die Installation dieser Version fortführen können, müssen alle Plugin-Anforderungen gelöst sein.';
$string['pluginsoverview'] = 'Plugin-Übersicht';
$string['pluginsoverviewsee'] = 'Weitere Details in der <a href="{$a->url}">Plugin-Übersicht</a>.';
$string['policysettings'] = 'Richtlinieneinstellungen';
$string['privacy:metadata'] = 'Das Administrations-Plugin speichert keine personenbezogenen Daten.';
$string['privacyandpolicies'] = 'Datenschutz und Richtlinien';
$string['privacysettings'] = 'Datenschutzeinstellungen';
$string['profilecategory'] = 'Kategorie';
$string['profilecategoryname'] = 'Name der Kategorie (muss eindeutig sein)';
$string['profilecategorynamenotunique'] = 'Dieser Name wird bereits benutzt';
$string['profilecommonsettings'] = 'Grundeinstellungen';
$string['profileconfirmcategorydeletion'] = 'In dieser Kategorie gibt es {$a} Feld(er), die in die Kategorie darüber (oder darunter) verschoben werden. <br />Möchten Sie die Kategorie wirklich löschen?';
$string['profileconfirmfielddeletion'] = 'Für das zu löschende Feld gibt es {$a} Nutzereinträge. <br />Möchten Sie das Feld wirklich löschen?';
$string['profilecreatecategory'] = 'Neue Profilkategorie anlegen';
$string['profilecreatefield'] = 'Neues Profilfeld anlegen:';
$string['profilecreatenewcategory'] = 'Neue Kategorie anlegen';
$string['profilecreatenewfield'] = 'Neues Profilfeld \'{$a}\' anlegen';
$string['profiledefaultcategory'] = 'Weitere Felder';
$string['profiledefaultchecked'] = 'Bereits markiert';
$string['profiledefaultdata'] = 'Standardwert';
$string['profiledeletecategory'] = 'Kategorie löschen';
$string['profiledeletefield'] = 'Feld \'{$a}\' wird gelöscht';
$string['profiledescription'] = 'Beschreibung eines Feldes';
$string['profiledscript'] = 'Dieses Script wird gerade analysiert';
$string['profiledscriptview'] = 'Analyseinformationen für dieses Script anzeigen';
$string['profileeditcategory'] = 'Kategorie {$a} bearbeiten';
$string['profileeditfield'] = 'Profilfeld {$a} bearbeiten';
$string['profilefield'] = 'Profilfeld';
$string['profilefieldcolumns'] = 'Spalten';
$string['profilefieldispassword'] = 'Ist dies ein Kennwortfeld?';
$string['profilefieldlink'] = 'Link';
$string['profilefieldlink_help'] = 'Um den Text in einen Link umzuwandeln, geben Sie eine URL mit $$ an, wobei $$ durch den Text ersetzt wird. Um z.B. eine Twitter-ID in einen Link umzuwandeln, schreiben Sie https://twitter.com/$$.';
$string['profilefieldlinktarget'] = 'Verlinkungsziel';
$string['profilefieldmaxlength'] = 'Maximale Zeichenzahl';
$string['profilefieldmaxlength_help'] = 'Um dieses Feld in der Einstellung "Nutzeridentität anzeigen" zu verwenden, muss die Zeichenzahl 255 oder weniger sein.';
$string['profilefieldrows'] = 'Zeilen';
$string['profilefields'] = 'Profilfelder';
$string['profilefieldsize'] = 'Größe anzeigen';
$string['profileforceunique'] = 'Sollen die Daten eindeutig sein?';
$string['profileinvaliddata'] = 'Ungültiger Wert';
$string['profilelocked'] = 'Ist dieses Feld gesperrt?';
$string['profilemenudefaultnotinoptions'] = 'Der Standardwert entspricht keiner der Optionen';
$string['profilemenunooptions'] = 'Keine Menü-Option vorhanden';
$string['profilemenuoptions'] = 'Menü-Optionen (eine pro Zeile)';
$string['profilemenutoofewoptions'] = 'Sie müssen mindestens 2 Optionen angeben';
$string['profilename'] = 'Name';
$string['profilenofieldsdefined'] = 'Es wurden keine Felder definiert';
$string['profilerequired'] = 'Ist dieses Feld notwendig?';
$string['profileroles'] = 'Rollen im Profil anzeigen';
$string['profilesforenrolledusersonly'] = 'Profilzugriff nur für eingetragene Nutzer/innen';
$string['profileshortname'] = 'Kurzbezeichnung (muss eindeutig sein)';
$string['profileshortnameinvalid'] = 'Diese Kurzbezeichnung darf nur alphanumerische Zeichen und den Unterstrich (_) enthalten.';
$string['profileshortnamenotunique'] = 'Diese Kurzbezeichnung wird bereits benutzt';
$string['profilesignup'] = 'Auf der Registrierungsseite zeigen?';
$string['profilespecificsettings'] = 'Weitere Einstellungen';
$string['profilevisible'] = 'Für wen ist dieses Feld sichtbar?';
$string['profilevisible_help'] = '* Nicht sichtbar - Für private Daten, nur sichtbar für Administrator/innen und Manager/innen
* Sichtbar für Nutzer/in - Für private Daten, nur sichtbar für Nutzer/in und Administrator/innen
* Sichtbar für Nutzer/in, Trainer/innen und Administrator/innen - Für private Daten, nur sichtbar für Nutzer/in, Trainer/innen und Administrator/innen (im Kursprofil)
* Sichtbar für alle';
$string['profilevisibleall'] = 'Sichtbar für alle';
$string['profilevisiblenone'] = 'Nicht sichtbar';
$string['profilevisibleprivate'] = 'Sichtbar für Nutzer/in';
$string['profilevisibleteachers'] = 'Sichtbar für Nutzer/in, Trainer/innen und Administrator/innen';
$string['profiling'] = 'Analyse';
$string['profilingallowall'] = 'Kontinuierliche Analyse';
$string['profilingallowall_help'] = 'Wenn diese Option aktiviert ist, können Sie jederzeit den Parameter PROFILEALL überall benutzen (PGC), um die Analyse für alle ausgeführten Scripts einzuschalten. Analog dazu können Sie den Parameter PROFILEALLSTOP verwenden, um alles zu beenden.';
$string['profilingallowme'] = 'Selektive Analyse';
$string['profilingallowme_help'] = 'Wenn diese Option aktiviert ist, können Sie jederzeit den Parameter PROFILEME überall benutzen (PGC), um die Analyse für das ausgewählte Script einzuschalten. Analog dazu können Sie den Parameter DONTPROFILEME verwenden, um die Analyse zu unterbinden.';
$string['profilingautofrec'] = 'Automatische Analyse';
$string['profilingautofrec_help'] = 'Mit dieser Einstellung werden mehrere Einträge automatisch vorgenommen (u.z. zufällig auf der Basis der angegebenen Häufigkeit - 1 aus N). Der Ablauf wird zur weiteren Analyse gespeichert. Beachten Sie, dass dieser Analysetyp die Einstellungen include/exclude verwendet. Setzen Sie die Einstellung auf 0, um die automatische Analyse zu deaktivieren.';
$string['profilingenabled'] = 'Analyse aktivieren';
$string['profilingenabled_help'] = 'Wenn diese Option aktiviert ist, wird die Analyse von Scripts für die Website eingeschaltet. Sie können die Analysedurchführung mit weiteren Einstellungen festlegen.';
$string['profilingexcluded'] = 'Analyse ausschließen';
$string['profilingexcluded_help'] = 'Liste von URLs (Komma oder getrennte Zeilen, wwwroot wird übersprungen, erreichbar), die bei der Profilerstellung ausgeschlossen werden.';
$string['profilingimportprefix'] = 'Präfix für Analyse-Importe';
$string['profilingimportprefix_desc'] = 'Zur leichteren Erkennung erhalten alle Analyse-Importe den angegebenen Wert vorangestellt.';
$string['profilingincluded'] = 'Diese Scripts analysieren';
$string['profilingincluded_help'] = 'Liste von URLs (kommagetrennt oder in einzelnen Zeilen, wwwroot wird übersprungen, erreichbar), die bei der Profilerstellung automatisch verwandt werden. Beispiele: /index.php, /course/view.php. Akzeptiert wird auch eine * Wildcard an jeder Stelle. Beispiele: /mod/forum/*, /mod/*/view.php.';
$string['profilinglifetime'] = 'Analyseprotokolle speichern';
$string['profilinglifetime_help'] = 'Legen Sie den Zeitraum fest, über den Sie ältere Analyseprotokolle behalten möchten. Ältere Protokolle werden automatisch gelöscht. Beachten Sie, dass keines der Protokolle als Referenz markiert werden kann.';
$string['profilingslow'] = 'Profile verlangsamen die Seiten';
$string['profilingslow_help'] = 'Durch die Einstellung einer Mindestzeit für den Aufruf werden alle langsameren Seite profiliert. Nur im Vergleich zu bestehenden Profilen langsamere Seiten werden aufbewahrt. Die Einstellung \'0\' deaktiviert die Funktion.';
$string['protectusernames'] = 'Anmeldenamen schützen';
$string['proxybypass'] = 'Proxy für diese Server nicht verwenden';
$string['proxyfixunsafe'] = 'Aufrufe ohne Proxy korrigieren';
$string['proxyhost'] = 'Proxy-Server';
$string['proxylogunsafe'] = 'Aufrufe ohne Proxy protokollieren';
$string['proxypassword'] = 'Proxy-Kennwort';
$string['proxyport'] = 'Proxy-Port';
$string['proxytype'] = 'Proxy-Typ';
$string['proxyuser'] = 'Proxy-Anmeldename';
$string['purgecaches'] = 'Alle Caches löschen';
$string['purgecachesconfirm'] = 'Moodle kann Designs, JavaScript, Sprachstrings, gefilterten Text, RSS-Feeds und andere berechnete Daten zwischenspeichern. Durch das Leeren des Caches werden Daten vom Server gelöscht und Browser zum erneuten Abrufen gezwungen. So können Sie sicher sein, dass Ihnen die Werte des aktuellen Codes angezeigt werden. Das Leeren des Caches ist ungefährlich, Ihre Website kann jedoch vorübergehend langsamer erscheinen, bis Server und Clients neue Informationen berechnet und zwischengespeichert haben.';
$string['purgecachesfinished'] = 'Caches wurden gelöscht.';
$string['purgecachesnoneselected'] = 'Einen oder mehr Caches zum Löschen auswählen';
$string['purgecachespage'] = 'Caches löschen';
$string['purgecoursecache'] = 'Kurse';
$string['purgefiltercache'] = 'Textfilter';
$string['purgejscache'] = 'JavaScript';
$string['purgelangcache'] = 'Sprache';
$string['purgemuc'] = 'Alle MUC Caches';
$string['purgeothercaches'] = 'Alle Datei- und sonstigen Caches';
$string['purgeselectedcaches'] = 'Ausgewählte Caches löschen';
$string['purgeselectedcachesfinished'] = 'Die ausgewählten Caches wurden gelöscht.';
$string['purgetemplates'] = 'Vorlagen';
$string['purgethemecache'] = 'Design';
$string['query'] = 'Abfrage';
$string['question'] = 'Fragen';
$string['questionbehaviours'] = 'Frageverhalten';
$string['questioncwqpfscheck'] = 'Im Test sind eine oder mehrere \'Zufallsfragen\' so konfiguriert, dass Fragen aus einem Mix von freigegebenen und nichtfreigegebenen Fragenkategorien ausgewählt werden sollen. Lesen Sie dazu bitte den <a href="{$a->reporturl}"> Bericht zu den Zufallsfragen</a> und die
<a href="{$a->docsurl}"> Moodle Dokumentation</a>.';
$string['questioncwqpfsok'] = 'Gut. Keine der \'Zufallsfragen\' in Ihren Tests ist so konfiguriert, dass
Fragen aus einem Mix von freigegebenen und nicht freigegebenen Fragenkategorien ausgewählt werden könnten.';
$string['questiontype'] = 'Fragetyp';
$string['questiontypes'] = 'Fragetypen';
$string['quizattemptsupgradedmessage'] = 'In Moodle 2.1 gab es eine umfangreiche Aktualisierung für die Testfragen. Es war allerdings möglich, die Aktualisierung teilweise zu einem späteren Zeitpunkt auszuführen. Vor dem Upgrade auf Moodle 2.7 muss diese Aktualisierung abgeschlossen sein.';
$string['recaptchaprivatekey'] = 'ReCaptcha: Secret  Key';
$string['recaptchapublickey'] = 'ReCaptcha: Site Key';
$string['referrernone'] = 'Browser-Standard';
$string['referrerpolicy'] = 'Referrer-Richtlinie';
$string['referrerpolicydesc'] = 'Legen Sie die Kopfzeile mit der Referrer-Richtlinie so fest, dass sie in die Antworten Ihrer Website aufgenommen wird.';
$string['register'] = 'Website registrieren';
$string['registration'] = 'Registrierung';
$string['registration_help'] = 'Mit der Registrierung Ihrer Website:

* erhalten Sie von uns Sicherheitswarnungen für Moodle
* können Sie Push-Mitteilungen für die mobile App aktivieren
* tragen Sie zu unserer weltweiten Moodle-Statistik bei';
$string['registrationwarning'] = 'Verpassen Sie keine wichtigen Updates und Sicherheitswarnungen.';
$string['registrationwarningcontactadmin'] = 'Diese Website ist nicht registriert. Bitten Sie die Administrator/innen, die Webbsite zu registrieren, damit sie keine wichtigen Updates und Sicherheitswarnungen verpassen.';
$string['releasenoteslink'] = 'Weitere Informationen über diese Version finden Sie online: <a target="_blank" href="{$a}">Versionsinformation</a>';
$string['rememberuserlicensepref'] = 'Lizenzeinstellung merken';
$string['rememberuserlicensepref_help'] = 'Diese Einstellung legt fest, dass die zuletzt von einer Person ausgewählte Lizenz beim nächsten Laden in der Dateiauswahl vorausgewählt ist. Andernfalls wird die eingestellte Standardlizenz der Webseite vorausgewählt.';
$string['rememberusername'] = 'Anmeldenamen merken';
$string['rememberusername_desc'] = 'Aktivieren Sie diese Option, wenn Sie für das Login den Anmeldenamen in einem Cookie speichern möchten. Cookies könnten als Datenschutzrisiko betrachtet werden, wenn man sie ohne Information verwendet.';
$string['replacefrontsearch'] = 'Wird für die Kurssuche auf der Startseite verwendet';
$string['reportsmanage'] = 'Berichte verwalten';
$string['required'] = 'Notwendig';
$string['requiredentrieschanged'] = 'Hinweis: Nach dem Upgrade wird die Funktion \'Erforderliche Einträge vor Zugriff\' nun erzwungen für die folgenden Datenbankeinträge:<br/>{$a->text}<br/>';
$string['requiremodintro'] = 'Beschreibung notwendig';
$string['requiremodintro_desc'] = 'Diese Option legt fest, dass für jede Aktivität eine Beschreibung angegeben werden muss.';
$string['requires'] = 'Erfordernisse';
$string['resetindentation'] = 'Einzug seitenweit zurücksetzen';
$string['resetindentation_help'] = 'Hiermit werden alle zuvor für Kurse im {$a->format} gesetzten Einzüge entfernt.';
$string['resetindentation_title'] = 'Einzug seitenweit zurücksetzen?';
$string['resetindentationsuccess'] = 'Einzug zurückgesetzt.';
$string['restorecourse'] = 'Kurs wiederherstellen';
$string['restorernewroleid'] = 'Rolle für Wiederhersteller/in in Kursen';
$string['restorernewroleid_help'] = 'Wenn eine Person nicht bereits das Recht zum Verwalten des neu wiederhergestellten Kurses hat, wird die hier angegebene Rolle zugewiesen. Die Person wird u.U. dabei automatisch in den Kurs eingeschrieben. Wählen Sie \'keine\' falls bei der Wiederherstellung nicht automatisch eine Rolle im Kurs zugewiesen werden soll.';
$string['resultfilter'] = 'Filtern nach  Ergebnissen';
$string['reverseproxy'] = 'Reverse Proxy';
$string['reverseproxyignore'] = 'Reverse-Proxys ignorieren';
$string['riskconfig'] = 'Nutzer/innen könnten Einstellungen für die Website und das Erscheinungsbild verändern.';
$string['riskconfigshort'] = 'Konfigurationsrisiko';
$string['riskdataloss'] = 'Nutzer/innen könnten große Mengen von Inhalten und Informationen zerstören';
$string['riskdatalossshort'] = 'Risiko des Datenverlusts';
$string['riskmanagetrust'] = 'Nutzer/innen könnten die Vertrauenseinstellungen anderer Nutzer/innen verändern.';
$string['riskmanagetrustshort'] = 'Vertrauenseinstellungen verwalten';
$string['riskpersonal'] = 'Nutzer/innen könnten Zugang zu persönlichen Informationen anderer Nutzer/innen erhalten.';
$string['riskpersonalshort'] = 'Datenschutzrisiko';
$string['riskspam'] = 'Nutzer/innen könnten Spam-Mails an andere  Nutzer/innen oder externe Adressen senden.';
$string['riskspamshort'] = 'Spam-Gefahr';
$string['riskxss'] = 'Nutzer/innen könnten Dateien und Texte einfügen, die Cross-Website-Scripting (XSS) ermöglichen.';
$string['riskxssshort'] = 'RISK_XSS';
$string['roleswithexceptions'] = '{$a->roles}, mit {$a->exceptions}';
$string['rssglobaldisabled'] = 'Auf Serverebene deaktiviert';
$string['save'] = 'Speichern';
$string['savechanges'] = 'Änderungen speichern';
$string['scssinvalid'] = 'Der SCSS-Code ist nicht gültig. Folgender Fehler ist aufgetreten: {$a}';
$string['search'] = 'Suchen';
$string['searchablecourses'] = 'Durchsuchbare Kurse';
$string['searchallavailablecourses'] = 'Durchsuchbare Kurse';
$string['searchallavailablecourses_desc'] = 'In einigen Situationen kann die Suchmaschine nicht bei der Suche über eine große Anzahl von Kursen arbeiten. Suchen Sie nur nach  Kursen in denen sie eingeschrieben sind, wenn Sie die Anzahl der gesuchten Kurse einschränken müssen.';
$string['searchallavailablecourses_off'] = 'Suche in Kursen, in denen die Person eingeschrieben ist';
$string['searchallavailablecourses_on'] = 'Suche in Kursen, auf die die Person zugreifen kann';
$string['searchallavailablecoursesdesc'] = 'Wenn die Suche nur in Kursen, in denen die Person eingeschrieben ist aktiviert ist, werden Kursinformationen (Name und Beschreibung) und Kursinhalte nur in Kursen gesucht, in denen der/die Nutzer/in eingeschrieben ist. Andernfalls werden Kursinformationen und Kursinhalte in allen Kursen gesucht, auf die der/die Nutzer/in Zugriff hat, wie z.B. Kurse mit aktiviertem Gastzugang.';
$string['searchalldeleted'] = 'Alle indizierten Inhalte wurden gelöscht';
$string['searchalternatesettings'] = 'Alternativer Einstellungen';
$string['searchalternatesettings_desc'] = 'Wenn Sie diese Einstellungen vorgenommen haben, können Sie in der Option "Nur Abfrage suchen" auf der Seite "Globale Suche verwalten" die Option "Alternative Einstellungen" für diese Suchmaschine auswählen. Dies ist nur nützlich, wenn Sie zwischen zwei Suchmaschinen desselben Typs wechseln.';
$string['searchareadisabled'] = 'Suchbereich deaktiviert';
$string['searchareaenabled'] = 'Suchbereich aktiviert';
$string['searchareas'] = 'Suchbereiche';
$string['searchbanner'] = 'Suchinformation';
$string['searchbannerenable'] = 'Suchinformation anzeigen';
$string['searchbannerenable_desc'] = 'Wenn diese Option aktiviert ist, wird der folgende Text für alle Nutzer/innen im Suchbildschirm angezeigt. Dies kann verwendet werden, um Nutzer/innen zu informieren, wenn eine Suchmaschinenwartung durchgeführt wird.';
$string['searchdefaultcategory'] = 'Standardsuchkategorie';
$string['searchdefaultcategory_desc'] = 'Ergebnisse der ausgewählten Kategorie von Suchbereichen werden angezeigt.';
$string['searchdeleteindex'] = 'Alle indizierten Inhalte löschen';
$string['searchdisplay'] = 'Anzeige von Suchergebnissen';
$string['searchenablecategories'] = 'Ergebnisse in getrennten Kategorien anzeigen';
$string['searchenablecategories_desc'] = 'Bei Aktivierung werden Suchergebnisse in einzelnen Kategorien angezeigt';
$string['searchengine'] = 'Suchmaschine';
$string['searchenginealternatesettings'] = '{$a} (alternative Einstellungen)';
$string['searchenginequeryonly'] = 'Suchmaschine nur für Suchanfragen';
$string['searchenginequeryonly_desc'] = 'Diese Suchmaschine wird nur für Suchanfragen genutzt, nicht für die Indizierung. Benutzt man diese Einstellung, kann man mit einer anderen Suchmaschine den index erzeugen, während Suchanfragen von Nutzer/innen weiterhin von dieser hier bearbeitet werden.';
$string['searchenginequeryonly_none'] = 'Keine (Hauptsuche für Anfragen verwenden)';
$string['searchenginequeryonlysame'] = 'Für die Suchmaschine, die nur für Suchanfragen verwendet wird, und die Hauptsuchmaschine können nicht die gleichen Werte gesetzt werden.';
$string['searchhideallcategory'] = 'Kategorie \'Alle Ergebnisse\' verbergen';
$string['searchhideallcategory_desc'] = 'Bei Aktivierung wird die Kategorie mit allen Ergebnissen bei der Anzeige der Suchergebnisse verborgen.';
$string['searchincludeallcourses'] = 'Alle sichtbaren Kurse einbeziehen';
$string['searchincludeallcourses_desc'] = 'Diese Option legt fest, dass die Suchergebnisse die Kursinformationen (Name und Beschreibung) von Kursen einbezieht, die für eine Person sichtbar sind, egal ob sie auf die Kursinhalte zugreifen kann.';
$string['searchindexactions'] = 'Indizierungsaktionen';
$string['searchindexdeleted'] = 'Indizierung gelöscht';
$string['searchindextime'] = 'Zeitlimit für Indizierung';
$string['searchindextime_desc'] = 'Bei der Indizierung großer Datenmengen wird der regelmäßige Task nach Ablauf des Zeitlimits angehalten und beim nachfolgenden Durchlauf fortgesetzt.';
$string['searchindexupdated'] = 'Suchmaschineninhalte wurden aktualisiert';
$string['searchindexwhendisabled'] = 'Indizierung wenn deaktiviert';
$string['searchindexwhendisabled_desc'] = 'Diese Option erlaubt dem regelmäßigen Task, den Suchindex auch bei deaktivierter Suche zu erstellen. Dies ist sinnvoll, wenn der Index erstellt werden soll, bevor die Suchfunktion den Nutzer/innen angezeigt wird.';
$string['searchinsettings'] = 'In den Einstellungen suchen';
$string['searchlastrun'] = 'Letzter Durchgang (Zeit, # Dokumente, # Einträge, # Ignorierungen)';
$string['searchmanagement'] = 'Suchverwaltung';
$string['searchmanagement_desc'] = 'Diese Optionen sind nützlich, wenn Sie Änderungen an Websites mit sehr großen Suchindizes vornehmen, deren Wiederherstellung lange dauert.';
$string['searchmaxtopresults'] = 'Maximal beste Ergebnisse';
$string['searchmaxtopresults_desc'] = 'Die maximale Anzahl der am höchsten bewerteten Ergebnisse, die über den Suchergebnissen für Kursinhalte, Kurse und Nutzer/innen angezeigt werden.';
$string['searchnotavailable'] = 'Suche ist nicht verfügbar';
$string['searchoptions'] = 'Suchoptionen';
$string['searchpartial'] = '(bisher nicht vollständig indiziert)';
$string['searchreindexed'] = 'Alle Inhalte der Website wurden neu indiziert.';
$string['searchreindexindex'] = 'Alle Inhalte der Website neu indizieren';
$string['searchresults'] = 'Suchergebnisse';
$string['searchsetupinfo'] = 'Einstellungen zur Suche';
$string['searchteacherroles'] = 'Trainerrollen';
$string['searchteacherroles_desc'] = 'Wählen Sie alle Rollen aus, die Nutzer/innen im Rollenrang in den Suchergebnissen höher machen.';
$string['searchtopresults'] = 'Beste Ergebnisse';
$string['searchupdateindex'] = 'Indizierte Inhalte aktualisieren';
$string['sectionerror'] = 'Bereichsfehler!';
$string['secureforms'] = 'Erweiterte Formularsicherheit benutzen';
$string['security'] = 'Sicherheit';
$string['selectsearchengine'] = 'Suchmaschine auswählen';
$string['server'] = 'Server';
$string['serverchecks'] = 'Server-Überprüfung';
$string['serverlimit'] = 'Server-Grenze';
$string['servicespage'] = 'Link "Dienste und Support"';
$string['sessionautostartwarning'] = '<p> Schwerwiegender Konfigurationsfehler entdeckt. Bitte Server Administrator/in informieren.</p><p>Für eine korrekte Funktionsweise ist eine Änderung von PHP-Einstellung für Moodle erforderlich. </p><p><code>session.auto_start</code> muss auf <code>off</code> gesetzt werden.</p><p>Die Einstellung erfolgt in der <code>php.ini</code>-Datei, in der <br /> Apache/IIS Konfiguration oder der <code>.htaccess</code>-Datei auf dem Server.</p>';
$string['sessioncookie'] = 'Cookie-Zusatz';
$string['sessioncookiedomain'] = 'Cookie-Domain';
$string['sessioncookiepath'] = 'Cookie-Pfad';
$string['sessionhandling'] = 'Sitzungsinformation';
$string['sessiontimeout'] = 'Zeitüberschreitung';
$string['sessiontimeoutwarning'] = 'Warnung wegen Zeitüberschreitung';
$string['settingdependenton'] = 'Diese Einstellung könnte verborgen sein, abhängig vom Wert von <strong>{$a}</strong>.';
$string['settingfileuploads'] = 'Datei-Upload ist für die normale Nutzung nötig - bitte aktivieren Sie dies in den PHP-Einstellungen.';
$string['settingmaxinputvars'] = 'Die PHP-Einstellung max_input_vars sollte mindestens 5000 sein.';
$string['settingmaxinputvarsrequired'] = 'Die PHP-Einstellung max_input_vars muss mindestens 5000 sein.';
$string['settingmemorylimit'] = 'Unzureichende Speicherzuweisung - bitte setzen Sie eine höhere Speichergrenze memory_limit in den PHP-Einstellungen.';
$string['settingsafemode'] = 'Moodle ist nicht vollständig kompatibel mit dem Safe Mode. Bitten Sie Ihre/n Server-Administrator/in, diesen Modus auszuschalten. Rechnen Sie mit verschiedenen Problemen, falls Sie Moodle mit eingeschaltetem Safe Mode installieren.';
$string['settingzendexceptionignoreargs'] = 'Aus Sicherheitsgründen wird dringend empfohlen, die PHP-Einstellung zend.exception_ignore_args zu aktivieren.';
$string['setupsearchengine'] = 'Einstellungen für die Suchmaschine';
$string['showcommentscount'] = 'Kommentarzähler anzeigen';
$string['showdetails'] = 'Details anzeigen';
$string['showuseridentity'] = 'Nutzeridentität anzeigen';
$string['showuseridentity_desc'] = 'Bei der Nutzersuche und in Nutzerlisten werden diese Felder zusätzlich zum Namen angezeigt. Die Felder sind nur sichtbar für Nutzer/innen mit der Berechtigung moodle/site:viewuseridentity; normalerweise sind dies Trainer/innen und Manager/innen. (Die Option ist sinnvoll, wenn eines oder mehrere der gewählten Felder in Ihrer Institution als Pflichtfelder vorhanden sind, bsp. für die Bezeichnung einer Klasse.)

Mit * gekennzeichnete Felder sind seitenspezifische Nutzerprofilfelder. Sie können diese Felder auswählen, aber es gibt derzeit einige Ansichten, auf denen sie nicht angezeigt werden.';
$string['simplexmlrequired'] = 'Die PHP-Extension SimpleXML wird benötigt.';
$string['sitemailcharset'] = 'E-Mail-Zeichensatz';
$string['sitemaintenance'] = 'Wartungsmodus: Die Website ist momentan nicht verfügbar!';
$string['sitemaintenancemode'] = 'Wartungsmodus';
$string['sitemaintenanceoff'] = 'Der Wartungsmodus wurde beendet. Die Website ist wieder verfügbar.';
$string['sitemaintenanceon'] = 'Die Website ist momentan im Wartungsmodus. Die Anmeldung ist ausschließlich für Administrator/innen möglich.';
$string['sitemaintenanceoncli'] = 'Ihr System ist derzeit im CLI-Wartungsmodus. Ein Zugriff aus dem Internet ist nicht möglich.';
$string['sitemaintenancetitle'] = '{$a} wird gewartet';
$string['sitemaintenancewarning'] = 'Die Website ist momentan im Wartungsmodus. Die Anmeldung ist ausschließlich für Administrator/innen möglich. <br /><a href="maintenance.php"> Wartungsmodus beenden </a>.';
$string['sitemaintenancewarning2'] = 'Die Website ist momentan im Wartungsmodus. Die Anmeldung ist ausschließlich für Administrator/innen möglich. <br /><a href="{$a}"> Wartungsmodus beenden </a>.';
$string['sitemenubar'] = 'Site-Navigation';
$string['sitenameintitle'] = 'Website-Namen in den Seitentitel einbeziehen';
$string['sitenameintitle_help'] = 'Mit dieser Einstellung wird der Website-Name am Ende des Seitentitels angehängt. Es wird empfohlen, den Website-Namen in den Seitentitel aufzunehmen, da dies die Barrierefreiheit der Website verbessert. Die besuchte Website ist so schnell zu identifizieren.';
$string['sitepolicies'] = 'Sicherheitseinstellungen';
$string['sitepolicy'] = 'URL zur Datenschutzinformation';
$string['sitepolicy_help'] = 'Wenn Sie eine Datenschutzrichtlinie verwenden, die alle Personen vor der Nutzung der Website akzeptieren müssen, können Sie hier die URL angeben. Die Einstellung ist nur wirksam, wenn die Methode Standard (core) eingestellt ist.';
$string['sitepolicyguest'] = 'URL zur Datenschutzinformation für Gäste';
$string['sitepolicyguest_help'] = 'Wenn Sie eine Datenschutzinformation verwenden, die alle Gäste vor der Nutzung der Website akzeptieren müssen, können Sie hier die URL angeben. Die Einstellung ist nur wirksam, wenn die Methode Standard (core) gewählt wurde.<br><br>
Diese Einstellung kann jede öffentliche URL enthalten. Probleme könnte es mit der Option \'Anmeldung notwendig\' geben, weil nicht angemeldete Personen keinen Zugriff auf Dateien der Website haben.';
$string['sitepolicyhandler'] = 'Datenschutz der Website';
$string['sitepolicyhandler_desc'] = 'Wählen Sie die Komponente aus, um die Bestätigung der  Datenschutzvorgaben der Website einzuholen. Die Standardverarbeitung bietet eine einfache Funktionalität, gesteuert durch die beiden weiteren Einstellungen \'sitepolicy\' und \'sitepolicyguest\'. Die erweiterte Funktion ermöglich die Bestimmungen besser zu verwalten, die Nutzer zu informieren, ihre Einwilligung einzuholen und die Zustimmung bei Kindern (unter 16 Jahre) zu verwalten.';
$string['sitepolicyhandlercore'] = 'Standard (Core)';
$string['sitepolicyhandlerplugin'] = '{$a->name} ({$a->component})';
$string['sitesectionhelp'] = 'Auf der Startseite wird oben ein Bereich einbezogen, wo Sie angepasste Inhalte, Texte und Bilder, aber auch Ressourcen und Aktivitäten hinzufügen können.';
$string['sixtyfourbitsrequired'] = 'Es wurde festgestellt, dass Ihre Website keine 64-Bit-PHP-Version verwendet. Sie müssen Ihr System (Betriebssystem, PHP...) aktualisieren, bevor Sie diese Moodle-Version installieren.';
$string['sixtyfourbitswarning'] = 'Ihre Website verwendet keine 64-Bit-Version für PHP. Es wird empfohlen, die Website zu aktualisieren, um die zukünftige Kompatibilität sicherzustellen.';
$string['slasharguments'] = 'Slash-Parameter benutzen';
$string['slashargumentswarning'] = 'Es wird empfohlen, die Verwendung von Schrägstrich-Argumenten zu aktivieren. Zukünftig wird dies erforderlich sein. Weitere Einzelheiten finden Sie in der Dokumentation <a href="https://docs.moodle.org/en/admin/environment/slasharguments">Schrägstrich-Argumente</a> .';
$string['smallscreensonly'] = 'Nur kleine Bildschirme';
$string['smtp'] = 'SMTP';
$string['smtpauthtype'] = 'SMTP-Authentifizierung';
$string['smtpdetail'] = 'Einstellungen für SMTP (Simple Mail Transfer Protocol) zum Versand von E-Mails';
$string['smtphosts'] = 'SMTP-Server';
$string['smtpmaxbulk'] = 'Limit für SMTP-Session';
$string['smtppass'] = 'SMTP-Kennwort';
$string['smtpsecure'] = 'SMTP-Sicherheit';
$string['smtpuser'] = 'SMTP-Anmeldename';
$string['soaprecommended'] = 'Die PHP-Extension soap sollte für Webservices und Plugins installiert sein.';
$string['sort_fullname'] = 'Vollständiger Kursname';
$string['sort_idnumber'] = 'Kurs-ID';
$string['sort_shortname'] = 'Kurzer Kursname';
$string['sort_sortorder'] = 'Sortierung';
$string['spellengine'] = 'Rechtschreibprüfung';
$string['spelllanguagelist'] = 'Liste zur Rechtschreibkontrolle';
$string['splrequired'] = 'Die PHP-Extension SPL wird benötigt.';
$string['stats'] = 'Statistiken';
$string['statsfirstrun'] = 'Maximale Verarbeitungsdauer';
$string['statsmaxruntime'] = 'Maximale Laufzeit';
$string['statsmoodleorg'] = 'Statistiken';
$string['statsruntimedays'] = 'Tage für Berechnung';
$string['statsruntimestart'] = 'Ausführung um';
$string['statsuserthreshold'] = 'Schwelle für die Nutzerzahl';
$string['stickyblocks'] = 'Feste Blöcke';
$string['stickyblockscourseview'] = 'Kursseite';
$string['stickyblocksduplicatenotice'] = 'Wenn Sie einen Block hier hinzufügen, so steht eine Kopie auf jeder einzelnen Seite zur Verfügung.<br />Der unveränderliche Block lässt sich nicht bearbeiten und nicht verschieben. Ein Duplikat des Blocks können Sie jedoch verändern und an einem beliebigen Platz ablegen.';
$string['stickyblocksmymoodle'] = 'Dashboard';
$string['stickyblockspagetype'] = 'Seitentyp zum Konfigurieren';
$string['storedprogressbarcleanuptask'] = 'Task zum Bereinigen des gespeicherten Fortschrittsbalkens';
$string['strictformsrequired'] = 'Strenge Prüfung der Pflichtfelder';
$string['stripalltitletags'] = 'HTML-Tags aus allen Aktivitätsnamen entfernen';
$string['supportandservices'] = 'Support und Dienstleistungen';
$string['supportavailability'] = 'Supportverfügbarkeit';
$string['supportcontact'] = 'Supportanfragen';
$string['supportemail'] = 'Support-Mail';
$string['supportemailsubject'] = 'Website-Supportanfrage - {$a}';
$string['supportname'] = 'Support-Name';
$string['supportpage'] = 'Link "Support kontaktieren"';
$string['suspenduser'] = 'Nutzerkonto sperren';
$string['swaggerui'] = 'Moodle REST API UI (SwaggerUI)';
$string['switchlang'] = 'Verzeichnis wechseln';
$string['systempaths'] = 'Systempfade';
$string['tablenosave'] = 'Änderungen in der obigen Tabelle werden automatisch gespeichert.';
$string['tablesnosave'] = 'Änderungen in den obigen Tabellen werden automatisch gespeichert.';
$string['tabselectedtofront'] = 'Tabellen mit Tabs: Soll die Reihe mit dem aktiven Tabulator im Vordergrund platziert werden?';
$string['tabselectedtofronttext'] = 'Ausgewählte Reihe nach vorne holen';
$string['task_adhoc_concurrency_limit'] = 'Limit für gleichzeitige Ad-hoc-Tasks';
$string['task_adhoc_concurrency_limit_desc'] = 'Anzahl der zeitgleich laufenden Ad-hoc-Tasks. Wenn der Wert zu hoch gesetzt wird und viele Ad-hoc-Tasks abgearbeitet werden müssen, könnten reguläre Tasks verzögert ausgeführt werden. Der Wert \'0\' verhindert das Ausführen von Ad-hoc-Tasks vollständig.';
$string['task_adhoc_failed_retention'] = 'Aufbewahrungsfrist für Ad-hoc-Task fehlgeschlagen';
$string['task_adhoc_failed_retention_desc'] = 'Die maximale Zeit, in der fehlgeschlagene Ad-hoc-Aufgaben in der Warteschlange verbleiben sollten, sobald sie ihr Wiederholungslimit erreicht haben.';
$string['task_adhoc_max_runtime'] = 'Laufzeit für Ad-hoc-Tasks';
$string['task_adhoc_max_runtime_desc'] = 'Die Zeit, während der ein Ad-hoc-Task lebt, bevor er freigegeben wird. Eine niedrige Laufzeit wird empfohlen falls keine Begrenzung der Zahl festgelegt wurde. Wenn die Zahl zu hoch ist und sehr viele Ad-hoc-Tasks ausgeführt werden sollen, kann die Ausführung der geplanten Vorgänge verzögert werden.';
$string['task_dbreads'] = 'Lesezugriffe auf die Datenbank';
$string['task_dbstats'] = 'Datenbank';
$string['task_dbwrites'] = 'Schreibzugriffe auf die Datenbank';
$string['task_duration'] = 'Dauer';
$string['task_endtime'] = 'Endzeit';
$string['task_logmode'] = 'Wann geloggt wird';
$string['task_logmode_all'] = 'Ausgabe aller Vorgänge loggen';
$string['task_logmode_desc'] = 'Sie können auswählen wann Log-Prozesse erfolgen sollen.  In der Standardeinstellung werden Logs immer erzeugt. Sie können Logs gänzlich unterbinden oder nur Logs bei Fehlerhaften Einlogprozessen nutzen.';
$string['task_logmode_failonly'] = 'Nur fehlgeschlagene Vorgänge loggen';
$string['task_logmode_none'] = 'Gar nichts loggen';
$string['task_logoutput'] = 'Task-Output';
$string['task_logretainruns'] = 'Wiederholungsdurchläufe';
$string['task_logretainruns_desc'] = 'Zahl der erneuten Versuche für einen Task. Die Einstellung korrespondiert mit der Aufbewahrungsfrist, gültig ist was zuerst eintritt.';
$string['task_logretention'] = 'Aufbewahrungsfrist';
$string['task_logretention_desc'] = 'Höchstdauer der Aufbewahrung von Logs. Die Einstellung korrespondiert mit der Einstellung für Wiederholungsdurchläufe.';
$string['task_logtostdout'] = 'Logdaten anzeigen';
$string['task_logtostdout_desc'] = 'Wenn Prozesse laufen und die Ausgabe erfasst wird, wird festgelegt, ob die erfasste Ausgabe auch in den Tasks angezeigt werden soll.';
$string['task_result'] = 'Ergebnis';
$string['task_result:failed'] = 'Fehlgeschlagen';
$string['task_scheduled_concurrency_limit'] = 'Beschränkung für zeitgleiche terminierte Aufträge';
$string['task_scheduled_concurrency_limit_desc'] = 'Die Anzahl zeitgleich ausführbarer Aufträge. Eine hohe Anzahl kann zu hohen Belastungen des Servers führen. Dadurch können andere Anfragen verzögert werden. Der Wert \'0\' bedeutet, dass terminierte Aufträge deaktiviert werden.';
$string['task_scheduled_max_runtime'] = 'Laufzeit für zeitgleich ausführbare Aufträge';
$string['task_scheduled_max_runtime_desc'] = 'Die Zeit, während der ein zeitgleich ausführbarer Auftrag lebt, bevor er freigegeben wird.';
$string['task_starttime'] = 'Anfangszeit';
$string['task_stats:dbreads'] = '{$a} Lesevorgänge';
$string['task_stats:dbwrites'] = '{$a} Schreibvorgänge';
$string['task_status'] = 'Task-Status';
$string['task_status_desc'] = 'Die Task \'{$a->name}\' ist {$a->status}. Details finden Sie in {$a->class}{$a->extradescription} in <a href="{$a->gotourl}">Geplante Tasks</a>.';
$string['task_type:adhoc'] = 'Ad-hoc';
$string['task_type:scheduled'] = 'Terminiert';
$string['taskadmintitle'] = 'Tasks';
$string['taskanalyticscleanup'] = 'Analytics-Bereinigung';
$string['taskautomatedbackup'] = 'Automatische Sicherungen';
$string['taskautomatedbackup_report'] = 'Bericht über automatische Sicherungen';
$string['taskbackupcleanup'] = 'Tabellen, Logdaten und Dateien für Sicherungen bereinigen';
$string['taskbadgesadhoc'] = 'Badge verleihen';
$string['taskbadgescron'] = 'Ad-hoc-Aufgaben für Badges hinzufügen';
$string['taskbadgesmessagecron'] = 'Hintergrundprozess für Badge-Mitteilungen';
$string['taskblogcron'] = 'Externe Blogs synchronisieren';
$string['taskcachecleanup'] = 'Abgelaufene Cache-Einträge entfernen';
$string['taskcachecron'] = 'Hintergrundprozess für Caches';
$string['taskcalendarcron'] = 'Systemnachrichten zu Kalendereinträgen senden';
$string['taskcheckforupdates'] = 'Auf Aktualisierungen prüfen';
$string['taskcompletiondaily'] = 'Abschlussmarkierung wenn begonnen';
$string['taskcompletionregular'] = 'Normale Abschlussdaten berechnen';
$string['taskcontextcleanup'] = 'Kontexte bereinigen';
$string['taskcreatecontexts'] = 'Fehlende Kontexte erzeugen';
$string['taskdeleteincompleteusers'] = 'Unvollständige Nutzerprofile löschen';
$string['taskdeleteunconfirmedusers'] = 'Unbestätigte Nutzerprofile löschen';
$string['taskeventscron'] = 'Hintergrundprozess für Ereignisse';
$string['taskfiletrashcleanup'] = 'Dateien endgültig löschen';
$string['taskglobalsearchindex'] = 'Indizierung für die globale Suche';
$string['taskglobalsearchoptimize'] = 'Index für Globale Suche optimieren';
$string['taskgradecron'] = 'Hintergrundprozess für Bewertungen';
$string['taskgradehistorycleanup'] = 'Hintergrundprozess zur Bereinigung alter Bewertungstabellen';
$string['taskh5pcleanup'] = 'Bereinigung nicht verwendeter H5P-Dateien';
$string['tasklegacycron'] = 'Legacy Cron für Plugins';
$string['tasklockcleanuptask'] = 'Metadaten der Ad-hoc-Tasks bereinigen';
$string['tasklogcleanup'] = 'Bereinigung der Task-Logdaten';
$string['tasklogging'] = 'Task-Logkonfiguration';
$string['tasklogs'] = 'Task-Logdaten';
$string['taskmessagingcleanup'] = 'Hintergrundprozess für Mitteilungen';
$string['taskpasswordresetcleanup'] = 'Kennwortanforderungen löschen';
$string['taskplagiarismcron'] = 'Hintergrundprozess für den Legacy Cron in Plagiat-Plugins';
$string['taskportfoliocron'] = 'Hintergrundprozess für Portfolio-Plugins';
$string['taskprocessing'] = 'Task-Verarbeitung';
$string['taskquestioncron'] = 'Hintergrundprozess um Fragen-Vorschauen zu löschen';
$string['taskquestionstatscleanupcron'] = 'Hintergrundprozess zum Löschen von Fragestatistik-Caches';
$string['taskrefreshsystemtokens'] = 'OAuth-Token für Servicekonten erneuern';
$string['taskregistrationcron'] = 'Website-Registrierung';
$string['tasksendfailedloginnotifications'] = 'Systemnachricht zu fehlgeschlagenen Anmeldeversuchen senden';
$string['tasksendnewuserpasswords'] = 'Neues Nutzerkennwort senden';
$string['tasksessioncleanup'] = 'Alte Sessions bereinigen';
$string['taskstatscron'] = 'Hintergrundprozess für Statistiken';
$string['tasktagcron'] = 'Hintergrundprozess für Tags';
$string['tasktempfilecleanup'] = 'Veraltete temporäre Dateien löschen';
$string['tasktype'] = 'Typ';
$string['taskupdategeoip2file'] = 'GeoIP-Datei aktualisieren';
$string['tempdatafoldercleanup'] = 'Temporäre Dateien löschen, wenn älter als';
$string['templates'] = 'Vorlagen';
$string['testoutgoingmailconf'] = 'Test für ausgehende E-Mails';
$string['testoutgoingmailconf_errorcommunications'] = 'Die Website kann nicht mit dem E-Mail-Server kommunizieren. Überprüfen Sie die Konfiguration für die ausgehenden E-Mails.';
$string['testoutgoingmailconf_fromemail'] = 'Von Anmeldename oder E-Mail-Adresse';
$string['testoutgoingmailconf_fromemail_help'] = 'Dieses Feld emuliert das Senden der Mitteilung von diesem Absender. Ob der From-Header in der echten gesendeten E-Mail verwendet wird, hängt von anderen Einstellungen ab, wie z.B. von allowedemaildomains';
$string['testoutgoingmailconf_fromemail_invalid'] = 'Ungültiger Eintrag "Von Anmeldename oder E-Mail-Adresse". Der Eintrag muss ein gültiges E-Mail-Format haben oder ein vorhandener Nutzername in diesem Moodle sein.';
$string['testoutgoingmailconf_message'] = 'Mit dieser Testmitteilung wird überprüft, ob der Server für ausgehende E-Mails der Website erfolgreich konfiguriert wurde. Gesendet: {$a}';
$string['testoutgoingmailconf_sendtest'] = 'Testmitteilung senden';
$string['testoutgoingmailconf_sentmail'] = 'Die Website hat erfolgreich eine Testnachricht an den E-Mail-Server gesendet. <br />Von: {$a->fromemail}<br />An: {$a->toemail}';
$string['testoutgoingmailconf_subject'] = '{$a->site}: Testmitteilung. {$a->additional} gesendet: {$a->time}';
$string['testoutgoingmailconf_subjectadditional'] = 'Zusätzlicher Betreff';
$string['testoutgoingmailconf_toemail'] = 'An E-Mail-Adresse';
$string['testoutgoingmaildetail'] = 'Hinweis: Vor dem Testen müssen Sie die Konfiguration speichern.<br />{$a}';
$string['testsiteupgradewarning'] = 'Sie verwenden derzeit die Testseite {$a}. Um ein korrektes Upgrade durchzuführen, verwenden SIe die Befehlszeile.';
$string['themedefinedinconfigphp'] = 'Das Design kann nicht geändert werden, weil es in der config.php auf {$a} gesetzt ist.';
$string['themedesignermode'] = 'Modus zur Designbearbeitung';
$string['themedesignermodewarning'] = 'Theme-Designer-Modus ist aktiviert. Dies sollte auf Produktionsseiten nicht aktiviert sein, da es die Geschwindigkeit erheblich beeinträchtigen kann.';
$string['themeeditsettingsname'] = 'Designeinstellungen \'{$a}\' bearbeiten';
$string['themelist'] = 'Designliste';
$string['themeresetcaches'] = 'Design-Cache löschen';
$string['themeselect'] = 'Design wechseln';
$string['themeselector'] = 'Designs';
$string['themesettingsadvanced'] = 'Erweiterte Designeinstellungen';
$string['themesettingscustom'] = 'Angepasste Designeinstellungen';
$string['themesettingsname'] = 'Designeinstellungen \'{$a}\'';
$string['themeusagereportname'] = 'Bericht zur Designnutzung \'{$a}\'';
$string['therewereerrors'] = 'Es gibt Fehler in Ihren Daten';
$string['thirdpartylibrary'] = 'Bibliothek';
$string['thirdpartylibrarylocation'] = 'Ort';
$string['thirdpartylibs'] = 'Drittanbieter-Bibliotheken';
$string['timezone'] = 'Zeitzone';
$string['timezoneforced'] = 'Von Administrator/in festgelegt';
$string['timezoneinvalid'] = 'Ungültige Zeitzone \'{$a}\'';
$string['timezoneisforcedto'] = 'Für alle Nutzer/innen festgelegt';
$string['timezonenotforced'] = 'Eigene Zeitzone wählbar';
$string['timezonephpdefault'] = 'Zeitzone in PHP ({$a})';
$string['timezoneserver'] = 'Serverzeitzone ({$a})';
$string['tlswarning'] = 'Es wurde keine PHP/cURL Erweiterung mit TLSv1.2 Unterstützung erkannt. Einige Funktionen werden daher nicht funktionieren. Wir empfehlen die Aktualisierung der TLS-Bibliotheken.';
$string['tokenduration'] = 'Zeitlimit für Nutzer-Token';
$string['tokenduration_desc'] = 'Zeitdauer, während der automatisch erzeugte Token für Webservices gültig sind (z.B. für die mobile App).';
$string['tokenizerrecommended'] = 'Die PHP-Extension Tokenizer sollte zur Verbesserung der Netzwerkfunktionalität installiert sein.';
$string['tools'] = 'Dienstprogramme';
$string['toolsmanage'] = 'Übersicht';
$string['unattendedoperation'] = 'Automatischer Ablauf';
$string['unbookmarkthispage'] = 'Lesezeichen zu dieser Seite entfernen';
$string['unicoderequired'] = 'Alle Daten müssen im Format Unicode UTF-8 gespeichert werden. Bei einer Neuinstallation muss eine Datenbanken verwendet werden, die als Standardzeichensatz UTF-8 benutzt. Wenn Sie ein Upgrade durchführen, müssen Sie die UTF-8-Migration starten.';
$string['uninstallplugin'] = 'Deinstallieren';
$string['unlockaccount'] = 'Konto freigeben';
$string['unoconvwarning'] = 'Die bei Ihnen installierte Version von \'unoconv\' wird nicht unterstützt. Moodle braucht für die Aufgabenbewertung mindestens die Version 0.7.';
$string['unsupported'] = 'Kein Support';
$string['unsupporteddbfileformat'] = 'Die Datenbank enthält Tabellen im Format \'Antelope\'. Eine vollständige Unterstützung von \'utf-8\' in MySQL und MariaDB erfordern das Format \'Barracuda\'. Informationen zum Konvertieren finden Sie unter <a href="https://docs.moodle.org/de/MySQL_Unicode_Unterstützung">MySQL Unicode Unterstützung</a>.';
$string['unsupporteddbfilepertable'] = 'Zur vollständigen Unterstützung von UTF-8 benötigen sowohl MySQL als auch MariaDB die Änderung der MySQL-Einstellung \'innodb_file_per_table\' auf \'ON\'. Weitere Informationen finden Sie in der Dokumentation.';
$string['unsupporteddblargeprefix'] = 'Zur vollständigen Unterstützung von UTF-8 benötigen sowohl MySQL als auch MariaDB die Änderung der MySQL-Einstellung \'innodb_large_prefix\' auf \'ON\'. Weitere Informationen finden Sie in der Dokumentation.';
$string['unsupporteddbstorageengine'] = 'Die benutzte Datenbank-Engine wird nicht weiter unterstützt.';
$string['unsupporteddbtablerowformat'] = 'Die Datenbank enthält Tabellen mit Format \'Antelope\'. Diese Tabellen sollten unbedingt ins Format \'Barracuda\' konvertiert werden. Informationen zum Konvertieren finden Sie unter <a href="https://docs.moodle.org/de/cli"> Administration über die Befehlszeile </a>.';
$string['unsupportedphpversion7'] = 'PHP 7 (und höher) wird nicht unterstützt.';
$string['unsupportedphpversion71'] = 'PHP 7.1 (und höher) wird nicht unterstützt.';
$string['unsupportedphpversion72'] = 'PHP 7.2 (und höher) wird nicht unterstützt.';
$string['unsupportedphpversion73'] = 'PHP 7.3 (und höher) wird nicht unterstützt.';
$string['unsupportedphpversion74'] = 'PHP 7.4 (und höher) wird nicht unterstützt.';
$string['unsupportedphpversion80'] = 'PHP 8.0 (und höher) wird nicht unterstützt.';
$string['unsupportedphpversion81'] = 'PHP 8.1 (und höher) wird nicht unterstützt.';
$string['unsupportedphpversion82'] = 'PHP Version 8.2 und höher werden nicht unterstützt';
$string['unsupportedphpversion83'] = 'PHP 8.3 und höher werden nicht unterstützt';
$string['unsupportedphpversion84'] = 'PHP Version 8.4 und höher werden nicht unterstützt.';
$string['unsuspenduser'] = 'Nutzerkonto aktivieren';
$string['updateaccounts'] = 'Bestehende Nutzerkonten aktualisieren';
$string['updateautocheck'] = 'Automatisch auf Aktualisierungen prüfen';
$string['updateautocheck_desc'] = 'Wenn diese Option aktiviert ist, wird für Ihrer Website automatisch geprüft, ob für Moodle oder ein zusätzliches Plugin aktuellere Versionen verfügbar sind. Falls eine Aktualisierung vorhanden ist, werden die Administrator/innen benachrichtigt.';
$string['updateavailable'] = 'Moodle ist nicht aktuell!';
$string['updateavailable_moreinfo'] = 'Weitere Infos ...';
$string['updateavailable_release'] = 'Moodle {$a}';
$string['updateavailable_version'] = 'Version {$a}';
$string['updateavailabledetailslink'] = 'Weitere Details: {$a->url}';
$string['updateavailableforplugin'] = 'Für mindestens ein Plugin ist eine Aktualisierung verfügbar.';
$string['updateavailableinstall'] = 'Aktualisierung ausführen';
$string['updateavailableinstallall'] = 'Aktualisierungen ausführen ({$a})';
$string['updateavailableinstallallhead'] = 'Verfügbare Aktualisierungen werden installiert.';
$string['updateavailablenot'] = 'Moodle ist aktuell!';
$string['updateavailablerecommendation'] = 'Sie sollten unbedingt die Software dieser Website auf die neueste Version aktualisieren, um alle Sicherheits- und Fehlerkorrekturen zu erhalten.';
$string['updatecomponent'] = 'Komponente aktualisieren';
$string['updateminmaturity'] = 'Entwicklungsstand prüfen';
$string['updateminmaturity_desc'] = 'Auf Aktualisierungen wird hingewiesen, sobald der verfügbare Code den ausgewählten Entwicklungsstand erreicht. Wenn Plugins Ihren Entwicklungsstand nicht dokumentieren, werden Aktualisierungen von Plugins unabhängig von dieser Einstellung trotzdem aufgeführt.';
$string['updatenotificationfooter'] = 'Ihre Website \'{$a->siteurl}\' sucht automatisch nach verfügbaren Aktualisierungen und versendet Systemnachrichten an Administrator/innen. Sie können die automatische Suche deaktivieren. Den Versand der Mitteilungen können Sie über \'Website-Administration > Server > Aktualisierungsmitteilungen\' ausschalten oder die Einstellungen im Bereich \'Meine Einstellungen\' anpassen.';
$string['updatenotifications'] = 'Aktualisierungsnachrichten';
$string['updatenotificationsubject'] = 'Aktualisierungen für Moodle sind verfügbar: {$a->siteurl}';
$string['updatenotifybuilds'] = 'Neue Builds prüfen';
$string['updatenotifybuilds_desc'] = 'Diese Option legt fest, ob neuere \'Builds\' der aktuell installierten Version angezeigt werden sollen. Builds sind kontinuierliche Verbesserungen, die regelmäßig jede Woche veröffentlicht werden. Wenn diese Option deaktiviert ist, wird ein verfügbares Update nur gemeldet, wenn eine höhere Version veröffentlicht wurde. Die Prüfung der Plugins ist von dieser Einstellung nicht betroffen.';
$string['upgradeerror'] = 'Unbekannter Fehler beim Aktualisieren von {$a->plugin} zu Version {$a->version}. Ein Weitermachen ist nicht möglich.';
$string['upgradeforumread'] = 'Ab Moodle 1.5 können Sie Forenbeiträge als gelesen/ungelesen markieren.<br />Für diese Funktion müssen die Datenbanktabellen aktualisiert werden. <a href="{$a}">Tabellen jetzt aktualisieren</a>.';
$string['upgradeforumreadinfo'] = 'Mit einer neuen Funktion in Moodle 1.5 können Forenbeiträge als gelesen/ungelesen markiert werden. Um diese Funktion zu verwenden, müssen die Datenbanktabellen aktualisiert werden. Je nach Größe der Datenbank kann dieser Vorgang längere Zeit (u.U. mehrere Stunden) erfordern. Führen Sie diesen Vorgang am besten in Zeiten mit wenigen Zugriffen aus. Die Website funktioniert während der Umstellung weiter. Die Nutzer/innen bemerken davon nichts. Wenn Sie den Vorgang einmal gestartet haben, darf er nicht unterbrochen werden. Lassen Sie das Browserfenster dabei offen. Sollten Sie das Browserfenster versehentlich schließen, können Sie den Prozess neu starten. <br />Wollen Sie nun starten?';
$string['upgradekeyreq'] = 'Aktualisierungskennwort notwendig';
$string['upgradekeyset'] = 'Aktualisierungskennwort (leer, um keins zu setzen)';
$string['upgradelogs'] = 'Für die vollständige Funktionsfähigkeit müssen die alten Logdaten aktualisiert werden. <a href="{$a}">Weitere Informationen</a>';
$string['upgradelogsinfo'] = 'Die Art und Weise, in der Logdaten gespeichert werden, wurde verändert. Damit Sie Ihre alten Logdaten mit den Einzelaktivitäten einsehen können, müssen die alten Logdaten aktualisiert werden. Je nachdem, wie viele Daten auf Ihrer Seite gespeichert sind, kann dieser Vorgang eine längere Zeit beanspruchen (u.U. mehrere Stunden). Der Vorgang beansprucht die Datenbank bei umfangreichen Seiten stark. Wenn Sie den Vorgang einmal gestartet haben, müssen Sie ihn ohne Unterbrechung abschließen lassen. Das Browserfenster darf in dieser Zeit nicht geschlossen und die Internetverbindung nicht unterbrochen werden. Der Zugriff auf Ihre Website durch andere Anwender ist nicht beeinträchtigt. <br /><br />Wollen Sie nun Ihre Logdaten aktualisieren?';
$string['upgradepluginsfirst'] = 'Die verfügbaren Aktualisierungen sollten zuerst installiert werden.';
$string['upgradepluginsinfo'] = 'Plugins aktualisieren';
$string['upgradepluginsinfo_help'] = 'Für die installierten Plugins sind Aktualisierungen verfügbar! Die Aktualisierungen müssen manuell herunterladen und installiert werden. Erst dann sollten Sie die Aktualisierung der Datenbank starten.';
$string['upgradepluginsinfo_link'] = 'admin/upgradepluginsinfo';
$string['upgradesettings'] = 'Neue Einstellungen';
$string['upgradesettingsintro'] = 'Die folgenden Optionen wurden bei der letzten Aktualisierung hinzugefügt. Ändern Sie (falls nötig) die voreingestellten Werte  und speichern Sie die Einstellungen am Ende dieser Seite.';
$string['upgradestalefiles'] = 'Das Verzeichnis enthält noch Dateien von einem älteren Moodle. Das Upgrade kann nicht fortgesetzt werden.';
$string['upgradestalefilesinfo'] = 'Die Aktualisierung wurde angehalten, weil PHP-Skripte aus unterschiedlichen Moodle-Versionen gefunden wurden. Dies könnte zu erheblichen Problemen im Betrieb führen.

Für eine saubere Installation wird folgendes Vorgehen empfohlen:

* benennen Sie das bestehende Verzeichnis \'moodle\' um in \'moodle-alt\'
* legen Sie ein neues Verzeichnis \'moodle\' an, das Sie als Standardpaket herunterladen oder über git bzw. cvs beziehen können.
* kopieren Sie die Datei \'config.php\' und alle nicht im Standardumfang enthaltenen Plugins von \'moodle-alt\' nach \'moodle\'

Sobald Sie ein sauberes Moodle-Verzeichnis haben, können Sie diese Seite aktualisieren und den Update-Prozess fortsetzen.

Diese Warnung tritt in den meisten Fällen auf, weil ein neues Standardpaket einfach in das alte Verzeichnis \'moodle\' kopiert wurde. Dabei werden zwar alte gegen neue Dateien ausgetauscht, aber keine überzähligen Dateien und Verzeichnisse entfernt.

Die Warnung kann auch bedeuten, dass bei einem unvollständigen Update über git, cvs oder svn nicht alle notwendigen Dateien aktualisiert wurden. Versuchen Sie die Aktualisierung erneut und warten Sie, bis alle Dateien vollständig geladen sind.

Weitere Informationen: <a href="{$a}">{$a}</a>.';
$string['upgradestart'] = 'Aktualisierung der Datenbank starten';
$string['upgradesure'] = '<p>Die Moodle-Dateien wurden auf Ihrem Server verändert. Moodle wird automatisch auf die Version <strong>{$a}</strong> aktualisiert. Danach können Sie nicht mehr zur alten Version zurückkehren. Beachten Sie, dass der Vorgang sehr lange dauern könnte!</p>
<p>Möchten Sie die Aktualisierung des Servers wirklich starten?</p>';
$string['upgradetimedout'] = 'Die Aktualisierung wurde wegen Zeitüberschreitung abgebrochen. Starten Sie den Vorgang bitte nochmal.';
$string['upgradingdata'] = 'Daten werden aktualisiert.';
$string['upgradinglogs'] = 'Logdaten werden aktualisiert.';
$string['upgradingversion'] = 'Aktualisierung auf neue Version';
$string['upwards'] = 'aufwärts';
$string['useblogassociations'] = 'Blogverbund erlauben';
$string['user'] = 'Nutzer/in';
$string['userbulk'] = 'Nutzerverwaltung (Bulk)';
$string['userbulkdownload'] = 'Nutzer/innen exportieren als';
$string['userdefaultpreferences'] = 'Voreingestellte Nutzereinstellungen';
$string['userfeedbackafterupgrade'] = 'Nach jeder großen Aktualisierung';
$string['userfeedbackencouragement'] = '<p>Moodle verfügt über eine Funktion, mit der Nutzer/innen ein Feedback zur Moodle-Software abgeben können. Die Umfrage wird über einen externen Server bereitgestellt. Für die Umfrage werden keine personenbezogenen Daten an den externen Server übertragen oder erfasst.</p>
<p>Moodle HQ ist bestrebt, offen und transparent mit seinen Datenerfassungspraktiken umzugehen. Daher möchten wir sicherstellen, dass Sie über diese Funktion informiert sind und sie kontrollieren können.</p>
<p>Das Feedback unterstützt das Moodle HQ dabei, die Moodle-Software zu verbessern. Um diese Funktion zu aktivieren, gehen Sie bitte zu den <a href="{$a}">Feedback-Einstellungen</a>.</p>';
$string['userfeedbacknextreminder'] = 'Nächste Feedback-Erinnerung';
$string['userfeedbacknextreminder_desc'] = 'Wann sollen die Nutzer/innen erneut nach ihrem Feedback gefragt werden?';
$string['userfeedbackperiodically'] = 'Regelmäßig';
$string['userfeedbackremindafter'] = 'Erinnerung anzeigen nach';
$string['userfeedbackremindafter_desc'] = 'Nutzer/innen sollen nach der angegebenen Zahl von Tagen erneut um ein Feedback gebeten werden.';
$string['userfiltersdefault'] = 'Voreingestellte Nutzerfilter';
$string['userfiltersdefault_desc'] = 'Wählen Sie die Filter aus, die auf der Seite "Nutzerverwaltung (Bulk)" angezeigt werden sollen. Eine Mehrfachauswahl ist möglich. Nicht ausgewählte Filter sind immer verfügbar, wenn Sie auf den Link "Mehr anzeigen" klicken.';
$string['userimagesdisabled'] = 'Bilder im Nutzerprofil sind deaktiviert.';
$string['userlist'] = 'Nutzerliste anzeigen';
$string['usermanagement'] = 'Nutzerverwaltung';
$string['userpolicies'] = 'Nutzereigenschaften';
$string['userpreference'] = 'Nutzereinstellungen';
$string['userquota'] = 'Speicherplatz für meine Dateien';
$string['userquota_desc'] = 'Das Gesamtspeichervolumen einer Person für ihre Dateiablage \'Meine Dateien\'';
$string['users'] = 'Nutzer/innen';
$string['usesitenameforsitepages'] = 'Kurzbezeichnung der Website für \'Website\' verwenden.';
$string['usetags'] = 'Tags aktivieren';
$string['validateemptylineerror'] = 'Leere Zeilen sind nicht erlaubt.';
$string['validateerror'] = 'Dieser Wert ist ungültig:';
$string['validateerrorlist'] = 'Diese Einträge sind ungültig: {$a}';
$string['validateiperror'] = 'Diese IP-Adressen sind ungültig: {$a}';
$string['verifychangedemail'] = 'E-Mail-Domains bei Änderung prüfen';
$string['warningcurrentsetting'] = 'Aktueller Wert ist ungültig: {$a}';
$string['warningiconvbuggy'] = 'Die Library iconv unterstützt den //IGNORE modifier nicht. Sie sollten die PHP-Extension mbstring installieren, die stattdessen zur Bereinigung von Strings mit nicht UTF-8-konformen Zeichen.';
$string['webproxy'] = 'Web-Proxy';
$string['webproxyinfo'] = 'Füllen Sie die folgenden Optionen aus, falls Ihr Moodle-Server das Internet nicht direkt erreichen kann. Ein Internetzugang ist notwendig, um Updates, Sprachpakete, RSS-Feeds, Zeitzonen-Daten usw. laden zu können. <br /><em>Die Installation der PHP-Extension cURL wird dringend empfohlen!</em>';
$string['xmlrpcwebserviceenabled'] = 'Es wurde festgestellt, dass der Webservice XMLRPC auf dieser Website aktiviert ist. Diese Funktion basiert auf der PHP-Erweiterung XMLRPC, die nicht mehr von PHP bereitgestellt wird.';
$string['yuicomboloading'] = 'YUI Combo Cache';
$string['ziprequired'] = 'Die PHP-Extension Zip ist notwendig. Die alten Pakete infoZip und PclZip werden nicht mehr benutzt.';
