<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'question', language 'pl', version '5.0'.
 *
 * @package     question
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Akcja';
$string['addanotherhint'] = 'Dodaj kolejną podpowiedź';
$string['addcategory'] = 'Dodaj kategorię';
$string['addmorechoiceblanks'] = 'Pola na {no} więcej odpowiedzi';
$string['adminreport'] = 'Raportuj o możliwych problemach w twojej bazie pytań.';
$string['advancedsearchoptions'] = 'Opcje wyszukiwania';
$string['alltries'] = 'Wszystkie próby';
$string['alwayslatest'] = 'Zawsze najnowsza';
$string['answer'] = 'Odpowiedź';
$string['answers'] = 'Odpowiedzi';
$string['answersaved'] = 'Odpowiedź zapisana';
$string['answerx'] = 'Odpowiedź {$a}';
$string['attemptfinished'] = 'Próba zakończona';
$string['attemptfinishedsubmitting'] = 'Próba zakończona przesłaniem: {$a}';
$string['attemptoptions'] = 'Opcje próby';
$string['availableq'] = 'Dostępny?';
$string['badbase'] = 'Niewłaściwa podstawa potęgi przed **: {$a}**';
$string['banksincourse'] = 'Banki pytań w tym kursie';
$string['behaviour'] = 'Tryb';
$string['behaviourbeingused'] = 'Użyte zachowanie: {$a}';
$string['broken'] = 'To jest nieprawidłowe łącze, wskazuje na nieistniejący plik.';
$string['byandon'] = 'przez <em>{$a->user}</em> o <em>{$a->time}</em>';
$string['cannotcopybackup'] = 'Nie można skopiować pliku kopii zapasowej';
$string['cannotcreate'] = 'Nie można utworzyć nowego wpisu w tabeli question_attempts';
$string['cannotcreatepath'] = 'Nie udało się utworzyć ścieżki: {$a}';
$string['cannotdeletebehaviourinuse'] = 'Nie można usunąć trybu \'{$a} &quot;. Jest on używany w pytaniach.';
$string['cannotdeletecate'] = 'Nie można usunąć tej kategorii. Jest to kategoria domyślna dla tego kontekstu.';
$string['cannotdeleteneededbehaviour'] = 'Nie można usunąć trybu &quot;{$a}&quot;. Istnieją inne tryby, które od niego zależą.';
$string['cannotdeleteqtypeinuse'] = 'Nie można usunąć pytania typu \'{$a}\'. W bazie pytań znajdują się pytania tego typu.';
$string['cannotdeleteqtypeneeded'] = 'Nie można usunąć pytanie typu \'{$a}\'. Istnieją inne rodzaje zainstalowanych pytań, które są od niego zależne.';
$string['cannotdeletetopcat'] = 'Kategorie najwyższego poziomu nie mogą zostać usunięte.';
$string['cannotedittopcat'] = 'Kategorie najwyższego poziomu nie mogą być edytowane.';
$string['cannotenable'] = 'Nie można bezpośrednio utworzyć pytania typu: {$a}.';
$string['cannotenablebehaviour'] = 'Tryb {$a} nie może być stosowany bezpośrednio. Jest tylko do użytku wewnętrznego.';
$string['cannotfindcate'] = 'Nie można odnaleźć rekordu kategorii';
$string['cannotfindquestionfile'] = 'Nie można znaleźć danych pytania w pliku zip';
$string['cannotgetdsfordependent'] = 'Nie można pobrać określonego zestawu danych niezbędnego w pytaniu! (Pytanie: {$a->id}, zestaw danych: {$a->item})';
$string['cannotgetdsforquestion'] = 'Nie można pobrać zestawu danych dla pytania obliczeniowego! (Pytanie: {$a})';
$string['cannothidequestion'] = 'Nie był w stanie ukryć pytania';
$string['cannotimportformat'] = 'Przepraszamy, nie zaimplementowano jeszcze możliwości importu tego formatu!';
$string['cannotinsertquestion'] = 'Nie można wstawić nowego pytania!';
$string['cannotinsertquestioncatecontext'] = 'Nie można wstawić nowej kategorii {$a->cat}. Niedozwolony kontekst {$a->ctx}';
$string['cannotloadquestion'] = 'Nie można załadować pytania';
$string['cannotmovequestion'] = 'Nie można użyć tego skryptu, aby przenosić pytania, które są związane z plikami z różnych obszarów.';
$string['cannotopenforwriting'] = 'Nie można otworzyć do zapisu: {$a}';
$string['cannotpreview'] = 'Nie można wyświetlić podglądu tego pytania!';
$string['cannotread'] = 'Nie można odczytać pliku do importu (lub plik jest pusty)';
$string['cannotregradedifferentqtype'] = 'Nie można ponownie ocenić z pytaniem innego typu.';
$string['cannotretrieveqcat'] = 'Nie można pobrać kategorii pytania';
$string['cannotunhidequestion'] = 'Nie udało się odkryć pytania.';
$string['cannotunzip'] = 'Nie można rozpakować pliku.';
$string['cannotwriteto'] = 'Nie można zapisać wyeksportowanych pytań do {$a}';
$string['categories'] = 'Kategorie';
$string['category'] = 'Kategoria';
$string['categorycurrent'] = 'Bieżąca kategoria';
$string['categorycurrentuse'] = 'Użyj tej kategorii';
$string['categorydoesnotexist'] = 'Ta kategoria nie istnieje';
$string['categoryinfo'] = 'Informacje na temat kategorii';
$string['categorymove'] = 'Kategoria \'{$a->name}\' zawiera {$a->count} pytań (niektóre z nich mogą być pytaniami ukrytymi lub losowymi pytaniami, które są nadal używane w teście). Wybierz inną kategorię, do której chcesz je przenieść.';
$string['categorymoveto'] = 'Zapisz w kategorii';
$string['categorynamecantbeblank'] = 'Nazwa kategorii nie może być pusta.';
$string['categorynamewithcount'] = '{$a->name} ({$a->questioncount})';
$string['categorynamewithidnumber'] = '{$a->name} [{$a->idnumber}]';
$string['categorynamewithidnumberandcount'] = '{$a->name} [{$a->idnumber}] ({$a->questioncount})';
$string['changeoptions'] = 'Zmiana opcji';
$string['changepublishstatuscat'] = '<a href="{$a->caturl}">Kategoria "{$a->name}"</a> w kursie "{$a->coursename}" zmieni status udostępniania z {$a->changefrom} na {$a->changeto}.';
$string['check'] = 'Sprawdź';
$string['chooseqtypetoadd'] = 'Wybierz rodzaj nowego pytania';
$string['clearwrongparts'] = 'Wyczyść nieprawidłowe odpowiedzi';
$string['clickflag'] = 'Oflaguj pytanie';
$string['clicktoflag'] = 'Zaznacz to pytanie flagą';
$string['clicktounflag'] = 'Usuń flagę';
$string['clickunflag'] = 'Usuń flagę';
$string['closepreview'] = 'Zamknij podgląd';
$string['combinedfeedback'] = 'Złożona informacja zwrotna';
$string['comment'] = 'Komentarz';
$string['commented'] = 'Skomentował: {$a}';
$string['commentormark'] = 'Utwórz komentarz lub zastąp punktację';
$string['comments'] = 'Komentarze';
$string['commentx'] = 'Komentarz: {$a}';
$string['complete'] = 'Zakończone';
$string['contexterror'] = 'Nie powinieneś / powinnaś się tu znaleźć, chyba że przenosisz kategorię do innego kontekstu.';
$string['copy'] = 'Skopiuj z {$a} i zmień łącza';
$string['correct'] = 'Poprawnie';
$string['correctfeedback'] = 'Dla każdej poprawnej odpowiedzi';
$string['correctfeedbackdefault'] = 'Twoja odpowiedź jest poprawna.';
$string['courserestore'] = 'Przywracanie kursu';
$string['created'] = 'Utworzony';
$string['createdby'] = 'Utworzone przez';
$string['createdefault'] = 'Utwórz domyślny bank pytań';
$string['createdmodifiedheader'] = 'Utworzono / ostatnio zapisany';
$string['createnewquestion'] = 'Utwórz nowe pytanie ...';
$string['cwrqpfs'] = 'Losowe pytania wybierające pytania z podkategorii.';
$string['cwrqpfsinfo'] = 'Podczas aktualizacji do Moodle 1.9 podzielimy kategorie pytań na różne konteksty. Status współdzielenia niektórych kategorii i pytań będzie musiał zostać zmieniony. Jest to konieczne w rzadkim przypadku, kiedy jedno lub więcej \'losowych\' pytań wybiera pytania z mieszanki kategorii współdzielonych i niewspółdzielonych (tak jak w przypadku tej strony). Zdarza się tak, kiedy \'losowe\' pytanie wybiera pytania z podkategorii i jedna lub więcej podkategorii ma status współdzielenia różny od kategorii nadrzędnej, w której zawiera się pytanie losowe.</p>
<p>Podczas aktualizacji do Moodle 1.9 status współdzielenia poniższych kategorii pytań (z których \'losowe\' pytania kategorii nadrzędnej wybierają pytania) zostanie zmieniony na taki, jaki jest status kategorii zawierającej pytanie losowe. Poniższe kategorie będą miały zmieniony status współdzielenia. Wszystkie pytania we wszystkich testach będą nadal działać (dopóki ich nie usuniesz).</p>';
$string['cwrqpfsnoprob'] = 'Problem "losowych pytań wybierających pytania z podkategorii" nie dotyczy żadnego z istniejących pytań.';
$string['decimalplacesingrades'] = 'Miejsca dziesiętne w ocenach';
$string['defaultbank'] = 'Bank pytań w kursie {$a->coursename}';
$string['defaultcreated'] = 'Utworzono domyślny bank pytań.';
$string['defaultfor'] = 'Domyślna dla: {$a}';
$string['defaultinfofor'] = 'Domyślna kategoria dla pytań współdzielonych w kontekście \'{$a}\'.';
$string['defaultmark'] = 'Domyślna punktacja';
$string['defaultmarkmustbepositive'] = 'Domyślna ocena musi być pozytywna,';
$string['deletecoursecategorywithquestions'] = 'Istnieją pytania w tej kategorii w banku pytań. Jeśli będziesz kontynuować, zostaną one usunięte. Może lepiej przenieść je najpierw za pomocą interfejsu bazy pytań.';
$string['deletequestioncheck'] = 'To spowoduje usunięcie następującego pytania i wszystkich jego wersji:<br /><br />{$a}';
$string['deletequestionscheck'] = 'To spowoduje usunięcie następujących pytań i wszystkich jego wersji:<br /><br />{$a}';
$string['deletequestiontitle'] = 'Usunąć pytanie?';
$string['deletequestiontitle_plural'] = 'Usunąć pytania?';
$string['deleteselectedquestioncheck'] = 'To spowoduje usunięcie wybranych wersji następującego pytania:<br /><br />{$a}';
$string['deleteversiontitle'] = 'Usunąć wybraną wersję?';
$string['deleteversiontitle_plural'] = 'Usunąć wybraną wersje?';
$string['deletingbehaviour'] = 'Usuwanie trybu \'{$a}\'';
$string['deletingqtype'] = 'Usuwanie pytania typu: \'{$a}\'';
$string['didnotmatchanyanswer'] = '[Nie pasuje to żadnej odpowiedzi]';
$string['disabled'] = 'Wyłączone';
$string['disabledbanks'] = 'Wszystkie typy modułów banku pytań są wyłączone.';
$string['displayoptions'] = 'Opcje wyświetlania';
$string['disterror'] = 'Dystrybucja {$a} spowodowała problemy';
$string['donothing'] = 'Nie kopiuj, nie przenoś plików ani nie zmieniaj łączy.';
$string['editcategories'] = 'Edytuj kategorie';
$string['editcategories_help'] = 'Zamiast trzymać wszystko na jednej dużej liście, pytania można podzielić na kategorie i podkategorie.

Kategorie są również używane do pytań losowych, ponieważ pytania są wybierane z określonej kategorii.';
$string['editcategories_link'] = 'question/category';
$string['editcategory'] = 'Edytuj kategorię';
$string['editingcategory'] = 'Edycja kategorii';
$string['editingquestion'] = 'Edycja pytania';
$string['editquestion'] = 'Edytuj pytanie';
$string['editquestions'] = 'Edytuj pytania';
$string['editthiscategory'] = 'Edytuj tę kategorię';
$string['emptyxml'] = 'Nieznany błąd - pusty imsmanifest.xml';
$string['enabled'] = 'Włączony';
$string['erroraccessingcontext'] = 'Nie można uzyskać dostępu do kontekstu';
$string['errordeletingquestionsfromcategory'] = 'Błąd podczas usuwania pytań z kategorii {$a}.';
$string['errorduringpost'] = 'Wystąpił błąd podczas przetwarzania końcowego!';
$string['errorduringpre'] = 'Wystąpił błąd podczas przetwarzania wstępnego!';
$string['errorduringproc'] = 'Wystąpił błąd podczas przetwarzania!';
$string['errorduringregrade'] = 'Nie można przeliczyć oceny pytania {$a->qid}. Ustawiam stan {$a->stateid}.';
$string['errorfilecannotbecopied'] = 'Błąd: nie można skopiować pliku {$a}.';
$string['errorfilecannotbemoved'] = 'Błąd: nie można przenieść pliku {$a}.';
$string['errorfileschanged'] = 'Błąd: pliki związane z pytaniami zostały zmienione w czasie, gdy  formatka jest wyświetlona.';
$string['erroritemappearsmorethanoncewithdifferentweight'] = 'Pytanie ({$a}) występuje w teście więcej niż jeden raz z różną wagą. Obecnie nie jest to wspierane żadnym raportem statystycznym i może sprawić, że statystyki dotyczące tego pytania będą niewiarygodne.';
$string['errormanualgradeoutofrange'] = 'Ocena {$a->grade} pytania {$a->name} nie mieści się w przedziale od  0 do {$a->maxgrade}. Ocena i komentarz nie zostały zapisane.';
$string['errormovingquestions'] = 'Błąd podczas przesuwania pytań z identyfikatorami {$a}.';
$string['errorpostprocess'] = 'Wystąpił błąd podczas przetwarzania końcowego!';
$string['errorpreprocess'] = 'Wystąpił błąd podczas przetwarzania wstępnego!';
$string['errorprocess'] = 'Wystąpił błąd podczas przetwarzania!';
$string['errorprocessingresponses'] = 'Wystąpił błąd podczas przetwarzania twojej odpowiedzi ({$a}). Kliknij przycisk Kontynuuj, aby powrócić do poprzedniej strony i spróbuj ponownie.';
$string['errorsavingcomment'] = 'Błąd podczas zapisywania komentarza dla pytania {$a->name} w bazie danych.';
$string['errorsavingflags'] = 'Błąd podczas zapisywania stanu flagi.';
$string['errorupdatingattempt'] = 'Błąd podczas aktualizacji {$a->id}. podejścia w bazie danych.';
$string['eventqbankdisabled'] = 'Wtyczka banku pytań wyłączona';
$string['eventqbankenabled'] = 'Wtyczka banku pytań włączona';
$string['eventquestioncategorycreated'] = 'Utworzono kategorię pytań';
$string['eventquestioncategorydeleted'] = 'Usunięto kategorię pytań';
$string['eventquestioncategorymoved'] = 'Przeniesiono kategorię pytań';
$string['eventquestioncategoryupdated'] = 'Zaktualizowano kategorię pytań';
$string['eventquestioncategoryviewed'] = 'Wyświetlono kategorię pytań';
$string['eventquestioncreated'] = 'Utworzono pytanie';
$string['eventquestiondeleted'] = 'Usunięto pytanie';
$string['eventquestionmoved'] = 'Przeniesiono pytanie';
$string['eventquestionsexported'] = 'Wyeksportowano pytanie';
$string['eventquestionsimported'] = 'Zaimportowano pytanie';
$string['eventquestionupdated'] = 'Zaktualizowano pytanie';
$string['eventquestionviewed'] = 'Wyświetlono pytanie';
$string['export'] = 'Eksport';
$string['exportasxml'] = 'Wyeksportuj jako Moodle XML';
$string['exportcategory'] = 'Eksportuj kategorię';
$string['exportcategory_help'] = 'Kategoria, z której eksportowane będą pytania.
Niektóre formaty importu, takie jak GIFT i Moodle XML, zapisują również kategorię i kontekst w pliku eksportu, dzięki czemu mogą być one (opcjonalnie) odtworzone podczas importu. Jeśli tego chcemy, odpowiednie pola wyboru powinny być zaznaczone.';
$string['exporterror'] = 'Wystąpiły błędy podczas eksportu!';
$string['exportfilename'] = 'pytania';
$string['exportnameformat'] = '%Y%m%d-%H%M';
$string['exportonequestion'] = 'Pobierz to pytanie w formacie Moodle XML';
$string['exportquestions'] = 'Eksportuj pytania do pliku';
$string['exportquestions_help'] = 'Ta funkcja umożliwia eksport pełnej kategorii (i dowolnej podkategorii) pytań do pliku. Pamiętaj, że w zależności od wybranego formatu pliku niektóre dane pytań i niektóre typy pytań mogą nie zostać wyeksportowane.';
$string['exportquestions_link'] = 'question/export';
$string['feedback'] = 'Informacja zwrotna';
$string['fieldinquestion'] = '{$a->fieldname} {$a->questionindentifier}';
$string['fieldinquestionpre'] = '{$a->questionindentifier} {$a->fieldname}';
$string['filecantmovefrom'] = 'Pliki pytań nie mogą być przeniesione, ponieważ nie masz uprawnień do usuwania plików z miejsca, skąd próbujesz je przenieść.';
$string['filecantmoveto'] = 'Pliki nie mogą być przeniesione lub skopiowane, ponieważ nie masz uprawnień do dodawania plików w miejscu, dokąd próbujesz się przenieść.';
$string['fileformat'] = 'Format pliku';
$string['filesareacourse'] = 'Obszar plików kursu';
$string['filesareasite'] = 'Obszar plików witryny';
$string['filestomove'] = 'Przenieść / skopiować pliki do {$a}?';
$string['fillincorrect'] = 'Wypełnij poprawnymi odpowiedziami';
$string['filterbytags'] = 'Filtruj wg tagów...';
$string['firsttry'] = 'Pierwsza próba';
$string['flagged'] = 'Zaznaczone flagą';
$string['flagthisquestion'] = 'Oflaguj to pytanie';
$string['formquestionnotinids'] = 'Formularz zawierał pytanie, któredo nie ma w questionids';
$string['fractionsnomax'] = 'Jedna z odpowiedzi powinna być warta 100%, aby można było otrzymać całą ocenę za to pytanie.';
$string['generalfeedback'] = 'Ogólna inf. zwrotna';
$string['generalfeedback_help'] = 'Ogólna informacja zwrotna jest wyświetlana dla studenta, gdy odpowiedział już na pytanie. W przeciwieństwie do Informacji zwrotnej, która zależy od typu pytania i udzielonej odpowiedzi , ta sama Ogólna informacja zwrotna jest wyświetlana wszystkim studentom.
Możesz użyć Ogólnej informacji zwrotnej, aby dać studentom wskazówkę, jakiej dziedziny dotyczyło pytanie, lub dać im link do dodatkowych informacji, które mogą wykorzystać, jeśli nie zrozumieli pytania.';
$string['getcategoryfromfile'] = 'Pobierz kategorię z pliku';
$string['getcontextfromfile'] = 'Pobierz kontekst z pliku';
$string['hintn'] = 'Wskazówka {no}';
$string['hintnoptions'] = 'Opcje wskazówki {no}';
$string['hinttext'] = 'Tekst wskazówki';
$string['howquestionsbehave'] = 'Jak zachowują się pytania';
$string['howquestionsbehave_help'] = 'Studenci mogą korzystać z pytań w teście w wielu trybach. Na przykład studenci będą  wpisywać odpowiedzi na wszystkie pytania, a następnie zatwierdzać cały test, zanim  dostaną ocenę czy komentarz. To będzie "Opóźniona informacja zwrotna.
Z kolei można spowodować, że od razu po odpowiedzi student otrzymuje punktację, a w przypadku pomyłki ma szansę skorygować odpowiedź, z tym że otrzyma mniej punktów za powtórkę. Ten tryb nazywa się "Interaktywny z powtórzeniami".';
$string['howquestionsbehave_link'] = 'question/behaviour';
$string['idnumber'] = 'Identyfikator';
$string['idnumber_help'] = 'Jeśli jest używany, numer identyfikacyjny musi być unikalny w ramach każdej kategorii pytań. Zapewnia on inny sposób identyfikacji pytania, które czasami jest przydatne, ale zazwyczaj można je pozostawić puste.';
$string['ignorebroken'] = 'Ignoruj niedziałające łącza';
$string['import'] = 'Import';
$string['importcategory'] = 'Import do kategorii';
$string['importcategory_help'] = 'Kategoria, w której pojawią się importowane pytania.
Niektóre formaty importu, takie jak GIFT i Moodle XML, zapisują również kategorię i kontekst w pliku. Aby skorzystać z tych danych, a nie z wybranej tu kategorii, należy zaznaczyć odpowiednie pola wyboru. Jeśli kategorie określone w pliku importu nie istnieją, zostaną one stworzone.';
$string['importerror'] = 'Wystąpił błąd podczas przetwarzania importu';
$string['importerrorquestion'] = 'Błąd podczas importowania pytania';
$string['importfromcoursefiles'] = '... lub wybierz plik kursu do zaimportowania.';
$string['importfromupload'] = 'Wybierz plik do przesłania ...';
$string['importingquestions'] = 'Importowanie {$a} pytań z pliku';
$string['importparseerror'] = 'Stwierdzono błąd podczas analizowania pliku importu. Żadne pytania nie zostały zaimportowane.  Aby zaimportować te pytania, które są prawidłowe, spróbuj ponownie, ustawiwszy "Zatrzymaj na błędzie" na "Nie"';
$string['importquestions'] = 'Importuj pytania z pliku';
$string['importquestions_help'] = 'Funkcja ta pozwala na importowanie pytań z różnych formatów plików tekstowych. Zauważ, że należy używać kodowania UTF-8.';
$string['importquestions_link'] = 'question/import';
$string['importwrongfileencoding'] = 'Wybrany plik nie używa kodowania znaków UTF-8. Pliki {$a} muszą używać UTF-8.';
$string['importwrongfiletype'] = 'Typ wybranego pliku ({$a->actualtype}) nie jest typem oczekiwanym przez ten format importu ({$a->expectedtype})';
$string['impossiblechar'] = 'Niepoprawny znak {$a} wykryty w roli  nawiasu';
$string['includesubcategories'] = 'Pokaż także pytania z podkategorii';
$string['incorrect'] = 'Niepoprawnie';
$string['incorrectfeedback'] = 'Dla każdej niepoprawnej odpowiedzi';
$string['incorrectfeedbackdefault'] = 'Twoja odpowiedź jest niepoprawna.';
$string['information'] = 'Informacja';
$string['invalidanswer'] = 'Niekompletna odpowiedź';
$string['invalidarg'] = 'Nie dostarczono prawidłowych argumentów lub nieprawidłowa konfiguracja serwera';
$string['invalidcategoryidforparent'] = 'Nieprawidłowy identyfikator kategorii nadrzędnej!';
$string['invalidcategoryidtomove'] = 'Nieprawidłowy identyfikator przenoszonej kategorii!';
$string['invalidconfirm'] = 'Ciąg potwierdzający był nieprawidłowy';
$string['invalidcontextinhasanyquestions'] = 'Nieprawidłowy kontekst przekazany do question_context_has_any_questions';
$string['invalidgrade'] = 'Oceny ({$a}) nie pasują do opcji ocen - pominięto pytanie.';
$string['invalidgradequestion'] = 'Oceny ({$a->grades}) nie pasują do opcji ocen - pytanie \'{$a->question}\' zostało pominięte.';
$string['invalidpenalty'] = 'Niewłaściwa kara';
$string['invalidquestiontype'] = 'Nieprawidłowy typ pytania: {$a}';
$string['invalidwizardpage'] = 'Nieprawidłowa lub nieokreślona strona kreatora!';
$string['lastmodifiedby'] = 'Ostatnio zmienione przez';
$string['lasttry'] = 'Ostatnia próba';
$string['linkedfiledoesntexist'] = 'Powiązany plik {$a} nie istnieje';
$string['makechildof'] = 'Utwórz potomka dla \'{$a}\'';
$string['makecopy'] = 'Utwórz kopię';
$string['maketoplevelitem'] = 'Przesuń na poziom nadrzędny';
$string['manualgradeinvalidformat'] = 'To nie jest poprawna liczba.';
$string['manualgradeoutofrange'] = 'Ocena jest poza dozwolonym zakresem';
$string['manuallygraded'] = 'Ręcznie ocenione na {$a->mark} z komentarzem: {$a->comment}';
$string['mark'] = 'Ocena';
$string['markedoutof'] = 'Maks. punktów';
$string['markedoutofmax'] = 'Punkty maks.: {$a}';
$string['markoutofmax'] = 'Punkty: {$a->mark} z {$a->max}';
$string['marks'] = 'Punkty';
$string['matchgrades'] = 'Jeśli punktów nie da się dopasować';
$string['matchgrades_help'] = 'Importowane oceny muszą być zgodne z ustaloną listą poprawnych ocen: 100, 90, 80, 75, 70, 66,666, 60, 50, 40, 33,333, 30, 25, 20, 16,666, 14,2857, 12,5, 11,111, 10, 5 , 0 (również wartości ujemne). Jeśli nie, to są dwie opcje:
* błąd, ocena spoza listy - Jeżeli pytanie zawiera ocenę, które nie występuje na liście, wyświetlany jest błąd i pytanie to nie zostanie zaimportowane
* zaokrąglij do najbliższej - Jeśli ocena nie pasuje do wartości na liście, jest ona zaokrąglana do najbliższej pasującej wartości na liście';
$string['matchgradeserror'] = 'Pokaż błąd';
$string['matchgradesnearest'] = 'Zaokrąglij do najbliższej wartości';
$string['missingcourseorcmid'] = 'print_question wymaga courseid lub cmid .';
$string['missingcourseorcmidtolink'] = 'get_question_edit_link wymaga courseid lub cmid .';
$string['missingimportantcode'] = 'W pytaniu brakuje istotnego kodu: {$a}.';
$string['missingoption'] = 'W pytaniu Cloze {$a} brakuje opcji';
$string['modified'] = 'Ostatnio zapisano';
$string['move'] = 'Przenieś z {$a} i zmień łącza';
$string['movecategory'] = 'Przenieś kategorię';
$string['movedquestionsandcategories'] = 'Przeniesione pytania i kategorie pytań z {$a->oldplace} do {$a->newplace}.';
$string['movelinksonly'] = 'Tylko zmień adres docelowy łączy, nie przesuwaj ani nie kopiuj plików.';
$string['moveq'] = 'Przesuń pytanie(a)';
$string['moveqtoanothercontext'] = 'Przesuń pytanie do innego kontekstu';
$string['moveto'] = 'Przenieś do';
$string['movingcategory'] = 'Przenoszenie kategorii';
$string['movingcategoryandfiles'] = 'Czy na pewno chcesz przenieść kategorię {$a->name} ze wszystkimi podkategoriami do kontekstu "{$a->contextto}"?<br /> {$a->urlcount} plików jest powiązanych z pytaniami w {$a->fromareaname}. Czy chcesz skopiować lub przesunąć te pliki do {$a->toareaname}?';
$string['movingcategorynofiles'] = 'Czy na pewno chcesz przesunąć kategorię "{$a->name}" wraz ze wszystkimi podkategoriami do kontekstu "{$a->contextto}"?';
$string['movingquestions'] = 'Przenoszenie pytań i plików';
$string['movingquestionsandfiles'] = 'Czy na pewno chcesz przenieść pytanie(a) {$a->questions} do kontekstu <strong>"{$a->tocontext}"</strong>?<br /> <strong>{$a->urlcount} plików</strong> jest powiązanych z tym(i) pytaniem(ami) w {$a->fromareaname}. Czy chcesz skopiować lub przesunąć te pliki do {$a->toareaname}?';
$string['movingquestionsnofiles'] = 'Czy na pewno chcesz przenieść pytanie(a) {$a->questions} do kontekstu <strong>"{$a->tocontext}"</strong>?<br /> <strong>Nie ma plików</strong> powiązanych z tymi pytaniami w {$a->fromareaname}.';
$string['needtochoosecat'] = 'Wybierz kategorię, do której przesunąć to pytanie lub wciśnij \'Anuluj\'.';
$string['nobanks'] = 'Ten kurs nie ma jeszcze żadnych banków pytań.';
$string['nocate'] = 'Nie ma takiej kategorii: {$a}';
$string['noconditionspecified'] = 'Proszę określić warunek';
$string['nopermissionadd'] = 'Nie masz uprawnień do dodawania tutaj pytań.';
$string['nopermissionedit'] = 'Nie masz uprawnień do edytowania pytań z tego miejsca.';
$string['noprobs'] = 'Nie wykryto błędów w bazie danych zapytań.';
$string['noquestionbanks'] = 'Nie znaleziono wtyczki banku pytań.';
$string['noquestions'] = 'Brak pytań do eksportowania. Upewnij się, że wybrano kategorię, który zawiera pytania.';
$string['noquestionsinfile'] = 'Nie ma pytań w importowanym pliku';
$string['noresponse'] = '[Brak odpowiedzi]';
$string['notagfiltersapplied'] = 'Nie zastosowano filtrów tagów';
$string['notanswered'] = 'Nie udzielono odpowiedzi';
$string['notchanged'] = 'Nie zmienione od ostatniego podejścia';
$string['notenoughanswers'] = 'Ten typ pytania wymaga co najmniej {$a} odpowiedzi';
$string['notenoughdatatoeditaquestion'] = 'Ani ID pytania ani ID kategorii i typ pytania nie zostały określone.';
$string['notenoughdatatomovequestions'] = 'Podaj id pytań, które chcesz przesunąć.';
$string['notgraded'] = 'Nie oceniono';
$string['notshown'] = 'Nie pokazano';
$string['notyetanswered'] = 'Nie udzielono odpowiedzi';
$string['notyourpreview'] = 'Ten podgląd nie należy do ciebie';
$string['novirtualquestiontype'] = 'Brak wirtualnego typu pytania dla typu pytania {$a}';
$string['numqas'] = 'Liczba podejść do pytania';
$string['numquestions'] = 'Liczba pytań';
$string['numquestionsandhidden'] = '{$a->numquestions} (+{$a->numhidden} ukrytych +{$a->numdraft} szkic/ów)';
$string['options'] = 'Opcje';
$string['otherbanks'] = 'Inne aktywności z pytaniami';
$string['otherbanksdesc'] = 'Te aktywności również zawierają pytania, ale nie mogą być one udostępnian.';
$string['otherquestionbank'] = 'Inne banki pytań';
$string['otherquestionbankstoomany'] = '> {$a} wyników, proszę sprecyzować wyszukiwanie.';
$string['page-question-category'] = 'Strona kategorii pytań';
$string['page-question-edit'] = 'Strona edycji pytania';
$string['page-question-export'] = 'Strona eksportu pytań';
$string['page-question-import'] = 'Strona importu pytań';
$string['page-question-x'] = 'Dowolna strona pytania';
$string['parent'] = 'Nadrzędny';
$string['parentcategory'] = 'Kategoria nadrzędna';
$string['parentcategory_help'] = 'Kategoria nadrzędna to ta, w której  zostanie umieszczona nowa kategoria. "Top" oznacza, że ta kategoria nie jest zawarta w żadnej innej. Konteksty Konteksty kategorii są wyświetlane pogrubioną czcionką. Musi być co najmniej jedna kategoria (Default) w każdym kontekście.';
$string['parentcategory_link'] = 'question/category';
$string['parenthesisinproperclose'] = 'Nawias przed ** nie jest prawidłowo zamknięty w {$a}**';
$string['parenthesisinproperstart'] = 'Nawias przed ** nie jest prawidłowo otwarty w {$a}**';
$string['parsingquestions'] = 'Wczytywanie pytań z pliku importu.';
$string['partiallycorrect'] = 'Częściowo poprawnie';
$string['partiallycorrectfeedback'] = 'Dla każdej częściowo poprawnej odpowiedzi';
$string['partiallycorrectfeedbackdefault'] = 'Twoja odpowiedź jest częściowo poprawna.';
$string['penaltyfactor'] = 'Mnożnik kary';
$string['penaltyfactor_help'] = '<p>Możesz określić ile ma zostać odjęte za każdym razem od nieprawidłowej odpowiedzi. To działa tylko gdy test jest w trybie adaptacyjnym w którym student może wielekrotnie odpowiadać na pytanie. Współczynnik kary może być liczbą od 0 do 1. Współczynnik kary równy 1 oznacza że student musi udzielić poprawnej odpowiedzi za 1 razem. Współczynnik kary równy 0 oznacza ze student może próbować odpowiadać dowolną liczbę razy i wciąż dostanie maksymalną liczbę punktów za pytanie. </p>';
$string['penaltyforeachincorrecttry'] = 'Kara dla każdej błędnej próby';
$string['penaltyforeachincorrecttry_help'] = 'Po uruchomieniu na pytania w trybie "Interaktywny z powtórzeniami" lub "adaptacyjny" zachowanie, w których student ma kilka prób, aby prawidłowo odpowiedzieć na pytanie, ta opcja decyduje, jakie są następstwa każdej nieudanej próby.

Kara wyrażana jest jako ułamek całkowitej oceny za pytanie, więc jeśli pytanie jest warte 3 punkty, a kara wynosi 0.3333333, to student zdobędzie 3 p, jeśli odpowie dobrze za pierwszym razem, 2 p - jeśli za drugim, a 1 p - jeśli dopiero w trzeciej próbie.

W niektórych wieloczęściowych pytaniach ta logika punktacji jest stosowana odrębnie do każdej części pytania. Szczegóły zależą od typu pytania i mogą byś skomplikowane, ale zasadą jest, aby dać studentowi punkt za wiedzę jak najbardziej sprawiedliwie.';
$string['permissionedit'] = 'Edytuj to pytanie.';
$string['permissionmove'] = 'Przesuń to pytanie.';
$string['permissionsaveasnew'] = 'Zapisz to pytanie jako nowe.';
$string['permissionto'] = 'Masz uprawnienia do:';
$string['previewbank'] = 'Podgląd udostępnionego banku pytań';
$string['previewquestion'] = 'Podgląd pytania: {$a}';
$string['privacy:metadata:database:question'] = 'Szczegóły dotyczące określonego pytania.';
$string['privacy:metadata:database:question:createdby'] = 'Osoba, która utworzyła pytanie.';
$string['privacy:metadata:database:question:generalfeedback'] = 'Ogólna opinia zwrotna dla tego pytania.';
$string['privacy:metadata:database:question:modifiedby'] = 'Osoba, która ostatnio zaktualizowała pytanie.';
$string['privacy:metadata:database:question:name'] = 'Nazwa pytania.';
$string['privacy:metadata:database:question:questiontext'] = 'Tekst pytania.';
$string['privacy:metadata:database:question:timecreated'] = 'Data i godzina utworzenia tego pytania.';
$string['privacy:metadata:database:question:timemodified'] = 'Data i godzina aktualizacji tego pytania.';
$string['privacy:metadata:database:question_attempt_step_data'] = 'W krokach dotyczących próby pytań mogą znajdować się dodatkowe dane dotyczące tego kroku. Dane są przechowywane w tabeli step_data.';
$string['privacy:metadata:database:question_attempt_step_data:name'] = 'Nazwa elementu danych.';
$string['privacy:metadata:database:question_attempt_step_data:value'] = 'Wartość elementu danych.';
$string['privacy:metadata:database:question_attempt_steps'] = 'Każda próba pytania ma kilka kroków, aby wskazać różne fazy od początku do końca, aż do oznaczenia. Ta tabela przechowuje informacje dla każdego z tych kroków.';
$string['privacy:metadata:database:question_attempt_steps:fraction'] = 'Ocena przyznana tej próbie pytania została przeskalowana do wartości poza 1.';
$string['privacy:metadata:database:question_attempt_steps:timecreated'] = 'Data i godzina rozpoczęcia przejścia tego etapu.';
$string['privacy:metadata:database:question_attempt_steps:userid'] = 'Użytkownik, który wykonał przejście etapowe.';
$string['privacy:metadata:database:question_attempts'] = 'Informacja o próbie konkretnego pytania.';
$string['privacy:metadata:database:question_attempts:flagged'] = 'Wskazanie, że użytkownik oznaczył to pytanie w ramach próby.';
$string['privacy:metadata:database:question_attempts:responsesummary'] = 'Podsumowanie odpowiedzi na pytanie.';
$string['privacy:metadata:database:question_attempts:timemodified'] = 'Czas aktualizacji pytania.';
$string['privacy:metadata:database:question_bank_entries'] = 'Szczegóły dotyczące konkretnego wpisu w banku pytań.';
$string['privacy:metadata:database:question_bank_entries:ownerid'] = 'Osoba, która jest właścicielem wpisu banku pytań.';
$string['privacy:metadata:link:qbehaviour'] = 'Podsystem Pytań korzysta z wtyczki Zachowanie pytań.';
$string['privacy:metadata:link:qformat'] = 'Podsystem Pytań korzysta z wtyczki Format pytań, która umożliwia importowanie i eksportowanie pytań w różnych formatach.';
$string['privacy:metadata:link:qtype'] = 'Podsystem Pytań współpracuje z wtyczką Typu pytań, która zawiera różne typy pytań.';
$string['published'] = 'współdzielony';
$string['qbanknotfound'] = 'Wtyczka banku pytań \'{$a}\' nie istnieje lub nie jest rozpoznawana.';
$string['qtypeveryshort'] = 'T';
$string['question_version'] = 'Wersja pytania';
$string['question_versionshort'] = 'wer. {$a}';
$string['questionaffected'] = '<a href="{$a->qurl}">Pytanie "{$a->name}" ({$a->qtype})</a> istnieje w tej kategorii pytań, ale także jest używane w <a href="{$a->qurl}"> teście "{$a->quizname}"</a> w innym kursie "{$a->coursename}".';
$string['questionbank'] = 'Baza pytań';
$string['questionbank_plural'] = 'Banki pytań';
$string['questionbanknavigation'] = 'Nawigacja trzeciego stopnia banku pytań';
$string['questionbehaviouradminsetting'] = 'Ustawienia trybu działania testu';
$string['questionbehavioursdisabled'] = 'Tryby działania testu do wyłączenia';
$string['questionbehavioursdisabledexplained'] = 'Wpisz rozdzieloną przecinkami listę trybów, których nie chcesz wyświetlić w menu rozwijanym';
$string['questionbehavioursorder'] = 'Kolejność trybów testowania';
$string['questionbehavioursorderexplained'] = 'Wpisz rozdzieloną przecinkami listę trybów, które chcesz wyświetlić w menu rozwijanym';
$string['questioncategories'] = 'Kategorie pytań';
$string['questioncategory'] = 'Kategoria pytań';
$string['questioncatsfor'] = 'Kategorie pytań dla \'{$a}\'';
$string['questiondefaultssave'] = 'Zapisz opcje pytań jako domyślne ustawienia preferencji użytkownika';
$string['questiondefaultssave_desc'] = 'Czy opcje pytania, takie jak „Domyślny znak”, „Jedna czy wiele odpowiedzi?” itp. powinny być zapisywane jako preferencje użytkownika po przesłaniu formularza edycji pytania, aby były używane jako domyślne przy następnym dostępie użytkownika do formularza.';
$string['questiondoesnotexist'] = 'To pytanie nie istnieje';
$string['questionediting'] = 'Edycja pytań';
$string['questionediting_desc'] = 'Ustawienia te mają zastosowanie do formularzy edycji pytań.';
$string['questionformtagheader'] = '{$a} tagi';
$string['questionidmismatch'] = 'Niezgodność id pytań';
$string['questionloaderror'] = 'Nie udało się wczytać opcji pytań.';
$string['questionname'] = 'Nazwa pytania';
$string['questionnameandquestionversion'] = '{$a->name} wer. {$a->version}';
$string['questionnamecopy'] = '{$a} (kopia)';
$string['questionno'] = 'Pytanie {$a}';
$string['questionpreviewdefaults'] = 'Domyślny podgląd pytania';
$string['questionpreviewdefaults_desc'] = 'Te domyślne wartości są używane, gdy użytkownik pierwszy raz  przegląda pytanie w banku pytań. Gdy użytkownik zobaczy pytanie, jego osobiste ustawienia są przechowywane jako preferencje użytkownika.';
$string['questions'] = 'Pytania';
$string['questionsaveerror'] = 'Wystąpiły błędy podczas zapisywania pytania - ({$a})';
$string['questionsinuse'] = '* Oznacza pytania, których nie można usunąć, ponieważ są używane. Zamiast tego zostaną one ukryte w banku pytań, chyba że opcja „Pokaż ukryte pytania” zostanie ustawiona na „Tak”.';
$string['questionsmovedto'] = 'Pytania będące nadal w użyciu, przeniesiono do "{$a}" w nadrzędnej kategorii.*';
$string['questionsrescuedfrom'] = 'Zachowane pytania z kontekstu {$a} .';
$string['questionsrescuedfrominfo'] = 'Te pytania (niektóre z nich mogą być ukryte) zostały zachowane, gdy kontekst {$a} został usunięty, ponieważ są one nadal używane w niektórych testach lub innych aktywnościach.';
$string['questiontags'] = 'Tagi pytania';
$string['questiontext'] = 'Treść pytania';
$string['questiontype'] = 'Typ pytania';
$string['questionuse'] = 'Użyj pytania w tej aktywności';
$string['questionvariant'] = 'Wariant pytania';
$string['questionx'] = 'Pytanie {$a}';
$string['quizquestionbank'] = 'Ten bank pytań';
$string['recentlyviewedquestionbanks'] = 'Ostatnio przeglądane banki pytań';
$string['requiresgrading'] = 'Wymaga oceny';
$string['responsehistory'] = 'Historia odpowiedzi';
$string['restart'] = 'Rozpocznij ponownie';
$string['restartwiththeseoptions'] = 'Zapisz opcje podglądu i zacznij od nowa';
$string['restoremultipletopcats'] = 'Plik kopii zapasowej zawiera więcej niż jedną kategorię pytań najwyższego poziomu dla kontekstu {$a}.';
$string['reviewresponse'] = 'Przeglądaj odpowiedzi';
$string['rightanswer'] = 'Prawidłowa odpowiedź';
$string['rightanswer_help'] = 'Automatycznie wygenerowane podsumowanie poprawnych odpowiedzi. Może to być ograniczone, więc możesz rozważyć wyjaśnienie poprawnego rozwiązania w ogólnej zwrotnej odpowiedzi dla pytania, i wyłączenie tej opcji.';
$string['save'] = 'Zapisz';
$string['savechangesandcontinueediting'] = 'Zapisz zmiany i kontynuuj edycję';
$string['saved'] = 'Zapisano: {$a}';
$string['saveflags'] = 'Zapisz stan flag';
$string['selectacategory'] = 'Wybierz kategorię:';
$string['selectaqtypefordescription'] = 'Wybierz rodzaj pytania, aby zobaczyć jego opis.';
$string['selectcategoryabove'] = 'Wybierz jedną z powyższych kategorii';
$string['selectquestionsforbulk'] = 'Wybierz pytania do czynności zbiorczej';
$string['settingsformultipletries'] = 'Wiele prób';
$string['shareincontext'] = 'Udostępnij w kontekście {$a}';
$string['shortversioninfo'] = 'v{$a->version} (z {$a->latestversion})';
$string['shortversioninfolatest'] = 'v{$a->version} (najnowsza)';
$string['showhidden'] = 'Pokaż ukryte pytania';
$string['showmarkandmax'] = 'Pokaż punkty i maksimum';
$string['showmaxmarkonly'] = 'Pokaż tylko maksymalną liczbę punktów';
$string['shown'] = 'Pokazano';
$string['shownumpartscorrect'] = 'Pokaż liczbę poprawnych odpowiedzi';
$string['shownumpartscorrectwhenfinished'] = 'Pokaż liczbę poprawnych odpowiedzi po zakończeniu pytania';
$string['showquestiontext'] = 'Czy pokazać tekst pytania na liście pytań?';
$string['showquestiontext_full'] = 'Tak, z obrazami, mediami, itp.';
$string['showquestiontext_off'] = 'Nie';
$string['showquestiontext_plain'] = 'Tak, tylko tekst';
$string['specificfeedback'] = 'Szczegółowa inf. zwrotna';
$string['specificfeedback_help'] = 'Informacja zwrotna zależy od odpowiedzi udzielonej przez studenta.';
$string['started'] = 'Rozpoczęto';
$string['state'] = 'Stan';
$string['step'] = 'Krok';
$string['steps'] = 'Kroki';
$string['stoponerror'] = 'Zatrzymaj na błędzie';
$string['stoponerror_help'] = 'To ustawienie określa, czy proces importowania ma się zatrzymać, gdy zostanie wykryty błąd (wtedy żadne pytanie nie zostanie zaimportowane), czy pytania zawierające błędy mają być ignorowane, ale pozostałe - importowane.';
$string['submissionoutofsequence'] = 'Zaburzona poprawna sekwencja stron testu. Nie klikaj przycisku Wstecz podczas pracy z testem.';
$string['submissionoutofsequencefriendlymessage'] = 'Próbujesz wprowadzić dane poza normalną sekwencją stron. Taka sytuacja może wystąpić, jeśli używasz w swojej przeglądarce przycisków Wstecz lub Do przodu; proszę ich nie używać w trakcie testu. Może się to również zdarzyć, jeśli klikniesz na coś podczas ładowania strony. Kliknij przycisk <strong>Kontynuuj,</strong>, aby wznowić.';
$string['submit'] = 'Zatwierdź';
$string['submitandfinish'] = 'Zatwierdź i zakończ';
$string['submitted'] = 'Zatwierdź: {$a}';
$string['switchbank'] = 'Zmień bank pytań';
$string['systembank'] = 'Współdzielony bank pytań systemowych';
$string['systembankdescription'] = 'Ta baza pytań została utworzona automatycznie podczas aktualizacji witryny.';
$string['tagarea_question'] = 'Pytania';
$string['technicalinfo'] = 'Dane techniczne';
$string['technicalinfo_help'] = 'Niniejsza informacja techniczna jest prawdopodobnie tylko użyteczna dla programistów pracujących nad nowymi typami pytań. Może to również być pomocne przy diagnozowaniu problemów z pytaniami.';
$string['technicalinfomaxfraction'] = 'Maksymalna część: {$a}';
$string['technicalinfominfraction'] = 'Minimalna część: {$a}';
$string['technicalinfoquestionsummary'] = 'Podsumowanie pytania: {$a}';
$string['technicalinforesponsesummary'] = 'Podsumowanie odpowiedzi: {$a}';
$string['technicalinforightsummary'] = 'Podsumowanie poprawnej odpowiedzi: {$a}';
$string['technicalinfostate'] = 'Stan pytania: {$a}';
$string['technicalinfovariant'] = 'Wariant pytania: {$a}';
$string['tofilecategory'] = 'Zapisz kategorię do pliku';
$string['tofilecontext'] = 'Zapisz kontekst do pliku';
$string['topfor'] = 'Najwyższe dla {$a}';
$string['uninstallbehaviour'] = 'Odinstaluj ten tryb';
$string['uninstallqtype'] = 'Odinstaluj ten typ pytania.';
$string['unknown'] = 'Nieznany';
$string['unknownbehaviour'] = 'Nieznany tryb: {$a}.';
$string['unknownorunhandledtype'] = 'Nieznany lub nieobsługiwany typ pytania: {$a}';
$string['unknownquestion'] = 'Nieznane pytanie: {$a}.';
$string['unknownquestioncatregory'] = 'Nieznana kategoria pytań: {$a}.';
$string['unknownquestiontype'] = 'Nieznany typ pytania: {$a}.';
$string['unknowntolerance'] = 'Nieznany typ tolerancji {$a}';
$string['unpublished'] = 'nieudostępniony';
$string['unusedcategorydeleted'] = 'Kategoria została usunięta, gdyż, po usunięciu kursu jej pytania nie były wykorzystane.';
$string['updatedisplayoptions'] = 'Aktualizuj opcje wyświetlania';
$string['upgradeproblemcategoryloop'] = 'Wykryto problem podczas aktualizacji kategorii pytań. Jest pętli w drzewie kategorii. Dotyczy kategorii id: {$a}.';
$string['upgradeproblemcouldnotupdatecategory'] = 'Nie można zaktualizować kategorii {$a->name} ({$a->id}).';
$string['upgradeproblemunknowncategory'] = 'Wykryto problem podczas aktualizacji kategorii pytań. Kategoria {$a->id} odwołuje się do kategorii nadrzędnej {$a->parent}, która nie istnieje. Zmieniono kategorię nadrzędną, aby naprawić problem.';
$string['version_selection'] = 'Wersja {$a->version}';
$string['versioninfo'] = 'Wersja {$a->version} (z {$a->latestversion})';
$string['versioninfolatest'] = 'Wersja {$a->version} (najnowsza)';
$string['versioninfolatestshort'] = 'wer. {$a} (najnowsza)';
$string['whethercorrect'] = 'Czy poprawnie';
$string['whethercorrect_help'] = 'To obejmuje zarówno opis tekstowy \'Poprawny\', \'Częściowo poprawny\' lub \'Niepoprawny\' i każde podkolorowane podświetlenie, które przekazuje te same informacje.';
$string['whichtries'] = 'Które próby';
$string['withselected'] = 'Z zaznaczonymi';
$string['wrongprefix'] = 'Błędnie sformatowany nameprefix {$a}';
$string['xoutofmax'] = '{$a->mark} z {$a->max}';
$string['yougotnright'] = 'Poprawnie wybrałeś (-łaś): {$a->num}.';
$string['youmustselectaqtype'] = 'Musisz wybrać typ pytania.';
$string['yourfileshoulddownload'] = 'Pobranie pliku eksportu powinno wkrótce się rozpocząć. Jeśli nie, proszę <a href="{$a}">kliknąć tutaj</a>.';
