<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'moodle', language 'pl', version '5.0'.
 *
 * @package     moodle
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abouttobeinstalled'] = 'zostanie za chwilę zainstalowany';
$string['accept'] = 'Akceptuj';
$string['action'] = 'Akcja';
$string['actionchoice'] = 'Co chciałbyś zrobić z plikiem \'{$a}\'?';
$string['actions'] = 'Akcje';
$string['actionsfor'] = 'Akcja dla {$a}';
$string['actionsmenu'] = 'Menu akcji';
$string['active'] = 'Aktywny(a)';
$string['activeusers'] = 'Aktywni użytkownicy';
$string['activities'] = 'Aktywności';
$string['activities_help'] = 'Aktywności, takie jak forum, testy i wiki umożliwiają dodanie interaktywnych treści do kursu.';
$string['activity'] = 'Aktywność';
$string['activityclipboard'] = 'Przenoszenie tej aktywności: {$a}';
$string['activityheader'] = 'Menu aktywności';
$string['activityicon'] = '{$a} ikona';
$string['activityiscurrentlyhidden'] = 'Ta aktywność jest obecnie ukryta';
$string['activitymodule'] = 'Moduł aktywności';
$string['activitymodules'] = 'Moduły aktywności';
$string['activitynotready'] = 'Aktywność nie jest jeszcze gotowa';
$string['activityorresource'] = 'Aktywność lub zasób';
$string['activityreport'] = 'Raport aktywności';
$string['activityreports'] = 'Raporty aktywności';
$string['activityselect'] = 'Wybierz aktywność, która ma być przeniesiona';
$string['activitysince'] = 'Aktywność od {$a}';
$string['activitytypetitle'] = '{$a->activity} - {$a->type}';
$string['activityweighted'] = 'Aktywności na użytkownika';
$string['add'] = 'Dodaj';
$string['addactivity'] = 'Dodaj aktywność...';
$string['addactivitytosection'] = 'Dodaj aktywność do sekcji \'{$a}\'';
$string['addadmin'] = 'Dodaj admina';
$string['addblock'] = 'Dodaj blok';
$string['addcomment'] = 'Dodaj komentarz...';
$string['addcondition'] = 'Dodaj warunek';
$string['addcontent'] = 'Dodaj zawartość';
$string['addcountertousername'] = 'Utwórz użytkownika poprzez dodanie liczby do nazwy użytkownika';
$string['addcreator'] = 'Dodaj autora kursu';
$string['adddots'] = 'Dodaj...';
$string['added'] = 'Dodano {$a}';
$string['addedtogroup'] = 'Dodano do grupy "{$a}"';
$string['addedtogroupnot'] = 'Nie dodano do grupy "{$a}"';
$string['addedtogroupnotenrolled'] = 'Nie dodano do grupy {$a}, ponieważ ta osoba nie jest uczestnikiem kursu';
$string['addfilehere'] = 'Upuść pliki tutaj, aby dodać je na dole tej sekcji';
$string['addfilesdrop'] = 'Możesz przeciągnąć i upuścić tutaj pliki, aby je przesłać lub kliknąć, aby je wybrać.';
$string['addinganew'] = 'Nowe {$a}';
$string['addingdatatoexisting'] = 'Dodawanie danych do istniejących';
$string['additionalcustomnav'] = 'Dodatkowa niestandardowa nawigacja';
$string['additionalnames'] = 'Dodatkowe nazwy';
$string['addlinkhere'] = 'Wstaw link tutaj';
$string['addnew'] = 'Dodaj nowy {$a}';
$string['addnewcategory'] = 'Dodaj nową kategorię';
$string['addnewcourse'] = 'Dodaj nowy kurs';
$string['addnewuser'] = 'Dodaj nowego użytkownika';
$string['addnousersrecip'] = 'Dodaj użytkowników, którzy nie uzyskali dostępu do {$a} do listy odbiorców';
$string['addpagehere'] = 'Wstaw tekst tutaj';
$string['addresource'] = 'Dodaj zasób...';
$string['addresourceoractivity'] = 'Dodaj aktywność lub zasób';
$string['addresourcetosection'] = 'Dodaj zasób do sekcji \'{$a}\'';
$string['address'] = 'Adres';
$string['addsections'] = 'Dodaj sekcję';
$string['addstudent'] = 'Dodaj studenta';
$string['addsubcategory'] = 'Dodaj podkategorię';
$string['addteacher'] = 'Dodaj nauczyciela';
$string['admin'] = 'Admin';
$string['adminhelpaddnewuser'] = 'Aby ręcznie utworzyć nowe konto użytkownika';
$string['adminhelpassignadmins'] = 'Administratorzy mogą zmieniać wszystkie ustawienia i dowolnie się przemieszczać w obrębie tego serwisu';
$string['adminhelpassigncreators'] = 'Autorzy kursów mogą tworzyć nowe kursy';
$string['adminhelpassignsiteroles'] = 'Przypisz zdefiniowane role w serwisie konkretnym użytkownikom';
$string['adminhelpassignstudents'] = 'Przejdź do kursu i dodaj studentów w menu Administracja';
$string['adminhelpauthentication'] = 'Możesz korzystać z wewnętrznych kont użytkowników lub z zewnętrznej bazy danych';
$string['adminhelpbackup'] = 'Skonfiguruj opcje automatycznego tworzenia kopii zapasowych';
$string['adminhelpconfiguration'] = 'Konfiguracja wyglądu i działania serwisu';
$string['adminhelpconfigvariables'] = 'Konfiguracja zmiennych odpowiedzialnych za działanie serwisu';
$string['adminhelpcourses'] = 'Zdefiniuj kursy i kategorie, dodaj do nich użytkowników, edytuj kursy oczekujące';
$string['adminhelpeditorsettings'] = 'Zdefiniuj podstawowe parametry edytora HTML';
$string['adminhelpedituser'] = 'Przeglądaj listę kont użytkowników i modyfikuj dowolne z nich';
$string['adminhelpenvironment'] = 'Sprawdź, czy Twój serwer spełnia wymaganiom bieżącej i przyszłej instalacji';
$string['adminhelpfailurelogs'] = 'Przeglądaj logi nieudanych logowań';
$string['adminhelplanguage'] = 'Do sprawdzania i edycji aktualnego pakietu językowego';
$string['adminhelplogs'] = 'Przejrzyj logi wszystkich działań w obrębie serwisu';
$string['adminhelpmanageblocks'] = 'Zarządzaj zainstalowanymi blokami i ich ustawieniami';
$string['adminhelpmanagedatabase'] = 'Bezpośredni dostęp do bazy danych (bądź ostrożny!)';
$string['adminhelpmanagefilters'] = 'Określ filtry tekstu i inne parametry';
$string['adminhelpmanagemodules'] = 'Zarządzaj zainstalowanymi modułami i ich ustawieniami';
$string['adminhelpmanageroles'] = 'Utwórz i zdefiniuj role, które mogą być przypisane użytkownikom';
$string['adminhelpmymoodle'] = 'Konfiguruj blok \'Mój Moodle\' dla użytkowników';
$string['adminhelpreports'] = 'Ranking kursów z uwzględnieniem różnorodnych kryteriów';
$string['adminhelpsitefiles'] = 'Do publikowania plików ogólnych lub przesyłania zewnętrznych kopii zapasowych';
$string['adminhelpsitesettings'] = 'Definiuj wygląd strony głównej serwisu';
$string['adminhelpstickyblocks'] = 'Skonfiguruj wymuszone bloki Moodle';
$string['adminhelpthemes'] = 'Zdefiniuj wyglądu serwisu (kolory, czcionki itp.)';
$string['adminhelpuploadusers'] = 'Importuj konta użytkowników z pliku tekstowego';
$string['adminhelpusers'] = 'Zdefiniuj użytkowników i mechanizm uwierzytelniania';
$string['adminhelpxmldbeditor'] = 'Interfejs do edycji plików XMLDB.';
$string['administration'] = 'Administracja';
$string['administrationsite'] = 'Administracja serwisu';
$string['administrator'] = 'Administrator';
$string['administratordescription'] = 'Administratorzy mogą zwykle robić dowolne rzeczy na stronie, we wszystkich kursach.';
$string['administrators'] = 'Administratorzy';
$string['administratorsall'] = 'Wszyscy Administratorzy';
$string['administratorsandteachers'] = 'Administratorzy i nauczyciele';
$string['advanced'] = 'Zaawansowane';
$string['advancedfilter'] = 'Zaawansowane wyszukiwanie';
$string['advancedsettings'] = 'Opcje zaawansowane';
$string['afterresource'] = 'Po zasobie "{$a}"';
$string['aftersection'] = 'Po sekcji "{$a}"';
$string['again'] = 'ponownie';
$string['agelocationverification'] = 'Weryfikacja wieku i lokalizacji';
$string['ajaxuse'] = 'AJAX i Javascript';
$string['all'] = 'Wszystkie';
$string['allactions'] = 'Wszystkie czynności';
$string['allactivities'] = 'Wszystkie aktywności';
$string['allcategories'] = 'Wszystkie kategorie';
$string['allchanges'] = 'Wszystkie zmiany';
$string['alldays'] = 'Wszystkie dni';
$string['allfiles'] = 'Wszystkie pliki';
$string['allgroups'] = 'Wszystkie grupy';
$string['alllogs'] = 'Wszystkie logi';
$string['allmods'] = 'Wszystkie {$a}';
$string['allow'] = 'Zezwól';
$string['allowinternal'] = 'Zezwól również na wewnętrzne metody';
$string['allownone'] = 'Nie zezwalaj nikomu';
$string['allownot'] = 'Nie zezwalaj';
$string['allowstealthmodules'] = 'Zezwól na ukryte aktywności';
$string['allowstealthmodules_help'] = 'Jeśli ta opcja jest włączona, aktywności mogą być dostępne, ale nie są widoczne w widocznych sekcjach strony kursu. W związku z tym linki do ukrytych działań muszą być dostarczane z innych źródeł, na przykład z zasobu strony. Ukryte aktywności są nadal wymienione w dzienniku i innych raportach.';
$string['allparticipants'] = 'Wszyscy uczestnicy';
$string['allteachers'] = 'Wszyscy nauczyciele';
$string['alphanumerical'] = 'Może zawierać wyłącznie litery alfabetu i cyfry, myślnik (-) oraz kropkę (.)';
$string['alreadyconfirmed'] = 'Rejestracja została już potwierdzona';
$string['alternatename'] = 'Alternatywna nazwa';
$string['always'] = 'Zawsze';
$string['and'] = '{$a->one} i {$a->two}';
$string['answer'] = 'Odpowiedź';
$string['any'] = 'Którykolwiek';
$string['appearance'] = 'Wygląd';
$string['apply'] = 'Zastosuj';
$string['applyfilters'] = 'Zastosuj filtry';
$string['approve'] = 'Zatwierdź';
$string['areyousure'] = 'Czy jesteś pewny?';
$string['areyousuretorestorethis'] = 'Czy chcesz kontynuować?';
$string['areyousuretorestorethisinfo'] = 'W dalszej części tego procesu będziesz miał możliwość dodania zawartości tej kopii zapasowej do istniejącego kursu lub utworzenia zupełnie nowego kursu.';
$string['asc'] = 'Rosnąco';
$string['assessment'] = 'Ocena';
$string['assignadmins'] = 'Przypisz administratorów';
$string['assigncreators'] = 'Przypisz autorów kursów';
$string['assignedrolecount'] = '{$a->role}: {$a->count}';
$string['assignsiteroles'] = 'Przypisz role w obrębie całego serwisu';
$string['authenticateduser'] = 'Uwierzytelniony użytkownik';
$string['authenticateduserdescription'] = 'Wszyscy zalogowani użytkownicy';
$string['authentication'] = 'Uwierzytelnianie';
$string['authenticationplugins'] = 'Wtyczki uwierzytelniania';
$string['autosubscribe'] = 'Automatyczny zapis na forum';
$string['autosubscribeno'] = 'Nie, nie zapisuj mnie automatycznie na fora';
$string['autosubscribeyes'] = 'Tak: włącz subskrypcję dyskusji, w której jest mój wpis';
$string['availability'] = 'Dostępność';
$string['availablecourses'] = 'Dostępne kursy';
$string['back'] = 'Powrót';
$string['backto'] = 'Wróć do {$a}';
$string['backtocourselisting'] = 'Powrót do listy kursów';
$string['backtohome'] = 'Powrót do strony głównej';
$string['backtopageyouwereon'] = 'Wróć do poprzedniej strony';
$string['backup'] = 'Kopia zapasowa';
$string['backupactivehelp'] = 'Zaznacz, aby kopie zapasowe były tworzone automatycznie.';
$string['backupadhocpending'] = 'Oczekujące zadanie tworzenia kopii zapasowych kursu w trybie ad hoc';
$string['backupcancelled'] = 'Tworzenie kopii zapasowej zostało anulowane';
$string['backupcoursefileshelp'] = 'Zaznacz, aby dołączać pliki kursu do kopii zapasowej.';
$string['backupdate'] = 'Data kopii zapasowej';
$string['backupdatenew'] = '&nbsp; {$a->TAG} jest teraz {$a->weekday}, {$a->mday} {$a->month} {$a->year}<br />';
$string['backupdateold'] = '{$a->TAG} był {$a->weekday}, {$a->mday} {$a->month} {$a->year}';
$string['backupdaterecordtype'] = '<br />{$a->recordtype} - {$a->recordname}<br />';
$string['backupdetails'] = 'Szczegóły kopii zapasowej';
$string['backuperrorinvaliddestination'] = 'Docelowy folder dla kopii zapisowej nie istnieje lub nie ma praw zapisu.';
$string['backupexecuteathelp'] = 'Wybierz, o której godzinie mają być tworzone automatyczne kopie zapasowe.';
$string['backupfailed'] = 'Nie zapisałeś wszystkich kursów!!';
$string['backupfilename'] = 'kopia zapasowa';
$string['backupfinished'] = 'Tworzenie kopii zapasowych zakończyło się sukcesem';
$string['backupfromthissite'] = 'Czy robiłeś już kopię zapasową?';
$string['backupgradebookhistoryhelp'] = 'Ustawienie tej opcji jako aktywnej spowoduję, że zmiany w dzienniku ocen znajdą się w automatycznie tworzonej kopii zapasowej. Zauważ, że historia ocen nie może być wyłączona w ustawieniach serwera aby bieżąca opcja działała.';
$string['backupincludemoduleshelp'] = 'Zaznacz, aby dane z modułów kursów były zapisywane w automatycznych kopiach zapasowych.';
$string['backupincludemoduleuserdatahelp'] = 'Zaznacz, aby dane użytkowników były zapisywane w automatycznych kopiach zapasowych.';
$string['backupinfo'] = 'Wykonaj kopię zapasową tego kursu, łącznie z całą treścią i aktywnościami. Możesz użyć pliku kopii zapasowej, aby przywrócić ten kurs lub użyć go w innej witrynie.';
$string['backuplogdetailed'] = 'Szczegółowy dziennik wykonań';
$string['backuploglaststatus'] = 'Ostatni dziennik wykonań';
$string['backupmissinguserinfoperms'] = 'Uwaga: Ta kopia zapasowa nie zawiera danych użytkownika. Ćwiczenia i warsztaty nie zostaną uwzględnione w kopii zapasowej, ponieważ moduły te nie są zgodne z tym typem kopii zapasowej.';
$string['backupnext'] = 'Następna kopia zapasowa';
$string['backupnonisowarning'] = 'Uwaga: Ta kopia pochodzi z innej niż Unicode wersji Moodle (przed 1.6). Jeżeli kopia zawiera teksty o innym kodowaniu niż ISO-8859-1, mogą zostać one USZKODZONE podczas próby odtwarzania ich w obecnej wersji Unicode Moodle. Więcej informacji, o poprawnym odtwarzaniu kopii zapasowych dla tej wersji Moodle, znajdziesz na stronie <a href="http://docs.moodle.org/en/Backup_FAQ">Backup FAQ</a>.';
$string['backupnotyetrun'] = 'Oczekująca automatyczna kopia zapasowa';
$string['backuporiginalname'] = 'Nazwa kopii zapasowej';
$string['backuproleassignments'] = 'Archiwizuj przydzielone role dla tych ról';
$string['backupsavetohelp'] = 'Pełna ścieżka dostępu do katalogu, w którym chcesz zapisać pliki kopii zapasowej';
$string['backupsitefileshelp'] = 'Jeśli włączysz, wtedy pliki głównej strony użyte w kursach będą dołączane do automatycznych kopii zapasowych.';
$string['backuptakealook'] = 'Sprawdź logi kopii zapasowej w:
{$a}';
$string['backupuserfileshelp'] = 'Określ, czy pliki użytkownika (np. zdjęcie) mają być zapisane w automatycznej kopii zapasowej';
$string['backupversion'] = 'Wersja kopii zapasowej';
$string['badges'] = 'Odznaki';
$string['between'] = 'Pomiędzy';
$string['block'] = 'Blok';
$string['blockconfiga'] = 'Konfigurowanie bloku {$a}';
$string['blockconfigbad'] = 'Ten blok nie został poprawnie wprowadzony i dlatego nie może udostępnić interfejsu konfiguracji.';
$string['blocks'] = 'Bloki';
$string['blocks_main'] = 'Główne bloki treści';
$string['blocks_supplementary'] = 'Bloki uzupełniające';
$string['blocksaddedit'] = 'Dodaj/Modyfikuj bloki';
$string['blockseditoff'] = 'Wyłącz edycję bloków';
$string['blocksediton'] = 'Włącz edycję bloków';
$string['blocksetup'] = 'Tworzenie tabeli bloków';
$string['blocksuccess'] = '{$a} tabele zostały poprawnie utworzone';
$string['brief'] = 'Krótka';
$string['bulkactions'] = 'Zbiorcze działania';
$string['bulkactionselect'] = '{$a} wybrane masowe działanie';
$string['bulkcancel'] = 'Zamknij edycję zbiorczą';
$string['bulkmovecoursessuccess'] = 'Pomyślnie przeniesiono {$a->courses} kurs(y) do {$a->category}';
$string['bulkselection'] = 'wybranych: {$a}';
$string['bycourseorder'] = 'Według kolejności w kursie';
$string['byname'] = 'przez {$a}';
$string['bypassed'] = 'Ominięty';
$string['cachecontrols'] = 'Kontrola pamięci podręcznej';
$string['calltofeedback'] = 'Twórcy tego oprogramowania chcieliby poznać twoją opinię.';
$string['calltofeedback_give'] = 'Przekaż swoją opinię o tym oprogramowaniu';
$string['calltofeedback_remind'] = 'Przypomnij mi później';
$string['cancel'] = 'Anuluj';
$string['cancelled'] = 'Anulowane';
$string['categories'] = 'Kategorie kursów';
$string['categoriesandcourses'] = 'Kursy i kategorie kursów';
$string['category'] = 'Kategoria';
$string['categoryadded'] = 'Kategoria \'{$a}\' została dodana';
$string['categorybulkaction'] = 'Działania masowe dla wybranych kategorii';
$string['categorycontents'] = 'Podkategorie i kursy';
$string['categorycurrentcontents'] = 'Zawartość {$a}';
$string['categorydeleted'] = 'Kategoria \'{$a}\' została usunięta';
$string['categoryduplicate'] = 'Kategoria o nazwie \'{$a}\' już istnieje!';
$string['categoryheader'] = 'Menu kategorii';
$string['categoryhidden'] = '(ukryte)';
$string['categorymodifiedcancel'] = 'Kategoria zostanie zmieniona. Wybierz Anuluj aby tego nie robić.';
$string['categoryname'] = 'Nazwa kategorii';
$string['categorypath'] = 'Ścieżka kategorii';
$string['categorysubcategoryof'] = '{$a->category} - podkategoria {$a->parentcategory}';
$string['categoryupdated'] = 'Kategoria \'{$a}\' została zaktualizowana';
$string['changedpassword'] = 'Hasło zostało zmienione';
$string['changepassword'] = 'Zmień hasło';
$string['changesmade'] = 'Zmiany dokonane';
$string['changesmadereallygoaway'] = 'Dokonano zmian. Czy na pewno chcesz nawigować dalej i utracić swoje zmiany?';
$string['changessaved'] = 'Zmiany zostały zapisane';
$string['check'] = 'Sprawdź';
$string['checkactual'] = 'Aktualny';
$string['checkall'] = 'Sprawdź wszystko';
$string['checkerror'] = 'Błąd pobierania wyniku sprawdzenia \'{$a}\'. Sprawdź konsolę przeglądarki, aby uzyskać więcej informacji.';
$string['checkexpected'] = 'Oczekiwany';
$string['checkingbackup'] = 'Sprawdzanie kopii zapasowej';
$string['checkingcourse'] = 'Sprawdzanie kursu';
$string['checkingforbbexport'] = 'Sprawdzanie wersji dla platformy e-learning BlackBoard';
$string['checkinginstances'] = 'Sprawdzanie instancji';
$string['checkingsections'] = 'Sprawdzanie sekcji';
$string['checklanguage'] = 'Sprawdzanie języka';
$string['checkloading'] = 'Uzyskanie wyniku sprawdzenia \'{$a}\'';
$string['checknone'] = 'Nic nie sprawdzaj';
$string['checks'] = 'Kontrolki';
$string['checksok'] = 'Wszystkie {$a} są OK';
$string['childcoursenotfound'] = 'Nie znaleziono potomnego kursu';
$string['childcourses'] = 'Kursy podrzędne';
$string['choose'] = 'Wybierz';
$string['choosecourse'] = 'Wybierz kurs';
$string['choosedots'] = 'Wybierz...';
$string['chooselivelogs'] = 'Lub przejrzyj obecną aktywność';
$string['chooselogs'] = 'Wybierz logi, które chcesz obejrzeć';
$string['choosereportfilter'] = 'Wybierz filtr dla raportu';
$string['choosetheme'] = 'Wybierz temat';
$string['chooseuser'] = 'Wybierz użytkownika';
$string['city'] = 'Miasto';
$string['cleaningtempdata'] = 'Usuwanie danych tymczasowych';
$string['clear'] = 'Wyczyść';
$string['clearall'] = 'Wyczyść wszystko';
$string['clearfilterrow'] = 'Usuń rząd filtra';
$string['clearfilters'] = 'Wyczyść filtry';
$string['clearsearch'] = 'Wyczyść okienko wyszukiwania';
$string['clickhelpiconformoreinfo'] = '... dalej ... Kliknij ikonę pomocy by przeczytać cały artykuł.';
$string['clickhere'] = 'Kliknij tutaj ...';
$string['clicktohideshow'] = 'Kliknij, aby rozwinąć lub zwinąć';
$string['closeblockdrawer'] = 'Zamknij szufladę bloków';
$string['closebuttontitle'] = 'Zamknij';
$string['closecourseindex'] = 'Zamknij indeks kursu';
$string['closedrawer'] = 'Zamknij menu';
$string['closewindow'] = 'Zamknij to okno';
$string['collapse'] = 'Minimalizuj';
$string['collapseall'] = 'Zwiń wszystko';
$string['collapsecategory'] = 'Zwiń {$a}';
$string['comebacklater'] = 'Proszę wrócić później';
$string['commentincontext'] = 'Znajdź ten komentarz w kontekście';
$string['comments'] = 'Komentarze';
$string['commentscount'] = 'Komentarze ({$a})';
$string['commentsnotenabled'] = 'Funkcja Komentarze nie jest włączona';
$string['commentsrequirelogin'] = 'Musisz się zalogować, aby zobaczyć komentarze.';
$string['comparelanguage'] = 'Przejrzyj i edytuj bieżący język';
$string['complete'] = 'Ukończone';
$string['completed'] = 'Ukończony';
$string['completereport'] = 'Pełny raport';
$string['configuration'] = 'Konfiguracja';
$string['confirm'] = 'Potwierdź';
$string['confirmaccount'] = 'Potwierdź konto';
$string['confirmcheckfull'] = 'Czy masz absolutną pewność, że chcesz potwierdzić {$a} ?';
$string['confirmcoursemove'] = 'Czy na pewno chcesz przenieść ten kurs ({$a->course}) do tej kategorii ({$a->category})?';
$string['confirmdeletesection'] = 'Czy na pewno chcesz całkowicie usunąć "{$a}" i wszystkie aktywności, które zawiera?';
$string['confirmed'] = 'Twoja rejestracja została potwierdzona';
$string['confirmednot'] = 'Twoja rejestracja nie została jeszcze potwierdzona. Sprawdź swoją skrzynkę e-mail czy otrzymałeś wiadomość o rejestracji.';
$string['considereddigitalminor'] = 'Jesteś zbyt młody, aby założyć konto na tej stronie.';
$string['content'] = 'Zawartość';
$string['contentbank'] = 'Bank treści';
$string['contentexport_aboutthiscourse'] = 'Podsumowanie kursu';
$string['contentexport_coursesummary'] = 'Ten plik jest częścią zawartości pobranej z <a href="{$a->courselink}">{$a->coursename}</a>.';
$string['contentexport_footersummary'] = 'Ten plik jest częścią zawartości pobranej z <a href="{$a->courselink}">{$a->coursename}</a> przez {$a->userfullname} w dniu {$a->date}.';
$string['contentexport_modulesummary'] = 'Ta strona jest częścią zawartości pobranej z <a href="{$a->modulelink}"> {$a->modulename}</a> w dniu {$a->date}. Zwróć uwagę, że niektóre treści i pliki większe niż {$a->maxfilesize} nie są pobierane.';
$string['contentexport_viewfilename'] = 'Zobacz plik {$a}';
$string['context'] = 'Kontekst';
$string['contextlevel'] = 'Poziom kontekstu';
$string['contextname'] = 'Nazwa kontekstu';
$string['contextparent'] = 'Nadrzędny';
$string['contexturl'] = 'Adres URL kontekstu';
$string['continue'] = 'Kontynuuj';
$string['continuetocourse'] = 'Kliknij tutaj, aby wejść do kursu';
$string['convertingwikitomarkdown'] = 'Konwersja wiki do Markdown';
$string['cookiesenabled'] = 'Przyjmowanie cookies (ciasteczek) musi być włączone w Twojej przeglądarce';
$string['cookiesenabled_help'] = 'Na tej stronie używane są dwa pliki cookie:

Podstawowym jest plik cookie sesji, zwykle nazywany MoodleSession. Musisz zezwolić na ten plik cookie w swojej przeglądarce, aby zapewnić ciągłość i pozostać zalogowanym podczas przeglądania strony. Kiedy wylogowujesz się lub zamykasz przeglądarkę, ten plik cookie jest niszczony (w przeglądarce i na serwerze).

Drugi plik cookie jest czysto wygodny, zwykle nazywany MOODLEID lub podobnie. Zapamiętuje on tylko Twoją nazwę użytkownika w przeglądarce. Oznacza to, że kiedy wracasz na tę stronę, pole nazwy użytkownika na stronie logowania jest już wypełnione. Możesz bezpiecznie odrzucić ten plik cookie - będziesz musiał po prostu ponownie wpisać swoją nazwę użytkownika za każdym razem, gdy się logujesz.';
$string['cookiesenabled_help_html'] = 'Ta strona korzysta z dwóch ciasteczek (cookies).<br/><br/>

Najważniejszym z nich jest plik cookie sesji, zwykle nazywany MoodleSession. Musisz zezwolić na to ciasteczko w swojej przeglądarce, aby zapewnić ciągłość i pozostać zalogowanym podczas przeglądania witryny. Kiedy wylogujesz się lub zamkniesz przeglądarkę, ten plik cookie zostanie zniszczony (w Twojej przeglądarce i na serwerze).<br/><br/>

Drugi plik cookie jest przeznaczony wyłącznie dla wygody, zwykle nazywany jest MOODLEID lub podobnym. Po prostu zapamiętuje twoją nazwę użytkownika w przeglądarce. Oznacza to, że kiedy wrócisz na tę stronę, pole nazwy użytkownika na stronie logowania jest już wypełnione. Bezpiecznie jest odrzucić ten plik cookie - wystarczy, że będziesz musiał ponownie wpisać swoją nazwę użytkownika za każdym razem, gdy się zalogujesz.';
$string['cookiesenabledonlysession'] = 'Przyjmowanie cookies (ciasteczek) musi być włączone w Twojej przeglądarce';
$string['cookiesenabledonlysession_help'] = 'Ta strona używa jednego ciasteczka sesji, zwanego MoodleSession. Musisz zezwolić na to ciasteczko w przeglądarce, aby zapewnić ciągłość i pozostać zalogowanym podczas przeglądania strony. Gdy się wylogujesz lub zamkniesz przeglądarkę, to ciasteczko zostanie zniszczone (w twojej przeglądarce i na serwerze)';
$string['cookiesnotenabled'] = 'Obsługa cookies (ciasteczek) nie jest włączona w Twojej przeglądarce';
$string['cookiesnotice'] = 'Powiadomienie o plikach cookie';
$string['copy'] = 'kopiuj';
$string['copyasnoun'] = 'kopia';
$string['copycourse'] = 'Kopiuj kurs';
$string['copyingcoursefiles'] = 'Kopiowanie plików kursów';
$string['copyingsitefiles'] = 'Kopiowanie plików strony głównej użytych w kursie';
$string['copyinguserfiles'] = 'Kopiowanie plików użytkowników';
$string['copyingzipfile'] = 'Kopiowanie archiwów zip';
$string['copyrightnotice'] = 'Prawa autorskie';
$string['copytoclipboard'] = 'Skopiuj do schowka';
$string['coresystem'] = 'System';
$string['cost'] = 'Koszt';
$string['costdefault'] = 'Domyślny koszt';
$string['count_of_total'] = '<strong>{$a->count}</strong>/{$a->total}';
$string['counteditems'] = '{$a->count} {$a->items}';
$string['country'] = 'Kraj';
$string['course'] = 'Kurs';
$string['courseadministration'] = 'Administracja kursem';
$string['courseapprovedemail'] = 'Zamówiony przez Ciebie kurs został zatwierdzony, <a href="{$a->url}">{$a->name</a>, a Ty jesteś {$a->nauczycielem}.';
$string['courseapprovedemail2'] = 'Wniosek o założenie kursu został zaakceptowany: <a href="{$a->url}">{$a->name}</a>.';
$string['courseapprovedfailed'] = 'Nieudana próba zatwierdzenia kursu';
$string['courseapprovedsubject'] = 'Twój kurs został zatwierdzony.';
$string['courseavailable'] = 'Ten kurs jest dostępny dla studentów';
$string['courseavailablenot'] = 'Ten kurs nie jest dostępny dla studentów';
$string['coursebackup'] = 'Kopia zapasowa kursu';
$string['coursebulkaction'] = 'Masowe działania dla wybranych kursów';
$string['coursecategories'] = 'Kategorie kursów';
$string['coursecategory'] = 'Kategoria kursu';
$string['coursecategory_help'] = 'To ustawienie określa kategorię kursów, w której będzie on wyświetlany na liście kursów.';
$string['coursecategorydeleted'] = 'Kategoria {$a} została usunięta';
$string['coursecatmanagement'] = 'Zarządzanie kursami i kategoriami';
$string['coursecompletion'] = 'Ukończenie kursu';
$string['coursecompletions'] = 'Ukończenie kursu';
$string['coursecreators'] = 'Autor kursu';
$string['coursecreatorsdescription'] = 'Autorzy kursów mogą tworzyć nowe kursy.';
$string['coursedeleted'] = 'Kurs {$a} usunięty';
$string['coursedetails'] = 'Szczegóły kursów';
$string['coursedisplay'] = 'Układ kursu';
$string['coursedisplay_help'] = 'Sekcje kursu można wyświetlić na jednej stronie lub podzielić na kilka stron.';
$string['coursedisplay_multi'] = 'Pokaż jedną sekcję na stronę';
$string['coursedisplay_single'] = 'Pokaż wszystkie sekcje na jednej stronie';
$string['courseduration'] = 'Czas trwania kursu';
$string['courseduration_desc'] = 'Czas trwania kursu jest używany do obliczenia domyślnej daty zakończenia kursu. Data zakończenia kursu służy do ustalenia, czy dany kurs powinien znajdować się na liście kursów danego użytkownika. Może być również używany w raportach niestandardowych. Użytkownicy mogą nadal wchodzić na kurs po dacie zakończenia.';
$string['courseenddateenabled'] = 'Data zakończenia kursu jest domyślnie włączona';
$string['courseenddateenabled_desc'] = 'To ustawienie określa, czy data zakończenia kursu będzie domyślnie włączona dla nowych kursów i ustawiona na datę obliczoną na podstawie czasu trwania kursu.';
$string['courseextendednamedisplay'] = '{$a->shortname} {$a->fullname}';
$string['coursefiles'] = 'Pliki kursu starego formatu';
$string['coursefilesedit'] = 'Edytuj pliki przynależne do kursu';
$string['coursefileswarning'] = 'Sekcja "Pliki kursu" jest przestarzała.';
$string['coursefileswarning_help'] = 'Sekcja "Pliki kursu" została wycofana począwszy od wersji 2.0. Należy tak dalece jak to możliwe używać zewnętrznych repozytoriów plików.';
$string['courseformatdata'] = 'Dane formatu kursu';
$string['courseformatoptions'] = 'Opcje formatowania dla {$a}';
$string['courseformats'] = 'Formaty kursu';
$string['courseformatudpate'] = 'Aktualizacja formatu';
$string['coursegrades'] = 'Oceny kursu';
$string['courseheader'] = 'Menu kursu';
$string['coursehelpcategory'] = 'Wstaw kurs na listę kursów, co ułatwi studentom znalezienie go.';
$string['coursehelpforce'] = 'Wymuś tryb grup do każdej aktywności w tym kursie.';
$string['coursehelpformat'] = 'Głowna strona kursu będzie wyświetlana w tym formacie.';
$string['coursehelphiddensections'] = 'Jak ukryta sekcja kursu jest widoczna dla studentów.';
$string['coursehelpmaximumupload'] = 'Zdefiniuj największy rozmiar pliku jaki można przesłać do tego kursu, ograniczony przez ustawienia globalne.';
$string['coursehelpnewsitemsnumber'] = 'Liczba ostatnich ogłoszeń pojawiających się w bloku z ostatnimi informacjami na stronie kursu. Jeśli ustawione na zero, forum ogłoszeń nie zostanie utworzone.';
$string['coursehelpnumberweeks'] = 'Liczba sekcji w kursie (dotyczy tylko niektórych formatów kursów).';
$string['coursehelpshowgrades'] = 'Włącz wyswietlanie dziennika ocen. To nie zapobiega wyświetlaniu ocen wewnątrz poszczególnych aktywności.';
$string['coursehidden'] = 'Ten kurs jest obecnie niedostępny dla studentów';
$string['courseinfo'] = 'Informacje o kursie';
$string['courselegacyfiles'] = 'Pliki kursu (stary format)';
$string['courselegacyfiles_help'] = 'Obszar plików kursu zapewnia pewną wsteczną kompatybilność z Moodlem 1.9 i jego wcześniejszymi wersjami. Wszystkie pliki w tym obszarze są dostępne dla wszystkich uczestników kursu (niezależnie, czy są podlinkowane czy nie) i nie jest możliwe stwierdzenie, gdzie te pliki są używane w Moodlu.

Jeżeli używasz tego obszaru do przechowywania plików wystawiasz się na szereg ryzyk związanych z prywatnością i bezpieczeństwem oraz możesz doświadczyć problemów wynikających z pominięcia plików w kopiach archiwalnych i importach danych oraz faktu, że treści są dowolnie współdzielone i wykorzystywane. Nie używaj tej funkcjonalności, chyba, że naprawdę dobrze wiesz co robisz.';
$string['courselegacyfiles_link'] = 'coursefiles2';
$string['courselegacyfilesofcourse'] = 'Odziedziczone pliki kursu: {$a}';
$string['coursenotaccessible'] = 'Ten kurs nie jest ogólnodostępny';
$string['courseoverview'] = 'Podsumowanie kursu';
$string['courseoverviewfiles'] = 'Obraz kursu';
$string['courseoverviewfiles_help'] = 'Obraz kursu jest wyświetlany na stronie "Moje kursy" i w zestawieniach kursów na Stronie głównej. Administratorzy mogą dodać inne dopuszczalne formaty graficzne, a także umożliwić użycie wielu plików. Jeśli użyjesz więcej niż jednego pliku, wszystkie zostaną wyświetlone na liście dostępnych kursów na Stronie głównej.';
$string['courseoverviewfilesext'] = 'Rozszerzenia plików obrazów kursów';
$string['courseoverviewfileslimit'] = 'Limit plików obrazów kursu';
$string['courseoverviewgraph'] = 'Wykres podglądu kursu';
$string['courseprofiles'] = 'Profile w kursach';
$string['coursereasonforrejecting'] = 'Powód odrzucenia zamówienia na nowy kurs';
$string['coursereasonforrejectingemail'] = 'Tekst zostanie wysłany do zamawiającego';
$string['coursereject'] = 'Odrzuć zamówienie na kurs';
$string['courserejected'] = 'Zamówienie zostało odrzucone, a zamawiający został poinformowany.';
$string['courserejectemail'] = 'Przepraszamy, ale kurs, na który złożono zamówienie, został odrzucony. Uzasadnienie:

{$a}';
$string['courserejectreason'] = 'Wytłumaczenie powodów, dla których zamówienie zostało odrzucone<br />(wpisane tutaj uzasadnienie zostanie wysłane e-mailem do wnioskodawcy).';
$string['courserejectsubject'] = 'Kurs został odrzucony';
$string['coursereport'] = 'Raport kursu';
$string['coursereports'] = 'Raport kursu';
$string['courserequest'] = 'Zamawianie kursu';
$string['courserequestdetails'] = 'Szczegóły zamawianego kursu';
$string['courserequestfailed'] = 'Twoje zamówienie nie zostało zapisane';
$string['courserequestintro'] = 'Użyj formularza, aby zamówić utworzenie kursu. Zamieść jak najwięcej informacji tak, aby administratorzy poznali cel utworzenia tego kursu.';
$string['courserequestreason'] = 'Kurs jest potrzebny do...';
$string['courserequestroleerror'] = 'Rola twórcy w konfiguracji nowych kursów jest nieprawidłowa. Prosimy o zapoznanie się z <a href="{$a}">zasadami użytkownika</a>.';
$string['courserequestsuccess'] = 'Wniosek o utworzenie kursu został wysłany.';
$string['courserequestsupport'] = 'Dodatkowe informacje dla administratora na temat zamawianego kursu';
$string['courserequestwarning'] = 'Autor zgłoszenia zostanie automatyczne zapisany na kurs i otrzyma rolę: {$a}.';
$string['courserestore'] = 'Odtworzenie kursu';
$string['coursereuse'] = 'Ponowne wykorzystanie kursu';
$string['coursereusenavigationmenu'] = 'Menu nawigacyjne ponownego wykorzystania kursu';
$string['courses'] = 'Kursy';
$string['coursesectionsummaries'] = 'Streszczenie sekcji kursu';
$string['coursesectiontitle'] = '{$a->sectionname}: {$a->sectiontitle} | {$a->course}';
$string['coursesectiontitlebulkediting'] = 'Edycja zbiorcza {$a->sectionname}: {$a->sectiontitle} | {$a->course}';
$string['coursesectiontitleediting'] = 'Edycja {$a->sectionname}: {$a->sectiontitle} | {$a->course}';
$string['coursesettings'] = 'Domyślne ustawienia kursu';
$string['coursesmovedout'] = 'Kurs przeniesiony z {$a}';
$string['coursespending'] = 'Kursy oczekujące na zatwierdzenie';
$string['coursestart'] = 'Rozpoczęcie kursu';
$string['coursesummary'] = 'Streszczenie kursu';
$string['coursesummary_help'] = 'Krótki opis Twojego kursu. Treść, którą tu dodasz, można przeszukiwać.';
$string['coursetitle'] = 'Kurs: {$a->course}';
$string['coursetitlebulkediting'] = 'Zbiorcza edycja kursu: {$a->course}';
$string['coursetitleediting'] = 'Edycja kursu: {$a->course}';
$string['courseupdates'] = 'Aktualizacje w kursach';
$string['coursevisibility'] = 'Widoczność kursu';
$string['coursevisibility_help'] = '* Pokaż: kurs pojawi się na liście kursów i studenci będą mieli do niego dostęp.
* Ukryj: dostęp jest ograniczony tylko dla nauczycieli i innych użytkowników z możliwością przeglądania ukrytych kursów.';
$string['create'] = 'Utwórz';
$string['createaccount'] = 'Utwórz moje nowe konto';
$string['createcategory'] = 'Utwórz kategorię';
$string['createfolder'] = 'Utwórz folder w {$a}';
$string['createnew'] = 'Utwórz nową';
$string['createnewcategory'] = 'Utwórz nową kategorię';
$string['createnewcourse'] = 'Utwórz nowy kurs';
$string['createnewsubcategory'] = 'Utwórz nową podkategorię';
$string['createsubcategoryof'] = 'Utwórz podkategorię dla {$a}';
$string['createuser'] = 'Utwórz użytkownika';
$string['createziparchive'] = 'Utwórz archiwum zip';
$string['creatingblocks'] = 'Tworzenie bloków';
$string['creatingblocksroles'] = 'Tworzenie uprawnień i nadpisywań uprawnień na poziomie bloku';
$string['creatingblogsinfo'] = 'Tworzenie informacji o blogach';
$string['creatingcategoriesandquestions'] = 'Tworzenie kategorii i pytań';
$string['creatingcoursemodules'] = 'Tworzenie modułów kursu';
$string['creatingcourseroles'] = 'Tworzenie uprawnień i nadpisywań uprawnień na poziomie kursu';
$string['creatingevents'] = 'Tworzenie zdarzeń';
$string['creatinggradebook'] = 'Tworzenie dziennika ocen';
$string['creatinggroupings'] = 'Tworzenie grup nadrzędnych';
$string['creatinggroupingsgroups'] = 'Dodawanie grup do grup nadrzędnych';
$string['creatinggroups'] = 'Tworzenie grup';
$string['creatinglogentries'] = 'Tworzenie logów';
$string['creatingmessagesinfo'] = 'Tworzenie informacji o wiadomościach';
$string['creatingmodroles'] = 'Tworzenie uprawnień i nadpisywań uprawnień na poziomie modułu';
$string['creatingnewcourse'] = 'Tworzenie nowego kursu';
$string['creatingrolesdefinitions'] = 'Tworzenie definicji ról';
$string['creatingscales'] = 'Tworzenie skal ocen';
$string['creatingsections'] = 'Tworzenie sekcji';
$string['creatingtemporarystructures'] = 'Tworzenie struktur tymczasowych';
$string['creatinguserroles'] = 'Tworzenie uprawnień i nadpisywań uprawnień na poziomie użytkownika';
$string['creatingusers'] = 'Tworzenie użytkowników';
$string['creatingxmlfile'] = 'Tworzenie pliku XML';
$string['currency'] = 'Waluta';
$string['currentcourse'] = 'Bieżący przedmiot';
$string['currentcourseadding'] = 'Dodaj dane do bieżącego kursu bez usuwania jego zawartości';
$string['currentcoursedeleting'] = 'Dodaj dane do bieżącego kursu, usuwając wpierw jego zawartość';
$string['currentlanguage'] = 'Aktualny język';
$string['currentlocaltime'] = 'twój aktualny czas lokalny';
$string['currentpicture'] = 'Aktualne zdjęcie';
$string['currentrelease'] = 'Informacje o aktualnej wersji';
$string['currenttheme'] = 'Bieżący motyw';
$string['currentversion'] = 'Aktualna wersja';
$string['databasechecking'] = 'Aktualizacja bazy danych Moodle z wersji {$a->oldversion} do {$a->newversion}';
$string['databaseperformance'] = 'Wydajność bazy danych';
$string['databasesetup'] = 'Tworzenie bazy danych';
$string['databasesuccess'] = 'Baza danych została poprawnie zaktualizowana';
$string['databaseupgradebackups'] = '{$a} wersja kopii zapasowej';
$string['databaseupgradeblocks'] = '{$a} wersja bloków';
$string['databaseupgradegroups'] = '{$a} wersja grup';
$string['databaseupgradelocal'] = 'Obecnie dostosowana wersja lokalnej bazy danych to {$a}';
$string['databaseupgrades'] = 'Aktualizacja bazy danych';
$string['dataformats'] = 'Formaty danych';
$string['date'] = 'Data';
$string['datechanged'] = 'Data zmieniona';
$string['datemostrecentfirst'] = 'Daty - od najświeższej';
$string['datemostrecentlast'] = 'Daty - od najstarszej';
$string['datetimefilterafter'] = '{$a->title} po';
$string['datetimefilterbefore'] = '{$a->title} przed';
$string['day'] = 'dzień';
$string['days'] = 'dni';
$string['decodinginternallinks'] = 'Odkodowywanie linków wewnętrznych';
$string['default'] = 'Domyślny';
$string['defaultcategoryname'] = 'Kategoria 1';
$string['defaultcompetencescale'] = 'Domyślna skala kompetencji';
$string['defaultcompetencescaledesc'] = 'Dwustopniowa skala, która wskazuje jedynie czy ktoś posiada daną kompetencję czy nie.';
$string['defaultcompetencescalenotproficient'] = 'Jeszcze nie kompetentny';
$string['defaultcompetencescaleproficient'] = 'Kompetentny';
$string['defaultcoursestudent'] = 'Student';
$string['defaultcoursestudentdescription'] = 'Studenci na ogół mają mniej uprawnień w kursie.';
$string['defaultcoursestudents'] = 'Studenci';
$string['defaultcoursesummary'] = 'Wpisz tutaj krótki opis kursu';
$string['defaultcourseteacher'] = 'Nauczyciel';
$string['defaultcourseteacherdescription'] = 'Nauczyciele mogą robić wszystko w kursie, np. zmieniać aktywności i oceniać studentów';
$string['defaultcourseteachers'] = 'Nauczyciele';
$string['defaulteditor'] = 'Domyślny edytor';
$string['defaulthomepageuser'] = 'Strona główna';
$string['defaulthomepageuser_help'] = 'Na którą stronę powinieneś zostać przekierowany po zalogowaniu się do serwisu?';
$string['delete'] = 'Usuń';
$string['deleteablock'] = 'Usuń blok';
$string['deleteall'] = 'Usuń wszystko';
$string['deleteallcannotundo'] = 'Usuń wszystko - nie da się cofnąć';
$string['deleteallcomments'] = 'Wszystkie komentarze';
$string['deleteallratings'] = 'Wszystkie oceny';
$string['deletecategory'] = 'Usuń kategorię {$a}';
$string['deletecategorycheck'] = 'Czy na pewno chcesz usunąć kategorię <b>\'{$a}\'</b>?<br/>Spowoduje to przesunięcie wszystkich kursów do kategorii nadrzędnej lub kategorii "Różne".';
$string['deletecategorycheck2'] = 'Gdy usuwasz tą kategorię, musisz wybrać co zrobić z kursami i podkategoriami które zawiera.';
$string['deletecategoryempty'] = 'Ta kategoria jest pusta';
$string['deletecheck'] = 'Usunąć {$a}?';
$string['deletecheckfiles'] = 'Czy na pewno chcesz usunąć te pliki?';
$string['deletecheckfull'] = 'Czy na pewno chcesz całkowicie usunąć użytkownika {$a}, w tym jego wpisy, aktywność i inne dane?';
$string['deletechecktype'] = 'Czy na pewno chcesz usunąć {$a->type}?';
$string['deletechecktypename'] = 'Czy na pewno chcesz usunąć {$a->type} "{$a->name}"?';
$string['deletecheckwarning'] = 'Te pliki zostaną zaraz usunięte';
$string['deletecommentbyon'] = 'Usuń komentarz zamieszczony przez {$a->user} dnia {$a->time}';
$string['deletecompletely'] = 'Usuń całkowicie';
$string['deletecourse'] = 'Usuń kurs';
$string['deletecoursecheck'] = 'Czy na pewno chcesz całkowicie usunąć ten kurs i wszystkie zawarte w nim dane?';
$string['deleted'] = 'Usunięto';
$string['deletedactivity'] = 'Usunięto {$a}';
$string['deletedcourse'] = '{$a} został całkowicie usunięty.';
$string['deletednot'] = 'Nie można usunąć {$a}.';
$string['deletepicture'] = 'Usuń';
$string['deletesection'] = 'Usuń';
$string['deleteselected'] = 'Usuń zaznaczone';
$string['deleteselectedkey'] = 'Usuń wybrany klucz';
$string['deletingcourse'] = 'Usuwanie {$a}';
$string['deletingexistingcoursedata'] = 'Usuwanie istniejących danych kursu';
$string['deletingolddata'] = 'Kasowanie starych danych';
$string['department'] = 'Wydział';
$string['deprecatedeventname'] = '{$a} (już nie używany)';
$string['desc'] = 'Malejąco';
$string['description'] = 'Opis';
$string['deselectall'] = 'Odznacz wszystkie';
$string['deselectnos'] = 'Odznacz wszystkie "Nie"';
$string['detailedless'] = 'Mniej szczegółowo';
$string['detailedmore'] = 'Bardziej szczegółowo';
$string['details'] = 'Szczegóły';
$string['digitalminor'] = 'Niepełnoletni';
$string['digitalminor_desc'] = 'Poproś rodzica / opiekuna o kontakt:';
$string['directory'] = 'Katalog';
$string['disable'] = 'Wyłącz';
$string['disabledcomments'] = 'Komentarze są wyłączone';
$string['dismissnotification'] = 'Odrzuć te powiadomienie';
$string['displayingfirst'] = 'Tylko pierwszych {$a->count} elementów jest wyświetlanych';
$string['displayingrecords'] = 'Wyświetlanie {$a} rekordów';
$string['displayingusers'] = 'Wyświetlanie użytkowników od {$a->start} do {$a->end}';
$string['displayonpage'] = 'Wyświetl na stronie';
$string['dndcourse'] = 'Możesz przeciągać i upuszczać ten kurs, w celu sortowania lub przeniesienia do innej kategorii.';
$string['dndenabled_inbox'] = 'Możesz przeciągnąć i upuścić pliki tutaj, aby je dodać.';
$string['dndnotsupported'] = 'Funkcja przeciągnij i upuść nie jest wspierana';
$string['dndnotsupported_help'] = 'Twoja przeglądarka nie obsługuje opcji przeciągnij i  upuść. Ta funkcja jest dostępna we wszystkich nowych wersjach Chrome, Firefox i Safari, a także Internet Explorer v.10 i nowszych.';
$string['dndnotsupported_insentence'] = 'funkcja przeciągnij i upuść nie jest wspierana';
$string['dnduploadwithoutcontent'] = 'Ten upload nie ma żadnej zawartości';
$string['dndworkingfile'] = 'Przeciągnij i upuść pliki do sekcji kursu, aby je załadować';
$string['dndworkingfilelink'] = 'Przeciągnij i upuść pliki lub linki do sekcji kursu, aby je załadować';
$string['dndworkingfiletext'] = 'Przeciągnij i upuść pliki lub tekst do sekcji kursu, aby je załadować';
$string['dndworkingfiletextlink'] = 'Przeciągnij i upuść pliki, tekst lub linki do sekcji kursu, aby je załadować';
$string['dndworkinglink'] = 'Przeciągnij i upuść linki do sekcji kursu, aby je załadować';
$string['dndworkingtext'] = 'Przeciągnij i upuść tekst do sekcji kursu, aby je załadować';
$string['dndworkingtextlink'] = 'Przeciągnij i upuść tekst lub linki do sekcji kursu, aby je załadować';
$string['documentation'] = 'Dokumentacja Moodle';
$string['dontsortcategories'] = 'Nie sortuj kategorii';
$string['dontsortcourses'] = 'Nie sortuj kursów';
$string['down'] = 'W dół';
$string['download'] = 'Pobierz';
$string['downloadall'] = 'Pobierz wszystkie';
$string['downloadexcel'] = 'Ściągnij w formacie Excela';
$string['downloadfile'] = 'Pobierz plik';
$string['downloadods'] = 'Ściągnij w formacie ODS';
$string['downloadtext'] = 'Ściągnij w formacie tekstowym';
$string['doyouagree'] = 'Czy przeczytałeś(aś) warunki i rozumiesz je?';
$string['droptoupload'] = 'Upuścić pliki tutaj, aby je przesłać';
$string['duplicate'] = 'Duplikuj';
$string['duplicatedmodule'] = '{$a} (kopia)';
$string['duplicatedsection'] = '{$a} (kopia)';
$string['edhelpaspellpath'] = 'Aby sprawdzać pisownię w tym edytorze, musisz mieć zainstalowany słownik <strong> aspell</strong> w wersji co najmniej 0.5. Musi być ustawiona ścieżka dostępu; w systemach Unix/Linux jest to najczęściej<strong>/usr/bin/aspell</strong>.';
$string['edhelpbgcolor'] = 'Ustaw kolor tła w polu edycji.<br /> Poprawną wartością jest np. #FFFFFF lub white';
$string['edhelpcleanword'] = 'To ustawienie włącza lub wyłącza filtrowanie formatów charakterystyczne dla Worda.';
$string['edhelpenablespelling'] = 'Włącz lub wyłącz sprawdzanie pisowni. Jeśli włączone, <strong>aspell</strong> musi być zainstalowany na serwerze.';
$string['edhelpfontfamily'] = 'Zmienna rodziny czcionek to lista czcionek i/lub typów czcionek. Kolejne nazwy czcionek muszą być oddzielone przecinkami.';
$string['edhelpfontlist'] = 'Zdefiniuj czcionki dostępne na rozwijanej liście edytora.';
$string['edhelpfontsize'] = 'Domyślny parametr font-size ustawia wielkość czcionki.<br />Poprawnymi wartościami są: medium, large, smaller, larger, 10px, 11px.';
$string['edit'] = 'Modyfikuj';
$string['edita'] = 'Modyfikuj {$a}';
$string['editcategorysettings'] = 'Modyfikuj ustawienia kategorii';
$string['editcategorythis'] = 'Modyfikuj tę kategorię';
$string['editcoursesettings'] = 'Zmień ustawienia kursu';
$string['editfiles'] = 'Edytuj pliki';
$string['editgroupprofile'] = 'Edytuj opis grupy';
$string['editingteachershort'] = 'Edytor';
$string['editlock'] = 'Ta wartość nie może być modyfikowana';
$string['editmode'] = 'Tryb edycji';
$string['editmyprofile'] = 'Modyfikuj profil';
$string['editorbgcolor'] = 'Kolor tła';
$string['editorcleanonpaste'] = 'Wyczyść formatowanie Worda przy wklejaniu';
$string['editorcommonsettings'] = 'Domyślne ustawienia';
$string['editordefaultfont'] = 'Domyślna czcionka';
$string['editorenablespelling'] = 'Włącz sprawdzanie pisowni';
$string['editorfontlist'] = 'Lista czcionek';
$string['editorfontsize'] = 'Domyślny rozmiar czcionki';
$string['editorpreferences'] = 'Preferencje edytora';
$string['editorresettodefaults'] = 'Przywróć ustawienia domyślne';
$string['editorsettings'] = 'Ustawienia edytora tekstu';
$string['editorshortcutkeys'] = 'Klawisze skrótu edytora';
$string['editsection'] = 'Edytuj ustawienia';
$string['editsectionname'] = 'Edytuj nazwę sekcji';
$string['editsectionsettings'] = 'Edytuj ustawienia sekcji';
$string['editsectiontitle'] = 'Edytuj sekcję: {$a}';
$string['editsettings'] = 'Edytuj ustawienia';
$string['editthisactivity'] = 'Zmień składową';
$string['editthiscategory'] = 'Zmień kategorię';
$string['edittitle'] = 'Edytuj tytuł';
$string['edittitleinstructions'] = 'Naciśnij Escape aby anulować, Enter aby zakończyć';
$string['edituser'] = 'Zmień konta użytkowników';
$string['edulevel'] = 'Wszystkie wydarzenia';
$string['edulevel_help'] = '* Nauczanie - działania wykonywane przez nauczyciela, np. aktualizowanie zasobu
* Uczestniczenie - działania wykonywane przez studenta, np. zamieszczanie na forum
* Inne - działania wykonywane przez użytkownika z roli innej niż nauczyciel lub student';
$string['edulevelother'] = 'Inny';
$string['edulevelparticipating'] = 'Uczestniczących';
$string['edulevelteacher'] = 'Nauczanie';
$string['email'] = 'E-mail';
$string['emailactive'] = 'Aktywowany e-mail';
$string['emailagain'] = 'E-mail (powtórz)';
$string['emailalreadysent'] = 'Email resetowania hasła został wysłany.';
$string['emailcharset'] = 'Kodowanie znaków w e-mail';
$string['emailconfirm'] = 'Potwierdź konto';
$string['emailconfirmation'] = 'Drogi użytkowniku: {$a->firstname},
zgłoszono prośbę o utworzenie nowego konta w {$a->sitename} przy użyciu Twojego adresu e-mail. Aby potwierdzić nowe konto, przejdź na ten adres internetowy: {$a->link}

W większości programów pocztowych powinno to wyglądać jak niebieski link, na który możesz po prostu kliknąć. Jeśli to nie zadziała, skopiuj i wklej adres w wierszu adresu u góry okna przeglądarki internetowej.

Jeśli potrzebujesz pomocy, skontaktuj się z administratorem witryny,
{$a->admin}';
$string['emailconfirmationresend'] = 'Wyślij ponownie e-mail potwierdzający';
$string['emailconfirmationsubject'] = 'Potwierdzenie dla konta {$a}';
$string['emailconfirmsent'] = '<p>Został do Ciebie wysłany e-mail pod adres <b>{$a}</b>.</p><p>Zawiera on prostą instrukcję, jak dokończyć rejestrację.</p><p>Jeżeli nadal będziesz mieć kłopoty, skontaktuj się z administratorem serwisu.</p>';
$string['emailconfirmsentfailure'] = 'Wiadomość e-mail z potwierdzeniem nie została wysłana';
$string['emailconfirmsentsuccess'] = 'E-mail z potwierdzeniem został pomyślnie wysłany';
$string['emaildigest'] = 'Typ streszczenia wysyłanego mailem';
$string['emaildigest_help'] = 'To jest ustawienie codziennego streszczenia, którego forum używa domyślnie.

* Brak streszczenia - otrzymujesz jeden email na jedną wiadomość na forum;
* Streszczenie - wiadomości kompletne - otrzymujesz streszczenie codziennie emailem, zawierające kompletną zawartość każdej wiadomości na forum;
* Streszczenie - tylko tematy - otrzymujesz streszczenie codziennie emailem, zawierające tylko tematy każdej wiadomości na forum.

Możesz wybrać według własnego życzenia różne ustawienia dla każdego forum.';
$string['emaildigestcomplete'] = 'Pełny (jeden e-mail dziennie ze wszystkimi wpisami)';
$string['emaildigestoff'] = 'Bez streszczenia (jeden e-mail na każdy wpis)';
$string['emaildigestsubjects'] = 'Tematy (codzienny e-mail tylko z tematami)';
$string['emaildisable'] = 'Ten e-mail jest dezaktywowany';
$string['emaildisableclick'] = 'Kliknij tutaj, aby dezaktywować wysyłanie maili na ten adres.';
$string['emaildisplay'] = 'Widoczność adresu e-mail';
$string['emaildisplay_help'] = '* Ukryty - tylko użytkownicy z odpowiednimi uprawnieniami, np. nauczyciele, mogą zobaczyć Twój adres e-mail.
* Widoczny dla wszystkich - wszyscy użytkownicy witryny mogą zobaczyć Twój adres e-mail.
* Widoczne dla uczestników kursów - tylko uczestnicy kursów, na które jesteś zapisany, mogą zobaczyć Twój adres e-mail.';
$string['emaildisplaycourse'] = 'Widoczne dla uczestników kursu';
$string['emaildisplaycoursemembersonly'] = '(Widoczne dla innych uczestników kursu)';
$string['emaildisplayeveryone'] = '(Widoczne dla wszystkich)';
$string['emaildisplayhide'] = '(Ukryty przed wszystkimi z wyjątkiem użytkowników z odpowiednimi uprawnieniami)';
$string['emaildisplayno'] = 'Ukryty';
$string['emaildisplayyes'] = 'Widoczne dla każdego';
$string['emailenable'] = 'Ten mail jest uaktywniony';
$string['emailenableclick'] = 'Kliknij tutaj, aby uaktywnić wysyłanie maili na ten adres';
$string['emailexists'] = 'Ten adres e-mail jest już zarejestrowany';
$string['emailexistshintlink'] = 'Odzyskaj zapomnianą nazwę użytkownika lub hasło';
$string['emailexistssignuphint'] = 'Być może założyłeś konto w przeszłości? {$a}';
$string['emailformat'] = 'Format e-mail';
$string['emailmustbereal'] = 'Uwaga: Twój adres e-mail musi być prawdziwy';
$string['emailnotallowed'] = 'Niedozwolona domena adresu e-mail ({$a})';
$string['emailnotfound'] = 'Adres e-mail nie został znaleziony w bazie danych';
$string['emailonlyallowed'] = 'Niedozwolony adres e-mail. Akceptowane są: {$a}.';
$string['emailpasswordchangeinfo'] = 'Drogi użytkowniku: {$a->firstname},
ktoś (prawdopodobnie Ty) na stronie {$a->sitename} zażądał wygenerowania nowego hasła dla Twojego konta (nazwa użytkownika: {$a->username}).

W celu potwierdzenia zmiany hasła, kliknij w link {$a->link}

W większości programów pocztowych przesłany adres powinien działać jako aktywny link, który można kliknąć. Jeśli link nie działa, skopiuj go i wklej w pasku adresu Twojej przeglądarki.


Jeśli potrzebujesz pomocy, skontaktuj się z administratorem witryny
{$a->admin}';
$string['emailpasswordchangeinfodisabled'] = 'Drogi użytkowniku: {$a->firstname},
ktoś (prawdopodobnie Ty) na stronie {$a->sitename} zażądał wygenerowania nowego hasła dla Twojego konta.

Niestety, Twoje konto w tym serwisie jest zablokowane, w związku z tym hasło nie może zostać zresetowane.

Skontaktuj się z administratorem witryny
{$a->admin}';
$string['emailpasswordchangeinfofail'] = 'Drogi użytkowniku: {$a->firstname},
ktoś (prawdopodobnie Ty) na stronie {$a->sitename} zażądał wygenerowania nowego hasła dla Twojego konta.

Niestety w tym serwisie hasła nie mogą być zmieniane.

Skontaktuj się z administratorem witryny
{$a->admin}';
$string['emailpasswordchangeinfosubject'] = '{$a}: Zmień informacje dotyczące hasła';
$string['emailpasswordconfirmation'] = 'Drogi użytkowniku: {$a->firstname},
na stronie {$a->sitename} wygenerowano żądanie zresetowania hasła dla Twojego konta.

W celu potwierdzenia zmiany hasła za pośrednictwem poczty e-mail, kliknij w link {$a->link}

W większości programów pocztowych przesłany adres powinien działać jako aktywny link, który można kliknąć. Jeśli link nie działa, skopiuj go i wklej w pasku adresu Twojej przeglądarki.


Jeśli potrzebujesz pomocy, skontaktuj się z administratorem witryny
{$a->admin}';
$string['emailpasswordconfirmationsubject'] = 'Potwierdzenie zmiany hasła dla: {$a}';
$string['emailpasswordconfirmmaybesent'] = '<p>Jeśli wpisałeś właściwą nazwę użytkownika lub adres e-mail, na twoją skrzynkę zostanie wysłana wiadomość.<br>
Znajdziesz w niej łatwą instrukcję zmiany hasła. W razie problemów skontaktuj się z administratorem serwisu.</p>';
$string['emailpasswordconfirmnoemail'] = '<p>Konto użytkownika, które podałeś nie ma zapisanego adresu emailowego.</p>
<p>Proszę skontaktować się z administratorem strony.</p>';
$string['emailpasswordconfirmnotsent'] = '<p>Szczegóły użytkownika, które dostarczyłeś nie identyfikują istniejącego konta użytkownika.</p>
<p>Proszę sprawdzić informacje, które wprowadziłeś, i spróbować ponownie.
Jeżeli w dalszym ciągu będziesz miał trudności, skontaktuj się z administratorem serwisu.</p>';
$string['emailpasswordconfirmsent'] = 'Został do Ciebie wysłany e-mail na adres <b>{$a}</b>.<br />Zawiera on prostą instrukcję jak potwierdzić i zakończyć zmianę hasła. Jeśli nadal będziesz miał problemy, skontaktuj się z administratorem.';
$string['emailresetconfirmation'] = 'Drogi użytkowniku: {$a->firstname},
poproszono o zresetowanie hasła dla Twojego konta (nazwa użytkownika: {$a->username}) w serwisie {$a->sitename}.

Aby potwierdzić zmianę hasła kliknij w poniższy adres<br>
<a href="{$a->link}">{$a->link}</a>
<br>
(Ten link jest ważny przez {$a->resetminutes} minut od momentu wygenerowania tej wiadomości.)
<br><br>
Jeśli nie poprosiłeś o zresetowanie hasła, nie musisz podejmować żadnych działań.


Jeśli potrzebujesz pomocy, skontaktuj się z administratorem witryny<br>
{$a->admin}';
$string['emailresetconfirmationsubject'] = '{$a}: żądanie zresetowania hasła';
$string['emailresetconfirmsent'] = 'Email został wysłany na twój adres <b>{$a}</b>.
<br />Zawiera prostą instrukcję do potwierdzenia zmiany hasła.
Jeżeli w dalszym ciągu będziesz miał trudności, skontaktuj się z administratorem serwisu.';
$string['emailstop'] = 'Wyłącz powiadomienia';
$string['emailtoprivatefiles'] = 'Możesz również wysłać pliki jako załącznik poczty e-mail przestrzeni prywatnych plików. Wystarczy dołączyć pliki do wiadomości e-mail i wysłać go do {$a}.';
$string['emailtoprivatefilesdenied'] = 'Twój administrator wyłączył możliwość przesyłania własnych prywatnych plików.';
$string['emailvia'] = '{$a->name} (z {$a->siteshortname})';
$string['emojicategoryactivities'] = 'Aktywności';
$string['emojicategoryanimalsnature'] = 'Zwierzęta i natura';
$string['emojicategoryflags'] = 'Flagi';
$string['emojicategoryfooddrink'] = 'Jedzenie i napoje';
$string['emojicategoryobjects'] = 'Obiekty';
$string['emojicategorypeoplebody'] = 'Ludzie i ciało';
$string['emojicategoryrecent'] = 'Ostatni';
$string['emojicategorysmileysemotion'] = 'Uśmiech i emotikon';
$string['emojicategorysymbols'] = 'Symbole';
$string['emojicategorytravelplaces'] = 'Podróże i miejsca';
$string['emptycmids'] = 'Puste identyfikatory modułów kursu';
$string['emptydragdropregion'] = 'pusty obszar';
$string['emptysectionids'] = 'Puste identyfikatory sekcji';
$string['enable'] = 'Włącz';
$string['encryptedcode'] = 'Zaszyfrowany kod';
$string['enddate'] = 'Data zakończenia kursu';
$string['enddate_help'] = 'Data zakończenia kursu służy do ustalenia, czy dany kurs powinien znajdować się na liście kursów danego użytkownika. Po dacie zakończenia, kurs nie jest już wymieniony w nawigacji i jest wymieniony jako zakończony w przeglądzie kursu. Data zakończenia kursu może być również używana w raportach niestandardowych. Użytkownicy mogą nadal wchodzić na kurs po dacie zakończenia; innymi słowy, data nie ogranicza dostępu.';
$string['enddatewithtaskenabled'] = 'Data zakończenia kursu';
$string['enddatewithtaskenabled_help'] = 'Data, od kiedy kurs staje się ukryty dla studentów i nie mogą już uzyskać do niego dostępu.';
$string['english'] = 'angielski';
$string['enrolmentmethods'] = 'Metody zapisu';
$string['entercourse'] = 'Kliknij, aby wejść do kursu';
$string['enteremail'] = 'Wprowadź swój adres e-mail';
$string['enteremailaddress'] = 'Wprowadź swój adres e-mail, aby wykasować twoje hasło i otrzymać pocztą elektroniczną nowe.';
$string['enterusername'] = 'Wprowadź swoją nazwę użytkownika';
$string['entries'] = 'Wpisy';
$string['error'] = 'Błąd';
$string['errorcreatingactivity'] = 'Nie można utworzyć instancji aktywności \'{$a}\'';
$string['errorfiletoobig'] = 'Plik był większy niż limit bajtów {$a}';
$string['errornouploadrepo'] = 'Dla tej strony nie aktywowano żadnego repozytorium plików';
$string['errorwhenconfirming'] = 'Potwierdzenie nie zostało przesłane z powodu wystąpienia błędu. Jeśli kliknąłeś na link w mailu, upewnij się, że nie odwoływał się on do nieistniejącej strony albo że jego dalszy ciąg nie znajdował się w następnej linii wiadomości.';
$string['eventcommentcreated'] = 'Utworzono komentarz';
$string['eventcommentdeleted'] = 'Usunięto komentarz';
$string['eventcommentsviewed'] = 'Oglądane komentarze';
$string['eventconfiglogcreated'] = 'Utworzono dziennik konfiguracji';
$string['eventcontentviewed'] = 'Oglądana zawartość';
$string['eventcoursebackupcreated'] = 'Utworzono kopię zapasową kursu';
$string['eventcoursecategorycreated'] = 'Utworzono kategorię';
$string['eventcoursecategorydeleted'] = 'Kategoria usunięta';
$string['eventcoursecategoryupdated'] = 'Zaktualizowano kategorię';
$string['eventcoursecategoryviewed'] = 'Wyświetlono kategorię';
$string['eventcoursecontentdeleted'] = 'Zawartość kursu skasowana';
$string['eventcoursecreated'] = 'Kurs utworzony';
$string['eventcoursedeleted'] = 'Kurs usunięty';
$string['eventcourseended'] = 'Kurs zakończony';
$string['eventcourseinformationviewed'] = 'Wyświetlono podsumowanie kursu';
$string['eventcoursemodulecreated'] = 'Utworzono moduł kursu';
$string['eventcoursemoduledeleted'] = 'Moduł kursu usunięty';
$string['eventcoursemoduleinstancelistviewed'] = 'Lista oglądanych instancji modułu kursu';
$string['eventcoursemoduleupdated'] = 'Moduł kursu zaktualizowany';
$string['eventcoursemoduleviewed'] = 'Wyświetlono moduł kursu';
$string['eventcourseoverviewviewed'] = 'Wyświetlono stronę przeglądu aktywności kursu';
$string['eventcourseresetended'] = 'Resetowanie kursu zakończone';
$string['eventcourseresetstarted'] = 'Resetowanie kursu rozpoczęte';
$string['eventcourserestored'] = 'Kurs przywrócony';
$string['eventcoursesectioncreated'] = 'Utworzono sekcję kursu';
$string['eventcoursesectiondeleted'] = 'Sekcja kursu usunięta';
$string['eventcoursesectionupdated'] = 'Zaktualizowano sekcję kursu';
$string['eventcoursessearched'] = 'Przeszukane kursy';
$string['eventcoursestarted'] = 'Kurs rozpoczęty';
$string['eventcourseupdated'] = 'Kurs zaktualizowany';
$string['eventcourseuserreportviewed'] = 'Raport użytkownika kursy wyświetlony';
$string['eventcourseviewed'] = 'Wyświetlono kurs';
$string['eventdashboardreset'] = 'Resetowanie pulpitu nawigacyjnego';
$string['eventdashboardsreset'] = 'Resetowanie pulpitów nawigacyjnych';
$string['eventdashboardviewed'] = 'Wyświetlono pulpit nawigacji';
$string['eventdatabasetextfieldcontentreplaced'] = 'Globalne wyszukiwanie i zamiana bazy danych';
$string['eventemailfailed'] = 'Nie udało się wysłać e-maila';
$string['eventmycoursesviewed'] = 'Wyświetlono moje kursy';
$string['eventname'] = 'Nazwa zdarzenia';
$string['eventrecentactivityviewed'] = 'Ostatnia aktywność wyświetlona';
$string['eventsearchindexed'] = 'Wyszukaj zindeksowane dane';
$string['eventsearchresultsviewed'] = 'Wyświetlone wyniki wyszukiwania';
$string['eventsectionviewed'] = 'Wyświetlono sekcję';
$string['eventunknownlogged'] = 'Nieznane wydarzenie';
$string['eventurlblocked'] = 'Adres URL został zablokowany';
$string['eventusercreated'] = 'Użytkownik utworzony';
$string['eventuserdeleted'] = 'Użytkownik usunięty';
$string['eventuserfeedbackgiven'] = 'Kliknij łącze opinii';
$string['eventuserfeedbackremind'] = 'Przypomnij mi później kliknąć łącze opinii';
$string['eventuserinfocategorycreated'] = 'Utworzono kategorię pola profilu użytkownika';
$string['eventuserinfocategorydeleted'] = 'Usunięto kategorię pola profilu użytkownika';
$string['eventuserinfocategoryupdated'] = 'Zaktualizowano kategorię pola profilu użytkownika';
$string['eventuserinfofieldcreated'] = 'Utworzono pole profilu użytkownika';
$string['eventuserinfofielddeleted'] = 'Usunięto pole profilu użytkownika';
$string['eventuserinfofieldupdated'] = 'Zaktualizowano pole profilu użytkownika';
$string['eventuserlistviewed'] = 'Wyświetlono listę uczestników';
$string['eventuserloggedout'] = 'Użytkownik wylogowany';
$string['eventuserpasswordpolicyfailed'] = 'Hasło użytkownika nie spełnia polityki haseł';
$string['eventuserpasswordupdated'] = 'Hasło zaktualizowane';
$string['eventuserprofileviewed'] = 'Wyświetlono profil użytkownika';
$string['eventuserupdated'] = 'Użytkownik zaktualizowany';
$string['everybody'] = 'Wszyscy';
$string['executeat'] = 'Wykonaj';
$string['existing'] = 'Istniejące';
$string['existingadmins'] = 'Istniejący administratorzy';
$string['existingcourse'] = 'Istniejące kursy';
$string['existingcourseadding'] = 'Istniejący kurs, dodawanie danych do niego';
$string['existingcoursedeleting'] = 'Istniejący kurs, po jego uprzednim wykasowaniu';
$string['existingcreators'] = 'Istniejący autorzy kursów';
$string['existingstudents'] = 'Zapisani studenci';
$string['existingteachers'] = 'Istniejący nauczyciele';
$string['expand'] = 'Rozwiń';
$string['expandall'] = 'Rozwiń wszystko';
$string['expandcategory'] = 'Rozwiń {$a}';
$string['explanation'] = 'Wyjaśnienie';
$string['explanationdigitalminor'] = 'Ta informacja jest wymagana, aby ustalić czy Twój wiek spełnia wymóg wieku cyfrowego przyzwolenia. Jest to wiek, od którego osoba może zatwierdzać regulamin i godzić się, aby jej dane były legalnie zapisywane oraz przetwarzane.';
$string['extendperiod'] = 'Przedłużony okres';
$string['extendsession'] = 'Wydłuż sesję';
$string['failedloginattempts'] = '{$a->attempts} nieudanych prób logowania od Twojego ostatniego logowania';
$string['failedtaskbody'] = '<p>Drogi użytkowniku: {$a->firstname},<br>
zadanie <b>{$a->taskname}</b> wielokrotnie zakończyło się niepowodzeniem i wymaga uwagi.</p>
<p><a href="{$a->link}">Zobacz zadanie</a></p>';
$string['failedtaskcontexturlname'] = 'Raport o stanie systemu';
$string['failedtasksubject'] = 'Zadanie nie powiodło się: {$a}';
$string['favourites'] = 'Oznaczone gwiazdką';
$string['feedback'] = 'Informacja zwrotna';
$string['file'] = 'Plik';
$string['fileexists'] = 'Istnieje już plik o nazwie {$a}';
$string['filemissing'] = 'brak {$a}';
$string['filereaderror'] = 'Nie można odczytać pliku \'{$a}\'. Sprawdź, czy to naprawdę plik, a nie folder.';
$string['files'] = 'Pliki';
$string['filesanduploads'] = 'Pliki i przesyłanie';
$string['filesfolders'] = 'Pliki/foldery';
$string['fileuploadwithcontent'] = 'Wgrywanie pliku nie zawiera parametru treści';
$string['filloutallfields'] = 'Należy wypełnić wszystkie pola formularza';
$string['filter'] = 'Filtr';
$string['filteroption'] = '{$a->criteria}: {$a->value}';
$string['filterrowlegend'] = 'Filtr {$a}';
$string['filters'] = 'Filtry';
$string['filtersetmatchdescription'] = 'Jak należy łączyć wiele filtrów';
$string['filtertype'] = 'Typ filtra';
$string['findmorecourses'] = 'Znajdź więcej kursów ...';
$string['first'] = 'Pierwszy';
$string['firstaccess'] = 'Pierwsze wejście';
$string['firstname'] = 'Imię';
$string['firstnamephonetic'] = 'Imię - fonetyczne';
$string['firstpage'] = 'Pierwsza strona';
$string['firstsiteaccess'] = 'Pierwszy dostęp do strony';
$string['firsttime'] = 'Jak się zalogować?';
$string['folder'] = 'Folder';
$string['folderclosed'] = 'Zamknięty folder';
$string['folderopened'] = 'Otwarty folder';
$string['followingoptional'] = 'Następujące punkty są opcjonalne';
$string['followingrequired'] = 'Następujące punkty są wymagane';
$string['for'] = 'Dla';
$string['force'] = 'Wymuś';
$string['forcelanguage'] = 'Wymuś język';
$string['forceno'] = 'Nie wymuszaj';
$string['forcepasswordchange'] = 'Wymuś zmianę hasła';
$string['forcepasswordchange_help'] = 'Jeśli to pole zostanie zaznaczone, użytkownik zostanie poproszony o zmianę hasła przy następnym logowaniu';
$string['forcepasswordchangecheckfull'] = 'Czy jesteś absolutnie pewny(a), że chcesz wymusić zmianę hasła dla {$a} ?';
$string['forcepasswordchangenot'] = 'Nie udało się wymusić zmiany hasła dla {$a}';
$string['forcepasswordchangenotice'] = 'Aby kontynuować, musisz zmienić swoje hasło.';
$string['forcepasswordresetfailurenotice'] = 'Twoje bieżące hasło nie spełnia już ustawionych zasad dotyczących haseł. Aby uzyskać pomoc, skontaktuj się z administratorem Moodle.
    {$a}';
$string['forcepasswordresetnotice'] = 'Twoje obecne hasło nie jest już zgodne z ustawioną polityką haseł, musisz zresetować hasło, aby się zalogować.
    {$a}';
$string['forcetheme'] = 'Wymuś temat';
$string['forgotaccount'] = 'Zapomniałeś hasła?';
$string['forgotten'] = 'Zapomniałeś(aś) nazwy użytkownika lub hasła?';
$string['forgottenduplicate'] = 'Ten adres e-mail należy do kilku kont. Wpisz nazwę użytkownika.';
$string['forgotteninvalidurl'] = 'Link do zmiany hasła wygasł';
$string['format'] = 'Format';
$string['formathtml'] = 'Format HTML';
$string['formatmarkdown'] = 'Format Markdown';
$string['formatplain'] = 'Format tekstu zwykłego';
$string['formattext'] = 'Automatyczny format Moodle';
$string['forumpreferences'] = 'Preferencje forum';
$string['framesetinfo'] = 'Ramka dokumentu zawiera:';
$string['fromdate'] = 'Od';
$string['fromsender'] = 'Od';
$string['frontpagecategorycombo'] = 'Lista wyboru';
$string['frontpagecategorynames'] = 'Pokaż listę kategorii';
$string['frontpagecourselist'] = 'Pokaż listę kursów';
$string['frontpagecoursesearch'] = 'Wyszukiwarka kursów';
$string['frontpagedescription'] = 'Podsumowanie strony głównej';
$string['frontpagedescriptionhelp'] = 'To podsumowanie można wyświetlić na stronie głównej za pomocą bloku podsumowania kursu/strony.';
$string['frontpageenrolledcourselist'] = 'Kursy przypisane';
$string['frontpageformat'] = 'Układ strony głównej';
$string['frontpageformatloggedin'] = 'Format strony głównej po zalogowaniu';
$string['frontpagenews'] = 'Ogłoszenia';
$string['frontpagesettings'] = 'Ustawienia strony głównej';
$string['fulllistofcourses'] = 'Wszystkie kursy';
$string['fullname'] = 'Pełna nazwa';
$string['fullnamecourse'] = 'Pełna nazwa kursu';
$string['fullnamecourse_help'] = 'Pełna nazwa kursu wyświetlana jest na górze każdej strony w kursie oraz na liście kursów';
$string['fullnamedisplay'] = '{$a->firstname} {$a->lastname}';
$string['fullnameuser'] = 'Pełna nazwa';
$string['fullprofile'] = 'Pełny profil';
$string['fullsitename'] = 'Pełna nazwa serwisu';
$string['functiondisabled'] = 'Ta funkcja jest obecnie wyłączona';
$string['general'] = 'Ogólne';
$string['geolocation'] = 'szerokość - długość geograficzna';
$string['gettheselogs'] = 'Pobierz logi';
$string['go'] = 'Wykonaj';
$string['gobacktosite'] = 'Wróć do strony';
$string['gpl'] = 'Copyright (C) 1999 onwards  Martin Dougiamas  (http://moodle.com)

Ten program jest wolnym oprogramowaniem; możesz go rozpowszechniać i/lub modyfikować zgodnie z warunkami GNU General Public License opublikowanej przez Free Software Foundation; albo w wersji 2 Licencji, albo (według wyboru) dowolnej późniejszej wersji.

Ten program jest rozpowszechniany z nadzieją, że będzie przydatny, ale BEZ JAKIEJKOLWIEK GWARANCJI; nawet domyślnej gwarancji PRZYDATNOŚCI HANDLOWEJ lub PRZYDATNOŚCI DO OKREŚLONYCH CELÓW.

Zobacz stronę z informacjami na temat licencji Moodle, aby uzyskać szczegółowe informacje:
http://docs.moodle.org/dev/License';
$string['gpl3'] = 'Copyright (C) 1999 onwards Martin Dougiamas (https://moodle.com)

Ten program jest wolnym oprogramowaniem: możesz go redystrybuować i/lub modyfikować na warunkach licencji GNU General Public License opublikowanej przez Free Software Foundation, w wersji 3 licencji lub (według własnego wyboru) w dowolnej późniejszej wersji.

Ten program jest dystrybuowany z nadzieją, że będzie użyteczny, ale BEZ ŻADNEJ GWARANCJI; nawet bez domniemanej gwarancji PRZYDATNOŚCI HANDLOWEJ lub PRZYDATNOŚCI DO OKREŚLONEGO CELU.

Więcej szczegółów znajdziesz na stronie z informacjami o licencji Moodle: https://moodledev.io/general/license';
$string['gpllicense'] = 'Licencja GPL';
$string['gradenoun'] = 'Ocena';
$string['grades'] = 'Oceny';
$string['gradeverb'] = 'Oceń';
$string['gravatarenabled'] = '<a href="https://www.gravatar.com/">Gravatar</a> został włączony dla tej witryny. Jeśli nie prześlesz zdjęcia profilowego, Moodle spróbuje załadować zdjęcie profilowe z Gravatara.';
$string['group'] = 'Grupa';
$string['groupadd'] = 'Dodaj nową grupę';
$string['groupaddusers'] = 'Dodaj do grupy';
$string['groupfor'] = 'dla grupy';
$string['groupinfo'] = 'Informacje o wybranej grupie';
$string['groupinfoedit'] = 'Edytuj ustawienia grup';
$string['groupinfomembers'] = 'Informacje o wybranych członkach';
$string['groupinfopeople'] = 'Informacje o wybranych ludziach';
$string['groupmembers'] = 'Członkowie grupy';
$string['groupmemberssee'] = 'Zobacz członków grupy';
$string['groupmembersselected'] = 'Członkowie wybranych grup';
$string['groupmode'] = 'Rodzaj grup';
$string['groupmodeforce'] = 'Wymuś grupy';
$string['groupmy'] = 'Moja grupa';
$string['groupnonmembers'] = 'Uczestnicy nie w mojej grupie';
$string['groupnotamember'] = 'Nie jesteś przypisany do tej grupy';
$string['grouprandomassign'] = 'Losowo przypisz wszystkich do grup';
$string['groupremove'] = 'Usuń zaznaczoną grupę';
$string['groupremovemembers'] = 'Usuń zaznaczonych członków';
$string['groups'] = 'Grupy';
$string['groupsnone'] = 'Bez grup';
$string['groupsseparate'] = 'Osobne grupy';
$string['groupsvisible'] = 'Widoczne grupy';
$string['guest'] = 'Gość';
$string['guestdescription'] = 'Goście mają niewiele uprawnień i przeważnie nie mogą nigdzie nic wpisywać.';
$string['guestskey'] = 'Zezwól gościom posiadającym klucz';
$string['guestsno'] = 'Wejście dla gości nie jest dozwolone';
$string['guestsnotallowed'] = 'Niestety, kurs \'{$a}\' nie jest dostępny dla gości.';
$string['guestsyes'] = 'Wejście dla gości bez klucza jest dozwolone';
$string['guestuser'] = 'Gość';
$string['guestuserinfo'] = 'To jest specjalny użytkownik, który posiada prawa dostępu do niektórych kursów wyłącznie w trybie \'do odczytu\'.';
$string['help'] = 'Pomoc';
$string['helpprefix2'] = 'Pomoc dla {$a}';
$string['helpwiththis'] = 'Pomóż z tym';
$string['hiddenassign'] = 'Ukryte zadanie';
$string['hiddenfromstudents'] = 'Ukryte przed studentami';
$string['hiddenoncoursepage'] = 'Dostępne, ale niewyświetlane na stronie kursu';
$string['hiddensections'] = 'Ukryte sekcje';
$string['hiddensections_help'] = 'Ukryte sekcje mogą być wyświetlane studentom jako „niedostępne” na stronie kursu lub mogą pozostać całkowicie ukryte.';
$string['hiddensectionscollapsed'] = 'Ukryte sekcje są wyświetlane jako niedostępne';
$string['hiddensectionsinvisible'] = 'Ukryte sekcje są całkowicie niewidoczne';
$string['hiddenwithbrackets'] = '(ukryte)';
$string['hide'] = 'Ukryj';
$string['hideadvancedsettings'] = 'Ukryj ustawienia zaawansowane';
$string['hidecategory'] = 'Ukryć kategorię?';
$string['hidecategorymany'] = 'Kategoria {$a->category} zawiera {$a->coursecount} kursów.
<br/>Jeśli ją ukryjesz, użytkownicy bez uprawnień do przeglądania ukrytych kategorii nie będą już mieli dostępu do kursów.';
$string['hidecategoryone'] = 'Kategoria {$a->category} zawiera 1 kurs.
<br/>Jeśli ją ukryjesz, użytkownicy bez uprawnień do przeglądania ukrytych kategorii nie będą już mieli dostępu do kursu.';
$string['hidechartdata'] = 'Ukryj dane wykresu';
$string['hidefromstudents'] = 'Ukryj na stronie kursu';
$string['hideoncoursepage'] = 'Uczyń dostępnym, jednak nie pokazuj na stronie kursu';
$string['hidepopoverwindow'] = 'Ukryj wyskakujące okno';
$string['hidesection'] = 'Ukryj sekcję {$a}';
$string['hidesettings'] = 'Ukryj ustawienia';
$string['hideshowblocks'] = 'Ukryj lub pokaż bloki';
$string['highlight'] = 'Podświetl';
$string['highlighted'] = 'Wyróżnione';
$string['highlightoff'] = 'Usuń podświetlenie';
$string['hits'] = 'Wyświetlenia';
$string['hitsoncourse'] = 'Wyświetlenia {$a->coursename} przez {$a->username}';
$string['hitsoncoursetoday'] = 'Dzisiejsze wyświetlenia w {$a->coursename} przez {$a->username}';
$string['home'] = 'Strona główna';
$string['homeheader'] = 'Menu główne';
$string['hour'] = 'godzina';
$string['hours'] = 'godzin';
$string['howtomakethemes'] = 'Jak utworzyć nowy temat';
$string['htmleditor'] = 'Użyj edytora HTML';
$string['htmleditoravailable'] = 'Edytor HTML jest dostępny';
$string['htmleditordisabled'] = 'Masz wyłączony edytor HTML w swoim profilu użytkownika';
$string['htmleditordisabledadmin'] = 'Administrator wyłączył edytor HTML w tym serwisie';
$string['htmleditordisabledbrowser'] = 'Edytor HTML jest niedostępny ponieważ nie używasz Internet Explorera 5.5 lub nowszego.';
$string['htmlfilesonly'] = 'Tylko pliki HTML';
$string['htmlformat'] = 'Pełny format HTML';
$string['icon'] = 'Ikona';
$string['idnumber'] = 'Numer ID';
$string['idnumbercourse'] = 'ID kursu';
$string['idnumbercourse_help'] = 'Używane tylko do łączenia kursu z systemami zewnętrznymi. Pozostaw puste, jeśli nie masz oficjalnego identyfikatora kursu.';
$string['idnumbercoursecategory'] = 'ID kategorii';
$string['idnumbercoursecategory_help'] = 'Numer ID kategorii kursu jest używany przy współpracy z zewnętrznymi systemami i nie jest nigdzie wyświetlany. Jeśli kategoria ma oficjalna nazwę kodową, może być wprowadzona. W przeciwnym razie polo może zostać puste.';
$string['idnumbergroup'] = 'Numer ID grupy';
$string['idnumbergroup_help'] = 'Nr grupy jest tylko używane podczas dopasowania grupy przed zewnętrznymi systemami i nie jest nigdzie wyświetlane na stronie. Jeżeli grupa ma oficjalną nazwę kodu, można ją wprowadzić, inaczej pole powinno pozostać puste.';
$string['idnumbergrouping'] = 'Numer ID grupy nadrzędnej';
$string['idnumbergrouping_help'] = 'Nr ID grupy nadrzędnej jest używany tylko podczas dopasowania grupy nadrzędnej z zewnętrznymi systemami i nie jest nigdzie wyświetlane na stronie. Jeżeli grupa nadrzędna ma oficjalną nazwę kodu, można ją wprowadzić, inaczej pole powinno pozostać puste.';
$string['idnumbermod'] = 'Numer ID';
$string['idnumbermod_help'] = 'Ustawienie numeru ID stanowi sposób na identyfikowanie aktywności w obliczeniach ocen. Jeżeli aktywność nie jest wykorzystywana w obliczeniach ocen, numer ID może pozostać pusty.';
$string['idnumbertaken'] = 'Ten numer ID jest już zajęty';
$string['imagealt'] = 'Opis zdjęcia';
$string['import'] = 'Import';
$string['importdata'] = 'Importuj dane kursu';
$string['importdataexported'] = 'Eksport danych kompletny.<br/> Kliknij \'Kontynuuj\', aby importować je do wskazanego kursu.';
$string['importdatafinished'] = 'Import kompletny. Powróć do kursu';
$string['importdatafrom'] = 'Znajdź kurs, z którego chcesz importować dane:';
$string['importinfo'] = 'Importuj elementy z innych kursów, takie jak aktywności, bloki lub wydarzenia w kalendarzu. Dane użytkownika nie zostaną zaimportowane.';
$string['inactive'] = 'Nieaktywne';
$string['include'] = 'Uwzględnij';
$string['includeallusers'] = 'Uwzględnij wszystkich użytkowników';
$string['includecoursefiles'] = 'Uwzględnij pliki kursu';
$string['includecourseusers'] = 'Uwzględnij użytkowników kursu';
$string['included'] = 'Uwzględniono';
$string['includelogentries'] = 'Uwzględnij logi';
$string['includemodules'] = 'Uwzględnij moduły';
$string['includemoduleuserdata'] = 'Uwzględnij dane użytkowników modułu';
$string['includeneededusers'] = 'Uwzględnij wymaganych użytkowników';
$string['includenoneusers'] = 'Nie uwzględniaj żadnych użytkowników';
$string['includeroleassignments'] = 'Uwzględnij przypisania ról';
$string['includesitefiles'] = 'Dołącz pliki strony głównej użyte w tym kursie';
$string['includesubcategories'] = 'Uwzględnij podkategorie';
$string['includeuserfiles'] = 'Uwzględnij pliki użytkownika';
$string['increasesections'] = 'Zwiększ liczbę sekcji';
$string['indicator:accessesafterend'] = 'Kurs dostępny po dacie zakończenia';
$string['indicator:accessesafterend_help'] = 'Wskaźnik ten pokazuje, czy student miał dostęp do kursu po dacie zakończenia kursu.';
$string['indicator:accessesbeforestart'] = 'Kurs dostępny przed datą rozpoczęcia';
$string['indicator:accessesbeforestart_help'] = 'Wskaźnik ten pokazuje, czy student miał dostęp do kursu przed datą rozpoczęcia kursu.';
$string['indicator:activitiesdue'] = 'Zaplanowane aktywności';
$string['indicator:activitiesdue_help'] = 'Użytkownik ma zaplanowane aktywności';
$string['indicator:anycourseaccess'] = 'Wszelkie wejścia do kursu';
$string['indicator:anycourseaccess_help'] = 'Ten wskaźnik odzwierciedla dostęp do dowolnego kursu, na który zapisał się użytkownik.';
$string['indicator:anywrite'] = 'Każda akcja zapisu';
$string['indicator:anywrite_help'] = 'Ten wskaźnik reprezentuje dowolną akcję zapisu (przesłania) podjętą przez studenta.';
$string['indicator:anywriteincourse'] = 'Wszelkie działania związane z pisaniem w trakcie kursu';
$string['indicator:anywriteincourse_help'] = 'Ten wskaźnik reprezentuje dowolną akcję zapisu (przesłania) podjętą przez studenta w dowolnym kursie.';
$string['indicator:completeduserprofile'] = 'Profil użytkownika został uzupełniony';
$string['indicator:completeduserprofile_help'] = 'Ten wskaźnik reprezentuje to, że student uzupełnił swój profil użytkownika.';
$string['indicator:completeduserprofiledef'] = 'Profil użytkownika jest kompletny';
$string['indicator:completeduserprofiledef_help'] = 'Zasady witryny zostały zatwierdzone, a użytkownik wypełnił następujące pola: instytucja, dział, adres, miasto, kraj, adres URL.';
$string['indicator:completionenabled'] = 'Włączono śledzenie ukończenia';
$string['indicator:completionenabled_help'] = 'Ten wskaźnik oznacza, że śledzenie ukończenia zostało włączone dla tego kursu.';
$string['indicator:nostudent'] = 'Zapisy studentów';
$string['indicator:nostudent_help'] = 'Ten wskaźnik pokazuje, że w tym kursie nie ma studentów.';
$string['indicator:noteacher'] = 'Dostępność nauczyciela';
$string['indicator:noteacher_help'] = 'Ten wskaźnik pokazuje dostępność nauczycieli w kursie.';
$string['indicator:potentialcognitive'] = 'Potencjał poznawczy kursu';
$string['indicator:potentialcognitive_help'] = 'Wskaźnik ten opiera się na potencjalnej głębi poznawczej, jaką może osiągnąć student uczestniczący w aktywnościach.';
$string['indicator:potentialcognitivedef'] = 'Potencjał poznawczy kursu';
$string['indicator:potentialcognitivedef_help'] = 'Stopień, w jakim kurs zapewnia „głębokie” zaangażowanie poznawcze, m.in. przesyłanie zadań do oceny, możliwość recenzowania pracy przez innych oraz możliwość poprawienia i ponownego przesłania zadania.';
$string['indicator:potentialcognitivedef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:potentialsocial'] = 'Potencjał społeczny kursu';
$string['indicator:potentialsocial_help'] = 'Wskaźnik ten opiera się na potencjalnym zasięgu społecznym, który może zostać osiągnięty przez studenta uczestniczącego w zajęciach.';
$string['indicator:potentialsocialdef'] = 'Potencjał społeczny kursu';
$string['indicator:potentialsocialdef_help'] = 'Stopień, w jakim kurs oferuje "szerokie" zaangażowanie społeczne, interakcję z innymi uczestnikami i ze społecznością praktyków poza zajęciami.';
$string['indicator:potentialsocialdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['indicator:readactions'] = 'Liczba odczytów';
$string['indicator:readactions_help'] = 'Ten wskaźnik reprezentuje liczbę odczytów (wyświetleń) podjętych przez studenta.';
$string['indicator:userforumstracking'] = 'Użytkownik śledzi fora';
$string['indicator:userforumstracking_help'] = 'Ten wskaźnik pokazuje, czy student ma włączoną funkcję śledzenia na forach.';
$string['info'] = 'Informacja';
$string['inprogress'] = 'W toku';
$string['insertcontentbefore'] = 'Wstaw zawartość przed \'{$a->activityname}\'';
$string['insertcontentsection'] = 'Wstaw zawartość do sekcji \'{$a->sectionname}\'';
$string['insertresourceoractivitybefore'] = 'Wstaw aktywność lub zasób przed "{$a->activityname}".';
$string['institution'] = 'Instytucja';
$string['instudentview'] = 'widok studenta';
$string['interests'] = 'Zainteresowania';
$string['interestslist'] = 'Lista zainteresowań';
$string['interestslist_help'] = 'Wprowadź swoje zainteresowania, jeden po drugim, które następnie będą wyświetlane na stronie profilu jako tagi.';
$string['invalidemail'] = 'Niewłaściwy adres e-mail';
$string['invalidlogin'] = 'Niewłaściwa nazwa użytkownika lub hasło, spróbuj ponownie';
$string['invalidtaskclassname'] = 'Nieprawidłowa klasa zadania {$a}';
$string['invalidtaskid'] = 'Nieprawidłowe ID zadania';
$string['invalidusername'] = 'Nazwa użytkownika może zawierać tylko małe litery alfanumeryczne (litery i cyfry), podkreślenie (_), myślnik (-), kropkę (.) lub symbol (@).';
$string['invalidusernameupload'] = 'Niepoprawna nazwa użytkownika';
$string['ip_address'] = 'Adres IP';
$string['jump'] = 'Przejdź';
$string['jumpto'] = 'Przejdź do...';
$string['keep'] = 'Przechowaj';
$string['labelvalue'] = '{$a->label}: {$a->value}';
$string['langltr'] = 'Kierunek języka od lewej do prawej';
$string['langrtl'] = 'Kierunek języka od prawej do lewej';
$string['language'] = 'Język';
$string['languagegood'] = 'Ten pakiet językowy jest aktualny';
$string['languageselector'] = 'Wybór języka';
$string['last'] = 'Ostatni';
$string['lastaccess'] = 'Ostatni dostęp';
$string['lastcourseaccess'] = 'Ostatni dostęp do kursu';
$string['lastedited'] = 'Ostatnia modyfikacja';
$string['lastip'] = 'Ostatni adres IP';
$string['lastlogin'] = 'Ostanie logowanie';
$string['lastmodified'] = 'Ostatnia modyfikacja';
$string['lastname'] = 'Nazwisko';
$string['lastnamephonetic'] = 'Nazwisko - fonetyczne';
$string['lastpage'] = 'Ostatnia strona';
$string['lastsiteaccess'] = 'Ostatni dostęp do strony';
$string['lastyear'] = 'Zeszły rok';
$string['latestlanguagepack'] = 'Szukaj najnowszego pakietu językowego na moodle.org';
$string['layouttable'] = 'Układ tabeli';
$string['leavetokeep'] = 'Pozostaw puste, aby zachować dotychczasowe hasło';
$string['legacylogginginuse'] = '';
$string['legacythemeinuse'] = 'Ta strona wyświetlana jest w trybie zgodności ponieważ Twoja przeglądarka jest zbyt stara.';
$string['license'] = 'Licencja';
$string['licenses'] = 'Licencje';
$string['liketologin'] = 'Czy chcesz sie zalogować z pełnymi prawami użytkownika?';
$string['list'] = 'Lista';
$string['listfiles'] = 'Lista plików w {$a}';
$string['listofallpeople'] = 'Lista wszystkich osób';
$string['listofcourses'] = 'Wykaz kursów';
$string['loading'] = 'Ładowanie';
$string['loadinghelp'] = 'Ładowanie ...';
$string['local'] = 'Lokalny';
$string['localplugins'] = 'Wtyczki lokalne';
$string['localpluginsmanage'] = 'Zarządzaj wtyczkami lokalnymi';
$string['location'] = 'Lokalizacja';
$string['locktimeout'] = 'Operacja przekroczyła limit czasu podczas oczekiwania na blokadę.';
$string['log_excel_date_format'] = 'yyyy mmmm d h:mm';
$string['loggedinas'] = 'Jesteś zalogowany(a) jako {$a}';
$string['loggedinasguest'] = 'Jesteś zalogowany jako gość';
$string['loggedinnot'] = 'Nie jesteś zalogowany(a)';
$string['login'] = 'Zaloguj się';
$string['login_failure_logs'] = 'Logi nieudanych prób logowania';
$string['loginactivity'] = 'Aktywność konta';
$string['loginagain'] = 'Zaloguj się jeszcze raz';
$string['loginalready'] = 'Jesteś już zarejestrowany';
$string['loginas'] = 'Zaloguj się jako';
$string['loginaspasswordexplain'] = '<p>Wprawadź specjalny "loginas password", aby uzyskać dostęp do tego ustawienia.<br/>';
$string['loginguest'] = 'Zaloguj się jako gość';
$string['loginsite'] = 'Zaloguj się do serwisu';
$string['loginsteps'] = 'Aby otrzymać pełny dostęp do kursów w tym serwisie, musisz najpierw utworzyć konto.';
$string['loginstepsnone'] = '<p>Witaj!</p>
<p>Dla uzyskania pełnego dostępu do kursów niezbędne jest utworzenie konta.</p>
<p>Utwórz nazwę użytkownika i hasło oraz użyj tych danych w formularza na tej stronie!</p>
<p>Jeżeli ktoś inny wybrał już taką nazwę użytkownika, będziesz musiał(a) powtórzyć operację używając innej nazwy.</p>';
$string['loginto'] = 'Zaloguj do {$a}';
$string['logoof'] = 'Logo {$a}';
$string['logout'] = 'Wyloguj';
$string['logoutconfirm'] = 'Czy chcesz się wylogować?';
$string['logs'] = 'Logi';
$string['logtoomanycourses'] = '[ <a href="{$a->url}">więcej</a> ]';
$string['logtoomanyusers'] = '[ <a href="{$a->url}">więcej</a> ]';
$string['lookback'] = 'Zobacz poprzednie';
$string['mailadmins'] = 'Powiadom administratorów';
$string['mailstudents'] = 'Powiadom studentów';
$string['mailteachers'] = 'Powiadom nauczycieli';
$string['maincoursepage'] = 'Strona główna kursu';
$string['makeafolder'] = 'Utwórz folder';
$string['makeavailable'] = 'Uczyń dostępnym';
$string['makeeditable'] = 'Jeżeli umożliwisz edycję \'{$a}\' przez proces serwera WWW (np. Apache), możesz dokonać edycji tego pliku bezpośrednio z tej strony.';
$string['makethismyhome'] = 'Ustaw to jako moją stronę główną';
$string['makeunavailable'] = 'Uczyń niedostępnym';
$string['manageblocks'] = 'Bloki';
$string['managecategories'] = 'Zarządzaj kategoriami kursów';
$string['managecategorythis'] = 'Zarządzaj tą kategorią';
$string['managecombined'] = 'Zarządzaj kategoriami kursów i kursami';
$string['managecontentbanktypes'] = 'Zarządzaj typami treści';
$string['managecourses'] = 'Zarządzaj kursami';
$string['managedatabase'] = 'Zarządzaj bazą danych';
$string['managedataformats'] = 'Zarządzaj formatami danych';
$string['manageeditorfiles'] = 'Zarządzaj plikami używanymi przez edytor';
$string['managefilters'] = 'Filtry';
$string['managemodules'] = 'Zarządzaj modułami';
$string['manageroles'] = 'Role i uprawnienia';
$string['markallread'] = 'Oznacz wszystko jako przeczytane';
$string['match'] = 'Dopasuj';
$string['matchingsearchandrole'] = 'Pasujące: \'{$a->search}\' i {$a->role}';
$string['matchofthefollowing'] = 'z następujących:';
$string['maxareabytesreached'] = 'Plik (lub całkowity rozmiar kilku plików) jest większy niż pozostałe miejsce w tym obszarze.';
$string['maxfilesize'] = 'Maksymalny rozmiar dla nowych plików: {$a}';
$string['maxfilesreached'] = 'Możesz dołączyć maksymalnie {$a} plik(i)(ów) do tej pozycji';
$string['maximumchars'] = 'Maksymalnie {$a} znaków';
$string['maximumgrade'] = 'Maksymalna ocena';
$string['maximumgradex'] = 'Maksymalna ocena: {$a}';
$string['maximumshort'] = 'Max';
$string['maximumupload'] = 'Maksymalny rozmiar pliku';
$string['maximumupload_help'] = 'Maksymalny rozmiar pliku, który student może przesłać do kursu. Dodatkowo możesz dodatkowo ograniczyć maksymalny rozmiar przesyłanych plików dla każdej aktywności.';
$string['maxlengthreached'] = 'Osiągnięto maksymalny limit znaków {$a}';
$string['maxnumberweeks'] = 'Maksymalna liczba sekcji';
$string['maxnumberweeks_desc'] = 'Ta opcja steruje maksymalnymi wartościami opcji, które pojawiają się w ustawieniach "Liczba tygodni/tematów" w kursach';
$string['maxnumcoursesincombo'] = 'Przeglądaj <a href="{$a->link}">{$a->numberofcourses} kursy(ów)</a>.';
$string['maxsectionslimit'] = 'Nie można utworzyć nowej sekcji, ponieważ przekroczyłaby maksymalną liczbę sekcji dozwoloną dla tego kursu ({$a}).';
$string['maxsize'] = 'Maksymalny rozmiar: {$a}';
$string['maxsizeandareasize'] = 'Maksymalny rozmiar dla nowych plików: {$a->size}, ogólny limit: {$a->areasize}';
$string['maxsizeandattachments'] = 'Maksymalny rozmiar plików: {$a->size}, maksymalna liczba załączników: {$a->attachments}';
$string['maxsizeandattachmentsandareasize'] = 'Maksymalny rozmiar pliku: {$a->size}, maksymalna liczba plików: {$a->attachments}, maksymalny całkowity rozmiar: {$a->areasize}';
$string['memberincourse'] = 'Zapisani na kurs';
$string['menu'] = 'Menu';
$string['message'] = 'Wiadomość';
$string['messagebody'] = 'Treść wiadomości';
$string['messagedselectedusers'] = 'Wiadomość została wysłana do wybranych użytkowników, a następnie wyczyszczono listę adresatów.';
$string['messagedselectedusersfailed'] = 'Nastąpił błąd podczas przesyłania wiadomości do zaznaczonych użytkowników. Część z nich mogła otrzymać ten e-mail.';
$string['messageprovider:asyncbackupnotification'] = 'Powiadomienia o asynchronicznym tworzeniu / przywracaniu kopii zapasowych';
$string['messageprovider:availableupdate'] = 'Powiadomienia o dostępnych aktualizacjach';
$string['messageprovider:backup'] = 'Powiadomienie o kopii zapasowej';
$string['messageprovider:badgecreatornotice'] = 'Powiadomienia twórcy odznaki';
$string['messageprovider:badgerecipientnotice'] = 'Powiadomienia odbiorcy odznaki';
$string['messageprovider:competencyplancomment'] = 'Komentarz zamieszczony na planie nauki';
$string['messageprovider:competencyusercompcomment'] = 'Komentarz zamieszczony na podstawie kompetencji';
$string['messageprovider:coursecompleted'] = 'Kurs ukończony';
$string['messageprovider:coursecontentupdated'] = 'Zmiany zawartości kursu';
$string['messageprovider:courserequestapproved'] = 'Powiadomienie o zatwierdzeniu prośby o utworzenie kursu';
$string['messageprovider:courserequested'] = 'Powiadomienie o prośbie o utworzenie kursu';
$string['messageprovider:courserequestrejected'] = 'Powiadomienie o odrzuceniu prośby o utworzenie kursu';
$string['messageprovider:enrolcoursewelcomemessage'] = 'Wiadomość powitalna dotycząca nowych zapisów do kursu';
$string['messageprovider:errors'] = 'Ważne błędy z witryny';
$string['messageprovider:errors_help'] = 'Są to istotne błędy, o których powinien wiedzieć administrator.';
$string['messageprovider:failedtaskmaxdelay'] = 'Zadanie osiągnęło maksymalne opóźnienie niepowodzenia';
$string['messageprovider:gradenotifications'] = 'Powiadomienia o ocenie';
$string['messageprovider:infected'] = 'Powiadomienia o awariach antywirusa.';
$string['messageprovider:insights'] = 'Spostrzeżenia wygenerowane przez modele prognoz';
$string['messageprovider:instantmessage'] = 'Osobiste wiadomości między użytkownikami';
$string['messageprovider:instantmessage_help'] = 'W tej sekcji można skonfigurować, co dzieje się z wiadomościami przesyłanymi przez innych użytkowników.';
$string['messageprovider:messagecontactrequests'] = 'Powiadomienie o prośbie o kontakt w wiadomościach';
$string['messageprovider:newlogin'] = 'Powiadomienia o nowym logowaniu';
$string['messageprovider:notices'] = 'Powiadomienia o drobnych problemach';
$string['messageprovider:notices_help'] = 'Są to powiadomienia, którymi mógłby się zainteresować administrator.';
$string['messageprovider:reportbuilderschedule'] = 'Powiadomienia kreatora zaplanowanych raportów niestandardowych';
$string['messageselect'] = 'Wybierz tego użytkownika jako odbiorcę wiadomości';
$string['messageselectadd'] = 'Wyślij wiadomość';
$string['middlename'] = 'Drugie imię';
$string['migratinggrades'] = 'Przenoszenie ocen';
$string['min'] = 'min';
$string['mins'] = 'min.';
$string['minute'] = 'minuta';
$string['minutes'] = 'minut';
$string['miscellaneous'] = 'Różne';
$string['missingcategory'] = 'Musisz wybrać kategorię';
$string['missingdescription'] = 'Pominięto opis';
$string['missingemail'] = 'Pominięto adres e-mail';
$string['missingfirstname'] = 'Pominięto imię';
$string['missingfromdisk'] = 'Pominięto plik z dysku';
$string['missingfullname'] = 'Pominięto pełną nazwę';
$string['missinglastname'] = 'Brak nazwiska';
$string['missingname'] = 'Pominięto imię';
$string['missingnewpassword'] = 'Pominięto nowe hasło';
$string['missingpassword'] = 'Pominięto hasło';
$string['missingrecaptchachallengefield'] = 'Nie wpisano tekstu reCAPTCHA, spróbuj ponownie.';
$string['missingreqreason'] = 'Pominięto powód';
$string['missingshortname'] = 'Pominięto nazwę skróconą';
$string['missingshortsitename'] = 'Pominięto skróconą nazwę serwisu';
$string['missingsitedescription'] = 'Pominięto opis serwisu';
$string['missingsitename'] = 'Pominięto nazwę serwisu';
$string['missingstrings'] = 'Poszukaj brakujących tłumaczeń słów lub wyrażeń';
$string['missingstudent'] = 'Należy coś wybrać';
$string['missingsummary'] = 'Pominięto streszczenie';
$string['missingteacher'] = 'Należy coś wybrać';
$string['missingurl'] = 'Pominięto adres URL';
$string['missingusername'] = 'Pominięto nazwę użytkownika';
$string['moddoesnotsupporttype'] = 'Moduł {$a->modname} nie pozwala na przesyłanie treści typu {$a->type}';
$string['modhide'] = 'Ukryj';
$string['modified'] = 'Zmodyfikowano';
$string['modshow'] = 'Pokaż';
$string['moduleintro'] = 'Opis';
$string['modulesetup'] = 'Tworzenie tablic modułów';
$string['modulesuccess'] = 'tablice dla modułu {$a} utworzono poprawnie';
$string['modulesused'] = 'Używane moduły';
$string['modvisible'] = 'Dostępność';
$string['modvisible_help'] = '* Pokaż na stronie kursu: Dostępne dla studentów (z zastrzeżeniem wszelkich ograniczeń dostępu, które mogą być ustawione).
* Ukryj na stronie kursu: Niedostępne dla studentów.';
$string['modvisiblehiddensection'] = 'Dostępność';
$string['modvisiblehiddensection_help'] = '* Ukryj na stronie kursu: Niedostępne dla studentów.
* Udostępnij, ale nie pokazuj na stronie kursu: Dostępne dla studentów, jeśli podasz link. Aktywności nadal będą pojawiać się w arkuszu ocen i innych raportach.';
$string['modvisiblewithstealth'] = 'Dostępność';
$string['modvisiblewithstealth_help'] = '* Pokaż na stronie kursu: Dostępne dla studentów (z zastrzeżeniem wszelkich ograniczeń dostępu, które mogą być ustawione).
* Ukryj na stronie kursu: Niedostępne dla studentów.
* Udostępnij, ale nie pokazuj na stronie kursu: Dostępne dla studentów, jeśli podasz link. Aktywności nadal będą wyświetlane w arkuszu ocen i innych raportach.';
$string['month'] = 'miesiąc';
$string['months'] = 'miesiące';
$string['moodledocs'] = 'Dokumentacja Moodle';
$string['moodledocslink'] = 'Dokumentacja dla tej strony';
$string['moodlelogo'] = 'Logo Moodle';
$string['moodlenet:cannotconnecttoserver'] = 'Nie można połączyć się z serwerem MoodleNet';
$string['moodlenet:columnname'] = 'Nazwa';
$string['moodlenet:columnsenddate'] = 'Data wysłania';
$string['moodlenet:columnsendstatus'] = 'Status wysłania';
$string['moodlenet:columntype'] = 'Typ';
$string['moodlenet:configoauthservice'] = 'Wybierz usługę MoodleNet OAuth 2, aby włączyć udostępnianie w tej witrynie MoodleNet.  Jeśli usługa jeszcze nie istnieje, należy ją <a href="{$a}">utworzyć</a>.';
$string['moodlenet:deletedactivity'] = 'Aktywność usunięta';
$string['moodlenet:deletedcourse'] = 'Kurs usunięty';
$string['moodlenet:eventresourceexported'] = 'Zasób wyeksportowany';
$string['moodlenet:gotomoodlenet'] = 'Przejdź do wersji roboczych MoodleNet';
$string['moodlenet:issuerisnotauthorized'] = 'Wydawca MoodleNet nie jest autoryzowany';
$string['moodlenet:issuerisnotenabled'] = 'Wydawca MoodleNet nie jest włączony';
$string['moodlenet:issuerisnotset'] = 'Wydawca MoodleNet nie jest ustawiony w administracji strony';
$string['moodlenet:nosharedresources'] = 'W tej chwili nie ma żadnych udostępnionych zasobów do wyświetlenia.';
$string['moodlenet:outboundsettings'] = 'Ustawienia ruchu wychodzącego MoodleNet';
$string['moodlenet:packagingandsending'] = 'Kompresowanie pliku i wysyłanie do MoodleNet...';
$string['moodlenet:sharefailtext'] = 'Wystąpił błąd podczas udostępniania treści do MoodleNet.<br>Spróbuj ponownie później.';
$string['moodlenet:sharefailtextwithsitesupport'] = 'Wystąpił błąd podczas udostępniania Twojej treści w MoodleNet.<br>Spróbuj ponownie później lub <a href="{$a}">skontaktuj się z obsługą witryny</a>.';
$string['moodlenet:sharefailtitle'] = 'Coś poszło nie tak';
$string['moodlenet:sharefilesizelimitexceeded'] = 'Rozmiar udostępnianego zasobu ({$a->filesize} bajtów) przekracza limit {$a->filesizelimit} bajtów.';
$string['moodlenet:sharenoticeactivity'] = 'Ta aktywność jest udostępniana w MoodleNet jako zasób.';
$string['moodlenet:sharenoticecourse'] = 'Ten kurs jest udostępniany w MoodleNet jako zasób.';
$string['moodlenet:sharenoticepartial'] = 'Wybrane aktywności są udostępniane w MoodleNet jako zasoby.';
$string['moodlenet:sharenoticepartialactivitynumber'] = 'Aktywności {$a} będą uwzględnione w kursie.';
$string['moodlenet:shareprogress'] = 'Postęp udostępniania w MoodleNet';
$string['moodlenet:shareprogressinfo'] = 'Lista pokazuje kursy i aktywności udostępnione w MoodleNet.<br>Kliknij nazwę zasobu, aby wyświetlić go w MoodleNet.';
$string['moodlenet:sharesuccesstext'] = 'Prawie gotowe! Odwiedź swoje wersje robocze w MoodleNet, aby dokończyć udostępnianie treści.';
$string['moodlenet:sharesuccesstitle'] = 'Zapisane w wersjach roboczych MoodleNet';
$string['moodlenet:sharetomoodlenet'] = 'Udostępnij w MoodleNet';
$string['moodlenet:sharinglargefile'] = 'Duże pliki mogą zająć trochę czasu.';
$string['moodlenet:sharingstatus'] = 'Udostępnianie w MoodleNet';
$string['moodlenet:sharingto'] = 'Udostępnianie:';
$string['moodlerelease'] = 'Wydanie Moodle';
$string['moodleservicesandsupport'] = 'Usługi i wsparcie';
$string['moodleversion'] = 'Wersja Moodle';
$string['more'] = 'więcej';
$string['moreactions'] = 'Więcej akcji';
$string['morehelp'] = 'Więcej pomocy';
$string['morehelpaboutmodule'] = 'Więcej pomocy na temat aktywności {$a}';
$string['moreinfo'] = 'Więcej informacji';
$string['moreinformation'] = 'Więcej informacji o tym błędzie';
$string['moremenu'] = 'Więcej';
$string['morenavigationlinks'] = 'Więcej...';
$string['moreprofileinfoneeded'] = 'Proszę, napisz coś więcej o sobie.';
$string['mostrecently'] = 'najświeższe';
$string['move'] = 'Przenieś';
$string['movecategoriessuccess'] = 'Pomyślnie przeniesiono {$a->count} kategorii do kategorii \'{$a->to}\'';
$string['movecategoriestotopsuccess'] = 'Pomyślnie przeniesiono {$a->count} kategorii do nadrzędnego poziomu';
$string['movecategorycontentto'] = 'Przenieś do';
$string['movecategorysuccess'] = 'Pomyślnie przeniesiono kategorię \'{$a->moved}\' do kategorii \'{$a->to}\'';
$string['movecategoryto'] = 'Przenieś kategorię do:';
$string['movecategorytotopsuccess'] = 'Pomyślnie przeniesiono {$a->count} kategorii do nadrzędnego poziomu';
$string['movecontent'] = 'Przenieś {$a}';
$string['movecontentafter'] = 'Po "{$a}"';
$string['movecontentstoanothercategory'] = 'Przenieś zawartość do innej kategorii';
$string['movecontenttothetop'] = 'Na początek listy';
$string['movecoursemodule'] = 'Przenieś aktywność';
$string['movecoursesection'] = 'Przenieś sekcję';
$string['movecourseto'] = 'Przenieś kurs do:';
$string['movedown'] = 'Przesuń w dół';
$string['movefilestohere'] = 'Przesuń pliki tutaj';
$string['movefull'] = 'Przenieś {$a} do tej lokacji';
$string['movehere'] = 'Przenieś tutaj';
$string['moveitemdown'] = 'Przesuń {$a} w dół';
$string['moveitemup'] = 'Przesuń {$a} w górę';
$string['moveleft'] = 'Przenieś na lewo';
$string['moveright'] = 'Przenieś na prawo';
$string['movesection'] = 'Przenieś sekcję {$a}';
$string['moveselectedcategoriesto'] = 'Przenieś wybrane kategorie do';
$string['moveselectedcoursesto'] = 'Przenieś zaznaczone kursy do...';
$string['movetoanotherfolder'] = 'Przesuń do innego folderu';
$string['moveup'] = 'Przesuń w górę';
$string['mustchangepassword'] = 'Nowe hasło musi być inne niż aktualnie używane.';
$string['mustconfirm'] = 'Musisz potwierdzić swoje konto';
$string['mycourses'] = 'Moje kursy';
$string['myfiles'] = 'Moje prywatne pliki';
$string['myfilesmanage'] = 'Zarządzaj plikami prywatnymi';
$string['myhome'] = 'Kokpit';
$string['mymoodledashboard'] = 'Mój kokpit Moodle';
$string['myprofile'] = 'Mój profil';
$string['name'] = 'Nazwa';
$string['namedfiletoolarge'] = 'Plik \'{$a->filename}\' jest zbyt duży i nie może zostać przesłany';
$string['nameforlink'] = 'Jak chcesz nazwać łącze?';
$string['nameforpage'] = 'Nazwa';
$string['navigation'] = 'Nawigacja';
$string['needed'] = 'Wymagane';
$string['networkdropped'] = 'Wykryto, że Twoje połączenie internetowe jest niestabilne lub zostało przerwane. <br /> Należy pamiętać, że zmiany nie mogą być zapisane poprawnie, dopóki twoje połączenie nie poprawi się.';
$string['never'] = 'Nigdy';
$string['neverdeletelogs'] = 'Nigdy nie usuwaj logów';
$string['new'] = 'Nowy';
$string['newaccount'] = 'Nowe konto';
$string['newactivityname'] = 'Nowa nazwa dla aktywności {$a}';
$string['newcourse'] = 'Nowy kurs';
$string['newloginnotificationbodyfull'] = '<p>Cześć {$a->userfullname},</p>
<p>Twoje konto zostało użyte do zalogowania się z nowego urządzenia na: {$a->sitename}.</p>
<ul>
<li>Twoje konto: {$a->username} {$a->useremail}</li>
<li>Data i godzina logowania: {$a->logintime}</li>
<li>Urządzenie: {$a->logindevice}</li>
<li>Adres IP: {$a->loginip}</li>
</ul>
<p>Jeśli to ty, nie musisz nic robić.</p>
<p>Jeśli nie rozpoznajesz tej aktywności, <a href="{$a->changepasswordlink}">zmień swoje hasło</a>.</p>';
$string['newloginnotificationbodysmall'] = 'Nowe logowanie na Twoje konto {$a} z nowego urządzenia.';
$string['newloginnotificationtitle'] = 'Nowe logowanie na Twoje konto {$a}';
$string['newpassword'] = 'Nowe hasło';
$string['newpassword_help'] = 'Wprowadź nowe hasło lub pozostaw puste pole by zachować obecne hasło.';
$string['newpasswordfromlost'] = '<strong>NOTICE:</strong> Twoje <strong>obecne hasło</strong> zostanie do Ciebie wysłane w dwóch
mailach. Po otrzymaniu nowego hasła będziesz mógł skorzystać z tej strony.';
$string['newpasswordtext'] = 'Drogi użytkowniku: {$a->firstname},
twoje hasło do konta w {$a->sitename} zostało zresetowane i otrzymałeś nowe hasło tymczasowe.

Twoje aktualne dane logowania są następujące:
   nazwa użytkownika: {$a->username}
   hasło: {$a->newpassword}

Przejdź do tej strony, aby zmienić hasło: {$a->link}

W większości programów pocztowych adres powyżej powinien być wyświetlany jako niebieski link, który można po prostu kliknąć. Jeśli to nie zadziała, wytnij i wklej adres w pasku adresu u góry okna przeglądarki internetowej.

Pozdrowienia od administratora {$a->sitename},
{$a->signoff}';
$string['newpicture'] = 'Nowy obraz';
$string['newpicture_help'] = '<P ALIGN=CENTER><B>Przesyłanie grafiki</B></P>

<P>Możesz przesłać na ten serwer plik graficzny ze swojego komputera.  Plik ten będzie Cię reprezentował w różnych miejscach.
<P>Z podanego powyżej powodu najlepszym wizerunkiem będzie Twój portret z bliska, ale możesz wykorzystać dowolną inną grafikę.
<P>Plik graficzny musi mieć format JPG lub PNG (tzn. jego nazwa powinna mieć rozszerzenie .jpg lub .png).
<P>Są cztery sposoby uzyskania pliku graficznego:

<OL>
<LI>Zdjęcia wykonane cyfrowym aparatem fotograficznym zapisane w Twoim komputerze najprawdopodobniej będą już we właściwym formacie.
<LI>Możesz zeskanować odbitkę fotograficzną - pamiętaj o zapisaniu pliku w formacie JPG lub PNG.
<LI>Jeżeli masz zdolności artystyczne, możesz sam zrobić rysunek używając programu do malowania.
<LI>Możesz &quot;podkraść&quot; plik graficzny z sieci WWW.  <A TARGET=google HREF="http://images.google.com/">http://images.google.com</A> to znakomite miejsce do szukania grafiki. Po znalezieniu odpowiedniego pliku, kliknij prawym przyciskiem myszy i wybierz polecenie &quot;Zapisz rysunek&quot; z menu (procedura ta może się trochę różnić w zależności od komputera).
</OL>

<P>W celu przesłania pliku graficznego, kliknij przycisk &quot;Przeglądaj&quot; na niniejszej stronie edycji i wybierz odpowiedni plik z twardego dysku.</p>
<P>UWAGA: Upewnij się że plik ten nie przekracza podanego maksymalnego rozmiaru, w przeciwnym razie nie zostanie on przesłany.</p>
<P>Następnie kliknij &quot;Aktualizuj mój profil&quot; na dole ekranu  - obraz zostanie przycięty i zmniejszony do rozmiaru 100 na 100 pikseli.</p>
<P>Gdy powrócisz na stronę profilu, być może nie zmieni się wygląd reprezentującej Cię grafiki. W takim przypadku kliknij w swojej przeglądarce przycisk &quot;Odśwież&quot;.</p>';
$string['newpictureusernotsetup'] = 'Zdjęcie może zostać dodane do profilu dopiero po uzupełnieniu wszystkich wymaganych danych.';
$string['newsectionname'] = 'Nowa nazwa dla sekcji {$a}';
$string['newsitem'] = 'Wiadomość';
$string['newsitems'] = 'ogłoszenia';
$string['newsitemsnumber'] = 'Liczba ogłoszeń';
$string['newsitemsnumber_help'] = 'Forum ogłoszeń jest specjalnym forum, które jest tworzone automatycznie w trakcie kursu, ma domyślnie wymuszoną subskrypcję i tylko użytkownicy z odpowiednimi uprawnieniami (domyślnie nauczyciele) mogą na nim publikować.

To ustawienie określa liczbę informacji wyświetlanych w bloku ostatnich ogłoszeń.

Jeśli forum nie jest wymagane w trakcie kursu, to ustawienie powinno być ustawione na zero.';
$string['newuser'] = 'Nowy użytkownik';
$string['newusernewpasswordsubj'] = 'Nowe konto użytkownika';
$string['newusernewpasswordtext'] = 'Drogi użytkowniku: {$a->firstname},
na stronie {$a->sitename} zostało założone dla Ciebie nowe konto z tymczasowym hasłem.

W celu rozpoczęcia pracy, zaloguj się na stronie {$a->sitename} znajdującej się pod adresem {$a->link}

Twoje obecne dane do logowania są następujące:
      <b>adres strony:</b> {$a->link}
      <b>nazwa użytkownika:</b> {$a->username}
      <b>hasło:</b> {$a->newpassword}
(hasło należy zmienić podczas pierwszego logowania)

Administrator serwisu
{$a->signoff}';
$string['newusers'] = 'Nowi użytkownicy';
$string['newwindow'] = 'Nowe okno';
$string['next'] = 'Dalej';
$string['nextpage'] = 'Następna strona';
$string['nextsection'] = 'Następna sekcja';
$string['no'] = 'Nie';
$string['noblockstoaddhere'] = 'Nie ma bloków, które można dodać do tej strony.';
$string['nobody'] = 'Nikt';
$string['nochange'] = 'Bez zmian';
$string['nocomments'] = 'Brak komentarzy';
$string['nocourses'] = 'Brak kursów';
$string['nocoursesfound'] = 'Nie znaleziono kursów zawierających słowa \'{$a}\'';
$string['nocoursestarttime'] = 'Kurs nie ma daty rozpoczęcia.';
$string['nocoursesyet'] = 'Brak kursów w tej kategorii';
$string['nodstpresets'] = 'Administrator nie umożliwił stosowania czasu letniego (DST)';
$string['nofilesselected'] = 'Nie wybrano żadnych plików do odtworzenia';
$string['nofilesyet'] = 'Nie przesłano jeszcze żadnych plików w związku z tym kursem';
$string['nofiltersapplied'] = 'Nie zastosowano filtrów';
$string['nograde'] = 'Brak oceny';
$string['nohelpforactivityorresource'] = 'Obecnie nie ma jeszcze pomocy związanej z tym zasobem lub aktywnością';
$string['noimagesyet'] = 'Żadnych obrazów nie przesłano do twojego kursu';
$string['nologsfound'] = 'Nie znaleziono logów';
$string['nomatchingusers'] = 'Brak pasujących użytkowników  \'{$a}\'';
$string['nomorecourses'] = 'Nie znaleziono więcej pasujących kursów';
$string['nomoreidnumber'] = 'Nie użyto numeru id żeby unikać kolizji';
$string['none'] = 'Żaden';
$string['noneditingteacher'] = 'Nauczyciel bez praw edycji';
$string['noneditingteacherdescription'] = 'Nauczyciele bez praw edycji mogą uczyć w kursach i oceniać studentów, ale nie mogą wprowadzać zmian edycyjnych.';
$string['nonstandard'] = 'Niestandardowe';
$string['nopendingcourses'] = 'Brak kursów oczekujących na zatwierdzenie';
$string['nopotentialadmins'] = 'Brak potencjalnych administratorów';
$string['nopotentialcreators'] = 'Brak potencjalnych autorów kursów';
$string['nopotentialstudents'] = 'Brak potencjalnych studentów';
$string['nopotentialteachers'] = 'Brak potencjalnych nauczycieli';
$string['norecentactivity'] = 'Brak ostatnich aktywności';
$string['noreplybouncemessage'] = 'Odpowiedziałeś na mail wysłany z adresu, który nie przyjmuje odpowiedzi. Jeżeli chcesz odpowiedzieć na wiadomość z forum, musisz to zrobić na forum {$a}.

Poniżej jest treść Twojego listu:';
$string['noreplybouncesubject'] = '{$a} - mail odrzucony';
$string['noreplyname'] = 'Automatyczne powiadomienie - nie odpowiadaj na ten mail';
$string['noresetrecord'] = 'Nie ma żadnego zapisanego żądania resetowania. Proszę zainicjować nowe żądanie resetowania hasła.';
$string['noresults'] = 'Brak wyników';
$string['noresultsfor'] = 'Brak wyników dla "{$a}"';
$string['normal'] = 'Zwykły';
$string['normalfilter'] = 'Normalny filtr';
$string['nosite'] = 'Nie znaleziono kursu strony głównej.';
$string['nostudentsfound'] = 'Nie znaleziono studenta {$a}';
$string['nostudentsingroup'] = 'Studenci nie są przypisani do grup';
$string['nostudentsyet'] = 'Brak studentów zapisanych w tym kursie.';
$string['nosuchemail'] = 'Nie ma takiego adresu e-mail';
$string['notavailable'] = 'Niedostępne';
$string['notavailablecourse'] = '{$a} nie jest dostępny';
$string['noteachersyet'] = 'Brak nauczycieli w kursie';
$string['noteachingupcomingcourses'] = 'Nadchodzące kursy nie mają nauczycieli lub studentów';
$string['notenrolled'] = '{$a} nie jest zapisany/a na kurs.';
$string['notenrolledprofile'] = 'Ten profil jest niedostępny, gdyż ten użytkownik nie jest zapisany na ten kurs.';
$string['noteusercannotrolldatesoncontext'] = '<strong>Uwaga:</strong> Możliwość przesunięcia daty podczas przywracania tej kopii zapasowej została wyłączona, ponieważ nie posiadasz wymaganych uprawnień.';
$string['noteuserschangednonetocourse'] = '<strong>Uwaga:</strong> Podczas odtwarzania danych użytkowników (aktywności, plików lub wiadomości), użytkownicy kursu muszą zostać odtworzeni. To ustawienie zostało zmienione dla Ciebie.';
$string['nothingnew'] = 'Brak ostatniej aktywności';
$string['nothingtodisplay'] = 'Brak danych do wyświetlenia';
$string['notice'] = 'Powiadomienie';
$string['noticenewerbackup'] = 'Ta kopia zapasowa została stworzona przez Moodle {$a->backuprelease} ({$a->backupversion}) i jest nowsza niż obecnie zainstalowany Moodle {$a->serverrelease} ({$a->serverversion}). Odtworzenie tej kopii może być przyczyną różnych błędów, ponieważ nie ma gwarancji wstecznej kompatybilności kopii zapasowych.';
$string['notifications'] = 'Powiadomienia';
$string['notifyloginfailuresmessage'] = '{$a->time}, IP: {$a->ip}, Użytkownik: {$a->info}, Imię i Nazwisko: {$a->name}';
$string['notifyloginfailuresmessageend'] = 'Możesz wyświetlić te dzienniki na {$a}';
$string['notifyloginfailuresmessagestart'] = 'Lista nieudanych prób logowania do {$a} od ostatniego powiadomienia &nbsp;';
$string['notifyloginfailuressubject'] = '{$a} :: Powiadomienie o błędnych próbach logowania';
$string['notincluded'] = 'Nie uwzględniono';
$string['notingroup'] = 'Musisz należeć do grupy, aby przeglądać tę aktywność';
$string['notpublic'] = 'Nie publiczne!';
$string['nousersfound'] = 'Nie znaleziono użytkowników';
$string['nousersmatching'] = 'Nie znaleziono użytkowników pasujących do \'{$a}\'';
$string['nousersyet'] = 'Brak użytkowników (jak dotąd)';
$string['novalidcourses'] = 'Brak odpowiednich kursów do wyświetlenia';
$string['now'] = 'teraz';
$string['numattempts'] = '{$a} nieudanych prób logowania';
$string['numberofcourses'] = 'Liczba kursów';
$string['numberweeks'] = 'Liczba sekcji';
$string['numday'] = '{$a} dzień';
$string['numdays'] = '{$a} dni';
$string['numhours'] = '{$a} godz.';
$string['numletters'] = '{$a} listy';
$string['numminutes'] = '{$a} min.';
$string['nummonth'] = '{$a} miesiąc';
$string['nummonths'] = '{$a} miesiące';
$string['numseconds'] = '{$a} sek.';
$string['numviews'] = '{$a} wglądów';
$string['numweek'] = '{$a} tydzień';
$string['numweeks'] = '{$a} tygodnie';
$string['numwords'] = '{$a} słów';
$string['numyear'] = '{$a} rok';
$string['numyears'] = '{$a} lat';
$string['ok'] = 'OK';
$string['oldpassword'] = 'Obecne hasło';
$string['olduserdirectory'] = 'To jest stary katalog użytkowników i nie jest już potrzebny. Możesz go usunąć. Pliki które zawiera będą skopiowane do nowego katalogu.';
$string['opendrawerblocks'] = 'Otwórz szufladę bloków';
$string['opendrawerindex'] = 'Otwórz indeks kursu';
$string['opensinnewwindow'] = 'Otwiera się w nowym oknie';
$string['operator_and'] = 'i';
$string['operator_andnot'] = 'i';
$string['operator_or'] = 'lub';
$string['optional'] = 'opcjonalne';
$string['options'] = 'opcje';
$string['order'] = 'Kolejność';
$string['originalpath'] = 'Oryginalna ścieżka';
$string['orphanedactivitiesinsectionno'] = 'Osierocone aktywności (sekcja {$a})';
$string['other'] = 'Inne';
$string['outline'] = 'Skrócona wersja';
$string['outlinereport'] = 'Streszczenie raportu';
$string['page'] = 'Strona';
$string['pagea'] = 'Strona {$a}';
$string['pagedcontentnavigation'] = 'Nawigacja w paginacji';
$string['pagedcontentnavigationactiveitem'] = 'Bieżąca strona, strona {$a}';
$string['pagedcontentnavigationitem'] = 'Idź do strony {$a}';
$string['pagedcontentpagingbaritemsperpage'] = 'Pokaż {$a} elementów na stronie';
$string['pageheaderconfigablock'] = 'Konfigurowanie bloku {$a->fullname}';
$string['pagepath'] = 'Ścieżka do strony';
$string['pageshouldredirect'] = 'Ta strona powinna się automatycznie przeładować. Jeśli nic się nie zmienia proszę użyć hiperłącza "Kontynuuj" umieszczonego poniżej.';
$string['parentcategory'] = 'Kategoria nadrzędna';
$string['parentcoursenotfound'] = 'Nie znaleziono kursu!';
$string['parentfolder'] = 'Katalog nadrzędny';
$string['participants'] = 'Uczestnicy';
$string['participantslist'] = 'Lista uczestników';
$string['participationratio'] = 'Procent udziału';
$string['participationreport'] = 'Raport uczestnictwa';
$string['password'] = 'Hasło';
$string['passwordchanged'] = 'Hasło zostało zmienione';
$string['passwordextlink'] = 'Ten link służy do odzyskiwania straconego hasła. Klikając na link, wyjdziesz z Moodle.';
$string['passwordforgotten'] = 'Zapomniane hasło';
$string['passwordforgotteninstructions'] = 'Twoje dane muszą zostać najpierw znalezione w bazie danych użytkowników. Wprowadź swoją nazwę użytkownika <strong>albo</strong> zarejestrowany adres e-mail w odpowiednie pole. Nie ma konieczności wprowadzania obu.';
$string['passwordforgotteninstructions2'] = 'Aby zresetować hasło, wprowadź poniżej swoją nazwę użytkownika lub adres e-mail. Jeżeli uda nam się znaleźć Twoje dane w bazie danych, zostanie wysłana wiadomość na Twój adres e-mail z instrukcją jak uzyskać ponownie dostęp.';
$string['passwordpolicynomatch'] = 'Twoje obecne hasło nie jest już zgodne z ustawioną polityką haseł.
    {$a}';
$string['passwordsdiffer'] = 'Podane hasła różnią się';
$string['passwordset'] = 'Twoje hasło zostało zmienione.';
$string['path'] = 'Ścieżka';
$string['pathnotexists'] = 'Ścieżka nie istnieje';
$string['pathslasherror'] = 'Ścieżka nie może kończyć się slashem!';
$string['paymentinstant'] = 'Użyj poniższego przycisku, aby zapłacić i zapisać się na kurs w ciągu kilku minut!';
$string['paymentpending'] = '(<small><b><u>{$a}</u></b> w ciągu</small>)';
$string['paymentrequired'] = 'Ten kurs wymaga opłaty';
$string['payments'] = 'Opłata';
$string['paymentsorry'] = 'Dziękujemy za wpłatę. Niestety nie została ona jeszcze potwierdzona i nie możesz jeszcze wejść do  kursu {$a->fullname}. Spróbuj ponownie za kilka minut. Jeśli problem będzie się powtarzał, skontaktuj się z {$a->teacher} lub administratorem platformy.';
$string['paymentthanks'] = 'Dziękujemy za wpłatę. Zostałeś/aś zapisany/a do kursu {$a}.';
$string['pendingrequests'] = 'Wnioski o utworzenie kursu';
$string['percents'] = '{$a}%';
$string['periodending'] = 'Koniec okresu';
$string['perpage'] = 'Na stronę';
$string['perpagea'] = 'Na stronę: {$a}';
$string['personal'] = 'Osobisty';
$string['personalprofile'] = 'Profil osobisty';
$string['phone'] = 'Telefon';
$string['phone1'] = 'Telefon';
$string['phone2'] = 'Tel. komórkowy';
$string['phpinfo'] = 'Informacje o PHP';
$string['picture'] = 'Obraz';
$string['pictureof'] = 'Obraz {$a}';
$string['pictureofuser'] = 'Zdjęcie użytkownika';
$string['placeholdertypeorselect'] = 'Wpisz lub wybierz...';
$string['pleaseclose'] = 'Proszę zamknij teraz to okno';
$string['pleasesearchmore'] = 'Wyszukaj trochę więcej';
$string['pleaseusesearch'] = 'Proszę użyć wyszukiwarki';
$string['plugin'] = 'Wtyczka';
$string['pluginarea'] = 'Obszar';
$string['plugincheck'] = 'Sprawdzanie wtyczek';
$string['plugindeletefiles'] = 'Wszystkie dane związane z wtyczką \'{$a->name}\' zostały usunięte z bazy danych. Aby zapobiec ponownej instalacji wtyczki, należy teraz usunąć z serwera ten folder: {$a->directory}';
$string['pluginitemid'] = 'Identyfikator elementu';
$string['pluginmissingfromdisk'] = '{$a->name} (brakuje na dysku)';
$string['pluginsetup'] = 'Ustawianie tablic wtyczek';
$string['policyaccept'] = 'Rozumiem i zgadzam się';
$string['policyagree'] = 'Musisz zaakceptować te zasady, żeby używać strony. Czy zgadzasz się?';
$string['policyagreement'] = 'Zasady użytkowania serwisu';
$string['policyagreementclick'] = 'Link do strony dotyczącej polityki';
$string['popup'] = 'popup';
$string['popupwindow'] = 'Otwórz w nowym oknie';
$string['popupwindowname'] = 'Okienko popup';
$string['post'] = 'Wpis';
$string['posts'] = 'Wpisy';
$string['potentialadmins'] = 'Potencjalni administratorzy';
$string['potentialcreators'] = 'Potencjalni autorzy kursów';
$string['potentialstudents'] = 'Potencjalni studenci';
$string['potentialteachers'] = 'Potencjalni nauczyciele';
$string['poweredbymoodle'] = 'Wspierane przez <a href="https://moodle.com">Moodle</a>';
$string['preferences'] = 'Preferencje';
$string['preferredlanguage'] = 'Preferowany język';
$string['preferredtheme'] = 'Preferowany wygląd strony';
$string['preprocessingbackupfile'] = 'Wstępne przetwarzanie pliku kopii zapasowej';
$string['prev'] = 'Poprzedni';
$string['preview'] = 'Podgląd';
$string['previeworchoose'] = 'Przejrzyj lub wybierz temat';
$string['previewthemename'] = 'Podgląd motywu „{$a}”';
$string['previous'] = 'Wstecz';
$string['previouslyselectedusers'] = 'Wybrani wcześniej użytkownicy nie pasują \'{$a}\'';
$string['previouspage'] = 'Poprzednia strona';
$string['previoussection'] = 'Poprzednia sekcja';
$string['primaryadminsetup'] = 'Ustawienia konta administratora';
$string['privacy:metadata:config_log'] = 'Dziennik zmian konfiguracji.';
$string['privacy:metadata:config_log:name'] = 'Nazwa ustawienia ulegnie zmianie.';
$string['privacy:metadata:config_log:oldvalue'] = 'Poprzednia wartość dla tego ustawienia.';
$string['privacy:metadata:config_log:plugin'] = 'Wtyczka została zmodyfikowana.';
$string['privacy:metadata:config_log:timemodified'] = 'Czas dokonania zmiany.';
$string['privacy:metadata:config_log:userid'] = 'Użytkownik, który wprowadził zmianę.';
$string['privacy:metadata:config_log:value'] = 'Nowa wartość dla tego ustawienia.';
$string['privacy:metadata:events_queue'] = 'Kolejka zdarzeń użytkownika oczekujących na przetworzenie.';
$string['privacy:metadata:events_queue:eventdata'] = 'Dane przechowywane w przypadku.';
$string['privacy:metadata:events_queue:stackdump'] = 'Dowolny ślad stosu powiązany z tym wydarzeniem.';
$string['privacy:metadata:events_queue:timecreated'] = 'Czas utworzenia tego wydarzenia.';
$string['privacy:metadata:events_queue:userid'] = 'Identyfikator użytkownika ID powiązany z tym zdarzeniem';
$string['privacy:metadata:log'] = 'Zbiór minionych wydarzeń';
$string['privacy:metadata:log:action'] = 'Opis działania';
$string['privacy:metadata:log:cmid'] = 'cmid';
$string['privacy:metadata:log:course'] = 'kurs';
$string['privacy:metadata:log:info'] = 'Dodatkowe informacje';
$string['privacy:metadata:log:ip'] = 'Adres IP używany w czasie wydarzenia';
$string['privacy:metadata:log:module'] = 'moduł';
$string['privacy:metadata:log:time'] = 'Czas, w którym miała miejsce akcja';
$string['privacy:metadata:log:url'] = 'Adres URL powiązany z wydarzeniem';
$string['privacy:metadata:log:userid'] = 'Identyfikator użytkownika, który wykonał akcję';
$string['privacy:metadata:moodlenet_share_progress'] = 'Szczegóły postępu udostępniania w MoodleNet';
$string['privacy:metadata:moodlenet_share_progress:cmid'] = 'ID powiązanego modułu kursu';
$string['privacy:metadata:moodlenet_share_progress:courseid'] = 'ID powiązanego kursu';
$string['privacy:metadata:moodlenet_share_progress:resourceurl'] = 'Zwrócony przez MoodleNet adres URL po udanym udostępnieniu';
$string['privacy:metadata:moodlenet_share_progress:status'] = 'Wynikowy status udostępnienia';
$string['privacy:metadata:moodlenet_share_progress:timecreated'] = 'Czas wykonania udostępnienia';
$string['privacy:metadata:moodlenet_share_progress:type'] = 'Typ wykonanego uostępnienia';
$string['privacy:metadata:moodlenet_share_progress:userid'] = 'Użytkownik, który wykonał udostępnienie';
$string['privacy:metadata:oauth2_refresh_token'] = 'Token odświeżania używany w komunikacji OAuth 2.0';
$string['privacy:metadata:oauth2_refresh_token:issuerid'] = 'Identyfikator wystawcy ID, któremu odpowiada token';
$string['privacy:metadata:oauth2_refresh_token:scopehash'] = 'Identyfikator użytkownika ID, któremu odpowiada token';
$string['privacy:metadata:oauth2_refresh_token:timecreated'] = 'Czas utworzenia tokena';
$string['privacy:metadata:oauth2_refresh_token:timemodified'] = 'Czas ostatniej aktualizacji tokena';
$string['privacy:metadata:oauth2_refresh_token:token'] = 'Token odświeżania dla odpowiednich zakresów i użytkownika';
$string['privacy:metadata:oauth2_refresh_token:userid'] = 'Identyfikator użytkownika ID, któremu odpowiada token';
$string['privacy:metadata:task_adhoc'] = 'Status zadań doraźnych.';
$string['privacy:metadata:task_adhoc:component'] = 'Komponent będący właścicielem zadania.';
$string['privacy:metadata:task_adhoc:nextruntime'] = 'Najwcześniejsza godzina uruchomienia tego zadania.';
$string['privacy:metadata:task_adhoc:userid'] = 'Użytkownik, który ma uruchomić zadanie jako.';
$string['privacy:metadata:task_log'] = 'Dane wyjściowe dla dziennika';
$string['privacy:metadata:task_log:component'] = 'Komponent będący właścicielem zadania.';
$string['privacy:metadata:task_log:userid'] = 'Użytkownik, do którego należało zadanie.';
$string['privacy:metadata:upgrade_log'] = 'Dziennik aktualizacji.';
$string['privacy:metadata:upgrade_log:backtrace'] = 'Wszelkie operacje śledzenia związane z tym krokiem aktualizacji.';
$string['privacy:metadata:upgrade_log:details'] = 'Dodatkowe informacje dotyczące aktualizacji.';
$string['privacy:metadata:upgrade_log:info'] = 'Główne informacje dotyczące tego kroku aktualizacji.';
$string['privacy:metadata:upgrade_log:plugin'] = 'Wtyczka, która została zaktualizowana.';
$string['privacy:metadata:upgrade_log:targetversion'] = 'Nowa wersja do uaktualnienia.';
$string['privacy:metadata:upgrade_log:timemodified'] = 'Czas, w którym miała miejsce aktualizacja.';
$string['privacy:metadata:upgrade_log:type'] = 'Typ wpisu dziennika.';
$string['privacy:metadata:upgrade_log:userid'] = 'Użytkownik, który uruchomił aktualizację.';
$string['privacy:metadata:upgrade_log:version'] = 'Stara wersja wtyczki.';
$string['private_files_handler'] = 'Przechowuj załączniki do wiadomości e-mail w prywatnej przestrzeni przechowywania plików użytkownika.';
$string['private_files_handler_name'] = 'E-mail do prywatnych plików';
$string['privatefiles'] = 'Prywatne pliki';
$string['privatefilesmanage'] = 'Zarządzaj prywatnymi plikami';
$string['proceed'] = 'Kontynuuj';
$string['profile'] = 'Profil';
$string['profilenotshown'] = 'Opis w profilu nie będzie widoczny, dopóki osoba nie będzie zapisana na przynajmniej jeden kurs.';
$string['progress'] = 'Postęp';
$string['publicprofile'] = 'Profil publiczny';
$string['publicsitefileswarning'] = 'Uwaga: Pliki zamieszczone w tym miejscu są dostępne dla wszystkich';
$string['publicsitefileswarning2'] = 'Ostrzeżenie: Pliki umieszczone tutaj mogą być dostępne dla każdego, kto zna (lub odgadnie) URL. Ze względów bezpieczeństwa zaleca się, aby wszelakie kopie zapasowe plików zostały usuwane natychmiast po ich przywróceniu.';
$string['publicsitefileswarning3'] = 'Ostrzeżenie: Pliki umieszczone tutaj mogą być dostępne dla każdego, kto zna (lub odgadnie) URL. <br />Ze względów bezpieczeństwa, pliki kopii zapasowej powinny być zapisywane tylko w bezpiecznym folderze backupdata.';
$string['question'] = 'Pytanie';
$string['questionsinthequestionbank'] = 'Pytania w banku pytań';
$string['queued'] = 'W kolejce';
$string['quotausage'] = 'Aktualnie wykorzystano {$a->used} z limitu {$a->total}.';
$string['readinginfofrombackup'] = 'Odczyt danych z kopii zapasowej';
$string['readme'] = 'README';
$string['recentactivity'] = 'Co się ostatnio działo?';
$string['recentactivityreport'] = 'Raport ostatniej aktywności';
$string['recipientslist'] = 'Lista odbiorców';
$string['recommended'] = 'Zalecane';
$string['recreatedcategory'] = 'Tworzenie na nowo kategorii {$a}';
$string['redirect'] = 'Przekierowanie';
$string['reducesections'] = 'Zredukuj liczbę sekcji';
$string['refresh'] = 'Odśwież';
$string['refreshingevents'] = 'Odświeżanie';
$string['registration'] = 'Rejestracja Moodle';
$string['registrationcontact'] = 'Kontakt publiczny';
$string['registrationcontactno'] = 'Nie, nie chcę by inni użytkownicy mogli się ze mną skontaktować';
$string['registrationcontactyes'] = 'Tak, udostępnij formularz, dzięki któremu inni użytkownicy Moodle będą mogli się ze mną skontaktować';
$string['registrationemail'] = 'Powiadamianie e-mail';
$string['registrationinfo'] = '<p>Ta strona umożliwia rejestrację Twojego serwisu na stronie moodle.org. Rejestracja jest bezpłatna. Główną zaletą rejestracji jest to, że zostaniesz dodany do listy wysyłkowej zawierającej istotne zawiadomienia, np. alerty bezpieczeństwa czy nowe wersje Moodle.</p><p>Twoje dane będą domyślnie prywatne i nie zostaną udostępnione lub odsprzedane nikomu innemu. Jedyną przyczyną zbierania tych danych jest budowanie statystycznego obrazu populacji użytkowników Moodle.</p> <p>Jeśli chcesz, możesz zezwolić, by nazwa Twojego serwisu, kraj oraz URL zostały dodane do ogólnodostępnej listy serwisów Moodle.</p><p>Wszystkie nowe rejestracje są sprawdzane ręcznie przed dodaniem ich do listy. Możesz później uaktualnić swoją rejestrację (i wpis na liście), wysyłając ponownie ten formularz.</p>';
$string['registrationinfotitle'] = 'Informacje o rejestracji';
$string['registrationsend'] = 'Prześlij informacje rejestracyjne do moodle.org';
$string['registrationyes'] = 'Tak, informuj mnie o nowych wersjach Moodle, alertach bezpieczeństwa i innych ważnych wiadomościach';
$string['reject'] = 'Odrzuć';
$string['rejectdots'] = 'Odrzuć...';
$string['relativedatesmode'] = 'Tryb dat względnych';
$string['relativedatesmode_help'] = 'Wyświetlaj daty kursu lub czynności w stosunku do daty rozpoczęcia przez użytkownika w kursie.

Data rozpoczęcia kursu użytkownika będzie datą rozpoczęcia rejestracji, chyba że zostanie zapisany przed rozpoczęciem kursu, w tym przypadku data rozpoczęcia będzie datą rozpoczęcia kursu.

OSTRZEŻENIE: jest to funkcja eksperymentalna i nie wszystkie działania mogą ją obsługiwać. Po utworzeniu kursu nie można już zmienić tego ustawienia kursu.';
$string['relativedatesmode_warning'] = '<strong> Ostrzeżenie: </strong> trybu dat względnych nie można zmienić po utworzeniu kursu.';
$string['reload'] = 'Odśwież';
$string['remoteappuser'] = 'Zdalny użytkownik {$a}';
$string['remove'] = 'Usuń';
$string['removeadmin'] = 'Usuń administratora';
$string['removecreator'] = 'Usuń autora kursu';
$string['removed'] = 'Usunięto {$a}';
$string['removestudent'] = 'Usuń studenta';
$string['removeteacher'] = 'Usuń nauczyciela';
$string['rename'] = 'Zmień nazwę';
$string['renamefileto'] = 'Zmień <b>{$a}</b> na';
$string['report'] = 'Raport';
$string['reports'] = 'Raporty';
$string['reporttype'] = 'Rodzaj raportu';
$string['repositories'] = 'Repozytoria';
$string['requestcourse'] = 'Zamów kurs';
$string['requestedby'] = 'Autor zgłoszenia';
$string['requestedcourses'] = 'Prośby o kursy';
$string['requestreason'] = 'Powód złożenia wniosku';
$string['requests'] = 'Prośby';
$string['required'] = 'Wymagane';
$string['requirespayment'] = 'Ten kurs wymaga opłaty';
$string['resendemail'] = 'Wyślij ponownie e-mail z potwierdzeniem';
$string['reset'] = 'Reset';
$string['resetcomponent'] = 'Składnik';
$string['resetcourse'] = 'Resetuj kurs';
$string['resetcourseconfirm'] = 'Zresetować kurs?';
$string['resetcoursewarning'] = 'Czy na pewno chcesz zresetować kurs "{$a}"?
<br/><br/>
Spowoduje to usunięcie wybranych danych i przywrócenie pierwotnego stanu kursu. Nie można cofnąć tej akcji.';
$string['resetinfo'] = 'Ta funkcja umożliwia wyczyszczenie wszystkich danych użytkownika i zresetowanie kursu do jego pierwotnego stanu. Aktywności i ustawienia kursu pozostają niezmienione.';
$string['resetinfoselect'] = 'Z poniższych kategorii wybierz dane, które chcesz usunąć lub zresetować:';
$string['resetnotimplemented'] = 'Resetowanie nie jest obsługiwane';
$string['resetnotimplementedinfo'] = 'Tych aktywności nie można zresetować:';
$string['resetrecordexpired'] = 'Ważność linku resetowania hasła, którego użyłeś ma więcej niż {$a} minut i przez to wygasł. Proszę zainicjować nowe resetowanie hasła.';
$string['resetstartdate'] = 'Resetuj datę początkową';
$string['resetstatus'] = 'Status';
$string['resettable'] = 'Resetuj ustawienia tabeli';
$string['resettask'] = 'Resetuj';
$string['resettodefaults'] = 'Przywrócenie domyślnych ustawień';
$string['resortcourses'] = 'Sortuj kursy';
$string['resortsubcategoriesby'] = 'Sortuj podkategorie rosnąco {$a}';
$string['resortsubcategoriesbyreverse'] = 'Sortuj podkategorie malejąco {$a}';
$string['resource'] = 'Zasób';
$string['resource_type'] = 'Typ zasobu';
$string['resourcedisplayauto'] = 'Automatycznie';
$string['resourcedisplaydownload'] = 'Wymuś pobieranie';
$string['resourcedisplayembed'] = 'Osadzone';
$string['resourcedisplayframe'] = 'W ramce';
$string['resourcedisplaynew'] = 'Nowe okno';
$string['resourcedisplayopen'] = 'Otwórz';
$string['resourcedisplaypopup'] = 'W wyskakującym oknie';
$string['resources'] = 'Zasoby';
$string['resources_help'] = 'Zasoby umożliwiają zamieszczenie w kursie niemal dowolnych treści stron www.';
$string['restore'] = 'Odtwórz';
$string['restorecancelled'] = 'Przywracanie anulowane';
$string['restorecannotassignroles'] = 'Odtworzenie wymaga przypisania ról, a ty nie masz do tego uprawnień';
$string['restorecannotcreateorassignroles'] = 'Odtworzenie wymaga utworzenia lub przypisania ról, a ty nie masz do tego uprawnień.';
$string['restorecannotcreateuser'] = 'Procedura odtwarzania wymaga utworzenia użytkownika \'{$a}\' z pliku kopii zapasowej, a ty nie masz uprawnień aby to wykonać';
$string['restorecannotoverrideperms'] = 'Przywracanie nadpisze uprawnienia, a ty nie masz stosownych uprawnień do tego.';
$string['restorecoursenow'] = 'Odtwórz ten kurs teraz!';
$string['restoredaccount'] = 'Przywrócone konto';
$string['restoredaccountinfo'] = 'To konto zostało zaimportowane z innego serwera i hasło zostało utracone. Aby ustawić nowe hasło przez e-mail, kliknij napis "Kontynuuj"';
$string['restorefinished'] = 'Odtwarzanie kopii zapasowej zakończone sukcesem';
$string['restoreinfo'] = 'Użyj pliku kopii zapasowej, aby przywrócić poprzednią wersję kursu lub utworzyć nowy kurs.';
$string['restoremnethostidmismatch'] = 'Identyfikator hosta MNet użytkownika \'{$a}\' nie odpowiada identyfikatorowi lokalnego hosta MNet.';
$string['restoreto'] = 'Odtwórz do ...';
$string['restoretositeadding'] = 'Ostrzeżenie: Zamierzasz przywrócić główną stronę, dodając do niej dane!';
$string['restoretositedeleting'] = 'Ostrzeżenie: Zamierzasz przywrócić główną stronę, usuwając z niej dane!';
$string['restoreuserconflict'] = 'Próba przywrócenia konta użytkownika \'{$a}\' z pliku kopii zapasowej spowoduje wystąpienie konfliktu';
$string['restoreuserinfofailed'] = 'Proces przywracania został zatrzymany, ponieważ nie masz uprawnień, aby przywrócić dane użytkownika.';
$string['restoreusersprecheck'] = 'Sprawdzanie danych użytkownika';
$string['restoreusersprecheckerror'] = 'Zostały wykryte problemy podczas sprawdzania danych użytkownika';
$string['restricted'] = 'Ograniczony';
$string['resultsfound'] = 'Znalezionych wyników: {$a}';
$string['retry'] = 'Spróbuj ponownie';
$string['returningtosite'] = 'Powracasz na tę stronę WWW?';
$string['returntooriginaluser'] = 'Wróć do {$a}';
$string['revert'] = 'Przywróć';
$string['role'] = 'Rola';
$string['roleassignments'] = 'Przypisanie ról';
$string['rolemappings'] = 'Mapowanie ról';
$string['rolerenaming'] = 'Zmiana nazwy ról';
$string['rolerenaming_help'] = 'Zmień wyświetlane nazwy ról w tym kursie.';
$string['rolerenaming_success'] = 'Zaktualizowano nazwy ról w kursach.';
$string['roles'] = 'Role';
$string['rss'] = 'RSS';
$string['rssarticles'] = 'Liczba ostatnich artykułów RSS';
$string['rsserror'] = 'Błąd odczytu danych RSS';
$string['rsserrorauth'] = 'Twój link RSS nie zawiera prawidłowego tokena uwierzytelniania.';
$string['rsserrorguest'] = 'Ten kanał używa praw gościa, aby pobrać dane, ale gość nie ma uprawnień do odczytu danych. Odwiedź oryginalną lokalizację źródła jako poprawny użytkownik i uzyskaj stamtąd nowy link RSS .';
$string['rsskeyshelp'] = '<p>Aby zapewnić bezpieczeństwo i prywatność, URL kanału RSS zawiera specjalny znacznik, który identyfikuje użytkownika, dla którego jest przeznaczony. Uniemożliwia to innym użytkownikom Moodle\'a dostęp do obszarów, do których nie powinni mieć dostępu przez kanały RSS. </p><p> Token ten jest tworzony automatycznie podczas pierwszego dostępu do obszaru Moodle, gdzie produkuje się kanał RSS. Jeśli uważasz, że Twój token RSS został w jakiś sposób upubliczniony, możesz uzyskać nowy, klikając link Resetuj. Należy pamiętać, że aktualnie używane URLe RSS staną się wtedy nieważne.</p>';
$string['rsstype'] = 'Kanał RSS dla tej aktywności';
$string['save'] = 'Zapisz';
$string['saveandnext'] = 'Zachowaj i pokaż następne';
$string['savechanges'] = 'Zapisz zmiany';
$string['savechangesanddisplay'] = 'Zapisz i wyświetl';
$string['savechangesandreturn'] = 'Zapisz i wróć';
$string['savechangesandreturntocourse'] = 'Zapisz i wróć do kursu';
$string['savecomment'] = 'Zapisz komentarz';
$string['savedat'] = 'Zachowane w:';
$string['savepreferences'] = 'Zapisz ustawienia';
$string['saveto'] = 'Zapisz do';
$string['scale'] = 'Skala';
$string['scale_help'] = 'Skala zapewnia sposób oceny lub oceny wyników w aktywnościach. Jest zdefiniowana przez uporządkowaną listę wartości, od ujemnych do dodatnich, oddzielonych przecinkami, na przykład „Niedostateczny, Dopuszczający, Dostateczny, Dobry, Bardzo Dobry, Celujący!”';
$string['scale_link'] = 'grade/scale';
$string['scales'] = 'Skale';
$string['scalescustom'] = 'Skale niestandardowe';
$string['scalescustomcreate'] = 'Dodaj nową skalę';
$string['scalescustomno'] = 'Nie utworzono żadnych niestandardowych skali';
$string['scalesstandard'] = 'Skale standardowe';
$string['scalestandard'] = 'Skala standardowa';
$string['scalestandard_help'] = 'Standardowa skala jest dostępna na całej witrynie, dla wszystkich kursów.';
$string['scalestandard_link'] = 'grade/scale';
$string['scalestip'] = 'Aby stworzyć własne skale, użyj linku "Skale" w menu Administracja kursu.';
$string['scalestip2'] = 'Aby utworzyć własne skale, kliknij na link Oceny w menu Administracja kursem, a następnie wybierz opcję Edycja, Skale.';
$string['schedule'] = 'Harmonogram';
$string['screenshot'] = 'Zrzut ekranu';
$string['search'] = 'Wyszukaj';
$string['search_help'] = 'Aby wyszukać jedno lub więcej słów w tekście, po prostu wpisz je oddzielone spacjami. Liczą się wszystkie słowa dłuższe niż dwa znaki.

Naciśnij przycisk przeszukiwania bez wypełniania pola wyszukiwania, aby przejść do formularza wyszukiwania zaawansowanego.';
$string['searchactivities'] = 'Wyszukaj aktywności według nazwy lub opisu';
$string['searchagain'] = 'Wyszukaj ponownie';
$string['searchbyemail'] = 'Wyszukaj po adresach e-mail';
$string['searchbyusername'] = 'Wyszukaj po nazwie użytkownika';
$string['searchcoursecategories'] = 'Przeszukaj kategorie';
$string['searchcourses'] = 'Wyszukaj kursy';
$string['searchgroups'] = 'Wyszukaj grupy';
$string['searchitems'] = 'Wyszukaj elementy';
$string['searchoptions'] = 'Opcje wyszukiwania';
$string['searchresults'] = 'Wyniki wyszukiwania';
$string['searchusers'] = 'Wyszukaj użytkowników';
$string['sec'] = 'sek';
$string['seconds'] = 'sekund';
$string['secondsleft'] = '{$a} sek';
$string['secondstotime172800'] = '2 dni';
$string['secondstotime259200'] = '3 dni';
$string['secondstotime345600'] = '4 dni';
$string['secondstotime432000'] = '5 dni';
$string['secondstotime518400'] = '6 dni';
$string['secondstotime604800'] = '1 tydzień';
$string['secondstotime86400'] = '1 dzień';
$string['secretalreadyused'] = 'Link do potwierdzenia zmiany hasła został już użyty. Hasło nie zostało zmienione.';
$string['secs'] = 'sek.';
$string['section'] = 'Sekcja';
$string['sectionactionnotsupported'] = 'Wybrane działanie "{$a}" nie jest tu obsługiwane';
$string['sectionname'] = 'Nazwa sekcji';
$string['sectionoutline'] = 'Przegląd sekcji';
$string['sections'] = 'Sekcje';
$string['seealsostats'] = 'Patrz również: statystyki';
$string['selctauser'] = 'Wybierz użytkownika';
$string['select'] = 'Zaznacz';
$string['selectacategory'] = 'Proszę wybrać kategorię';
$string['selectacountry'] = 'Wybierz kraj';
$string['selectacourse'] = 'Wybierz kurs';
$string['selectacoursesite'] = 'Wybierz kurs lub stronę';
$string['selectagroup'] = 'Wybierz grupę';
$string['selectall'] = 'Wybierz wszystko';
$string['selectallusersonpage'] = 'Zaznacz wszystkich użytkowników na tej stronie';
$string['selectalluserswithcount'] = 'Zaznacz wszystkich {$a} użytkowników';
$string['selectamodule'] = 'Proszę wybrać moduły aktywności';
$string['selectanaction'] = 'Wybierz akcję';
$string['selectanoptions'] = 'Wybierz opcję';
$string['selectaregion'] = 'Wybierz obszar';
$string['selectcategorysort'] = 'Które kategorie chcesz posortować?';
$string['selectcategorysortby'] = 'Wybierz, jak chcesz posortować kategorie';
$string['selectcoursesortby'] = 'Wybierz, jak chcesz posortować kursy';
$string['selectdates'] = 'Wybierz daty';
$string['selectdefault'] = 'Wybierz domyślne';
$string['selectedcategories'] = 'Wybrane kategorie';
$string['selectedfile'] = 'Wybrany plik';
$string['selectednowmove'] = '{$a} plików zaznaczonych w celu przeniesienia. Przejdź teraz do miejsca docelowego i wybierz \'Przenieś pliki tutaj\'';
$string['selectfiles'] = 'Wybierz pliki';
$string['selectfiltertype'] = 'Wybierz';
$string['selectgroupsseparate'] = 'Wybierz osobne grupy';
$string['selectgroupsvisible'] = 'Wybierz widoczne grupy';
$string['selectitem'] = 'Wybierz \'{$a}\'';
$string['selectmoduletoviewhelp'] = 'Wybierz aktywność lub zasób, aby wyświetlić pomoc na jego temat.

Kliknij dwukrotnie nazwę aktywności lub zasobu, aby szybko je dodać.';
$string['selectnos'] = 'Wybierz wszystkie „nie”';
$string['selectperiod'] = 'Wybierz okres';
$string['selecttheme'] = 'Wybierz motyw';
$string['selectthemename'] = 'Wybierz motyw „{$a}”';
$string['senddetails'] = 'Wyślij mi moje dane e-mail\'em';
$string['sent'] = 'Wysłano';
$string['separate'] = 'Osobne';
$string['separateandconnected'] = 'Odrębne i powiązane sposoby poznania';
$string['separateandconnected1'] = 'Przeważnie oddzielna wiedza';
$string['separateandconnected2'] = 'Oddzielne i połączone';
$string['separateandconnected3'] = 'Przeważnie wiedza połączona';
$string['separateandconnectedinfo'] = 'Skala opiera się na teorii oddzielonego i połączonego poznania. Ta teoria opisuje dwa różne sposoby, które możemy ocenić i nauczyć się o tym co widzimy i słyszymy.<ul><li><strong>Osobni znawcy</strong> pozostają jak najbardziej obiektywni, bez włączania uczuć i emocji. W dyskusji z innymi ludźmi, lubią bronić swoich racji używając logiki do znajdywania luk w idei przeciwnika.</li><li><strong>Podłączeni znawcy</strong> są bardzo wrażliwi na innych ludzi. Mają rozwiniętą empatię i tendencję do słuchania i zadawania pytań, dopóki nie poczują, że mogą być połączeni i "rozumieją sprawy z ich punktu widzenia". Uczą się poprzez próbę wymiany doświadczeń, które doprowadziły do tej wiedzy, którą znajdują u innych ludzi.</li></ul>';
$string['servererror'] = 'Wystąpił błąd podczas komunikacji z serwerem';
$string['serverlocaltime'] = 'Lokalny czas serwera';
$string['sessionforceclean'] = 'Ze względów bezpieczeństwa skrypty generowane przez użytkowników zostały wyłączone w tej sesji.';
$string['sessiontimeoutsoon'] = 'Twoja sesja wkrótce wygaśnie. Czy wydłużyć bieżącą sesję?';
$string['setcategorytheme'] = 'Ustaw schemat graficzny dla kategorii';
$string['setmode'] = 'Ustaw tryb';
$string['setpassword'] = 'Ustaw hasło';
$string['setpasswordinstructions'] = 'Proszę poniżej wprowadzić swoje nowe hasło i zastosować zmiany.';
$string['settings'] = 'Ustawienia';
$string['share'] = 'Udostępnij';
$string['shortname'] = 'Skrócona nazwa';
$string['shortnamecollisionwarning'] = 'Ten skrót jest już używany w kursie i należy go zmienić.';
$string['shortnamecourse'] = 'Krótka nazwa kursu';
$string['shortnamecourse_help'] = 'Nazwa wyświetlana w obszarach o ograniczonej przestrzeni. Musi być ona unikalna.';
$string['shortnametaken'] = 'Nazwa skrócona jest już wykorzystana przez inny kurs ({$a})';
$string['shortnameuser'] = 'Krótka nazwa użytkownika';
$string['shortsitename'] = 'Skrócona nazwa serwisu';
$string['show'] = 'Pokaż';
$string['showactions'] = 'Pokaż aktywności';
$string['showactivitydates'] = 'Pokaż daty aktywności';
$string['showactivitydates_help'] = 'Pokaż daty aktywności na stronie kursu.';
$string['showadvancededitor'] = 'Zaawansowane';
$string['showadvancedsettings'] = 'Pokaż ustawienia zaawansowane';
$string['showall'] = 'Pokaż wszystkie {$a}';
$string['showallcourses'] = 'Pokaż wszystkie kursy';
$string['showblockcourse'] = 'Pokaż listę kursów zawierających blok';
$string['showcategory'] = 'Pokaż {$a}';
$string['showchartdata'] = 'Pokaż dane wykresu';
$string['showcomments'] = 'Pokaż/ukryj komentarze';
$string['showcommentsnonjs'] = 'Pokaż komentarze';
$string['showdescription'] = 'Wyświetl opis na stronie kursu';
$string['showdescription_help'] = 'Jeśli opcja jest włączona, opis będzie wyświetlany na stronie kursu tuż poniżej linku z aktywnością lub zasobami.';
$string['showgrades'] = 'Pokaż dziennik ocen studentom';
$string['showgrades_help'] = 'Pozwól studentom zobaczyć listę wszystkich swoich ocen w kursie.';
$string['showingacourses'] = 'Pokazywanie wszystkich {$a} kursów';
$string['showingxofycourses'] = 'Pokazywanie kursów {$a->start} do {$a->end} z {$a->total} kursów';
$string['showless'] = 'Pokaż mniej';
$string['showlistofcourses'] = 'Pokaż listę kursów';
$string['showmodulecourse'] = 'Pokaż listę kursów zawierających składową';
$string['showmore'] = 'Pokaż więcej';
$string['showoncoursepage'] = 'Pokaż na stronie kursu';
$string['showonly'] = 'Wyświetl tylko';
$string['showperpage'] = 'Pokaż {$a} na stronę';
$string['showpopoverwindow'] = 'Pokaż wyskakujące okienko';
$string['showrecent'] = 'Pokaż ostatnie wydarzenia';
$string['showreports'] = 'Pokaż raporty aktywności';
$string['showreports_help'] = 'Zezwól studentom przeglądać własne raporty z aktywności za pośrednictwem strony profilowej.';
$string['showsettings'] = 'Pokaż ustawienia';
$string['showtheselogs'] = 'Pokaż te logi';
$string['showthishelpinlanguage'] = 'Pokaż tę pomoc w języku: {$a}';
$string['sidepanel'] = 'Panel boczny';
$string['signoutofotherservices'] = 'Wyloguj się ze wszystkich aplikacji internetowych';
$string['signoutofotherservices_help'] = 'Jeżeli zaznaczysz tę opcję, nastąpi wylogowanie na wszystkich urządzeniach i systemach, które korzystają z usług sieciowych, takich jak aplikacja mobilna.';
$string['since'] = 'Od';
$string['sincelast'] = 'od ostatniego logowania';
$string['site'] = 'Strona';
$string['sitedefault'] = 'Wartość domyślna witryny';
$string['sitedefaultspecified'] = 'Domyślna witryna ({$a})';
$string['siteerrors'] = 'Błędy w serwisie';
$string['sitefiles'] = 'Pliki serwisu';
$string['sitefilesused'] = 'Pliki serwisu, które są użyte w tym kursie';
$string['sitehome'] = 'Strona główna';
$string['sitelegacyfiles'] = 'Stare pliki strony';
$string['sitelogs'] = 'Logi serwisu';
$string['sitenews'] = 'Ogłoszenia';
$string['sitepages'] = 'Strony';
$string['sitepartlist'] = 'Nie masz wymaganych uprawnień, aby oglądać listę użytkowników';
$string['sitepartlist0'] = 'Musisz być nauczycielem na poziomie serwisu, aby móc oglądać listy użytkowników serwisu';
$string['sitepartlist1'] = 'Musisz być nauczycielem, aby móc oglądać listy użytkowników serwisu';
$string['sites'] = 'Strony';
$string['sitesection'] = 'Dodaj niestandardową treść';
$string['sitesettings'] = 'Ustawienia serwisu';
$string['siteteachers'] = 'Nauczyciele w serwisie';
$string['size'] = 'Rozmiar';
$string['sizeb'] = 'bajtów';
$string['sizegb'] = 'GB';
$string['sizekb'] = 'KB';
$string['sizemb'] = 'MB';
$string['sizepb'] = 'PB';
$string['sizetb'] = 'TB';
$string['skipped'] = 'Pominięto';
$string['skiptocategorylisting'] = 'Przejdź do listy kategorii';
$string['skiptocoursedetails'] = 'Przejdź do szczegółowych informacji o kursie';
$string['skiptocourselisting'] = 'Przejdź do listy kursów';
$string['someallowguest'] = 'Niektóre kursy dostępne są dla użytkowników zalogowanych jako goście.';
$string['someerrorswerefound'] = 'Część informacji została pominięta lub jest niepoprawna. Poniżej znajdziesz szczegóły.';
$string['sort'] = 'Sortuj';
$string['sortby'] = 'Sortuj według';
$string['sortbyx'] = 'Sortuj {$a} rosnąco';
$string['sortbyxreverse'] = 'Sortuj {$a} malejąco';
$string['sorting'] = 'Sortowanie';
$string['sourcerole'] = 'Rola pierwotna';
$string['specifyname'] = 'Musisz podać imię.';
$string['standard'] = 'Standard';
$string['starpending'] = '([*] = Zatwierdzenie kursu oczekującego)';
$string['startdate'] = 'Data rozpoczęcia kursu';
$string['startdate_help'] = 'To ustawienie określa początek pierwszego tygodnia kursu w formacie tygodniowym. Określa również najwcześniejszą datę, dla której dostępne są dzienniki zajęć. Jeśli kurs zostanie zresetowany i data rozpoczęcia kursu zostanie zmieniona, wszystkie daty na kursie zostaną przesunięte w stosunku do nowej daty rozpoczęcia.';
$string['startdatewithtaskenabled'] = 'Data rozpoczęcia kursu';
$string['startdatewithtaskenabled_help'] = 'Data, kiedy kurs staje się widoczny dla studentów. Przed tą datą nie będą oni mogli uzyskać dostępu do kursu.

Data ta określa również początek pierwszego tygodnia kursu w formacie tygodniowym i jest datą rozpoczęcia dzienników aktywności kursu. Jeśli zresetujesz kurs i zmienisz tę datę, wszystkie daty w kursie zostaną przesunięte w stosunku do nowej daty rozpoczęcia.';
$string['startingfrom'] = 'Rozpoczynający się od';
$string['startsignup'] = 'Utwórz nowe konto!';
$string['state'] = 'Stan/prowincja';
$string['statistics'] = 'Statystyki';
$string['statisticsgraph'] = 'Graf statystyk';
$string['stats'] = 'Statystyki';
$string['statslogins'] = 'Logowania';
$string['statsmodedetailed'] = 'Widok szczegółowy (użytkownika)';
$string['statsmodegeneral'] = 'Widok ogólny';
$string['statsnodata'] = 'Brak dostępnych danych dla tego kursu i przedziału czasowego.';
$string['statsnodatauser'] = 'Brak możliwości stworzenia takiej kombinacji kursu, użytkownika i przedziału czasowego.';
$string['statsoff'] = 'Statystyki nie są obecnie aktywne';
$string['statsreads'] = 'Wyświetlenia';
$string['statsreport1'] = 'Logowania';
$string['statsreport10'] = 'Aktywność użytkownika';
$string['statsreport11'] = 'Najbardziej aktywne kursy';
$string['statsreport12'] = 'Najbardziej aktywne kursy (ważone)';
$string['statsreport13'] = 'Najbardziej uczęszczane kursy (zapisy)';
$string['statsreport14'] = 'Najbardziej uczęszczane kursy (wyświetlenia/wpisy)';
$string['statsreport2'] = 'Wyświetlenia (wszystkie role)';
$string['statsreport3'] = 'Wpisy (wszystkie role)';
$string['statsreport4'] = 'Wszystkie aktywności (wszystkie role)';
$string['statsreport5'] = 'Wszystkie aktywności (wyświetlenia i wpisy)';
$string['statsreport7'] = 'Aktywności użytkownika (wyświetlenia i wpisy)';
$string['statsreport8'] = 'Aktywność wszystkich użytkowników';
$string['statsreport9'] = 'Logowania (strona główna)';
$string['statsreportactivity'] = 'Wszystkie aktywności (wszystkie role)';
$string['statsreportactivitybyrole'] = 'Wszystkie aktywności (wyświetlenia i wpisy)';
$string['statsreportforuser'] = 'dla';
$string['statsreportlogins'] = 'Logowania';
$string['statsreportreads'] = 'Wyświetlenia (wszystkie role)';
$string['statsreporttype'] = 'Typ raportu';
$string['statsreportwrites'] = 'Wpisy (wszystkie role)';
$string['statsstudentactivity'] = 'Aktywności studenta';
$string['statsstudentreads'] = 'Wyświetlenia studenta';
$string['statsstudentwrites'] = 'Wpisy studenta';
$string['statsteacheractivity'] = 'Aktywności nauczyciela';
$string['statsteacherreads'] = 'Wyświetlenia nauczyciela';
$string['statsteacherwrites'] = 'Wpisy nauczyciela';
$string['statstimeperiod'] = 'Okres czasu - ostatnie:';
$string['statsuniquelogins'] = 'Unikalne logowania';
$string['statsuseractivity'] = 'Wszystkie aktywności';
$string['statsuserlogins'] = 'Logowania';
$string['statsuserreads'] = 'Wyświetlenia';
$string['statsuserwrites'] = 'Wpisy';
$string['statswrites'] = 'Wpisy';
$string['status'] = 'Status';
$string['statuschecks'] = 'Sprawdzanie statusu';
$string['statuscritical'] = 'Krytyczny';
$string['statusdone'] = 'Gotowe';
$string['statuserror'] = 'Błąd';
$string['statusinfo'] = 'Informacja';
$string['statusna'] = 'nd.';
$string['statusok'] = 'OK';
$string['statusunknown'] = 'Nieznany';
$string['statuswarning'] = 'Ostrzeżenie';
$string['stringsnotset'] = 'Następujące łańcuchy znaków nie są zdefiniowane w {$a}';
$string['studentnotallowed'] = 'Nie możesz wejść do kursu jako \'{$a}\'';
$string['students'] = 'Studenci';
$string['studentsandteachers'] = 'Studenci i nauczyciele';
$string['subcategories'] = 'Podkategorie';
$string['subcategory'] = 'Podkategoria';
$string['subcategoryof'] = 'Podkategoria {$a}';
$string['subject'] = 'Temat';
$string['submit'] = 'Prześlij';
$string['subsectionmoveerror'] = 'Nie można przenieść tej podsekcji na inną podsekcję';
$string['success'] = 'Gotowe';
$string['successduration'] = 'Sukces ({$a} sekund)';
$string['summary'] = 'Streszczenie';
$string['suspended'] = 'Zawieszony';
$string['suspendedusers'] = 'Zawieszeni użytkownicy';
$string['switchdevicedefault'] = 'Przełącz na standardowy schemat graficzny';
$string['switchdevicerecommended'] = 'Przełącz na zalecany dla twojego urządzenia schemat graficzny';
$string['switchrolereturn'] = 'Powróć do mojej standardowej roli';
$string['switchroleto'] = 'Zmień rolę na...';
$string['switchroleto_help'] = 'Wybierz rolę, aby sprawdzić, jak ktoś z tą rolą widzi kurs.

Pamiętaj, że ten podgląd może nie być doskonały  (<a href="https://docs.moodle.org/en/Switch_roles">Zobacz szczegóły i alternatywy</a>).';
$string['tag'] = 'Tag';
$string['tagalready'] = 'Ten tag już istnieje';
$string['tagmanagement'] = 'Dodaj/usuń tag ...';
$string['tags'] = 'Tagi';
$string['targetrole'] = 'Rola docelowa';
$string['teacheronly'] = 'wyłącznie dla {$a}';
$string['teacherroles'] = '{$a} tytułu';
$string['teachers'] = 'Nauczyciele';
$string['textcopiedtoclipboard'] = 'Tekst skopiowano do schowka';
$string['textediting'] = 'Edytor tekstu';
$string['textediting_help'] = 'Jeśli wybrano edytor HTML, taki jak Atto lub TinyMCE, obszary wprowadzania tekstu będą miały pasek narzędzi z przyciskami umożliwiającymi łatwe dodawanie zawartości.

Jeśli wybrano "zwykły obszar tekstowy", można wybrać format obszarów wprowadzania tekstu, takich jak HTML lub Markdown.

Lista dostępnych edytorów tekstowych jest określana przez administratora witryny.';
$string['texteditor'] = 'Użyj standardowych formularzy WWW';
$string['textellipsis'] = '{$a}...';
$string['textformat'] = 'Zwykły tekst';
$string['thanks'] = 'Dziękuję';
$string['theme'] = 'Motyw';
$string['themepreviewdescription'] = 'Opis motywu {$a}';
$string['themepreviewimage'] = '{$a} obraz podglądu';
$string['themes'] = 'Motywy';
$string['themesaved'] = 'Nowy temat został zapisany';
$string['therearecourses'] = 'Istnieje {$a} kursów';
$string['thereareno'] = 'Nie ma {$a} w tym kursie';
$string['thiscategory'] = 'W tej kategorii';
$string['thiscategorycontains'] = 'Ta kategoria zawiera';
$string['time'] = 'Czas';
$string['timecreated'] = 'Czas utworzenia';
$string['timecreatedcourse'] = 'Czas utworzenia kursu';
$string['timesplitting:deciles'] = 'Ostatnia dziesiątka';
$string['timesplitting:deciles_help'] = 'Ta metoda podziału czasu dzieli kurs na dziesiątki (10 równych części), przy czym każda prognoza opiera się na danych tylko ostatniej dziesiątki.';
$string['timesplitting:decilesaccum'] = 'Wszystkie poprzednie dziesiątki';
$string['timesplitting:decilesaccum_help'] = 'Ta metoda podziału czasu dzieli kurs na dziesiątki (10 równych części), przy czym każda prognoza jest oparta na danych wszystkich poprzednich dziesiątek.';
$string['timesplitting:nosplitting'] = 'Brak ograniczeń czasowych';
$string['timesplitting:nosplitting_help'] = 'Dla tego modelu nie zdefiniowano żadnej metody podziału czasu.';
$string['timesplitting:onemonthafterstart'] = 'Miesiąc po rozpoczęciu';
$string['timesplitting:onemonthafterstart_help'] = 'Ten interwał analizy generuje prognozę 1 miesiąc po rozpoczęciu analizy.';
$string['timesplitting:oneweekafterstart'] = 'Tydzień po rozpoczęciu';
$string['timesplitting:oneweekafterstart_help'] = 'Ten interwał analizy generuje prognozę 1 tydzień po rozpoczęciu analizy.';
$string['timesplitting:past3days'] = 'Ostatnie 3 dni';
$string['timesplitting:past3days_help'] = 'Ten interwał analizy generuje prognozy co 3 dni. Obliczenia wskaźników będą oparte na ostatnich 3 dniach.';
$string['timesplitting:pastmonth'] = 'Ostatni miesiąc';
$string['timesplitting:pastmonth_help'] = 'Ten interwał analizy generuje prognozy co miesiąc. Obliczenia wskaźników będą oparte na minionym miesiącu.';
$string['timesplitting:pastweek'] = 'Ostatni tydzień';
$string['timesplitting:pastweek_help'] = 'Ten interwał analizy generuje prognozy co tydzień. Obliczenia wskaźników będą oparte na minionym tygodniu.';
$string['timesplitting:quarters'] = 'Ostanie ćwiartki';
$string['timesplitting:quarters_help'] = 'Ta metoda podziału czasu dzieli kurs na ćwiartki (4 równe części), przy czym każda prognoza opiera się na danych tylko ostatniej ćwiartki.';
$string['timesplitting:quartersaccum'] = 'Wszystkie poprzednie ćwiartki';
$string['timesplitting:quartersaccum_help'] = 'Ta metoda podziału czasu dzieli kurs na ćwiartki (4 równe części), przy czym każda prognoza jest oparta na danych wszystkich poprzednich ćwiartek.';
$string['timesplitting:singlerange'] = 'Od początku do końca';
$string['timesplitting:singlerange_help'] = 'Ta metoda dzielenia czasu traktuje cały kurs jako pojedynczy zakres.';
$string['timesplitting:tenpercentafterstart'] = '10% po uruchomieniu';
$string['timesplitting:tenpercentafterstart_help'] = 'Ten przedział analizy generuje prognozę po ukończeniu 10% kursu.';
$string['timesplitting:upcoming3days'] = 'Nadchodzące 3 dni';
$string['timesplitting:upcoming3days_help'] = 'Ten przedział analizy generuje prognozy co 3 dni. Obliczenia wskaźników będą oparte na najbliższych 3 dniach.';
$string['timesplitting:upcomingfortnight'] = 'Nadchodzące dwa tygodnie';
$string['timesplitting:upcomingfortnight_help'] = 'Ten interwał analizy generuje prognozy co dwa tygodnie. Obliczenia wskaźników będą oparte na nadchodzących dwóch tygodniach.';
$string['timesplitting:upcomingweek'] = 'Nadchodzący tydzień';
$string['timesplitting:upcomingweek_help'] = 'Ten interwał analizy generuje prognozy co tydzień. Obliczenia wskaźników będą oparte na nadchodzącym tygodniu.';
$string['timezone'] = 'Strefa czasowa';
$string['tocontent'] = 'Do pozycji "{$a}"';
$string['tocreatenewaccount'] = 'Pomiń tworzenie nowego konta';
$string['todate'] = 'Do';
$string['today'] = 'Dzisiaj';
$string['todaylogs'] = 'Dzisiejsze logi';
$string['toeveryone'] = 'Wszyscy';
$string['toggleemojipicker'] = 'Włącz przybornik emoji';
$string['togglesearch'] = 'Przełącznik wyszukiwarki';
$string['toomanybounces'] = 'Ten adres e-mail został odrzucony zbyt wiele razy.<b> Musisz </B> to zmienić żeby kontynuować.';
$string['toomanytags'] = 'To wyszukiwanie zawiera zbyt wiele tagów; niektóre zostaną zignorowane.';
$string['toomanytoshow'] = 'Zbyt wielu użytkowników do pokazania';
$string['toomanyusersmatchsearch'] = 'Zbyt wielu ({$a->count}) użytkowników pasuje \'{$a->search}\'';
$string['toomanyuserstoshow'] = 'Zbyt wielu ({$a}) użytkowników do wyświetlenia';
$string['toonly'] = 'tylko dla {$a}';
$string['top'] = 'Góra';
$string['topic'] = 'Temat';
$string['toplevelcategory'] = 'Kategoria poziomu nadrzędnego';
$string['torecipient'] = 'Do';
$string['total'] = 'Razem';
$string['totopofsection'] = 'Na górę sekcji "{$a}"';
$string['trackforums'] = 'Obserwuj forum';
$string['trackforumsno'] = 'Nie: Nie obserwuj forum';
$string['trackforumsyes'] = 'Tak: Podświetl nowe wpisy dla mnie';
$string['trysearching'] = 'Poszukaj jeszcze raz.';
$string['turneditingoff'] = 'Wyłącz tryb edycji';
$string['turneditingon'] = 'Włącz tryb edycji';
$string['unabletocopytoclipboard'] = 'Nie można skopiować tekstu do schowka';
$string['unauthorisedlogin'] = 'Konto użytkownika "{$a}" nie jest dostępne na tej stronie';
$string['undecided'] = 'Nie zdecydowano';
$string['unexistingcmid'] = 'Nie znaleziono identyfikatora modułu kursu';
$string['unexistingsectionid'] = 'Nie znaleziono identyfikatora sekcji kursu';
$string['unfinished'] = 'Nie ukończono';
$string['unknowncategory'] = 'Nieznana kategoria';
$string['unknownerror'] = 'Nieznany błąd';
$string['unknownuser'] = 'Nieznany użytkownik';
$string['unlimited'] = 'Nieograniczone';
$string['unpacking'] = 'Rozpakowywanie {$a}';
$string['unsafepassword'] = 'Hasło nie jest bezpieczne - wybierz inne';
$string['untilcomplete'] = 'Aż będzie kompletne';
$string['unusedaccounts'] = 'Konta nie używane przez ponad {$a} dni są automatycznie wypisywane z kursu';
$string['unzip'] = 'Rozpakuj';
$string['unzippingbackup'] = 'Rozpakowywanie kopii zapasowej';
$string['up'] = 'Do góry';
$string['update'] = 'Dokonaj zmian';
$string['updated'] = 'Zmieniono {$a}';
$string['updatemymoodleoff'] = 'Zakończ edycję tej strony';
$string['updatemymoodleon'] = 'Dostosuj tę stronę';
$string['updatemyprofile'] = 'Zmień profil';
$string['updatesevery'] = 'Zapisywanie zmian co {$a} sekund';
$string['updatethis'] = 'Zmień {$a}';
$string['updatethiscourse'] = 'Dokonaj zmian w tym kursie';
$string['upload'] = 'Prześlij';
$string['uploadafile'] = 'Prześlij plik';
$string['uploadcantwrite'] = 'Nie udało się zapisać plik na dysku';
$string['uploadedfile'] = 'Przesyłanie pliku zakończone';
$string['uploadedfileto'] = 'Przesłano {$a->file} do {$a->directory}';
$string['uploadedfiletoobig'] = 'Plik jest za duży (maksymalny rozmiar jest {$a} bajtów)';
$string['uploadextension'] = 'Przesyłanie plików zostało zatrzymane przez rozszerzenie PHP';
$string['uploadfailednotrecovering'] = 'Plik nie został przesłany, ponieważ wystąpił problem z plikiem {$a->name}. <br/> Tutaj jest zapis w logu odnośnie tego problemu:<br/>{$a->problem}';
$string['uploadfilelog'] = 'Prześlij log dla pliku {$a}';
$string['uploadformlimit'] = 'Przesłany plik {$a} przewyższa maksymalny limit rozmiaru określony przez formularz';
$string['uploadlabel'] = 'Tytuł:';
$string['uploadlimitwithsize'] = '{$a->contextname} - limit przesyłania: ({$a->displaysize})';
$string['uploadnewfile'] = 'Prześlij nowy plik';
$string['uploadnofilefound'] = 'Nie znaleziono żadnego pliku. Czy na pewno zaznaczyłeś plik do przesłania?';
$string['uploadnotallowed'] = 'Przesyłanie plików jest zakazane';
$string['uploadnotempdir'] = 'Na serwerze brak katalogu tymczasowego do przesyłania plików';
$string['uploadoldfilesdeleted'] = 'Stare pliki zostały usunięte';
$string['uploadpartialfile'] = 'Przesłano tylko część pliku';
$string['uploadproblem'] = 'Pojawił się nieznany błąd podczas przesyłania pliku \'{$a}\' (być może plik był za duży)';
$string['uploadrenamedchars'] = 'Zmieniono nazwę pliku z {$a->oldname} na {$a->newname} ponieważ użyto niedozwolonych znaków';
$string['uploadrenamedcollision'] = 'Zmieniono nazwę pliku z {$a->oldname} na {$a->newname}, ponieważ był konflikt nazw.';
$string['uploadserverlimit'] = 'Plik ma większy rozmiar niż dopuszczalny maksymalny rozmiar';
$string['uploadthisfile'] = 'Prześlij ten plik';
$string['url'] = 'URL';
$string['used'] = 'Użyte';
$string['usedinnplaces'] = 'Użyte w {$a} miejscach';
$string['user'] = 'Użytkownik';
$string['useraccount'] = 'Konto użytkownika';
$string['useractivity'] = 'Aktywność';
$string['userconfirmed'] = '{$a} został potwierdzony';
$string['userdata'] = 'Dane użytkownika';
$string['userdeleted'] = 'To konto użytkownika zostało usunięte';
$string['userdescription'] = 'Opis';
$string['userdescription_help'] = 'To pole umożliwia wprowadzanie tekstu o sobie, który następnie zostanie umieszczony na stronie Twojego profilu, aby inni mogli go zobaczyć.';
$string['userdetails'] = 'Szczegóły użytkownika';
$string['userfiles'] = 'Pliki użytkownika';
$string['userlist'] = 'Lista użytkowników';
$string['usermatchedon'] = 'Ten użytkownik pasuje do wyszukiwania za pomocą następującego pola';
$string['usermenu'] = 'Menu użytkownika';
$string['usermenugoback'] = 'Wróć do menu użytkownika';
$string['username'] = 'Nazwa użytkownika';
$string['usernameemail'] = 'Nazwa użytkownika lub e-mail';
$string['usernameemailmatch'] = 'Nazwa użytkownika i adres e-mail nie odnoszą się do tego samego użytkownika.';
$string['usernameexists'] = 'Ta nazwa użytkownika już istnieje. Wybierz inną.';
$string['usernamelowercase'] = 'Dopuszczalne tylko małe litery';
$string['usernamenotfound'] = 'Nazwa użytkownika nie została odnaleziona w bazie danych';
$string['usernameoremail'] = 'Wpisz nazwę użytkownika LUB adres e-mail';
$string['usernotconfirmed'] = '{$a} nie został potwierdzony';
$string['userpic'] = 'Zdjęcie użytkownika';
$string['userpreferences'] = 'Preferencje użytkownika';
$string['users'] = 'Użytkownicy';
$string['userselectorautoselectunique'] = 'Jeżeli tylko jeden użytkownik odpowiada kryteriom wyszukiwania, wybierz go automatycznie';
$string['userselectorpreserveselected'] = 'Zachowaj wybranych użytkowników, nawet jeśli nie pasują już do kryteriów wyszukiwania';
$string['userselectorsearchanywhere'] = 'gdziekolwiek';
$string['userselectorsearchexactmatchonly'] = 'tylko dokładne dopasowania';
$string['userselectorsearchfromstart'] = 'od początku';
$string['userselectorsearchmatching'] = 'Dopasowanie:';
$string['usersnew'] = 'Nowi użytkownicy';
$string['usersnoaccesssince'] = 'Nieaktywni dłużej niż';
$string['userswithfiles'] = 'Użytkownicy z plikami';
$string['useruploadtype'] = 'Użytkownik załadował typ: ($a}';
$string['userzones'] = 'Strefy użytkowników';
$string['usetheme'] = 'Użyj tego motywu';
$string['usingexistingcourse'] = 'Korzystanie z istniejącego kursu';
$string['validatehtml'] = 'Zweryfikuj kod HTML';
$string['valuealreadyused'] = 'Ta wartość jest już w użyciu.';
$string['version'] = 'Wersja';
$string['view'] = 'Wyświetl';
$string['viewallcourses'] = 'Zobacz wszystkie kursy';
$string['viewallcoursescategories'] = 'Zobacz wszystkie kursy i kategorie';
$string['viewallresults'] = 'Wyświetl wszystkie wyniki ({$a})';
$string['viewallsubcategories'] = 'Zobacz wszystkie podkategorie';
$string['viewfileinpopup'] = 'Zobacz plik w wyskakującym oknie';
$string['viewing'] = 'Wyświetlanie:';
$string['viewmore'] = 'Zobacz więcej';
$string['viewprofile'] = 'Zobacz profil';
$string['views'] = 'Wejścia';
$string['viewsolution'] = 'zobacz rozwiązanie';
$string['visible'] = 'Widoczny';
$string['visible_help'] = 'Ta opcja określa, czy kurs będzie widoczny na liście kursów. Poza nauczycielami i administratorami, użytkownicy nie są uprawnieni do wejścia na kurs';
$string['visibletostudents'] = 'Widoczny dla {$a}';
$string['warning'] = 'Ostrzeżenie';
$string['warningdeleteresource'] = 'Uwaga: {$a} jest wskazywany w zasobie. Czy chcesz uaktualnić ten zasób?';
$string['wcagcheck'] = 'Sprawdzenie wytycznych dotyczących ułatwień dostępu dla treści internetowych (WCAG)';
$string['webpage'] = 'Strona WWW';
$string['week'] = 'Tydzień';
$string['weeks'] = 'tygodnie';
$string['welcomeback'] = 'Cześć {$a->firstname}! 👋';
$string['welcometocourse'] = 'Witamy w {$a}';
$string['welcometocoursetext'] = 'Witamy w {$a->coursename}!

Jeśli jeszcze tego nie zrobiłeś/aś, edytuj stronę swojego profilu, abyśmy mogli dowiedzieć się więcej o Tobie:
<a href="{$a->profileurl}">{$a->profileurl}</a>';
$string['welcometosite'] = 'Witaj, {$a->firstname}! 👋';
$string['whatforlink'] = 'Co chcesz zrobić z linkiem?';
$string['whatforpage'] = 'Co chcesz zrobić z tekstem?';
$string['whatisyourage'] = 'Ile masz lat?';
$string['whattocallzip'] = 'Jak chcesz nazwać ten plik zip?';
$string['whattodo'] = 'Co zrobić';
$string['wheredoyoulive'] = 'W jakim kraju mieszkasz?';
$string['whyisthisrequired'] = 'Dlaczego jest to wymagane?';
$string['windowclosing'] = 'To okno powinno zamknąć się automatycznie. Jeśli się nie zamknęło, zamknij je teraz.';
$string['withchosenfiles'] = 'Z wybranymi plikami';
$string['withdisablednote'] = '{$a} (wyłączone)';
$string['withoutuserdata'] = 'bez danych o użytkowniku';
$string['withselectedusers'] = 'Z zaznaczonymi użytkownikami';
$string['withuserdata'] = 'z danymi o użytkownikach';
$string['wontrunfuturescheduledtask'] = 'Nie uruchomię zadania, które nie zakończyło się niepowodzeniem i jest zaplanowane do uruchomienia w przyszłości.';
$string['wordforstudent'] = 'Twój odpowiednik słowa Student';
$string['wordforstudenteg'] = 'np. Student, Uczestnik itd.';
$string['wordforstudents'] = 'Twój odpowiednik słowa Studenci';
$string['wordforstudentseg'] = 'np. Studenci, Uczestnicy itd.';
$string['wordforteacher'] = 'Twój odpowiednik słowa Nauczyciel';
$string['wordforteachereg'] = 'np. Prowadzący, Nauczyciel, Trener itp.';
$string['wordforteachers'] = 'Twój odpowiednik słowa Nauczyciele (l. mnoga)';
$string['wordforteacherseg'] = 'np. Prowadzący, Nauczyciele, Trenerzy itp.';
$string['writingblogsinfo'] = 'Zapis informacji o blogach';
$string['writingcategoriesandquestions'] = 'Zapis kategorii i pytań';
$string['writingcoursedata'] = 'Zapis danych kursu';
$string['writingeventsinfo'] = 'Zapis informacji o zdarzeniach';
$string['writinggeneralinfo'] = 'Zapis informacji ogólnych';
$string['writinggradebookinfo'] = 'Zapis informacji w menu \'Oceny\'';
$string['writinggroupingsgroupsinfo'] = 'Zapis informacji o grupach nadrzędnych';
$string['writinggroupingsinfo'] = 'Zapis informacji o grupach nadrzędnych';
$string['writinggroupsinfo'] = 'Zapis informacji o grupach';
$string['writingheader'] = 'Zapis nagłówka';
$string['writingloginfo'] = 'Zapis informacji logów';
$string['writingmessagesinfo'] = 'Zapis informacji o wiadomościach';
$string['writingmoduleinfo'] = 'Zapis informacji o modułach';
$string['writingscalesinfo'] = 'Zapis informacji o skalach';
$string['writinguserinfo'] = 'Zapis informacji o użytkownikach';
$string['wrongpassword'] = 'Błędne hasło dla tej nazwy użytkownika';
$string['year'] = 'rok';
$string['years'] = 'lata';
$string['yes'] = 'Tak';
$string['youareabouttocreatezip'] = 'Masz zamiar utworzyć archiwum zip zawierające:';
$string['youaregoingtorestorefrom'] = 'Za chwilę rozpoczniesz odtwarzanie kursu';
$string['youhaveupcomingactivitiesdue'] = 'Zbliża się termin ukończenia aktywności';
$string['youhaveupcomingactivitiesdueinfo'] = '{$a},
<br/>zbliża się termin ukończenia aktywności:';
$string['youneedtoenrol'] = 'Aby to zrobić, musisz być zapisany na kursie';
$string['yourlastlogin'] = 'Ostatnie logowanie';
$string['yourself'] = 'samodzielnie';
$string['yourteacher'] = 'twój {$a}';
$string['yourwordforx'] = 'Twój odpowiednik słowa: \'{$a}\'';
$string['zippingbackup'] = 'Archiwizacja kopii zapasowej';
