<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_amos', language 'pl', version '5.0'.
 *
 * @package     local_amos
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['amos'] = 'AMOS - narzędzie do tłumaczeń Moodle';
$string['amos:changecontriblang'] = 'Zmień język przesłanych ciągów';
$string['amos:commit'] = 'Zatwierdź przygotowane ciągi w głównym repozytorium';
$string['amos:importfile'] = 'Importuj ciągi znaków z przesłanego pliku';
$string['amos:manage'] = 'Zarządzaj portalem AMOS';
$string['amos:stage'] = 'Użyj narzędzia do tłumaczenia AMOS i przygotuj ciągi znaków';
$string['amos:stash'] = 'Zapisz bieżący etap w trwałym schowku';
$string['amos:usegoogle'] = 'Użyj usługi Google Tłumacz';
$string['branchesall'] = 'Wszystkie znane wersje Moodle';
$string['branchsupported'] = 'Najstarsza obsługiwana wersja Moodle';
$string['cachedef_lists'] = 'Listy języków i znanych komponentów w AMOS';
$string['cachedef_stats'] = 'Dane statystyczne wygenerowane przez AMOS';
$string['committable'] = 'Masz uprawnienia do korzystania z tego pakietu językowego';
$string['committableall'] = 'wszystkie języki';
$string['componentsall'] = 'Wszystkie';
$string['componentsapp'] = 'Aplikacja Moodle';
$string['componentsnone'] = 'Żaden';
$string['componentsstandard'] = 'Standardowe';
$string['confirmaction'] = 'Tego nie można będzie cofnąć. Czy jesteś pewien(a)?';
$string['contribaccept'] = 'Akceptuj';
$string['contribactions_link'] = 'AMOS#Contributing_to_a_language_pack';
$string['contribapply'] = 'Zastosuj';
$string['contribassignee'] = 'Zatwierdzający';
$string['contribassigneenone'] = '-';
$string['contribassigntome'] = 'Przypisz do mnie';
$string['contribauthor'] = 'Autor';
$string['contribclosedno'] = 'Ukryj zatwierdzone tłumaczenia';
$string['contribclosedyes'] = 'Pokaż zatwierdzone tłumaczenia';
$string['contribcomponents'] = 'Składniki';
$string['contribincomingnone'] = 'Brak nowych tłumaczeń';
$string['contribincomingsome'] = 'Nowe tłumaczenia: ({$a})';
$string['contriblanguage'] = 'Język';
$string['contriblanguagebutton'] = 'Konwertuj';
$string['contriblanguagechange'] = 'Naprawianie błędnego języka tłumaczeń';
$string['contriblanguagechange_help'] = 'Jeśli przez pomyłkę tłumaczenia zostały przesłane do niewłaściwego pakietu językowego, wybierz właściwy język z menu rozwijanego poniżej, a następnie kliknij przycisk Konwertuj.';
$string['contriblanguagereport'] = 'Zgłaszanie nieprawidłowego języka tłumaczeń';
$string['contriblanguagewrong'] = 'Zły język?';
$string['contribnotif'] = '[AMOS] Powiadomienie o tłumaczeniu (#{$a->id})';
$string['contribnotifaccepted'] = '{$a->fullname} zaakceptował Twoje tłumaczenie
#{$a->id} {$a->subject}

----------------------------------------------------------------------
Strona z tlumaczeniem: {$a->contriburl}';
$string['contribnotifcommented'] = '{$a->fullname} skomentował/a przesłane tłumaczenie
#{$a->id} {$a->subject}
----------------------------------------------------------------------

{$a->message}

----------------------------------------------------------------------
Strona z treścią: {$a->contriburl}';
$string['contribnotifrejected'] = '{$a->fullname} odrzucił Twoje tłumaczenie
#{$a->id} {$a->subject}

----------------------------------------------------------------------
Strona z tłumaczeniem: {$a->contriburl}';
$string['contribnotifsubmitted'] = '{$a->fullname} przesłał nowe tłumaczenie
#{$a->id} {$a->subject}
----------------------------------------------------------------------

{$a->message}

* Język: {$a->language}
* Komponenty: {$a->components}
* Ciągi: {$a->strings}

----------------------------------------------------------------------
Strona tłumaczenia: {$a->contriburl}';
$string['contribreject'] = 'Odrzuć';
$string['contribresign'] = 'Anuluj przypisanie';
$string['contribstagedinfo_link'] = 'AMOS#Contributing_to_a_language_pack';
$string['contribstartreview'] = 'Rozpocznij przegląd';
$string['contribstatus'] = 'Status';
$string['contribstatus0'] = 'Nowe';
$string['contribstatus10'] = 'W przeglądzie';
$string['contribstatus20'] = 'Odrzucono';
$string['contribstatus30'] = 'Zaakceptowano';
$string['contribstatus_link'] = 'AMOS#Contributing_to_a_language_pack';
$string['contribstrings'] = 'Łańcuchy';
$string['contribstringseq'] = '{$a->orig} nowe';
$string['contribstringsnone'] = '{$a->orig} (wszystkie z nich są już przetłumaczone w paczce językowej)';
$string['contribstringssome'] = '{$a->orig} ({$a->same} z nich ma już nowsze tłumaczenie)';
$string['contribsubject'] = 'Temat';
$string['contribsubmittednone'] = 'Brak przesłanych tłumaczeń';
$string['contribsubmittedsome'] = 'Twoje tłumaczenia ({$a})';
$string['contribtimemodified'] = 'Zmodyfikowano';
$string['contribute'] = 'Tłumacz';
$string['contributenow'] = 'Tłumacz teraz!';
$string['contributestats'] = 'Dotychczas, przez członków społeczności, zostało przetłumaczonych i przesłanych do AMOS <strong>{$a->count}</strong> ciągów tekstowych.';
$string['contributethanks'] = 'Wielkie podziękowania dla {$a->listcontributors} za ich ostatnie tłumaczenia!';
$string['contributethankslist'] = '{$a->contributor1}, {$a->contributor2}, {$a->contributor3} i {$a->contributor4}';
$string['contributions'] = 'Tłumaczenia';
$string['creditsaddcontributor'] = 'Dodaj współpracownika';
$string['creditsaddmaintainer'] = 'Dodaj opiekuna';
$string['creditscontact'] = 'Wyślij wiadomość';
$string['creditscontributors'] = 'Inni współpracownicy';
$string['creditsdelcontributor'] = 'Usuń współpracownika';
$string['creditsdelmaintainer'] = 'Usuń opiekuna';
$string['creditsmaintainedby'] = 'Utrzymywane przez';
$string['creditsnomaintainer'] = 'W tej chwili nie ma opiekuna. <a href="{$a->url}">Zostań nim!</a>';
$string['creditstitlelong'] = 'Opiekunowie i współautorzy pakietów językowych';
$string['diff'] = 'Porównaj';
$string['err_exception'] = 'Błąd: {$a}';
$string['err_invalidlangcode'] = 'Niepoprawny kod języka';
$string['err_parser'] = 'Błąd składni: {$a}';
$string['filtercmp'] = 'Składniki';
$string['filtercmp_desc'] = 'Pokaż ciągi znaków tych elementów';
$string['filtercmpnothingselected'] = 'Proszę wybrać element';
$string['filterlng'] = 'Języki';
$string['filterlng_desc'] = 'Wyświetl tłumaczenia w tym języku';
$string['filterlngnothingselected'] = 'Proszę wybrać język';
$string['filtermis'] = 'Różne';
$string['filtermis_desc'] = 'Dodatkowe warunki do wyświetlenia';
$string['filtermisfapp'] = 'tylko ciągi używane w aplikacji Moodle';
$string['filtermisfapp_help'] = 'Ten ciąg jest używany w aplikacji Moodle jako {$a}';
$string['filtermisfhas'] = 'tylko przetłumaczone ciągi znaków';
$string['filtermisfhlp'] = 'tylko łańcuchy tekstowe plików pomocy';
$string['filtermisfmis'] = 'tylko brakujące i nieaktualne ciągi znaków';
$string['filtermisfout'] = 'tylko nieaktualne ciągi znaków';
$string['filtermisfworkplace'] = 'tylko ciągi używane w Moodle Workplace';
$string['filtermisfworkplace_help'] = 'Ten ciąg znaków jest używany w Moodle Workplace jako {$a}';
$string['filtersid'] = 'Identyfikator łańcucha';
$string['filtersid_desc'] = 'Klucz w tablicy łańcuchów';
$string['filtersidpartial'] = 'częściowe dopasowanie';
$string['filtertxt'] = 'Podciąg';
$string['filtertxt_desc'] = 'Łańcuch musi zawierać podany tekst';
$string['filtertxtcasesensitive'] = 'uwzględnij wielkość liter';
$string['filtertxtregex'] = 'wyrażenie regularne';
$string['filtertxttra'] = 'w przetłumaczonych ciągach znaków';
$string['filterver'] = 'Wersja';
$string['filterver_desc'] = 'Pokaż ciągi tekstowe dla tej wersji Moodle';
$string['filtervernothingselected'] = 'Proszę wybrać wersję';
$string['foundmissing'] = 'brakujących: {$a}';
$string['foundmissingonthispage'] = 'na tej stronie: {$a}';
$string['foundtotal'] = 'znaleziono: {$a}';
$string['googletranslate'] = 'zapytaj google';
$string['importfile'] = 'Importuj przetłumaczone łańcuchy znaków z pliku';
$string['importfile_link'] = 'local/amos/importfile';
$string['language'] = 'Język';
$string['languages'] = 'Języki';
$string['languagesall'] = 'Wszystkie';
$string['languagesnone'] = 'Żaden';
$string['lastavailable'] = 'Najnowsza dostępna wersja';
$string['lessfilteringoptions'] = 'Mniej opcji';
$string['log'] = 'Logi';
$string['logfilterbranch'] = 'Wersje';
$string['logfiltercommits'] = 'Filtr zatwierdzenia';
$string['logfiltercommittedafter'] = 'Zatwierdzone po';
$string['logfiltercommittedbefore'] = 'Zatwierdzone przed';
$string['logfiltercomponent'] = 'Składniki';
$string['logfilterlang'] = 'Języki';
$string['logfiltersource'] = 'Źródło';
$string['logfiltersourceamos'] = 'amos (internetowy system tłumaczeń)';
$string['logfilterstringid'] = 'Identyfikator łańcucha';
$string['logfilterstrings'] = 'Filtr łańcucha';
$string['logfilterusergrp'] = 'Zatwierdzający';
$string['logfilterusergrpor'] = 'lub';
$string['maintainers'] = 'Opiekunowie';
$string['manageamos'] = 'Zarządzaj AMOS';
$string['markuptodate'] = 'Oznaczenie tłumaczenia jako aktualne';
$string['markuptodatelabel'] = 'Oznacz jako aktualne';
$string['messageprovider:checker'] = 'Wyniki sprawdzania pakietów językowych';
$string['morefilteringoptions'] = 'Więcej opcji';
$string['newlanguage'] = 'Nowy język';
$string['nodiffs'] = 'Nie znaleziono różnic';
$string['nofiletoimport'] = 'Proszę dostarczyć plik do formularza importu.';
$string['nologsfound'] = 'Nie znaleziono łańcuchów, proszę zmodyfikować filtry';
$string['nostringsfound'] = 'Nie znaleziono łańcuchów';
$string['nostringtoimport'] = 'Nie znaleziono pasujących łańcuchów w pliku. Proszę się upewnić, że plik ma poprawną nazwę i że jest popranie sformatowany.';
$string['novalidzip'] = 'Nie można rozpakować pliku ZIP.';
$string['outdatednotcommitted'] = 'Nieaktualne łańcuchy znaków';
$string['outdatednotcommitted_help'] = 'AMOS wykrył, że łańcuch znaków może być nieaktualny, ponieważ angielska wersja została zmodyfikowana po tym, jak dokonano tłumaczenia. Zapoznaj się nowszym tłumaczeniem.';
$string['outdatednotcommittedwarning'] = 'Nieaktualne';
$string['ownstashactions'] = 'Działania schowka';
$string['ownstashes'] = 'Twój schowek';
$string['ownstashes_help'] = 'To jest lista elementów schowka.';
$string['ownstashesnone'] = 'Nie znaleziono własnych schowków';
$string['permalink'] = 'Stały link';
$string['placeholder'] = 'Symbole zastępcze';
$string['placeholder_help'] = 'Symbole zastępcze to specjalne instrukcje, takie jak `{$a}` lub `{$a->something}` w ciągu. Są one zastępowane wartością, gdy ciąg jest faktycznie drukowany.

Ważne jest, aby skopiować je dokładnie tak, jak są w oryginalnym ciągu. Nie tłumacz ich ani nie zmieniaj ich orientacji od lewej do prawej.';
$string['placeholderwarning'] = 'symbole zastępcze';
$string['pluginclasscore'] = 'Podstawowe podsystemy';
$string['pluginclassnonstandard'] = 'Moduły niestandardowe';
$string['pluginclassstandard'] = 'Moduły standardowe';
$string['pluginname'] = 'AMOS';
$string['presetcommitmessage'] = 'Nadesłane tłumaczenie #{$a->id} przez {$a->author}';
$string['presetcommitmessage2'] = 'Połączono brakujące łańcuchy z {$a->source} do działu {$a->target}';
$string['privacy:contribnumber'] = 'Tłumaczenie {$a}';
$string['privacy:metadata:db:amoscontributions:lang'] = 'Kod języka, do którego należy to tłumaczenie.';
$string['privacy:metadata:db:amosfilterusage:numofcomponents'] = 'Liczba wybranych składników';
$string['privacy:metadata:db:amosfilterusage:numoflanguages'] = 'Liczba wybranych języków';
$string['privacy:metadata:db:amosfilterusage:numofversions'] = 'Number of selected versions';
$string['privacy:metadata:db:amosfilterusage:showexistingonly'] = 'Czy mają być wyświetlane tylko istniejące tłumaczenia?';
$string['privacy:metadata:db:amosfilterusage:showhelpsonly'] = 'Czy powinny być wyświetlane tylko ciągi pomocy?';
$string['privacy:metadata:db:amosfilterusage:showmissingonly'] = 'Czy powinny być wyświetlane tylko brakujące i nieaktualne ciągi?';
$string['privacy:metadata:db:amosfilterusage:showoutdatedonly'] = 'Czy powinny być wyświetlane tylko nieaktualne ciągi?';
$string['privacy:metadata:db:amospreferences:name'] = 'Nazwa preferencji';
$string['privacy:metadata:db:amospreferences:value'] = 'Wartość preferencji';
$string['privacy:metadata:db:amosstashes:id'] = 'Wewnętrzny identyfikator schowka';
$string['privacy:metadata:db:amosstashes:name'] = 'Nazwa lub tytuł schowka';
$string['privacy:metadata:db:amosstashes:strings'] = 'Tytuł schowka';
$string['privacy:metadata:db:amosstashes:timecreated'] = 'Znak czasu utworzenia schowka';
$string['privacy:metadata:db:amosstashes:timemodified'] = 'Znak czasu ostatniej modyfikacji rekordu';
$string['privacy:stashnumber'] = 'Schowek {$a}';
$string['privileges'] = 'Twoje uprawnienia';
$string['privilegesnone'] = 'Do informacji publicznej masz dostęp typu: tylko do odczytu.';
$string['processing'] = 'Przetwarzanie ...';
$string['quicklinks'] = 'Szybkie linki';
$string['quicklinks_amos'] = 'Tłumacz AMOS';
$string['quicklinks_forum'] = 'Forum tłumaczeń';
$string['quicklinks_manual'] = 'Instrukcja obsługi';
$string['quicklinks_newcomers'] = 'Pomoc dla nowych użytkowników';
$string['requestactions'] = 'Działanie';
$string['savefilter'] = 'Pokaż ciągi';
$string['sourceversion'] = 'Wersja źródłowa';
$string['stagedownload'] = 'Pobierz';
$string['stagesubmit'] = 'Wyślij ciągi do opiekunów pakietów językowych';
$string['stagetranslation'] = 'Tłumaczenie';
$string['stageunstageall'] = 'Wycofaj wszystko';
$string['standardcomponents'] = 'Lista standardowych składników';
$string['stashactions'] = 'Zapisz bieżącą pracę';
$string['stashapply'] = 'Zastosuj';
$string['stashautosave'] = 'Automatycznie zapisane elementy schowka';
$string['stashcomponents'] = '<span>Składniki:</span> {$a}';
$string['stashdownload'] = 'Pobierz';
$string['stashdrop'] = 'Porzuć';
$string['stashdropconfirm'] = 'Czy na pewno chcesz trwale usunąć zapisany schowek <em>\'{$a}\'</em>?';
$string['stashes'] = 'Schowek';
$string['stashlanguages'] = '<span>Języki:</span> {$a}';
$string['stashpop'] = 'Przenieś';
$string['stashpush'] = 'Przenieś wszystkie przygotowane ciągi znaków do nowego schowka';
$string['stashstrings'] = '<span>Liczba łańcuchów:</span> {$a}';
$string['stashsubmit'] = 'Wyślij do opiekuna';
$string['stashsubmitmessage'] = 'Wiadomość';
$string['stashsubmitsubject'] = 'Temat';
$string['stashtitle'] = 'Tytuł schowka';
$string['stashtitledefault'] = 'Bieżąca praca - {$a->time}';
$string['stringhistory'] = 'historia';
$string['strings'] = 'Ciągi znaków';
$string['stringversionnotlatest'] = 'istnieje nowsza wersja';
$string['submitting'] = 'Wysyłanie tłumaczenia';
$string['timeline'] = 'Oś czasu ciągu tekstowego';
$string['timelineheading'] = 'Oś czasu ciągu tekstowego: {$a->component} | {$a->strname}';
$string['translatortool'] = 'Tłumacz';
$string['translatortoolopen'] = 'Otwórz tłumacza AMOS';
$string['translatortranslation'] = 'Tłumaczenie';
$string['typecontrib'] = 'Dodatkowe moduły';
$string['typecontribbadge'] = 'Dodatkowy';
$string['typecore'] = 'Podstawowe podsystemy';
$string['typestandard'] = 'Standardowe moduły';
$string['typestandardbadge'] = 'Standardowy';
$string['unableenfixcountries'] = 'Nazwy krajów są kopiowane z ISO 3166-1';
$string['unablelangconfig'] = 'Brak uprawnień do edycji konfiguracji pakietu językowego';
$string['unableunmaintained'] = 'Pakiet językowy \'{$a}\' nie ma obecnie opiekuna, więc nie można przyjmować tłumaczeń. Prosimy o rozważenie wolontariatu jako opiekuna pakietu językowego \'{$a}\'.';
$string['unstage'] = 'wycofaj';
$string['unstageconfirm'] = 'Potwierdź wycofanie?';
$string['unstageconfirmlong'] = '<p>Zamierzasz wycofać tłumaczenie ciągu <code>{$a->stringid}</code>, komponentu <code>{$a->component}</code>, pakietu językowego <code>{$a->language}</code>.</p><p>Czy na pewno?</p>';
$string['unstaging'] = 'Wycofywanie';
$string['untranslatetitle'] = 'Usuwanie tłumaczenia z pakietu językowego';
$string['userdefaultreset'] = 'Przywróć ustawienia domyślne';
$string['userdefaultsave'] = 'Zapisz jako moje ustawienia domyślne';
$string['version'] = 'Wersja';
