<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'h5p', language 'pl', version '5.0'.
 *
 * @package     h5p
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['a11yTitle:label'] = 'Etykieta technologii wspomagających';
$string['acceptTerms'] = 'Akceptuję <a href=":url" target="_blank">Warunki korzystania</a>';
$string['accountDetailsLinkText'] = 'tu';
$string['actions'] = 'Akcje';
$string['add'] = 'Dodaj';
$string['addedandupdatedpp'] = 'Dodano {$a->%new} nowe biblioteki H5P i zaktualizowano stare {$a->%old}.';
$string['addedandupdatedps'] = 'Dodano {$a->%new} nowe biblioteki H5P i zaktualizowano starą {$a->%old}.';
$string['addedandupdatedsp'] = 'Dodano {$a->%new} nowe biblioteki H5P i zaktualizowano stare {$a->%old}.';
$string['addedandupdatedss'] = 'Dodano {$a->%new} nowe biblioteki H5P i zaktualizowano starą {$a->%old}.';
$string['addednewlibraries'] = 'Dodano {$a->%new} nowe biblioteki H5P.';
$string['addednewlibrary'] = 'Dodano {$a->%new} nowe biblioteki H5P.';
$string['additionallicenseinfo'] = 'Wszelkie dodatkowe informacje o licencji';
$string['address'] = 'Adres';
$string['age'] = 'Typowy wiek';
$string['ageDescription'] = 'Grupa docelowa tej zawartości. Możliwe formaty wejściowe oddzielone przecinkami: „1,34-45,-50,59-”.';
$string['altText'] = 'Tekst alternatywny';
$string['atto_h5p'] = 'Przycisk Wstaw H5P';
$string['atto_h5p_description'] = 'Przycisk Wstaw H5P w edytorze Atto umożliwia użytkownikom wstawianie zasobu H5P przez wprowadzenie adresu URL lub kodu osadzania albo przez załadowanie pliku H5P.';
$string['author'] = 'Autor';
$string['authorcomments'] = 'Komentarze autora';
$string['authorcommentsdescription'] = 'Komentarze dla redaktora treści. (Ten tekst nie zostanie opublikowany jako część informacji o prawach autorskich.)';
$string['authorname'] = 'Nazwa autora';
$string['authorrole'] = 'Rola autora';
$string['back'] = 'Powrót';
$string['by'] = 'przez';
$string['cancelCrop'] = 'Anuluj przycinanie';
$string['cancelPublishConfirmationDialogCancelButtonText'] = 'Nie';
$string['cancelPublishConfirmationDialogConfirmButtonText'] = 'Tak';
$string['cancelPublishConfirmationDialogDescription'] = 'Czy na pewno chcesz anulować proces udostępniania?';
$string['cancelPublishConfirmationDialogTitle'] = 'Anuluj udostępnianie';
$string['cancellabel'] = 'Anuluj';
$string['ccattribution'] = 'Uznanie autorstwa (CC BY)';
$string['ccattributionnc'] = 'Uznanie autorstwa – Użycie niekomercyjne (CC BY-NC)';
$string['ccattributionncnd'] = 'Uznanie autorstwa – Użycie niekomercyjne – Bez utworów zależnych (CC BY-NC-ND)';
$string['ccattributionncsa'] = 'Uznanie autorstwa – Użycie niekomercyjne – Na tych samych warunkach (CC BY-NC-SA)';
$string['ccattributionnd'] = 'Uznanie autorstwa – Bez utworów zależnych (CC BY-ND)';
$string['ccattributionsa'] = 'Uznanie autorstwa – Na tych samych warunkach (CC BY-SA)';
$string['ccpdd'] = 'Public Domain Dedication (CC0)';
$string['changeHasBeenSubmitted'] = 'Zgłoszono zmianę dla';
$string['changedby'] = 'Zmienione przez';
$string['changedescription'] = 'Opis zmian';
$string['changelog'] = 'Dziennik zmian';
$string['changeplaceholder'] = 'Zdjęcie przycięte, tekst zmieniony, itp.';
$string['city'] = 'Miasto';
$string['close'] = 'Zamknij';
$string['confirmCrop'] = 'Potwierdź przycięcie';
$string['confirmdialogbody'] = 'Potwierdź, że chcesz kontynuować. Nie można cofnąć tego działania.';
$string['confirmdialogheader'] = 'Potwierdź działanie';
$string['confirmlabel'] = 'Potwierdź';
$string['connectionLost'] = 'Utracono połączenie. Wyniki zostaną zapisane i wysłane po ponownym nawiązaniu połączenia.';
$string['connectionReestablished'] = 'Połączenie zostało przywrócone.';
$string['contactPerson'] = 'Osoba kontaktowa';
$string['contactPersonDescription'] = 'H5P skontaktuje się z osobą kontaktową w przypadku jakichkolwiek problemów z treściami udostępnionymi przez wydawcę. Imię i nazwisko osoby kontaktowej ani inne informacje nie będą publikowane ani udostępniane stronom trzecim';
$string['contentAvailable'] = 'Twoje treści będą zwykle dostępne w Hubie w ciągu jednego dnia roboczego.';
$string['contentCopied'] = 'Treść jest kopiowana do schowka';
$string['contentLicenseTitle'] = 'Informacje o licencji  zawartości';
$string['contentUpdateSoon'] = 'Twoje treści zostaną wkrótce zaktualizowane';
$string['contentchanged'] = 'Ta zawartość uległa zmianie od ostatniego użycia.';
$string['contentinuse'] = 'Ta treść może być wykorzystywana w innych miejscach.';
$string['contenttype'] = 'Typ zasobu';
$string['copyright'] = 'Prawa użytkowania';
$string['copyrightWarning'] = 'Materiałów chronionych prawem autorskim nie można udostępniać w H5P Content Hub. Jeśli treść jest objęta licencją przyjazną OER, taką jak Creative Commons, wybierz odpowiednią licencję. W przeciwnym razie ta zawartość nie może zostać udostępniona.';
$string['copyrightinfo'] = 'Informacje o prawach autorskich';
$string['copyrightstring'] = 'Prawa autorskie';
$string['copyrighttitle'] = 'Wyświetl informacje o prawach autorskich dla tego zasobu';
$string['couldNotParseJSONFromZip'] = 'Nie można przeanalizować JSON z pakietu: {$a->%fileName}';
$string['couldNotReadFileFromZip'] = 'Nie można odczytać pliku z pakietu: {$a->%fileName}';
$string['country'] = 'Kraj';
$string['creativecommons'] = 'Creative Commons';
$string['cropImage'] = 'Przytnij obraz';
$string['currentStep'] = 'Krok :step z :total';
$string['date'] = 'Data';
$string['deletelibraryconfirm'] = '<p>Czy na pewno chcesz usunąć wersję <em>\'{$a->version}\'</em> z biblioteki <em>\'{$a->name}\'</em>? Spowoduje to usunięcie biblioteki i wszystkich jej wystąpień.</p><p>Tej operacji nie można cofnąć.</p>';
$string['deletelibraryversion'] = 'Usuń wersję';
$string['deleting'] = 'Usuwanie biblioteki';
$string['description'] = 'Opis';
$string['disablefullscreen'] = 'Wyłącz pełny ekran';
$string['discipline:dropdownButton'] = 'Przycisk rozwijany';
$string['discipline:in'] = 'w';
$string['discipline:searchPlaceholder'] = 'Wpisz, aby wyszukać dyscypliny';
$string['disciplineDescription'] = 'Możesz wybrać wiele dyscyplin';
$string['disciplineLabel'] = 'Dyscypliny';
$string['disciplineLimitReachedMessage'] = 'Możesz wybrać maksymalnie :numDisciplines dyscyplin';
$string['disciplines'] = 'Dyscypliny';
$string['download'] = 'Pobierz';
$string['downloadtitle'] = 'Pobierz ten zasób jako plik H5P.';
$string['editInfoTitle'] = 'Edytuj informacje dla <strong>:title</strong>';
$string['editcontent'] = 'Edytuj zawartość H5P';
$string['editingFailed'] = 'Edycja nie powiodła się.';
$string['editor'] = 'Edytor';
$string['emailAddress'] = 'Adres e-mail';
$string['emailAddressDescription'] = 'Adres e-mail będzie używany przez H5P do kontaktowania się z wydawcą w przypadku jakichkolwiek problemów z treścią lub w przypadku konieczności odzyskania konta przez wydawcę. Nie będą one publikowane ani udostępniane osobom trzecim';
$string['embed'] = 'Osadź';
$string['embedtitle'] = 'Wyświetl kod do umieszczenia tego zasobu.';
$string['error:emptycontentid'] = 'Podany adres URL jest nieprawidłowy lub nie możesz edytować tego pliku.';
$string['eventh5pdeleted'] = 'Usunięto H5P';
$string['eventh5pviewed'] = 'Wyświetlone treści H5P';
$string['feature'] = 'Funkcja';
$string['fetchtypesfailure'] = 'Nie można było uzyskać żadnych informacji na temat dostępnych typów zasobów H5P. Błąd połączenia z repozytorium H5P';
$string['fileExceedsMaxSize'] = 'Jeden z plików w pakiecie przekracza maksymalny dozwolony rozmiar pliku. ({$a->%file} {$a->%used} > {$a->%max})';
$string['filter_displayh5p'] = 'Filtr Wyświetl H5P';
$string['filter_displayh5p_description'] = 'Filtr Wyświetl H5P konwertuje adresy URL na osadzone treści H5P.';
$string['fullscreen'] = 'Pełny ekran';
$string['gpl'] = 'General Public License v3';
$string['h5p'] = 'H5P';
$string['h5pcustomcss'] = 'Własny CSS';
$string['h5pcustomcss_help'] = 'CSS do zastosowania w modułach H5P.';
$string['h5peditor'] = 'Edytor H5P';
$string['h5pfilenotfound'] = 'Nie znaleziono pliku H5P';
$string['h5pinvalidurl'] = 'Nieprawidłowy adres URL zasobu H5P.';
$string['h5plibraryhandler'] = 'Obsługa struktury H5P';
$string['h5plibraryhandler_help'] = 'Struktura H5P używana do wyświetlania zawartości H5P. Zalecana jest najnowsza wersja.';
$string['h5pmanage'] = 'Zarządzanie typami zasobów H5P';
$string['h5poverview'] = 'Przegląd H5P';
$string['h5ppackage'] = 'Typ zasobu H5P';
$string['h5ppackage_help'] = 'Typ zasobu H5P to plik z rozszerzeniem H5P lub ZIP zawierający wszystkie biblioteki wymagane do wyświetlenia treści.';
$string['h5pprivatefile'] = 'Nie można wyświetlić tego zasobu H5P, ponieważ nie masz dostępu do pliku .h5p.';
$string['h5psettings'] = 'Ustawienia H5P';
$string['h5ptitle'] = 'Odwiedź h5p.org, aby zobaczyć więcej zasobów.';
$string['height'] = 'wysokość';
$string['helpChoosingLicense'] = 'Pomóż mi wybrać licencję';
$string['hideadvanced'] = 'Ukryj zaawansowane';
$string['icon'] = 'Ikona';
$string['iconDescription'] = '640 x 480 pikseli. Jeśli nie wybrano treści, zostanie użyta ikona kategorii';
$string['installedcontentlibraries'] = 'Zainstalowane biblioteki H5P';
$string['installedcontenttypes'] = 'Zainstalowane typy zasobów H5P';
$string['installedh5p'] = 'Zainstalowano H5P';
$string['invalidAge'] = 'Nieprawidłowy format wejściowy dla typowego wieku. Możliwe formaty wejściowe oddzielone przecinkami: „1, 34-45, -50, -59-”.';
$string['invalidcontextid'] = 'Nie znaleziono pliku H5P (nieprawidłowy identyfikator kontekstu)';
$string['invalidfile'] = 'Plik "{$a->%filename}" jest niedozwolony. Tylko pliki z następującymi rozszerzeniami są dozwolone: {$a->%files-allowed}.';
$string['invalidlanguagefile'] = 'Nieprawidłowy plik językowy {$a->%file} w bibliotece {$a->%library}';
$string['invalidlanguagefile2'] = 'Nieprawidłowy plik językowy {$a->%languageFile} został dołączony do biblioteki  {$a->%name}';
$string['invalidlibrarydata'] = 'Podano nieprawidłowe dane dla {$a->%property} in {$a->%library}';
$string['invalidlibrarydataboolean'] = 'Podano nieprawidłowe dane dla  {$a->%property} w {$a->%library}. Oczekiwano wartości logicznej.';
$string['invalidlibraryname'] = 'Nieprawidłowa nazwa biblioteki: {$a->%name}';
$string['invalidlibrarynamed'] = 'Biblioteka H5P {$a->%library} użyta w zasobie jest nieprawidłowa';
$string['invalidlibraryoption'] = 'Opcja {$a->%option} niedozwolona w {$a->%library}';
$string['invalidlibraryproperty'] = 'Nie można odczytać właściwości {$a->%property} z {$a->%library}';
$string['invalidmainjson'] = 'Brak prawidłowego głównego pliku h5p.json';
$string['invalidmultiselectoption'] = 'Nieprawidłowa wybrana opcja w wielokrotnym wyborze.';
$string['invalidpackage'] = 'Nieprawidłowy typ zasobu H5P';
$string['invalidselectoption'] = 'Zaznaczono nieprawidłową opcję.';
$string['invalidsemanticsjson'] = 'Biblioteka {$a->%name} zawiera nieprawidłowy plik semantics.json';
$string['invalidsemanticstype'] = 'Błąd wewnętrzny H5P: nieznany typ treści {$a->@type} w semantyce. Usuwanie treści!';
$string['invalidstring'] = 'Podany ciąg nie jest poprawny zgodnie z wyrażeniem regularnym w semantyce. (wartość: „{$a->%value}”, wyrażenie regularne: „{$a->%regexp}”)';
$string['isNowSubmitted'] = 'Zostało przesłane do H5P Hub';
$string['keywordExists'] = 'Słowa kluczowe już istnieją!';
$string['keywords'] = 'Słowa kluczowe';
$string['keywordsDescription'] = 'Możesz dodać wiele słów kluczowych oddzielonych przecinkami. Naciśnij „Enter” lub „Dodaj”, aby potwierdzić słowa kluczowe';
$string['keywordsExits'] = 'Słowa kluczowe już istnieją!';
$string['keywordsPlaceholder'] = 'Dodaj słowa kluczowe';
$string['language'] = 'Język';
$string['level'] = 'Poziom';
$string['librariesmanagerdescription'] = '<p>H5P umożliwia użytkownikom tworzenie interaktywnych treści przy użyciu różnych typów treści.</p><p>Aby mieć pewność, że w Twojej witrynie są używane tylko zaufane typy treści H5P, musisz <i>albo</i></p><ul><li>Pobrać typy treści H5P z h5p.org<i>lub</i></li> <li>Włączyć zaplanowane zadanie „Pobierz dostępne typy treści H5P z h5p.org”</li></ul><p>Pamiętaj, że użytkownicy będą mogli korzystać tylko z typów treści H5P, które są zainstalowane w Twojej witrynie.</p>';
$string['librarydirectoryerror'] = 'Nazwa katalogu biblioteki musi być zgodna z machineName lub machineName-majorVersion.minorVersion (z pliku library.json). (Katalog: {$a->%directoryName} , machineName: {$a->%machineName}, majorVersion: {$a->%majorVersion}, minorVersion: {$a->%minorVersion})';
$string['license'] = 'Licencje';
$string['licenseCC010'] = 'Licencja CC0 1.0 Universal (CC0 1.0) Public Domain Dedication';
$string['licenseCC010U'] = 'Licencja CC0 1.0 Universal';
$string['licenseCC10'] = 'Licencja CC 1.0 Generic';
$string['licenseCC20'] = 'Licencja CC 2.0 Generic';
$string['licenseCC25'] = 'Licencja CC 2.5 Generic';
$string['licenseCC30'] = 'Licencja CC 3.0 Unported';
$string['licenseCC40'] = 'Licencja CC 4.0 International';
$string['licenseDescription'] = 'Wybierz licencję dla Twojej zawartości';
$string['licenseDetails'] = 'Szczegóły licencji';
$string['licenseDialogDescription'] = 'Kliknij konkretną licencję, aby uzyskać informacje na temat prawidłowego użytkowania';
$string['licenseGPL'] = 'Licencja GPL';
$string['licenseV1'] = 'Wersja 1';
$string['licenseV2'] = 'Wersja 2';
$string['licenseV3'] = 'Wersja 3';
$string['licenseVersionDescription'] = 'Wybierz wersję licencji';
$string['licensee'] = 'Właściciel';
$string['licenseextras'] = 'Dodatki licencyjne';
$string['licenseversion'] = 'Wersja licencji';
$string['lockh5pdeploy'] = 'Nie można uzyskać dostępu do treści H5P, ponieważ jest ona wdrażana. Spróbuj ponownie później.';
$string['logoUploadText'] = 'Logo lub awatar organizacji';
$string['longDescription'] = 'Długi opis';
$string['longDescriptionPlaceholder'] = 'Długi opis treści';
$string['mainTitle'] = 'Udostępnianie <strong>:title</strong>';
$string['mainlibrarydisabled'] = 'Nie można wyświetlić tego pliku, ponieważ jego typ zawartości jest wyłączony. Skontaktuj się z administratorem, w celu włączenia wymaganego typu zawartości.';
$string['maxLength'] = ':length to maksymalna liczba znaków';
$string['missingcontentfolder'] = 'Brakuje poprawnego folderu dla treści';
$string['missingcoreversion'] = 'System nie mógł zainstalować komponentu {$a->%component} z pakietu, ponieważ wymaga nowszej wersji wtyczki H5P. Ta witryna obecnie działa z wersją {$a->%current}, podczas gdy wymagana wersja to {$a->%required} lub wyższa. Uaktualnij wtyczkę H5P, a następnie spróbuj ponownie.';
$string['missingdependency'] = 'Brak zależności {$a->@dep} wymaganej przez {$a->@lib}.';
$string['missinglibrary'] = 'Brak wymaganej biblioteki {$a->@library}';
$string['missinglibraryfile'] = 'Brak pliku {$a->%file} w bibliotece {$a->%name}';
$string['missinglibraryjson'] = 'Nie można odnaleźć pliku library.json z prawidłowym formatem json dla biblioteki {$a->%name}';
$string['missinglibraryproperty'] = 'Brak wymaganej właściwości {$a->%property} w bibliotece {$a->%library}';
$string['missingmainlibrary'] = 'Brakuje głównej biblioteki {$a->@library}';
$string['missingmbstring'] = 'Rozszerzenie mbstring PHP nie zostało załadowane. Jest ono wymagane do prawidłowego działania H5P.';
$string['missinguploadpermissions'] = 'Pamiętaj, że biblioteki mogą istnieć w przesłanym pliku, ale nie możesz przesyłać nowych bibliotek. Skontaktuj się z administratorem.';
$string['next'] = 'Dalej';
$string['nocopyright'] = 'Brak dostępnych informacji o prawach autorskich dla tego zasobu.';
$string['noextension'] = 'Przesłany plik nie jest prawidłowym pakietem HTML5. (Nie ma rozszerzenia pliku .h5p).';
$string['noh5plibhandlerdefined'] = 'Nie jest zainstalowany żaden program do obsługi struktury H5P, więc nie można wyświetlić zawartości H5P.';
$string['nojson'] = 'Główny plik h5p.json jest nieprawidłowy';
$string['nopermissiontodeploy'] = 'Nie można wyświetlić tego pliku, ponieważ został przesłany przez użytkownika bez wymaganych możliwości wdrożenia zasobu H5P.';
$string['nopermissiontoedit'] = 'Nie masz uprawnień do edycji treści H5P.';
$string['notrustablefile'] = 'Nie można wyświetlić tego pliku, ponieważ został przekazany przez użytkownika bez możliwości aktualizowania typów zasobu H5P. Skontaktuj się z administratorem, aby poprosić o zainstalowanie typu zasobów.';
$string['nounzip'] = 'Przesłany plik nie jest prawidłowym pakietem HTML5. (Nie można go rozpakować).';
$string['offlineDialogBody'] = 'Nie udało nam się wysłać informacji o zakończeniu tego zadania. Sprawdź swoje połączenie internetowe.';
$string['offlineDialogHeader'] = 'Twoje połączenie z serwerem zostało utracone';
$string['offlineDialogRetryButtonLabel'] = 'Ponów teraz';
$string['offlineDialogRetryMessage'] = 'Ponowne podejście za :num....';
$string['offlineSuccessfulSubmit'] = 'Pomyślnie przesłane wyniki.';
$string['optionalInfo'] = 'Informacje opcjonalne';
$string['originator'] = 'Pomysłodawca';
$string['pd'] = 'Domena publiczna';
$string['pddl'] = 'Dedykacja w domenie publicznej i licencja';
$string['pdm'] = 'Znak domeny publicznej (PDM)';
$string['phone'] = 'Telefon';
$string['pleaseWait'] = 'Proszę czekać...';
$string['pluginname'] = 'Pakiet H5P';
$string['privacy:metadata'] = 'Podsystem H5P nie przechowuje żadnych danych osobowych.';
$string['publisherDescription'] = 'Opis wydawcy';
$string['publisherDescriptionText'] = 'Będzie to widoczne w sekcji „Informacje o wydawcy” w udostępnianych treściach';
$string['publisherFieldDescription'] = 'Będzie ona wyświetlana jako „Nazwa wydawcy” w udostępnianych treściach';
$string['publisherFieldTitle'] = 'Wydawca';
$string['registerOnHub'] = 'Zarejestruj się w H5P Hub';
$string['registrationFailed'] = 'Wystąpił błąd';
$string['registrationFailedDescription'] = 'W tym momencie nie mogliśmy założyć konta. Coś poszło nie tak. Spróbuj ponownie później.';
$string['registrationTitle'] = 'Rejestracja w H5P Hub';
$string['remove'] = 'Usuń';
$string['removeChip'] = 'Usuń :chip z listy';
$string['removeImage'] = 'Usuń obraz';
$string['requiredInfo'] = 'Wymagane informacje';
$string['resizescript'] = 'Dołącz ten skrypt do swojej strony, jeśli chcesz dynamicznie zmieniać rozmiar osadzonej zawartości:';
$string['resubmitScores'] = 'Próba przesłania zapisanych wyników.';
$string['reuse'] = 'Ponowne użycie';
$string['reuseContent'] = 'Ponowne użycie zasobu.';
$string['reuseDescription'] = 'Ponownie użyj ten zasób.';
$string['reviewAndSave'] = 'Przejrzyj i zapisz';
$string['reviewAndShare'] = 'Przejrzyj i udostępnij';
$string['reviewInfo'] = 'Przejrzyj informacje';
$string['reviewMessage'] = 'Przed udostępnieniem zapoznaj się z poniższymi informacjami';
$string['rotateLeft'] = 'Obróć w lewo';
$string['rotateRight'] = 'Obróć w prawo';
$string['saveChanges'] = 'Zapisz zmiany';
$string['screenshots'] = 'Zrzuty ekranu';
$string['screenshotsDescription'] = 'Dodaj maksymalnie pięć zrzutów ekranu swojej zawartości';
$string['share'] = 'Udostępnij';
$string['shareFailed'] = 'Udostępnianie nie powiodło się.';
$string['shareTryAgain'] = 'Coś poszło nie tak. Spróbuj udostępnić ponownie.';
$string['shared'] = 'Udostępnione';
$string['sharingNote'] = 'Wszystkie szczegóły dot. zawartości można edytować po udostępnieniu';
$string['shortDescription'] = 'Krótki opis';
$string['shortDescriptionPlaceholder'] = 'Krótki opis zawartości';
$string['showadvanced'] = 'Pokaż zaawansowane';
$string['showless'] = 'Pokaż mniej';
$string['showmore'] = 'Pokaż więcej';
$string['size'] = 'Rozmiar';
$string['someKeywordsExits'] = 'Niektóre z tych słów kluczowych już istnieją';
$string['source'] = 'Źródło';
$string['startingover'] = 'Rozpoczniesz od nowa.';
$string['status'] = 'Status';
$string['subContentWarning'] = 'Treść podrzędna (obrazy, pytania itp.) zostanie udostępniona w ramach :license, chyba że w narzędziu autorskim określono inaczej';
$string['sublevel'] = 'Poziom podrzędny';
$string['submitted'] = 'Przesłano!';
$string['successfullyRegistred'] = 'Pomyślnie zarejestrowałeś konto w hubie H5P';
$string['successfullyRegistredDescription'] = 'Dane konta można zmienić';
$string['successfullyUpdated'] = 'Ustawienia Twojego konta H5P Hub zostały pomyślnie zmienione';
$string['task_h5p'] = 'Zaplanowane zadanie H5P';
$string['task_h5p_description'] = 'Zaplanowane zadanie H5P pobiera dostępne typy zasobów H5P z h5p.org.';
$string['thumbnail'] = 'Miniaturka';
$string['title'] = 'Tytuł';
$string['undisclosed'] = 'Niejawne';
$string['unpackedFilesExceedsMaxSize'] = 'Całkowity rozmiar rozpakowanych plików przekracza maksymalny dozwolony rozmiar. ({$a->%used} > {$a->%max})';
$string['updateRegistrationOnHub'] = 'Zapisz ustawienia konta';
$string['updatedlibraries'] = 'Zaktualizowano biblioteki H5P {$a->%old}.';
$string['updatedlibrary'] = 'Zaktualizowano bibliotekę H5P {$a->%old}.';
$string['uploadlibraries'] = 'Prześlij typy treści H5P';
$string['uploadsuccess'] = 'Typy treści H5P zostały pomyślnie przesłane';
$string['width'] = 'szerokość';
$string['wrongversion'] = 'Wersja biblioteki H5P {$a->%machineName} użyta w tej treści jest nieprawidłowa. Treść zawiera {$a->%contentLibrary}, a powinna {$a->%semanticsLibrary}.';
$string['year'] = 'Rok';
$string['years'] = 'Lata';
$string['yearsfrom'] = 'Lata (od)';
$string['yearsto'] = 'Lata (do)';
$string['zip'] = 'Zip';
