<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'auth_googleoauth2', language 'pl', version '5.0'.
 *
 * @package     auth_googleoauth2
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['auth_facebookclientid'] = 'twój identyfikator/klucz "secret" aplikacji może być wygenerowany na  <a href="https://developers.facebook.com/apps/" target="_blank">stronie dewelopera Facebook</a>:
<br/>Dodaj nową aplikację > Strona > Wprowadź nazwę strony jako nazwę aplikacji > Utwórz nowy identyfikator aplikacji Facebooka > Wprowadź adres URL Strony - nie jest wymagane wprowadzenie adresy mobilnego > Na stronie potwierdzenia strony, zobacz link "Przeskocz do Kokpitu dewelopera" > w kokpicie aplikacji powinienes znaleźć identyfikator / klucz "secret" > Ustawienia > Zaawansowane > Wprowadź poprawny OAuth redirect URIs
<br/>Adres URL strony: {$a->siteurl}
<br/>Domena aplikacji: {$a->sitedomain}
<br/>Valid OAuth redirect URIs: {$a->callbackurl}';
$string['auth_googlesettings'] = 'Ustawienia';
$string['auth_sign-in_with'] = 'Zaloguj się z {$a->providername}';
$string['couldnotauthenticate'] = 'Uwierzytelnienie nie powiodło się. Spróbuj zalogować się ponownie.';
$string['couldnotauthenticateuserlogin'] = 'Błąd metody uwierzytelnienia: użytkownik o tym samym adresie e-mail już istnieje !<br/>
Wybierz inną metodę uwierzytelniania lub skontaktuj się z administratorem witryny.<br/>
<br/>
<a href="{$a->loginpage}">Spróbuj ponownie</a>.<br/>
<a href="{$a->forgotpass}">Zapomniałeś hasła</a>?';
$string['couldnotgetgoogleaccesstoken'] = 'Dostawca uwierzytelniania wysłał nam informację o błędzie komunikacji. Spróbuj zalogować się ponownie.';
$string['couldnotgetuseremail'] = 'Sieć społecznościowa nie dostarcza nam <b>e-maila</b>. Moodle wymaga prawidłowego adresu e-mail do poprawnego logowania: sprawdź preferencje użytkownika w sieci społecznościowej i włącz widoczność e-maili.';
$string['displaybuttons'] = 'Wyświetlić przyciski na stronie logowania ?';
$string['displaybuttonshelp'] = 'Wyświetl przyciski logo dostawcy w górnej części strony logowania.
Jeśli chcesz samodzielnie umieścić przyciski na swojej stronie logowania, możesz wyłączyć tę opcję i dodać następujący kod: {$a}';
$string['donotcreatenewuser'] = 'Zabroń automatycznego tworzenia kont użytkowników.';
$string['donotcreatenewuserhelp'] = 'Po włączeniu tej opcji, nawet jeśli włączona jest opcja "Zapobiegaj tworzeniu konta", wtyczka ta nie tworzy automatycznie nowego konta użytkownika przy logowaniu (zwykle ta opcja musi pozostać niezaznaczona).';
$string['emailaddressmustbeverified'] = 'Twój adres e-mail nie jest weryfikowany przez wybraną metodę uwierzytelniania. Prawdopodobnie zapomniałeś kliknąć link „zweryfikuj adres e-mail”, który Google lub Facebook powinien wysłać Ci w trakcie subskrypcji ich usług.';
$string['emailnotallowed'] = 'Twój adres e-mail jest uprawniony do logowania się na tej stronie.';
$string['faileduserdetails'] = 'Witryna nawiązała połączenie z wybranym dostawcą, ale nie udało się pobrać danych użytkownika.';
$string['horizontal'] = 'Ułożenie poziome';
$string['microsoft_failure'] = 'Nie otrzymano kodu autoryzacyjnego z serwerów Microsoft.';
$string['moreproviderlink'] = 'Zaloguj się za pomocą innej usługi.';
$string['noaccountyet'] = 'Nie masz jeszcze uprawnień do korzystania z serwisu. Skontaktuj się z administratorem i poproś go o aktywację konta.';
$string['othermoodle'] = 'Inne uwierzytelnienie Moodle';
$string['othersettings'] = 'Inne ustawienia';
$string['providerlinksstylehelp'] = 'Dzięki tej opcji możesz wybrać pionowy lub poziomy styl wizualizacji listy dostawców logowania. Konkretny motyw może ograniczyć to ustawienie, osadzając formularz logowania w ściśle określonym rozmiarze.';
$string['providerlinkstext'] = 'Inni dostawcy logowania:';
$string['saveaccesstoken'] = 'Czy zapisać token dostępu użytkownika?';
$string['saveaccesstokenhelp'] = 'Ustaw, aby zapisać token dostępu użytkownika we wtyczce wewnętrznej tabeli. Sprawdź, czy polityka API dla włączonych dostawców oauth2 wyraża zgodę na lokalne zapisywanie tokenów (większość z nich nie wyraża zgody).';
$string['signinwithanaccount'] = 'Zaloguj się za pomocą {$a}';
$string['stattitle'] = 'Statystyki logowania dla tej wtyczki';
$string['stattitlecaption'] = 'Statystyki z ostatnich {$a->periodindays} dni.';
$string['supportmaintenance'] = 'Aby pomóc w utrzymaniu tej wtyczki, zaloguj się na <a target="_blank" href="https://moodle.org/plugins/view/auth_googleoauth2">stronę wtyczki Moodle.org</a> i kliknij \'Dodaj do moje ulubione\'. Dzięki!';
$string['unknownfirstname'] = 'Nieznane imię';
$string['unknownlastname'] = 'Nieznane nazwisko';
$string['vertical'] = 'Ułożenie pionowe';
