<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_amos', language 'no', version '5.0'.
 *
 * @package     local_amos
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['about'] = '<p> AMOS er et sentralt lagringssted for Moodle språkstrenger og deres historie. Den sporer tillegg av engelske strenger i Moodle-koden, samler oversettelser, håndterer vanlige oversettelsesoppgaver og genererer språkpakker som skal distribueres på Moodle-servere. </ P><p> Se <a href="https://docs.moodle.org/dev/AMOS_manual"> AMOS-dokumentasjon </a> for mer informasjon. </ p>';
$string['amos'] = 'AMOS verktøykasse for oversettelse';
$string['amos:changecontriblang'] = 'Endre språk for bidragsstrenger';
$string['amos:commit'] = 'Sjekk inn mellomlagrede strenger til kjernefilene';
$string['amos:execute'] = 'Kjør valgt AMOScript';
$string['amos:importfile'] = 'Importer strenger fra opplastet fil og mellomlagre dem';
$string['amos:importstrings'] = 'Importer strenger (inkludert de engelske) direkte til hovedrepositoriet.';
$string['amos:manage'] = 'Administrere AMOS-portal';
$string['amos:stage'] = 'Bruk AMOS oversettelsesverktøy og mellomlagre språkstrengene';
$string['amos:stash'] = 'Lagre gjeldende mellomlager i permanent lager';
$string['amos:usegoogle'] = 'Bruk Google Translator';
$string['applangindexfile'] = 'Moodle App langindeks filplassering';
$string['applangindexfile_desc'] = 'Fullfør URL hvor du skal laste ned filen. Det vil bli gjort av en cron-oppgave.';
$string['branchesall'] = 'Alle kjente Moodle-versjoner';
$string['branchesall_desc'] = 'Kommaseparert liste over Moodle-versjonskoder som AMOS støtter. Dette brukes til å fylle ut listen over versjoner i oversetterfilteret og andre steder.';
$string['branchsupported'] = 'Eldste støttede Moodle-versjon';
$string['branchsupported_desc'] = 'Kode for den eldste Moodle-versjonen som fortsatt skal spores for endringer i engelske strenger og som installeringsspråkpakkene ennå er generert for. Bruk <https://docs.moodle.org/dev/Releases#Version_support> som referanse.';
$string['cachedef_lists'] = 'Lister over språk og komponenter kjent i AMOS';
$string['cachedef_stats'] = 'Statistikkdata generert av AMOS';
$string['commitbutton'] = 'Innsjekking';
$string['commitkeepstaged'] = 'Hold strenger mellomlagret';
$string['commitmessage'] = 'Innsjekkingsmelding';
$string['commitmessageempty'] = 'Vennligst fyll inn Innsjekkingsmeldingen';
$string['commitstage'] = 'Sjekk inn mellomlagrede språkstrenger';
$string['commitstage_help'] = 'Lagre alle mellomlagrede oversettelser i AMOS sine kjernefiler. Mellomlageret blir automatisk sjekket for feil før innsjekking og bare innsjekkbare strenger blir lagret. Dette betyr at det KUN lagres strenger som er merket med grønt. Mellomlageret tømmes når innsjekkingen er fullført.';
$string['committable'] = 'Du har tillatelse til å sjekke inn til denne språkpakken';
$string['committableall'] = 'alle språk';
$string['committablenone'] = 'ingen tilgang til språk - vennligst kontakt AMOS administratoren';
$string['componentsall'] = 'Alle';
$string['componentsapp'] = 'Moodle App';
$string['componentsnone'] = 'Ingen';
$string['componentsstandard'] = 'Standard';
$string['confirmaction'] = 'Dette kan ikke angres. Er du sikker?';
$string['contribaccept'] = 'Godta';
$string['contribactions'] = 'Oversettelsesbidrag';
$string['contribactions_help'] = 'Avhengig av dine rettigheter ,og hvordan arbeidsflyten er satt opp, kan noen av handlingene under være tilgjengelige:

* Legg til - kopier oversettelsen inn i mellom lageret, endrer ikke dine bidrag.
* Tildel meg - angi deg selv som redaktør og ansvarlig for å se over oversettelser og godkjenne dem.
* Fratre - angir "ingen" som tildeler av oppgaver.
* Start gjennomgang - tildeler siste oversettelsesbidrag til deg selv, setter status "under gjennomgang" og kopierer oversettelsesbidraget inn i ditt mellomlager.
* Godta - merker bidraget som godkjent.
* Avslå - merker bidraget som avvist, vennligst bruk kommentarfeltet og gi en begrunnelse.

Bidragsyteren blir informert via e-post hver gang status for bidragene endres.';
$string['contribactions_link'] = 'AMOS#Contributing_to_a_language_pack';
$string['contribapply'] = 'Legg til';
$string['contribassignee'] = 'Tildeler';
$string['contribassigneenone'] = '-';
$string['contribassigntome'] = 'Tildel til meg';
$string['contribauthor'] = 'Forfatter';
$string['contribclosedno'] = 'Skjul gjennomgåtte bidrag';
$string['contribclosedyes'] = 'Vis gjennomgåtte bidrag';
$string['contribcomponents'] = 'Komponenter';
$string['contribid'] = 'ID';
$string['contribincomingnone'] = 'Ingen inngående bidrag';
$string['contribincomingsome'] = 'Inngående bidrag ({$a})';
$string['contriblanguage'] = 'Språk';
$string['contriblanguagebutton'] = 'Konvertér';
$string['contriblanguagechange'] = 'Retter feil bidragsspråk';
$string['contriblanguagechange_help'] = 'Hvis bidraget har blitt sendt til feil språkpakke ved en feiltakelse, velg riktig språk i rullegardinmenyen nedenfor og klikk deretter på Konverter-knappen.';
$string['contriblanguagereport'] = 'Rapporterer feil bidragsspråk';
$string['contriblanguagereport_help'] = 'Hvis dette bidraget har blitt sendt til feil språkpakke ved en feiltakelse, må du kopiere og lime inn bidragets URL i en e-post til `translation@moodle.org`. Bidraget vil da bli flyttet til riktig språk.';
$string['contriblanguagewrong'] = 'Feil språk?';
$string['contribnotif'] = '[AMOS] Bidragsvarsling (#{$a->id})';
$string['contribnotifaccepted'] = '{$a->fullname} har godtatt oversettelsen du har bidratt med
#{$a->id} {$a->subject}

-------------------------------------------------- ------------------
Bidragsside: {$a->contriburl}';
$string['contribnotifcommented'] = '{$a->fullname} har kommentert oversettelsen
#{$a->id} {$a->subject}
-------------------------------------------------- ------------------

{$a->message}

-------------------------------------------------- ------------------
Bidragsside: {$a->contriburl}';
$string['contribnotifconverted'] = '{$a->fullname} har konvertert oversettelsen din
#{$a->id} {$a->subject}

Takk for ditt bidrag. Imidlertid ser det ut til at det ble sendt til feil
språkpakke ved en feiltakelse. Derfor har ditt bidrag blitt avvist fra
feil språkpakke og flyttet til riktig språkpakke for gjennomgang av
språkpakke vedlikeholder. Ingen handling fra deg er nødvendig.

I fremtiden må du dobbeltsjekke at du har valgt ditt eget språk før
du begynner å oversette strenger.

-------------------------------------------------- ------------------
Opprinnelig bidragside: {$a->contriborigurl}
Ny bidragside: {$a->contribnewurl}';
$string['contribnotifpending'] = 'Det er en ventende oversettelse som krever handlingen din
#{$a->id} {$a->subject}

Som vedlikeholder av språkpakken er det meningen at du skal gjennomgå og til slutt
forplikte alle innsendte bidrag. Når du er ferdig, merk dem som godkjent eller
avvist.

Se {$a->docsurl} for mer informasjon.
-------------------------------------------------- ------------------
Bidragsside: {$a->contriburl}';
$string['contribnotifrejected'] = '{$a->fullname} har avvist oversettelsen din
#{$a->id} {$a->subject}

-------------------------------------------------- ------------------
Bidragsside: {$a->contriburl}';
$string['contribnotifsubmitted'] = '{$a->fullname} har sendt inn en ny oversettelse
#{$a->id} {$a->subject}
-------------------------------------------------- ------------------

{$a->message}

* Språk: {$a->language}
* Komponenter: {$a->components}
* Strenger: {$a->strings}

-------------------------------------------------- ------------------
Bidragsside: {$a->contriburl}';
$string['contribreject'] = 'Avslå';
$string['contribresign'] = 'Fjern tildelingen';
$string['contribstaged'] = 'Mellomlagret bidrag <a href="contrib.php?id={$a->id}">#{$a->id}</a> av {$a->author}';
$string['contribstagedinfo'] = 'Mellomlagret bidrag';
$string['contribstagedinfo_help'] = 'Mellomlageret inneholder strenger som ble bidratt av et fellesskapsmedlem. Språkpakkens vedlikeholdere skal gjennomgå dem og deretter sette statusen deres til enten Godtatt (hvis det var forpliktet) eller Avvist (hvis de av en eller annen grunn ikke kan inkluderes i den offisielle språkpakken).';
$string['contribstagedinfo_link'] = 'AMOS#Contributing_to_a_language_pack';
$string['contribstartreview'] = 'Start gjennomgang';
$string['contribstatus'] = 'Status';
$string['contribstatus0'] = 'Ny';
$string['contribstatus10'] = 'Under gjennomgang';
$string['contribstatus20'] = 'Avvist';
$string['contribstatus30'] = 'Godkjent';
$string['contribstatus_help'] = 'Arbeidsflyten på oversettelsesbidrag består av følgende faser:

* Ny - bidraget er levert men ikke gjennomgått ennå.
* Under gjennomgang - oversettelsesbidraget er tildelt en språkpakkeadministrator og er mellomlagret for gjennomgang.
* Avvist - språkpakkeadministratoren har avvist bidraget og har muligens skrevet en begrunnelse
* Godkjent - bidraget er godkjent av språkpakkeadminstratoren.';
$string['contribstatus_link'] = 'AMOS#Contributing_to_a_language_pack';
$string['contribstrings'] = 'Språkstrenger';
$string['contribstringseq'] = '{$a->orig} nye';
$string['contribstringsnone'] = '{$a->orig} (alle er allerede oversatt i språkpakken)';
$string['contribstringssome'] = '{$a->orig} ({$a->same} av dem har allerede en nyere oversettelse';
$string['contribsubject'] = 'Emne';
$string['contribsubmittednone'] = 'Ingen innsendte bidrag';
$string['contribsubmittedsome'] = 'Dine bidrag ({$a})';
$string['contribtimemodified'] = 'Endret';
$string['contribute'] = 'Bidra';
$string['contributenow'] = 'Bidra nå!';
$string['contributestats'] = 'Totalt <strong>{$a->count}</strong> strenger oversatt av fellesskapsmedlemmer har blitt sendt inn til AMOS så langt.';
$string['contributethanks'] = 'Tusen takk til {$a->listcontributors} for deres nylige bidrag!';
$string['contributethankslist'] = '{$a->contributor1}, {$a->contributor2}, {$a->contributor3} og {$a->contributor4}';
$string['contributions'] = 'Oversettelsesbidrag';
$string['creditsaddcontributor'] = 'Legg til bidragsyter';
$string['creditsaddmaintainer'] = 'Legg til vedlikeholder';
$string['creditscontact'] = 'Send melding';
$string['creditscontributors'] = 'Andre bidragsytere';
$string['creditsdelcontributor'] = 'Fjern bidragsyter';
$string['creditsdelmaintainer'] = 'Fjern vedlikeholder';
$string['creditsmaintainedby'] = 'Vedlikeholdt av';
$string['creditsnomaintainer'] = 'Ingen vedlikeholder for øyeblikket. <a href="{$a->url}">Bli det!</a>';
$string['creditsthanks'] = 'På denne siden ønsker vi å takke alle som har bidratt til Moodle-oversettelser. Arbeidet deres har gjort spredningen av Moodle over hele verden mulig.';
$string['creditstitlelong'] = 'Språkpakke vedlikeholdere og bidragsytere';
$string['creditstitleshort'] = 'Kredit';
$string['diff'] = 'Sammenlign';
$string['diffstringmode'] = 'Bytt diff-modus';
$string['err_exception'] = 'Feil: {$a}';
$string['err_invalidlangcode'] = 'Ugyldig språkkode';
$string['err_parser'] = 'Parsing feil: {$a}';
$string['filtercmp'] = 'Komponenter';
$string['filtercmp_desc'] = 'Vis strenger for disse komponentene';
$string['filtercmpnothingselected'] = 'Velg en komponent';
$string['filterlng'] = 'Språk';
$string['filterlng_desc'] = 'Vis oversettelser i disse språkene';
$string['filterlngnothingselected'] = 'Velg et språk';
$string['filtermis'] = 'Diverse';
$string['filtermis_desc'] = 'Vis tilleggsbetingelser på språkstrenger';
$string['filtermisfapp'] = 'bare strenger brukt i Moodle App';
$string['filtermisfapp_help'] = 'Denne strengen brukes i Moodle Apps som {$a}';
$string['filtermisfhas'] = 'bare oversatte strenger';
$string['filtermisfhlp'] = 'vis bare hjelp-strenger';
$string['filtermisfmis'] = 'vis bare manglende eller utdaterte strenger';
$string['filtermisfout'] = 'bare utdaterte strenger';
$string['filtermisfstg'] = 'vis bare mellomlagrede strenger';
$string['filtersid'] = 'Streng-indentifikator';
$string['filtersid_desc'] = 'Nøkkelen i strengmatrisen';
$string['filtersidpartial'] = 'delvis treff';
$string['filtertxt'] = 'Underordnet streng';
$string['filtertxt_desc'] = 'Strengen må inneholde en tekst';
$string['filtertxtcasesensitive'] = 'store og små bokstaver';
$string['filtertxtregex'] = 'regex';
$string['filterver'] = 'Versjon';
$string['filterver_desc'] = 'Vis strenger for denne Moodle-versjonen';
$string['filtervernothingselected'] = 'Velg en versjon';
$string['foundmissing'] = '{$a} mangler';
$string['foundmissingonthispage'] = '{$a} på denne siden';
$string['foundtotal'] = '{$a} funnet';
$string['googletranslate'] = 'spør google';
$string['importfile'] = 'Importér oversatte strenger fra fil';
$string['importfile_help'] = 'Hvis du har oversatt strengene dine offline, kan du sjekke dem inn via dette skjemaet.

* Filen må være en gyldig Moodle PHP-streng definisjonsfil. Se på `/lang/en/`-katalogen til Moodle-installasjonen for eksempler.
* Navnet på filen må samsvare med den med engelske streng-definisjoner for den gitte komponenten (som `moodle.php`, `assignment.php` eller `enrol_manual.php`).

Alle strenger som finnes i filen vil bli sjekket inn for den valgte versjonen og språket.

Flere PHP-filer kan behandles samtidig hvis du legger dem inn i en ZIP-fil.';
$string['importfile_link'] = 'local/amos/importfile';
$string['language'] = 'Språk';
$string['languagepacks'] = 'Ytterligere språkpakker kan installeres på Moodle-nettstedet ditt via <em>Administrasjon > Nettstedadministrasjon > Språk > Språkpakker</em>, eller manuelt. For mer informasjon, se <a href="https://docs.moodle.org/en/Language_packs">dokumentasjonen for språkpakker</a>.';
$string['languages'] = 'Språk';
$string['languagesall'] = 'Alle';
$string['languagesnone'] = 'Ingen';
$string['lastavailable'] = 'Siste tilgjengelige versjon';
$string['lessfilteringoptions'] = 'Færre alternativer';
$string['log'] = 'Logg';
$string['logfilterbranch'] = 'Versjoner';
$string['logfiltercommithash'] = 'git hash';
$string['logfiltercommitmsg'] = 'Melding ved innsjekking inneholder';
$string['logfiltercommits'] = 'Innsjekkingsfilter';
$string['logfiltercommittedafter'] = 'Innsjekket etter';
$string['logfiltercommittedbefore'] = 'Innsjekket før';
$string['logfiltercomponent'] = 'Komponenter';
$string['logfilterlang'] = 'Språk';
$string['logfiltershow'] = 'Vis filtrerte innsjekkinger og strenger';
$string['logfiltersource'] = 'Kilde';
$string['logfiltersourceamos'] = 'amos (Webbasert oversetter)';
$string['logfiltersourceautomerge'] = 'automerge (oversettelse kopiert fra en annen gren)';
$string['logfiltersourcebot'] = 'bot (masseoperasjoner utført av et skript)';
$string['logfiltersourcecommitscript'] = 'commitscript (AMOS skriptet i innsjekkingsmeldingen)';
$string['logfiltersourcefixdrift'] = 'fixdrift (fiksert AMOS-git-drift)';
$string['logfiltersourcegit'] = 'git (git speiler Moodles kildekode og 1.x pakker)';
$string['logfiltersourceimport'] = 'import (importerte strenger for en bidratt modul)';
$string['logfiltersourcerevclean'] = 'revclean (revers oppryddingsprosess)';
$string['logfilterstringid'] = 'Streng-identifikator';
$string['logfilterstrings'] = 'Strengfilter';
$string['logfilterusergrp'] = 'Innsjekker';
$string['logfilterusergrpor'] = 'eller';
$string['maintainers'] = 'Oversettere';
$string['manageamos'] = 'Administrér AMOS';
$string['markuptodate'] = 'Merk oversettelsen som oppdatert';
$string['markuptodatelabel'] = 'merk som oppdatert';
$string['messageprovider:checker'] = 'Språkpakkekontrollresultater';
$string['messageprovider:contribution'] = 'Bidro med oversettelser';
$string['morefilteringoptions'] = 'Flere valg';
$string['newlanguage'] = 'Nytt språk';
$string['nodiffs'] = 'Ingen forskjeller funnet';
$string['nofiletoimport'] = 'Vennligst oppgi en fil å importere fra.';
$string['nologsfound'] = 'Fant ingen strenger, vennligst endre filteret.';
$string['nostringsfound'] = 'Fant ingen strenger';
$string['nostringtoimport'] = 'Fant ingen gyldige strenger i fila. Sjekk at fila har korrekt filnavn og er korrekt formatert.';
$string['nothingtostage'] = 'Operasjonen returnerte ingen streng som kunne mellomlagres.';
$string['novalidzip'] = 'Kan ikke pakke ut ZIP-filen.';
$string['numofcommitsabovelimit'] = 'Fant {$a->found} bidrag som samsvarte med innsjekkingsfilteret {$a->limit} nylig endrede';
$string['numofcommitsunderlimit'] = 'Fant {$a->found} bidrag som samsvarte med innsjekkingsfilteret';
$string['numofmatchingstrings'] = 'Innenfor dette, {$a->strings} modifiseringer i {$a->commits}';
$string['outdatednotcommitted'] = 'Utdaterte strenger';
$string['outdatednotcommitted_help'] = 'AMOS oppdaget at strengen kan være utdatert siden den engelske versjonen er oppdatert etter oversettelsen. Vennligst se over oversettelsen.';
$string['outdatednotcommittedwarning'] = 'Utdatert';
$string['ownstashactions'] = 'Handliger for lokalt mellomlager';
$string['ownstashactions_help'] = '* Legg til - kopierer oversatte strenger fra lokalt mellomlager inn i brukerens mellomlage og lar det lokale mellomlageret forbli som det er.
* Pop - flytter oversatte strenger fra lokalt mellomlager til brukerens mellomlager og tømmer det lokale mellomlageret etterpå. (Dette blir som Legg til og tøm)
* Tøm - sletter alle strengene i lokalt mellomlager.
* Send - åpner et skjema for innsending av lokalt mellomlager til de offisielle oversetterne slik at de kan ta med dine bidrag i den offisielle språkpakken.';
$string['ownstashes'] = 'Dine lokale mellomlagre';
$string['ownstashes_help'] = 'Dette er en liste over alle dine lokale mellomlagre';
$string['ownstashesnone'] = 'Fant ingen egne lokale mellomlagre';
$string['permalink'] = 'Permalink';
$string['placeholder'] = 'Plassholdere';
$string['placeholder_help'] = 'Plassholdere er spesielle uttrykk som `{$a}` or `{$a->etellerannet}` i strengen. Utrykkene erstattes med en verdi når strengen vises.

Det er viktig å kopiere disse plassholderne nøyaktig slik de står i den originale strengen. Ikke prøv å oversette uttrykkene eller bytt orientering høyre-venstre.';
$string['placeholderwarning'] = 'plassholdere';
$string['pluginclasscore'] = 'Kjerne undersystemer';
$string['pluginclassnonstandard'] = 'Moduler som ikke er standard';
$string['pluginclassstandard'] = 'Standard moduler';
$string['pluginname'] = 'AMOS';
$string['plugintypelocations'] = 'Plasseringer av modultype';
$string['plugintypelocations_desc'] = 'Lar deg definere plasseringer av ekstra standard modultyper, for eksempel submodultyper levert av standard moduler, eller eldre typer.';
$string['presetcommitmessage'] = 'Oversettelsesbidrag #{$a->id} av {$a->author}';
$string['presetcommitmessage2'] = 'Flettet manglende strenger fra {$a->source} til {$a->target}-versjonen.';
$string['presetcommitmessage3'] = 'Retting av forskjeller mellom {$a->version} og {$a->version}';
$string['privacy:commitnumber'] = 'Sjekk inn {$a}';
$string['privacy:contribnumber'] = 'Bidrag {$a}';
$string['privacy:filterusage'] = 'Filterbruk';
$string['privacy:metadata:db:amoscommits'] = 'Beholder alle bidrags-relaterte metadata.';
$string['privacy:metadata:db:amoscommits:commitmsg'] = 'Sjekk inn melding levert av brukeren.';
$string['privacy:metadata:db:amoscommits:timecommitted'] = 'Tidsstempel for bidraget';
$string['privacy:metadata:db:amoscommits:userinfo'] = 'Brukeridentifikasjon som oppgitt i bidrags-kilden, f.eks. i Git.';
$string['privacy:metadata:db:amoscontributions'] = 'Bidro med oversettelser fra fellesskapets medlemmer.';
$string['privacy:metadata:db:amoscontributions:lang'] = 'Koden til språket dette bidraget tilhører.';
$string['privacy:metadata:db:amoscontributions:message'] = 'Innledende melding som beskriver innsendingen.';
$string['privacy:metadata:db:amoscontributions:stashid'] = 'Intern identifikator for vedlagte mellomlager.';
$string['privacy:metadata:db:amoscontributions:status'] = 'Arbeidsflytstatusen til bidraget".';
$string['privacy:metadata:db:amoscontributions:subject'] = 'Emnet for bidraget.';
$string['privacy:metadata:db:amoscontributions:timecreated'] = 'Tidsstempel for når bidragsposten ble opprettet.';
$string['privacy:metadata:db:amoscontributions:timemodified'] = 'Tidsstempel for når bidragsposten nylig ble endret.';
$string['privacy:metadata:db:amosfilterusage'] = 'Logg over bruk av AMOS-oversetterfilter.';
$string['privacy:metadata:db:amosfilterusage:currentlang'] = 'Gjeldende sesjonspråk.';
$string['privacy:metadata:db:amosfilterusage:ismaintainer'] = 'Har brukeren tillatelse til å bidra til AMOS-depotet?';
$string['privacy:metadata:db:amosfilterusage:numofcomponents'] = 'Antall valgte komponenter';
$string['privacy:metadata:db:amosfilterusage:numoflanguages'] = 'Antall valgte språk';
$string['privacy:metadata:db:amosfilterusage:numofversions'] = 'Antall valgte versjoner';
$string['privacy:metadata:db:amosfilterusage:showexistingonly'] = 'Skal bare eksisterende oversettelser vises?';
$string['privacy:metadata:db:amosfilterusage:showgreylistedonly'] = 'Skal kun grålistet streng vises?';
$string['privacy:metadata:db:amosfilterusage:showhelpsonly'] = 'Skal bare hjelpestrenger vises?';
$string['privacy:metadata:db:amosfilterusage:showmissingonly'] = 'Skal bare manglende og utdaterte strenger vises?';
$string['privacy:metadata:db:amosfilterusage:showoutdatedonly'] = 'Skal bare utdaterte strenger vises?';
$string['privacy:metadata:db:amosfilterusage:showstagedonly'] = 'Skal bare mellomlagrede strenger vises?';
$string['privacy:metadata:db:amosfilterusage:showwithoutgreylisted'] = 'Bør grålistede strenger fjernes fra resultatene?';
$string['privacy:metadata:db:amosfilterusage:stringidpartial'] = 'Er delvis samsvar for steng-id forespurt?';
$string['privacy:metadata:db:amosfilterusage:substringcasesensitive'] = 'Bør delstrengen betraktes som store og små bokstaver?';
$string['privacy:metadata:db:amosfilterusage:substringregex'] = 'Bør delstrengen betraktes som et regulært uttrykk?';
$string['privacy:metadata:db:amosfilterusage:timesubmitted'] = 'Tidsstempel for når filterskjemaet ble sendt inn';
$string['privacy:metadata:db:amosfilterusage:usercountry'] = 'Brukerens landskode som valgt i profilen';
$string['privacy:metadata:db:amosfilterusage:userlang'] = 'Brukerens foretrukne språk fra profilen deres';
$string['privacy:metadata:db:amosfilterusage:usesdefaultlang'] = 'Brukte brukeren de forhåndsvalgte språkene?';
$string['privacy:metadata:db:amosfilterusage:usesdefaultversion'] = 'Brukte brukeren de forhåndsvalgte versjonene i skjemaet?';
$string['privacy:metadata:db:amosfilterusage:withstringid'] = 'Ble streng-id spesifisert?';
$string['privacy:metadata:db:amosfilterusage:withsubstring'] = 'Var det spesifisert en understreng å søke etter?';
$string['privacy:metadata:db:amosstashes'] = 'Oppbevarer informasjonen om oppbevaringene i stashpoolen';
$string['privacy:metadata:db:amosstashes:components'] = 'Liste over komponenter som er lagret i det lagrede stadiet';
$string['privacy:metadata:db:amosstashes:id'] = 'Intern identifikator for mellomlageret';
$string['privacy:metadata:db:amosstashes:languages'] = 'Liste over språk som er inneholdt i det mellomlagrede stadiet';
$string['privacy:metadata:db:amosstashes:message'] = 'Den fullstendige meldingen som beskriver mellomlagringen, brukt som standard forpliktelsesmelding når mellomlagringen sendes inn som en oversettelse.';
$string['privacy:metadata:db:amosstashes:name'] = 'Navnet eller tittelen på mellomlageret';
$string['privacy:metadata:db:amosstashes:strings'] = 'Tittelen på stash';
$string['privacy:metadata:db:amosstashes:timecreated'] = 'Timestamp of when the stash was created';
$string['privacy:metadata:db:amosstashes:timemodified'] = 'Tidsstempel for når posten nylig ble endret';
$string['privacy:metadata:db:amostranslators'] = 'Beskriver forholdet mellom en språkpakke og en bruker. Dette kan enten være vedlikeholder (har rettigheter til å binde seg til språkpakken) eller eksplisitt bidragsyter (vises på kredittsiden selv uten innsendte bidrag).';
$string['privacy:metadata:db:amostranslators:lang'] = 'Språkkoden som oversetteren har lov til å oversette, eller stjerne for alle språk.';
$string['privacy:metadata:db:amostranslators:status'] = 'Bestemmer om brukeren er en vedlikeholder (0) eller en eksplisitt bidragsyter (1) av språkpakken.';
$string['privacy:metadata:external:languagepacks'] = 'Oversettelsesbidrag eksporteres til ZIP-filer som distribueres globalt og installeres på Moodle-portaler.';
$string['privacy:metadata:external:languagepacks:email'] = 'Bidragsyters e-postadresse kan være inkludert i språkpakkefilene.';
$string['privacy:metadata:external:languagepacks:firstname'] = 'Bidragsyterens fornavn kan være inkludert i språkpakkefilene.';
$string['privacy:metadata:external:languagepacks:lastname'] = 'Bidragsyterens etternavn kan være inkludert i språkpakkefilene.';
$string['privacy:metadata:subsystem:comment'] = 'Beskriv hvordan kommentarundersystemet brukes av modulen.';
$string['privacy:stashnumber'] = 'Mellomlagre {$a}';
$string['privileges'] = 'Dine privelegier';
$string['privilegesnone'] = 'Du har bare lese-rettigheter til offentlig informasjon.';
$string['processing'] = 'Behandler....';
$string['quicklinks'] = 'Hurtiglenker';
$string['quicklinks_amos'] = 'AMOS oversetter';
$string['quicklinks_forum'] = 'Oversetterforum';
$string['quicklinks_manual'] = 'Brukermanual';
$string['quicklinks_newcomers'] = 'Hjelp for nybegynnere';
$string['requestactions'] = 'Handling';
$string['requestactions_help'] = '* Legg til - kopierer oversatte strenger fra hent-forespørselen inn i ditt mellomlager. Dersom strengen allerede finnes blir den overskrevet med den hentede.
* Skjul - blokkerer hent-forespørsler så de ikke vises for deg mer.';
$string['savefilter'] = 'Vis strenger';
$string['script'] = 'AMOScript';
$string['script_help'] = 'AMOScript er et sett med instruksjoner for å prosessere strenglagret.';
$string['scriptexecute'] = 'Utfør og mellomlagre resultat';
$string['sourceversion'] = 'Kildeversjon';
$string['stage'] = 'Innsjekking';
$string['stageactions'] = 'Innsjekkingshandlinger';
$string['stageactions_help'] = '* Endre mellomlagrede strenger - modifiserer filterinnstillingene for oversetter slik at bare mellomlagrede strenger vises.
* Fjern strenger som ikke kan sjekkes inn - Fjerner alle strenger fra mellomlageret som du ikke har tillatelse til å sjekke inn. Mellomlageret blir automatisk rensket for ikke tillatte strenger før det sjekkes inn.
* klargjør databasen - fjerner alle oversettelser som enten ikke modifiserer eksisterende oversettelse eller er eldre enn siste oversettelse i språkpakken.  Mellomlageret blir automatisk klargjort før det sjekkes inn.
* Fjern alt fra mellomlageret - sletter mellomlageret og alle oversettelser lagret der går tapt.';
$string['stagedownload'] = 'Last ned';
$string['stageedit'] = 'Endre mellomlagrede strenger';
$string['stageprune'] = 'Fjern strenger som ikke kan sjekkes inn';
$string['stagerebase'] = 'Oppdater basen';
$string['stagestringsnocommit'] = 'Det er {$a->staged} mellomlagrede strenger';
$string['stagestringsnone'] = 'Det er ingen mellomlagrede strenger';
$string['stagestringssome'] = 'Det er {$a->staged} mellomlagrede strenger, {$a->committable} av dem kan sjekkes inn';
$string['stagesubmit'] = 'Send til språkpakkens oversettere';
$string['stagetoolopen'] = 'Gå til mellomlageret';
$string['stagetranslation'] = 'Oversettelse';
$string['stagetranslation_help'] = 'Viser mellomlagrede oversettelser som skal sjekkes inn. Bakgrunnsfargene for hver streng betyr:

* Grønn - du har modifisert en streng eller lagt til en manglende oversettelse som du har tillatelse til å sjekke inn.
* Gul - Du har endret en streng og du har lov til å sjekke endringen.
* Blå - du har modifisert en streng eller lagt til en manglende oversettelse du ikke har tillatelse til å sjekke inn i gjeldende språkpakke.
* Ingen farge - mellomlagret oversettelse er den samme som gjeldende og vil derfor ikke bli sjekket inn.';
$string['stageunstageall'] = 'Fjern alt fra innsjekkingen';
$string['standardcomponents'] = 'Liste over standard moduler';
$string['standardcomponents_desc'] = 'Liste over Moodle-standardkomponenter. Det valgfrie nummeret indikerer versjonskoden siden da komponenten er standard. Hvis tallet er negativt, indikerer det den siste versjonen da komponenten var til stede som standard en. Begge tallene kan være til stede. Eksempel:

* `mod_workshop` - uten versjoner anses denne komponenten som standard én på alle versjoner
* `report_infectedfiles 310` - indikerer en komponent som bør betraktes som standard fra og med Moodle 3.10
* `theme_clean 25 -36` - standardkomponent fra Moodle 2.5 til og med 3.6';
$string['stashactions'] = 'Lagre arbeid som pågår';
$string['stashactions_help'] = 'Et lokalt mellomlager er et øyeblikksbilde av gjeldende mellomlager. Lokale mellomlagre kan sendes inn til den offisielle administratoren av språkpakken for godkjenning. Godkjente strenger legges inn i språkpakken.';
$string['stashapply'] = 'Legg til';
$string['stashautosave'] = 'Automatisk lagrede sikkerhetskopier av lokale mellomlagre';
$string['stashautosave_help'] = 'Dette lokale mellomlageret inneholder den mest oppdaterte versjonen av mellomlageret ditt. Du kan bruke den som en sikkerhetskopi for de tilfellene hvor alle strenger blir fjernet fra mellomlageret f.eks. ved et uhell. Bruk "Legg til"- handlingen til å kopiere alle lokalt mellomlagrede strenger tilbake til mellomlageret. (Dette vil overskrive samsvarende strenger som ligger i mellomlageret fra før)';
$string['stashcomponents'] = '<span>Komponenter:</span> {$a}';
$string['stashdownload'] = 'Last ned';
$string['stashdrop'] = 'Drop';
$string['stashdropconfirm'] = 'Vil du virkelig slette mellomlagringen <em>\'{$a}\'</em> permanent?';
$string['stashes'] = 'Lokale mellomlagre';
$string['stashlanguages'] = '<span>Språk:</span> {$a}';
$string['stashpop'] = 'Pop';
$string['stashpush'] = 'Overfør alle mellomlagrede strenger til et nytt lokalt mellomlager';
$string['stashstrings'] = '<span>Antall strenger:</span> {$a}';
$string['stashsubmit'] = 'Send til oversettere';
$string['stashsubmitdetails'] = 'Innsendingsinformasjon';
$string['stashsubmitmessage'] = 'Melding';
$string['stashsubmitsubject'] = 'Emne';
$string['stashtitle'] = 'Tittel på lokal innsjekking';
$string['stashtitledefault'] = 'Arbeid pågår – {$a->time}';
$string['stdvernotebetween'] = 'Standard fra {$a->from} opp til {$a->to}';
$string['stdvernotefrom'] = 'Standard fra {$a->from}';
$string['stdvernoteto'] = 'Standard opp til {$a->to}';
$string['stringhistory'] = 'Historie';
$string['strings'] = 'Strenger';
$string['stringversionnotlatest'] = 'nyere versjoner finnes';
$string['submitting'] = 'Sender et bidrag';
$string['submitting_help'] = 'Dette vil sende oversatte strenger til de offisielle språkoversetterne. De kan legge til oversettelsen du har gjort i eget mellomlager, gjennomgå og eventuelt sjekke inn. Vennligst legg ved en melding til oversetterne som beskriver hva du har gjort og hvorfor du ønsker at din oversettelse skal brukes.';
$string['targetversion'] = 'Målversjon';
$string['timeline'] = 'Strengtidslinje';
$string['timelineheading'] = 'Strengtidslinje: {$a->component} | {$a->strname}';
$string['translatortool'] = 'Oversetter';
$string['translatortoolopen'] = 'Åpne AMOS oversetter';
$string['translatortranslation'] = 'Oversettelse';
$string['translatortranslation_help'] = 'Klikk på cellen for å gjøre den om til inndataredigering. Sett inn oversettelsen og klikk utenfor cellen for å iscenesette oversettelsen. Bakgrunnsfargen til cellen betyr:

* Grønn - strengen er allerede oversatt, du kan til slutt endre oversettelsen.
* Gul - strengen kan være utdatert. Den engelske originalen ble sannsynligvis modifisert etter at strengen var oversatt.
* Rød - strengen er ikke oversatt ennå.
* Blå - du har endret oversettelsen og den er nå iscenesatt.
* Grå - AMOS kan ikke brukes til å oversette denne strengen. For eksempel må strenger for Moodle 1.9 bare redigeres via den eldre CVS-tilgangen.

Språkpakkevedlikeholdere kan se et lite rødt symbol i hjørnet av cellene de har lov til å bruke.';
$string['typecontrib'] = 'Tilleggsmoduler';
$string['typecontribbadge'] = 'Tillegg';
$string['typecore'] = 'Kjerne undersystemer';
$string['typecorebadge'] = 'Kjerne';
$string['typestandard'] = 'Standard moduler';
$string['typestandardbadge'] = 'Standard';
$string['unableenfixaddon'] = 'Engelske rettelser kun tillatt for standard moduler';
$string['unableenfixcountries'] = 'Landnavn er kopiert fra ISO 3166-1';
$string['unableunmaintained'] = 'Språkpakken \'{$a}\' har ingen vedlikeholder for øyeblikket, så oversettelsesbidrag kan ikke aksepteres. Vennligst vurder å melde deg frivillig for å bli \'{$a}\' språkpakke-vedlikeholder.';
$string['unstage'] = 'Fjern fra mellomlagring';
$string['unstageconfirm'] = 'Bekreft fjern fra mellomlagring';
$string['unstageconfirmlong'] = '<p>Du skal fjerne oversettelsen av strengen <code>{$a->stringid}</code>, komponent <code>{$a->component}</code>, språkpakke <code>{$ a->language}</code>.</p><p>Er du sikker?</p>';
$string['unstaging'] = 'Fjerner fra mellomlagring';
$string['untranslate'] = 'Fjern oversettelse';
$string['untranslateconfirm'] = '<p>Du skal fjerne eksisterende oversettelse av strengen <code>{$a->stringid}</code>, komponent <code>{$a->component}</code>, fra <code>{$ a->siden</code> og høyere versjoner av språkpakken <code>{$a->language}</code>.</p><p>Er du sikker?</p>';
$string['untranslatetitle'] = 'Fjerner oversettelsen fra språkpakken';
$string['untranslating'] = 'Fjerner oversettelser';
$string['userdefaultreset'] = 'Tilbakestill til mine standardinnstillinger';
$string['userdefaultsave'] = 'Lagre som mine standardinnstillinger';
$string['version'] = 'Versjon';
