<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'forum', language 'da', version '5.0'.
 *
 * @package     forum
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actionsforgraderinterface'] = 'Handlinger for grænsefladen til bedømmeren';
$string['actionsforpost'] = 'Handlinger for indlæg';
$string['activitydate:due'] = 'Forfalder';
$string['activityoverview'] = 'Der er nye forumindlæg';
$string['addanewdiscussion'] = 'Tilføj en ny tråd';
$string['addanewquestion'] = 'Tilføj et nyt spørgsmål';
$string['addanewtopic'] = 'Tilføj nyt emne';
$string['addreply'] = 'Tilføj svar';
$string['addtofavourites'] = 'Giv denne tråd en stjerne';
$string['advancedsearch'] = 'Avanceret søgning';
$string['alldiscussions'] = 'Alle tråde';
$string['allforums'] = 'Alle fora';
$string['allowdiscussions'] = 'Kan en {$a} skrive i dette forum?';
$string['allowsallsubscribe'] = 'Dette forum giver alle mulighed for at vælge, om de vil abonnere eller ej';
$string['allowsdiscussions'] = 'Dette forum tillader hver person at starte en enkelt tråd.';
$string['allsubscribe'] = 'Abonner på alle fora';
$string['allunsubscribe'] = 'Afmeld abonnementer på alle fora';
$string['allusers'] = 'Alle brugere';
$string['alreadyfirstpost'] = 'Dette er allerede det første indlæg i diskussionen';
$string['announcementsettings'] = 'Standardindstillinger for meddelelsesforum';
$string['announcementsettings_help'] = 'Disse indstillinger definerer standardværdierne for alle meddelelsesfora.';
$string['anyfile'] = 'Alle filer';
$string['areaattachment'] = 'Bilag';
$string['areapost'] = 'Beskeder';
$string['attachment'] = 'Bilag';
$string['attachment_help'] = 'Du har mulighed for at vedhæfte en eller flere filer som bilag til et forumindlæg. Hvis du vedhæfter et billede vises det lige efter teksten.';
$string['attachmentname'] = 'Bilag {$a}';
$string['attachmentnameandfilesize'] = '{$a->name} ({$a->size})';
$string['attachmentnopost'] = 'Du kan ikke eksportere bilag uden et indlægs-id';
$string['attachments'] = 'Bilag';
$string['attachmentswordcount'] = 'Bilag og ordoptælling';
$string['authorreplyingprivatelytoauthor'] = '{$a->respondant} svarer {$a->author} privat';
$string['authorreplyingtoauthor'] = '{$a->respondant} svarer {$a->author}';
$string['availability'] = 'Tilgængelighed';
$string['blockafter'] = 'Antal tilladte indlæg før der blokeres';
$string['blockafter_help'] = 'Denne indstilling angiver det højeste antal indlæg en bruger må have i en given periode. Brugere der har rettigheden \'mod/forum:postwithoutthrottling\' er ikke underlagt denne begrænsning';
$string['blockperiod'] = 'Hvor længe skal der blokeres';
$string['blockperiod_help'] = 'Det er muligt at begrænse antal forumindlæg fra studerende i en given periode. Brugere der har rettigheden "mod/forum:postwithoutthrottling" er ikke underlagt denne begrænsning';
$string['blockperioddisabled'] = 'Bloker ikke';
$string['blogforum'] = 'Standardforum vist i et blog-agtigt format';
$string['bynameondate'] = 'ved {$a->name} - {$a->date}';
$string['cachedef_forum_count_discussions'] = 'Antal forumsdiskussioner';
$string['cachedef_forum_is_tracked'] = 'Brugers sporingsstatus for forum';
$string['calendardue'] = '{$a} er forestående';
$string['cancelreply'] = 'Annuller svar';
$string['cannotadd'] = 'Kunne ikke tilføje tråden i dette forum';
$string['cannotadddiscussion'] = 'For at oprette en ny tråd i dette forum skal man være medlem af en gruppe.';
$string['cannotadddiscussionall'] = 'Du har ikke tilladelse til at oprette en ny tråd for alle deltagere.';
$string['cannotadddiscussiongroup'] = 'Du kan ikke starte en tråd da du ikke er med i en gruppe.';
$string['cannotaddsubscriber'] = 'Kunne ikke tilføje abonnenten med id\'et {$a} til dette forum!';
$string['cannotaddteacherforumto'] = 'Kunne ikke tilføje konverteret lærerforum til sektion 0 på kurset';
$string['cannotcreatediscussion'] = 'Kunne ikke oprette en ny tråd.';
$string['cannotcreateinstanceforteacher'] = 'Kunne ikke oprette nyt kursusmodul til lærerforummet';
$string['cannotdeletepost'] = 'Du kan ikke slette dette indlæg!';
$string['cannoteditposts'] = 'Du kan ikke redigere andres indlæg!';
$string['cannotexportforum'] = 'Du kan ikke eksportere dette forum';
$string['cannotfavourite'] = 'Beklager, du har ikke tilladelse til at stjernemarkere tråde.';
$string['cannotfinddiscussion'] = 'Kunne ikke finde tråden i dette forum';
$string['cannotfindfirstpost'] = 'Kunne ikke finde det første indlæg i dette forum';
$string['cannotfindorcreateforum'] = 'Kunne ikke finde eller oprette et primært meddelelsesforum på webstedet';
$string['cannotfindparentpost'] = 'Kunne ikke finde første indlæg i tråden {$a}';
$string['cannotmovefromsingleforum'] = 'Kunne ikke flytte tråden fra et simpelt enkelttrådet forum';
$string['cannotmovenotvisible'] = 'Forummet er ikke synligt';
$string['cannotmovetonotexist'] = 'Du kan ikke flytte til det forum - det eksisterer ikke!';
$string['cannotmovetonotfound'] = 'Forummet blev ikke fundet på dette kursus';
$string['cannotmovetosingleforum'] = 'Kan ikke flytte diskussionen til et enkelt-diskussionsforum';
$string['cannotpindiscussions'] = 'Beklager, du har ikke beføjelse til at fastgøre tråde.';
$string['cannotpurgecachedrss'] = 'Kunne ikke fjerne de cachede rss-feeds fra kilde- og/eller destinationsforum/-ra. Tjek din fil med forumtilladelser.';
$string['cannotremovesubscriber'] = 'Kunne ikke fjerne abonnenten med id\'et {$a} fra dette forum!';
$string['cannotreply'] = 'Du kan ikke svare på dette indlæg';
$string['cannotsplit'] = 'Diskussioner i dette forum kan ikke splittes op';
$string['cannotsubscribe'] = 'Beklager, men du skal være medlem af en gruppe for at kunne abonnere.';
$string['cannottrack'] = 'Kunne ikke stoppe med at spore dette forum';
$string['cannotunsubscribe'] = 'Kunne ikke framelde dit abonnement på dette forum';
$string['cannotupdatepost'] = 'Du kan ikke opdatere dette indlæg';
$string['cannotuseseperategroupsandsingletopic'] = 'Separate grupper kan ikke bruges med en enkelt simpel diskussion.';
$string['cannotusesingletopicandseperategroups'] = 'En enkelt simpel diskussion kan ikke bruges med separate grupper.';
$string['cannotviewpostyet'] = 'Du kan ikke læse andre studerendes indlæg i denne diskussion, før du selv har skrevet noget.';
$string['cannotviewusersposts'] = 'Der er ingen indlæg fra denne bruger, som du kan se.';
$string['cleanreadtime'] = 'Marker gamle indlæg som læst klokken (time)';
$string['clicktofavourite'] = 'Du har ikke stjernemarkeret denne tråd. Klik her.';
$string['clicktolockdiscussion'] = 'Klik for at låse tråden';
$string['clicktosubscribe'] = 'Du abonnerer ikke på denne tråd. Klik for at abonnere.';
$string['clicktounfavourite'] = 'Du har stjernemarkeret denne tråd. Klik for at fjerne markeringen.';
$string['clicktounlockdiscussion'] = 'Klik for at åbne tråden igen.';
$string['clicktounsubscribe'] = 'Du abonnerer på denne tråd. Klik for at afmelde dig.';
$string['close'] = 'Luk';
$string['closegrader'] = 'Vælg hvem der skal bedømme';
$string['completiondetail:discussions'] = 'Start samtaler: {$a}';
$string['completiondetail:posts'] = 'Skriv indlæg i forummet: {$a}';
$string['completiondetail:replies'] = 'Svar på indlæg: {$a}';
$string['completiondiscussions'] = 'Start nye tråde:';
$string['completiondiscussionsdesc'] = 'Den studerende skal oprette mindst {$a} tråd(e)';
$string['completionposts'] = 'Start tråde eller skriv svar';
$string['completionpostsdesc'] = 'Studerende skal oprette mindst {$a} tråd(e) eller svar.';
$string['completionpostshelp'] = 'kræver diskussioner eller svar for at gennemføre';
$string['completionpostsinforums'] = 'Opslag i fora';
$string['completionreplies'] = 'Skriv svar';
$string['completionrepliesdesc'] = 'Studerende skal skrive mindst {$a} svar';
$string['configcleanreadtime'] = 'Klokkeslæt hvor indlæg fjernes fra listen over ulæste indlæg.';
$string['configdigestmailtime'] = 'Brugere som har valgt at få tilsendt e-mailsammendrag, vil højst få én e-mail om dagen. Denne indstilling styrer på hvilket tidspunkt af dagen den vil blive sendt (Mailen vil blive sendt ved næste cronjob efter dette tidspunkt).';
$string['configdisplaymode'] = 'Den normale præsentation af tråde, hvis der ikke er valgt andre.';
$string['configenablerssfeeds'] = 'Denne valgmulighed angiver om rss-feeds skal kunne bruges i alle fora. Du skal stadig slå rss-feeds til for hver enkelt forum.';
$string['configenabletimedposts'] = 'Vælg "ja" hvis du vil gøre det muligt at sætte et tidsrum for visning når en ny tråd oprettes i forummet.';
$string['configlongpost'] = 'Ethvert indlæg over denne længde (antal tegn, dog ikke html) bliver betragtet som lange. Indlæg på forsiden og på kurser med "Social format", eller brugerprofiler afkortes til et sted mellem længden for korte og lange indlæg (forum_shortpost og forum_longpost).';
$string['configmanydiscussions'] = 'Max antal tråde vist på en forumside.';
$string['configmaxattachments'] = 'Højeste antal bilag pr. indlæg';
$string['configmaxbytes'] = 'Standard for maksimal filstørrelse på alle filer vedhæftet et forumindlæg (underlagt kursusbegrænsninger og andre lokale indstillinger)';
$string['configoldpostdays'] = 'Antal dage før et indlæg markeres som læst';
$string['configreplytouser'] = 'Når en forummail sendes ud, skal brugerens e-mailadresse da stå som afsender, så modtagere kan svare direkte til brugeren i stedet for at svare i forummet? Selv hvis denne indstilling er aktiveret, kan brugeren stadig vælge at holde sin e-mailadresse hemmelig.';
$string['configrssarticlesdefault'] = 'Hvis RSS-feeds er aktiveret, indstiller dette standardantallet af artikler (enten tråde eller indlæg).';
$string['configrsstypedefault'] = 'Hvis RSS-feeds er aktiveret, indstiller dette standardaktivitetstypen.';
$string['configshortpost'] = 'Enhver besked under denne længde (antal tegn, dog ikke HTML) bliver betragtet som kort (se nedenfor).';
$string['configsubscriptiontype'] = 'Standardindstilling til abonnementstilstand';
$string['configtrackingtype'] = 'Standardindstilling for sporing af ulæste indlæg.';
$string['configtrackreadposts'] = 'Sættes til "Ja" hvis du ønsker at følge hvad hver bruger har læst.';
$string['configusermarksread'] = 'Vælges "ja" skal brugeren selv markere indlægget som læst. Vælges "nej" bliver indlægget markeret som læst hvis brugeren har kikket på det.';
$string['confirmsubscribe'] = 'Bekræft at du vil abonnere på forummet "{$a}".';
$string['confirmsubscribediscussion'] = 'Ønsker du at abonnere på tråden "{$a->discussion}" i forummet "{$a->forum}"?';
$string['confirmunsubscribe'] = 'Bekræft at du vil opsige dit abonnement på forummet "{$a}".';
$string['confirmunsubscribediscussion'] = 'Bekræft, at du vil opsige dit abonnement på tråden "{$a->discussion}" i forummet "{$a->forum}"?';
$string['couldnotadd'] = 'Kunne ikke tilføje dit indlæg pga. en ukendt fejl';
$string['couldnotdeletereplies'] = 'Beklager, kan ikke slettes, da andre allerede har svaret på det.';
$string['couldnotupdate'] = 'Kunne ikke opdatere dit indlæg pga. en ukendt fejl.';
$string['created'] = 'Oprettet';
$string['crontask'] = 'Send forummails og vedligeholdelsesjob';
$string['cutoffdate'] = 'Skæringsdato';
$string['cutoffdate_help'] = 'Er indstillingen aktiveret, vil forummet ikke acceptere indlæg efter denne dato.';
$string['cutoffdatereached'] = 'Skæringsdagen for indlæg i dette forum er nået, så du kan ikke skrive i det.';
$string['cutoffdatevalidation'] = 'Skæringsdatoen kan ikke ligge før afleveringsdatoen.';
$string['delete'] = 'Slet';
$string['deleteddiscussion'] = 'Tråden er slettet';
$string['deletedpost'] = 'Indlægget er slettet';
$string['deletedposts'] = 'Disse indlæg er slettet';
$string['deleteduser'] = 'Slettet bruger';
$string['deletesure'] = 'Er du sikker på, at du vil slette dette indlæg?';
$string['deletesureplural'] = 'Er du sikker på at du vil slette dette indlæg og alle svar på det? ({$a} indlæg)';
$string['digestmailheader'] = 'Dette er et dagligt sammendrag af nye indlæg fra {$a->sitename}s fora. Hvis du vil ændre dine indstillinger for forummails, gå til {$a->userprefs}.';
$string['digestmailpost'] = 'Ændr dine indstillinger for sammendrag fra forum';
$string['digestmailpostlink'] = 'Ændr dine indstillinger for sammendrag fra forummet: {$a}';
$string['digestmailprefs'] = 'din brugerprofil';
$string['digestmailsubject'] = '{$a}: Forumsammendrag';
$string['digestmailtime'] = 'Klokketime hvor der skal sendes sammendrags-mails';
$string['digestsentusers'] = 'E-mail med forumsammendrag sendt til {$a} brugere.';
$string['disallowsubscribe'] = 'Abonnement ikke mulig';
$string['disallowsubscribeteacher'] = 'Abonnement er ikke mulig (undtagen for lærere)';
$string['disallowsubscription'] = 'Abonnement';
$string['disallowsubscription_help'] = 'Dette forum er sat sådan op at du ikke kan abonnere på tråde.';
$string['discussion'] = 'Tråd';
$string['discussionlistsortbycreatedasc'] = 'Sorter efter oprettelsesdato, stigende';
$string['discussionlistsortbycreateddesc'] = 'Sorter efter oprettelsesdato, faldende';
$string['discussionlistsortbydiscussionasc'] = 'Sorter efter emne, stigende';
$string['discussionlistsortbydiscussiondesc'] = 'Sorter efter emne, faldende';
$string['discussionlistsortbygroupasc'] = 'Sorter efter gruppe, stigende';
$string['discussionlistsortbygroupdesc'] = 'Sorter efter gruppe, faldende';
$string['discussionlistsortbylastpostasc'] = 'Sorter efter seneste indlæg, stigende';
$string['discussionlistsortbylastpostdesc'] = 'Sorter efter seneste indlæg, faldende';
$string['discussionlistsortbyrepliesasc'] = 'Sorter efter antal svar, stigende';
$string['discussionlistsortbyrepliesdesc'] = 'Sorter efter antal svar, faldende';
$string['discussionlistsortbystarterasc'] = 'Sorter efter bruger der startede tråden, stigende';
$string['discussionlistsortbystarterdesc'] = 'Sorter efter bruger der startede tråden, faldende';
$string['discussionlocked'] = 'Denne tråd er låst, så du kan ikke længere svare på den.';
$string['discussionlockingdisabled'] = 'Lås ikke tråde';
$string['discussionlockingheader'] = 'Låsning af tråde';
$string['discussionmoved'] = 'Denne tråd er flyttet til "{$a}".';
$string['discussionmovedpost'] = 'Denne tråd er flyttet <a href="{$a->discusshref}">hertil</a> i forummet <a href="{$a->forumhref}">{$a->forumname}</a>';
$string['discussionname'] = 'Trådnavn';
$string['discussionnownotsubscribed'] = '{$a->name} vil IKKE blive underrettet om nye indlæg i tråden "{$a->discussion}" i "{$a->forum}"';
$string['discussionnowsubscribed'] = 'Du vil få besked om nye indlæg i "{$a->discussion}" i "{$a->forum}"';
$string['discussionpin'] = 'Fastgør';
$string['discussionpinned'] = 'Fastgjort';
$string['discussionpinned_help'] = 'Fastgjorte tråde vil vises i toppen af et forum.';
$string['discussions'] = 'Tråde';
$string['discussionsplit'] = 'Tråden er splittet op';
$string['discussionsstartedby'] = 'Tråde oprettet af {$a}';
$string['discussionsstartedbyrecent'] = 'Tråd  nyligt startet af {$a}';
$string['discussionsstartedbyuserincourse'] = 'Tråde oprettet af {$a->fullname} i {$a->coursename}';
$string['discussionsstartedincourse'] = 'Diskussioner startet i {$a}';
$string['discussionstartedby'] = 'Tråden er startet af {$a}';
$string['discussionsubscribed'] = 'Du abonnerer nu på denne tråd.';
$string['discussionsubscribestart'] = 'Send mig underretninger om nye indlæg i denne tråd';
$string['discussionsubscribestop'] = 'Jeg ønsker ikke at blive underrettet om nye indlæg i denne tråd';
$string['discussionsubscription'] = 'Abonnement på tråd';
$string['discussionsubscription_help'] = 'Når du abonnerer på en tråd, vil du modtage underretninger om nye indlæg i den.';
$string['discussionunpin'] = 'Frigør';
$string['discussionunsubscribed'] = 'Du abonnerer ikke længere på tråden.';
$string['discussthistopic'] = 'Diskuter dette emne';
$string['discusstopicname'] = 'Diskuter emnet: {$a}';
$string['displayend'] = 'Afslut visning';
$string['displayend_help'] = 'Du kan vælge om dit forumindlæg kun skal kunne ses indtil en bestemt dato. Bemærk dog at administratorer altid kan se forumindlæg.';
$string['displayenddate'] = 'Visningen ender: {$a}.';
$string['displaymode'] = 'Visningsform';
$string['displayperiod'] = 'Visningsperiode';
$string['displaystart'] = 'Begynd visning';
$string['displaystart_help'] = 'Du kan vælge om dit forumindlæg skal synliggøres en bestemt dato. Bemærk dog at administratorer altid kan se forumindlæg.';
$string['displaystartdate'] = 'Vis start: {$a}.';
$string['displaywordcount'] = 'Vis ordoptælling';
$string['displaywordcount_help'] = 'Denne indstilling angiver, om ordoptælling for hvert indlæg skal vises eller ej.';
$string['duedate'] = 'Afleveringsdato';
$string['duedate_help'] = 'På dette tidspunkt skal indlæg være sendt. Selvom datoen vises i kalenderen, vil der stadig kunne sendes indlæg til forummet. Sæt en skæringsdato for at forhindre indlæg efter et bestemt tidspunkt.';
$string['duedatetodisplayincalendar'] = 'Dato til visning i kalenderen';
$string['eachuserforum'] = 'Hver person starter én tråd';
$string['edit'] = 'Rediger';
$string['editdiscussion'] = 'Rediger diskussion';
$string['editdiscussiontopic'] = 'Rediger diskussionsemne';
$string['editedby'] = 'Redigeret af {$a->name} - oprindeligt indlæg {$a->date}';
$string['editedpostupdated'] = '{$a}\'s indlæg blev opdateret';
$string['editing'] = 'Redigerer';
$string['emaildigestcompleteshort'] = 'Komplette indlæg';
$string['emaildigestdefault'] = 'Standard ({$a})';
$string['emaildigestoffshort'] = 'Intet sammendrag';
$string['emaildigestsubjectsshort'] = 'Kun emner';
$string['emaildigesttype'] = 'Valgmuligheder for e-mailsammendrag';
$string['emaildigesttype_help'] = 'Den type underretning du vil få fra hvert forum:

* Standard - følger den indstilling for sammendrag der er i din brugerprofil. Hvis du opdaterer din profil, vil ændringen også afspejles her.
* Intet sammendrag - du vil få en e-mail pr. indlæg i forummet.
* Sammendrag - komplette indlæg - du vil få et e-mailsammendrag om dagen med det fulde indhold af hvert indlæg i forummet.
* Sammendrag - kun emner - du vil få et e-mailsammendrag om dagen kun med emnet for hvert indlæg i forummet.';
$string['emptymessage'] = 'Der var noget galt med dit indlæg.  Måske har du ikke skrevet noget eller den vedhæftede fil er for stor.  Dine ændringer er IKKE blevet gemt.';
$string['errorcannotlock'] = 'Du har ikke tilladelse til at låse tråde.';
$string['errordiscussionnotfound'] = 'Diskussionen blev ikke fundet';
$string['erroremptymessage'] = 'Indlægget kan ikke være tomt.';
$string['erroremptysubject'] = 'Indlæggets emne kan ikke være tomt.';
$string['errorenrolmentrequired'] = 'Du skal være tilmeldt kurset for at få adgang til dette indhold';
$string['errorforumnotfound'] = 'Forummet, som denne diskussion tilhører, blev ikke fundet';
$string['errorwhiledelete'] = 'Der opstod en fejl under sletning af posten.';
$string['eventassessableuploaded'] = 'Der er blevet skrevet i forummet.';
$string['eventcoursesearched'] = 'Kursus gennemsøgt';
$string['eventdiscussioncreated'] = 'Tråd oprettet';
$string['eventdiscussiondeleted'] = 'Tråd slettet';
$string['eventdiscussionlockupdated'] = 'Diskussionslås opdateret';
$string['eventdiscussionmoved'] = 'Tråd flyttet';
$string['eventdiscussionpinned'] = 'Tråd fastgjort';
$string['eventdiscussionsubscriptioncreated'] = 'Abonnement på tråd oprettet';
$string['eventdiscussionsubscriptiondeleted'] = 'Abonnement på tråd slettet';
$string['eventdiscussionunpinned'] = 'Tråd frigjort';
$string['eventdiscussionupdated'] = 'Tråd opdateret';
$string['eventdiscussionviewed'] = 'Tråd set';
$string['eventforumsubscriptionupdated'] = 'Abonnementstilstand opdateret';
$string['eventpostcreated'] = 'Indlæg oprettet';
$string['eventpostdeleted'] = 'Indlæg slettet';
$string['eventpostupdated'] = 'Indlæg opdateret';
$string['eventreadtrackingdisabled'] = 'Sporing af ulæste indlæg deaktiveret';
$string['eventreadtrackingenabled'] = 'Sporing af ulæste indlæg aktiveret';
$string['eventsubscribersviewed'] = 'Abonnenter set';
$string['eventsubscriptioncreated'] = 'Abonnement oprettet';
$string['eventsubscriptiondeleted'] = 'Abonnement slettet';
$string['eventuserreportviewed'] = 'Brugerrapport set';
$string['everyonecanchoose'] = 'Alle kan vælge at abonnere';
$string['everyonecannowchoose'] = 'Alle kan vælge at abonnere';
$string['everyoneisnowsubscribed'] = 'Nu er alle abonnenter på dette forum';
$string['everyoneissubscribed'] = 'Alle er abonnenter på forummet';
$string['existingsubscribers'] = 'Eksisterende abonnenter';
$string['export'] = 'Eksporter';
$string['exportattachmentname'] = 'Eksporter bilaget {$a} til portefolio';
$string['exportdiscussion'] = 'Eksporter hele tråden til portefølje';
$string['exporthumandates'] = 'Humant læsbare dateringer';
$string['exporthumandates_help'] = 'Hvorvidt dateringer skal eksporteres i et humant læsbart format eller som et tidsstempel (en talrække)-';
$string['exportoptions'] = 'Eksportindstillinger';
$string['exportstriphtml'] = 'Fjern HTML';
$string['exportstriphtml_help'] = 'Hvorvidt HTML-tags såsom p og br skal fjernes fra forumindlæg.';
$string['favourites'] = 'Stjernemarkerede';
$string['favouriteupdated'] = 'Din stjerneindstilling er opdateret';
$string['firstpost'] = 'Første indlæg';
$string['forcedreadtracking'] = 'Tillad tvungen sporing af ulæste indlæg';
$string['forcedreadtracking_desc'] = 'Dette tillader, at fora kan indstilles til tvungen sporing af læsning. Det vil resultere i dårligere ydeevne for nogle brugere, især på kurser med mange fora og indlæg. Når dette er slået fra, vil fora der tidligere er indstillet til tvungen sporing, blive behandlet som valgfrie.';
$string['forcesubscribed'] = 'Dette forum tvinger alle til at være abonnenter';
$string['forcesubscribed_help'] = 'I dette forum kan du ikke afmelde abonnementet på tråde.';
$string['forum'] = 'Forum';
$string['forum:addinstance'] = 'Tilføj et nyt forum';
$string['forum:addnews'] = 'Tilføj meddelelser';
$string['forum:addquestion'] = 'Tilføj spørgsmål';
$string['forum:allowforcesubscribe'] = 'Tillad tvunget abonnement';
$string['forum:canmailnow'] = 'Kan skrive i spørgsmål og svar-forummet uden forsinkelse for redigering';
$string['forum:canoverridecutoff'] = 'Indlæg i fora efter deres skæringsdato';
$string['forum:canoverridediscussionlock'] = 'Svar på låste tråde';
$string['forum:canposttomygroups'] = 'Skriv til alle de grupper, du har adgang til';
$string['forum:cantogglefavourite'] = 'Stjernemarker tråde';
$string['forum:createattachment'] = 'Tilføj bilag';
$string['forum:deleteanypost'] = 'Slet alle indlæg (til enhver tid)';
$string['forum:deleteownpost'] = 'Slet egne indlæg (indenfor deadline)';
$string['forum:editanypost'] = 'Rediger ethvert indlæg';
$string['forum:exportdiscussion'] = 'Eksporter hele tråden';
$string['forum:exportforum'] = 'Eksporter forum';
$string['forum:exportownpost'] = 'Eksporter eget indlæg';
$string['forum:exportpost'] = 'Eksporter indlæg';
$string['forum:grade'] = 'Giv karakter for forum';
$string['forum:managesubscriptions'] = 'Håndter abonnenter';
$string['forum:movediscussions'] = 'Flyt tråd';
$string['forum:pindiscussions'] = 'Fastgør tråde';
$string['forum:postprivatereply'] = 'Svar privat på indlæg';
$string['forum:postwithoutthrottling'] = 'Undtaget fra indlægsgrænse';
$string['forum:rate'] = 'Vurder indlæg';
$string['forum:readprivatereplies'] = 'Vis private svar';
$string['forum:replynews'] = 'Svar på meddelelser';
$string['forum:replypost'] = 'Svar indlæg';
$string['forum:splitdiscussions'] = 'Split diskussionen i to tråde';
$string['forum:startdiscussion'] = 'Start en ny tråd';
$string['forum:viewallratings'] = 'Vis alle bedømmelser givet af enkeltpersoner';
$string['forum:viewanyrating'] = 'Vis enhver vurdering';
$string['forum:viewdiscussion'] = 'Vis tråde';
$string['forum:viewhiddentimedposts'] = 'Vis skjulte timede indlæg';
$string['forum:viewqandawithoutposting'] = 'Se altid spørgsmål og svar-indlæg';
$string['forum:viewrating'] = 'Vis de vurderinger, du har modtaget';
$string['forum:viewsubscribers'] = 'Vis abonnenter';
$string['forumauthorhidden'] = 'Forfatter (skjult)';
$string['forumblockingalmosttoomanyposts'] = 'Du nærmer dig begrænsningen på indlæg. Du har skrevet {$a->numposts} indlæg indenfor {$a->blockperiod}, og for at undgå spam er begrænsningen {$a->blockafter} indlæg.';
$string['forumbodydeleted'] = 'Dette forumindlæg er fjernet og indholdet er ikke længere tilgængeligt.';
$string['forumbodyhidden'] = 'Dette indlæg er i øjeblikket skjult, sandsynligvis fordi du først skal skrive i tråden og der skal sendes meddelelser om forumindlæg. En anden mulighed er, at det aktuelle tidspunkt ikke ligger inden for den visningsperiode, der er fastlagt for indlægget.';
$string['forumgrader'] = 'Forums bedømmer';
$string['forumgradingnavigation'] = 'Navigation til bedømmelse af forummet';
$string['forumgradingpanel'] = 'Bedømmelsespanel for forum';
$string['forumintro'] = 'Beskrivelse';
$string['forumname'] = 'Forumnavn';
$string['forumposts'] = 'Forumindlæg';
$string['forums'] = 'Fora';
$string['forumsubjectdeleted'] = 'Dette forumindlæg er fjernet.';
$string['forumsubjecthidden'] = 'Emne (skjult)';
$string['forumtracked'] = 'Ulæste indlæg markeres';
$string['forumtrackednot'] = 'Ulæste indlæg markeres ikke';
$string['forumtype'] = 'Forumtype';
$string['forumtype_help'] = 'Der findes 5 forumtyper:

* Én enkelt tråd - Slet og ret et enkelt emne i en tråd, som alle kan skrive i. (kan ikke bruges med separate grupper)
* Hver person skriver én diskussion - Hver studerende kan skrive præcis ét nyt diskussionsemne, som alle kan svare på.
* Spørgsmål og svar-forum - En studerende skal først skrive et svar på et spørgsmål, som læreren har stillet, før han/hun kan se de øvriges indlæg.
* Standardforum, der vises i et bloglignende format - Et åbent forum hvor alle når som helst kan starte en ny tråd og hvor hvert emne vises på en side med link til "Besvar dette emne".
* Standardforum til almindelig brug - Et åbent forum, hvor alle når som helst kan starte en ny tråd';
$string['generalforum'] = 'Standardforum til almindeligt brug';
$string['generalforums'] = 'Generelle fora';
$string['grade_forum_header'] = 'Bedømmelse af hele forummet';
$string['grade_forum_name'] = 'Hele forummet';
$string['grade_forum_title'] = 'Karakter';
$string['grade_rating_name'] = 'Vurdering';
$string['graded'] = 'Givet karakter';
$string['gradedby'] = 'Vurderet af';
$string['gradeforrating'] = 'Karakter for vurdering: {$a->str_long_grade}';
$string['gradeforratinghidden'] = 'Karakter for vurdering skjult';
$string['gradeforwholeforum'] = 'Karakter forum: {$a->str_long_grade}';
$string['gradeforwholeforumhidden'] = 'Karakter for forum skjult';
$string['gradeitem:forum'] = 'Forum';
$string['gradeitemnameforrating'] = '{$a->name} vurdering';
$string['gradeitemnameforwholeforum'] = '{$a->name} hele forum';
$string['grades:gradesavedfor'] = 'Karakter gemt for {$a->fullname}';
$string['grades:gradesavefailed'] = 'Kunne ikke gemme karakteren for {$a->fullname}: {$a->error}';
$string['gradeusers'] = 'Giv brugere karakterer';
$string['grading'] = 'Giver karakter';
$string['gradingstatus'] = 'Karakterstatus:';
$string['hiddenforumpost'] = 'Skjult indlæg i forum';
$string['hidegraderpanel'] = 'Skjul karaktergivningspanel';
$string['hidepreviousrepliescount'] = 'Skjul foregående svar ({$a})';
$string['hideusersearch'] = 'Skjul brugersøgning';
$string['indexoutoftotal'] = '{$a->index} ud af {$a->total}';
$string['indicator:cognitivedepth'] = 'Kognitivt forum';
$string['indicator:cognitivedepth_help'] = 'Denne indikator er baseret på den kognitive dybde, som eleven har opnået i en forumaktivitet.';
$string['indicator:cognitivedepthdef'] = 'Kognitivt forum';
$string['indicator:cognitivedepthdef_help'] = 'Deltageren har opnået denne procentdel af den kognitive engagement, som forumaktiviteterne tilbyder i løbet af denne analyseperiode (Niveauer = Ingen visning, Visning, Indsend, Vis feedback, Kommenter på feedback, Indsend igen efter at have set feedback).';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Socialt forum';
$string['indicator:socialbreadth_help'] = 'Denne indikator er baseret på den sociale rækkevidde, som eleven har opnået i en forumaktivitet.';
$string['indicator:socialbreadthdef'] = 'Socialt forum';
$string['indicator:socialbreadthdef_help'] = 'Deltageren har opnået denne procentdel af den sociale engagement, som forumaktiviteterne tilbyder i løbet af denne analyseperiode (Niveauer = Ingen deltagelse, Deltager alene, Deltager med andre).';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['inforum'] = 'i {$a}';
$string['inreplyto'] = 'I svar til {$a}';
$string['introblog'] = 'Indlæggene i dette forum blev automatisk kopieret fra blogs tilhørende brugere på dette kursus, fordi blogindlæggene ikke længere er tilgængelige.';
$string['intronews'] = 'Nyheder og meddelelser';
$string['introsocial'] = 'Et åbent forum til samtale om hvad du synes.';
$string['introteacher'] = 'Et forum kun for lærernoter og -diskussioner';
$string['invalidaccess'] = 'Denne side blev ikke indlæst korrekt';
$string['invaliddigestsetting'] = 'Der blev opgivet en ugyldig indstilling for mailsammendrag';
$string['invaliddiscussionid'] = 'Diskussios-id var forkert eller eksisterer ikke længere';
$string['invalidforcesubscribe'] = 'Ugyldig tilstand af tvungen abonnement';
$string['invalidforumid'] = 'Forum-id var forkert';
$string['invalidparentpostid'] = 'Id på foregående indlæg var forkert';
$string['invalidpostid'] = 'Ugyldig indlægs-id - {$a}';
$string['lastpost'] = 'Seneste indlæg';
$string['learningforums'] = 'Undervisningsfora';
$string['lockdiscussion'] = 'Lås denne tråd for nye indlæg';
$string['lockdiscussionafter'] = 'Lås tråde efter en periode med inaktivitet';
$string['lockdiscussionafter_help'] = 'Tråde kan låses automatisk efter en angivet periode siden sidste svar. Brugere med rettighed til at svare på låste tråde kan åbne diskussionen ved at svare på den';
$string['locked'] = 'Låst';
$string['lockupdated'] = 'Låsemuligheden er opdateret';
$string['longpost'] = 'Langt indlæg';
$string['mailnow'] = 'Send mail nu uden at vente på forsinkelse på grund af  redigeringstiden.';
$string['managesubscriptionsoff'] = 'Afslut abonnementshåndtering';
$string['managesubscriptionson'] = 'Håndter abonnenter';
$string['manydiscussions'] = 'Antal tråde pr. side';
$string['markalldread'] = 'Marker alle indlæg i denne tråd som læste';
$string['markallread'] = 'Marker alle indlæg som læste';
$string['markasread'] = 'Marker som læst';
$string['markasreadonnotification'] = 'Ved udsendelse af underretninger om forumindlæg';
$string['markasreadonnotification_help'] = 'Når du får underretning om et nyt forumindlæg, kan du her vælge om det i sporingen af læste/ulæste indlæg skal markeres som læst.';
$string['markasreadonnotificationno'] = 'Marker ikke indlægget som læst';
$string['markasreadonnotificationyes'] = 'Marker indlægget som læst';
$string['markread'] = 'Marker som læst';
$string['markreadbutton'] = 'Marker som<br />læst';
$string['markunread'] = 'Marker som ulæst';
$string['markunreadbutton'] = 'Marker som<br />ulæst';
$string['maxattachments'] = 'Højeste antal bilag';
$string['maxattachments_help'] = 'Her sættes det maksimale antal bilag der der kan vedhæftes et forumindlæg.';
$string['maxattachmentsize'] = 'Maksimal filstørrelse der kan vedhæftes';
$string['maxattachmentsize_help'] = 'Her styres den maksimale filstørrelse der kan vedhæftes et forumindlæg.';
$string['maxtimehaspassed'] = 'Beklager, men tiden er gået ({$a}) og du kan ikke redigere i indlægget mere!';
$string['message'] = 'Meddelelse';
$string['messageinboundattachmentdisallowed'] = 'Dit indlæg blev ikke gemt da det indeholder bilag og forummet kan ikke modtage bilag.';
$string['messageinboundfilecountexceeded'] = 'Dit indlæg blev ikke gemt da det indeholder for mange bilag, højeste tilladte antal er ({$a->forum->maxattachments}).';
$string['messageinboundfilesizeexceeded'] = 'Dit indlæg blev ikke gemt da den samlede størrelse på bilag ({$a->filesize}) er større end den, der er tilladt for forummet ({$a->maxbytes}).';
$string['messageinboundforumhidden'] = 'Kunne ikke gemme dit svar, da forummet pt. ikke er tilgængeligt.';
$string['messageinboundnopostforum'] = 'Kunne ikke gemme dit svar, da du ikke har tilladelse til at skrive indlæg i forummet {$a->forum->name}.';
$string['messageinboundthresholdhit'] = 'Kan ikke sende dit svar. Du har overskredet den posteringsgrænse, der er angivet for dette forum';
$string['messageprovider:digests'] = 'Forumsammendrag med abbonnement';
$string['messageprovider:posts'] = 'Forumindlæg med abonnement';
$string['missingsearchterms'] = 'Den følgende søgning foregår kun i HTML-versionen af denne besked:';
$string['modeflatnewestfirst'] = 'Kronologisk visning med seneste indlæg først';
$string['modeflatoldestfirst'] = 'Kronologisk visning med første indlæg først';
$string['modenested'] = 'Trådet visning, udfoldet';
$string['modenestedv2'] = 'Vis svar i eksperimenterende forgrenet form';
$string['modethreaded'] = 'Trådet visning, sammenfoldet';
$string['modulename'] = 'Forum';
$string['modulename_help'] = 'Forummodulet giver mulighed for at deltagerne kan have asynkrone samtaler, dvs. samtaler, der finder sted over et langt tidsinterval.

Der er forskellige forumtyper at vælge imellem, som f.eks. et standardforum, hvor alle når som helst kan starte en ny tråd, et forum hvor hver studerende kan oprette nøjagtig én tråd, eller et spørgsmål og svar-forum, hvor de studerende først skal skrive et indlæg inden de kan se andre studerendes indlæg. En lærer kan tillade at der vedhæftes filer til forumindlæg. Vedhæftede billeder vises i indlægget.

Deltagere kan abonnere på et forum for at få besked når der er nye indlæg. En lærer kan gøre abonnement valgfrit, tvunget eller automatisk eller fuldstændig forhindre abonnement. Hvis det er påkrævet, kan studerende forhindres i at oprette mere end et givet antal indlæg inden for et vist tidsrum. Dette kan forhindre at nogen dominerer en tråd.

Forumindlæg kan bedømmes af lærere eller studerende (sidemandsevaluering). Bedømmelser kan lægges sammen til en endelig karakter, som gemmes i karakterbogen.

Fora bruges til mange funktioner, som f.eks.:

* Et socialt sted, hvor studerende kan lære hinanden at kende
* Til meddelelser på kurser (brug et nyhedsforum med tvunget abonnement)
* Til at diskutere indhold i kurser eller læsestof
* Til at fortsætte en diskussion/et emne, der er startet tidligere i en konfrontationstime
* Til diskussioner mellem lærere (brug et skjult forum)
* Et vejledningscenter, hvor vejledere og studerende kan give råd
* Et en til en-hjælpeområde, hvor studerende og lærer kan kommunikere privat (brug et forum med separate grupper og en studerende pr. gruppe)
* Til ekstraopgaver, f.eks. \'hjernevridere\', som de studerende kan fundere over og komme med løsningsforslag til';
$string['modulename_link'] = 'mod/forum/view';
$string['modulenameplural'] = 'Fora';
$string['more'] = 'mere';
$string['movedmarker'] = '(Flyttet)';
$string['movethisdiscussionlabel'] = 'Flyt den aktuelle tråd til det angivne forum';
$string['movethisdiscussionto'] = 'Flyt diskussionen til...';
$string['mustprovidediscussionorpost'] = 'Du skal angive enten en diskussions-id eller indlægs-id til eksport';
$string['myprofileotherdis'] = 'Forumtråde';
$string['myprofileowndis'] = 'Mine forumtråde';
$string['myprofileownpost'] = 'Mine forumindlæg';
$string['namenews'] = 'Meddelelser';
$string['namenews_help'] = 'Meddelelsesforummet er et specielt forum til meddelelser og bekendtgørelser, som automatisk oprettes samtidig med kursets oprettelse. Der kan være ét meddelelsesforum på hvert kursus. Kun lærere og administratorer kan skrive meddelelser. Blokken "Seneste meddelelser" viser de nyeste indlæg i dette forum.';
$string['namesocial'] = 'Socialt forum';
$string['nameteacher'] = 'Lærerforum';
$string['newforumposts'] = 'Nyt indlæg';
$string['nextdiscussiona'] = 'Næste tråd: {$a}';
$string['nextuser'] = 'Gem ændringerne og fortsæt til næste bruger';
$string['noattachments'] = 'Der er ingen bilag til dette indlæg';
$string['nodiscussions'] = 'Der er endnu ingen diskussionsemner i dette forum';
$string['nodiscussionsstartedby'] = 'Denne bruger har ikke oprettet nogen tråde';
$string['nodiscussionsstartedbyyou'] = 'Du har ikke startet nogen diskussioner endnu';
$string['noguestpost'] = 'Kun brugere, der er logget ind, kan skrive i dette forum.';
$string['noguestpost:title'] = 'Log ind for at fortsætte';
$string['noguestsubscribe'] = 'Beklager, men gæster kan ikke abonnere.';
$string['noguesttracking'] = 'Desværre, gæster kan ikke ændre indstillingerne.';
$string['nomorepostscontaining'] = 'Der blev ikke fundet flere indlæg indeholdende "{$a}"';
$string['nonews'] = 'Endnu ingen meddelelser';
$string['noonecansubscribenow'] = 'Abonnement er nu ikke tilladt';
$string['nopermissiontosubscribe'] = 'Du har ikke tilladelse til at se forumabonnenter';
$string['nopermissiontoview'] = 'Du har ikke tilladelse til at læse dette indlæg';
$string['nopostforum'] = 'Du har ikke tilladelse til at skrive i dette forum';
$string['noposts'] = 'Ingen indlæg';
$string['nopostsmadebyuser'] = '{$a} har ikke skrevet nogen forumindlæg';
$string['nopostsmadebyyou'] = 'Du har ikke skrevet nogen indlæg';
$string['noquestions'] = 'Der er endnu ingen spørgsmål i dette forum';
$string['nosubscribers'] = 'Der er endnu ingen abonnenter for dette forum';
$string['notexists'] = 'Tråden eksisterer ikke længere';
$string['notgraded'] = 'Ikke vurderet';
$string['nothingnew'] = 'Intet nyt for {$a}';
$string['notingroup'] = 'Du skal være medlem af en gruppe for at kunne se dette forum';
$string['notinstalled'] = 'Forummodulet er ikke installeret';
$string['notlocked'] = 'Lås';
$string['notpartofdiscussion'] = 'Dette indlæg er ikke en del af en tråd!';
$string['notrackforum'] = 'Marker ikke ulæste indlæg';
$string['notsubscribed'] = 'Abonner';
$string['nousersmatch'] = 'Ingen bruger(e) fundet med disse kriterier';
$string['noviewdiscussionspermission'] = 'Du har ikke tilladelse til at se diskussioner i dette forum';
$string['nowallsubscribed'] = 'Du abonnerer nu på alle fora i {$a}.';
$string['nowallunsubscribed'] = 'Dine abonnementer på fora i {$a} er nu stoppet.';
$string['nowgradinguser'] = 'Bedømmer nu {$a}';
$string['nownotsubscribed'] = '{$a->name} vil IKKE få besked om nye indlæg i "{$a->forum}".';
$string['nownottracking'] = '{$a->name} får ikke markeret nye og ulæste indlæg i "{$a->forum}".';
$string['nowsubscribed'] = 'Du vil få besked om nye indlæg i "{$a->forum}".';
$string['nowtracking'] = '{$a->name} får markeret nye og ulæste indlæg i "{$a->forum}".';
$string['numberofreplies'] = 'Antal besvarelser: {$a}';
$string['numposts'] = '{$a} indlæg';
$string['olderdiscussions'] = 'Ældre diskussioner';
$string['oldertopics'] = 'Ældre emner';
$string['oldpostdays'] = 'Læst efter antal dage';
$string['page-mod-forum-discuss'] = 'Side for forummodulets diskussionstråd';
$string['page-mod-forum-view'] = 'Hovedside for forummodul';
$string['page-mod-forum-x'] = 'En hvilken som helst forummodul-side';
$string['parent'] = 'Vis oprindeligt indlæg';
$string['parentofthispost'] = 'Forudgående indlæg';
$string['permalink'] = 'Permalink';
$string['permanentlinktoparentpost'] = 'Permanent link til dette indlægs forældre';
$string['permanentlinktopost'] = 'Permanent link til dette indlæg';
$string['pindiscussion'] = 'Fastgør denne tråd';
$string['pinupdated'] = 'Fastgøringsindstillingen er opdateret';
$string['pluginadministration'] = 'Forumadministration';
$string['pluginname'] = 'Forum';
$string['postadded'] = '<p>Dit indlæg er tilføjet.</p><p>Du har {$a} til at redigere i det, hvis du vil ændre noget.</p>';
$string['postaddedsuccess'] = 'Dit indlæg er tilføjet.';
$string['postaddedtimeleft'] = 'Du har {$a} til at redigere i det, hvis du vil ændre noget.';
$string['postbymailsuccess'] = 'Dit forumindlæg "{$a->subject}"  er sendt til: {$a->discussionurl}.';
$string['postbymailsuccess_html'] = 'Dit svar på forumindlægget <a href="{$a->discussionurl}">{$a->subject}</a> er oprettet.';
$string['postbyuser'] = '{$a->post} af {$a->user}';
$string['postincontext'] = 'Se dette indlægs indhold';
$string['postisprivatereply'] = 'Dette er et privat svar. (Lærere og andre brugere med rettighed til at se private svar, kan også se det.)';
$string['postmailinfo'] = 'Dette er en kopi af en meddelelse sendt til {$a}.';
$string['postmailnow'] = '<p>Dette indlæg vil blive mailet med det samme til alle der abonnerer på forummet.</p>';
$string['postmailreply'] = 'Klik på dette link for at svare: {$a}';
$string['postmailsubject'] = '{$a->courseshortname}: {$a->subject}';
$string['posts'] = 'Indlæg';
$string['postsfrom'] = 'Indlæg fra';
$string['postsmadebyuser'] = 'Forumindlæg af {$a}';
$string['postsmadebyuserincourse'] = 'Indlæg fra {$a->fullname} i {$a->coursename}';
$string['postsmadeincourse'] = 'Indlæg foretaget i {$a}';
$string['poststo'] = 'Indlæg til';
$string['posttoforum'] = 'Send til forum';
$string['posttomygroups'] = 'Send til alle grupper';
$string['posttomygroups_help'] = 'Send denne meddelelse til alle de grupper, du har adgang til. Deltagere i grupper, du ikke har adgang til, vil ikke se dette indlæg';
$string['postupdated'] = 'Dit indlæg er opdateret';
$string['potentialsubscribers'] = 'Potentielle abonnenter';
$string['prevdiscussiona'] = 'Tidligere tråd: {$a}';
$string['previoususer'] = 'Gem ændringerne og fortsæt med forrige bruger';
$string['privacy:digesttypenone'] = 'Vi gemmer ikke data om foretrukket type sammendrag for dette forum.';
$string['privacy:digesttypepreference'] = 'Du har valg at modtage denne type sammendrag for forummet: "{$a->type}".';
$string['privacy:discussionsubscriptionpreference'] = 'Dit valg for abonnement på indlæg i dette forum: "{$a->preference}"';
$string['privacy:metadata:core_rating'] = 'Forummet bruger et vurderingssystem til vurdering af indlæg.';
$string['privacy:metadata:core_tag'] = 'Forummet bruger tag-systemet så indlæg kan tagges.';
$string['privacy:metadata:forum_digests'] = 'Information om indstillinger for sammendrag til hvert forum.';
$string['privacy:metadata:forum_digests:forum'] = 'Det forum der abonneres på.';
$string['privacy:metadata:forum_digests:maildigest'] = 'Indstilling for sammendrag.';
$string['privacy:metadata:forum_digests:userid'] = 'Id for brugeren med sammendragsindstillingen.';
$string['privacy:metadata:forum_discussion_subs'] = 'Information om abonnementer på de enkelte forumtråde';
$string['privacy:metadata:forum_discussion_subs:discussionid'] = 'Id på tråden der blev oprettet abonnement på.';
$string['privacy:metadata:forum_discussion_subs:preference'] = 'Hvornår abonnementet begyndte.';
$string['privacy:metadata:forum_discussion_subs:userid'] = 'Id på brugeren med abonnement på tråden.';
$string['privacy:metadata:forum_discussions'] = 'Information om de enkelte forumtråde brugeren har oprettet';
$string['privacy:metadata:forum_discussions:assessed'] = 'TODOD - hvad dette felt gemmer';
$string['privacy:metadata:forum_discussions:name'] = 'Navn på tråden, som valgt af forfatteren.';
$string['privacy:metadata:forum_discussions:timemodified'] = 'Hvornår tråden blev redigeret.';
$string['privacy:metadata:forum_discussions:userid'] = 'Id på den bruger der oprettede tråden';
$string['privacy:metadata:forum_discussions:usermodified'] = 'Id på den bruger der redigerede tråden på en eller anden måde.';
$string['privacy:metadata:forum_grades'] = 'Karakterdata for forummet';
$string['privacy:metadata:forum_grades:forum'] = 'Forummet, der blev bedømt';
$string['privacy:metadata:forum_grades:grade'] = 'Den tildelte karakter';
$string['privacy:metadata:forum_grades:userid'] = 'Brugeren, der blev bedømt';
$string['privacy:metadata:forum_posts'] = 'Information om sammendragsvalg for hvert forum.';
$string['privacy:metadata:forum_posts:created'] = 'Hvornår indlægget blev oprettet.';
$string['privacy:metadata:forum_posts:discussion'] = 'Tråden indlægget blev oprettet i.';
$string['privacy:metadata:forum_posts:message'] = 'Indhold i forumindlægget.';
$string['privacy:metadata:forum_posts:modified'] = 'Hvornår indlægget blev redigeret.';
$string['privacy:metadata:forum_posts:parent'] = 'Det indlæg der blev svaret på.';
$string['privacy:metadata:forum_posts:privatereplyto'] = 'Id på den bruger denne besvarelse blev sendt til';
$string['privacy:metadata:forum_posts:subject'] = 'Forumindlæggets emne.';
$string['privacy:metadata:forum_posts:totalscore'] = 'Indhold i forumindlægget.';
$string['privacy:metadata:forum_posts:userid'] = 'Bruger-id for forfatteren til dette indlæg.';
$string['privacy:metadata:forum_queue'] = 'Midlertidig log for indlæg der vil blive mailet som sammendrag.';
$string['privacy:metadata:forum_queue:discussionid'] = 'Id for forumtråd';
$string['privacy:metadata:forum_queue:postid'] = 'Id for forumindlæg';
$string['privacy:metadata:forum_queue:timemodified'] = 'Ændringstid for det originale indlæg';
$string['privacy:metadata:forum_queue:userid'] = 'Bruger der skal underrettes om indlægget';
$string['privacy:metadata:forum_read'] = 'Information om hvilke indlæg brugeren har læst.';
$string['privacy:metadata:forum_read:discussionid'] = 'Tråden indlægget er skrevet i.';
$string['privacy:metadata:forum_read:firstread'] = 'Første gang indlægget blev læst.';
$string['privacy:metadata:forum_read:lastread'] = 'Hvornår indlægget sidst blev læst.';
$string['privacy:metadata:forum_read:postid'] = 'Indlægget der blev læst.';
$string['privacy:metadata:forum_read:userid'] = 'Bruger-id posten er relateret til';
$string['privacy:metadata:forum_subscriptions'] = 'Information om hvilke fora brugeren abonnerer på.';
$string['privacy:metadata:forum_subscriptions:forum'] = 'Forummet der var oprettet abonnement på.';
$string['privacy:metadata:forum_subscriptions:userid'] = 'Id for den bruger forumabonnementet tilhører.';
$string['privacy:metadata:forum_track_prefs'] = 'Information om hvilke fora brugeren har valgt at holde øje med læste indlæg i.';
$string['privacy:metadata:forum_track_prefs:forumid'] = 'Forummet der har sporing af læst aktiveret.';
$string['privacy:metadata:forum_track_prefs:userid'] = 'Id på den bruger denne sporingsindstilling relaterer til.';
$string['privacy:metadata:preference:autosubscribe'] = 'Hvorvidt abonnement på tråd aktiveres ved svar på indlæg i den.';
$string['privacy:metadata:preference:forum_discussionlistsortorder'] = 'Den foretrukne sorteringsrækkefølge for diskussionslisten';
$string['privacy:metadata:preference:maildigest'] = 'Webstedets indstillinger for mail-sammendrag';
$string['privacy:metadata:preference:markasreadonnotification'] = 'Hvorvidt forumindlæg markeres som læste når de modtages som beskeder.';
$string['privacy:metadata:preference:trackforums'] = 'Hvorvidt sporing af læste indlæg skal aktiveres.';
$string['privacy:postwasread'] = 'Dette indlæg blev første gang læst {$a->firstread} og sidst læst {$a->lastread}';
$string['privacy:readtrackingdisabled'] = 'Du har valgt ikke at spore hvilke indlæg du har læst i dette forum.';
$string['privacy:request:delete:discussion:name'] = 'Slet efter ønske fra forfatteren';
$string['privacy:request:delete:post:message'] = 'Indholdet i dette indlæg er slettet efter ønske fra forfatteren.';
$string['privacy:request:delete:post:subject'] = 'Slet efter ønske fra forfatteren';
$string['privacy:subscribedtoforum'] = 'Du abonnerer på dette forum.';
$string['privatereply'] = 'Svar privat';
$string['privatereply_help'] = 'Når du svarer privat, er dit indlæg også synligt for brugere med rettighed til at se private svar, f.eks. lærere';
$string['processingdigest'] = 'Behandler e-mailsammendrag for bruger {$a}';
$string['processingpost'] = 'Behandler indlægget {$a}';
$string['prune'] = 'Split';
$string['prunediscussion'] = 'Opdel diskussion';
$string['prunedpost'] = 'En ny diskussion er blevet oprettet efter dette indlæg.';
$string['pruneheading'] = 'Del diskussionen i to og lad den nye tråd starte med dette indlæg.';
$string['qandaforum'] = 'Spørgsmål og svar-forum';
$string['qandanotify'] = 'Dette er et spørgsmål-og-svar forum. For at se andres svar til dette spørgsmål skal du selv først skrive dit svar.';
$string['re'] = 'Ang:';
$string['readtherest'] = 'Læs resten af dette emne';
$string['removeallforumtags'] = 'Alle forumtags';
$string['removefromfavourites'] = 'Fjern stjernen fra denne tråd';
$string['replies'] = 'Svar';
$string['repliesmany'] = '{$a} svar indtil videre';
$string['repliesone'] = '{$a} svar indtil videre';
$string['reply'] = 'Besvar';
$string['reply_handler'] = 'Svar på forumindlæg via e-mail';
$string['reply_handler_name'] = 'Svar på forumindlæg';
$string['replyauthorself'] = '{$a} (dig)';
$string['replyforum'] = 'Svar til forum';
$string['replyingtoauthor'] = 'Svarer {$a}...';
$string['replyplaceholder'] = 'Skriv dit svar...';
$string['replypostdiscussion'] = 'Svar på diskussion';
$string['replytopostbyemail'] = 'Du kan svare på dette via e-mail.';
$string['replytouser'] = 'Brug e-mailadresse i svaret';
$string['resetdigests'] = 'Alle brugerbaserede forum-digest-præferencer';
$string['resetforums'] = 'Fjern indlæg fra';
$string['resetforumsall'] = 'Alle indlæg';
$string['resetsubscriptions'] = 'Alle forum abonnenter';
$string['resettrackprefs'] = 'Alle forumsporing-præferencer';
$string['rssarticles'] = 'Antal seneste RSS-nyheder';
$string['rssarticles_help'] = 'Denne indstilling angiver hvor mange tråde/indlæg der skal med i RSS-feedet. Et tal mellem 5 og 20 vil generelt være passende.';
$string['rsssubscriberssdiscussions'] = 'Vis RSS-feed for tråde';
$string['rsssubscriberssposts'] = 'Vis RSS-feed for indlæg';
$string['rsstype'] = 'RSS-feed til denne aktivitet';
$string['rsstype_help'] = 'Aktivering af RSS-feed for denne aktivitet kræver at du vælger enten tråde eller indlæg til feedet.';
$string['rsstypedefault'] = 'RSS-feedtype';
$string['search'] = 'Søg';
$string['search:activity'] = 'Forum - aktivitetsinformation';
$string['search:post'] = 'Forum - indlæg';
$string['searchdatefrom'] = 'Indlæg skal være nyere end dette';
$string['searchdateto'] = 'Indlæg skal være ældre end dette';
$string['searchforumintro'] = 'Skriv søgeordene i en eller flere af de følgene felter:';
$string['searchforums'] = 'Søg i fora';
$string['searchfullwords'] = 'Disse ord skal forekomme som hele ord';
$string['searchnotwords'] = 'Disse ord må IKKE forekomme';
$string['searcholderposts'] = 'Søg i gamle indlæg';
$string['searchphrase'] = 'Den præcise sætning skal forekomme i indlægget';
$string['searchresults'] = 'Søgeresultater';
$string['searchsubject'] = 'Disse ord skal forekomme i emnet';
$string['searchtags'] = 'Er tagget med';
$string['searchuser'] = 'Forfatterens navn';
$string['searchuserid'] = 'Forfatterens Moodle-id';
$string['searchusers'] = 'Søg brugere';
$string['searchwhichforums'] = 'Vælg hvilke fora der skal søges i';
$string['searchwords'] = 'Disse ord kan forekomme alle steder i teksten';
$string['seeallposts'] = 'Se alle indlæg fra denne bruger';
$string['sendstudentnotificationsdefault'] = 'Standardindstilling til "Underret studerende"';
$string['sendstudentnotificationsdefault_help'] = 'Sæt standardværdien for tjekboksen "Underret studerende" i karakterformularen.';
$string['sendstudentnotificationsno'] = 'Nej';
$string['sendstudentnotificationsyes'] = 'Ja, send underretning til den studerende';
$string['settings'] = 'Indstillinger';
$string['shortpost'] = 'Kort indlæg';
$string['showgraderpanel'] = 'Vis karaktergivningspanel';
$string['showingcountoftotaldiscussions'] = 'Liste med samtaleemner. Viser {$a->count} af {$a->total} tråde';
$string['showmoreusers'] = 'Vis flere brugere';
$string['showpreviousrepliescount'] = 'Vis forrige svar ({$a})';
$string['showsubscribers'] = 'Vis/administrer abonnenter';
$string['showusersearch'] = 'Vis brugersøgning';
$string['singleforum'] = 'Én enkelt tråd';
$string['smallmessage'] = '{$a->user} skrev i {$a->forumname}';
$string['smallmessagedigest'] = 'Forumsammendrag med {$a} indlæg';
$string['starredonly'] = 'Søg kun i stjernemarkerede tråde';
$string['startedby'] = 'Startet af';
$string['subject'] = 'Emne';
$string['subplugintype_forumreport'] = 'Forumrapport';
$string['subplugintype_forumreport_plural'] = 'Forumrapporter';
$string['subscribe'] = 'Abonner på dette forum';
$string['subscribeall'] = 'Sæt alle som abonnenter';
$string['subscribed'] = 'Abonnement oprettet';
$string['subscribediscussion'] = 'Abonner på denne tråd';
$string['subscribeenrolledonly'] = 'Beklager, kun tilmeldte brugere kan abonnere på forumindlæg.';
$string['subscribenone'] = 'Frameld alles abonnement';
$string['subscribers'] = 'Abonnenter';
$string['subscriberstowithcount'] = 'Abonnenter på "{$a->name}" ({$a->count})';
$string['subscribestart'] = 'Send mig besked om nye indlæg i dette forum';
$string['subscribestop'] = 'Jeg ønsker ikke at blive underrettet om nye indlæg i dette forum';
$string['subscription'] = 'Abonnement';
$string['subscription_help'] = 'Når man er abonnent på et forum, betyder det, at man bliver underrettet om nye indlæg i forummet. Man kan normalt selv bestemme, om man vil abonnere på et forum, selv om der vil være tilfælde, hvor alle automatisk står som abonnenter og således bliver underrettet om forumindlæg.';
$string['subscriptionandtracking'] = 'Abonnement og sporing';
$string['subscriptionauto'] = 'Auto-abonnement';
$string['subscriptiondisabled'] = 'Abonnement deaktiveret';
$string['subscriptionforced'] = 'Tvungen abonnement';
$string['subscriptionmode'] = 'Abonnementstilstand';
$string['subscriptionmode_help'] = 'Når man er abonnent på et forum betyder det at man bliver underrettet når der er nye indlæg i forummet. Der er 4 abonnementsmuligheder:

* Valgfrit abonnement - Deltagerne kan selv vælge, om de vil abonnere.
* Tvunget abonnement - Alle abonnerer og kan ikke afmelde abonnementet * Automatisk abonnement - Alle abonnerer automatisk fra start, men kan til enhver tid framelde det.
* Abonnement deaktiveret - Abonnement er ikke tilladt.';
$string['subscriptionmodeconfirm'] = 'Er du sikker på, at du vil ændre abonnementstilstanden til {$a}?';
$string['subscriptionoptional'] = 'Frivilligt abonnement';
$string['subscriptions'] = 'Abonnementer';
$string['tagarea_forum_posts'] = 'Forumindlæg';
$string['tagsdeleted'] = 'Forumtags er slettet';
$string['thisforumhasduedate'] = 'Indlæg til dette forum skal være sendt {$a}.';
$string['thisforumisdue'] = 'Indlæg til dette forum skulle være sendt {$a}.';
$string['thisforumisthrottled'] = 'Dette forum har en begrænsning på hvor mange indlæg du kan skrive indenfor en vis periode. Denne begrænsning er p.t. sat til at tillade {$a->blockafter} indlæg på {$a->blockperiod}';
$string['timed'] = 'Timet';
$string['timeddiscussion'] = 'Timet diskussion';
$string['timedhidden'] = 'Timet status: Skjult for de studerende';
$string['timedposts'] = 'Timede indlæg';
$string['timedvisible'] = 'Timet status: Synlig for alle brugere';
$string['timestartenderror'] = 'Afslutningen på visningen kan ikke være tidligere end starten af visningen.';
$string['togglediscussionmenu'] = 'Slå trådmenuen til/fra';
$string['togglefullscreen'] = 'Fuld skærm til/fra';
$string['togglesettingsdrawer'] = 'Åbn/luk indstillingsskuffen';
$string['trackforum'] = 'Marker ulæste indlæg';
$string['tracking'] = 'Marker';
$string['trackingoff'] = 'Deaktiveret';
$string['trackingon'] = 'Tvunget';
$string['trackingoptional'] = 'Valgfrit';
$string['trackingtype'] = 'Oplys om ulæste indlæg?';
$string['trackingtype_help'] = 'Med læsesporing kan deltagerne tjekke, hvilke indlæg de endnu ikke har set, ved at fremhæve nye indlæg.

Hvis den er indstillet til valgfri, kan deltagerne vælge, om de vil slå sporing til eller fra for forummet. (Brugerne skal også aktivere forumsporing i deres forumindstillinger).

Hvis "Tillad tvungen sporing af ulæste indlæg" er aktiveret af en webstedsadministrator, er der endnu en valgmulighed - tvungen. Det betyder, at sporing altid er aktiveret, uanset brugernes forumindstillinger.';
$string['trackreadposts_header'] = 'Forumsporing';
$string['unlockdiscussion'] = 'Lås denne tråd op';
$string['unpindiscussion'] = 'Frigør denne tråd';
$string['unread'] = 'Ikke læst';
$string['unreadpost'] = 'Ulæst indlæg';
$string['unreadposts'] = 'Nye indlæg';
$string['unreadpostsnumber'] = '{$a} nye indlæg';
$string['unreadpostsone'] = '1 nyt indlæg';
$string['unsubscribe'] = 'Stop dit abonnement&nbsp;';
$string['unsubscribeall'] = 'Fjern alle abonnementer på fora';
$string['unsubscribeallconfirm'] = 'Du abonnerer på {$a} fora og {$a->discussions} tråde. Bekræft at du vil stoppe med det og deaktivere auto-abonnement.';
$string['unsubscribeallconfirmdiscussions'] = 'Du abonnerer på {$a->discussions}  tråde. Bekræft at du vil framelde abonnement på alle tråde og deaktivere auto-abonnement på tråde.';
$string['unsubscribeallconfirmforums'] = 'Du abonnerer på {$a->forums} fora. Bekræft at du vil framelde abonnement på alle fora og at du vil deaktivere auto-abonnement på tråde.';
$string['unsubscribealldone'] = 'Alle dine abonnementer på fora er slettet. Det kan dog godt være at du stadig modtager beskeder fra fora med tvunget abonnement. Du kan administrere underretninger under indstillinger i din profil.';
$string['unsubscribeallempty'] = 'Beklager, du abonnerer ikke på nogen fora. Du kan administrere underretninger under din profil.';
$string['unsubscribed'] = 'Abonnement frameldt';
$string['unsubscribediscussion'] = 'Stop abonnementet på denne tråd&nbsp;';
$string['unsubscribediscussionlink'] = 'Frameld abonnement på denne tråd: {$a}';
$string['unsubscribelink'] = 'Frameld abonnement på dette forum: {$a}';
$string['unsubscribeshort'] = 'Frameld abonnement';
$string['useexperimentalui'] = 'Brug eksperimentel grenet visning';
$string['usermarksread'] = 'Manuel markering af læste indlæg';
$string['usernavigation'] = 'Brugernavigation';
$string['usersforumposts'] = 'Brugerens forumindlæg';
$string['viewalldiscussions'] = 'Vis alle tråde';
$string['viewconversation'] = 'Vis tråd';
$string['viewgrades'] = 'Se karakterer';
$string['viewparentpost'] = 'Vis det foregående indlæg';
$string['viewthediscussion'] = 'Vis diskussionen';
$string['warnafter'] = 'Vis advarsel, når resterende indlæg er';
$string['warnafter_help'] = 'Studerende kan blive advaret når de nærmer sig grænsen for antallet af tilladte indlæg i en given periode. Her angives efter hvor mange indlæg advarslen kommer. Brugere med rettigheden "mod/forum:postwithoutthrottling" er fritaget for begrænsning antal indlæg';
$string['warnformorepost'] = 'Advarsel! Der er mere end en tråd i dette forum - den nyeste bruges';
$string['yournewquestion'] = 'Dit nye spørgsmål';
$string['yournewtopic'] = 'Dit nye diskussionsemne';
$string['yourreply'] = 'Dit svar';
