<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'diary', language 'da', version '5.0'.
 *
 * @package     diary
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'Adgang nægtet';
$string['additionallinks'] = 'Yderligere links til denne aktivitet og kursus:';
$string['addtofeedback'] = 'Tilføj til feedback';
$string['alias'] = 'Nøgleord';
$string['aliases'] = 'Nøgleord';
$string['aliases_help'] = 'Hver dagbogsindlæg kan have en tilknyttet liste af nøgleord (eller aliaser).

Indtast hvert nøgleord på en ny linje (ikke adskilt af kommaer).';
$string['alwaysopen'] = 'Altid åben';
$string['alwaysshowdescription'] = 'Vis altid beskrivelse';
$string['alwaysshowdescription_help'] = 'Hvis deaktiveret, vil dagbogsbeskrivelsen ovenfor kun blive synlig for studerende på "Åbningstid" datoen.';
$string['and'] = 'og';
$string['attachment'] = 'Vedhæftning';
$string['attachment_help'] = 'Du kan valgfrit vedhæfte en eller flere filer til en dagbogsindlæg.';
$string['autorating'] = 'Automatisk bedømmelse';
$string['autorating_descr'] = 'Hvis det er aktiveret, vil bedømmelsen for en post automatisk blive beregnet baseret på indstillingerne for Min/Max tællinger.';
$string['autorating_help'] = 'Denne indstilling sammen med Min/Max tællinger definerer standarderne for autorating i alle nye dagbøger.';
$string['autorating_title'] = 'Automatisk bedømmelse aktiveret';
$string['autoratingbelowmaxitemdetails'] = 'Automatisk bedømmelse kræver {$a->one} eller flere {$a->two} med en mulig {$a->three}% straf for hver manglende. <br>Du har {$a->four}. Du skal komme op med {$a->five}. Den mulige straf er {$a->six} point.';
$string['autoratingitempenaltymath'] = 'Den automatiske straffematematik for vurdering af elementer er (max({$a->one} - {$a->two}, 0)) * {$a->three} =  {$a->four}.<br> Bemærk: max forhindrer negative tal, der skyldes at have mere end hvad der er nødvendigt.';
$string['autoratingitempercentset'] = 'Indstillinger for automatisk bedømmelse procent: {$a}%';
$string['autoratingovermaxitemdetails'] = 'Auto-vurderingsgrænsen er maksimalt {$a->one} {$a->two} med en mulig {$a->three}% straf for hver ekstra enhed.<br>Du har {$a->four}, hvilket er {$a->five} for mange. Den mulige straf er {$a->six} point.';
$string['availabilityhdr'] = 'Tilgængelighed';
$string['avgsylperword'] = 'Gennemsnitligt antal stavelser pr. ord {$a}';
$string['avgwordlenchar'] = 'Gennemsnitlig ordlængde {$a} tegn';
$string['avgwordpara'] = 'Gennemsnitligt antal ord pr. afsnit {$a}';
$string['blankentry'] = 'Tom indtastning';
$string['calendarend'] = '{$a} lukker';
$string['calendarstart'] = '{$a} åbner';
$string['cancel'] = 'Annuller overførsel';
$string['chars'] = 'Tegn:';
$string['charspersentence'] = 'Tegn pr. sætning';
$string['clearfeedback'] = 'Klar feedback';
$string['commonerrorpercentset'] = 'Indstilling af procent for almindelige fejl {$a}%';
$string['commonerrors'] = 'Almindelige fejl';
$string['commonerrors_help'] = 'De almindelige fejl er defineret i "Ordbogen over fejl", der er knyttet til dette spørgsmål.';
$string['configdateformat'] = 'Dette definerer, hvordan datoer vises i dagbogsrapporter. Standardværdien, "M d, Y G:i" er måned, dag, år og 24-timers format for tid. Se venligst Date i PHP-manualen for flere eksempler og foruddefinerede datokonstanter.';
$string['created'] = 'Oprettet for {$a->one} dage og {$a->two} timer siden.';
$string['createnewprompt'] = 'Opret ny prompt';
$string['crontask'] = 'Baggrundsbehandling for Dagbogsmodulet';
$string['csvexport'] = 'Eksporter til .csv';
$string['currententry'] = 'Nuværende dagbogsindlæg:';
$string['currpotrating'] = 'Din nuværende potentielle vurdering er: {$a->one} point, eller {$a->two} %.';
$string['datechanged'] = 'Dato ændret';
$string['dateformat'] = 'Standard datoformat';
$string['datestart'] = 'Indstil dato for at begynde at bruge prompt ID {$a}:';
$string['datestop'] = 'Indstil dato for at stoppe med at bruge prompt ID {$a}:';
$string['daysavailable'] = 'Tilgængelige dage';
$string['daysavailable_help'] = 'Hvis du bruger ugeformatet, kan du indstille, hvor mange dage dagbogen er åben for brug.';
$string['deadline'] = 'Åbningstider';
$string['delete'] = 'Slet';
$string['deleteallratings'] = 'Slet alle bedømmelser';
$string['deleteexconfirm'] = 'Bekræft at du er ved at slette skriveprompt ID';
$string['deletenotenrolled'] = 'Slet indtastninger fra brugere, der ikke er tilmeldt';
$string['details'] = 'Detaljer:';
$string['detectcommonerror'] = 'Registreret mindst {$a->one}, {$a->two}. De er: {$a->three}
<br>Hvis det er tilladt, bør du rette og genaflevere.';
$string['diary:addentries'] = 'Tilføj dagbogsindlæg';
$string['diary:addinstance'] = 'Tilføj dagbogsinstanser';
$string['diary:manageentries'] = 'Administrer dagbogsindlæg';
$string['diary:rate'] = 'Vurder dagbogsindlæg';
$string['diaryclosetime'] = 'Lukketid';
$string['diaryclosetime_help'] = 'Hvis aktiveret, kan du indstille en dato for, hvornår dagbogen skal lukkes og ikke længere være åben til brug.';
$string['diarydescription'] = 'Dagbogsbeskrivelse';
$string['diaryentrydate'] = 'Indstil dato for denne post';
$string['diaryid'] = 'diaryid at overføre til';
$string['diarymail'] = 'Hej {$a->user},
{$a->teacher} har offentliggjort nogle kommentarer til din dagbogsindlæg for \'{$a->diary}\'.

Du kan se det tilføjet til dit dagbogsindlæg:

    {$a->url}';
$string['diarymailhtml'] = 'Hej {$a->user},<br>
{$a->teacher} har lagt noget feedback på din
dagbogsindlæg for \'<i>{$a->diary}</i>\'.<br /><br />
Du kan se det tilføjet til dit <a href="{$a->url}">dagbogsindlæg</a>.';
$string['diarymailhtmluser'] = 'har offentliggjort en dagbogsindlæg for \'<i>{$a->diary}</i>\'<br /><br />
Du kan se <a href="{$a->url}">dagbogsindlægget her</a>.<br /><br />Bemærk: Du skal muligvis give feedback eller opdatere status for indlægget for at aktiviteten kan blive markeret som fuldført.';
$string['diarymailuser'] = 'har offentliggjort en dagbogsindlæg for \'{$a->diary}\'

Du kan se indlægget her:

    {$a->url}

Bemærk: Du skal muligvis give feedback eller opdatere status for indlægget for at aktiviteten kan sættes til fuldført.';
$string['diaryname'] = 'Dagbogsnavn';
$string['diaryopentime'] = 'Åbningstid';
$string['diaryopentime_help'] = 'Hvis det er aktiveret, kan du angive en dato for, hvornår dagbogen skal åbnes til brug.';
$string['diarytitle'] = 'Titel';
$string['diarytitle_help'] = 'Du kan tilføje en valgfri titel/beskrivelse.';
$string['editall'] = 'Rediger alle poster';
$string['editall_help'] = 'Når det er aktiveret, kan brugerne redigere enhver post.';
$string['editdates'] = 'Rediger indtastningsdatoer';
$string['editdates_help'] = 'Når det er aktiveret, kan brugerne redigere datoen for enhver post.';
$string['editingended'] = 'Redigeringsperioden er slut';
$string['editingends'] = 'Redigeringsperioden slutter';
$string['editthisentry'] = 'Rediger denne post';
$string['edittopoflist'] = 'Rediger toppen af listen';
$string['eeditlabel'] = 'Rediger';
$string['emaillater'] = 'Send e-mail senere';
$string['emailnow'] = 'Send email nu';
$string['emailpreference'] = 'Skift e-mails';
$string['enableautorating'] = 'Aktiver automatisk bedømmelse';
$string['enableautorating_help'] = 'Aktiver eller deaktiver automatiske bedømmelser';
$string['enablestats'] = 'Aktiver statistik';
$string['enablestats_descr'] = 'Hvis aktiveret, vil statistikken for hver indtastning blive vist.';
$string['enablestats_help'] = 'Aktiver eller deaktiver visning af statistikker for hver post.';
$string['enablestats_title'] = 'Aktiver statistik';
$string['enabletitles'] = 'Aktiver titler';
$string['enabletitles_descr'] = 'Hvis aktiveret, vil titlerne for hver post være påkrævet og blive vist.';
$string['enabletitles_help'] = 'Aktiver eller deaktiver kravet om titler for hver post.';
$string['enabletitles_title'] = 'Aktiver titler';
$string['entries'] = 'Indlæg';
$string['entry'] = 'Indgang';
$string['entrybgc'] = 'Baggrundsfarve for dagbogsindlæg/feedback';
$string['entrybgc_colour'] = '#93FC84';
$string['entrybgc_descr'] = 'Dette sætter baggrundsfarven for en dagbogsindlæg/feedback.';
$string['entrybgc_help'] = 'Dette sætter den overordnede baggrundsfarve for hver dagbogsindlæg og feedback.';
$string['entrybgc_title'] = 'Baggrundsfarve for dagbogsindlæg/feedback';
$string['entrycomment'] = 'Indgangskommentar';
$string['entrysuccess'] = 'Din indtastning er blevet gemt! Den kan have brug for at blive gennemgået eller vurderet, før aktiviteten er sat til at være fuldført.';
$string['entrytextbgc'] = 'Baggrundsfarve for dagbogstekst';
$string['entrytextbgc_colour'] = '#EEFC84';
$string['entrytextbgc_descr'] = 'Dette sætter baggrundsfarven for teksten i en dagbogsindlæg.';
$string['entrytextbgc_help'] = 'Dette sætter baggrundsfarven for teksten i en dagbogsindlæg.';
$string['entrytextbgc_title'] = 'Baggrundsfarve for dagbogstekst';
$string['errorbehavior'] = 'Fejl ved matchning af adfærd';
$string['errorbehavior_help'] = 'Disse indstillinger forfiner matchningsadfærden for poster i Ordbogen over almindelige fejl.';
$string['errorcmid'] = 'Ordliste over fejl';
$string['errorcmid_help'] = 'Vælg den ordliste, der indeholder en liste over almindelige fejl. Hver gang en af fejlene findes i essaybesvarelsen, vil den angivne straf blive trukket fra den studerendes vurdering for denne aflevering.';
$string['errorfullmatch'] = 'Fejl ved matchning af adfærd';
$string['errorfullmatch_help'] = 'Denne indstilling forfiner matchadfærden for poster i Ordbogen over Almindelige Fejl.';
$string['errorpercent'] = 'Bøde pr. fejl';
$string['errorpercent_help'] = 'Vælg den procentdel af den samlede bedømmelse, der skal trækkes fra for hver fejl, der findes i svaret.';
$string['errp'] = 'Fejl %:';
$string['eventdiarycreated'] = 'Dagbog oprettet';
$string['eventdiarydeleted'] = 'Dagbog slettet';
$string['eventdiaryviewed'] = 'Dagbog set';
$string['eventdownloadentriess'] = 'Download indlæg';
$string['evententriesviewed'] = 'Dagbogsindlæg vist';
$string['evententrycreated'] = 'Dagbogsindlæg oprettet';
$string['evententryupdated'] = 'Dagbogsindlæg opdateret';
$string['eventfeedbackupdated'] = 'Feedback til dagbogen opdateret';
$string['eventinvalidentryattempt'] = 'Dagbog ugyldig indtastningsforsøg';
$string['eventpromptcreated'] = 'Prompt oprettet';
$string['eventpromptedited'] = 'Prompt redigeret';
$string['eventpromptinuse'] = 'Sletning af prompt er forhindret';
$string['eventpromptremoved'] = 'Prompt fjernet';
$string['eventpromptsviewed'] = 'Viste prompts';
$string['eventxfrentries'] = 'Overførsel fra journal til dagbogsindlæg';
$string['exportfilename'] = 'entries.csv';
$string['exportfilenamep1'] = 'Alle_Site';
$string['exportfilenamep2'] = '_Dagbogsindlæg_eksporteret_den_';
$string['feedbackupdated'] = 'Feedback opdateret for {$a} indtastninger';
$string['files'] = 'Filer';
$string['firstentry'] = 'Første dagbogsindlæg:';
$string['fkgrade'] = 'FK Karakter';
$string['fkgrade_help'] = 'Flesch Kincaid karakterniveau angiver det antal års uddannelse, der generelt kræves for at forstå denne tekst. Forsøg at sigte efter et karakterniveau under 10.';
$string['fogindex'] = 'Fog index';
$string['fogindex_help'] = 'Gunning fog-indekset er et mål for læsbarhed. Det beregnes ved hjælp af følgende formel.

 ((ord pr. sætning) + (lange ord pr. sætning)) x 0.4

Forsøg at sigte efter et klassetrin under 10. For mere information se: <https://en.wikipedia.org/wiki/Gunning_fog_index>';
$string['for'] = 'for site:';
$string['format'] = 'Format';
$string['freadingease'] = 'Flesch læsbarhed';
$string['freadingease_help'] = 'Flesch læsbarhed: høje scorer indikerer, at din tekst er lettere at læse, mens lavere scorer indikerer, at din tekst er sværere at læse. Forsøg at sigte efter en læsbarhed over 60.';
$string['generalerror'] = 'Der er opstået en fejl.';
$string['generalerrorinsert'] = 'Kunne ikke indsætte en ny dagbogsindgang.';
$string['generalerrorupdate'] = 'Kunne ikke opdatere din dagbog.';
$string['gradeingradebook'] = 'Nuværende vurdering i karakterbogen';
$string['highestgradeentry'] = 'Højst vurderede indlæg:';
$string['idlable'] = '(ID: {$a})';
$string['incorrectcourseid'] = 'Kursus-ID er forkert';
$string['incorrectmodule'] = 'Kursusmodul-ID var forkert';
$string['invalidaccess'] = 'Ugyldig adgang';
$string['invalidaccessexp'] = 'Du har ikke tilladelse til at se den side, du forsøgte at få adgang til! Forsøget er blevet logget!';
$string['invalidtimechange'] = 'Et ugyldigt forsøg på at ændre denne post, Oprettelsestidspunkt, er blevet registreret.';
$string['invalidtimechangenewtime'] = 'Den ændrede tid var: {$a->one}.';
$string['invalidtimechangeoriginal'] = 'Den oprindelige tid var: {$a->one}.';
$string['invalidtimeresettime'] = 'Tiden blev nulstillet til den oprindelige tid: {$a->one}.';
$string['journalid'] = 'journalid at overføre fra';
$string['journalmissing'] = 'I øjeblikket er der ingen Journal-aktiviteter i dette kursus.';
$string['journaltodiaryxfrdid'] = '<br>Dette er en liste over hver Dagbogsaktivitet i dette kursus.<br><b>    ID</b> | Kursus | Dagbogsnavn<br>';
$string['journaltodiaryxfrjid'] = 'Dette er en liste over hver Journal aktivitet i dette kursus.<br><b>    ID</b> | Kursus | Journal navn<br>';
$string['journaltodiaryxfrp1'] = 'Dette er en funktion kun for administratorbrugere til at overføre Journalindlæg til Dagbogsindlæg. Indlæg fra flere Journaler kan overføres til en enkelt Dagbog eller til flere separate Dagbøger. Dette er en ny funktionalitet og er stadig under udvikling.<br><br>';
$string['journaltodiaryxfrp2'] = 'Hvis du bruger <b>Overfør og send email</b> afkrydsningsfeltet, vil enhver journalpost, der overføres til en dagbogsaktivitet, markere den nye post som needing en email sendt til brugeren, så de ved, at posten er blevet overført til en dagbogsaktivitet.<br><br>';
$string['journaltodiaryxfrp3'] = 'Hvis du bruger knappen <b>Overfør uden email</b>, vil der IKKE blive sendt en email til hver bruger, selvom processen automatisk tilføjer feedback i den nye Dagbogsindlæg, selvom det oprindelige Journalindlæg ikke havde feedback inkluderet.<br><br>';
$string['journaltodiaryxfrp4'] = 'Navnet på det kursus, du arbejder i, er: <b> {$a->one}</b>, med et kursus-ID på: <b> {$a->two}</b><br><br>';
$string['journaltodiaryxfrp5'] = 'Hvis du vælger at inkludere feedback vedrørende overførslen, og journalindlægget allerede ikke har nogen feedback, vil du automatisk blive tilføjet som underviser for indlægget for at forhindre en fejl.<br><br>';
$string['journaltodiaryxfrtitle'] = 'Journal til Dagbog xfr';
$string['lastnameasc'] = 'Efternavn stigende:';
$string['lastnamedesc'] = 'Efternavn i faldende rækkefølge:';
$string['latestmodifiedentry'] = 'Senest ændrede poster:';
$string['lexicaldensity'] = 'Leksikal tæthed';
$string['lexicaldensity_help'] = 'Den leksikale tæthed er en procentdel, der beregnes ved hjælp af følgende formel.

 100 x (antal unikke ord) / (samlet antal ord)

Dermed har et essay, hvor mange ord gentages, en lav leksikal tæthed, mens et essay med mange unikke ord har en høj leksikal tæthed.';
$string['longwords'] = 'Unikke lange ord';
$string['longwords_help'] = 'Lange ord er ord, der har tre eller flere stavelser. Bemærk, at algoritmen til at bestemme antallet af stavelser kun giver omtrentlige resultater.';
$string['longwordspersentence'] = 'Lange ord pr. sætning';
$string['lowestgradeentry'] = 'Lavest vurderede indlæg:';
$string['mailed'] = 'Sendt';
$string['mailsubject'] = 'Dagbogsfeedback';
$string['max'] = 'max';
$string['maxc'] = 'Max:';
$string['maxchar'] = 'Maksimalt antal tegn';
$string['maxchar_help'] = 'Hvis et tal større end nul indtastes, skal brugeren bruge færre tegn end det maksimale antal, der er angivet, ellers modtager de en straf for hvert af de ekstra tegn.';
$string['maxcharacterlimit'] = 'Maksimalt antal tegn';
$string['maxcharacterlimit_desc'] = 'Bemærk: Denne indtastning kan bruge <strong>maksimalt {$a} tegn.</strong>';
$string['maxcharacterlimit_help'] = 'Hvis et nummer indtastes, skal brugeren bruge færre tegn end det maksimale antal, der er angivet.';
$string['maxparagraph'] = 'Maksimalt antal afsnit';
$string['maxparagraph_help'] = 'Hvis et tal større end nul indtastes, skal brugeren anvende færre afsnit end det maksimale antal angivet, ellers vil der blive pålagt en straf for hvert af de ekstra afsnit.';
$string['maxparagraphlimit'] = 'Maksimalt antal afsnit';
$string['maxparagraphlimit_desc'] = 'Bemærk: Denne indtastning kan bruge et <strong>maksimum af {$a} afsnit.</strong>';
$string['maxparagraphlimit_help'] = 'Hvis et tal indtastes, skal brugeren bruge færre afsnit end det maksimale antal, der er angivet.';
$string['maxpossrating'] = 'Den maksimale mulige bedømmelse for denne indtastning er {$a} point.';
$string['maxsentence'] = 'Maksimalt antal sætninger';
$string['maxsentence_help'] = 'Hvis der indtastes et tal større end nul, skal brugeren bruge færre sætninger end det maksimale antal, der er angivet, ellers vil der blive pålagt en straf for hver af de ekstra sætninger.';
$string['maxsentencelimit'] = 'Maksimalt antal sætninger';
$string['maxsentencelimit_desc'] = 'Bemærk: Denne indtastning kan bruge et <strong>maksimum af {$a} sætninger.</strong>';
$string['maxsentencelimit_help'] = 'Hvis et tal indtastes, skal brugeren anvende færre sætninger end det maksimale antal, der er angivet.';
$string['maxword'] = 'Maksimalt antal ord';
$string['maxword_help'] = 'Hvis et tal større end nul indtastes, skal brugeren bruge færre ord end det maksimale antal angivet, ellers vil der blive pålagt en straf for hvert af de ekstra ord.';
$string['maxwordlimit'] = 'Maksimalt antal ord';
$string['maxwordlimit_desc'] = 'Bemærk: Denne indtastning kan bruge <strong>maksimalt {$a} ord.</strong>';
$string['maxwordlimit_help'] = 'Hvis et nummer indtastes, skal brugeren bruge færre ord end det maksimale antal, der er angivet.';
$string['mediumwords'] = 'Unikke medium ord';
$string['mediumwords_help'] = 'Medium ord er ord, der har to stavelser. Bemærk, at algoritmen til at bestemme antallet af stavelser kun giver omtrentlige resultater.';
$string['min'] = 'min';
$string['minc'] = 'Min:';
$string['minchar'] = 'Minimum antal tegn';
$string['minchar_help'] = 'Hvis et tal større end nul indtastes, skal brugeren bruge flere tegn end det minimumsantal, der er angivet, ellers modtager de en straf for hvert af de manglende tegn.';
$string['mincharacterlimit'] = 'Minimum antal tegn';
$string['mincharacterlimit_desc'] = 'Bemærk: Denne indtastning skal bruge <strong>minimum {$a} tegn.</strong>';
$string['mincharacterlimit_help'] = 'Hvis et nummer indtastes, skal brugeren bruge flere tegn end det minimumsnummer, der er angivet.';
$string['minmaxcharpercent'] = 'Karakterstraffe pr. Min/Max tællefejl';
$string['minmaxcharpercent_help'] = 'Vælg den procentdel af den samlede bedømmelse, der skal trækkes fra for hver fejl i Min/Max tegnantal.';
$string['minmaxhdr'] = 'Min/Max antal';
$string['minmaxhdr_help'] = 'Disse indstillinger definerer standarderne for minimums- og maksimumsantal af tegn og ord i alle nye dagbøger.';
$string['minmaxparagraphpercent'] = 'Afleveringsstraffe pr. Min/Max tællefejl';
$string['minmaxparagraphpercent_help'] = 'Vælg den procentdel af den samlede bedømmelse, der skal fratrækkes for hver fejl i antallet af afsnit i forhold til minimum/maximum.';
$string['minmaxparapercent'] = 'Afleveringsstraffe pr. Min/Max tællefejl';
$string['minmaxparapercent_help'] = 'Vælg den procentdel af den samlede bedømmelse, der skal fratrækkes for hver fejl i antallet af afsnit i forhold til minimum/maximum.';
$string['minmaxpercent'] = 'Bøde pr. Min/Max tællefejl';
$string['minmaxpercent_help'] = 'Vælg den procentdel af den samlede bedømmelse, der skal trækkes fra for hver Min/Max tællefejl.';
$string['minmaxsentencepercent'] = 'Sætning straf pr. Min/Max tællefejl';
$string['minmaxsentencepercent_help'] = 'Vælg den procentdel af den samlede bedømmelse, der skal trækkes fra for hver Min/Max sætningstællefejl.';
$string['minmaxsentpercent'] = 'Sætning straf pr. Min/Max tællefejl';
$string['minmaxsentpercent_help'] = 'Vælg den procentdel af den samlede bedømmelse, der skal trækkes fra for hver Min/Max sætningstællefejl.';
$string['minmaxwordpercent'] = 'Ordstraffe pr. Min/Maks antal fejl';
$string['minmaxwordpercent_help'] = 'Vælg den procentdel af den samlede bedømmelse, der skal trækkes fra for hver Min/Max ordtællefejl.';
$string['minparagraph'] = 'Minimum antal afsnit';
$string['minparagraph_help'] = 'Hvis der indtastes et tal større end nul, skal brugeren anvende flere afsnit end det minimumsantal, der er angivet, ellers vil der blive pålagt en straf for hvert manglende afsnit.';
$string['minparagraphlimit'] = 'Minimum antal afsnit';
$string['minparagraphlimit_desc'] = 'Bemærk: Denne indtastning skal bruge et <strong>minimum af {$a} afsnit.</strong>';
$string['minparagraphlimit_help'] = 'Hvis et tal indtastes, skal brugeren bruge flere afsnit end det minimumsantal, der er angivet.';
$string['minsentence'] = 'Minimum antal sætninger';
$string['minsentence_help'] = 'Hvis der indtastes et tal større end nul, skal brugeren anvende flere sætninger end det minimumsantal, der er angivet, ellers vil der blive pålagt en straf for hver af de manglende sætninger.';
$string['minsentencelimit'] = 'Minimum antal sætninger';
$string['minsentencelimit_desc'] = 'Bemærk: Denne indtastning skal bruge et <strong>minimum af {$a} sætninger.</strong>';
$string['minsentencelimit_help'] = 'Hvis et tal indtastes, skal brugeren anvende flere sætninger end det minimumsantal, der er angivet.';
$string['minword'] = 'Minimum antal ord';
$string['minword_help'] = 'Hvis et tal større end nul indtastes, skal brugeren bruge flere ord end det minimumsantal, der er angivet, ellers vil der blive pålagt en straf for hvert af de manglende ord.';
$string['minwordlimit'] = 'Minimum antal ord';
$string['minwordlimit_desc'] = 'Bemærk: Denne indtastning skal bruge et <strong>minimum på {$a} ord.</strong>';
$string['minwordlimit_help'] = 'Hvis et tal indtastes, skal brugeren bruge flere ord end det minimumsantal, der er angivet.';
$string['missing'] = 'Manglende';
$string['modulename'] = 'Dagbog';
$string['modulename_help'] = 'Diary-aktiviteten giver lærere mulighed for at indhente feedback fra studerende
 over en periode.';
$string['modulenameplural'] = 'Dagbøger';
$string['needsgrading'] = 'Denne aflevering har ikke fået feedback eller blevet bedømt endnu.';
$string['needsregrade'] = 'Denne post er ændret siden der blev givet feedback eller en vurdering.';
$string['newdiaryentries'] = 'Nye dagbogsindlæg';
$string['nextentry'] = 'Næste indtastning';
$string['nodeadline'] = 'Altid åben';
$string['noentriesmanagers'] = 'Der er ingen undervisere';
$string['noentry'] = 'Ingen adgang.';
$string['noratinggiven'] = 'Ingen bedømmelse givet';
$string['notextdetected'] = '<b>Ingen tekst registreret!</b>';
$string['notopenuntil'] = 'Denne dagbog vil ikke være åben før';
$string['notstarted'] = 'Du har endnu ikke startet denne dagbog';
$string['numwordscln'] = '{$a->one} rene tekstord ved hjælp af {$a->two} tegn, IKKE inklusive {$a->three} mellemrum.';
$string['numwordsnew'] = 'Ny beregning: {$a->one} rå tekstord ved brug af {$a->two} tegn, i {$a->three} sætninger, i {$a->four} afsnit.';
$string['numwordsraw'] = '{$a->one} rå tekstord ved hjælp af {$a->two} tegn, inklusive {$a->three} mellemrum.';
$string['numwordsstd'] = '{$a->one} standardiserede ord ved hjælp af {$a->two} tegn, inklusive {$a->three} mellemrum.';
$string['outof'] = 'ud af {$a} indtastninger.';
$string['overallrating'] = 'Samlet bedømmelse';
$string['pagesize'] = 'Indlæg pr. side';
$string['paragraphs'] = 'Afsnit:';
$string['percentofentryrating'] = '{$a}% af bedømmelsen for indtastningen.';
$string['phrasecasesensitiveno'] = 'Match er ikke skelnet mellem store og små bogstaver.';
$string['phrasecasesensitiveyes'] = 'Match er skelnet mellem store og små bogstaver.';
$string['phrasefullmatchno'] = 'Match fulde eller delvise ord.';
$string['phrasefullmatchyes'] = 'Match kun hele ord.';
$string['phraseignorebreaksno'] = 'Genkend linjeskift.';
$string['phraseignorebreaksyes'] = 'Ignorer linjeskift.';
$string['pluginadministration'] = 'Administration af dagbogsmodulet';
$string['pluginname'] = 'Dagbog';
$string['popoverhelp'] = 'klik for info';
$string['potautoratingerrpen'] = 'Potentiel autoratingsfejlstraff: {$a->one}% eller {$a->two} point fratrukket.';
$string['potcommerrpen'] = 'Potentiel almindelig fejlstraff: {$a->one} * {$a->two} = {$a->three}% eller {$a->four} point fratrukket.';
$string['present'] = 'Præsenter';
$string['previousentry'] = 'Tidligere indtastning';
$string['privacy:metadata:diary_entries'] = 'En optegnelse af en dagbogsindgang.';
$string['privacy:metadata:diary_entries:diary'] = 'ID\'et på Dagbogsaktiviteten, hvor indlægget blev offentliggjort.';
$string['privacy:metadata:diary_entries:entrycomment'] = 'Lærerfeedback og muligvis, automatisk bedømmelsesfeedback.';
$string['privacy:metadata:diary_entries:mailed'] = 'Er denne bruger blevet mailet endnu?';
$string['privacy:metadata:diary_entries:promptdatestart'] = 'Datoen hvor den automatiske skriveopfordring begyndte at blive brugt.';
$string['privacy:metadata:diary_entries:promptdatestop'] = 'Datoen hvor den automatiske skriveopgave ikke længere blev brugt.';
$string['privacy:metadata:diary_entries:promptid'] = 'ID\'et for den automatiske skriveopgave, der bruges til automatisk bedømmelse og feedback.';
$string['privacy:metadata:diary_entries:prompttext'] = 'Teksten af skriveopgaven, der bruges til automatisk vurdering og feedback.';
$string['privacy:metadata:diary_entries:rating'] = 'Den numeriske karakter for denne dagbogsindlæg kan bestemmes af skalaer/advancedgradingforms osv., men vil altid blive konverteret tilbage til et flydende punkt nummer.';
$string['privacy:metadata:diary_entries:teacher'] = 'Bruger-ID\'et på den person, der vurderer indlægget.';
$string['privacy:metadata:diary_entries:text'] = 'Indholdet af denne post.';
$string['privacy:metadata:diary_entries:timecreated'] = 'Tidspunktet for oprettelsen af posten.';
$string['privacy:metadata:diary_entries:timemarked'] = 'Tidspunktet hvor indlægget blev bedømt.';
$string['privacy:metadata:diary_entries:timemodified'] = 'Tidspunktet for hvornår posten sidst blev ændret.';
$string['privacy:metadata:diary_entries:userid'] = 'Brugerens ID.';
$string['prompt'] = 'Indtast dit skriveprompt';
$string['promptbgc'] = 'Baggrundsfarve for denne prompt';
$string['promptbgc_help'] = 'Dette sætter den overordnede baggrundsfarve for denne prompt.';
$string['promptid'] = 'Prompt id';
$string['promptinfo'] = 'Der er {$a->past} tidligere opfordringer, {$a->current} nuværende opfordring og {$a->future} fremtidige opfordringer til denne dagbogsaktivitet.<br>';
$string['promptmaxc'] = 'Char max';
$string['promptmaxp'] = 'Para max';
$string['promptmaxs'] = 'Send maks';
$string['promptmaxw'] = 'Word max';
$string['promptminc'] = 'Char min';
$string['promptminmaxcp'] = 'Char %';
$string['promptminmaxpp'] = 'Para %';
$string['promptminmaxsp'] = 'Sendt %';
$string['promptminmaxwp'] = 'Word %';
$string['promptminp'] = 'Til mig';
$string['promptmins'] = 'Sendt min';
$string['promptminw'] = 'Word min';
$string['promptremovefailure'] = 'Denne prompt, ID {$a}, er i brug og kan ikke fjernes.';
$string['promptremovesuccess'] = 'Du har med succes fjernet prompten, ID {$a}.';
$string['promptstart'] = 'Prompt start';
$string['promptstitle'] = 'Dagbogsskrivningsopgaver';
$string['promptstop'] = 'Prompt stop';
$string['promptsviewtitle'] = 'Se skriveopgaver';
$string['prompttext'] = 'Prompt tekst';
$string['promptzerocount'] = '<td>Der er i øjeblikket {$a} opfordringer til denne Dagbogsaktivitet.</td>';
$string['rate'] = 'Bedøm';
$string['rating'] = 'Bedømmelse af denne post';
$string['reload'] = 'Genindlæs og vis fra den nuværende til den ældste dagbogsindgang';
$string['removealldiarytags'] = 'Fjern alle Dagbogs-tags';
$string['removeentries'] = 'Fjern alle poster';
$string['removemessages'] = 'Fjern alle dagbogsindlæg';
$string['reportsingle'] = 'Hent alle dagbogsindlæg for denne bruger.';
$string['reportsingleallentries'] = 'Alle dagbogsindlæg for denne bruger.';
$string['returnto'] = 'Returner til {$a}';
$string['returntoreport'] = 'Returner til rapportside for - {$a}';
$string['saveallfeedback'] = 'Gem al min feedback';
$string['savesettings'] = 'Gem indstillinger';
$string['search'] = 'Søg';
$string['search:activity'] = 'Dagbog - aktivitetsinformation';
$string['search:entry'] = 'Dagbog - indlæg';
$string['search:entrycomment'] = 'Dagbog - indlæg kommentar';
$string['selectentry'] = 'Vælg aflevering til bedømmelse';
$string['sentences'] = 'Sætninger:';
$string['sentencesperparagraph'] = 'Sætninger pr. afsnit';
$string['shortwords'] = 'Unikke korte ord';
$string['shortwords_help'] = 'Korte ord er ord, der kun har én stavelse. Bemærk, at algoritmen til at bestemme antallet af stavelser kun giver omtrentlige resultater.';
$string['showlistno'] = 'Skjul ingen adgang';
$string['showlistpreference'] = 'Vis brugere uden indtastninger';
$string['showlistyes'] = 'Vis ingen adgang';
$string['shownone'] = 'Vis ingen';
$string['showoverview'] = 'Vis oversigt over dagbøger på mit Moodle';
$string['showrecentactivity'] = 'Vis seneste aktivitet';
$string['showstudentsonly'] = 'Vis kun studerende';
$string['showteacherandstudents'] = 'Vis lærer og studerende';
$string['showteachersonly'] = 'Vis kun undervisere';
$string['showtextstats'] = 'Vis tekststatistik?';
$string['showtextstats_help'] = 'Hvis denne mulighed er aktiveret, vil der blive vist statistik om teksten.';
$string['showtostudentsonly'] = 'Ja, vis kun til studerende';
$string['showtoteachersandstudents'] = 'Ja, vis til lærere og studerende';
$string['showtoteachersonly'] = 'Ja, vis kun til lærere';
$string['sortcurrententry'] = 'Fra nuværende dagbogsindlæg til det første indlæg.';
$string['sortfirstentry'] = 'Fra den første dagbogsindførsel til den seneste indførsel.';
$string['sorthighestentry'] = 'Fra den højest vurderede dagbogsindlæg til det lavest vurderede indlæg.';
$string['sortlastentry'] = 'Fra den senest ændrede dagbogsindgang til den ældste ændrede indgang.';
$string['sortlowestentry'] = 'Fra den lavest vurderede dagbogsindlæg til det højest vurderede indlæg.';
$string['sortoptions'] = 'Sorter muligheder:';
$string['sortorder'] = 'Sorteringsrækkefølge er:';
$string['startnewentry'] = 'Start ny post';
$string['startoredit'] = 'Start ny eller rediger dagens indtastning';
$string['statshdr'] = 'Tekststatistik';
$string['statshdr_help'] = 'Disse indstillinger definerer standarderne for statistikkerne i alle nye dagbøger.';
$string['statshide'] = 'Skjul statistik';
$string['statsshow'] = 'Vis statistik';
$string['studentemail'] = 'Send e-mailnotifikationer til studerende';
$string['studentemail_help'] = 'Aktiver eller deaktiver muligheden for straks at sende e-mail-notifikationer til studerende.';
$string['tablecolumncharacters'] = 'Karakterer';
$string['tablecolumnedit'] = 'Rediger&nbsp;&nbsp;&nbsp;&nbsp;';
$string['tablecolumnparagraphs'] = 'Afsnit';
$string['tablecolumnprompts'] = 'Prompter';
$string['tablecolumnpromptsbgc'] = 'Baggrundsfarve for prompt';
$string['tablecolumnsentences'] = 'Sætninger';
$string['tablecolumnstart'] = 'Start';
$string['tablecolumnstatus'] = 'Status';
$string['tablecolumnstop'] = 'Stop';
$string['tablecolumnwords'] = 'Ord&nbsp;&nbsp;&nbsp;&nbsp;';
$string['tagarea_diary_entries'] = 'Dagbogsindlæg';
$string['tcount'] = 'I øjeblikket har denne dagbogsaktivitet i alt {$a} skriveopgaver, der tilhører den.<br>';
$string['teacher'] = 'Lærer';
$string['teacheremail'] = 'Send e-mailunderretninger til lærere';
$string['teacheremail_help'] = 'Aktiver eller deaktiver muligheden for straks at sende e-mail-notifikationer til lærere.';
$string['text'] = 'Indtast dit skriveprompt';
$string['text_editor'] = 'Prompt tekst';
$string['textstatitems'] = 'Statistiske elementer';
$string['textstatitems_help'] = 'Vælg de elementer her, som du ønsker skal vises i tekststatistikkerne, der vises på en visningsside, rapportside og rapportenkeltside.';
$string['timecreated'] = 'Oprettelsestid';
$string['timemarked'] = 'Tid markeret';
$string['timemodified'] = 'Tid ændret';
$string['toolbar'] = 'Værktøjslinje:';
$string['totalsyllables'] = 'Samlet antal stavelser {$a}';
$string['transfer'] = 'Overførsel af indtastning';
$string['transferwemail'] = 'Overfør og send e-mail. <b>Standard: Send ikke e-mail</b>';
$string['transferwfb'] = 'Overfør og inkluder feedback vedrørende overførslen. <b>Standard: Inkluder ikke feedback</b>';
$string['transferwfbmsg'] = '<br> Denne post blev overført fra journalen med navnet:  {$a}';
$string['transferwoe'] = 'Overførsel uden email';
$string['uniquewords'] = 'Unikke ord';
$string['userid'] = 'Bruger-id';
$string['usertoolbar'] = 'Bruger værktøjslinje:';
$string['viewalldiaries'] = 'Se alle kursusdagbøger';
$string['viewallentries'] = 'Se {$a} dagbogsindlæg';
$string['viewentries'] = 'Se indlæg';
$string['warning'] = '<b>ADVARSEL - Du har {$a} aktuelle anmodninger, hvilket er en fejl. Du kan ikke have flere, overlappende aktuelle datoer! Dette skal rettes!</b><br>';
$string['words'] = 'Ord:';
$string['wordspersentence'] = 'Ord pr. sætning';
$string['writingpromptlable'] = 'Nuværende skriveopgave: {$a->counter} (ID: {$a->entryid}) som startede den {$a->starton} og vil slutte den {$a->endon}.<br>{$a->datatext}';
$string['writingpromptlable2'] = 'Skriveopgave:';
$string['writingpromptlable3'] = 'Redaktør for skriveopgaver';
$string['writingpromptnotused'] = 'De normale dagbogsindstillinger blev brugt til denne entries auto-vurderings procentindstillinger.';
$string['writingpromptused'] = 'Skriveprompt ID: {$a} blev brugt til denne indgangs auto-bedømmelses procentindstillinger.';
$string['xfrresults'] = 'Der blev behandlet {$a->one} indtastninger, og {$a->two} af dem blev overført.';
