<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'badges', language 'da', version '5.0'.
 *
 * @package     badges
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'Handlinger';
$string['activate'] = 'Aktivér adgang';
$string['activatesuccess'] = 'Adgang til mærket \'{$a}\' aktiveret.';
$string['addalignment'] = 'Tilføj ekstern færdighed eller standard';
$string['addbadge'] = 'Tilføj badges';
$string['addbadge_help'] = 'Vælg alle mærker, der skal tilføjes til dette mærkekrav. Hold CTRL-tasten nede for at vælge flere elementer.';
$string['addbadgecriteria'] = 'Tilføj kriterier for badge';
$string['addcohort'] = 'Tilføj kohorte';
$string['addcohort_help'] = 'Vælg alle kohorter, der skal tilføjes til dette badgekrav. Hold CTRL-tasten nede for at vælge flere elementer.';
$string['addcompetency'] = 'Tilføj kompetence';
$string['addcompetency_help'] = 'Vælg alle kompetencer, der skal tilføjes til dette badgekrav. Hold CTRL-tasten nede for at vælge flere elementer.';
$string['addcourse'] = 'Tilføj kurser';
$string['addcourse_help'] = 'Vælg alle kurser, der skal tilføjes til dette badgekrav. Hold CTRL-tasten nede for at vælge flere elementer.';
$string['addcriteria'] = 'Tilføj kriterier';
$string['addcriteriatext'] = 'For at begynde at tilføje kriterier, vælg venligst en af mulighederne fra rullemenuen.';
$string['addcriterion'] = 'Tilføj kriterium';
$string['addedtobackpack'] = 'Tilføjet mærke til rygsæk';
$string['addrelated'] = 'Tilføj relateret badge';
$string['addtobackpack'] = 'Tilføj til rygsæk';
$string['adminonly'] = 'Denne side er begrænset til kun webstedsadministratorer.';
$string['after'] = 'efter udstedelsesdatoen.';
$string['aggregationmethod'] = 'Aggregeringsmetode';
$string['alignment'] = 'Justering';
$string['all'] = 'Alle';
$string['allmethod'] = 'Alle de valgte betingelser er opfyldt';
$string['allmethodactivity'] = 'Alle de valgte aktiviteter er afsluttede';
$string['allmethodbadges'] = 'Alle de valgte badges er blevet opnået';
$string['allmethodcohort'] = 'Medlemskab i alle de valgte kohorter';
$string['allmethodcompetencies'] = 'Alle de valgte kompetencer er blevet gennemført';
$string['allmethodcourseset'] = 'Alle de valgte kurser er afsluttede';
$string['allmethodmanual'] = 'Alle de valgte roller tildeler mærket';
$string['allmethodprofile'] = 'Alle de valgte profilfelter er blevet udfyldt';
$string['allowcoursebadges'] = 'Aktivér kursusmærker';
$string['allowcoursebadges_desc'] = 'Tillad at badges oprettes og tildeles i kursus-konteksten.';
$string['allowexternalbackpack'] = 'Ekstern rygsækforbindelse';
$string['allowexternalbackpack_desc'] = 'Hvis aktiveret, kan brugere forbinde til en ekstern rygsæk og dele deres badges fra dette websted. Brugere kan også vælge at vise eventuelle offentlige badge-samlinger fra deres eksterne rygsæk på deres profilside på dette websted. Det anbefales at lade denne mulighed være deaktiveret, hvis dit websted ikke er tilgængeligt fra internettet.';
$string['any'] = 'En af';
$string['anymethod'] = 'Enhver af de valgte betingelser er opfyldt';
$string['anymethodactivity'] = 'Enhver af de valgte aktiviteter er fuldført';
$string['anymethodbadges'] = 'Nogen af de valgte badges er blevet opnået';
$string['anymethodcohort'] = 'Medlemskab i en hvilken som helst af de valgte kohorter';
$string['anymethodcompetencies'] = 'Nogle af de valgte kompetencer er blevet gennemført';
$string['anymethodcourseset'] = 'Enhver af de valgte kurser er fuldført';
$string['anymethodmanual'] = 'Enhver af de valgte roller tildeler mærket';
$string['anymethodprofile'] = 'Nogen af de valgte profilfelter er blevet udfyldt';
$string['apiversion'] = 'Understøttet API-version';
$string['archivebadge'] = 'Ønsker du at slette mærket \'{$a}\', men beholde eksisterende udstedte mærker?';
$string['archiveconfirm'] = 'Slet og behold eksisterende udstedte badges';
$string['archivehelp'] = '<p>This option means that the badge will be marked as "retired" and will no longer appear in the list of badges. Users will no longer be able to earn this badge, however existing badge recipients will still be able to display this badge on their profile page and push it to their external backpacks.</p>
<p>If you would like your users to retain access to the earned badges it is important to select this option instead of fully deleting badges.</p>';
$string['attachment'] = 'Vedhæft badge til besked';
$string['attachment_help'] = 'Hvis aktiveret, vil et udstedt badge blive vedhæftet modtagerens e-mail til download. (Vedhæftede filer skal være aktiveret i Webstedsadministration / Server / E-mail / Konfiguration af udgående mail for at bruge denne mulighed.)';
$string['award'] = 'Tildel mærke';
$string['awardedto'] = 'Tildelt til {$a}';
$string['awardedtoyou'] = 'Udstedt til mig';
$string['awardoncron'] = 'Et stort antal brugere modtager mærket \'{$a->badgename}\'. Det kan tage noget tid, før alle brugere modtager det.';
$string['awards'] = 'Modtagere';
$string['backpackapiurl'] = 'Backpack API URL';
$string['backpackavailability'] = 'Ekstern verifikation af badge';
$string['backpackavailability_help'] = 'For at badgemodtagere kan bevise at de har optjent deres badge fra dig, bør en ekstern rygsækservice kunne få adgang til dit site og verificere badges tildelt fra det. Dit site ser p.t. ikke ud til at være tilgængeligt, hvilket betyder, at badges der allerede er tildelt eller vil blive tildelt, fremadrettet ikke kan verificeres.

**Hvorfor ser jeg denne besked?**

Det kan være at jeres firewall ikke tillader adgang for brugere udenfor jeres netværk, at jeres site er adgangskodebeskyttet, eller at du kører sitet fra en computer der ikke kan tilgås fra internettet (såsom en lokal udviklingsmaskine).

**Er dette et problem?**

Du bør fikse dette problem på en installation i drift hvorfra du planlægger at kunne tildele badges, ellers vil modtagerne ikke kunne bevise at de har optjent deres badges fra jer. Hvis jeres site endnu ikke er gået live, kan du danne og tildele testbadges blot sitet er tilgængeligt når I går live.

**Hvad hvis jeg ikke kan gøre mit fulde site tilgængeligt?**

Den eneste URL der er påkrævet for verifikation, er [ditdomæne.dk]/badges/assertion.php, så hvis I kan konfigurere jeres firewall til at tillade ekstern adgang til denne fil, vil verifikation af badges fortsat virke.';
$string['backpackbadgessettings'] = 'Ændre rygsæk-indstillinger';
$string['backpackbadgessummary'] = 'Du har {$a->totalbadges} badge(r) vist fra {$a->totalcollections} samling(er).';
$string['backpackcannotsendverification'] = 'Kan ikke sende bekræftelses-e-mail';
$string['backpackconnected'] = 'Rygsækken er tilsluttet';
$string['backpackconnection'] = 'Opret forbindelse til en rygsæk';
$string['backpackconnection_connected'] = 'Din rygsæk';
$string['backpackconnection_help'] = 'Opbevar og del dine badges fra dette websted og vis offentlige badges fra andre websteder på din brugerprofil.';
$string['backpackconnectioncancelattempt'] = 'Forbind ved hjælp af en anden e-mailadresse';
$string['backpackconnectionconnect'] = 'Forbind til rygsæk';
$string['backpackconnectionnottested'] = 'Forbindelsen kan ikke testes for denne rygsæk, da kun rygsække med Open Badges v2.0 understøtter dette.';
$string['backpackconnectionok'] = 'Forbindelse til rygsæk blev oprettet med succes';
$string['backpackconnectionresendemail'] = 'Gensend bekræftelses-e-mail';
$string['backpackconnectionunexpectedmessage'] = 'Rygsækken returnerede fejlen: "{$a}".';
$string['backpackconnectionunexpectedresult'] = 'Der opstod et problem med at forbinde til din rygsæk. Din rygsækudbyder sender denne besked: \'{$a}\'.';
$string['backpackdetails'] = 'Rygsæk-indstillinger';
$string['backpackdisconnected'] = 'Rygsækken er frakoblet';
$string['backpackemail_required'] = 'E-mailadressen må ikke være tom';
$string['backpackemailverificationpending'] = 'Verifikation afventer';
$string['backpackemailverifyemailbody'] = 'Hej {$a->userfirstname},

Du er næsten færdig med at oprette forbindelse til din badges-rygsæk på \'{$a->sitename}\'.

For at afslutte forbindelsen til din rygsæk skal du bekræfte din e-mailadresse via følgende knap:

{$a->buttonlink}

Virker knappen ikke, kan du kopiere og indsætte følgende URL i din browser:
{$a->link}

Hvis du ikke har forsøgt at oprette forbindelse til din badges-rygsæk, kan du roligt ignorere denne e-mail.

Har du brug for yderligere hjælp, bedes du kontakte dit websteds support

{$a->admin}';
$string['backpackemailverifyemailsubject'] = '{$a}: E-mailbekræftelse for badges-rygsæk';
$string['backpackemailverifypending'] = 'Vi har sendt en e-mail til <strong>{$a}</strong>. Klik på bekræftelseslinket i e-mailen for at aktivere din rygsæksforbindelse.';
$string['backpackemailverifysuccess'] = 'Du er nu forbundet til din rygsæk.';
$string['backpackemailverifytokenmismatch'] = 'Tokenet i det link, du klikkede på, stemmer ikke overens med det gemte token. Sørg for, at du klikkede på linket i den seneste e-mail, du modtog.';
$string['backpackexporterror'] = 'Kan ikke eksportere mærket til rygsækken';
$string['backpackexporterrorwithinfo'] = 'Kan ikke eksportere mærket "{$a->badgename}" til rygsækken. Fejl: {$a->error}';
$string['backpackimport'] = 'Indstillinger for import af badges';
$string['backpackimport_help'] = 'Når forbindelsen til rygsækken er korrekt etableret, kan badges fra din rygsæk blive vist på din badge- og din profilside.

I dette område kan du udvælge samlinger af badges fra din rygsæk som du gerne vil vise på din profil.';
$string['backpackprovider'] = 'Rygsækudbyder';
$string['backpacksettings'] = 'Rygsæk-indstillinger';
$string['backpackweburl'] = 'Backpack-URL';
$string['badgedetails'] = 'Emblemdetaljer';
$string['badgeimage'] = 'Billede';
$string['badgeimage_help'] = 'Billedet skal være mindst 300 x 300 pixels i størrelse. Det vil blive vist som 300 x 300 pixels på badgesiden og 100 x 100 pixels på brugerens profilside.';
$string['badgeimageinfo'] = 'For de bedste resultater, upload et firkantet billede med en minimumsstørrelse på 300 x 300 pixels.';
$string['badgeissued'] = 'Mærke udstedt';
$string['badgeprivacysetting'] = 'Privatindstillinger for badges';
$string['badgeprivacysetting_help'] = 'Badges you earn can be displayed on your account profile page. This setting allows you to automatically set the visibility of the newly earned badges.

You can still control individual badge privacy settings on your badges page.';
$string['badgeprivacysetting_str'] = 'Vis automatisk de badges, jeg opnår, på min profilside';
$string['badges'] = 'Mærker';
$string['badgesalt'] = 'Salt til hashing af modtagerens e-mailadresse';
$string['badgesalt_desc'] = 'Using a hash allows backpack services to confirm the badge earner without having to expose their email address. This setting should only use numbers and letters.

Note: For recipient verification purposes, please avoid changing this setting once you start issuing badges.';
$string['badgesdisabled'] = 'Badges er ikke aktiveret på dette websted.';
$string['badgesearned'] = 'Antal opnåede badges: {$a}';
$string['badgesettings'] = 'Indstillinger for badges';
$string['badgesnavigation'] = 'Badge-navigation';
$string['badgestatus_0'] = 'Ikke tilgængelig';
$string['badgestatus_1'] = 'Tilgængelig';
$string['badgestatus_2'] = 'Ikke tilgængelig (kriterier låst)';
$string['badgestatus_3'] = 'Tilgængelig (kriterier låst)';
$string['badgestatus_4'] = 'Arkiveret';
$string['badgestoearn'] = 'Antal tilgængelige badges: {$a}';
$string['badgesview'] = 'Kursusmærker';
$string['badgetags'] = 'Emneknapper';
$string['badgeurl'] = 'Udstedt badge-link';
$string['balignment'] = 'Justeringer ({$a})';
$string['bawards'] = 'Modtagere ({$a})';
$string['bcriteria'] = 'Kriterier';
$string['bdetails'] = 'Rediger oplysninger';
$string['bendorsement'] = 'Godkendelse';
$string['bmessage'] = 'Besked';
$string['boverview'] = 'Oversigt';
$string['brelated'] = 'Relaterede badges ({$a})';
$string['bydate'] = 'afslut inden';
$string['canvascredentialsprovider'] = 'Canvas-legitimationsoplysninger';
$string['canvasregions'] = 'Canvas-legitimationsoplysninger regioner';
$string['canvasregions_desc'] = 'Du kan konfigurere indholdet af Canvas-legitimationsoplysninger regioner. Hver linje er adskilt af lodrette streger og består af 1) regionsnavnet, 2) backpack-URL\'en og 3) backpack-API-URL\'en';
$string['claim'] = 'Krav';
$string['claimcomment'] = 'Godkendelseskommentar';
$string['claimid'] = 'Kræv URL';
$string['clearsettings'] = 'Ryd indstillinger';
$string['completioninfo'] = 'Dette badge blev udstedt for at have gennemført:';
$string['completionnotenabled'] = 'Kursusgennemførelse er ikke aktiveret for dette kursus, så det kan ikke inkluderes i kriterierne for mærker. Kursusgennemførelse kan aktiveres i kursusindstillingerne.';
$string['configenablebadges'] = 'Hvis aktiveret, giver denne funktion dig mulighed for at oprette badges og tildele dem til webstedets brugere.';
$string['configuremessage'] = 'Mærkebesked';
$string['connect'] = 'Forbind';
$string['connected'] = 'Forbundet';
$string['connecting'] = 'Opretter forbindelse...';
$string['contact'] = 'Email';
$string['contact_help'] = 'En e-mailadresse tilknyttet badgeudstederen.';
$string['copy'] = 'Kopi';
$string['copyof'] = 'Kopi af {$a}';
$string['course'] = 'Kursus: {$a}';
$string['coursebadges'] = 'Mærker';
$string['coursebadgesdisabled'] = 'Kursusmærker er ikke aktiveret på dette websted.';
$string['coursebadgetitle'] = '{$a} kursusmærke';
$string['coursecompletion'] = 'Brugerne skal gennemføre dette kursus.';
$string['create'] = 'Nyt mærke';
$string['createbutton'] = 'Opret mærke';
$string['creatorbody'] = '{$a->user} har opfyldt alle krav til mærket og har modtaget mærket. Se det udstedte mærke på {$a->link}';
$string['creatorsubject'] = '\'{$a}\' er blevet tildelt!';
$string['criteria_0'] = 'Dette badge tildeles, når...';
$string['criteria_1'] = 'Aktivitetsfærdiggørelse';
$string['criteria_1_help'] = 'Gør det muligt at tildele et badge til brugere baseret på gennemførelsen af et sæt aktiviteter inden for et kursus.';
$string['criteria_2'] = 'Manuel tildeling efter rolle';
$string['criteria_2_help'] = 'Giver mulighed for manuelt at tildele et badge af brugere, der har en bestemt rolle inden for sitet eller kurset.';
$string['criteria_3'] = 'Social deltagelse';
$string['criteria_3_help'] = 'Social';
$string['criteria_4'] = 'Kursusgennemførelse';
$string['criteria_4_help'] = 'Giver mulighed for at tildele et badge til brugere, der har gennemført kurset. Dette kriterium kan have yderligere parametre såsom minimumskarakter og dato for kursets afslutning.';
$string['criteria_5'] = 'Færdiggørelse af et sæt kurser';
$string['criteria_5_help'] = 'Giver mulighed for at tildele et badge til brugere, der har gennemført et sæt kurser. Hvert kursus kan have yderligere parametre såsom minimumskarakter og dato for kursets afslutning.';
$string['criteria_6'] = 'Profilfærdiggørelse';
$string['criteria_6_help'] = 'Giver mulighed for at tildele et badge til brugere for at udfylde bestemte felter i deres profil. Du kan vælge mellem standard- og brugerdefinerede profilfelter, der er tilgængelige for brugerne.';
$string['criteria_7'] = 'Tildelte badges';
$string['criteria_7_help'] = 'Gør det muligt at tildele et badge til brugere baseret på andre badges, de har opnået.';
$string['criteria_8'] = 'Kohortemedlemskab';
$string['criteria_8_help'] = 'Gør det muligt at tildele et badge til brugere baseret på kohortmedlemskab.';
$string['criteria_9'] = 'Kompetencer';
$string['criteria_9_help'] = 'Gør det muligt at tildele et badge til brugere baseret på de kompetencer, de har fuldført.';
$string['criteria_descr'] = 'Brugere tildeles dette badge, når de opfylder følgende krav:';
$string['criteria_descr_0'] = 'Fuldfør <strong>{$a}</strong> af de opstillede krav.';
$string['criteria_descr_1'] = '<strong>{$a}</strong> af de følgende aktiviteter er gennemført:';
$string['criteria_descr_2'] = 'Dette badge skal tildeles af brugere med <strong>{$a}</strong> af følgende roller:';
$string['criteria_descr_4'] = 'Brugerne skal gennemføre kurset';
$string['criteria_descr_5'] = '<strong>{$a}</strong> af de følgende kurser skal gennemføres:';
$string['criteria_descr_6'] = '<strong>{$a}</strong> af de følgende brugerprofilfelter skal udfyldes:';
$string['criteria_descr_7'] = '<strong>{$a}</strong> af de følgende badges skal erhverves:';
$string['criteria_descr_8'] = 'Medlemskab i <strong>{$a}</strong> af følgende kohorter er påkrævet:';
$string['criteria_descr_9'] = '<strong>{$a}</strong> af de følgende kompetencer skal være gennemført:';
$string['criteria_descr_bydate'] = 'af <em>{$a}</em>';
$string['criteria_descr_grade'] = 'med en minimumskarakter på <em>{$a}</em>';
$string['criteria_descr_short0'] = 'Fuldfør <strong>{$a}</strong> af:';
$string['criteria_descr_short1'] = 'Fuldfør <strong>{$a}</strong> af:';
$string['criteria_descr_short2'] = 'Tildelt af <strong>{$a}</strong> fra:';
$string['criteria_descr_short4'] = 'Gennemfør kurset';
$string['criteria_descr_short5'] = 'Fuldfør <strong>{$a}</strong> af:';
$string['criteria_descr_short6'] = 'Fuldfør <strong>{$a}</strong> af:';
$string['criteria_descr_short7'] = 'Fuldfør <strong>{$a}</strong> af:';
$string['criteria_descr_short8'] = 'Kohortmedlemskab i <strong>{$a}</strong> af:';
$string['criteria_descr_short9'] = 'Fuldfør <strong>{$a}</strong> af:';
$string['criteria_descr_single_1'] = 'Følgende aktivitet skal gennemføres:';
$string['criteria_descr_single_2'] = 'Dette badge skal tildeles af en bruger med følgende rolle:';
$string['criteria_descr_single_4'] = 'Brugerne skal gennemføre kurset';
$string['criteria_descr_single_5'] = 'Følgende kursus skal gennemføres:';
$string['criteria_descr_single_6'] = 'Følgende brugerprofilfelt skal udfyldes:';
$string['criteria_descr_single_7'] = 'Følgende badge skal opnås:';
$string['criteria_descr_single_8'] = 'Medlemskab i den følgende kohorte er påkrævet:';
$string['criteria_descr_single_9'] = 'Følgende kompetencer skal gennemføres:';
$string['criteria_descr_single_short1'] = 'Fuldfør:';
$string['criteria_descr_single_short2'] = 'Tildelt af:';
$string['criteria_descr_single_short4'] = 'Gennemfør kurset';
$string['criteria_descr_single_short5'] = 'Fuldfør:';
$string['criteria_descr_single_short6'] = 'Fuldfør:';
$string['criteria_descr_single_short7'] = 'Fuldfør:';
$string['criteria_descr_single_short8'] = 'Medlemskab i:';
$string['criteria_descr_single_short9'] = 'Fuldfør:';
$string['criteriacreated'] = 'Kriterier for badge oprettet med succes';
$string['criteriadeleted'] = 'Kriterier for badge blev slettet med succes';
$string['criteriasummary'] = 'Kriteriesammendrag';
$string['criteriaupdated'] = 'Kriterier for badge blev opdateret med succes';
$string['criterror'] = 'Aktuelle parametreproblemer';
$string['criterror_help'] = 'Dette feltset viser alle parametre, der oprindeligt blev tilføjet til dette badgekrav, men som ikke længere er tilgængelige. Det anbefales, at du fravælger sådanne parametre for at sikre, at brugere kan opnå dette badge i fremtiden.';
$string['currentimage'] = 'Aktuelt billede';
$string['currentstatus'] = 'Nuværende status:';
$string['dateawarded'] = 'Udstedelsesdato';
$string['dateearned'] = 'Dato: {$a}';
$string['day'] = 'Dag(e)';
$string['deactivate'] = 'Deaktiver adgang';
$string['deactivatesuccess'] = 'Adgang til mærket \'{$a}\' deaktiveret.';
$string['defaultissuercontact'] = 'E-mailadresse for badgeudsteder';
$string['defaultissuercontact_desc'] = 'En e-mailadresse tilknyttet badgeudstederen. For en Open Badges v2.0 rygsæk anvendes dette til autentifikation, når badges offentliggøres til en rygsæk.';
$string['defaultissuername'] = 'Udsteders navn for badge';
$string['defaultissuername_desc'] = 'Navn på udstedende agent eller myndighed.';
$string['defaultissuerpassword'] = 'Adgangskode for badgeudsteder';
$string['defaultissuerpassword_help'] = 'Der kræves en konto på rygsæk-siden med en e-mailadresse, som specificeret i indstillingen for udstederens e-mailadresse under Webstedsadministration / Mærker / Indstillinger for mærker. Adgangskoden til kontoen skal indtastes her.';
$string['delbadge'] = 'Ønsker du at slette mærket \'{$a}\' og fjerne alle eksisterende udstedte mærker?';
$string['delconfirm'] = 'Slet og fjern eksisterende udstedte badges';
$string['delcritconfirm'] = 'Er du sikker på, at du ønsker at slette dette kriterium?';
$string['deletehelp'] = '<p>At slette en badge helt betyder, at al dens information og kriterieposter vil blive fjernet permanent. Brugere der har optjent badgen, vil ikke længere kunne tilgå og vise den på deres profilside.</p> <p>Bemærk: Brugere der har optjent badgen og allerede har lagt den i deres eksterne rygsæk, vil stadig have den i deres eksterne rygsæk. Imidlertid vil de ikke kunne tilgå kriterier og vidnesbyrdsider der linker tilbage til dette websted.</p>';
$string['delexternalbackpack'] = 'Slet webstedets rygsæk';
$string['delexternalbackpackconfirm'] = 'Slet webstedets rygsæk \'{$a}\'?';
$string['delparamconfirm'] = 'Er du sikker på, at du ønsker at slette denne parameter?';
$string['description'] = 'Beskrivelse';
$string['descriptioninfo'] = 'Hvad repræsentere dette badge';
$string['disconnect'] = 'Afbryd forbindelsen';
$string['donotaward'] = 'I øjeblikket er dette mærke ikke aktivt, så det kan ikke tildeles brugere. Hvis du ønsker at tildele dette mærke, skal du venligst aktivere dets status.';
$string['enablebadges'] = 'Aktivér badges';
$string['endorsement'] = 'Godkendelse';
$string['error:backpackdatainvalid'] = 'Dataretur fra rygsækken var ugyldig.';
$string['error:backpackemailnotfound'] = 'E-mailen \'{$a}\' er ikke tilknyttet en rygsæk. Du skal <a href="http://backpack.openbadges.org">oprette en rygsæk</a> for den konto eller logge ind med en anden e-mailadresse.';
$string['error:badgeawardnotfound'] = 'Kan ikke verificere dette tildelte mærke. Dette mærke kan være blevet tilbagekaldt.';
$string['error:badgenotfound'] = 'Mærke ikke fundet';
$string['error:cannotact'] = 'Kan ikke aktivere mærket.';
$string['error:cannotawardbadge'] = 'Kan ikke tildele badge til en bruger.';
$string['error:cannotdeletecriterion'] = 'Dette kriterium kan ikke slettes.';
$string['error:cannotrevokebadge'] = 'Kan ikke tilbagekalde badge fra en bruger.';
$string['error:cannotsendtobackpack'] = '<strong>Kan ikke tilføje badge til backpack</strong><br />
Din backpack-udbyder sender denne meddelelse: \'{$a}\'.<br /><br />
Du kan prøve at downloade badge og tilføje det manuelt til din backpack, eller prøve igen senere';
$string['error:clone'] = 'Kan ikke klone mærket.';
$string['error:connectionunknownreason'] = 'Forbindelsen mislykkedes, men der blev ikke givet nogen årsag.';
$string['error:duplicatename'] = 'Et badge med dette navn findes allerede i systemet.';
$string['error:externalbadgedoesntexist'] = 'Mærke ikke fundet';
$string['error:guestuseraccess'] = 'Du bruger i øjeblikket gæsteadgang. For at se badges skal du logge ind med din brugerkonto.';
$string['error:invalidcriteriatype'] = 'Ugyldig kriterietype.';
$string['error:invalidexpiredate'] = 'Udløbsdatoen skal være i fremtiden.';
$string['error:invalidexpireperiod'] = 'Udløbsperioden kan ikke være negativ eller lig med 0.';
$string['error:invalidparambadge'] = 'Mærket findes ikke.';
$string['error:invalidparamcohort'] = 'Kohorten findes ikke.';
$string['error:noactivities'] = 'Der er ingen aktiviteter med aktiverede kriterier for gennemførelse i dette kursus.';
$string['error:nobadges'] = 'Der er i øjeblikket ingen badges med aktiveret adgang, der kan tilføjes som kriterier. Et webstedsbadge kan kun have andre webstedsbadges som kriterier. Et kursusbadge kan have andre kursusbadges eller webstedsbadges som kriterier.';
$string['error:nocohorts'] = 'Ingen kohorter';
$string['error:nocourses'] = 'Kursusgennemførelse er ikke aktiveret for nogen af kurserne på dette site, så ingen kan vises. Kursusgennemførelse kan aktiveres i kursusindstillingerne.';
$string['error:nogroupslink'] = '<p>Kun offentlige samlinger vises. <a href="{$a}" target="_blank" rel="nofollow">Besøg din rygsæk</a> for at oprette nogle offentlige samlinger.</p>';
$string['error:nogroupssummary'] = 'Der er ingen offentlige samlinger af badges tilgængelige i din rygsæk.';
$string['error:nopermissiontoview'] = 'Du har ikke tilladelse til at se modtagere af badges';
$string['error:nosuchbadge'] = 'Mærket med id {$a} eksisterer ikke.';
$string['error:nosuchcohort'] = 'Advarsel: Denne kohorte er ikke længere tilgængelig.';
$string['error:nosuchcourse'] = 'Advarsel: Dette kursus er ikke længere tilgængeligt.';
$string['error:nosuchfield'] = 'Advarsel: Dette brugerprofilfelt er ikke længere tilgængeligt.';
$string['error:nosuchmod'] = 'Advarsel: Denne aktivitet er ikke længere tilgængelig.';
$string['error:nosuchrole'] = 'Advarsel: Denne rolle er ikke længere tilgængelig.';
$string['error:nosuchuser'] = 'Bruger med denne e-mailadresse har ikke en konto hos den nuværende rygsækudbyder.';
$string['error:notifycoursedate'] = 'Mærker forbundet med kursus- og aktivitetsafslutninger vil ikke blive udstedt før kursusstartdatoen ({$a}).';
$string['error:parameter'] = 'Advarsel: Mindst én parameter bør vælges for at sikre en korrekt arbejdsgang for udstedelse af badges.';
$string['error:relatedbadgedoesntexist'] = 'Der er ingen offentlig badge med dette identifikator';
$string['error:requesterror'] = 'Forbindelsesforespørgslen mislykkedes (fejlkode {$a}).';
$string['error:requesttimeout'] = 'Forbindelsesforespørgslen fik timeout, før den kunne fuldføres.';
$string['error:save'] = 'Kan ikke gemme mærket.';
$string['error:userdeleted'] = '{$a->user} (Denne bruger findes ikke længere i {$a->site})';
$string['eventbadgearchived'] = 'Mærke arkiveret';
$string['eventbadgeawarded'] = 'Mærke tildelt';
$string['eventbadgecreated'] = 'Mærke oprettet';
$string['eventbadgecriteriacreated'] = 'Kriterier for badge oprettet';
$string['eventbadgecriteriadeleted'] = 'Kriterier for badge slettet';
$string['eventbadgecriteriaupdated'] = 'Kriterier for badge opdateret';
$string['eventbadgedeleted'] = 'Mærke slettet';
$string['eventbadgedisabled'] = 'Mærke deaktiveret';
$string['eventbadgeduplicated'] = 'Mærke duplikeret';
$string['eventbadgeenabled'] = 'Mærke aktiveret';
$string['eventbadgelistingviewed'] = 'Visning af badgeoversigt';
$string['eventbadgerevoked'] = 'Mærke tilbagekaldt';
$string['eventbadgeupdated'] = 'Mærke opdateret';
$string['eventbadgeviewed'] = 'Mærke vist';
$string['existingrecipients'] = 'Eksisterende badge-modtagere';
$string['existsinbackpack'] = 'Mærket findes allerede i rygsækken';
$string['expired'] = 'Udløbet';
$string['expiredate'] = 'Dette badge udløber den {$a}.';
$string['expireddate'] = 'Dette badge udløb den {$a}.';
$string['expiredin'] = 'Udløbet {$a}';
$string['expireperiod'] = 'Dette mærke udløber {$a} dag(e) efter det er udstedt.';
$string['expireperiodh'] = 'Dette badge udløber {$a} time(r) efter det er udstedt.';
$string['expireperiodm'] = 'Dette badge udløber {$a} minut(ter) efter det er udstedt.';
$string['expireperiods'] = 'Dette badge udløber {$a} sekund(er) efter det er udstedt.';
$string['expiresin'] = 'Udløber {$a}';
$string['expirydate'] = 'Udløbsdato';
$string['expirydate_help'] = 'Valgfrit kan mærker udløbe på en specifik dato, eller datoen kan beregnes baseret på datoen, hvor mærket blev tildelt til en bruger.';
$string['externalbackpack_required'] = 'Rygsækudbyder kan ikke være tom';
$string['externalbadges'] = 'Mine badges fra andre websteder';
$string['externalbadges_help'] = 'Dette område viser badges fra din eksterne rygsæk.';
$string['externalbadgesp'] = 'Badges fra andre websteder:';
$string['externalconnectto'] = 'For at vise eksterne badges skal du <a href="{$a}">forbinde til en rygsæk</a>.';
$string['fixed'] = 'Fast dato: Dette badge udløber på følgende dato:';
$string['hidden'] = 'Skjult';
$string['hiddenbadge'] = 'Desværre har badgeindehaveren ikke gjort disse oplysninger tilgængelige.';
$string['hostedurl'] = 'Ekstern URL';
$string['hostedurldescription'] = 'Ekstern URL hvor badget er hostet';
$string['imageauthoremail'] = 'Billedforfatterens e-mail';
$string['imageauthoremail_help'] = 'Hvis angivet, vises e-mailadressen på forfatteren af badge-billedet på badgesiden.';
$string['imageauthorname'] = 'Billedforfatterens navn';
$string['imageauthorname_help'] = 'Hvis angivet, vises navnet på forfatteren til badge-billedet på badgesiden.';
$string['imageauthorurl'] = 'Billedforfatterens URL';
$string['imageauthorurl_help'] = 'Hvis angivet, vises et link til emblembilledets forfatters websted på emblemsiden. URL\'en bør have et præfiks http:// eller https://.';
$string['imagecaption'] = 'Billedtekst';
$string['imagecaption_help'] = 'Hvis angivet, vises en billedtekst på badgemodulets side.';
$string['includeauthdetails'] = 'Include authentication details with the backpack';
$string['includeauthdetails_desc'] = 'Indtast dine legitimationsoplysninger for badge-udsteder for at forbinde til din backpack-udbyder';
$string['includeauthdetails_help'] = 'Sender dine udsteder-legitimationsoplysninger med hvert badge, der eksporteres til denne backpack';
$string['includeauthdetailscanvas'] = 'Forbind til en Canvas-legitimationsoplysninger udstederkonto';
$string['includeauthdetailscanvas_desc'] = 'Indtast dine Canvas-legitimationsoplysninger for at forbinde din udstederkonto';
$string['includeauthdetailscanvas_help'] = 'Badges eksporteret til Canvas-legitimationsoplysninger vil vise din organisation som udsteder. Dette giver dig også mulighed for at spore, hvem der har modtaget badges, og administrere opdateringer';
$string['includeauthdetailscanvas_subtitle'] = '(Kræver en Canvas-legitimationsoplysninger betalt plan)';
$string['invalidurl'] = 'Ugyldig URL';
$string['issuancedetails'] = 'Mærke udløb';
$string['issuedbadge'] = 'Udstedt badgeinformation';
$string['issuedby'] = 'Udstedt af {$a}';
$string['issuedon'] = 'Udstedt {$a}';
$string['issuerdetails'] = 'Udstederoplysninger';
$string['issueremail'] = 'E-mail';
$string['issueremail_help'] = 'En kontaktemailadresse for organisationen, der udsteder godkendelsen.';
$string['issuername'] = 'Navn';
$string['issuername_endorsement'] = 'Navn på godkender';
$string['issuername_endorsement_help'] = 'Navnet på garanten.';
$string['issuername_help'] = 'Navn på udstedende agent eller myndighed.';
$string['issuerurl'] = 'URL';
$string['issuerurl_help'] = 'Organisationens websted, der udsteder godkendelsen. URL\'en bør have et præfiks http:// eller https://.';
$string['language'] = 'Sprog';
$string['language_help'] = 'Sproget, der anvendes på badgesiden.';
$string['listbackpacks'] = 'Liste over rygsække';
$string['localbadges'] = 'Mine badges fra {$a} webstedet';
$string['localbadgesh'] = 'Mine badges fra denne hjemmeside';
$string['localbadgesh_help'] = 'All badges earned within this web site by completing courses, course activities, and other requirements.

You can manage your badges here by making them public or private for your profile page.

You can download all of your badges or each badge separately and save them on your computer. Downloaded badges can be added to your external backpack service.';
$string['localbadgesp'] = 'Mærker fra {$a}:';
$string['localconnectto'] = 'For at dele disse badges uden for dette websted skal du <a href="{$a}">forbinde til en rygsæk</a>.';
$string['loginbackpacktitle'] = '<strong>Log ind på din rygsæk</strong>';
$string['makeprivate'] = 'Gør privat';
$string['makepublic'] = 'Gør offentlig';
$string['managebackpacks'] = 'Administrer rygsække';
$string['managebadges'] = 'Administrer badges';
$string['message'] = 'Beskedindhold';
$string['messagebody'] = '<p>Du er blevet tildelt badgen "%badgename%"!</p> <p>Der er mere information om den på siden med %badgelink% badgeinformation.</p> <p>Du kan administrere og downloade badgen fra din {$a}-side.</p>';
$string['messagesubject'] = 'Tillykke! Du har netop opnået et badge!';
$string['method'] = 'Dette kriterium er opfyldt, når...';
$string['mingrade'] = 'Minimumkarakter krævet';
$string['month'] = 'Måned(er)';
$string['moredetails'] = 'Flere detaljer';
$string['mybackpack'] = 'Mine rygsæk-indstillinger';
$string['mybadges'] = 'Mine badges';
$string['namewithimagelink'] = 'Navn med billede og link';
$string['namewithlink'] = 'Navn med link';
$string['never'] = 'Aldrig: Dette badge udløber aldrig.';
$string['newbackpack'] = 'Tilføj en ny rygsæk';
$string['newbadge'] = 'Tilføj et nyt badge';
$string['newbadgedeprecated'] = 'You have been redirected from badges/newbadge.php. Please note that badges/newbadge.php will be removed in the near future.
<br/>Update links and bookmarks to use the current page badges/edit.php.';
$string['newimage'] = 'Nyt billede';
$string['noalignment'] = 'Dette badge har ikke nogen eksterne færdigheder eller standarder specificeret.';
$string['noawards'] = 'Dette badge er endnu ikke opnået.';
$string['nobackpack'] = 'Der er ingen rygsæk-tjeneste tilknyttet denne konto.<br/>';
$string['nobackpackbadgessummary'] = 'Der er ingen badges i de samlinger, du har valgt.';
$string['nobackpackcollectionssummary'] = 'Ingen badgesamlinger er blevet valgt.';
$string['nobackpacks'] = 'Der er ingen rygsække tilgængelige';
$string['nobadges'] = 'Der er i øjeblikket ingen tilgængelige badges, som brugere kan opnå.';
$string['nocompetencies'] = 'Ingen kompetencer valgt.';
$string['nocriteria'] = 'Kriterierne for dette badge er endnu ikke blevet opsat.';
$string['noendorsement'] = 'Dette badge har ikke en godkendelse.';
$string['noexpiry'] = 'Dette badge har ikke en udløbsdato.';
$string['nomatchingawards'] = 'Der er endnu ingen modtagere, der har opnået dette badge.';
$string['nomatchingbadges'] = 'Der er ingen tilgængelige matchende badges, som brugere kan opnå.';
$string['noparamstoadd'] = 'Der er ingen yderligere parametre tilgængelige for at tilføje til dette badgekrav.';
$string['norelated'] = 'Dette badge har ikke nogen relaterede badges.';
$string['notacceptedrole'] = 'Din nuværende rolletildeling er ikke mellem de roller, der manuelt kan udstede denne badge.<br/>Vil du se hvilke brugere der har opnået denne badge, kan du besøge siden {$a}.';
$string['notconnected'] = 'Ikke forbundet';
$string['notealignment'] = 'Eksterne færdigheder eller standarder, som mærket er i overensstemmelse med, kan angives. Eventuelle eksterne færdigheder eller standarder vises på mærkesiden.';
$string['noteendorsement'] = 'En godkendelse fra en tredjepart kan anvendes til at tilføje værdi til mærket. For eksempel kan et mærke udstedt af en lærer blive godkendt af skolen, eller et mærke udstedt af en lokal uddelende instans kan blive godkendt af den nationale uddelende instans.';
$string['noterelated'] = 'Mærker med en forbindelse kan markeres som relaterede. For eksempel kan mærker med de samme kriterier, som vises på forskellige sprog, markeres som relaterede. Eventuelle relaterede mærker vises på mærkesiden.';
$string['nothingtoadd'] = 'Der er ingen tilgængelige kriterier at tilføje.';
$string['notification'] = 'Underret badge-skaberen';
$string['notification_help'] = 'Denne indstilling styrer underretninger sendt til opretteren af en badge med oplysning om at badgen er blevet tildelt. Følgende valgmuligheder er tilgængelige:

* **ALDRIG** – Send ikke underretninger.
* **HVER GANG** – Send besked hver gang en badge er tildelt.
* **DAGLIGT** – Send besked en gang dagligt.
* **UGENTLIGT** – Send besked en gang om ugen.
* **MÅNEDLIG** – Send besked en gang om måneden.';
$string['notifydaily'] = 'Dagligt';
$string['notifyevery'] = 'Hver gang';
$string['notifymonthly'] = 'Månedligt';
$string['notifyweekly'] = 'Ugentlig';
$string['numawards'] = 'Brugere tildelt mærket \'{$a->badgename}\': <a href="{$a->link}">{$a->count}</a>.';
$string['numawardstat'] = 'Brugere tildelt mærket \'{$a->badgename}\': {$a->awards}.';
$string['oauth2issuer'] = 'OAuth 2-tjenester';
$string['openbadgesv1'] = 'Open Badges v1.0';
$string['openbadgesv2'] = 'Open Badges v2.0';
$string['openbadgesv2p1'] = 'Open Badges v2.1';
$string['othernavigation'] = 'Anden navigation ...';
$string['otherprovider'] = 'Andet';
$string['overallcrit'] = 'af de valgte kriterier er fuldførte.';
$string['password_required'] = 'Adgangskoden må ikke være tom';
$string['potentialrecipients'] = 'Potentielle badge-modtagere';
$string['preferences'] = 'Indstillinger for badges';
$string['privacy:metadata:backpack'] = 'En fortegnelse over brugeres rygsække';
$string['privacy:metadata:backpack:backpackuid'] = 'Den unikke identifikator for rygsækken';
$string['privacy:metadata:backpack:email'] = 'E-mailen tilknyttet rygsækken';
$string['privacy:metadata:backpack:externalbackpackid'] = 'Rygsækkens ID';
$string['privacy:metadata:backpack:userid'] = 'Brugerens ID, hvis rygsæk det er';
$string['privacy:metadata:backpackoauth2'] = 'OAuth 2-oplysninger, når brugeren forbinder til en ekstern rygsæk';
$string['privacy:metadata:backpackoauth2:issuerid'] = 'OAuth 2-tjeneste-ID';
$string['privacy:metadata:backpackoauth2:scope'] = 'Oplist omfanget af backpack connect';
$string['privacy:metadata:backpackoauth2:token'] = 'Backpack-forbindelsestoken';
$string['privacy:metadata:backpackoauth2:userid'] = 'Brugerens ID tilknyttet til rygsækken';
$string['privacy:metadata:backpackoauth2:usermodified'] = 'Brugerens ID blev ændret i forbindelse';
$string['privacy:metadata:badge'] = 'En samling af badges';
$string['privacy:metadata:badge:timecreated'] = 'Tidspunktet for oprettelsen af mærket';
$string['privacy:metadata:badge:timemodified'] = 'Tidspunktet for sidste ændring af mærket';
$string['privacy:metadata:badge:usercreated'] = 'ID\'et for brugeren, der oprettede mærket';
$string['privacy:metadata:badge:usermodified'] = 'ID\'et for brugeren, der ændrede mærket';
$string['privacy:metadata:criteriamet'] = 'En samling af kriterier, som er blevet opfyldt';
$string['privacy:metadata:criteriamet:datemet'] = 'Datoen hvor kriterierne blev opfyldt';
$string['privacy:metadata:criteriamet:userid'] = 'ID\'et for brugeren, der har opfyldt kriterierne';
$string['privacy:metadata:external:backpacks'] = 'Information delt, når brugere indsender deres badges til en ekstern rygsæk';
$string['privacy:metadata:external:backpacks:badge'] = 'Navnet på mærket';
$string['privacy:metadata:external:backpacks:description'] = 'Beskrivelsen af mærket';
$string['privacy:metadata:external:backpacks:image'] = 'Billedet af mærket';
$string['privacy:metadata:external:backpacks:issuer'] = 'Nogle oplysninger om udstederen';
$string['privacy:metadata:external:backpacks:url'] = 'Moodle-URL\'en, hvor oplysningerne om det udstedte badge kan ses';
$string['privacy:metadata:issued'] = 'En fortegnelse over tildelte badges';
$string['privacy:metadata:issued:dateexpire'] = 'Datoen for hvornår mærket udløber';
$string['privacy:metadata:issued:dateissued'] = 'Datoen for tildelingen';
$string['privacy:metadata:issued:userid'] = 'ID\'et for brugeren, der blev tildelt et badge';
$string['privacy:metadata:manualaward'] = 'En fortegnelse over manuelle tildelinger';
$string['privacy:metadata:manualaward:datemet'] = 'Datoen hvor brugeren blev tildelt mærket';
$string['privacy:metadata:manualaward:issuerid'] = 'ID\'et for brugeren, der tildeler mærket';
$string['privacy:metadata:manualaward:issuerrole'] = 'Brugerens rolle i tildelingen af mærket';
$string['privacy:metadata:manualaward:recipientid'] = 'ID\'et for brugeren, som manuelt tildeles et badge';
$string['provider'] = 'Udbyder';
$string['recipient'] = 'Modtager af badge';
$string['recipients'] = 'Modtagere af badges';
$string['recipientvalidationproblem'] = 'Denne bruger kan ikke bekræftes som modtager af dette badge.';
$string['region'] = 'Region';
$string['relatedbages'] = 'Relaterede badges';
$string['relative'] = 'Relativ dato: Dette badge udløber efter en periode:';
$string['requiredbadge'] = 'Mindst ét mærke bør tilføjes til mærkekriteriet.';
$string['requiredcohort'] = 'Mindst én kohorte bør tilføjes til kohortekriteriet.';
$string['requiredcompetency'] = 'Mindst én kompetence bør tilføjes til kompetencekriteriet.';
$string['requiredcourse'] = 'Mindst ét kursus skal tilføjes til kriteriesættet for kurser.';
$string['reviewbadge'] = 'Ændringer i adgang til badges';
$string['reviewconfirm'] = '<p>Dette vil gøre din badge synlig for brugere og gøre det muligt for dem at gøre sig fortjent til den.</p> <p>Det er muligt at nogle brugere allerede opfylder kravene i badgens kriterier og vil få den tildelt umiddelbart efter du aktiverer den.</p> <p>Når en badge er tildelt <strong>låses</strong> den - bestemte indstillinger inklusiv kriterier og udløbsindstilling kan ikke længere ændres.</p> <p>Er du sikker på at du vil aktivere adgang til badgen "{$a}"?</p>';
$string['revoke'] = 'Tilbagekald mærke';
$string['save'] = 'Gem';
$string['searchname'] = 'Søg efter navn';
$string['selectaward'] = 'Vælg venligst den rolle, du ønsker at bruge til at tildele dette badge:';
$string['selectgroup_end'] = 'Kun offentlige samlinger vises. <a href="{$a}">Besøg din rygsæk</a> for at oprette flere offentlige samlinger.';
$string['selectgroup_start'] = 'Vælg samlinger fra din rygsæk til visning på dette websted:';
$string['selecting'] = 'Med valgte badges...';
$string['setup'] = 'Opsæt forbindelse';
$string['sitebackpackdeleted'] = 'Rygsækken på webstedet er blevet slettet.';
$string['sitebackpacknotdeleted'] = 'Denne rygsæk kunne ikke slettes, da den i øjeblikket er standard for webstedet.';
$string['sitebackpackwarning'] = 'Kunne ikke oprette forbindelse til rygsækken. <br/><br/>Kontroller, at "E-mailadresse for badgeudsteder" i admin-indstillingerne er den gyldige e-mail for en konto på rygsækswebstedet. <br/><br/>Kontroller, at "Adgangskode for badgeudsteder" på <a href="{$a->url}">siden for rygsæksindstillinger</a>, er den korrekte adgangskode for kontoen på rygsækswebstedet. <br/><br/>Rygsækken returnerede: "{$a->warning}"';
$string['sitebadges'] = 'Webstedsbadges';
$string['sitebadges_help'] = 'Sitebadges kan kun tildeles brugere for siterelaterede aktiviteter. Disse omfatter færdiggørelse af kurser eller dele af brugerprofiler. Sitebadges kan også tildeles manuelt af en bruger til en anden.

Badges for kursusrelaterede aktiviteter kan oprettes på kursusniveau. Kursusbadges kan findes under Kursusadministration > Badges.';
$string['sitebadgetitle'] = '{$a} webstedsbadge';
$string['status'] = 'Mærkestatus';
$string['status_help'] = 'Status på en badge styrer dens \'opførsel\' i systemet:

* **TILGÆNGELIG** – Den kan optjenes af brugere. Så længe den er tilgængelig for brugerne, kan dens kriterier ikke ændres.

* ** IKKE TILGÆNGELIG** – Betyder at badgen ikke er tilgængelig for brugere og ikke kan blive optjent eller udstedt manuelt. Hvis ikke en sådan badge tidligere er tildelt, kan dens kriterier ændres.

Så snart en badge er udstedt til en bruger, bliver den **LÅST**. En låst badge kan stadig optjenes, men kriterierne kan ikke ændres. Hvis du skal modificere oplysninger eller kriterier på en låst badge, kan du tage en kopi og ændre den.

*Hvorfor låser vi badges?*

Vi vil sikre at brugerne opfylder ens kriterier for at optjene en badge. Det er pt. ikke muligt at tilbagekalde badges. Hvis vi altid tillod ændringer i badgekriterier, ville vi få brugere med samme badge men optjent på helt forskellige forudsætninger.';
$string['statusmessage_0'] = 'Dette badge er i øjeblikket ikke tilgængeligt for brugere. Aktivér adgang, hvis du ønsker, at brugerne skal kunne opnå dette badge.';
$string['statusmessage_1'] = 'Dette badge er i øjeblikket tilgængeligt for brugere. Deaktiver adgang for at foretage ændringer.';
$string['statusmessage_2'] = 'Dette badge er i øjeblikket ikke tilgængeligt for brugere, og dets kriterier er låst. Aktivér adgang, hvis du ønsker, at brugerne skal kunne opnå dette badge.';
$string['statusmessage_3'] = 'Dette mærke er i øjeblikket tilgængeligt for brugere, og dets kriterier er låst.';
$string['statusmessage_4'] = 'Dette badge er i øjeblikket arkiveret.';
$string['subject'] = 'Beskedemne';
$string['tagarea_badge'] = 'Mærker';
$string['tags'] = 'Tags';
$string['targetcode'] = 'Kode';
$string['targetcode_help'] = 'En unik strengidentifikator til henvisning til den eksterne færdighed eller standard inden for dets ramme.';
$string['targetdescription'] = 'Beskrivelse';
$string['targetdescription_help'] = 'Kort beskrivelse af den eksterne færdighed eller standard.';
$string['targetframework'] = 'Rammeværk';
$string['targetframework_help'] = 'Navnet på den eksterne færdighed eller standardramme.';
$string['targetname'] = 'Navn';
$string['targetname_help'] = 'Den eksterne færdighed eller standard, som mærket er afstemt med.';
$string['targeturl'] = 'URL';
$string['targeturl_help'] = 'Et link til en side, der beskriver den eksterne færdighed eller standard. URL\'en bør have et præfiks http:// eller https://.';
$string['testbackpack'] = 'Test rygsæk \'{$a}\'}';
$string['testsettings'] = 'Testindstillinger';
$string['type'] = 'Type';
$string['userbadges'] = 'Brugerbadges';
$string['variablesubstitution'] = 'Variabelsubstitution i beskeder.';
$string['variablesubstitution_help'] = 'I en badge-besked kan bestemte variable indsættes som emne og/eller i selve teksten sådan at de bliver erstattet af rigtige værdier når beskeden sendes. Variablene skal indsættes nøjagtig som vist herunder. Følgende variable kan bruges:
%badgename%: Vil blive erstattet med badgens fulde navn.
%username%: Vil blive erstattet med modtagerens fulde navn.
%badgelink%: Vil blive erstattet med den offentlige URL med information om den tildelte badge.';
$string['verifyemail'] = 'Bekræft e-mail';
$string['version'] = 'Version';
$string['version_help'] = 'Versionsfeltet kan anvendes til at følge udviklingen af mærket. Hvis angivet, vises versionen på mærkesiden.';
$string['viewbadge'] = 'Vis udstedt badge';
$string['visible'] = 'Synlig';
$string['warnexpired'] = '(Dette badge er udløbet!)';
$string['year'] = 'År';
