<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'ai', language 'da', version '5.0'.
 *
 * @package     ai
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acceptai'] = 'Accepter og fortsæt';
$string['action'] = 'Handling';
$string['action_explain_text'] = 'Forklar tekst';
$string['action_explain_text_desc'] = 'Forklarer tekstindholdet på en kursside.';
$string['action_explain_text_instruction'] = 'Okay, forstået. Her er en direkte oversættelse:

Du vil modtage en tekstinput fra brugeren. Din opgave er at forklare den angivne tekst. Følg disse retningslinjer:
1. Udfold: Udvid på nøgleideer og koncepter, og sørg for at forklaringen tilføjer meningsfuld dybde og undgår at gentage teksten ordret.
2. Forenkl: Opdel komplekse termer eller ideer i simplere komponenter, hvilket gør dem lette at forstå for et bredt publikum, inklusive lærende.
3. Giv kontekst: Forklar hvorfor noget sker, hvordan det fungerer, eller hvad dets formål er. Inkluder relevante eksempler eller analogier for at forbedre forståelsen, hvor det er passende.
4. Organiser logisk: Strukturér din forklaring, så den flyder naturligt, startende med grundlæggende ideer før du bevæger dig til finere detaljer.

Vigtige instruktioner:
1. Returner opsummeringen kun i ren tekst.
2. Inkluder ikke nogen markdown-formatering, hilsner eller platheder.
3. Fokuser på klarhed, korthed og tilgængelighed.

Sørg for at forklaringen er let at læse og effektivt formidler de vigtigste punkter i den originale tekst.';
$string['action_generate_image'] = 'Generer billede';
$string['action_generate_image_desc'] = 'Genererer et billede baseret på en tekstprompt.';
$string['action_generate_text'] = 'Generer tekst';
$string['action_generate_text_desc'] = 'Genererer tekst baseret på en tekstprompt.';
$string['action_generate_text_instruction'] = 'Du vil modtage en tekstinput fra brugeren. Din opgave er at generere tekst baseret på deres anmodning. Følg disse vigtige instruktioner:
    1. Returner resuméet kun i almindelig tekst.
    2. Inkludér ikke markdown-formatering, hilsener eller høflighedsfraser.';
$string['action_summarise_text'] = 'Opsummer tekst';
$string['action_summarise_text_desc'] = 'Opsummerer tekstindholdet på en kursus side.';
$string['action_summarise_text_instruction'] = 'Du vil modtage en tekstinput fra brugeren. Din opgave er at opsummere den angivne tekst. Følg disse retningslinjer:
    1. Forkort: Forkort lange afsnit til nøglepunkter.
    2. Forenkle: Gør kompleks information lettere at forstå, især for elever.

Vigtige instruktioner:
    1. Returner resuméet kun i almindelig tekst.
    2. Inkludér ikke markdown-formatering, hilsener eller høflighedsfraser.
    3. Fokuser på klarhed, kortfattethed og tilgængelighed.

Sørg for, at resuméet er let at læse og effektivt formidler hovedpunkterne i den originale tekst.';
$string['action_translate_text'] = 'Venligst aflever din opgave inden udgangen af ugen.';
$string['action_translate_text_desc'] = 'Oversæt den angivne tekst fra et sprog til et andet.';
$string['actionsettingprovider'] = '{$a} handlingsindstillinger';
$string['actionsettingprovider_desc'] = 'Disse indstillinger styrer, hvordan {$a->providername} udfører handlingen {$a->actionname}.';
$string['actionsettings'] = 'Handlingsindstillinger';
$string['actionsettings_desc'] = 'Disse indstillinger styrer, hvordan AI-handlinger for denne  providerinstans.';
$string['ai'] = 'AI';
$string['aiactionregister'] = 'AI handlingsregister';
$string['aiplacements'] = 'AI placeringer';
$string['aipolicyacceptance'] = 'Accept af AI-politik';
$string['aipolicyregister'] = 'AI politikregister';
$string['aiproviders'] = 'AI-udbydere';
$string['aireports'] = 'AI rapporter';
$string['aiusage'] = 'Brug af AI';
$string['aiusagepolicy'] = 'Politik for brug af AI';
$string['availableplacements'] = 'Vælg hvor AI-handlinger er tilgængelige';
$string['availableplacements_desc'] = 'Placeringer definerer hvordan og hvor AI-handlinger kan anvendes på dit site. Du kan vælge hvilke handlinger der er tilgængelige i hver placering gennem indstillingerne.';
$string['availableproviders'] = 'Administrer de AI-udbydere, der er tilsluttet dit LMS';
$string['availableproviders_desc'] = 'AI providers add AI functionality to your site through \'actions\' like text summarisation or image generation.<br/>
You can manage the actions for each provider in their settings.';
$string['btninstancecreate'] = 'Opret instans';
$string['btninstanceupdate'] = 'Opdater instans';
$string['completiontokens'] = 'Fuldførelsestokens';
$string['completiontokens_help'] = 'Færdiggørelsestokens er tekstenheder, der genereres af AI-modellen som et svar på din input. Længere svar bruger flere tokens, hvilket sandsynligvis vil koste mere.';
$string['configureprovider'] = 'Konfigurer udbyderinstans';
$string['contentwatermark'] = 'Genereret af AI';
$string['createnewprovider'] = 'Opret en ny udbyderinstans';
$string['dateaccepted'] = 'Dato accepteret';
$string['declineaipolicy'] = 'Afvis';
$string['enableglobalratelimit'] = 'Indstil en global hastighedsgrænse';
$string['enableglobalratelimit_help'] = 'Begræns antallet af requests, som AI-udbyderen kan modtage på hele siden hver time.';
$string['enableuserratelimit'] = 'Indstil brugerens hastighedsgrænse';
$string['enableuserratelimit_help'] = 'Begræns antallet af anmodninger, hver bruger kan foretage til AI-udbyderen hver time.';
$string['error:actionnotfound'] = 'Handlingen \'{$a}\' understøttes ikke.';
$string['error:providernotfound'] = 'AI-udbyderinstansen blev ikke fundet.';
$string['globalratelimit'] = 'Maksimalt antal anmodninger på tværs af siden';
$string['globalratelimit_help'] = 'Antallet af site-wide requests, der er tilladt pr. time.';
$string['manageaiplacements'] = 'Administrer AI-placeringer';
$string['manageaiproviders'] = 'Administrer AI-udbydere';
$string['noproviders'] = 'Denne handling er ikke tilgængelig. Ingen <a href="{$a}">AI-udbydere</a> er konfigureret til denne handling.';
$string['placement'] = 'Placering';
$string['placementactionsettings'] = 'Handlinger';
$string['placementactionsettings_desc'] = 'De tilgængelige AI-handlinger for denne placering.';
$string['placementsettings'] = 'Placering-specifikke indstillinger';
$string['placementsettings_desc'] = 'Disse indstillinger styrer, hvordan denne AI-placering forbinder til AI-tjenesten og relaterede operationer.';
$string['privacy:metadata:ai_action_explain_text'] = 'En tabel, der gemmer de forklarende tekstanmodninger, som brugerne har lavet.';
$string['privacy:metadata:ai_action_explain_text:completiontoken'] = 'De fuldførelsestokens, der bruges til at forklare teksten.';
$string['privacy:metadata:ai_action_explain_text:fingerprint'] = 'Den unikke hash, der repræsenterer staten/versionen af modellen og indholdet.';
$string['privacy:metadata:ai_action_explain_text:generatedcontent'] = 'Den faktiske tekst, der er genereret af AI-modellen baseret på inputprompten.';
$string['privacy:metadata:ai_action_explain_text:prompt'] = 'Prompten for anmodningen om at forklare teksten.';
$string['privacy:metadata:ai_action_explain_text:prompttokens'] = 'De prompt-tokens, der bruges til at forklare teksten.';
$string['privacy:metadata:ai_action_explain_text:responseid'] = 'Responsets ID.';
$string['privacy:metadata:ai_action_generate_image'] = 'En tabel der gemmer de anmodninger om billedgenerering som brugerne har foretaget.';
$string['privacy:metadata:ai_action_generate_image:aspectratio'] = 'Forholdet mellem bredde og højde af de genererede billeder.';
$string['privacy:metadata:ai_action_generate_image:numberimages'] = 'Antallet af genererede billeder.';
$string['privacy:metadata:ai_action_generate_image:prompt'] = 'Prompten for anmodningen om billedgenerering.';
$string['privacy:metadata:ai_action_generate_image:quality'] = 'Kvaliteten af de genererede billeder.';
$string['privacy:metadata:ai_action_generate_image:revisedprompt'] = 'Den reviderede prompt for de genererede billeder.';
$string['privacy:metadata:ai_action_generate_image:sourceurl'] = 'Kilde-URL\'en for de genererede billeder.';
$string['privacy:metadata:ai_action_generate_image:style'] = 'Stilen af de genererede billeder.';
$string['privacy:metadata:ai_action_generate_text'] = 'En tabel der gemmer de tekstgenereringsanmodninger der er lavet af brugerne.';
$string['privacy:metadata:ai_action_generate_text:completiontoken'] = 'De fuldførelsestokens, der anvendes til at generere teksten.';
$string['privacy:metadata:ai_action_generate_text:fingerprint'] = 'Den unikke hash, der repræsenterer tilstanden/versionen af modellen og indholdet.';
$string['privacy:metadata:ai_action_generate_text:generatedcontent'] = 'Den faktiske tekst genereret af AI-modellen baseret på inputprompten.';
$string['privacy:metadata:ai_action_generate_text:prompt'] = 'Prompten for anmodningen om tekstgenerering.';
$string['privacy:metadata:ai_action_generate_text:prompttokens'] = 'De prompt tokens, der anvendes til at generere teksten.';
$string['privacy:metadata:ai_action_generate_text:responseid'] = 'ID\'et for svaret.';
$string['privacy:metadata:ai_action_register'] = 'En tabel der gemmer de handlingsanmodninger der er lavet af brugerne.';
$string['privacy:metadata:ai_action_register:actionid'] = 'ID\'et for anmodningen om handling.';
$string['privacy:metadata:ai_action_register:actionname'] = 'Navnet på handlingen af anmodningen.';
$string['privacy:metadata:ai_action_register:model'] = 'Modellen der anvendes til at generere svaret.';
$string['privacy:metadata:ai_action_register:provider'] = 'Navnet på den udbyder, der håndterede anmodningen.';
$string['privacy:metadata:ai_action_register:success'] = 'Status for anmodningen om handling.';
$string['privacy:metadata:ai_action_register:timecompleted'] = 'Det fuldførte tidspunkt for anmodningen.';
$string['privacy:metadata:ai_action_register:timecreated'] = 'Tidspunktet for oprettelsen af anmodningen.';
$string['privacy:metadata:ai_action_register:userid'] = 'ID\'et på brugeren, der lavede anmodningen.';
$string['privacy:metadata:ai_action_summarise_text'] = 'En tabel der gemmer de opsummerede tekstanmodninger foretaget af brugere.';
$string['privacy:metadata:ai_action_summarise_text:completiontoken'] = 'De fuldførelsestokens, der anvendes til at opsummere teksten.';
$string['privacy:metadata:ai_action_summarise_text:fingerprint'] = 'Den unikke hash, der repræsenterer tilstanden/versionen af modellen og indholdet.';
$string['privacy:metadata:ai_action_summarise_text:generatedcontent'] = 'Den faktiske tekst genereret af AI-modellen baseret på inputprompten.';
$string['privacy:metadata:ai_action_summarise_text:prompt'] = 'Prompten for anmodningen om at opsummere teksten.';
$string['privacy:metadata:ai_action_summarise_text:prompttokens'] = 'De prompt tokens, der anvendes til at opsummere teksten.';
$string['privacy:metadata:ai_action_summarise_text:responseid'] = 'ID\'et for svaret.';
$string['privacy:metadata:ai_policy_register'] = 'En tabel der opbevarer status for accept af AI-politikken for hver bruger.';
$string['privacy:metadata:ai_policy_register:contextid'] = 'ID\'en for den kontekst, hvis data blev gemt.';
$string['privacy:metadata:ai_policy_register:timeaccepted'] = 'Tidspunktet hvor brugeren accepterede AI-politikken.';
$string['privacy:metadata:ai_policy_register:userid'] = 'ID\'et på brugeren, hvis data blev gemt.';
$string['prompttokens'] = 'Prompt tokens';
$string['prompttokens_help'] = 'Prompt-tokens er tekstenheder, der udgør det input, du sender til AI-modellen. Længere input bruger flere tokens, hvilket sandsynligvis vil koste mere.';
$string['provider'] = 'Udbyder';
$string['provideractionsettings'] = 'Handlinger';
$string['provideractionsettings_desc'] = 'Vælg og konfigurer de handlinger, som {$a} kan udføre på dit site.';
$string['providerinstanceactionupdated'] = '{$a} handlingsindstillinger opdateret';
$string['providerinstancecreated'] = '{$a} AI Provider instans oprettet';
$string['providerinstancedelete'] = 'Slet AI-udbyderinstans';
$string['providerinstancedeleteconfirm'] = 'Du er ved at slette AI Provider-instansen: "{$a->name} ({$a->provider})". Er du sikker?';
$string['providerinstancedeleted'] = '{$a} AI Provider instans slettet';
$string['providerinstancedeletefailed'] = 'Kan ikke slette {$a} AI Provider-instansen. Udbyderen er enten i brug, eller der er et databaseproblem. Tjek om den private er aktiv, eller kontakt din databaseadministrator for hjælp.';
$string['providerinstancedisablefailed'] = 'Kan ikke deaktivere AI Provider-instansen. Leverandøren er enten i brug, eller der er et databaseproblem. Tjek om leverandøren er aktiv, eller kontakt din databaseadministrator for hjælp.';
$string['providerinstanceupdated'] = '{$a} AI Provider instans opdateret';
$string['providermoveddown'] = '{$a} flyttet ned.';
$string['providermovedup'] = '{$a} flyttet op.';
$string['providername'] = 'Navn for eksempel';
$string['providers'] = 'Udbydere';
$string['providersettings'] = 'Indstillinger';
$string['providertype'] = 'Vælg AI-udbyder-plugin';
$string['timegenerated'] = 'Tid genereret';
$string['unknownvalue'] = '---';
$string['userpolicy'] = '<b>Velkommen til den nye AI-funktion!</b>


Denne Kunstige Intelligens (AI) funktion er udelukkende baseret på eksterne Store Sproglige Modeller (LLM) for at forbedre din lærings- og undervisningsoplevelse. Før du begynder at bruge disse AI-tjenester, bedes du læse denne brugsvejledning.


<b>Nøjagtigheden af AI-genereret indhold</b>


AI kan give nyttige forslag og information, men nøjagtigheden kan variere. Du bør altid dobbelt-tjekke de givne informationer for at sikre, at de er nøjagtige, komplette og passende til din specifikke situation.


<b>Hvordan dine data behandles</b>


Denne AI-funktion bruger eksterne Store Sproglige Modeller (LLM). Hvis du bruger denne funktion, vil enhver information eller personlige data, du deler, blive behandlet i henhold til disse LLM\'er privatlivspolitik. Vi anbefaler, at du læser deres privatlivspolitik for at forstå, hvordan de vil håndtere dine data.
Desuden kan en registrering af dine interaktioner med AI-funktionerne blive gemt på denne side.


Hvis du har spørgsmål om, hvordan dine data behandles, bedes du kontakte dine undervisere eller din læringsorganisation.


Ved at fortsætte, anerkender du, at du forstår og accepterer denne politik.';
$string['userratelimit'] = 'Maksimalt antal anmodninger pr. bruger';
$string['userratelimit_help'] = 'Antallet af requests, der er tilladt pr. time pr. bruger.';
