<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_kopere_bi', language 'ru', version '4.5'.
 *
 * @package     local_kopere_bi
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['active_enrolments'] = 'Активные зачисления';
$string['all_learners'] = 'Все участники';
$string['area_desc'] = 'Создает диаграмму с областями';
$string['area_name'] = 'Диаграмма с областями';
$string['block_add'] = 'Добавить новый блок';
$string['block_delete_message'] = 'Вы действительно хотите навсегда удалить этот блок и его отчеты?';
$string['block_delete_title'] = 'Удалить блок';
$string['block_extra'] = 'Очень продвинутые параметры диаграммы';
$string['block_not_found'] = 'Блок не найден';
$string['block_theme'] = 'Тема блока';
$string['block_theme_blue'] = 'Синяя тема';
$string['block_theme_dark'] = 'Темная тема';
$string['block_theme_green'] = 'Зеленая тема';
$string['block_theme_light'] = 'Светлая тема (по умолчанию)';
$string['block_theme_orange'] = 'Оранжевая тема';
$string['block_theme_pink'] = 'Розовая тема';
$string['blocktype_not_found'] = 'Тип блока не найден';
$string['c_format'] = 'Формат курса';
$string['c_fullname'] = 'Полное название курса';
$string['c_id'] = 'ID курса';
$string['c_shortname'] = 'Краткое название';
$string['c_tempo'] = 'Проведенное время';
$string['c_timemodified'] = 'Изменено';
$string['c_visible'] = 'Видимый';
$string['ca_completed_activities'] = 'Выполненные элементы';
$string['cache_time'] = 'Время кэширования';
$string['cache_time_15min'] = '15 минут';
$string['cache_time_1d'] = '24 часа';
$string['cache_time_1h'] = '1 час';
$string['cache_time_30min'] = '30 минут';
$string['cache_time_6h'] = '6 часов';
$string['cache_time_desc'] = 'Время, в течение которого результаты SQL должны оставаться в кэше перед очисткой';
$string['cache_time_no'] = 'Не кэшировать';
$string['cachedef_block_chart_data_none'] = 'Кэш данных диаграммы без данных';
$string['cachedef_ip_user_location'] = 'Кэш местоположения пользователя по IP';
$string['cachedef_mustache_nosql'] = 'Кэш данных Mustache не для SQL';
$string['cachedef_mustache_sql'] = 'Кэш данных Mustache для SQL';
$string['cat_delete'] = 'Удалить категорию';
$string['cat_description'] = 'Описание категории';
$string['cat_edit'] = 'Редактировать категорию';
$string['cat_name'] = 'Название категории';
$string['cat_new'] = 'Новая категория';
$string['cat_not_found'] = 'Категория не найдена';
$string['cat_title'] = 'Категория';
$string['cat_upload'] = 'Загрузить файл шаблона';
$string['cat_upload_filetitle'] = 'Выберите и загрузите JSON-файл, экспортированный из Kopere BI.';
$string['category_delete_confirm'] = 'Удаление категории';
$string['category_delete_message'] = 'Вы действительно хотите удалить категорию <strong>{$a}</strong> и все страницы и блоки?';
$string['cc_id'] = 'Пройденные курсы';
$string['chart_area_default'] = 'Конфигурация диаграммы с областями по умолчанию';
$string['chart_column_default'] = 'Конфигурация столбчатой диаграммы по умолчанию';
$string['chart_default_desc'] = 'Изменение этого значения не повлияет ни на какие существующие диаграммы.<br>Редактируйте только в том случае, если вы знакомы с Apex Charts. Подробнее на сайте <a target="_blank" href="https://apexcharts.com/docs/series/">apexcharts.com/docs</a>.';
$string['chart_line_default'] = 'Конфигурация линейной диаграммы по умолчанию';
$string['chart_pie_default'] = 'Конфигурация круговой диаграммы по умолчанию';
$string['city_name'] = 'Город';
$string['class_not_found'] = 'Класс не найден';
$string['click_new_block'] = 'Нажмите на тип блока, который вы хотите добавить.';
$string['client_name'] = 'Браузер';
$string['client_version'] = 'Версия';
$string['cm_cmid'] = 'ID модуля курса';
$string['column_desc'] = 'Создает столбчатую диаграмму';
$string['column_name'] = 'Столбчатая диаграмма';
$string['completed_learners'] = 'Студенты, завершившие курсы';
$string['completion_status'] = 'Отслеживание';
$string['completionstate_status'] = 'Завершение';
$string['country_name'] = 'Страна';
$string['course_completed'] = 'Процент завершения';
$string['create_report'] = 'Создать отчет';
$string['css_extra'] = 'Дополнительный CSS';
$string['css_extra_desc'] = 'Добавьте стили CSS или SCSS к этому блоку.<br> Добавленный CSS будет применяться только к содержимому этого блока и не окажет никакого влияния на другие части Moodle.';
$string['data_not_found'] = 'Данные не найдены.';
$string['delete_report_text'] = 'Вы действительно хотите удалить этот отчет?';
$string['delete_report_title'] = 'Удаление отчета';
$string['e_enrol'] = 'Тип зачисления';
$string['edit_report'] = 'Редактировать отчет';
$string['enrol_status'] = 'Состояние зачисления';
$string['enrol_timeend'] = 'Окончание зачисления';
$string['error_chart_renderer'] = 'Ошибка при отображении диаграммы';
$string['error_data_loader'] = 'Ошибка загрузки данных диаграммы';
$string['expired_enrolments'] = 'Просроченные зачисления';
$string['extra_langs_customs_title'] = 'Для помощи вам с новыми строками некоторые поля оставлены пустыми:';
$string['extra_langs_filter_component'] = 'Компонент';
$string['extra_langs_header_lang_key'] = 'Новый ключ';
$string['extra_langs_header_string'] = 'Имеющийся текст';
$string['extra_langs_title'] = 'Имеющиеся ключи:';
$string['extra_options'] = 'Расширенные параметры блока';
$string['firstname'] = 'Имя участника';
$string['g_finalgrade'] = 'Итоговая оценка';
$string['grade'] = 'Оценка';
$string['grade_course'] = 'Оценка курса';
$string['html_after'] = 'Необязательный дополнительный текст (в текстовом формате, HTML или в формате Mustache), отображаемый после диаграммы.';
$string['html_before'] = 'Необязательный дополнительный текст (в текстовом формате, HTML или в формате Mustache), отображаемый над диаграммой';
$string['html_block'] = 'HTML-блок с поддержкой Mustache';
$string['html_block_desc'] = '<p>HTML-код, добавляемый в это поле, должен соответствовать формату <strong>Mustache</strong>, что позволяет динамически подставлять данные на страницах. Используйте в HTML-коде двойные фигурные скобки <code>{{ }}</code> для прямого обращения к значениям столбцов SQL, обеспечивая корректную вставку данных.</p>
<blockquote>
<p>Например, используйте следующий SQL-запрос:</p>
<pre>SELECT firstname, lastname, email FROM mdl_user WHERE id = :userid</pre>
<p>Вы можете в HTML-коде ссылаться на возвращаемые значения, используя следующий синтаксис:</p>
<pre>&lt;p&gt;Электронная почта: {{{email}}}&lt;/p&gt;
&lt;p&gt;Полное имя: {{{firstname}}} {{{lastname}}}&lt;/p&gt;</pre>
</blockquote>
<blockquote>
<p>В этом примере отображается несколько строк из результата SQL-запроса, возвращающего список пользователей, зарегистрированных вручную. Для этого используется следующий SQL-запрос:</p>
<pre>SELECT firstname, lastname, email FROM mdl_user WHERE auth = \'manual\'</pre>
<p>Для итерации результатов и отображения данных в табличном формате в шаблоне используется <code>{{#lines}}</code>, чтобы повторить содержимое каждой возвращаемой записи. Шаблон будет выглядеть следующим образом:</p>
<pre>&lt;table class="table table-bordered"&gt;
&lt;tr&gt;
&lt;th&gt;E-mail&lt;/th&gt;
&lt;th&gt;Полное имя&lt;/th&gt;
&lt;/tr&gt;
<strong>{{#lines}}</strong>
&lt;tr&gt;
&lt;td&gt;{{{email}}}&lt;/td&gt;
&lt;td&gt;{{{firstname}}} {{{lastname}}}&lt;/td&gt;
&lt;/tr&gt;
<strong>{{/lines}}</strong>
&lt;/table&gt;</pre>
</blockquote>
<p>Тройные фигурные скобки <code>{{{ }}}</code> позволяют вставлять значение без экранирования HTML, что полезно для отображения контента, который может содержать HTML-теги.</p>
<p>Дополнительную информацию об использовании шаблонов Mustache в Moodle см. в официальной документации: <a href="https://moodledev.io/docs/guides/templates" target="_blank">Руководство по шаблонам Moodle</a>.</p>';
$string['html_desc'] = 'Отображает HTML-блок с данными из базы данных';
$string['html_name'] = 'HTML-блок';
$string['inactive_enrolments'] = 'Неактивные зачисления';
$string['info_desc'] = 'Просто информация. Идеально подходит для отображения имени участника, статуса зачисления и т. д.';
$string['info_error_sql'] = 'Ошибка выполнения SQL';
$string['info_name'] = 'Информационная строка';
$string['info_sql_warning'] = 'Помните, что приведенный ниже SQL-запрос должен возвращать только одну строку с одним столбцом.';
$string['integracaoroot'] = 'Интеграции';
$string['item_not_found'] = 'Элемент не найден';
$string['kopere_bi:manage'] = 'Управлять бизнес-аналитикой';
$string['kopere_bi:view'] = 'Просматривать бизнес-аналитику';
$string['l_ip'] = 'IP';
$string['l_timecreated'] = 'Создано';
$string['line_desc'] = 'Создает линейную диаграмму';
$string['line_name'] = 'Линейная диаграмма';
$string['line_sql_warning'] = '<p>Помните, что приведенный ниже SQL-запрос должен иметь следующую структуру:</p>
<ul>
<li>Первый столбец должен содержать текст, который будет использоваться в качестве названия оси X.</li>
<li>Остальные столбцы должны быть структурированы следующим образом:
<ul>
<li>Название столбца будет использоваться в качестве названия ряда. Вы можете использовать строки перевода, как описано на
<a href="?classname=bi-extra_langs&method=index" target="_blank">странице строк</a>.</li>
<li>Значение столбца будет представлять собой ряд данных на диаграмме.</li>
</ul>
</li>
</ul>
<blockquote>В примере ниже первый столбец возвращает название курса, а второй — количество новых элементов для каждого курса:
<pre>SELECT fullname,
newsitems AS "Course news items count"
FROM mdl_course</pre></blockquote>
<blockquote>В примере ниже, помимо названия курса в первом столбце, на диаграмме генерируются две дополнительные строки с переведёнными названиями столбцов:
<pre> SELECT c.fullname AS course_name,
COUNT(cm.section) AS \'lang::thiscourse::theme_rebel\',
COUNT(cm.module) AS \'lang::ca_completed_activities::local_kopere_bi\'
FROM mdl_course AS c
JOIN mdl_course_modules AS cm ON c.id = cm.course
GROUP BY c.id</pre></blockquote>';
$string['loading'] = 'Загрузка...';
$string['maps_1_city'] = '{a1} и еще один город';
$string['maps_desc'] = 'Создает карту с участнмками в сети на основе их IP-адресов';
$string['maps_many_city'] = '{a1} и еще городов - {a2}';
$string['maps_name'] = 'Карта участников в сети.';
$string['maps_online'] = 'участники в сети - {a1}';
$string['maps_onlines'] = 'Студентов в сети - {a1}';
$string['maps_sql_warning'] = '<p>Помните, что приведенный ниже SQL-запрос должен возвращать только один столбец, и этот столбец должен содержать действительный IP-адрес.<br>Пример: SQL-запрос <code>SELECT lastip FROM {user} WHERE lastaccess > UNIX_TIMESTAMP() - (10 * 60)</code> возвращает всех студентов, которые обращались к сайту Moodle за последние 10 минут</p>';
$string['module_count'] = 'Количество модулей';
$string['module_name'] = 'Название модуля';
$string['modulename'] = 'Бизнес-аналитика';
$string['new_block'] = 'Новый блок на этой странице';
$string['new_block_1'] = 'Один блок';
$string['new_block_12'] = 'Один плюс два блока';
$string['new_block_2'] = 'Два блока';
$string['new_block_21'] = 'Два плюс один блок';
$string['new_block_25'] = 'Один широкий и один узкий';
$string['new_block_3'] = 'Три блока';
$string['new_block_4'] = 'Четыре блока';
$string['new_block_52'] = 'Один узкий и один широкий';
$string['not_accessed_learners'] = 'Студенты, которые не получили доступ к платформе';
$string['not_completed_learners'] = 'Студенты, не окончившие курсы';
$string['num_activelearners'] = 'Количество активных участников';
$string['num_completedlearners'] = 'Количество студентов, окончивших курсы';
$string['num_courses'] = 'Количество доступных курсов';
$string['num_learners'] = 'Общее количество участников';
$string['num_user'] = 'Количество участников';
$string['os_name'] = 'Операционная система';
$string['page_delete_confirm'] = 'Удаление страницы';
$string['page_delete_message'] = 'Вы действительно хотите удалить страницу <strong>{$a}</strong> со всеми блоками?';
$string['page_description'] = 'Описание страницы';
$string['page_edit'] = 'Редактировать страницу';
$string['page_name'] = 'Название страницы';
$string['page_new_cat'] = 'Добавить новую страницу в эту категорию';
$string['page_new_sequence'] = 'Перетащите блоки для изменения их порядка.';
$string['page_not_found'] = 'Страница не найдена';
$string['page_preview'] = 'Предварительный просмотр страницы';
$string['page_title_edit'] = 'Изменить название этой страницы';
$string['page_title_export'] = 'Экспорт страницы';
$string['pie_desc'] = 'Создает круговую диаграмму';
$string['pie_name'] = 'Круговая диаграмма';
$string['pie_sql_warning'] = '<p>Приведенный ниже SQL-запрос должен возвращать только два столбца.</p><p>Первый столбец будет именем столбца, а второй столбец должен быть числовым значением.</p>';
$string['pluginname'] = 'Бизнес-аналитика';
$string['privacy:metadata:city_name'] = 'Название города пользователя.';
$string['privacy:metadata:client_name'] = 'Название приложения или браузера, используемого пользователем.';
$string['privacy:metadata:client_type'] = 'Что используется пользователем, браузер или приложение.';
$string['privacy:metadata:client_version'] = 'Версия приложения или браузера.';
$string['privacy:metadata:country_code'] = 'Код страны пользователя.';
$string['privacy:metadata:country_name'] = 'Название страны пользователя.';
$string['privacy:metadata:day'] = 'День входа';
$string['privacy:metadata:lastip'] = 'Последний зарегистрированный IP-адрес пользователя.';
$string['privacy:metadata:latitude'] = 'Широта местонахождения пользователя во время доступа.';
$string['privacy:metadata:local_kopere_bi_online'] = 'Таблица, в которой хранится информация для анализа о пользователях, находящихся в данный момент в сети.';
$string['privacy:metadata:local_kopere_bi_statistic'] = 'Таблица для хранения анализируемых статистических данных.';
$string['privacy:metadata:longitude'] = 'Долгота местоположения пользователя во время доступа.';
$string['privacy:metadata:month'] = 'Месяц входа.';
$string['privacy:metadata:os_name'] = 'Название операционной системы, используемой пользователем.';
$string['privacy:metadata:os_version'] = 'Версия операционной системы, используемой пользователем.';
$string['privacy:metadata:seconds'] = 'Секунды времени входа.';
$string['privacy:metadata:user_id'] = 'Уникальный идентификатор пользователя.';
$string['privacy:metadata:userid'] = 'Идентификатор пользователя для конкретных записей.';
$string['privacy:metadata:weekday'] = 'Будний день входа.';
$string['privacy:metadata:year'] = 'Год входа.';
$string['reload_time'] = 'Перезагружать данные каждые';
$string['reload_time_10m'] = '10 минут';
$string['reload_time_1h'] = '1 час';
$string['reload_time_1m'] = '1 минуту';
$string['reload_time_20m'] = '20 минут';
$string['reload_time_2h'] = '2 часа';
$string['reload_time_30m'] = '30 минут';
$string['reload_time_40m'] = '40 минут';
$string['reload_time_50m'] = '50 минут';
$string['reload_time_5m'] = '5 минут';
$string['reload_time_desc'] = 'Перезагружать данные каждые X минут. Это значение должно быть больше значения в кэше!';
$string['reload_time_none'] = 'Никогда';
$string['report_1_cat_description'] = 'Отчеты об успеваемости студентов и прохождениях курсов.';
$string['report_1_cat_title'] = 'Студенты';
$string['report_1_categories'] = 'Категории';
$string['report_1_description'] = 'Отчеты об участниках';
$string['report_1_modules'] = 'Модули';
$string['report_1_title'] = 'Активные студенты';
$string['report_1_user_status'] = 'Статус участника';
$string['report_1_user_summary'] = 'Сводка об активных студентах';
$string['report_1_users'] = 'Студенты';
$string['report_2_cat_description'] = 'Комплексный анализ всех доступных курсов, успеваемости, прогресса и развития студентов.';
$string['report_2_cat_title'] = 'Курсы';
$string['report_2_completion_progress'] = 'Процент выполнения';
$string['report_2_course_access_statistics'] = 'Статистика доступа к курсу';
$string['report_2_course_analysis_participation_completion'] = 'Анализ курса: участие и завершение';
$string['report_2_course_progress'] = 'Ход прохождения курса';
$string['report_2_description'] = 'Отчет о курсе';
$string['report_2_title'] = 'Курсы';
$string['report_2_total_engagement'] = 'Общая вовлеченность по курсам';
$string['report_3_cat_description'] = 'Отчет обо всех, кто в сети на Moodle';
$string['report_3_cat_title'] = 'В сети';
$string['report_3_course_access_time'] = 'Время доступа к курсу';
$string['report_3_course_last30days'] = 'Данные только за последние 30 дней';
$string['report_3_description'] = 'Показывает студентов в сети из лучших регионов';
$string['report_3_operating_systems'] = 'Операционные системы с наибольшим временем доступа';
$string['report_3_title'] = 'Пользователи в сети';
$string['report_3_top_browsers'] = 'Браузеры с наибольшим временем доступа';
$string['report_3_top_country_access'] = 'Города и страны с наибольшей продолжительностью доступа';
$string['report_3_users_online'] = 'Пользователи в сети';
$string['report_3_users_online_list'] = 'Список пользователей в сети';
$string['report_4_cat_description'] = 'Отчеты о зачислении, охватывающие историю, текущее состояние и тенденции зачисления на курсы.';
$string['report_4_cat_title'] = 'Зачисления';
$string['report_4_completion_0'] = 'Отслеживание выполнения для этого элемента отключено';
$string['report_4_completion_1'] = 'Для этого элемента включено отслеживание выполнения вручную';
$string['report_4_completion_2'] = 'Для этого элемента включено автоматическое отслеживание выполнения';
$string['report_4_completion_none'] = 'Выполнение неизвестно';
$string['report_4_completionstate_0'] = 'Элемент не выполнен';
$string['report_4_completionstate_1'] = 'Элемент выполнен, но пройден успешно или нет, не указано';
$string['report_4_completionstate_2'] = 'Элемент выполнен с оценкой выше проходного балла';
$string['report_4_completionstate_3'] = 'Элемент выполнен с оценкой ниже проходного балла';
$string['report_4_completionstate_4'] = 'Не удалось найти скрытый элемент';
$string['report_4_completionstate_none'] = 'Выполнение неизвестно';
$string['report_4_coursesenrollmentstatus'] = 'Состояние зачисления на курсы';
$string['report_4_description'] = 'Отчеты о зачислении, охватывающие историю, текущее состояние и тенденции зачисления на курсы.';
$string['report_4_enrolpercourse'] = 'Участники курса';
$string['report_4_title'] = 'Статистика';
$string['report_5_cat_description'] = 'В этом отчете представлен обзор ключевых показателей системы и информации, позволяющей провести всесторонний анализ производительности и работы системы.';
$string['report_5_cat_title'] = 'Система';
$string['report_5_component'] = 'Компонент';
$string['report_5_coursefilesizes'] = 'Файлы курса';
$string['report_5_coursefilesizes_title'] = 'Пространство, занимаемое каждым курсом';
$string['report_5_description'] = 'Общий отчет содержит подробную информацию обо всех аспектах системы, включая данные об использовании, производительности и областях, требующих улучшения. Идеально подходит для администраторов и управляющих, стремящихся оптимизировать эффективность системы.';
$string['report_5_filesize'] = 'Размер файла';
$string['report_5_filesizes'] = 'Размеры файлов';
$string['report_5_modulesdeleting'] = 'Удаление модулей';
$string['report_5_modulesfilesizes'] = 'Файлы модулей';
$string['report_5_numfiles'] = 'Количество файлов';
$string['report_5_title'] = 'Общий';
$string['report_5_upload_title'] = 'Пространство, занимаемое каждым модулем';
$string['report_6_cat_description'] = 'Мониторинг и статистика входов в систему';
$string['report_6_cat_title'] = 'Отчеты о входе в систему';
$string['report_6_login'] = 'Входы';
$string['report_6_login_report'] = 'Отчет о входе в Moodle';
$string['report_7_inactive'] = 'Неактивные зачисления';
$string['report_7_inactive_report'] = 'Отчет о неактивных зачислениях';
$string['report_7_users_not_accessed_course'] = 'Зарегистрированные пользователи, которые не получили доступ к своему курсу';
$string['report_8_engagement'] = 'Участие';
$string['report_8_student_teacher_engagement'] = 'Отчет об участии студентов и учителей';
$string['report_8_teacher_access'] = 'Доступ учителей';
$string['report_8_total_engagement_per_course'] = 'Общее участие в курсе';
$string['report_9_category_desc'] = 'Отчет по модулям курса';
$string['report_9_category_title'] = 'Модули курса';
$string['report_9_report_1_name'] = 'Статистика по модулям';
$string['report_dashboard_cat_title'] = 'Панель управления';
$string['report_dashboard_page_1_cursos'] = 'Курсы / Видимые';
$string['report_dashboard_page_1_newusers'] = 'Новые пользователи за последние 12 месяцев';
$string['report_dashboard_page_1_online'] = 'Онлайн / Последний час';
$string['report_dashboard_page_1_title'] = 'Панель управления';
$string['report_dashboard_page_1_users'] = 'Пользователи / Активные';
$string['report_new'] = 'Новый отчет для «{$a}»';
$string['report_preview'] = 'Предварительный просмотр отчета';
$string['report_save'] = 'Сохранить и перейти к настройке столбцов';
$string['report_title'] = 'Название отчета';
$string['reports_selectcourse'] = 'Выберите курс для создания отчета';
$string['reports_selectuser'] = 'Выберите участника для создания отчета';
$string['return_edit'] = '<< Вернуться к редактированию';
$string['rolename'] = 'Название роли';
$string['save'] = 'Сохранить';
$string['seconds'] = 'Сколько';
$string['select_report_select_type'] = 'Выберите тип отчета';
$string['select_report_select_type_desc'] = 'Сначала выберите, какой тип отчета вы хотите использовать для этого блока.';
$string['select_report_type'] = 'Тип отчета';
$string['select_report_type_desc'] = 'Вы можете переключаться между типами «{$a->line}», «{$a->area}» или «{$a->column}».';
$string['setting_apex'] = 'Настройки диаграмм Apex';
$string['setting_apex_desc'] = 'Редактируйте только в том случае, если вы знакомы с диаграммами Apex. Подробнее смотрите на сайте <a target="_blank" href="https://apexcharts.com/docs/series/">apexcharts.com/docs </a>';
$string['sql_no_rows'] = 'SQL-запрос вернул 0 строк. Для настройки столбцов SQL-запрос должен вернуть хотя бы 1 строку.';
$string['sql_read_only'] = 'Все SQL-запросы защищены подключением только для чтения и выполнение команд INSERT/UPDATE/DELETE невозможно.';
$string['sql_replace_keys'] = '<h4>Сменные ключи</h4>
<ul>
<li><b>:userid</b> ID студента для создания отчёта.</li>
<li><b>:courseid</b> ID курса для создания отчёта.</li>
</ul>
<h4>Многоязычность</h4>
<p>Для возврата столбцов, которые будут переведены на основе языковых пакетов Moodle, требуется специальный формат, позволяющий обрабатывать и правильно локализовать строки. Правильный формат:</p>
<pre>lang::{identifier}::{component}</pre>
<p>Где:</p>
<ul>
<li><b>{identifier}</b>: Идентификатор строки, который будет использоваться для получения перевода из языкового пакета.</li>
<li><b>{component}</b>: Ссылка на компонент, в котором определена языковая строка, и обычно представляет собой имя плагина (например, <code>mod_forum</code>, <code>local_kopere_dashboard</code>, <code>theme_degrade</code>).</li>
</ul>
<p><em>Пример: Если вам нужно вернуть переведённую строку для компонента <code>mod_forum</code> с идентификатором <code>postmessage</code>, возвращаемый результат должен быть структурирован следующим образом:</em></p>
<pre>SELECT \'<b>lang::postmessage::mod_forum</b>\' FROM mdl_forum</pre>
<p>Посетите <a href="?classname=bi-extra_langs&method=index" target="_blank">страницу строк</a>, чтобы увидеть все доступные строки.</p>';
$string['sql_replace_keys_mdl'] = '<h4>Префикс базы данных</h4>
<p>Вы всегда можете использовать префикс <code>mdl_</code>, даже если в вашей базе данных используется префикс <code>{$a}</code>.
Бизнес-аналитика выполнит эту замену.</p>';
$string['table_col_title'] = 'Название столбца';
$string['table_column_not_configured'] = 'Столбцы в этой таблице не настроены';
$string['table_desc'] = 'Отображает таблицу с разбивкой данных на страницы.';
$string['table_edit_column'] = 'Столбец';
$string['table_first_5'] = 'Первые пять записей запроса';
$string['table_info_topo'] = 'Сначала вы увидите предварительный просмотр результатов поиска. Затем вам будет представлен ряд столбцов, которым вы сможете дать названия и определить формат данных для каждого столбца.';
$string['table_info_types'] = 'Вы можете задать имя столбца, а затем указать желаемый формат и необходимость дополнительного форматирования с помощью Mustache.
<ul>
<li><strong>Без форматирования</strong>: отображает содержимое в том виде, в котором оно есть, или применяет Mustache, если оно добавлено.</li>
<li><strong>Не показывать этот столбец</strong>: скрывает выбранный столбец в представлении, но данные остаются доступными для обработки Mustache.</li>
<ul><li>Mustache недоступен</li></ul>
<li><strong>Числа</strong>: форматирует столбец для отображения только числовых значений, применяя стандартные правила отображения чисел, такие как разделители тысяч и десятичных дробей.</li>
<ul><li>Mustache недоступен</li></ul>
<li><strong>Преобразовать столбец в полное имя "fullname()"</strong>: запускает функцию <code>fullname()</code> для генерации полного имени на основе языка, которое будет храниться в этом же столбце. Для работы этого необходимо указать столбец <code>lastname</code>, который по возможности следует скрыть.</li>
<li><strong>Создать фотографию профиля по ID студента</strong>: ID из этого столбца используется для создания фотографии профиля.</li>
<li><strong>Двоичное поле «Видимый/Невидимый»</strong>: Использует двоичное значение для определения видимости, где «0»/«false» означает невидимый, а «1»/«true» — видимый.</li>
<li><strong>Двоичное поле «Активное/Неактивное»</strong>: Использует двоичное значение для определения состояния, где «0»/«false» означает неактивное, а «1»/«true» — активное.</li>
<li><strong>Поле «Время» отформатировано как дата</strong>: Преобразует значение времени (метку времени) в столбце в читаемую дату, отображая только дату (день/месяц/год).</li>
<ul><li>Mustache недоступен</li></ul>
<li><strong>Поле «Время» отформатировано как дата и время</strong>: Отображает значение времени (метку времени) в столбце как дату (день/месяц/год) и время (часы:минуты).</li>
<ul><li>Mustache недоступен</li></ul>
<li><strong>Поле «Время» отформатировано как время</strong>: Форматирует значение времени (метку времени) в столбце так, чтобы отображалось только время (часы:минуты), без даты.</li>
<ul><li>Mustache недоступен</li></ul>
</ul>';
$string['table_name'] = 'Таблица данных';
$string['table_renderer_date'] = 'Поле «Время» отформатировано как дата';
$string['table_renderer_datetime'] = 'Поле «Время» отформатировано как дата и время';
$string['table_renderer_filesize'] = 'Преобразует в размер данных на диске';
$string['table_renderer_mustache'] = 'HTML-код
столбца <a href="https://moodledev.io/docs/guides/templates" target="_blank">«Mustache»</a>';
$string['table_renderer_none'] = 'Не показывать этот столбец';
$string['table_renderer_number'] = 'Числа';
$string['table_renderer_seconds'] = 'Поле «Время» отформатировано как время';
$string['table_renderer_status'] = 'Двоичное поле для «Активное/Неактивное»';
$string['table_renderer_title'] = 'Форматирование столбцов';
$string['table_renderer_translate'] = 'Использовать get_string("identifier", "component") для перевода столбца';
$string['table_renderer_userfullname'] = 'Преобразовать столбец в полное имя участника с помощью функции «fullname()»';
$string['table_renderer_userphoto'] = 'Создать фотографию профиля по ID участника';
$string['table_renderer_visible'] = 'Двоичное поле для «Видимый/Невидимый»';
$string['theme_palette_default'] = 'Палитра по умолчанию';
$string['theme_palette_desc'] = 'Цвета палитры:';
$string['theme_palette_desc2'] = 'Посмотреть все темы здесь';
$string['theme_palette_palette'] = 'Палитра {$a}';
$string['theme_palette_title'] = 'Цветовая палитра';
$string['timecompleted'] = 'Зачисление выполнено';
$string['title'] = 'Бизнес-аналитика';
$string['u_fullname'] = 'Имя и фамилия';
$string['u_id'] = 'ID участника';
$string['u_idnumber'] = 'Номер ID';
$string['ue_id'] = 'ID зачисления';
$string['ue_status'] = 'Состояние зачисления';
$string['ue_timecreated'] = 'Зачисление создано в';
$string['ue_timeend'] = 'Зачисление заканчивается в';
$string['ul_timeaccess'] = 'Последний доступ';
$string['use_this_type'] = 'Использовать этот тип';
