<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'auth_db', language 'sr_lt', version '4.5'.
 *
 * @package     auth_db
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['auth_dbcannotconnect'] = 'Nije moguće povezati se sa eksternom bazom podataka.';
$string['auth_dbcannotreadtable'] = 'Nije moguće pročitati eksternu tabelu.';
$string['auth_dbcantconnect'] = 'Nije bilo moguće povetati se navedenom bazom podataka za proveru identiteta...';
$string['auth_dbchangepasswordurl_key'] = 'URL za promenu lozinke';
$string['auth_dbcolumnlist'] = 'Eksterna tabela sadrži sledeće kolone:<br />{$a}';
$string['auth_dbdebugauthdb'] = 'Otklonite ADOdb grešku';
$string['auth_dbdebugauthdbhelp'] = 'Otklonite grešku u ADOdb konekciji sa eksternom bazom podataka - upotrebite u situaciji kada tokom prijave na sistem dobijate praznu stranicu. Nije pogodno za sajtove na kojima ima aktivnih kurseva.';
$string['auth_dbdeleteuser'] = 'Obrisani korisnik {$a->name} id {$a->id}';
$string['auth_dbdeleteusererror'] = 'Greška prilikom brisanja korisnika {$a}';
$string['auth_dbdescription'] = 'Ovaj metod koristi eksterne tabele baze podataka ѕa proveru da li su dato korisničko ime i lozinka ispravni. Ukoliko je nalog nov, onda informacija iz drugih ponja mogu biti prekopirane u Moodleu.';
$string['auth_dbextencoding'] = 'Kodni raspored eksterne baze podataka';
$string['auth_dbextencodinghelp'] = 'Kodni raspored korišćen u eksternoj bazi podataka';
$string['auth_dbextrafields'] = 'Ova polja su opciona. Možete da izaberete da prethodno popunite neka Moodle korisnička polja sa informacijam iz <b>polja eksterne baza podataka</b> koja ovde navedete.<p>Ukoliko ova polja ostavite prazna, biće korišćene podrazumevane vrednosti.</p><p>U svakom slučaju korisnik će moći da uređuje sva ova polja nakon što se prijave na sistem.</p>';
$string['auth_dbfieldpass'] = 'Ime polja koje sadrži lozinke';
$string['auth_dbfieldpass_key'] = 'Polje za lozinku';
$string['auth_dbfielduser'] = 'Naziv polja koje sadrži korisnička imena. Ovo polje mora biti varchar tip podataka';
$string['auth_dbfielduser_key'] = 'Polje korisničkog imena';
$string['auth_dbhost'] = 'Ovaj računar je domaćin servera baze podataka. Upotrebite sistemski DSN unos ako koristite ODBC. Upotrebite PDO DSN unos ako koristite PDO.';
$string['auth_dbhost_key'] = 'Računar domaćin';
$string['auth_dbinsertuser'] = 'Umetnuti korisnik {$a->name} id {$a->id}';
$string['auth_dbinsertuserduplicate'] = 'Greška prilikom ubacivanja korisnika  {$a->username} - korisnik sa ovim korisničkim imenom već je kreiran pomoću dodatka za proveru identiteta \'{$a->auth}\' .';
$string['auth_dbinsertusererror'] = 'Greška prilikom ubacivanja korisnika {$a}';
$string['auth_dbname'] = 'Naziv same baze podataka. Ostavite prazno ako koristite ODBC DSN. Ostavite prazno ako vaš PDO DSN već sadrži naziv baze podataka.';
$string['auth_dbname_key'] = 'Naziv baze podataka';
$string['auth_dbnoexttable'] = 'Eksterna tabela nije navedena.';
$string['auth_dbnouserfield'] = 'Polje eksternog korisnika nije navedeno.';
$string['auth_dbpass'] = 'Lozinka se poklapa sa gornjim korisničkim imenom';
$string['auth_dbpass_key'] = 'Lozinka';
$string['auth_dbpasstype'] = '<p>Odredite format koje koristi polje za lozinku..</p> <p>Upotrebite "interno" ukoliko želite da spoljna baza podataka upravlja korisničkim imenima i elektronskim adresama, a Moodle lozinkama. Ako koristite format "interno", <i>morate</i> da obezbedite polja popunjena elektronskim adresama u eksternoj bazi podataka. Takođe, morate da omogućite planirani zadatak  \\auth_db\\task\\sync_users. Moodle će novim korisnicima poslati e-poruku sa privremenom lozinkom.</p>';
$string['auth_dbpasstype_key'] = 'Format lozinke';
$string['auth_dbreviveduser'] = 'Ponovo aktivirani korisnik {$a->name} id {$a->id}';
$string['auth_dbrevivedusererror'] = 'Greška u ponovnom aktiviranju korisnika {$a}';
$string['auth_dbsaltedcrypt'] = 'Kriptuj jednosmerno hešovanje stringa';
$string['auth_dbsetupsql'] = 'SQL komanda postavaljanja';
$string['auth_dbsetupsqlhelp'] = 'SQL komanda za posebno podešavanje baze podataka, često korišćena za podešavanje kodnog raspored - na primer za MySQL i PostgreSQL: <em>SET NAMES \'utf8\'</em>';
$string['auth_dbsuspenduser'] = 'Suspendovani korisnik {$a->name} id {$a->id}';
$string['auth_dbsuspendusererror'] = 'Greška prilikom suspendovanja korisnika {$a}';
$string['auth_dbsybasequoting'] = 'Koristi navodnike Sybase baze podataka';
$string['auth_dbsybasequotinghelp'] = 'Sybase stil izlaza jednostrukim navodnicima - potrebno za Oracle, MS SQL i neke druge baze podataka. Ne koristiti za  MySQL!';
$string['auth_dbsyncuserstask'] = 'Sinhronizacija korisnika';
$string['auth_dbtable'] = 'Ime tabele u bazi podataka';
$string['auth_dbtable_key'] = 'Tabela';
$string['auth_dbtableempty'] = 'Eksterna tabela je prazna.';
$string['auth_dbtype'] = 'Tip baze podataka (za više informacija pogledajte dokumentaciju <a href="http://adodb.org/dokuwiki/doku.php" target="_blank">ADOdb - Database Abstraction Layer for PHP</a>)';
$string['auth_dbtype_key'] = 'Baza podataka';
$string['auth_dbupdateerror'] = 'Greška pri ažuriranju spoljne baze podataka.';
$string['auth_dbupdateusers'] = 'Ažuriraj korisnike';
$string['auth_dbupdateusers_description'] = 'Osim što ubacuje nove, ažurira i postojeće korisnike';
$string['auth_dbupdatinguser'] = 'Ažuriranje korisnika {$a->name} id {$a->id}';
$string['auth_dbuser'] = 'Korisničko ime sa pravom čitanja baze podataka';
$string['auth_dbuser_key'] = 'Korisnik baze podataka';
$string['auth_dbuserstoadd'] = 'Korisničkih unosa za dodavanje: {$a}';
$string['auth_dbuserstoremove'] = 'Korisničkih unosa za uklanjanje: {$a}';
$string['pluginname'] = 'Eksterna baza podataka';
$string['privacy:metadata'] = 'Dodatak za proveru identiteta Eksterna baza ne čuva nikakve lične podatke.';
