<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'atto_styles', language 'sr_lt', version '4.5'.
 *
 * @package     atto_styles
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['config'] = 'Konfiguracija stilova';
$string['config_desc'] = 'Konfiguracija za dodatke stilova za za Atto editor u JSON formatu.
<hr />
Na primer:<br />
{<br />
&nbsp;&nbsp;&nbsp;&nbsp;"title": "Blue box",<br />
&nbsp;&nbsp;&nbsp;&nbsp;"type": "block",<br />
&nbsp;&nbsp;&nbsp;&nbsp;"classes": "box blue"<br />
},{<br />
&nbsp;&nbsp;&nbsp;&nbsp;"title": "Red text",<br />
&nbsp;&nbsp;&nbsp;&nbsp;"type": "inline",<br />
&nbsp;&nbsp;&nbsp;&nbsp;"classes": "red"<br />
}<br />
<hr />
Atribut <em>title</em> definiše naziv za stil unutar Atto dodatka stilova.<br />
<br />
Naslov, takođe, može da podrži Moodle višejezički filter (ako je uključen), ali dodatni dvostruki navodnici moraće da se izbegnu sa obrnutom kosom crtoma.<br />
Molimo vas, za primer pogledajte README datoteku dodatka.<br />
<hr />
Atribut <em>type</em> može da sadrži jednu ili dve vrednosti: "block" ili "inline".<br />
<br />
"block" će kreirati  oznaku div sa datom klasom(klasama) i funkcionisaće kao element nivoa standardnog bloka. Ovo će preuzeti element nivoa tekućeg bloka i moći će da se primeni više puta, a ne samo na trenutno izabrani tekst.<br />
<br />
"inline" će kreirati oznaku span sa datom klasom(klasama) i funkcionisaće kao standardni  umetnuti element. Ovi će se primeniti samo na trenutno izabrani tekst.
<hr />
Atribut <em>classes</em> preuzima naziv CSS klase koji će biti primenjen na blok / umetnuti tekst.<br />
<br />
Za svaku stavku mogu biti definisane višestruke klase, razdvojene razmakom. Klase će biti primenjene na na blok / umetnuti tekst.<br />
<br />
Definicije CSS klase ne mogu da se prave unutar ovog dodatka. Moraćeta da dodate definicije svojih CSS klasa u vašu grafičku temeu ili dodatna Moodle HTML podešavanja.
<hr />
Na Moodle instalacijama sa bootstrap temama (posebno,  sa temama <em>More</em> i <em>Clean</em>, takođe možete da kreirate stilove sa bootstrap CSS klasama umesto da definišite sopstvene klase.
<br /><br />
Na primer:<br />
{<br />
&nbsp;&nbsp;&nbsp;&nbsp;"title": "Hero unit box",<br />
&nbsp;&nbsp;&nbsp;&nbsp;"type": "block",<br />
&nbsp;&nbsp;&nbsp;&nbsp;"classes": "hero-unit"<br />
},{<br />
&nbsp;&nbsp;&nbsp;&nbsp;"title": "Well",<br />
&nbsp;&nbsp;&nbsp;&nbsp;"type": "block",<br />
&nbsp;&nbsp;&nbsp;&nbsp;"classes": "well"<br />
},{<br />
&nbsp;&nbsp;&nbsp;&nbsp;"title": "Info text",<br />
&nbsp;&nbsp;&nbsp;&nbsp;"type": "inline",<br />
&nbsp;&nbsp;&nbsp;&nbsp;"classes": "label label-info"<br />
},{<br />
&nbsp;&nbsp;&nbsp;&nbsp;"title": "Warning text",<br />
&nbsp;&nbsp;&nbsp;&nbsp;"type": "inline",<br />
&nbsp;&nbsp;&nbsp;&nbsp;"classes": "label label-warning"<br />
}<br /><br />
Za više informacija o bootstrap klasama, molimo vas da posetite sledeće linkove u Bootstrap 2.3 dokumentaciji:
<ul>
<li><a href="http://getbootstrap.com/2.3.2/components.html#labels-badges">Bootstrap oznake i bedževi</a></li>
<li><a href="http://getbootstrap.com/2.3.2/components.html#alerts">Bootstrap upozorenja</a></li>
<li><a href="http://getbootstrap.com/2.3.2/components.html#misc">Bootstrap pomoćne klase</a></li>
</ul>';
$string['nostyle'] = 'Bez stila';
$string['pluginname'] = 'Stilovi';
$string['settings'] = 'Podešavanja stilova';
