<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'role', language 'cs', version '4.5'.
 *
 * @package     role
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addinganewrole'] = 'Přidání nové role';
$string['addrole'] = 'Přidat novou roli';
$string['advancedoverride'] = 'Pokročilé přenastavování rolí';
$string['ai:acceptpolicy'] = 'Přijmout zásady AI';
$string['ai:fetchanyuserpolicystatus'] = 'Získatpřijetí zásad AI pro uživatele';
$string['ai:fetchpolicy'] = 'Získat přijetí zásad AI pro uživatele';
$string['allow'] = 'Povolit';
$string['allowassign'] = 'Povolit přidělování rolí';
$string['allowed'] = 'Povoleno';
$string['allowoverride'] = 'Povolit přenastavování rolí';
$string['allowroletoassign'] = 'Povolit uživatelům s rolí {$a->fromrole} přidělovat roli {$a->targetrole}';
$string['allowroletooverride'] = 'Povolit uživatelům s rolí {$a->fromrole} přenastavovat roli {$a->targetrole}';
$string['allowroletoswitch'] = 'Povolit uživatelům s rolí {$a->fromrole} přepnout roli na {$a->targetrole}';
$string['allowroletoview'] = 'Povolit uživatelům s rolí {$a->fromrole} zobrazení role {$a->targetrole}';
$string['allowswitch'] = 'Povolit přepínání rolí';
$string['allowview'] = 'Povolit role pro zobrazení';
$string['allsiteusers'] = 'Všichni uživatelé na serveru';
$string['analytics:listinsights'] = 'Seznam poznatků';
$string['analytics:listowninsights'] = 'Seznam vlastních poznatků';
$string['analytics:managemodels'] = 'Správa modelů';
$string['archetype'] = 'Archetyp role';
$string['archetype_help'] = 'Archetyp role určuje oprávnění, na která je role nastavena při resetu na výchozí hodnoty. Určuje rovněž, zda budou roli automaticky přidělena nějaká nová oprávnění při upgrade serveru.';
$string['archetypecoursecreator'] = 'Archetyp: Tvůrce kurzu';
$string['archetypeeditingteacher'] = 'Archetyp: Učitel';
$string['archetypefrontpage'] = 'Archetyp: Registrovaný uživatel na ttulní stránce';
$string['archetypeguest'] = 'Archetyp: Host';
$string['archetypemanager'] = 'Archetyp: Manažer';
$string['archetypestudent'] = 'Archetyp: Student';
$string['archetypeteacher'] = 'Archetyp: Učitel bez práv úprav';
$string['archetypeuser'] = 'Archetyp: Registrovaný uživatel';
$string['assignanotherrole'] = 'Přidělit jinou roli';
$string['assignedroles'] = 'Přidělené role';
$string['assignerror'] = 'Chyba při přidělování role {$a->role} uživateli {$a->user}';
$string['assignglobalroles'] = 'Přidělit globální role';
$string['assignmentcontext'] = 'Kontext přidělení';
$string['assignmentoptions'] = 'Možnosti přidělení';
$string['assignrole'] = 'Přidělit roli';
$string['assignrolenameincontext'] = 'Přidělení role "{$a->role}" v kontextu "{$a->context}"';
$string['assignroles'] = 'Přidělit role';
$string['assignroles_help'] = 'Přidělíte-li uživateli v určitém kontextu nějakou roli, přidělujete mu oprávnění definovaná touto roli pro aktuální kontext a pro všechny podřazené
kontexty.

Pokud tedy např. roli Student přidělíte uživateli v kurzu, bude tuto roli mít pro daný kurz, ale také pro všechny bloky a činnosti uvnitř kurzu. Skutečná oprávnění uživatele přitom mohou záviset ještě na dalších rolích a použitých přenastaveních.';
$string['assignroles_link'] = 'admin/roles/assign';
$string['assignrolesin'] = 'Přidělit role v {$a}';
$string['assignrolesrelativetothisuser'] = 'Přidělit role ve vztahu k tomuto uživateli';
$string['backtoallroles'] = 'Zpět na seznam všech rolí';
$string['backup:anonymise'] = 'Anonymizovat uživatelská data v zálohách';
$string['backup:backupactivity'] = 'Zálohovat činnosti';
$string['backup:backupcourse'] = 'Zálohovat kurzy';
$string['backup:backupsection'] = 'Zálohovat oddíly kurzu';
$string['backup:backuptargetimport'] = 'Zálohovat pro účely importu do jiného kurzu';
$string['backup:configure'] = 'Konfigurovat možnosti zálohování';
$string['backup:downloadfile'] = 'Stahovat soubory se zálohami';
$string['backup:userinfo'] = 'Zálohovat data uživatelů';
$string['badges:awardbadge'] = 'Udělit uživateli odznak';
$string['badges:configurecriteria'] = 'Nastavit/upravit kritéria získání odznaku';
$string['badges:configuredetails'] = 'Nastavit/upravit podrobnosti odznaku';
$string['badges:configuremessages'] = 'Konfigurace zprávy o odznaku';
$string['badges:createbadge'] = 'Vytvořit/kopírovat odznaky';
$string['badges:deletebadge'] = 'Odstranit  odznaky';
$string['badges:earnbadge'] = 'Získat odznak';
$string['badges:manageglobalsettings'] = 'Správa globálního nastavení odznaků';
$string['badges:manageownbadges'] = 'Zobrazení a správa vlastních odznaků';
$string['badges:revokebadge'] = 'Zrušit odznak uživatele';
$string['badges:viewawarded'] = 'Zobrazit uživatele, kteří získali konkrétní odznak, aniž by jej mohli udělit';
$string['badges:viewbadges'] = 'Zobrazit dostupné odznaky, které nejsou získány';
$string['badges:viewotherbadges'] = 'Zobrazit veřejné odznaky v profilech ostatních uživatelů';
$string['block:edit'] = 'Upravovat nastavení bloku';
$string['block:view'] = 'Zobrazit blok';
$string['blog:create'] = 'Vytvářet nové příspěvky v blogu';
$string['blog:manageentries'] = 'Upravovat a spravovat příspěvky v blogu';
$string['blog:manageexternal'] = 'Upravovat a spravovat externí blogy';
$string['blog:search'] = 'Vyhledávat příspěvky v blogu';
$string['blog:view'] = 'Zobrazit příspěvky v blogu';
$string['blog:viewdrafts'] = 'Zobrazit pracovní verze příspěvků v blogu';
$string['calendar:manageentries'] = 'Spravovat všechny položky v kalendáři';
$string['calendar:managegroupentries'] = 'Spravovat skupinové položky v kalendáři';
$string['calendar:manageownentries'] = 'Spravovat vlastní položky v kalendáři';
$string['capabilities'] = 'Pravomoci';
$string['capability'] = 'Pravomoc';
$string['category:create'] = 'Vytvářet kategorie';
$string['category:delete'] = 'Odstraňovat kategorie';
$string['category:manage'] = 'Spravovat kategorie';
$string['category:update'] = 'Aktualizovat kategorie';
$string['category:viewcourselist'] = 'Zobrazit kategorii kurzů a kurzy v něm';
$string['category:viewhiddencategories'] = 'Vidět skryté kategorie';
$string['category:visibility'] = 'Vidět skryté kategorie';
$string['checkglobalpermissions'] = 'Kontrola globálních oprávnění';
$string['checkpermissions'] = 'Kontrola oprávnění';
$string['checkpermissionsin'] = 'Kontrola oprávnění v {$a}';
$string['checksystempermissionsfor'] = 'Kontrola globálních oprávnění pro uživatele {$a->fullname}';
$string['checkuserspermissionshere'] = 'Kontrola oprávnění pro uživatele {$a->fullname} v kontextu {$a->contextlevel}';
$string['chooseroletoassign'] = 'Prosím, vyberte roli k přidělení';
$string['cohort:assign'] = 'Přidávat nebo odebírat členy globální skupiny';
$string['cohort:configurecustomfields'] = 'Nakonfigurovat vlastní pole globální skupiny';
$string['cohort:manage'] = 'Vytvářet, odstraňovat a přesouvat globální skupiny';
$string['cohort:view'] = 'Zobrazit globální skupiny na úrovni serveru';
$string['comment:delete'] = 'Odstraňovat komentáře';
$string['comment:post'] = 'Vkládat komentáře';
$string['comment:view'] = 'Zobrazit komentáře';
$string['competency:competencygrade'] = 'Nastavit hodnocení kompetence';
$string['competency:competencymanage'] = 'Správa rámce kompetencí';
$string['competency:competencyview'] = 'Zobrazit  rámce kompetencí';
$string['competency:coursecompetencyconfigure'] = 'Konfigurace nastavení kompetencí kurzu';
$string['competency:coursecompetencygradable'] = 'Přijmout známky kompetencí';
$string['competency:coursecompetencymanage'] = 'Správa kompetencí kurzu';
$string['competency:coursecompetencyview'] = 'Zobrazit kompetence kurzu';
$string['competency:evidencedelete'] = 'Odstranit evidenci';
$string['competency:plancomment'] = 'Komentovat studijní plán';
$string['competency:plancommentown'] = 'Komentovat vlastní studijní plán';
$string['competency:planmanage'] = 'Správa studijních plánů';
$string['competency:planmanagedraft'] = 'Správa návrhů studijních plánů';
$string['competency:planmanageown'] = 'Správa vlastních studijních plánů';
$string['competency:planmanageowndraft'] = 'Správa vlastních návrhů studijních plánů';
$string['competency:planrequestreview'] = 'Žádost o revizi studijního plánu';
$string['competency:planrequestreviewown'] = 'Žádost o revizi vlastního studijního plánu';
$string['competency:planreview'] = 'Revize studijního plánu';
$string['competency:planview'] = 'Zobrazit všechny studijní plány';
$string['competency:planviewdraft'] = 'Zobrazit návrhy studijních plánů';
$string['competency:planviewown'] = 'Zobrazit vlastní studijní plány';
$string['competency:planviewowndraft'] = 'Zobrazit vlastní návrhy studijních plánů';
$string['competency:templatemanage'] = 'Správa šablon vzdělávacích plánů';
$string['competency:templateview'] = 'Zobrazit šablony vzdělávacích plánů';
$string['competency:usercompetencycomment'] = 'Komentář k uživatelským kompetencím';
$string['competency:usercompetencycommentown'] = 'Komentář k vlastním uživatelským kompetencím';
$string['competency:usercompetencyrequestreview'] = 'Žádost o revizi kompetence uživatele';
$string['competency:usercompetencyrequestreviewown'] = 'Žádost o revizi vlastní kompetence uživatele';
$string['competency:usercompetencyreview'] = 'Revize kompetence uživatele';
$string['competency:usercompetencyview'] = 'Zobrazení kompetence uživatele';
$string['competency:userevidencemanage'] = 'Správa evidence předchozího studia';
$string['competency:userevidencemanageown'] = 'Správa vlastní evidence předchozího studia';
$string['competency:userevidenceview'] = 'Zobrazit evidenci předchozího studia uživatele';
$string['confirmaddadmin'] = 'Opravdu chcete přidat uživatele <strong>{$a}</strong> jako nového správce těchto stránek?';
$string['confirmaddadmins'] = 'Opravdu chcete přidat následující uživatele do seznamu správců stránek?';
$string['confirmdeladmin'] = 'Opravdu chcete odebrat uživatele <strong>{$a}</strong> ze seznamu správců těchto stránek?';
$string['confirmremoveadmins'] = 'Opravdu chcete odebrat následující uživatele ze seznamu správců stránek?';
$string['confirmroleprevent'] = 'Opravdu chcete odebrat roli <strong>"{$a->role}"</strong> ze seznamu rolí s povolenou pravomocí "{$a->cap}" v kontextu "{$a->context}"?';
$string['confirmroleunprohibit'] = 'Opravdu chcete odebrat roli <strong>"{$a->role}"</strong> ze seznamu rolí se zakázanou pravomocí "{$a->cap}" v kontextu "{$a->context}"?';
$string['confirmunassign'] = 'Opravdu chcete tuto roli odebrat danému uživateli?';
$string['confirmunassignno'] = 'Zrušit';
$string['confirmunassigntitle'] = 'Potvrdit změnu role';
$string['confirmunassignyes'] = 'Odebrat';
$string['contentbank:access'] = 'Přístup do banky obsahu';
$string['contentbank:changelockedcustomfields'] = 'Změnit uzamčená vlastní pole pro banku obsahu';
$string['contentbank:configurecustomfields'] = 'Nakonfigurovat vlastní pole pro banku obsahu';
$string['contentbank:copyanycontent'] = 'Zkopírovat jakýkoli obsah v bance obsahu';
$string['contentbank:copycontent'] = 'Zkopírovat obsah v bance obsahu';
$string['contentbank:deleteanycontent'] = 'Odstranit veškerý obsah z banky obsahu';
$string['contentbank:deleteowncontent'] = 'Odstranit obsah z banky obsahu';
$string['contentbank:downloadcontent'] = 'Stáhnout obsah z banky obsahu';
$string['contentbank:manageanycontent'] = 'Spravovat veškerý obsah z banky obsahu';
$string['contentbank:manageowncontent'] = 'Spravovat obsah z vlastní banky obsahu';
$string['contentbank:upload'] = 'Nahrát nový obsah do banky obsahu';
$string['contentbank:useeditor'] = 'Vytvořit nebo upravit obsah pomocí editoru typů obsahu';
$string['contentbank:viewunlistedcontent'] = 'Zobrazit neveřejný obsah z banky obsahu';
$string['context'] = 'Kontext';
$string['contextrolenotallowed'] = 'Role {$a} není v tomto kontextu povolena.';
$string['course:activityvisibility'] = 'Skrývat a zobrazovat činnosti';
$string['course:bulkmessaging'] = 'Posílat zprávu více uživatelům';
$string['course:changecategory'] = 'Měnit kategorii kurzu';
$string['course:changefullname'] = 'Měnit celý název kurzu';
$string['course:changeidnumber'] = 'Měnit identifikátor kurzu';
$string['course:changelockedcustomfields'] = 'Změnit uzamčené vlastní pole';
$string['course:changeshortname'] = 'Měnit krátký název kurzu';
$string['course:changesummary'] = 'Měnit souhrn kurzu';
$string['course:configurecoursecommunication'] = 'Nakonfigurovat nastavení komunikace kurzu';
$string['course:configurecustomfields'] = 'Nakonfigurovat vlastní pole kurzu';
$string['course:configuredownloadcontent'] = 'Konfigurace stahování obsahu kurzu';
$string['course:create'] = 'Vytvářet kurzy';
$string['course:creategroupconversations'] = 'Vytvořit skupinové konverzace';
$string['course:delete'] = 'Odstraňovat kurzy';
$string['course:downloadcoursecontent'] = 'Stáhnout obsah kurzu';
$string['course:editcoursewelcomemessage'] = 'Upravit uvítací zprávu kurzu';
$string['course:enrolconfig'] = 'Konfigurovat instance modulů pro zápis uživatelů do kurzu';
$string['course:enrolreview'] = 'Vidět přehled zápisů do kurzu';
$string['course:ignoreavailabilityrestrictions'] = 'Ignorovat omezení dostupnosti';
$string['course:ignorefilesizelimits'] = 'Používát soubory větší než je omezení velikosti souboru';
$string['course:isincompletionreports'] = 'Bude zobrazeno na závěr sestavy';
$string['course:manageactivities'] = 'Spravovat činnosti';
$string['course:managefiles'] = 'Spravovat soubory';
$string['course:managegrades'] = 'Spravovat známkování';
$string['course:managegroups'] = 'Spravovat skupiny';
$string['course:managescales'] = 'Spravovat škály';
$string['course:markcomplete'] = 'Ručně označovat absolvování kurzu';
$string['course:movesections'] = 'Přesouvat sekce';
$string['course:overridecompletion'] = 'Přepsat stav dokončení činnosti';
$string['course:recommendactivity'] = 'Doporučit aktivity v průvodci přidání obsahu';
$string['course:renameroles'] = 'Přejmenovat role';
$string['course:request'] = 'Požadovat založení nových kurzů';
$string['course:reset'] = 'Resetovat kurz';
$string['course:reviewotherusers'] = 'Zkontrolujte ostatní uživatele';
$string['course:sectionvisibility'] = 'Nastavovat viditelnost sekce';
$string['course:setcurrentsection'] = 'Nastavovat aktuální sekci';
$string['course:setforcedlanguage'] = 'Vnutit jazyk kurzu nebo aktivity';
$string['course:tag'] = 'Změnit štítky kurzu';
$string['course:togglecompletion'] = 'Ručně dokončené aktivity';
$string['course:update'] = 'Aktualizovat nastavení kurzu';
$string['course:useremail'] = 'Povolovat a zakazovat emailové adresy';
$string['course:view'] = 'Zobrazit kurzy, i když do nich není zapsán';
$string['course:viewcoursegrades'] = 'Zobrazit známky v kurzu';
$string['course:viewhiddenactivities'] = 'Zobrazit skryté činnosti';
$string['course:viewhiddencourses'] = 'Zobrazit skryté kurzy';
$string['course:viewhiddengroups'] = 'Zobrazit skryté skupiny';
$string['course:viewhiddensections'] = 'Zobrazit skryté sekce';
$string['course:viewhiddenuserfields'] = 'Zobrazit skrytá uživatelská pole';
$string['course:viewparticipants'] = 'Zobrazit účastníky';
$string['course:viewscales'] = 'Zobrazit škály';
$string['course:viewsuspendedusers'] = 'Zobrazit pozastavené uživatele';
$string['course:visibility'] = 'Skrývat a zobrazovat kurzy';
$string['createrolebycopying'] = 'Vytvořit novou roli kopírováním {$a}';
$string['createthisrole'] = 'Vytvořit tuto roli';
$string['currentcontext'] = 'Stávající kontext';
$string['currentrole'] = 'Stávající role';
$string['customroledescription'] = 'Vlastní popis';
$string['customroledescription_help'] = 'Pokud je vlastní popis prázdný, jsou popisy standardních rolí nastaveny automaticky.';
$string['customrolename'] = 'Vlastní název';
$string['customrolename_help'] = 'Pokud je vlastní název role prázdný, bude použit lokalizovaný standardní název role. Ve všech vlastních rolích musíte název role vyplnit.';
$string['defaultrole'] = 'Výchozí role';
$string['defaultx'] = 'Výchozí: {$a}';
$string['defineroles'] = 'Definovat role';
$string['definitionofrolex'] = 'Definice role "{$a}"';
$string['deletecourseoverrides'] = 'Všechna lokální přenastavení v kurzu';
$string['deletelocalroles'] = 'Všechna lokální přidělení rolí';
$string['deleterolesure'] = '<p>Skutečně chcete odstranit roli "{$a->name} ({$a->shortname})"?</p><p>Tato role je teď přidělena  {$a->count} uživatelům.</p>';
$string['deletexrole'] = 'Odstranit roli {$a}';
$string['duplicaterole'] = 'Duplikovat tuto roli';
$string['duplicaterolesure'] = '<p>Skutečně chcete duplikovat roli "{$a->name} ({$a->shortname})"?</p>';
$string['editingrolex'] = 'Úprava role "{$a}"';
$string['editrole'] = 'Upravit roli';
$string['editxrole'] = 'Upravit roli {$a}';
$string['errorbadrolename'] = 'Nesprávný název role';
$string['errorbadroleshortname'] = 'Nesprávná zkratka role';
$string['errorexistsrolename'] = 'Název role už existuje';
$string['errorexistsroleshortname'] = 'Zkratka role už existuje';
$string['errorroleshortnametoolong'] = 'Krátký název nesmí překročit 100 znaků';
$string['eventcapabilityassigned'] = 'Oprávnění přiřazeno';
$string['eventcapabilityunassigned'] = 'Oprávnění odstraněno';
$string['eventroleallowassignupdated'] = 'Aktualizováno povolení přiřazovat role';
$string['eventroleallowoverrideupdated'] = 'Aktualizováno povolení přepsat role';
$string['eventroleallowswitchupdated'] = 'Aktualizováno povolení přepnout roli';
$string['eventroleallowviewupdated'] = 'Povolit roli zobrazení';
$string['eventroleassigned'] = 'Role přiřazena';
$string['eventrolecapabilitiesupdated'] = 'Oprávnění role aktualizováno';
$string['eventrolecreated'] = 'Role vytvořena';
$string['eventroledeleted'] = 'Role odstraněna';
$string['eventroleunassigned'] = 'Přiřazení role odebráno';
$string['eventroleupdated'] = 'Role byla aktualizována';
$string['existingadmins'] = 'Stávající správci stránek';
$string['existingusers'] = '{$a} stávajících uživatelů';
$string['explanation'] = 'Analýza';
$string['export'] = 'Export';
$string['extusers'] = 'Stávající uživatelé';
$string['extusersmatching'] = 'Stávající uživatelé odpovídající hledání "{$a}"';
$string['filter:manage'] = 'Spravovat lokální nastavení filtrů';
$string['frontpageuser'] = 'Registrovaný uživatel na titulní stránce';
$string['frontpageuserdescription'] = 'Tuto roli mají automaticky všichni uživatelé na titulní stránce';
$string['globalrole'] = 'Globální role';
$string['globalroleswarning'] = 'UPOZORNĚNÍ! Všechny role, které přiřadíte na této stránce, budou platné napříč celými stránkami včetně titulní strany a všech kurzů.';
$string['gotoassignroles'] = 'Přejít k přidělování rolí v tomto kontextu - {$a->contextlevel}';
$string['gotoassignsystemroles'] = 'Přejít k přidělování globálních rolí';
$string['grade:edit'] = 'Upravovat známky';
$string['grade:export'] = 'Exportovat známky';
$string['grade:hide'] = 'Skrývat a odkrývat známky nebo položky hodnocení';
$string['grade:import'] = 'Importovat známky';
$string['grade:lock'] = 'Uzamykat známky nebo položky';
$string['grade:manage'] = 'Spravovat položky známkování';
$string['grade:managegradingforms'] = 'Správa pokročilých metod hodnocení';
$string['grade:manageletters'] = 'Spravovat slovní známky';
$string['grade:manageoutcomes'] = 'Spravovat očekávané výstupy';
$string['grade:managesharedforms'] = 'Správa šablon pokročilého hodnocení';
$string['grade:override'] = 'Přepisovat známky';
$string['grade:sharegradingforms'] = 'Sdílení pokročilého hodnocení jako šablony';
$string['grade:unlock'] = 'Odemykat známky nebo položky';
$string['grade:view'] = 'Zobrazit vlastní známky';
$string['grade:viewall'] = 'Zobrazit známky ostatních';
$string['grade:viewhidden'] = 'Zobrazit skryté známky vlastníka';
$string['group:configurecustomfields'] = 'Konfigurace vlastních polí skupiny/seskupení';
$string['h5p:deploy'] = 'Nasazení obsahu H5P';
$string['h5p:setdisplayoptions'] = 'Nastavit možnosti zobrazení H5P';
$string['h5p:updatelibraries'] = 'Spravovat typy obsahu H5P';
$string['highlightedcellsshowdefault'] = 'Zvýrazněné buňky v tabulce níže ukazují výchozí hodnoty pro tuto roli v návaznosti na aktuálně vybraný archetyp role.';
$string['highlightedcellsshowinherit'] = 'Zvýrazněné buňky v tabulce níže ukazují případná oprávnění, která budou standardně použita. Upravte oprávnění pouze u těch pravomocí, které chcete opravdu změnit. Vše ostatní ponechejte na hodnotě "Zdědit".';
$string['inactiveformorethan'] = 'nečinní déle než {$a->timeperiod}';
$string['ingroup'] = 've skupině "{$a->group}"';
$string['inherit'] = 'Zdědit';
$string['invalidpresetfile'] = 'Neplatný soubor definice role';
$string['legacy:admin'] = 'Archetyp: Správce';
$string['legacy:coursecreator'] = 'Původní role: Tvůrce kurzu';
$string['legacy:editingteacher'] = 'Archetyp: Učitel (s právy úprav)';
$string['legacy:guest'] = 'Archetyp: Host';
$string['legacy:student'] = 'Archetyp: Student';
$string['legacy:teacher'] = 'Archetyp: Učitel (bez práv úprav)';
$string['legacy:user'] = 'Archetyp: Registrovaný uživatel';
$string['legacytype'] = 'Archetyp role';
$string['listallroles'] = 'Seznam všech rolí';
$string['localroles'] = 'Lokálně přidělené role';
$string['mainadmin'] = 'Hlavní správce';
$string['mainadminset'] = 'Nastavit hlavního správce';
$string['manageadmins'] = 'Seznam správců stránek';
$string['manager'] = 'Manažer';
$string['managerdescription'] = 'Manažeři mají přístup ke kurzům a mohou je upravovat, ale obvykle se jich neúčastní.';
$string['manageroles'] = 'Spravovat role';
$string['maybeassignedin'] = 'Kontexty, ve kterých může být tato role přidělena';
$string['moodlenet:shareactivity'] = 'Sdílet aktivity na MoodleNet';
$string['moodlenet:sharecourse'] = 'Sdílet kurz na MoodleNet';
$string['morethan'] = 'Více než {$a}';
$string['multipleroles'] = 'Více rolí';
$string['my:configsyspages'] = 'Konfigurovat systémové šablony stránek Nástěnka';
$string['my:manageblocks'] = 'Spravovat bloky na stránce Nástěnka';
$string['neededroles'] = 'Role s oprávněním';
$string['nocapabilitiesincontext'] = 'V tomto kontextu nejsou k dispozici žádné pravomoci.';
$string['noneinthisx'] = 'Žádní v tomto kontextu {$a}';
$string['noneinthisxmatching'] = 'Žádní uživatelé odpovídající hledání "{$a->search}" v tomto kontextu {$a->contexttype}';
$string['norole'] = 'Žádná role';
$string['noroleassignments'] = 'Tomuto uživateli není na celém serveru přiřazena žádná role';
$string['noroles'] = 'Žádné role';
$string['notabletoassignroleshere'] = 'Přiřazení rolí v tomto kontextu nebylo administrátorem povoleno.';
$string['notabletooverrideroleshere'] = 'Zde nemůžete přenastavit žádná oprávnění';
$string['notes:manage'] = 'Spravovat poznámky';
$string['notes:view'] = 'Zobrazit poznámky';
$string['notset'] = 'Nenastaveno';
$string['novisibleroles'] = 'Žádné role';
$string['overrideanotherrole'] = 'Přenastavit jinou roli';
$string['overridecontext'] = 'Přenastavit kontext';
$string['overridepermissions'] = 'Lokální přenastavení oprávnění';
$string['overridepermissions_help'] = 'Přenastavení oprávnění slouží k jemnému vyladění přístupových práv v daném kontextu tak, aby odpovídaly vašim potřebám.

Příklad: uživatelé s rolí Student mohou ve vašem kurzu začínat nové diskuse v diskusních fórech. V jednom konkrétním fóru byste jim však chtěli tuto možnost odebrat. Pak stačí u daného fóra přenastavit oprávnění u pravomoci "Začínat novou diskusi" na hodnotu Nepovolit.';
$string['overridepermissions_link'] = 'admin/roles/override';
$string['overridepermissionsforrole'] = 'Přenastavit oprávnění pro roli "{$a->role}" v kontextu {$a->context}';
$string['overridepermissionsin'] = 'Přenastavení oprávnění - {$a}';
$string['overrideroles'] = 'Lokální přenastavení rolí';
$string['overriderolesin'] = 'Přenastavení rolí - {$a}';
$string['overrides'] = 'Přenastavení';
$string['overridesbycontext'] = 'Přenastavení (podle kontextu)';
$string['payment:manageaccounts'] = 'Spravovat účty';
$string['payment:viewpayments'] = 'Zobrazit platby';
$string['permission'] = 'Oprávnění';
$string['permission_help'] = 'Pro každou pravomoc je možno nastavit jednu ze čtyř možných hodnot oprávnění.

* Nenastaveno/Zdědit - oprávnění není uděleno, případně není měněna hodnota definovaná na vyšším kontextu
* Povolit - uděluje oprávnění vykonat danou akci
* Nepovolit - odebírá oprávnění vykonat danou akci, i když je na vyšším kontextu přiděleno
* Zakázat - oprávnění vykonat danou akci je odebráno a nemůže být na nižším kontextu opětovně přiděleno';
$string['permissions'] = 'Oprávnění';
$string['permissionsforuser'] = 'Oprávnění pro uživatele {$a}';
$string['permissionsincontext'] = 'Oprávnění v kontextu {$a}';
$string['portfolio:export'] = 'Exportovat obsah do portfolia';
$string['potentialusers'] = '{$a} uživatelů k dispozici';
$string['potusers'] = 'Uživatelé k dispozici';
$string['potusersmatching'] = 'Uživatelé k dispozici odpovídající hledání "{$a}"';
$string['prevent'] = 'Nepovolit';
$string['privacy:metadata:preference:showadvanced'] = 'Použijte přepínač pokročilého režimu.';
$string['privacy:metadata:role_assignments'] = 'Přiřazení rolí';
$string['privacy:metadata:role_assignments:component'] = 'Modul zodpovědný za přiřazení rolí, prázdný při ručním přiřazení.';
$string['privacy:metadata:role_assignments:itemid'] = 'Identifikátor instance zápisu / autentizace  zodpovědné za přidělení role';
$string['privacy:metadata:role_assignments:modifierid'] = 'Identifikátor uživatele ID, který vytvořil nebo změnil přiřazení rolí';
$string['privacy:metadata:role_assignments:roleid'] = 'ID role';
$string['privacy:metadata:role_assignments:tableexplanation'] = 'Tato tabulka ukládá přiřazené role v každém kontextu.';
$string['privacy:metadata:role_assignments:timemodified'] = 'Datum, kdy byla role přiřazena nebo upravena.';
$string['privacy:metadata:role_assignments:userid'] = 'ID uživatele';
$string['privacy:metadata:role_capabilities'] = 'Pravomoci role';
$string['privacy:metadata:role_capabilities:capability'] = 'Název pravomoci.';
$string['privacy:metadata:role_capabilities:modifierid'] = 'Identifikátor uživatele, který pravomoc vytvořil nebo změnil';
$string['privacy:metadata:role_capabilities:permission'] = 'Oprávnění k pravomoci: zdědit, povolit, nepovolit nebo zakázat.';
$string['privacy:metadata:role_capabilities:roleid'] = 'ID role';
$string['privacy:metadata:role_capabilities:tableexplanation'] = 'Tato tabulka ukládá pravomoci a přepíše pravomoci určité role v konkrétním kontextu';
$string['privacy:metadata:role_capabilities:timemodified'] = 'Datum vytvoření nebo úpravy pravomoci.';
$string['privacy:metadata:role_cohortroles'] = 'Role do globální skupiny';
$string['prohibit'] = 'Zakázat';
$string['prohibitedroles'] = 'Zakázáno';
$string['question:add'] = 'Vkládat nové úlohy';
$string['question:commentall'] = 'Komentovat všechny úlohy';
$string['question:commentmine'] = 'Komentovat své vlastní úlohy';
$string['question:config'] = 'Konfigurovat typy úloh';
$string['question:editall'] = 'Upravovat všechny úlohy';
$string['question:editmine'] = 'Upravovat vlastní úlohy';
$string['question:flag'] = 'Označovat úlohy vlaječkou v průběhu konání pokusu o absolvování testu';
$string['question:managecategory'] = 'Spravovat kategorii úloh';
$string['question:moveall'] = 'Přesouvat všechny úlohy';
$string['question:movemine'] = 'Přesouvat vlastní úlohy';
$string['question:tagall'] = 'Označit všechny otázky';
$string['question:tagmine'] = 'Označit své vlastní otázky';
$string['question:useall'] = 'Používat všechny úlohy';
$string['question:usemine'] = 'Používat vlastní úlohy';
$string['question:viewall'] = 'Zobrazit všechny úlohy';
$string['question:viewmine'] = 'Zobrazit vlastní úlohy';
$string['rating:rate'] = 'Hodnotit položky';
$string['rating:view'] = 'Zobrazit vlastní celkový výsledek hodnocení';
$string['rating:viewall'] = 'Zobrazit podrobné informace o hodnocení jednotlivými uživateli';
$string['rating:viewany'] = 'Zobrazit celkový výsledek hodnocení libovolného uživatele';
$string['reportbuilder:edit'] = 'Upravit své vlastní přehledy';
$string['reportbuilder:editall'] = 'Upravit všechny vlastní přehledy';
$string['reportbuilder:scheduleviewas'] = 'Naplánovat sestavy, které se mají zobrazovat jako ostatní uživatelé';
$string['reportbuilder:view'] = 'Zobrazit vlastní přehledy';
$string['reportbuilder:viewall'] = 'Zobrazit všechny vlastní sestavy';
$string['resetrole'] = 'Resetovat na výchozí hodnoty';
$string['resettingrole'] = 'Obnovení role "{$a}"';
$string['restore:configure'] = 'Konfigurovat možnosti obnovy zálohy';
$string['restore:createuser'] = 'Vytvářet nové uživatelské účty při obnově zálohy kurzu';
$string['restore:restoreactivity'] = 'Obnovovat činnosti';
$string['restore:restorecourse'] = 'Obnovovat kurzy';
$string['restore:restoresection'] = 'Obnovovat sekce kurzů';
$string['restore:restoretargetimport'] = 'Obnovovat ze souborů určených pro import';
$string['restore:rolldates'] = 'Nechat přepočítat termíny v modulech činností při obnově';
$string['restore:uploadfile'] = 'Nahrávat soubory do oblastí se zálohami';
$string['restore:userinfo'] = 'Obnovovat data uživatelů';
$string['restore:viewautomatedfilearea'] = 'Obnovit kurzy z automatických záloh';
$string['risks'] = 'Rizika';
$string['role:assign'] = 'Přiřadit role uživatelům';
$string['role:manage'] = 'Vytvářet a spravovat role';
$string['role:override'] = 'Přenastavovat oprávnění ostatních uživatelů';
$string['role:review'] = 'Vidět nastavení rolí ostatních uživatelů';
$string['role:safeoverride'] = 'Přenastavovat bezpečná oprávnění ostatních uživatelů';
$string['role:switchroles'] = 'Přepínat na jiné role';
$string['roleallowheader'] = 'Povolit pro role';
$string['roleallowinfo'] = 'Vyberte role, které mají být přidány na seznam rolí s povolenou pravomocí "{$a->cap}" v kontextu "{$a->context}":';
$string['roleassignment'] = 'Přiřazení rolí';
$string['roleassignments'] = 'Přidělení rolí';
$string['roledefinitions'] = 'Definice rolí';
$string['rolefullname'] = 'Název';
$string['roleincontext'] = '{$a->role} v {$a->context}';
$string['roleoriginalname'] = 'Původní název';
$string['roleprohibitheader'] = 'Zakázat pro role';
$string['roleprohibitinfo'] = 'Vyberte role, které mají být přidány na seznam rolí se zakázanou pravomocí "{$a->cap}" v kontextu "{$a->context}":';
$string['rolerepreset'] = 'Použít předvolby role';
$string['roleresetdefaults'] = 'Výchozí';
$string['roleresetrole'] = 'Použít roli nebo archetyp';
$string['rolerisks'] = 'Rizika role';
$string['roles'] = 'Role';
$string['roles_help'] = 'Role je soubor oprávnění, který je definován pro celé stránky a který lze v konkrétních kontextech přidělovat konkrétním uživatelům.
';
$string['roles_link'] = 'roles';
$string['roleselect'] = 'Vyberte role';
$string['rolesforuser'] = 'Role pro uživatele {$a}';
$string['roleshortname'] = 'Krátký název';
$string['roleshortname_help'] = 'Krátký název role je nízkoúrovňový identifikátor role, ve které jsou povoleny pouze alfanumerické ASCII znaky.';
$string['roletoassign'] = 'Přidělit roli';
$string['roletooverride'] = 'Přenastavit roli';
$string['safeoverridenotice'] = 'Poznámka: pravomoci s vyšším stupněm rizika jsou zamknuty, protože jste oprávnění přenastavovat pouze bezpečná oprávnění.';
$string['search:query'] = 'Proveďte vyhledávání přes celý web';
$string['selectanotheruser'] = 'Vybrat jiného uživatele';
$string['selectauser'] = 'Vyberte uživatele';
$string['selectrole'] = 'Vybrat roli';
$string['showallroles'] = 'Ukázat všechny role';
$string['showthisuserspermissions'] = 'Zobrazit oprávnění tohoto uživatele';
$string['site:accessallgroups'] = 'Vstupovat do všech skupin';
$string['site:approvecourse'] = 'Schvalovat vytvoření kurzu';
$string['site:backup'] = 'Zálohovat kurzy';
$string['site:config'] = 'Měnit konfiguraci stránek';
$string['site:configview'] = 'Zobrazit strom administrace webu (ale ne všechny stránky v něm)';
$string['site:deleteanymessage'] = 'Odstranit všechny zprávy na webu';
$string['site:deleteownmessage'] = 'Odstranit zprávy odeslané uživateli a uživatelem';
$string['site:doanything'] = 'Možnost dělat cokoli';
$string['site:doclinks'] = 'Vidět odkazy na dokumenty vně těchto stránek';
$string['site:forcelanguage'] = 'Přepsat jazyk kurzu';
$string['site:import'] = 'Importovat obsah do kurzu';
$string['site:maintenanceaccess'] = 'Přístup k webu pokud je nastaven režim údržby';
$string['site:manageallmessaging'] = 'Přidávat, odebírat, blokovat a odblokovat kontakty pro jakéhokoli uživatele';
$string['site:manageblocks'] = 'Upravovat bloky na stránce';
$string['site:managecontextlocks'] = 'Správa zmrazení kontextu';
$string['site:messageanyuser'] = 'Zablokujte předvolby ochrany osobních údajů pro zasílání zpráv všem uživatelům';
$string['site:mnetloginfromremote'] = 'Přihlásit se ze vzdáleného serveru pomocí MNet';
$string['site:mnetlogintoremote'] = 'Roamovat do vzdáleného serveru pomocí MNet';
$string['site:readallmessages'] = 'Číst všechny zprávy na stránkách';
$string['site:restore'] = 'Obnovovat kurzy';
$string['site:senderrormessage'] = 'Odeslat zprávu uživatelské podpory z chybové stránky';
$string['site:sendmessage'] = 'Posílat zprávy libovolnému uživateli';
$string['site:trustcontent'] = 'Důvěřovat uloženému obsahu';
$string['site:uploadusers'] = 'Načítat nové uživatele ze souboru';
$string['site:viewanonymousevents'] = 'Zobrazit anonymní události v sestavách';
$string['site:viewfullnames'] = 'Vždy ukazovat celá jména uživatelů';
$string['site:viewparticipants'] = 'Zobrazit účastníky';
$string['site:viewreports'] = 'Zobrazit protokoly';
$string['site:viewuseridentity'] = 'V seznamu zobrazit celou identitu uživatele';
$string['siteadministrators'] = 'Správci stránek';
$string['siteadministratorsconfigphp'] = 'Seznam administrátorů stránek nelze změnit, protože je definován v config.php.';
$string['tag:edit'] = 'Upravovat existující štítky';
$string['tag:editblocks'] = 'Upravovat bloky na stránkách štítků';
$string['tag:flag'] = 'Označovat štítek jako nevhodný';
$string['tag:manage'] = 'Spravovat všechny štítky';
$string['thisnewrole'] = 'Tato nová role';
$string['thisusersroles'] = 'Přidělení rolí pro tohoto uživatele';
$string['unassignarole'] = 'Odebrat roli {$a}';
$string['unassignconfirm'] = 'Opravdu chcete uživateli "{$a->user}" odebrat roli "{$a->role}"?';
$string['unassignerror'] = 'Chyba při odebrání role {$a->role} u uživatele {$a->user}.';
$string['user:changeownpassword'] = 'Měnit si vlastní heslo';
$string['user:create'] = 'Vytvářet uživatele';
$string['user:delete'] = 'Odstraňovat uživatele';
$string['user:editmessageprofile'] = 'Upravovat nastavení zasílání zpráv uživatelů';
$string['user:editownmessageprofile'] = 'Upravovat své vlastní nastavení zasílání zpráv';
$string['user:editownprofile'] = 'Upravovat svůj vlastní profil uživatele';
$string['user:editprofile'] = 'Upravovat profil jiného uživatele';
$string['user:ignoreuserquota'] = 'Ignorovat uživatelské kvóty';
$string['user:loginas'] = 'Přihlásit se jako jiní uživatelé';
$string['user:manageblocks'] = 'Spravovat bloky na stránce s profilem jiných uživatelů';
$string['user:manageownblocks'] = 'Spravovat bloky na stránce s vlastním veřejným profilem';
$string['user:manageownfiles'] = 'Spravovat osobní soubory';
$string['user:managesyspages'] = 'Konfigurovat výchozí rozložení stránky s veřejným profilem uživatelů';
$string['user:readuserblogs'] = 'Zobrazit všechny uživatelské blogy';
$string['user:readuserposts'] = 'Zobrazit příspěvky všech uživatelů';
$string['user:update'] = 'Aktualizovat profily uživatelů';
$string['user:viewalldetails'] = 'Zobrazit všechny informace o uživatelích';
$string['user:viewdetails'] = 'Zobrazit profily uživatelů';
$string['user:viewhiddendetails'] = 'Zobrazit skryté detaily uživatelů';
$string['user:viewlastip'] = 'Zobrazit poslední IP adresu uživatele';
$string['user:viewprofilepictures'] = 'Zobrazit obrázky uživatelského profilu (pokud je povoleno vynucení přihlášení)';
$string['user:viewuseractivitiesreport'] = 'Vidět zprávy o činnosti uživatele';
$string['user:viewusergrades'] = 'Zobrazit známky uživatele';
$string['usersfrom'] = 'Uživatelé z kontextu {$a}';
$string['usersfrommatching'] = 'Uživatelé z kontextu {$a->contextname} odpovídající hledání "{$a->search}"';
$string['usersinthisx'] = 'Uživatelé v tomto kontextu {$a}';
$string['usersinthisxmatching'] = 'Uživatelé v tomto kontextu {$a->contexttype} odpovídající hledání "{$a->search}"';
$string['userswithrole'] = 'Všichni uživatelé s rolí';
$string['userswiththisrole'] = 'Uživatelé s rolí';
$string['useshowadvancedtochange'] = 'Použijte tlačítko "Zobrazit rozšiřující nastavení" pro změnu';
$string['viewingdefinitionofrolex'] = 'Zobrazení definice role "{$a}"';
$string['viewrole'] = 'Vidět podrobnosti role';
$string['webservice:createmobiletoken'] = 'Generovat token webové služby pro mobilní přístup';
$string['webservice:createtoken'] = 'Generovat token webové služby';
$string['webservice:managealltokens'] = 'Správa tokenů webových služeb všech uživatelů';
$string['whydoesuserhavecap'] = 'Proč má {$a->fullname} oprávnění {$a->capability} v kontextu {$a->context}?';
$string['whydoesusernothavecap'] = 'Proč nemá {$a->fullname} oprávnění {$a->capability} v kontextu {$a->context}?';
$string['xroleassignments'] = 'Přiřazení role {$a}';
$string['xuserswiththerole'] = 'Uživatelé s rolí "{$a->role}"';
