<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_ai_manager', language 'cs', version '4.5'.
 *
 * @package     local_ai_manager
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addinstance'] = 'Přidat nástroj AI';
$string['addnavigationentry'] = 'Přidat položku v navigaci';
$string['addnavigationentrydesc'] = 'Povolte, pokud má být konfigurace správce AI přístupná z primární navigace.';
$string['ai_info_table_row_highlighted'] = 'Zvýrazněné nástroje AI jsou ty, které používá doplněk, který jste použili při kliknutí na odkaz na tuto stránku.';
$string['ai_manager:manage'] = 'Konfigurace nastavení správce AI pro klienta';
$string['ai_manager:managetenants'] = 'Konfigurace nastavení správce AI pro všechny klienty';
$string['ai_manager:managevertexcache'] = 'Získání a změna konfigurace stavu ukládání do mezipaměti Google Vertex AI';
$string['ai_manager:use'] = 'Použijte ai_manager';
$string['ai_manager:viewprompts'] = 'Zobrazit výzvy uživatelů';
$string['ai_manager:viewpromptsdates'] = 'Zobrazit časová razítka výzev uživatelů';
$string['ai_manager:viewstatistics'] = 'Zobrazit statistiky';
$string['ai_manager:viewtenantprompts'] = 'Zobrazení výzev uživatelů, které byly použity v kontextu klienta (mimo kurzy)';
$string['ai_manager:viewusage'] = 'Zobrazit informace o využití';
$string['ai_manager:viewusernames'] = 'Zobrazit neanonymizovaná uživatelská jména ve statistikách';
$string['ai_manager:viewuserstatistics'] = 'Zobrazit statistiky jednotlivých uživatelů';
$string['aiadministrationlink'] = 'Administrace nástrojů AI';
$string['aicourseeditheader'] = 'Funkce umělé inteligence';
$string['aiinfotitle'] = 'Nástroje AI ve vašem klientovi';
$string['aiisbeingused'] = 'Používáte nástroj s AI. Zadaná data budou odeslána do externího systému s AI.';
$string['aipurposeplugins'] = 'Doplňky pro účely AI';
$string['airesponse'] = 'Reakce AI';
$string['aitool'] = 'Nástroj AI';
$string['aitooldeleted'] = 'Nástroj AI smazán';
$string['aitoolplugins'] = 'Doplňky pro nástroje AI';
$string['aitoolsaved'] = 'Data nástroje AI uložena';
$string['aiwarning'] = 'Obsah generovaný AI by měl být vždy ověřen.';
$string['aiwarningurl'] = 'Odkaz na upozornění na obsah generovaný AI';
$string['aiwarningurldesc'] = 'Můžete zadat URL adresu, která obsahuje další informace o problému s obsahem generovaným AI.';
$string['allowedtenants'] = 'Povolení klienti';
$string['allowedtenantsdesc'] = 'Zadejte seznam povolených klientů: Jeden identifikátor na řádek.';
$string['alltime'] = 'Všechny výzvy';
$string['anonymized'] = 'Anonymizováno';
$string['apikey'] = 'Klíč API';
$string['applyfilter'] = 'Použít filtr';
$string['assignpurposes'] = 'Přiřadit účely';
$string['assignrole'] = 'Přiřadit roli';
$string['backtodashboard'] = 'Zpět na řídicí panel';
$string['basicsettings'] = 'Základní nastavení';
$string['basicsettingsdesc'] = 'Konfigurace základních nastavení pluginu AI Správce';
$string['cachedef_googleauth'] = 'Mezipaměť pro přístupový token Google OAuth2';
$string['changeconfirmstate'] = 'Potvrzení změny podmínek použití';
$string['changelockstate'] = 'Změnit stav zámku';
$string['changescope'] = 'Změnit rozsah použití';
$string['choosecontext'] = 'Vyberte kontext, který chcete uživatelům zobrazit';
$string['cleanuprequestlogtask'] = 'Vyčištění protokolu požadavků správce AI';
$string['configure_instance'] = 'Konfigurace instancí nástrojů AI';
$string['configureaitool'] = 'Konfigurace nástroje AI';
$string['configurepurposes'] = 'Konfigurace účelů';
$string['confirm'] = 'Potvrdit';
$string['confirmaitoolsusage_heading'] = 'Využití funkcí AI';
$string['confirmationnotrequired'] = 'Pro použití nástrojů AI není nutné potvrzení.';
$string['confirmationstatuschanged'] = 'Stav vašeho potvrzení byl uložen';
$string['confirmed'] = 'Přijato';
$string['confirmtermsofuse'] = 'Souhlasím s podmínkami použití a rozumím jim';
$string['context'] = 'Kurz/Aktivita';
$string['contextdeleted'] = 'Již smazáno';
$string['currentlyusedaitools'] = 'Aktuálně nakonfigurované nástroje AI';
$string['datawiperanonymizedate'] = 'Datum pro anonymizaci uživatelských dat';
$string['datawiperanonymizedatedesc'] = 'Uživatelská data starší než toto datum budou anonymizována. Toto nastavení platí pouze v případě, že je povoleno nastavení „enablecleanuprequestlogtask“.';
$string['datawiperdeletedate'] = 'Datum pro smazání uživatelských dat';
$string['datawiperdeletedatedesc'] = 'Uživatelská data starší než toto datum budou zcela smazána. Toto nastavení má vliv pouze v případě, že je povoleno nastavení „enablecleanuprequestlogtask“.';
$string['defaultrole'] = 'výchozí role';
$string['defaulttenantname'] = 'Výchozí klient';
$string['empty_api_key'] = 'Prázdný klíč API';
$string['enable_ai_integration'] = 'Povolit integraci AI';
$string['enablecleanuprequestlogtask'] = 'Povolit úlohu čištění protokolu požadavků';
$string['enablecleanuprequestlogtaskdesc'] = 'Pokud je tato možnost povolena, úloha na pozadí doplňku AI Správce odstraní a anonymizuje položky protokolu požadavků, které jsou starší než nakonfigurovaná časová razítka.';
$string['endpoint'] = 'Koncový bod API';
$string['error_confirmtermsofuse'] = 'Musíte potvrdit podmínky použití';
$string['error_http400'] = 'Chyba při čištění předaných možností';
$string['error_http400contextmissing'] = 'Chybí kontext';
$string['error_http403blocked'] = 'Váš správce klientů vám zablokoval přístup k nástrojům AI';
$string['error_http403coursesonly'] = 'Nemáte oprávnění používat nástroje AI mimo kurzy.';
$string['error_http403disabled'] = 'Váš správce klientů nepovolil funkci nástrojů AI.';
$string['error_http403nocapability'] = 'Nemáte možnost používat správce AI („local/ai_manager:use“)';
$string['error_http403notconfirmed'] = 'Ještě jste nepotvrdili podmínky použití';
$string['error_http403usertype'] = 'Váš správce klientů tento účel pro váš typ uživatele zakázal.';
$string['error_http404endpointempty'] = 'Nebyl zadán žádný koncový bod pro odeslání požadavku.';
$string['error_http409'] = 'ID položky {$a} je již obsazeno.';
$string['error_http429'] = 'Dosáhli jste maximálního počtu požadavků. V období {$a->period} můžete odeslat pouze {$a->count} požadavků.';
$string['error_limitreached'] = 'Dosáhli jste maximálního počtu požadavků pro tento účel. Počkejte prosím, dokud se počítadlo nevynuluje.';
$string['error_noaitoolassignedforpurpose'] = 'Pro účel „{$a}“ není přiřazen žádný nástroj AI.';
$string['error_pleaseconfirm'] = 'Před použitím je prosím přijměte.';
$string['error_purposenotconfigured'] = 'Pro tento účel není nakonfigurován žádný nástroj AI. Kontaktujte prosím svého správce klienta.';
$string['error_sendingrequestfailed'] = 'Odeslání požadavku do nástroje AI se nezdařilo.';
$string['error_tenantdisabled'] = 'Nástroje AI nejsou pro vašeho klienta povoleny. Kontaktujte prosím svého správce klienta.';
$string['error_unavailable_noselection'] = 'Tento nástroj je k dispozici pouze v případě, že byl vybrán text.';
$string['error_unavailable_selection'] = 'Tento nástroj je k dispozici pouze tehdy, pokud nebyl vybrán žádný text.';
$string['error_userlocked'] = 'Váš uživatel byl uzamčen vaším správcem klientů.';
$string['error_usernotconfirmed'] = 'Ještě jste nepřijali podmínky použití.';
$string['error_vertexai_serviceaccountjsonempty'] = 'Obsah souboru JSON, který jste si stáhli při vytváření servisního účtu, je třeba vložit do konzole Google Cloud.';
$string['error_vertexai_serviceaccountjsoninvalid'] = 'Neplatný formát. Musí se jednat o platný JSON.';
$string['error_vertexai_serviceaccountjsoninvalidmissing'] = 'Neplatný formát. Chybí položka „{$a}“.';
$string['exception_badmessageformat'] = 'Zprávy byly odeslány v neplatném formátu';
$string['exception_changestatusnotallowed'] = 'Nesmíte změnit stav tohoto uživatele.';
$string['exception_curl'] = 'Došlo k chybě připojení k externímu koncovému bodu API.';
$string['exception_curl28'] = 'Zpracování vašeho požadavku trvalo rozhraní API příliš dlouho nebo nebylo možné jej v rozumné době spojit.';
$string['exception_default'] = 'Při pokusu o odeslání požadavku do nástroje AI došlo k obecné chybě.';
$string['exception_editinstancedenied'] = 'Tento nástroj (instanci) AI nesmíte upravovat.';
$string['exception_http401'] = 'Přístup k API byl odepřen z důvodu neplatných přihlašovacích údajů.';
$string['exception_http429'] = 'Do nástroje AI bylo v určitém časovém období odesláno příliš mnoho nebo příliš velké požadavky. Zkuste to prosím znovu později.';
$string['exception_http500'] = 'Došlo k interní chybě serveru nástroje AI.';
$string['exception_instanceidmissing'] = 'Musíte zadat ID nástroje AI (instance)';
$string['exception_instancenotexists'] = 'Nástroj (instance) AI s ID {$a} neexistuje.';
$string['exception_instanceunavailable'] = 'Tento nástroj AI není k dispozici.';
$string['exception_invalidpurpose'] = 'Neplatný účel';
$string['exception_notenantmanagerrights'] = 'Nemáte práva ke správě nástrojů AI.';
$string['exception_novalidconnector'] = 'Není zadán platný typ nástroje AI.';
$string['exception_retrievingaccesstoken'] = 'Při pokusu o načtení přístupového tokenu došlo k chybě.';
$string['exception_retrievingcachestatus'] = 'Při pokusu o načtení stavu mezipaměti došlo k chybě.';
$string['exception_tenantaccessdenied'] = 'K tomuto klientovi ({$a}) nesmíte přistupovat.';
$string['exception_tenantnotallowed'] = 'Klient nemá přístup od správce';
$string['exception_usernotexists'] = 'Uživatel neexistuje';
$string['executeaction'] = 'Provést akci';
$string['executebulkuseractions'] = 'Provést akci pro vybrané uživatele';
$string['female'] = 'Žena';
$string['filterroles'] = 'Filtrovat role';
$string['formvalidation_editinstance_azureapiversion'] = 'Musíte poskytnout verzi API vašeho Azure Resource.';
$string['formvalidation_editinstance_azuredeploymentid'] = 'Musíte zadat ID nasazení vašeho prostředku Azure.';
$string['formvalidation_editinstance_azureresourcename'] = 'Musíte zadat název prostředku Azure.';
$string['formvalidation_editinstance_endpointnossl'] = 'Z důvodů bezpečnosti a ochrany osobních údajů jsou povoleny pouze koncové body HTTPS.';
$string['formvalidation_editinstance_name'] = 'Zadejte prosím název nástroje AI.';
$string['formvalidation_editinstance_temperaturerange'] = 'Hodnota teploty musí být mezi 0 a 1';
$string['general_information_heading'] = 'Obecné informace';
$string['general_information_text'] = 'Vaše instance Moodlu v tuto chvíli neposkytuje žádné nástroje AI. Instance Moodlu však nabízí rozhraní, jejichž prostřednictvím lze nástroje AI používat v rámci instance Moodlu. Aby to bylo možné pro všechny uživatele vašeho klienta, musí klient takový nástroj získat nebo poskytnout. Správce klienta pak může uložit přístupová data prostřednictvím konfigurační stránky a tím povolit funkce AI nabízené v instanci Moodlu.';
$string['general_user_settings'] = 'Obecná uživatelská nastavení';
$string['get_ai_response_failed'] = 'Načtení odpovědi AI se nezdařilo';
$string['get_ai_response_failed_desc'] = 'Při pokusu o získání výsledku z koncového bodu externího nástroje AI došlo k chybě.';
$string['get_ai_response_succeeded'] = 'Úspěšně přijata odpověď AI';
$string['get_ai_response_succeeded_desc'] = 'Pokus o načtení odpovědi z koncového bodu externího nástroje AI byl úspěšný.';
$string['heading_home'] = 'Nástroje AI';
$string['heading_purposes'] = 'Účely';
$string['heading_statistics'] = 'Statistika';
$string['infolink'] = 'Odkaz pro další informace';
$string['instanceaddmodal_heading'] = 'Který nástroj AI chcete přidat?';
$string['instanceavailable'] = 'použitelný';
$string['instancedeleteconfirm'] = 'Jste si jisti, že chcete smazat tento nástroj AI?';
$string['instancedisabled'] = 'Nástroj AI je momentálně deaktivován';
$string['instanceenabled'] = 'Nástroj AI je aktuálně povolen';
$string['instancename'] = 'Interní identifikátor';
$string['landscape'] = 'krajina';
$string['large'] = 'velký';
$string['lastday'] = 'Posledních 24 hodin';
$string['lastmonth'] = 'Posledních 30 dní';
$string['lastweek'] = 'Posledních 7 dní';
$string['lock'] = 'Zámek';
$string['locked'] = 'Zamčeno';
$string['male'] = 'Muž';
$string['max_request_time_window'] = 'Časové okno pro maximální počet požadavků';
$string['max_requests_purpose'] = 'Maximální počet požadavků za časové okno ({$a})';
$string['max_requests_purpose_heading'] = 'Účel {$a}';
$string['medium'] = 'střední';
$string['model'] = 'Model';
$string['namepattern'] = 'Název';
$string['nodata'] = 'Žádná data k zobrazení';
$string['noprompts'] = 'Žádné výzvy k zobrazení';
$string['notconfirmed'] = 'Nepřijato';
$string['notselected'] = 'Zakázáno';
$string['per'] = 'za';
$string['pluginname'] = 'Správce AI';
$string['portrait'] = 'portrét';
$string['preconfiguredmodel'] = 'Předkonfigurovaný model';
$string['privacy:metadata:local_ai_manager_request_log'] = 'Protokoly žádostí';
$string['privacy:metadata:local_ai_manager_request_log:contextid'] = 'ID kontextu, ve kterém byl požadavek AI proveden';
$string['privacy:metadata:local_ai_manager_request_log:promptcompletion'] = 'Okamžité dokončení přijaté externím systémem AI';
$string['privacy:metadata:local_ai_manager_request_log:prompttext'] = 'Výzva odeslaná do externího systému AI';
$string['privacy:metadata:local_ai_manager_request_log:requestoptions'] = 'Možnosti požadavku kódované ve formátu JSON, které byly odeslány spolu s výzvou';
$string['privacy:metadata:local_ai_manager_request_log:timecreated'] = 'Časové razítko, kdy byla žádost podána';
$string['privacy:metadata:local_ai_manager_request_log:userid'] = 'ID uživatele';
$string['privacy:metadata:local_ai_manager_userinfo'] = 'Informace specifické pro uživatele';
$string['privacy:metadata:local_ai_manager_userinfo:confirmed'] = 'Pokud uživatel potvrdil podmínky použití';
$string['privacy:metadata:local_ai_manager_userinfo:locked'] = 'Pokud byl uživatel uzamčen správcem tenanta';
$string['privacy:metadata:local_ai_manager_userinfo:role'] = 'Interní role správce AI, kódovaná jako celá čísla';
$string['privacy:metadata:local_ai_manager_userinfo:scope'] = 'Rozsah, ve kterém je uživatel oprávněn používat nástroje umělé inteligence, kódovaný jako celá čísla';
$string['privacy:metadata:local_ai_manager_userinfo:timemodified'] = 'Časové razítko poslední změny záznamu o uživateli';
$string['privacy:metadata:local_ai_manager_userinfo:userid'] = 'ID uživatele';
$string['privacy:metadata:local_ai_manager_userusage'] = 'Data využití uživateli';
$string['privacy:metadata:local_ai_manager_userusage:currentusage'] = 'Počet požadavků, které uživatel použil od posledního resetování';
$string['privacy:metadata:local_ai_manager_userusage:purpose'] = 'Účel, pro který se počítá počet žádostí';
$string['privacy:metadata:local_ai_manager_userusage:timemodified'] = 'Časové razítko poslední změny v záznamu o využití uživatelem';
$string['privacy:metadata:local_ai_manager_userusage:userid'] = 'ID uživatele';
$string['privacy_table_description'] = 'V níže uvedené tabulce naleznete přehled nástrojů AI nakonfigurovaných vaší školou. Váš správce klientů mohl ve sloupci „Odkaz na informace“ uvést další poznámky k podmínkám používání a oznámením o ochraně osobních údajů příslušných nástrojů AI.';
$string['privacy_terms_description'] = 'Následují poznámky o ochraně osobních údajů a podmínky použití ve stejné formě, jakou jste potvrdili nebo stále musíte potvrdit pro používání funkcí AI.';
$string['privacy_terms_heading'] = 'Ochrana osobních údajů a podmínky použití';
$string['privacy_terms_missing'] = 'Nebyly stanoveny žádné podmínky použití.';
$string['privacy_terms_missing_enable_anyway'] = 'Nejsou žádné další podmínky použití, které byste museli přijmout. Potvrďte prosím, že chcete pro svůj účet povolit nástroje AI.';
$string['privilegedroles'] = 'Privilegované role';
$string['privilegedrolesdesc'] = 'Výzvy uživatelů s těmito rolemi v kontextu systému nemohou zobrazit ostatní uživatelé, včetně správců klientů. Kromě toho jsou jména uživatelů s těmito rolemi anonymizována ve statistikách uživatelů.';
$string['prompt'] = 'Výzva';
$string['promptcompletitionfilesnotavailable'] = 'Vygenerované soubory nejsou k dispozici v zobrazení výzev.';
$string['promptsmodalheading'] = 'Výzvy a dokončení pro uživatele {$a->userDisplayName} v kontextu {$a->contextDisplayName}';
$string['purpose'] = 'Účel';
$string['purposedescription'] = 'Jaký je účel "{$a}"?';
$string['purposesdescription'] = 'Který z vašich nakonfigurovaných nástrojů AI by měl být použit k jakému účelu?';
$string['purposesheading'] = 'Účely pro {$a->role} (přiřazeno {$a->currentcount}/{$a->maxcount})';
$string['purposeusageinfoheading'] = 'Použití účelu "{$a}"';
$string['quotaconfig'] = 'Konfigurace limitů';
$string['quotadescription'] = 'Zde nastavte časové okno a maximální počet požadavků na studenta a učitele. Po uplynutí časového okna se počet požadavků automaticky vynuluje.';
$string['request_count'] = 'Počet požadavků';
$string['requesttimeout'] = 'Časový limit pro požadavek na koncové body AI';
$string['requesttimeoutdesc'] = 'Maximální doba v sekundách pro požadavky na externí koncové body AI';
$string['requireconfirmtou'] = 'Vyžadovat potvrzení podmínek použití';
$string['requireconfirmtoudesc'] = 'Povolte, pokud chcete, aby uživatelé museli potvrdit podmínky použití, než budou moci používat nástroje AI poskytované správcem AI.';
$string['resetfilter'] = 'Obnovit filtry';
$string['resetuserusagetask'] = 'Obnovit data o využití uživateli Správce AI';
$string['restricttenants'] = 'Zamknout přístup pro určité klienty';
$string['restricttenantsdesc'] = 'Povolit omezení nástrojů AI na konkrétní klienty, které lze definovat pomocí konfigurační možnosti „allowedtenants“.';
$string['revokeconfirmation'] = 'Zrušit potvrzení';
$string['rightsconfig'] = 'Konfigurace práv';
$string['role'] = 'Role';
$string['role_basic'] = 'základní role';
$string['role_extended'] = 'rozšířená role';
$string['role_unlimited'] = 'neomezená role';
$string['scope'] = 'rozsah použití';
$string['scope_courses'] = 'Pouze v kurzech';
$string['scope_everywhere'] = 'Všude';
$string['select_tool_for_purpose'] = 'Účel {$a}';
$string['selecteduserscount'] = 'Vybráno {$a}';
$string['serviceaccountjson'] = 'Obsah souboru JSON účtu služby Google';
$string['small'] = 'malý';
$string['squared'] = 'na druhou';
$string['statistics_for'] = 'Statistiky pro {$a}';
$string['statisticsoverview'] = 'Globální přehled';
$string['subpluginspageheading'] = 'Dílčí doplňky AI Správce';
$string['subplugintype_aipurpose'] = 'Účel AI';
$string['subplugintype_aipurpose_plural'] = 'Účely AI';
$string['subplugintype_aitool'] = 'Nástroj AI';
$string['subplugintype_aitool_plural'] = 'Nástroje AI';
$string['table_heading_infolink'] = 'Informační odkaz';
$string['table_heading_instance_name'] = 'Název nástroje AI';
$string['table_heading_model'] = 'Model';
$string['table_heading_purpose'] = 'Účel';
$string['technical_function_heading'] = 'Technická funkčnost';
$string['technical_function_step1'] = 'Správce klientů ukládá konfiguraci pro konkrétní účel, například konfiguraci možnosti generování obrázků, protože jeho klient má smlouvu s OpenAI, takže může používat nástroj Dall-E.';
$string['technical_function_step2'] = 'Uživatel tohoto klienta pak v instanci Moodlu najde odpovídající funkci AI, například možnost vygenerovat obrázek pomocí promptu přímo v editoru a vložit ho do editoru.';
$string['technical_function_step3'] = 'Pokud uživatel nyní tuto funkci použije, je výzva odeslána na servery instance Moodlu a jimi vyhodnocena.';
$string['technical_function_step4'] = 'Servery instance Moodle používají uložená přístupová data pro nástroj umělé inteligence daného klienta a odesílají požadavek jménem uživatele na servery externího nástroje AI.';
$string['technical_function_step4_emphasized'] = 'V tomto procesu instance Moodlu funguje jako koncový uživatel externího nástroje, což znamená, že externí nástroj nemůže sledovat, který jednotlivý uživatel odeslal odpovídající požadavek nástroji s AI. Pro nástroj s AI je identifikovatelný pouze klient, ke kterému uživatel patří.';
$string['technical_function_step5'] = 'Odpověď z nástroje AI je odeslána zpět uživateli instancí Moodlu nebo je výsledek, například vygenerovaný obrázek, přímo integrován do příslušné aktivity.';
$string['technical_function_text'] = 'Při použití funkcí AI v rámci této instance Moodlu je technický postup následující:';
$string['temperature_creative_balanced'] = 'Vyrovnané';
$string['temperature_custom_value'] = 'Vlastní hodnota (mezi 0 a 1)';
$string['temperature_defaultsetting'] = 'Výchozí teplota';
$string['temperature_desc'] = 'Toto popisuje „náhodnost“ nebo „kreativitu“. Nízká teplota vygeneruje souvislejší, ale předvídatelnější text. Vysoké hodnoty znamenají kreativnější, ale nepřesnější text. Rozsah je od 0 do 1.';
$string['temperature_more_creative'] = 'Spíše kreativní';
$string['temperature_more_precise'] = 'Spíše přesné';
$string['temperature_use_custom_value'] = 'Použít vlastní hodnotu teploty';
$string['tenant'] = 'Klient';
$string['tenantcolumn'] = 'Sloupec klienta';
$string['tenantcolumndesc'] = 'Sloupec tabulky uživatelů, který obsahuje identifikátor klienta, ke kterému má být uživatel přidružen.';
$string['tenantconfig_heading'] = 'AI u vašeho klienta';
$string['tenantdisabled'] = 'zakázáno';
$string['tenantenabled'] = 'povoleno';
$string['tenantenabledescription'] = 'Aby vaši klienti získali přístup ke všem funkcím AI instance Moodle, musíte tyto funkce povolit a nakonfigurovat zde.';
$string['tenantenablednextsteps'] = 'Funkce AI instance Moodlu jsou nyní pro vašeho klienta povoleny. Upozorňujeme, že nyní musíte definovat nástroje a účely, aby byly funkce skutečně použitelné.<br/>Všichni uživatelé budou mít přístup k funkcím AI. Uživatele však můžete zakázat na stránce {$a}.';
$string['tenantenableheading'] = 'Nástroje AI u vašeho klienta';
$string['tenantnotallowed'] = 'Tato funkce je pro vašeho klienta globálně zakázána, a proto ji nelze použít.';
$string['termsofusesetting'] = 'Podmínky použití';
$string['termsofusesettingdesc'] = 'Zde můžete přidat specifické podmínky používání pro správce AI. Uživatel je bude muset přijmout, než bude moci nástroje AI používat.';
$string['toinfopage'] = 'Na stránku s informacemi o AI';
$string['unconfirmed'] = 'nepotvrzeno';
$string['unit_count'] = 'požadavek(y)';
$string['unit_token'] = 'token';
$string['unlock'] = 'Odemknout';
$string['unlockaitools'] = 'Chci odemknout nástroje AI pro svůj účet';
$string['updatelist'] = 'Aktualizovat seznam';
$string['usage'] = 'Používání';
$string['use_openai_by_azure_apiversion'] = 'Verze API prostředku Azure';
$string['use_openai_by_azure_deploymentid'] = 'ID nasazení prostředku Azure';
$string['use_openai_by_azure_heading'] = 'Použít OpenAI přes Azure';
$string['use_openai_by_azure_name'] = 'Název prostředku Azure';
$string['useconfirmlink'] = 'Potvrďte prosím zde: {$a}.';
$string['userconfig'] = 'Konfigurace uživatele';
$string['userconfirmation_headline'] = 'Potvrzení o použití nástrojů AI';
$string['userstatistics'] = 'Přehled uživatelů';
$string['userstatusupdated'] = 'Stav uživatele/uživatelů byl aktualizován.';
$string['userwithusageonlyshown'] = 'V této tabulce se zobrazují pouze uživatelé, kteří tento účel již využili.';
$string['verifyssl'] = 'Ověření SSL certifikátů';
$string['verifyssldesc'] = 'Pokud je tato možnost povolena, připojení k nástrojům AI bude navázáno pouze v případě, že lze certifikáty řádně ověřit. Doporučuje se zakázat pouze pro vývojářské účely!';
$string['vertex_cachingdisabled'] = 'Ukládání do mezipaměti zakázáno';
$string['vertex_cachingenabled'] = 'Ukládání do mezipaměti povoleno';
$string['vertex_disablecaching'] = 'Zakázat ukládání do mezipaměti';
$string['vertex_enablecaching'] = 'Povolit ukládání do mezipaměti';
$string['vertex_error_cachestatus'] = 'Chyba při dotazování/aktualizaci konfigurace mezipaměti Vertex AI';
$string['vertex_nocachestatus'] = 'Kliknutím na tlačítko Obnovit zobrazíte aktuální stav mezipaměti Vertex AI.';
$string['vertexcachestatus'] = 'Dotazování a změna stavu mezipaměti Vertex AI';
$string['viewprompts'] = 'Zobrazit výzvy';
$string['within'] = 've';
