<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'aiprovider_openai', language 'ja', version '4.5'.
 *
 * @package     aiprovider_openai
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action:generate_image:endpoint'] = 'APIエンドポイント';
$string['action:generate_image:model'] = 'AIモデル';
$string['action:generate_image:model_desc'] = 'ユーザプロンプトから画像を生成するために使用されるモデルです。';
$string['action:generate_text:endpoint'] = 'APIエンドポイント';
$string['action:generate_text:model'] = 'AIモデル';
$string['action:generate_text:model_desc'] = 'テキストレスポンスの生成に使用されるモデルです。';
$string['action:generate_text:systeminstruction'] = 'システムインストラクション';
$string['action:generate_text:systeminstruction_desc'] = 'このインストラクションはユーザのプロンプトとともにAIモデルに送信されます。どうしても必要な場合を除き、このインストラクションの編集は推奨できません。';
$string['action:summarise_text:endpoint'] = 'APIエンドポイント';
$string['action:summarise_text:model'] = 'AIモデル';
$string['action:summarise_text:model_desc'] = '提供されたテキストを要約するために使用されたモデルです。';
$string['action:summarise_text:systeminstruction'] = 'システムインストラクション';
$string['action:summarise_text:systeminstruction_desc'] = 'このインストラクションはユーザのプロンプトとともにAIモデルに送信されます。どうしても必要な場合を除き、このインストラクションの編集は推奨できません。';
$string['apikey'] = 'OpenAI APIキー';
$string['apikey_desc'] = 'あなたの<a href="https://platform.openai.com/account/api-keys" target="_blank">OpenAI APIキー</a>を取得します。';
$string['enableglobalratelimit'] = 'グローバルレート制限を設定にする';
$string['enableglobalratelimit_desc'] = 'OpenAI APIプロバイダが1時間ごとにサイト全体で受信できるリクエスト数を制限します。';
$string['enableuserratelimit'] = 'ユーザレート制限を設定にする';
$string['enableuserratelimit_desc'] = 'それぞれのユーザが1時間ごとにOpenAI APIプロバイダにリクエストできる回数を制限します。';
$string['globalratelimit'] = 'サイト全体の最大リクエスト数';
$string['globalratelimit_desc'] = '1時間に許可されるサイト全体のリクエスト数です。';
$string['orgid'] = 'OpenAI組織ID';
$string['orgid_desc'] = 'あなたのOpenAI組織IDをあなたの<a href="https://platform.openai.com/account/org-settings" target="_blank">OpenAIプラットフォームアカウント</a>から取得します。';
$string['pluginname'] = 'OpenAI APIプロバイダ';
$string['privacy:metadata'] = 'OpenAI APIプロバイダはいかなる個人データも保存しません。';
$string['privacy:metadata:aiprovider_openai:externalpurpose'] = 'この情報はレスポンスを生成するためにOpenAI APIに送信されます。あなたのOpenAI AIアカウント設定によりOpenAIがこのデータを保存および保持する方法が変更される場合があります。このプラグインによりユーザデータが明示的にOpenAIに送信されたり、Moodle LMSに保存されることはありません。';
$string['privacy:metadata:aiprovider_openai:model'] = 'レスポンスの生成に使用されたモデルです。';
$string['privacy:metadata:aiprovider_openai:numberimages'] = '画像を生成する場合のレスポンスに使用される画像数です。';
$string['privacy:metadata:aiprovider_openai:prompttext'] = 'レスポンスを生成するためにユーザが入力したテキストプロンプトです。';
$string['privacy:metadata:aiprovider_openai:responseformat'] = '画像を生成する場合のレスポンスのフォーマットです。';
$string['userratelimit'] = 'ユーザごとの最大リクエスト数';
$string['userratelimit_desc'] = 'ユーザごとに1時間に許可されるリクエスト数です。';
