<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'enrol_self', language 'no', version '4.5'.
 *
 * @package     enrol_self
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['canntenrol'] = 'Påmeldinger er avslått eller inaktive.';
$string['canntenrolearly'] = 'Du kan ikke melde deg på ennå. Påmeldingen åpner {$a}.';
$string['canntenrollate'] = 'Du kan ikke melde deg på lengre. Påmeldingen stengte {$a}';
$string['cohortnonmemberinfo'] = 'Kun medlemmer av kohorten \'{$a}\' kan melde seg på selv.';
$string['cohortonly'] = 'Kun kohort-medlemmer';
$string['cohortonly_help'] = 'Egenpåmelding kan begrenses til medlemmer av en angitt kohort. Vær oppmerksom på at endring av denne innstillingen ikke har noen virkning på eksisterende påmeldinger.';
$string['confirmbulkdeleteenrolment'] = 'Er du sikker på at du ønsker å slette disse brukerpåmeldingene?';
$string['customwelcomemessage'] = 'Egendefinert velkomstmelding';
$string['customwelcomemessage_help'] = 'En egendefinert velkomstmelding kan legges til som vanlig tekst eller Moodle auto-format, inkludert HTML-tagger og flerspråktagger. Følgende plassholdere kan legges inn i meldingen:
<ul>
<li>Kursnavn {$a->coursename}</li>
<li>Lenke til brukerens profilside {$a->profileurl}</li>
<li>Brukerens epostadresse {$a->email}</li>
<li>Brukerens navn {$a->fullname}</li>
<li>Brukerens fornavn $a->firstname}</li>
<li>Brukerens etternavn {$a->lastname}</li>
<li>Brukerens kursrolle {$a->courserole}</li>
</ul>';
$string['defaultrole'] = 'Standard rolletildeling';
$string['defaultrole_desc'] = 'Velg hvilken rolle som skal tildeles brukerne når de melder seg inn selv.';
$string['deleteselectedusers'] = 'Slett valgte brukerpåmeldinger';
$string['editselectedusers'] = 'Rediger valgte brukerpåmeldinger';
$string['enrolenddate'] = 'Sluttdato';
$string['enrolenddate_help'] = 'Hvis denne funksjonen er aktivert, kan brukere kun melde seg på fram til denne datoen.';
$string['enrolenddaterror'] = 'Sluttdatoen for påmelding kan ikke være tidligere enn startdatoen.';
$string['enrolme'] = 'Meld meg på';
$string['enrolperiod'] = 'Påmeldingsvarighet';
$string['enrolperiod_desc'] = 'Standard lengde på påmeldingsperioden. Hvis denne settes til null, settes påmeldingsvarigheten til ubegrenset som standard.';
$string['enrolperiod_help'] = 'Lengde på påmeldingsperioden. Den starter det øyeblikket brukeren melder seg på. Hvis denne funksjonen er deaktivert, vil påmeldingsvarigheten være ubegrenset.';
$string['enrolstartdate'] = 'Startdato';
$string['enrolstartdate_help'] = 'Hvis denne funksjonen er aktivert, kan brukere kun melde seg på fra og med denne datoen.';
$string['expiredaction'] = 'Handling for utløpt påmelding';
$string['expiredaction_help'] = 'Velg handling som skal utføres når brukerpåmeldingen utløper. Vær oppmerksom på at noen brukerdata og innstillinger fjernes fra kurset under avmeldingen fra kurset.';
$string['expiryinactivemessageenrolledbody'] = 'Hi {$a->user},

Påmeldingen din i kurset {$a->course} utløper den {$a->timeend} siden du ikke har besøkt kurssiden {$a->inactivetime} på dager.

For å beholde tilgangen til kurset må du logge inn og besøke kurssiden <a href="{$a->url}">{$a->course}</a> før {$a->timeend}.';
$string['expiryinactivemessageenrolledsubject'] = 'Påmeldingen din utløper: {$a->course}';
$string['expirymessageenrolledbody'] = 'Hei {$a->user},

Dette er melding om at din påmelding i kurset \'{$a->course}\' utløper {$a->timeend}.

Hvis du trenger hjelp, vennligst ta kontakt med {$a->enroller}.';
$string['expirymessageenrolledsubject'] = 'Varsel om at egenpåmeldingen utløper';
$string['expirymessageenrollerbody'] = 'Egenpåmelding i kurset \'{$a->course}\' utløper i løpet av de neste {$a->threshold} for følgende brukerere:

{$a->users}

For å forlenge påmeldingen deres, gå til {$a->extendurl}';
$string['expirymessageenrollersubject'] = 'Melding om at egenpåmelding utløper';
$string['expirynotifyall'] = 'Påmelder og påmeldt bruker';
$string['expirynotifyenroller'] = 'Kun påmelder';
$string['groupkey'] = 'Bruk gruppepåmeldingsnøkler';
$string['groupkey_desc'] = 'Bruk som standard gruppepåmeldingsnøkler';
$string['groupkey_help'] = 'I tillegg til å begrense tilgang til kurset til kun de som kjenner påmeldingsnøkkelen, vil bruk av gruppepåmeldingsnøkler også melde dem inn i riktig gruppe.

OBS: Dersom du skal bruke gruppepåmeldingsnøkler må dette angis i kursinnstillingene i tillegg til at nøklene skrives inn i innstillingene for hver gruppe.';
$string['keyholder'] = 'Du skulle ha mottatt påmeldingsnøkkelen fra:';
$string['longtimenosee'] = 'Meld ut inaktive brukere etter';
$string['longtimenosee_help'] = 'Dersom brukere ikke har besøkt kurset på lang tid blir de automatisk utmeldt. Denne parameteren angir tidsgrensen for dette.';
$string['maxenrolled'] = 'Maksimum antall påmeldte brukere';
$string['maxenrolled_help'] = 'Angi maksimum antall brukere som kan melde seg inn selv. Tallet  -0- betyr ubegrenset.';
$string['maxenrolledreached'] = 'Maksimum antall brukere for egenpåmelding var allerede nådd.';
$string['messageprovider:expiry_notification'] = 'Meldinger om at egenpåmelding utløper';
$string['newenrols'] = 'Tillat nye egenpåmeldinger';
$string['newenrols_desc'] = 'Tillat brukere å melde seg på nye kurs selv som standard';
$string['newenrols_help'] = 'Denne innstillingen bestemmer om en bruker kan melde seg på dette kurset.';
$string['nopassword'] = 'Meld deg på via knappen under.';
$string['password'] = 'Påmeldingsnøkkel';
$string['password_help'] = 'En påmeldingsnøkkel begrenser påmeldingen til kun de som kjenner nøkkelen.

Dersom feltet er tomt kan alle brukere melde seg inn.

Dersom du oppgir en påmeldingsnøkkel må en bruker oppgi denne nøkkelen for å kunne melde seg inn. Påmeldingsnøkkelen brukes bare til påmelding og brukeren blir siden ikke spurt flere ganger.';
$string['passwordinvalid'] = 'Ugyldig påmeldingsnøkkel, vennligst prøv en gang til.';
$string['passwordinvalidhint'] = 'Påmeldingsnøkkelen var feil. Prøv på nytt. (Her er et hint - den begynner på \'{$a}\')';
$string['passwordmatchesgroupkey'] = 'Påmeldingsnøkkel samsvarer med en eksisterende gruppepåmeldingsnøkkel';
$string['pluginname'] = 'Egenpåmelding';
$string['pluginname_desc'] = 'Modulen for egenpåmelding lar brukere velge hvilke kurs de vil delta på. Kursene kan beskyttes med påmeldingsnøkler. Du kan i tillegg melde inn brukere via kursets \'Tildele roller\'.';
$string['privacy:metadata'] = 'Modulen "Egenpåmelding" lagrer ikke noen persondata.';
$string['requirepassword'] = 'Krev påmeldingsnøkkel';
$string['requirepassword_desc'] = 'Krev påmeldingsnøkkel i nye kurs og forhindre fjerning av påmeldingsnøkler fra eksisterende kurs.';
$string['role'] = 'Standard tildelt rolle';
$string['self:config'] = 'Konfigurer instanser av egenpåmelding';
$string['self:enrolself'] = 'Egenpåmelding til kurs';
$string['self:holdkey'] = 'Vis som egenpåmeldingsnøkkelholderen.';
$string['self:manage'] = 'Aministrere påmeldte brukere';
$string['self:unenrol'] = 'Meld ut brukere fra kurs';
$string['self:unenrolself'] = 'Meld ut meg selv fra kurset';
$string['sendcoursewelcomemessage'] = 'Send en kurs-velkomstmelding';
$string['sendcoursewelcomemessage_help'] = 'Når kursdeltakere melder seg på via egepåmelding kan de bli sendt en velkomstepost. Denne eposten vil ha den kursansvarlige (vanligvis lærer-rollen) som avsender. Dersom det er mer enn en bruker med denne rollen i kurset, vil eposten sendes fra den første som fikk rollen.';
$string['sendexpirynotificationstask'] = 'Oppgave for utsendelse av utmeldingsvarsel ved egenpåmelding.';
$string['showhint'] = 'Vis tips';
$string['showhint_desc'] = 'Vis første bokstav av påmeldingsnøkkelen for gjestetilgang.';
$string['status'] = 'Hold gjeldende egenpåmeldinger aktive';
$string['status_desc'] = 'Aktiver påmeldingsmetoden "Egenpåmelding" i nye kurs';
$string['status_help'] = 'Hvis satt til Nei, vil eventuelle eksisterende deltakere som meldte seg på kurset ikke lenger ha tilgang.';
$string['syncenrolmentstask'] = 'Synkroniseringsoppgave for egenpåmelding';
$string['unenrol'] = 'Meld ut bruker';
$string['unenrolselfconfirm'] = 'Ønsker du virkelig å melde deg selv ut fra kurset "{$a}"?';
$string['unenroluser'] = 'Vil du virkelig melde ut "{$a->user}" fra kurs "{$a->course}"?';
$string['unenrolusers'] = 'Meld ut brukere';
$string['usepasswordpolicy'] = 'Bruk passordregler';
$string['usepasswordpolicy_desc'] = 'Bruk portalens passordordregler også for påmeldingsnøkler.';
$string['welcometocourse'] = 'Velkommen til {$a}';
$string['welcometocoursetext'] = 'Velkommen til {$a->coursename}!
Hvis du ikke har gjort det enda bør du redigere profilen din (informasjon om deg selv) slik at vi kan bli bedre kjent med deg:
  {$a->profileurl}';
