<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'error', language 'it', version '4.5'.
 *
 * @package     error
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['TODO'] = 'TODO';
$string['activityisscheduledfordeletion'] = 'Eliminazione dell\'attività in corso...';
$string['agedigitalconsentmapinvalidage'] = '"{$a}" non è un valore valido per l\'età.';
$string['agedigitalconsentmapinvalidcomma'] = '"{$a}" ha una virgola di separazione in più o in meno.';
$string['agedigitalconsentmapinvalidcountry'] = '"{$a}" non è un valore valido per la nazione.';
$string['agedigitalconsentmapinvaliddefault'] = 'Manca il valore di default (*).';
$string['agelocationverificationdisabled'] = 'La verifica dell\'età e della della nazione è disabilitata';
$string['alreadyloggedin'] = 'Sei già autenticato come {$a}, per autenticarti con un altro account devi effettuare il logout.';
$string['authnotexisting'] = 'Il plugin di autenticazione non esiste';
$string['backupcontainexternal'] = 'Questo file di backup contiene host Moodle Network che non sono definiti in questo sito';
$string['backuptablefail'] = 'Non è stato possibile impostare le tabelle del backup';
$string['blockcannotadd'] = 'Non è possibile aggiungere il blocco';
$string['blockcannotconfig'] = 'Questo blocco non supporta configurazioni globali';
$string['blockcannotinistantiate'] = 'Si è verificato un problema istanziando un block object';
$string['blockcannotread'] = 'Non è stato possibile leggere i dati del blockid={$a}';
$string['blockdoesnotexist'] = 'Questo blocco non esiste';
$string['blockdoesnotexistonpage'] = 'Questo blocco (id={$a->instanceid}) non esiste in questa pagina ({$a->url}).';
$string['blocknameconflict'] = 'Conflitto di nomi: il blocco {$a->name} ha lo stesso nome di un blocco già esistente: Naming conflict: block {$a->name} has the same title with an existing block: {$a->conflict}!';
$string['callbackrejectcomment'] = 'Il modulo ha respinto l\'inserimento del commento';
$string['cannotaddcoursemodule'] = 'Non è stato possibile aggiungere il modulo al corso';
$string['cannotaddcoursemoduletosection'] = 'Non è stato possibile aggiungere il modulo in questa sezione';
$string['cannotaddmodule'] = 'Non è stato possibile aggiungere il modulo {$a} nell\'elenco dei moduli!';
$string['cannotaddnewmodule'] = 'Non è stato possibile aggiungere il modulo {$a}';
$string['cannotaddrss'] = 'Non sei autorizzati ad aggiungere feed RSS';
$string['cannotaddthisblocktype'] = 'Non è possibile aggiungere il blocco {$a} su questa pagina';
$string['cannotassignrole'] = 'Non è possibile assegnare ruoli nel corso';
$string['cannotassignrolehere'] = 'Non sei autorizzato ad attribuire questo ruolo (id = {$a->roleid}) nel contesto ({$a->context})';
$string['cannotassignselfasparent'] = 'Non è possibile assegnare se stesso come genitore!';
$string['cannotcallscript'] = 'Non è possibile chiamare questo script in quel modo!';
$string['cannotcallusgetselecteduser'] = 'Non puoi chiamare user_selector::get_selected_user se multiselect è true';
$string['cannotcreatebackupdir'] = 'Non è stato possibile creare la cartella backupdata. L\'amministratore del sito deve sistemare i permessi dei file.';
$string['cannotcreatecategory'] = 'La categorie non è stata inserita';
$string['cannotcreatedboninstall'] = '<p>Non è possibile creare il database </p> <p>Il database non esiste e l\'utente fornito non è autorizzato a crearlo.</p>
<p>È necessario che l\'amministratore del sito  verifichi  la configurazione del database.</p>';
$string['cannotcreategroup'] = 'Si è verificato un errore durante la creazione di un gruppo';
$string['cannotcreatelangbase'] = 'Errore: non è stato possibile creare la cartella lang';
$string['cannotcreatelangdir'] = 'Non è possibile creare la cartella lang';
$string['cannotcreateorfindstructs'] = 'Si è verificato un errore durante la ricerca o la creazione della struttura delle sezioni di questo corso';
$string['cannotcreatepopupwin'] = 'Elemento non definito - Non è possibile creare la finestra popup';
$string['cannotcreatesitedir'] = 'Non è possibile creare la cartella del sito. L\'amministratore del sito deve sistemare i permessi dei file.';
$string['cannotcreatetempdir'] = 'Non è possibile creare la cartella temp';
$string['cannotcreateuploaddir'] = 'Non è possibile creare la cartella di caricamento. L\'amministratore del sito deve sistemare i permessi dei file.';
$string['cannotcustomisefiltersblockuser'] = 'Non è possibile personalizzare i filtri nei contesti dell\'utente o dei blocchi.';
$string['cannotdeletebackupids'] = 'Non è stato possibile eliminare le id dei backup precedenti';
$string['cannotdeletecategorycourse'] = 'Non è stato possibile eliminare il corso \'{$a}\'';
$string['cannotdeletecategoryquestions'] = 'Non è stato possibile eliminare le domande dalla categoria \'{$a}\'';
$string['cannotdeletecourse'] = 'Non avete il privilegio per eliminare questo corso';
$string['cannotdeletecustomfield'] = 'Si è verificato un errore durante l\'eliminazione dei campi personalizzati';
$string['cannotdeletedir'] = 'Non è possibile eliminare ({$a})';
$string['cannotdeletefile'] = 'Non è possibile eliminare il file';
$string['cannotdeleterole'] = 'Non può essere eliminato.Il motivo è {$a}';
$string['cannotdeleterolewithid'] = 'Non è stato possibile eliminare il ruolo con ID {$a}';
$string['cannotdeletethisrole'] = 'Non puoi eliminare questo ruolo poiché è usato dal sistema oppure è l\'unico ruolo rimasto con privilegi da amministratore';
$string['cannotdisableformat'] = 'Non è possibile disabilitare il formato di default';
$string['cannotdownloadcomponents'] = 'Non è possibile scaricare componenti.';
$string['cannotdownloadlanguageupdatelist'] = 'Non è possibile scaricare la lista degli aggiornamenti dei language pack da moodle.org';
$string['cannotdownloadzipfile'] = 'Non è possibile scaricare file ZIP.';
$string['cannoteditcomment'] = 'Non puoi modificare commenti che non sono tuoi!';
$string['cannoteditcommentexpired'] = 'Non puoi modificarlo. Il tempo è scaduto!';
$string['cannoteditpostorblog'] = 'Non puoi inserire o modificare interventi nei blog';
$string['cannoteditsiteform'] = 'Non puoi modificare il corso nella pagina home usando questo form';
$string['cannotedituserpreferences'] = 'Non è possibile modificare le preferenze di questo utente';
$string['cannotedityourprofile'] = 'Spiacente, non sei autorizzato a modificar eil tuo profilo';
$string['cannotexecduringupgrade'] = 'Non può essere elaborato durante l\'aggiornamento';
$string['cannotfindcategory'] = 'Non è possibile trovare nel database il record della categoria con ID - {$a}';
$string['cannotfindcomponent'] = 'Non è possibile trovare il componente.';
$string['cannotfindcontext'] = 'Non è possibile trovare il contesto';
$string['cannotfindcourse'] = 'Non è possibile trovare il corso';
$string['cannotfinddocs'] = 'Non è possibile trovare i file di documentazione per la lingua "{$a}"';
$string['cannotfindgradeitem'] = 'Non è possibile trovare l\'elemento di valutazione';
$string['cannotfindgroup'] = 'Non è possibile trovare il gruppo';
$string['cannotfindhelp'] = 'Non è possibile trovare gli help file della lingua "{$a}"';
$string['cannotfindinfo'] = 'Non è possibile trovare per: "{$a}"';
$string['cannotfindlang'] = 'Non è possibile trovare il language pack "{$a}"';
$string['cannotfindteacher'] = 'Non è possibile trovare docenti';
$string['cannotfinduser'] = 'Non è possibile trovare l\'utente di nome "{$a}"';
$string['cannotgeoplugin'] = 'Non è possibile collegarsi al server geoPlugin disponibile su https://www.geoplugin.com, per favore verificare le impostazioni del proxy oppure installare il file di dati MaxMind GeoIP City';
$string['cannotgetblock'] = 'Non è stato possibile ottenere i blocchi dal database';
$string['cannotgetcats'] = 'Non è possibile ottenere il record della categoria';
$string['cannotgetdata'] = 'Non è possibile ottenere dati';
$string['cannotgradeuser'] = 'Non è possibile valutare questo utente';
$string['cannothaveparentcate'] = 'Le categorie di corso non possono avere un genitore!';
$string['cannotimport'] = 'Errore di importazione';
$string['cannotimportformat'] = 'Spiacente, l\'importazione con questo formato non è ancora implementata!';
$string['cannotimportgrade'] = 'Errore di importazione delle valutazioni';
$string['cannotinsertgrade'] = 'Non è possibile inserire elementi di valutazione senza la id del corso!';
$string['cannotinsertrate'] = 'Non è possibile inserire nuove valutazioni ({$a->id} = {$a->rating})';
$string['cannotinsertrecord'] = 'Non è possibile inserire il nuove rcord ID {$a}';
$string['cannotmailconfirm'] = 'Si è verificato un errore durante l\'invio della email di conferma del cambio email';
$string['cannotmanualctrack'] = 'L\'attività non prevede il completamento manuale';
$string['cannotmapfield'] = 'Conflitto di mappatura - due campi sono mappati allo stesso elemento di valutazione {$a}';
$string['cannotmarktopic'] = 'Non è stato possibile contrassegnare quella sezione in questo corso';
$string['cannotmigratedatacomments'] = 'Non è possibile migrare i commenti del modulo database';
$string['cannotmodulename'] = 'Non è possibile ottenere il nome del modulo per costruire la navigazione';
$string['cannotmoduletype'] = 'Non è possibile ottenere l\'id del modulo per costruire la navigazione';
$string['cannotmovecategory'] = 'Non è possibile spostare la categoria';
$string['cannotmovecourses'] = 'Non è possibile spostare corsi dalla loro categoria ad un\'altra';
$string['cannotmoverolewithid'] = 'Non è possibile spostare il ruolo con ID {$a}';
$string['cannotopencsv'] = 'Non è possibile aprire il file CSV';
$string['cannotopenfile'] = 'Non è possibile aprire il file ({$a})';
$string['cannotopenforwrit'] = 'Non è possibile aprire in scrittura: {$a}';
$string['cannotopentemplate'] = 'Non è possibile aprire il file template ({$a})';
$string['cannotopenzip'] = 'Non è possibile aprire il file zip, probabilmente è un bug delle estensioni zip nei sistemi operativi a 64bit';
$string['cannotoverridebaserole'] = 'Non è possibile modificare i privilegi dei ruoli base';
$string['cannotoverriderolehere'] = 'Non sei autorizzato a modificare questo ruolo (id = {$a->roleid}) nel contesto ({$a->context})';
$string['cannotreadfile'] = 'Non è possibile leggere il file ({$a})';
$string['cannotreadtmpfile'] = 'Si è verificato un errore durante la lettura del file temporaneo';
$string['cannotreaduploadfile'] = 'Non è stato possibile leggere il file caricato';
$string['cannotremovefrommeta'] = 'Non è stato possibile rimuovere il corso selezionato da questo meta corso!';
$string['cannotreprocessgrades'] = 'Non è stato possibile ricalcolare le valutazioni per l\'attività {$a}';
$string['cannotresetguestpwd'] = 'Non puoi resettare la password dell\'utente opsite';
$string['cannotresetmail'] = 'Si è verificato un errore durante il reset e l\'invio della tua password';
$string['cannotresetthisrole'] = 'Non è possibile resettare questo ruolo';
$string['cannotrestore'] = 'Si è verificato un errore ed il ripristino non è stato completato';
$string['cannotrestoreadminorcreator'] = 'Devi avere il ruolo di amministratore o di creatore di corsi per ripristinare un backup in un corso nuovo !';
$string['cannotrestoreadminoredit'] = 'Devi avere il ruolo il ruolo di amministratore o di docente per ripristinare un backup nel corso selezionato!';
$string['cannotsaveagreement'] = 'Non è stato possibile salvare il tuo accordo';
$string['cannotsaveblock'] = 'Si è verificato un errore durante il salvataggio della configurazione del blocco';
$string['cannotsavecomment'] = 'Non è possibile salvare il commento';
$string['cannotsavedata'] = 'Non è possibile salvare i dati';
$string['cannotsavefile'] = 'Non è possibile salvare il file "{$a}"!';
$string['cannotsavemd5file'] = 'Non è possibile salvare il file md5';
$string['cannotsavezipfile'] = 'Non è possibile salvare il file ZIP';
$string['cannotservefile'] = 'Non è possibile salvare il file a causa di problemi nella configurazione del server.';
$string['cannotsetparentforcatoritem'] = 'Non è possibile impostare un genitore per la categoria o l\'elemento del corso';
$string['cannotsetpassword'] = 'Non è stato possibile impostare la password utente!';
$string['cannotsetprefgrade'] = 'Non è stato possibile impostare la vista dell\'aggregazione a {$a} per questa categoria di valutazioni';
$string['cannotsettheme'] = 'Non è stato possibile impostare il tema!';
$string['cannotsetupblock'] = 'Non è stato possibile impostare correttamente le tabelle dei blocchi!';
$string['cannotsetupcapformod'] = 'Non è stato possibile impostare i privilegi per {$a}';
$string['cannotsetupcapforplugin'] = 'Non è stato possibile impostare i privilegi per {$a}';
$string['cannotshowhidecoursesincategory'] = 'Non è possibile visualizzare/nascondere il corso nella categoria {$a}';
$string['cannotsignup'] = 'Non puoi creare un nuovo account poiché sei già autenticato come {$a}.';
$string['cannotunassigncap'] = 'Non è possibile rimuovere il privilegio deprecato {$a->cap} dal ruolo {$a->role}';
$string['cannotunassignrolefrom'] = 'Non è possibile togliere a questo utente il ruolo id: {$a}';
$string['cannotunzipfile'] = 'Non è possibile decomprimere il file.';
$string['cannotupdatemod'] = 'Non è stato possibile aggiornare {$a}';
$string['cannotupdatepasswordonextauth'] = 'Non è stato possibile aggiornare la password dell\'autenticazione esterna: {$a}. Controllare i log per maggiori informazioni.';
$string['cannotupdateprofile'] = 'Si è verificato un errore durante l\'aggiornamento del record utente';
$string['cannotupdaterecord'] = 'Non è stato possibile aggiornare il record ID {$a}';
$string['cannotupdaterss'] = 'Non è possibile aggiornare gli RSS';
$string['cannotupdatesubcourse'] = 'Non è stato possibile aggiornare il corso figlio!';
$string['cannotupdateusermsgpref'] = 'Non è possibile aggiornare le preferenze di messaging dell\'utente';
$string['cannotupdateuseronexauth'] = 'Non è stato possibile aggiornare i dati utente dell\'autenticazione esterna: {$a}. Controllare i log per maggiori informazioni.';
$string['cannotuploadfile'] = 'Si è verificato un errore durante l\'elaborazione del file caricato';
$string['cannotuseadmin'] = 'Devi avere il ruolo di amministratore per usare questa pagina';
$string['cannotuseadminadminorteacher'] = 'Devi avere il ruolo di docente o di amministratore per usare questa pagina';
$string['cannotusepage'] = 'Solo i docenti e gli amministratori possono usare questa pagina';
$string['cannotusepage2'] = 'Spiacente, non puoi usare questa pagina';
$string['cannotviewcategory'] = 'Non sei autorizzato a visualizzare l\'elenco dei corsi.';
$string['cannotviewprofile'] = 'Non puoi visualizzare il profilo di questo utente.';
$string['cannotviewreport'] = 'Non puoi visualizzare questo report';
$string['cannotwritefile'] = 'Non è possibile scrivere sul file ({$a})';
$string['categoryerror'] = 'Errore di categoria';
$string['categoryidnumbertaken'] = 'Il Codice identificativo è già usato da un\'altra categoria';
$string['categorynamerequired'] = 'Il nome della categoria è obbligatorio';
$string['categorytoolong'] = 'Il nome della categoria è troppo lungo';
$string['commentmisconf'] = 'l\'ID del commento è mal configurata';
$string['componentisuptodate'] = 'Il componente è aggiornato.';
$string['confirmationnotenabled'] = 'La conferma di account non è abilitata';
$string['confirmsesskeybad'] = 'Spiacente, ma la tua chiave di sessione non può essere confermata per completare questa operazione. Questa caratteristica di sicurezza previene l\'esecuzione accidentale o maligna di funzioni importanti effettuate a tuo nome. Assicurati di voler eseguire realmente questa funzione.';
$string['contenttypenotfound'] = 'Il deposito dei contenuti \'{$a}\' non esiste o non viene riconosciuto';
$string['contentvisibilitynotfound'] = 'La visibilità del contenuto con valore \'{$a}\' non esiste o non è riconosciuta.';
$string['couldnotassignrole'] = 'Si è verificato un problema non specificato ma serio mentre si tentava di assegnarvi un ruolo';
$string['couldnotupdatenoexistinguser'] = 'Non è possibile aggiornare l\'utente: l\'utente non esiste';
$string['couldnotverifyagedigitalconsent'] = 'Si è verificato un errore durante la verifica dell\'età del consenso digitale.<br />Per favore contatta l\'amministratore del sito.';
$string['countriesphpempty'] = 'Errore: nel language pack {$a} il file countries.php è vuoto o mancante';
$string['coursedoesnotbelongtocategory'] = 'Il corso non appartiene a questa categoria';
$string['courseformatnotfound'] = 'Il formato di corso \'{$a}\'  non esiste oppure non viene riconosciuto.';
$string['coursegroupunknown'] = 'Il corso corrisponde a un gruppo {$a} non specificato';
$string['courseidnotfound'] = 'L\'ID del corso non esiste.';
$string['courseidnumbertaken'] = 'Il codice identificativo è già usato da un altro corso ({$a})';
$string['coursemisconf'] = 'Il corso è mal configurato';
$string['courserequestdisabled'] = 'Purtroppo i corsi a richiesta sono stati disabilitati dall\'amministratore';
$string['csvcolumnduplicates'] = 'Sono state individuate colonne duplicate';
$string['csvemptyfile'] = 'Il file CSV è vuoto';
$string['csvfewcolumns'] = 'Non ci sono abbastanza colonne, per favore controllare le impostazioni del delimitatore di campo.';
$string['csvfileerror'] = 'Il file CSV ha un formato non corretto. Controllare la corrispondenza tra intestazioni e colonne, il delimitatore utilizzato e la codifica: {$a}';
$string['csvinvalidcols'] = '<b>File CVS non valido:</b> la prima riga deve contenere "Header fields" ed il file deve essere di tipo <br />"Expanded Fields/Comma Separated" <br />oppure<br /> "Expanded Fields with CAVV Result Code/Comma Separated"';
$string['csvinvalidcolsnum'] = 'File CSV non valido - Ciascuna linea deve contenere 49 o 70 campi.';
$string['csvloaderror'] = 'Si è verificato un errore durante il caricamento del file: {$a}';
$string['csvnodata'] = 'Il file CSV non è valido, sono presenti le intestazioni ma non ci sono dati.';
$string['csvweirdcolumns'] = 'Il formato del file CSV non è valido - il numero delle colonne non è uniforme.';
$string['dbconnectionfailed'] = '<p>Errore: la connessione al Database non è andata a buon fine</p>
<p>È possibile che il database sia sovraccarico oppure non stia funzionando correttamente.</p>
<p>L\'amministratore del sito dovrebbe anche controllare che il database sia stato configurato correttamente nel file config.php</p>';
$string['dbdriverproblem'] = '<p>Errore: è stato rilevato un problema sui driver del database</p>
<p>L\'amministratore del sito dovrebbe verificare la configurazione del server</p><p>{$a}</p>';
$string['dbsessionbroken'] = 'È stato individuato un problema serio nelle database session.<br /><br />Per favore avvertite l\'amministratore del server.';
$string['dbsessionhandlerproblem'] = 'L\'impostazione delle database session non è andato a buon fine. Per favore avverti l\'amministratore del server.';
$string['dbsessionmysqlpacketsize'] = 'È stato rilevato un errore di sessione grave. Per favore avvertire l\'amministratore, probabilmente il problema è originato da un valore troppo piccolo per max_allowed_packet nelle impostazioni di MySQL.';
$string['dbupdatefailed'] = 'L\'aggiornamento del Database non è andato a buon fine.';
$string['ddldependencyerror'] = '{$a->targettype} "{$a->targetname}" non può essere modificato. È stata rilevata una dipendenza da {$a->offendingtype} "{$a->offendingname}"';
$string['ddlexecuteerror'] = 'Si è verificato un errore durante l\'esecuzione di DDL sql';
$string['ddlfieldalreadyexists'] = 'Il campo "{$a}" esiste già';
$string['ddlfieldnotexist'] = 'Il campo "{$a->fieldname}" non esiste nella tabella "{$a->tablename}"';
$string['ddltablealreadyexists'] = 'La tabella "{$a}" esiste già';
$string['ddltablenotexist'] = 'La tabella "{$a}" non esiste';
$string['ddlunknownerror'] = 'Si è verificato un errore sconosciuto nella libreria DDL';
$string['ddlxmlfileerror'] = 'Sono stati rilevati errori nel file XML del database';
$string['ddsequenceerror'] = 'Definizione errata della tabella "{$a}"; può essere presente solo una auto column e deve essere definita come key';
$string['destinationcmnotexit'] = 'Il modulo destinazione del corso non esiste';
$string['detectedbrokenplugin'] = 'Il plugin "{$a}" è difettoso o non aggiornato, non è possibile proseguire.';
$string['dmlexceptiononinstall'] = '<p>Si è verificato un errore nel database: [{$a->errorcode}].<br />{$a->debuginfo}</p>';
$string['dmlparseexception'] = 'Si è verificato un errore durante l\'interpretazione della query SQL';
$string['dmlreadexception'] = 'Si è verificato un errore durante la lettura del database';
$string['dmltransactionexception'] = 'Si è verificato un errore nella transazione del database';
$string['dmlwriteexception'] = 'Si è verificato un errore durante la scrittura nel database';
$string['dndmaxbytes'] = 'Il file è troppo grande. La dimensione massima è {$a->size}';
$string['dndread'] = 'Si è verificato un errore durante la lettura del file';
$string['dndunkownfile'] = 'Questo tipo di file non è supportato.';
$string['dndupload'] = 'Si è verificato un errore sconosciuto durante il caricamento del file.';
$string['downgradedcore'] = 'Errore: la versione del codice in uso è più vecchia della versione usata per creare il database';
$string['downloadedfilecheckfailed'] = 'Il controllo del file scaricato non è andato a buon fine.';
$string['duplicatefieldname'] = 'È stato individuato un nome di campo duplicato: "{$a}"';
$string['duplicatenosupport'] = 'Non è stato possibile duplicare l\'attività \'{$a->modname}\' poiché il modulo {$a->modtype} non supporta il backup e ripristino.';
$string['duplicateparaminsql'] = 'Errore: query con nome duplicato del parametro';
$string['duplicaterolename'] = 'Esiste giù un ruolo con questo nome!';
$string['duplicateroleshortname'] = 'Esiste giù un ruolo con questo nome abbreviato!';
$string['duplicateusername'] = 'Nome utente duplicato - record saltato';
$string['editedpagenotfound'] = 'Il sistema non è riuscito a determinare la pagina in cui ti trovi. Per favore ricarica la pagina e riprova.';
$string['emailfail'] = 'Invio email fallito';
$string['encryption_decryptfailed'] = 'La decifratura non è andata a buon fine';
$string['encryption_encryptfailed'] = 'La cifratura non è andata a buon fine';
$string['encryption_invalidkey'] = 'Chiave non valida';
$string['encryption_keyalreadyexists'] = 'Chiave già esistente';
$string['encryption_nokey'] = 'Chiave non trovata';
$string['encryption_wrongmethod'] = 'I dati non coincidono con un metodi di cifratura supportato';
$string['enddatebeforestartdate'] = 'La data di fine corso deve essere antecedente alla data di inizio.';
$string['error'] = 'Si è verificato un errore';
$string['error_question_answers_missing_in_db'] = 'Non è stato possibile trovare una risposta che corrisponda a "{$a->answer}" nel tabella question_answers. Il problema si è verificato durante il ripristino della domandi con id {$a->filequestionid} presente nel file di backup. Tale domanda è stata fatta corrispondere alla domanda già presente nel database con id {$a->dbquestionid}.';
$string['errorcleaningdirectory'] = 'Si è verificato un errore svuotando la cartella "{$a}"';
$string['errorcopyingfiles'] = 'Si è verificato un errore copiando i file';
$string['errorcreatingdirectory'] = 'Si è verificato un errore creando la cartella "{$a}"';
$string['errorcreatingfile'] = 'Si è verificato un errore creando il file "{$a}"';
$string['errorcreatingrole'] = 'Si è verificato un errore durante la creazione del ruolo';
$string['errorfetchingrssfeed'] = 'Si è verificato un errore durante la ricezione del feed RSS.';
$string['erroronline'] = 'Si è verificato un errore alla linea {$a}';
$string['erroroutput'] = 'Errore in uscita, il reindirizzamento automatico è stato disabilitato.';
$string['errorparsingxml'] = 'Errore durante il parsing dell\'XML {$a->errorstring} alla linea {$a->errorline}, carattere {$a->errorchar}';
$string['errorprocessingarchive'] = 'Si è verificato un errore durante l\'elaborazione del file archivio';
$string['errorreadingfile'] = 'Si è verificato un errore leggendo il file "{$a}"';
$string['errorsavingrequest'] = 'Si è verificato un errore durante il salvataggio della tua richiesta';
$string['errorsettinguserpref'] = 'Si è verificato un errore durante l\'impostazione delle preferenze utente';
$string['errorunzippingfiles'] = 'Si è verificato un errore scompattando i file';
$string['expiredkey'] = 'Chiave scaduta';
$string['externalauthpassworderror'] = 'Password non vuota per l\'autenticazione esterna';
$string['externalfilenolocation'] = 'Il file esterno non ha un percorso';
$string['failtoloadblocks'] = 'Nel database sono registrati uno o più blocchi, tuttavia nessuno si è caricato correttamente!';
$string['fieldrequired'] = '"{$a}" è un campo obbligatorio';
$string['fileexists'] = 'File esistente';
$string['filemismatch'] = 'Discordanza nel nome del file non-core. Il file "{$a->current}" dovrebbe essere {$a->file}';
$string['filenotfound'] = 'Spiacente, il file richiesto non può essere trovato';
$string['filenotreadable'] = 'Il file non è leggibile';
$string['filterdoesnothavelocalconfig'] = 'Il filtro {$a} non consente personalizzazioni locali.';
$string['filternotactive'] = 'Il filtro {$a} non è attivo';
$string['filternotenabled'] = 'Il filtro non è abilitato!';
$string['filternotinstalled'] = 'Il filtro {$a} non è installato';
$string['forumblockingtoomanyposts'] = 'Hai superato il limite di messaggi impostato per questo forum.';
$string['functionalityremoved'] = 'Stai tentando di accedere a funzionalità che sono state rimosse.';
$string['gdfeaturenotsupported'] = 'L\'estensione GD non è stata compilata con i metodi per {$a}';
$string['gdmimetypenotsupported'] = 'Tipo MIME non supportato.';
$string['generalexceptionmessage'] = 'Eccezione - {$a}';
$string['gradecantregrade'] = 'Si è verificato un errore durante il calcolo delle valutazioni: {$a}';
$string['gradepubdisable'] = 'La pubblicazione delle valutazioni è disabilitata';
$string['gradesneedregrading'] = 'Le valutazioni del corso devono essere ricalcolate';
$string['groupalready'] = 'L\'utente appartiene già al gruppo {$a}';
$string['groupexistforcourse'] = 'Il gruppo "{$a}" esiste già in questo corso';
$string['groupexistforcoursewithidnumber'] = '{$a->problemgroup}: Il gruppo "{$a->name}" con il codice identificativo "{$a->idnumber}" è già presente in questo corso.';
$string['grouphasidnumber'] = 'Il gruppo "{$a}" ha già un codice identificativo è potrebbe essere stato creato automaticamente da un sistema esterno. Non sei autorizzato a rimuoverlo.';
$string['groupinghasidnumber'] = 'Il raggruppamento "{$a}" ha già un codice identificativo è potrebbe essere stato creato automaticamente da un sistema esterno. Non sei autorizzato a rimuoverlo.';
$string['groupingnotaddederror'] = 'Il raggruppamento "{$a}" non è stato aggiunto';
$string['groupnotaddederror'] = 'Il gruppo "{$a}" non è stato aggiunto';
$string['groupnotaddedtogroupingerror'] = 'Il gruppo "{$a->groupname}"  non è stato aggiunto al raggruppamento "{$a->groupingname}"';
$string['groupunknown'] = 'Il gruppo {$a} non è associato al corso specificato';
$string['groupusernotmember'] = 'L\'utente non è un membro di questo gruppo.';
$string['guestcantaccessprofiles'] = 'Gli ospiti non possono visualizzare i profili degli utenti. Per proseguire è necessario autenticarsi.';
$string['guestnocomment'] = 'Gli ospiti non sono autorizzati ad inserire commenti!';
$string['guestnoeditprofile'] = 'Gli ospiti non possono modificare il loro profilo';
$string['guestnoeditprofileother'] = 'Il profilo dell\'utente ospite non può essere modificato';
$string['guestnorate'] = 'Gli ospiti non possono dare valutazioni';
$string['guestsarenotallowed'] = 'Gli ospiti non sono autorizzati a fare questo';
$string['hackdetected'] = 'È stato riscontrato un attacco hacker!';
$string['hashpoolproblem'] = 'Contenuto {$a} del pool file errato';
$string['headersent'] = 'Headers already sent';
$string['idnumbertaken'] = 'Il codice identificativo è già usato';
$string['idnumbertoolong'] = 'Il codice identificativo è troppo lungo';
$string['importformatnotimplement'] = 'Spiacente, l\'importazione con questo formato non è stata ancora implementata!';
$string['incorrectext'] = 'Il file ha una estensione errata';
$string['inplaceeditableerror'] = 'Si è verificato un errore durante la chiamata al gestore dall\'aggiornamento';
$string['installproblem'] = 'Di solito non è possibile proseguire a valle di errori verificatisi durante l\'installazione, per riprovare ad installare potrebbe essere necessario creare un nuovo database oppure utilizzare un prefisso diverso per le tabelle.';
$string['internalauthpassworderror'] = 'L\'autenticazione interna non ha la password o le regole password non sono valide.';
$string['invalidaccess'] = 'Questa pagina non è stata acceduta correttamente';
$string['invalidaccessparameter'] = 'Parametro di accesso non valido';
$string['invalidaction'] = 'Parametro di azione non valido';
$string['invalidactivityid'] = 'L\'ID dell\'attività non è valido';
$string['invalidadminsettingname'] = 'Impostazioni admin non valide ({$a})';
$string['invalidargorconf'] = 'Non sono stati forniti argomenti validi oppure la configurazione del server è errata';
$string['invalidarguments'] = 'Non sono stati forniti argomenti validi';
$string['invalidblockinstance'] = 'Istanza non valida del blocco: {$a}';
$string['invalidbulkenrolop'] = 'È stata richiesta un\'operazione in massa non valida.';
$string['invalidcategory'] = 'Categoria errata!';
$string['invalidcategoryid'] = 'L\'ID della categoria non è corretto';
$string['invalidcomment'] = 'Il commento è errato';
$string['invalidcommentarea'] = 'Area commento non è valida';
$string['invalidcommentid'] = 'L\'ID del commento non è valido';
$string['invalidcommentitemid'] = 'L\'ID del elemento commento non è valido';
$string['invalidcommentparam'] = 'I parametri commento non sono validi';
$string['invalidcomponent'] = 'Il nome componente non è valido';
$string['invalidconfirmdata'] = 'Dati di conferma non validi';
$string['invalidcontentid'] = 'L\'ID del contenuto non è valido';
$string['invalidcontext'] = 'Contesto non valido';
$string['invalidcountrycode'] = 'Codice nazione non valido: {$a}';
$string['invalidcourse'] = 'Corso non valido';
$string['invalidcourseformat'] = 'Formato di corso non valido';
$string['invalidcourseid'] = 'Stai tentando di usare un ID di corso non valido';
$string['invalidcourselevel'] = 'Livello di contesto errato';
$string['invalidcoursemodule'] = 'ID modulo del corso non valido';
$string['invalidcoursemoduleid'] = 'ID non valido del modulo del corso: {$a}';
$string['invalidcoursenameshort'] = 'Titolo abbreviato del corso non valido';
$string['invaliddata'] = 'I dati inseriti non sono validi';
$string['invaliddatarootpermissions'] = 'Sono state rilevati permessi non validi durante la creazione di una cartella. Per maggiori informazioni attivare la modalità debugging.';
$string['invaliddevicetype'] = 'Tipo di dispositivo non valido';
$string['invalidelementid'] = 'L\'ID dell\'elemento non è corretto';
$string['invalidentry'] = 'Questo inserimento non è valido!';
$string['invalidevent'] = 'Evento non valido';
$string['invalidfieldname'] = '"{$a}" non è nome di campo valido';
$string['invalidfile'] = 'Il file non è stato trovato';
$string['invalidfiletype'] = '"{$a}" non è un tipo di file valido';
$string['invalidformatpara'] = 'Formato errato per la scelta di un parametro';
$string['invalidformdata'] = 'I dati del modulo sono errati';
$string['invalidfunction'] = 'Funzione errata';
$string['invalidgradeitemid'] = 'L\'ID dell\'elemento di valutazione non è correatto';
$string['invalidgroupid'] = 'L\'ID del gruppo non è corretto';
$string['invalidipformat'] = 'Il formato dell\'indirizzo IP non è valido';
$string['invaliditemid'] = 'ID elemento errato';
$string['invalidkey'] = 'Chiave errata';
$string['invalidlanguagecode'] = 'Codice lingua non valido: {$a}';
$string['invalidlegacy'] = 'Definizione errata del ruolo origine di tipo:{$a}';
$string['invalidmd5'] = 'La variabile di controllo era errata - prova di nuovo';
$string['invalidmode'] = 'Modo non valido ({$a})';
$string['invalidmodule'] = 'Modulo non valido';
$string['invalidmoduleid'] = 'ID modulo non valido: {$a}';
$string['invalidmodulename'] = 'Nome modulo non valido: {$a}';
$string['invalidnum'] = 'Valore numerico non valido';
$string['invalidnumkey'] = 'L\'array $conditions non può contenere chiavi numeriche, per favore correggere il codice.';
$string['invalidoutcome'] = 'ID obiettivo errato';
$string['invalidpagesize'] = 'Dimensione pagina non valida';
$string['invalidpasswordpolicy'] = 'Le regole password non sono valide';
$string['invalidpaymentmethod'] = 'Metodo di pagamento non valido: {$a}';
$string['invalidpersistenterror'] = 'Errore: {$a}';
$string['invalidqueryparam'] = 'ERRORE: numero errato di parametri della query. Parametri attesi {$a->expected}, parametri ricevuti {$a->actual}.';
$string['invalidratingarea'] = 'Area di valutazione non valida';
$string['invalidrecord'] = 'Non è possibile trovare il record nella tabella {$a}.';
$string['invalidrecordunknown'] = 'Non è possibile trovare il record nel database.';
$string['invalidrequest'] = 'Richiesta non valida';
$string['invalidrole'] = 'Ruolo non valido';
$string['invalidroleid'] = 'ID Ruolo non valido';
$string['invalidscaleid'] = 'L\'ID della scala non è valido';
$string['invalidsection'] = 'Il record del modulo del corso contiene una sezione non valida';
$string['invalidsesskey'] = 'La sessione è molto probabilmente scaduta. Controllare se hai effettuato l\'accesso o torna alla schermata precedente e ricarica la pagina.';
$string['invalidshortname'] = 'Il titolo abbreviato del corso non è valido';
$string['invalidsourcefield'] = 'Il campo del file bozza sorgente non è valido';
$string['invalidstatedetected'] = 'Qualcosa non è andato a buon fine: {$a}. Di norma questo non dovrebbe mai verificarsi.';
$string['invalidurl'] = 'L\'URL non è valido';
$string['invaliduser'] = 'Utente non valido';
$string['invaliduserdata'] = 'Dati utenti non validi: {$a}';
$string['invaliduserfield'] = 'Campo utente non valido: : {$a}';
$string['invaliduserid'] = 'L\'ID dell\'utente non è valido';
$string['invalidusername'] = 'Lo username fornito contiene caratteri non validi';
$string['invalidusernameblank'] = 'Lo username non può essere vuoto';
$string['invalidxmlfile'] = '"{$a}" non è file XML valido';
$string['iplookupfailed'] = 'Non è possibile trovare le informazioni geografiche sull\'indirzzo IP {$a}';
$string['iplookupprivate'] = 'Non è possibile effettuare il lookup di indirizzi IP privati';
$string['ipmismatch'] = 'Discordanza nell\'indirzzo IP del client';
$string['itemnotfound'] = 'Non è stato trovato alcun {$a->itemtype} con un identificatore \'{$a->identifier}\'';
$string['listcantmovedown'] = 'Non è stato possibile spostare in basso questo elemento in quanto è già l\'ultimo dei suoi pari';
$string['listcantmoveleft'] = 'Non è stato possibile spostare a sinistra questo elemento in quanto non ha elementi genitore';
$string['listcantmoveright'] = 'Non è stato possibile spostare a destra questo elemento in quanto non ci sono elementi pari da trasformare in genitore. Spostate l\'elemento al di sotto di un elemento pari e poi spostatelo a destra.';
$string['listcantmoveup'] = 'Non è stato possibile spostare in su questo elemento in quanto è già il primo dei suoi pari.';
$string['listnochildren'] = 'Non sono stati trovati elementi figli';
$string['listnoitem'] = 'Elemento non trovato';
$string['listnopeers'] = 'Non sono stati trovati elementi di pari livello';
$string['listupdatefail'] = 'Durante la modifica della gerarchia dell\'elenco l\'operazione nel DB non è andata a buon fine.';
$string['logfilenotavailable'] = 'I log non sono disponibili';
$string['loginasnoenrol'] = 'Non si può usare \'iscrivi\' o \'disiscrivi\' se si è in una sessione \'Login come\'.';
$string['loginasonecourse'] = 'Non puoi entrare in questo corso. Devi prima terminare la sessione \'Login come\' prima di entrare in altri corsi.';
$string['maxareabytes'] = 'La dimensione del file eccede lo spazio rimasto disponibile in quest\'area.';
$string['maxbytesfile'] = 'Il file {$a->file} è troppo grande. La dimensione massima che è possibile caricare è pari a {$a->size}.';
$string['maxdraftitemids'] = 'I tuoi caricamenti di file sono stati temporaneamente limitati a causa del caricamento di un volume elevato di file. Attendi prima di riprovare.';
$string['messageundeliveredbynotificationsettings'] = 'Non è stato possibile inviare il messaggi poiché i messaggi personali tra utenti sono stati disabilitati dall\'amministratore dle sito';
$string['messagingdisable'] = 'La messaggistica è disabilitata';
$string['mimetexisnotexist'] = 'Il sistema non è configurato per eseguire mimeTEX. È necessario scaricare il sorgente C da <a href="https://www.forkosh.com/mimetex.zip">https://www.forkosh.com/mimetex.zip</a>, compilarlo e copiare l\'eseguibile nella cartella  moodle/filter/tex/.';
$string['mimetexnotexecutable'] = 'Il mimetex personalizzato non è eseguibile!';
$string['missing_moodle_backup_xml_file'] = 'Al backup manca il file XML: {$a}';
$string['missingcategoryrole'] = 'Non è stato possibile assegnare il ruolo all\'utente: non esiste il ruolo nella categoria.';
$string['missingfield'] = 'Manca il campo "{$a}"';
$string['missingkeyinsql'] = 'ERROR: nella query manca il parametro "{$a}"';
$string['missingparam'] = 'Un parametro obbligatorio ({$a}) è mancante';
$string['missingparameter'] = 'Parametro mancante';
$string['missingrequiredfield'] = 'Mancano alcuni campi richiesti';
$string['missinguseranditemid'] = 'Manca userid e itemid';
$string['missingvarname'] = 'Manca il nome di una variabile obbligatoria!';
$string['mixedtypesqlparam'] = 'ERRORE: parametri della query di tipo promiscuo';
$string['mnetdisable'] = 'MNET è disabilitato';
$string['mnetlocal'] = 'Gli utenti remoti MNET non possono autenticarsi localmente';
$string['moduledisable'] = 'Questo modulo ({$a}) è stato disabilitato per questo corso';
$string['moduledoesnotexist'] = 'Questo modulo non esiste';
$string['moduleinstancedoesnotexist'] = 'L\'istanza di questo modulo non esiste';
$string['modulemissingcode'] = 'Nel modulo {$a} manca il codice necessario per eseguire questa funzione';
$string['moodlenet:invalidshareformat'] = 'Formato di condivisone MoodeNet non corretto';
$string['moodlenet:invalidsharestatus'] = 'Stato di condivisone MoodeNet non corretto';
$string['moodlenet:invalidsharetype'] = 'Tipo di condivisone MoodeNet non valido';
$string['moodlenet:usernotconfigured'] = 'Non sei autorizzato a condividere contenuti su MoodleNet o il tuo account non è configurato correttamente.';
$string['movecatcontentstoroot'] = 'Non è consentito spostare il contenuto di una categoria al livello radice. Devi spostarlo in una categoria già esistente.';
$string['movecatcontentstoselected'] = 'Non è possibile spostare alcuni contenuto della categoria all\'interno della categoria selezionata.';
$string['movecategorynotpossible'] = 'Non è possibile spostare la categoria \'{$a}\' nella categoria selezionata.';
$string['movecategoryownparent'] = 'Non è possibile rendere la categoria \'{$a}\' genitore di se stessa.';
$string['movecategoryparentconflict'] = 'Non è possibile rendere la categoria \'{$a}\' sottocategoria di se stessa.';
$string['mssqlrcsmodemissing'] = 'Il database non utilizza la modalità READ_COMMITTED_SNAPSHOT, cosa che può portare a risultati errati specialmente in presenza di elevato utilizzo simultaneo. Per favore abilita la modalità. Per maggiori informazioni: <a href="https://docs.moodle.org/en/Installing_MSSQL_for_PHP#Configuration">Installing MSSQL for PHP</a>.';
$string['multiplerecordsfound'] = 'Sono stati trovati molti record: se ne sarebbe dovuto trovare uno solo.';
$string['multiplerestorenotallow'] = 'Non sono consentiti processi di ripristino multipli!';
$string['mustbeloggedin'] = 'Devi essere autenticato per fare questo';
$string['mustbeteacher'] = 'Bisogna essere docenti per visualizzare questa pagina';
$string['myisamproblem'] = 'Le tabelle del database usano il motore MyISAM, si raccomanda di utilizzare un motore ACID compliant, come InnoDB.';
$string['needcopy'] = 'Prima devi copiare qualcosa!';
$string['needcoursecategroyid'] = 'È necessario specificare la id del corso o la categoria';
$string['needphpext'] = 'Devi aggiungere il supporto {$a} alla tua installazione PHP';
$string['noadmins'] = 'Non ci sono amministratori!';
$string['noblocks'] = 'Non sono stati trovati blocchi!';
$string['nocapabilitytousethisservice'] = 'L\'utente non possiede il privilegio necessario per utilizzare questo servizio';
$string['nocategorydelete'] = 'Non è possibile eliminare la categoria \'{$a}\'';
$string['nocontext'] = 'Spiacente, ma quel corso non è un contesto valido';
$string['nodata'] = 'Non ci sono dati';
$string['noexistingcategory'] = 'Categoria non esistente';
$string['nofile'] = 'File non specificato';
$string['nofiltersenabled'] = 'Non ci sono filtri abilitati.';
$string['nofolder'] = 'La cartella richiesta non esiste';
$string['noformdesc'] = 'Per questa attività nella formslib non sono state trovate definizioni del form';
$string['noguest'] = 'Non ci sono ospiti qui!';
$string['noinstances'] = 'Non ci sono istanze di {$a} in questo corso.';
$string['nologinas'] = 'Non sei autorizzato ad autenticarti come quell\'utente';
$string['nonmeaningfulcontent'] = 'Contenuto senza significato';
$string['noparticipants'] = 'In questo corso non sono stati trovati partecipanti';
$string['noparticipatorycms'] = 'Spiacente, ma il report di partecipazione dei moduli del corso non è attivato.';
$string['nopermissions'] = 'Non sei autorizzato a svolgere questa azione ({$a})';
$string['nopermissiontoaccesspage'] = 'Non sei autorizzato a visualizzare questa pagina.';
$string['nopermissiontocomment'] = 'Non puoi aggiungere commenti';
$string['nopermissiontodelentry'] = 'Non puoi eliminare questo commento.';
$string['nopermissiontoeditcomment'] = 'Non puoi eliminare i commenti di altre persone!';
$string['nopermissiontohide'] = 'Non ci sono autorizzazioni da nascondere!';
$string['nopermissiontoimportact'] = 'Non avete i privilegi necessari per importare attività in questo corso';
$string['nopermissiontolock'] = 'Non sei autorizzato a bloccare!';
$string['nopermissiontomanagegroup'] = 'Non avete i privilegi necessari per gestire i gruppi';
$string['nopermissiontorate'] = 'La valutazione degli elementi non è consentita!';
$string['nopermissiontoshow'] = 'Non sei autorizzato a visualizzare questo!';
$string['nopermissiontounlock'] = 'Non sei autorizzato a sbloccare!';
$string['nopermissiontoupdatecalendar'] = 'Non sei autorizzato ad aggiornare gli eventi nel calendario';
$string['nopermissiontoviewcalendar'] = 'Siamo spaicenti, non sei autorizzato a visualizzare l\'evento di calendario.';
$string['nopermissiontoviewgrades'] = 'Non sei autorizzato a visualizzare i voti.';
$string['nopermissiontoviewletergrade'] = 'Mancano i privilegi per visualizzare la graduatoria letterale';
$string['nopermissiontoviewpage'] = 'Non sei autorizzato a visualizzare questa pagina';
$string['nosite'] = 'Non è stato possibile trovare un corso di livello top';
$string['nositeid'] = 'ID del sito mancante';
$string['nostartdatenoenddate'] = 'È possibile impostare una data di fine corso solo in presenza di una data di inizio corso.';
$string['nostatstodisplay'] = 'Spiacente, non ci sono dati da visualizzare';
$string['notallowedtoupdateprefremotely'] = 'Non sei autorizzato ad aggiornare remotamente queste preferenze dell\'utente';
$string['notavailable'] = 'Non è attualmente disponibile';
$string['notfound'] = 'Non trovato';
$string['notlocalisederrormessage'] = '{$a}';
$string['notmemberofgroup'] = 'Non sei un membro di questo gruppo del corso';
$string['notownerofkey'] = 'Non sei il proprietario di questa chiave';
$string['nousers'] = 'L\'utente non esiste!';
$string['oauth1accesstoken'] = 'Errore OAuth 1.0: non è stato possibile ottenere il token di accesso';
$string['oauth1requesttoken'] = 'Errore OAuth 1.0: non è stato possibile ottenere il token di accesso - il service provider può essere down';
$string['oauth2refreshtokenerror'] = 'Non è stato possibile aggiornare il token OAuth2. Di seguito lo stato HTTP dell’endpoint remoto: {$a}';
$string['oauth2refreshtokentaskerror'] = 'Impossibile aggiornare il token OAuth 2 per uno o più emittenti. Visualizza l\'output dell\'attività per i dettagli.';
$string['oauth2upgradetokenerror'] = 'Non è stato possibile eseguire l\'upgrade del token OAuth2. Di seguito lo stato HTTP dell’endpoint remoto: {$a}';
$string['onlyadmins'] = 'Solo gli amministratori possono farlo.';
$string['onlyeditingteachers'] = 'Solo i docenti con diritti di modifica possono farlo.';
$string['onlyeditown'] = 'È possibile modificare solo le proprie informazioni';
$string['opensslsealerror'] = 'OpenSSL non è in grado di sigillare i dati';
$string['opensslsignerror'] = 'OpenSSL non è in grado di firmare i dati';
$string['orderidnotfound'] = 'L\'ordine ID {$a} non è stato trovato';
$string['pagenotexist'] = '<p>Si è verificato un errore inatteso durante la visualizzazione di una pagina non esistente.</p>{$a}';
$string['pagenotexisttitle'] = 'Errore 404: File non trovato';
$string['passwordexceeded'] = 'La password non può essere più lunga di {$a} caratteri.';
$string['pathdoesnotstartslash'] = 'Non sono stati forniti argomenti validi, i percorsi non iniziano con lo slash!';
$string['pleasereport'] = 'Se hai tempo, ti preghiamo di farci sapere cosa stavi cercando di fare quando l\'errore si è verificato:';
$string['pluginnotexist'] = 'Il plugin {$a} non esiste';
$string['pluginrequirementsnotmet'] = 'Non è possibile installare Il plugin "{$a->pluginname}" ({$a->pluginversion}). È necessaria una versione più recente di Moodle (versione in uso:  {$a->currentmoodle}, versione richiesta: {$a->requiremoodle}).';
$string['pluginunsupported'] = 'Il plugin "{$a->pluginname}" {$a->pluginversion} non supporta la versione di Moodle installata, {$a->moodleversion}. Per favore verificare la disponibilità di versioni supportate.';
$string['prefixcannotbeempty'] = '<p>Errore: il prefisso del database non può essere vuoto. ({$a})</p>
<p>L\'amministratore del sito deve risolvere questo problema.</p>';
$string['prefixtoolong'] = '<p>Errore: il prefisso delle tabelle del database è troppo lungo ({$a->dbfamily})</p>
<p>L\'amministratore del sito deve risolvere questo problema. La lunghezza massima del prefisso delle tabelle per {$a->dbfamily} è {$a->maxlength} caratteri.</p>';
$string['privatefilesupload'] = 'Il caricamento di file nei File privati dell\'utente non è più supportato. Caricare prima i file nella area draft e poi spostarli con core_user::add_user_private_files.';
$string['processingstops'] = 'L\'elaborazione si è fermata qui. Rimangono dei record ignorati.';
$string['protected_cc_not_supported'] = 'I cartridge protetti non sono supportati.';
$string['querystringcannotbeempty'] = 'Il query string non può essere vuoto.';
$string['redirecterrordetected'] = 'È stato individuato un redirect non supportato, l\'elaborazione dello script è stata interrotta';
$string['redissessionhandlerproblem'] = 'La configurazione delle sessioni Redis. Si prega di avvisare l\'amministratore del server.';
$string['refoundto'] = 'Può essere restituito a {$a}';
$string['refoundtoorigi'] = 'Ammontare pagato restituito a {$a}';
$string['registrationdisabled'] = 'La creazione di account non è abilitata';
$string['remotedownloaderror'] = '<p>Lo scaricamento delle componenti non è andato a buon fine. Verificare le impostazioni del proxy. L\'estensione PHP cURL è fortemente consigliata.</p>
<p>Devi scaricare manualmente il file <a href="{$a->url}">{$a->url}</a>, copiarlo in "{$a->dest}" e decomprimerlo.</p>';
$string['remotedownloadnotallowed'] = 'Non è permesso scaricare i componenti sul  server (allow_url_fopen è disabilitato). <br /><br /> È necessario scaricare manualmente il file <a href="{$a->url}">{$a->url}</a>, copiarlo in "{$a->dest}" sul server e scompattarlo.';
$string['reportnotavailable'] = 'Questo tipo di report è disponibile solamente nel corso home del sito';
$string['requirecorrectaccess'] = 'URL o porta non valido';
$string['requireloginerror'] = 'L\'accesso al corso o attività non è consentito.';
$string['restore_path_element_missingmethod'] = 'Il metodo di ripristino {$a} non è presente. Deve essere definito da uno sviluppatore.';
$string['restore_path_element_noobject'] = 'L\'oggetto del ripristino {$a} non è un oggetto.';
$string['restorechecksumfailed'] = 'Si sono verificati alcuni problemi con le informazioni di ripristino presenti nella tua sessione. Per favore controllare i limiti della memoria PHP e della dimensione del pacchetto. Il ripristino è stato interrotto.';
$string['restrictedcontextexception'] = 'Spiacente, l\'esecuzione di funzioni esterne viola le restrizioni del contesto.';
$string['restricteduser'] = 'Spiacente, ma il tuoi account  "{$a}" non è autorizzato a fare questo';
$string['reverseproxyabused'] = 'I server non può essere raggiunto direttamente poiché è stato abilitato un reverse proxy.<br />Per favore contattate l\'amministratore del server.';
$string['rpcerror'] = 'Ooops! La comunicazione MNET è fallita! Di seguito il messaggio di errore da fornire all\'amministratore: {$a}';
$string['scheduledbackupsdisabled'] = 'I backup periodici sono stati disabilitati dall\'amministratore del server.';
$string['secretalreadyused'] = 'Il link di conferma cambio password è già stato utilizzato, la password non è stata cambiata';
$string['sectioncantbefound'] = '<p>strong>Non è possibile trovare il contenuto</b></p><p>Può essere stato eliminato o l\'URL può essere errata.</strong>';
$string['sectionnotexist'] = 'Questa sezione non esiste';
$string['sendmessage'] = 'Invia messaggio';
$string['sendmessagesent'] = 'Grazie per il feedback su: <br>{$a}';
$string['serverconnection'] = 'Si è verificato un errore durante la connessione al server';
$string['servicedonotexist'] = 'Il servizio non esiste';
$string['sessioncannotobtainlock'] = '<p>Non è stato possibile ottenere il lock della sessione id {$a->id} entro {$a->acquiretimeout}.</p>
<p>È probabile che un\'altra pagina ({$a->whohaslock}) sia ancora in esecuzione in un\'altra scheda del browser o che non abbia rilasciato il lock a causa di un errore.</p>
<p>È possibile attendere fino al timeout del lock della sessione ({$a->lockexpire}) oppure è possibile riavviare la sessione del browser. Se l\'errore persiste, avvisare l\'amministratore del server.</p>';
$string['sessioncookiesdisable'] = 'È stato rilevato un uso errato di require_key_login() - i cookie di sessione devono essere disabilitati!';
$string['sessiondiskfull'] = 'La partizione contenente le sessioni è piena. Al momento non è possibile autenticarsi. Per favore avvertire l\'amministratore del server.';
$string['sessionerroruser'] = 'La sessione è scaduta. Si prega di autenticarsi nuovamente.';
$string['sessionerroruser2'] = 'È stato rilevato un errore sul server che ha compromesso la sessione di autenticazione. Autenticati nuovamente o fai ripartire il browser.';
$string['sessionexpired'] = 'La sessione è scaduta';
$string['sessionhandlerproblem'] = 'Il session handler non è configurato correttamente';
$string['sessionipnomatch'] = 'Spiacente, ma il tuo IP sembra essere cambiato da quando ti sei autenticao. Questa caratteristica previene il furto della vostra identità  da parte di hacker mentre sei collegato a questo sito. Gli utenti non dovrebbero vedere questo messaggio - chiedi aiuto all\'amministratore del sito.';
$string['sessionipnomatch2'] = '<p>Spiacente ma il tuo indirizzo IP è cambiato da quando ti sei autenticato. Questa misura di sicurezza evita che cracker possano rubare la tua identità mentre sei collegato al sito. L\'errore potrebbe comparire se stai usando reti wireless oppure se stai muovendovi su reti diverse. Per ricevere aiuto, contatta il tuo amministratore.</p>
<p>Se desideri continuare, premi il pulsante F5 per ricaricare questa pagina.</p>';
$string['sessionstarterror'] = 'Non è stato possibile avviare la sessione. Riprovare più tardi.';
$string['sessionwaiterr'] = 'Si è verificato un timeout durante l\'attesa del session lock.<br />Attendi sino al termine della richiesta e riprova.';
$string['shortnametaken'] = 'Il titolo abbreviato è già stato usato per un altro corso ({$a})';
$string['sitepolicynotagreed'] = 'Le politiche del sito non sono state accettate: <a href="{$a}">Fai click qui per consultarle.</a>';
$string['socksnotsupported'] = 'I proxy SOCKS5 non sono supportati nel PHP4';
$string['spellcheckernotconf'] = 'Lo spell checker non è configurato';
$string['sslonlyaccess'] = 'Spiacente, per motivi di sicurezza sono ammesse solo connessioni https.';
$string['statscatchupmode'] = 'Le statistiche sono attualmente in modalità  raccolta dati. Sono già  stati elaborati {$a->daysdone} giorno(i) e {$a->dayspending} lo devono ancora essere. Ricontrollate presto!';
$string['statsdisable'] = 'Le statistiche non sono abilitate';
$string['statsnodata'] = 'Non ci sono dati disponibili per quella combinazione di corso e periodo di tempo';
$string['storedfilecannotcreatefile'] = 'Non è possibile creare il pool locale dei file. Verificare i permessi della dataroot e lo spazio disponibile sul disco.';
$string['storedfilecannotcreatefiledirs'] = 'Non è possibile creare le cartelle per il pool dei file locali, verificare i permessi della dataroot.';
$string['storedfilecannotread'] = 'Non è possibile leggere il file, il file potrebbe non esistere oppure potrebbero esserci problemi nei permessi';
$string['storedfilecannotreadfile'] = 'Non è possibile leggere il file \'{$a}\'. Il file non esiste o è presente un problema sui permessi.';
$string['storedfilenotcreated'] = 'Non è possibile creare il file {$a->contextid}/{$a->component}/{$a->filearea}/{$a->itemid}{$a->filepath}{$a->filename}';
$string['storedfileproblem'] = 'Si è verificata un exception sconosciuta riferita i file locali ({$a})';
$string['tagdisabled'] = 'I tag non sono abilitati!';
$string['tagnotfound'] = 'Il tag specificato non è stato trovato nel database';
$string['targetdatabasenotempty'] = 'Il database destinazione non è vuoto. Per sicurezza il trasferimento è stato interrotto.';
$string['textconditionsnotallowed'] = 'Il confronto di condizioni sulle colonne di testo non è consentito. Per favore utilizza sql_compare_text() nella query.';
$string['themenotinstall'] = 'Questo tema non è installato!';
$string['tokengenerationfailed'] = 'Non è possibile generare un nuovo token.';
$string['transactionvoid'] = 'La transazione non può essere annullata in quanto è già stata annullata';
$string['unenrolerror'] = 'Si è verificato un errore durante la disiscrizione dei quella persona';
$string['unicodeupgradeerror'] = 'Spiacente, ma la il tuo database non è ancora in  Unicode, e questa versione di Moodle non è in grado di migrarlo in Unicode. Si prega di aggiornare a Moodle 1.7.x prima ed effettuare la migrazione a Unicode dalla pagina di Amministrazione. Fatto questo ti sarà possibile migrare a Moodle {$a}';
$string['unknowaction'] = 'Azione sconosciuta!';
$string['unknowcategory'] = 'Categoria sconosciuta!';
$string['unknowcontext'] = 'Questo è un contesto sconosciuto ({$a}) in get_child_contexts!';
$string['unknowformat'] = 'Formato sconosciuto ({$a})';
$string['unknownbackupexporterror'] = 'Si è verificato un errore sconosciuto durante la preparazione delle informazioni da importare';
$string['unknownblockregion'] = 'In questa pagina l\'area blocchi \'{$a}\' non è stata individuata.';
$string['unknowncategory'] = 'La categoria con ID "{$a}" è sconosciuta';
$string['unknowncontext'] = 'Questo contesto è sconosciuto.';
$string['unknowncourse'] = 'Il corso di nome "{$a}" è sconosciuto';
$string['unknowncourseidnumber'] = 'L\'ID del corso "{$a}" è sconosciuta';
$string['unknowncourserequest'] = 'Richiesta di corso sconosciuta';
$string['unknowncoursesection'] = 'Nel corso "{$a}" è presente una sezione sconosciuta';
$string['unknownevent'] = 'Evento sconosciuto';
$string['unknownfiletype'] = 'Errore - Filtro sconosciuto';
$string['unknowngroup'] = 'Il gruppo "{$a}" è sconosciuto';
$string['unknownhelp'] = 'La sezione di help {$a} è sconosciuta';
$string['unknownjsinrequirejs'] = 'Non è stato possibile trovare la libreria JavaScript {$a}.';
$string['unknownmodulename'] = 'Per il form il nome del modulo è sconosciuto';
$string['unknownrole'] = 'Il ruolo "{$a}" è sconosciuto';
$string['unknownsortcolumn'] = 'La colonna {$a} per l\'ordinamento è sconosciuta';
$string['unknownuseraction'] = 'Purtroppo non si riesce a comprendere l\'azione dell\'utente';
$string['unknownuserselector'] = 'Selettore utenti sconosciuto';
$string['unknoworder'] = 'Ordinamento sconosciuto';
$string['unknowparamtype'] = 'Parametro di tipo sconosciuto: {$a}';
$string['unknowquestiontype'] = 'Tipo di domanda non supportato: {$a}';
$string['unknowuploadaction'] = 'Errore: azione di caricamento sconosciuta ({$a})';
$string['unspecifycourseid'] = 'È necessario specificare l\'id del corso, il titolo abbreviato oppure il codice identificativo';
$string['unsupportedevent'] = 'Tipo di evento non supportato';
$string['unsupportedstate'] = 'Stato di completamento non supportato';
$string['unsupportedwebserver'] = 'Purtroppo il software del web server ({$a}) non è supportato.';
$string['upgraderequires19'] = 'Errore: sul server è stata installata una nuova versione di Moodle, purtroppo l\'upgrade da questa versione precedente non è supportato.<br />Per eseguire l\'upgrade, si deve prima aggiornare l\'installazione alla release 1.9 più recente. Se lo si desidera è possibile ritornare alla versione di Moodle originaria semplicemente ricopiando i file della versione precedentemente in uso.';
$string['upgraderunning'] = 'Il sito è in fase di aggiornamento, per favore provate ad accedere più tardi';
$string['urlnotdefinerss'] = 'URL non definita per il feed RSS';
$string['useradmineditadmin'] = 'Solo gli amministratori possono modificare gli altri account da amministratore.';
$string['useradminodelete'] = 'Gli account di amministratore non possono essere eliminati.';
$string['userautherror'] = 'Plugin d autenticazione sconosciuta';
$string['userauthunsupported'] = 'Plugin di autenticazione non supportato';
$string['useremailduplicate'] = 'Indirizzo duplicato';
$string['userisfilteredout'] = 'Questo utente non corrisponde ai filtri e alle preferenze della tabella.';
$string['usermustbemnet'] = 'Gli utenti presenti nella access control list MNET devono essere utenti remoti MNET';
$string['usernamelowercase'] = 'Lo username deve contener solamente caratteri minuscoli';
$string['usernotaddederror'] = 'Errore - L\'utente "{$a}" non è stato aggiunto';
$string['usernotaddedregistered'] = 'L\'utente non è stato aggiunto - utente già  registrato';
$string['usernotaddedusernameexists'] = 'Utente non aggiunto: il nome utente esiste già con un indirizzo email diverso';
$string['usernotavailable'] = 'Non puoi visualizzare i dettagli di questo utente.';
$string['usernotdeletedadmin'] = 'L\'utente non è stato eliminato - non è possibile eliminare l\'account amministrativi.';
$string['usernotdeleteddeleted'] = 'L\'utente è già stato eliminato.';
$string['usernotdeletederror'] = 'Errore - L\'utente non è stato eliminato';
$string['usernotdeletedmissing'] = 'Errore - L\'utente non è stato eliminato, non è stato possibile trovare lo username';
$string['usernotdeletedoff'] = 'L\'utente non è stato eliminato. L\'eliminazione non è consentita';
$string['usernotfullysetup'] = 'Utente non completamente impostato';
$string['usernotincourse'] = 'Questo utente non si è presente in questo corso!';
$string['usernotrenamedadmin'] = 'Non è possibile rinominare gli account amministratore';
$string['usernotrenamedexists'] = 'Utente non rinominato - il nuovo username è già utilizzato.';
$string['usernotrenamedmissing'] = 'Utente non rinominato - non è possibile trovare il vecchio username.';
$string['usernotrenamedoff'] = 'Nome utente non rinominato- non è permesso rinominare.';
$string['usernotupdatedadmin'] = 'Non è possibile aggiornare gli account amministratore';
$string['usernotupdatederror'] = 'Utente non aggiornato - errore.';
$string['usernotupdatednotexists'] = 'Utente non aggiornato o non esistente.';
$string['userquotalimit'] = 'Hai raggiunto il limite della tua quota di file';
$string['userselectortoomany'] = 'user_selector ha ottenuto più di un utente, anche se multiselect è false';
$string['verifyagedigitalconsentnotpossible'] = 'Al momento la verifica dell’età del consenso digitale non è possibile.';
$string['wrongcall'] = 'Questo script è stato chiamato in modo errato';
$string['wrongcontextid'] = 'l\'ID del contesto è errato (non è possibile trovarla)';
$string['wrongdestpath'] = 'Percorso di destinazione errato';
$string['wrongroleid'] = 'ID del ruolo errata!';
$string['wrongsourcebase'] = 'Indirizzo (URL) sorgente errato.';
$string['wrongusernamepassword'] = 'Utente/password errati';
$string['wrongzipfilename'] = 'Il nome del file ZIP è errato.';
$string['wscouldnotcreateecoursenopermission'] = 'WS - Non è stato possibile creare il corso - Mancanza di autorizzazioni';
$string['wwwrootmismatch'] = 'È stato individuato un accesso errato, questo server può essere raggiunto solo da "{$a}".<br /><br />Per favore avvertite l\'amministratore del server.';
$string['wwwrootslash'] = 'È stato individuata una $CFG->wwwroot errata nel file config.php. Non devono essere presenti slash alla fine.<br /><br />Per favore avvertite l\'amministratore del server.';
$string['xmldberror'] = 'Errore XMLDB!';
$string['youcannotdeletecategory'] = 'Non puoi eliminare la categoria \'{$a}" poiché non puoi cancellarne i contenuti né spostarli altrove.';
