<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'interactivevideo', language 'es_mx', version '4.5'.
 *
 * @package     interactivevideo
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activitycard'] = 'Tarjeta de actividad';
$string['add'] = 'Añadir';
$string['addinteractiontitle'] = 'Añadir  {$a->name} en {$a->time}';
$string['additionalsettings'] = 'Configuraciones adicionales';
$string['advanced'] = 'Avanzadas';
$string['aftercompletion'] = 'Después de la finalización';
$string['alignindicatorcenter'] = 'Alinear los indicadores de interacción al centro';
$string['allowcustomtheme'] = 'Permitir tema personalizado';
$string['allowcustomtheme_desc'] = 'Marque esta opción para permitir que los usuarios seleccionen un tema personalizado para la instancia de video interactivo.';
$string['annotationcontent'] = 'Contenido de la anotación';
$string['annotationscopied'] = 'Anotaciones copiadas al portapapeles';
$string['annotationsimported'] = 'Anotaciones importadas exitosamente';
$string['annotationssavedasdefaults'] = 'Los valores predeterminados se han actualizado correctamente.';
$string['appearanceandbehaviorsettings'] = 'Configuraciones de apariencia y comportamiento';
$string['appearancesettings'] = 'Configuraciones de apariencia';
$string['areyousureyouwanttoresetthecompletiondata'] = '¿Está seguro de que desea restablecer el progreso de este usuario? Esta acción eliminará todos los intentos actuales y los archivos asociados.';
$string['atleastonecompletionrule'] = 'At least one completion rule must be set.';
$string['audio'] = 'Audio';
$string['audiovideooptions'] = 'Opciones de audio/video';
$string['auth_tool'] = 'Token/clave API para {$a}';
$string['auth_tool_desc'] = 'Ingrese el token/clave API para {$a}.';
$string['auto'] = 'Auto';
$string['autohidecontrols'] = 'Controles de ocultación automática';
$string['autoplay'] = 'Autoreproducir';
$string['autoplay_help'] = 'Esto no funcionará si el navegador no admite o bloquea la reproducción automática.';
$string['autoplayblocked'] = 'Su navegador o sus extensiones bloquean la reproducción automática. Es posible que experimente algunas dificultades. Habilite la reproducción automática en este sitio para disfrutar de una experiencia sin inconvenientes.';
$string['avg'] = 'Prom.';
$string['awardpartialpoints'] = 'Otorgar puntos parciales';
$string['backtocourse'] = 'Regresar a página del curso';
$string['beforecompletion'] = 'Antes de la finalización';
$string['behavioraftercompletion'] = 'Comportamiento: después de la finalización';
$string['behaviorbeforecompletion'] = 'Comportamiento: antes/sin finalización';
$string['behaviorsettings'] = 'Configuraciones del comportamiento';
$string['braveautoplay'] = 'La actividad de video interactivo no es compatible con el navegador Brave con la reproducción automática deshabilitada. Habilite la reproducción automática en la configuración del navegador para este sitio o utilice un navegador diferente.';
$string['bulkedit'] = 'Edición masiva';
$string['bunnystream'] = 'Bunny Stream';
$string['byauthor'] = 'por {$a}';
$string['cachedef_interactivevideo_settings'] = 'Cache definitions for Interactive Video';
$string['cachedef_iv_items_by_cmid'] = 'Definiciones de caché para elementos de video interactivo por ID de módulo del curso';
$string['cancel'] = 'Cancelar';
$string['canvas'] = 'Lienzo';
$string['captions'] = 'Subtítulos';
$string['cardsize'] = 'Tamaño de tarjeta';
$string['cardsize_desc'] = 'Seleccionar el tamaño predeterminado de tarjeta para la instancia de video interactivo en la página del curso,';
$string['centeroncoursepage'] = 'Centrar en la página del curso';
$string['changeplaybackspeed'] = 'Velocidad de reproducción';
$string['changevideoquality'] = 'Cambiar calidad del video';
$string['chapterlist'] = 'Lista de capítulos';
$string['chaptermetadata'] = 'Metadatos del capítulo';
$string['chapters'] = 'Capítulos';
$string['chaptertitle'] = 'Título del capítulo';
$string['chaptertoggle'] = 'Alternar capítulo';
$string['checkall'] = 'Comproba todo';
$string['clickability'] = 'Se le puede dar clic';
$string['clickability_desc'] = 'Si está marcada, se puede hacer clic en el indicador de interacción para ver el contenido de la interacción.';
$string['clickaddtoaddinteraction'] = 'Haga clic en "Agregar" para agregar una interacción';
$string['clone'] = 'Clonar';
$string['close'] = 'Cerrar';
$string['closechapterpanel'] = 'Cerrar panel de capítulos';
$string['completed'] = 'Completado';
$string['completedeletedforthisitem'] = 'Datos de finalización eliminados para <b>{$a->item}</b> para <b>{$a->user}</b>';
$string['completionandgrade'] = 'Finalización y calificación';
$string['completioncompleted'] = 'Completado';
$string['completiondetail:nonexistent'] = 'Condición desconocida: {$a}';
$string['completiondetail:percentage'] = 'Completar trabajos al menos {$a}%';
$string['completiondetail:watchtillend'] = 'Ver hasta el final';
$string['completiondisablewarning'] = 'Al menos un usuario ha completado esta actividad. Para editar el vídeo, primero debe desbloquear la configuración de finalización. Esto también permitirá que se vuelva a calcular el estado de finalización, si corresponde.';
$string['completionincomplete'] = 'Incompleto';
$string['completionmanual'] = 'Marcar manualmente como completado';
$string['completionmarkcomplete'] = 'Marcar completado';
$string['completionmarkincomplete'] = 'Hecho';
$string['completionnone'] = 'No monitoreado';
$string['completionnotrecordedinpreviewmode'] = 'La finalización no se registra en el modo de vista previa.';
$string['completiononcomplete'] = 'Completar la actividad';
$string['completiononcompletefull'] = 'Recibir una calificación completa';
$string['completiononcompletepass'] = 'Recibir una calificación aprobatoria (> 50%)';
$string['completiononpass'] = 'Recibir una calificación aprobatoria (> 50%)';
$string['completiononview'] = 'Ver';
$string['completionpercentage'] = '% de Finalización del Trabajo';
$string['completionpercentageerror'] = 'El porcentaje de finalización debe ser mayor que 0 y menor o igual a 100';
$string['completionpercentagehelp'] = 'Las interacciones son tareas que los usuarios pueden marcar como completadas al ver el vídeo.';
$string['completionreseterror'] = 'Error al restablecer los datos de finalización.';
$string['completionresetsuccess'] = 'Los datos de finalización se restablecieron correctamente.';
$string['completiontracking'] = 'Seguimiento de finalización';
$string['completionwatchtillend'] = 'Ver hasta el final';
$string['congratulationsyoucompletethisactivity'] = '¡FELICITACIONES! ¡Ha completado todos los requisitos para esta actividad!';
$string['content'] = 'Contenido';
$string['contenttype'] = 'Tipos de contenido';
$string['contentuploaded'] = 'Contenido subido exitosamente';
$string['contentuploaderror'] = 'Error al subir contenido';
$string['controlsaftercompletion'] = 'Controles: después de la finalización';
$string['controlsbeforecompletion'] = 'Controles: antes/sin finalización';
$string['copied'] = '¡Copiado!';
$string['copiedtoclipboard'] = '¡Enlace copiado al portapapeles!';
$string['copy'] = 'Copiar';
$string['copynoun'] = 'Copiar';
$string['courseindex'] = 'Índice del curso';
$string['createinteractivevideofromlist'] = 'Crear un vídeo interactivo a partir de la lista';
$string['currenttime'] = 'Hora actual';
$string['customdescription'] = 'Descripción personalizada';
$string['dailymotion'] = 'Movimiento diario';
$string['darkmode'] = 'Usar modo oscuro';
$string['datatableinfo'] = 'Mostrando del _INICIO_ al _FIN_ de _TOTAL_ entradas';
$string['datatableinfoempty'] = 'Mostrando 0 a 0 de 0 entradas';
$string['datatableinfofiltered'] = '(filtrado de _MAX_ entradas totales)';
$string['default'] = 'Predeterminado';
$string['defaultappearance'] = 'Apariencia predeterminada';
$string['defaultappearance_desc'] = 'Seleccionar la configuración de apariencia predeterminada para la instancia de video interactivo.';
$string['defaultbehavior'] = 'Comportamiento predeterminado';
$string['defaultbehavior_desc'] = 'Seleccione la configuración de comportamiento predeterminada para la instancia de vídeo interactivo.';
$string['defaulttheme'] = 'Tema predeterminado';
$string['defaulttheme_desc'] = 'Seleccionar el Tema predeterminado para la instancia de video interactivo.';
$string['defaulttitle'] = 'Sin título';
$string['defaultvideosource'] = 'Fuente predeterminada del video/audio';
$string['defaultvideosource_desc'] = 'Seleccione la fuente de video/audio predeterminada para la instancia de video interactivo.';
$string['delete'] = 'Eliminar';
$string['deletecompletion'] = 'Eliminar finalización';
$string['deletedbyinstructor'] = 'Eliminado por el instructor';
$string['deleteinteraction'] = 'Eliminar interacción';
$string['deleteinteractionconfirm'] = '¿Está seguro de que desea eliminar esta interacción?';
$string['deleterecordforitemforuserconfirm'] = '¿Está seguro de querer eliminar el registro de <b>{$a->item}</b> para <b>{$a->user}</b>? <br><br><b>Nota</b>: Esta acción no actualiza el estado de finalización, ni la calificación, ni los puntos de experiencia. El re-calcular solo ocurre cuando el usuario re-intenta la actividad.';
$string['deleterecordforselectedusers'] = '¿Está seguro de querer eliminar los registros seleccionados ({$a})?';
$string['deletevideo'] = 'Eliminar audio/video';
$string['deletevideobutton'] = '<i class="fa fa-trash fa-fw iv-mr-2"></i>Eliminar vídeo/audio';
$string['deletevideoconfirm'] = '¿Está seguro de que quiere eliminar este archivo?';
$string['disablechapternavigation'] = 'Deshabilitar el menú de capítulos';
$string['disablecustomtime'] = 'Deshabilitar la hora personalizada del video';
$string['disablecustomtime_desc'] = 'Si se activa, los usuarios no podrán configurar una hora d einicio y hora de fin para el video en el formato para editar la actividad.';
$string['disableinteractionclick'] = 'Deshabilitar interacción haciendo clic en la navegación del video';
$string['disableinteractionclickuntilcompleted'] = 'Deshabilitar el clic de interacción a menos que se complete';
$string['dismissible'] = 'Descartable';
$string['dismissibleandskippable'] = 'Si se puede descartar, la interacción incompleta se puede cerrar utilizando el botón de cerrar. <br>Si se puede omitir, se puede omitir la interacción incompleta. De lo contrario, el usuario debe completar la interacción antes de pasar al siguiente segmento.';
$string['dismissnotallowedbeforecompletion'] = 'No puede descartar esta interacción antes de completarla.';
$string['displayasstartscreen'] = 'Mostrar descripción en la pantalla de inicio';
$string['displaydescriptiononactivityheader'] = 'Display description on activity header';
$string['displayinline'] = 'Mostrar en línea en la página del curso';
$string['displayoptions'] = 'Opciones de visualización';
$string['displayoptionsbottom'] = 'Debajo del video';
$string['displayoptionsinline'] = 'En línea';
$string['displayoptionspopup'] = 'Ventana emergente';
$string['displayoptionsside'] = 'Cajón';
$string['distractionfreemode'] = 'Usar modo sin distracciones';
$string['download'] = 'Descargar';
$string['draftsaved'] = 'Cambios guardados';
$string['duration'] = 'Duración';
$string['dyntube'] = 'Tubo dinámico';
$string['edit'] = 'Editar';
$string['editinteractiontitle'] = 'Editar {$a->name} a las {$a->time}';
$string['editinteractiontitlenotime'] = 'Editar {$a}';
$string['editwithctrlclick'] = 'Editar (ctrl/cmd + clic para edición rápida)';
$string['email'] = 'Email';
$string['enablecontenttypes'] = 'Tipos de contenido habilitados';
$string['enablecontenttypes_desc'] = 'Seleccionar para habilitar los tipos de contenido.';
$string['enablecoursesettings'] = 'Habilitar configuraciones a nivel de curso';
$string['enablecoursesettings_desc'] = 'Marque para habilitar la configuración a nivel de curso para las instancias de video interactivo.';
$string['enablevideosources'] = 'Fuentes de vídeo/audio habilitadas';
$string['enablevideosources_desc'] = 'Seleccionar para habilitar las fuentes de video/audio.';
$string['end'] = 'Hora del fin';
$string['endscreen'] = 'Pantalla final';
$string['endscreentext'] = 'Texto de pantalla final';
$string['endtime'] = 'Hora del fin';
$string['endtimegreaterstarttime'] = 'Hora del fin debe ser mayor que hora de inicio.';
$string['endtimelesstotaltime'] = 'Tiempo debe ser menor que la duración total del video.';
$string['endtip'] = '<b>Tip:</b> Clic derecho para configurar la hora actual. Ctrl/Cmd + clic para reiiciar la hora a la predeterminada.';
$string['errorplaynotallowed'] = 'Su navegador no permite la reproducción automática del vídeo. Haga clic en el botón de reproducción para obtener la información del vídeo.';
$string['expand'] = 'Expandir';
$string['expected'] = 'Esperado';
$string['external'] = 'Externo';
$string['fastforward200'] = 'Avance rápido 0,2 s (Ctrl/Cmd durante 1 s)';
$string['file'] = 'Archivo subido';
$string['filters'] = 'Filtro';
$string['first'] = 'Primero';
$string['firstname'] = 'Nombre';
$string['fontfamilies'] = 'Familias de tipos de letra';
$string['fontfamilies_desc'] = 'Defina las familias de tipos de letra disponibles para el menú desplegable de selección. Separe cada tipo de letra con una nueva línea. Utilice este formato: Nombre para mostrar=familia de tipo de letra. Ejemplo: Arial=Arial, sans-serif';
$string['formvaluesarereset'] = 'Los valores del formato se restablecen. Por favor guarde el formato nuevamente.';
$string['forward'] = 'Adelantar';
$string['forwardtooltip'] = 'Adelantar (flecha derecha)';
$string['fullavailablewidth'] = 'Imagen de poster de ancho completo';
$string['fullscreen'] = 'Pantalla completa';
$string['fullscreenisnotsupported'] = 'Pantalla completa no está soportada en este dispositivo.';
$string['generalsettings'] = 'Configuraciones generales';
$string['generalsettings_desc'] = 'Esta es una versión candidata a lanzamiento del plugin de video interactivo. Se recomienda probar este plugin en un entorno de desarrollo antes de implementarlo en un sitio de producción. Informe cualquier problema al encargado del mantenimiento del plugin: <a href="{$a}">{$a}</a>.';
$string['goto'] = 'Ir a';
$string['gradenonzero'] = 'La calificación debe ser mayor o igual a 0';
$string['hideinteractions'] = 'Ocultar interacciones en navegación en video';
$string['hidemainvideocontrols'] = 'Ocultar controles principales de video';
$string['html5video'] = 'Subida de video/audio HTML5';
$string['id'] = 'ID';
$string['idlealert'] = 'Ha estado inactivo por un tiempo. Hemos detenido los procesos en segundo plano para ahorrar memoria en su navegador. Vuelva a cargar la página para continuar.';
$string['import'] = 'Importar';
$string['importcontent'] = 'Importar contenidos';
$string['incomplete'] = 'Incompleto';
$string['inprogress'] = 'En progreso';
$string['instance'] = 'Instancia';
$string['interactionadded'] = 'Interacción añadida exitosamente';
$string['interactionalreadyexists'] = 'Ya existe una interacción en este tiempo.';
$string['interactionbar'] = 'Barra de interacción';
$string['interactioncanonlybeaddedbetweenstartandendtime'] = 'Solo se puede agregar una interacción entre los tiempos de inicio ({$a->start}) y final ({$a->end}) del video que se hayan establecido en la configuración de la actividad.';
$string['interactioncount'] = 'Interacciones';
$string['interactiondeleted'] = 'Interacción eliminada exitosamente';
$string['interactionimported'] = 'Interacción importada exitosamente';
$string['interactionisbetweentheskipsegment'] = 'No se puede agregar una interacción entre el segmento de omisión.';
$string['interactions'] = 'Interacciones';
$string['interactionscannotbeedited'] = '<i class="fa fa-warning iv-mr-2 fa-xl"></i>Al menos un usuario ha intentado esta actividad. Aún puedes agregar nuevas interacciones o editar las existentes, pero el estado de finalización y la calificación no se actualizarán hasta que se vuelva a intentar la actividad.';
$string['interactionsdeleted'] = '{$a} interacciones eliminadas exitosamente.';
$string['interactionsin'] = 'Interacciones en {$a}';
$string['interactionsnotsupportedonlivevideo'] = 'Las interacciones no están soportadas en videos en vivo.';
$string['interactionupdated'] = 'Interacción actualizada exitosamente';
$string['interactivevideo'] = 'Video interactivo';
$string['interactivevideo:addinstance'] = 'Añadir módulo de video interactivo';
$string['interactivevideo:edit'] = 'Editar módulo de video interactivo';
$string['interactivevideo:editreport'] = 'Editar reporte de vídeo interactivo';
$string['interactivevideo:manage'] = 'Gestionar actividades de vídeo interactivas';
$string['interactivevideo:view'] = 'Ver módulo de video interactivo';
$string['interactivevideo:viewreport'] = 'Ver reporte de video interactivo';
$string['interactivevideoname'] = 'Nombre';
$string['invalidtimeformat'] = 'Por favor ingrese una hora válida.';
$string['invalidtimestamp'] = 'Sello de tiempo inválido';
$string['invalidtimestampformat'] = 'Formato inválido de sello de tiempo';
$string['invalidtoken'] = 'Token inválido';
$string['invalidurlformat'] = 'URL inválida';
$string['invalidvideourl'] = 'La URL proporcionada no es válida.';
$string['keepcurrent'] = 'Conservar actual';
$string['keyboardshortcuts'] = '<h5>Atajos de teclado:</h5><br><ul class="iv-pl-3"><li><b>Barra espaciadora </b> - Reproducir/Pausar</li><li><b>Flecha derecha</b> - Avanzar 1 segundo</li><li><b>Flecha izquierda</b> - Retroceder 1 segundo</li><li><b>Más (+)</b> - Acercar la línea de tiempo</li><li><b>Menos (-)</b> - Alejar la línea de tiempo</li><li><b>Ctrl/Cmd + S</b> - Guardar interacciones</li><li><b>A</b> - Abrir la lista de tipos de interacción</li><li><b>E</b> - Activar la edición en masa</li><li><b>Ctrl/Cmd + A</b> - Seleccionar/Deseleccionar interacciones</li><li><b>C</b> - Copiar interacciones seleccionadas</li><li><b>D</b> - Descargar las seleccionadas Interacciones</li><li><b>X</b> - Eliminar interacciones seleccionadas</li><li><b>I</b> - Iniciar formato de importación de interacciones</li><li><b>P</b> - Pegar interacciones copiadas</li><li><b>U</b> - Iniciar formato de carga de interacciones</li></ul>';
$string['kinescope'] = 'Kinescopio';
$string['last'] = 'Último';
$string['lastname'] = 'Apellido(s)';
$string['launchinpopup'] = 'Iniciar en ventana emergente';
$string['launchvideo'] = 'Invocar video';
$string['layer-down'] = 'Capa abajo';
$string['layer-up'] = 'Capa arriba';
$string['list'] = 'Lista';
$string['live'] = 'Vivo';
$string['lock'] = 'Desbloqueado: haga clic para bloquear';
$string['manageivfor'] = 'Administrar videos interactivos para {$a}';
$string['managevideos'] = 'Administrar videos interactivos';
$string['max'] = 'Máx.';
$string['maximum'] = 'Máximo {$a}';
$string['min'] = 'Mín.';
$string['minimum'] = 'Mínimo {$a}';
$string['minimumcompletionpercentage'] = 'Completar tareas al menos (%)';
$string['modulename'] = 'Video interactivo';
$string['modulename_help'] = 'Utilice el módulo de vídeo interactivo para crear vídeos interactivos con tareas e interacciones.';
$string['modulenameplural'] = 'Videos Interactivos';
$string['moresettings'] = 'Más configuraciones';
$string['mute'] = 'Mudo';
$string['mutetooltip'] = 'Mudo (M)';
$string['nametip'] = '<b>Sugerencia:</b> Clic derecho para reiniciar el nombre al título del video predeterminado (si hubiera).';
$string['new'] = 'Nuevo';
$string['next'] = 'Siguiente';
$string['nocontent'] = 'Sin contenido';
$string['nocontentfound'] = 'No se encontraron contenidos';
$string['nofound'] = 'No encontrado';
$string['nonzero'] = 'No puede ser cero';
$string['nopermissiontoaddinteractions'] = 'Usted no tiene permiso para añadir interacciones.';
$string['nopermissiontoview'] = 'Usted no tiene permiso para ver el video interactivo';
$string['noposterimage'] = 'Sin imagen de psoter';
$string['notaccessreport'] = 'Usted no puede acceder ala página del reporte.';
$string['notstarted'] = 'No iniciado';
$string['novideofile'] = 'Usted debe subir un archivo de video.';
$string['novideourl'] = 'Debe pegar una URL aquí.';
$string['numeric'] = 'Solo números';
$string['off'] = 'Desactivado';
$string['openinnewtab'] = 'Abrir en nueva pestaña';
$string['options'] = 'Opciones';
$string['panopto'] = 'Panopto';
$string['participant'] = 'Participante';
$string['passwordprotected'] = 'Protegido por contraseña';
$string['passwordprotected_help'] = 'Marque esta casilla si el vídeo está protegido con contraseña. Esto garantizará que el campo de contraseña no quede obstruido por ningún elemento de la página.';
$string['passwordrequired'] = 'Se requiere contraseña';
$string['paste'] = 'Pegar';
$string['pause'] = 'Pausa';
$string['pauseonblur'] = 'Pausar video cuando pestaña está inactiva';
$string['pausetooltip'] = 'Pausar (Barra espaciadora)';
$string['peertube'] = 'PeerTube';
$string['play'] = 'Reproducir';
$string['playbackcontrols'] = 'Controles de reproducción';
$string['playbackrate'] = 'Velocidad de reproducción';
$string['player'] = 'Reproductor';
$string['playhere'] = 'Reproducir aquí';
$string['playpause'] = 'Reproducir/Pausa';
$string['playtooltip'] = 'Reproducir (Barra espaciadora)';
$string['playvideo'] = 'Reproducir video';
$string['pluginadministration'] = 'Administración de video interactivo';
$string['pluginname'] = 'Video Interactivo';
$string['posterimage'] = 'Imagen de poster';
$string['preventseeking'] = 'Prevenir la búsqueda';
$string['preventskipping'] = 'Evitar saltos';
$string['preventskipping_help'] = 'Esta configuración no se aplica a usuarios con capacidades de edición.';
$string['preview'] = 'Vista previa';
$string['previous'] = 'Anterior';
$string['privacy:metadata:attachments'] = 'El itemid del anexo.';
$string['privacy:metadata:char1'] = 'Datos almacenados como Char1.';
$string['privacy:metadata:char2'] = 'Datos almacenados como Char2.';
$string['privacy:metadata:char3'] = 'Datos almacenados como Char3.';
$string['privacy:metadata:completeditems'] = 'Una lista de elementos completados.';
$string['privacy:metadata:completiondetails'] = 'Los detalles de finalización del usuario.';
$string['privacy:metadata:completionid'] = 'La ID de la finalización.';
$string['privacy:metadata:completionpercentage'] = 'El porcentaje de finalización del usuario.';
$string['privacy:metadata:interactivevideo_completion'] = 'El estado de finalización del usuario para la actividad de vídeo interactivo.';
$string['privacy:metadata:interactivevideo_log'] = 'Una bitácora de usuario para la actividad de vídeo interactivo.';
$string['privacy:metadata:intg1'] = 'Datos almacenados como Intg1.';
$string['privacy:metadata:intg2'] = 'Datos almacenados como Intg2.';
$string['privacy:metadata:intg3'] = 'Datos almacenados como Intg3.';
$string['privacy:metadata:text1'] = 'Datos almacenados como Text1.';
$string['privacy:metadata:text2'] = 'Datos almacenados como Text2.';
$string['privacy:metadata:text3'] = 'Datos almacenados como Text3.';
$string['privacy:metadata:timecompleted'] = 'La hora en que un usuario completó la actividad.';
$string['privacy:metadata:timecreated'] = 'La hora en que se creó el estado/bitácora de finalización.';
$string['privacy:metadata:timeended'] = 'LA hora de cuando el video llegóa al final.';
$string['privacy:metadata:timemodified'] = 'La hora en que se modificó el estado/bitácora de finalización.';
$string['privacy:metadata:userid'] = 'La ID de un usuario.';
$string['privacy:metadata:xp'] = 'Los puntos de experiencia ganados por el usuario.';
$string['progress'] = 'Progreso';
$string['progressbar'] = 'Barra del progreso';
$string['providerapis'] = 'APIs del proveedor';
$string['quality'] = 'Calidad';
$string['quicksettings'] = 'Configuraciones rápidas';
$string['redo'] = 'Rehacer';
$string['refresh'] = 'Refrescar';
$string['remainingtime'] = 'Tiempo restante';
$string['replayaftercompletion'] = 'Volver a reproducir después de finalizar';
$string['replaybehavior'] = 'Comportamiento de reproducción';
$string['replycount'] = 'Reproducciones';
$string['report'] = 'Reporte';
$string['reportfields'] = 'Campos reportados';
$string['reportfields_desc'] = 'Seleccionar los campos del usuario a mostrar en el reporte.';
$string['reportfor'] = 'Reporte para {$a}';
$string['reportsettings'] = 'Configuraciones del reporte';
$string['reportwithctrlclick'] = 'Reporte (ctrl/cmd + clic para reporte rápido)';
$string['required'] = 'Requerido';
$string['requiremintime'] = 'Minutos mínimos empleados';
$string['requiremintime_help'] = 'El tiempo mínimo en minutos que un usuario debe dedicar a la actividad (después de que se inicia la actividad) antes de que pueda marcarse como completada.';
$string['rerun_desc'] = 'Si se marca, la interacción completada se volverá a ejecutar cuando el usuario vuelva a visitar el segmento.';
$string['reset'] = 'Reiniciar';
$string['resetappearancesettings'] = 'Restablecer configuración de apariencia';
$string['resetbehaviorsettings'] = 'Restablecer la configuración de comportamiento';
$string['resetcompletion'] = 'Reiniciar finalización';
$string['resetgrades'] = 'Reiniciar calificaciones';
$string['resetintro'] = 'Vaciar la descripción';
$string['resetpasswordprotected'] = 'Restablecer contraseña protegida';
$string['resetsettings'] = 'Restablecer configuraciones';
$string['resettodefaults'] = 'Restablecer a valores predeterminados';
$string['resettositedefaults'] = 'Restablecer a los valores predeterminados del sitio';
$string['resize'] = 'Resize';
$string['restart'] = 'Reiniciar';
$string['resync'] = 'Resincronizar contenido desde el banco de contenidos';
$string['rewind'] = 'Rebobinar';
$string['rewind200'] = 'Rebobinar 0,2 s (Ctrl/Cmd durante 1 s)';
$string['rewindtooltip'] = 'Rebobinar (flecha izquierda)';
$string['rightclicktodelete'] = 'Clic derecho para eliminar';
$string['rightclicktosetcurrenttime'] = 'Haga clic derecho para establecer la hora actual. Intro para guardar.';
$string['rowsselected'] = '%d filas seleccionadas';
$string['rumble'] = 'Rumble';
$string['rutube'] = 'RuTube';
$string['save'] = 'Guardar';
$string['search'] = 'Buscar';
$string['section'] = 'Sección';
$string['sectionname'] = 'Nombre de sección';
$string['sectionnum'] = 'Sección';
$string['seekingdisabled'] = 'La búsqueda está deshabilitada.';
$string['segmentendmustbegreaterthantimestamp'] = 'La hora de fin del segmento debe ser mayor que la hora de inicio.';
$string['select'] = 'Seleccionar...';
$string['selectacontenttypetoadd'] = 'Seleccionar un tipo de contenido para añadir';
$string['selectactivity'] = 'Seleccionar módulo';
$string['selectcourse'] = 'Seleccionar curso';
$string['selectinteraction'] = 'Comprobar sus selecciones.';
$string['selectoruploadcontent'] = 'Seleccionar un contenido de la lista o crear uno';
$string['separatesearchtermsbyslash'] = 'Sugerencia: Use "|" para separar múltiples términos de búsquedas.';
$string['setasdefault'] = 'Establecer como predeterminados para este curso';
$string['settings'] = 'Configuraciones';
$string['settingssaved'] = 'Configuraciones guardadas';
$string['settingstooltip'] = 'Configuración (Ctrl/Cmd + clic para configuraciones rápidas)';
$string['share'] = 'Compartir';
$string['sharethismoment'] = 'Compartir este momento';
$string['showcompletionrequirements'] = 'Mostrar requisitos de finalización';
$string['showindexindf'] = 'Mostrar en modo sin distracciones';
$string['showless'] = 'Mostrar menos';
$string['showmore'] = 'Mostrar más';
$string['showname'] = 'Mostrar nombre';
$string['showplaybuttononcoursepage'] = 'Mostrar el botón de reproducción en la página del curso';
$string['showposterimage'] = 'Mostrar imagen de poster';
$string['showposterimageright'] = 'Mostrar imagen de poster a la derecha';
$string['showprogressbar'] = 'Mostrar barra del progreso';
$string['skip'] = 'Saltar';
$string['skippable'] = 'Saltable';
$string['skipped'] = 'Saltado';
$string['soundcloud'] = 'SoundCloud';
$string['source'] = 'Fuente';
$string['source_help'] = 'Seleccionar la fuente del video.';
$string['spendatleast'] = 'Dedicar al menos {$a} minutos';
$string['spotify'] = 'Spotify';
$string['sproutvideo'] = 'SproutVideo';
$string['squareposterimage'] = 'Imagen cuadrada de poster';
$string['start'] = 'Hora de inicio';
$string['startchapter'] = 'Inicio';
$string['started'] = 'Iniciado';
$string['startscreen'] = 'Pantalla de inicio';
$string['starttimelessthanendtime'] = 'La hora de inicio debe ser menor a la hora de fin.';
$string['starttimelesstotaltime'] = 'La hora de inicio debe ser menor que la duración total del video.';
$string['starttip'] = '<b>Sugerencia:</b> Haga clic derecho para establecer la hora actual. Ctrl/Cmd + clic para restablecer la hora a 00:00:00.';
$string['subplugintype_ivplugin'] = 'Tipo de Contenido Video Interactivo';
$string['subplugintype_ivplugin_plural'] = 'Tipos de Contenido Video Interactivo';
$string['subtitle'] = 'Subtítulo';
$string['supportedlinks'] = '<b>Fuentes soportadas:</b> {$a}';
$string['taskscompleted'] = 'Trabajos completados';
$string['thereisanissueloadingvideo'] = 'Hay un problema al cargar el vídeo.';
$string['thisinteractionalreadyexists'] = 'No puede agregar más de un <b> {$ a} </b>.';
$string['timecompleted'] = 'Hora de completado';
$string['timecompletedrange'] = 'Rango de hora de completado';
$string['timecreatedrange'] = 'Rango de hora de iniciado';
$string['timemodified'] = 'Hora de modificado';
$string['timemustbebetweenstartandendtime'] = 'El tiempo debe estar dentro de los tiempos de inicio ({$a->start}) y final ({$a->end}) del video';
$string['timestamp'] = 'Sello de tiempo';
$string['timestarted'] = 'Hora de iniciado';
$string['timesubmitted'] = 'Hora de enviado';
$string['tip'] = 'Sugerencia';
$string['title'] = 'Título';
$string['todo'] = 'Por hacer';
$string['togglechapter'] = 'Alternar menú de capítulo';
$string['togglecompletion'] = 'Alternar finalización';
$string['togglecontrols'] = 'Cambiar controles';
$string['togglefullscreen'] = 'Cambiar a/de pantalla completa';
$string['toggleview'] = 'Cambiar vista';
$string['tutorial'] = 'Tutorial';
$string['type'] = 'Tipo';
$string['undo'] = 'Deshacer';
$string['unknowncontenttype'] = 'Tipo desconocido de contenido';
$string['unlock'] = 'Bloqueado: haga clic para desbloquear';
$string['unmute'] = 'Activar el sonido';
$string['unmutetooltip'] = 'Sonoro (M)';
$string['unsavedchanges'] = 'Tiene cambios sin guardar. ¿Estás seguro de que desea salir de esta página?';
$string['updateavailable'] = 'Actualización disponible';
$string['upload'] = 'Subir';
$string['uploadanimagebelow'] = 'Subir debajo una imagen de poster';
$string['uploadannotations'] = 'Subr interacciones';
$string['uploadcontent'] = 'Subir contenido';
$string['uploadvideo'] = 'Subir video/audio';
$string['uploadvideobutton'] = '<i class="fa fa-upload fa-fw iv-mr-2"></i>Subir video/audio';
$string['url'] = 'URL';
$string['usecardonlydesign'] = 'Usar diseño minimalista';
$string['usecolumnlayout'] = 'Usar acomodo horizontal';
$string['usecustomdescription'] = 'Usar descripción personalizada';
$string['usecustomposterimage'] = 'Usar imagen de poster personalizada';
$string['usefixedratio'] = 'Forzar relación de aspecto 16:9';
$string['useoriginalvideocontrols'] = 'Usar controles originales de video';
$string['vdocipher'] = 'VdoCipher';
$string['video'] = 'Video';
$string['videocontrols'] = 'Controles del video';
$string['videodisplayoptions'] = 'Opciones del reproductor';
$string['videoinformation'] = 'Información del video';
$string['videolink'] = 'Video/audio externo directo';
$string['videonavhelp'] = '<h5>Sugerencias:</h5><ul class="iv-pl-3"><li>Haga clic en la barra de navegación del video para buscar un momento específico.</li><li>Haga clic derecho en la barra de navegación del video para agregar contenido en un momento específico.</li><li>Haga clic en el ícono de interacción para ver su contenido.</li><li>Haga clic derecho en el ícono de interacción para editar su contenido.</li><li>Presione Ctrl/Comando para avanzar o retroceder rápidamente para aumentar la velocidad en 1 segundo.</li><li>Presione Mayús y desplázate por la línea de tiempo para desplazarte horizontalmente.</li><li>Presione Ctrl/Comando y desplázate por la línea de tiempo para acercar o alejar la imagen.</li><li>Arrastre el ícono de interacción para cambiar su marca de tiempo.</li></ul>';
$string['videoplayer'] = 'Reproductor de video';
$string['videoprogress'] = 'Progreso del video';
$string['videoquality'] = 'Calidad del video';
$string['videosharinginstructions'] = 'Insctrucciones para compartir medios para todo el sitio';
$string['videosharinginstructions_desc'] = 'Ingrese las instrucciones para compartir medios en el sitio. Por ejemplo, si su organización tiene políticas específicas para medios alojados externamente, este es el lugar perfecto para especificarlas. Estas instrucciones se mostrarán en la parte superior del formato de edición de actividad.';
$string['videotoolbar'] = 'Barra de herramientas del video';
$string['videourl'] = 'URL del video/audio';
$string['videourlplaceholder'] = 'Pegar aquí una URL soportada';
$string['vidyard'] = 'Vidyard';
$string['views'] = 'Vistas';
$string['vimeo'] = 'Vimeo';
$string['viostream'] = 'Viostream';
$string['visibilityonvideonav'] = 'Visible en navegación en video';
$string['visibilityonvideonav_desc'] = 'Si está marcada, el indicador de interacción será visible en la barra de navegación del video.';
$string['watch'] = 'Ver';
$string['watched'] = 'Visto %';
$string['wistia'] = 'Wistia';
$string['xp'] = 'XP';
$string['xpcompleted'] = 'XP ganados';
$string['xpearned'] = '¡Usted ha ganado {$a} XPs!';
$string['xplost'] = '¡Usted ha perdido {$a} XPs!';
$string['xppoint'] = 'Puntos de experiencia';
$string['yes'] = 'Si';
$string['youcannotviewthisannotationyet'] = 'Todavía no puede ver este contenido.';
$string['youmustcompletethepreviousactivity'] = 'Debe completar la actividad anterior antes de poder ver el resto del video.';
$string['youmustcompletethistaskfirst'] = 'Usted debe completar primero este trabajo.';
$string['youmustspendatleastminutesbeforemarkingcomplete'] = 'Debe dedicar al menos <b>{$a->timerequire} minutos</b> antes de marcar esto como completo.<br><br><b>Tiempo empleado: {$a->timespent} minutos.</b>';
$string['youtube'] = 'YouTube';
$string['yt'] = 'YouTube';
