<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'englishcentral', language 'es_mx', version '4.5'.
 *
 * @package     englishcentral
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accountid'] = 'ID de EnglishCentral';
$string['accountlookup'] = 'Búsqueda de cuenta';
$string['achieved'] = 'logrado';
$string['activetime'] = 'Tiempo Activo';
$string['activityclose'] = 'Actividad cierra';
$string['activityclose_help'] = 'Los estudiantes pueden acceder a esta actividad hasta antes de la fecha y hora aquí especificadas. Después de esta fecha y hora, la actividad estará cerrada.';
$string['activityname'] = 'Nombre de actividad';
$string['activityname_help'] = 'Este es el contenido para la herramientita de ayuda asociada con el campo englishcentralnam. La sintaxis Markdown está soportada.';
$string['activityopen'] = 'Actividad abre';
$string['activityopen_help'] = 'Los estudiantes pueden acceder a esta actividad a partir de esta fecha y hora. Antes de esta fecha y hora, la actividad estará cerrada.';
$string['addthisvideo'] = 'Añadir este video';
$string['addvideo'] = 'Añadir video';
$string['addvideohelp'] = 'Para añadir un video a esta página, hacer clic en este ícono y hacer una búsqueda del video.';
$string['advanced'] = 'Avanzado';
$string['advancedsection'] = 'Configuraciones Avanzadas';
$string['advancedsection_details'] = 'Usualmente las configuraciones de aquí deberían dejarse sin cambios. A Usted se le podrían dar instrucciones de Poodll support para usarlas en algunos casos.';
$string['allattempts'] = 'Gestor de Intentos';
$string['allusers'] = 'Todos los usuarios (intento más reciente)';
$string['allusersreport'] = 'Reporte de Todos los Usuarios';
$string['appauthorised'] = 'Poodll EnglishCentral está autorizado para este sitio.';
$string['appnotauthorised'] = 'Poodll EnglishCentral NO está autorizado para este sitio. ¿Está registrada la URL de su sitio y está vigente su suscripción?';
$string['attemptdetails'] = 'Detalles del Intento';
$string['attemptdetailsheader'] = '{$a->name} detalles de intento para {$a->username} en {$a->date}';
$string['attemptsmanager'] = 'Gestor de Intentos';
$string['badcount'] = 'Mal Conteo';
$string['beginner'] = 'Principiante';
$string['chatmode'] = 'Habilitar Modo Chat';
$string['chatmode_details'] = 'Si se habilita en su cuenta, el modo chat se volverá disponible en el reproductor de EnglishCentral.';
$string['completed'] = 'Completado';
$string['completiondetail:goals'] = 'Completar los objetivos de ver, aprender y hablar';
$string['completiondetail:mingrade'] = 'Calificación mínima: {$a}';
$string['completiondetail:pass'] = 'Calificación de pase lograda';
$string['completiongoals'] = 'Requerir metas de estudio';
$string['completionmingrade'] = 'Requerir calificación mínima';
$string['completionpass'] = 'Requerir calificación aprobatoria';
$string['compositescore'] = 'Puntaje Global';
$string['confirmattemptdelete'] = '¿Está seguro de querer eliminar este intento?';
$string['confirmattemptdeleteall'] = '¿Está seguro de querer eliminar TODOS los intentos?';
$string['confirmattemptdeletealltitle'] = '¿Eliminar TODOS los intentos?';
$string['confirmattemptdeletetitle'] = '¿Eliminar intento?';
$string['confirmremovevideo'] = '¿Realmente desea quitar este video?';
$string['consultadmin'] = 'Para más ayuda, por favor consulte al administrador de este sitio Moodle.';
$string['consumerkey'] = 'Clave del Consumidor';
$string['consumerkeydefault'] = 'SU CLAVE DEL CONSUMIDOR';
$string['consumerkeyexplain'] = 'Su clave del consumidor está disponible en {$a}';
$string['consumersecret'] = 'Secreto del Consumidor';
$string['consumersecretdefault'] = 'SU SECRETO DEL CONSUMIDOR';
$string['consumersecretexplain'] = 'Su secreto del consumidor está disponible en {$a}';
$string['copyright'] = 'Orígen';
$string['credentialsinvalid'] = 'El secreto y usuario API de Poodll ingresados no se pudieron usar para obtener acceso. Por favor revíselos. Póngase en contacto con  <a href="https://poodll.com/contact" target="EC">Poodll support </a>si hubiera algún problema.';
$string['date'] = 'Fecha';
$string['defaultsettings'] = 'Configuraciones precargadas';
$string['delete'] = 'Eliminar';
$string['deleteallattempts'] = 'Eliminar todos los intentos';
$string['deleteattempt'] = 'eliminar';
$string['description'] = 'Descripción';
$string['details'] = 'Detalles';
$string['developmentmode'] = 'Modo de desarrollo';
$string['developmentmodeexplain'] = 'En sitios en desarrollo, este ajuste debería estar habilitado. En sitios en producción, debería estar deshabilitado.';
$string['displaysubs'] = '{$a->subscriptionname} : expira en {$a->expiredate}';
$string['duration1'] = '<b>Corto</b> (hasta 1 minut0)';
$string['duration2'] = '<b>Medio</b> (1 a 3 minutos)';
$string['duration3'] = '<b>Largo</b> (más de 3 minutos)';
$string['editvideos'] = 'Editar videos';
$string['email'] = 'Email';
$string['enablesetuptab'] = 'Habilitar pestaña configurar';
$string['enablesetuptab_details'] = 'Mostrar una pestaña a administradores que contiene las configuraciones de instancia de actividad. En la mayoría de los casos NO es super útil.';
$string['encryptedsecret'] = 'Secreto Encriptado';
$string['encryptedsecretdefault'] = 'SU SECRETO ENCRIPTADO';
$string['encryptedsecretexplain'] = 'Su secreto encriptado está disponible en {$a}';
$string['englishcentral'] = 'English Central';
$string['englishcentral:addinstance'] = 'Añadir una nueva actividad EnglishCentral';
$string['englishcentral:manage'] = 'Gestionar una actividad de EnglishCentral';
$string['englishcentral:manageattempts'] = 'Gestionar intentos de una actividad de EnglishCentral';
$string['englishcentral:submit'] = 'Enviar datos a una actividad de EnglishCentral';
$string['englishcentral:view'] = 'Ver una actividad de EnglishCentral';
$string['englishcentral:viewreports'] = 'Ver reportes para una actividad de EnglishCentral';
$string['englishcentralfieldset'] = 'Conjuntodecampo ejemplo personalizado';
$string['englishcentralsettings'] = 'Ingresar ID y Título de Video de English Central';
$string['exceededattempts'] = 'Usted ha completado el máximo de  {$a} intentos.';
$string['exportcsv'] = 'Exportar a CSV';
$string['exportexcel'] = 'Exportar  a Excel (csv)';
$string['exportpdf'] = 'Exportar a PDF';
$string['fillcredentials'] = 'Configurar secreto y usuario API con credenciales existentes';
$string['finish'] = 'Terminar';
$string['freetrial'] = 'Obtener Credenciales API Cloud Poodll y una Prueba Gratuita';
$string['freetrial_desc'] = 'Un diálogo debería de aparecer, que le permite registrarse para una prueba gratuita con Poodll. después de registrarse usted debería ingresar al Tablero de Miembros para obtener su secreto y usuario API, Y para registrar la URL de su sitio.';
$string['from'] = 'De';
$string['fullname'] = 'Nombre Completo';
$string['futureactivityclose'] = 'Esta actividad cerrará en {$a}';
$string['futureactivityopen'] = 'Esta actividad abriráen {$a}';
$string['futurevideoclose'] = 'Los videos estarán disponibles hasta antes de {$a}';
$string['futurevideoopen'] = 'Los videos estarán disponibles a partir de {$a}';
$string['goalperiod'] = 'Período de la meta';
$string['goalperiod_help'] = 'El período de tiempo y el día o la fecha de cuando estas metas deberían de alcanzarse.ser alcanzadas.';
$string['goals'] = 'Metas';
$string['goals_help'] = 'Definir metas para tiempo de Ver, Hablar y Estudiar';
$string['goodcount'] = 'Buen Conteo';
$string['gradeaverage'] = 'puntaje promedio de todos los intentos';
$string['gradehighest'] = 'puntaje del intento más alto';
$string['gradelatest'] = 'puntaje del último intento';
$string['gradelowest'] = 'puntaje del intento más bajo';
$string['gradenone'] = 'Sin calificación';
$string['gradeoptions'] = 'Opciones de calificación';
$string['hiddenchallengemode'] = 'Reto oculto';
$string['intermediate'] = 'Intermedio';
$string['invalidconfig'] = 'Lo sentimos, no podemos seguir adelante porque las configuraciones para el módulo de la la actividad English Central en este sitio Moodle no son válidas.';
$string['item'] = 'Ítem';
$string['lastaccess'] = 'Último intento';
$string['learngoal'] = 'Aprender';
$string['learngoal_help'] = 'La meta del número de palabras individuales a aprender.';
$string['learngoalunits'] = 'palabras';
$string['learnmode'] = 'Modo de aprender';
$string['learnwords'] = '{$a} palabras';
$string['level'] = 'Nivel';
$string['levelx'] = 'Nivel {$a}';
$string['lightboxmode'] = 'Modo de caja-de-luz';
$string['linesrecorded'] = 'Líneas grabadas';
$string['lineswatched'] = 'Líneas observadas';
$string['lookupemptyresult'] = 'No se encontró ID de cuenta de EnglishCentral para usuario: {$a->fullname}.';
$string['lookupinstructions'] = 'Seleccionar un usuario y presionar "Buscar" para ver la ID de cuenta EnglishCentral del usuario.';
$string['lookupresults'] = 'La ID de cuenta EnglishCentral para {$a->fullname} es: <big><b>{$a->accountid}</b></big>';
$string['maxattempts'] = 'Máximos intentos';
$string['memberdashboard'] = 'Tablero del Miembro';
$string['missingconfig'] = 'Lo sentimos, no podemos seguir adelante porque  las configuraciones siguientes aun no están definidas para el módulo de la actividad English Central en este sitio Moodle.';
$string['modulename'] = 'Poodll EnglishCentral';
$string['modulename_help'] = 'Usar el módulo EnglishCentral para permitirles a sus estudiantes usar videos EnglishCentral dentro de cursos Moodle.';
$string['modulenameplural'] = 'Actividades Poodll de EnglishCentral';
$string['myattempts'] = 'Mis Intentos';
$string['noapisecret'] = 'No se ingresó un secreto API Poodll. Por favor suscríbase o tome una prueba gratuita en  <a href="https://poodll.com/plugin-poodll-englishcentral" target="EC">https://poodll.com</a>';
$string['noapiuser'] = 'No se ingresó un usuario API Poodll. Por favor suscríbase o tome una prueba gratuita en  <a href="https://poodll.com/plugin-poodll-englishcentral" target="EC">https://poodll.com</a>';
$string['noconnection'] = 'ADVERTENCIA: Su sitio Moodle actualmente no puede conectarse al servidor de EnglishCentral.';
$string['nocredentials'] = 'No se ingresó un secreto y usuario API Poodll. Por favor  ingréselos en <a href="{$a}">the settings page.</a> Los puede obtener de <a href="https://poodll.com/member" target="EC">Poodll.com.</a>';
$string['nodataavailable'] = 'Sin datos disponibles';
$string['noenglishcentrals'] = 'Lo siento,no hay actividades EnglishCentral en este curso.';
$string['noprogressreport'] = 'Lo siento, pero no hay progreso para reportar';
$string['nosubscriptions'] = 'No hay una suscripción actual para este sitio/plugin.';
$string['notavailable'] = 'Lo sentimos, esta actividad actualmente no está disponible para Usted.';
$string['notokenincache'] = 'Refrescar para ver información de la licencia. Póngase en contacto con  <a href="https://poodll.com/contact" target="EC">Poodll support </a>si hubiera algún problema.';
$string['notviewable'] = 'Lo sentimos, los videos para esta actividad actualmente no están disponibles para Usted.';
$string['novalidcredentials'] = 'Secreto y usuario API Poodll API fueron rechazados y no se pudo obtener acceso. Por favor revíselos en <a href="{$a}">the settings page.</a> Puede obtenerlos de <a href="https://poodll.com/member" target="EC">Poodll.com.</a>';
$string['novideos'] = 'Al momento no hay videos para ver.';
$string['overview'] = 'Vista general';
$string['overview_help'] = 'En una actividad EnglishCentral, los estudiantes interactúan con un conjunto seleccionado de videos y trabajan para lograr las metas de Observar, Aprender y Estudiar configuradas por su profesor.

Para configurar la actividad, el profesor primeramente define las siguientes metas de estudio:

* el número de videos a Observar
* el número de palabras a Aprender
* el número de líneas a Hablar

El profesor entonces busca en la biblioteca de videos de EnglishCentral y selecciona cuales videos deberían de ser añadidos a esta actividad EnglishCentral.

Finalmente, el estudiante elige uno o más de los videos que le gustaría ver. Después de ver un video, el estudiante puede elegir cuales palabras del video le gustaría aprender, y cuales líneas le gustaría practicar hablando.

Conforme cada estudiante estudia, los indicadores en su tablero son actualizados para dar retroalimentación acerca de su progreso hacia las metas de Observar, Aprender y Hablar.';
$string['partnerid'] = 'ID del Partner';
$string['partneriddefault'] = 'SU PARTNER ID';
$string['partneridexplain'] = 'Su Partner ID está disponible en {$a}';
$string['pastactivityclose'] = 'Esta actividad cerró en {$a}';
$string['pastactivityopen'] = 'Esta actividad abrió en {$a}';
$string['pastvideoclose'] = 'Los videos estuvieron disponibles hasta {$a}';
$string['pastvideoopen'] = 'Los videos estarán disponibles a partir de {$a}';
$string['phoneme'] = 'Fonema';
$string['phonemes'] = 'Fonemas';
$string['phonemesheader'] = '{$a->englishcentralname} Fonemas para el intento de {$a->username} en {$a->attemptdate}';
$string['playersettings'] = 'Configuraciones del reproductor';
$string['playerversion'] = 'Versión del reproductor';
$string['playerversiondefault'] = 'JSDK3';
$string['playerversionexplain'] = 'Generalmente, Usted debería usar la versión más reciente disponible, pero en algunas circunstancias, Usted podría preferir seleccionar una versión más antigua.';
$string['pluginadministration'] = 'Administración de EnglishCentral';
$string['pluginname'] = 'Poodll EnglishCentral';
$string['points'] = 'Puntos';
$string['poodllapisecret'] = 'Secreto API Poodll';
$string['poodllapiuser'] = 'Usuario API Poodll';
$string['preview'] = 'Vista previa';
$string['previewenglishcentral'] = 'Previsualizar English Central';
$string['privacy:metadata:activetime'] = 'El tiempo activo en la sesión';
$string['privacy:metadata:attemptid'] = 'El identificador único de un intento de actividad de usuario en English Central.';
$string['privacy:metadata:attempttable'] = 'La tabla donde son almacenados los datos del intento del usuario de English Central.';
$string['privacy:metadata:ecid'] = 'El identificador único de una instancia de actividad de English Central.';
$string['privacy:metadata:englishcentralcom'] = 'El plugin English Central almacena datos de sesión contra la id de cuenta  de English Central de los usuarios de Moodle.';
$string['privacy:metadata:englishcentralcom:accountid'] = 'El plugin de English Central apareja la userid de Moodle con una id de cuenta única English Central. La id de la cuenta es almacenada en englishcentral.com.';
$string['privacy:metadata:learncount'] = 'Los ítems hechos de sesión de aprender';
$string['privacy:metadata:learntotal'] = 'totales';
$string['privacy:metadata:learnwordids'] = 'Los IDs de las palabras aprendidas';
$string['privacy:metadata:sessiongrade'] = 'La calificación de la sesión';
$string['privacy:metadata:sessionscore'] = 'El puntaje de la sesión';
$string['privacy:metadata:speakcomplete'] = 'El porcentaje completado de la sesión hablada';
$string['privacy:metadata:speakcount'] = 'Los ítems vistos de sesión hablada';
$string['privacy:metadata:speaklineids'] = 'Los IDs de ítems de sesión hablada';
$string['privacy:metadata:speaktotal'] = 'Los ítems totales de sesión hablada';
$string['privacy:metadata:status'] = 'El estado de la actividad';
$string['privacy:metadata:timecompleted'] = 'La hora de cuando fue completada la actividad';
$string['privacy:metadata:timecreated'] = 'La hora de cuando fue creada la actividad';
$string['privacy:metadata:totalpoints'] = 'Los puntos totales para la sesión';
$string['privacy:metadata:totaltime'] = 'El tiempo total de la sesión';
$string['privacy:metadata:userid'] = 'La user ID para el intento de English Central';
$string['privacy:metadata:videoid'] = 'La ID del viideo para el intento actual';
$string['privacy:metadata:watchcomplete'] = 'El porcentaje completado de ver sesión';
$string['privacy:metadata:watchcount'] = 'Los ítems vistos de ver sesión';
$string['privacy:metadata:watchlineids'] = 'Los IDs de línea de ítems de ver sesión';
$string['privacy:metadata:watchtotal'] = 'El total de ítems de ver sesión';
$string['progressdials'] = 'Ubicación de Indicadores del Progreso';
$string['progressdials_bottom'] = 'Inferior (debajo del reproductor)';
$string['progressdials_top'] = 'Superior (Arriba del reproductor)';
$string['progressupdated'] = 'Evento Actualizado en Progreso';
$string['readonlymode'] = 'Modo de solo-lectura';
$string['readonlymode_desc'] = 'Esta actividad actualmente está en modo de solamente lectura. Usted puede ver la información en la primera página de esta actividad EnglishCentral, pero no puede ver ninguno de los videos.';
$string['reattempt'] = 'Intentar de nuevo';
$string['refreshtoken'] = 'Refrescar información de licencia';
$string['removevideo'] = 'Quitar video';
$string['removevideohelp'] = 'Para quitar un video de esta página, arrástrelo a su ícono.';
$string['report'] = 'Reportes';
$string['reports'] = 'Reportes';
$string['reporttitle'] = 'Título del reporte {$a}';
$string['returntoreports'] = 'Regresar a Reportes';
$string['searchterm'] = 'Buscar palabras';
$string['selectanother'] = 'Regresar al Curso';
$string['sessionactivetime'] = 'Tiempo de actividad de la sesión';
$string['sessiongrade'] = 'Calificación de la sesión';
$string['sessionresults'] = 'Resultados de la sesión';
$string['sessionscore'] = 'Puntaje de la Sesión';
$string['setup'] = 'Configuración';
$string['showdetails'] = 'Mostrar enlace a detalles';
$string['showdetails_help'] = 'Si esta opción es seleccionada, un enlace a los detalles de cada video será mostrado. Los detalles incluyen una transcripción, información del vocabulario, preguntas de comprensión y preguntas de discusión.';
$string['showduration'] = 'Mostrar duración';
$string['showduration_help'] = 'Si esta opción es seleccionada, la duración de cada video será mostrada.';
$string['showlevelnumber'] = 'Mostrar número del nivel';
$string['showlevelnumber_help'] = 'Si esta opción es seleccionada, el nivel de dificultad de cada video es mostrado como un número.';
$string['showleveltext'] = 'Mostrar descripción del nivel';
$string['showleveltext_help'] = 'Si esta opción es seleccionada, el nivel de dificultad de cada video es mostrado como texto.';
$string['showtostudentsonly'] = 'Si, mostrar solamente a estudiantes';
$string['showtoteachersandstudents'] = 'Si, mostrar a profesores y estudiantes';
$string['showtoteachersonly'] = 'Si, mostrar solamente a profesores';
$string['simpleui'] = 'Interfaz de Usuario Simple';
$string['speakgoal'] = 'Hablar';
$string['speakgoal_help'] = 'El número meta de líneas únicas a hablar.';
$string['speakgoalunits'] = 'Líneas';
$string['speaklines'] = '{$a} líneas';
$string['speaklitemode'] = 'Modo SpeakLite';
$string['speakmode'] = 'Modo de Hablar';
$string['start'] = 'Iniciar';
$string['status'] = 'Estado';
$string['studygoal'] = 'Tiempo de estudio';
$string['studygoal_help'] = 'El número meta de minutos/horas a estudiar.

El tiempo de estudio es calculado usando la fórmula siguiente:

(número de videos vistos) x 6 minutos
+ (número de palabras aprendidas) x 1 minuto
+ (número de líneas habladas) x 1 minuto';
$string['studygoalunits'] = 'minutos';
$string['subscriptionhasnocreds'] = 'La suscripción de Poodll EnglishCentral está expirada o aun no se ha configurado. ¨Póngase en contacto con <a href="https://poodll.com/contact" target="EC">Poodll support</a>';
$string['supportconfirm'] = 'La información siguiente será enviada a Poodll.com (solicitud demo a English Central) para solicitar una Partner ID y claves de acceso:';
$string['supportmessage'] = 'Por favor podría ponerse en contacto conmigo con respecto a una partner ID y claves para usar el módulo EC en mi sitio Moodle';
$string['supportsubject'] = 'Solicitud para acceso a módulo EC para Moodle';
$string['supporttitle'] = 'Solicitar partner ID de EnglishCentral.com';
$string['timeondate'] = '%l:%M %p en %b %d (%a) %Y';
$string['topics'] = 'Tópicos';
$string['total'] = 'Total';
$string['totalactivetime'] = 'Tiempo activo total';
$string['totalgoal'] = 'Total';
$string['totalgoal_help'] = 'El progreso total como un porcentaje. Es calculado usando la fórmula siguiente:

**(número de ítems estudiados) / (meta total de estudio)**

* **número de ítems estudiados**:
(número de videos vistos) +
(número de palabras aprendidas) +
(número de líneas habladas)
* **meta total de estudio**:
(meta de vistos) + (meta de aprendidas) + (meta de habladas)';
$string['transcript'] = 'Transcripción';
$string['unlimited'] = 'ilimitado';
$string['until'] = 'Hasta';
$string['updatesettings'] = 'Hacer clic en el enlace siguiente para añadir/editar estas configuraciones: {$a}';
$string['updatinggrades'] = 'Actualizando calificaciones de EnglishCentral';
$string['username'] = 'Nombre_de_usuario';
$string['value'] = 'Valor';
$string['videoclose'] = 'Videos visibles hasta antes de';
$string['videoclose_help'] = 'Los estudiantes pueden ver e interactuar con videos hasta antes de esta fecha y hora. Después de esta fecha, los estudiante ya no pueden ver los videos, pero aun pueden ver sus resultados.';
$string['videodetails'] = 'Detalles de video de EnglishCentral';
$string['videoid'] = 'ID del Video';
$string['videoopen'] = 'Videos visibles a partir de';
$string['videoopen_help'] = 'Los estudiantes pueden ver e interactuar con videos a partir  de esta fecha y hora. Antes de esta fecha, los videos no serán visibles.';
$string['videosearch'] = 'Búsqueda de video';
$string['videosearchhelp'] = 'Por favor escriba una o más palabras a buscar dentro de la caja de texto de "Búsqueda de video"';
$string['videosearchprompt'] = 'Ingresar aquí términos a buscar';
$string['videotitle'] = 'Título del Video';
$string['view'] = 'Ver';
$string['viewreport'] = 'Detalles';
$string['viewreports'] = 'Ver reportes';
$string['watchgoal'] = 'Observar';
$string['watchgoal_help'] = 'El número meta de videos a observar.';
$string['watchgoalunits'] = 'videos';
$string['watchmode'] = 'Modo de observar';
$string['watchvideos'] = '{$a} videos';
$string['xitemsfound'] = '{$a} ítems encontrados';
$string['yourprogress'] = 'Su progreso';
