<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'block_exaport', language 'es_mx', version '4.5'.
 *
 * @package     block_exaport
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutme'] = 'Acerca de mí';
$string['aboutme_description'] = 'Predefinida por informción del CV, pero puede ser editable para cada bloque';
$string['accessoptions'] = '¿Quién tiene acceso?';
$string['add'] = 'Añadir';
$string['addButton'] = 'Añadir';
$string['add_directory_structure'] = 'Añadir directorio-estructura';
$string['add_mixed'] = 'Añadir nuevo artefacto';
$string['add_this_file'] = 'añadir este archivo';
$string['addbookmark'] = 'Añadir marcador';
$string['addcategory'] = 'Añadir categoría';
$string['addcomment'] = 'Añadir comentario';
$string['addposterror'] = 'Hubo un error al añadir esta publicación en la base de datos';
$string['addstdcat'] = 'categorías de importación estándar';
$string['attachincluded'] = '¿anexo?';
$string['attachment'] = 'anexo';
$string['autofillview'] = 'Automáticamente añadir todos los artefactos disponibles a esta vista';
$string['awaiting'] = '({$a} esperando)';
$string['back'] = 'Atras';
$string['back_to_desp'] = 'regresar a portafolio de idioma';
$string['backtocourse'] = 'Regresar al curso';
$string['badges_help'] = 'el bloque con las insignias otorgadas a usted<br><a href=\'{$a}\' target=\'_blank\' class=\'external-link\'>Vea sus insignias</a>';
$string['badsessionkey'] = 'Clave de sesión Mala';
$string['block_exaport_allowcustomlayout_body'] = 'Permite usar configuraciones de diseño de vista personalizadas (similar a las opciones de abajo) para propietarios regulares de las vistas';
$string['block_exaport_allowcustomlayout_head'] = 'Opciones personalizadas para el diseño de vista para ver propietarios';
$string['block_exaport_app_alloweditdelete_body'] = 'Solamente es útil en combinación con Rejilla de Competencia Exabis y dakora';
$string['block_exaport_app_alloweditdelete_head'] = 'A los estudiantes se les permite editar y eliminar ítems después de la revisión por los profesores';
$string['block_exaport_app_externaleportfolio_body'] = 'Para App';
$string['block_exaport_app_externaleportfolio_head'] = 'Guardar archivos para Mahara si está activado, guardar para exaport si no está activado';
$string['block_exaport_confirm_profilefield_create'] = '¿Realmente desea añadir el campo de perfil requerido?';
$string['block_exaport_confirm_profilefield_exists'] = 'Ya existe el campo del perfil para el profesor confiable';
$string['block_exaport_copytomyportfolio'] = 'Habilitar "Copiar a mi portafolios"';
$string['block_exaport_copytomyportfolio_body'] = 'Usuario podrá copiar artefactos desde categoría compartida hacia su propio portafolios';
$string['block_exaport_maxbytes'] = 'Tamaño máximo de archivo a subir en Exabis E-Portafolio';
$string['block_exaport_maxbytes_body'] = 'Esto especifica un tamaño máximo para archivos subidos que pueden procesarse en Exabis E-Portfolio.<br> El valor para el sitio completo es: {$a->sitemaxbytes}. Vea <a href="{$a->settingsurl}">configuraciones</a>';
$string['block_exaport_multiplefilesinitem'] = 'Artificio de archivos múltiples dentro de "Archivo"';
$string['block_exaport_multiplefilesinitem_body'] = 'límite: 10 archivos.';
$string['block_exaport_profilefield_created'] = 'Se añadió el campo del perfil para el profesor confiable';
$string['block_exaport_teachercanseeartifactsofstudents_body'] = 'Los profesores confiables tienen que ser configurados en sus perfiles individuales y esto solamente funcionará, si la opción superior ha sido activada.<br />{$a}La lista de estudiantes para cada profesor confiable es generada de acuerdo a sus inscripciones a cursos.<br />Los estudiantes no pueden deshabilitar este acceso. El acceso para otros usuarios puede darse como antes.';
$string['block_exaport_teachercanseeartifactsofstudents_configurationlink'] = 'Añadir campo del perfil del usuario requerido';
$string['block_exaport_teachercanseeartifactsofstudents_head'] = 'El profesor puede ver TODOS los artefactos de sus estudiantes';
$string['block_exaport_used_layout'] = 'Acomodo usado';
$string['block_exaport_used_layout_body'] = 'Cambie el acomodo si tiene problemas de apariencia. En este momento, se utiliza solo para la lista de artefactos.';
$string['block_exaport_used_layout_clean_old'] = 'Acomodo de mosaicos (antiguo: se perdió el soporte a partir de la versión v4.6.7)';
$string['block_exaport_used_layout_moodle_bootstrap'] = 'Acomodo de tarjetas';
$string['block_exaport_userquota'] = 'Cuota del usuario para Exabis E-Portafolio';
$string['block_exaport_userquota_body'] = 'El máximo número de bytes que un usuario puede almacenar en su propio Exabis E-Portfolio.<br> Valor para el sitio completo es: {$a->bytes}. Vea <a href="{$a->settingsurl}">configuraciones</a>';
$string['blockcontent'] = 'Contenido del bloque';
$string['blocktitle'] = 'E-Portafolio Exabis';
$string['blocktitle2'] = 'Título del bloque';
$string['bookmarknotfound'] = 'Marcador no encontrado';
$string['bookmarksall'] = 'Todos los items';
$string['bookmarksfiles'] = 'Archivos';
$string['bookmarkslinks'] = 'Ligas';
$string['bookmarksnotes'] = 'Notas';
$string['browsecategory'] = 'Mirar esta categoría';
$string['browseportfolio'] = 'Mirar este portafolio';
$string['cancelButton'] = 'Cancelar';
$string['categories'] = 'Categorías';
$string['category'] = 'Categoria';
$string['category_not_found'] = 'Categoría no encontrada';
$string['category_up'] = 'regresar a Categoría Padre';
$string['categorydeleted'] = 'Categoría eliminada.';
$string['categoryedited'] = 'Categoría guardada.';
$string['categoryhead'] = 'Nombre de categoría';
$string['categorynotempty'] = 'Usted debe elegir una categoría.';
$string['categorysaved'] = 'Categoría añadida.';
$string['change'] = 'Cambiar';
$string['change_layout'] = 'Cambiar Diseño';
$string['checkall'] = 'Revisar todas';
$string['chooselayout'] = 'Seleccione cómo le gustaría que se acomodoran las columnas en su página';
$string['clearAllFilers'] = 'Borrar todos los filtros';
$string['clicktodownloadscorm'] = 'Prsione el botón para descargar el archivo SCORM:';
$string['close'] = 'cerrar';
$string['cofigureblock'] = 'Configurar Bloque';
$string['cofigureblock_badge'] = 'Elegir Insignias';
$string['cofigureblock_cvinfo'] = 'Elegir informaciónCV';
$string['cofigureblock_cvinfo_certif'] = 'Certificaciones, acreditaciones y distinciones';
$string['cofigureblock_cvinfo_cover'] = 'Acerca de mi';
$string['cofigureblock_cvinfo_cover_actual'] = 'Añadir contenido de CV actual "Acerca de mi"';
$string['cofigureblock_cvinfo_education_history'] = 'Historia educativa';
$string['cofigureblock_cvinfo_employment_history'] = 'Historia laboral';
$string['cofigureblock_cvinfo_goals'] = 'Mis metas';
$string['cofigureblock_cvinfo_help'] = 'Usted verá el estado actual de los elementos seleccionados en su CV. El contenido del bloque será actualizado si usted hace cambios a cualquier cosa en CV después.';
$string['cofigureblock_cvinfo_interests'] = 'intereses';
$string['cofigureblock_cvinfo_mbrship'] = 'Membresías';
$string['cofigureblock_cvinfo_public'] = 'Libros y publicaciones';
$string['cofigureblock_cvinfo_skills'] = 'Mis habilidades';
$string['cofigureblock_cvinfo_withfiles'] = 'Con archivos anexos';
$string['cofigureblock_header'] = 'Elegir encabezado';
$string['cofigureblock_item'] = 'Elegir artefacto';
$string['cofigureblock_media'] = 'Elegir medio';
$string['cofigureblock_personalinfo'] = 'Elegir información personal';
$string['cofigureblock_text'] = 'Elegir texto';
$string['comment'] = 'Comentario';
$string['comment_delete_confirmation'] = '¿Realmente desea eliminar este comentario?';
$string['commentnotfound'] = 'Comentario no encontrado';
$string['comments'] = 'Comentarios';
$string['commentshouldnotbeempty'] = 'Usted debe escribir un comentario';
$string['competenceinteraction'] = 'Permitir interacción con bloque de Rejilla de Competencia Exabis, en caso de estar instalado';
$string['competences'] = 'competencias';
$string['competences_old_version'] = 'En este Moodle está instalada una versión obsoleta de Exabis Competences, que ya no está soportada por Exabis Eportfolio.';
$string['config_feature_copy_to_course'] = 'Permitirle a los estudiantes copiar archivos del E-portafolio a sus cursos';
$string['configureblock_cvinfo_group_by_category'] = 'Desplegar elementos de CV en categorías';
$string['contactcomps'] = 'Contraer todo';
$string['copycategory'] = 'Copiar a mi Portafolio';
$string['copyitemtocourse'] = 'Copiar al curso';
$string['couldninsertcomment'] = '¡No se pudo insertar comentario!';
$string['couldntcopyfile'] = '¡No se pudo copiar archivo para {$a}! Archivo no importado.';
$string['couldntcreatedirectory'] = 'No se pudo crear directorio';
$string['couldntcreatetempdir'] = '¡No se pudo crear directorio temporal!';
$string['couldntextractscormfile'] = '¡No se pudo extraer archivo-SCORM!';
$string['couldntinsert'] = 'No se pudo insertar {$a} en la base de datos';
$string['couldntinsertcategory'] = '¡No se pudo insertar categoría!';
$string['couldntinsertdesc'] = '¡No se pudo insertar la descripción!';
$string['couldntupdatecategory'] = '¡No se pudo actualizar categoría!';
$string['couldntupdatedesc'] = '¡No se pudo actualizar su descripción!';
$string['course'] = 'Curso';
$string['create_as_note'] = 'Crear como Artefacto';
$string['create_view_content_help_text'] = '<ul>
                <li><strong>Planee su diseño:</strong> Arrastre y suelte bloques y arréglelos para decir su historia. Use columnas (disponible en la sección "diseño") para planear su portafolios.</li>
                <li><strong>Organice para claridad:</strong> Use encabezado, enlaces y anotaciones para estructurar su contenido eficientemente.</li>
                <li><strong>Personalice su estilo:</strong> Elija fonts y colores dentro de las opciones disponibles para añadirle un toque suyo.</li>
            </ul>
            <strong>Recuerder: Su e-poratfolio le dice al mundo acerca de usted y sus habilidades. ¡Hágalo claro, conciso y atractivo!</strong>';
$string['create_view_content_help_title'] = 'Fabrique su propia historia: Construya su Portafolios';
$string['createepxexport'] = 'Crear Archivo-EPX';
$string['createexport'] = 'Crear Archivo-SCORM';
$string['createexport_directory'] = 'Crear Directorio-estructura';
$string['createexportxapi'] = 'Crear archivo XAPI';
$string['createpage'] = 'Arrastre y coloque bloques de contenido desde las pestañas de abajo para crear su página';
$string['current_category'] = 'Categoría Actual';
$string['cvgroup'] = 'CV';
$string['cvinformation'] = 'Información CV';
$string['cvinformation_help'] = 'El bloque con los datos del CV de su ePortafolios exabis, como: educación, empleo, etc.<br><a href=\'{$a}\' target=\'_blank\' class=\'external-link\'>Vea su CV</a>';
$string['date'] = 'Fecha';
$string['delete'] = 'Eliminar';
$string['delete_all_shareall'] = '¿Borrar todo lo de compartir_todo (shareall)?';
$string['deletecategoryconfirm'] = '¿Realmente desea eliminar la categoría "{$a->name}"? ¡Todas las entradas en esta categoría, y todas las sub-categorías serán eliminadas!';
$string['deletefileconfirm'] = '¿Realmente quiere eliminar este archivo?';
$string['deletelinkconfirm'] = '¿Realmente quiere eliminar esta liga?';
$string['deletenoteconfirm'] = '¿Realmente quiere eliminar esta nota?';
$string['deleteposterror'] = 'Ocurrió un error al eliminar publicación';
$string['descriptionsaved'] = 'descripción guardada';
$string['deselectall'] = 'Des-seleccionar Todo';
$string['desp_categories'] = 'historias, interpretar roles, ensayos, collage
   curriculum vitae
   reseñas de producciones teatrales, exhibiciones
   reportes y reflexiones sobre projecto
   audio- y videoclips
   encuentros con otras nacionalidades
   pensamientos acerca de tus habilidades con el idioma
   tarjetas de reportes
   certificados
   reconocimientos
   comprensión auditiva
   - trabajo individual
   - trabajo en pareja
   - trabajo en grupo
   lectura
   - trabajo individual
   - trabajo en pareja
   - trabajo en grupo
   participación en conversaciones
   - trabajo individual
   - trabajo en pareja
   - trabajo en grupo
   hablar con fluidez
   - trabajo individual
   - trabajo en pareja
   - trabajo en grupo
   escritura
   - trabajo individual
   - trabajo en pareja
   - trabajo en grupo';
$string['desp_einleitung'] = 'Aquí está su portafolios. Usted puede mostrarle a otros lo que Usted ha logrado por sí mismo.';
$string['desp_language'] = 'Idioma';
$string['desp_pluginname'] = 'Dosier';
$string['details'] = 'Detalles';
$string['developed'] = 'desarrollado por';
$string['dontincludeurl'] = 'Elija esta casilla para des-asociar el marcador con el URL';
$string['download'] = 'Descargar';
$string['download_pdf'] = 'Descargar como PDF';
$string['duplicatedurl'] = 'Usted ya tiene este URL marcado.';
$string['edit'] = 'Editar';
$string['editcategories'] = 'editar categorías';
$string['emailaccess'] = 'Compartir por Email';
$string['emailaccessdescription'] = 'Ingresar una dirección Email por línea<br />Cada Email recibirá un enlace único con acceso a esta vista. Al eliminar el Email se quitará el acceso a esta vista.will receive a unique link with access to this view. Deleting the email will remove access to this view.';
$string['emailaccessmessage'] = '¡Hola! {$a->sendername} ha compartido la vista  "{$a->viewname}" para Usted. Usted puede verla aquí: {$a->url}';
$string['emailaccessmessageHTML'] = '¡Hola!<br />{$a->sendername} ha compartido la vista "{$a->viewname}" para Usted.<br />Usted puede verla <a href="{$a->url}">aquí</a>.';
$string['emailaccessmessagesubject'] = 'Nueva Vista compartida para Usted';
$string['endedit'] = 'Terminar de editar';
$string['enrolled_courses'] = 'Relacionado con cursos';
$string['exaport:addinstance'] = 'añadir E-Portafolios Exabis al curso';
$string['exaport:allowposts'] = 'Permitir publicaciones';
$string['exaport:competences'] = 'Permitir competencias';
$string['exaport:export'] = 'Exportar Archivos-SCORM';
$string['exaport:import'] = 'Importar Archivos-SCORM';
$string['exaport:importfrommoodle'] = 'Importar desde Moodle';
$string['exaport:myaddinstance'] = 'añadir E-Portafolios Exabis a Mi hogar';
$string['exaport:shareextern'] = 'Compartición externa de vistas';
$string['exaport:shareintern'] = 'Compartición interna de vistas';
$string['exaport:use'] = 'Uso permitido';
$string['exaport:viewartifactsfromstudents'] = 'Puede ver artefactos del portafolio de sus estudiantes';
$string['expandcomps'] = 'Expander todo';
$string['explaincategories'] = 'Categorías: aquí puede Usted crear y modificar categorías';
$string['explainexport'] = 'Exportar su portafolios aquí.';
$string['explainimport'] = 'Aquí puede importar un Archivo-SCORM al portafolios. Si se encontraran marcadores de exportaciones  previas, la importación tratará de importar los datos en la estructura de archivos existente.';
$string['explaining'] = 'El portafolios puede usarse para guardar direcciones web, archivos y anotaciones, lo que le permite a los usuarios escribir ideas o comentarios breves.';
$string['explainingall'] = 'Todos los items en el portafolios';
$string['explainingfile'] = 'Archivos. Estos archivos pueden compartirse con todos los miembros del curso autorizados.';
$string['explaininglink'] = 'Ligas. Estas ligar pueden compartirse con todos los miembros del curso autorizados.';
$string['explainingmoredata'] = '<strong>Este es su espacio para juntar evidencia de su viaje de aprendizaje.</strong>
            <ul>
                <li><strong>Añada su mejor trabajo:</strong> Suba archivos, enlaces web, o descripciones de proyectos, presentaciones y más.</li>
                <li><strong>Discuta sus experiencias:</strong> Explique qué aprendió, los retos que enfrentó, y sus logros para cada parte.</li>
            </ul>
            <strong>Piense en cada elemento como una historia, resaltando sus habilidades y conocimiento.</strong>';
$string['explainingnote'] = 'Notas. Estas notas pueden compartirse con todos los miembros del curso autorizados.';
$string['explainingshare'] = 'Para permitirle a un participante ver la liga, elija su nombre y después elija \'Guardar Cambios\'. Usted puede elegir a más de un participante.';
$string['explainingshared'] = 'Estos participantes han compartido algunas de sus ligas externas, archivos o notas.';
$string['explainingsharefile'] = 'Para permitirle a un participante que vea el archivo, elija su nombre y después elija \'Guardar Cambios\'.  Usted puede elegir a más de un participante.';
$string['explainingsharenote'] = 'Para permitirle a un participante que vea la nota, elija su nombre y después elija \'Guardar Cambios\'.  Usted puede elegir a más de un participante.';
$string['explainingviews'] = 'Gestionar sus vistas.';
$string['explainpersonal'] = 'Información personal';
$string['export'] = 'Exportar Archivo-SCORM';
$string['export_directory'] = 'Exportar Directorio-estructura';
$string['export_short'] = 'Exportar';
$string['exportcomment'] = 'Este es un archivo exportado desde el E-portafolio Exabis. ¡Por favor no quite los comentarios, porque se necesitan para la importación!';
$string['exportepx'] = 'Exportar Archivo-EPX';
$string['exportviewselect'] = 'Para exportar todos los items de una vista específica, por favor selecciónela aquí.';
$string['externaccess'] = 'Liga externa a E-portafolio';
$string['externalaccess'] = 'Acceso Externo';
$string['externcomment'] = 'Compartir comentarios en portafolios externo';
$string['fieldstoshow'] = 'Campos a mostrar';
$string['file'] = 'Archivo';
$string['filecopiedtocourse'] = 'Archivo copiado al curso $a->coursename con el nombre de $a->filename';
$string['filenotfound'] = 'Archivo no encontrado';
$string['filetypenotdetected'] = 'El tipo de archivo de $a->filename ($a->title) no pudo detectarse. ¡El archivo no se importó!';
$string['filterByTag'] = 'Filtrar por marca';
$string['firstname'] = 'Nombre(s)';
$string['firstnameshared'] = 'Nombre';
$string['forms.item.project_description'] = 'El porqué detrás de este proyecto';
$string['forms.item.project_description_editor'] = 'El porqué detrás de este proyecto';
$string['forms.item.project_description_editor_help'] = '<strong>Explique brevemente el propósito de su trabajo:</strong>
            <ul>
                <li>¿Qué problemas atacaba?</li>
                <li>¿Qué habilidades quería desarrollar?</li>
                <li>¿Cuál era el contexto?</li>
            </ul>';
$string['forms.item.project_description_help'] = '<strong>Explique brevemente el propósito de su trabajo:</strong>
            <ul>
                <li>¿Qué problemas atacaba?</li>
                <li>¿Qué habilidades quería desarrollar?</li>
                <li>¿Cuál era el contexto?</li>
            </ul>';
$string['forms.item.project_process'] = 'Hacer que suceda';
$string['forms.item.project_process_editor'] = 'Hacer que suceda';
$string['forms.item.project_process_editor_help'] = '<strong>Describa su viaje:</strong>
            <ul>
                <li>¿Qué pasos tomó para completar este proyecto?</li>
                <li>Qué retos encontró y cómo los sobrepasó?</li>
                <li>¿Qué recursos usó?</li>
            </ul>';
$string['forms.item.project_process_help'] = '<strong>Describa su viaje:</strong>
            <ul>
                <li>¿Qué pasos tomó para completar este proyecto?</li>
                <li>Qué retos encontró y cómo los sobrepasó?</li>
                <li>¿Qué recursos usó?</li>
            </ul>';
$string['forms.item.project_result'] = 'Resultados y aprendizajes';
$string['forms.item.project_result_editor'] = 'Resultados y aprendizajes';
$string['forms.item.project_result_editor_help'] = '<strong>Resuma brevemente los resultados de su proyecto:</strong>
                <ul>
                    <li>¿Qué logró?</li>
                    <li>¿Cuáles habilidades y competencias desarrolló o reforzó con este trabajo?</li>
                    <li>¿Qué aprendió acerca de usted mismo y sus habilidades?</li>
                    <li>¿Qué haría diferente la próxima vez?”</li>
                </ul>';
$string['forms.item.project_result_help'] = '<strong>Resuma brevemente los resultados de su proyecto:</strong>
                <ul>
                    <li>¿Qué logró?</li>
                    <li>¿Cuáles habilidades y competencias desarrolló o reforzó con este trabajo?</li>
                    <li>¿Qué aprendió acerca de usted mismo y sus habilidades?</li>
                    <li>¿Qué haría diferente la próxima vez?”</li>
                </ul>';
$string['forms.item.title'] = 'Título';
$string['forms.item.title_help'] = '';
$string['go'] = '¡Hacerlo!';
$string['gradeitem'] = 'Calificar el ítem';
$string['grouptitle'] = 'Título del Grupo';
$string['headertext'] = 'Textodelencabezado';
$string['headertext_help'] = 'El bloque simple para añadir solamente línea del encabezado';
$string['height'] = 'Altura';
$string['hidesummary'] = '(ocultar resumen)';
$string['i_shared'] = 'Yo compartí una vista de e-portafolio con Usted';
$string['iconfile'] = 'Miniatura';
$string['iconfile_merge'] = 'Unir esta imágen de ícono con el ícono de la carpeta';
$string['iconfile_merge_description'] = 'Imagen del ícono tratará (sin garantías) de unir con el ícono estándar de la carpeta. El ícono será remplazado con la nueva imagen.';
$string['import'] = 'Importar Archivo SCORM';
$string['import_short'] = 'Importar';
$string['importedcommentsend'] = 'Fin de comentarios importados';
$string['importedcommentsstart'] = 'Comentarios importados:<br /><br />';
$string['importexport'] = 'Importar/Exportar';
$string['in'] = 'en';
$string['incompatible_video'] = 'Para ver este video por favor use el enlace directo: {$a->link}';
$string['incorrectlinksid'] = 'ID de publicación de liga incorreto';
$string['incorrectnoteid'] = 'ID de nota incorrecto';
$string['internalaccess'] = 'Acceso Interno';
$string['internalaccessall'] = 'Acceso para <span class=\'block_eportfolio_bold\'>todos</span>';
$string['internalaccessgroups'] = 'Acceso solamente para los grupos siguientes';
$string['internalaccessusers'] = 'Acceso solamente para los siguientes usuarios';
$string['intro'] = 'Contenido';
$string['intronotempty'] = 'Usted tiene que escribir un contenido.';
$string['invalidassignmentid'] = 'ID de tarea inválido';
$string['invalidcourseid'] = 'Hay un ID de curso inválido';
$string['invalidfileatthisassignment'] = '¡El archivo no existe en esta tarea!';
$string['invalidinstance'] = 'Hay una instancia inválida';
$string['item'] = 'Ítem';
$string['item.project_information'] = 'Información del proyecto';
$string['itemgrading'] = 'Calificación';
$string['items'] = 'Mis artefactos';
$string['items_help'] = 'El bloque con sus artefactos<br><a href=\'{$a}\' target=\'_blank\' class=\'external-link\'>Ver sus artefactos</a>';
$string['lang_categories'] = '';
$string['lastname'] = 'Apellido(s)';
$string['layout_settings'] = 'Configuraciones del diseño';
$string['layout_settings_border_width'] = 'Ancho del borde';
$string['layout_settings_border_width_only_bottom'] = 'Borde solamente abajo';
$string['layout_settings_custom_css'] = 'CSS personalizado';
$string['layout_settings_custom_css_description'] = 'Usted puede usar aquí sus propias reglas CSS personalizadas';
$string['layout_settings_description'] = 'Usted puede cambiar aquí algunas opciones del diseño de vista o usar reglas propias personalizadas CSS para tener la vista que quiere';
$string['layout_settings_font_size'] = 'Tamaño del font';
$string['layout_settings_font_weight'] = 'Negritas';
$string['layout_settings_view_content'] = 'Contenido de bloques de vista';
$string['layout_settings_view_headers'] = 'Encabezados de bloques de vista';
$string['link'] = 'Liga';
$string['linkedfilenotfound'] = 'Archivo $a->nombre-de-archivo en $a->url ($a->title) no se encontró. ¡El archivo no se importó!';
$string['list'] = 'Lista';
$string['listofartefacts'] = 'Lista de Artefactos';
$string['listofbadges'] = 'Lista de Insignias';
$string['loginasmode'] = 'Usted no puede accesar portafolios en el modo de \'Entrar como\'.';
$string['mailadress'] = 'Dirección Email';
$string['maincategory'] = 'Categoría principal';
$string['make_it_yours'] = 'Hágalo suyo';
$string['makeimport'] = 'Importar';
$string['managecategories'] = 'Gestionar categorías';
$string['mandatoryfields'] = 'El nombre del campo, categoría y la introducción son necesarios. Por favor escríbalos.';
$string['mandatoryfieldsforcat'] = 'El nombre del campo es necesario. Por favor escríbalo.';
$string['media'] = 'Medio';
$string['media_allowed_notes'] = 'Los URLs de los siguientes sitios están permitidos:';
$string['media_help'] = 'El bloque con datos incrustados d emedios del orígen como: YouTube, Vimeo, SlideShare, etc.';
$string['mediacontent'] = 'URL o código incrustado *';
$string['membercount'] = 'Número de miembros';
$string['messageprovider:sharing'] = 'Compartiendo notificaciones';
$string['mixed'] = 'Artefacto';
$string['moodleimport'] = 'Importar desde Moodle-tareas';
$string['moreinfolink'] = 'Mostrar más información';
$string['movebottom'] = 'Botón Mover';
$string['movetop'] = 'Mover arriba';
$string['myfilearea'] = 'Mi área de archivos';
$string['myportfolio'] = 'Mis Artefactos del Portafolio';
$string['myportfoliotitle'] = 'Módulo Exabis ePortafolio: Añada aquí sus enlaces y archivos.';
$string['name'] = 'Nombre';
$string['new'] = 'Nuevo';
$string['newfile'] = 'Añadir archivo nuevo';
$string['newlink'] = 'Añadir liga nueva';
$string['newnote'] = 'Añadir nota nueva';
$string['newview'] = 'Añadir vista';
$string['nobookmarksall'] = '(todavía sin items)';
$string['nobookmarksfile'] = '(todavía sin archivos)';
$string['nobookmarkslink'] = '(todavía sin ligas)';
$string['nobookmarksnote'] = '(todavía sin notas)';
$string['nocategories'] = '(todavía sin categorías)';
$string['nocoursetogether'] = 'Sin Curso';
$string['noemails'] = 'no hay dirección Email disponible';
$string['noentry'] = 'Sin entrada';
$string['nogroupsfound'] = 'No se encontraron grupos';
$string['noguestpost'] = '¡Los visitantes no tienen acceso aquí!';
$string['nomail'] = 'sin Email';
$string['nomoodleimportyet'] = '¡Al momento Usted no tiene envíos en ninguna tarea!';
$string['nopicture'] = 'sin imagen';
$string['noprofilepicture'] = 'sin imagen de perfil disponible';
$string['note'] = 'Nota';
$string['notetitle'] = 'Nota';
$string['nothingshared'] = 'Nadie está compartiendo portafolios con Usted';
$string['nothingstructureshared'] = 'Nadie está compartiendo ua estructura con Usted';
$string['notify'] = 'notificar';
$string['nouserforaccess'] = 'Usuario no encontrado (código de acceso desconocido)';
$string['nouserforid'] = 'Usuario no encontrado (ID desconocida)';
$string['nousersfound'] = 'No se encontraron usuarios';
$string['noviews'] = 'Por favor crear una Vista nueva';
$string['opencomps'] = 'Elija sus competencias';
$string['other_groups_course'] = 'Otros cursos';
$string['other_users_course'] = 'Usuarios que no están en mis cursos';
$string['othercourses'] = 'otros cursos';
$string['pdf_customfont'] = 'Subir font personalizado';
$string['pdf_customfont_help'] = 'Usted puede subir su propio archivo .ttd. Nosotros trataremos de usarlo para generación del PDF.';
$string['pdf_settings'] = 'Configuraciones del PDF';
$string['pdf_settings_description'] = 'Si utiliza caracteres especiales o poco comunes en un idioma, el PDF generado puede tener problemas. Por lo tanto, puede intentar utilizar diferentes configuraciones de tipo de letra.<br>
Su configuración de PDF se guardará para esta vista.<br>Por lo tanto, si comparte su vista con otros usuarios, verán el PDF con su configuración.<br>
Los tipos de letra no estándar pueden perder algunas opciones, como negrita, cursiva, etc.';
$string['pdf_settings_fontfamily'] = 'Familia del font';
$string['pdf_settings_fontfamily_customgroup'] = 'Fonts personalizados subidos';
$string['pdf_settings_fontfamily_fixedgroup'] = 'Fonts predefinidos';
$string['pdf_settings_fontsize'] = 'Tamaño básico del font';
$string['pdf_settings_pageorient'] = 'Orientación de página';
$string['pdf_settings_pageorient.landscape'] = 'Apaisado';
$string['pdf_settings_pageorient.portrait'] = 'Retrato';
$string['pdf_settings_pagesize'] = 'Tamaño de página';
$string['pdf_settings_showmetadata'] = 'Añadir ver meta datos';
$string['pdf_settings_showuseremail'] = 'Email del usuario';
$string['pdf_settings_showusername'] = 'nombre del usuario';
$string['pdf_settings_showuserphone'] = 'teléfono del usuario';
$string['pdf_settings_showuserpicture'] = 'imagen del usuario';
$string['pdf_settings_uploadfont'] = 'Subir font propio';
$string['personal'] = 'Información';
$string['personalinformation'] = 'Información personal';
$string['personalinformation_help'] = 'el bloque con sus datos personales, como: nombre, email.<br><a href=\'{$a}\' target=\'_blank\' class=\'external-link\'>Vea su perfil</a>';
$string['pluginname'] = 'ePortafolio Exabis';
$string['privacy:metadata:block_exaportcate'] = 'categorías del usuario';
$string['privacy:metadata:block_exaportcate:courseid'] = 'ID del curso';
$string['privacy:metadata:block_exaportcate:description'] = 'descripción';
$string['privacy:metadata:block_exaportcate:internshare'] = '¿compartir interno?';
$string['privacy:metadata:block_exaportcate:name'] = 'título';
$string['privacy:metadata:block_exaportcate:name_short'] = 'título corto';
$string['privacy:metadata:block_exaportcate:parent_ids'] = 'lista de IDs  paternos';
$string['privacy:metadata:block_exaportcate:parent_titles'] = 'lista de títulos paternos';
$string['privacy:metadata:block_exaportcate:pid'] = 'ID de categoría paterna';
$string['privacy:metadata:block_exaportcate:shareall'] = '¿compartido para todos? 0 - no compartir; 1 - compartido para todos; 2 - compartido para grupos';
$string['privacy:metadata:block_exaportcate:source'] = 'origen';
$string['privacy:metadata:block_exaportcate:sourceid'] = 'ID del origen';
$string['privacy:metadata:block_exaportcate:stid'] = 'ID del tipo de escuela';
$string['privacy:metadata:block_exaportcate:structure_share'] = '¿compartido como estructura? vea también \'structure_shareall\'';
$string['privacy:metadata:block_exaportcate:structure_shareall'] = '¿compartido como estructura? : 0 - no compartido; 1 - compartido para todos; 2 - compartido para grupos';
$string['privacy:metadata:block_exaportcate:subjid'] = 'ID de asunto relacionado';
$string['privacy:metadata:block_exaportcate:timemodified'] = 'última modificación';
$string['privacy:metadata:block_exaportcate:topicid'] = 'ID de tópico relacionado';
$string['privacy:metadata:block_exaportcate:userid'] = 'ID del usuario';
$string['privacy:metadata:block_exaportitem'] = 'artefactos del usuario';
$string['privacy:metadata:block_exaportitem:categoryid'] = 'ID de categoría';
$string['privacy:metadata:block_exaportitem:courseid'] = 'ID del curso';
$string['privacy:metadata:block_exaportitem:exampid'] = 'ID de ejemplo relacionado';
$string['privacy:metadata:block_exaportitem:example_url'] = 'propietario del artefacto';
$string['privacy:metadata:block_exaportitem:externaccess'] = '¿acceso externo?';
$string['privacy:metadata:block_exaportitem:externcomment'] = 'comentario para externos';
$string['privacy:metadata:block_exaportitem:fileurl'] = 'URL hacia archivo';
$string['privacy:metadata:block_exaportitem:intro'] = 'intro';
$string['privacy:metadata:block_exaportitem:iseditable'] = '¿es editable?';
$string['privacy:metadata:block_exaportitem:langid'] = 'ID del idioma';
$string['privacy:metadata:block_exaportitem:name'] = 'nombre';
$string['privacy:metadata:block_exaportitem:parentid'] = 'ID paterno';
$string['privacy:metadata:block_exaportitem:shareall'] = '¿compartido para todos?';
$string['privacy:metadata:block_exaportitem:source'] = 'origen';
$string['privacy:metadata:block_exaportitem:sourceid'] = 'ID del origen';
$string['privacy:metadata:block_exaportitem:timemodified'] = 'hora de última modificación';
$string['privacy:metadata:block_exaportitem:type'] = 'tipo de artefacto';
$string['privacy:metadata:block_exaportitem:url'] = 'URL';
$string['privacy:metadata:block_exaportitem:userid'] = 'propietario del artefacto';
$string['privacy:metadata:block_exaportitemcomm'] = 'comentarios para artefactos';
$string['privacy:metadata:block_exaportitemcomm:entry'] = 'comentario';
$string['privacy:metadata:block_exaportitemcomm:itemid'] = 'ID del artefacto';
$string['privacy:metadata:block_exaportitemcomm:timemodified'] = 'última modificación';
$string['privacy:metadata:block_exaportitemcomm:userid'] = 'autor del comentario';
$string['privacy:metadata:block_exaportresume'] = 'resumen datos';
$string['privacy:metadata:block_exaportresume:courseid'] = 'ID del curso';
$string['privacy:metadata:block_exaportresume:cover'] = 'contenido de portada';
$string['privacy:metadata:block_exaportresume:goalsacademic'] = 'objetivos académicos';
$string['privacy:metadata:block_exaportresume:goalscareers'] = 'objetivos de carrera';
$string['privacy:metadata:block_exaportresume:goalspersonal'] = 'objetivos personales';
$string['privacy:metadata:block_exaportresume:interests'] = 'intereses';
$string['privacy:metadata:block_exaportresume:skillsacademic'] = 'habilidades académicas';
$string['privacy:metadata:block_exaportresume:skillscareers'] = 'habilidades de carrera';
$string['privacy:metadata:block_exaportresume:skillspersonal'] = 'habilidades personales';
$string['privacy:metadata:block_exaportresume:user_id'] = 'propietario resumen';
$string['privacy:metadata:block_exaportuser'] = 'datos del usaurio de e-portafolio exabis';
$string['privacy:metadata:block_exaportuser:description'] = 'descripción';
$string['privacy:metadata:block_exaportuser:user_id'] = 'ID del usuario';
$string['privacy:metadata:block_exaportuser:view_items_layout'] = 'ID del usuario';
$string['privacy:metadata:block_exaportview'] = 'comentarios para artefactos';
$string['privacy:metadata:block_exaportview:autofill_artefacts'] = 'auto-llenado habilitado por artefactos';
$string['privacy:metadata:block_exaportview:description'] = 'descripción';
$string['privacy:metadata:block_exaportview:externaccess'] = '¿acceso externo?';
$string['privacy:metadata:block_exaportview:externcomment'] = '¿comentario de externo?';
$string['privacy:metadata:block_exaportview:langid'] = 'ID del idioma';
$string['privacy:metadata:block_exaportview:layout'] = 'diseño de la vista';
$string['privacy:metadata:block_exaportview:name'] = 'nombre';
$string['privacy:metadata:block_exaportview:shareall'] = '¿compartido para todos?';
$string['privacy:metadata:block_exaportview:sharedemails'] = 'lista de Emails compartidos';
$string['privacy:metadata:block_exaportview:timemodified'] = 'última modificación';
$string['privacy:metadata:block_exaportview:userid'] = 'propietario de vista';
$string['privacy:metadata:core_files'] = 'ePortafolios exabis almacena archivos que han sido subidos por el usuario para formar parte de artefactos, entradas de resumen y comentarios';
$string['profilepicture'] = 'Imagen del perfil';
$string['project_description'] = 'el porqué detrás de este proyecto';
$string['project_process'] = 'Haciendo que suceda';
$string['project_result'] = 'Resultados y aprendizaje';
$string['publishedportfolios'] = 'Portafolios publicados';
$string['resume_badges'] = 'Insignias';
$string['resume_certif'] = 'Certificaciones, acreditaciones y distinciones';
$string['resume_certifdeleted'] = 'Certificación, acreditación o distinción eliminada';
$string['resume_certifsaved'] = 'Certificación, acreditación o distinción guardada';
$string['resume_collaps'] = 'Colapsar todo';
$string['resume_contribution'] = 'Contribución';
$string['resume_contributiondetails'] = 'Detalles de su contribución';
$string['resume_cover'] = 'Acerca de mi';
$string['resume_coversaved'] = 'Carátula guardada';
$string['resume_date'] = 'Fecha';
$string['resume_deletecertifconfirm'] = '¿Realmente quiere eliminar esta certificación, acreditación o distinción?';
$string['resume_deleteeduconfirm'] = '¿Realmente quiere eliminar esta educación?';
$string['resume_deleteemployconfirm'] = '¿Realmente quiere eliminar este empleo?';
$string['resume_deletelinkedinconfirm'] = '¿Realmente sesea eliminar esta membresía?';
$string['resume_deletembrshipconfirm'] = '¿Realmente quiere eliminar esta membresía?';
$string['resume_deletepublicconfirm'] = '¿Realmente quiere eliminar este libro o publicación?';
$string['resume_description'] = 'descripción';
$string['resume_edu'] = 'Educación';
$string['resume_edudeleted'] = 'Educación eliminada';
$string['resume_eduhistory'] = 'Historia educativa';
$string['resume_edusaved'] = 'Educación guardada';
$string['resume_employ'] = 'Empleo';
$string['resume_employdeleted'] = 'Empleo eliminado';
$string['resume_employer'] = 'Empleador';
$string['resume_employeraddress'] = 'Dirección del empleador';
$string['resume_employhistory'] = 'Historia de empleo';
$string['resume_employsaved'] = 'Empleo guardado';
$string['resume_enddate'] = 'Fecha final';
$string['resume_expand'] = 'Expander todo';
$string['resume_exportto_europass'] = 'Exportar a Europass';
$string['resume_exportto_europass_getXML'] = 'Descargar XML';
$string['resume_exportto_europass_intro'] = '<p>El perfil Europass puede ayudar a las personas a planificar su aprendizaje y desarrollo profesional. El perfil puede ser utilizado por organizaciones (empleadores, organizaciones de voluntarios, reclutadores, profesionales de orientación, organizaciones juveniles, instituciones de educación y formación, etc.) como parte del apoyo y los servicios que ofrecen a las personas.</p>
<p>Ofrecemos una forma de utilizar su CV de Exabis eProtfolio en el perfil Europass<br>
El archivo XML generado debe insertarse en la página <a href="https://europa.eu/europass/eportfolio/screen/cv-editor?lang=es" target="_blank">Crear su CV</a><br>
(es mejor iniciar sesión en Europass previamente)<br>
Pulse el botón "Importar CV Europass" y cargue el archivo XML que generará el botón de abajo
</p>

Algunas notas:<br>
<ul>
<li>Definitivamente debe verificar el CV resultante</li>
<li>Sus datos personales se tomarán de su cuenta Moodle</li>
<li>Verifique todas las fechas, teléfonos, direcciones</li>
<li>Las imágenes de los editores HTML no se exportarán</li>
<li>La mayoría de los textos de los editores HTML deben ser reformateados</li>
<li>Los archivos adjuntos no están implementados en la nueva versión de Europass, por lo que no se importarán</li>
</ul>';
$string['resume_files'] = 'Anexos';
$string['resume_goals'] = 'Objetivos';
$string['resume_goalsacademic'] = 'Objetivos académicos';
$string['resume_goalsacademicsaved'] = 'Objetivos académicos guardados';
$string['resume_goalscareers'] = 'Objetivos de carrera';
$string['resume_goalscareerssaved'] = 'Objetivos de carrera guardados';
$string['resume_goalscomp'] = 'Estándares educativos';
$string['resume_goalspersonal'] = 'Objetivos personales';
$string['resume_goalspersonalsaved'] = 'Objetivos personales guardados';
$string['resume_institution'] = 'Institución';
$string['resume_institutionaddress'] = 'Dirección de la institución';
$string['resume_interests'] = 'Intereses';
$string['resume_interestssaved'] = 'Intereses guardados';
$string['resume_jobtitle'] = 'título del trabajo';
$string['resume_linkedin'] = 'Perfil de Linkedln';
$string['resume_linkedindeleted'] = 'Perfil de Linkedln eliminado';
$string['resume_linkedinsaved'] = 'Perfil de Linkedln guardado';
$string['resume_mbrship'] = 'Membresías';
$string['resume_mbrshipdeleted'] = 'Membresía eliminada';
$string['resume_mbrshipsaved'] = 'Membresía guardada';
$string['resume_my'] = 'Mi Curriculum Vitae';
$string['resume_mygoals'] = 'Mis objetivos';
$string['resume_myskills'] = 'Mis habilidades';
$string['resume_position'] = 'Posición';
$string['resume_positiondescription'] = 'Descripción de la posición';
$string['resume_public'] = 'Libros y publicaciones';
$string['resume_publicdeleted'] = 'Libro o publicación eliminado';
$string['resume_publicsaved'] = 'Libro o publicación guardado';
$string['resume_qualdescription'] = 'Descripción de la calificación';
$string['resume_qualification'] = 'Calificación';
$string['resume_qualname'] = 'Nombre de la Calificación';
$string['resume_qualtype'] = 'Tipo de la Calificación';
$string['resume_skills'] = 'Habilidades';
$string['resume_skillsacademic'] = 'Habilidades académicas';
$string['resume_skillsacademicsaved'] = 'Habilidades académicas guardadas';
$string['resume_skillscareers'] = 'Habilidades de carrera';
$string['resume_skillscareerssaved'] = 'Habilidades de carrera guardadas';
$string['resume_skillscomp'] = '<Estándares educativos';
$string['resume_skillspersonal'] = 'Habilidades personales';
$string['resume_skillspersonalsaved'] = 'Habilidades personales guardadas';
$string['resume_startdate'] = 'Fecha de inicio';
$string['resume_template_newresume'] = '<h2>Mi nuevo Curriculum Vitae</h2>';
$string['resume_title'] = 'Título';
$string['resume_url'] = 'URL';
$string['role'] = 'Rol';
$string['root_category'] = 'Categoría Raíz';
$string['saveButton'] = 'Guardar';
$string['saveitem'] = 'Guardar';
$string['scormhastobezip'] = 'El Archivo-SCORM debe ser un archivo-.ZIP';
$string['searchByTitle'] = 'Buscar';
$string['selectall'] = 'Seleccionar Todos';
$string['selectcomps'] = '¡Elegir competencias asociadas con su subida!';
$string['selected_competencies'] = 'Competencia Lograda';
$string['selectitems'] = 'Seleccionar ítems';
$string['settings_allow_loginas_body'] = '';
$string['settings_allow_loginas_head'] = 'Permitir entrar-como';
$string['settings_create_desp_categories_body'] = '';
$string['settings_create_desp_categories_head'] = 'Crear Categorías Desp';
$string['settings_disable_externaccess_body'] = '';
$string['settings_disable_externaccess_head'] = 'Deshabilitar Opción-Compartir "Acceso externo" para vistas';
$string['settings_disable_external_comments_body'] = '';
$string['settings_disable_external_comments_head'] = 'Deshabilitar el compartir comentarios en vista externa';
$string['settings_disable_shareall_body'] = 'Elija <a href="{$a}">aquí</a>, para remover todas las comparticiones globales';
$string['settings_disable_shareall_head'] = 'Deshabilitar compartir con todos los usuarios';
$string['settings_disable_shareemails_body'] = '';
$string['settings_disable_shareemails_head'] = 'Deshabilitar Opción-Compartir "Compartir por Email" para vistas';
$string['settings_interaktion_exacomp_body'] = 'Interacción con el bloque de Rejilla de Competencia Exabis, en caso de estar instalado';
$string['settings_interaktion_exacomp_head'] = 'Interacción entre Rejilla de Competencia Exabis y exabis ePortafolio';
$string['settings_layout_settings_description'] = 'Aquí usted puede cambiar algunas opciones de diseño de vista o puede usar sus propias reglas CSS personalizadas para tener la vista que desea<br>Estas configuraciones serán usadas como configuraciones predeterminadas<strong>para todas las vistas</strong>';
$string['settings_layout_settings_heading'] = 'Configuraciones del diseño';
$string['share'] = 'Compartir';
$string['share_to_other_users'] = 'Buscar Usuarios';
$string['shareallexceptthose'] = 'Acceso para <span class=\'block_eportfolio_bold\'>todos</span> (aún aquellos que no estuvieran enlistados aquí) excepto para los siguientes usuarios';
$string['sharedArtefacts'] = 'Agrupar portafolios compartidos con Usted';
$string['shared_categories'] = 'Categorías Compartidas';
$string['shared_views'] = 'Vistas Compartidas';
$string['shareditems_category'] = 'Agrupar portafolios compartidos con Usted';
$string['sharedpersons'] = 'Personas con Portafolios compartidos';
$string['sharedwith'] = 'Compartido con';
$string['sharedwith_group'] = 'Compartido con mi grupo';
$string['sharedwith_group_cnt'] = 'Compartido con {$a} grupos';
$string['sharedwith_onlyme'] = 'Compartido solamente conmigo';
$string['sharedwith_shareall'] = 'Compartido con todos los usuarios';
$string['sharedwith_shareexternal'] = 'Compartido externo';
$string['sharedwith_user_cnt'] = 'Compartida con {$a} usuarios';
$string['sharejs'] = 'compartir';
$string['sharenoneexceptthose'] = 'Acceso para <span class=\'block_eportfolio_bold\'>nadie</span> excepto los siguientes usuarios';
$string['sharetoteacher'] = 'Compartirlo con todos los profesor en este curso';
$string['shortdescription'] = 'Descripción breve';
$string['show'] = 'Mostrar';
$string['show_mystudents'] = 'Mis estudiantes';
$string['show_sharedbyuser'] = 'Compartido por usuarios';
$string['showall'] = 'Mostrar también Otros Cursos';
$string['showallusers'] = 'Mostrar usuarios de todos mis cursos';
$string['showcourse'] = 'Mostrar Solamente Este Curso';
$string['showcourseusers'] = 'Mostrar solamente usuarios del curso';
$string['showsummary'] = '(mostrar resumen)';
$string['steckbrief'] = 'Perfil';
$string['strshare'] = 'Compartir';
$string['strunshare'] = 'Des-compartir';
$string['studentcomps'] = 'Aquí puede auto-evaluar si es que Usted ha adquirido la competencia con su artefacto.';
$string['subcategory'] = 'Sub categoría';
$string['submititem'] = 'Enviar';
$string['success'] = '¡Archivo importado exitosamente!';
$string['summary'] = 'Resumen (opcional)';
$string['supported'] = 'soportado por';
$string['tagarea_block_exaportitem'] = 'Mis Artefactos del Portafolio';
$string['teachercomps'] = 'Aquí puede Usted evaluar si es que sus estudiantes han adquirido la competencia con este artefacto.';
$string['thiscourse'] = 'Este curso';
$string['tiles'] = 'Mosaicos';
$string['title'] = 'Título';
$string['titlenotemtpy'] = 'Usted debe escribir un título';
$string['translation:email'] = 'gvalero@unam.mx';
$string['translation:language'] = 'Español de México';
$string['translation:organisation'] = 'U.N.A.M.';
$string['translation:person'] = 'Germán Valero';
$string['type'] = 'Tipo';
$string['unknownaction'] = 'Acción desconocida';
$string['updateposterror'] = 'Hubo un error al actualizar esta publicación en la base de datos';
$string['updownarrow'] = 'flecha hacia arriba';
$string['uploadfailed'] = 'Falló subida.';
$string['url'] = 'URL';
$string['urlnotempty'] = 'Usted debe escribir una URL';
$string['userdefinedsort'] = 'Defina su propia búsqueda';
$string['view'] = 'Vista';
$string['view_preview_help'] = 'Vista previa de su vista';
$string['view_preview_help_title'] = 'Vista previa';
$string['view_saved'] = 'Vista guardada';
$string['view_sharing'] = 'Compartiendo';
$string['view_sharing_noaccess'] = 'Sin Acceso';
$string['view_sharing_updated'] = 'Ver compartición actualizada';
$string['view_specialitem_badge'] = 'Insignia';
$string['view_specialitem_headline'] = 'Encabezado';
$string['view_specialitem_headline_defaulttext'] = 'Escriba Aquí el Ecabezado';
$string['view_specialitem_media'] = 'Medio';
$string['view_specialitem_personal'] = 'Información personal';
$string['view_specialitem_text'] = 'Texto';
$string['view_specialitem_text_defaulttext'] = 'Escriba Texto Aquí';
$string['view_specialitem_text_help'] = 'El bloque con textopersonalizado. Uste dpuede formatear el texto como lo necesite';
$string['view_specialitems'] = 'Items Especiales';
$string['viewand'] = 'y';
$string['viewcategories'] = 'gestionar categorías';
$string['viewcontent'] = 'Contenido';
$string['viewdescription'] = 'descripción';
$string['viewdesign'] = 'Ver Diseño';
$string['viewinformation'] = 'Ver información';
$string['viewitem'] = 'Item';
$string['viewitems'] = 'Sus Items';
$string['viewlayout'] = 'Diseño';
$string['viewlayout1'] = 'Anchuras iguales';
$string['viewlayout10'] = 'Anchuras iguales';
$string['viewlayout2'] = 'Anchuras iguales';
$string['viewlayout3'] = 'Columna izquierda más grande';
$string['viewlayout4'] = 'Columna derecha más grande';
$string['viewlayout5'] = 'Anchuras iguales';
$string['viewlayout6'] = 'Columna central más grande';
$string['viewlayout7'] = 'Columna central mucho más grande';
$string['viewlayout8'] = 'Anchuras iguales';
$string['viewlayout9'] = 'Columnas centrales más grande';
$string['viewlayoutgroup1'] = '1 columna';
$string['viewlayoutgroup2'] = '2 columnas';
$string['viewlayoutgroup3'] = '3 columnas';
$string['viewlayoutgroup4'] = '4 columnas';
$string['viewlayoutgroup5'] = '5 columnas';
$string['viewnotfound'] = 'Vista no encontrada';
$string['views'] = 'Mis Vistas';
$string['viewshare'] = 'Compartir';
$string['viewtitle'] = 'Título y descripción';
$string['what_is_embed_code_content'] = 'El código de inserción es un código generado por un sitio web de terceros, como YouTube o Twitter, que un usuario puede copiar y pegar en su propia página web. Este código incrustado mostrará entonces el mismo medio, aplicación o fuente en la página web del usuario como lo hace en la fuente original.</p>
<p>Ofrecemos instrucciones para los proveedores de videos más populares, como YouTube o Vimeo.</p>
<p><strong>Cómo encontrar el código de incrustación en YouTube:</strong></p>
<ol>
<li>Vaya a YouTube</a>.</li>
<li>Navegue hasta el video que desea incrustar.</li>
<li>Haga clic en el <strong>enlace para compartir</strong> debajo del video y luego haga clic en el <strong>enlace para incrustar</strong>.</li>
<li>Presione el botón <strong>Copiar</strong> en el pie de página de la ventana abierta.</li>
<li>El enlace para incrustar se resaltará en azul y se copiará al portapapeles.</li>
<li>Pegue el código en el campo de área de texto de exabis E-portfolio.</li>
</ol>
<p><strong>Cómo encontrar el código de incrustación en Vimeo:</strong></p>
<ol>
<li>Vaya a Vimeo.</li>
<li>Navegue hasta el video que desea insertar.</li>
<li>Haga clic en el botón <strong>Compartir</strong>, en la esquina superior derecha de su video.</li>
<li>Aparecerá una ventana emergente con la información del enlace para insertar. Deberá copiar solo la parte <strong>&lt;<i>iframe</i>&gt;</strong> del enlace para insertar.
Ejemplo:<br>
<ol>
<li>
El enlace para insertar completo muestra lo siguiente:<br>
<textarea disabled=\'true\' style=\'border: none;background-color:white;width:100%;font-size:0.75em;\'>&lt;iframe src=&quote;https://player.vimeo.com/video/1233456789&quote; width=&quote;640&quote; height=&quote;360&quote; frameborder=&quote;0&quote; allow=&quote;autoplay; fullscreen&quote; allowfullscreen&gt;&lt;/iframe&gt;&lt;p&gt;&lt;a href=&quote;https://vimeo.com/1233456789&quote;&gt;1- Apertura de automatización[2]&lt;/a&gt; desde &lt;a href=&quote;https://vimeo.com/user98765432&quote;&gt;R1 Marketing&lt;/a&gt; en &lt;a href=&quote;https://vimeo.com&quote;&gt;Vimeo&lt;/a&gt;.&lt;/p&gt;</textarea>
</li>
<li>
Solo necesitas copiar la parte <strong>&lt;<i>iframe</i>&gt;</strong>:<br>
<textarea disabled=\'true\' style=\'border: none;background-color:white;width:100%;font-size:0.75em;\'>&lt;iframe src=&quote;https://player.vimeo.com/video/1233456789&quote; width=&quote;640&quote; height=&quote;360&quote; frameborder=&quote;0&quote; allow=&quote;autoplay; fullscreen&quote; allowfullscreen&gt;&lt;/iframe&gt;</textarea>
</li>
</ol>
<li>Pegue este código en el campo de área de texto de E-portafolio de Exabis.</li>
</ol>';
$string['what_is_embed_code_title'] = '¿Qué es incrustar código?';
$string['whyEportfolio'] = 'Porqué ePortafolios';
$string['whyEportfolio_description'] = '<h4>No deje que su arduo trabajo desaparezca: cree su portafolio digital</h4>
<br>
<p>Imagine todo el esfuerzo que pones en tareas, presentaciones y proyectos. ¿Alguna vez siente que todo queda enterrado en un cajón después de enviarlo?</p>
<p>Pero aquí tiene la buena noticia: esos proyectos son <strong>prueba de sus habilidades y conocimientos</strong>, ¡y puede usarlos para impresionar a posibles empleadores o clientes!</p>
<p><strong>Cree su portafolio digital</strong> y muestre su mejor trabajo, desde presentaciones, tareas y proyectos hasta videos. ¡Es más fácil de lo que cree!</p>
<br>
<h4>¿Qué es un portafolio electrónico?</h4>
<br>
<p>Un <strong>portafolio electrónico</strong> es una <strong>colección digital</strong> que muestra tus <strong>habilidades, conocimientos y experiencias</strong>. Si bien su CV se centra en su formación y experiencia laboral, su ePortfolio va más allá de eso, ya que proporciona <strong>pruebas y contexto</strong> de sus habilidades.
Le permite mostrar sus muestras de trabajo y <strong>demostrar su talento</strong> de manera rápida y eficaz.
En definitiva, su ePortfolio es una herramienta poderosa para <strong>resaltar sus cualificaciones</strong> y diferenciarse.
</p>
<p><strong>Recuerde que diferentes puestos pueden requerir diferentes tipos de ePortfolios.</strong>
Sin embargo, algunos elementos clave permanecen constantes.
<strong>Exabis ePortfolio</strong> le permite <strong>crear múltiples vistas</strong> adaptadas a puestos específicos, oportunidades laborales u otros fines.
</p>
<br>
<h4>Cómo crear su ePortfolio</h4>
<br>
<ol>
<li><strong>Reúna su trabajo:</strong> comience por revisar todos sus proyectos, presentaciones y tareas.</li>
<li><strong>Elija su mejor trabajo:</strong> seleccione las piezas que muestren sus habilidades más sólidas y aquellas que hayan recibido comentarios positivos.</li>
<li><strong>Reflexione y describa:</strong> piense en las habilidades y competencias que demuestra cada pieza. Escriba una breve descripción para brindar contexto.</li>
<li><strong>Construya y repita:</strong> no tenga miedo de experimentar y refinar su ePortfolio a medida que aprende y crece.</li>
</ol>
<p><strong>Exabis ePortfolio</strong> puede guiarlo en cada paso, haciendo que el proceso de creación de su ePortfolio sea sencillo y eficiente.</p>';
$string['width'] = 'Ancho';
$string['wrongfileid'] = 'ID de archivo equivocada';
$string['wrongfilepostid'] = 'ID de archivo equivocada';
$string['wronglinkid'] = 'ID de liga equivocada';
$string['wrongnoteid'] = 'ID de nota equivocada';
$string['wrongnotepostid'] = 'Postbid de nota equivocado';
