<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'reservation', language 'pl', version '4.5'.
 *
 * @package     reservation
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addparticipant'] = 'Dodaj zgłoszenie';
$string['after10min'] = 'Po 10 minutach od rozpoczęcia zdarzenia';
$string['after12h'] = 'Po 12 godzinach od rozpoczęcia zdarzenia';
$string['after1d'] = 'Po 1 dniu od rozpoczęcia zdarzenia';
$string['after1h'] = 'Po 1 godzinie od rozpoczęcia zdarzenia';
$string['after1w'] = 'Po 1 tygodniu od rozpoczęcia zdarzenia';
$string['after2d'] = 'Po 2 dniach od rozpoczęcia zdarzenia';
$string['after2h'] = 'Po 2 godzinach od rozpoczęcia zdarzenia';
$string['after2w'] = 'Po 2 tygodniach od rozpoczęcia zdarzenia';
$string['after30min'] = 'Po 30 minutach od rozpoczęcia zdarzenia';
$string['after3w'] = 'Po 3 tygodniach od rozpoczęcia zdarzenia';
$string['after4h'] = 'Po 4 godzinach od rozpoczęcia zdarzenia';
$string['after4w'] = 'Po 4 tygodniach od rozpoczęcia zdarzenia';
$string['after5min'] = 'Po 5 minutach od rozpoczęcia zdarzenia';
$string['after6h'] = 'Po 6 godzinach od rozpoczęcia zdarzenia';
$string['alreadybooked'] = 'Masz już rezerwację';
$string['alreadyoverbooked'] = 'Jesteś już na liście rezerwowej';
$string['atstart'] = 'Po rozpoczęciu zdarzenia';
$string['autohide'] = 'Automatyczne ukrywanie dla listy rezerwacji';
$string['availablerequests'] = 'Wolne miejsca';
$string['badcourse'] = 'Kurs nie istnieje';
$string['badparent'] = 'Ta rezerwacja była połączona z inną rezerwacją, które nie została teraz odtworzona. Połączenie to zostało usunięte. Jeśli potrzeba, proszę ponownie połączyć rezerwacje ręcznie.';
$string['badsection'] = 'Nie odnaleziono sekcji w kursie "{$a}"';
$string['badteachers'] = 'Podany adres e-mail nauczyciela ({$a}) nie został odnaleziony';
$string['badteachersmail'] = 'Podany adres e-mail nauczyciela ({$a}) jest niewłaściwy';
$string['badtimeclose'] = 'niewłaściwy czas (timeclose)';
$string['badtimeend'] = 'niewłaściwy czas (timeend)';
$string['badtimeopen'] = 'niewłaściwy czas (timeopen)';
$string['badtimestart'] = 'niewłaściwy czas (timestart)';
$string['by'] = 'przez';
$string['bydate'] = 'Data zdarzenia';
$string['byname'] = 'Nazwa';
$string['bysection'] = 'Temat/Tydzień';
$string['cancelledon'] = 'Odwołana w dniu';
$string['cancellersmail'] = 'Rezerwacja w \'{$a->reservation}\' została odwołana.';
$string['cancellersmailhtml'] = 'Rezerwacja w <em>{$a->reservation}</em> została odwołana.';
$string['checkclashes'] = 'Sprawdź konflikty miejsc i czasu';
$string['clashesfound'] = 'Znaleziono konflikty miejsc i czasu';
$string['clashesreport'] = 'Raport konfliktów';
$string['cleanview'] = 'Tylko aktualne rezerwacje';
$string['close'] = 'Zamknij';
$string['closed'] = 'Zamknięte';
$string['completionreserved'] = 'Student musi dokonać rezerwacji, aby ukończyć tę aktywność.';
$string['config'] = 'Globalne ustawienia modułu Rezerwacja';
$string['configautohide'] = 'Określa kiedy rezerwacje mają być ukrywane w liście rezerwacji (mod/reservation/index.php). Może być to przydatne w połączeniu z publicznymi listami, aby bardziej przejrzyjście pokazywać listę.';
$string['configcheckclashes'] = 'Włącz przycisk "Sprawdź konflikty miejsc i czasu" na stronie edycji rezerwacji';
$string['configconnectto'] = 'Określa gdzie będą poszukiwane rezerwacje do których można będzie łączyć inne';
$string['configdownload'] = 'Określa domyślny format dla pobieranych pliów zawierających listy rezerwacji i zgłoszeń.';
$string['configevents'] = 'To ustawienie określa jakie wydarzenia będą tworzone dla każdej rezerwacji';
$string['configfields'] = 'Określa które pola będą widoczne w tabeli rezerwacji.';
$string['configlocations'] = 'Na tej stronie można zarządzać standardowymi lokalizacjami rezerwacji dla tego portalu Moodle';
$string['configmanualusers'] = 'Określa listę użytkowników pokazywaną w rozwijanym menu używanym przy ręcznym zgłaszaniu użytkowników.';
$string['configmaxoverbook'] = 'Określa maksymalny procent nadwyżki limitu ilości zgłoszeń dla rezerwacji.';
$string['configmaxrequests'] = 'Określa limit ilości zgłoszeń dla rozwijanego menu na stronie edycji rezerwacji.';
$string['configminduration'] = 'Określa minimalną długość trwania zdarzenia. Jest używane do sprawdzania dostępności czasu i  miejsca dla niezakończonych zdarzeń.';
$string['confignotifies'] = 'To ustawienie określa jakie powiadomienia muszą być wysyłane';
$string['configoverbookstep'] = 'Określa ziarnistość nadwyżki limitów zgłoszeń dla rezerwacji. Mniejszy krok daje większą ziarnistość.';
$string['configpubliclists'] = 'Określa czy listy rezerwacji są publiczne (widoczne bez zalogowania), czy też nie.';
$string['configsortby'] = 'Określa sposób sortowania list rezerwacji.';
$string['configsublimits'] = 'Określa ilość wierszy dla reguł podlimitów na stronie edycji rezerwacji.';
$string['configupload'] = 'Utworzenie wielu rezerwacji przez przesłanie ich w pliku tekstowym';
$string['confirmdelete'] = 'Czy na pewno usunąć wybrane zgłoszenia rezerwacji?';
$string['connectedto'] = 'Rezerwacja połączona z';
$string['connectto'] = 'Źródło łączenia rezerwacji';
$string['crontask'] = 'Wyślij powiadomienia o zgłoszeniach rezerwacji i żądaniach oceny';
$string['description'] = 'Opis';
$string['downloadas'] = 'Domyślny format pobierania';
$string['duration10h'] = '10 godzin';
$string['duration10min'] = '10 minut';
$string['duration11h'] = '11 godzin';
$string['duration12h'] = '12 godzin';
$string['duration15min'] = '15 minut';
$string['duration20min'] = '20 minut';
$string['duration2h'] = '2 godziny';
$string['duration30min'] = '30 minut';
$string['duration3h'] = '3 godziny';
$string['duration45min'] = '45 minut';
$string['duration4h'] = '4 godziny';
$string['duration5h'] = '5 godziny';
$string['duration5min'] = '5 minut';
$string['duration60min'] = '60 minut';
$string['duration6h'] = '6 godzin';
$string['duration7h'] = '7 godzin';
$string['duration8h'] = '8 godzin';
$string['duration90min'] = '90 minut';
$string['duration9h'] = '9 godzin';
$string['enablenote'] = 'Włącz uwagi użytkowników';
$string['equal'] = 'równe';
$string['err_notimestart'] = 'Data rozpoczęcia zdarzenia nie jest ustawiona';
$string['err_sublimitsgreater'] = 'Suma podlimitów przekracza maksymalną ilość zgłoszeń';
$string['err_timeendlower'] = 'Data zakończenia zdarzenia jest wcześniejsza niż data jego rozpoczęcia';
$string['err_timeopengreater'] = 'Data rozpoczęcia zdarzenia jest późniejsza niż data jego zakończenia';
$string['eventevent'] = 'Utwórz wydarzenie z datami od początku do końca (zdarzenia)';
$string['eventreminder'] = '{$a} (rezerwacja)';
$string['eventrequestadded'] = 'Zgłoszenie rezerwacji dodane';
$string['eventrequestcancelled'] = 'Zgłoszenie rezerwacji anulowane';
$string['eventrequestdeleted'] = 'Zgłoszenie rezerwacji usunięte';
$string['events'] = 'Wydarzenia w kalendarzu';
$string['eventsettings'] = 'Ustawienia zdarzenia';
$string['explainconfig'] = 'Administratorzy mogą tu określać globalne ustawienia dla modułu Rezerwacja';
$string['fields'] = 'Widoczne pola';
$string['fullview'] = 'Włącznie z usuniętymi rezerwacjami';
$string['grade'] = 'Ocena';
$string['gradedmail'] = '{$a->teacher} przesłał informację zwrotną do Twojego
zgłoszenia rezerwacji \'{$a->reservation}\'

Informację zwrotną znajdziesz tutaj:

    {$a->url}';
$string['gradedmailhtml'] = '{$a->teacher} przesłał informację zwrotną do Twojego
zgłoszenia rezerwacji \'<i>{$a->reservation}</i>\'<br /><br />
Informację zwrotną znajdziesz <a href=\\"{$a->url}\\">tutaj</a>.';
$string['importreservations'] = 'Import rezerwacji';
$string['invalidreservationid'] = 'Niewłaściwy ID rezerwacji';
$string['justbooked'] = 'Masz rezerwację jako: {$a}';
$string['justoverbooked'] = 'Jesteś na liście rezerwowej jako: {$a}';
$string['linenumber'] = '#';
$string['listafterclose'] = 'listę zgłoszeń rezerwacji po zamknięciu rezerwacji';
$string['listalways'] = 'listę zgłoszeń rezerwacji w dowolnym czasie';
$string['location'] = 'Lokalizacja';
$string['locations'] = 'Zarządzaj lokalizacjami';
$string['locationslist'] = 'Lista lokalizacji';
$string['mail'] = 'Rezerwacje do \'{$a->reservation}\' zostały zamknięte.

Możesz pobrać listę zgłoszeń z adresu:

    {$a->url}';
$string['mailhtml'] = 'Rezerwacje do <em>{$a->reservation}</em> zostały zamknięte.<br /><br />
Możesz pobrać listę zgłoszeń z <a href="{$a->url}">tego adresu</a>.';
$string['mailrequest'] = 'Rezerwacje do \'{$a->reservation}\' zostały zamknięte.

Możesz sprawdzić numer zgłoszenia pod adresem:

    {$a->url}';
$string['mailrequesthtml'] = 'Rezerwacje do <em>{$a->reservation}</em> zostały zamknięte.<br /><br />
Możesz sprawdzić numer zgłoszenia pod <a href="{$a->url}">tym adresem</a>.';
$string['manage'] = 'Zarządzanie';
$string['manualusers'] = 'Lista użytkowników przy ręcznym zgłaszaniu';
$string['maxoverbook'] = 'Maksymalny procent nadwyżki';
$string['maxrequest'] = 'Maksymalna ilość zgłoszeń';
$string['message'] = 'Wiadomość dla uczestników';
$string['minduration'] = 'Minimalna długość zdarzenia';
$string['modulename'] = 'Rezerwacja';
$string['modulename_help'] = '<p>Głównym celem tej aktywności jest rezerwowanie terminów zajęć laboratoryjnych i egzaminów, ale można jej używać także do innych rezerwacji.</p><p>Nauczyciel może określić liczbę miejsc dostępnych dla zdarzenia, daty zdarzenia, oraz daty otwarcia i zamknięcia rezerwacji.<br />Rezerwacja może mieć ocenę punktową lub skalę.<br />Studenci mogą zarezerwować i anulować rezerwację miejsca, oraz dodać uwagę przy swoim zgłoszeniu rezerwacji.</p><p>Po rozpoczęciu zdarzenia nauczyciel może oceniać każde zgłoszenie rezerwacji. Studenci będą powiadomieni pocztą.</p><p>Lista rezerwacji może być pobrana w różnych formatach.</p>';
$string['modulenameplural'] = 'Rezerwacje';
$string['newlocation'] = 'Nowa lokalizacja';
$string['noclashcheck'] = 'Sprawdzanie konfliktów nie jest włączone. Zwróć się z tym do administratora.';
$string['noclashes'] = 'Nie znaleziono konfliktów miejsc i czasu';
$string['nocourseswithnsections'] = 'Nie odnaleziono kursu z {$a} sekcjami';
$string['nolimit'] = 'Bez limitu zgłoszeń';
$string['nomorerequest'] = 'Brak wolnych miejsc';
$string['none'] = 'bez informacji dotyczącej kolejności rezerwacji';
$string['nooverbook'] = 'Bez nadwyżki limitu zgłoszeń';
$string['noparent'] = 'Brak';
$string['noreservations'] = 'Brak rezerwacji';
$string['note'] = 'Uwagi';
$string['noteachers'] = 'Brak dostępnych nauczycieli';
$string['notequal'] = 'różne od';
$string['noterequired'] = 'Uwagi wymagane, proszę wpisać tutaj przed dokonaniem rezerwacji.';
$string['notgraded'] = 'Nie ocenione';
$string['notifies'] = 'Wysyłane powiadomienia';
$string['notifycancellers'] = 'Powiadomienia osób anulujących rezerwację o pomyślnym anulowaniu';
$string['notifygrades'] = 'Powiadomienia o ocenie rezerwacji do studentów';
$string['notifyoverbookers'] = 'Powiadomienia osób na liście rezerwowej o wejściu na listę główną';
$string['notifyreservers'] = 'Powiadomienia osób rezerwujących o pomyślnej rezerwacji';
$string['notifystudents'] = 'Powiadomienia o zakończeniu czasu rezerwacji do studentów';
$string['notifyteachers'] = 'Powiadomienia o zakończeniu czasu rezerwacji do nauczycieli';
$string['notopened'] = 'Nie otwarte';
$string['notreserved'] = 'Nie zarezerwowane';
$string['novalues'] = 'Brak dostępnych wartości dla tego pola';
$string['number'] = 'Numer rezerwacji';
$string['numberafterclose'] = 'numer swojego zgłoszenia rezerwacji po zamknięciu rezerwacji';
$string['numberalways'] = 'numer swojego zgłoszenia rezerwacji w dowolnym czasie';
$string['optional'] = 'Opcjonalne';
$string['otherlocation'] = 'Podana inna lokalizacja';
$string['overbook'] = 'Nadwyżka limitu zgłoszeń';
$string['overbookonly'] = 'Dostępne tyko miejsca z nadwyżki';
$string['overbookstep'] = 'Krok nadwyżki limitu zgłoszeń';
$string['overview'] = 'Przegląd';
$string['parent'] = 'Połącz rezerwację z';
$string['pluginadministration'] = 'Administracja rezerwacją';
$string['pluginname'] = 'Rezerwacja';
$string['privacy:metadata:reservation_note'] = 'Zapisywanie uwag użytkownika do zgłoszenia rezerwacji';
$string['privacy:metadata:reservation_note:note'] = 'Uwagi użytkownika do zgłoszenia rezerwacji';
$string['privacy:metadata:reservation_request'] = 'Zapisywanie danych użytkownika zgłaszającego rezerwację';
$string['privacy:metadata:reservation_request:grade'] = 'Ocena zgłoszenia rezerwacji';
$string['privacy:metadata:reservation_request:grader'] = 'ID oceniającego';
$string['privacy:metadata:reservation_request:mailed'] = 'Status wysyłki powiadomienia mailem o ocenie';
$string['privacy:metadata:reservation_request:reservationid'] = 'ID rezerwacji';
$string['privacy:metadata:reservation_request:timecancelled'] = 'Data i czas anulowania zgłoszenia';
$string['privacy:metadata:reservation_request:timecreated'] = 'Data i czas utworzenia zgłoszenia';
$string['privacy:metadata:reservation_request:timegraded'] = 'Data i czas oceny zgłoszenia rezerwacji';
$string['privacy:metadata:reservation_request:userid'] = 'ID użytkownika';
$string['publiclists'] = 'Publiczna lista rezerwacji';
$string['requestoverview'] = 'Przegląd zgłoszeń';
$string['requests'] = 'Zgłoszenia';
$string['required'] = 'Wymagane';
$string['reservation:addinstance'] = 'Dodawanie nowej rezerwacji';
$string['reservation:downloadrequests'] = 'Może pobierać listę zgłoszeń';
$string['reservation:grade'] = 'Może przypisać ocenę';
$string['reservation:manage'] = 'Może zarządzać rezerwacją';
$string['reservation:manualdelete'] = 'Może usuwać zgłoszenia innych użytkowników';
$string['reservation:manualreserve'] = 'Może wysyłać zgłoszenia w imieniu innych użytkowników';
$string['reservation:reserve'] = 'Może wysyłać własne zgłoszenia';
$string['reservation:uploadreservations'] = 'Może wgrywać rezerwacje';
$string['reservation:view'] = 'Może przeglądać rezerwacje';
$string['reservation:viewnote'] = 'Może przeglądać uwagi do zgłoszeń';
$string['reservation:viewrequest'] = 'Może przeglądac listę zgłoszeń';
$string['reservation_listing'] = 'Ustawienia strony głównej';
$string['reservation_other'] = 'Inne ustawienia';
$string['reservation_settings'] = 'Ustawienia rezerwacji';
$string['reservation_view'] = 'Ustawienia strony widoku';
$string['reservationcancelled'] = 'Rezerwacja odwołana';
$string['reservationclosed'] = 'Rezerwacja zamknięta';
$string['reservationdenied'] = 'Rezerwacje są niedostępne';
$string['reservationevent'] = 'Utwórz wydarzenie kursu z datami od otwarcia do zamknięcia (czas rezerwacji)';
$string['reservationnotopened'] = 'Rezerwacje nie są jeszcze otwarte';
$string['reservations'] = 'Rezerwacje';
$string['reservationsettings'] = 'Ustawienia rezerwacji';
$string['reserve'] = 'Rezerwuj';
$string['reservecancel'] = 'Anuluj rezerwację';
$string['reserved'] = 'Zarezerwowane';
$string['reservedon'] = 'Zarezerwowane w dniu';
$string['reservedonconnected'] = 'Masz już zgłoszenie w połączonej rezerwacji: {$a}';
$string['reserversmail'] = 'Masz zarezerwowane miejsce w rezerwacji \'{$a->reservation}\'.';
$string['reserversmailhtml'] = 'Masz zarezerwowane miejsce w rezerwacji <em>{$a->reservation}</em>.';
$string['resetreservation'] = 'Usuń wszystkie rezerwacje';
$string['save'] = 'Zapisz ocenę';
$string['search:activity'] = 'Rezerwacja - informacja o aktywności';
$string['selectvalue'] = 'Wybierz jedną z dostępnych wartości';
$string['showrequest'] = 'Użytkownicy mogą przeglądać listę zgłoszeń';
$string['showuserrequest'] = 'Użytkownicy mogą przeglądać';
$string['sortby'] = 'Sposób sortowania list rezerwacji';
$string['status'] = 'Status rezerwacji';
$string['sublimit'] = 'Podlimit {$a}';
$string['sublimitrules'] = 'Reguły podlimitów';
$string['sublimits'] = 'Podlimity rezerwacji';
$string['timeclose'] = 'Zamknięcie rezerwacji';
$string['timeend'] = 'Data zakończenia';
$string['timeopen'] = 'Otwarcie rezerwacji';
$string['timestart'] = 'Data rozpoczęcia';
$string['tools'] = 'Narzędzia rezerwacji';
$string['upload'] = 'Przesyłanie rezerwacji';
$string['upload_help'] = '<p>Rezerwacje mogą być importowane poprzez plik tekstowy. Jego format powinien być następujący:</p><ul><li>Każda linia zawiera jeden rekord</li><li>Każdy rekord jest serią danych rozdzielonych przecinkami (lub innymi znakami rozdzielającymi)</li><li>Pierwszy rekord zawiera listę nazw pól określających format reszty pliku</li><li>Wymagane nazwy pól to: section, name, timestart</li><li>Opcjonalne nazwy pól to: course, intro, teachers, timeend, maxgrade, timeopen, timeclose, maxrequest</li><li>Jeśli nie zostanie podany kurs, musi zostać wybrany po podglądzie</li></ul>';
$string['uploadreservations'] = 'Prześlij rezerwacje';
$string['uploadreservationspreview'] = 'Podgląd przesyłanych rezerwacji';
$string['uploadreservationsresult'] = 'Wynik przesyłania rezerwacji';
$string['useralreadybooked'] = 'Użytkownik ma już rezerwację';
$string['userevent'] = 'Utwórz wydarzenie użytkownika z datami od początku do końca (zdarzenia) po przyjęciu zgłoszenia rezerwacji';
$string['with'] = 'dla';
$string['withselected'] = 'Z zaznaczonymi...';
$string['yourgrade'] = 'Twoja ocena tej rezerwacji: {$a->grade}/{$a->maxgrade}';
$string['yournote'] = 'Twoje uwagi:';
$string['yourscale'] = 'Twoja ocena tej rezerwacji: {$a}';
