<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'glossary', language 'pl', version '4.5'.
 *
 * @package     glossary
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addcategory'] = 'Dodaj kategorię';
$string['addcomment'] = 'Dodaj komentarz';
$string['addentry'] = 'Dodaj pojęcie';
$string['addingcomment'] = 'Dodaj komentarz';
$string['addsingleentry'] = 'Dodaj wpis';
$string['alias'] = 'Słowo kluczowe';
$string['aliases'] = 'Słowa kluczowe';
$string['aliases_help'] = 'Słownik umożliwia zapisanie aliasu, czyli alternatywnej nazwy dla każdego terminu.

<b>Wprowadź aliasy w osobnych liniach</b> (nie używaj przecinków).

Alias może być używany jak alternatywna nazwa do hasła. Na przykład, jeżeli używacie w słowniku auto-linkowania, alias będzie używany (razem z głównym hasłem) jako link do tego pojęcia.';
$string['allcategories'] = 'Wszystkie kategorie';
$string['allentries'] = 'Wszystkie';
$string['allowcomments'] = 'Pozwól komentować wpisy';
$string['allowcomments_help'] = 'Gdy ta opcja zostanie włączona, wszyscy uczestnicy, którzy posiadający uprawnienia do tworzenia komentarzy, będą mogli dodać komentarze do pojęć w słowniku.';
$string['allowduplicatedentries'] = 'Pozwól na wielokrotne definiowanie tego samego pojęcia';
$string['allowduplicatedentries_help'] = 'Jeżeli włączysz tę funkcję, określony termin będzie mógł mieć wiele definicji.';
$string['allowprintview'] = 'Zezwalaj na wydruk podglądu';
$string['allowprintview_help'] = 'Jeśli ta opcja jest włączona, studenci otrzymują link do wersji drukowanej słownika. Link jest zawsze dostępny dla nauczycieli.';
$string['andmorenewentries'] = 'i {$a} nowych wpisów.';
$string['answer'] = 'Odpowiedź';
$string['approvaldisplayformat'] = 'Zatwierdzony format wyświetlania';
$string['approvaldisplayformat_help'] = 'Zatwierdzając pojęcia do słownika, możesz wybrać inny format wyświetlania';
$string['approve'] = 'Potwierdź';
$string['areaattachment'] = 'Załączniki';
$string['areaentry'] = 'Definicje';
$string['areyousuredelete'] = 'Czy na pewno chcesz usunąć ten wpis?';
$string['areyousuredeletecomment'] = 'Czy na pewno chcesz usunąć ten komentarz?';
$string['areyousureexport'] = 'Czy na pewno chcesz wyeksportować ten wpis do';
$string['ascending'] = 'rosnąco';
$string['attachment'] = 'Załącznik';
$string['attachment_help'] = 'Możesz opcjonalnie załączyć jeden lub więcej plików do wpisu w słowniku.';
$string['author'] = 'autor';
$string['authorview'] = 'Szukaj według autora';
$string['back'] = 'Powrót';
$string['cachedef_concepts'] = 'Łączenie pojęć';
$string['cantinsertcat'] = 'Nie można wstawić tej kategorii';
$string['cantinsertrec'] = 'Nie można wstawić rekordu';
$string['cantinsertrel'] = 'Nie można wstawić relacji kategoria-wpis';
$string['casesensitive'] = 'Ten wpis inaczej traktuje duże i małe litery';
$string['casesensitive_help'] = 'To ustawienie określa, czy podczas automatycznego łączenia z wpisem konieczne jest dokładne dopasowanie wielkich i małych liter.';
$string['cat'] = 'Kat.';
$string['categories'] = 'Kategorie';
$string['category'] = 'Kategoria';
$string['categorydeleted'] = 'Usunięta kategoria';
$string['categoryview'] = 'Szukaj według kategorii';
$string['changeto'] = 'Zmień na {$a}';
$string['cnfallowcomments'] = 'Określ, czy słownik pojęć domyślnie akceptuje komentarze.';
$string['cnfallowdupentries'] = 'Określ, czy słownik pojęć domyślnie pozwoli na podwójne definicje.';
$string['cnfapprovalstatus'] = 'Określ, czy wpis dokonany przez studenta będzie domyślnie zatwierdzany.';
$string['cnfcasesensitive'] = 'Określ, czy nowy wpis, który jest automatycznie linkowany, jest domyślnie wrażliwy na duże i małe litery.';
$string['cnfdefaulthook'] = 'Określ domyślne zaznaczenie, kiedy słownik będzie otwarty po raz pierwszy.';
$string['cnfdefaultmode'] = 'Wybierz domyślną ramkę, która się pojawi, gdy słownik pojęć będzie po raz pierwszy uruchomiony.';
$string['cnffullmatch'] = 'Określ, czy wpis, który jest automatycznie linkowany, ma dokładnie odpowiadać wyrazowi docelowemu.';
$string['cnflinkentry'] = 'Określ, czy wpis domyślnie powinien być automatycznie połączony z docelowym wyrazem.';
$string['cnflinkglossaries'] = 'Określ, czy słownik pojęć powinien być automatycznie łączony z innymi wpisami.';
$string['cnfrelatedview'] = 'Wybierz format wyświetlenia wpisów dla automatycznego łączenia pojęć i wyświetlenia wpisu';
$string['cnfshowgroup'] = 'Określ, czy przerwa powinna być widoczna czy nie';
$string['cnfsortkey'] = 'Wybierz domyślny klucz sortowania';
$string['cnfsortorder'] = 'Wybierz domyślny sposób sortowania';
$string['cnfstudentcanpost'] = 'Określ, czy studenci mogą wprowadzać nowe pojęcia.';
$string['cnftabs'] = 'Wybierz widoczne zakładki dla tego formatu słownika';
$string['comment'] = 'Komentarz';
$string['commentdeleted'] = 'Komentarz został usunięty.';
$string['comments'] = 'Komentarze';
$string['commentson'] = 'Komentarze na';
$string['commentupdated'] = 'Komentarz został uaktualniony';
$string['completiondetail:entries'] = 'Dodaj pojęcia: {$a}';
$string['completionentries'] = 'Dodaj wpisy';
$string['completionentriesdesc'] = 'Student musi utworzyć co najmniej {$a} wpisów';
$string['completionentriesgroup'] = 'Wymagaj wpisów';
$string['concept'] = 'Termin';
$string['concepts'] = 'Terminy';
$string['configenablerssfeeds'] = 'Umożliwia użycie kanałów RSS dla wszystkich słowników pojęć. Musisz jednak i tak włączyć obsługę kanałów dla każdego słownika.';
$string['current'] = 'Obecnie posortowane wg {$a}';
$string['currentglossary'] = 'Aktualny słownik pojęć';
$string['date'] = 'data';
$string['dateview'] = 'Szukaj według daty';
$string['defaultapproval'] = 'Automatycznie aprobuj wpisy definicji przez studentów';
$string['defaultapproval_help'] = 'W przypadku ustawienia wartości NIE, wpisy wymagają zatwierdzenia przez nauczyciela, zanim będą widoczne dla wszystkich.';
$string['defaulthook'] = 'Domyślny filtr*';
$string['defaultmode'] = 'Domyślny tryb';
$string['defaultsortkey'] = 'Domyślne sortowanie';
$string['defaultsortorder'] = 'Domyślny porządek sortowania';
$string['definition'] = 'Definicja';
$string['definitions'] = 'Definicje';
$string['deletecategory'] = 'Usuń kategorię';
$string['deleteentry'] = 'Usuń wpis';
$string['deleteentrya'] = 'Usuń wpis: {$a}';
$string['deletenotenrolled'] = 'Wpisy niezapisanych użytkowników';
$string['deletingcomment'] = 'Usuwanie komentarza';
$string['deletingnoneemptycategory'] = 'Usunięcie tej kategorii nie usunie pojęć należących do tej kategorii. Zostaną one oznaczone jako \'nieskategoryzowane\'.';
$string['descending'] = '(malejąco)';
$string['destination'] = 'Miejsce docelowe importowanych wpisów';
$string['destination_help'] = 'Wpisy można importować i dodawać do aktualnego lub do nowego słownika. Nowy słownik zostanie utworzony w oparciu o plik XML i importowane pojęcia.';
$string['disapprove'] = 'Cofnij zgodę';
$string['displayformat'] = 'Format wyświetlania';
$string['displayformat_help'] = '<P ALIGN=CENTER><B>Wygląd słownika</B></P>

<P>Ten parametr określa sposób w jaki definicje zostaną zaprezentowane w słowniku. Możliwe są następujące sposoby prezentacji:</p>
<blockquote>
<dl>
<dt><b>Prosty słownik</b>:</dt>
<dd>Przypomina klasyczny słownik. Autorzy nie są uwidocznieni a załączniki schowane są za linkami.</dd>
<dt><b>Ciągły</b>:</dt>
<dd>Pokazuje terminy jeden po drugim bez żadnych przerw oprócz edycyjnych ikon.</dd>
<dt><b>Pełen z autorami</b>:</dt>
<dd>Pokazuje terminy wraz z danymi autora w sposób podobny do forum. Załączniki schowane są za linkami.</dd>
<dt><b>Pełen bez autorów</b>:</dt>
<dd>Format podobny do poprzedniego z tym, że nie zawiera informacji o autorach.</dd>
<dt><b>Encyklopedia</b>:</dt>
<dd>Taki jak "Ciągły z autorami" ale załączniki są wyświetlone w tekście.</dd>
<dt><b>Często zadawane pytania (FAQ)</b>:</dt>
<dd>Użyteczny przy wyświetlaniu "Często zadawanych pytań (FAQ). Automatycznie kategoryzuje terminy definiowane i definicje jako pytania i odpowiedzi.</dd>
</dl>
</blockquote>

<hr>
<p>Administratorzy Moodle\'a mogą utworzyć nowe formy wyświetlenia słownika:
<ol>
<li> Sprawdź zawartość katalogu mod/glossary/formats .... Powinny tam być ponumerowane pliki odpowiadające dostępnym formatom słownika.
<li> Skopiuj jeden z tych plików i nadaj jemu nową nazwę tj. numer N (zwróć uwagę, że 0 i 1 są zarezerwowane).
<li> Dokonaj edycji tego pliku wg własnego uznania (musisz jednak trochę znać PHP).
<li> Następnie dopisz w każdym pakiecie językowym jakiego używasz <b>displayformatN</b>, i nadaj mu krótką ale logiczną nazwę.
</ol>';
$string['displayformatcontinuous'] = 'Ciągły bez autora';
$string['displayformatdefault'] = 'Domyślny(zgodny z ustawionym formatem wyświetlania)';
$string['displayformatdictionary'] = 'Prosty styl słownika';
$string['displayformatencyclopedia'] = 'Encyklopedia';
$string['displayformatentrylist'] = 'Lista wpisów';
$string['displayformatfaq'] = 'FAQ';
$string['displayformatfullwithauthor'] = 'Pełny z autorami';
$string['displayformatfullwithoutauthor'] = 'Pełny bez autorów';
$string['displayformats'] = 'Dostępne formaty wyglądu';
$string['displayformatssetup'] = 'Wyświetl ustawienia formatów wyświetlania';
$string['duplicatecategory'] = 'Duplikuj kategorie';
$string['duplicateentry'] = 'Podwójne definicje';
$string['editalways'] = 'Zawsze można edytować';
$string['editalways_help'] = '<P ALIGN=CENTER><B>Zawsze edytowalne</B></P>

<P>Opcja ta pozwala Ci ustalić, czy wpisy są zawsze edytowalne.

<P>Możesz wybrać

<UL>
<LI><B>Tak:</B> Wpisy są zawsze edytowalne.

<LI><B>Nie:</B> Wpisy są edytowalne tylko przez określony czas po ich stworzeniu.
</UL>';
$string['editcategories'] = 'Edytuj kategorie';
$string['editcategory'] = 'Edytuj kategorię';
$string['editentry'] = 'Edytuj wpis';
$string['editentrya'] = 'Edytuj wpis: {$a}';
$string['editingcomment'] = 'Edytuj komentarz';
$string['entbypage'] = 'Wyświetl podaną liczbę pojęć na stronie';
$string['entries'] = 'Pojęcia';
$string['entrieswithoutcategory'] = 'Pojęcia nieskategoryzowane';
$string['entry'] = 'Pojęcie';
$string['entryalreadyexist'] = 'Pojęcie już istnieje';
$string['entryapproved'] = 'Wpis został zaaprobowany';
$string['entrydeleted'] = 'Wpis został usunięty';
$string['entryexported'] = 'Wpis został wyeksportowany pomyślnie';
$string['entryishidden'] = '(ten wpis jest aktualnie ukryty)';
$string['entryleveldefaultsettings'] = 'Domyślne ustawienia wpisów';
$string['entrylink'] = 'Link do wpisu: {$a}';
$string['entrynotapproved'] = 'Wpis nie został zatwierdzony';
$string['entrysaved'] = 'Hasło zostało zapisane';
$string['entryupdated'] = 'Hasło zostało uaktualnione';
$string['entryusedynalink'] = 'Ten wpis powinien zostać automatycznie linkowany.';
$string['entryusedynalink_help'] = 'Jeśli administrator włączył automatyczne linkowanie wpisu w całej witrynie i to pole wyboru jest zaznaczone, wpis zostanie automatycznie połączony wszędzie tam, gdzie w pozostałej części kursu pojawią się pojęcia i wyrażenia.';
$string['errcannoteditothers'] = 'Nie możesz edytować pojęć innych użytkowników';
$string['errconceptalreadyexists'] = 'Definicja tego pojęcia już istnieje. Ten słownik nie zezwala na duplikowanie pojęć.';
$string['errdeltimeexpired'] = 'Nie możesz tego usunąć. Czas minął!';
$string['erredittimeexpired'] = 'Czas edycji tego pojęcia upłynął.';
$string['errorparsingxml'] = 'Wystąpiły błędy podczas przetwarzania pliku. Upewnij się, że ma on poprawną składnię XML.';
$string['errreservedkeywords'] = 'Co najmniej jedno słowo kluczowe zawiera znak specjalny, którego nie można użyć.';
$string['eventcategorycreated'] = 'Kategoria została utworzona';
$string['eventcategorydeleted'] = 'Kategoria została usunięta';
$string['eventcategoryupdated'] = 'Kategoria została zaktualizowana';
$string['evententryapproved'] = 'Wpis został zatwierdzony';
$string['evententrycreated'] = 'Wpis został utworzony';
$string['evententrydeleted'] = 'Wpis został usunięty';
$string['evententrydisapproved'] = 'Wpis nie został zatwierdzony';
$string['evententryupdated'] = 'Wpis został zakualizowany';
$string['evententryviewed'] = 'Wpis został wyświetlony';
$string['explainaddentry'] = 'Dodaj nowe pojęcie do tego słownika pojęć.<br />Pola: Termin i Definicja muszą zostać wypełnione.';
$string['explainall'] = 'Wyświetl wszystkie pojęcia na jednej stronie';
$string['explainalphabet'] = 'Wyszukaj pojęcia używając tego indeksu';
$string['explainexport'] = 'Plik został stworzony.<br />Pobierz go i zachowaj w bezpiecznym miejscu. Możesz go zaimportować w ramach tego lub innego kursu.<br />Zwróć uwagę, że załączniki (np. obrazki) oraz autorzy nie są eksportowani.';
$string['explainimport'] = 'Musisz wskazać plik, który chcesz importować i zdefiniować kryteria.<p>Wyślij swoje żądanie i sprawdź wynik.';
$string['explainspecial'] = 'Pokaż pojęcia, które nie zaczynają się od litery';
$string['export'] = 'Eksport';
$string['exportedentry'] = 'Wyeksportowany plik';
$string['exportentries'] = 'Eksportuj pojęcia';
$string['exportentriestoxml'] = 'Eksportuj pojęcia do pliku XML';
$string['exportfile'] = 'Eksportuj pojęcia do pliku';
$string['exportglossary'] = 'Eksportuj słownik pojęć';
$string['exporttomainglossary'] = 'Eksportuj do głównego słownika pojęć';
$string['filetoimport'] = 'Plik do importu';
$string['filetoimport_help'] = '<P ALIGN=CENTER><B>Plik do importu</B></P>

<P>Wybierz plik XML zawierający definicje, które chcesz zaimportować</p>';
$string['fillfields'] = 'Pola: Termin i Definicja muszą zostać wypełnione';
$string['filtername'] = 'Automatyczne linkowanie pojęć';
$string['fullmatch'] = 'Szukaj tylko wyrazów tak jak zostały wpisane<br /><small>(jeśli zostały automatycznie połączone)</small>';
$string['fullmatch_help'] = '<P ALIGN=CENTER><B>Łączenie tylko całych słów</B></P>

<p>Jeżeli zostało wybrane automatyczne łączenie pojęć, wówczas włączenie tego parametru spowoduje,
że tylko całe wyrazy będą łączone.

<p>Na przykład, słownikowy termin "kolor" nie utworzy linku do wyrazu "kolorowy" w tekście.</p>';
$string['glossary:addinstance'] = 'Dodaj nowy słownik';
$string['glossary:approve'] = 'Zatwierdzaj i cofnij zatwierdzenia wpisów';
$string['glossary:comment'] = 'Twórz komentarze';
$string['glossary:export'] = 'Eksportuj pojęcia';
$string['glossary:exportentry'] = 'Eksport pojedynczego wpisu';
$string['glossary:exportownentry'] = 'Eksport własnego pojedynczego wpisu';
$string['glossary:import'] = 'Importuj pojęcia';
$string['glossary:managecategories'] = 'Zarządzaj kategoriami';
$string['glossary:managecomments'] = 'Zarządzaj komentarzami';
$string['glossary:manageentries'] = 'Zarządzaj wpisami';
$string['glossary:rate'] = 'Oceń wpisy';
$string['glossary:view'] = 'Oglądaj słownik';
$string['glossary:viewallratings'] = 'Oglądaj  wszystkie surowe oceny wystawione przez wszystkich';
$string['glossary:viewanyrating'] = 'Oglądaj oceny wszystkich';
$string['glossary:viewrating'] = 'Wyświetl oceny które otrzymałeś';
$string['glossary:write'] = 'Twórz nowe pojęcia';
$string['glossaryleveldefaultsettings'] = 'Domyślne ustawienia słownika';
$string['glossarytype'] = 'Typ słownika pojęć';
$string['glossarytype_help'] = 'Słownik główny to słownik, do którego można importować wpisy ze słowników dodatkowych. W kursie może być tylko jeden główny słownik. Jeśli import wpisów słownika nie jest wymagany, wszystkie słowniki w kursie mogą być słownikami dodatkowymi.';
$string['guestnoedit'] = 'Goście nie mogą edytować słowników';
$string['importcategories'] = 'Importuj kategorie';
$string['importedcategories'] = 'Zaimportowano kategorie';
$string['importedentries'] = 'Zaimportowano wpisy';
$string['importentries'] = 'Importuj pojęcia';
$string['importentriesfromxml'] = 'Importuj pojęcia z pliku XML';
$string['includegroupbreaks'] = 'Rozdzielaj grupy';
$string['indicator:cognitivedepth'] = 'Poznawczość Słownika pojęć';
$string['indicator:cognitivedepth_help'] = 'Ten wskaźnik opiera się na głębi poznawczej osiągniętej przez studenta podczas korzystania z aktywności Słownika pojęć.';
$string['indicator:cognitivedepthdef'] = 'Poznawczość Słownika pojęć';
$string['indicator:cognitivedepthdef_help'] = 'Uczestnik osiągnął ten procent zaangażowania poznawczego oferowany przez aktywność Słownika pojęć w tym okresie analizy (Poziomy = Brak wyświetlenia, Wyświetlenie, Wysłanie)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['isglobal'] = 'Czy to jest globalny słownik pojęć?';
$string['isglobal_help'] = 'Słownik globalny zawiera wpisy, do których prowadzą odsyłacze z całej witryny, a nie tylko z kursu, w którym znajduje się słownik. Tylko administratorzy mogą ustawić słownik jako globalny.';
$string['letter'] = 'litera';
$string['linkcategory'] = 'Automatycznie łącz tę kategorię';
$string['linkcategory_help'] = 'Jeśli włączono automatyczne łączenie słownika i to ustawienie jest włączone, nazwa kategorii będzie automatycznie łączona wszędzie tam, gdzie pojawia się w pozostałej części kursu. Gdy uczestnik skorzysta z łącza nazwy kategorii, zostanie przeniesiony na stronę „Przeglądaj według kategorii” słownika.';
$string['linking'] = 'Automatyczne linkowanie';
$string['mainglossary'] = 'Główny słownik pojęć';
$string['maxtimehaspassed'] = 'Maksymalny czas przeznaczony na edycję tego komentarza ({$a}) minął!';
$string['modulename'] = 'Słownik pojęć';
$string['modulename_help'] = 'Moduł słownika pojęć umożliwia uczestnikom tworzenie i używanie zbioru definicji, jak w słowniku; można go także użyć do zbierania i organizowania zasobów czy informacji.

Nauczyciel może zezwolić na dołączanie załączników do wpisów. Dołączone obrazki są wyświetlane we wpisie. Wpisy mogą być przeszukiwane lub przeglądane alfabetyczne lub według kategorii, daty czy autora. Wpisy mogą być domyślnie zatwierdzane lub wymagać zatwierdzenia przez nauczyciela, zanim staną się widoczne dla wszystkich.

Gdziekolwiek w treściach kursu pojawią się słowa lub zwroty ze słownika, mogą być automatycznie zamieniane na linki do wpisu w słowniku. Nazywamy to automatycznym linkowaniem pojęć.

Nauczyciel może pozwolić na komentowanie pojęć. Pojęcia mogą być także oceniane przez nauczycieli czy uczestników. Oceny mogą być agregowane do końcowej oceny kursu, odnotowywanej w dzienniczku ocen.

Słowniki mają wiele możliwości użycia, np.:

* współtworzony bank pojęć,
* miejsce, w którym uczestnicy dodają kilka słów o sobie,
* źródło praktycznych porad w określanej dziedzinie,
* miejsce dzielenia się przydatnymi filmami, obrazkami czy nagraniami audio,
* źródło pojęć do powtórzenia i zapamiętania („vademecum”).';
$string['modulename_link'] = 'mod/glossary/view';
$string['modulenameplural'] = 'Słowniki pojęć';
$string['newentries'] = 'Nowe wpisy w słowniku';
$string['newglossary'] = 'Nowy słownik pojęć';
$string['newglossarycreated'] = 'Nowy słownik pojęć został utworzony';
$string['newglossaryentries'] = 'Nowe pojęcia w słowniku:';
$string['nocomment'] = 'Nie znaleziono żadnych komentarzy';
$string['nocomments'] = '(Nie znaleziono żadnych komentarzy dotyczących tego wpisu)';
$string['noconceptfound'] = 'Nie znaleziono żadnych terminów ani definicji';
$string['noentries'] = 'Nie znaleziono żadnych pojęć w tej sekcji';
$string['noentry'] = 'Nie znaleziono żadnych pojęć';
$string['nopermissiontodelcomment'] = 'Nie można usuwać komentarzy innych osób!';
$string['nopermissiontodelinglossary'] = 'Nie możesz komentować w tym słowniku!';
$string['nopermissiontoviewresult'] = 'Można tylko wyświetlić wyniki dla swoich własnych haseł';
$string['notapproved'] = 'wpis do słownika nie został jeszcze zatwierdzony';
$string['notcategorised'] = 'Nieskategoryzowane';
$string['numberofentries'] = 'Liczba pojęć';
$string['onebyline'] = '(jedno na linię)';
$string['page-mod-glossary-edit'] = 'Strona dodawania/edycji pojęcia ze słownika';
$string['page-mod-glossary-view'] = 'Strona przeglądu słownika pojęć';
$string['page-mod-glossary-x'] = 'Dowolna strona słownika pojęć';
$string['pendingapproval'] = 'Oczekuje na zatwierdzenie';
$string['pendingapprovalcount'] = 'Oczekuje na zatwierdzenie ({$a})';
$string['pluginadministration'] = 'Administracja słownikiem';
$string['pluginname'] = 'Słownik pojęć';
$string['popupformat'] = 'Format okna wyskakującego (popup)';
$string['print'] = 'Drukuj';
$string['printerfriendly'] = 'Wersja do wydruku';
$string['printviewnotallowed'] = 'Nie pozwalaj na drukowanie słownika';
$string['privacy'] = 'Prywatność wyników';
$string['privacy:metadata:core_comments'] = 'Komentarze dodawane do wpisów słownika są przechowywane przy użyciu systemu core_comment';
$string['privacy:metadata:core_files'] = 'Pliki dołączone do wpisów słownika są przechowywane przy użyciu systemu core_files';
$string['privacy:metadata:core_rating'] = 'Oceny dodane do wpisów słownika są przechowywane przy użyciu systemu core_rating';
$string['privacy:metadata:core_tag'] = 'Tagi dodane do definicji w słowniku są przechowywane przy użyciu systemu core_tag';
$string['privacy:metadata:glossary_entries'] = 'Informacje o wpisach użytkownika w danym słowniku (aktywności typu słownik pojęć)';
$string['privacy:metadata:glossary_entries:attachment'] = 'Załącznik do dodanego przez użytkownika wpisu';
$string['privacy:metadata:glossary_entries:concept'] = 'Koncepcja pojęcia dodana przez użytkownika';
$string['privacy:metadata:glossary_entries:definition'] = 'Definicja wpisu dodanego przez użytkownika';
$string['privacy:metadata:glossary_entries:glossaryid'] = 'ID aktywności typu słownik pojęć';
$string['privacy:metadata:glossary_entries:timemodified'] = 'Stempel czasowy wskazujący na to, kiedy wpis słownika został zmodyfikowany przez użytkownika';
$string['privacy:metadata:glossary_entries:userid'] = 'ID użytkownika dodającego ten wpis słownika';
$string['question'] = 'Pytanie';
$string['rejectedentries'] = 'Odrzuć wpisy';
$string['rejectionrpt'] = 'Raport odrzucenia';
$string['removeallglossarytags'] = 'Wszystkie tagi słownika';
$string['resetglossaries'] = 'Usuń wpisy z';
$string['resetglossariesall'] = 'Wpisy ze wszystkich słowników';
$string['rssarticles'] = 'Liczba ostatnich artykułów RSS';
$string['rssarticles_help'] = 'To ustawienie określa liczbę pojęć w słowniku, które mają zostać uwzględnione w kanale RSS. Liczba pomiędzy 5 a 20 jest zwykle odpowiednia.';
$string['rssfeed'] = 'Kanał RSS';
$string['rsssubscriberss'] = 'Pokaż kanał RSS dla {$a} terminów';
$string['rsstype'] = 'Kanał RSS dla tej aktywności';
$string['rsstype_help'] = 'Aby włączyć kanał RSS dla tej aktywności, wybierz:
z autorem: w tej opcji autor wpisu będzie podany,
bez autora: w tej opcji autor wpisu nie będzie podany.';
$string['search:activity'] = 'Słownik pojęć - informacje o aktywności';
$string['search:entry'] = 'Słownik pojęć - wpisy';
$string['searchindefinition'] = 'Przeszukaj cały tekst';
$string['secondaryglossary'] = 'Pomocniczy słownik pojęć';
$string['showall'] = 'Pokaż link „Wszystkie”';
$string['showall_help'] = 'Jeśli ta opcja jest włączona, uczestnicy mogą przeglądać wszystkie wpisy jednocześnie.';
$string['showalphabet'] = 'Pokaż litery alfabetu';
$string['showalphabet_help'] = 'Jeśli ta opcja jest włączona, uczestnicy mogą przeglądać słownik według liter alfabetu.';
$string['showspecial'] = 'Pokaż link „Specjalne”';
$string['showspecial_help'] = 'Jeśli ta opcja jest włączona, uczestnicy mogą przeglądać słownik za pomocą znaków specjalnych, takich jak @ i #.';
$string['sortby'] = 'Sortuj według';
$string['sortbycreation'] = 'Według daty utworzenia';
$string['sortbylastupdate'] = 'Według ostatniej aktualizacji';
$string['sortchronogically'] = 'Posortuj chronologicznie';
$string['special'] = 'Specjalne';
$string['standardview'] = 'Szukaj według alfabetu';
$string['studentcanpost'] = 'Studenci mogą dodawać nowe pojęcia';
$string['tagarea_glossary_entries'] = 'Wpisy w słowniku';
$string['tagsdeleted'] = 'Tagi słownika zostały usunięte';
$string['totalentries'] = 'Liczba wpisów';
$string['usedynalink'] = 'Automatycznie linkuj pojęcia';
$string['usedynalink_help'] = 'Jeśli administrator włączył automatyczne linkowanie pojęć obejmujące całą witrynę i to ustawienie jest włączone, formularz „Dodaj nowy wpis” zawiera opcję automatycznego łączenia wpisu wszędzie tam, gdzie w pozostałej części kursu pojawiają się słowa i wyrażenia pojęć.';
$string['visibletabs'] = 'Widoczne karty';
$string['warningstudentcapost'] = '(Dotyczy tylko sytuacji, gdy słownik pojęć nie jest słownikiem głównym)';
$string['withauthor'] = 'Terminy z autorem';
$string['withoutauthor'] = 'Terminy bez autora';
$string['writtenby'] = 'przez';
$string['youarenottheauthor'] = 'Nie jesteś autorem tego wpisu, więc nie możesz go edytować.';
