<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'forum', language 'pl', version '4.5'.
 *
 * @package     forum
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actionsforpost'] = 'Działania dla postu';
$string['activitydate:due'] = 'Wymagane do:';
$string['activityoverview'] = 'Są nowe wpisy na forum';
$string['addanewdiscussion'] = 'Dodaj nowy temat dyskusji';
$string['addanewquestion'] = 'Dodaj nowe pytanie';
$string['addanewtopic'] = 'Dodaj nowy temat';
$string['addreply'] = 'Dodaj odpowiedź';
$string['addtofavourites'] = 'Dodaj gwiazdkę do tej dyskusji';
$string['advancedsearch'] = 'Zaawansowane wyszukiwanie';
$string['alldiscussions'] = 'Wszystkie dyskusje';
$string['allforums'] = 'Wszystkie fora';
$string['allowdiscussions'] = 'Czy {$a} może wysyłać wiadomości na to forum?';
$string['allowsallsubscribe'] = 'W tym forum każdy może wybrać, czy subskrybować je czy nie.';
$string['allowsdiscussions'] = 'W tym forum każdy może utworzyć tylko jeden temat dyskusji.';
$string['allsubscribe'] = 'Subskrybuj wszystkie fora';
$string['allunsubscribe'] = 'Odwołaj subskrypcje z wszystkich for';
$string['allusers'] = 'Wszyscy uczestnicy';
$string['alreadyfirstpost'] = 'To jest pierwszy wpis w dyskusji';
$string['announcementsettings_help'] = 'Ustawienia te definiują domyślne ustawienia dla wszystkich for ogłoszeniowych.';
$string['anyfile'] = 'Jakikolwiek plik';
$string['areaattachment'] = 'Załączniki';
$string['areapost'] = 'Wiadomości';
$string['attachment'] = 'Załącznik';
$string['attachment_help'] = 'Opcjonalnie można dołączyć jeden lub więcej plików do wątku na forum. Jeśli dołączysz zdjęcie, zostanie ono wyświetlone po wiadomości.';
$string['attachmentname'] = 'Załącznik ($a)';
$string['attachmentnopost'] = 'Nie można wyeksportować załączników bez identyfikatora wpisu';
$string['attachments'] = 'Załączniki';
$string['attachmentswordcount'] = 'Załączniki i liczba słów';
$string['authorreplyingprivatelytoauthor'] = '{$a->respondant} odpowiadający prywatnie {$a->author}';
$string['authorreplyingtoauthor'] = '{$a->respondant} odpowiada {$a->author}';
$string['availability'] = 'Dostęp';
$string['blockafter'] = 'Próg blokowania wpisów';
$string['blockafter_help'] = 'To ustawienie określa maksymalną liczbę wpisów, które użytkownik może zamieścić na forum w danym okresie. Użytkownicy z opcją mod/forum: postwithoutthrottling są zwolnieni z tego ograniczenia.';
$string['blockperiod'] = 'Czas blokowania';
$string['blockperiod_help'] = 'Studenci mogą mieć ograniczenie w liczbie napisanych wpisów w danym przedziale czasowym. Użytkownicy z uprawnieniem od/forum:postwithoutthrottling są wyjęci spod tej zasady.';
$string['blockperioddisabled'] = 'Nie blokuj';
$string['blogforum'] = 'Standardowe forum wyświetlane podobnie jak blogi';
$string['bynameondate'] = 'Napisane przez: {$a->name} ({$a->date})';
$string['cachedef_forum_is_tracked'] = 'Status śledzenia forum dla użytkownika';
$string['calendardue'] = 'Termin wykonania {$a}';
$string['cancelreply'] = 'Anuluj odpowiedź';
$string['cannotadd'] = 'Nie można dodać do dyskusji na tym forum';
$string['cannotadddiscussion'] = 'Musisz być członkiem grupy aby dodać dyskusję do tego forum';
$string['cannotadddiscussionall'] = 'Nie masz uprawnień, aby dodać nową dyskusję dla wszystkich uczestników.';
$string['cannotadddiscussiongroup'] = 'Nie możesz utworzyć dyskusji, ponieważ nie jesteś członkiem żadnej grupy.';
$string['cannotaddsubscriber'] = 'Nie można dodać subskrybenta o identyfikatorze {$a} do tego forum!';
$string['cannotaddteacherforumto'] = 'Nie można dodać przekonwertowanego forum nauczycieli do sekcji 0 kursu';
$string['cannotcreatediscussion'] = 'Nie można utworzyć nowego wątku';
$string['cannotcreateinstanceforteacher'] = 'Nie można utworzyć nowego egzemplarza forum nauczycieli';
$string['cannotdeletepost'] = 'Nie możesz usunąć tego wpisu!';
$string['cannoteditposts'] = 'Nie możesz edytować wpisów innych osób!';
$string['cannotexportforum'] = 'Nie możesz eksportować tego forum';
$string['cannotfavourite'] = 'Przepraszamy, ale nie masz uprawnień do rozpoczynania dyskusji.';
$string['cannotfinddiscussion'] = 'Nie można znaleźć dyskusji na tym forum';
$string['cannotfindfirstpost'] = 'Nie można znaleźć pierwszego wpisu na tym forum';
$string['cannotfindorcreateforum'] = 'Nie udało się znaleźć lub utworzyć głównego forum ogłoszeń dla witryny';
$string['cannotfindparentpost'] = 'Nie znaleziono głównego wpisu nadrzędnego w stosunku do wpisu {$a}';
$string['cannotmovefromsingleforum'] = 'Nie można przenieść dyskusji z forum prostej, pojedynczej dyskusji';
$string['cannotmovenotvisible'] = 'Forum jest niewidoczne';
$string['cannotmovetonotexist'] = 'Nie możesz przenieść do tego forum - ono nie istnieje!';
$string['cannotmovetonotfound'] = 'Docelowe forum nie zostało znalezione w tym kursie.';
$string['cannotmovetosingleforum'] = 'Nie można przenieść dyskusji do forum prostej, pojedynczej dyskusji';
$string['cannotpindiscussions'] = 'Przepraszamy, nie masz uprawnień do przypinania dyskusji.';
$string['cannotpurgecachedrss'] = 'Nie można wyczyścić buforowanych kanałów RSS dla forów źródłowych i/lub docelowych - sprawdź uprawnienia dostępu do plików forum';
$string['cannotremovesubscriber'] = 'Nie możesz usunąć subskrybenta o identyfikatorze {$a} z tego forum!';
$string['cannotreply'] = 'Nie możesz odpowiedzieć na ten wpis';
$string['cannotsplit'] = 'Dyskusje z tego forum nie mogą być rozdzielone';
$string['cannotsubscribe'] = 'Musisz być  członkiem grupy aby subskrybować.';
$string['cannottrack'] = 'Nie można zatrzymać śledzenia tego forum';
$string['cannotunsubscribe'] = 'Nie można wypisać się z tego forum';
$string['cannotupdatepost'] = 'Nie możesz aktualizować tego wpisu';
$string['cannotuseseperategroupsandsingletopic'] = 'Dla pojedynczej prostej dyskusji nie można używać oddzielnych grup.';
$string['cannotusesingletopicandseperategroups'] = 'Pojedynczej prostej dyskusji nie można prowadzić w oddzielnych grupach.';
$string['cannotviewpostyet'] = 'Nie możesz jeszcze czytać postów innych studentów w tej dyskusji, ponieważ nie opublikowałeś jeszcze żadnych wpisów.';
$string['cannotviewusersposts'] = 'Nie ma wpisów tego użytkownika, które możesz zobaczyć.';
$string['cleanreadtime'] = 'Zaznacz stare wpisy jako przeczytane w tej godzinie';
$string['clicktofavourite'] = 'Nie rozpocząłeś tej dyskusji. Kliknij, aby zaznaczyć gwiazdką.';
$string['clicktolockdiscussion'] = 'Kliknij, aby zablokować tę dyskusję';
$string['clicktosubscribe'] = 'Nie subskrybujesz tej dyskusji. Kliknij, aby subskrybować.';
$string['clicktounfavourite'] = 'Nie rozpocząłeś tej dyskusji. Kliknij, aby cofnąć gwiazdkę.';
$string['clicktounlockdiscussion'] = 'Kliknij, aby odblokować tę dyskusję';
$string['clicktounsubscribe'] = 'Subskrybujesz tę dyskusję. Kliknij, aby zrezygnować z subskrypcji.';
$string['close'] = 'Zamknij';
$string['closegrader'] = 'Zamknij ocenianie';
$string['completiondetail:discussions'] = 'Rozpocznij dyskusje: {$a}';
$string['completiondetail:posts'] = 'Utwórz posty na forum: {$a}';
$string['completiondetail:replies'] = 'Odpowiedź na posty: {$a}';
$string['completiondiscussions'] = 'Rozpocznij dyskusję';
$string['completiondiscussionsdesc'] = 'Student musi utworzyć co najmniej {$a} dyskusję/e';
$string['completiondiscussionsgroup'] = 'Wymagaj dyskusji';
$string['completiondiscussionshelp'] = 'wymaga się dyskusji, aby ukończyć';
$string['completionposts'] = 'Rozpocznij dyskusję lub odpowiedź na post';
$string['completionpostsdesc'] = 'Student musi opublikować co najmniej {$a} dyskusję/e lub odpowiedź';
$string['completionpostsgroup'] = 'Wymagaj wpisów';
$string['completionpostshelp'] = 'wymaga się dyskusji lub odpowiedzi, aby ukończyć';
$string['completionpostsinforums'] = 'Publikuj na forach';
$string['completionreplies'] = 'Odpowiedź na post';
$string['completionrepliesdesc'] = 'Student musi utworzyć co najmniej {$a} odpowiedź/i';
$string['completionrepliesgroup'] = 'Wymagaj odpowiedzi';
$string['completionreplieshelp'] = 'wymaga się odpowiedzi, aby ukończyć';
$string['configcleanreadtime'] = 'Godzina i dzień oczyszczania starych wpisów w tablicy przeczytanych';
$string['configdigestmailtime'] = 'Dla tych, którzy wybrali wysyłanie streszczenia codziennie mailem, można ustawić, o której godzinie codziennie streszczenie będzie wysyłane.';
$string['configdisplaymode'] = 'Domyślny tryb wyświetlania dyskusji, jeśli nie wybrano innego.';
$string['configenablerssfeeds'] = 'Umożliwia RSS feeds dla wszystkich forów dyskusyjnych. Musisz jednak i tak włączyć obsługę feeds manualnie dla każdego forum.';
$string['configenabletimedposts'] = 'Ustaw na \'tak\', jeśli chcesz zezwolić ustawieniu na wyświetlanie okresu, w którym ma być wysłany wpis na forum.';
$string['configlongpost'] = 'Każdy wpis o długości przekraczającej tą liczbę (nie uwzględniając kodu HTML) jest uważany za długi.';
$string['configmanydiscussions'] = 'Maksymalna liczba dyskusji pokazywanych na jednej stronie forum.';
$string['configmaxattachments'] = 'Domyślna maksymalna liczba załączników dozwolonych na jeden wpis.';
$string['configmaxbytes'] = 'Domyślna wielkość plików dla wszystkich załączników na tej stronie (chyba, że przedmiot bądź ustawienia strony nakładają jeszcze inne ograniczenia)';
$string['configoldpostdays'] = 'Liczba dni, po których każdy wpis jest uważany za przeczytany.';
$string['configreplytouser'] = 'Czy wysłany wpis powinien zawierać email wysyłającego, tak aby mogli do niego osobiście odpowiedzieć (zamiast poprzez forum)? Nawet przy wyborze "Tak" użytkownicy mogą wybrać w swoich profilach, że chcą ukryć swój adres email.';
$string['configrssarticlesdefault'] = 'Jeśli kanały RSS są włączone, ustaw domyślną liczbę artykułów (zarówno dyskusji lub postów).';
$string['configrsstypedefault'] = 'Jeśli kanały RSS są włączone, ustaw domyślny typ aktywności.';
$string['configshortpost'] = 'Każdy wpis o długości mniejszej od tej liczby (nie uwzględniając kodu HTML) jest uważany za krótki';
$string['configsubscriptiontype'] = 'Domyślne ustawienie trybu subskrypcji.';
$string['configtrackingtype'] = 'Domyślne ustawienia dla śledzenia odczytu.';
$string['configtrackreadposts'] = 'Ustaw "tak" jeżeli chcesz śledzić przeczytane/nieprzeczytane wpisy dla każdego użytkownika';
$string['configusermarksread'] = 'Jeżeli "tak" użytkownik musi sam zaznaczyć wpis jako przeczytany. Jeżeli "nie", to wpis wyświetlony jest zaznaczany jako przeczytany.';
$string['confirmsubscribe'] = 'Czy na pewno chcesz się zapisać na forum \'{$a}\'?';
$string['confirmsubscribediscussion'] = 'Czy chcesz subskrybować dyskusję \'{$a->discussion}\' na forum \'{$a->forum}\'?';
$string['confirmunsubscribe'] = 'Czy na pewno chcesz się wypisać z forum \'{$a}\'?';
$string['confirmunsubscribediscussion'] = 'Czy chcesz zrezygnować z subskrypcji dyskusji \'{$a->discussion}\' na forum \'{$a->forum}\'?';
$string['couldnotadd'] = 'Nie można dodać twojego wpisu z powodu nieznanego błędu';
$string['couldnotdeletereplies'] = 'Niestety, nie można było usunąć tego wpisu, gdyż inni użytkownicy już na niego odpowiedzieli.';
$string['couldnotupdate'] = 'Nie można zaktualizować twojego wpisu z powodu nieznanego błędu';
$string['created'] = 'Utworzono';
$string['crontask'] = 'Mailingi na forum i prace konserwacyjne';
$string['cutoffdate'] = 'Zablokuj dyskusję od';
$string['cutoffdate_help'] = 'Jeśli ustawione, forum nie będzie akceptowało postów po tej dacie.';
$string['cutoffdatereached'] = 'Termin dodawania wpisów na tym forum się zakończył, wiec nie możesz już dodawać tutaj wpisów.';
$string['cutoffdatevalidation'] = 'Data ostatecznego terminu nie może być wcześniejsza niż data terminu oddania zadania.';
$string['delete'] = 'Usuń';
$string['deleteddiscussion'] = 'Usunięto temat dyskusji';
$string['deletedpost'] = 'Wpis został usunięty';
$string['deletedposts'] = 'Wpisy zostały usunięte';
$string['deleteduser'] = 'Usunięty użytkownik';
$string['deletesure'] = 'Czy masz pewność, że chcesz usunąć ten wpis?';
$string['deletesureplural'] = 'Czy na pewno chcesz usunąć ten wpis i wszystkie odpowiedzi? ({$a} wpisów)';
$string['digestmailheader'] = 'To jest twoje dzienne streszczenie wpisów z forum {$a->sitename}. Aby zmienić emailowe preferencje forum, idź do {$a->userprefs}.';
$string['digestmailpost'] = 'Zmień swoje preferencje streszczenia wiadomości na forum';
$string['digestmailpostlink'] = 'Zmień swoje preferencje streszczenia wiadomości na forum: {$a}';
$string['digestmailprefs'] = 'profil użytkownika';
$string['digestmailsubject'] = '{$a}: streszczenie wpisów';
$string['digestmailtime'] = 'Godzina do wysłania emaili przeglądowych';
$string['digestsentusers'] = 'Wysłano do użytkownika {$a}';
$string['disallowsubscribe'] = 'Subskrypcje niedozwolone';
$string['disallowsubscribeteacher'] = 'Subskrypcje niedozwolone (nie dotyczy nauczycieli)';
$string['disallowsubscription'] = 'Subskrypcja';
$string['disallowsubscription_help'] = 'To forum zostało skonfigurowane w taki sposób, że nie można subskrybować tej dyskusji.';
$string['discussion'] = 'Temat';
$string['discussionlistsortbycreatedasc'] = 'Segreguj według daty utworzenia w porządku rosnącym';
$string['discussionlistsortbycreateddesc'] = 'Segreguj według daty utworzenia w porządku malejącym';
$string['discussionlistsortbydiscussionasc'] = 'Sortuj wg nazwy dyskusji w kolejności rosnącej';
$string['discussionlistsortbydiscussiondesc'] = 'Sortuj wg nazwy dyskusji w kolejności malejącej';
$string['discussionlistsortbygroupasc'] = 'Sortuj wg grupy w kolejności rosnącej';
$string['discussionlistsortbygroupdesc'] = 'Sortuj wg grupy w kolejności malejącej';
$string['discussionlistsortbylastpostasc'] = 'Segreguj według daty utworzenia ostatniego wpisu w porządku rosnącym';
$string['discussionlistsortbylastpostdesc'] = 'Segreguj według daty utworzenia ostatniego wpisu w porządku malejącym';
$string['discussionlistsortbyrepliesasc'] = 'Segreguj według liczby odpowiedzi w porządku rosnącym';
$string['discussionlistsortbyrepliesdesc'] = 'Segreguj według liczby odpowiedzi w porządku malejącym';
$string['discussionlistsortbystarterasc'] = 'Sortuj wg nazwy początku dyskusji w porządku rosnącym';
$string['discussionlistsortbystarterdesc'] = 'Sortuj wg nazwy początku dyskusji w porządku malejącym';
$string['discussionlocked'] = 'Dyskusja została zablokowana, więc nie możesz już odpowiedzieć.';
$string['discussionlockingdisabled'] = 'Nie blokuj dyskusji';
$string['discussionlockingheader'] = 'Blokowanie dyskusji';
$string['discussionmoved'] = 'Dyskusja ta została przeniesiona do \'{$a}\'.';
$string['discussionmovedpost'] = 'Ta dyskusja została przeniesiona do <a href="{$a->discusshref}">here</a> na forum <a href="{$a->forumhref}">{$a->forumname}</a>';
$string['discussionname'] = 'Nazwa dyskusji';
$string['discussionnownotsubscribed'] = '{$a->name} nie zostanie powiadomiona/y o nowych postach w \'{$a->discussion}\' dla forum \'{$a->forum}\'';
$string['discussionnowsubscribed'] = 'Zostaniesz powiadomiona/y o nowych postach w \'{$a->discussion}\' dla forum \'{$a->forum}\'';
$string['discussionpin'] = 'Przypnij';
$string['discussionpinned'] = 'Przypięta';
$string['discussionpinned_help'] = 'Przypięte dyskusje będą sie pojawiały na górze listy dyskusji w forum.';
$string['discussions'] = 'Dyskusje';
$string['discussionsplit'] = 'Dyskusja została podzielona';
$string['discussionsstartedby'] = 'Dyskusje rozpoczęte przez {$a}';
$string['discussionsstartedbyrecent'] = 'Dyskusje rozpoczęte ostatnio przez {$a}';
$string['discussionsstartedbyuserincourse'] = 'Dyskusja rozpoczęta przez {$a->fullname} w {$a->coursename}';
$string['discussionsstartedincourse'] = 'Dyskusje rozpoczęte w {$a}';
$string['discussionstartedby'] = 'Dyskusja rozpoczęta przez {$a}';
$string['discussionsubscribed'] = 'Zapisałeś się do tej dyskusji.';
$string['discussionsubscribestart'] = 'Wyślij mi powiadomienia o nowych postach w tej dyskusji';
$string['discussionsubscribestop'] = 'Nie chcę, aby otrzymywać powiadomień o nowych postach w tej dyskusji';
$string['discussionsubscription'] = 'Subskrypcja dyskusji';
$string['discussionsubscription_help'] = 'Włączenie subskrypcji dyskusji oznacza, że otrzymasz powiadomienia o nowych wpisach dodanych w tej dyskusji (wątku).';
$string['discussionunpin'] = 'Odepnij';
$string['discussionunsubscribed'] = 'Wypisałeś się z tej dyskusji.';
$string['discussthistopic'] = 'Podyskutuj na ten temat';
$string['discusstopicname'] = 'Porozmawiaj na temat: {$a}';
$string['displayend'] = 'Koniec wyświetlania';
$string['displayend_help'] = 'To ustawienie określa, czy wpisy na forum powinny być ukryte po określonej dacie. Należy pamiętać, że administratorzy mogą zawsze przeglądać wpisy na forum.';
$string['displayenddate'] = 'Zakończ wyświetlanie: {$a}.';
$string['displaymode'] = 'Sposób wyświetlania';
$string['displayperiod'] = 'Okres wyświetlania';
$string['displaystart'] = 'Początek wyświetlania';
$string['displaystart_help'] = 'To ustawienie określa, czy wpisy na forum powinny być wyświetlane poczynając od określonej daty. Należy pamiętać, że administratorzy mogą zawsze przeglądać wpisy na forum.';
$string['displaystartdate'] = 'Rozpocznij wyświetlanie: {$a}.';
$string['displaywordcount'] = 'Wyświetl liczbę słów';
$string['displaywordcount_help'] = 'Jeśli to ustawienie jest zaznaczone na "Tak" wtedy pod każdym wpisem wyświetlona jest liczba użytych słów.';
$string['duedate'] = 'Termin wykonania';
$string['duedatetodisplayincalendar'] = 'Termin do wyświetlenia w kalendarzu';
$string['eachuserforum'] = 'Każdy wysyła jeden temat dyskusji';
$string['edit'] = 'Edycja';
$string['editdiscussion'] = 'Edytuj dyskusję';
$string['editdiscussiontopic'] = 'Edytuj temat dyskusji';
$string['editedby'] = 'Edytowany przez {$a->name} - pierwotnie wysłano {$a->date}';
$string['editedpostupdated'] = 'Wpis użytkownika \'{$a}\' został zaktualizowany';
$string['editing'] = 'Edycja';
$string['emaildigestdefault'] = 'Domyślne ({$a})';
$string['emaildigestoffshort'] = 'Bez streszczenia';
$string['emaildigestsubjectsshort'] = 'Tylko tematy';
$string['emaildigesttype'] = 'Opcje streszczenia wiadomości email';
$string['emaildigesttype_help'] = 'Typ powiadomienia, które zostanie wysłane z wybranego forum.

* Domyślne - ustawienia zgodne z tymi, które zostały nadane w profilu użytkownika. Zmiana typu powiadomienia w profilu wpływa na sposób wysyłania powiadomień z danego forum.
* Bez streszczenia - zostanie wysłany jeden email na każdy wpis
* Pełny - jeden email dziennie z wszystkimi wpisami
* Tematy - codzienny email tylko z tematami wpisów';
$string['emptymessage'] = 'Coś nie tak z twoim wpisem. Być może był  pusty lub załącznik był zbyt duży. Twoje zmiany nie zostały zapisane.';
$string['errorcannotlock'] = 'Nie masz uprawnień do blokowania dyskusji.';
$string['errordiscussionnotfound'] = 'Nie znaleziono dyskusji';
$string['erroremptymessage'] = 'Wiadomość nie może być pusta';
$string['erroremptysubject'] = 'Tytuł wpisu nie może być pusty.';
$string['errorenrolmentrequired'] = 'Musisz być zapisany na ten kurs, by mieć dostęp do tej zawartości';
$string['errorforumnotfound'] = 'Nie znaleziono forum, do którego należy ta dyskusja';
$string['errorwhiledelete'] = 'Wystąpił błąd podczas usuwania zapisu.';
$string['eventassessableuploaded'] = 'Zamieszczono treść';
$string['eventcoursesearched'] = 'Użyto wyszukiwania w przedmiocie';
$string['eventdiscussioncreated'] = 'Utworzono wątek';
$string['eventdiscussiondeleted'] = 'Usunięto wątek';
$string['eventdiscussionlockupdated'] = 'Zaktualizowano blokadę dyskusji';
$string['eventdiscussionmoved'] = 'Dyskusja przeniesiona';
$string['eventdiscussionpinned'] = 'Dyskusja przypięta';
$string['eventdiscussionsubscriptioncreated'] = 'Utworzono subskrypcję dyskusji';
$string['eventdiscussionsubscriptiondeleted'] = 'Subskrypcja wyłączona';
$string['eventdiscussionunpinned'] = 'Dyskusja odpięta';
$string['eventdiscussionupdated'] = 'Dyskusja zaktualizowana';
$string['eventdiscussionviewed'] = 'Dyskusja wyświetlona';
$string['eventforumsubscriptionupdated'] = 'Zaktualizowano tryb subskrypcji';
$string['eventpostcreated'] = 'Post utworzony';
$string['eventpostdeleted'] = 'Post usunięty';
$string['eventpostupdated'] = 'Post zaktualizowany';
$string['eventreadtrackingdisabled'] = 'Śledzenie odczytu wyłączone';
$string['eventreadtrackingenabled'] = 'Włączono śledzenie czytania';
$string['eventsubscribersviewed'] = 'Subskrypcja wyświetlona';
$string['eventsubscriptioncreated'] = 'Subskrypcja utworzona';
$string['eventsubscriptiondeleted'] = 'Subskrypcja usunięta';
$string['eventuserreportviewed'] = 'Wyświetlony raport użytkownika';
$string['everyonecanchoose'] = 'Każdy może się zapisać na forum';
$string['everyonecannowchoose'] = 'Każdy może teraz wybrać subskrypcję';
$string['everyoneisnowsubscribed'] = 'Wszyscy subskrybują to forum';
$string['everyoneissubscribed'] = 'Każdy jest zapisany na to forum';
$string['existingsubscribers'] = 'Istniejący subskrybenci';
$string['export'] = 'Eksport';
$string['exportattachmentname'] = 'Eksportuj załącznik  {$a} do portfolio';
$string['exportdiscussion'] = 'Eksportuj całą dyskusję do portfolio';
$string['exportoptions'] = 'Opcje eksportu';
$string['exportstriphtml'] = 'Usuń HTML';
$string['favourites'] = 'Oznaczone gwiazdką';
$string['favouriteupdated'] = 'Twoja opcja gwiazdki została zapisana.';
$string['firstpost'] = 'Pierwszy wpis';
$string['forcedreadtracking'] = 'Zezwól na wymuszanie śledzenia czytania';
$string['forcesubscribed'] = 'To forum wymusza subskrypcję u wszystkich.';
$string['forcesubscribed_help'] = 'To forum zostało skonfigurowane w taki sposób, że nie można zrezygnować z subskrypcji tej dyskusji.';
$string['forum'] = 'Forum';
$string['forum:addinstance'] = 'Dodaj nowy dział';
$string['forum:addnews'] = 'Dodawaj ogłoszenia';
$string['forum:addquestion'] = 'Dodaj pytanie';
$string['forum:allowforcesubscribe'] = 'Pozwól na wymuszenie zapisów';
$string['forum:canoverridediscussionlock'] = 'Odpowiedz na zablokowane dyskusje';
$string['forum:canposttomygroups'] = 'Publikuj we wszystkich grupach, do których masz dostęp';
$string['forum:cantogglefavourite'] = 'Oznacz dyskusję (gwiazdką)';
$string['forum:createattachment'] = 'Utworzyć załączniki';
$string['forum:deleteanypost'] = 'Usunąć każdy wpis (kiedykolwiek umieszczony)';
$string['forum:deleteownpost'] = 'Usunąć własne wpisy';
$string['forum:editanypost'] = 'Modyfikować każdy wpis';
$string['forum:exportdiscussion'] = 'Eksportuj całą dyskusję';
$string['forum:exportforum'] = 'Eksportuj forum';
$string['forum:exportownpost'] = 'Eksportuj własne wpisy';
$string['forum:exportpost'] = 'Eksport wpisów';
$string['forum:grade'] = 'Oceń forum';
$string['forum:managesubscriptions'] = 'Zarządzaj subskrybentami';
$string['forum:movediscussions'] = 'Przesunąć dyskusje';
$string['forum:pindiscussions'] = 'Przypnij dyskusje';
$string['forum:postprivatereply'] = 'Odpowiadaj prywatnie na posty';
$string['forum:postwithoutthrottling'] = 'Wolny od blokad edycji postów';
$string['forum:rate'] = 'Ocenić wpisy';
$string['forum:readprivatereplies'] = 'Wyświetl prywatne odpowiedzi';
$string['forum:replynews'] = 'Odpowiadaj na ogłoszenia';
$string['forum:replypost'] = 'Odpowiedzieć na wpis';
$string['forum:splitdiscussions'] = 'Podzielić dyskusje';
$string['forum:startdiscussion'] = 'Rozpocząć nową dyskusję';
$string['forum:viewallratings'] = 'Zobacz wszystkie, poszczególne oceny wystawione przez użytkowników';
$string['forum:viewanyrating'] = 'Przeglądać dowolne oceny';
$string['forum:viewdiscussion'] = 'Przeglądać dyskusje';
$string['forum:viewhiddentimedposts'] = 'Zobacz ukryte wpisy z ustawionym czasem wysłania';
$string['forum:viewqandawithoutposting'] = 'Pokazuj pytania i odpowiedzi również osobom które nie odpowiedziały';
$string['forum:viewrating'] = 'Wyświetl całkowitą otrzymaną ocenę';
$string['forum:viewsubscribers'] = 'Przeglądaj subskrybentów';
$string['forumauthorhidden'] = 'Autor (ukryty)';
$string['forumblockingalmosttoomanyposts'] = 'Zbliżasz się do progu liczby wpisów. Napisałeś {$a->numposts}  wpisów w czasie {$a->blockperiod}  a limit to {$a->blockafter}  wpisów.';
$string['forumbodydeleted'] = 'Treść tego wpisu na forum została usunięta i nie można już uzyskać do niej dostępu.';
$string['forumbodyhidden'] = 'Nie możesz oglądać tej dyskusji, prawdopodobnie dlatego, że jeszcze w niej nic nie napisałeś, maksymalny czas edycji jeszcze nie minął, dyskusja nie rozpoczęła się lub wygasła.';
$string['forumgradingpanel'] = 'Panel oceniania forum';
$string['forumintro'] = 'Opis';
$string['forumname'] = 'Nazwa Forum';
$string['forumposts'] = 'Wpisy na forach';
$string['forums'] = 'Fora dyskusyjne';
$string['forumsubjectdeleted'] = 'Ten post na forum został usunięty';
$string['forumsubjecthidden'] = 'Tytuł (ukryty)';
$string['forumtracked'] = 'Nieprzeczytane wpisy są śledzone';
$string['forumtrackednot'] = 'Nieprzeczytane wpisy nie są śledzone';
$string['forumtype'] = 'Rodzaj forum';
$string['forumtype_help'] = 'Istnieje 5 typów forów dyskusyjnych:

* Pojedyncza prosta dyskusja - pojedynczy temat dyskusji, na który każdy może odpowiedzieć (nie można używać z oddzielnymi grupami)
* Każda osoba publikuje jedną dyskusję - każdy uczeń może opublikować dokładnie jeden nowy temat dyskusji, na który każdy może odpowiedzieć
* Forum pytań i odpowiedzi - uczeń musi najpierw opublikować swoją odpowiedź na pytanie zadane przez nauczyciela, zanim wyświetli posty innych uczniów
* Standardowe forum wyświetlane w formacie podobnym do bloga - otwarte forum, na którym każdy może rozpocząć nową dyskusję w dowolnym momencie, a tematy dyskusji są wyświetlane na jednej stronie z linkami „Omów ten temat”
* Standardowe forum do użytku ogólnego - otwarte forum, na którym każdy może rozpocząć nową dyskusję w dowolnym momencie';
$string['generalforum'] = 'Forum standardowe do użytku ogólnego';
$string['generalforums'] = 'Fora ogólne';
$string['grade_forum_header'] = 'Ocenianie całego forum';
$string['grade_forum_name'] = 'Całe forum';
$string['grade_forum_title'] = 'Ocena';
$string['grade_rating_name'] = 'Ocena';
$string['graded'] = 'Oceniono';
$string['gradedby'] = 'Oceniono przez';
$string['gradeforwholeforum'] = 'Ocena dla forum: {$a->str_long_grade}';
$string['gradeforwholeforumhidden'] = 'Ocena dla forum ukryta';
$string['gradeitem:forum'] = 'Forum';
$string['gradeitemnameforwholeforum'] = '{$a->name} całe forum';
$string['grades:gradesavedfor'] = 'Ocena zapisana dla {$a->fullname}';
$string['grades:gradesavefailed'] = 'Nie można zapisać oceny dla {$a->fullname}: {$a->error}';
$string['gradeusers'] = 'Oceń użytkowników';
$string['grading'] = 'Ocenianie';
$string['gradingstatus'] = 'Status oceny:';
$string['hiddenforumpost'] = 'Ukryty wpis na forum';
$string['hidegraderpanel'] = 'Ukryj panel oceniania';
$string['hidepreviousrepliescount'] = 'Ukryj poprzednie odpowiedzi ({$a})';
$string['hideusersearch'] = 'Ukryj wyszukiwanie użytkowników';
$string['indexoutoftotal'] = '{$a->index} z {$a->total}';
$string['indicator:cognitivedepth'] = 'Poznawczość Forum';
$string['indicator:cognitivedepth_help'] = 'Wskaźnik ten opiera się na głębokości poznawczej osiągniętej przez studenta podczas aktywności na Forum.';
$string['indicator:cognitivedepthdef'] = 'Poznawczość Forum';
$string['indicator:cognitivedepthdef_help'] = 'Uczestnik osiągnął określony procent zaangażowania poznawczego oferowanego przez aktywność Forum w tym przedziale czasowym analizy (Poziomy = Brak wyświetlenia, Wyświetlenie, Wysłanie, Wyświetlenie informacji zwrotnej, Skomentowanie informacji zwrotnej, Ponowne wysłanie po zapoznaniu się z informacją zwrotną)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Forum społeczne';
$string['indicator:socialbreadth_help'] = 'Wskaźnik ten opiera się na zasięgu społecznym osiągniętym przez studenta w ramach aktywności  Forum.';
$string['indicator:socialbreadthdef'] = 'Forum społeczne';
$string['indicator:socialbreadthdef_help'] = 'Uczestnik osiągnął ten procent zaangażowania społecznego oferowanego przez aktywność Forum w tym przedziale analizy (Poziomy = Brak uczestnictwa, Sam uczestnik, Uczestnik z innymi)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['inforum'] = 'w {$a}';
$string['inreplyto'] = 'W odpowiedzi na {$a}';
$string['introblog'] = 'Wpisy na tym forum zostały skopiowane automatycznie z blogów użytkowników tego kursu, ponieważ te wpisy na blogach nie są już dostępne';
$string['intronews'] = 'Komunikaty i ogłoszenia';
$string['introsocial'] = 'Forum otwarte do dyskusji na dowolny temat';
$string['introteacher'] = 'Forum dla notatek i dyskusji tylko dla nauczycieli';
$string['invalidaccess'] = 'Ta strona nie była prawidłowo dostępna';
$string['invaliddigestsetting'] = 'Wprowadzono niepoprawne ustawienia streszczenia wiadomości e-mail';
$string['invaliddiscussionid'] = 'ID dyskusji było nieprawidłowe lub już nie istnieje';
$string['invalidforcesubscribe'] = 'Nieprawidłowy tryb wymuszenia subskrypcji';
$string['invalidforumid'] = 'Identyfikator forum był niepoprawny';
$string['invalidparentpostid'] = 'Identyfikator nadrzędnego wpisu był niepoprawny';
$string['invalidpostid'] = 'Nieprawidłowy identyfikator wpisu - {$a}';
$string['lastpost'] = 'Ostatni wpis';
$string['learningforums'] = 'Fora dydaktyczne';
$string['lockdiscussion'] = 'Zablokuj tę dyskusję';
$string['lockdiscussionafter'] = 'Zablokuj dyskusję po wybranym okresie lub braku aktywności';
$string['lockdiscussionafter_help'] = 'Dyskusje mogą zostać automatycznie zablokowane po upływie określonego czasu od ostatniej odpowiedzi.
Użytkownicy z możliwością odpowiadania na zablokowane dyskusje mogą odblokować dyskusję, odpowiadając na nią.';
$string['locked'] = 'Zablokowany';
$string['lockupdated'] = 'Opcja zablokowania została zapisana.';
$string['longpost'] = 'Długi wpis';
$string['mailnow'] = 'Natychmiast wyślij zawiadomienia (pomiń czas na edycję)';
$string['managesubscriptionsoff'] = 'Zakończ zarządzanie subskrybentami';
$string['managesubscriptionson'] = 'Zarządzaj subskrybentami';
$string['manydiscussions'] = 'Dyskusji na stronę';
$string['markalldread'] = 'Ustaw wszystkie wpisy w tej dyskusji jako przeczytane';
$string['markallread'] = 'Ustaw wszystkie wpisy w tym forum jako przeczytane';
$string['markasread'] = 'Oznacz jako przeczytane';
$string['markasreadonnotification'] = 'Przy wysyłaniu powiadomień z forów dyskusyjnych';
$string['markasreadonnotification_help'] = 'Gdy zostaniesz powiadomiony o poście na forum, możesz wybrać, czy post ma być oznaczony jako przeczytany na potrzeby śledzenia forum.';
$string['markasreadonnotificationno'] = 'Nie oznaczaj postu jako przeczytany';
$string['markasreadonnotificationyes'] = 'Oznacz post jako przeczytany';
$string['markread'] = 'Przeczytane';
$string['markreadbutton'] = 'Przeczytane';
$string['markunread'] = 'Nieprzeczytane';
$string['markunreadbutton'] = 'Nieprzeczytane';
$string['maxattachments'] = 'Maksymalna liczba załączników';
$string['maxattachments_help'] = 'To ustawienie określa maksymalną liczbę plików, które mogą być dołączone do wpisu na forum.';
$string['maxattachmentsize'] = 'Maksymalna wielkość załącznika';
$string['maxattachmentsize_help'] = 'To ustawienie określa największy rozmiar pliku, który można dołączyć do posta na forum.';
$string['maxtimehaspassed'] = 'Niestety, maksymalny czas dozwolony na edycję tego wpisu ({$a}) minął!';
$string['message'] = 'Wiadomość';
$string['messageinboundattachmentdisallowed'] = 'Twój wpis nie może zostać opublikowany.
Wpis zawiera załącznik, a to forum nie pozwala na umieszczanie załączników.';
$string['messageinboundfilecountexceeded'] = 'Twój wpis nie może zostać opublikowany.
Liczba załączników we wpisie przekracza dopuszczony limit forum ({$a->forum->maxattachments}).';
$string['messageinboundfilesizeexceeded'] = 'Twój wpis nie może zostać opublikowany.
Rozmiar twojego załącznika ({$a->filesize}) przekracza dopuszczony rozmiar załącznika na tym forum ({$a->maxbytes}).';
$string['messageinboundforumhidden'] = 'Twój wpis nie może zostać opublikowany, ponieważ forum nie jest obecnie dostępne.';
$string['messageinboundnopostforum'] = 'Nie można opublikować Twojej odpowiedzi, ponieważ nie masz uprawnień do publikowania postów na forum {$a->forum->name}.';
$string['messageinboundthresholdhit'] = 'Nie można opublikować Twojej odpowiedzi. Przekroczono próg publikowania ustawiony dla tego forum';
$string['messageprovider:digests'] = 'Streszczenie wiadomości z subskrybowanego forum';
$string['messageprovider:posts'] = 'Wpisy z subskrybowanego forum';
$string['missingsearchterms'] = 'Następujące terminy wyszukiwania pojawiają się tylko w markowaniu HTML dla tej wiadomości';
$string['modeflatnewestfirst'] = 'Wyświetl odpowiedzi płasko, z najnowszymi na początku';
$string['modeflatoldestfirst'] = 'Wyświetl odpowiedzi płasko, z najdawniejszymi na początku';
$string['modenested'] = 'Wyświetl odpowiedzi tematycznie';
$string['modenestedv2'] = 'Wyświetlaj odpowiedzi w eksperymentalnej formie zagnieżdżonej';
$string['modethreaded'] = 'Wyświetl odpowiedzi wątkami';
$string['modulename'] = 'Forum';
$string['modulename_help'] = '<P>Ten moduł może być najważniejszy - właśnie w nim odbywa się większość dyskusji.
   Fora mogą posiadać różną strukturę i mogą umożliwiać ocenę każdego postu przez współuczestników.
   Posty mogą być przeglądane w różnych formatach i mogą zawierać załączniki.
   Uczestnicy, którzy są subskrybentami forum otrzymają pocztą elektroniczną kopie każdego nowego postu. Prowadzący może narzucić subskrypcję wszystkim uczestnikom.</P>';
$string['modulename_link'] = 'mod/forum/view';
$string['modulenameplural'] = 'Fora dyskusyjne';
$string['more'] = 'więcej';
$string['movedmarker'] = '(przeniesione)';
$string['movethisdiscussionlabel'] = 'Przenieś bieżącą dyskusję na określone forum';
$string['movethisdiscussionto'] = 'Przenieś tę dyskusję do ...';
$string['mustprovidediscussionorpost'] = 'Aby wyeksportować, musisz podać identyfikator dyskusji lub identyfikator wpisu.';
$string['myprofileotherdis'] = 'Dyskusje rozpoczęte na forach';
$string['myprofileowndis'] = 'Moje forum dyskusyjne';
$string['myprofileownpost'] = 'Moje posty na forum';
$string['namenews'] = 'Ogłoszenia';
$string['namenews_help'] = 'Forum "Ogłoszenia" jest specjalnym forum tworzonym automatycznie w każdym kursie. Może być tylko jedno takie forum na kurs. Ogłoszenia zamieszczać mogą jedynie nauczyciele i administrator. Tematy ostatnio dodanych ogłoszeń wyświetlane są w bloku "Najnowsze ogłoszenia".';
$string['namesocial'] = 'Forum towarzyskie';
$string['nameteacher'] = 'Forum nauczycielskie';
$string['newforumposts'] = 'Nowe wpisy na forum';
$string['nextdiscussiona'] = 'Następna dyskusja: {$a}';
$string['nextuser'] = 'Następny uczestnik';
$string['noattachments'] = 'Brak załączników do tego wpisu';
$string['nodiscussions'] = 'Nie ma żadnych tematów na tym forum';
$string['nodiscussionsstartedby'] = 'Użytkownik {$a} nie rozpoczął żadnych dyskusji';
$string['nodiscussionsstartedbyyou'] = 'Nie rozpocząłeś jeszcze żadnej dyskusji';
$string['noguestpost'] = 'Tylko zalogowani użytkownicy mogą publikować na tym forum.';
$string['noguestpost:title'] = 'Zaloguj się, aby kontynuować';
$string['noguestsubscribe'] = 'Goście nie mogą subskrybować dyskusji.';
$string['noguesttracking'] = 'Niestety goście nie mogą zmienić opcji obserwowania wpisów.';
$string['nomorepostscontaining'] = 'Nie znaleziono więcej wpisów zawierających \'{$a}\'';
$string['nonews'] = 'Nie zamieszczono jeszcze żadnych ogłoszeń.';
$string['noonecansubscribenow'] = 'Subskrypcje są teraz niedozwolone';
$string['nopermissiontosubscribe'] = 'Nie masz uprawnień do przeglądania subskrybentów forum';
$string['nopermissiontoview'] = 'Nie masz uprawnień do zobaczenia tego wpisu';
$string['nopostforum'] = 'Niestety, nie możesz publikować wpisów w tym forum';
$string['noposts'] = 'Brak wpisów';
$string['nopostsmadebyuser'] = '{$a} nie dokonał żadnych wpisów';
$string['nopostsmadebyyou'] = 'Nie dokonano żadnych wpisów';
$string['noquestions'] = 'Na tym forum nie ma jeszcze wpisów';
$string['nosubscribers'] = 'Nikt jeszcze nie zapisał się na to forum';
$string['notexists'] = 'Dyskusja już nie istnieje';
$string['notgraded'] = 'Nie ocenione';
$string['nothingnew'] = 'nic nowego dla {$a}';
$string['notingroup'] = 'Musisz być zapisany do grupy aby móc przeglądać to forum.';
$string['notinstalled'] = 'Moduł forum nie jest zainstalowany';
$string['notlocked'] = 'Blokuj';
$string['notpartofdiscussion'] = 'Ten wpis nie jest częścią dyskusji!';
$string['notrackforum'] = 'Nie pokazuj nieprzeczytanych wpisów';
$string['notsubscribed'] = 'Subskrybuj';
$string['nousersmatch'] = 'Nie znaleziono użytkowników dla podanych kryteriów';
$string['noviewdiscussionspermission'] = 'Nie masz uprawnień do przeglądania dyskusji na tym forum';
$string['nowallsubscribed'] = 'Jesteś teraz subskrybentem wszystkich for dyskusyjnych w {$a}.';
$string['nowallunsubscribed'] = 'Zostałeś wypisany ze wszystkich for dyskusyjnych w {$a}.';
$string['nowgradinguser'] = 'Teraz oceniam {$a}';
$string['nownotsubscribed'] = '{$a->name} NIE będzie otrzymywać kopii nowych wpisów na \'{$a->forum}\' pocztą elektroniczną.';
$string['nownottracking'] = '{$a->name} nie obserwuje nieprzeczytanych wpisów na {$a->forum}';
$string['nowsubscribed'] = 'Będziesz otrzymywać powiadomienia o nowych wpisach w \'{$a->forum}\'';
$string['nowtracking'] = '{$a->name} obserwuje \'{$a->forum}\'.';
$string['numberofreplies'] = 'Liczba odpowiedzi: {$a}';
$string['numposts'] = '{$a} wpisów';
$string['olderdiscussions'] = 'Starsze dyskusje';
$string['oldertopics'] = 'Starsze tematy';
$string['oldpostdays'] = 'Oznacz jako przeczytane po ...';
$string['page-mod-forum-discuss'] = 'Strona z wątkiem dyskusji modułu Forum dyskusyjne';
$string['page-mod-forum-view'] = 'Strona główna modułu Forum dyskusyjne';
$string['page-mod-forum-x'] = 'Jakakolwiek strona modułu Forum dyskusyjne';
$string['parent'] = 'Pokaż post nadrzędny';
$string['parentofthispost'] = 'Wpis nadrzędny';
$string['permalink'] = 'Link bezpośredni';
$string['permanentlinktoparentpost'] = 'Stały link do postu nadrzędnego tego posta';
$string['permanentlinktopost'] = 'Stały link do postu';
$string['pindiscussion'] = 'Przypnij tę dyskusję';
$string['pinupdated'] = 'Opcja przypięcia została zapisana.';
$string['pluginadministration'] = 'Administracja forum';
$string['pluginname'] = 'Forum';
$string['postadded'] = 'Twój wpis został dodany. <br />Jeżeli chcesz coś jeszcze zmienić masz {$a} na edycję.';
$string['postaddedsuccess'] = 'Wpis został dodany.';
$string['postaddedtimeleft'] = 'Masz {$a}, aby go edytować, jeśli chcesz wprowadzić jakieś zmiany.';
$string['postbymailsuccess'] = 'Twoja odpowiedź "{$a->subject}" została pomyślnie opublikowana: {$a->discussionurl}';
$string['postbymailsuccess_html'] = 'Twoja odpowiedź <a href="{$a->discussionurl}">{$a->subject}</a> została opublikowana';
$string['postbyuser'] = '{$a->post} utworzony przez  {$a->user}';
$string['postincontext'] = 'Zobacz ten wpis w kontekście';
$string['postisprivatereply'] = 'To jest prywatna odpowiedź. (Nauczyciele i inni użytkownicy mający możliwość przeglądania prywatnych odpowiedzi również mogą ją zobaczyć.)';
$string['postmailinfo'] = 'To jest kopia wiadomości opublikowanej w {$a}.';
$string['postmailnow'] = '<p>Wpis zostanie natychmiast rozesłany do wszystkich zapisanych użytkowników (subskrybentów) tego forum.</p>';
$string['postmailreply'] = 'Aby odpowiedzieć, kliknij ten link: {$a}';
$string['posts'] = 'Wpisy';
$string['postsfrom'] = 'Posty od';
$string['postsmadebyuser'] = 'Wpisy utworzone przez {$a}';
$string['postsmadebyuserincourse'] = 'Wpis utworzony przez {$a->fullname} w {$a->coursename}';
$string['postsmadeincourse'] = 'Posty opublikowane w {$a}';
$string['poststo'] = 'Posty do';
$string['posttoforum'] = 'Wyślij wpis na forum';
$string['posttomygroups'] = 'Skopiuj post do wszystkich grup';
$string['posttomygroups_help'] = 'Opublikuj kopię tej wiadomości do wszystkich grup, do których masz dostęp. Uczestnicy w grupach, do których nie masz dostępu, nie będą widzieć tej wiadomości.';
$string['postupdated'] = 'Wpis został zaktualizowany';
$string['potentialsubscribers'] = 'Potencjalni subskrybenci';
$string['prevdiscussiona'] = 'Poprzednia dyskusja: {$a}';
$string['previoususer'] = 'Poprzedni uczestnik';
$string['privacy:digesttypenone'] = 'Nie przechowujemy żadnych danych związanych z preferowanym typem podsumowania forum dla tego forum dyskusyjnego.';
$string['privacy:digesttypepreference'] = 'Wybrałeś następujący typ podsumowania forum: "{$a->type}".';
$string['privacy:discussionsubscriptionpreference'] = 'Wybrałeś następujące preferencje subskrypcji dyskusji dla tego forum: "{$a->preference}"';
$string['privacy:metadata:core_rating'] = 'Forum korzysta z podsystemu oceniania do obsługi oceny postów.';
$string['privacy:metadata:core_tag'] = 'Forum wykorzystuje podsystem tagów do obsługi tagowania postów.';
$string['privacy:metadata:forum_digests'] = 'Informacje o preferencjach podsumowania dla każdego forum.';
$string['privacy:metadata:forum_digests:forum'] = 'Forum zasubskrybowane.';
$string['privacy:metadata:forum_digests:maildigest'] = 'Preferencja podsumowania.';
$string['privacy:metadata:forum_digests:userid'] = 'Identyfikator użytkownika z preferencją podsumowania.';
$string['privacy:metadata:forum_discussion_subs'] = 'Informacje o zapisach na poszczególne dyskusje na forum';
$string['privacy:metadata:forum_discussion_subs:discussionid'] = 'Identyfikator subskrybowanej dyskusji.';
$string['privacy:metadata:forum_discussion_subs:preference'] = 'Czas rozpoczęcia subskrypcji.';
$string['privacy:metadata:forum_discussion_subs:userid'] = 'Identyfikator użytkownika z subskrypcją dyskusji.';
$string['privacy:metadata:forum_discussions'] = 'Informacje o poszczególnych dyskusjach na forum, które utworzył użytkownik';
$string['privacy:metadata:forum_discussions:assessed'] = 'TODOD - co przechowuje to pole';
$string['privacy:metadata:forum_discussions:name'] = 'Nazwa dyskusji wybrana przez autora.';
$string['privacy:metadata:forum_discussions:timemodified'] = 'Czas ostatniej modyfikacji dyskusji.';
$string['privacy:metadata:forum_discussions:userid'] = 'Identyfikator użytkownika, który utworzył dyskusję';
$string['privacy:metadata:forum_discussions:usermodified'] = 'Identyfikator użytkownika, który jako ostatni zmodyfikował dyskusję.';
$string['privacy:metadata:forum_grades'] = 'Dane ocen dla forum';
$string['privacy:metadata:forum_grades:forum'] = 'Forum, które zostało ocenione';
$string['privacy:metadata:forum_grades:grade'] = 'Przyznana ocena';
$string['privacy:metadata:forum_grades:userid'] = 'Użytkownik, który został oceniony';
$string['privacy:metadata:forum_posts'] = 'Informacje o preferencjach podsumowania dla każdego forum.';
$string['privacy:metadata:forum_posts:created'] = 'Czas utworzenia posta.';
$string['privacy:metadata:forum_posts:discussion'] = 'Dyskusja, w której znajduje się post.';
$string['privacy:metadata:forum_posts:message'] = 'Treść wpisu na forum.';
$string['privacy:metadata:forum_posts:modified'] = 'Czas ostatniej modyfikacji wpisu.';
$string['privacy:metadata:forum_posts:parent'] = 'Post nadrzędny, na który udzielono odpowiedzi.';
$string['privacy:metadata:forum_posts:privatereplyto'] = 'Identyfikator użytkownika, do którego wysłano tę odpowiedź.';
$string['privacy:metadata:forum_posts:subject'] = 'Temat postu na forum.';
$string['privacy:metadata:forum_posts:totalscore'] = 'Treść wiadomości postu na forum.';
$string['privacy:metadata:forum_posts:userid'] = 'Identyfikator użytkownika, który jest autorem posta na forum.';
$string['privacy:metadata:forum_queue'] = 'Tymczasowy dziennik postów, które zostaną wysłane w formie podsumowania';
$string['privacy:metadata:forum_queue:discussionid'] = 'Identyfikator dyskusji na forum';
$string['privacy:metadata:forum_queue:postid'] = 'Identyfikator posta na forum';
$string['privacy:metadata:forum_queue:timemodified'] = 'Czas modyfikacji oryginalnego postu';
$string['privacy:metadata:forum_queue:userid'] = 'Użytkownik, który musi zostać powiadomiony o poście';
$string['privacy:metadata:forum_read'] = 'Informacje o tym, które posty zostały przeczytane przez użytkownika.';
$string['privacy:metadata:forum_read:discussionid'] = 'Dyskusja, w której znajduje się post.';
$string['privacy:metadata:forum_read:firstread'] = 'Pierwszy raz, kiedy post został przeczytany.';
$string['privacy:metadata:forum_read:lastread'] = 'Data ostatniego przeczytania wpisu.';
$string['privacy:metadata:forum_read:postid'] = 'Post, który został odczytany.';
$string['privacy:metadata:forum_read:userid'] = 'Identyfikator użytkownika, którego dotyczy ten rekord.';
$string['privacy:metadata:forum_subscriptions'] = 'Informacja o tym, które fora zasubskrybował użytkownik.';
$string['privacy:metadata:forum_subscriptions:forum'] = 'Forum, które zostało zasubskrybowane.';
$string['privacy:metadata:forum_track_prefs:forumid'] = 'Forum, które ma włączone śledzenie odczytu.';
$string['privacy:metadata:preference:forum_discussionlistsortorder'] = 'Preferowana kolejność sortowania listy dyskusyjnej';
$string['privacy:metadata:preference:markasreadonnotification'] = 'Czy oznaczać posty na forum jako przeczytane podczas odbierania ich jako wiadomości.';
$string['privacy:metadata:preference:trackforums'] = 'Czy włączyć śledzenie odczytu?';
$string['privacy:postwasread'] = 'Ten post został po raz pierwszy przeczytany {$a->firstread}, i ostatnio {$a->lastread}';
$string['privacy:readtrackingdisabled'] = 'Zdecydowałeś nie śledzić postów, które przeczytałeś na tym forum.';
$string['privacy:request:delete:discussion:name'] = 'Usuń na prośbę autora';
$string['privacy:request:delete:post:message'] = 'Zawartość tego posta została usunięta na prośbę autora.';
$string['privacy:request:delete:post:subject'] = 'Usuń na prośbę autora';
$string['privacy:subscribedtoforum'] = 'Jesteś subskrybentem tego forum.';
$string['privatereply'] = 'Odpowiedz prywatnie';
$string['privatereply_help'] = 'Gdy odpowiadasz prywatnie, Twój wpis jest widoczny również dla użytkowników mających możliwość przeglądania prywatnych odpowiedzi, np. nauczycieli.';
$string['processingdigest'] = 'Przetwarzanie streszczenia maili użytkownika {$a}';
$string['processingpost'] = 'Wpis {$a} jest w trakcie przetwarzania';
$string['prune'] = 'Zerwij';
$string['prunediscussion'] = 'Podziel dyskusję';
$string['prunedpost'] = 'Z tego wpisu została utworzona nowa dyskusja';
$string['pruneheading'] = 'Rozdziel tą dyskusję i przenieś ten wpis do nowej dyskusji';
$string['qandaforum'] = 'Forum pytań i odpowiedzi';
$string['qandanotify'] = 'To jest forum \'Pytań i odpowiedzi\'. Aby zobaczyć odpowiedzi innych osób, musisz najpierw sam udzielić odpowiedzi.';
$string['re'] = 'Odp:';
$string['readtherest'] = 'Przeczytaj resztę tematu';
$string['removeallforumtags'] = 'Wszystkie tagi forum';
$string['removefromfavourites'] = 'Usuń gwiazdkę z tej dyskusji';
$string['replies'] = 'Odpowiedzi';
$string['repliesmany'] = '{$a} odpowiedzi (jak dotąd)';
$string['repliesone'] = '{$a} odpowiedź (jak dotąd)';
$string['reply'] = 'Odpowiedz';
$string['reply_handler'] = 'Odpowiedz na forum poprzez email';
$string['reply_handler_name'] = 'Odpowiedz na wpisy na forum';
$string['replyauthorself'] = '{$a} (ty)';
$string['replyforum'] = 'Odpowiedz na forum';
$string['replyingtoauthor'] = 'Odpowiadam na {$a}...';
$string['replyplaceholder'] = 'Napisz swoją odpowiedź...';
$string['replypostdiscussion'] = 'Odpowiedz na dyskusję';
$string['replytopostbyemail'] = 'Możesz odpowiedzieć na ten post za pomocą e-maila.';
$string['replytouser'] = 'Użyj adresu e-mail w odpowiedzi';
$string['resetdigests'] = 'Wszystkie preferencje dotyczące podsumowania forum dla każdego użytkownika';
$string['resetforums'] = 'Usuń wpisy z';
$string['resetforumsall'] = 'Wszystkie wpisy';
$string['resetsubscriptions'] = 'Wszystkie subskrypcje forum';
$string['resettrackprefs'] = 'Wszystkie preferencje śledzenia forum';
$string['rssarticles'] = 'Liczba ostatnich artykułów RSS ';
$string['rssarticles_help'] = '<P ALIGN=CENTER><B>Liczba artykułów w RSS</B></P>

<P>Ta opcja pozawala ustalić liczbę artykułów w RSS Feed.

<P>Liczba pomiędzy 5 a 20 jest zwykle odpowiednia. Zwiększ ją, jesli forum jest bardzo aktywne.';
$string['rsssubscriberssdiscussions'] = 'Kanał RSS dyskusji';
$string['rsssubscriberssposts'] = 'Kanał RSS wpisów';
$string['rsstype'] = 'Kanał RSS dla tej aktywności';
$string['rsstype_help'] = '<P ALIGN=CENTER><B>RSS feed dla tego forum</B></P>

<P>Ta opcja włącza RSS feeds w tym forum.

<P>Możesz wybrać jeden z dwóch rodzajów forum:

<UL>
<LI><B>Dyskusja:</B> W tej opcji zawarte będą nowe dyskusje z ich pierwszymi wpisami.

<LI><B>Posty:</B> W tej opcji zawarty będzie każdy wpis tego forum.
</UL>';
$string['rsstypedefault'] = 'Typ kanału RSS';
$string['search'] = 'Szukaj';
$string['search:activity'] = 'Forum - Informacje o aktywności';
$string['search:post'] = 'Forum - wpisy';
$string['searchdatefrom'] = 'Wpis nowszy niż';
$string['searchdateto'] = 'Wpis starszy niż';
$string['searchforumintro'] = 'Wprowadź szukane słowo/słowa. Możesz uzupełnić jedno lub więcej pól.';
$string['searchforums'] = 'Szukaj w forach';
$string['searchfullwords'] = 'Ze słowami';
$string['searchnotwords'] = 'Bez następujących słów';
$string['searcholderposts'] = 'Przeszukaj starsze wpisy...';
$string['searchphrase'] = 'Ta fraza musi pojawić się we wpisie';
$string['searchresults'] = 'Szukaj w rezultatach';
$string['searchsubject'] = 'Słowa w polu tytuł';
$string['searchtags'] = 'Jest oznaczony tagami';
$string['searchuser'] = 'Słowa w polu autor';
$string['searchuserid'] = 'Id autora';
$string['searchusers'] = 'Wyszukaj użytkowników';
$string['searchwhichforums'] = 'Wybierz forum';
$string['searchwords'] = 'Słowa, które mają wystąpić we wpisach';
$string['seeallposts'] = 'Pokaż wszystkie wpisy tego użytkownika';
$string['sendstudentnotificationsdefault'] = 'Domyślne ustawienie „Powiadom studentów”';
$string['sendstudentnotificationsdefault_help'] = 'Ustaw domyślną wartość pola wyboru „Powiadom studentów” w formularzu oceniania.';
$string['sendstudentnotificationsno'] = 'Nie';
$string['sendstudentnotificationsyes'] = 'Tak, wyślij powiadomienie do studenta';
$string['settings'] = 'Ustawienia';
$string['shortpost'] = 'Krótki wpis';
$string['showgraderpanel'] = 'Pokaż panel oceniania';
$string['showingcountoftotaldiscussions'] = 'Lista dyskusji. Wyświetlam {$a ->count} z {$a->total} dyskusji';
$string['showmoreusers'] = 'Wyświetl więcej użytkowników';
$string['showpreviousrepliescount'] = 'Pokaż poprzednie odpowiedzi ({$a})';
$string['showsubscribers'] = 'Wyświetl/modyfikuj użytkowników zapisanych na forum';
$string['showusersearch'] = 'Pokaż wyszukiwanie użytkownika';
$string['singleforum'] = 'Pojedyncza prosta dyskusja';
$string['smallmessage'] = '{$a->user} napisał w {$a->forumname}';
$string['smallmessagedigest'] = 'Streszczenie forum zawiera {$a} wiadomości';
$string['starredonly'] = 'Przeszukuj tylko dyskusje oznaczone gwiazdką';
$string['startedby'] = 'Rozpoczęty przez';
$string['subject'] = 'Temat';
$string['subplugintype_forumreport'] = 'Raport forum';
$string['subplugintype_forumreport_plural'] = 'Raporty forum';
$string['subscribe'] = 'Zapisz się na to forum';
$string['subscribeall'] = 'Zapisz wszystkich do tego forum';
$string['subscribed'] = 'Zapisany na forum';
$string['subscribediscussion'] = 'Zapisz się do tej dyskusji';
$string['subscribeenrolledonly'] = 'Tylko zapisani użytkownicy mogą subskrybować powiadomienia o nowych wpisach na forum.';
$string['subscribenone'] = 'Wypisz wszystkich z tego forum';
$string['subscribers'] = 'Zapisani na forum';
$string['subscriberstowithcount'] = 'Zapisani na "{$a->name}" ({$a->count})';
$string['subscribestart'] = 'Przesyłaj mi powiadomienia o nowych wpisach na tym forum';
$string['subscribestop'] = 'Nie chcę otrzymywać powiadomień o nowych wpisach na tym forum';
$string['subscription'] = 'Subskrypcja';
$string['subscription_help'] = 'Jeśli jesteś subskrybentem forum, oznacza to, że będziesz otrzymywać powiadomienia o nowych postach na forum. Zwykle możesz wybrać, czy chcesz  subskrybować forum, chociaż czasami subskrypcja jest wymuszana, aby wszyscy otrzymywali powiadomienia.';
$string['subscriptionandtracking'] = 'Subskrypcja i obserwacja';
$string['subscriptionauto'] = 'Automatyczna subskrypcja';
$string['subscriptiondisabled'] = 'Subskrypcja wyłączona';
$string['subscriptionforced'] = 'Wymuś subskrypcję';
$string['subscriptionmode'] = 'Subskrypcja';
$string['subscriptionmode_help'] = 'Gdy uczestnik jest zapisany na forum, oznacza to, że będzie otrzymywał powiadomienia o postach na forum. Istnieją 4 rodzaje subskrypcji:

* Opcjonalna subskrypcja - uczestnicy mogą wybrać, czy chcą być zasubskrybowani
* Wymuszona subskrypcja - wszyscy są zasubskrybowani i nie mogą się wypisać
* Automatyczna subskrypcja - wszyscy są zasubskrybowani początkowo, ale mogą zrezygnować z subskrypcji w dowolnym momencie
* Subskrypcja wyłączona - subskrypcje nie są dozwolone';
$string['subscriptionmodeconfirm'] = 'Czy na pewno chcesz zmienić tryb subskrypcji na {$a}?';
$string['subscriptionoptional'] = 'Subskrypcja opcjonalna';
$string['subscriptions'] = 'Subskrypcje';
$string['tagarea_forum_posts'] = 'Wpisy na forum';
$string['tagsdeleted'] = 'Tagi forum zostały usunięte';
$string['thisforumhasduedate'] = 'Termin dodawania wpisów do tego forum to {$a}.';
$string['thisforumisdue'] = 'Termin dodawania wpisów do tego forum był {$a}.';
$string['thisforumisthrottled'] = 'To forum ma ograniczoną liczbę wpisów, które można napisać w określonym czasie – jest to ustawione na  {$a->blockafter} wpis(ów) w {$a->blockperiod}';
$string['timed'] = 'Limit czasowy';
$string['timeddiscussion'] = 'Wątek ograniczony czasowo';
$string['timedhidden'] = 'Stan bieżący: Ukryte przed studentami';
$string['timedposts'] = 'Wpisy przygotowane do wysłania';
$string['timedvisible'] = 'Stan bieżący: Widoczne dla wszystkich użytkowników';
$string['timestartenderror'] = 'Końcowa data nie może być późniejsza niż początkowa';
$string['togglediscussionmenu'] = 'Przełącz menu dyskusji';
$string['togglefullscreen'] = 'Przełącz w tryb pełnoekranowy';
$string['trackforum'] = 'Pokaż nieprzeczytane wpisy';
$string['tracking'] = 'Obserwuj';
$string['trackingoff'] = 'Wyłącz';
$string['trackingon'] = 'Wymuś';
$string['trackingoptional'] = 'Opcjonalnie';
$string['trackingtype'] = 'Obserwacja';
$string['trackingtype_help'] = 'Śledzenie odczytu umożliwia uczestnikom sprawdzanie, których postów jeszcze nie widzieli, podświetlając nowe posty.
Jeśli ustawiono opcję opcjonalny, uczestnicy mogą zdecydować, czy mają włączyć lub wyłączyć śledzenie na forum. (Użytkownicy muszą również włączyć śledzenie forum w swoich preferencjach forum.)
Jeśli administrator witryny włączył opcję „Zezwalaj na wymuszone śledzenie odczytu”, dostępna jest kolejna opcja — wymuszona. Oznacza to, że śledzenie jest zawsze włączone, niezależnie od preferencji użytkowników na forum.';
$string['trackreadposts_header'] = 'Śledzenie forum';
$string['unlockdiscussion'] = 'Odblokuj tę dyskusję';
$string['unpindiscussion'] = 'Odepnij tę dyskusję';
$string['unread'] = 'Nieprzeczytane';
$string['unreadpost'] = 'Nieprzeczytany post';
$string['unreadposts'] = 'Nieprzeczytane wpisy';
$string['unreadpostsnumber'] = '{$a} nieprzeczytanych wpisów';
$string['unreadpostsone'] = '1 nieprzeczytany wpis';
$string['unsubscribe'] = 'Wypisz się z tego forum';
$string['unsubscribeall'] = 'Wypisz się ze wszystkich forów';
$string['unsubscribeallconfirm'] = 'Obecnie subskrybujesz fora {$a->forums} i dyskusje {$a->discussions}. Czy na pewno chcesz zrezygnować z subskrypcji wszystkich forów i dyskusji oraz wyłączyć automatyczną subskrypcję dyskusji?';
$string['unsubscribeallconfirmdiscussions'] = 'Obecnie subskrybujesz {$a->discussions} dyskusje. Czy na pewno chcesz wypisać się ze wszystkich dyskusji i wyłączyć automatyczną subskrypcję dyskusji?';
$string['unsubscribeallconfirmforums'] = 'Obecnie subskrybujesz fora {$a->forums}. Czy na pewno chcesz zrezygnować z subskrypcji wszystkich forów i wyłączyć automatyczną subskrypcję dyskusji?';
$string['unsubscribealldone'] = 'Wszystkie twoje subskrypcje zostały anulowane. Możesz jednak otrzymywać e-maile z forów dyskusyjnych, w których zapisanie jest obowiązkowe. Jeśli nie chcesz otrzymywać żadnych wpisów z forów dyskusyjnych możesz wyłączyć e-mail w swoim profilu.';
$string['unsubscribeallempty'] = 'Do żadnego forum nie jesteś zapisany.
Jeśli nie chcesz otrzymywać żadnych informacji z tego serwera, możesz wyłączyć e-mail w swoim profilu.';
$string['unsubscribed'] = 'Wypisany z forum';
$string['unsubscribediscussion'] = 'Wypisz się z tej dyskusji';
$string['unsubscribediscussionlink'] = 'Wypisz się z tej dyskusji: {$a}';
$string['unsubscribelink'] = 'Wypisz się z tego forum: {$a}';
$string['unsubscribeshort'] = 'Wypisz';
$string['useexperimentalui'] = 'Użyj eksperymentalnego zagnieżdżonego widoku dyskusji';
$string['usermarksread'] = 'Ręczne zaznaczanie przeczytanych wpisów';
$string['usernavigation'] = 'Nawigacja użytkownika';
$string['usersforumposts'] = 'Posty użytkownika na forum';
$string['viewalldiscussions'] = 'Zobacz wszystkie dyskusje';
$string['viewconversation'] = 'Wyświetl dyskusję';
$string['viewgrades'] = 'Zobacz oceny';
$string['viewparentpost'] = 'Wyświetl post nadrzędny';
$string['viewthediscussion'] = 'Wyświetl dyskusję';
$string['warnafter'] = 'Ostrzeżenie o progu wpisów';
$string['warnafter_help'] = 'Studenci mogą otrzymywać ostrzeżenie, gdy zbliżają się do maksymalnej liczby wpisów dozwolonych w danym okresie. Tu podajemy liczbę wpisów, po których studenci są ostrzegani. Użytkownicy z uprawnieniem mod/forum:postwithoutthrottling są zwolnieni z limitów wpisów.';
$string['warnformorepost'] = 'Ostrzeżenie! Jest więcej niż jedna dyskusja na tym forum - użyto najnowszej';
$string['yournewquestion'] = 'Twoje nowe pytanie';
$string['yournewtopic'] = 'Twoja nowa dyskusja';
$string['yourreply'] = 'Twoja odpowiedź';
