<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'editor_tinymce', language 'pl', version '4.5'.
 *
 * @package     editor_tinymce
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['advanced:address'] = 'Adres';
$string['advanced:anchor_delta_height'] = '';
$string['advanced:anchor_delta_width'] = '';
$string['advanced:anchor_desc'] = 'Wstaw/edytuj kotwicę';
$string['advanced:backcolor_desc'] = 'Wybierz kolor tła';
$string['advanced:block'] = 'Format';
$string['advanced:blockquote'] = 'Wydzielony blok';
$string['advanced:blockquote_desc'] = 'Blok cytatu';
$string['advanced:bold_desc'] = 'Pogrubienie (Ctrl+B)';
$string['advanced:bullist_desc'] = 'Wstaw/usuń listę punktowaną';
$string['advanced:charmap_delta_height'] = '';
$string['advanced:charmap_delta_width'] = '';
$string['advanced:charmap_desc'] = 'Wstaw znak specjalny';
$string['advanced:cleanup_desc'] = 'Wyczyść nieuporządkowany kod';
$string['advanced:clipboard_msg'] = 'Funkcja kopiowania/wycinania/wklejania nie jest dostępna w przeglądarkach Mozilla i Firefox.
Czy chcesz uzyskać więcej informacji na ten temat?';
$string['advanced:code'] = 'Kod';
$string['advanced:code_desc'] = 'Edytuj źródło HTML';
$string['advanced:colorpicker_delta_height'] = '';
$string['advanced:colorpicker_delta_width'] = '';
$string['advanced:copy_desc'] = 'Kopiuj';
$string['advanced:custom1_desc'] = 'Twój niestandardowy opis tutaj';
$string['advanced:cut_desc'] = 'Wytnij';
$string['advanced:dd'] = 'Opis terminu';
$string['advanced:div'] = 'DiV';
$string['advanced:dt'] = 'Definicja terminu';
$string['advanced:font_size'] = 'Rozmiar czcionki';
$string['advanced:fontdefault'] = 'Rodzaj czcionki';
$string['advanced:forecolor_desc'] = 'Wybierz kolor tekstu';
$string['advanced:h1'] = 'Nagłówek 1';
$string['advanced:h2'] = 'Nagłówek 2';
$string['advanced:h3'] = 'Nagłówek 3';
$string['advanced:h4'] = 'Nagłówek 4';
$string['advanced:h5'] = 'Nagłówek 5';
$string['advanced:h6'] = 'Nagłówek 6';
$string['advanced:help_desc'] = 'Pomoc';
$string['advanced:help_shortcut'] = 'Naciśnij ALT-F10 by wyświetlić pasek narzędzi. Naciśnij ALT-0 by wyświetlić pomoc.';
$string['advanced:hr_desc'] = 'Wstaw poziomą linię';
$string['advanced:image_delta_height'] = '';
$string['advanced:image_delta_width'] = '';
$string['advanced:image_desc'] = 'Wstaw/edytuj obraz';
$string['advanced:image_props_desc'] = 'Właściwości obrazka';
$string['advanced:indent_desc'] = 'Zwiększ wcięcie';
$string['advanced:italic_desc'] = 'Kursywa (Ctrl+I)';
$string['advanced:justifycenter_desc'] = 'Wycentruj';
$string['advanced:justifyfull_desc'] = 'Równanie do prawej i lewej';
$string['advanced:justifyleft_desc'] = 'Wyrównaj do lewej';
$string['advanced:justifyright_desc'] = 'Wyrównaj do prawej';
$string['advanced:link_delta_height'] = '';
$string['advanced:link_delta_width'] = '';
$string['advanced:link_desc'] = 'Wstaw/edytuj link';
$string['advanced:more_colors'] = 'Więcej kolorów...';
$string['advanced:newdocument'] = 'Czy jesteś pewnien, ze chcesz wyczyścić całą zawartość?';
$string['advanced:newdocument_desc'] = 'Nowy dokument';
$string['advanced:numlist_desc'] = 'Wstaw/usuń listę numerowaną';
$string['advanced:outdent_desc'] = 'Zmniejsz wcięcie';
$string['advanced:paragraph'] = 'Paragraf';
$string['advanced:paste_desc'] = 'Wklej';
$string['advanced:path'] = 'Ścieżka';
$string['advanced:pre'] = 'Czcionka o stałej szerokości';
$string['advanced:redo_desc'] = 'Ponów (Ctrl+Y)';
$string['advanced:removeformat_desc'] = 'Usuń formatowanie';
$string['advanced:rich_text_area'] = 'Obszar tekstowy';
$string['advanced:samp'] = 'Próbka kodu';
$string['advanced:shortcuts_desc'] = 'Pomoc dot. dostępności';
$string['advanced:striketrough_desc'] = 'Przekreślenia';
$string['advanced:style_select'] = 'Styl';
$string['advanced:sub_desc'] = 'Indeks dolny';
$string['advanced:sup_desc'] = 'Indeks górny';
$string['advanced:toolbar'] = 'Pasek narzędzi';
$string['advanced:toolbar_focus'] = 'Przeskocz do przycisków narzędzi - Alt+Q, Przeskocz do edytora - Alt-Z, Przeskocz do elementu ścieżki - Alt-X';
$string['advanced:underline_desc'] = 'Podkreślenie (Ctrl+U)';
$string['advanced:undo_desc'] = 'Cofnij (Ctrl+Z)';
$string['advanced:unlink_desc'] = 'Usuń link';
$string['advanced:visualaid_desc'] = 'Przełącz widoczność wskaźników i niewidocznych elementów';
$string['advanced_dlg:about_author'] = 'Autor';
$string['advanced_dlg:about_general'] = 'O TinyMCE';
$string['advanced_dlg:about_help'] = 'Pomoc';
$string['advanced_dlg:about_license'] = 'Licencja';
$string['advanced_dlg:about_loaded'] = 'Załadowane wtyczki';
$string['advanced_dlg:about_plugin'] = 'Wtyczka';
$string['advanced_dlg:about_plugins'] = 'Wtyczki';
$string['advanced_dlg:about_title'] = 'O TinyMCE';
$string['advanced_dlg:about_version'] = 'Wersja';
$string['advanced_dlg:accessibility_help'] = 'Pomoc dot. dostępności';
$string['advanced_dlg:accessibility_usage_title'] = 'Ogólne zastosowanie';
$string['advanced_dlg:anchor_invalid'] = 'Proszę podać prawidłową nazwę kotwicy.';
$string['advanced_dlg:anchor_name'] = 'Nazwa zakotwiczenia';
$string['advanced_dlg:anchor_title'] = 'Wstaw/Edytuj zakotwiczenie';
$string['advanced_dlg:charmap_title'] = 'Wybierz znak specjalny';
$string['advanced_dlg:charmap_usage'] = 'Użyj kursorów w prawo / lewo do nawigacji.';
$string['advanced_dlg:code_title'] = 'Edytor źródła HTML';
$string['advanced_dlg:code_wordwrap'] = 'Zawijanie słów';
$string['advanced_dlg:colorpicker_color'] = 'Kolor:';
$string['advanced_dlg:colorpicker_name'] = 'Nazwa:';
$string['advanced_dlg:colorpicker_named_tab'] = 'Nazwane';
$string['advanced_dlg:colorpicker_named_title'] = 'Nazwane kolory';
$string['advanced_dlg:colorpicker_palette_tab'] = 'Paleta';
$string['advanced_dlg:colorpicker_palette_title'] = 'Paleta kolorów';
$string['advanced_dlg:colorpicker_picker_tab'] = 'Wybieranie';
$string['advanced_dlg:colorpicker_picker_title'] = 'Wybieranie kolorów';
$string['advanced_dlg:colorpicker_title'] = 'Wybierz kolor';
$string['advanced_dlg:image_align'] = 'Wyrównanie';
$string['advanced_dlg:image_align_baseline'] = 'Linia bazowa';
$string['advanced_dlg:image_align_bottom'] = 'Dolny';
$string['advanced_dlg:image_align_left'] = 'Lewy';
$string['advanced_dlg:image_align_middle'] = 'Środek';
$string['advanced_dlg:image_align_right'] = 'Prawy';
$string['advanced_dlg:image_align_textbottom'] = 'Dolny tekst';
$string['advanced_dlg:image_align_texttop'] = 'Górny tekst';
$string['advanced_dlg:image_align_top'] = 'Góra';
$string['advanced_dlg:image_alt'] = 'Opis obrazka';
$string['advanced_dlg:image_border'] = 'Ramka';
$string['advanced_dlg:image_dimensions'] = 'Rozmiary';
$string['advanced_dlg:image_hspace'] = 'Poziomy odstęp';
$string['advanced_dlg:image_list'] = 'Lista obrazków';
$string['advanced_dlg:image_src'] = 'URL obrazka';
$string['advanced_dlg:image_title'] = 'Wstaw/Edytuj obraz';
$string['advanced_dlg:image_vspace'] = 'Pionowy odstęp';
$string['advanced_dlg:invalid_color_value'] = 'Nieprawidłowa wartość koloru';
$string['advanced_dlg:link_is_email'] = 'URL który otworzyłeś wydaje się być adresem mailowym. Czy chcesz dodać wymagany prefix mailto: ?';
$string['advanced_dlg:link_is_external'] = 'URL który otworzyłeś wydaje się być zewnętrznym linkiem. Czy chcesz dodać wymagany prefix http:// ?';
$string['advanced_dlg:link_list'] = 'Lista linków';
$string['advanced_dlg:link_target'] = 'Cel';
$string['advanced_dlg:link_target_blank'] = 'Otwórz link w nowym oknie';
$string['advanced_dlg:link_target_same'] = 'Otwórz link w tym samym oknie';
$string['advanced_dlg:link_title'] = 'Wstaw/edytuj link';
$string['advanced_dlg:link_titlefield'] = 'Tytuł';
$string['advanced_dlg:link_url'] = 'Link URL';
$string['advhr:advhr_desc'] = 'Wstaw linię poziomą';
$string['advhr:delta_height'] = '';
$string['advhr:delta_width'] = '';
$string['advhr_dlg:normal'] = 'Normalny';
$string['advhr_dlg:noshade'] = 'Bez cienia';
$string['advhr_dlg:size'] = 'Wysokość';
$string['advhr_dlg:width'] = 'Szerokość';
$string['advhr_dlg:widthunits'] = 'Jednostki';
$string['advimage:delta_height'] = '';
$string['advimage:delta_width'] = '';
$string['advimage:image_desc'] = 'Wstaw/edytuj obraz';
$string['advimage_dlg:align'] = 'Wyrównanie';
$string['advimage_dlg:align_baseline'] = 'Główna linia';
$string['advimage_dlg:align_bottom'] = 'Dolny';
$string['advimage_dlg:align_left'] = 'Lewy';
$string['advimage_dlg:align_middle'] = 'Środkowy';
$string['advimage_dlg:align_right'] = 'Prawy';
$string['advimage_dlg:align_textbottom'] = 'Tekst dolny';
$string['advimage_dlg:align_texttop'] = 'Tekst górny';
$string['advimage_dlg:align_top'] = 'Górny';
$string['advimage_dlg:alt'] = 'Opis obrazka';
$string['advimage_dlg:alt_image'] = 'Alternatywny obraz';
$string['advimage_dlg:border'] = 'Obramowanie';
$string['advimage_dlg:classes'] = 'Klasa';
$string['advimage_dlg:constrain_proportions'] = 'Zachowaj proporcje';
$string['advimage_dlg:dialog_title'] = 'Wstaw/edytuj obraz';
$string['advimage_dlg:dimensions'] = 'Wymiary';
$string['advimage_dlg:example_img'] = 'Podgląd wyglądu obrazka';
$string['advimage_dlg:general'] = 'Ogólny';
$string['advimage_dlg:height'] = 'Wysokość';
$string['advimage_dlg:hspace'] = 'Poziomy odstep';
$string['advimage_dlg:id'] = 'ID';
$string['advimage_dlg:image_list'] = 'Lista obrazków';
$string['advimage_dlg:langcode'] = 'Kod języka';
$string['advimage_dlg:langdir'] = 'Kierunek języka';
$string['advimage_dlg:list'] = 'Lista obrazków';
$string['advimage_dlg:long_desc'] = 'Długi opis linku';
$string['advimage_dlg:ltr'] = 'Lewy do prawego';
$string['advimage_dlg:map'] = 'Mapa obrazu';
$string['advimage_dlg:misc'] = 'Różne';
$string['advimage_dlg:missing_alt'] = 'Czy na pewno chcesz kontynuować bez dołączania opisu obrazu? Bez tego obraz może nie być dostępny dla niektórych użytkowników niepełnosprawnych, korzystających z przeglądarki tekstowej lub przeglądających Internet z wyłączonymi obrazami.';
$string['advimage_dlg:mouseout'] = 'po odjechaniu myszką';
$string['advimage_dlg:mouseover'] = 'po najechaniu myszką';
$string['advimage_dlg:preview'] = 'Podgląd';
$string['advimage_dlg:rtl'] = 'Prawy do lewego';
$string['advimage_dlg:src'] = 'URL obrazka';
$string['advimage_dlg:style'] = 'Styl';
$string['advimage_dlg:swap_image'] = 'Wymiana obrazka';
$string['advimage_dlg:tab_advanced'] = 'Zaawansowany';
$string['advimage_dlg:tab_appearance'] = 'Prezentacja';
$string['advimage_dlg:tab_general'] = 'Ogólny';
$string['advimage_dlg:title'] = 'Tytuł';
$string['advimage_dlg:vspace'] = 'Pionowy odstep';
$string['advimage_dlg:width'] = 'Szerokość';
$string['advlink:delta_height'] = '';
$string['advlink:delta_width'] = '';
$string['advlink:link_desc'] = 'Wstaw/edytuj link';
$string['advlink_dlg:accesskey'] = 'Klawisz skrótu';
$string['advlink_dlg:advanced_props'] = 'Zaawansowae właściwości';
$string['advlink_dlg:advanced_tab'] = 'Zaawansowany';
$string['advlink_dlg:anchor_names'] = 'Kotwice';
$string['advlink_dlg:classes'] = 'Klasy';
$string['advlink_dlg:encoding'] = 'Kodowanie znaków celu';
$string['advlink_dlg:event_props'] = 'Wydarzenia';
$string['advlink_dlg:events_tab'] = 'Wydarzenia';
$string['advlink_dlg:general_props'] = 'Ogólne właściwości';
$string['advlink_dlg:general_tab'] = 'Ogólny';
$string['advlink_dlg:height'] = 'Wysokość';
$string['advlink_dlg:id'] = 'ID';
$string['advlink_dlg:is_email'] = 'URL który otworzyłeś wydaje się być adresem mailowym. Czy chcesz dodać wymagany prefix mailto: ?';
$string['advlink_dlg:is_external'] = 'Podany adres wydaje się być zewnętrznym linkiem. Czy chcesz dodać wymagany prefix http:// ?';
$string['advlink_dlg:langcode'] = 'Kod języka';
$string['advlink_dlg:langdir'] = 'Kierunek czytania tekstu';
$string['advlink_dlg:link_list'] = 'Lista odnośników';
$string['advlink_dlg:list'] = 'Lista linków';
$string['advlink_dlg:ltr'] = 'Kierunek z lewej do prawej';
$string['advlink_dlg:mime'] = 'Cel MIME type';
$string['advlink_dlg:popup'] = 'Wyskakujące okienko JavaScript';
$string['advlink_dlg:popup_dependent'] = 'Podległy (Mozilla/Firefox wyłącznie)';
$string['advlink_dlg:popup_location'] = 'Pokaż pasek adresu';
$string['advlink_dlg:popup_menubar'] = 'Pokaż pasek menu';
$string['advlink_dlg:popup_name'] = 'Nazwa okiena';
$string['advlink_dlg:popup_opts'] = 'Opcje';
$string['advlink_dlg:popup_position'] = 'Pozycja (X/Y)';
$string['advlink_dlg:popup_props'] = 'Popup właściwości';
$string['advlink_dlg:popup_resizable'] = 'Stwórz okno z właściwościami zmiany rozmiaru';
$string['advlink_dlg:popup_return'] = 'Wklej \'return false\'';
$string['advlink_dlg:popup_scrollbars'] = 'Pokaż paski przewijania';
$string['advlink_dlg:popup_size'] = 'Rozmiar';
$string['advlink_dlg:popup_statusbar'] = 'Pokaż pasek statusu';
$string['advlink_dlg:popup_tab'] = 'Popup';
$string['advlink_dlg:popup_toolbar'] = 'Pokaż paski narzędzi';
$string['advlink_dlg:popup_url'] = 'URL okienka';
$string['advlink_dlg:rel'] = 'Relacje strony do celu';
$string['advlink_dlg:rev'] = 'Relacje celu do strony';
$string['advlink_dlg:rtl'] = 'Kierunek z prawej do lewej';
$string['advlink_dlg:style'] = 'Wzór';
$string['advlink_dlg:tabindex'] = 'Tabindex';
$string['advlink_dlg:target'] = 'Cel';
$string['advlink_dlg:target_blank'] = 'Otwórz w nowym oknie';
$string['advlink_dlg:target_langcode'] = 'Docelowy kod języka';
$string['advlink_dlg:target_name'] = 'Cel';
$string['advlink_dlg:target_parent'] = 'Otwórz w oknie/ramce nadrzędnej';
$string['advlink_dlg:target_same'] = 'Otwórz w tym oknie/ramce';
$string['advlink_dlg:target_top'] = 'Otwórz w górnej ramce (zamień wszystkie ramki)';
$string['advlink_dlg:title'] = 'Wstaw/edytuj link';
$string['advlink_dlg:titlefield'] = 'Tytuł';
$string['advlink_dlg:url'] = 'Link URL';
$string['advlink_dlg:width'] = 'Szerokość';
$string['advlist:circle'] = 'Okrąg';
$string['advlist:def'] = 'Domyślny';
$string['advlist:disc'] = 'Punkty';
$string['advlist:lower_alpha'] = 'małe';
$string['advlist:lower_greek'] = 'małe greckie';
$string['advlist:lower_roman'] = 'małe rzymskie';
$string['advlist:square'] = 'Kwadrat';
$string['advlist:types'] = 'Typy';
$string['advlist:upper_alpha'] = 'duże';
$string['advlist:upper_roman'] = 'duże rzymskie';
$string['aria:rich_text_area'] = 'Obszar tekstowy';
$string['autosave:restore_content'] = 'Przywróć automatycznie zapisaną zawartość';
$string['autosave:unload_msg'] = 'Zmiany, które zrobiłeś zostaną utracone jeśli opuścisz tę stronę.';
$string['autosave:warning_message'] = 'Jeśli przywrócisz zapisaną treść, stracisz całą bieżącą zawartość edytora.
Czy na pewno chcesz przywrócić zapisany stan?';
$string['availablebuttons'] = 'Dostępne przyciski';
$string['colors:000000'] = 'Czarny';
$string['colors:000080'] = 'Granatowy';
$string['colors:0000FF'] = 'Niebieski';
$string['colors:003300'] = 'Ciemnozielony';
$string['colors:003366'] = 'Ciemnobłękitny';
$string['colors:008000'] = 'Zielony';
$string['colors:00CCFF'] = 'Błękitny';
$string['colors:00FF00'] = 'Limonkowy';
$string['colors:33CCCC'] = 'Turkusowy';
$string['colors:800080'] = 'Purpurowy';
$string['colors:808000'] = 'Oliwkowy';
$string['colors:808080'] = 'Szary';
$string['colors:993366'] = 'Brązowy';
$string['colors:99CCFF'] = 'Jasnoniebieski';
$string['colors:C0C0C0'] = 'Srebrny';
$string['colors:CC99FF'] = 'Śliwkowy';
$string['colors:FF0000'] = 'Czerwony';
$string['colors:FF6600'] = 'Pomarańczowy';
$string['colors:FF9900'] = 'Bursztynowy';
$string['colors:FF99CC'] = 'Różowy';
$string['colors:FFCC00'] = 'Złoty';
$string['colors:FFCC99'] = 'Brzoskwiniowy';
$string['colors:FFFF00'] = 'Żółty';
$string['colors:FFFFFF'] = 'Biały';
$string['common:apply'] = 'Zastosuj';
$string['common:browse'] = 'Przeglądaj';
$string['common:cancel'] = 'Anuluj';
$string['common:class_name'] = 'Klasa';
$string['common:clipboard_msg'] = 'Funkcja kopiowania/wycinania/wklejania nie jest dostępna w przeglądarkach Mozilla i Firefox.
Czy chcesz uzyskać więcej informacji na ten temat?';
$string['common:clipboard_no_support'] = 'Obecnie nie jest obsługiwane przez Twoją przeglądarkę. Zamiast tego użyj skrótów klawiaturowych.';
$string['common:close'] = 'Zamknij';
$string['common:edit_confirm'] = 'Czy chcesz użyć trybu WYSIWYG dla tego pola formularza?';
$string['common:insert'] = 'Wstaw';
$string['common:invalid_data'] = 'Błąd: Zostały wprowadzone błędne dane, są zaznaczone na czerwono.';
$string['common:invalid_data_min'] = '{#field} musi być liczbą większą niż {#min}';
$string['common:invalid_data_number'] = '{#field} musi być liczbą';
$string['common:invalid_data_size'] = '{#field} musi być liczbą lub wartością procentową';
$string['common:more_colors'] = 'Więcej kolorów...';
$string['common:not_set'] = '-- Brak --';
$string['common:popup_blocked'] = 'Zauważyliśmy, że Twoje blokowanie wyskakujących okienek wyłączyło okno, które dostarcza funkcjonalność aplikacji. Będziesz potrzebował wyłączyć blokowanie wyskakujących okienek na tej stronie aby w pełni wykorzystać to narzędzie.';
$string['common:update'] = 'Aktualizuj';
$string['common:value'] = '(wartość)';
$string['contextmenu:align'] = 'Wyrównanie';
$string['contextmenu:center'] = 'Środkowy';
$string['contextmenu:full'] = 'Wypełniony';
$string['contextmenu:left'] = 'Lewy';
$string['contextmenu:right'] = 'Prawy';
$string['customconfig'] = 'Niestandardowa konfiguracja';
$string['customconfig_desc'] = 'Niestandardowa zaawansowana konfiguracja TinyMCE w formacie JSON, na przykład: {\'opcja1\': \'wartość2\', \'opcja2\': \'wartość2\'}. Wszelkie określone tutaj opcje zastępują ustawienia standardowe i wtyczki.';
$string['customtoolbar'] = 'Edytuj pasek narzędzi';
$string['customtoolbar_desc'] = 'Każda linia zawiera listę nazw przycisków oddzielonych przecinkami. Użyj „wrap” jako separatora grupy, puste linie są ignorowane. Zobacz <a href="{$a}" target="_blank">{$a}</a>, aby zapoznać się z listą domyślnych przycisków TinyMCE.<br />Pierwszy rząd będzie zawsze widoczny, natomiast widoczność drugiego i trzeciego paska narzędzi można przełączać.';
$string['directionality:ltr_desc'] = 'Kierunek od lewej do prawej';
$string['directionality:rtl_desc'] = 'Kierunek od prawej do lewej';
$string['emotions:delta_height'] = '';
$string['emotions:delta_width'] = '';
$string['emotions:emotions_desc'] = 'Emotikony';
$string['emotions_dlg:cool'] = 'luzak';
$string['emotions_dlg:cry'] = 'Cry';
$string['emotions_dlg:desc'] = 'Emotikony';
$string['emotions_dlg:embarassed'] = 'Embarassed';
$string['emotions_dlg:foot_in_mouth'] = 'Foot in mouth';
$string['emotions_dlg:frown'] = 'Frown';
$string['emotions_dlg:innocent'] = 'Innocent';
$string['emotions_dlg:kiss'] = 'Kiss';
$string['emotions_dlg:laughing'] = 'Laughing';
$string['emotions_dlg:money_mouth'] = 'Money mouth';
$string['emotions_dlg:sealed'] = 'Sealed';
$string['emotions_dlg:smile'] = 'Smile';
$string['emotions_dlg:surprised'] = 'Zaskoczony';
$string['emotions_dlg:title'] = 'Wstaw emotikonę';
$string['emotions_dlg:tongue_out'] = 'Z językiem';
$string['emotions_dlg:undecided'] = 'Undecided';
$string['emotions_dlg:usage'] = 'Użyj strzałek w lewo i w prawo by nawigować.';
$string['emotions_dlg:wink'] = 'Puścić oczko';
$string['emotions_dlg:yell'] = 'Yell';
$string['fontselectlist'] = 'Lista dostępnych czcionek';
$string['fullpage:delta_height'] = '';
$string['fullpage:delta_width'] = '';
$string['fullpage:desc'] = 'Właściwości dokumentu';
$string['fullpage_dlg:active_color'] = 'Kolor aktywnych linków';
$string['fullpage_dlg:add'] = 'Dodaj nowy element';
$string['fullpage_dlg:add_base'] = 'Baza';
$string['fullpage_dlg:add_comment'] = 'Komentarz';
$string['fullpage_dlg:add_link'] = 'Odnośnik';
$string['fullpage_dlg:add_meta'] = 'Meta tag';
$string['fullpage_dlg:add_script'] = 'Skrypt';
$string['fullpage_dlg:add_style'] = 'Styl';
$string['fullpage_dlg:add_title'] = 'Tytuł';
$string['fullpage_dlg:advanced_props'] = 'Zaawansowane';
$string['fullpage_dlg:advanced_tab'] = 'Zaawansowane';
$string['fullpage_dlg:appearance_bgprops'] = 'Właściwości tła';
$string['fullpage_dlg:appearance_linkprops'] = 'Kolor odnośników';
$string['fullpage_dlg:appearance_marginprops'] = 'Marginesy strony';
$string['fullpage_dlg:appearance_style'] = 'Arkusze i właściwości stylów';
$string['fullpage_dlg:appearance_tab'] = 'Wygląd';
$string['fullpage_dlg:appearance_textprops'] = 'Właściwości tekstu';
$string['fullpage_dlg:author'] = 'Autor';
$string['fullpage_dlg:base_element'] = 'Baza';
$string['fullpage_dlg:bgcolor'] = 'Kolor tła';
$string['fullpage_dlg:bgimage'] = 'Obrazek tła';
$string['fullpage_dlg:bottom_margin'] = 'Dolny margines';
$string['fullpage_dlg:charset'] = 'Kodowanie';
$string['fullpage_dlg:comment_element'] = 'Komentarz';
$string['fullpage_dlg:content'] = 'Zawartość';
$string['fullpage_dlg:copyright'] = 'Prawa autorskie';
$string['fullpage_dlg:defer'] = 'Defer';
$string['fullpage_dlg:doctypes'] = 'Typ dokumentu';
$string['fullpage_dlg:encoding'] = 'Kodowanie znaków';
$string['fullpage_dlg:font_face'] = 'Czcionka';
$string['fullpage_dlg:font_size'] = 'Rozmiar czcionki';
$string['fullpage_dlg:fontface'] = 'Rodzaj czcionki';
$string['fullpage_dlg:fontsize'] = 'Rozmiar czcionki';
$string['fullpage_dlg:general_props'] = 'Główne';
$string['fullpage_dlg:head_elements'] = 'Elementy nagłówka';
$string['fullpage_dlg:hover_color'] = 'Kolor po najechaniu myszką';
$string['fullpage_dlg:href'] = 'HREF';
$string['fullpage_dlg:hreflang'] = 'Język odnośnika';
$string['fullpage_dlg:info'] = 'Informacja';
$string['fullpage_dlg:langcode'] = 'Oznaczenie kodowe języka';
$string['fullpage_dlg:langdir'] = 'Kierunek czytania tekstu';
$string['fullpage_dlg:langprops'] = 'Język i kodowanie';
$string['fullpage_dlg:language'] = 'Język';
$string['fullpage_dlg:left_margin'] = 'Lewy margines';
$string['fullpage_dlg:link_color'] = 'Kolor odnośnika';
$string['fullpage_dlg:link_element'] = 'Odnośnik';
$string['fullpage_dlg:ltr'] = 'Kierunek z lewej do prawej';
$string['fullpage_dlg:media'] = 'Media';
$string['fullpage_dlg:meta_description'] = 'Opis';
$string['fullpage_dlg:meta_element'] = 'Meta tag';
$string['fullpage_dlg:meta_index_follow'] = 'Indeksuj i podążaj za linkami';
$string['fullpage_dlg:meta_index_nofollow'] = 'Indeksuj i nie podążaj za odnośnikami';
$string['fullpage_dlg:meta_keywords'] = 'Słowa kluczowe';
$string['fullpage_dlg:meta_noindex_follow'] = 'Nie indeksuj i podążaj za odnośnikami';
$string['fullpage_dlg:meta_noindex_nofollow'] = 'Nie indeksuj i nie podążaj za odnośnikami';
$string['fullpage_dlg:meta_props'] = 'Meta informacje';
$string['fullpage_dlg:meta_robots'] = 'Robots';
$string['fullpage_dlg:meta_tab'] = 'Ogólne';
$string['fullpage_dlg:meta_title'] = 'Tytuł';
$string['fullpage_dlg:movedown'] = 'Przesuń wybrane element w dół';
$string['fullpage_dlg:moveup'] = 'Przesuń wybrane element do góry';
$string['fullpage_dlg:name'] = 'Nazwa';
$string['fullpage_dlg:properties'] = 'Właściwości';
$string['fullpage_dlg:rel'] = 'Rel';
$string['fullpage_dlg:remove'] = 'Usuń wybrany element';
$string['fullpage_dlg:rev'] = 'Rev';
$string['fullpage_dlg:right_margin'] = 'Prawy margines';
$string['fullpage_dlg:rtl'] = 'Kierunek z prawej do lewej';
$string['fullpage_dlg:script_element'] = 'Skrypt';
$string['fullpage_dlg:src'] = 'Źródło';
$string['fullpage_dlg:style'] = 'Styl';
$string['fullpage_dlg:style_element'] = 'Styl';
$string['fullpage_dlg:stylesheet'] = 'Arkusz stylów';
$string['fullpage_dlg:target'] = 'Cel';
$string['fullpage_dlg:text_color'] = 'Kolor tekstu';
$string['fullpage_dlg:textcolor'] = 'Kolor';
$string['fullpage_dlg:title'] = 'Właściwości dokumentu';
$string['fullpage_dlg:title_element'] = 'Tytuł';
$string['fullpage_dlg:top_margin'] = 'Górny margines';
$string['fullpage_dlg:type'] = 'Typ';
$string['fullpage_dlg:value'] = 'Wartość';
$string['fullpage_dlg:visited_color'] = 'Kolor odwiedzonych linków';
$string['fullpage_dlg:xml_pi'] = 'XML deklaracja';
$string['fullscreen:desc'] = 'Przełącz tryb pełnoekranowy';
$string['iespell:download'] = 'ieSpell nie wykryte. Czy przeprowadzić instalację tego komponentu?';
$string['iespell:iespell_desc'] = 'Sprawdź pisownię';
$string['insertdatetime:date_fmt'] = '%Y-%m-%d';
$string['insertdatetime:day_long'] = 'Niedziela, Poniedziałek, Wtorek, Środa, Czwartek, Piątek, Sobota, Niedziela';
$string['insertdatetime:day_short'] = 'N,Pn,Wt,Śr,Cz,Pt,So,N';
$string['insertdatetime:insertdate_desc'] = 'Wstaw datę';
$string['insertdatetime:inserttime_desc'] = 'Wstaw czas';
$string['insertdatetime:months_long'] = 'Styczeń,Luty,Marzec,Kwiecień,Maj,Czerwiec,Lipiec,Sierpień,Wrzesień,Październik,Listopad,Grudzień';
$string['insertdatetime:months_short'] = 'Sty,Lut,Mar,Kwi,Maj,Cze,Lip,Sie,Wrz,Paź,Lis,Gru';
$string['insertdatetime:time_fmt'] = '%H:%M:%S';
$string['layer:absolute_desc'] = 'Przełącz pozycjonowanie absolutne';
$string['layer:backward_desc'] = 'Przesuń w tył';
$string['layer:content'] = 'Nowa warstwa...';
$string['layer:forward_desc'] = 'Przesuń do przodu';
$string['layer:insertlayer_desc'] = 'Wklej nową warstwę';
$string['media:delta_height'] = '';
$string['media:delta_width'] = '';
$string['media:desc'] = 'Wstaw/edytuj zagnieżdzone media';
$string['media:edit'] = 'Edytuj wbudowane media';
$string['media_dlg:advanced'] = 'Zaawansowany';
$string['media_dlg:align'] = 'Wyrównaj';
$string['media_dlg:align_bottom'] = 'Dół';
$string['media_dlg:align_bottom_left'] = 'Dolny lewy';
$string['media_dlg:align_bottom_right'] = 'Dolny prawy';
$string['media_dlg:align_center'] = 'Środek';
$string['media_dlg:align_left'] = 'Lewo';
$string['media_dlg:align_right'] = 'Prawo';
$string['media_dlg:align_top'] = 'Góra';
$string['media_dlg:align_top_left'] = 'Górny lewy';
$string['media_dlg:align_top_right'] = 'Górny prawy';
$string['media_dlg:altsource1'] = 'Alternatywne źródło 1';
$string['media_dlg:altsource2'] = 'Alternatywne źródło 2';
$string['media_dlg:audio'] = 'Audio HTML5';
$string['media_dlg:autogotourl'] = 'Auto goto URL';
$string['media_dlg:autohref'] = 'Auto HREF';
$string['media_dlg:autostart'] = 'Auto start';
$string['media_dlg:balance'] = 'Balance';
$string['media_dlg:base'] = 'Baza';
$string['media_dlg:baseurl'] = 'Base URL';
$string['media_dlg:bgcolor'] = 'Tło';
$string['media_dlg:cache'] = 'Cache';
$string['media_dlg:captioningid'] = 'Captioning id';
$string['media_dlg:center'] = 'Środek';
$string['media_dlg:class_name'] = 'Klasa';
$string['media_dlg:console'] = 'Konsola';
$string['media_dlg:constrain_proportions'] = 'Zachowaj proporcje';
$string['media_dlg:controller'] = 'Controller';
$string['media_dlg:controls'] = 'Controls';
$string['media_dlg:correction'] = 'Bez korekcji';
$string['media_dlg:currentmarker'] = 'Current marker';
$string['media_dlg:currentposition'] = 'Aktualna pozycja';
$string['media_dlg:defaultframe'] = 'Default frame';
$string['media_dlg:embedded_audio_options'] = 'Opcje zagnieżdżonego audio';
$string['media_dlg:embeddedaudio'] = 'Zagnieżdżone audio';
$string['media_dlg:enabled'] = 'Włączone';
$string['media_dlg:enablejavascript'] = 'Włącz JavaScript';
$string['media_dlg:endtime'] = 'End time';
$string['media_dlg:file'] = 'Plik/URL';
$string['media_dlg:flash'] = 'Flash';
$string['media_dlg:flash_options'] = 'Flash opcje';
$string['media_dlg:flashvars'] = 'Flashvars';
$string['media_dlg:fullscreen'] = 'Pełny ekran';
$string['media_dlg:general'] = 'Główny';
$string['media_dlg:hidden'] = 'Ukryty';
$string['media_dlg:href'] = 'Href';
$string['media_dlg:hspace'] = 'H-Space';
$string['media_dlg:html5_audio_options'] = 'Opcje audio';
$string['media_dlg:html5_video_options'] = 'Opcje wideo HTML5';
$string['media_dlg:id'] = 'Id';
$string['media_dlg:iframe'] = 'Pływająca ramka';
$string['media_dlg:imagestatus'] = 'Status obrazu';
$string['media_dlg:invokeurls'] = 'Odwołaj się do URLs';
$string['media_dlg:kioskmode'] = 'Kiosk mode';
$string['media_dlg:list'] = 'Lista';
$string['media_dlg:liveconnect'] = 'SWLiveConnect';
$string['media_dlg:loop'] = 'Zapętlenie';
$string['media_dlg:maintainaspect'] = 'Maintain aspect';
$string['media_dlg:menu'] = 'Pokaż menu';
$string['media_dlg:mute'] = 'Wycisz';
$string['media_dlg:name'] = 'Nazwa';
$string['media_dlg:nojava'] = 'No java';
$string['media_dlg:numloop'] = 'Liczba powtórzeń';
$string['media_dlg:play'] = 'Autoodtwarzanie';
$string['media_dlg:playcount'] = 'Play count';
$string['media_dlg:playeveryframe'] = 'Play every frame';
$string['media_dlg:poster'] = 'Plakat';
$string['media_dlg:prefetch'] = 'Prefetch';
$string['media_dlg:preload'] = 'Wstępne ładowanie';
$string['media_dlg:preload_auto'] = 'Pozwól zdecydować przeglądarce użytkownika';
$string['media_dlg:preload_metadata'] = 'Wstępne ładowanie metadanych wideo';
$string['media_dlg:preload_none'] = 'Nie ładuj wstępnie';
$string['media_dlg:preview'] = 'Podgląd';
$string['media_dlg:progress'] = 'Postęp';
$string['media_dlg:qt_options'] = 'Opcje QuickTime';
$string['media_dlg:qt_stream_warn'] = 'Strumieniowane zasoby RTSP należy dodać do pola źródła QT w zakładce zaawansowane.
Do pola źródła należy również dodać wersję niestrumieniową.';
$string['media_dlg:qtsrc'] = 'Żródło QT';
$string['media_dlg:qtsrcchokespeed'] = 'Choke speed';
$string['media_dlg:quality'] = 'Jakość';
$string['media_dlg:quicktime'] = 'QuickTime';
$string['media_dlg:rate'] = 'Rate';
$string['media_dlg:realmedia'] = 'Real Media';
$string['media_dlg:rmp_options'] = 'Opcje Real Media Player';
$string['media_dlg:salign'] = 'SAlign';
$string['media_dlg:scale'] = 'Skala';
$string['media_dlg:scriptcallbacks'] = 'Script callbacks';
$string['media_dlg:shockwave'] = 'Shockwave';
$string['media_dlg:shockwave_options'] = 'Shockwave options';
$string['media_dlg:shuffle'] = 'Losowo';
$string['media_dlg:size'] = 'Wymiary';
$string['media_dlg:sound'] = 'Dźwięk';
$string['media_dlg:source'] = 'źródło';
$string['media_dlg:starttime'] = 'Start time';
$string['media_dlg:stretchtofit'] = 'Rozciągnij aby dopasować';
$string['media_dlg:swstretchhalign'] = 'Stretch H-Align';
$string['media_dlg:swstretchstyle'] = 'Stretch style';
$string['media_dlg:swstretchvalign'] = 'Stretch V-Align';
$string['media_dlg:target'] = 'Komórka';
$string['media_dlg:targetcache'] = 'Target cache';
$string['media_dlg:title'] = 'Wstawianie/edycja osadzonych multimediów';
$string['media_dlg:type'] = 'Typ';
$string['media_dlg:uimode'] = 'UI Mode';
$string['media_dlg:video'] = 'Wideo HTML5';
$string['media_dlg:volume'] = 'Głośność';
$string['media_dlg:vspace'] = 'V-Space';
$string['media_dlg:windowlessvideo'] = 'Windowless video';
$string['media_dlg:windowsmedia'] = 'Windows Media';
$string['media_dlg:wmode'] = 'WMode';
$string['media_dlg:wmp_options'] = 'Opcje Windows Media Player';
$string['nonbreaking:nonbreaking_desc'] = 'Wstaw twardą spację';
$string['pagebreak:desc'] = 'Wstaw linię do wydruku';
$string['paste:paste_text_desc'] = 'Wklej jako zwykły tekst';
$string['paste:paste_word_desc'] = 'Wklej z Worda';
$string['paste:plaintext_mode'] = 'Wklejasz teraz w trybie czystego tekstu. Kliknij ponownie, aby przełączyć z powrotem do normalnego trybu wklejania (z formatowaniem).';
$string['paste:plaintext_mode_stick'] = 'Wklejanie jest w trybie zwykłego tekstu. Kliknij ponownie, aby przełączyć z powrotem do normalnego trybu wklejania.';
$string['paste:selectall_desc'] = 'Zaznacz wszystko';
$string['paste_dlg:text_linebreaks'] = 'Zachowaj końce linii.';
$string['paste_dlg:text_title'] = 'Użyj CTRL+V na swojej klawiaturze żeby wkleić tekst do okna.';
$string['paste_dlg:word_title'] = 'Użyj CTRL+V na swojej klawiaturze żeby wkleić tekst do okna.';
$string['pluginname'] = 'Edytor HTML TinyMCE (starsza wersja)';
$string['preview:preview_desc'] = 'Podgląd';
$string['print:print_desc'] = 'Drukuj';
$string['privacy:metadata'] = 'Wtyczka edytora HTML TinyMCE nie przechowuje żadnych danych osobowych.';
$string['save:cancel_desc'] = 'Anuluj wszystkie zmiany';
$string['save:save_desc'] = 'Zachowaj';
$string['searchreplace:delta_height'] = '';
$string['searchreplace:delta_width'] = '';
$string['searchreplace:replace_desc'] = 'Znajdź/zamień';
$string['searchreplace:search_desc'] = 'Znajdź';
$string['searchreplace_dlg:allreplaced'] = 'Wszystkie wystąpienia szukanego fragmentu zostały zastąpione.';
$string['searchreplace_dlg:direction'] = 'Kierunek';
$string['searchreplace_dlg:down'] = 'W dół';
$string['searchreplace_dlg:findnext'] = 'Znajdź następny';
$string['searchreplace_dlg:findwhat'] = 'Znajdź...';
$string['searchreplace_dlg:mcase'] = 'Dopasuj case';
$string['searchreplace_dlg:notfound'] = 'Wyszukiwanie zakończone. Poszukiwany fragment nie został znaleziony.';
$string['searchreplace_dlg:replace'] = 'Zamień';
$string['searchreplace_dlg:replace_title'] = 'Znajdź/zamień';
$string['searchreplace_dlg:replaceall'] = 'Zamień wszystko';
$string['searchreplace_dlg:replacewith'] = 'Zamień z...';
$string['searchreplace_dlg:search_title'] = 'Znajdź';
$string['searchreplace_dlg:searchnext_desc'] = 'Znajdź ponownie';
$string['searchreplace_dlg:up'] = 'W górę';
$string['settings'] = 'Ustawienia ogólne';
$string['simple:bold_desc'] = 'Pogrubienie (Ctrl+B)';
$string['simple:bullist_desc'] = 'Wstaw / usuń listę z wypunktowaniem';
$string['simple:cleanup_desc'] = 'Wyczyść nieuporządkowany kod';
$string['simple:italic_desc'] = 'Kursywa (Ctrl+I)';
$string['simple:numlist_desc'] = 'Wstaw / usuń listę numerowaną';
$string['simple:redo_desc'] = 'Ponów (Ctrl+Y)';
$string['simple:striketrough_desc'] = 'Przekreślenie';
$string['simple:underline_desc'] = 'Podkreślenie (Ctrl+U)';
$string['simple:undo_desc'] = 'Cofnij (Ctrl+Z)';
$string['spellchecker:desc'] = 'Włącz sprawdzanie pisowni';
$string['spellchecker:ignore_word'] = 'Ignoruj słowo';
$string['spellchecker:ignore_words'] = 'Ignoruj wszystkie';
$string['spellchecker:langs'] = 'Języki';
$string['spellchecker:learn_word'] = 'Naucz się słowa';
$string['spellchecker:menu'] = 'Ustawienia sprawdzania pisowni';
$string['spellchecker:no_mpell'] = 'Żadnych brakujących nie znaleziono.';
$string['spellchecker:no_sug'] = 'Brak sugestii';
$string['spellchecker:sug'] = 'Sugestie';
$string['spellchecker:wait'] = 'Proszę poczekać...';
$string['style:delta_height'] = '';
$string['style:delta_width'] = '';
$string['style:desc'] = 'Edytuj Style CSS';
$string['style_dlg:apply'] = 'Zastosuj';
$string['style_dlg:background'] = 'Tło';
$string['style_dlg:background_attachment'] = 'Załącznik';
$string['style_dlg:background_color'] = 'Kolor tła';
$string['style_dlg:background_hpos'] = 'Pozycja pozioma';
$string['style_dlg:background_image'] = 'Obrazek tła';
$string['style_dlg:background_repeat'] = 'Powtórz';
$string['style_dlg:background_tab'] = 'Tło';
$string['style_dlg:background_vpos'] = 'Pozycja pionowa';
$string['style_dlg:block'] = 'Blok';
$string['style_dlg:block_display'] = 'Widoczność';
$string['style_dlg:block_letterspacing'] = 'Odstęp między literami';
$string['style_dlg:block_tab'] = 'Zablokuj';
$string['style_dlg:block_text_align'] = 'Wyrównać tekst';
$string['style_dlg:block_text_indent'] = 'Akapit w tekście';
$string['style_dlg:block_vertical_alignment'] = 'Pionowe wyrównanie';
$string['style_dlg:block_whitespace'] = 'Biała przestrzeń';
$string['style_dlg:block_wordspacing'] = 'Odstęp między wyrazami';
$string['style_dlg:border'] = 'Obramowanie';
$string['style_dlg:border_tab'] = 'Obramowanie';
$string['style_dlg:bottom'] = 'Dół';
$string['style_dlg:box_clear'] = 'Wyczyść';
$string['style_dlg:box_float'] = 'Pływanie';
$string['style_dlg:box_height'] = 'Wysokość';
$string['style_dlg:box_tab'] = 'Box';
$string['style_dlg:box_width'] = 'Szerokość';
$string['style_dlg:bullet_image'] = 'Obrazek listy';
$string['style_dlg:clip'] = 'Clip';
$string['style_dlg:color'] = 'Kolor';
$string['style_dlg:height'] = 'Wysokość';
$string['style_dlg:left'] = 'Lewy';
$string['style_dlg:list'] = 'Lista';
$string['style_dlg:list_tab'] = 'Lista';
$string['style_dlg:list_type'] = 'Typ';
$string['style_dlg:margin'] = 'Margines';
$string['style_dlg:overflow'] = 'Przepełniony';
$string['style_dlg:padding'] = 'Odstępy';
$string['style_dlg:placement'] = 'Umieszczenie';
$string['style_dlg:position'] = 'Pozycja';
$string['style_dlg:positioning_tab'] = 'Pozycjonowanie';
$string['style_dlg:positioning_type'] = 'Typ';
$string['style_dlg:right'] = 'Prawy';
$string['style_dlg:same'] = 'To samo dla wszystkich';
$string['style_dlg:style'] = 'Styl';
$string['style_dlg:text'] = 'Tekst';
$string['style_dlg:text_blink'] = 'Miganie';
$string['style_dlg:text_case'] = 'Case';
$string['style_dlg:text_color'] = 'Kolor';
$string['style_dlg:text_decoration'] = 'Dekoracja';
$string['style_dlg:text_font'] = 'Wzór czcionki';
$string['style_dlg:text_lineheight'] = 'Linia wysokości';
$string['style_dlg:text_none'] = 'Żaden';
$string['style_dlg:text_overline'] = 'Nadkreślenie';
$string['style_dlg:text_props'] = 'Tekst';
$string['style_dlg:text_size'] = 'Rozmiar';
$string['style_dlg:text_striketrough'] = 'Przekreślenie';
$string['style_dlg:text_style'] = 'Styl';
$string['style_dlg:text_tab'] = 'Text';
$string['style_dlg:text_underline'] = 'Podkreślenie';
$string['style_dlg:text_variant'] = 'Wariant';
$string['style_dlg:text_weight'] = 'Waga';
$string['style_dlg:title'] = 'Edytuj CSS Style';
$string['style_dlg:toggle_insert_span'] = 'Wstaw zakres w miejscu zaznaczenia';
$string['style_dlg:top'] = 'Góra';
$string['style_dlg:visibility'] = 'Widoczność';
$string['style_dlg:width'] = 'Szerokość';
$string['style_dlg:zindex'] = 'Z-index';
$string['subplugintype_tinymce'] = 'Wtyczka';
$string['subplugintype_tinymce_plural'] = 'Wtyczki';
$string['table:cell'] = 'Komórka';
$string['table:cell_desc'] = 'Właściwości komórki';
$string['table:cellprops_delta_height'] = '';
$string['table:cellprops_delta_width'] = '';
$string['table:col'] = 'Kolumna';
$string['table:col_after_desc'] = 'Wstaw kolumnę po...';
$string['table:col_before_desc'] = 'Wstaw kolumnę przed...';
$string['table:copy_row_desc'] = 'Kopiuj wiersz...';
$string['table:cut_row_desc'] = 'Wytnij wiersz...';
$string['table:del'] = 'Usuń tabelę';
$string['table:delete_col_desc'] = 'Usuń kolumnę';
$string['table:delete_row_desc'] = 'Usuń wiersz';
$string['table:desc'] = 'Wstaw/edytuj tabelę';
$string['table:merge_cells_delta_height'] = '';
$string['table:merge_cells_delta_width'] = '';
$string['table:merge_cells_desc'] = 'Połącz komórki';
$string['table:paste_row_after_desc'] = 'Wklej wiersz po...';
$string['table:paste_row_before_desc'] = 'Wklej wiersz przed...';
$string['table:props_desc'] = 'Właściwości tabeli';
$string['table:row'] = 'Wiersz';
$string['table:row_after_desc'] = 'Wstaw nowy wiersz po...';
$string['table:row_before_desc'] = 'Wstaw nowy wiersz przed...';
$string['table:row_desc'] = 'Właściwości wiersza';
$string['table:rowprops_delta_height'] = '';
$string['table:rowprops_delta_width'] = '';
$string['table:split_cells_desc'] = 'Podziel komórkę';
$string['table:table_delta_height'] = '';
$string['table:table_delta_width'] = '';
$string['table_dlg:advanced_props'] = 'Zaawansowane właściwości';
$string['table_dlg:advanced_tab'] = 'Zaawansowana';
$string['table_dlg:align'] = 'Wyrównanie';
$string['table_dlg:align_bottom'] = 'Dół';
$string['table_dlg:align_default'] = 'Domyślnie';
$string['table_dlg:align_left'] = 'Lewy';
$string['table_dlg:align_middle'] = 'Środek';
$string['table_dlg:align_right'] = 'Prawy';
$string['table_dlg:align_top'] = 'Góra';
$string['table_dlg:bgcolor'] = 'Kolor tła';
$string['table_dlg:bgimage'] = 'Obrazek tła';
$string['table_dlg:border'] = 'Ramka';
$string['table_dlg:bordercolor'] = 'Kolor ramki';
$string['table_dlg:caption'] = 'Nagłówek tabeli';
$string['table_dlg:cell_all'] = 'Zmień wszytkie komórki w tabeli';
$string['table_dlg:cell_cell'] = 'Zmień aktualną komórkę';
$string['table_dlg:cell_col'] = 'Aktualizuj wszystkie komórki w kolumnie';
$string['table_dlg:cell_limit'] = 'Przekroczyłeś maksymalną liczbę komórek która wynosi {$cells}.';
$string['table_dlg:cell_row'] = 'Zmień wszytkie komórki w wierszu';
$string['table_dlg:cell_title'] = 'Właściwości komórki';
$string['table_dlg:cell_type'] = 'Typ komórki';
$string['table_dlg:cellpadding'] = 'Marginesy wew. kom.';
$string['table_dlg:cellspacing'] = 'Odstępy między komórkami';
$string['table_dlg:col_limit'] = 'Przekroczyłeś maksymalną liczbę kolumn która wynosi {$cols}.';
$string['table_dlg:colgroup'] = 'Grupa kolumn';
$string['table_dlg:cols'] = 'Kolumny';
$string['table_dlg:frame'] = 'Ramka';
$string['table_dlg:frame_all'] = 'wszystkie';
$string['table_dlg:frame_cols'] = 'kolumny';
$string['table_dlg:frame_groups'] = 'grupy';
$string['table_dlg:frame_none'] = 'brak';
$string['table_dlg:frame_rows'] = 'wiersze';
$string['table_dlg:general_props'] = 'Główne właściwości';
$string['table_dlg:general_tab'] = 'Główna';
$string['table_dlg:height'] = 'Wysokość';
$string['table_dlg:id'] = 'ID';
$string['table_dlg:langcode'] = 'Oznaczenie kodowe języka';
$string['table_dlg:langdir'] = 'Kierunek czytania tekstu';
$string['table_dlg:ltr'] = 'Kierunek z lewej do prawej';
$string['table_dlg:merge_cells_title'] = 'Połącz komórki';
$string['table_dlg:mime'] = 'Docelowy typ MIME';
$string['table_dlg:missing_scope'] = 'Jesteś pewny że chcesz kontynuować bez definiowania zasięgu dla komórki tabeli. Bez niej, może być trudne dla niektórych użytkowników zrozuminie zawartości albo danych wyświetlanych poza tabelą.';
$string['table_dlg:row_all'] = 'Zmień wszystkie wiersze';
$string['table_dlg:row_even'] = 'Zmień parzyste wiersze';
$string['table_dlg:row_limit'] = 'Przekroczyłeś maksymalną liczbę wierszy która wynosi {$rows}.';
$string['table_dlg:row_odd'] = 'Zmień nieparzyste wiersze';
$string['table_dlg:row_row'] = 'Zmień aktualny wiersz';
$string['table_dlg:row_title'] = 'Właściwości wiersza';
$string['table_dlg:rowgroup'] = 'Grupa wierszy';
$string['table_dlg:rows'] = 'Wiersze';
$string['table_dlg:rowtype'] = 'Typ wiersza';
$string['table_dlg:rtl'] = 'Kierunek z prawej do lewej';
$string['table_dlg:rules'] = 'Prowadnice';
$string['table_dlg:rules_above'] = 'nad';
$string['table_dlg:rules_below'] = 'pod';
$string['table_dlg:rules_border'] = 'border';
$string['table_dlg:rules_box'] = 'box';
$string['table_dlg:rules_hsides'] = 'hsides';
$string['table_dlg:rules_lhs'] = 'lhs';
$string['table_dlg:rules_rhs'] = 'rhs';
$string['table_dlg:rules_void'] = 'void';
$string['table_dlg:rules_vsides'] = 'vsides';
$string['table_dlg:scope'] = 'Zakres';
$string['table_dlg:style'] = 'Styl';
$string['table_dlg:summary'] = 'Podsumowanie';
$string['table_dlg:tbody'] = 'Ciało tabeli';
$string['table_dlg:td'] = 'Data';
$string['table_dlg:tfoot'] = 'Stopka';
$string['table_dlg:th'] = 'Nagłowek';
$string['table_dlg:thead'] = 'Nagłówek';
$string['table_dlg:title'] = 'Wstaw/edytuj tabele';
$string['table_dlg:valign'] = 'Pionowe wyrównanie';
$string['table_dlg:width'] = 'Szerokość';
$string['template:desc'] = 'Wstaw szablon dokumentu';
$string['template_dlg:cdate_format'] = '%Y-%m-%d %H:%M:%S';
$string['template_dlg:day_long'] = 'Niedziela,Poniedziałek,Wtorek,Środa,Czwartek,Piątek,Sobota,Niedziela';
$string['template_dlg:day_short'] = 'N,Pn,Wt,Śr,Cz,Pt,So,N';
$string['template_dlg:desc'] = 'Wstaw szablon dokumentu';
$string['template_dlg:desc_label'] = 'Opis';
$string['template_dlg:label'] = 'Szablon';
$string['template_dlg:mdate_format'] = '%Y-%m-%d %H:%M:%S';
$string['template_dlg:months_long'] = 'Styczeń,Luty,Marzec,Kwiecień,Maj,Czerwiec,Lipiec,Sierpień,Wrzesień,Październik,Listopad,Grudzień';
$string['template_dlg:months_short'] = 'Sty,Lut,Mar,Kwi,Maj,Cze,Lip,Sie,Wrz,Paź,Lis,Gru';
$string['template_dlg:preview'] = 'Podgląd';
$string['template_dlg:select'] = 'Wybierz szablon';
$string['template_dlg:title'] = 'Szablony';
$string['template_dlg:warning'] = 'Uwaga: Aktualizacja szablonów może spowodować utratę danych.';
$string['visualblocks:desc'] = 'Pokaż / ukryj elementy blokowe';
$string['visualchars:desc'] = 'Graficzna kontrola pisma włącz/wyłącz.';
$string['wordcount:words'] = 'Słowa:';
$string['xhtmlxtras:abbr_delta_height'] = '';
$string['xhtmlxtras:abbr_delta_width'] = '';
$string['xhtmlxtras:abbr_desc'] = 'Skrót';
$string['xhtmlxtras:acronym_delta_height'] = '';
$string['xhtmlxtras:acronym_delta_width'] = '';
$string['xhtmlxtras:acronym_desc'] = 'Akronim';
$string['xhtmlxtras:attribs_delta_height'] = '';
$string['xhtmlxtras:attribs_delta_width'] = '';
$string['xhtmlxtras:attribs_desc'] = 'Wstaw/edytuj atrybuty';
$string['xhtmlxtras:cite_delta_height'] = '';
$string['xhtmlxtras:cite_delta_width'] = '';
$string['xhtmlxtras:cite_desc'] = 'Osoba cytowana';
$string['xhtmlxtras:del_delta_height'] = '';
$string['xhtmlxtras:del_delta_width'] = '';
$string['xhtmlxtras:del_desc'] = 'Usunięcie';
$string['xhtmlxtras:ins_delta_height'] = '';
$string['xhtmlxtras:ins_delta_width'] = '';
$string['xhtmlxtras:ins_desc'] = 'Wstawianie';
$string['xhtmlxtras_dlg:attrib_tab'] = 'Atrybuty';
$string['xhtmlxtras_dlg:attribs_title'] = 'Wstaw/edytuj atrybuty';
$string['xhtmlxtras_dlg:attribute_attrib_tab'] = 'Atrybuty';
$string['xhtmlxtras_dlg:attribute_events_tab'] = 'Wydarzenia';
$string['xhtmlxtras_dlg:attribute_label_accesskey'] = 'AccessKey';
$string['xhtmlxtras_dlg:attribute_label_cite'] = 'Osoba cytowana';
$string['xhtmlxtras_dlg:attribute_label_class'] = 'Klasa';
$string['xhtmlxtras_dlg:attribute_label_datetime'] = 'Data/czas';
$string['xhtmlxtras_dlg:attribute_label_id'] = 'ID';
$string['xhtmlxtras_dlg:attribute_label_langcode'] = 'Język';
$string['xhtmlxtras_dlg:attribute_label_langdir'] = 'Kierunek czytania tekstu';
$string['xhtmlxtras_dlg:attribute_label_style'] = 'Styl';
$string['xhtmlxtras_dlg:attribute_label_tabindex'] = 'TabIndex';
$string['xhtmlxtras_dlg:attribute_label_title'] = 'Tytuł';
$string['xhtmlxtras_dlg:attribute_option_ltr'] = 'Kierunek z lewej do prawej';
$string['xhtmlxtras_dlg:attribute_option_rtl'] = 'Kierunek z prawej do lewej';
$string['xhtmlxtras_dlg:events_tab'] = 'Wydarzenia';
$string['xhtmlxtras_dlg:fieldset_attrib_tab'] = 'Atrybuty';
$string['xhtmlxtras_dlg:fieldset_events_tab'] = 'Zdarzenia';
$string['xhtmlxtras_dlg:fieldset_general_tab'] = 'Główne ustawienia';
$string['xhtmlxtras_dlg:general_tab'] = 'Główny';
$string['xhtmlxtras_dlg:insert_date'] = 'Wklej aktualną datę/czas';
$string['xhtmlxtras_dlg:option_ltr'] = 'Kierunek z lewej do prawej';
$string['xhtmlxtras_dlg:option_rtl'] = 'Kierunek z prawej do lewej';
$string['xhtmlxtras_dlg:remove'] = 'Usuń';
$string['xhtmlxtras_dlg:title_abbr_element'] = 'Abbreviation Element';
$string['xhtmlxtras_dlg:title_acronym_element'] = 'Element akronimu';
$string['xhtmlxtras_dlg:title_cite_element'] = 'Osoba cytowana';
$string['xhtmlxtras_dlg:title_del_element'] = 'Usuń element';
$string['xhtmlxtras_dlg:title_ins_element'] = 'Wstaw element';
