<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'auth_ldap', language 'sk', version '4.5'.
 *
 * @package     auth_ldap
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['auth_ldap_ad_create_req'] = 'Nie je možné vytvoriť nové konto v Active Directory. Skontrolujte si všetky nastavenia pre jeho správnu funkcionalitu (LDAPS spojenie, bind používateľov so zodpovedajúcimi právami, atď).';
$string['auth_ldap_attrcreators'] = 'Zoznam skupín alebo kontextov, ktorých členovia majú právo vytvárať atribúty. Oddeľujte viaceré skupiny bodkočiarkou. Väčšinou je to niečo ako \'cn=teachers,ou=staff,o=myorg\'.';
$string['auth_ldap_attrcreators_key'] = 'Tvorcovia atribútov';
$string['auth_ldap_auth_user_create_key'] = 'Vytvoriť používateľov externe';
$string['auth_ldap_bind_dn'] = 'Ak chcete používať spoluužívateľov na vyhľadávanie používateľov, uveďte to tu. Napríklad: \'ou=users,o=org; ou=others,o=org\'';
$string['auth_ldap_bind_dn_key'] = 'Jednoznačné (distingvované) meno (DN)';
$string['auth_ldap_bind_pw'] = 'Heslo pre spoluužívateľa.';
$string['auth_ldap_bind_pw_key'] = 'Heslo';
$string['auth_ldap_bind_settings'] = 'Spoločné nastavenia';
$string['auth_ldap_changepasswordurl_key'] = 'Heslo - zmena URL';
$string['auth_ldap_contexts'] = 'Zoznam kontextov, v ktorých sa nachádzajú používatelia. Oddeľte rozličné kontexty bodkočiarkou. Napríklad: \'ou=users,o=org; ou=others,o=org\'';
$string['auth_ldap_contexts_key'] = 'Kontexty';
$string['auth_ldap_create_context'] = 'Ak umožníte vytváranie používateľov s emailovým potvrdzovaním, špecifikujte kontext, kde budú používatelia vytvorení. Tento kontext by mal byť iný, ako pre ostatných používateľov, v záujme bezpečnosti. Nepotrebujete pridať tento kontext do premennej ldap-context, Moodle bude vyhľadávať používateľov z tohto kontextu automaticky.<br />
<b>Pozor!</b> Musíte upraviť funkciu auth_user_create() v súbore auth/ldap/lib.php, aby mohli byť takýmto spôsobom vytváraní noví používatelia.';
$string['auth_ldap_create_context_key'] = 'Kontexty pre nových používateľov';
$string['auth_ldap_create_error'] = 'Chyba pri vytváraní používateľov v LDAP.';
$string['auth_ldap_expiration_desc'] = 'Pre deaktiváciu konca platnosti kontroly hesla alebo "{$a->ldapserver}" pre čítanie času ukončenia platnosti hesla priamo zo serveru LDAP zvoľte "{$a->no}".';
$string['auth_ldap_expiration_key'] = 'Vypršanie platnosti';
$string['auth_ldap_expiration_warning_desc'] = 'Počet dní pred tým, ako sa objaví upozornenie o vypršaní platnosti hesla.';
$string['auth_ldap_expiration_warning_key'] = 'Varovanie o vypršaní platnosti';
$string['auth_ldap_expireattr_desc'] = 'Nepovinné: prestaví hodnotu LDAP atribútu, ktorý uchováva  čas do vypršania hesla.';
$string['auth_ldap_expireattr_key'] = 'Atribút vypršania platnosti';
$string['auth_ldap_graceattr_desc'] = 'Nepovinné: prenastavuje hodnotu atribútu prihlásenia z milosti';
$string['auth_ldap_gracelogin_key'] = 'Atribút \'gracelogin\'';
$string['auth_ldap_gracelogins_desc'] = 'Umožniť podporu LDAP gracelogin (tzv. prihlásenie z milosti). Po tom, ako vyprší platnosť hesla, používateľ sa môže prihlásiť, kým nie je hodnota gracelogin 0. Ak povolíte toto nastavenie, používatelia budú informovaní, v prípade, že im vyprší platnosť hesla.';
$string['auth_ldap_gracelogins_key'] = 'Prihlásenie z milosti';
$string['auth_ldap_groupecreators'] = 'Zoznam skupín alebo kontextov, ktorých členovia majú právo vytvárať skupiny. Oddeľujte viaceré skupiny bodkočiarkou. Väčšinou je to niečo ako \'cn=teachers,ou=staff,o=myorg\'.';
$string['auth_ldap_groupecreators_key'] = 'Tvorcovia skupín';
$string['auth_ldap_host_url'] = 'Špecifikujte hostiteľa LDAP v podobe URL, napr. \'ldap://ldap.myorg.com/\' alebo \'ldaps://ldap.myorg.com/\'. Jednotlivé servery oddeľte bodkočiarkou.';
$string['auth_ldap_host_url_key'] = 'Hosťovské URL';
$string['auth_ldap_ldap_encoding'] = 'Upresnite kódovnie používané LDAP serverom. Pravdepodobne utf-8, MS AD v2 použiva formy kódovania ako cp1252, cp1250, atď.';
$string['auth_ldap_ldap_encoding_key'] = 'LDAP kódovanie';
$string['auth_ldap_login_settings'] = 'Nastavenia prihlasovania';
$string['auth_ldap_memberattribute'] = 'Nepovinné: voľba potlačí názov atribútu člena skupiny, ak používateľ patrí do skupiny. Obyčajne je to \'member\'';
$string['auth_ldap_memberattribute_isdn'] = 'Potlačí spracovanie hodnôt atribútov člena';
$string['auth_ldap_memberattribute_isdn_key'] = 'Atribút členstva používa dn';
$string['auth_ldap_memberattribute_key'] = 'Atribút členstva';
$string['auth_ldap_no_mbstring'] = 'Pre vytváranie používateľov v Active Directory potrebujete rozšírenie mbstring.';
$string['auth_ldap_noconnect'] = 'Modul LDAP sa nemôže pripojiť k serveru: {$a}';
$string['auth_ldap_noconnect_all'] = 'Modul LDAP sa nemôže pripojiť k žiadnemu zo serverov: {$a}';
$string['auth_ldap_noextension'] = 'Zdá sa, že modul PHP LDAP nie je nainštalovaný. Ak chcete použiť tento autentifikačný modul, uistite sa, že je nainštalovaný a povolený.';
$string['auth_ldap_objectclass'] = 'Nepovinné: voľba potlačí funkciu objectClass používanú na vyhľadávanie používateľov na ldap_user_type. Zvyčajne túto voľbu nepotrebujete meniť.';
$string['auth_ldap_objectclass_key'] = 'Trieda objektu';
$string['auth_ldap_opt_deref'] = 'Táto voľba určuje, ako sa zaobchádza s aliasmi pri vyhľadávaní. Vyberte jednu z nasledujúcich hodnôt: "Nie"(LDAP_DEREF_NEVER) alebo "Áno"(LDAP_DEREF_ALWAYS)';
$string['auth_ldap_opt_deref_key'] = 'Zrušiť prepojenie s aliasmi';
$string['auth_ldap_passtype'] = 'Upresnite formát nového alebo zmeneného hesla v LDAP serveri.';
$string['auth_ldap_passtype_key'] = 'Formát hesla';
$string['auth_ldap_passwdexpire_settings'] = 'LDAP nastavenia pri vypršaní platnosti hesla.';
$string['auth_ldap_preventpassindb'] = 'Má sa zabrániť ukladaniu hesiel v databáze Moodle? Ak zvolíte "áno", nebudú heslá v databáze ukladané.';
$string['auth_ldap_preventpassindb_key'] = 'Zabrániť kešovanie hesiel';
$string['auth_ldap_rolecontext'] = 'kontext {$a->localname}';
$string['auth_ldap_rolecontext_help'] = 'Kontext LDAP používaný na výber mapovania <i>{$a->localname}</i>. Viaceré skupiny oddeľte znakom „;“. Zvyčajne niečo ako "cn={$a->shortname},ou=first-ou-with-role-groups,o=myorg; cn={$a->shortname},ou=second-ou-withprole=groups,o=myorg".';
$string['auth_ldap_search_sub'] = 'Uveďte hodnotu <> 0, ak chcete hľadať používateľov v subkontextoch.';
$string['auth_ldap_search_sub_key'] = 'Prehľadať subkontexty';
$string['auth_ldap_server_settings'] = 'LDAP nastavenia servera';
$string['auth_ldap_suspended_attribute'] = 'Voliteľné: Ak je k dispozícii tento atribút, bude použitý k aktivácii / pozastaviť lokálne vytvorený používateľský účet.';
$string['auth_ldap_suspended_attribute_key'] = 'Pozastavený atribút';
$string['auth_ldap_unsupportedusertype'] = 'Overovanie: ldap user_create() nepodporuje zvolený typ používateľa: {$a}';
$string['auth_ldap_update_userinfo'] = 'Aktualizovať informácie o používateľovi (krstné meno, priezvisko, adresa...) z LDAP do Moodle. Hľadať v /auth/ldap/attr_mappings.php pre priraďujúce informácie. Ak potrebujete, definujte nastavenia pre "Mapovanie údajov".';
$string['auth_ldap_user_attribute'] = 'Nepovinné: voľba potlačí vlastnosť používanú na hľadanie mien používateľov. Zvyčajne \'cn\'.';
$string['auth_ldap_user_attribute_key'] = 'Atribút používateľa';
$string['auth_ldap_user_exists'] = 'LDAP meno už existuje.';
$string['auth_ldap_user_settings'] = 'Nastavenia prehľadávania používateľov';
$string['auth_ldap_user_type'] = 'Vyberte si, ako budú používatelia uchovávaní v LDAP. Toto nastavenie tiež špecifikuje, ako bude fungovať vytváranie nových používateľov, grace loginy a vypršanie platnosti hesla.';
$string['auth_ldap_user_type_key'] = 'Typ používateľa';
$string['auth_ldap_usertypeundefined'] = 'config.user_type nie je definovaný alebo funkcia ldap_expirationtime2unix nepodporuje zvolený typ!';
$string['auth_ldap_usertypeundefined2'] = 'config.user_type nie je definovaý alebo funkcia ldap_unixi2expirationtime nepodporuje zvolený typ!';
$string['auth_ldap_version'] = 'Verzia LDAP protokolu, ktorú používa váš server';
$string['auth_ldap_version_key'] = 'Verzia';
$string['auth_ldapdescription'] = 'Táto metóda poskytuje overovanie používateľov proti  LDAP serveru. Ak je používateľské meno a heslo správne, Moodle vytvorí nového používateľa vo svojej databáze. Tento modul dokáže načítať používateľské vlastnosti z LDAP a predvyplniť požadované políčka v Moodle. Pre nasledujúce prihlasovania sa kontrolujú už iba používateľské meno a heslo.';
$string['auth_ldapextrafields'] = 'Tieto políčka sú nepovinné. Môžete predvyplniť niektoré políčka v profile používateľa v Moodle s informáciami z <b>LDAP políčok</b>, ktoré tu uvediete.
<p>Ak tu nič neuvediete, informácie z LDAP nebudú prenesené a namiesto toho bude uvádzané štandardné Moodle nastavenie.</p>
<p>V obidvoch prípadoch bude môcť používateľ po prihlásení upravovať všetky tieto políčka.</p>';
$string['auth_ldapnotinstalled'] = 'Nemožno použiť overenie LDAP. Modul PHP LADP nie je nainštalovaný.';
$string['auth_ntlmsso'] = 'NTLM SSO';
$string['auth_ntlmsso_enabled'] = 'Nastavte na áno pre pokus o Single Sign On s NTLM doménou. <strong>Poznámka:</strong> na webserveri je treba ešte ďalšie nastavenia, viď <a href="http://docs.moodle.org/en/NTLM_authentication">http://docs.moodle.org/en/NTLM_authentication</a>.';
$string['auth_ntlmsso_enabled_key'] = 'Povoliť';
$string['auth_ntlmsso_ie_fastpath'] = 'Zapnutie aktivuje NTLM SSO fast path (preskočí určité kroky a funguje iba v prípade, že klientsky prehliadač je MS Internet Explorer)';
$string['auth_ntlmsso_ie_fastpath_attempt'] = 'Pokus NTLM so všetkými prehliadačmi';
$string['auth_ntlmsso_ie_fastpath_key'] = 'MS IE fast path?';
$string['auth_ntlmsso_ie_fastpath_yesattempt'] = 'Áno, pokus NTLM s inými prehliadačmi';
$string['auth_ntlmsso_ie_fastpath_yesform'] = 'Áno, všetky ostatné prehliadače používajú štandardný prihlasovací formulár';
$string['auth_ntlmsso_maybeinvalidformat'] = 'Používateľské meno sa nedá vyňať z hlavičky REMOTE_USER. Je nakonfigurovaný formát správny?';
$string['auth_ntlmsso_missing_username'] = 'Vo formáte vzdialeného používateľského mena musíte špecifikovať aspoň %username%';
$string['auth_ntlmsso_remoteuserformat'] = 'Ak ste si vybrali \'NTLM\' v \'Type overenia\', na tomto mieste môžete špecifikovať formát vzdialeného používateľského mena. Ak miesto necháte prázdne, použije sa štandardný formát používateľského mena domény, Voliteľný zástupný znak  <b>%domain%</b> môžete použiť, aby ste špecifikovali, kde sa objaví meno domény a povinný zástupný znak <b>%username%</b> , aby ste špecifikovali, kde sa objaví používateľské meno.  <br /><br />Niektoré hojne používané formáty sú <tt>%domain%username%</tt> (štandardný v MS Windows), <tt>%domain%/%username%</tt>, <tt>%domain%+%username%</tt> a iba <tt>%username%</tt> (ak tam nie je žiadna časť s doménou).';
$string['auth_ntlmsso_remoteuserformat_key'] = 'Formát vzdialeného používateľského mena';
$string['auth_ntlmsso_subnet'] = 'Nastavte na áno pre pokus o SSO s klientmi v tejto subsieti. Viac podsietí oddeľujte čiarkou. Formát: xxx.xxx.xxx.xxx/bitová_maska';
$string['auth_ntlmsso_subnet_key'] = 'Podsieť';
$string['auth_ntlmsso_type'] = 'Autentifikačná metóda konfigurovaná na web serveri pre autentifikáciu používateľov (ak neviete, použite NTLM)';
$string['auth_ntlmsso_type_key'] = 'Typ autentifikácie';
$string['cannotmaprole'] = 'Roleu "{$a-> rolename}" nie je možné mapovať, pretože jeho krátky názov "{$a-> shortname}" je príliš dlhý a/alebo obsahuje pomlčky. Aby mapovanie bolo možné, musíte skrátiť krátky názov na  {$a-> charlimit} znakov alebo odstrániť pomlčky. <a href="{$a-> link} "> Upraviť rolu </a>';
$string['connectingldap'] = 'Pripájanie k LDAP serveru ...';
$string['connectingldapsuccess'] = 'Pripojenie k serveru LDAP bolo úspešné';
$string['creatingtemptable'] = 'Vytvára sa dočasné tabuľka {$a}';
$string['diag_contextnotfound'] = 'Kontext {$a} neexistuje alebo nie je čitateľný pomocou väzby DN.';
$string['diag_emptycontext'] = 'Bol nájdený prázdy kontext.';
$string['diag_genericerror'] = 'LDAP chyba {$a->code} čítania {$a->subject}: {$a->message}.';
$string['diag_rolegroupnotfound'] = 'Skupina {$a->group} pre rolu {$a->localname} neexistuje alebo nemôže byť čítaná väzbou DN.';
$string['diag_toooldversion'] = 'Je veľmi nepravdepodobné, že moderný server LDAP používa protokol LDAPv2. Chybné nastavení môže poškodiť hodnoty v používateľských poliach. Informujte sa u správcu LDAP.';
$string['didntfindexpiretime'] = 'funkcia password_expire() nenašla čas expirácie';
$string['didntgetusersfromldap'] = 'Neboli nájdení žiadni LDAP používatelia -- chyba? -- končím.';
$string['gotcountrecordsfromldap'] = 'Bolo získaných {$a} záznamov z LDAP';
$string['invalidusererrors'] = 'Upozornenie: Preskočené vytváranie {$a} používateľských účtov.';
$string['invaliduserexception'] = 'Chyba: Nie je možné vytvoriť nový používateľský účet. Podrobnosti a dôvod:
{$a}
Preskočenie tohto používateľa.';
$string['ldapnotconfigured'] = 'URL hostiteľa LDAP nie je aktuálne nakonfigurovaná';
$string['morethanoneuser'] = 'Hm, to je divné. V LDAP bolo nájdených viac ako len jeden záznam pre používateľa. Použijem prvý z nich.';
$string['needbcmath'] = 'Ak chcete používať technológiu Active Directory, budete potrebovať rozšírenie BCMath pre grace prihlásenia.';
$string['needmbstring'] = 'Pre zmenu hesiel pomocou Active Directory potrebujete rozšírenie mbstring.';
$string['nodnforusername'] = 'Chyba vo funkcii user_update_password(). Žiadne DN pre používateľa: {$a->username}';
$string['noemail'] = 'Nepodarilo sa poslať Vám email!';
$string['notcalledfromserver'] = 'Tento skript by nemal by zavolaný z web servera.';
$string['noupdatestobedone'] = 'Netreba vykonať žiadne aktualizácie.';
$string['nouserentriestoremove'] = 'Netreba vykonať odstránenie používateľov';
$string['nouserentriestorevive'] = 'Netreba vykonať obnovu používateľov';
$string['nouserstobeadded'] = 'Nie sú žiadni používatelia na pridanie';
$string['ntlmsso_attempting'] = 'Pokus o Single Sign On pomocou NTLM...';
$string['ntlmsso_failed'] = 'Auto-login sa nepodaril, skúste normálne prihlasovanie.';
$string['ntlmsso_isdisabled'] = 'NTLM SSO je zakázané.';
$string['ntlmsso_unknowntype'] = 'Neznámy typ ntlmsso!';
$string['pagedresultsnotsupp'] = 'LDAP stránkované výsledky nie sú podporované (buď vaša PHP verzia nemá podporu, alebo ste nakonfigurovali Moodle tak, aby používal verziu 2 LDAP protokolu alebo Moodle nemôže kontaktovať váš LDAP server, aby zistil, či je podpora k dispozícii)';
$string['pagesize'] = 'Uistite sa, že je táto hodnota nižšia ako tá, ktorú váš LDAP server nastavil ako veľkostný limit (maximálny počet záznamov, ktoré môžu byť vrátené v jednom vyhľadávaní)';
$string['pagesize_key'] = 'Veľkosť stránky';
$string['pluginname'] = 'Použiť LDAP server';
$string['pluginnotenabled'] = 'Zásuvný modul nebol aktivovaný!';
$string['privacy:metadata'] = 'Zásuvný modul autentifikácia sever LDAP neukladá žiadne osobné údaje.';
$string['renamingnotallowed'] = 'V LDAP nie je povolené premenovať používateľov';
$string['rootdseerror'] = 'Chyba pri dopyte rootDSE pre Active Directory';
$string['start_tls'] = 'Použiť riadnu LDAP službu (port 389) s TLS kódovaním';
$string['start_tls_key'] = 'Použiť TLS';
$string['syncroles'] = 'Synchronizácia rolí systému z LDAP';
$string['synctask'] = 'Úloha cronu pre synchronizáciu používateľov LDAP';
$string['systemrolemapping'] = 'Mapovanie rolí systému';
$string['updatepasserror'] = 'Chyba vo funkcii user_update_password(). Kód chyby: {$a->errno}; Error string: {$a->errstring}';
$string['updatepasserrorexpire'] = 'Chyba vo funkcii user_update_password() pri zisťovaní času expirácie hesla. Kód chyby: {$a->errno}; Chyba: {$a->errstring}';
$string['updatepasserrorexpiregrace'] = 'Chyba vo funkcii user_update_password() pri úprave času expirácie hesla a/alebo graceloginov. Kód chyby: {$a->errno}; Chyba: {$a->errstring}';
$string['updateremfail'] = 'Chyba pri aktualizácii LDAP záznamu. Kód chyby: {$a->errno}; Chyba: {$a->errstring}<br/>Kľúč ({$a->key}) - stará hodnota: \'{$a->ouvalue}\', nová hodnota: \'{$a->nuvalue}\'';
$string['updateremfailamb'] = 'Nepodarilo sa aktualizovať LDAP s nejednoznačným poľom {$a->key}; stará hodnota: \'{$a->ouvalue}\', nová hodnota: \'{$a->nuvalue}\'';
$string['updateusernotfound'] = 'Pri externej aktualizácii nebol nájdený používateľ. Bližšie údaje: Báza vyhľadávania: \'{$a->userdn}\'; filtre vyhľadávania: \'(objectClass=*)\'; atribúty vyhľadávania: {$a->attribs}';
$string['user_activatenotsupportusertype'] = 'auth: ldap user_activate() nepodporuje vybraný typ používateľa: {$a}';
$string['user_disablenotsupportusertype'] = 'auth: ldap user_disable() nepodporuje vybraný typ používateľa: {$a}';
$string['useracctctrlerror'] = 'Nepodarilo sa získať userAccountControl pre používateľa {$a}';
$string['userentriestoadd'] = 'Počet záznamov používateľov pre pridanie: {$a}';
$string['userentriestoremove'] = 'Počet záznamov používateľov pre odstránenie: {$a}';
$string['userentriestorevive'] = 'Počet záznamov používateľov pre obnovenie: {$a}';
$string['userentriestoupdate'] = 'Počet záznamov používateľov pre aktualizáciu: {$a}';
$string['usernotfound'] = 'Pooužívateľ nebol nájdený v LDAP';
