<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'atto_styles', language 'sr_cr', version '4.5'.
 *
 * @package     atto_styles
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['config'] = 'Конфигурација стилова';
$string['config_desc'] = 'Конфигурација за додатке стилова за за Atto едитор у JSON формату.
<hr />
На пример:<br />
{<br />
&nbsp;&nbsp;&nbsp;&nbsp;"title": "Blue box",<br />
&nbsp;&nbsp;&nbsp;&nbsp;"type": "block",<br />
&nbsp;&nbsp;&nbsp;&nbsp;"classes": "box blue"<br />
},{<br />
&nbsp;&nbsp;&nbsp;&nbsp;"title": "Red text",<br />
&nbsp;&nbsp;&nbsp;&nbsp;"type": "inline",<br />
&nbsp;&nbsp;&nbsp;&nbsp;"classes": "red"<br />
}<br />
<hr />
Атрибут <em>title</em> дефинише назив за стил унутар Atto додатка стилова.<br />
<br />
Наслов, такође, може да подржи Moodle вишејезички филтер (ако је укључен), али додатни двоструки наводници мораће да се избегну са обрнутом косом цртома.<br />
Молимо вас, за пример погледајте README датотеку додатка.<br />
<hr />
Атрибут <em>type</em> може да садржи једну или две вредности: "block" или "inline".<br />
<br />
"block" ће креирати  ознаку div са датом класом(класама) и функционисаће као елемент нивоа стандардног блока. Ово ће преузети елемент нивоа текућег блока и моћи ће да се примени више пута, а не само на тренутно изабрани текст.<br />
<br />
"inline" ће креирати ознаку span са датом класом(класама) и функционисаће као стандардни  уметнути елемент. Ови ће се применити само на тренутно изабрани текст.
<hr />
Атрибут <em>classes</em> преузима назив CSS класе који ће бити примењен на блок / уметнути текст.<br />
<br />
За сваку ставку могу бити дефинисане вишеструке класе, раздвојене размаком. Класе ће бити примењене на на блок / уметнути текст.<br />
<br />
Дефиниције CSS класе не могу да се праве унутар овог додатка. Мораћета да додате дефиниције својих CSS класа у вашу графичку темеу или додатна Moodle HTML подешавања.
<hr />
На Moodle инсталацијама са bootstrap темама (посебно,  са темама <em>More</em> и <em>Clean</em>, такође можете да креирате стилове са bootstrap CSS класама уместо да дефинишите сопствене класе.
<br /><br />
На пример:<br />
{<br />
&nbsp;&nbsp;&nbsp;&nbsp;"title": "Hero unit box",<br />
&nbsp;&nbsp;&nbsp;&nbsp;"type": "block",<br />
&nbsp;&nbsp;&nbsp;&nbsp;"classes": "hero-unit"<br />
},{<br />
&nbsp;&nbsp;&nbsp;&nbsp;"title": "Well",<br />
&nbsp;&nbsp;&nbsp;&nbsp;"type": "block",<br />
&nbsp;&nbsp;&nbsp;&nbsp;"classes": "well"<br />
},{<br />
&nbsp;&nbsp;&nbsp;&nbsp;"title": "Info text",<br />
&nbsp;&nbsp;&nbsp;&nbsp;"type": "inline",<br />
&nbsp;&nbsp;&nbsp;&nbsp;"classes": "label label-info"<br />
},{<br />
&nbsp;&nbsp;&nbsp;&nbsp;"title": "Warning text",<br />
&nbsp;&nbsp;&nbsp;&nbsp;"type": "inline",<br />
&nbsp;&nbsp;&nbsp;&nbsp;"classes": "label label-warning"<br />
}<br /><br />
За више информација о bootstrap класама, молимо вас да посетите следеће линкове у Bootstrap 2.3 документацији:
<ul>
<li><a href="http://getbootstrap.com/2.3.2/components.html#labels-badges">Bootstrap ознаке и беџеви</a></li>
<li><a href="http://getbootstrap.com/2.3.2/components.html#alerts">Bootstrap упозорења</a></li>
<li><a href="http://getbootstrap.com/2.3.2/components.html#misc">Bootstrap помоћне класе</a></li>
</ul>';
$string['nostyle'] = 'Без стила';
$string['pluginname'] = 'Стилови';
$string['settings'] = 'Подешавања стилова';
