<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'bigbluebuttonbn', language 'af', version '4.5'.
 *
 * @package     bigbluebuttonbn
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'Jy het opkomende bigbluebuttonbn sessies';
$string['bbbduetimeoverstartingtime'] = 'Die toemaak tyd moet later wees as die begin tyd';
$string['bbbdurationwarning'] = 'Die maksimum tydsduur vir hierdie sessie is %duration% minute.';
$string['bbbrecordallfromstartwarning'] = 'Hierdie sessie word van die begin af opgeneem.';
$string['bbbrecordwarning'] = 'Die sessie mag opgeneem word.';
$string['bigbluebuttonbn'] = 'BigBlueButton';
$string['bigbluebuttonbn:addinstance'] = 'Voeg \'n nuwe BigBlueButton kamer by';
$string['bigbluebuttonbn:join'] = 'Skakel in by \'n BigBlueButton kamer';
$string['bigbluebuttonbn:managerecordings'] = 'Bestuur opnames';
$string['bigbluebuttonbn:view'] = 'Wys BigBlueButton kamer';
$string['calendarstarts'] = '{$a} word geskeduleer vir';
$string['completionattendance'] = 'Student moet die vergadering bywoon vir:';
$string['completionattendancegroup'] = 'Vereis bywoning';
$string['completionattendancegroup_help'] = 'Bywoning van die vergadering vir (n) minute word vereis vir voltooiing';
$string['completionengagementchats'] = 'Kletsgeleenthede';
$string['completionengagementemojis'] = 'Emoji\'s';
$string['completionengagementgroup'] = 'Vereis deelname';
$string['completionengagementgroup_help'] = 'Aktiewe deelname tydens sessie word vereis vir voltooiing';
$string['completionengagementpollvotes'] = 'Peiling stemme';
$string['completionengagementraisehand'] = 'Steek hand op gebeure';
$string['completionengagementtalks'] = 'Gespreksgebeure';
$string['completionupdatestate'] = 'Voltooiing opdatering status';
$string['completionvalidatestate'] = 'Bekragtig voltooiing';
$string['completionvalidatestatetriggered'] = 'Voltooiing bekragtiging is geaktiveer.';
$string['config_default_messages'] = 'Verstekboodskap';
$string['config_default_messages_description'] = 'Stel verstekboodskap vir alle aktiwiteite';
$string['config_disablecam_default'] = 'Deaktiveer verstekkamera';
$string['config_disablecam_default_description'] = 'Indien aktiveer sal die webkamera deaktiveer word.';
$string['config_disablecam_editable'] = 'Deaktiveer kamera kan gewysig word';
$string['config_disablecam_editable_description'] = 'Deaktiveer kamera as verstekinstelling kan gewysig word wanneer die instansie bygevoeg word of opdateer word.';
$string['config_disablemic_default'] = 'Deaktiveer mikrofoon word aktiveer as verstek';
$string['config_disablemic_default_description'] = 'Indien aktiveer sal al die mikrofone deaktiveer word.';
$string['config_disablemic_editable'] = 'Deaktiveer mikrofoon kan gewysig word';
$string['config_disablemic_editable_description'] = 'Skakel mikrofoon by verstek af kan gewysig word wanneer die instansie bygevoeg of opgedateer word.';
$string['config_disablenote_default'] = 'Deaktiveer gedeelde notas word as verstekinstelling aktiveer';
$string['config_disablenote_default_description'] = 'Indien aktiveer sal die gedeelde notas deaktiveer word.';
$string['config_disablenote_editable'] = 'Deaktiveer gedeelde notas kan gewysig word';
$string['config_disablenote_editable_description'] = 'Deaktiveer gedeelde notas as standaard kan geredigeer word wanneer die instansie bygevoeg of opgedateer word.';
$string['config_disableprivatechat_default'] = 'Deaktiveer private klets word as verstekinstelling aktiveer';
$string['config_disableprivatechat_default_description'] = 'Indien aktiveer sal die private klets deaktiveer word.';
$string['config_disableprivatechat_editable'] = 'Deaktiveer private gesels kan gewysig word';
$string['config_disableprivatechat_editable_description'] = 'Skakel privaatklets uit as verstekinstelling kan verander word wanneer die instansie bygevoeg of opgedateer word';
$string['config_disablepublicchat_default'] = 'Skakel private klets af word as verstekinstelling aktiveer';
$string['config_disablepublicchat_default_description'] = 'Indien geaktiveer sal die publieke klets deaktiveer word';
$string['config_disablepublicchat_editable'] = 'Deaktiveer publieke klets kan gewysig word';
$string['config_disablepublicchat_editable_description'] = 'Deaktiveer openbare klets by verstek kan geredigeer word wanneer die instansie bygevoeg of opgedateer word.';
$string['config_experimental_features'] = 'Instelling vir eksperimentele funksies';
$string['config_experimental_features_description'] = 'Instelling vir eksperimentele funksies.';
$string['config_extended_capabilities'] = 'Instelling vir uitgebreide vermoëns';
$string['config_extended_capabilities_description'] = 'Instelling vir uitgebreide vermoëns wanneer die BigBlueButton-bediener dit toelaat.';
$string['config_general'] = 'Algemene instellings';
$string['config_general_description'] = 'Om BigBlueButton op te stel, kan jy óf jou eie BigBlueButton-bediener en intekenbesonderhede gebruik, óf intekenbesonderhede bekom deur die <a href="https://registration-portal.blindsidenetworks.com/" target="_blank">Blindside Networks Registrasieportaal (maak in \'n nuwe venster oop)</a>.';
$string['config_hideuserlist_default'] = 'Versteek gebruikerslys by verstek geaktiveer';
$string['config_hideuserlist_default_description'] = 'Indien aktiveer sal die sessie gebruikerslys versteek word.';
$string['config_hideuserlist_editable'] = 'Versteek gebruikerslys kan gewysig word';
$string['config_hideuserlist_editable_description'] = 'Versteek gebruikerslys kan verstekinstelling gewysig word wanneer die instansie bygevoeg of opgedateer word.';
$string['config_importrecordings'] = 'Instelling vir "Invoering van opnames" funksie';
$string['config_importrecordings_description'] = 'Hierdie instellings is funksiespesifiek';
$string['config_importrecordings_enabled'] = 'Invoer van opnames geaktiveer';
$string['config_importrecordings_enabled_description'] = 'As hierdie en die opname-funksie geaktiveer is, is dit moontlik om opnames van verskillende kursusse in \'n aktiwiteit in te voer.';
$string['config_importrecordings_from_deleted_enabled'] = 'Invoering van opnames van verwyderde aktiwiteite geaktiveer';
$string['config_importrecordings_from_deleted_enabled_description'] = 'Wanneer hierdie en die invoeropname-funksie geaktiveer is, is dit moontlik om opnames in te voer van aktiwiteite wat nie meer in die kursus is nie.';
$string['config_locksettings'] = 'Instelling vir sluit-instellings';
$string['config_locksettings_description'] = 'Hierdie instellings aktiveer of deaktiveer opsies in die UI vir die sluit van instellings, en definieer ook standaardwaardes vir hierdie opsies.';
$string['config_meetingevents_enabled'] = 'Registreer lewendige sessies';
$string['config_meetingevents_enabled_description'] = 'Skakel die inprop in vir die aanvaarding en verwerking van regstreekse gebeure nadat die sessie geëindig het. (Dit moet geaktiveer wees vir "Aktiwiteit voltooi" en sal slegs werk as die BigBlueButton-bediener in staat is om na-gebeure-skrifte te verwerk)';
$string['config_muteonstart'] = 'Instelling vir "Demp by begin" -funksie';
$string['config_muteonstart_default'] = 'Demp by begin by verstek geaktiveer';
$string['config_muteonstart_default_description'] = 'Indien aktiveer sal die sessie van die begin af gedemp word.';
$string['config_muteonstart_description'] = 'Hierdie instellings aktiveer of deaktiveer opsies in die UI en definieer ook standaardwaardes vir hierdie opsies.';
$string['config_muteonstart_editable'] = 'Demp by begin kan gewysig word';
$string['config_muteonstart_editable_description'] = 'Demping by begin kanas verstekinstelling gewysig word wanneer die instansie bygevoeg of opgedateer word.';
$string['config_participant'] = 'Deelname instelling';
$string['config_participant_description'] = 'Hierdie instellings bepaal die verstekrol van deelnemers in \'n konferensie.';
$string['config_participant_moderator_default'] = 'Moderator by verstek';
$string['config_participant_moderator_default_description'] = 'Hierdie reël word as verstek gebruik wanneer \'n nuwe kamer bygevoeg word.';
$string['config_presentation_default'] = 'Verstekleêr vir "Vooraf opgelaaide aanbiedings" funksie';
$string['config_presentation_default_description'] = 'Met hierdie instelling kan jy \'n lêer kies om standaard in alle BBB-gevalle te gebruik as "Vooroplaai van aanbiedings" geaktiveer is.';
$string['config_preuploadpresentation'] = 'Instellings vir "Voorafopgelaaide aanbiedings" funksie';
$string['config_preuploadpresentation_description'] = 'Hierdie instellings aktiveer of deaktiveer opsies in die Gebruikers Koppelvlak (GK) en definieer ook standaardwaardes vir hierdie opsies. Die funksie werk slegs as die Moodle-bediener toeganklik is vir BigBlueButton.';
$string['config_recording'] = 'Instelling vir "Neem vergadering op" funksie';
$string['config_recording_all_from_start_default'] = 'Neem alles van die begin af op';
$string['config_recording_all_from_start_default_description'] = 'Indien gemerk sal die vergadering begin opneem om te begin';
$string['config_recording_all_from_start_editable'] = 'Neem alles van die begin af op kan gewysig word';
$string['config_recording_all_from_start_editable_description'] = 'As dit gemerk is, bevat die koppelvlak \'n opsie om neem van begin af op funksie te aktiveer of deaktiveer.';
$string['config_recording_default'] = 'Opneemfunksie as verstek geaktiveer';
$string['config_recording_default_description'] = 'As dit geaktiveer is, kan die sessies wat in BigBlueButton geskep is, opneem vermoëns hê.';
$string['config_recording_description'] = 'Hierdie instellings is funksiespesifiek';
$string['config_recording_editable'] = 'Opneemfunksie kan gewysig word';
$string['config_recording_editable_description'] = 'Indien gemerk, bevat die koppelvlak \'n opsie om die opname-funksie in of uit te skakel.';
$string['config_recording_hide_button_default'] = 'Versteek opneem knoppie';
$string['config_recording_hide_button_default_description'] = 'Indien gemerk sal die opneemknoppie versteek word';
$string['config_recording_hide_button_editable'] = 'Versteek opneemknoppie kan gewysig word';
$string['config_recording_hide_button_editable_description'] = 'Indien gemerk, bevat die koppelvlak \'n opsie om die versteek-knoppie-funksie in of uit te skakel.';
$string['config_recordingready_enabled'] = 'Stuur kennisgewing wanneer \'n opname gereed is';
$string['config_recordingready_enabled_description'] = 'Skakel die inprop in om kennisgewings te stuur wanneer die opname gereed is. (Dit sal slegs werk as die skrif post_publish_recording_ready_callback in die BigBlueButton-bediener geaktiveer is)';
$string['config_recordings'] = 'Instelling vir "Wys opnames" funksie';
$string['config_recordings_asc_sort'] = 'Orden opnames in stygende orde.';
$string['config_recordings_asc_sort_description'] = 'Opnames word standaard in dalende volgorde vertoon. As dit gemekr word, sal dit in stygende volgorde gesorteer word.';
$string['config_recordings_deleted_default'] = 'Sluit opnames van verwyderde opnames as verstek in';
$string['config_recordings_deleted_default_description'] = 'Indien geaktiveer, sal die opnametabel die opnames bevat wat deel uitmaak van geskrapte aktiwiteite indien daar is.';
$string['config_recordings_deleted_editable'] = 'Sluit opnames van geskrap aktiwiteite in funksie kan gewysig word';
$string['config_recordings_deleted_editable_description'] = 'Sluit opnames in van geskrapte aktiwiteite as verstek kan geredigeer word wanneer die instansie bygevoeg of opgedateer word.';
$string['config_recordings_description'] = 'Hierdie instellings is funksiespesifiek';
$string['config_recordings_general'] = 'Wys opneeminstellings';
$string['config_recordings_general_description'] = 'Hierdie instellings word slegs gebruik as opnames vertoon word';
$string['config_recordings_imported_default'] = 'Wys slegs ingevoerde skakels word as verstek aktiveer';
$string['config_recordings_imported_default_description'] = 'As dit geaktiveer is, sal die opnametabel slegs die ingevoerde skakels na opnames bevat.';
$string['config_recordings_imported_editable'] = 'Wys slegs ingevoerde skakels funksie kan gewysig word';
$string['config_recordings_imported_editable_description'] = 'Wys slegs ingevoerde skakels kan standaard gewysig word wanneer die instansie bygevoeg of opgedateer word.';
$string['config_recordings_preview_default'] = 'Voorskou word as verstek aktiveer';
$string['config_recordings_preview_default_description'] = 'Indien aktiveer sluit die tabel \'n voorskou van die aanbieding in.';
$string['config_recordings_preview_editable'] = 'Voorskoufunksie kan gewysig word';
$string['config_recordings_preview_editable_description'] = 'Voorskou funksie kan geredigeer word wanneer die instansie bygevoeg of opdateer word';
$string['config_scheduled'] = 'Instelling vir "Geskeduleerde sessies"';
$string['config_scheduled_description'] = 'Hierdie instellings bepaal gedeeltelik die verstekwerking vir geskeduleerde sessies.';
$string['config_scheduled_pre_opening'] = 'Toeganklik voor openingstyd (minute)';
$string['config_scheduled_pre_opening_description'] = 'Die tyd in minute wanneer die sessie toeganklik is voordat die openingstyd van die skedules beskikbaar is.';
$string['config_server_url'] = 'BigBlueButton Bediener URL';
$string['config_server_url_description'] = 'Die URL van jou BigBlueButton-bediener moet eindig met /bigbluebutton/. (Hierdie standaard URL is vir \'n BigBlueButton-bediener wat deur Blindside Networks verskaf word en wat jy kan gebruik vir toetsing.)';
$string['config_shared_secret'] = 'BigBlueButton Gedeelde Geheim';
$string['config_shared_secret_description'] = 'Die veiligheidsout van jou BigBlueButton bediener. (Hierdie versteksout is vir \'n BigBlueButton-bediener wat deur Blindside Networks aangebied word en wat jy kan gebruik vir toetse.)';
$string['config_uidelegation_enabled'] = 'Afvaardiging van gebruikerskoppelvlak is aktiveer';
$string['config_uidelegation_enabled_description'] = 'Hierdie instellings skakel die gebruikerskoppelvlakafvaardiging na die BigBlueButton-bediener aan of af.';
$string['config_userlimit'] = 'Instelling vir die "Gebruikersbeperking" funksie';
$string['config_userlimit_default'] = 'Gebruikersbeperking word as standaardinstelling geaktiveer';
$string['config_userlimit_default_description'] = 'Die verstekaantal gebruikers wat in \'n sessie toegelaat word as \'n nuwe kamer of konferensie bygevoeg word. As die getal op 0 gestel word, word geen beperking vasgestel nie';
$string['config_userlimit_description'] = 'Hierdie instellings aktiveer of deaktiveer opsies in die gebruikerskoppelvlak en definieer ook standaardwaardes vir hierdie opsies.';
$string['config_userlimit_editable'] = 'Gebruikersbeperkingfunksie kan gewysig word';
$string['config_userlimit_editable_description'] = 'Verstekgebruikersbeperkingwaarde kan gewysig word wanneer die kamer of konferensie bygevoeg of opgedateer word.';
$string['config_voicebridge'] = 'Instelling vir die "Stembrug funksie"';
$string['config_voicebridge_description'] = 'Hierdie instellings aktiveer of deaktiveer opsies in die gebruikerskoppelvlak en bepaal ook hul verstekwaardes.';
$string['config_voicebridge_editable'] = 'Konferensie stembrug kan gewysig word';
$string['config_voicebridge_editable_description'] = 'Konferensie-stembrugnommer kan permanent aan \'n kamerkonferensie toegeken word. Wanneer dit toegeken word, kan die nommer nie deur enige ander kamer of konferensie gebruik word nie';
$string['config_waitformoderator'] = 'Instelling vir "Wag vir moderator" funksie';
$string['config_waitformoderator_cache_ttl'] = 'Wag vir moderator kasse TTL (sekondes)';
$string['config_waitformoderator_cache_ttl_description'] = 'Om \'n groot hoeveelheid kliënte te ondersteun, maak hierdie invoegtoepassing gebruik van \'n kas. Hierdie parameter definieer die tyd wat die kas gehou sal word voordat die volgende versoek na die BigBlueButton-bediener gestuur word.';
$string['config_waitformoderator_default'] = 'Wag vir moderator word as verstek geaktiveer';
$string['config_waitformoderator_default_description'] = 'Wag vir moderatorfunksie word as verstek geaktiveer wanneer \'n nuwe kamer of konferensie bygevoeg word.';
$string['config_waitformoderator_description'] = 'Hierdie funksies is funksiespesifiek';
$string['config_waitformoderator_editable'] = 'Wag vir moderatorfunksie kan gewysig word';
$string['config_waitformoderator_editable_description'] = 'Wag vir moderator verstekwaarde kan gewysig word wanner \'n kamer of konferensie bygevoeg of opdateer word.';
$string['config_waitformoderator_ping_interval'] = 'Wag vir moderator poing (sekondes)';
$string['config_waitformoderator_ping_interval_description'] = 'As die wag vir moderator-funksie geaktiveer is, kyk die kliënt elke [number] sekonde na die status van die sessie. Hierdie parameter definieer die interval vir versoeke wat aan die Moodle-bediener gerig word';
$string['config_warning_bigbluebuttonbn_cfg_deprecated'] = 'BigBlueButtonBN maak gebruik van config.php met \'n globale veranderlike wat verouderd is. Skakel die lêer om, aangesien dit nie in toekomstige weergawes ondersteun sal word nie';
$string['config_warning_curl_not_installed'] = 'Hierdie funksie vereis die CURL-uitbreiding vir php geïnstalleer en geaktiveer. Die instellings is slegs toeganklik indien aan hierdie voorwaarde voldoen word';
$string['config_welcome_default'] = 'Standaard welkomboodskap';
$string['config_welcome_default_description'] = 'Vervang die standaardboodskap wat ingestel is op die BigBlueButton-bediener. Die boodskap kan sleutelwoorde (%% CONFNAME %%, %% DIALNUM %%, %% CONFNUM %%) bevat wat outomaties vervang sal word, en ook HTML-tags soos <b> ... </b> of <i> < / i>';
$string['end_session_confirm'] = 'Is jy seker jy wil die sessie beëindig?';
$string['end_session_confirm_title'] = 'Is jy seker jy wil die sessie eindig?';
$string['ends_at'] = 'Eindig';
$string['event_activity_created'] = 'Aktiwiteit geskep';
$string['event_activity_deleted'] = 'Aktiwiteit uitgevee';
$string['event_activity_updated'] = 'Aktiwiteit opdateer';
$string['event_live_session'] = 'Regstreekse sessie gebeure';
$string['event_meeting_created'] = 'Vergadering geskep';
$string['event_meeting_ended'] = 'Vergadering is noodgedwonge beëndig';
$string['event_meeting_joined'] = 'Vergadering aangesluit';
$string['event_meeting_left'] = 'Vergadering verlaat';
$string['event_recording_deleted'] = 'Opname uitgevee';
$string['event_recording_edited'] = 'Opname gewysig';
$string['event_recording_imported'] = 'Opname ingevoer';
$string['event_recording_protected'] = 'Opname beskerm';
$string['event_recording_published'] = 'Opname gepubliseer';
$string['event_recording_unprotected'] = 'Opname onbeskermd';
$string['event_recording_unpublished'] = 'Opname ongepubliseerd';
$string['event_recording_viewed'] = 'Opname besigtig';
$string['general_error_not_allowed_to_create_instances'] = 'Gebruiker word nie toegelaat om enige soort instansie te skep nie.';
$string['general_error_unable_connect'] = 'Kan nie koppel nie. Gaan die URL van die BigBlueButton-bediener na EN kyk of die BigBlueButton-bediener werk.';
$string['index_confirm_end'] = 'Wil jy graag die virtuele klas beëindig?';
$string['index_disabled'] = 'deaktiveer';
$string['index_enabled'] = 'aktiveer';
$string['index_ending'] = 'Beëindig die virtuele klaskamer ... wag asb';
$string['index_error_bbtn'] = 'BigBlueButton-ID {$ a} is verkeerd';
$string['index_error_checksum'] = '\'n Kontrolesomfout het voorgekom. Maak seker dat jy die regte sout ingevoer het.';
$string['index_error_forciblyended'] = 'Kan nie by hierdie vergadering aansluit nie, want dit is handmatig beëindig.';
$string['index_error_noinstances'] = 'Daar is geen instansie van die bigbluebuttonbn';
$string['index_error_unable_display'] = 'Kan nie die vergaderings vertoon nie. Gaan die url van die BigBlueButton-bediener na EN kyk of die BigBlueButton-bediener werk.';
$string['index_heading'] = 'BigBlueButton Kamers';
$string['index_heading_actions'] = 'Aksies';
$string['index_heading_group'] = 'Groep';
$string['index_heading_moderator'] = 'Moderators';
$string['index_heading_name'] = 'Kamer';
$string['index_heading_recording'] = 'Opname';
$string['index_heading_users'] = 'Gebruikers';
$string['index_heading_viewer'] = 'Kykers';
$string['indicator:cognitivedepth'] = 'BigBlueButtonBN kognitief';
$string['indicator:cognitivedepth_help'] = 'Hierdie aanwyser is gebaseer op die kognitiewe diepte wat die student in \'n BigBlueButtonBN-aktiwiteit bereik het.';
$string['indicator:socialbreadth'] = 'BigBlueButtonBN sosiaal';
$string['indicator:socialbreadth_help'] = 'Hierdie aanwyser is gebaseer op die sosiale breedte wat die student in \'n BigBlueButtonBN-aktiwiteit bereik.';
$string['instance_type_default'] = 'Kamer/Aktiwiteit met opnames';
$string['instance_type_recording_only'] = 'Slegs opnames';
$string['instance_type_room_only'] = 'Slegs kamer/aktiwiteit';
$string['minute'] = 'minuut';
$string['minutes'] = 'minute';
$string['mod_form_block_general'] = 'Algemene instellings';
$string['mod_form_block_participants'] = 'Rol toegeken tydens lewendige sessie';
$string['mod_form_block_presentation'] = 'Aanbieding inhoud';
$string['mod_form_block_presentation_default'] = 'Aanbieding verstekinhoud';
$string['mod_form_block_record'] = 'Opname instellings';
$string['mod_form_block_recordings'] = 'Vertoon vir opname';
$string['mod_form_block_room'] = 'Aktiwiteit/Kamer instellings';
$string['mod_form_block_schedule'] = 'Skedule vir sessie';
$string['mod_form_field_closingtime'] = 'Aansluiting gesluit';
$string['mod_form_field_conference_name'] = 'Konferensienaam';
$string['mod_form_field_disablecam'] = 'Deaktiveer webkameras';
$string['mod_form_field_disablemic'] = 'Deaktiveer mikrofone';
$string['mod_form_field_disablenote'] = 'Deaktiveer gedeelde notas';
$string['mod_form_field_disableprivatechat'] = 'Deaktiveer private klets';
$string['mod_form_field_disablepublicchat'] = 'Deaktiveer publieke klets';
$string['mod_form_field_duration'] = 'Tydsduur';
$string['mod_form_field_duration_help'] = 'Deur die tydsduur vir \'n vergadering in te stel, word die maksimum tyd bepaal vir die vergadering om aan te hou voordat die opname voltooi is';
$string['mod_form_field_hideuserlist'] = 'Versteek gebruikerslys';
$string['mod_form_field_instanceprofiles'] = 'Instansietipe';
$string['mod_form_field_instanceprofiles_help'] = 'Kies die tipe vir hierdie BigBlueButtonBN instansie.';
$string['mod_form_field_intro'] = 'Beskrywing';
$string['mod_form_field_intro_help'] = '\'n Kort beskrywing vir die kamer of konferensie';
$string['mod_form_field_muteonstart'] = 'Demp op begin';
$string['mod_form_field_name'] = 'Virtuele klaskamer naam';
$string['mod_form_field_nosettings'] = 'Geen instellings kan gewysig word nie';
$string['mod_form_field_openingtime'] = 'Aansluiting oop';
$string['mod_form_field_participant_add'] = 'Voeg toekenning by';
$string['mod_form_field_participant_bbb_role_moderator'] = 'Moderator';
$string['mod_form_field_participant_bbb_role_viewer'] = 'Kyker';
$string['mod_form_field_participant_list'] = 'Toekenningslys';
$string['mod_form_field_participant_list_action_add'] = 'Voeg by';
$string['mod_form_field_participant_list_action_remove'] = 'Verwyder';
$string['mod_form_field_participant_list_text_as'] = 'Sluit by sessie aan as';
$string['mod_form_field_participant_list_type_all'] = 'Alle ingetekende gebruikers';
$string['mod_form_field_participant_list_type_owner'] = 'Eienaar';
$string['mod_form_field_participant_list_type_role'] = 'Rol';
$string['mod_form_field_participant_list_type_user'] = 'Gebruiker';
$string['mod_form_field_record'] = 'Sessie kan opgeneem word';
$string['mod_form_field_recordallfromstart'] = 'Neem alles van begin af op';
$string['mod_form_field_recordhidebutton'] = 'Versteek opneem knoppie';
$string['mod_form_field_recordings_deleted'] = 'Sluit opnames van verwyderde aktiwiteite in';
$string['mod_form_field_recordings_html'] = 'Vertoon die tabel in gewone html';
$string['mod_form_field_recordings_imported'] = 'Vertoon slegs ingevoerde skakels';
$string['mod_form_field_recordings_preview'] = 'Wys opname voorskou';
$string['mod_form_field_room_name'] = 'Kamernaam';
$string['mod_form_field_userlimit'] = 'Gebruikerbeperking';
$string['mod_form_field_userlimit_help'] = 'Maksimum getal gebruikers wat tydens \'n vergadering toegelaat word. As die limiet op 0 ingestel is, sal die aantal gebruikers onbeperk wees.';
$string['mod_form_field_voicebridge'] = 'Stembrug [####]';
$string['mod_form_field_voicebridge_format_error'] = 'Formaatfout. Jy moet \'n getal tussen 1 en 9999 invoer.';
$string['mod_form_field_voicebridge_help'] = 'Stemkonferensie-nommer wat deelnemers invoer om by die stemmekonferensie aan te sluit wanneer hulle inbel gebruik. \'n Nommer tussen 1 en 9999 moet getik word. As die waarde 0 is, sal die statiese stemnommer geïgnoreer word en sal \'n ewekansige getal gegenereer word deur BigBlueButton. \'n Nommer 7 sal die vier getikte syfers voorafgaan';
$string['mod_form_field_voicebridge_notunique_error'] = 'Nie \'n unieke getal nie. Hierdie getal word reeds deur \'n ander kamer of konferensie gebruik.';
$string['mod_form_field_wait'] = 'Wag vir moderator';
$string['mod_form_field_wait_help'] = 'Kykers moet wag totdat \'n moderator die sessie betree voordat hulle dit kan doen';
$string['mod_form_field_welcome'] = 'Welcome message';
$string['mod_form_field_welcome_default'] = '<br>Welkom by <b>%%CONFNAME%%</b>!<br><br>Vir hulp met BigBlueButton kyk na hierdie (kort)  <a href="event:http://www.bigbluebutton.org/content/videos"><u>begeleidende videos</u></a>.<br><br>Om net na die klankbaan te luister kliek op die foonikoon . <b>Gebruik asb. \'n oorfoon om agtergrondgeraas vir ander te beperk.</b>';
$string['mod_form_field_welcome_help'] = 'Vervang die verstekboodskap wat op die BigBlueButton bediener opgestel is. Hierdie boodskap kan sleutelwoorde  (%%CONFNAME%%, %%DIALNUM%%, %%CONFNUM%%) wat outomaties vervang sal word insluit, asook html merkers soos &lt;b>...&lt;/b>, &lt;br />, &lt;u>&lt;/u> of &lt;i>&lt;/i>';
$string['mod_form_locksettings'] = 'Sluit instellings';
$string['modulename'] = 'BigBlueButtonBN';
$string['modulename_help'] = 'Met behulp van BigBlueButtonBN (\'n oopbron-webkonferensie-stelsel vir afstandsonderrig) kan jy binne Moodle-skakels skep na regstreekse aanlyn klasse.

Deur BigBlueButtonBN te gebruik kan jy die titel, beskrywing, kalenderinskrywing (wat aandui wanneer die sessie begin en ophou), groepe en besonderhede spesifiseer oor die opname van die aanlyn-sessie.';
$string['modulename_link'] = 'BigBlueButton/view';
$string['modulenameplural'] = 'BigBlueButtonBN';
$string['pluginadministration'] = 'BigBlueButtonBN administrasie';
$string['pluginname'] = 'BigBlueButtonBN';
$string['privacy:metadata:bigbluebutton'] = 'Om BigBlueButton-sessies te skep en daarby aan te sluit, moet gebruikersdata met die bediener uitgeruil word.';
$string['privacy:metadata:bigbluebutton:fullname'] = 'Die volle naam van die gebruiker wat toegang tot die BigBlueButton-bediener het.';
$string['privacy:metadata:bigbluebutton:userid'] = 'The userid of the user accessing the BigBlueButton server.';
$string['privacy:metadata:bigbluebuttonbn'] = 'Stoor die instelling vir die kamer of aktiwiteit wat die kenmerke en algemene gedrag van die BigBlueButton-sessie definieer.';
$string['privacy:metadata:bigbluebuttonbn:participants'] = '\'n Lys met reëls wat die rol bepaal wat gebruikers in die lewendige vergadering sal speel. \'n Gebruikers-ID kan gestoor word, aangesien per rol of gebruiker toestemmings verleen kan word.';
$string['privacy:metadata:bigbluebuttonbn_logs'] = 'Stoor gebeure wat veroorsaak word tydens die gebruik van die inprop.';
$string['privacy:metadata:bigbluebuttonbn_logs:log'] = 'Die tipe gebeurtenis wat deur die gebruiker veroorsaak word.';
$string['privacy:metadata:bigbluebuttonbn_logs:meetingid'] = 'Die vergadering ID waartoe die gebruiker toegang het.';
$string['privacy:metadata:bigbluebuttonbn_logs:meta'] = 'Dit kan ekstra inligting bevat wat verband hou met die vergadering of die opname wat deur die geleentheid beïnvloed word.';
$string['privacy:metadata:bigbluebuttonbn_logs:timecreated'] = 'Die tydstip waarop die logboek geskep is.';
$string['privacy:metadata:bigbluebuttonbn_logs:userid'] = 'Die gebruikers-ID van die gebruiker wat die gebeurtenis veroorsaak het.';
$string['removedevents'] = 'Verwyderde gebeure';
$string['removedlogs'] = 'Verwyderde pasgemaakte logboeke';
$string['removedrecordings'] = 'Verwyderde opnames';
$string['removedtags'] = 'Verwyderde merkers';
$string['resetevents'] = 'Verwyderde gebeurtenisse';
$string['resetlogs'] = 'Verwyderde pasgemaakte logboeke';
$string['resetlogs_help'] = 'As jy die logboeke verwyder, verloor jy verwysings na opnames';
$string['resetrecordings'] = 'Verwyderde opnames';
$string['resetrecordings_help'] = 'Verwydering van opnames sal hul oral ontoeganklik en dit kan nie ontdoen word nie';
$string['resettags'] = 'Verwyder merkers';
$string['search:activity'] = 'BigBlueButtonBN - aktiwiteitsinligting';
$string['search:tags'] = 'BigBlueButtonBN - merkers inligting';
$string['sendnotification'] = 'Stuur kennisgewings';
$string['started_at'] = 'Het begin';
$string['starts_at'] = 'Begin teen';
$string['view_conference_action_end'] = 'Beëindig sessie';
$string['view_conference_action_join'] = 'Sluit aan by sessie';
$string['view_error_action_not_completed'] = 'Aksie kon nie voltooi word nie';
$string['view_error_bigbluebutton'] = 'BigBlueButton het met foute gereageer. {$a}';
$string['view_error_create'] = 'Die BigBlueButton-bediener het geantwoord met \'n foutboodskap, die vergadering kon nie geskep word nie.';
$string['view_error_current_state_not_found'] = 'Huidige status is nie gevind nie. Die opname is dalk verwyder of die BigBlueButton-bediener is nie versoenbaar met die uitgevoerde aksie nie.';
$string['view_error_import_no_courses'] = 'Geen kursus om te soek vir opnames nie';
$string['view_error_import_no_recordings'] = 'Geen opnames in hierdie kursus vir invoering nie';
$string['view_error_invalid_session'] = 'Hierdie sessie is vertreke. Gaan terug na die hoofblad van die aktiwiteit.';
$string['view_error_max_concurrent'] = 'Aantal gelyktydige vergaderings wat toegelaat word is bereik.';
$string['view_error_meeting_not_running'] = 'Iets het verkeerd gegaan, die vergadering werk nie tans nie.';
$string['view_error_no_group'] = 'Daar is geen groepe tans opgestel nie. Stel asb. groepe op voordat jy probeer om by die vergadering aan te sluit.';
$string['view_error_no_group_student'] = 'Jy is nog nie in \'n groep ingeskryf nie. Kontak asb. jou onderwyser of die administrateur.';
$string['view_error_no_group_teacher'] = 'Daar is tans geen groepe opgestel nie. Stel asb. groepe op of kontak die administrateur.';
$string['view_error_unable_join'] = 'Kan nie by die vergadering aansluit nie. Gaan die url van die BigBlueButton-bediener na EN kyk of die BigBlueButton-bediener werk.';
$string['view_error_unable_join_student'] = 'Kan nie aan die BigBlueButton-bediener koppel nie. Kontak u onderwyser of die administrateur.';
$string['view_error_unable_join_teacher'] = 'Kan nie aan die BigBlueButton-bediener koppel nie. Kontak asseblief die administrateur.';
$string['view_error_url_missing_parameters'] = 'Daar is parameters wat ontbreek in hierdie URL';
$string['view_error_userlimit_reached'] = 'Die aantal toegelate gebruikers wat in \'n vergadering toegelaat word is bereik.';
$string['view_groups_nogroups_warning'] = 'Die kamer is ingestel vir die gebruik van groepe, maar die kursus het nie die groepe nie.';
$string['view_groups_notenrolled_warning'] = 'Die kamer is ingestel om groepe te gebruik, maar jy is nie by een van hulle ingeskryf nie.';
$string['view_groups_selection'] = 'Kies die groep waarby jy wil aansluit en bevestig jou keuse';
$string['view_groups_selection_join'] = 'Sluit aan';
$string['view_groups_selection_warning'] = 'Daar is \'n konferensielokaal vir elke groep en jy het toegang tot meer as een. Kies die regte een.';
$string['view_login_moderator'] = 'Teken in as moderator ...';
$string['view_login_viewer'] = 'Teken in as kyker ...';
$string['view_message_and'] = 'en';
$string['view_message_conference_has_ended'] = 'Die konferensie is beëndig.';
$string['view_message_conference_in_progress'] = 'Die konferensie vind tans plaas.';
$string['view_message_conference_not_started'] = 'Die konferensie het nog nie begin nie.';
$string['view_message_conference_room_ready'] = 'Die konferensiekamer is gereed. Jy kan nou by die sessie aansluit.';
$string['view_message_conference_wait_for_moderator'] = 'Wag vir \'n moderator om aan te sluit.';
$string['view_message_finished'] = 'Die aktiwiteit is verby.';
$string['view_message_has_joined'] = 'het aangesluit';
$string['view_message_have_joined'] = 'het aangesluit';
$string['view_message_hour'] = 'uur';
$string['view_message_hours'] = 'ure';
$string['view_message_importrecordings_disabled'] = 'Funksie vir invoering  van opnameskakels is deaktiveer op die bediener';
$string['view_message_minute'] = 'minuut';
$string['view_message_minutes'] = 'minute';
$string['view_message_moderator'] = 'moderator';
$string['view_message_moderators'] = 'moderators';
$string['view_message_norecordings'] = 'Daar is geen opnames om te vertoon nie';
$string['view_message_notavailableyet'] = 'Die sessie is nie tans beskikbaar nie.';
$string['view_message_recordings_disabled'] = 'Opnames is op hierdie bediener gedeaktiveer. BigBlueButtonBN-gevalle slegs vir opnames kan nie gebruik word nie.';
$string['view_message_room_closed'] = 'Die kamer is gesluit.';
$string['view_message_room_open'] = 'Die kamer is oop';
$string['view_message_room_ready'] = 'Die kamer is gereed.';
$string['view_message_session_for'] = 'die sessie vir';
$string['view_message_session_has_user'] = 'Daar is';
$string['view_message_session_has_users'] = 'Daar is';
$string['view_message_session_no_users'] = 'Daar is geen gebruikers in die sessie nie';
$string['view_message_session_running_for'] = 'Die sessie is al besig vir';
$string['view_message_session_started_at'] = 'Die sessie het begin teen';
$string['view_message_tab_close'] = 'Die venster moet handmatig gesluit word';
$string['view_message_times'] = 'tye';
$string['view_message_user'] = 'gebruiker';
$string['view_message_users'] = 'gebruikers';
$string['view_message_viewer'] = 'kyker';
$string['view_message_viewers'] = 'kykers';
$string['view_mobile_message_groups_not_supported'] = 'Hierdie instansie stel in staat om met groepe te werk, maar die mobiele toep bied nie hiervoor ondersteuning nie. Maak dit asseblief op \'n rekenaar oop as jy die groepondersteuning wil gebruik.';
$string['view_mobile_message_reload_page_creation_time_meeting'] = 'Jy het die 45 sekondes op hierdie bladsy oorskry. Herlaai asseblief die bladsy om korrek by die vergadering aan te sluit.';
$string['view_noguests'] = 'Die BigBlueButtonBN is nie oop vir gaste nie';
$string['view_nojoin'] = 'Jy is nie in \'n rol wat nodig in om by die sessie aan te sluit nie.';
$string['view_recording'] = 'besig om op te neem';
$string['view_recording_actionbar'] = 'Werkbalk';
$string['view_recording_activity'] = 'Aktiwiteit';
$string['view_recording_button_import'] = 'Voer opnameskakels in';
$string['view_recording_button_return'] = 'Gaan terug';
$string['view_recording_course'] = 'Kursus';
$string['view_recording_date'] = 'Datum';
$string['view_recording_delete_confirmation'] = 'Is jy seker dat jy hierdie {$a} wil uitvee?';
$string['view_recording_delete_confirmation_warning_p'] = 'Hierdie opname bevat {$a} skakels wat in verskillende kursusse of aktiwiteite ingevoer is. As die opname verwyder word, sal die skakels ook verwyder word';
$string['view_recording_delete_confirmation_warning_s'] = 'Hierdie opname het \'n skakel met {$a} wat in \'n ander kursus of aktiwiteit ingevoer is. As die opname verwyder word, sal die skakel ook verwyder word';
$string['view_recording_description'] = 'Beskrywing';
$string['view_recording_duration'] = 'Duur';
$string['view_recording_duration_min'] = 'min';
$string['view_recording_format_errror_unreachable'] = 'Die URL vir hierdie opname is onbereikbaar.';
$string['view_recording_format_notes'] = 'Notas';
$string['view_recording_format_podcast'] = 'Potgooi';
$string['view_recording_format_presentation'] = 'Aanbieding';
$string['view_recording_format_screenshare'] = 'Skermdeling';
$string['view_recording_format_statistics'] = 'Statistieke';
$string['view_recording_format_video'] = 'Video';
$string['view_recording_import_confirmation'] = 'Is jy seker jy wil hierdie opname invoer?';
$string['view_recording_length'] = 'Lengte';
$string['view_recording_link_warning'] = 'Dit is \'n skakel wat verwys na \'n opname wat in \'n ander kursus of aktiwiteit geskep is';
$string['view_recording_list_action_delete'] = 'Besig om uit te vee';
$string['view_recording_list_action_edit'] = 'Opdatering';
$string['view_recording_list_action_play'] = 'Speel';
$string['view_recording_list_action_process'] = 'Prosessering';
$string['view_recording_list_action_protect'] = 'Beskerming';
$string['view_recording_list_action_publish'] = 'Publisering';
$string['view_recording_list_action_unprotect'] = 'Onbeskerming';
$string['view_recording_list_action_unpublish'] = 'Onpublisering';
$string['view_recording_list_action_update'] = 'Opdatering';
$string['view_recording_list_actionbar'] = 'Werkbalk';
$string['view_recording_list_actionbar_delete'] = 'Skrap';
$string['view_recording_list_actionbar_edit'] = 'Wysig';
$string['view_recording_list_actionbar_hide'] = 'Versteek';
$string['view_recording_list_actionbar_import'] = 'Invoer';
$string['view_recording_list_actionbar_protect'] = 'Maak dit privaat';
$string['view_recording_list_actionbar_publish'] = 'Publiseer';
$string['view_recording_list_actionbar_show'] = 'Wys';
$string['view_recording_list_actionbar_unprotect'] = 'Maak publiek';
$string['view_recording_list_actionbar_unpublish'] = 'Ontpubliseer';
$string['view_recording_list_activity'] = 'Aktiwiteit';
$string['view_recording_list_course'] = 'Kursus';
$string['view_recording_list_date'] = 'Datum';
$string['view_recording_list_description'] = 'Beskrywing';
$string['view_recording_list_duration'] = 'Tydsduur';
$string['view_recording_list_recording'] = 'Besig om op te neem';
$string['view_recording_meeting'] = 'Vergadering';
$string['view_recording_modal_button'] = 'Pas toe';
$string['view_recording_modal_title'] = 'Stel waardes vir opname in';
$string['view_recording_name'] = 'Naam';
$string['view_recording_playback'] = 'Terugspeel';
$string['view_recording_preview'] = 'Voorskou';
$string['view_recording_preview_help'] = 'Sweef oor \'n prent om dit in \'n volle grote te sien';
$string['view_recording_publish_link_deleted'] = 'Hierdie skakel kan nie weer gepubliseer word nie, want die werklike opname bestaan nie in die huidige BigBlueButton-bediener nie. Die skakel moet verwyder word.';
$string['view_recording_publish_link_not_published'] = 'Hierdie skakel kan nie weer gepubliseer word nie omdat die opname nie gepubliseer is nie';
$string['view_recording_recording'] = 'Besig met opname';
$string['view_recording_tags'] = 'Merkers';
$string['view_recording_unprotect_link_deleted'] = 'Hierdie skakel kan nie onbeskerm word nie, want die werklike opname bestaan nie in die huidige BigBlueButton-bediener nie. Die skakel moet verwyder word.';
$string['view_recording_unprotect_link_not_unprotected'] = 'Hierdie skakel kan nie onbeskerm word nie, want die werklike opname is beskerm';
$string['view_recording_unpublish_confirmation'] = 'Is jy seker jy wil hierdie {$a} ontpubliseer?';
$string['view_recording_unpublish_confirmation_warning_p'] = 'Hierdie opname bevat {$a} skakels wat in verskillende kursusse of aktiwiteite ingevoer is. As die opname nie gepubliseer is nie, sal die skakels ook nie gepubliseer word nie';
$string['view_recording_unpublish_confirmation_warning_s'] = 'Hierdie opname het \'n skakel met {$a} wat in \'n ander kursus of aktiwiteit ingevoer is. As die opname nie gepubliseer is nie, sal die skakel ook nie gepubliseer word nie';
$string['view_recording_yui_first'] = 'Eerste';
$string['view_recording_yui_go'] = 'Gaan';
$string['view_recording_yui_last'] = 'Laaste';
$string['view_recording_yui_next'] = 'Volgende';
$string['view_recording_yui_page'] = 'Bladsy';
$string['view_recording_yui_prev'] = 'Vorige';
$string['view_recording_yui_rows'] = 'Rye';
$string['view_recording_yui_show_all'] = 'Wys alles';
$string['view_room'] = 'Sien kamer';
$string['view_section_title_presentation'] = 'Aanbieding lêer';
$string['view_section_title_recordings'] = 'Opnames';
$string['view_warning_default_server'] = 'Hierdie Moodle-bediener maak gebruik van die BigBlueButton-toetsbediener wat as verstekinstelling vooraf ingestel is. Dit moet vervang word vir produksie.';
