<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'auth_shibboleth', language 'lo', version '4.5'.
 *
 * @package     auth_shibboleth
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['auth_shib_auth_logo'] = 'ໂລໂກ້ວິທີການກວດສອບຄວາມຖືກຕ້ອງ';
$string['auth_shib_auth_logo_description'] = 'ໃຫ້ໂລໂກ້ສໍາລັບວິທີການກວດສອບຄວາມຖືກຕ້ອງຂອງ Shibboleth ທີ່ຄຸ້ນເຄີຍກັບຜູ້ໃຊ້ຂອງທ່ານ. ນີ້ອາດຈະເປັນໂລໂກ້ຂອງສະຫະພັນ Shibboleth ຂອງທ່ານ, ເຊັ່ນ: <tt>SWITCHAaai ເຂົ້າສູ່ລະບົບ</tt> ຫຼື <tt>ການເຂົ້າສູ່ລະບົບ inCommon</tt> ຫຼື ຄ້າຍຄືກັນ.';
$string['auth_shib_auth_method'] = 'ໂລໂກ້ວິທີການກວດສອບຄວາມຖືກຕ້ອງ';
$string['auth_shib_auth_method_description'] = 'ໃຫ້ຊື່ສໍາລັບວິທີການກວດສອບ Shibboleth ທີ່ຄຸ້ນເຄີຍກັບຜູ້ໃຊ້ຂອງທ່ານ. ນີ້ອາດຈະເປັນຊື່ຂອງສະຫະພັນ Shibboleth ຂອງທ່ານ, ເຊັ່ນ: <tt>SWITCHAaai ເຂົ້າສູ່ລະບົບ</tt> ຫຼື <tt>ການເຂົ້າສູ່ລະບົບ inCommon</tt> ຫຼື ຄ້າຍຄືກັນ.';
$string['auth_shib_changepasswordurl'] = 'ການປ່ຽນລະຫັດຜ່ານ URL';
$string['auth_shib_contact_administrator'] = 'ໃນກໍລະນີທີ່ທ່ານບໍ່ໄດ້ກ່ຽວຂ້ອງກັບອົງການຈັດຕັ້ງທີ່ກໍານົດໄວ້ ແລະ ທ່ານຕ້ອງການເຂົ້າເຖິງຫຼັກສູດກ່ຽວກັບເຊີເວີນີ້, ກະລຸນາຕິດຕໍ່ຫາ <a href="mailto:{$a}">ຜູ້ເບິ່ງແຍງລະບົບ Moodle</a>.';
$string['auth_shib_convert_data'] = 'API ການແກ້ໄຂຂໍ້ມູນ';
$string['auth_shib_convert_data_description'] = 'ທ່ານສາມາດນໍາໃຊ້ API ນີ້ ເພື່ອປັບປຸງເພີ່ມເຕີມຂໍ້ມູນທີ່ສະໜອງໃຫ້ໂດຍ Shibboleth. ອ່ານ <a href="{$a}">README</a> ສໍາລັບຄໍາແນະນໍາເພີ່ມເຕີມ.';
$string['auth_shib_convert_data_filepath_warning'] = 'ທ່ານບໍ່ສາມາດໃຊ້ໄຟລ໌ທີ່ຢູ່ໃນບັນຊີລາຍການຂໍ້ມູນເວັບໄຊທ໌ປັດຈຸບັນ ($CFG->dataroot) ເປັນ API ການດັດແກ້ຂໍ້ມູນ.';
$string['auth_shib_convert_data_warning'] = 'ໄຟລ໌ບໍ່ມີຢູ່ ຫຼື ບໍ່ສາມາດອ່ານໄດ້ໂດຍຂະບວນການຂອງເຊີບເວີ!';
$string['auth_shib_idp_list'] = 'ຜູ້ໃຫ້ການລະບຸຕົວຕົນ';
$string['auth_shib_idp_list_description'] = 'ໃຫ້ລາຍຊື່ຂອງຜູ້ໃຫ້ການລະບຸຕົວຕົນ entityIDs ເພື່ອໃຫ້ຜູ້ໃຊ້ເລືອກຈາກໜ້າເຂົ້າສູ່ລະບົບ.<br />ໃນແຕ່ລະແຖວຈະຕ້ອງມີ tuple ທີ່ແຍກດ້ວຍເຄື່ອງໝາຍຈຸດສໍາລັບ entityID ຂອງ IdP (ເບິ່ງໄຟລ໌ metadata Shibboleth) ແລະ ຊື່ຂອງ IdP ເປັນ ມັນຈະຖືກສະແດງຢູ່ໃນລາຍການແບບເລື່ອນລົງ.<br />ເປັນຕົວກໍານົດການທີສາມທາງເລືອກ, ທ່ານສາມາດເພີ່ມສະຖານທີ່ຂອງຜູ້ລິເລີ່ມໄລຍະເວລາ Shibboleth ທີ່ຈະຖືກນໍາໃຊ້ໃນກໍລະນີທີ່ການຕິດຕັ້ງ Moodle ຂອງທ່ານເປັນສ່ວນໜຶ່ງຂອງການຕັ້ງຄ່າຫຼາຍສະຫະພັນ.';
$string['auth_shib_instructions'] = 'ໃຊ້ <a href="{$a}">ເຂົ້າສູ່ລະບົບ Shibboleth</a> ເພື່ອເຂົ້າເຖິງຜ່ານ Shibboleth, ຖ້າສະຖາບັນຂອງທ່ານສະໜັບສະໜູນມັນ. ຖ້າບໍ່ດັ່ງນັ້ນ, ໃຫ້ໃຊ້ແບບຟອມເຂົ້າສູ່ລະບົບປົກກະຕິທີ່ສະແດງຢູ່ທີ່ນີ້.';
$string['auth_shib_instructions_help'] = 'ໃນທີ່ນີ້ທ່ານຄວນໃຫ້ຄໍາແນະນໍາທີ່ກໍານົດເອງ ສໍາລັບຜູ້ໃຊ້ຂອງທ່ານເພື່ອອະທິບາຍ Shibboleth. ມັນຈະສະແດງຢູ່ໃນໜ້າເຂົ້າສູ່ລະບົບໃນພາກຄໍາແນະນໍາ. ຄຳແນະນຳຈະຕ້ອງມີລິ້ງໄປຫາ "<b>{$a}</b>" ທີ່ຜູ້ໃຊ້ຄລິກເມື່ອເຂົາເຈົ້າຕ້ອງການເຂົ້າສູ່ລະບົບ.';
$string['auth_shib_instructions_key'] = 'ຄຳແນະນຳການເຂົ້າສູ່ລະບົບ';
$string['auth_shib_integrated_wayf'] = 'ການບໍລິການ Moodle WAYF';
$string['auth_shib_integrated_wayf_description'] = 'ຖ້າທ່ານເປີດໃຊ້ງານນີ້, Moodle ຈະໃຊ້ບໍລິການ WAYF ຂອງມັນເອງແທນທີ່ຈະເປັນອັນທີ່ກຳນົດຄ່າໃຫ້ Shibboleth. Moodle ຈະສະແດງລາຍການແບບເລື່ອນລົງໃນໜ້າເຂົ້າສູ່ລະບົບທາງເລືອກນີ້ທີ່ຜູ້ໃຊ້ຕ້ອງເລືອກ ຜູ້ໃຫ້ການລະບຸຕົວຕົນ ຂອງລາວ.';
$string['auth_shib_logout_return_url'] = 'ທາງເລືອກການອອກຈາກລະບົບກັບຄືນ URL';
$string['auth_shib_logout_return_url_description'] = 'ໃຫ້ URL ທີ່ຜູ້ໃຊ້ Shibboleth ຈະຖືກໂອນໄປຫາຫຼັງຈາກອອກຈາກລະບົບ.<br />ຖ້າປະໄວ້ຫວ່າງເປົ່າ, ຜູ້ໃຊ້ຈະຖືກໂອນໄປຫາສະຖານທີ່ທີ່ moodle ຈະໂອນຜູ້ໃຊ້ໄປຫາ';
$string['auth_shib_logout_url'] = 'URL ຕົວຈັດການອອກຈາກລະບົບຂອງຜູ້ໃຫ້ບໍລິການ Shibboleth';
$string['auth_shib_logout_url_description'] = 'ສະໜອງ URL ໃຫ້ກັບຕົວຈັດການອອກຈາກລະບົບຂອງຜູ້ໃຫ້ບໍລິການ Shibboleth. ປົກກະຕິນີ້ແມ່ນ <tt>/Shibboleth.sso/Logout</tt>';
$string['auth_shib_no_organizations_warning'] = 'ຖ້າທ່ານຕ້ອງການໃຊ້ການບໍລິການ WAYF ປະສົມປະສານ, ທ່ານຕ້ອງໃຫ້ບັນຊີລາຍຊື່ທີ່ແຍກອອກໂດຍ ໝາຍຈຸດ ຂອງ ຜູ້ໃຫ້ການລະບຸຕົວຕົນ entityIDs, ຊື່ຂອງພວກເຂົາ ແລະ ທາງເລືອກເປັນຜູ້ລິເລີ່ມຂອງຊ່ວງເວລາ.';
$string['auth_shib_only'] = 'Shibboleth ເທົ່ານັ້ນ';
$string['auth_shib_only_description'] = 'ກວດເບິ່ງທາງເລືອກນີ້ ຖ້າຫາກວ່າ ການກວດສອບຄວາມຖືກຕ້ອງຂອງ Shibboleth ຈະຖືກບັງຄັບໃຊ້';
$string['auth_shib_username_description'] = 'ຊື່ຂອງຕົວແປສະພາບແວດລ້ອມຂອງເຊີບເວີ Shibboleth ທີ່ຈະຖືກໃຊ້ເປັນຊື່ຜູ້ໃຊ້ Moodle';
$string['auth_shibboleth_errormsg'] = 'ກະລຸນາເລືອກອົງກອນທີ່ທ່ານເປັນສະມາຊິກ!';
$string['auth_shibboleth_login'] = 'ເຂົ້າສູ່ລະບົບ Shibboleth';
$string['auth_shibboleth_login_long'] = 'ເຂົ້າສູ່ລະບົບ Moodle ຜ່ານ Shibboleth';
$string['auth_shibboleth_manual_login'] = 'ເຂົ້າສູ່ລະບົບດ້ວຍມື';
$string['auth_shibboleth_select_member'] = 'ຂ້ອຍເປັນສະມາຊິກຂອງ ...';
$string['auth_shibboleth_select_organization'] = 'ສໍາລັບການກວດສອບຄວາມຖືກຕ້ອງຜ່ານ Shibboleth, ກະລຸນາເລືອກອົງກອນຂອງທ່ານຈາກເມນູເລື່ອນລົງ:';
$string['auth_shibbolethdescription'] = 'ການນໍາໃຊ້ວິທີການນີ້ ຜູ້ໃຊ້ໄດ້ຖືກສ້າງຂື້ນ ແລະ ການກວດສອບຄວາມຖືກຕ້ອງໂດຍໃຊ້ Shibboleth. ສຳລັບລາຍລະອຽດການຕັ້ງຄ່າ, ກະລຸນາເບິ່ງທີ່ <a href="{$a}">Shibboleth README</a>.';
$string['pluginname'] = 'Shibboleth';
$string['privacy:metadata'] = 'ປລັກອິນການກວດສອບຄວາມຖືກຕ້ອງຂອງ Shibboleth ບໍ່ໄດ້ເກັບຮັກສາຂໍ້ມູນສ່ວນຕົວໃດໆ.';
$string['shib_invalid_account_error'] = 'ເບິ່ງຄືວ່າທ່ານໄດ້ຮັບການກວດສອບຄວາມຖືກຕ້ອງ Shibboleth ແຕ່ Moodle ບໍ່ມີບັນຊີທີ່ຖືກຕ້ອງສໍາລັບຊື່ຜູ້ໃຊ້ຂອງທ່ານ. ບັນຊີຂອງທ່ານອາດຈະບໍ່ມີຢູ່ ຫຼື ມັນອາດຈະຖືກລະງັບໄວ້.';
$string['shib_no_attributes_error'] = 'ເບິ່ງຄືວ່າ ທ່ານໄດ້ຮັບການກວດສອບຄວາມຖືກຕ້ອງ Shibboleth ແຕ່ Moodle ບໍ່ໄດ້ຮັບຄຸນລັກສະນະຜູ້ໃຊ້ໃດໆ. ກະລຸນາກວດເບິ່ງວ່າ ຜູ້ໃຫ້ການລະບຸຕົວຕົນ ຂອງທ່ານປ່ອຍຄຸນລັກສະນະທີ່ຈໍາເປັນ ({$a}) ໃຫ້ກັບຜູ້ໃຫ້ບໍລິການ Moodle ເຮັດວຽກຢູ່ ຫຼື ແຈ້ງໃຫ້ຜູ້ຄຸ້ມຄອງເວັບຂອງເຊີເວີນີ້.';
$string['shib_not_all_attributes_error'] = 'Moodle ຕ້ອງການຄຸນລັກສະນະຂອງ Shibboleth ບາງຢ່າງທີ່ບໍ່ມີຢູ່ໃນກໍລະນີຂອງທ່ານ. ຄຸນລັກສະນະແມ່ນ: {$a}<br />ກະລຸນາຕິດຕໍ່ຜູ້ຄຸ້ມຄອງເວັບຂອງເຊີເວີນີ້ ຫຼື ຜູ້ໃຫ້ບໍລິການລະບຸຕົວຕົນຂອງທ່ານ.';
$string['shib_not_set_up_error'] = 'ການກວດສອບຄວາມຖືກຕ້ອງຂອງ Shibboleth ເບິ່ງຄືວ່າ ບໍ່ໄດ້ຖືກຕັ້ງຢ່າງຖືກຕ້ອງເພາະວ່າບໍ່ມີຕົວແປສະພາບແວດລ້ອມ Shibboleth ຢູ່ໃນໜ້ານີ້. ກະລຸນາປຶກສາ <a href="{$a}">README</a> ສໍາລັບຄໍາແນະນໍາເພີ່ມເຕີມກ່ຽວກັບວິທີການຕັ້ງຄ່າການພິສູດຢືນຢັນ Shibboleth ຫຼື ຕິດຕໍ່ຜູ້ຄຸ້ມຄອງເວັບຂອງການຕິດຕັ້ງ Moodle ນີ້.';
