<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_nonzero', language 'de', version '4.5'.
 *
 * @package     theme_nonzero
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['choosereadme'] = '<div class="clearfix">
<div class="theme_screenshot">
<h2>Nonzero</h2>
<img src="nonzero/pix/screenshot.jpg" />
<h3>Forum zur Designdiskussion:</h3>
<p><a href="http://moodle.org/mod/forum/view.php?id=46">http://moodle.org/mod/forum/view.php?id=46</a></p>
<h3>Danksagungen (Designs):</h3>
<p><a href="http://docs.moodle.org/en/Theme_credits">http://docs.moodle.org/en/Theme_credits</a></p>
<h3>Dokumentationen:</h3><p><a href="http://docs.moodle.org/de/Designs">http://docs.moodle.org/de/Designs</a></p>
<h3>Fehler melden:</h3>
<p><a href="http://tracker.moodle.org">http://tracker.moodle.org</a></p>
</div>
<div class="theme_description">
<h2>Über Nonzero</h2>
<p>Nonzero ist ein modernes Drei-Spalten-Design mit variabler Breite für Moodle 2.0. Es ist in dem Sinne modern, dass es ein neues Drei-Spalten-Layout benutzt und die Inhalte links von den beiden Blockspalten anzeigt.
<h2>Hinweise</h2>
<p>Dieses Design basiert auf den beiden in Moodle enthaltenen Grunddesigns Base und Canvas. Wenn Sie Änderungen vornehmen wollen, empfehlen wir unbedingt, vorher immer eine Kopie zu erstellen und diese umzubenennen. So wird verhindert, dass Ihre Änderungen bei einem Update von Moodle verloren gehen; Sollte Ihnen ein Fehler in den Änderungen unterlaufen, haben Sie so ebenfalls noch eine funktionierende Sicherheitskopie. Weitere Informationen zum Bearbeiten von Designs finden Sie in der <a href="http://docs.moodle.org/de/Designs">Designdokumentation</a>.</p>
<h2>Autor</h2>
<p>Dieses Design wurde erstellt und wird weiter unterstützt von Patrick Malley (NewSchool Learning). Kontaktaufnahme ist per E-Mail: contact@newschoollearning.com</p>
<h2>Lizenz</h2>
<p>Alle in Moodle enthaltenen Grunddesigns stehen unter der <a href="http://www.gnu.org/licenses/gpl.html">GNU General Public License</a>.
</div>
</div>';
$string['configtitle'] = 'Nonzero-Einstellungen';
$string['customcss'] = 'CSS-Anpassungen';
$string['customcssdesc'] = 'Die CSS-Anpassungen werden auf jeder Seite benutzt. Das Design kann so einfach geändert werden.';
$string['pluginname'] = 'Nonzero';
$string['region-side-post'] = 'Rechts';
$string['region-side-pre'] = 'Links';
$string['regionpostwidth'] = 'Rechte Spaltenbreite';
$string['regionpostwidthdesc'] = 'Diese Einstellung legt die Breite der Blockbereiche in der rechten Spalte fest.';
$string['regionprewidth'] = 'Linke Spaltenbreite';
$string['regionprewidthdesc'] = 'Hier wird die Breite der Block-Elemente, die die linke Spalte bilden, angegeben. In der Blogansicht bildet sie den mittleren Bereich.';
