<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'facetoface', language 'de', version '4.5'.
 *
 * @package     facetoface
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addingsession'] = 'Neue Veranstaltung in {$a} hinzufügen';
$string['addmanageremailaddress'] = 'E-Mail-Adresse des/der Vorgesetzten hinzufügen';
$string['addmanageremailinstruction'] = 'Sie haben die E-Mail-Adresse Ihres/Ihrer Vorgesetzten noch nicht eingegeben. Bitte holen Sie das unten nach, um sich für diese Sitzung anzumelden.';
$string['addnewfield'] = 'Neues benutzerdefiniertes Feld hinzufügen';
$string['addnewfieldlink'] = 'Neues benutzerdefiniertes Feld erstellen';
$string['addnewnotice'] = 'Eine neue Notiz zu einem Ort hinzufügen';
$string['addnewnoticelink'] = 'Eine neue Notiz zu einem Ort erstellen';
$string['addremoveattendees'] = 'Teilnehmer/innen hinzufügen / entfernen';
$string['addsession'] = 'Einen neuen Termin hinzufügen';
$string['addstudent'] = 'Eine/n Teilnehmer/in hinzufügen';
$string['alllocations'] = 'Alle Orte';
$string['allowcancellations'] = 'Erlaube die Stornierung von Anmeldungen';
$string['allowcancellations_help'] = 'Wenn diese Option aktiviert ist, können Veranstaltungsteilnehmer/innen ihre Anmeldungen stornieren';
$string['allowcancellationsdefault'] = 'Erlaube die Stornierung von Anmeldungen (Voreinstellung)';
$string['allowcancellationsdefault_help'] = 'Wenn diese Option aktiviert ist, werden bei der Erstellung neuer Termine für diese Aktivität standardmäßig Anmeldestornierungen zugelassen';
$string['allowoverbook'] = 'Überbuchung erlauben';
$string['allowoverbook_help'] = 'Wenn "Überbuchung erlauben" aktiviert ist, können sich Teilnehmer/innen für eine Veranstaltung anmelden, auch wenn dieser bereits ausgebucht ist.<br />

Wenn sich ein/e Teilnehmer/in für einen Termin anmeldet, der bereits ausgebucht ist, wird er/sie in einer E-Mail darauf hingewiesen, dass er/sie auf die Warteliste für den Termin gesetzt wurde und benachrichtigt wird, sobald ein Platz verfügbar ist.';
$string['allsessionsin'] = 'Alle Veranstaltungen in {$a}';
$string['alreadysignedup'] = 'Sie haben sich bereits für diese Veranstaltung angemeldet.';
$string['answer'] = 'Einloggen';
$string['answercancel'] = 'Ausloggen';
$string['approvalreqd'] = 'Genehmigung erforderlich';
$string['approvalreqd_help'] = 'Wenn "Genehmigung erforderlich" aktiviert ist, benötigen Teilnehmer/innen die Genehmigung ihres/ihrer Vorgesetzten, um an einer Veranstaltung teilnehmen zu dürfen.';
$string['approve'] = 'Genehmigen';
$string['assessmentyour'] = 'Ihre Einschätzung';
$string['attendance'] = 'Teilnahme';
$string['attendanceinstructions'] = 'Wählen Sie die Teilnehmer/innen aus, die an der Veranstaltung teilgenommen haben:';
$string['attendedsession'] = 'Besuchter Termin';
$string['attendees'] = 'Teilnehmer/innen';
$string['attendeesexporttofileheading'] = 'Teilnehmer/innen in Datei exportieren';
$string['booked'] = 'Gebucht';
$string['bookingcancelled'] = 'Ihre Buchung wurde storniert.';
$string['bookingcompleted'] = 'Ihre Buchung wurde abgeschlossen.';
$string['bookingfull'] = 'Ausgebucht';
$string['bookingopen'] = 'Buchung möglich';
$string['bookingstatus'] = 'Sie sind für folgenden Termin angemeldet';
$string['calendareventdescriptionbooking'] = 'Sie sind für diese <a href="{$a}">Veranstaltung</a> angemeldet.';
$string['calendareventdescriptionsession'] = 'Sie haben diese <a href="{$a}">Veranstaltung</a> erstellt.';
$string['calendaroptions'] = 'Kalenderoptionen';
$string['cancelbooking'] = 'Buchung stornieren';
$string['cancelbookingfor'] = 'Buchung stornieren für {$a}';
$string['cancellation'] = 'Stornierung';
$string['cancellationconfirm'] = 'Möchten Sie wirklich die Buchung für diese Veranstaltung stornieren?';
$string['cancellationinstrmngr'] = '# Benachrichtigung an Vorgesetzte/n';
$string['cancellationinstrmngr_help'] = 'Wenn "Benachrichtigung an Vorgesetzte/n senden" aktiviert ist, wird der Text im Feld "Benachrichtigung für Vorgesetzte/n" an eine/n Vorgesetzte/n gesendet, der darauf hinweist, dass sich ein/e Mitarbeiter/in für eine Veranstaltung angemeldet hat.';
$string['cancellationmessage'] = 'Stornierungsmitteilung';
$string['cancellationmessage_help'] = 'Diese Nachricht wird gesendet, wenn Teilnehmer/innen ihre Buchung für einen Termin stornieren.';
$string['cancellations'] = 'Stornierungen';
$string['cancellationsent'] = 'Sie sollten umgehend eine Kündigungs-E-Mail erhalten.';
$string['cancellationsentmgr'] = 'Sie und Ihr/e Vorgesetzte/r sollten umgehend eine Kündigungs-E-Mail erhalten.';
$string['cancellationstablesummary'] = 'Liste der Teilnehmer/innen, die ihre Registrierung storniert haben.';
$string['cancelreason'] = 'Grund';
$string['cannotapproveatcapacity'] = 'Sie können keine weiteren Teilnehmer/innen genehmigen, da diese Veranstaltung ausgebucht ist.';
$string['cannotsignupsessioninprogress'] = 'Sie können sich nicht anmelden, diese Veranstaltung ist im Gange.';
$string['cannotsignupsessionover'] = 'Sie können sich nicht anmelden, diese Veranstaltung ist beendet.';
$string['capacity'] = 'Kapazität';
$string['capacity_help'] = '**Kapazität** ist die Anzahl der in einer Veranstaltung verfügbaren Plätze.

Wenn eine Veranstaltung die Kapazität erreicht, werden die Sitzungsdetails nicht auf der Kursseite angezeigt. Die Details werden auf der Seite "Alle Veranstaltungen anzeigen" ausgegraut angezeigt und der Interessent kann sich nicht für die Veranstaltung anmelden.
&nbsp;';
$string['changemanageremailaddress'] = 'E-Mail Adresse des/der Vorgesetzten ändern';
$string['changemanageremailinstruction'] = 'Bitte geben Sie unten die E-Mail-Adresse Ihres/Ihrer aktuellen Vorgesetzten ein.';
$string['clearall'] = 'Alle löschen';
$string['closed'] = 'Geschlossen';
$string['conditions'] = 'Bedingungen';
$string['conditionsexplanation'] = 'Alle diese Kriterien müssen erfüllt sein, damit die Meldung im Schulungskalender erscheint:';
$string['confirm'] = 'Bestätigen';
$string['confirmanager'] = 'E-Mail-Adresse des/der Vorgesetzten bestätigen';
$string['confirmation'] = 'Bestätigung';
$string['confirmationinstrmngr'] = '# Benachrichtigung an Vorgesetzte/n';
$string['confirmationinstrmngr_help'] = 'Wenn "Benachrichtigung an Vorgesetzte/n senden" aktiviert ist, wird der Text im Feld "Benachrichtigung an Vorgesetzte/n" an einen Vorgesetzten gesendet, der darauf hinweist, dass sich ein Mitarbeiter für eine Veranstaltung angemeldet hat.';
$string['confirmationmessage'] = 'Bestätigungsmitteilung';
$string['confirmationmessage_help'] = 'Diese Nachricht wird immer dann gesendet, wenn sich ein/e Teilnehmer/in für eine Veranstaltung anmeldet.';
$string['confirmationsent'] = 'Sie sollten sofort eine Bestätigungs-E-Mail erhalten.';
$string['confirmationsentmgr'] = 'Sie und Ihr/e Vorgesetzte/r sollten sofort eine Bestätigungs-E-Mail erhalten.';
$string['confirmmanageremailaddress'] = 'Bestätigen Sie die E-Mail-Adresse des/der Vorgesetzten';
$string['confirmmanageremailaddressquestion'] = 'Ist <b>{$a}</b> immer noch die E-Mail-Adresse Ihres/Ihrer Vorgesetzten?';
$string['confirmmanageremailinstruction1'] = 'Sie haben zuvor die folgende E-Mail-Adresse Ihres Vorgesetzten eingegeben:';
$string['confirmmanageremailinstruction2'] = 'Ist das immer noch die E-Mail-Adresse Ihres/Ihrer Vorgesetzten?';
$string['continuetologin'] = 'Zum Einloggen bitte weiter klicken';
$string['copy'] = 'Kopieren';
$string['copyingsession'] = 'Wird als neuer Termin in {$a} kopiert';
$string['copysession'] = 'Veranstaltung kopieren';
$string['cost'] = 'Kosten';
$string['costheading'] = 'Kosten der Veranstaltung';
$string['crontask'] = 'Wartungsarbeiten von Veranstaltungen';
$string['currentstatus'] = 'Aktueller Status';
$string['customfieldsheading'] = 'Benutzerdefinierte Veranstaltungsfelder';
$string['date'] = 'Datum';
$string['dateadd'] = 'Datum hinzufügen';
$string['dateremove'] = 'Dieses Datum entfernen';
$string['datesignedup'] = 'Datum der Anmeldung';
$string['datetext'] = 'Sie sind angemeldet für das Datum';
$string['decidelater'] = 'Später entscheiden';
$string['decline'] = 'Ablehnen';
$string['delete'] = 'Löschen';
$string['deleteall'] = 'Alle löschen';
$string['deletesession'] = 'Termin löschen';
$string['deletesessionconfirm'] = 'Sind Sie völlig sicher, dass Sie diesen Termin und alle Anmeldungen für diesen Termin löschen möchten?';
$string['deletingsession'] = 'Termin in {$a} wird gelöscht';
$string['description'] = 'Beschreibung';
$string['description_help'] = '**Beschreibung** ist die Kursbeschreibung, die angezeigt wird, wenn sich ein Interessent für eine Veranstaltung anmeldet.

Die **Beschreibung** wird auch im Veranstaltungskalender angezeigt.';
$string['details'] = 'Details';
$string['details_help'] = 'Details werden pro Termin verfolgt.
Wenn der Text im Detailfeld ausgefüllt ist, wird der Detailtext auf der Anmeldeseite des Benutzers angezeigt.
Standardmäßig erscheint der Detailtext auch in den Bestätigungs-, Erinnerungs-, Wartelisten- und Stornierungs-E-Mails.';
$string['discountcode'] = 'Rabattcode';
$string['discountcode_help'] = 'Der Rabattcode ist der Code, der zur Ermittlung der Rabattkosten für die Schulung eines Mitarbeiters erforderlich ist.
Wenn der Mitarbeiter den Rabattcode nicht eingibt, erscheinen die normalen Kosten im Schulungsbeleg.';
$string['discountcodelearner'] = 'Rabattcode';
$string['discountcodelearner_help'] = 'Wenn Sie den Rabattcode kennen, geben Sie ihn hier ein. Wenn Sie dieses Feld leer lassen, werden Ihnen die normalen Kosten für diese Veranstaltung in Rechnung gestellt.';
$string['discountcost'] = 'Rabattkosten';
$string['discountcost_help'] = 'Rabattkosten sind die Beträge, die den Mitarbeiter/innen, die eine Mitgliedsnummer haben, in Rechnung gestellt werden.
Wenn ein Mitarbeiter bei der Anmeldung zu einer Veranstaltung eine Mitgliedsnummer eingibt, erscheint der Rabatt in der Kostenspalte im Leistungsheft des Kurses.';
$string['due'] = 'fällig';
$string['duration'] = 'Dauer';
$string['duration_help'] = '**Dauer** ist die Gesamtlänge des Seminars in Stunden.
Zum Beispiel
* "2 Stunden" wird als **2** oder **2:00** eingegeben.
* "1 Stunde und 30 Minuten" wird als **1:30** eingegeben.
* "45 Minuten" wird als **0:45** eingegeben.
* "20 Minuten" wird als **0:20** eingegeben.

Wenn das Seminar zwei oder mehr Termine umfasst, ist die Dauer die Gesamtsumme.';
$string['early'] = '{$a} früh';
$string['edit'] = 'Bearbeiten';
$string['editingsession'] = 'Veranstaltung in {$a} wird bearbeitet';
$string['editsession'] = 'Veranstaltung bearbeiten';
$string['email:instrmngr'] = 'Hinweis für Vorgesetzte';
$string['email:message'] = 'Mitteilung';
$string['email:subject'] = 'Betreff';
$string['emailmanager'] = 'Hinweis an Vorgesetzte senden';
$string['emailmanagercancellation'] = '# Hinweis an Vorgesetzte senden';
$string['emailmanagercancellation_help'] = 'Wenn "Hinweis an Vorgesetzte senden" aktiviert ist, wird eine E-Mail an Vorgesetzte des/der Lernenden gesendet, in der diese/r darauf hingewiesen wird, dass die Buchung der Veranstaltung storniert wurde.';
$string['emailmanagerconfirmation'] = '# Hinweis an Vorgesetzte senden';
$string['emailmanagerconfirmation_help'] = 'Wenn "Hinweis an Vorgesetzte senden" aktiviert ist, wird eine Bestätigungs-E-Mail an Vorgesetzte des/der Lernenden gesendet, sobald er/sie sich für eine Veranstaltung anmeldet.';
$string['emailmanagerreminder'] = '# Hinweis an Vorgesetzte senden';
$string['emailmanagerreminder_help'] = 'Wenn "Hinweis an Vorgesetzte senden" aktiviert ist, wird einige Tage vor dem Beginn einer Veranstaltung eine Erinnerungs-E-Mail an Vorgesetzte des/der Lernenden gesendet.';
$string['emptylocation'] = 'Veranstaltungsort war leer';
$string['enrolled'] = 'eingeschrieben';
$string['error:addalreadysignedupattendee'] = '{$a} ist bereits für diese Veranstaltung angemeldet.';
$string['error:addattendee'] = '{$a} konnte dem Termin nicht hinzugefügt werden.';
$string['error:cancelbooking'] = 'Es gab ein Problem bei der Stornierung Ihrer Anmeldung.';
$string['error:cancellationsnotallowed'] = 'Sie sind nicht berechtigt, diese Anmeldung zu stornieren.';
$string['error:cannotemailmanager'] = 'Erinnerungs-E-Mail für Anmeldungs-ID {$a->submissionid} wurde an Teilnehmer {$a->userid} gesendet; die Benachrichtigung an die E-Mail-Adresse des/der Vorgesetzte/n ({$a->manageremail}) konnte jedoch nicht gesendet werden.';
$string['error:cannotemailuser'] = 'Die E-Mail für die Anmeldungs-ID {$a->submissionid} konnte nicht an den/die Teilnehmer/in {$a->userid} ({$a->useremail}) gesendet werden.';
$string['error:cannotsendconfirmationmanager'] = 'Eine Bestätigungsnachricht wurde an Ihr E-Mail-Konto gesendet, aber es gab ein Problem beim Senden der Bestätigungsnachricht an die E-Mail-Adresse Ihres/r Vorgesetzten.';
$string['error:cannotsendconfirmationthirdparty'] = 'Eine Bestätigungsnachricht wurde an Ihr E-Mail-Konto und das E-Mail-Konto Ihres Managers gesendet, aber es gab ein Problem beim Senden der Bestätigungsnachricht an die E-Mail-Adresse des Dritten.';
$string['error:cannotsendconfirmationuser'] = 'Beim Versand der Bestätigungsnachricht an das E-Mail-Konto Ihres/er Vorgesetzten gab es ein Problem.';
$string['error:cannotsendconfirmationusermanager'] = 'Eine Bestätigungsnachricht konnte nicht an Ihre E-Mail-Adresse und an die E-Mail-Adresse Ihres/r Vorgesetzten gesendet werden.';
$string['error:cannotsendrequestmanager'] = 'Beim Versand der Anmeldeanfrage an das E-Mail-Konto Ihres/er Vorgesetzten gab es ein Problem.';
$string['error:cannotsendrequestuser'] = 'Beim Versand der Anmeldeanfrage an Ihr E-Mail-Konto gab es ein Problem.';
$string['error:canttakeattendanceforunstartedsession'] = 'Sie können nicht an einer Veranstaltung teilnehmen, die noch nicht begonnen hat.';
$string['error:couldnotaddfield'] = 'Benutzerdefiniertes Veranstaltungsfeld konnte nicht hinzugefügt werden.';
$string['error:couldnotaddnotice'] = 'Konnte keine Standortnotiz hinzufügen.';
$string['error:couldnotaddsession'] = 'Veranstaltung konnte nicht hinzugefügt werden';
$string['error:couldnotaddtrainer'] = 'Der neue Veranstaltungstrainer konnte nicht gespeichert werden.';
$string['error:couldnotcopysession'] = 'Veranstaltung konnte nicht hinzugefügt werden';
$string['error:couldnotdeletefield'] = 'Nutzerdefiniertes Veranstaltungsfeld konnte nicht gelöscht werden';
$string['error:couldnotdeletenotice'] = 'Die Standortnotiz konnte nicht gelöscht werden';
$string['error:couldnotdeletesession'] = 'Die Veranstaltung konnte nicht gelöscht werden';
$string['error:couldnotdeletetrainer'] = 'Ein Veranstaltungstrainer konnte nicht gelöscht werden.';
$string['error:couldnotfindsession'] = 'Der neu eingefügte Termin konnte nicht gefunden werden.';
$string['error:couldnotsavecustomfield'] = 'Benutzerdefiniertes Feld konnte nicht gespeichert werden';
$string['error:couldnotupdatecalendar'] = 'Der Termin konnte im Kalender nicht aktualisiert werden.';
$string['error:couldnotupdatef2frecord'] = 'Der Veranstaltungs-Anmeldedatensatz in der Datenbank konnte nicht aktualisiert werden.';
$string['error:couldnotupdatefield'] = 'Benutzerdefiniertes Veranstaltungsfeld konnte nicht aktualisiert werden.';
$string['error:couldnotupdatemanageremail'] = 'E-Mail-Adresse des/der Vorgesetzten konnte nicht aktualisiert werden.';
$string['error:couldnotupdatenotice'] = 'Standortnotiz konnte nicht aktualisiert werden.';
$string['error:couldnotupdatesession'] = 'Termin konnte nicht aktualisiert werden';
$string['error:coursemisconfigured'] = 'Kurs ist falsch konfiguriert';
$string['error:cronprefix'] = 'Fehler: Face-to-Face cron:';
$string['error:emptylocation'] = 'Veranstaltungsort war leer.';
$string['error:emptymanageremail'] = 'Fehlende E-Mail-Adresse des Vorgesetzten';
$string['error:emptyvenue'] = 'Veranstaltungsgebäude war leer.';
$string['error:enrolmentfailed'] = '{$a} konnte nicht in den Kurs eingeschrieben werden.';
$string['error:eventoccurred'] = 'Ein bereits stattgefundener Termin kann nicht storniert werden.';
$string['error:f2ffailedupdatestatus'] = 'Der Status des/der Teilnehmer/in konnte nicht aktualisieren.';
$string['error:fieldidincorrect'] = 'Feld ID ist falsch: {$a}';
$string['error:incorrectcoursemodule'] = 'Kursmodul ist falsch';
$string['error:incorrectcoursemoduleid'] = 'Kursmodul-ID war falsch';
$string['error:incorrectcoursemodulesession'] = 'Veranstaltung des Kursmoduls war falsch.';
$string['error:incorrectfacetofaceid'] = 'Veranstaltungs-ID war falsch';
$string['error:incorrectnotificationtype'] = 'Falsche Benachrichtigungsart übergeben';
$string['error:invaliduserid'] = 'Ungültige Benutzer-ID';
$string['error:manageremailaddressmissing'] = 'Sie sind derzeit keinem Vorgesetzten im System zugeordnet. Bitte wenden Sie sich an den Standort-Administrator.';
$string['error:mustspecifycoursemodulefacetoface'] = 'Ein Kursmodul oder eine Veranstaltungs-ID muss angegeben werden.';
$string['error:nomanageremail'] = 'Sie haben keine E-Mail-Adresse für Ihre/n Vorgesetzte/n eingegeben.';
$string['error:nomanagersemailset'] = 'Es wurde keine E-Mail des/der Vorgesetzten angegeben.';
$string['error:nopermissiontosignup'] = 'Sie haben nicht die Erlaubnis, sich für diese Veranstaltung anzumelden.';
$string['error:noticeidincorrect'] = 'Hinweis ID ist falsch: {$a}';
$string['error:problemsigningup'] = 'Bei der Anmeldung gab es ein Problem.';
$string['error:removeattendee'] = 'Konnte {$a} nicht aus der Veranstaltung entfernen.';
$string['error:sessionstartafterend'] = 'Datum/Uhrzeit des Veranstaltungsbeginns liegt nach dem Ende.';
$string['error:shortnametaken'] = 'Das benutzerdefinierte Feld mit diesem Kurznamen existiert bereits.';
$string['error:signedupinothersession'] = 'Sie sind bereits in einer anderen Veranstaltung für diese Aktivität angemeldet. Sie können sich jeweils nur für eine Veranstaltung anmelden.';
$string['error:unknownbuttonclicked'] = 'Mit der angeklickten Schaltfläche ist keine Aktion verbunden';
$string['eventaddsession'] = 'Veranstaltung hinzugefügt';
$string['eventaddsessionfailed'] = 'Veranstaltung hinzufügen (FEHLGESCHLAGEN)';
$string['eventapproverequests'] = 'Anträge auf Genehmigung einer Veranstaltung';
$string['eventattendancetaken'] = 'Teilnahme an der Veranstaltung';
$string['eventattendeesviewed'] = 'Teilnehmer an der Veranstaltung sahen';
$string['eventcancelbooking'] = 'Termin kündigen';
$string['eventcancelbookingfailed'] = 'Termin kündigen (GESCHEITERT)';
$string['eventcoursef2fviewed'] = 'Angesehene Veranstaltungen (Face-to-Face)';
$string['eventcoursemoduleviewed'] = 'Angesehene Instanz des Face-to-Face-Moduls';
$string['eventdeletesession'] = 'Termin gelöscht';
$string['eventdeletesessionfailed'] = 'Termin löschen (GESCHEITERT)';
$string['eventsignup'] = 'Anmelden zu einem Termin';
$string['eventsignupfailed'] = 'Anmeldung zu einem Termin (GESCHEITERT)';
$string['eventtakeattendancefailed'] = 'Teilnahme an dem Termin (GESCHEITERT)';
$string['eventupdatemanageremailfailed'] = 'E-Mail Ihrer Führungskraft aktualisieren (GESCHEITERT)';
$string['eventupdatesession'] = 'Termin aktualisiert';
$string['eventupdatesessionfailed'] = 'Terminaktualisierung (FEHLGESCHLAGEN)';
$string['excelformat'] = 'Excel';
$string['export'] = 'Export';
$string['exportattendance'] = 'Teilnehmendenstatus exportieren';
$string['exporttofile'] = 'Export als Datei';
$string['facetoface'] = 'Präsenz';
$string['facetoface:addattendees'] = 'Teilnehmende zu einem Präsenztermin hinzufügen';
$string['facetoface:addinstance'] = 'Instanz hinzufügen';
$string['facetoface:configurecancellation'] = 'Ermöglichen Sie die Konfiguration von Anmeldungsstornierungen, wenn Sie eine Veranstaltung hinzufügen/bearbeiten.';
$string['facetoface:editsessions'] = 'Hinzufügen, Bearbeiten, Kopieren und Löschen von Veranstaltungen';
$string['facetoface:overbook'] = 'Melden Sie sich für ganze Veranstaltungen an.';
$string['facetoface:removeattendees'] = 'Teilnehmende aus einer persönlichen Veranstaltung entfernen';
$string['facetoface:signup'] = 'Einen Termin buchen';
$string['facetoface:takeattendance'] = 'Teilnehmen';
$string['facetoface:view'] = 'Veranstaltungen und Termine ansehen';
$string['facetoface:viewattendees'] = 'Anwesenheitsliste und Teilnehmende anzeigen';
$string['facetoface:viewcancellations'] = 'Stornierungen anzeigen';
$string['facetoface:viewemptyactivities'] = 'Leere Veranstaltungen anzeigen';
$string['facetofacebooking'] = 'Veranstaltungsbuchung';
$string['facetofacename'] = 'Name der Präsenzveranstaltung';
$string['facetofacesession'] = 'Präsenztermin';
$string['feedback'] = 'Feedback';
$string['feedbackupdated'] = 'Feedback aktualisiert für \\{$a} Personen';
$string['field:multiselect'] = 'Mehrfachauswahl';
$string['field:select'] = 'Auswahlmenü';
$string['field:text'] = 'Text';
$string['fielddeleteconfirm'] = 'Feld \'{$a}\' und alle damit verbundenen Daten der Veranstaltung löschen?';
$string['floor'] = 'Flur';
$string['format'] = 'Formatierung';
$string['full'] = 'Termin ist ausebucht';
$string['goback'] = 'Zurück';
$string['guestsno'] = 'Es tut uns leid, aber Gästen ist es nicht möglich, sich in Veranstaltungstermine einzuschreiben.';
$string['icalendarheading'] = 'iCalender-Anhänge';
$string['import'] = 'Import';
$string['info'] = 'Information';
$string['late'] = '\\{$a} verspätet';
$string['location'] = 'Veranstaltungsort';
$string['location_help'] = '**Veranstaltungsort** beschreibt die Umgebung der Veranstaltung (Stadt, Landkreis, Region, etc.).

**Veranstaltungsort** wird auf der Seite der Veranstaltung, auf der Seite "Anmeldung", auf der Seite "Alle Veranstaltungen anzeigen" und in allen E-Mail-Benachrichtigungen angezeigt.

Auf der Seite "Alle Veranstaltungen anzeigen" können die aufgelisteten Veranstaltungen nach Ort gefiltert werden.';
$string['lookfor'] = 'Suchen';
$string['manageradded'] = 'Die E-Mail-Adresse Ihrer Führungskraft wurde akzeptiert.';
$string['managerchanged'] = 'Die E-Mail-Adresse Ihrer Führungskraft wurde geändert.';
$string['manageremail'] = 'E-Mail-Adresse Ihrer Führungskraft';
$string['manageremailaddress'] = 'E-Mail-Adresse Ihrer Führungskraft';
$string['manageremailformat'] = 'Die E-Mail-Adresse muss das Format \'{$a}\' haben, um akzeptiert zu werden.';
$string['manageremailheading'] = 'Führungskräfte-E-Mails';
$string['manageremailinstruction'] = 'Um sich für eine Veranstaltung anzumelden, müssen Sie eine Bestätigungs-E-Mail an Ihre E-Mail-Adresse senden und eine Kopie an die E-Mail-Adresse Ihrer Führungskraft schicken.';
$string['manageremailinstructionconfirm'] = 'Bitte bestätigen Sie, dass dies die E-Mail-Adresse Ihrer Führungskraft ist:';
$string['managername'] = 'Name der Führungskraft';
$string['managerupdated'] = 'Die E-Mail-Adresse Ihrer Führungskraft wurde aktualisiert.';
$string['maximumpoints'] = 'Maximale Anzahl von Punkten';
$string['maximumsize'] = 'Maximale Anzahl von Teilnehmenden';
$string['message'] = 'Umbuchung in der Veranstaltung {$a->coursename}!

Es ist ein Platz im Termin am {$a->duedate} in der Veranstaltung {$a->coursename} frei geworden.
Sie wurden angemeldet. Wenn Ihnen der Termin nicht mehr passt, melden Sie sich bitte bei  <a href=\'{$a->url}\'>{$a->url}</a> ab.';
$string['mods_help'] = 'Face-to-Face-Aktivitäten werden verwendet, um den Überblick über Schulungen zu behalten, die im Voraus gebucht werden müssen.

Jede Aktivität wird in einer oder mehreren identischen Terminen angeboten. Diese Termine können sich über mehrere Tage erstrecken.

Ein paar Tage vor dem Termin der Veranstaltung werden Erinnerungsnachrichten an die Benutzer und ihre Führungskräfte gesendet. Bestätigungsnachrichten werden verschickt, wenn sich Teilnehmende für eine Veranstaltung anmelden oder absagen.';
$string['modulename'] = 'Veranstaltungen';
$string['modulename_help'] = 'Mit dem Modul "Face-to-Face-Aktivitäten" kann eine Lehrkraft ein freiwilliges Buchungssystem für eine oder mehrere Veranstaltungen im Klassenzimmer einrichten.

Für jede Veranstaltung innerhalb einer Face-to-Face-Aktivität können individuelle Einstellungen zu Ort, Veranstaltungsort, Startzeit, Endzeit, Kosten, Kapazität usw. vorgenommen werden. Sie können so eingestellt werden, dass sie sich über mehrere Tage erstrecken oder außerplanmäßige Termine und solche mit Warteliste ermöglichen.

Eine Aktivität kann so eingestellt werden, dass eine Genehmigung der Führungskraft erforderlich ist, und Lehrkräfte können automatische Benachrichtigungen und Erinnerungen an Veranstaltungen für Teilnehmende konfigurieren.

Studierende können Veranstaltungen anzeigen und sich für diese anmelden, wobei ihre Anwesenheit im Bereich "Noten" verfolgt und aufgezeichnet wird.';
$string['modulenameplural'] = 'Face-to-Face';
$string['moreinfo'] = 'Weitere Infos';
$string['multidate'] = '(mehrere Termine)';
$string['newmanageremailaddress'] = 'E-Mail Adresse Ihrer Führungskraft';
$string['noactionableunapprovedrequests'] = 'Keine verwertbaren nicht genehmigten Anträge';
$string['nocustomfields'] = '<p>Es sind keine benutzerdefinierten Felder definiert.</p>';
$string['nofacetofaces'] = 'Es gibt keine Face-to-Face-Aktivitäten';
$string['none'] = 'kein';
$string['noremindersneedtobesent'] = 'Es müssen keine Erinnerungen verschickt werden.';
$string['normalcost'] = 'Normalkosten';
$string['nosignedupusers'] = 'Es haben sich keine Interessenten für diesen Termin gefunden.';
$string['nositenotices'] = '<p>Es sind keine Standortmitteilungen definiert.</p>';
$string['note'] = 'Hinweis';
$string['notefull'] = 'Auch wenn der Termin ausgebucht ist, können Sie sich noch anmelden. Sie werden in eine Warteschlange aufgenommen (rot markiert). Wenn sich jemand abmeldet, wird die/der erste Teilnehmende in der Warteschlange in die Liste der angemeldeten Teilnehmenden aufgenommen und erhält eine Benachrichtigung per E-Mail.';
$string['noticetext'] = 'Hinweistext';
$string['notificationboth'] = 'E-Mail-Benachrichtigung und iCalendar-Termin';
$string['notificationemail'] = 'Nur E-Mail-Benachrichtigung';
$string['notificationical'] = 'Nur iCalendar-Termin';
$string['notificationtype'] = 'Benachrichtigungsart';
$string['notificationtype_help'] = 'Mit der Benachrichtigungsart kann der Teilnehmer auswählen, wie er über seine Buchung benachrichtigt werden möchte.

* Nur iCalendar-Termin
* Nur E-Mail-Benachrichtigung
* E-Mail-Benachrichtigung und iCalendar-Termin';
$string['notsignedup'] = 'Sie sind nicht für diese Veranstaltung angemeldet.';
$string['notsubmittedyet'] = 'Noch nicht bewertet';
$string['noupcoming'] = '<p><i>Keine bevorstehenden Veranstaltungen</i></p>';
$string['odsformat'] = 'OpenDocument';
$string['onehour'] = '1 Stunde';
$string['oneminute'] = '1 Minute';
$string['options'] = 'Optionen';
$string['or'] = 'oder';
$string['order'] = 'Bestellung';
$string['place'] = 'Raum';
$string['placeholder:alldates'] = '[alldates]';
$string['placeholder:attendeeslink'] = '[attendeeslink]';
$string['placeholder:cost'] = '[cost]';
$string['placeholder:details'] = '[details]';
$string['placeholder:duration'] = '[duration]';
$string['placeholder:facetofacename'] = '[facetofacename]';
$string['placeholder:finishtime'] = '[finishtime]';
$string['placeholder:firstname'] = '[firstname]';
$string['placeholder:lastname'] = '[lastname]';
$string['placeholder:reminderperiod'] = '[reminderperiod]';
$string['placeholder:sessiondate'] = '[sessiondate]';
$string['placeholder:starttime'] = '[starttime]';
$string['pluginadministration'] = 'Verwaltung von Veranstaltungen';
$string['pluginname'] = 'Veranstaltungen';
$string['points'] = 'Punkte';
$string['pointsplural'] = 'Punkte';
$string['potentialattendees'] = 'Potentielle Teilnehmer/innen';
$string['previoussessions'] = 'Frühere Termine';
$string['printversionid'] = 'Druckversion: ohne Namen';
$string['printversionname'] = 'Druckversion: mit Namen';
$string['privacy:metadata:facetoface_session_roles'] = 'Listet Benutzer mit einer Trainerrolle in einer Veranstaltung auf';
$string['privacy:metadata:facetoface_signups'] = 'Benutzeranmeldungen für Veranstaltungen';
$string['privacy:metadata:facetoface_signups:discountcode'] = 'Der vom Benutzer eingegebene Rabattcode';
$string['privacy:metadata:facetoface_signups:id'] = 'Die ID der Anmeldung';
$string['privacy:metadata:facetoface_signups:mailedreminder'] = 'Zeitpunkt des letzten Versands einer Erinnerung';
$string['privacy:metadata:facetoface_signups:notificationtype'] = 'Wie der Benutzer benachrichtigt werden möchte.';
$string['privacy:metadata:facetoface_signups:sessionid'] = 'Die ID der Veranstaltung';
$string['privacy:metadata:facetoface_signups_status'] = 'Der Status der Anmeldung eines Benutzers zu einer Veranstaltung';
$string['privacy:metadata:facetoface_signups_status:grade'] = 'Die für die Teilnahme an der Veranstaltung vergebene Note';
$string['privacy:metadata:facetoface_signups_status:note'] = 'Speichert den Grund für eine abgesagte Veranstaltung';
$string['privacy:metadata:facetoface_signups_status:signupid'] = 'Die ID der Anmeldung';
$string['privacy:metadata:facetoface_signups_status:statuscode'] = 'Der Status der Anmeldung, z. B. storniert, abgelehnt, vollständig besucht';
$string['privacy:metadata:facetoface_signups_status:timecreated'] = 'Der Zeitpunkt, zu dem die Anmeldung erstellt wurde.';
$string['privacy:metadata:roleid'] = 'Die Rollen-ID des Benutzers.';
$string['privacy:metadata:userid'] = 'Die ID des Benutzers, der auf die Veranstaltung zugegriffen hat';
$string['really'] = 'Wollen Sie wirklich alle Ergebnisse für diese Veranstaltung löschen?';
$string['registeredon'] = 'Angemeldet am';
$string['registrations'] = 'Anmeldungen';
$string['reminder'] = 'Erinnerung';
$string['reminderinstrmngr'] = '# Benachrichtigung an Vorgesetzte/n';
$string['reminderinstrmngr_help'] = 'Wenn **Benachrichtigung an Vorgesetzte/n** senden markiert ist, wird der Text im Feld **Benachrichtigung an Vorgesetzte/n** an den/die Vorgesetzte/n eines/einer Teilnehmenden gesendet, der/die sich für eine Veranstaltung angemeldet hat.';
$string['remindermessage'] = 'Erinnerungsnachricht';
$string['remindermessage_help'] = 'Diese Nachricht wird einige Tage vor Beginn einer Veranstaltung verschickt.';
$string['reminderperiod'] = 'Tage vor dem Versand der Nachricht';
$string['reminderperiod_help'] = 'Die Erinnerungsnachricht wird so viele Tage vor Beginn der Veranstaltung versendet.';
$string['requestmessage'] = 'Genehmigungsanforderung';
$string['requestmessage_help'] = 'Wenn **Genehmigung erforderlich** aktiviert ist, ist der Abschnitt **Genehmigungsanforderung** verfügbar.

Der Abschnitt **Genehmigungsanforderung** zeigt die an den/die Teilnehmer/in und seinen/ihren Vorgesetzten gesendeten Mitteilungen über den Genehmigungsprozess für die Teilnahme an dem Veranstaltung an.

**Betreff:** ist die Betreffzeile, die in den Genehmigungsanforderungs-E-Mails an den/die Vorgesetzte/n und den/die Teilnehmer/in erscheint.

**Nachricht:** ist der E-Mail-Text, mit dem dem/der Teilnehmer/in mitgeteilt wird, dass seine/ihr Antrag auf Teilnahme an der Veranstaltung an seinen/ihren Vorgesetzten zur Genehmigung gesendet wurde.

**Hinweis für den/die Vorgesetzte/n:** ist der E-Mail-Text, der an den/die Vorgesetzte/n des/der Lernenden geschickt wird, um die Genehmigung zur Teilnahme an dem Veranstaltung zu erhalten.';
$string['room'] = 'Veranstaltungsraum';
$string['room_help'] = '**Veranstaltungsraum** ist der Name, die Nummer oder die Kennung des Raumes, der für die Veranstaltung verwendet wird.

Der **Veranstaltungsraum** wird auf der Seite \'Anmeldung\', der Seite \'Alle Sitzungen anzeigen\' und in allen E-Mail-Benachrichtigungen angezeigt.';
$string['saveallfeedback'] = 'Alle Antworten speichern';
$string['saveattendance'] = 'Anwesenheit speichern';
$string['scheduledsession'] = 'Geplanter Termin';
$string['scheduledsessions'] = 'Geplante Termine';
$string['search:activity'] = 'Veranstaltungen';
$string['seatsavailable'] = 'Verfügbare Plätze';
$string['seeattendees'] = 'Siehe Teilnehmer';
$string['sentremindermanager'] = 'Erinnerungs-E-Mail an den Vorgesetzten des/der Teilnehmers/in schicken';
$string['sentreminderuser'] = 'Erinnerungs-E-Mail an den/die Teilnehmer/in schicken';
$string['sessiondate'] = 'Veranstaltungsdatum ist das Datum, an dem die Veranstaltung stattfindet.';
$string['sessiondatetime'] = 'Datum/Uhrzeit der Veranstaltung';
$string['sessiondatetimeknown'] = 'Datum/Uhrzeit der Veranstaltung bekannt';
$string['sessiondatetimeknown_help'] = '**Bei bekanntem Datum/Uhrzeit einer Veranstaltung**

Wenn Sie diese Einstellung mit "Ja" wählen, werden Datum und Uhrzeit der Veranstaltung auf der Kursseite (wenn die Veranstaltung ansteht und verfügbar ist), auf der Seite "Alle Veranstaltungen anzeigen", auf der Anmeldeseite für die Veranstaltung sowie in allen E-Mail-Benachrichtigungen zu dieser Veranstaltung angezeigt.

Wenn sich ein Mitarbeiter für eine Veranstaltung mit einem bekannten Datum und einer bekannten Uhrzeit anmeldet:

* Der Mitarbeiter und sein Vorgesetzter erhalten eine Bestätigungs-E-Mail (d. h. diejenige, die gemäß dem Abschnitt "Bestätigungsnachricht" in den Einstellungen der Face-to-Face-Instanz formatiert ist).
* Der Mitarbeiter erhält eine Erinnerungs-E-Mail (d. h. die Nachricht, die im Abschnitt "Erinnerungsnachricht" in den Einstellungen der Face-to-Face-Instanz formatiert ist). Die Erinnerung wird einige Tage vor der Veranstaltung verschickt, entsprechend der Einstellung "Tage vor Versand der Nachricht", die ebenfalls im Abschnitt "Erinnerungsnachricht" in den Einstellungen der Face-to-Face-Instanz zu finden ist.

**Wenn das Datum/die Uhrzeit einer Veranstaltung nicht bekannt ist (oder auf der Warteliste steht)**

Wenn für diese Einstellung "Nein" eingegeben wird, wird der Text "Warteliste" auf der Kursseite, der Seite "Alle Veranstaltungen anzeigen", der Anmeldeseite für die Veranstaltung sowie in allen E-Mail-Benachrichtigungen im Zusammenhang mit der Veranstaltung angezeigt.

Wenn sich ein Mitarbeiter für eine Veranstaltung auf der Warteliste anmeldet:

* Der Mitarbeiter erhält eine Bestätigungs-E-Mail (d. h. diejenige, die gemäß dem Abschnitt "Nachricht auf der Warteliste" in den Einstellungen der Face-to-Face-Instanz formatiert ist).
* Der Mitarbeiter erhält keine Erinnerungs-E-Mail.
* Der Vorgesetzte des Mitarbeiters erhält keine Bestätigungs- oder Stornierungs-E-Mails.';
$string['sessionfinishtime'] = 'Uhrzeit des Veranstaltungsendes';
$string['sessioninprogress'] = 'laufende Veranstaltung';
$string['sessionisfull'] = 'Diese Veranstaltung ist nun voll. Sie müssen einen anderen Zeitpunkt wählen oder mit dem Dozenten sprechen.';
$string['sessionover'] = 'Veranstaltung beendet';
$string['sessionrequiresmanagerapproval'] = 'Diese Veranstaltung erfordert die Genehmigung des/der Vorgesetzten zur Buchung.';
$string['sessionroles'] = 'Rollen der Veranstaltung';
$string['sessions'] = 'Veranstaltungen';
$string['sessionsoncoursepage'] = 'Auf der Kursseite angezeigte Veranstaltungen';
$string['sessionsoncoursepage_help'] = 'Dies ist die Anzahl der Termine für jede Veranstaltung, die auf der Hauptseite des Kurses angezeigt wird.';
$string['sessionstartdate'] = 'Datum des Veranstaltungsbeginns';
$string['sessionstartdateandtimewithouttimezone'] = '{$a->startdate}, {$a->starttime} - {$a->endtime}';
$string['sessionstarttime'] = 'Uhrzeit des Veranstaltungsbeginns';
$string['sessionvenue'] = 'Veranstaltungsort';
$string['setting:addchangemanageremail'] = 'Die Teilnehmer/innen nach der E-Mail-Adresse ihres/er Vorgesetzten fragen.';
$string['setting:addchangemanageremail_caption'] = 'E-Mail des/der Vorgesetzten:';
$string['setting:addchangemanageremaildefault'] = 'Die Teilnehmer/innen nach der E-Mail-Adresse ihres/er Vorgesetzten fragen.';
$string['setting:attendeesexportfields'] = 'Wählen Sie die Felder aus, die in die exportierte Teilnehmerliste einer Veranstaltung aufgenommen werden sollen. Dies geschieht zusätzlich zum Vor- und Nachnamen des/der Teilnehmenden.';
$string['setting:attendeesexportfields_caption'] = 'Felder für den Export von Teilnehmenden';
$string['setting:defaultcancellationinstrmngr'] = 'Standardmäßige Stornierungsnachricht, die an Vorgesetzte gesendet wird.';
$string['setting:defaultcancellationinstrmngr_caption'] = 'Stornierungsnachricht (Vorgesetzte)';
$string['setting:defaultcancellationinstrmngrdefault'] = '*** Hinweis ****

Dies ist ein Hinweis darauf, dass [Vorname] [Nachname] nicht mehr für die folgende Veranstaltung angemeldet ist, da Sie als dessen/deren Vorgesetzte/r angegeben sind.

*** [Vorname] [Nachname]s Stornierung findet sich nachfolgend in Kopie ****';
$string['setting:defaultcancellationmessage'] = 'Standardmäßige Stornierungsnachricht, die an den/die Teilnehmer gesendet wird.';
$string['setting:defaultcancellationmessage_caption'] = 'Stornierungsnachricht';
$string['setting:defaultcancellationmessagedefault'] = 'Hiermit weisen wir Sie darauf hin, dass Ihre Buchung für die folgende Veranstaltung storniert wurde:

***DIE RESERVIERUNG WURDE STORNIERT***

Teilnehmer:   [firstname] [lastname]
Kurs:   [facetofacename]

Dauer:   [duration]
Termin(e):
[alldates]

Standort/Ort: [session:location]
Veranstaltungsort: [session:venue]
Raum: [session:room]';
$string['setting:defaultcancellationsubject'] = 'Standard-Betreffzeile für Stornierungs-E-Mails.';
$string['setting:defaultcancellationsubject_caption'] = 'Betreffzeile der Stornierung';
$string['setting:defaultcancellationsubjectdefault'] = 'Stornierung der Veranstaltung';
$string['setting:defaultconfirmationinstrmngr'] = 'Standardmäßige Bestätigungsnachricht, die an Vorgesetzte gesendet wird.';
$string['setting:defaultconfirmationinstrmngr_caption'] = 'Bestätigungsmeldung (Vorgesetzte)';
$string['setting:defaultconfirmationinstrmngrdefault'] = '*** Nur Beratung ****

Hiermit teilen wir Ihnen mit, dass [firstname] [lastname] für den folgenden Kurs gebucht wurde und Sie als Teamleiter/in bzw. Manager/in angegeben hat.

Sollten Sie nicht Vorgesetzte/r diser Person sein und glauben, dass Sie diese E-Mail irrtümlich erhalten haben, antworten Sie bitte auf diese E-Mail.  Wenn Sie Bedenken haben, dass Ihr Mitarbeiter an diesem Kurs teilnimmt, besprechen Sie dies bitte direkt mit ihm.

*** Die Buchungsbestätigung von [firstname] [lastname] ist unten kopiert ****';
$string['setting:defaultconfirmationmessage'] = 'Standardmäßige Bestätigungsnachricht, die an Teilnehmer gesendet wird.';
$string['setting:defaultconfirmationmessage_caption'] = 'Bestätigungsnachricht';
$string['setting:defaultconfirmationmessagedefault'] = 'Hiermit bestätigen wir, dass Sie für die folgende Veranstaltung angemeldet sind:

Teilnehmer/in:   [firstname] [lastname]
Veranstaltung: [facetofacename]
Kosten: [cost]

Dauer:    [duration]
Termin(e):
[alldates]

Ort:   [session:location]
Veranstaltungsort:   [session:venue]
Raum: [session:room]

***Bitte erscheinen Sie zehn Minuten vor Beginn des Kurses***

Um Ihre Buchung umzubuchen oder zu stornieren
Um Ihre Buchung zu verschieben, müssen Sie diese Buchung stornieren und dann eine neue Veranstaltung buchen.  Um Ihre Buchung zu stornieren, kehren Sie auf die Website zurück, dann auf die Seite für diese Veranstaltung, und wählen Sie auf dem Bildschirm mit den Buchungsinformationen "stornieren".

[details]

Sie erhalten eine Erinnerung [reminderperiod] Tage vor der Veranstaltung.';
$string['setting:defaultconfirmationsubject'] = 'Standard-Betreffzeile für Bestätigungs-E-Mails.';
$string['setting:defaultconfirmationsubject_caption'] = 'Betreffzeile der Bestätigung';
$string['setting:defaultconfirmationsubjectdefault'] = 'Buchungsbestätigung: [facetofacename], [starttime]-[finishtime], [sessiondate]';
$string['setting:defaultreminderinstrmngr'] = 'Standardmäßige Erinnerungsnachricht an Vorgesetzte.';
$string['setting:defaultreminderinstrmngr_caption'] = 'Erinnerungsnachricht (Vorgesetzte)';
$string['setting:defaultreminderinstrmngrdefault'] = '*** Nur zur Erinnerung ***

Ihr Mitarbeiter [firstname] [lastname] ist für die Teilnahme an der oben genannten Veranstaltung angemeldet und hat auch diese Erinnerungs-E-Mail erhalten.

Wenn Sie nicht deren Vorgesetzte/r sind und glauben, dass Sie diese E-Mail versehentlich erhalten haben, antworten Sie bitte auf diese E-Mail.

*** [firstname] [lastname]s Erinnerungs-E-Mail ist nachfolgend angefügt***';
$string['setting:defaultremindermessage'] = 'Standardmäßige Erinnerungsnachricht an Teilnehmer.';
$string['setting:defaultremindermessage_caption'] = 'Erinnerungsnachricht';
$string['setting:defaultremindermessagedefault'] = 'Hiermit möchten wir Sie daran erinnern, dass Sie für die folgende Veranstaltung angemeldet sind:

Teilnehmer:   [firstname] [lastname]
Veranstaltung: [facetofacename]
Kosten: [cost]

Dauer:   [duration]
Termin(e):
[alldates]

Ort:   [session:location]
Veranstaltungsort:   [session:venue]
Raum: [session:room]

***Bitte erscheinen Sie zehn Minuten vor Beginn der Veranstaltung***

Um Ihre Buchung umzubuchen oder zu stornieren
Um Ihre Buchung zu verschieben, müssen Sie diese Buchung stornieren und dann eine neue Veranstaltung buchen.  Um Ihre Buchung zu stornieren, kehren Sie auf die Website zurück, dann auf die Seite dieser Veranstaltung, und wählen Sie dann "stornieren" auf dem Bildschirm mit den Buchungsinformationen.

[details]';
$string['setting:defaultremindersubject'] = 'Standard-Betreffzeile für Erinnerungs-E-Mails.';
$string['setting:defaultremindersubject_caption'] = 'Betreffzeile der Erinnerung';
$string['setting:defaultremindersubjectdefault'] = 'Buchungserinnerung: [facetofacename], [starttime]-[finishtime], [sessiondate]';
$string['setting:defaultrequestinstrmngrdefault'] = 'Hiermit teilen wir Ihnen mit, dass [Vorname] [Nachname] sich für die folgende Veranstaltung angemeldet hat und Sie als Vorgesetzte/r aufgeführt sind.

Veranstaltung: [facetofacename]
Kosten: [cost]

Dauer:   [duration]
Datum(en):
[alldates]

Ort:   [session:location]
Veranstaltungsort:   [session:venue]
Raum: [session:room]

Bitte folgen Sie dem unten stehenden Link, um die Anfrage zu genehmigen:
[attendeeslink]#unapproved


*** [Vorname] [Nachname]s Buchungsanfrage finden Sie nachfolgend ***';
$string['setting:defaultrequestmessagedefault'] = 'Ihre Anfrage, sich für die folgende Veranstaltung anzumelden, wurde an Ihren Vorgesetzten weitergeleitet:

Teilnehmer:   [firstname] [lastname]
Kurs: [facetofacename]
Kosten: [cost]

Dauer:   [duration]
Termin(e):
[alldates]

Ort:   [session:location]
Veranstaltungsort:   [session:venue]
Raum: [session:room]';
$string['setting:defaultrequestsubjectdefault'] = 'Buchungsanfrage: [facetofacename], [starttime]-[finishtime], [sessiondate]';
$string['setting:defaultvalue'] = 'Standardwert';
$string['setting:defaultwaitlistedmessage'] = 'Standardmäßige Wartelistennachricht, die an Teilnehmer gesendet wird.';
$string['setting:defaultwaitlistedmessage_caption'] = 'Wartelistennachricht';
$string['setting:defaultwaitlistedmessagedefault'] = 'Hiermit teilen wir Ihnen mit, dass Sie auf die Warteliste für folgende Veranstaltung gesetzt worden sind:

Kurs: [facetofacename]
Ort:  [session:location]
Teilnehmer:   [firstname] [lastname]

***Bitte beachten Sie, dass dies keine Kursbuchungsbestätigung ist***

Durch die Eintragung in die Warteliste haben Sie Ihr Interesse an dieser Veranstaltung bekundet und werden direkt kontaktiert, sobald sie verfügbar ist.

Um sich von dieser Warteliste zu streichen, kehren Sie bitte zu dieser Veranstaltung zurück und klicken Sie auf Buchung stornieren. Bitte beachten Sie, dass es keine E-Mail zur Bestätigung der Streichung von der Warteliste gibt.';
$string['setting:defaultwaitlistedsubject'] = 'Standard-Betreffzeile für Wartelisten-E-Mails.';
$string['setting:defaultwaitlistedsubject_caption'] = 'Betreffzeile der Warteliste';
$string['setting:defaultwaitlistedsubjectdefault'] = 'Wartelistenhinweis für [facetofacename]';
$string['setting:disableicalcancel'] = 'Stornierungs-E-Mails mittels eines iCalendar-Anhang deaktivieren.';
$string['setting:disableicalcancel_caption'] = 'iCalendar-Stornierungen deaktivieren:';
$string['setting:fromaddress'] = 'Was erscheint im Absenderfeld der von diesem Modul gesendeten E-Mail-Erinnerungen.';
$string['setting:fromaddress_caption'] = 'Absenderadresse:';
$string['setting:fromaddressdefault'] = 'moodle@example.com';
$string['setting:hidecost'] = 'Blenden Sie die Felder Kosten und Rabatt aus.';
$string['setting:hidecost_caption'] = 'Kosten und Rabatt ausblenden:';
$string['setting:hidediscount'] = 'Nur das Feld Rabatt ausblenden.';
$string['setting:hidediscount_caption'] = 'Rabatt ausblenden';
$string['setting:isfilter'] = 'Als Filter anzeigen';
$string['setting:manageraddressformat'] = 'Suffix, das in der E-Mail-Adresse des/der Vorgesetzten vorhanden sein muss, um als gültig zu gelten.';
$string['setting:manageraddressformat_caption'] = 'Erforderliches Suffix:';
$string['setting:manageraddressformatdefault'] = '';
$string['setting:manageraddressformatreadable'] = 'Kurze Beschreibung der Einschränkungen für die E-Mail-Adresse eines/einer Vorgesetzten.  Diese Einstellung hat keine Wirkung, wenn die vorherige nicht gesetzt ist.';
$string['setting:manageraddressformatreadable_caption'] = 'Formatierungsbeispiel:';
$string['setting:manageraddressformatreadabledefault'] = 'vorname.nachname@firma.de';
$string['setting:oneemailperday'] = 'Senden Sie mehrere Bestätigungs-E-Mails für mehrtägige Termine.';
$string['setting:oneemailperday_caption'] = 'Eine Nachricht pro Tag:';
$string['setting:possiblevalues'] = 'Liste der möglichen Werte';
$string['setting:sessionroles'] = 'Teilnehmer/innen, die den ausgewählten Rollen in einem Kurs zugeordnet sind, können bei jedem Präsenztermin nachverfolgt werden.';
$string['setting:sessionroles_caption'] = 'Veranstaltungsrollen:';
$string['setting:showinsummary'] = 'In Exporten und Listen anzeigen';
$string['setting:type'] = 'Feldtyp';
$string['shortname'] = '# Kurzname';
$string['shortname_help'] = '**Kurzname** ist die Beschreibung der Veranstaltung, die im Kalender erscheint, wenn **Zeige im Kalender** ausgewählt ist.';
$string['showbylocation'] = 'Nach Standort anzeigen';
$string['showoncalendar'] = 'Einstellungen der Kalenderanzeige';
$string['showoncalendar_help'] = 'Wenn **Website** ausgewählt ist, werden die Veranstaltungen im Kalender als allgemeines Ereignis angezeigt. Alle Besucher/innen der Website können diese Termine sehen.

Wenn **Kurs** ausgewählt ist, werden alle Veranstaltungen im Kurskalender und als Kursveranstaltung im Kalender auf Seitenebene angezeigt und sind für alle angemeldeten Benutzer/innen sichtbar.

Wenn **keine** ausgewählt ist, werden Veranstaltungen nur als Benutzerereignisse im Kalender eines bestätigten Teilnehmers angezeigt, sofern die Option **Im Kalender des/der Benutzers/Benutzerin anzeigen** ausgewählt wurde.';
$string['sign-ups'] = 'Anmeldungen';
$string['signup'] = 'Anmeldung';
$string['signupfor'] = 'Anmelden für {$a}';
$string['signupforsession'] = 'Melden Sie sich für eine verfügbare bevorstehende Veranstaltung an.';
$string['signupforthissession'] = 'Für diese Veranstaltung anmelden';
$string['signups'] = 'Anmeldungen';
$string['sitenoticesheading'] = 'Hinweise zum Veranstaltungsort';
$string['status'] = 'Stand';
$string['status_approved'] = 'Genehmigt';
$string['status_booked'] = 'Gebucht';
$string['status_declined'] = 'Abgelehnt';
$string['status_fully_attended'] = 'Vollständig anwesend';
$string['status_no_show'] = 'Nicht erschienen';
$string['status_partially_attended'] = 'Teilweise anwesend';
$string['status_requested'] = 'Angefragt';
$string['status_session_cancelled'] = 'Veranstaltung abgesagt';
$string['status_user_cancelled'] = 'Teilnehmer hat storniert';
$string['status_waitlisted'] = 'Warteliste';
$string['subject'] = 'Buchungsänderung im Kurs {$a->coursename} ({$a->duedate})';
$string['submissions'] = 'Einsendungen';
$string['submit'] = 'Absenden';
$string['submitted'] = 'Gesendet';
$string['summary'] = 'Zusammenfassung';
$string['suppressemail'] = 'E-Mail-Benachrichtigung unterdrücken';
$string['suppressemail_help'] = 'Verwenden Sie diese Option, wenn Sie im Hintergrund Teilnehmer zu einer Veranstaltung hinzufügen/entfernen möchten. Wenn diese Option aktiviert ist, wird die übliche E-Mail-Bestätigung nicht an die ausgewählten Teilnehmer gesendet.';
$string['takeattendance'] = 'Nehmen Sie teil';
$string['thirdpartyemailaddress'] = 'E-Mail-Adresse(n) von Dritten';
$string['thirdpartyemailaddress_help'] = '**E-Mail-Adresse(n) von Dritten** ist ein optionales Feld zur Angabe der E-Mail-Adresse eines/einer Dritten (z. B. eines externen Referenten), der/die dann Bestätigungsnachrichten erhält, wenn sich ein Teilnehmer für eine Veranstaltung anmeldet.
Wenn Sie **mehrere E-Mail-Adressen** eingeben, trennen Sie jede Adresse mit einem Komma, z. B. bob@example.com,joe@example.com';
$string['thirdpartywaitlist'] = 'Dritte über Veranstaltungen mit Wartelisten benachrichtigen';
$string['thirdpartywaitlist_help'] = 'Wenn **Dritte über Veranstaltungen mit Wartelisten benachrichtigen** ausgewählt ist, wird/werden der/die Dritte(n) benachrichtigt, wenn sich ein Teilnehmer für einen Präsenztermin mit Warteliste anmeldet.
Wenn **Dritte über Veranstaltungen mit Wartelisten benachrichtigen** nicht aktiviert ist werden Dritte nur benachrichtigt, wenn sich ein/e Teilnehmer/in für einen geplante Veranstaltung anmeldet (oder seine/ihre Teilnahme storniert).';
$string['time'] = 'Uhrzeit';
$string['timecancelled'] = 'Uhrzeit abgesagt';
$string['timedue'] = 'Anmeldeschluss';
$string['timefinish'] = 'Ende';
$string['timefinish_help'] = 'Ende ist die Zeit, zu welcher die Veranstaltung endet.';
$string['timerequested'] = 'Gewünschte Uhrzeit';
$string['timesignedup'] = 'Uhrzeit der Anmeldung';
$string['timestart'] = 'Anfang';
$string['timestart_help'] = 'Anfang ist die Zeit, zu welcher die Veranstaltung beginnt.';
$string['unapprovedrequests'] = 'Nicht genehmigte Anfragen';
$string['unknowndate'] = '(unbekanntes Datum)';
$string['unknowntime'] = '(unbekannte Uhrzeit)';
$string['upcomingsessions'] = 'Bevorstehende Veranstaltungen';
$string['upcomingsessionslist'] = 'Liste aller bevorstehenden Termine für diese Veranstaltung';
$string['updaterequests'] = 'Änderungswünsche';
$string['upgradeprocessinggrades'] = 'Die Verarbeitung von Veranstaltungsnoten kann eine Weile dauern, wenn es viele Veranstaltungen gibt.';
$string['usercalentry'] = 'Eintrag im Kalender eines/r Teilnehmers/in anzeigen';
$string['usercalentry_help'] = 'Wenn diese Einstellung aktiviert ist, wird dem Kalender eines/einer Teilnehmers/in einer Veranstaltung ein Eintrag hinzugefügt. Wenn diese Option deaktiviert ist, wird verhindert, dass ein doppeltes Ereignis im Kalender eines/einer Veranstaltungsteilnehmers/in angezeigt wird, in dem die Einstellungen für die Kalenderanzeige auf Kurs oder Veranstaltungsort eingestellt sind.';
$string['usercancelledon'] = 'Teilnehmer/in stornierte am {$a}';
$string['userdeletedcancel'] = 'Teilnehmer/in wurde gelöscht';
$string['usernotsignedup'] = 'Status: nicht angemeldet';
$string['usersignedup'] = 'Status: angemeldet';
$string['usersignedupon'] = 'Teilnehmer/in buchte am {$a}';
$string['userwillbewaitlisted'] = 'Diese Veranstaltung ist derzeit ausgebucht. Durch Anklicken der Schaltfläche "Anmelden" werden Sie auf die Warteliste gesetzt.';
$string['validation:needatleastonedate'] = 'Sie müssen mindestens ein Datum angeben oder die Warteliste für die Veranstaltung freigeben.';
$string['venue'] = 'Veranstaltungsgebäude';
$string['venue_help'] = '**Veranstaltungsgebäude** ist das Gebäude, in dem die Veranstaltung stattfinden wird.
Das **Veranstaltungsgebäude** wird auf der Anmeldungsseite, der Seite \'Alle Veranstaltungen anzeigen\' und in allen E-Mail-Benachrichtigungen angezeigt.';
$string['viewallsessions'] = 'Alle Veranstaltungen anzeigen';
$string['viewsubmissions'] = 'Anmeldungen ansehen';
$string['wait-list'] = 'Warteliste';
$string['wait-listed'] = 'Auf der Warteliste';
$string['waitlistedmessage'] = 'Wartelisten-Nachricht';
$string['waitlistedmessage_help'] = 'Diese Nachricht wird immer dann gesendet, wenn sich ein Teilnehmer für eine Warteliste anmeldet.';
$string['waitliststatus'] = 'Sie stehen auf der Warteliste für folgende Veranstaltung';
$string['xhours'] = '{$a} Stunden';
$string['xminutes'] = '{$a} Minuten';
$string['youarebooked'] = 'Sie haben sich für folgende Veranstaltung angemeldet';
$string['youremailaddress'] = 'Ihre E-Mail Adresse';
