<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'block_dash', language 'de', version '4.5'.
 *
 * @package     block_dash
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accordionfield1'] = 'Oberes linkes Feld';
$string['accordionfield1icon'] = 'Icon des oberen linken Felds';
$string['accordionfield2'] = 'Oberes rechtes Feld';
$string['accordionfield2icon'] = 'Icon des oberen rechten Felds';
$string['accordionfield3'] = 'Unteres linkes Feld';
$string['accordionfield3icon'] = 'Icon des unteren linken Felds';
$string['accordionfield4'] = 'Unteres linkes Feld';
$string['accordionfield4icon'] = 'Icon des unteren rechten Felds';
$string['achieved'] = 'Erreicht';
$string['activitybutton'] = 'Aktivitäts-Button';
$string['activityprogress'] = 'Fortschritt (abgeschlossen / Aktivitäten insgesamt)';
$string['activityprogressbar'] = 'Fortschrittsbalken (abgeschlossen / Aktivitäten insgesamt)';
$string['addcontent'] = 'Inhalt hinzufügen';
$string['addjointable'] = '{no} join Tabellen zum Formular hinzufügen';
$string['addnewfield'] = 'Neues Feld hinzufügen';
$string['addtocontacts'] = 'Zu Kontakten hinzufügen';
$string['alpha_asc'] = 'Alphabetisch sortieren von A bis Z';
$string['alpha_desc'] = 'Alphabetisch sortieren von Z bis A';
$string['always'] = 'Immer';
$string['anothertrailpath'] = 'Neuer Versuch';
$string['arrows'] = 'Pfeile anzeigen';
$string['arrows_help'] = 'Pfeilschaltflächen für die Navigation durch die nächste/vorherige Folie anzeigen.';
$string['asc'] = 'ASC';
$string['attribute'] = 'Attribut';
$string['auto'] = 'Auto';
$string['autoplay'] = 'Autoplay';
$string['autoplaySpeed'] = 'Autoplay-Geschwindigkeit (ms)';
$string['autoplaySpeed_help'] = 'Autoplay-Geschwindigkeit festlegen (Millisekunden)';
$string['autoplay_help'] = 'Autoplay';
$string['availablefields'] = 'Verfügbare Felder';
$string['availablefields_help'] = 'Wählen Sie alle möglichen Felder aus, die diese Datenquelle verwenden soll. Nutzer/innen können die Felder nach Bedarf auswählen. Beispiel: Wenn Nutzungsinformationen angezeigt werden, möglichst viele entsprechende Felder bereitstellen.';
$string['backgroundcolor'] = 'Hintergrundfarbe';
$string['backgroundgradient'] = 'Hintergrundfarbverlauf';
$string['backgroundgradient_help'] = 'Einen Farbverlauf erstellen: <a href="https://cssgradient.io/" target="_blank">cssgradient.io</a>. Fügen Sie die Hintergrundeigenschaft linear-gradient ein.';
$string['backgroundimage'] = 'Hintergrundbild';
$string['backgroundimage_help'] = 'Den gesamten Blockhintergrund mit diesem Bild bedecken';
$string['backgroundimagefield'] = 'Hintergrundbild';
$string['backgroundimageurl'] = 'URL des Hintergrundbildes';
$string['backgroundposition'] = 'Hintergrundposition';
$string['backgroundposition_help'] = 'Das Hintergrundbild fokussiert auf die angegebene Position';
$string['backgroundsize'] = 'Hintergrundgröße';
$string['backgroundsize_help'] = 'Das Hintergrundbild wird in dieser Größe angezeigt';
$string['badgecolorfield'] = 'Farbfeld des Badges';
$string['badgecolorfield_help'] = 'Wählen Sie ein Feld aus, das die Farben für die Badges der Timeline-Elemente zurückgibt.';
$string['badges'] = 'Badges';
$string['badgestitle'] = 'Badges';
$string['between'] = 'Zwischen';
$string['blockcontext'] = 'Block';
$string['blocksnotfound'] = 'Das aktuelle Dashboard enthält keine Blöcke.';
$string['blocktitle'] = 'Blocktitel';
$string['blocktitle_help'] = 'Titel, der in der Blocküberschrift angezeigt wird. Geben Sie einen kurzen und aussagekräftigen Titel für das ein, was dieser Block anzeigt.';
$string['blockwidth'] = 'Blockbreite';
$string['bodyfield'] = 'Body-Feld';
$string['bootstrapversion'] = 'Bootstrap-Version des Designs';
$string['bootstrapversion_desc'] = 'Wählen Sie die Bootstrap-Version Ihres Designs. Moodle verwendet im Allgemeinen die Version 4 und Totara die Version 3.';
$string['border'] = 'Rahmen';
$string['border_help'] = 'Wert der CSS-Rahmeneigenschaft.';
$string['border_option'] = 'Rahmen anzeigen';
$string['border_option_help'] = 'Sie können den Rahmen des Dash-Blocks hinzufügen.';
$string['bordervalue'] = 'Wert des Rahmens';
$string['buildown'] = 'Einen eigenen bauen';
$string['buildown_help'] = 'Datenquellen sind individuell konfigurierbar. Sie können die Datenquellen für verschiedene Zwecke verwenden. Filter-, Sortier- und Paginierungsfunktionen werden unterstützt';
$string['buynow'] = 'Jetzt kaufen';
$string['calendareventsfallback'] = 'Ersatzbild für Kalenderereignisse';
$string['calendareventsfallback_desc'] = 'Laden Sie ein Bild hoch, das angezeigt wird, wenn für einen Ereignistyp kein eigenes Bild vorhanden ist.';
$string['campaign'] = 'Kampagne';
$string['categories'] = 'Kategorien';
$string['categories_help'] = 'Die Quelle der Datenquellen-Kategorien enthält die verfügbaren Kategorien';
$string['category'] = 'Name der Kategorie';
$string['categorycoursecount'] = 'Anzahl der Kurse';
$string['categoryimage'] = 'Kategoriebild';
$string['categoryimagelink'] = 'Link zur Kategorie';
$string['categoryimageurl'] = 'URL des Kategoriebilds';
$string['categoryimgcategory'] = 'Bild für die Kategorie {$a->category}';
$string['categoryimgdesc'] = 'Bilder für die Kategorien hinzufügen';
$string['categoryimgfallback'] = 'Fallback-Bild für die Kategorie';
$string['categoryimgfallbackdesc'] = 'Laden Sie ein Bild hoch, das als standardmäßiger Ersatz für Kategorien verwendet wird. Wird eine neue Kategorie erstellt, erscheint dieses Ersatzbild, bis der Kategorie ein eigenes Bild zugewiesen wird.';
$string['categoryimgheading'] = 'Kategoriebild';
$string['categoryimgheadingsub'] = 'Kategoriebilder';
$string['categoryurl'] = 'Kategorie-URL';
$string['centerMode'] = 'Zentrierter Modus';
$string['centerMode_help'] = 'Diese Option aktiviert eine zentrierte Ansicht mit teilweise sichtbaren vorherigen/nächsten Folien. Verwenden Sie dies, wenn bei slidesToShow eine ungerade Zahl eingestellt ist.';
$string['centerPadding'] = 'Zentrierter Abstand (px)';
$string['centerPadding_help'] = 'Seitlicher Abstand wenn im zentrierten Modus (px).';
$string['centerbottom'] = 'Unten zentriert';
$string['centercenter'] = 'Mittig zentriert';
$string['centertop'] = 'Oben zentriert';
$string['certificatecodelinked'] = 'Verknüpfter Code';
$string['choosedatasource'] = 'Datenquelle wählen';
$string['choosefeature'] = 'Feature wählen';
$string['choosefilter'] = 'Filter wählen';
$string['chooseskill'] = 'Fähigkeit auswählen';
$string['circlepath'] = 'Kreis';
$string['cohorts'] = 'Globale Gruppen';
$string['columns'] = 'Spalten';
$string['columns_help'] = 'Die Anzahl der Spalten, die pro Zeile im Raster angezeigt werden sollen.';
$string['compentenciesnotfound'] = 'Kompetenz nicht gefunden';
$string['competencyappearance'] = 'Kompetenzaussehen';
$string['competencycolor'] = 'Kompetenzfarbe';
$string['competencyframework'] = 'Kompetenzrahmen';
$string['competencyheading'] = 'Einstellungen für Kompetenzaussehen';
$string['competencyimage'] = 'Kompetenz-Bild';
$string['completedactivities'] = 'Abgeschlossene Aktivitäten';
$string['completedcourse'] = 'Abgeschlossene Kurse';
$string['completedlearningpath'] = 'Lernpfad abgeschlossen. Gut gemacht!';
$string['completion:completed'] = 'Abgeschlossen';
$string['completion:inprogress'] = 'In Bearbeitung';
$string['completion:notstarted'] = 'Noch nicht begonnen';
$string['conditionaddfields'] = '{no} Bedingung(en) hinzufügen';
$string['conditionsection'] = 'Einstellungen für Bedingungen';
$string['conditionstatichdr'] = 'Bedingung #0';
$string['conditionvalue'] = 'Wert';
$string['conditionvalue_help'] = 'Bedingungswert – Geben Sie den Wert ein, mit dem die Bedingung geprüft wird. Dieser Wert bestimmt, wann die Bedingung erfüllt ist. Für IN-Bedingungen mehrere Werte mit Komma (,) eingeben.';
$string['confirmleavegroup'] = 'Möchten Sie die Gruppe {$a} wirklich verlassen?';
$string['contacts'] = 'Kontakte';
$string['contain'] = 'Einpassen';
$string['contentdisplay'] = 'Anzeigen';
$string['contentdisplayallpage'] = 'Alle Seiten';
$string['contentdisplaysection'] = 'Abschnittsseiten';
$string['contenteditor'] = 'Inhalt';
$string['contentlayout'] = 'Inhaltslayout';
$string['contentmodaltitle'] = 'Dash-Inhalte aktualisieren';
$string['contentsectiondisplay'] = 'Abschnitte anzeigen';
$string['contentsections'] = 'Anzuzeigende Abschnitte';
$string['contextcategory'] = 'Kategorie';
$string['contextcourse'] = 'Kurs';
$string['contextid'] = 'Kontext';
$string['contextid_help'] = 'Der Kontext für dieses Dashboard. Wählen Sie einen bestimmten Kurs, wenn Sie die Datenergebnisse einschränken möchten (Beispiel: Filter "Aktueller Kurs"). Ansonsten wählen Sie "System" für allgemeine Zwecke.';
$string['contextlevel'] = 'Kontextebene';
$string['contextlinked'] = 'Verlinkter Kontext';
$string['contextmissing'] = 'Fehlender Kontext';
$string['contextname'] = 'Kontextname';
$string['contextsettings'] = 'Einstellungen für Kontext';
$string['contextsystem'] = 'System';
$string['contexttype'] = 'Kontexttyp';
$string['contexturl'] = 'Kontext-URL';
$string['copy'] = 'Kopieren';
$string['coredashboard'] = 'Haupt-Dashboard';
$string['course_enrol_role'] = 'Rolle für Einschreibung mit Einschreibungs-Widget';
$string['course_enrolments:abovecourseform'] = 'Über den Kursen';
$string['course_enrolments:belowcourseform'] = 'Unter den Kursen';
$string['course_enrolments:disabled'] = 'Deaktiviert';
$string['course_enrolments:displayaddcourse'] = 'Formular zur Kurserstellung anzeigen';
$string['course_enrolments:expandable'] = 'Ausklappbar';
$string['course_enrolments:progress'] = 'Fortschritt anzeigen';
$string['course_enrols:viewotherprofiledash'] = 'Profil-Dash-Block anderer anzeigen';
$string['course_enrols:viewprofiledash'] = 'Eigenen Profil-Dash-Block anzeigen';
$string['coursebutton'] = 'Kursbutton';
$string['coursecatcontext'] = 'Kurskategorie';
$string['coursecategories'] = 'Kursbereiche';
$string['coursecontent'] = 'Kurskontext';
$string['coursecontext'] = 'Kurs';
$string['coursedata:past'] = 'Vergangene';
$string['coursedate:future'] = 'Zukünftige';
$string['coursedate:present'] = 'Aktuelle';
$string['coursedates'] = 'Kursdaten';
$string['coursefullname'] = 'Vollständiger Name des Kurses';
$string['courseidnumber'] = 'ID-Nummer des Kurses';
$string['courseimage'] = 'Standardbild für den Kurs';
$string['courseimagedesc'] = 'Hier können Sie ein Platzhalterbild hochladen, das als Kursbild angezeigt werden soll, falls in den Kurseinstellungen kein Kursbild existiert.';
$string['courseimagelink'] = 'Link zum Kursbild';
$string['courseinformation'] = 'Kursinformation';
$string['courseoverviewfilesurl'] = 'URL zum Kursbild';
$string['courseredirecturl'] = 'Kursweiterleitungs-URL';
$string['courseredirecturldesc'] = 'Geben Sie die URL ein, zu der Teilnehmer/innen von der Kursübersichtsseite weitergeleitet werden.';
$string['courseshopurl'] = 'Kurs-Shop-URL';
$string['courseshortname'] = 'Kurs-Kurzname';
$string['coursestafftitle'] = 'Lehrpersonal';
$string['coursestartdate'] = 'Kursbeginn';
$string['coursestartdate_asc'] = 'Nach Kursbeginn (neuesten zuerst)';
$string['coursestartdate_desc'] = 'Nach Kursbeginn (ältesten zuerst)';
$string['coursesummary'] = 'Kurszusammenfassung';
$string['courseurl'] = 'Kurs-URL';
$string['cover'] = 'Ausfüllen';
$string['createcustomdatasource'] = 'Eigene Datenquelle erstellen';
$string['createcustomlayout'] = 'Nutzerdefiniertes Layout erstellen';
$string['createdashboard'] = 'Dashboard erstellen';
$string['createddate'] = 'Erstellungsdatum';
$string['createlayout'] = 'Nutzerdefiniertes Layout erstellen';
$string['cssclass'] = 'CSS-Klasse';
$string['cssclass_help'] = 'Verwenden Sie eine nutzerdefinierte CSS-Klasse, um mehrere Klassen anzuwenden.';
$string['ctalink'] = '"Call to action"-Link';
$string['currentcategory'] = 'Aktuelle Kategorie';
$string['currentcourse'] = 'Aktueller Kurs';
$string['currentcoursecontext'] = 'Aktueller Kurskontext';
$string['currentcoursegroups'] = 'Aktuelle Kursgruppen';
$string['currentcourseskills'] = 'Aktuelle Kurs-Fähigkeiten';
$string['currentlevel'] = 'Aktuelle Ebene';
$string['custom'] = 'Nutzerdefiniert';
$string['customcondition'] = 'Nutzerdefinierte Bedingungsabfrage';
$string['customdatasource'] = 'Nutzerdefinierte Datenquelle';
$string['customdatasourcecreated'] = 'Datenquelle <b>{$a->name}</b> wurde erfolgreich erstellt.';
$string['customdatasourcedeleted'] = 'Nutzerdefinierte Datenquelle gelöscht';
$string['customdatasourceedited'] = 'Datenquelle <b>{$a->name}</b> wurde erfolgreich bearbeitet.';
$string['customdatasources'] = 'Nutzerdefinierte Datenquellen';
$string['customfeaturetype'] = 'Nutzerdefinierter Funktionstyp';
$string['customfield'] = '{$a->name}';
$string['customfields'] = 'Nutzerdefinierte Felder';
$string['customlayoutcreated'] = 'Nutzerdefiniertes Layout <b>{$a->name}</b> erfolgreich erstellt.';
$string['customlayoutdeleted'] = 'Nutzerdefiniertes Layout <b>{$a->name}</b> erfolgreich gelöscht.';
$string['customlayoutedited'] = 'Nutzerdefiniertes Layout <b>{$a->name}</b> erfolgreich bearbeitet.';
$string['customsqlfield'] = 'SQL-Felder';
$string['customsqlselect'] = 'SQL-Abfrage';
$string['customurl'] = 'Nutzerdefinierte URL';
$string['customurltext'] = 'Nutzerdefinierter URL-Text';
$string['dash:addinstance'] = 'Neuen Dash-Block hinzufügen';
$string['dash:managecoursecatedashboards'] = 'Datenquellen für Kurskategorien verwalten';
$string['dash:managedatasource'] = 'Datenquellen verwalten';
$string['dash:managewidget'] = 'Widgets verwalten';
$string['dash:myaddinstance'] = 'Neuen Dash-Block zum Dashboard hinzufügen';
$string['dash:mygroups_addusers'] = 'Personen zu Gruppen hinzufügen';
$string['dash:mygroups_creategroup'] = 'Gruppen in eingeschriebenen Kursen erstellen';
$string['dash:mygroups_leavegroup'] = 'Aus Gruppe austreten';
$string['dash:mygroups_view'] = 'Meine eigenen Gruppen ansehen';
$string['dash:mygroups_viewmembers'] = 'Personen in zugewiesenen Gruppen anzeigen';
$string['dash:viewrestrictedblocks'] = 'Eingeschränkte Dash-Blöcke anzeigen';
$string['dashaddoncontentdesc'] = 'Wählen Sie aus den folgenden Layouts';
$string['dashaddonpluginname'] = 'Dash-Add-on-Name';
$string['dashbgimg'] = 'Hintergrundbild';
$string['dashbgimg_help'] = 'Dieses Hintergrundbild wird als Hintergrund für das Dashboard verwendet.';
$string['dashboard'] = 'Dashboard';
$string['dashboardcreated'] = 'Dashboard <b>{$a->name}</b> erfolgreich angelegt';
$string['dashboarddeleted'] = 'Dashboard <b>{$a->name}</b> erfolgreich gelöscht';
$string['dashboardduplicated'] = 'Dashboard erfolgreich dupliziert';
$string['dashboardedited'] = 'Dashboard <b>{$a->name}</b> erfolgreich bearbeitet';
$string['dashboardlink'] = 'Link zum Dashboard';
$string['dashboards'] = 'Dashboards';
$string['dashicon'] = 'Icon';
$string['dashicon_help'] = 'Dieses Symbol wird nur in der Dashboards-Datenquelle angezeigt.';
$string['dashthumbnailimg'] = 'Thumbnail-Bild';
$string['dashthumbnailimg_help'] = 'Dieses Thumbnail-Bild wird nur in der Dashboards-Datenquelle angezeigt.';
$string['dashthumbnailimgurl'] = 'Thumbnail Bild-URL';
$string['databaseerror'] = 'Datenbankfehler. Dieser Inhalt kann nicht angezeigt werden.';
$string['datasource'] = 'Datenquelle';
$string['datasource:competency_progress_widget'] = 'Kompetenz-Widget';
$string['datasource:competency_widget'] = 'Fähigkeitengraph-Widget';
$string['datasource:completion_widget'] = 'Kursabschluss-Widget';
$string['datasource:completions_data_source'] = 'Kursabschlüsse';
$string['datasource:completions_data_source_help'] = 'Abgeschlossene Kurse der aktuellen Person';
$string['datasource:courses_data_source'] = 'Kurse';
$string['datasource:courses_data_source_help'] = 'Liste der verfügbaren Kurse für die aktuelle Person';
$string['datasource:dashboard_data_source'] = 'Dashboards';
$string['datasource:dashboard_data_source_help'] = 'Liste der Dashboards';
$string['datasource:enrolments_widget'] = 'Einschreibe-Widgets';
$string['datasource:logstore_data_source'] = 'Logdaten der Website';
$string['datasource:logstore_data_source_help'] = 'Datenquelle von Logdaten der Website';
$string['datasource:roleassignments_data_source'] = 'Rollenzuweisungen';
$string['datasource:sections_widget'] = 'Kursabschnitts-Widget';
$string['datasourcedesc'] = 'Dynamische Inhalte mit Datenquellen und Layouts hinzufügen';
$string['datasourcemissing'] = 'Datenquelle fehlt.';
$string['datasourcename'] = 'Name der Datenquelle';
$string['datasources'] = 'Datenquellen';
$string['datecompleted'] = 'Datum des Kursabschlusses';
$string['daysuntilend'] = 'Tage bis Kursende';
$string['daysuntilstart'] = 'Tage bis Kursstart';
$string['defaultexportdata'] = 'Dash-Datenexport';
$string['defaultexportdata_help'] = 'Mit dieser Einstellung kann der Export von Daten aus der dash-Datenquelle aktiviert oder deaktiviert werden.';
$string['defaultsortdirection'] = 'Sortierreihenfolge';
$string['defaultsortfield'] = 'Sortieren nach';
$string['defaultsortfield_help'] = 'Sortiert die Datenbankergebnisse nach diesem Feld. Wenn das Layout die Sortierung nach Nutzer/innen unterstützt, ist dies die Standardeinstellung.';
$string['delete'] = 'Löschen';
$string['deletecondition'] = 'Diese Bedingung löschen';
$string['deleteconfirm'] = 'Möchten Sie wirklich das Dashboard <b>{$a->name}</b> löschen?';
$string['deleteconfirmcustomdatasource'] = 'Möchten Sie die nutzerdefinierte Datenquelle <b>{$a->name}</b> wirklich löschen?';
$string['deleteconfirmcustomlayout'] = 'Möchten Sie wirklich das nutzerdefinierte Layout <b>{$a->name}</b> löschen?';
$string['deletecustomdatasource'] = 'Nutzerdefinierte Datenquelle löschen';
$string['deletecustomlayout'] = 'Nutzerdefiniertes Layout löschen';
$string['deletedashboard'] = 'Dashboard löschen';
$string['deletefield'] = 'Dieses Feld löschen';
$string['deletejoin'] = 'Diese Join-Tabelle löschen';
$string['desc'] = 'DESC';
$string['description'] = 'Beschreibung';
$string['designercustombgposition'] = 'Nutzerdefinierte Hintergrundposition';
$string['designercustombgsize'] = 'Nutzerdefinierte Hintergrundgröße';
$string['desktop_learningpath'] = 'Lernpfad (für Desktop)';
$string['desktop_learningpath_desc'] = 'Beschreibung des Lernpfades (für Desktop)';
$string['details_area'] = 'Bereich Details';
$string['details_area_help'] = 'Wählen Sie, wie der Bereich "Details" angezeigt werden soll.';
$string['details_area_locations'] = 'Details zu "Standort-Bereichen"';
$string['details_area_locations_help'] = 'Geben Sie die Einzelheiten für jeden Standort ein, der im Bereich "Details" angezeigt werden soll.';
$string['details_area_size'] = 'Details zu "Bereichsgrößen"';
$string['details_area_size_help'] = 'Wählen Sie, in welcher Größe der Bereich "Details" angezeigt werden soll.';
$string['details_bg_color'] = 'Details zu "Hintergrundfarbe"';
$string['details_body_1'] = 'Details zu "Body 1"';
$string['details_body_2'] = 'Details zu "Body 2"';
$string['details_body_3'] = 'Details zu "Body 3"';
$string['details_footer_left'] = 'Details zu "Footer links"';
$string['details_footer_right'] = 'Details zu "Footer rechts"';
$string['details_text_color'] = 'Details zu "Textfarbe"';
$string['details_title'] = 'Details zu "Titel"';
$string['developerfield'] = '{$a}';
$string['developerfieldid'] = 'ID';
$string['disableall'] = 'Alle Dash-Ausgaben deaktivieren';
$string['disableall_help'] = 'Warnung: Für Fehlersuche oder zur Behebung fehlerhafter Seiten';
$string['disableallmessage'] = 'Die Dash-Ausgabe ist deaktiviert. Prüfen Sie die Dash-Einstellungen.';
$string['disabled'] = 'Deaktiviert';
$string['displaycta'] = '"Call to action" anzeigen';
$string['displaydashboardtitle'] = 'Dashboard-Titel anzeigen';
$string['donut'] = 'Ringdiagramm';
$string['dot'] = 'Punkt';
$string['dots'] = 'Punkte anzeigen';
$string['dots_help'] = 'Punkt-Indikatoren für die Foliennavigation anzeigen';
$string['downloadcertificate'] = 'Zertifikat herunterladen';
$string['downloadcsv'] = 'Im CSV-Format herunterladen';
$string['draggable'] = 'Verschiebbar / Ziehbar';
$string['draggable_help'] = 'Ermöglicht das Ziehen und Wischen von Folien.';
$string['dragitem'] = 'Element ziehen';
$string['duedate'] = 'Fälligkeitsdatum';
$string['duplicatedashboard'] = 'Dashboard duplizieren';
$string['edit'] = 'Bearbeiten';
$string['editcontent'] = 'Inhalt bearbeiten';
$string['editcustomdatasource'] = 'Datenquelle bearbeiten';
$string['editcustomlayout'] = 'Nutzerdefiniertes Layout bearbeiten';
$string['editdashboard'] = 'Dashboard bearbeiten';
$string['editpreferences'] = 'Einstellungen bearbeiten';
$string['editthisblock'] = 'Bearbeiten Sie die Einstellungen dieses Blocks, um die Konfiguration abzuschließen.';
$string['edituserenrolment'] = 'Die Einschreibungen von {$a} bearbeiten';
$string['emptystateheading'] = 'Leerer Zustand';
$string['enableconditions'] = 'Bedingungen aktivieren';
$string['enabledconditions'] = 'Daten einschränken auf';
$string['enabledfields'] = 'Aktivierte Felder';
$string['enabledfilters'] = 'Aktivierte Filter';
$string['enabledownload'] = 'Daten exportieren';
$string['enabledownload_help'] = 'Diese Einstellung ermöglicht es Nutzer/innen, die Daten sowohl im CSV- als auch im XLS-Format herunterzuladen.';
$string['enablejoins'] = 'Joins aktivieren';
$string['enroldate_asc'] = 'Nach Datum der Einschreibung (älteste zuerst)';
$string['enroldate_desc'] = 'Nach Datum der Einschreibung (jüngste zuerst)';
$string['enroldetails'] = 'Einschreibedetails';
$string['enroled'] = 'Eingeschrieben';
$string['enrollment'] = 'Einschreibung';
$string['enrollment_options'] = 'Einschreibungs-Optionen';
$string['enrollmentmethod'] = 'Einschreibemethode';
$string['enrollmentmethodstatus'] = 'Status der Einschreibemethode';
$string['enrollmentoptions'] = 'Einschreibemethoden';
$string['enrollmentoptions:cost'] = 'Ab {$a->cost} {$a->currency}';
$string['enrollmentoptions:credits'] = '{$a} Credits';
$string['enrollmentoptions:free'] = 'Kostenlos';
$string['enrollmentoptions:fromcredits'] = 'Ab {$a} Credits';
$string['enrollmentoptions:seeoptions'] = 'Optionen ansehen';
$string['enrollments'] = 'Einschreibungen';
$string['enrollmentself'] = 'Selbsteinschreibungen';
$string['enrollmentsnotself'] = 'Fremdeinschreibungen';
$string['enrollmentstatus'] = 'Einschreibestatus';
$string['enrollmenttimeend'] = 'Einschreibeende';
$string['enrollmenttimestart'] = 'Startdatum für Einschreibungen';
$string['enrolmentmethod'] = 'Einschreibemethode';
$string['enrolmentoptions'] = 'Einschreibeoptionen';
$string['enrolnow'] = 'Jetzt einschreiben';
$string['enterclasses'] = 'Klasse eingeben';
$string['even:icon'] = 'Event-Symbol';
$string['event'] = 'Event';
$string['event:color'] = 'Event-Farbe';
$string['event:contextevent'] = 'Event-Kontext';
$string['event:contextlinked'] = 'Verlinkter Event-Kontext';
$string['event:description'] = 'Beschreibung';
$string['event:duration'] = 'Event-Dauer';
$string['event:durationinminutes'] = 'Event-Dauer in Minuten';
$string['event:enddate'] = 'Enddatum';
$string['event:endtime'] = 'Event-Ende';
$string['event:filterdate'] = 'Datum';
$string['event:filterday'] = 'Wochentage';
$string['event:gotoactivity'] = 'Zur Aktivität wechseln';
$string['event:image'] = 'Event-Bild';
$string['event:imagelinked'] = 'Event-Bild (verlinkt)';
$string['event:imageurl'] = 'Event-Bild-URL';
$string['event:location'] = 'Standort';
$string['event:repeated'] = 'Wiederkehrendes Event';
$string['event:startdate'] = 'Startdatum';
$string['event:starttime'] = 'Startzeit';
$string['event:status'] = 'Status';
$string['event:title'] = 'Event-Titel';
$string['event:type'] = 'Event-Art';
$string['event:typecategory'] = 'Kurskategorie';
$string['event:typecourse'] = 'Kurs';
$string['event:typefilter'] = 'Event-Art Filter';
$string['event:typegroup'] = 'Gruppe';
$string['event:typeother'] = 'Anderes';
$string['event:typesite'] = 'Seite';
$string['event:typeuser'] = 'Person';
$string['event_desc_core_event_user_enrolment_created'] = '{$a->relateduserfullname} war in <a href="{$a->eventurl}" title="{$a->contextname} ansehen">{$a->contextname}</a> eingeschrieben';
$string['event_desc_generic'] = '{$a->userfullname} {$a->action} <a href="{$a->eventurl}" title="{$a->contextname} ansehen">{$a->contextname}</a>';
$string['eventactivity:both'] = 'Nicht abgeschlossene und abgeschlossene Aktivitäten';
$string['eventactivity:incomplete'] = 'Nur nicht abgeschlossene Aktivitäten';
$string['eventactivitycompletion'] = 'Mit einer Aktivität verknüpft';
$string['eventbutton'] = 'Termin-Button';
$string['eventclass'] = 'Termin-Klasse';
$string['eventcolor'] = 'Termin-Farbe';
$string['eventcontext'] = 'Kontext des Termins';
$string['eventdescription'] = 'Termin-Beschreibung';
$string['eventicon'] = 'Termin-Icon';
$string['eventlink'] = 'Termin-Link';
$string['events'] = 'Termine';
$string['eventstatus'] = 'Status des Termins';
$string['eventtime'] = 'Zeitpunkt des Termins';
$string['eventurl'] = 'Termin-URL';
$string['extracontent'] = 'Zusätzlicher Inhalt';
$string['extralargeimage'] = 'Extragroßes Bild';
$string['fade'] = 'Überblenden';
$string['fade_help'] = 'Aktiviert den Überblenden-Effekt beim Folienwechsel.';
$string['failed'] = 'Fehlgeschlagen';
$string['field'] = 'Feld';
$string['field:completedactivitiesinweek'] = 'Abgeschlossene Aktivitäten diese Woche';
$string['field:completedcourses'] = 'Abgeschlossene Kurse';
$string['field:completedcoursesinweek'] = 'Diese Woche abgeschlossene Kurse';
$string['field:courseimgsize'] = 'Größe des Kursbilds';
$string['field:courseimgsize_help'] = 'Punkt — 20x20px Punkt, ohne Kursbild.<br>Winziges Bild — 35x35px.<br>Kleines Bild — 50x50px.<br>Mittleres Bild — 75x75px.<br>Großes Bild — 100x100px.<br>Sehr großes Bild — 150x150px.';
$string['field:coursesinprogress'] = 'Laufende Kurse';
$string['field:currentcoursescount'] = 'Aktuelle Kurse';
$string['field:detailsarea'] = 'Bereich "Details"';
$string['field:detailsarea_help'] = 'Wenn die Option aktiviert ist, wird beim Anklicken des Kurses ein Detailbereich als Modal angezeigt.';
$string['field:earnedandtotalpoints'] = 'Erreichte/gesamte Fähigkeitspunkte';
$string['field:earnedskillpoints'] = 'Erreichte Fähigkeitspunkte';
$string['field:enrolledprogress'] = 'Abgeschlossene Kurse/Kurse insgesamt';
$string['field:finishelement'] = 'Abschlusselement';
$string['field:finishelement_help'] = 'Wenn aktiviert, wird am Ende des Pfads ein Abschlusselement hinzugefügt.';
$string['field:fullname'] = 'Vollständigen Namen der Person anzeigen';
$string['field:futurecoursescount'] = 'Zukünftige Kurse';
$string['field:infoarea'] = 'Infobereich';
$string['field:infoarea_help'] = 'Wenn diese Option aktiviert ist, wird der Infobereich angezeigt.';
$string['field:kpi'] = 'KPI {$a}';
$string['field:learningpathdesktop'] = 'Pfad für Desktop';
$string['field:learningpathmobile'] = 'Pfad für Mobilgeräte';
$string['field:learningpathtablet'] = 'Pfad für Tablets';
$string['field:limit'] = 'Limit';
$string['field:limit_help'] = 'Limit';
$string['field:loginsthisweek'] = 'Logins diese Woche';
$string['field:loginstreak'] = 'Login-Serie';
$string['field:numberofcontactreq'] = 'Kontaktanfragen';
$string['field:numberofdueactivities'] = 'Bald fällige Aktivitäten';
$string['field:numberofoverdueactivities'] = 'Überfällige Aktivitäten';
$string['field:numberofunreadmsg'] = 'Ungelesene Nachrichten';
$string['field:onlineuserscount'] = 'Anzahl aktuell eingeloggter Personen';
$string['field:orderby'] = 'Sortieren nach';
$string['field:orderby_help'] = 'Sortieren nach';
$string['field:orderdirection'] = 'Sortierrichtung';
$string['field:orderdirection_help'] = 'Sortierrichtung';
$string['field:pastcoursescount'] = 'Vergangene Kurse';
$string['field:profileimage'] = 'Profilbild der Person anzeigen';
$string['field:profileuserinfo'] = 'Profil-Informationen von {$a}';
$string['field:sincelogindays'] = 'Tage seit dem letzten Login';
$string['field:startelement'] = 'Startelement';
$string['field:startelement_help'] = 'Wenn die Option aktiviert ist, wird am Anfang des Pfads ein Startelement hinzugefügt.';
$string['field:teammemberscount'] = 'Anzahl der Personen im Team';
$string['fieldalert'] = 'Das ausgewählte Layout kann nicht angepasst werden.';
$string['fieldalllevels'] = 'Alle Ebenen anzeigen';
$string['fieldattributeshdr'] = 'Felddatenformat umwandeln';
$string['fieldcurrentlevel'] = 'Aktuelle Ebene anzeigen';
$string['fieldcustomdata'] = 'Zusätzlicher Formatwert';
$string['fieldcustomdata_help'] = 'Geben Sie die zusätzlichen Daten zum ausgewählten Attribut ein.
<b>Beispiel:</b>
1. Geben Sie für das Link-Attribut den Link ein und verwenden Sie die Feldwerte als Parameter.
2. Verwenden Sie für das Prozent-Attribut den Outof-Wert. Für die Noten verwenden Sie 10, andernfalls 100.';
$string['fieldname'] = 'Feldname';
$string['fieldnotfound'] = 'Feld nicht gefunden';
$string['fields'] = 'Felder';
$string['fieldselect'] = 'SQL-Select für das Feld';
$string['fieldssection'] = 'Felder-Setup';
$string['fieldstatichdr'] = 'Feld #0';
$string['fieldtransformdata'] = 'Das Format transformieren';
$string['fieldtransformdata_help'] = 'Bei der Anzeige des Wertes in der Tabelle das Format transformieren';
$string['filter:friday'] = 'Freitag';
$string['filter:monday'] = 'Montag';
$string['filter:saturday'] = 'Samstag';
$string['filter:sunday'] = 'Sonntag';
$string['filter:thismonth'] = 'Diesen Monat';
$string['filter:thisweek'] = 'Diese Woche';
$string['filter:thursday'] = 'Donnerstag';
$string['filter:today'] = 'Heute';
$string['filter:tuesday'] = 'Dienstag';
$string['filter:upcoming'] = 'Bevorstehend';
$string['filter:wednesday'] = 'Mittwoch';
$string['fit_content'] = 'Inhalt einpassen';
$string['fit_content_help'] = 'Höhe des Detailbereichs an die Karte angleichen, Breite durch den Inhalt bestimmen lassen.';
$string['fontcolor'] = 'Schriftfarbe';
$string['fontcolor_help'] = 'CSS-Eigenschaft für Schriftfarbe (z. B. #ffffff, rgb(255, 255, 255), etc.)';
$string['footercontent'] = 'Footer-Inhalt';
$string['footercontent_help'] = 'Inhalt, der im Block-Footer angezeigt wird.';
$string['footerfield'] = 'Footer-Feld';
$string['footerrightfield'] = 'Footer-Feld (rechts)';
$string['fullnamelinked'] = 'Vollständiger Name mit Link zum Profil';
$string['generalsettings'] = 'Allgemeine Einstellungen';
$string['generateattributes'] = 'Feld-Attribute generieren';
$string['generatefields'] = 'Felder generieren';
$string['gotoevent'] = 'Zum Termin gehen';
$string['gridsizeoptions'] = 'Breit / Hoch / Quadratisch';
$string['groupby'] = 'Gruppieren nach';
$string['grouplabel'] = 'Gruppenbezeichnung';
$string['headercontent'] = 'Header-Inhalt';
$string['headercontent_help'] = 'Inhalt, der im Block-Header angezeigt wird.';
$string['headerfooter'] = 'Header & Footer';
$string['headingfield'] = 'Überschriftenfeld';
$string['hidden'] = 'Verborgen';
$string['hidecompletedskills'] = 'Abgeschlossene Fähigkeiten ausblenden';
$string['hidecoursecategory'] = 'Kategorien-/Kursübersicht nicht anzeigen';
$string['hidecoursecategorydesc'] = 'Wenn jemand die URL /course/index.php aufruft, erfolgt automatisch eine Weiterleitung zur Startseite, außer es ist unten eine nutzerdefinierte URL angegeben. In diesem Fall erfolgt die Weiterleitung dorthin.';
$string['hideindividualskills'] = 'Einzelne Fähigkeiten ausblenden';
$string['hidemycourses'] = 'Kurse verbergen, in die ich eingeschrieben bin';
$string['hideshow'] = 'Verbergen/Anzeigen';
$string['hidetable'] = 'Tabelleninhalte ausblenden';
$string['hidetable_help'] = 'Wenn diese Option aktiviert ist, können Nutzer/innen den Tabelleninhalt in der Dash-Instanz ausblenden. Nur die Kopf- und Fußzeilenblöcke bleiben sichtbar.';
$string['hidewhenempty'] = 'Verbergen, wenn leer';
$string['hidewhenempty_desc'] = 'Den Dash-Block ausblenden, wenn er leer ist.';
$string['higherthan'] = 'Höher als';
$string['iconfield'] = 'Icon-Feld';
$string['imageoverlayfield'] = 'Label auf Kursbild';
$string['imageoverlayfield_help'] = 'Inhalt wird als Label auf dem Kursbild mit farbigem Hintergrund angezeigt';
$string['imageurlfield'] = 'Feld für die Bild-URL';
$string['imageurlfield_help'] = 'Wählen Sie ein Bild-URL-Feld, das in jeder Karte im Raster verwendet werden soll.';
$string['includedblocks'] = 'Eingeschlossene Blöcke';
$string['includesubcategories'] = 'Unterkategorien einbeziehen';
$string['includesubcategories_help'] = 'Wenn die Option aktiviert ist, werden die Unterkategorien der gewählten Kategorien ebenfalls in die Ergebnisse einbezogen.';
$string['incomplete'] = 'Nicht abgeschlossen';
$string['infinite'] = 'Endlosschleife';
$string['infinite_help'] = 'Diese Option aktiviert endloses Durchlaufen der Folien.';
$string['initial'] = 'Initial';
$string['invalididnumberunique'] = 'ID-Nummer existiert bereits.';
$string['invalidoperator'] = 'Ungültiger Operator {$a->operator}.';
$string['invalidshortname'] = 'Ungültiger Kurzname. Er darf nur Buchstaben (a–z, A–Z) oder Bindestriche (-) enthalten.';
$string['invalidshortnametoolong'] = 'Ungültiger Kurzname. Er darf höchstens 16 Zeichen lang sein.';
$string['invalidshortnameunique'] = 'Dieser Kurzname wird bereits von einem anderen Dashboard verwendet.';
$string['invalidwhereclause'] = 'Ungültige WHERE-Klausel. Keine Werte angegeben.';
$string['label'] = 'Bezeichnung';
$string['label:completedactivitiesinweek'] = 'Abgeschlossene Aktivitäten diese Woche';
$string['label:completedcourses'] = 'Abgeschlossene Kurse';
$string['label:completedcoursesinweek'] = 'Abgeschlossene Kurse diese Woche';
$string['label:coursesinprogress'] = 'Laufende Kurse';
$string['label:currentcoursescount'] = 'Aktuelle Kurse';
$string['label:earnedandtotalpoints'] = 'Erworbene Punkte/Punkte insgesamt';
$string['label:earnedskillpoints'] = 'Gesammelte Punkte';
$string['label:enrolledprogress'] = 'Abgeschlossene Kurse';
$string['label:futurecoursescount'] = 'Zukünftige Kurse';
$string['label:loginsthisweek'] = 'Logins diese Woche';
$string['label:loginstreak'] = 'Anmeldeserie';
$string['label:numberofcontactreq'] = 'Kontaktanfragen';
$string['label:numberofdueactivities'] = 'Fällige Aktivitäten';
$string['label:numberofoverdueactivities'] = 'Überfällige Aktivitäten';
$string['label:numberofunreadmsg'] = 'Ungelesene Nachrichten';
$string['label:onlineuserscount'] = 'Aktuell eingeloggte Nutzer/innen';
$string['label:pastcoursescount'] = 'Vergangene Kurse';
$string['label:sincelogindays'] = 'Tage seit der letzten Anmeldung';
$string['label:teammemberscount'] = 'Teammitglieder';
$string['largeimage'] = 'Großes Bild';
$string['layout'] = 'Layout';
$string['layoutaccordion'] = 'Akkordeon-Layout (mit Tabellen)';
$string['layoutaccordion2'] = 'Akkordeon-Layout';
$string['layoutcards'] = 'Raster-Layout';
$string['layoutdoesnotsupportfiltering'] = 'Das gewählte Layout unterstützt keine Filterung.';
$string['layoutdoubleequal'] = 'Zweispaltig (1/2, 1/2)';
$string['layoutdoubleleft'] = 'Zweispaltig (1/3, 2/3)';
$string['layoutdoubleright'] = 'Zweispaltig (2/3, 1/3)';
$string['layoutfull'] = 'Einspaltig (volle Breite)';
$string['layoutgrid'] = 'Tabellen-Layout';
$string['layoutmode'] = 'Layout Modus';
$string['layoutmode_help'] = 'Wählen Sie, welcher Modus im Widget erscheint.';
$string['layoutonestat'] = 'Bild mit Bildunterschrift';
$string['layouttimeline'] = 'Timeline-Layout';
$string['layouttriple'] = 'Dreispaltig (1/3, 1/3, 1/3)';
$string['layouttwostat'] = 'Zwei Bilder nebeneinander';
$string['layouttype'] = 'Layouttyp';
$string['leanringpath_infocontent'] = 'Sie haben <b>{$a->completed}</b> von <b> {$a->total} </b> Kursen abgeschlossen. Der nächste Kurs in diesem Lernpfad ist: <b> {$a->nextcourse}</b>';
$string['learningpath:infoarea'] = 'Inhalt des Infobereichs';
$string['learningpath:path'] = 'Pfad';
$string['learningpathfinish'] = 'Ende';
$string['learningpathstart'] = 'Start';
$string['leftbottom'] = 'Links unten';
$string['leftcenter'] = 'Links halbe Höhe';
$string['lefttop'] = 'Links oben';
$string['like_item'] = 'Gleichgroß wie';
$string['like_item_help'] = 'Detailbereich auf die gleiche Größe wie die Karte setzen.';
$string['loggedinuser'] = 'Eingeloggte Nutzer/innen';
$string['loginstreakdays'] = 'Tage hintereinander angemeldet';
$string['loginstreakdaysdesc'] = 'Anzahl aufeinanderfolgender Tage festlegen, die für das Halten der Serie erforderlich sind.';
$string['lowerthan'] = 'Niedriger als';
$string['magicnotavailable'] = 'Die Magic-Authentifizierung ist für diese Plattform nicht verfügbar.';
$string['maindashboard'] = 'Hauptdashboard';
$string['maintable'] = 'Haupttabelle <b>(mnt)</b> auswählen';
$string['maintable_help'] = 'Wählen Sie die Haupttabelle für die Erzeugung der Felder';
$string['maintablenotconfigured'] = 'Die Haupttabelle ist nicht als Entwicklerdatenquelle konfiguriert';
$string['managecapabilitymissing'] = 'Erforderliche Fähigkeit „moodle/competency:competencymanage“ für den Zugriff auf die Seite fehlt.';
$string['managecompentency'] = 'Aussehen von Kompetenzen verwalten';
$string['managecustomdatasources'] = 'Nutzerdefinierte Datenquellen verwalten';
$string['managedashaddonplugins'] = 'Addons verwalten';
$string['managedashboards'] = 'Dashboards verwalten';
$string['managedatasources'] = 'Datenquellen verwalten';
$string['managelayouts'] = 'Layouts verwalten';
$string['masonrycustomfield'] = 'Dash Einstellungen';
$string['max'] = 'Max';
$string['maxlimit'] = 'Begrenzen auf';
$string['maxlimit_help'] = 'Höchstgrenze der angezeigten Abfrageergebnisse';
$string['mediumimage'] = 'Mittelgroßes Bild';
$string['menu'] = 'Menüreihenfolge';
$string['messageurl'] = 'Nachrichten-URL';
$string['minheight'] = 'Mindesthöhe';
$string['minheight_help'] = 'Mindesthöhe für den Block in Pixeln.';
$string['missingdatasource'] = 'Die Datenquellen fehlen. Bitte überprüfen Sie diese.';
$string['missingmustachetemplate'] = 'Fehlende Mustache-Vorlage.';
$string['mobile_learningpath'] = 'Lernpfad für Mobile';
$string['mobile_learningpath_desc'] = 'Beschreibung Lernpfad (Mobilgeräte)';
$string['modifieddate'] = 'Zuletzt geändert';
$string['modulecontext'] = 'Module';
$string['modulename'] = 'Modulname';
$string['mustachetemplate'] = 'Mustache-Template';
$string['mydashboards'] = 'Meine Dashboards';
$string['myenrolledcourses'] = 'Kurse, in die ich eingeschrieben bin';
$string['myparticipants'] = 'Meine Teilnehmer/innen';
$string['myprofiletable'] = 'Profil';
$string['myskills'] = 'Meine Skills';
$string['newblock'] = 'Neuer Dash';
$string['nextlevelpoints'] = 'Punkte bis zum nächsten Level';
$string['nextlevelstr'] = '{$a->points} Punkte, um {$a->name} zu erreichen';
$string['nocampaignsareavailable'] = 'Keine Kampagnen verfügbar';
$string['nocategoryselected'] = 'Keine Kategorie ausgewählt';
$string['nocontactsavailable'] = 'Keine Kontakte verfügbar';
$string['nocourselearnigpath'] = 'Es wurden noch keine Kurse zum Lernpfad hinzugefügt.';
$string['nocourses'] = 'Keine Kurse verfügbar';
$string['nocourseselected'] = 'Kein Kurs ausgewählt';
$string['nodashboardsforuser'] = 'Derzeit sind keine Dashboards verfügbar.';
$string['nogroupsavailable'] = 'Keine Gruppen verfügbar';
$string['none'] = 'Keine';
$string['nonpublicdashboards'] = 'Öffentliche Dashboards ausblenden';
$string['notachieved'] = 'Nicht erreicht';
$string['notauthorized'] = 'Sie haben keinen Zugriff auf dieses Dashboard.';
$string['notavailable'] = 'Nicht verfügbar';
$string['oneormoreblocks'] = 'Das Dashboard erfordert mehr als einen Block.';
$string['onlywhensticky'] = 'Nur bei Fixierung';
$string['onpagenavigation'] = 'Onpage-Navigation';
$string['openmodule'] = 'Offenes Modul';
$string['operator'] = 'Operator';
$string['operatorcondition'] = 'Bedingung';
$string['operatorcondition_help'] = 'Verknüpfungsoperator – Wählen Sie zwischen „AND“ und „OR“, um festzulegen, wie mehrere Bedingungen kombiniert werden. „AND“ bedeutet, dass alle Bedingungen erfüllt sein müssen. „OR“ bedeutet, dass mindestens eine Bedingung erfüllt sein muss.';
$string['operatorequal'] = '=';
$string['operatorgreaterthan'] = '>';
$string['operatorgreaterthanequal'] = '>=';
$string['operatorin'] = 'IN (...)';
$string['operatorinquery'] = 'IN (Query)';
$string['operatorlessthan'] = '<';
$string['operatorlessthanequal'] = '<=';
$string['operatorlike'] = 'LIKE';
$string['operatorlikebetween'] = 'LIKE %..%';
$string['operatornotequal'] = '!=';
$string['operatornotin'] = 'NOT IN (...)';
$string['operatornotlike'] = 'NOT LIKE';
$string['originalrolename'] = 'Ursprünglicher Name';
$string['otheraddons'] = 'Andere Addons';
$string['pagination_summary'] = 'Zeigt {$a->limit_from} - {$a->limit_to} von {$a->total}';
$string['parent'] = 'Elternelement';
$string['parseerror'] = 'Parse-Fehler. Der Inhalt kann nicht angezeigt werden.';
$string['participationnotcurrent'] = 'Nicht aktuell';
$string['passed'] = 'Bestanden';
$string['permissions'] = 'Zugang einschränken auf';
$string['permissionscohort'] = 'Globale Gruppe';
$string['permissionsloggedin'] = 'Anmeldung erforderlich';
$string['permissionspublic'] = 'Öffentlich';
$string['permissionsrole'] = 'Rolle';
$string['permissionsrolecontext'] = 'Rollenkontext';
$string['permissionsrolecontext_help'] = 'Kontext auswählen, in dem die Rolle der Nutzer/innen geprüft werden soll (beliebiger Kontext oder nur Systemkontext).';
$string['perpage'] = 'Pro Seite';
$string['perpage_help'] = 'Anzahl der Karten, die im Raster pro Seite angezeigt werden sollen.';
$string['persistenttablealias'] = 'Haupttabelle der nutzerdefinierten Quelle';
$string['pictureofuserlinked'] = 'Nutzerbild mit Link zum Profil';
$string['pictureofuserurl'] = 'Nutzerbild-URL';
$string['placeholderfields'] = 'Platzhalterfelder';
$string['placeholderfields_help'] = 'Wählen Sie die Felder aus und verwenden Sie diese Felder im Feld zusätzliche benutzerdefinierte Werte mit {feldname}, diese werden durch die entsprechenden Werte ersetzt.';
$string['pluginname'] = 'Dash';
$string['privacy:metadata'] = 'Der Dash-Block zeigt nur Informationen zu Kursen an und speichert selbst keine Daten.';
$string['proficient'] = 'Kompetent';
$string['programbg'] = 'Bild für Einschreibungsprogramm';
$string['programbg_desc'] = 'Beschreibung Programm-Hintergrund';
$string['programimagelink'] = 'Programmbild mit Link';
$string['programs:view'] = 'Programme anzeigen';
$string['progress_help'] = 'Den Abschlussfortschritt des Kurses anzeigen';
$string['promotionoptions'] = 'Hervorgehoben / Normal / Abgeblendet';
$string['querydebug'] = 'Abfrage-Debug';
$string['querytemplate'] = 'Abfragevorlage';
$string['querytemplate_help'] = 'Diese Abfrage wird verwendet, um …';
$string['querytemplateinstructions'] = 'Platzhalter: <ul><li><b>%%SELECT%%</b> – Ersetzt durch alle Selects basierend auf Felddefinitionen. Fügen Sie keine eigenen Selects ein!</li><li><b>%%WHERE%%</b> – Ersetzt durch aus Filtern generierte Klauseln. Sie können problemlos weitere Klauseln hinzufügen, indem Sie nach %%WHERE%% ein AND anhängen.</li><li><b>%%GROUPBY%%</b> – Ersetzt durch Gruppierungsfelder abhängig von der Datenquelle.</li><li><b>%%ORDERBY%%</b> – Ersetzt durch Standardsortierung oder nutzerdefinierte Sortierung (z.B. durch Klicken auf die Spaltenüberschrift in einer Tabelle).</li></ul>';
$string['querytemplatetip'] = 'Tipp: Strg + Leertaste drücken, um beim Schreiben der Abfrage Intellisense/Autovervollständigung anzuzeigen.';
$string['readymatewidgets'] = 'Einsatzbereite Widgets';
$string['readymatewidgets_help'] = 'Verwenden Sie die untenstehenden Widgets. Widgets sind einfach zu verwenden, es müssen keine zusätzlichen Konfigurationen vorgenommen werden.';
$string['recentcoursename'] = 'Aktueller Kurs';
$string['redirecttodashboard'] = 'Zum Dashboard weiterleiten';
$string['relations'] = 'Beziehungen';
$string['relations_help'] = 'Beinhaltet Nutzer/innen mit bestimmten Rollen (z.B. Mentor/in, Elternteil, Vorgesetzte/r, Coach).';
$string['restrict_operator'] = 'Operator';
$string['restrictaccess'] = 'Zugang einschränken';
$string['restrictaccessheading'] = 'Zugang einschränken';
$string['restrictbyactivitycompletion'] = 'Auf Aktivitätsabschlussstatus einschränken';
$string['restrictbyactivitycompletion_help'] = 'Mit dieser Einstellung lässt sich die Sichtbarkeit von Inhalten basierend auf dem Abschlussstatus der gewählten Aktivitäten steuern. <br><b>Nicht abgeschlossen:</b> Block ist nur sichtbar für Nutzer/innen, die nicht alle ausgewählten Aktivitäten abgeschlossen haben.<br><b>Abgeschlossen:</b> Block ist nur sichtbar für Nutzer/innen, die alle ausgewählten Aktivitäten abgeschlossen haben.<br><b>Bestanden:</b> Block ist nur sichtbar für Nutzer/innen, die alle ausgewählten Aktivitäten abgeschlossen und die Bestehensnote erreicht haben.<br><b>Nicht bestanden:</b> Block ist nur sichtbar für Nutzer/innen, die zwar alle Aktivitäten abgeschlossen, aber die Bestehensnote in mindestens einer nicht erreicht haben.';
$string['restrictbycohort'] = 'Auf globale Gruppen einschränken';
$string['restrictbycohort_help'] = 'Steuert die Sichtbarkeit von Inhalten basierend auf der Kohortenzugehörigkeit der Nutzer/innen. Nur Mitglieder/innen der angegebenen Kohorten sehen den Inhalt.';
$string['restrictbycoursecompletion'] = 'Auf Kursabschlussstatus einschränken';
$string['restrictbycoursecompletion_help'] = 'Steuert die Sichtbarkeit von Inhalten basierend auf Einschreibung und Fortschritt im Kurs.<br><b>Nicht eingeschrieben:</b> Sichtbar nur für Nutzer/innen ohne Einschreibung (z. B. Gäste).<br><b>Eingeschrieben:</b> Sichtbar nur für eingeschriebene Nutzer/innen ohne Aktivitätsabschluss.<br><b>Laufend:</b> Sichtbar nur für eingeschriebene Nutzer/innen mit mindestens einem Aktivitätsabschluss.<br><b>Abgeschlossen:</b> Sichtbar nur für eingeschriebene Nutzer/innen, die alle erforderlichen Aktivitäten abgeschlossen haben.';
$string['restrictbygrade'] = 'Auf Kursbewertung einschränken';
$string['restrictbygrade_help'] = 'Mit dieser Einstellung können Sie die Sichtbarkeit von Inhalten basierend auf der Kursbewertung einer Person im aktuellen Kurs steuern. Der Block ist nur sichtbar, wenn die Kursnote einer Person innerhalb des angegebenen Bereichs liegt.';
$string['restrictbygroup'] = 'Auf Kursgruppen einschränken';
$string['restrictbygroup_help'] = 'Mit dieser Einstellung können Sie die Sichtbarkeit von Inhalten basierend auf der Gruppenmitgliedschaft einer Person im aktuellen Kurs steuern. Nur Teilnehmer/innen, die Teil der ausgewählten Gruppen sind, können die Inhalte sehen.';
$string['restrictbyrole'] = 'Auf Rollen einschränken';
$string['restrictbyrole_help'] = 'Mit dieser Einstellung können Sie die Sichtbarkeit von Inhalten basierend auf der Rolle einer Person im aktuellen Kurs steuern. Nur Teilnehmer/innen, die die ausgewählten Rollen haben, können die Inhalte sehen.';
$string['restrictcurrentsection'] = 'Automatisch auf den aktuellen Abschnitt beschränken';
$string['restrictcurrentsection_desc'] = 'Wenn ein Dash-Block mit dem Content-Addon zu einer Seite mit einem Abschnitt hinzugefügt wird, wird er automatisch auf diesen Abschnitt beschränkt.';
$string['restrictrolecontext'] = 'Kontext';
$string['restrictrolecontext_help'] = 'Kontext auswählen, in dem die Rolle der Nutzer/innen geprüft wird (beliebiger Kontext oder nur Systemkontext).';
$string['resumecourse'] = 'Kurs fortsetzen';
$string['resumelearningpath'] = 'Lernpfad fortsetzen';
$string['rightbottom'] = 'Rechts unten';
$string['rightcenter'] = 'Rechts halbe Höhe';
$string['righttop'] = 'Rechts oben';
$string['role_assignments'] = 'Rollenzuweisungen';
$string['rolename'] = 'Rollenname';
$string['rows'] = 'Zeilen';
$string['rows_help'] = 'Anzahl der anzuzeigenden Zeilen bei Nutzung der Option slidesPerRow.';
$string['savechanges'] = 'Änderungen speichern';
$string['secondarynav'] = 'Zur Kursnavigation hinzufügen';
$string['selectactivity'] = 'Aktivität auswählen';
$string['selectactivity_help'] = 'Aktivität auswählen, deren Abschlussstatus geprüft werden soll.';
$string['selectcampaign'] = 'Kampagne auswählen';
$string['selectcategory'] = 'Kategorie auswählen';
$string['selectcourse'] = 'Kurs auswählen';
$string['selectlayout'] = 'Inhaltslayout in den Einstellungen wählen, um Inhalte hinzuzufügen';
$string['selfallocationwithkey'] = 'Anmeldeschlüssel erforderlich';
$string['setup'] = 'Setup';
$string['shopurl'] = 'Shop-URL';
$string['showheader'] = 'Header anzeigen';
$string['showheader_help'] = 'Den Blocktitel ausblenden, wenn Bearbeiten ausgeschaltet ist.';
$string['showhiddencourses'] = 'Verborgene Kurse anzeigen';
$string['skills'] = 'Skills';
$string['slidesPerRow'] = 'Folien pro Zeile';
$string['slidesPerRow_help'] = 'Anzahl der Folien pro Zeile.';
$string['slidesToScroll'] = 'Zu scrollende Folien';
$string['slidesToScroll_help'] = 'Anzahl der Folien, die gleichzeitig gescrollt werden.';
$string['slidesToShow'] = 'Anzuzeigende Folien';
$string['slidesToShow_help'] = 'Anzahl der Folien, die gleichzeitig angezeigt werden.';
$string['smallimage'] = 'Kleines Bild';
$string['smart_coursebutton'] = 'Smart Kursbutton';
$string['sortalpha'] = 'Alphabetisch';
$string['sortcoursestartdate'] = 'Kursbeginn';
$string['sortenrolmentdate'] = 'Datum der Einschreibung';
$string['source'] = 'Quelle';
$string['speed'] = 'Übergangsgeschwindigkeit (ms)';
$string['speed_help'] = 'Geschwindigkeit des Folienübergangs in Millisekunden festlegen.';
$string['startcourse'] = 'Kurs starten';
$string['stattodisplay'] = 'Anzuzeigende Kennzahl';
$string['stattodisplayother'] = 'Weitere anzuzeigende Kennzahl';
$string['status'] = 'Status';
$string['status:all'] = 'Alle';
$string['status:completed'] = 'Abgeschlossen';
$string['status:enrolled'] = 'Eingeschrieben';
$string['status:inprogress'] = 'In Bearbeitung';
$string['status:notcompleted'] = 'Nicht abgeschlossen';
$string['status:notenrolled'] = 'Nicht eingeschrieben';
$string['status:notyetstarted'] = 'Noch nicht begonnen';
$string['strasc'] = 'Aufsteigend';
$string['strcssclass'] = 'CSS-Klassen';
$string['strctacampaign'] = 'Registrierung';
$string['strctaenrolment'] = 'Einschreibeseite ansehen';
$string['strcustom'] = 'Nutzerdefiniert';
$string['strcustomurl'] = 'URL anzeigen';
$string['strdatasource'] = 'datasource';
$string['strdesc'] = 'Absteigend';
$string['strdisabled'] = 'Deaktiviert';
$string['strexpanding'] = 'Aufklappend';
$string['strfloating'] = 'Schwebend';
$string['strgrid'] = 'Raster';
$string['strgridsize'] = 'Rastergröße';
$string['strinfo'] = 'Info';
$string['strmasonry'] = 'Mauerwerk-Layout';
$string['strmasonrysearch'] = 'Suchfeld';
$string['strmasonrysort'] = 'Sortierung';
$string['strmodal'] = 'Modal';
$string['strpromotion'] = 'Hervorhebung';
$string['strrole'] = 'Rolle';
$string['strshopurl'] = 'Shop anzeigen';
$string['strslider'] = 'Slider';
$string['styleoptions'] = 'Stil-Optionen';
$string['styleoptions_help'] = 'Um individuelle Stile auf Elemente anzuwenden, können Sie nutzerdefinierte Felder verwenden. Wählen Sie die nutzerdefinierten Felder aus, die Sie als CSS-Klasse auf ein Rasterelement anwenden möchten. Hinweis: Sie müssen die CSS-Stile selbst erstellen, Dash verfügt nicht über vordefinierte CSS-Stile (wir planen jedoch, diese in der nächsten Version hinzuzufügen).';
$string['subheadingfield'] = 'Dachzeilenfeld';
$string['subheadingfieldicon'] = 'Unterüberschrift-Symbol';
$string['suggestcohort'] = 'Nutzer/innen vorschlagen, die in derselben globalen Gruppen sind';
$string['suggestcohort_desc'] = 'Block mit Nutzer/innen-Kontaktliste anzeigen, die gleiche Interessen haben';
$string['suggestcontacts'] = 'Vorgeschlagene Kontakte';
$string['suggestgroups'] = 'Nutzer/innen vorschlagen, die in denselben Gruppen sind';
$string['suggestgroups_desc'] = 'Block mit Nutzer/innen-Kontaktliste anzeigen, die gleiche Interessen haben';
$string['suggestinterests'] = 'Nutzer/innen vorschlagen, welche die gleichen Interessen haben';
$string['suggestinterests_desc'] = 'Block mit Nutzer/innen-Kontaktliste anzeigen, die gleiche Interessen haben';
$string['suggestion:cohort'] = 'Auch Mitglied von {$a->cohort}';
$string['suggestion:groups'] = 'In Ihrer Gruppe {$a->group}';
$string['suggestion:interest'] = 'Auch interessiert an {$a->interest}';
$string['suggestion:users'] = 'Empfohlen auf dieser Seite';
$string['suggestusers'] = 'Nutzer/innen mit gleichen Interessen vorschlagen';
$string['suggestusers_desc'] = 'Block mit Nutzer/innen-Kontaktliste anzeigen, die gleiche Interessen haben';
$string['supportsfieldvisibility'] = 'Sichtbarkeit der Unterstützungsfelder';
$string['supportsfieldvisibility_help'] = 'Wenn diese Option aktiviert ist, können Administrator/innen Felder bedingt aktivieren und deaktivieren.';
$string['supportsfiltering'] = 'Unterstützt Filterung';
$string['supportsfiltering_help'] = 'Wenn diese Option aktiviert ist, ist das Filtern der Ergebnisse möglich. Dies wird von der Datenquelle übernommen.';
$string['supportspagination'] = 'Unterstützt Seitennummerierung';
$string['supportspagination_help'] = 'Wenn diese Option aktiviert ist, werden die Ergebnisse automatisch paginiert. Eine Paginierungsleiste wird angezeigt.';
$string['supportssorting'] = 'Unterstützt Sortierung';
$string['supportssorting_help'] = 'Wenn diese Option aktiviert ist, ist Sortieren möglich (nur bei Tabellen).';
$string['swipeToSlide'] = 'Per Wischgeste zur Folie';
$string['swipeToSlide_help'] = 'Ermöglicht Wischen/Ziehen zur nächstgelegenen Folie nach Loslassen.';
$string['system'] = 'System';
$string['systemcontext'] = 'System';
$string['tabconditions'] = 'Bedingungen';
$string['tabfields'] = 'Felder';
$string['tabfilters'] = 'Filter';
$string['tabgeneral'] = 'Allgemein';
$string['tablealias_c'] = 'Kurs';
$string['tablealias_cc'] = 'Kursbereich';
$string['tablealias_ccp'] = 'Kursabschluss';
$string['tablealias_ctx'] = 'Kontext';
$string['tablealias_dd'] = 'Dashboard';
$string['tablealias_e'] = 'Einschreibemethode';
$string['tablealias_g'] = 'Gruppe';
$string['tablealias_r'] = 'Rolle';
$string['tablealias_ra'] = 'Rollenzuweisung';
$string['tablealias_sl'] = 'Logdaten der Website';
$string['tablealias_tsk'] = 'Skills';
$string['tablealias_u'] = 'Nutzer/in';
$string['tablealias_ue'] = 'Nutzereinschreibung';
$string['tablejoin'] = 'Join-Tabelle auswählen';
$string['tablejoin_help'] = 'Tabelle auswählen, die mit der Haupttabelle verknüpft werden soll. Alias für Bedingungen verwenden.';
$string['tablejoinon'] = 'Bedingungsabfrage für die Verknüpfung eingeben';
$string['tablejoinsalias'] = 'Tabellenalias';
$string['tablejoinshdr'] = 'Tabellen verbinden';
$string['tablejoinstatichdr'] = 'Verknüpfte Tabelle #{$a}';
$string['tablet_learningpath'] = 'Lernpfad für Tablet';
$string['tablet_learningpath_desc'] = 'Beschreibung Lernpfad-Tabelle';
$string['tags'] = 'Tags';
$string['textcolor'] = 'Textfarbe';
$string['timemodified'] = 'Geändert um';
$string['timesinceevent'] = 'Zeit seit dem Termin';
$string['tinyimage'] = 'Extrakleines Bild';
$string['titleoverride'] = 'Titelüberschreibung';
$string['totalactivities'] = 'Aktivitäten insgesamt';
$string['totalactivitiescompletion'] = 'Aktivitäten insgesamt (abschlussrelevant)';
$string['totallevelpoints'] = 'Gesamtpunkte für Level';
$string['totalpoints'] = 'Punkte insgesamt';
$string['totalprogress'] = 'Fortschritt insgesamt';
$string['transformformat'] = 'Format von {$a} transformieren';
$string['trialpath'] = 'Testversion';
$string['usercontext'] = 'Nutzer/in';
$string['userprofilelink'] = 'Link zum Profil';
$string['userprofileurl'] = 'Nutzerprofil-URL';
$string['users'] = 'Nutzer/innen';
$string['users_help'] = 'Datenquelle zeigt die Liste der verfügbaren Nutzer/innen aus dem LMS';
$string['users_mycohort'] = 'Nutzer/innen in einer meiner globalen Gruppen';
$string['userscompleted'] = 'Nutzer/innen abgeschlossen';
$string['usersnotcompleted'] = 'Nutzer/innen nicht abgeschlossen';
$string['userstat'] = 'Nutzer/innen-Statistik';
$string['variableWidth'] = 'Variable Breite';
$string['variableWidth_help'] = 'Aktiviert Folien mit variabler Breite.';
$string['vertical'] = 'Vertikal';
$string['verticalSwiping'] = 'Vertikales Wischen';
$string['verticalSwiping_help'] = 'Ermöglicht vertikales Wischen/Ziehen von Folien.';
$string['vertical_help'] = 'Vertikale Ausrichtung der Folien.';
$string['viewactivity'] = 'Aktivität ansehen';
$string['viewcourse'] = 'Zum Kurs';
$string['viewdetails'] = 'Details ansehen';
$string['viewprofile'] = 'Profile ansehen';
$string['viewprogram'] = 'Programm anzeigen';
$string['widget'] = 'Widget';
$string['widget:course_completions'] = 'Kursabschlüsse';
$string['widget:course_completions_help'] = 'Kursfortschrittsbericht';
$string['widget:course_enrols'] = 'Einschreibewidgets';
$string['widget:course_enrols_help'] = 'Liste der eingeschriebenen Kurse mit Abschlussfortschritt anzeigen';
$string['widget:course_sections'] = 'Kursabschnitte';
$string['widget:course_sections_help'] = 'Verwenden Sie dieses Widget, um mühelos mit Ihren Kursabschnitten zu interagieren.';
$string['widget:groups:adduser'] = 'Nutzer/in hinzufügen';
$string['widget:groups:chat'] = 'Chat';
$string['widget:groups:creategroup'] = 'Gruppe erstellen';
$string['widget:groups:groupmembers'] = 'Mitglieder ansehen';
$string['widget:groups:leavegroup'] = 'Gruppe verlassen';
$string['widget:learningpath'] = 'Lernpfad';
$string['widget:learningpath_help'] = 'Liste der im Lernpfad verfügbaren Kurse.';
$string['widget:mycontacts'] = 'Meine Kontakte';
$string['widget:mycontacts_help'] = 'Liste verfügbarer Nutzer/innen in der Kontaktliste.';
$string['widget:mygroups'] = 'Meine Gruppen';
$string['widget:mygroups_help'] = 'Liste der zugewiesenen Gruppen für die/den Nutzer/in. Ermöglicht, andere Gruppenmitglieder anzuzeigen, Mitglieder hinzuzufügen, Gruppen zu verlassen und mehr.';
$string['widget:mylearning'] = 'Mein Lernstand';
$string['widget:mylearning_help'] = 'Liste der Kurse, die registrierte Nutzer/innen haben, mit grundlegenden Kursinformationen wie Trainer/innen und verfügbaren Badges sowie einer Liste der Kursabschnitte und -module';
$string['widget:myprofile'] = 'Mein Profil';
$string['widget:myprofile_help'] = 'Informationen zum Nutzer/innenprofil mit wichtigen KPIs anzeigen';
$string['widget:skill_graph'] = 'Kompetenzdiagramm';
$string['widget:skill_graph_help'] = 'Bericht zur Aufschlüsselung von Kompetenzen';
$string['widget:skilllevelvisuals'] = 'Visualisierung von Kompetenzstufen';
$string['widget:skilllevelvisuals_help'] = 'Stufen der gewählten Kompetenz als Bilder anzeigen.';
$string['widget:skillprogress'] = 'Kompetenzfortschritt';
$string['widget:skillprogress_help'] = 'Kompetenzfortschritt zeigt den Gesamtfortschritt der Nutzer/innen in allen gewählten Kompetenzen, einschließlich aktuellem Level und Punkten pro Kompetenz.';
$string['widgetsdesc'] = 'Ein einsatzbereites Inhalts-Widget auswählen und konfigurieren';
$string['withroles'] = 'Mit Rollen';
$string['yourcurrentlevel'] = 'Ihr aktuelles Level';
