<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'workshop', language 'lt', version '4.5'.
 *
 * @package     workshop
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activitydate:assessmentsclose'] = 'Vertinimai uždaromi:';
$string['activitydate:assessmentsclosed'] = 'Vertinimai uždaromi:';
$string['activitydate:assessmentsopen'] = 'Vertinimai atidaromi:';
$string['activitydate:assessmentsopened'] = 'Vertinimai atidaromi:';
$string['activitydate:submissionsclose'] = 'Pateikimai uždaromi:';
$string['activitydate:submissionsclosed'] = 'Pateikimai uždaromi:';
$string['activitydate:submissionsopen'] = 'Pateikimai atidaromi:';
$string['activitydate:submissionsopened'] = 'Pateikimai atidaromi:';
$string['aggregategrades'] = 'Perskaičiuoti įvertinimus';
$string['aggregation'] = 'Įvertinimų agregavimas';
$string['allocate'] = 'Priskirti pateiktą turinį';
$string['allocatedetails'] = 'numatyta: {$a->expected}<br />pateikta: {$a->submitted}<br />priskirtina: {$a->allocate}';
$string['allocation'] = 'Pateikto turinio priskyrimas';
$string['allocationconfigured'] = 'Paskirstymas sukonfigūruotas';
$string['allocationdone'] = 'Atliktas priskyrimas';
$string['allocationerror'] = 'Priskyrimo klaida';
$string['allowedfiletypesforoverallfeedback'] = 'Leidžiami grįžtamojo ryšio failų tipai';
$string['allowedfiletypesforoverallfeedback_help'] = 'Leidžiami grįžtamojo ryšio failų tipų pateikimai gali būti apriboti, įvedant leidžiamų failų tipų sąrašą. Jei laukas paliekamas tuščias, visi failų tipai yra leidžiami.';
$string['allowedfiletypesforoverallfeedback_link'] = 'admin/tool/filetypes/index';
$string['allowedfiletypesforsubmission'] = 'Leidžiami pateikiamų failų tipai';
$string['allowedfiletypesforsubmission_help'] = 'Leidžiami pateikiamų failų tipai gali būti apribojami įvedant leidžiamų failų plėtinių sąrašą. Jei laukas paliktas tuščias, tada visi failų tipai yra leidžiami.';
$string['allowedfiletypesforsubmission_link'] = 'admin/tool/filetypes/index';
$string['allsubmissions'] = 'Visi pateikimai ({$a})';
$string['alreadygraded'] = 'Jau įvertinta';
$string['areaconclusion'] = 'Išvados tekstas';
$string['areainstructauthors'] = 'Pateikimo instrukcijos';
$string['areainstructreviewers'] = 'Įvertinimo instrukcijos';
$string['areaoverallfeedbackattachment'] = 'Bendras grįžtamasis ryšio failas';
$string['areaoverallfeedbackcontent'] = 'Bendras grįžtamojo ryšio tekstas';
$string['areasubmissionattachment'] = 'Pateikto turinio priedai';
$string['areasubmissioncontent'] = 'Pateikto turinio tekstai';
$string['assess'] = 'Įvertinti';
$string['assessedexample'] = 'Įvertinto pateikto turinio pavyzdys';
$string['assessedsubmission'] = 'Įvertintas pateikimas';
$string['assessingexample'] = 'Pateikto turinio įvertinimo pavyzdys';
$string['assessingsubmission'] = 'Pateikto turinio įvertinimas';
$string['assessment'] = 'Įvertinimas';
$string['assessmentby'] = 'pagal <a href="{$a->url}">{$a->name}</a>';
$string['assessmentbyfullname'] = 'Įvertinimas pagal {$a}';
$string['assessmentbyyourself'] = 'Jūsų pačių įvertinimas';
$string['assessmentdeleted'] = 'Panaikintas įvertinimo priskyrimas';
$string['assessmentend'] = 'Įvertinimo terminas';
$string['assessmentendbeforestart'] = 'Įvertinimo galutinis terminas negali būti ankstesnis nei įvertinimo atidarymo data';
$string['assessmentenddatetime'] = 'Įvertinimo terminas: {$a->daydatetime} ({$a->distanceday})';
$string['assessmentendevent'] = '{$a} vertinimo terminas';
$string['assessmentform'] = 'Vertinimo forma';
$string['assessmentofsubmission'] = '<a href="{$a->submissionurl}">{$a->submissiontitle}</a> <a href="{$a->assessmenturl}">įvertinimas</a>';
$string['assessmentreference'] = 'Įvertinimo pavyzdys';
$string['assessmentreferenceconflict'] = 'Neįmanoma įvertinti pavyzdinį pateikimą kuriam jūs davėte nuorodos įvertinimą';
$string['assessmentreferenceneeded'] = 'Turite įvertinti šį pateikto turinio pavyzdį, kad pateiktumėte įvertinimo pavyzdį. Norėdami įvertinti pateiktą turinį spustelėkite mygtuką Tęsti.';
$string['assessments'] = 'Vertinimai';
$string['assessmentsettings'] = 'Vertinimo parametrai';
$string['assessmentstart'] = 'Galima vertinti nuo';
$string['assessmentstartdatetime'] = 'Galima įvertinti nuo {$a->daydatetime} ({$a->distanceday})';
$string['assessmentstartevent'] = '{$a} galima vertinti';
$string['assessmentweight'] = 'Vertinimo svarba';
$string['assignedassessments'] = 'Vertinti priskirtas pateikimas';
$string['assignedassessmentsnone'] = 'Jūs neturite priskirto pateikimo įvertinimui';
$string['backtoeditform'] = 'Grįžti į redagavimo formą';
$string['byfullname'] = '<a href="{$a->url}">{$a->name}</a>';
$string['byfullnamewithoutlink'] = '{$a}';
$string['calculategradinggrades'] = 'Skaičiuoti bendrus įvertinimus';
$string['calculategradinggradesdetails'] = 'numatyta: {$a->expected}<br />apskaičiuota: {$a->calculated}';
$string['calculatesubmissiongrades'] = 'Skaičiuoti pateikimo įvertinimus';
$string['calculatesubmissiongradesdetails'] = 'numatyta: {$a->expected}<br />apskaičiuota: {$a->calculated}';
$string['chooseuser'] = 'Pasirinkti naudotoją...';
$string['clearaggregatedgrades'] = 'Valyti visus agreguotus įvertinimus';
$string['clearaggregatedgrades_help'] = 'Agreguoti pateikto turinio įvertinimai ir bendri įvertinimai bus nustatyti iš naujo. Galėsite iš naujo perskaičiuoti šiuos įvertinimus įvertinimų pateikimo etape.';
$string['clearaggregatedgradesconfirm'] = 'Ar tikrai norite išvalyti apskaičiuotus pateikimo ir įvertinimo įvertinimus?';
$string['clearassessments'] = 'Valyti įvertinimus';
$string['clearassessments_help'] = 'Bus iš naujo nustatyti apskaičiuoti pateikto turinio įverčiai ir bendri įverčiai. Informacija apie užpildytas įvertinimo formas išlieka, bet visi peržiūrėtojai turi iš naujo atidaryti įvertinimo formą ir ją pakartotinai įrašyti, kad vėl būtų apskaičiuoti pateikti įverčiai.';
$string['clearassessmentsconfirm'] = 'Ar tikrai norite valyti visus įvertinimus? Nebegalėsite patys vėl susigrąžinti šios informacijos ir recencentams reikės iš naujo įvertinti priskirtus darbus.';
$string['conclusion'] = 'Išvada';
$string['conclusion_help'] = 'Išvados tekstas bus rodomas dalyviams veiklos pabaigoje.';
$string['configexamplesmode'] = 'Numatytasis pavyzdžių įvertinimo režimas seminaruose';
$string['configgrade'] = 'Numatytasis maksimalus pateikto turinio įvertinimas seminaruose';
$string['configgradedecimals'] = 'Numatytasis skaitmenų skaičius po kablelio, kai rodomi įvertinimai.';
$string['configgradinggrade'] = 'Numatytasis maksimalus įvertinimas už vertinimą seminaruose';
$string['configmaxbytes'] = 'Numatytasis maksimalus visų svetainės seminarų pateikiamo failo dydis (priklauso nuo kursų apribojimų ir kitų vietinių parametrų)';
$string['configstrategy'] = 'Numatytoji seminarų įvertinimo strategija';
$string['createsubmission'] = 'Pridėti pateikimą';
$string['crontask'] = 'Fono apdorojimas seminaro moduliui';
$string['daysago'] = 'Prieš {$a} d.';
$string['daysleft'] = 'Liko {$a} d.';
$string['daystoday'] = 'šiandien';
$string['daystomorrow'] = 'rytoj';
$string['daysyesterday'] = 'vakar';
$string['deadlinesignored'] = 'Laiko apribojimas jums negalioja';
$string['deletesubmission'] = 'Ištrinti pateikimą';
$string['editassessmentform'] = 'Redaguoti įvertinimo formą';
$string['editassessmentformstrategy'] = 'Redaguoti įvertinimo formą ({$a})';
$string['editingassessmentform'] = 'Įvertinimo formos redagavimas';
$string['editingsubmission'] = 'Pateikto turinio redagavimas';
$string['editsubmission'] = 'Redaguoti pateiktą turinį';
$string['err_multiplesubmissions'] = 'Redaguojant šią formą įrašyta kita pateikto turinio versija. Vienam naudotojui neleidžiama pateikti kelis kartus.';
$string['err_removegrademappings'] = 'Negalima pašalinti nenaudojamų įvertinimų susiejimų';
$string['evaluategradeswait'] = 'Palaukite, kol atliekamas vertinimas ir apskaičiuojami įvertinimai';
$string['evaluation'] = 'Įvertinimų pateikimas';
$string['evaluationmethod'] = 'Įvertinimų pateikimo metodas';
$string['evaluationmethod_help'] = 'Įvertinimų pateikimo metodas nurodo, kaip apskaičiuojamas įvertinimas už vertinimą. Kol kas galimas vienas būdas – lyginimas su geriausiu įvertinimu.';
$string['evaluationsettings'] = 'Įvertinimų pateikimo parametrai';
$string['eventassessableuploaded'] = 'Pateikimas buvo įkeltas.';
$string['eventassessmentevaluated'] = 'Įvertinimas pateiktas';
$string['eventassessmentevaluationsreset'] = 'Įvertinimą pateikti iš naujo';
$string['eventassessmentreevaluated'] = 'Įvertinimas iš naujo pateiktas';
$string['eventphaseautomaticallyswitched'] = 'Etapas perjungiamas automatiškai';
$string['eventphaseswitched'] = 'Etapas perjungtas';
$string['eventsubmissionassessed'] = 'Pateikimas įvertintas';
$string['eventsubmissionassessmentsreset'] = 'Pateikimo įvertinimas išvalytas';
$string['eventsubmissioncreated'] = 'Pateikimas sukurtas';
$string['eventsubmissiondeleted'] = 'Pateikimas ištrintas';
$string['eventsubmissionreassessed'] = 'Pateikimas įvertintas iš naujo';
$string['eventsubmissionupdated'] = 'Pateikimas atnaujintas';
$string['eventsubmissionviewed'] = 'Pateikimas peržiūrėtas';
$string['example'] = 'Pateikto turinio pavyzdys';
$string['exampleadd'] = 'Įtraukti pateikto turinio pavyzdį';
$string['exampleassess'] = 'Įvertinti pateikto turinio pavyzdį';
$string['exampleassessments'] = 'Įvertinti skirtas pateikto turinio pavyzdys';
$string['exampleassesstask'] = 'Įvertinti pavyzdžius';
$string['exampleassesstaskdetails'] = 'numatyta: {$a->expected}<br />įvertinta: {$a->assessed}';
$string['examplecomparing'] = 'Pateikto turinio pavyzdžių įvertinimo palyginimas';
$string['exampledelete'] = 'Naikinti pavyzdį';
$string['exampledeleteconfirm'] = 'Ar tikrai norite naikinti šį pateikto turinio pavyzdį? Norėdami panaikinti pateiktą turinį spustelėkite Tęsti.';
$string['exampleedit'] = 'Redaguoti pavyzdį';
$string['exampleediting'] = 'Pavyzdžio redagavimas';
$string['exampleneedassessed'] = 'Pirma turite įvertinti visus pateikto turinio pavyzdžius';
$string['exampleneedsubmission'] = 'Pirma turite pateikti savo darbą ir įvertinti visus pateikto turinio pavyzdžius';
$string['examplesbeforeassessment'] = 'Pavyzdžiai pasiekiami pateikus savo turinį ir jie turi būti įvertinti prieš tarpusavio įvertinimą';
$string['examplesbeforesubmission'] = 'Pavyzdžius reikia įvertinti prieš pateikiant savo darbą';
$string['examplesmode'] = 'Pavyzdžių įvertinimo režimas';
$string['examplesubmissions'] = 'Pateikto turinio pavyzdžiai';
$string['examplesvoluntary'] = 'Pateikto turinio pavyzdžių įvertinimas yra savanoriškas';
$string['exportsubmission'] = 'Eksportuoti šį puslapį';
$string['feedbackauthor'] = 'Autoriui skirtas atsiliepimas';
$string['feedbackauthorattachment'] = 'Priedas';
$string['feedbackby'] = 'Atsakas iš {$a}';
$string['feedbackreviewer'] = 'Peržiūrėtojui skirtas atsiliepimas';
$string['feedbacksettings'] = 'Grįžtamasis ryšys';
$string['formataggregatedgrade'] = '{$a->grade}';
$string['formataggregatedgradeover'] = '<del>{$a->grade}</del><br /><ins>{$a->over}</ins>';
$string['formatpeergrade'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">({$a->gradinggrade})</span>';
$string['formatpeergradeover'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">(<del>{$a->gradinggrade}</del> / <ins>{$a->gradinggradeover}</ins>)</span>';
$string['formatpeergradeoverweighted'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">(<del>{$a->gradinggrade}</del> / <ins>{$a->gradinggradeover}</ins>)</span> @ <span class="weight">{$a->weight}</span>';
$string['formatpeergradeweighted'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">({$a->gradinggrade})</span> @ <span class="weight">{$a->weight}</span>';
$string['givengrades'] = 'Suteikti įvertinimai';
$string['grade_grading_name'] = 'Vertinimas';
$string['grade_submission_name'] = 'Pateikimas';
$string['gradecalculated'] = 'Apskaičiuotas pateikimo įvertinimas';
$string['gradedecimals'] = 'Dešimtainės vietos įvertinimuose';
$string['gradegivento'] = '&gt;';
$string['gradeinfo'] = 'Įvertinimas: {$a->received} iš {$a->max}';
$string['gradeitemassessment'] = '{$a->workshopname} (vertinimas)';
$string['gradeitemsubmission'] = '{$a->workshopname} (pateikimas)';
$string['gradeover'] = 'Pakeisti pateikto turinio įvertinimą';
$string['gradereceivedfrom'] = '&lt;';
$string['gradesreport'] = 'Seminaro įvertinimų ataskaita';
$string['gradetopassgrading'] = 'Vertinimo išlaikymo įvertinimas';
$string['gradetopasssubmission'] = 'Pateikimo išlaikymo įvertinimas';
$string['gradinggrade'] = 'Įvertinimas už vertinimą';
$string['gradinggrade_help'] = 'Šis parametras nurodo maksimalų įvertinimą, kurį galima gauti už pateiktą įvertinimą.';
$string['gradinggradecalculated'] = 'Apskaičiuotas įvertinimas už vertinimą';
$string['gradinggradeof'] = 'Įvertinimas už vertinimą (iš {$a})';
$string['gradinggradeover'] = 'Pakeisti įvertinimo balą už vertinimą';
$string['gradingsettings'] = 'Vertinimo parametrai';
$string['groupnoallowed'] = 'Jums neleidžiama pasiekti nei vienos grupės šiame seminare';
$string['iamsure'] = 'Taip, esu tikras';
$string['indicator:cognitivedepth'] = 'Pažintinis seminaras';
$string['indicator:cognitivedepth_help'] = 'Šis rodiklis pagrįstas pažinimo gyliu, kurį besimokantysis pasiekia Seminare.';
$string['indicator:cognitivedepthdef'] = 'Pažintinis seminaras';
$string['indicator:cognitivedepthdef_help'] = 'Dalyvis pasiekė šį kognityvinio įsitraukimo procentą, kurį siūlo seminaro veikla per šį analizės intervalą (lygiai = neperžiūrėta, peržiūrėta, pateikta, peržiūrėtas atsiliepimas, pakomentuotas atsiliepimas, pateikta iš naujo po peržiūros)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Socialinis seminaras';
$string['indicator:socialbreadth_help'] = 'Šis rodiklis pagrįstas socialiniu platumu, kurį besimokantysis pasiekia seminare.';
$string['indicator:socialbreadthdef'] = 'Socialinis seminaras';
$string['indicator:socialbreadthdef_help'] = 'Dalyvis pasiekė šį socialinio įsitraukimo procentą, kurį siūlo seminaro veikla per šį analizės intervalą (lygiai = nedalyvauta, dalyvis vienas, dalyvis su kitais)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['info'] = 'Informacija';
$string['instructauthors'] = 'Pateikimo instrukcijos';
$string['instructreviewers'] = 'Įvertinimo instrukcijos';
$string['introduction'] = 'Įvadas';
$string['latesubmissions'] = 'Pavėluotas pateikimas';
$string['latesubmissions_desc'] = 'Leisti pateikti pasibaigus terminui';
$string['latesubmissions_help'] = 'Jei įjungta, autorius gali pateikti savo darbą pasibaigus pateikimo terminui arba įvertinimo etape. Tačiau pavėluotai pateikto turinio negalima redaguoti.';
$string['latesubmissionsallowed'] = 'Leidžiama pateikti pavėluotai';
$string['maxbytes'] = 'Maksimalus failo dydis';
$string['modulename'] = 'Seminaras';
$string['modulename_help'] = 'Seminaro veikla leidžia rinkti, peržiūrėti ir vertinti tarpusavyje besimokančiųjų darbus.

Besimokantieji gali pateikti bet kokį skaitmeninį turinį (failus), pvz., tekstinius dokumentus ar skaičiuokles ir taip pat tekstą gali pateikti tiesiai teksto rengyklės lauke.

Pateikimai įvertinami naudojant įvertinimo kriterijų formą, kurią nustato dėstytojas. Tarpusavio įvertinimo procesas ir įvertinimo formos supratimas gali būti iš anksto vykdomas naudojant pateikimų pavyzdžius, kuriuos pateikia dėstytojas kartu su savo pateiktu įvertinimu. Besimokantiesiems suteikiama galimybė įvertinti vieną ar kelis savo kurso dalyvių pateikimus. Jei reikia, pateikimai ir recenzentai gali būti anonimiški.

Besimokantieji seminaro veikloje gauna du įvertinimus - įvertinimas už savo pateikimą ir įvertinimą už kitų dalyvių pateikimų vertinimą. Abu įverčiai įrašomi įverčių knygelėje.';
$string['modulename_link'] = 'mod/workshop/view';
$string['modulenameplural'] = 'Seminarai';
$string['myassessments'] = 'Mano įvertinimai';
$string['mysubmission'] = 'Mano pateikimas';
$string['nattachments'] = 'Maksimalus pateikto turinio priedų skaičius';
$string['noexamples'] = 'Šiame seminare dar nėra pavyzdžių';
$string['noexamplesformready'] = 'Prieš pateikdami pateikto turinio pavyzdžius turite apibrėžti įvertinimo formą';
$string['nogradeyet'] = 'Dar nėra įvertinimo';
$string['nosubmissionfound'] = 'Nerasta šio naudotojo pateikto turinio';
$string['nosubmissions'] = 'Šiame seminare dar nėra pateikto turinio';
$string['nosubmissiontype'] = 'Turi būti prieinamas bent vienas pateikimo tipas';
$string['notassessed'] = 'Dar neįvertinta';
$string['nothingfound'] = 'Nėra ką rodyti';
$string['nothingtoreview'] = 'Nėra, ką peržiūrėti';
$string['notoverridden'] = 'Nepakeistas';
$string['noworkshops'] = 'Šiuose kursuose nėra seminarų';
$string['noyoursubmission'] = 'Dar nepateikėte savo darbo';
$string['nullgrade'] = '-';
$string['overallfeedback'] = 'Bendras atsiliepimas';
$string['overallfeedbackfiles'] = 'Maksimalus grįžtamojo ryšio failų kiekis';
$string['overallfeedbackmaxbytes'] = 'Maksimalus failo dydis';
$string['overallfeedbackmode'] = 'Bendras grįžtamojo ryšio režimas';
$string['overallfeedbackmode_0'] = 'Išjungtas';
$string['overallfeedbackmode_1'] = 'Įjungtas ir neprivalomas';
$string['overallfeedbackmode_2'] = 'Įjungtas ir privalomas';
$string['overallfeedbackmode_help'] = 'Jei įjungta, įvertinimo formos apačioje yra rodomas teksto laukas. Recenzentai jame gali pateikti bendrą pateikimo įvertinimą arba papildomą įvertinimo paaiškinimą.';
$string['page-mod-workshop-x'] = 'Bet kuris dirbtuvės modulio puslapis';
$string['participant'] = 'Dalyvis';
$string['participantrevierof'] = 'Dalyvis yra peržiūrėtojas';
$string['participantreviewedby'] = 'Dalyvio darbą peržiūri';
$string['phaseassessment'] = 'Vertinimo etapas';
$string['phaseclosed'] = 'Uždaryta';
$string['phaseevaluation'] = 'Įvertinimų pateikimo etapas';
$string['phasesetup'] = 'Nustatymo etapas';
$string['phasesoverlap'] = 'Pateikimo etapas ir vertinimo etapas negali dubliuotis';
$string['phasesubmission'] = 'Pateikimo etapas';
$string['pluginadministration'] = 'Seminaro administravimas';
$string['pluginname'] = 'Seminaras';
$string['prepareexamples'] = 'Parengti pateikto turinio pavyzdžius';
$string['previewassessmentform'] = 'Peržiūra';
$string['privacy:metadata:aggregatedgradinggrade'] = 'Apibendrintas visų įvertinimų, kuriuos naudotojas atliko atlikdamas nurodytą seminarą, įvertinimas';
$string['privacy:metadata:assessmentgrade'] = 'Bendras pateikimo įvertinimas, siūlomas šiam vertinimui';
$string['privacy:metadata:assessmentgradinggrade'] = 'Įvertinimas už šį vertinimą';
$string['privacy:metadata:assessmentgradinggradeover'] = 'Rankiniu būdu pakeista įvertinimo reikšmė už šį vertinimą';
$string['privacy:metadata:assessmentid'] = 'Vertinimo ID';
$string['privacy:metadata:authorid'] = 'Pateikimo autoriaus ID';
$string['privacy:metadata:dimensiongrade'] = 'Įvertinimas nurodytoje vertinimo dimensijoje';
$string['privacy:metadata:dimensionid'] = 'Vertinimo dimensijos ID';
$string['privacy:metadata:example'] = 'Ar šis įrašas yra pateikimo pavyzdys';
$string['privacy:metadata:feedbackauthor'] = 'Atsiliepimas autoriui';
$string['privacy:metadata:feedbackauthorformat'] = 'Atsiliepimų autoriui teksto formatas';
$string['privacy:metadata:feedbackreviewer'] = 'Atsiliepimai naudotojui, teikiančiam vertinimą';
$string['privacy:metadata:feedbackreviewerformat'] = 'Atsiliepimo teksto formatas vertinimą teikiančiam naudotojui';
$string['privacy:metadata:late'] = 'Ar pateikimas buvo pateiktas pasibaigus terminui';
$string['privacy:metadata:peercomment'] = 'Pakomentuoti ant vertinimą teikiančio naudotojo duoto įvertinimo';
$string['privacy:metadata:peercommentformat'] = 'Pateikto pažymio komentaro teksto formatas';
$string['privacy:metadata:preference:perpage'] = 'Pateikimų, naudotojui matomų viename puslapyje, skaičius';
$string['privacy:metadata:preference:viewlet-allexamples-collapsed'] = 'Rodinio „Pateikimų pavyzdžiai“ būsena sutraukta/išplėsta.';
$string['privacy:metadata:preference:viewlet-allsubmissions-collapsed'] = 'Sutraukta / išplėsta rodinio „Seminaro pateikimo ataskaita“ būsena.';
$string['privacy:metadata:preference:viewlet-assessmentform-collapsed'] = 'Sutraukta / išplėsta peržiūros „Vertinimo forma“ būsena.';
$string['privacy:metadata:preference:viewlet-assignedassessments-collapsed'] = 'Rodinio „Priskirti vertinti pateikimai“ būsena sutraukta / išplėsta.';
$string['privacy:metadata:preference:viewlet-cleargrades-collapsed'] = 'Rodinio „Seminaro įrankių rinkinys“ būsena sutraukta / išplėsta.';
$string['privacy:metadata:preference:viewlet-conclusion-collapsed'] = 'Rodinio „Išvada“ sutraukta / išplėsta būsena.';
$string['privacy:metadata:preference:viewlet-examples-collapsed'] = 'Rodinio „Pateikimų pavyzdžiai vertinti“ būsena sutraukta / išplėsta.';
$string['privacy:metadata:preference:viewlet-examplesfail-collapsed'] = 'Rodinio „Pateikimų pavyzdžiai vertinti“ būsena sutraukta / išplėsta.';
$string['privacy:metadata:preference:viewlet-gradereport-collapsed'] = 'Rodinio „Seminaro įvertinimų ataskaitos“ būsena sutraukta / išplėsta.';
$string['privacy:metadata:preference:viewlet-instructauthors-collapsed'] = 'Rodinio „Pateikimo instrukcijos“ sutraukta / išplėsta būsena.';
$string['privacy:metadata:preference:viewlet-instructreviewers-collapsed'] = 'Rodinio „Vertinimo instrukcijos“ sutraukta / išplėsta būsena.';
$string['privacy:metadata:preference:viewlet-intro-collapsed'] = 'Sutraukta / išplėsta peržiūros „Įvadas“ būsena.';
$string['privacy:metadata:preference:viewlet-overallfeedback-collapsed'] = 'Rodinio „Bendras atsiliepimas“ sutraukta / išplėsta būsena.';
$string['privacy:metadata:preference:viewlet-ownsubmission-collapsed'] = 'Rodinio  „Jūsų pateikimas“ sutraukta / išplėsta būsena.';
$string['privacy:metadata:preference:viewlet-publicsubmissions-collapsed'] = 'Rodinio „Paskelbti pateikimai“ sutraukta / išplėsta būsena.';
$string['privacy:metadata:preference:viewlet-yourgrades-collapsed'] = 'Rodinio „Jūsų įvertinimai“ sutraukta / išplėsta būsena.';
$string['privacy:metadata:published'] = 'Ar pateikimas turėtų būti paskelbtas visiems dalyviams pasibaigus seminarui';
$string['privacy:metadata:reviewerid'] = 'Įvertinimą teikiančio naudotojo ID';
$string['privacy:metadata:strategy'] = 'Įvertinimo strategijos papildinio, interpretuojančio įrašo reikšmes, pavadinimas';
$string['privacy:metadata:submissioncontent'] = 'Pateikimo turinys';
$string['privacy:metadata:submissioncontentformat'] = 'Pateikimo turinio teksto formatas';
$string['privacy:metadata:submissiongrade'] = 'Pateikimo suvestinis įvertinimas, parašytas dešimtainiu skaičiumi intervale 0...100';
$string['privacy:metadata:submissiongradeover'] = 'Rankiniu būdu pakeista suvestinio įvertinimo vertė';
$string['privacy:metadata:submissionid'] = 'Pateikimo ID';
$string['privacy:metadata:submissiontitle'] = 'Pateikimo pavadinimas';
$string['privacy:metadata:subsystem:corefiles'] = 'Seminaro modulis saugo failus, įterptus / pridėtus prie pateikimo teksto';
$string['privacy:metadata:subsystem:coreplagiarism'] = 'Seminaro modulis turi integruotą plagiato prevencijos sistemų palaikymą';
$string['privacy:metadata:timeaggregated'] = 'Kada paskutinį kartą buvo skaičiuojamas suminis įvertinimas';
$string['privacy:metadata:timecreated'] = 'Kaada šis įrašas buvo sukurtas duomenų bazėje';
$string['privacy:metadata:timemodified'] = 'Kada paskutinį kartą šis įrašas buvo modifikuotas duomenų bazėje';
$string['privacy:metadata:userid'] = 'Naudotojo, kuriam skaičiuojamas bendras įvertinimas, ID';
$string['privacy:metadata:weight'] = 'Vertinimo svoris';
$string['privacy:metadata:workshopaggregations'] = 'Išlaiko apibendrintus įvertinimus';
$string['privacy:metadata:workshopassessments'] = 'Saugo informaciją apie skirtus seminarų modulio pateikimo vertinimus';
$string['privacy:metadata:workshopgrades'] = 'Saugoma informacija apie tai, kaip vertinimo formos buvo užpildytos įvertinimais ir komentarais';
$string['privacy:metadata:workshopid'] = 'Seminaro veiklos ID';
$string['privacy:metadata:workshopsubmissions'] = 'Talpina informaciją apie seminaro modulio pateikimą';
$string['privacy:request:delete:content'] = 'Turinys buvo ištrintas (paprašė naudotojas arba pasibaigė jo galiojimo laikas)';
$string['privacy:request:delete:title'] = '[Panaikinta]';
$string['publishedsubmissions'] = 'Publikuotai pateikimai';
$string['publishsubmission'] = 'Publikuoti pateiktą turinį';
$string['publishsubmission_help'] = 'Publikuoti pateikimai yra pasiekiami kitiems uždarius seminarą.';
$string['reassess'] = 'Įvertinti iš naujo';
$string['receivedgrades'] = 'Gauti įvertinimai';
$string['recentassessments'] = 'Seminaro įvertinimai:';
$string['recentsubmissions'] = 'Seminaro pateikimai:';
$string['resetassessments'] = 'Visi vertinimai';
$string['resetassessments_help'] = 'Galite pasirinkti ištrinti tik priskirtus įvertinimus, nepaveikiant  jų pateikimų. Jei pateikimai turi būti ištrinti, jų vertinimai bus netiesiogiai ištrinti ir ši galimybė bus ignoruojama. Pastaba, tai taip pat apima pavyzdžių pateikimo įvertinimus.';
$string['resetphase'] = 'Perjungti į nustatymo etapą';
$string['resetphase_help'] = 'Jei įjungta, visi seminarai bus įtraukti į pradinį nustatymo etapą.';
$string['resetsubmissions'] = 'Visi pateikimai';
$string['resetsubmissions_help'] = 'Visi pateikimai ir jų vertinimai bus panaikinti. Tai neturi įtakos pavyzdžių pateikimui.';
$string['saveandclose'] = 'Įrašyti ir uždaryti';
$string['saveandcontinue'] = 'Įrašyti ir toliau redaguoti';
$string['saveandpreview'] = 'Įrašyti ir peržiūrėti';
$string['saveandshownext'] = 'Įrašyti ir rodyti kitą';
$string['search:activity'] = 'Seminaras  - veiklos informacija';
$string['selfassessmentdisabled'] = 'Savęs įvertinimas išjungtas';
$string['showingperpage'] = 'Rodomi {$a} elementai puslapyje';
$string['showingperpagechange'] = 'Keisti ...';
$string['someuserswosubmission'] = 'Yra bent vienas autorius, dar nepateikęs savo darbo';
$string['sortasc'] = 'Rikiavimas didėjimo tvarka';
$string['sortdesc'] = 'Rikiavimas mažėjimo tvarka';
$string['strategy'] = 'Vertinimo strategija';
$string['strategy_help'] = 'Įvertinimų pateikimo strategija nurodo naudojamą įvertinimo formą ir pateikto turinio įvertinimų pateikimo metodą. Yra 4 galimybės:

* Kaupiamasis įvertinimas – komentarai ir įvertinimas pateikiami atsižvelgiant į nurodytus aspektus.
* Komentarai – atsižvelgiant į nurodytus aspektus rašomi komentarai, bet nepateikiamas joks įvertinimas.
* Klaidų skaičius – rašomi komentarai ir pateikiamas „taip / ne“ įvertinimas, atsižvelgiant į nurodytus aspektus.
* Rubrika – atsižvelgiant į nurodytus kriterijus pateikiamas lygio įvertinimas.';
$string['strategyhaschanged'] = 'Seminaro vertinimo strategija pasikeitė nuo tada, kai forma buvo atidaryta redagavimui.';
$string['submission'] = 'Pateikimas';
$string['submissionattachment'] = 'Priedas';
$string['submissionby'] = 'Pateikė {$a}';
$string['submissioncontent'] = 'Pateikimo turinys';
$string['submissiondeleteconfirm'] = 'Ar tikrai norite ištrinti šį pateikimą?';
$string['submissiondeleteconfirmassess'] = 'Ar tikrai norite ištrinti šį pateikimą? Atkreipkite dėmesį, kad taip pat bus ištrinti {$a-> count} įvertinimai, susiję su šiuo pateikimu, kuris gali įtakoti recenzentų įvertinimus.';
$string['submissionend'] = 'Pateikimo terminas';
$string['submissionendbeforestart'] = 'Pateikimo galutinis terminas negali būti ankstesnis nei pateikimo pradžios data';
$string['submissionenddatetime'] = 'Pateikimo terminas: {$a->daydatetime} ({$a->distanceday})';
$string['submissionendevent'] = '{$a} pateikimų terminas';
$string['submissionendswitch'] = 'Perjungti į kitą etapą po pateikimų termino';
$string['submissionendswitch_help'] = 'Jei pateikimo terminas yra nurodytas ir šis langelis yra pažymėtas, seminaras automatiškai persijungs į įvertinimo etapą po pateikimo termino.

Jei įjungsite šią funkciją, rekomenduojama taip pat nustatyti numatytą paskirstymo metodą. Jei pateikimai yra nepaskirstyti, įvertinimas negali būti atliktas, net jei pats seminaras yra įvertinimo etape.';
$string['submissiongrade'] = 'Pateikimo įvertinimas';
$string['submissiongrade_help'] = 'Šis parametras nurodo maksimalų įvertinimą, kurį galima gauti už pateiktą darbą.';
$string['submissiongradeof'] = 'Pateikimo įvertinimas (iš {$a})';
$string['submissionlastmodified'] = 'Paskutinis pakeitimas';
$string['submissionrequiredcontent'] = 'Jums reikia įvesti kokį nors tekstą ar pridėti failą.';
$string['submissionrequiredfile'] = 'Jums reikia pridėti failą ar įvesti kokį nors tekstą.';
$string['submissionsallocation'] = 'Pateikimų paskirstymas';
$string['submissionsettings'] = 'Pateikimo parametrai';
$string['submissionsreport'] = 'Seminaro pateikimų ataskaita';
$string['submissionstart'] = 'Galima pateikti nuo';
$string['submissionstartdatetime'] = 'Galima pateikti nuo {$a->daydatetime} ({$a->distanceday})';
$string['submissionstartevent'] = '{$a} atidaromi pateikimai';
$string['submissiontitle'] = 'Pavadinimas';
$string['submissiontypedisabled'] = 'Šiame seminare šis pateikimo tipas išjungtas.';
$string['submissiontypefileavailable'] = 'Failo priedas<span class="accesshide"> galimas</span>';
$string['submissiontypefilerequired'] = '<span class="accesshide">Failo priedas </span>Reikalingas';
$string['submissiontypes'] = 'Pateikimų tipai';
$string['submissiontypetextavailable'] = 'Internetinis tekstas<span class="accesshide">pasiekiamas</span>';
$string['submissiontypetextrequired'] = '<span class="accesshide">Internetinis tekstas </span>Reikalingas';
$string['submittednotsubmitted'] = 'Pateikta ({$a->submitted}) / nepateikta ({$a->notsubmitted})';
$string['subplugintype_workshopallocation'] = 'Pateikčių paskirstymo metodas';
$string['subplugintype_workshopallocation_plural'] = 'Pateikčių paskirstymo metodai';
$string['subplugintype_workshopeval'] = 'Vertinimo metodas';
$string['subplugintype_workshopeval_plural'] = 'Vertinimo metodai';
$string['subplugintype_workshopform'] = 'Vertinimo strategija';
$string['subplugintype_workshopform_plural'] = 'Vertinimo strategijos';
$string['switchingphase'] = 'Etapo perjungimas';
$string['switchphase'] = 'Perjungti etapą';
$string['switchphase10'] = 'Perjungti į nustatymo etapą';
$string['switchphase10info'] = 'Ruošiatės perjungti seminarą į <strong>nustatymo etapą</strong>. Šiame etape naudotojai negali modifikuoti savo pateikto turinio ar jo įvertinimo. Dėstytojai gali naudoti šį etapą norėdami pakeisti seminaro parametrus, modifikuoti koreguojamo įvertinimo formų įverčių pateikimo strategiją.';
$string['switchphase20'] = 'Perjungti į pateikimo etapą';
$string['switchphase20info'] = 'Ruošiatės perjungti seminarą į <strong>pateikimo etapą</strong>. Besimokantieji šiame etape gali pateikti savo darbus (nustatytomis pateikimo prieigos valdymo datomis, jei jos yra). Dėstytojai gali priskirti pateiktą turinį vertinti besimokančiųjų kolegoms.';
$string['switchphase30'] = 'Perjungti į vertinimo etapą';
$string['switchphase30auto'] = 'Seminaras automatiškai persijungs į įvertinimo etapą po {$a->daydatetime} ({$a->distanceday})';
$string['switchphase30info'] = 'Ruošiatės perjungti seminarą į <strong>įvertinimo etapą</strong>. Šiame etape peržiūrėtojai gali įvertinti jiems priskirtą pateiktą turinį (nustatytomis įvertinimo prieigos valdymo datomis, jei jos yra).';
$string['switchphase40'] = 'Perjungti į įvertinimų pateikimo etapą';
$string['switchphase40info'] = 'Ruošiatės perjungti seminarą į <strong>įverčių pateikimo etapą</strong>. Šiame etape naudotojai negali modifikuoti savo pateikto turinio ar jo įvertinimo. Dėstytojai gali naudoti įverčių pateikimo įrankius, kad apskaičiuotų galutinius įverčius ir pateiktų atsiliepimų peržiūrėtojams.';
$string['switchphase50'] = 'Uždaryti seminarą';
$string['switchphase50info'] = 'Ruošiatės uždaryti seminarą. Jei tai padarysite, apskaičiuoti įvertinimai bus rodomi įvertinimų knygelėje. Besimokantieji galės peržiūrėti savo pateiktą turinį ir jo įvertinimą.';
$string['switchphaseauto'] = 'Perjungimas buvo suplanuotas';
$string['switchphasenext'] = 'Perjungti į kitą etapą';
$string['taskassesspeers'] = 'Įvertinti kolegas';
$string['taskassesspeersdetails'] = 'iš viso: {$a->total}<br />laukia: {$a->todo}';
$string['taskassessself'] = 'Įvertinti save';
$string['taskconclusion'] = 'Pateikti veiklos išvadas';
$string['taskdone'] = 'Užduotis atlikta';
$string['taskfail'] = 'Užduotis nepavyko';
$string['taskinfo'] = 'Užduoties informacija';
$string['taskinstructauthors'] = 'Pateikti pateikimo instrukcijas';
$string['taskinstructreviewers'] = 'Pateikti įvertinimo instrukcijas';
$string['taskintro'] = 'Nustatyti seminaro įvadą';
$string['tasksubmit'] = 'Pateikti savo darbą';
$string['tasktodo'] = 'Užduotis daroma';
$string['toolbox'] = 'Seminaro įrankių rinkinys';
$string['undersetup'] = 'Seminaras šiuo metu nustatomas. Palaukite, kol bus perjungtas kitas jo etapas.';
$string['useexamples'] = 'Naudoti pavyzdžius';
$string['useexamples_desc'] = 'Pateikto turinio pavyzdžiai skirti vertinimo įgūdžiams lavinti';
$string['useexamples_help'] = 'Jei įjungta, naudotojai gali pabandyti įvertinti vieną ar daugiau pateikto turinio pavyzdžių ir palyginti savo įvertinimus su pavyzdiniu įvertinimu. Šis įvertinimas neįskaičiuojamas į vertinimo balą.';
$string['usepeerassessment'] = 'Naudoti tarpusavio įvertinimą';
$string['usepeerassessment_desc'] = 'Besimokantieji gali įvertinti kitų darbą';
$string['usepeerassessment_help'] = 'Jei įjungta, naudotojui gali būti priskirti vertinti kitų naudotojų pateikimai ir jis gaus ne tik įvertį už savo pateikimą, bet ir įvertinimą už vertinimą.';
$string['userdatecreated'] = 'pateikta <span>{$a}</span>';
$string['userdatemodified'] = 'modifikuota <span>{$a}</span>';
$string['userplan'] = 'Seminaro planavimo priemonė';
$string['userplan_help'] = 'Seminaro planavimo priemonė rodo visus veiklos etapus ir pateikia kiekvieno etapo užduotis. Dabartinė užduotis paryškinama, o užduoties atlikimas pažymimas varnele.';
$string['userplanaccessibilityskip'] = 'Pereiti prie dabartinių užduočių';
$string['userplanaccessibilitytitle'] = 'Seminaro laiko skalė su {$a} etapais';
$string['userplancurrentphase'] = 'Dabartinis etapas';
$string['useselfassessment'] = 'Naudoti savęs įvertinimą';
$string['useselfassessment_desc'] = 'Besimokantieji gali įvertinti savo pačių darbą';
$string['useselfassessment_help'] = 'Jei įjungta, naudotojui gali būti priskirtas vertinti savo paties pateikimas ir jis gaus ne tik įvertį už savo pateikimą, bet ir įvertį už vertinimą.';
$string['viewworkshopsummary'] = 'Peržiūrėti seminaro suvestinę';
$string['weightinfo'] = 'Svarba: {$a}';
$string['withoutsubmission'] = 'Peržiūrėtojas, nepateikęs savo turinio';
$string['workshop:addinstance'] = 'Pridėti naują seminarą';
$string['workshop:allocate'] = 'Priskirti pateiktą turinį peržiūrėti';
$string['workshop:deletesubmissions'] = 'Ištrinti pateikimus';
$string['workshop:editdimensions'] = 'Redaguoti įvertinimo formas';
$string['workshop:exportsubmissions'] = 'Eksportuoti pateikimus';
$string['workshop:ignoredeadlines'] = 'Ignoruoti laiko apribojimus';
$string['workshop:manageexamples'] = 'Valdyti pateikto turinio pavyzdžius';
$string['workshop:overridegrades'] = 'Keisti apskaičiuotus įvertinimus';
$string['workshop:peerassess'] = 'Įvertinti kolegas';
$string['workshop:publishsubmissions'] = 'Publikuoti pateiktą turinį';
$string['workshop:submit'] = 'Pateikti';
$string['workshop:switchphase'] = 'Perjungti etapą';
$string['workshop:view'] = 'Peržiūrėti seminarą';
$string['workshop:viewallassessments'] = 'Peržiūrėti visus įvertinimus';
$string['workshop:viewallsubmissions'] = 'Peržiūrėti visą pateiktą turinį';
$string['workshop:viewauthornames'] = 'Peržiūrėti autorių vardus';
$string['workshop:viewauthorpublished'] = 'Peržiūrėti paskelbtų pateikčių autorius';
$string['workshop:viewpublishedsubmissions'] = 'Peržiūrėti publikuotą pateiktą turinį';
$string['workshop:viewreviewernames'] = 'Peržiūrėti peržiūrėtojų vardus';
$string['workshopname'] = 'Seminaro pavadinimas';
$string['yourassessmentfor'] = 'Jūsų įvertinimas  {$a}';
$string['yourgrades'] = 'Jūsų įvertinimai';
$string['yoursubmission'] = 'Jūsų pateikimas';
$string['yoursubmissionwithassessments'] = 'Jūsų pateikimas su vertinimais';
