<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'badges', language 'lt', version '4.5'.
 *
 * @package     badges
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'Veiksmai';
$string['activate'] = 'Įgalinti prieigą';
$string['activatesuccess'] = 'Prieiga prie pasiekimo "{$a}" įgalinta.';
$string['addalignment'] = 'Pridėti išorinį įgūdį arba standartą';
$string['addbadge'] = 'Pridėti pasiekimus';
$string['addbadge_help'] = 'Pasirinkite visus pasiekimus, kurie turėtų būti reikalaujami šiam pasiekimui. Laikykite nuspaudę klavišą CTRL, jei norite pasirinkti kelis.';
$string['addbadgecriteria'] = 'Įtraukti pasiekimo kriterijų';
$string['addcohort'] = 'Įtraukti junginį';
$string['addcohort_help'] = 'Pasirinkite visus junginius, kurie turėtų būti reikalaujami šiam pasiekimui. Laikykite nuspaudę klavišą CTRL, jei norite pasirinkti kelis.';
$string['addcompetency'] = 'Pridėti kompetenciją';
$string['addcompetency_help'] = 'Pasirinkite visas kompetencijas, kurios turėtų būti reikalaujamos šiam pasiekimui. Laikykite nuspaudę klavišą CTRL, jei norite pasirinkti kelias.';
$string['addcourse'] = 'Įtraukti kursus';
$string['addcourse_help'] = 'Pažymėti visus kursus, kurie turi būti įtraukti prie šio pasiekimo reikalavimų. Laikykite "CTRL" norėdami pažymėti keletą elementų.';
$string['addcriteria'] = 'Įtraukti kriterijų';
$string['addcriteriatext'] = 'Norėdami pradėti kriterijų įtraukimą, prašom pasirinkti vieną iš parinkčių išskleidžiamajame meniu.';
$string['addedtobackpack'] = 'Pasiekimas įtrauktas į saugyklą';
$string['addrelated'] = 'Įtraukti susijusį pasiekimą';
$string['addtobackpack'] = 'Įtraukti į saugyklą';
$string['adminonly'] = 'Šis puslapis skirtas tik sistemos administratoriams.';
$string['after'] = 'po išdavimo datos.';
$string['aggregationmethod'] = 'Sudėties metodas';
$string['alignment'] = 'Lygiavimas';
$string['all'] = 'Viską';
$string['allmethod'] = 'Įvykdytos visos parinktos sąlygos';
$string['allmethodactivity'] = 'Įvykdytos visos pasirinktos veiklos';
$string['allmethodbadges'] = 'Visi pasirinkti pasiekimai buvo pasiekti';
$string['allmethodcohort'] = 'Narystė pasirinktuose junginiuose';
$string['allmethodcompetencies'] = 'Visos pasirinktos kompetencijos baigtos';
$string['allmethodcourseset'] = 'Baigti visi pasirinkti kursai';
$string['allmethodmanual'] = 'Visi pasirinkti vaidmenys gali skirti pasiekimą';
$string['allmethodprofile'] = 'Užpildyti visi nurodyti profilio laukai';
$string['allowcoursebadges'] = 'Įgalinti kurso pasiekimus';
$string['allowcoursebadges_desc'] = 'Leisti kurti kurso pasiekimus ir taikyti juos kurso kontekste.';
$string['allowexternalbackpack'] = 'Išorinių saugyklų prijungimas';
$string['allowexternalbackpack_desc'] = 'Jei įjungta, naudotojai gali jungtis prie išorinių saugyklų ir pasidalyti savo pasiekimais šioje svetainėje. Naudotojai taip pat gali pasirinkti bet kurias viešas pasiekimų kolekcijas rodyti šios svetainės profilio puslapyje. Rekomenduojama šią parinktį palikti išjungtą, jei svetainė nėra pasiekiama iš interneto.';
$string['any'] = 'Bet kuris';
$string['anymethod'] = 'Įvykdyta bet kuri iš sąlygų';
$string['anymethodactivity'] = 'Įvykdyta bet kuri nurodyta veikla';
$string['anymethodbadges'] = 'Bet kuris iš pasirinktų pasiekimų buvo gautas';
$string['anymethodcohort'] = 'Narystė bet kurioje iš pasirinktų grupių';
$string['anymethodcompetencies'] = 'Įgyta bet kuri iš pasirinktų kompetencijų';
$string['anymethodcourseset'] = 'Baigtas bet kuris iš pasirinktų kursų';
$string['anymethodmanual'] = 'Kai bet kuris iš pažymėtų vaidmenų įteikia pasiekimą';
$string['anymethodprofile'] = 'Bet kuris iš pasirinktų profilio laukų yra užpildytas';
$string['apiversion'] = 'Palaikoma API versija';
$string['archivebadge'] = 'Ar Jūs norėtumėte ištrinti \'{$a}\' pasiekimą, tačiau palikti jau suteiktus pasiekimus?';
$string['archiveconfirm'] = 'Ištrinti ir palikti jau suteiktus pasiekimus';
$string['archivehelp'] = '<p> Ši nuostata nurodo, kad pasiekimas bus pažymėtas kaip "nebenaudojamas" ir nebebus rodomas pasiekimų sąraše. Naudotojai nebegalės gauti šio pasiekimo, tačiau tie kas jau gavo jį  galės rodyti šį pasiekimą savo profilio puslapyje ir perkelti jį į savo išorinę saugyklą. </p>
<p>Jei Jūs norite palikti galimybę naudotojams gauti šį pasiekimą ateityje, tuomet yra labai svarbu parinkti šią nuostatą vietoj pilno pasiekimo ištrynimo.</p>';
$string['attachment'] = 'Prikabinti pasiekimą prie pranešimo';
$string['attachment_help'] = 'Jei pažymėta, paskirtas pasiekimas bus prikabintas prie gavėjo el. laiško atsisiuntimui. (Priedai turi būti įgalinti Administravimas / Serveris / Elektroninis paštas / Išsiunčiamo pašto konfigūracija.)';
$string['award'] = 'Skirti pasiekimą';
$string['awardedto'] = 'Apdovanotas {$a}';
$string['awardedtoyou'] = 'Skirtas man';
$string['awardoncron'] = 'Daug naudotojų gauna "{$a->badgename}" pasiekimą. Gali prireikti šiek tiek laiko, kol visi naudotojai jį gaus.';
$string['awards'] = 'Gavėjai';
$string['backpackapiurl'] = 'Pasiekimų talpyklos API URL';
$string['backpackavailability'] = 'Išorinio pasiekimo tikrinimas';
$string['backpackavailability_help'] = 'Tam, kad pasiekimo gavėjai galėtų įrodyti, kad jis gautas iš Jūsų, išorinė pasiekimų saugykla turi turėti galimybę pasiekti Jūsų svetainę ir patikrinti pasiekimų autentiškumą. Panašu, kad šiuo metu Jūsų svetainė nėra pasiekiama. Todėl pasiekimai, kuriuos Jūs skyrėte ar skirsite negali būti patikrinti.

**Kodėl aš matau šį pranešimą?**

Gali būti, kad Jūsų ugniasienė neleidžia pasiekti svetainės, Jūsų svetainė yra apsaugota slaptažodžiu ar Jūsų svetainė veikia kompiuteryje, kuris nepasiekiamas internete (pavyzdžiui, programų kūrimo darbo stotyje).

**Ar aš turiu problemų?**

Jūs turėtumėte pataisyti šią problemą bet kurioje svetainėje, kuri yra naudojama teikti paslaugoms ir kurioje Jūs planuojate skirti pasiekimus. Priešingu atveju pasiekimo gavėjai negalės įrodyti, kad šie pasiekimai yra gauti iš Jūsų. Jei Jūsų svetainė dar neteikia paslaugų, Jūs galite sukurti bandomuosius pasiekimus ir juos skirti, testavimo tikslais.

**Ką daryti, jei aš negaliu padaryti visos svetainės prieinamos viešai?**

Vienintelė nuoroda, kuri reikalinga patikrinimui yra [Jūsų-svetainės-URL]/badges/assertion.php. Todėl, jei Jūs galėtumėte pakeisti savo ugniasienės nustatymus, kad ji leistų pasiekti tik šį failą, pasiekimų patikrinimas veiks.';
$string['backpackbadgessettings'] = 'Keisti pasiekimų talpyklos nuostatas';
$string['backpackbadgessummary'] = 'Turite  {$a->totalbadges} pasiekimą (-us), rodomą (-us) iš {$a->totalcollections} kolekcijos (jų).';
$string['backpackcannotsendverification'] = 'Negalima siųsti patvirtinamo el. laiško';
$string['backpackconnected'] = 'Pasiekimų talpykla prijungta';
$string['backpackconnection'] = 'Jungtis prie saugyklos';
$string['backpackconnection_connected'] = 'Jūsų saugykla';
$string['backpackconnection_help'] = 'Saugokite ir bendrinkite savo pasiekimus iš šios svetainės ir rodykite viešus pasiekimus iš kitų svetainių savo naudotojo profilyje.';
$string['backpackconnectioncancelattempt'] = 'Prisijungimui naudojami skirtingi el. pašto adresai';
$string['backpackconnectionconnect'] = 'Prisijungimas prie saugyklos';
$string['backpackconnectionnottested'] = 'Šios pasiekimų talpyklos ryšio išbandyti negalima, nes jį palaiko tik Open Badges v2.0 pasiekimų talpyklos.';
$string['backpackconnectionok'] = 'Sėkmingai užmegztas pasiekimų talpyklos ryšys';
$string['backpackconnectionresendemail'] = 'Pakartotinai siųsti patvirtinimo el. laišką';
$string['backpackconnectionunexpectedmessage'] = 'Pasiekimų talpykla grąžino klaidą: „{$a}“.';
$string['backpackconnectionunexpectedresult'] = 'Prisijungiant prie saugyklos kilo problema. Jūsų saugyklos tiekėjas siunčia šį pranešimą: „{$a}“.';
$string['backpackdetails'] = 'Saugyklos nustatymai';
$string['backpackdisconnected'] = 'Pasiekimų talpykla atjungta';
$string['backpackemail'] = 'El.pašto adresas';
$string['backpackemail_help'] = 'El.pašto adresas susietas su Jūsų saugykla.
Kol Jūs esate prisijungę prie saugyklos, bet kuris pasiekimas gautas šioje svetainėje bus susietas su šiuo el.pašto adresu.';
$string['backpackemail_required'] = 'El. pašto adreso laukas negali būti tuščias';
$string['backpackemailverificationpending'] = 'Laukiamas patvirtinimas';
$string['backpackemailverifyemailbody'] = 'Sveiki, {$a->userfirstname},

Jau beveik baigėte prisijungimą prie savo pasiekimų kuprinės „{$a->sitename}“.

Norėdami baigti prisijungimą prie kuprinės, patvirtinkite savo el. pašto adresą spustelėdami šį mygtuką:

{$a->buttonlink}

Jei mygtukas neveikia, į naršyklę galite nukopijuoti ir įklijuoti šį URL adresą:
{$a->link}.

Jei nebandėte prisijungti prie savo pasiekimų kuprinės, galite ignoruoti šį el. laišką.

Jei norite gauti papildomos pagalbos, kreipkitės į svetainės palaikymo tarnybą,

{$a->admin}';
$string['backpackemailverifyemailsubject'] = '{$a}: „Badges“ saugyklos el. pašto patvirtinimas';
$string['backpackemailverifypending'] = 'Išsiuntėme el. laišką adresu <strong>{$a}</strong>. Norėdami suaktyvinti saugyklos ryšį, spustelėkite el. laiške esančią patvirtinimo nuorodą.';
$string['backpackemailverifysuccess'] = 'Dabar esate prisijungę prie saugyklos.';
$string['backpackemailverifytokenmismatch'] = 'Nuorodoje, kurią spustelėjote, esantis prieigos raktas neatitinka išsaugoto prieigos rakto. Įsitikinkite, kad spustelėjote nuorodą paskutiniame gautame el. laiške.';
$string['backpackexporterror'] = 'Nepavyko eksportuoti pasiekimo į pasiekimų talpyklą';
$string['backpackexporterrorwithinfo'] = 'Nepavyko eksportuoti pasiekimo „{$a->badgename}“ į taplyklą. Klaida: {$a->error}';
$string['backpackimport'] = 'Pasiekimo importavimo nustatymai';
$string['backpackimport_help'] = 'Po sėkmingo ryšio prie saugyklos įsigalėjimo, pasiekimai iš saugyklos gali būti rodomi Jūsų pasiekimų ir profilio puslapyje.

Šioje srityje Jūs galite pasirinkti, kuriuos pasiekimus iš savo saugyklos norėtumėte rodyti Jūsų profilyje.';
$string['backpackprovider'] = 'Pasiekimų talpyklos tiekėjas';
$string['backpacksettings'] = 'Pasiekimų talpyklos nuostatos';
$string['backpackweburl'] = 'Pasiekimų talpyklos URL';
$string['badgedetails'] = 'Pasiekimo detalės';
$string['badgeimage'] = 'Paveikslėlis';
$string['badgeimage_help'] = 'Vaizdas turi būti bent 300 x 300 pikselių dydžio. Jis bus rodomas kaip 300 x 300 pikselių ženklelio puslapyje ir 100 x 100 pikselių naudotojo profilio puslapyje.';
$string['badgeissued'] = 'Pasiekimas išduotas';
$string['badgeprivacysetting'] = 'Pasiekimo privatumo nustatymai';
$string['badgeprivacysetting_help'] = 'Pasiekimai, kuriuos Jūs gaunate, gali būti rodomi Jūsų paskyros profilio puslapyje. Šis nustatymas leidžia Jums automatiškai nustatyti naujai gautų pasiekimų matomumą.

Jūs vis dar galėsite nustatyti atskirų pasiekimų privatumo nustatymus savo pasiekimų puslapyje.';
$string['badgeprivacysetting_str'] = 'Mano profilio puslapyje automatiškai rodyti mano gautus pasiekimus';
$string['badges'] = 'Pasiekimai';
$string['badgesalt'] = 'Apsauginis kodas gavėjo el.pašto adresui';
$string['badgesalt_desc'] = 'Naudodamos apsauginį kodą, saugyklos gali patvirtinti pasiekimo gavėją, be būtinybės parodyti jo el.pašto adresą. Šioje nuostatoje turėtų būti naudojamos tik raidės ir skaičiai.

Pastaba: Pradėjus skirti pasiekimus, gavėjo patikrinimo tikslu, prašome nekeisti šios nuostatos.';
$string['badgesdisabled'] = 'Šioje svetainėje pasiekimai neįgalinti';
$string['badgesearned'] = 'Gauta pasiekimų: {$a}';
$string['badgesettings'] = 'Pasiekimų nustatymai';
$string['badgestatus_0'] = 'Neprieinamas';
$string['badgestatus_1'] = 'Prieinamas';
$string['badgestatus_2'] = 'Neprieinamas (kriterijai užrakinti)';
$string['badgestatus_3'] = 'Prieinamas (kriterijai užrakinti)';
$string['badgestatus_4'] = 'Archyvuotas';
$string['badgestoearn'] = 'Galimų pasiekimų skaičius: {$a}';
$string['badgesview'] = 'Kurso pasiekimai';
$string['badgetags'] = 'Pasiekimo žymos';
$string['badgeurl'] = 'Gauto pasiekimo nuoroda';
$string['balignment'] = 'Lygiavimai ({$a})';
$string['bawards'] = 'Gavusiųjų sąrašas ({$a})';
$string['bcriteria'] = 'Kriterijus';
$string['bdetails'] = 'Keisti detales';
$string['bendorsement'] = 'Patvirtinimas';
$string['bmessage'] = 'Pranešimas';
$string['boverview'] = 'Apžvalga';
$string['brelated'] = 'Susiję pasiekimai ({$a})';
$string['bydate'] = 'baigė';
$string['claim'] = 'Reikalauti';
$string['claimcomment'] = 'Patvirtinimo komentaras';
$string['claimid'] = 'Reikalauti URL';
$string['clearsettings'] = 'Išvalyti nuostatas';
$string['completioninfo'] = 'Šis pasiekimas skirtas už atlikimą:';
$string['completionnotenabled'] = 'Kurso baigimas nėra įgalintas šiame kurse, todėl tai negali būti naudojama kaip kriterijus. Kurso baigimas gali būti įgalintas kurso nustatymuose.';
$string['configenablebadges'] = 'Jei įjungta, ši funkcija leidžia kurti pasiekimus ir juos suteikti svetainės naudotojams.';
$string['configuremessage'] = 'Pasiekimo pranešimas';
$string['connect'] = 'Prijungti';
$string['connected'] = 'Prijungta';
$string['connecting'] = 'Jungiama...';
$string['contact'] = 'Išleidėjo kontaktai';
$string['contact_help'] = 'El.pašto adresas susietas su pasiekimo suteikėju.';
$string['copy'] = 'Kopijuoti';
$string['copyof'] = '{$a} kopija';
$string['course'] = 'Kursas: {$a}';
$string['coursebadges'] = 'Pasiekimai';
$string['coursebadgesdisabled'] = 'Kurso pasiekimai nėra įgalinti šioje svetainėje.';
$string['coursebadgetitle'] = '{$a} kurso pasiekimas';
$string['coursecompletion'] = 'Naudotojas turi baigti šį kursą.';
$string['create'] = 'Naujas pasiekimas';
$string['createbutton'] = 'Kurti pasiekimą';
$string['creatorbody'] = '<p>{$a->user} įvykdė visus pasiekimo reikalavimus ir buvo už tai apdovanotas. Peržiūrėkite paskirtą pasiekimą čia {$a->link}</p>';
$string['creatorsubject'] = '"{$a}" buvo apdovanotas!';
$string['criteria_0'] = 'Šis pasiekimas skiriamas kada...';
$string['criteria_1'] = 'Įvykdyta veikla';
$string['criteria_1_help'] = 'Leidžia skirti pasiekimą kai naudotojas įvykdo reikalavimus nustatytus paskaitoje.';
$string['criteria_2'] = 'Rankinis paskyrimas pagal vaidmenis';
$string['criteria_2_help'] = 'Leidžia skirti pasiekimą rankiniu būdu naudotojams, kurie turi atitinkamą vaidmenį svetainėje ar kurse.';
$string['criteria_3'] = 'Socialinis dalyvavimas';
$string['criteria_3_help'] = 'Socialinis';
$string['criteria_4'] = 'Kurso baigimas';
$string['criteria_4_help'] = 'Leidžia gauti pasiekimą naudotojams, kurie baigia kursą. Šis kriterijus gali turėti papildomų parametrų tokių kaip minimalus įvertinimas bei kurso baigimo data.';
$string['criteria_5'] = 'Kurso rinkinio baigimas';
$string['criteria_5_help'] = 'Leidžia gauti pasiekimą naudotojams, kurie baigia kursų rinkinį. Kiekvienas kursas gali turėti papildomų parametrų tokių kaip minimalus įvertinimas bei kurso baigimo data.';
$string['criteria_6'] = 'Profilio užpildymas';
$string['criteria_6_help'] = 'Leidžia gauti pasiekimą naudotojams, kurie užpildo kai kuriuos profilio laukus. Jūs galite pasirinkti numatytus ir savus profilio laukus, kurie bus prieinami naudotojams.';
$string['criteria_7'] = 'Gauti pasiekimai';
$string['criteria_7_help'] = 'Leidžia pasiekimą suteikti naudotojams pagal kitus jų uždirbtus pasiekimus.';
$string['criteria_8'] = 'Junginio narystė';
$string['criteria_8_help'] = 'Leidžia suteikti pasiekimą naudotojams, atsižvelgiant į grupės narystę.';
$string['criteria_9'] = 'Kompetencijos';
$string['criteria_9_help'] = 'Leidžia suteikti naudotojams pasiekimą pagal jų įgytas kompetencijas.';
$string['criteria_descr'] = 'Naudotojai gaus šį pasiekimą kai jie įvykdys sekančius reikalavimus:';
$string['criteria_descr_0'] = 'Atlikti<strong>{$a}</strong> iš išvardytų reikalavimų.';
$string['criteria_descr_1'] = 'Baigta <strong>{$a}</strong> sekančių veiklų';
$string['criteria_descr_2'] = 'This badge has to be awarded by the users with <strong>{$a}</strong> of the following roles';
$string['criteria_descr_4'] = 'Naudotojai turi baigti šį kursą';
$string['criteria_descr_5'] = 'Reikia baigti <strong>{$a}</strong> sekančių kursų:';
$string['criteria_descr_6'] = 'Reikia užildyti <strong>{$a}</strong> sekančių naudotojo profilio laukų:';
$string['criteria_descr_7'] = 'Turite uždirbti <strong>{$a}</strong> iš šių pasiekimų:';
$string['criteria_descr_8'] = 'Būtina narystė <strong>{$a}</strong> iš toliau nurodytų grupių:';
$string['criteria_descr_9'] = 'Turi būti baigtos <strong>{$a}</strong> iš šių kompetencijų:';
$string['criteria_descr_bydate'] = 'pagal <em>{$a}</em>';
$string['criteria_descr_grade'] = 'mažiausias įvertinimas <em>{$a}</em>';
$string['criteria_descr_short0'] = 'Baigta <strong>{$a}</strong>:';
$string['criteria_descr_short1'] = 'Baigta <strong>{$a}</strong>:';
$string['criteria_descr_short2'] = 'Skyrė <strong>{$a}</strong> iš:';
$string['criteria_descr_short4'] = 'Baikit šį kursą';
$string['criteria_descr_short5'] = 'Baigta <strong>{$a}</strong>:';
$string['criteria_descr_short6'] = 'Baigta <strong>{$a}</strong>:';
$string['criteria_descr_short7'] = 'Baigti <strong>{$a}</strong> iš:';
$string['criteria_descr_short8'] = 'Grupės narystė <strong>{$a}</strong> iš:';
$string['criteria_descr_short9'] = 'Užbaigta <strong>{$a}</strong> iš:';
$string['criteria_descr_single_1'] = 'Sekančios veiklos turi būti baigtos:';
$string['criteria_descr_single_2'] = 'Šis pasiekimas turi būti skirtas naudotojo turinčio tokį vaidmenį:';
$string['criteria_descr_single_4'] = 'Naudotojai turi baigti kursą';
$string['criteria_descr_single_5'] = 'Šie kursai turi būti baigti:';
$string['criteria_descr_single_6'] = 'Sekantys naudotojo profilio laukai turi būti baigti:';
$string['criteria_descr_single_7'] = 'Turi būti pelnytas pasiekimas:';
$string['criteria_descr_single_8'] = 'Būtina narystė šioje grupėje:';
$string['criteria_descr_single_9'] = 'Turi būti įgytos šios kompetencijos:';
$string['criteria_descr_single_short1'] = 'Baigta:';
$string['criteria_descr_single_short2'] = 'Skyrė:';
$string['criteria_descr_single_short4'] = 'Baikite kursą';
$string['criteria_descr_single_short5'] = 'Baigta:';
$string['criteria_descr_single_short6'] = 'Baigta:';
$string['criteria_descr_single_short7'] = 'Užbaigta:';
$string['criteria_descr_single_short8'] = 'Narystė:';
$string['criteria_descr_single_short9'] = 'Užbaigti:';
$string['criteriacreated'] = 'Pasiekimo kriterijus sėkmingai sukurtas';
$string['criteriadeleted'] = 'Pasiekimo kriterijus sėkmingai ištrintas';
$string['criteriasummary'] = 'Kriterijaus apžvalga';
$string['criteriaupdated'] = 'Pasiekimo kriterijus sėkmingai atnaujintas';
$string['criterror'] = 'Dabartinės parametrų problemos';
$string['criterror_help'] = 'Šis laukų rinkinys rodo visus parametrus, kurie buvo priskirti prie pasiekimo gavimo sąlygų, tačiau jų daugiau nebėra. Rekomenduojama, kad Jūs nuimtumėte šiuos parametrų pasirinkimus, tam kad būtų galima gauti pasiekimą ateityje.';
$string['currentimage'] = 'Dabartinis paveikslėlis';
$string['currentstatus'] = 'Dabartinė būklė:';
$string['dateawarded'] = 'Suteikimo data';
$string['dateearned'] = 'Data: {$a}';
$string['day'] = 'Diena(-os)';
$string['deactivate'] = 'Išjungti prieigą';
$string['deactivatesuccess'] = 'Pasiekimas {$a} išjungtas.';
$string['defaultissuercontact'] = 'Numatytasis pasiekimo suteikėjo el. pašto adresas';
$string['defaultissuercontact_desc'] = 'El. pašto adresas, susietas su pasiekimo išdavėju. „Open Badges“ v2.0 pasiekimų talpykloje tai naudojama autentifikavimui, kai pasiekimai dedami į pasiekimų talpyklą.';
$string['defaultissuername'] = 'Pasiekimo suteikėjo vardas';
$string['defaultissuername_desc'] = 'Pasiekimą suteikiančio agento ar įstaigos pavadinimas.';
$string['defaultissuerpassword'] = 'Pasiekimo išdavėjo slaptažodis';
$string['defaultissuerpassword_help'] = 'Pasiekimų talpyklos svetainėje reikalinga paskyra su el. pašto adresu, nurodytu pasiekimo išdavėjo el. pašto adreso nustatyme Svetainės administravimas / Pasiekimai/ Pasiekimų nustatymai nustatymuose. Čia reikia įvesti paskyros slaptažodį.';
$string['delbadge'] = 'Ar Jūs norėtumėte ištrinti \'{$a}\' pasiekimą ir pašalinti visus šiuos išduotus pasiekimus?';
$string['delconfirm'] = 'Ar Jūs tikrai norite ištrinti \'{$a}\' pasiekimą?';
$string['delcritconfirm'] = 'Ar Jūs tikrai norite ištrinti šį kriterijų?';
$string['deletehelp'] = '<p>Pilnas pasiekimo pašalinimas reiškia, kad visa informacija ir kriterijų įrašai susiję su šiuo pasiekimu bus pašalinta VISAM laikui. Naudotojai, kuriems buvo skirtas šis pasiekimas nebegalės jo pasiekti ir rodyti savo profilio puslapyje.</p>
<p>Pastaba: naudotojai, kurie gavo šį pasiekimą ir perkėlė jį į išorinę saugyklą, galės jį pasiekti išorinėje saugykloje. Tačiau, jie negalės pasiekti suteikimo kriterijų sąrašo ir įrodymų puslapio į kurį turėtų būti nukreipiamas naudotojas</p>';
$string['delexternalbackpack'] = 'Ištrinti svetainės pasiekimų talpyklą';
$string['delexternalbackpackconfirm'] = 'Ištrinti svetainės pasiekimų talpyklą „{$a}“?';
$string['delparamconfirm'] = 'Ar Jūs tikrai norite ištrinti šį parametrą?';
$string['description'] = 'Aprašas';
$string['disconnect'] = 'Atjungti';
$string['donotaward'] = 'Šiuo metu šis pasiekimas yra neaktyvus, todėl jis negali būti skirtas naudotojams. Jei Jūs norėtumėte skirti šį pasiekimą, prašome pakeisti jo būklę į aktyvią.';
$string['enablebadges'] = 'Įgalinti pasiekimus';
$string['endorsement'] = 'Patvirtinimas';
$string['error:backpackdatainvalid'] = 'Iš saugyklos gauti duomenys buvo neteisingi.';
$string['error:backpackemailnotfound'] = '\'{$a}\' el.pašto adresas nėra susietas su saugykla. Jums reikia <a href="http://backpack.openbadges.org">sukurti saugyklą</a> šiam naudotojui arba prisijungti su kitu el.pašto adresu.';
$string['error:badgeawardnotfound'] = 'Nepavyko patvirtinti šio suteikto pasiekimo. Šis pasiekimas gali būti atšauktas.';
$string['error:badgenotfound'] = 'Pasiekimas nerastas';
$string['error:cannotact'] = 'Nepavyko aktyvuoti pasiekimo.';
$string['error:cannotawardbadge'] = 'Nepavyksta skirti pasiekimo naudotojui.';
$string['error:cannotdeletecriterion'] = 'Šis kriterijus negali būti ištrintas.';
$string['error:cannotrevokebadge'] = 'Negalima panaikinti naudotojo pasiekimo.';
$string['error:clone'] = 'Nepavyksta klonuoti pasiekimo.';
$string['error:connectionunknownreason'] = 'Prisijungti nepavyko, tačiau priežasčių paaiškinimas negautas.';
$string['error:duplicatename'] = 'Pasiekimas su tokiu pavadinimu jau yra sistemoje.';
$string['error:externalbadgedoesntexist'] = 'Pasiekimas nerastas';
$string['error:guestuseraccess'] = 'Jūs šiuo metu prisijungę svečio teisėmis. Norėdami pamatyti pasiekimus, Jūs turite prisijungti su aktyvia naudotojo paskyra.';
$string['error:invalidcriteriatype'] = 'Neteisingas kriterijaus tipas.';
$string['error:invalidexpiredate'] = 'Galiojimo pabaigos laikas turi būti ateityje.';
$string['error:invalidexpireperiod'] = 'Galiojimo laikotarpis negali būti neigiamas arba lygus nuliui.';
$string['error:invalidparambadge'] = 'Pasiekimas neegzistuoja';
$string['error:invalidparamcohort'] = 'Junginiai neegzistuoja.';
$string['error:noactivities'] = 'Šiame kurse nėra veiklų, kurioms įgalintas baigimo kriterijus.';
$string['error:nobadges'] = 'Šiuo metu nėra pasiekimų su įgalinta prieiga, kuriuos būtų galima įtraukti kaip kriterijus. Svetainės pasiekimo kriterijai gali būti tik kiti svetainės pasiekimai. Kurso pasiekime kaip kriterijai gali būti kiti kurso pasiekimai arba svetainės pasiekimai.';
$string['error:nocohorts'] = 'Nėra junginio';
$string['error:nocourses'] = 'Nei viename šios svetainės kurse nėra įgalintas kurso baigimas, todėl nei vienas negali būti atvaizduotas. Kurso baigimas gali būti įgalintas kurso nuostatuose.';
$string['error:nogroupslink'] = '<p>Rodomos tik viešosios kolekcijos. <a href="{$a}" target="_blank" rel="nofollow">Apsilankykite savo pasiekimų talpykloje</a> ir sukurkite viešųjų kolekcijų.</p>';
$string['error:nogroupssummary'] = '<p>Jūsų pasiekimų talpykloje nėra viešų pasiekimų kolekcijų. </p>';
$string['error:nopermissiontoview'] = 'Jūs neturite teisių peržiūrėti pasiekimo gavėjų';
$string['error:nosuchbadge'] = 'Pasiekimas, kurio id yra {$a}, neegzistuoja.';
$string['error:nosuchcohort'] = 'Įspėjimas: ši grupė nebepasiekiama.';
$string['error:nosuchcourse'] = 'Dėmesio: šis kursas nebeegzistuoja.';
$string['error:nosuchfield'] = 'Dėmesio: šis naudotojo profilio laukas daugiau nebeprieinamas.';
$string['error:nosuchmod'] = 'Dėmesio: ši veikla nebeprieinama.';
$string['error:nosuchrole'] = 'Dėmesio: šis vaidmuo daugiau nebeegzistuoja.';
$string['error:nosuchuser'] = 'Naudotojas su nurodytu el. pašto adresu neturi savo paskyros šiuo metu susietoje talpykloje.';
$string['error:notifycoursedate'] = 'Su kurso ir veiklų baigimu susiję pasiekimai bus išduodami tik po kurso pradžios datos ({$a}).';
$string['error:parameter'] = 'Įspėjimas: turi būti parinktas bent vienas parametras siekiant korektiško pasiekimo išdavimo.';
$string['error:relatedbadgedoesntexist'] = 'Nėra viešo pasiekimo su šiuo identifikatoriumi';
$string['error:requesterror'] = 'Nepavyko prisijungti (klaidos kodas {$a}).';
$string['error:requesttimeout'] = 'Prisijungimui skirtas laikas baigėsi, nespėjus prisijungti.';
$string['error:save'] = 'Nepavyko išsaugoti pasiekimo.';
$string['error:userdeleted'] = '{$a->user} (Šio naudotojo nebėra čia: {$a->site})';
$string['eventbadgearchived'] = 'Pasiekimas archyve';
$string['eventbadgeawarded'] = 'Pasiekimas suteiktas';
$string['eventbadgecreated'] = 'Pasiekimas sukurtas';
$string['eventbadgecriteriacreated'] = 'Pasiekimo kriterijus sukurtas';
$string['eventbadgecriteriadeleted'] = 'Pasiekimo kriterijus panaikintas';
$string['eventbadgecriteriaupdated'] = 'Pasiekimo kriterijus atnaujintas';
$string['eventbadgedeleted'] = 'Pasiekimas panaikintas';
$string['eventbadgedisabled'] = 'Pasiekimas išjungtas';
$string['eventbadgeduplicated'] = 'Pasiekimo kopija sukurta';
$string['eventbadgeenabled'] = 'Pasiekimas įgalintas';
$string['eventbadgelistingviewed'] = 'Pasiekimų sąrašas peržiūrėtas';
$string['eventbadgerevoked'] = 'Pasiekimas atšauktas';
$string['eventbadgeupdated'] = 'Pasiekimas atnaujintas';
$string['eventbadgeviewed'] = 'Pasiekimai peržiūrėti';
$string['existingrecipients'] = 'Esami pasiekimo gavėjai';
$string['existsinbackpack'] = 'Pasiekimas jau yra pasiekimų talpykloje';
$string['expired'] = 'Nebegalioja';
$string['expiredate'] = 'Pasiekimas nebegalios {$a}.';
$string['expireddate'] = 'Šis pasiekimas baigė galioti {$a}.';
$string['expiredin'] = 'Baigėsi {$a}';
$string['expireperiod'] = 'Šio pasiekimo galiojimas baigsis po {$a} d. nuo išdavimo datos.';
$string['expireperiodh'] = 'Šio pasiekimo galiojimas baigsis po {$a} val. nuo išdavimo datos.';
$string['expireperiodm'] = 'Šio pasiekimo galiojimas baigsis po {$a} min. nuo išdavimo datos.';
$string['expireperiods'] = 'Šio pasiekimo galiojimas baigsis po {$a} sek. nuo išdavimo datos.';
$string['expiresin'] = 'Baigiasi {$a}';
$string['expirydate'] = 'Galiojimo laikas';
$string['expirydate_help'] = 'Pasirinktinai, pasiekimai gali galioti iki tam tikros datos arba galiojimas gali būti paskaičiuotas nuo išdavimo datos.';
$string['externalbackpack_required'] = 'Saugyklos teikėjo laukas negali būti tuščias';
$string['externalbadges'] = 'Mano pasiekimai iš kitų tinklalapių';
$string['externalbadges_help'] = 'Čia rodomi pasiekimai gauti iš Jūsų išorinių saugyklų.';
$string['externalbadgesp'] = 'Pasiekimai iš kitų tinklalapių:';
$string['externalconnectto'] = 'Norint rodyti pasiekimus saugomus išorinėje saugykloje, Jums reikia <a href="{$a}"> prisijungti prie jos</a>';
$string['fixed'] = 'Fiksuota data';
$string['hidden'] = 'Paslėptas';
$string['hiddenbadge'] = 'Deja, tačiau pasiekimo savininkas neviešina šios informacijos.';
$string['hostedurl'] = 'Išorinis URL';
$string['hostedurldescription'] = 'Išorinis URL, kuriame talpinamas ženkliukas';
$string['imageauthoremail'] = 'Paveiksliuko autoriaus el. pašto adresas';
$string['imageauthoremail_help'] = 'Jei nurodyta, pasiekimo paveiksliuko autoriaus el. pašto adresas rodomas pasiekimo puslapyje.';
$string['imageauthorname'] = 'Paveiksliuko autoriaus vardas';
$string['imageauthorname_help'] = 'Jei nurodyta, pasiekimo puslapyje rodomas pasiekimo paveiksliuko autoriaus vardas.';
$string['imageauthorurl'] = 'Paveiksliuko autoriaus URL';
$string['imageauthorurl_help'] = 'Jei nurodyta, pasiekimo puslapyje rodoma nuoroda į pasiekimo paveiksliuko autoriaus svetainę. URL turi turėti priešdėlį http:// arba https://.';
$string['imagecaption'] = 'Paveiksliuko antraštė';
$string['imagecaption_help'] = 'Jei nurodyta, pasiekimo puslapyje rodoma vaizdo antraštė.';
$string['includeauthdetails'] = 'Į pasiekimų talpyklą įtraukti autentifikavimo duomenis';
$string['invalidurl'] = 'Neteisingas URL';
$string['issuancedetails'] = 'Pasiekimo galiojimas';
$string['issuedbadge'] = 'Skirto pasiekimo informacija';
$string['issuedby'] = 'Išdavė {$a}';
$string['issuedon'] = 'Išduotas {$a}';
$string['issuerdetails'] = 'Suteikėjo detalesnė informacija';
$string['issueremail'] = 'El. paštas';
$string['issueremail_help'] = 'Organizacijos, patvirtinančios išdavimą, kontaktinis el. pašto adresas.';
$string['issuername'] = 'Suteikėjo vardas';
$string['issuername_endorsement'] = 'Patvirtinančiojo vardas';
$string['issuername_endorsement_help'] = 'Patvirtinančiojo vardas.';
$string['issuername_help'] = 'Pasiekimą suteikiančio agento ar įstaigos pavadinimas.';
$string['issuerurl'] = 'Suteikėjo URL';
$string['issuerurl_help'] = 'Organizacijos, patvirtinančios išdavimą, svetainės adresas. Svetainės URL turėtų prasidėti http: // arba https: //.';
$string['language'] = 'Kalba';
$string['language_help'] = 'Pasiekimo puslapyje naudojama kalba.';
$string['listbackpacks'] = 'Pasiekimų talpyklų sąrašas';
$string['localbadges'] = 'Mano pasiekimai iš {$a} tinklalapio';
$string['localbadgesh'] = 'Mano pasiekimai iš šio tinklalapio';
$string['localbadgesh_help'] = 'Visi pasiekimai, kurie gauti šioje svetainėje užbaigiant kursus, kursų veiklas bei kitus reikalavimus.

Čia Jūs galite valdyti savo pasiekimus: savo profilio puslapyje padaryti juos viešais ar privačiais.

Jūs galite parsisiųsti visus savo pasiekimus arba kiekvieną atskirai ir išsaugoti juos savo kompiuteryje. Parsiųsti pasiekimai gali būti įkelti į išorines saugyklas.';
$string['localbadgesp'] = 'Pasiekimai gauti iš {$a}:';
$string['localconnectto'] = 'Norint bendrinti šiuos pasiekimus, Jums reikia <a href="{$a}">prisijungti prie talpyklos</a>.';
$string['loginbackpacktitle'] = '<strong>Prisijunkite prie savo saugyklos</strong>';
$string['makeprivate'] = 'Padaryti asmenišku';
$string['makepublic'] = 'Padaryti viešu';
$string['managebackpacks'] = 'Tvarkyti pasiekimų talpyklas';
$string['managebadges'] = 'Tvarkyti pasiekimus';
$string['message'] = 'Pranešimo tekstas';
$string['messagebody'] = '<p>Jums skirtas pasiekimas „%badgename%“!</p>
<p>Daugiau informacijos apie šį pasiekimą galima rasti pasiekimo aprašymo puslapyje %badgelink%.</p>
<p>Jūs galite savo pasiekimus valdyti bei parsisiųsti iš šio puslapio: {$a}</p>';
$string['messagesubject'] = 'Sveikiname! Jūs uždirbote pasiekimą!';
$string['method'] = 'Šis kriterijus yra įvykdytas kai...';
$string['mingrade'] = 'Reikalaujamas minimalus įvertinimas';
$string['month'] = 'Mėnuo (-siai)';
$string['moredetails'] = 'Daugiau informacijos';
$string['mybackpack'] = 'Mano saugyklos nuostatos';
$string['mybadges'] = 'Mano pasiekimai';
$string['namewithlink'] = 'Pavadinimas su nuoroda';
$string['never'] = 'Niekada';
$string['newbackpack'] = 'Pridėti naują pasiekimų talpyklą';
$string['newbadge'] = 'Pridėti naują pasiekimą';
$string['newimage'] = 'Naujas paveikslėlis';
$string['noalignment'] = 'Šis pasiekimas nenurodo jokių išorinių įgūdžių ar standartų.';
$string['noawards'] = 'Šis pasiekimas dar neuždirbtas';
$string['nobackpack'] = 'Prie šios paskyros nėra susietos pasiekimų talpyklos paslaugos.<br/>';
$string['nobackpackbadgessummary'] = 'Jūsų pasirinktose kolekcijose nėra pasiekimų.';
$string['nobackpackcollectionssummary'] = 'Nepasirinkta jokių pasiekimų kolekcijų.';
$string['nobackpacks'] = 'Nėra galimų pasiekimų talpyklų';
$string['nobadges'] = 'Šiuo metu nėra pasiekimų, kuriuos naudotojai galėtų užsidirbti.';
$string['nocompetencies'] = 'Nėra pasirinktų kompetencijų';
$string['nocriteria'] = 'Šiam pasiekimui dar nenustatyti kriterijai.';
$string['noendorsement'] = 'Šis pasiekimas neturi patvirtinimo.';
$string['noexpiry'] = 'Šis pasiekimas neturi nustatyto galiojimo laiko.';
$string['nomatchingawards'] = 'Dar nėra šį pasiekimą gavusių dalyvių.';
$string['noparamstoadd'] = 'Šiam pasiekimo reikalavimui nėra papildomų parametrų.';
$string['norelated'] = 'Šis pasiekimas neturi jokių susijusių pasiekimų.';
$string['notacceptedrole'] = 'Jūsų turimas vaidmuo neleidžia pačiam suteikti šį pasiekimą. <br/>
Jei Jūs norite pamatyti vartotojus, kurie jau gavo šį pasiekimą, peržiūrėkite juos šiame {$a} puslapyje.';
$string['notconnected'] = 'Neprisijungta';
$string['notealignment'] = 'Gali būti nurodyti išoriniai įgūdžiai ar standartai, kuriuos pasiekimas atitinka. Visi išoriniai įgūdžiai ar standartai rodomi pasiekimo puslapyje.';
$string['noteendorsement'] = 'Trečiosios šalies patvirtinimas gali būti naudojamas pasiekimo aprašymo reikšmių papildymui. Pvz.: dėstytojas gali naudoti pasiekimą, kurio išdavimą patvirtina mokykla arba vietos apdovanojimo įstaigos išduotas pasiekimas gali būti patvirtintas nacionalinės apdovanojimų tarnybos.';
$string['noterelated'] = 'Pasiekimai su ryšiu gali būti pažymėti kaip susiję. Pavyzdžiui, pasiekimai su tais pačiais kriterijais, kurie rodomi skirtingomis kalbomis, gali būti pažymėti kaip susiję. Visi susiję pasiekimai rodomi pasiekimo puslapyje.';
$string['nothingtoadd'] = 'Nėra kriterijų, kuriuos galima įtraukti.';
$string['notification'] = 'Informuoti pasiekimo sukūrėją';
$string['notification_help'] = 'Ši nuostata valdo pranešimo siuntimą sukūrėjui, suteikiant galimybę sužinoti kada pasiekimas suteikiamas.
Yra šie pasirinkimai:

* **NIEKADA** - Nesiųsti pranešimų.

* **KIEKVIENĄ KARTĄ** - Siųsti pranešimus kiekvieną kartą, kai pasiekimas suteikiamas.

* **KASDIEN** - Siųsti pranešimus kartą per dieną.

* **KARTĄ Į SAVAITĘ** - Siųsti pranešimus kartą per savaitę.

* **KARTĄ Į MĖNESĮ** - Siųsti pranešimus kartą per mėnesį.';
$string['notifydaily'] = 'Kasdien';
$string['notifyevery'] = 'Kiekvieną kartą';
$string['notifymonthly'] = 'Kas mėnesį';
$string['notifyweekly'] = 'Kas savaitę';
$string['numawards'] = 'Naudotojų gavusių pasiekimą „{$a->badgename}“ skaičius: <a href="{$a->link}">{$a->count}</a>.';
$string['numawardstat'] = 'Naudotojai gavę pasiekimą „{$a->badgename}“: {$a->awards}.';
$string['oauth2issuer'] = 'OAuth 2 paslaugos';
$string['openbadgesv1'] = 'Open Badges v1.0';
$string['openbadgesv2'] = 'Open Badges v2.0';
$string['openbadgesv2p1'] = 'Open Badges v2.1';
$string['othernavigation'] = 'Kita navigacija...';
$string['overallcrit'] = 'iš pasirinktų kriterijų yra įvykdyti.';
$string['password_required'] = 'Slaptažodžio laukas negali būti tuščias';
$string['potentialrecipients'] = 'Tikėtini pasiekimo gavėjai';
$string['preferences'] = 'Pasiekimo nustatymai';
$string['privacy:metadata:backpack'] = 'Naudotojo pasiekimų talpyklų įrašas';
$string['privacy:metadata:backpack:backpackuid'] = 'Pasiekimų talpyklos unikalus identifikatorius';
$string['privacy:metadata:backpack:email'] = 'Su pasiekimų talpykla susietas el. pašto adresas';
$string['privacy:metadata:backpack:externalbackpackid'] = 'Pasiekimų talpyklos ID';
$string['privacy:metadata:backpack:userid'] = 'Naudotojo, kurio yra pasiekimų talpykla, ID';
$string['privacy:metadata:backpackoauth2'] = 'OAuth 2 informacija, kai naudotojas prisijungia prie išorinės pasiekimų talpyklos';
$string['privacy:metadata:backpackoauth2:issuerid'] = '„OAuth 2“ paslaugos ID';
$string['privacy:metadata:backpackoauth2:scope'] = 'Pasiekimų talpyklos prijungimo apimties sąrašas';
$string['privacy:metadata:backpackoauth2:token'] = 'Pasiekimų talpyklos prisijungimo prieigos raktas';
$string['privacy:metadata:backpackoauth2:userid'] = 'Naudotojo prisijungimo prie pasiekimų talpyklos ID';
$string['privacy:metadata:backpackoauth2:usermodified'] = 'Naudotojo pakeisto prisijungimo ID';
$string['privacy:metadata:badge'] = 'Pasiekimų rinkinys';
$string['privacy:metadata:badge:timecreated'] = 'Laikas, kada buvo sukurtas pasiekimas';
$string['privacy:metadata:badge:timemodified'] = 'Laikas, kada pasiekimas buvo paskutinį kartą keistas';
$string['privacy:metadata:badge:usercreated'] = 'Naudotojo, kuris sukūrė pasiekimą, ID';
$string['privacy:metadata:badge:usermodified'] = 'Pasiekimą pakeitusio naudotojo ID';
$string['privacy:metadata:criteriamet'] = 'Kriterijų rinkinys, kuris buvo įvykdytas';
$string['privacy:metadata:criteriamet:datemet'] = 'Data, kada buvo įvykdyti kriterijai';
$string['privacy:metadata:criteriamet:userid'] = 'Naudotojo, kuris atitiko kriterijus, ID';
$string['privacy:metadata:external:backpacks'] = 'Informacija bendrinama, kai naudotojai pateikia savo pasiekimus į išorinę pasiekimų talpyklą';
$string['privacy:metadata:external:backpacks:badge'] = 'Pasiekimo pavadinimas';
$string['privacy:metadata:external:backpacks:description'] = 'Pasiekimo aprašymas';
$string['privacy:metadata:external:backpacks:image'] = 'Pasiekimo paveiksliukas';
$string['privacy:metadata:external:backpacks:issuer'] = 'Šiek tiek informacijos apie išdavėją';
$string['privacy:metadata:external:backpacks:url'] = 'Moodle URL, kuriame galima pamatyti išduoto pasiekimo informaciją';
$string['privacy:metadata:issued'] = 'Įteiktų pasiekimų rekordas';
$string['privacy:metadata:issued:dateexpire'] = 'Data, kada baigiasi pasiekimo galiojimo laikas';
$string['privacy:metadata:issued:dateissued'] = 'Pasiekimo gavimo data';
$string['privacy:metadata:issued:userid'] = 'Naudotojo, kuriam buvo suteiktas pasiekimas, ID';
$string['privacy:metadata:manualaward'] = 'Rankinių apdovanojimų įrašas';
$string['privacy:metadata:manualaward:datemet'] = 'Data, kada naudotojui buvo suteiktas pasiekimas';
$string['privacy:metadata:manualaward:issuerid'] = 'Pasiekimą suteikusio naudotojo ID';
$string['privacy:metadata:manualaward:issuerrole'] = 'Pasiekimą suteikiančio naudotojo vaidmuo';
$string['privacy:metadata:manualaward:recipientid'] = 'Naudotojo, kuriam rankiniu būdu suteiktas pasiekimas, ID';
$string['recipient'] = 'Pasiekimo gavėjas';
$string['recipients'] = 'Pasiekimo gavėjai';
$string['recipientvalidationproblem'] = 'Šis naudotojas negali būti patikrintas kaip šio pasiekimo gavėjas.';
$string['relatedbages'] = 'Susiję pasiekimai';
$string['relative'] = 'Santykinė data';
$string['requiredbadge'] = 'Prie pasiekimo kriterijaus reikia pridėti bent vieną pasiekimą.';
$string['requiredcohort'] = 'Prie kohortos kriterijaus reikia pridėti bent vieną grupę.';
$string['requiredcompetency'] = 'Prie kompetencijos kriterijaus reikėtų pridėti bent vieną kompetenciją.';
$string['requiredcourse'] = 'Į kursų rinkinio kriterijų turi būti įtrauktas bent vienas kursas.';
$string['reviewbadge'] = 'Pasiekimo pasiekiamumo pasikeitimai';
$string['reviewconfirm'] = '<p>Tai padarys Jūsų sukurtą pasiekimą matomą naudotojams ir leis jiems jį uždirbti. </p>

<p>Įmanoma, kad kai kurie naudotojai jau atitinka šio pasiekimo kriterijus ir jį gaus iškart po to kai Jūs jį įgalinsite.</p>

<p>Kai pasiekimas bus suteiktas, jis bus <strong>užrakintas</strong> - kai kurie nustatymai, įskaitant kriterijus ir galiojimo laiką, bus nebekeičiami.</p>

<p>Ar Jūs tikrai norite įgalinti prieigą prie \'{$a}\' pasiekimo?</p>';
$string['revoke'] = 'Atšaukti pasiekimą';
$string['save'] = 'Išsaugoti';
$string['searchname'] = 'Ieškoti pagal pavadinimą';
$string['selectaward'] = 'Prašome pasirinkti vaidmenis, kurie galės skirti pasiekimą:';
$string['selectgroup_end'] = 'Rodomos tik viešos kolekcijos. <a href="{$a}">Apsilankykite savo saugykloje</a> norėdami sukurti daugiau viešų kolekcijų.';
$string['selectgroup_start'] = 'Pasirinkite kolekcijas iš savo saugyklas, kurias norėtumėte rodyti šioje svetainėje:';
$string['selecting'] = 'Su pasirinktais pasiekimais...';
$string['setup'] = 'Nustatyti prisijungimą';
$string['sitebackpackdeleted'] = 'Svetainės pasiekimų talpykla ištrinta.';
$string['sitebackpacknotdeleted'] = 'Šios pasiekimų talpyklos nepavyko ištrinti, nes šiuo metu ji yra svetainės numatytoji.';
$string['sitebackpackwarning'] = 'Nepavyko prisijungti prie pasiekimų talpyklos. <br/><br/>Patikrinkite, ar administratoriaus nustatymas „Pasiekimo išdavėjo el. pašto adresas“ yra galiojantis pasiekimų talpyklos svetainės paskyros el. paštas. <br/><br/>Patikrinkite, ar „Pasiekimo išdavėjo slaptažodis“ <a href="{$a->url}">svetainės pasiekimų talpyklos nustatymų puslapyje</a> yra teisingas paskyros slaptažodis. <br/><br/>Pasiekimų talpykla gražino: „{$a->warning}“';
$string['sitebadges'] = 'Svetainės pasiekimai';
$string['sitebadges_help'] = 'Svetainės pasiekimai gali būti suteikiami naudotojams tiktai už veiklas susijusias su pačia svetaine (globaliai). Tai galėtų būti kursų rinkinio baigimas ar naudotojo profilio tam tikrų laukų užpildymas. Svetainės pasiekimai taip pat gali būti skirti neautomatiškai, vieno naudotojo kitam.

Pasiekimai už veiklas susijusias su kursu turi būti kuriami kursų lygmeniu. Kursų pasiekimai pasiekiami Kursų informacija->Pasiekimai.';
$string['sitebadgetitle'] = '{$a} svetainės ženkliukas';
$string['status'] = 'Pasiekimo būsena';
$string['status_help'] = 'Pasiekimo būsena apibūdina jo elgseną sistemoje:

***GALIMAS*** - reiškia, kad naudotojai gali gauti šį pasiekimą. Kol pasiekimą gali gauti naudotojai, jo kriterijai negali būti kečiami.

***NEPASIEKIAMAS*** - reiškia, kad šio pasiekimo naudotojai negali gauti ir jis negali būti uždirbamas ar priskiriamas rankiniu būdu. Jei šis pasiekimas niekada nebuvo  uždirbtas, jo kriterijus galima keisti.

Kada pasiekimas suteikiamas bent vienam naudotojui, jis automatiškai tampa **UŽRAKINTAS**. Naudotojai gali gauti užrakintus pasiekimus, tačiau jų kriterijų keisti nebegalima. Jei Jums reikia pakeisti užrakinto pasiekimo detales ar kriterijus, Jūs galite padaryti šio pasiekimo dublikatą ir padaryti reikiamus pakeitimus.

*Kodėl pasiekimai yra užrakinami?*

Tai daroma tam, kad būtų galima užtikrinti, kad visi naudotojai norėdami gauti pasiekimus baigs užduotis vienodomis sąlygomis. Šiuo metu negalima modifikuoti suteiktų pasiekimų. Jei būtų leidžiama visada keisti pasiekimo gavimo reikalavimus, greičiausiai viskas baigtųsi tuo, kad naudotojai gautų tą patį pasiekimą dėl skirtingų reikalavimų gavimui atitikimo.';
$string['statusmessage_0'] = 'Šis pasiekimas šiuo metu nepasiekiamas naudotojams. Jei norite, kad naudotojai galėtų gauti šį pasiekimą - įgalinkite prieigą.';
$string['statusmessage_1'] = 'Šis pasiekimas yra prieinamas naudotojams. Išjunkite prieigą, jei norite padaryti keitimus.';
$string['statusmessage_2'] = 'Šis pasiekimas šiuo metu nepasiekiamas naudotojams ir jo kriterijai yra užrakinti. Jei norite, kad naudotojai galėtų gauti šį pasiekimą - įgalinkite prieigą.';
$string['statusmessage_3'] = 'Šis pasiekimas yra prieinamas naudotojams ir jo kriterijai yra užrakinti.';
$string['statusmessage_4'] = 'Šiuo metu šis pasiekimas yra suarchyvuotas.';
$string['subject'] = 'Pranešimo tema';
$string['tagarea_badge'] = 'Pasiekimai';
$string['tags'] = 'Žymos';
$string['targetcode'] = 'Kodas';
$string['targetcode_help'] = 'Unikalus eilutės identifikatorius, nurodantis išorinį įgūdį ar standartą toje sistemoje.';
$string['targetdescription'] = 'Aprašymas';
$string['targetdescription_help'] = 'Trumpas išorinių įgūdžių ar standartų aprašymas.';
$string['targetframework'] = 'Sistema';
$string['targetframework_help'] = 'Išorinių įgūdžių arba standartinės sistemos pavadinimas.';
$string['targetname'] = 'Pavadinimas';
$string['targetname_help'] = 'Išoriniai įgūdžiai arba standartas, pagal kuriuos suderintas pasiekimas.';
$string['targeturl'] = 'URL';
$string['targeturl_help'] = 'Nuoroda į puslapį, kuriame aprašomi išoriniai įgūdžiai arba standartas. URL turi turėti priešdėlį http:// arba https://.';
$string['testbackpack'] = 'Bandomoji pasiekimų talpykla \'{$a}\'';
$string['testsettings'] = 'Bandymo nustatymai';
$string['type'] = 'Tipas';
$string['userbadges'] = 'Naudotojo pasiekimai';
$string['variablesubstitution'] = 'Kintamasis keitimui pranešime.';
$string['variablesubstitution_help'] = 'Pasiekimo gavimo pranešimo tekste ar temoje gali būti įterpti kai kurie kintamieji. Tokiu būdu jie bus pakeisti su tikromis reikšmėmis kai pranešimas bus išsiųstas. Kintamieji turi būti aprašyti taip kaip parodyta žemiau. Galima naudoti tokius kintamuosius:

%badgename%
: Bus pakeista pilnu pasiekimo pavadinimu.

%username%
: Bus pakeista pilnu gavėjo vardu.

%badgelink%
: Bus pakeista vieša URL su informacija apie paskirta pasiekimą.';
$string['verifyemail'] = 'Patvirtinkite elektroninį paštą';
$string['version'] = 'Versija';
$string['version_help'] = 'Versijos laukas gali būti naudojamas norint sekti pasiekimo kūrimą. Jei nurodyta, versija rodoma pasiekimo puslapyje.';
$string['viewbadge'] = 'Peržiūrėti skirtą pasiekimą';
$string['visible'] = 'Matomas';
$string['warnexpired'] = '(Šis pasiekimas baigė galioti!)';
$string['year'] = 'Metai (-ų)';
