<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_cubic', language 'tr', version '4.5'.
 *
 * @package     theme_cubic
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['choosereadme'] = '<div sınıfı="düzeltme">
<div class="theme_screenshot">
<h2>Kübik</h2>
<img src="cubic/pix/screenshot.png" />
</div>
<div class="theme_description">
<h2>Hakkında</h2>
<p>Cubic, Moodle 2.3 için değişken genişlikte, üç sütunlu bir temadır.  Amacı, kullanıcılara çeşitli sosyal farkındalık biçimleri ve bazı yeni kavramlar sağlayan daha kullanıcı dostu bir arayüz sağlamaktır.</p>
<h2>Düzeltmeler</h2>
<p>Bu tema, bazı yeni kavramları tanıtan ve HTML5 ve CSS3 gibi bazı yeni teknolojilerden yararlanan Moodle için temel bir temadır.</p>
<p>Bu tema, her Moodle sayfasının üst kısmında, kullanıcılara çeşitli menüler sağlayan bir kullanıcı çubuğu sunar.  Bu menülerin her biri, mevcut kullanıcı kursları, etkinlikler, bildirimler, etkinlikler, mesajlar, ayarlar ve diğerleri hakkında bilgiler içerir.</p>
<p>Bunun yanı sıra, bu tema <a href="https://moodle.org/plugins/view.php?plugin=local_institutions">Kurumları</a> ve Moodle\'daki <a href="https://moodle.org/plugins/view.php?plugin=local_applications">Uygulamalar</a> kavramları.  Kullanıcı çubuğunda bu kavramların her biri için bir menü görüntülenir.  Bu menüler, kullanıcıların sırasıyla kurumsal veya uygulama web sayfalarına erişmesini sağlar.  Hem kurumlara hem de başvuru sayfalarına Moodle\'dan çıkmadan erişilebilir.</p>
<p>Ayrıca, bu tema aynı zamanda bir sohbet hizmeti sunan yeni bir Moodle <a href="https://moodle.org/plugins/view.php?plugin=block_gchat">blok eklentisi</a> ile de ilgilidir. Google Chat veya Facebook Chat gibi herkesin kullanımına açık Moodle.</p>
<p>Kullanıcı çubuğu pek çok yararlı bilgi içerdiğinden, bazı bağlamlarda bloklara artık gerek yoktur.  Örneğin, bir sayfayı yerleştirirken, Cubic tüm yatay ve dikey alanı kullanır ve yalnızca kullanıcı çubuğunu üstte bırakır.</p>
<p>Son olarak bu tema, logolar, renkler, sistem adı ve diğerleri gibi birçok özelliği değiştirebileceğiniz bir ayarlar sayfası da sağlar.  Bu sayfada ayrıca kullanmak istemediğiniz takdirde kurum ve uygulama menülerini kullanıcı çubuğundan kaldırabilirsiniz.</p>
<h2>Krediler</h2>
<p>Bu tema, <a href="http://pessoa.fct.unl.pt/b.sampaio/index.php?language=en">Bruno Sampaio</a> tarafından kodlanmıştır ve sürdürülmektedir.  Bu temayı yaratma kararı, başta video oyunları olmak üzere eğitimde yeni teknolojilerin kullanımı ile ilgili olan yüksek lisans tezi sırasında verildi.  Moodle, <a href="http://epik.di.fct.unl.pt/epik">Epik</a> kullanılarak geliştirilen eğitici oyunları dağıtmanın bir yolu olarak seçildi ve bazı araştırmalar kullanıcısıyla ilgili bazı sorunlara işaret ettiğinden arayüzü, Kişisel Öğrenme Ortamları (PLE\'ler) kavramlarından bazılarını karşılamak için yeni bir tema oluşturulmasına karar verildi.</p>
<p>Bu tema, Cubic logosunu tasarlayan <b>André Costa</b> ve kullanılan simgelerden bazılarını tasarlayan <b>Sónia Martins</b>\'in yardımı olmasaydı bu kadar harika olmazdı.  Bunun yanı sıra, kullanılan simgelerden ve komut dizilerinden bazıları internette mevcuttur.</p>
<p>Simgeleri <a href="http://www.iconfinder.com/search/15/?q=iconset%3Asuper-mono-reflection">buradaki</a> kullanıcı çubuğunda bulabilirsiniz (oluşturulmuş <a href="http://www.doublejdesign.co.uk/">Double-J Design</a>) ve tek renkli simgeler <a href="http://www.iconfinder.com/search /?q=iconset%3Acc_mono_icon_set">burada</a> (oluşturan <a href="http://www.gentleface.com/">GentleFace</a>), her ikisi de <a href="http altında ://creativecommons.org/licenses/by-nc/3.0/">Creative Commons</a> lisansı.</p>
<p>Kullanılan Javascript komut dosyaları, <a href="http://jquery.com/">burada</a> bulunan jQuery çerçevesi, <a href="http://jqueryui.com/ adresinde bulunan jQuery UI idi. ">burada</a> ve jQuery Özel Kaydırma Çubuğu <a href="http://manos.malihu.gr/jquery-custom-content-scroller">burada</a> bulundu.</p>
<p>Bu temayla ilgili herhangi bir konuda yardıma ihtiyacınız olursa b.sampaio@campus.fct.unl.pt adresine bir e-posta gönderin, elimden geldiğince hızlı yanıt vermeye çalışacağım.</p>
<h2>Ekstralar</h2>
<p>Bu temaya ek olarak iki blok da oluşturuldu.  Kullanıcının favori Uygulamalarını görüntülemek için bir tane.  Ve diğerleri, Google ve Facebook tarafından sağlanana benzer bir Genel Sohbet benzer bir sohbet uygulaması.</p>
</div>
</div>';
$string['menu-courses'] = 'Kurslar';
$string['settings-edit'] = 'Profili Düzenle';
$string['title'] = 'Başlık';
