<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_almondb', language 'fr', version '4.5'.
 *
 * @package     theme_almondb
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['advancedsettings'] = 'Paramètres avancés';
$string['almondbpage'] = 'Pages d’informations';
$string['almondbpagecaption'] = 'Légende de page';
$string['almondbpagecaptiondesc'] = 'Ajouter une légende à votre page';
$string['almondbpagecaptionsimple'] = 'Légende de page';
$string['almondbpagecaptionsimpledesc'] = 'Ajouter une légende à votre page';
$string['almondbpagecount'] = 'Nombre de pages';
$string['almondbpagecountdesc'] = 'Sélectionner le nombre de pages à ajouter <strong>puis cliquer sur ENREGISTRER</strong> pour charger les champs de saisie.';
$string['almondbpagecountsimple'] = 'Nombre de pages';
$string['almondbpagecountsimpledesc'] = 'Sélectionner le nombre de pages à ajouter <strong>puis cliquer sur ENREGISTRER</strong> pour charger les champs de saisie.';
$string['almondbpagecss'] = 'CSS de page';
$string['almondbpagecssdesc'] = 'Ajouter du css à votre page';
$string['almondbpagecsslink'] = 'Lien vers le css de la page';
$string['almondbpagecsslinkdesc'] = 'Ajouter un lien css à votre page, par exemple : « https://www.exemple.com/abc.css­ »';
$string['almondbpagedesign'] = 'Conception de page';
$string['almondbpagedesigndesc'] = 'Sélectionner la conception de page à ajouter. Création rapide des pages à l’aide d’un design simple.
                                Pour une conception simple, utiliser uniquement la partie image et sous-titre.';
$string['almondbpageenabled'] = 'Activer page Almondb';
$string['almondbpageenableddesc'] = 'Activer une page Almondb en haut de votre page d’accueil';
$string['almondbpageenabledsimple'] = 'Activer une page Almondb';
$string['almondbpageenabledsimpledesc'] = 'Activerune page Almondb';
$string['almondbpageend'] = '--Fin--';
$string['almondbpagefooter'] = 'Pied de page';
$string['almondbpagefooterdesc'] = 'Ajouter un pied de page à la page d’information';
$string['almondbpagefootersimple'] = 'Pied de page';
$string['almondbpagefootersimpledesc'] = 'Ajouter un pied de page à la page d’information';
$string['almondbpageheader'] = 'En-tête de page';
$string['almondbpageheaderdesc'] = 'Ajouter un en-tête de page à la page d’information';
$string['almondbpageheadersimple'] = 'En-tête de page';
$string['almondbpageheadersimpledesc'] = 'Ajouter un en-tête de page à la page d’information';
$string['almondbpageheading'] = ': Paramètres de page avancés';
$string['almondbpageheadingdesc'] = 'Cela crée jusqu’à six pages d’informations pour vous permettre de promouvoir des éléments importants de votre site.';
$string['almondbpageheadingsimple'] = '! Paramètres de page simples';
$string['almondbpageheadingsimpledesc'] = 'Cela crée jusqu’à six pages d’information pour vous permettre de promouvoir des éléments importants de votre site.';
$string['almondbpageimage'] = 'Image de page';
$string['almondbpageimagedesc'] = 'Ajouter une image à votre page.';
$string['almondbpageimagesimple'] = 'Image de page';
$string['almondbpageimagesimpledesc'] = 'Ajouter une image à votre page.';
$string['almondbpageimglink'] = 'Lien vers le dossier img de la page';
$string['almondbpageimglinkdesc'] = 'Ajoutez un lien de dossier img pour votre page, copier vos images que vous utilisez en html dans ce dossier.
            Si vous renseignez le champ dossier image, ne donnez pas le chemin de l’image en html,
            écrivez-le simplement comme demo-1.png (ou jpg).
            Exemple : http://www.exemple.com/img/ , (img src= demo-1.jpg)';
$string['almondbpageimgpositionsimple'] = 'Position de l’image sur la page';
$string['almondbpageimgpositionsimpledesc'] = 'Emplacement de l’image téléchargée sur la page.';
$string['almondbpagenavbar'] = 'Barre de navigation de la page';
$string['almondbpagenavbardesc'] = 'Ajouter une barre de navigation à la page d’informations';
$string['almondbpageno'] = '! Page-{$a->almondbpage}';
$string['almondbpagenodesc'] = 'Saisir les paramètres de la page {$a->almondbpage}. <b><i>LIEN VERS LA PAGE : www.votresite/local/almondbpage/?id=a{$a->almondbpage}</i></b>';
$string['almondbpagenosimple'] = '! Page-{$a->almondbpage}';
$string['almondbpagenosimpledesc'] = 'Saisir les paramètres de la page {$a->almondbpage}. <b><i>LIEN VERS LA PAGE : www.votresite/local/almondbpage/?id=a{$a->almondbpage}</i></b>';
$string['almondbpagenotfound'] = 'Page introuvable, veuillez vérifier l’URL';
$string['almondbpagestart'] = 'Paramètres de la page d’informations';
$string['almondbpagetitle'] = 'Titre de la page';
$string['almondbpagetitledesc'] = 'Ajouter le titre de la page.';
$string['almondbpagetitlesimple'] = 'Titre de la page';
$string['almondbpagetitlesimpledesc'] = 'Ajouter le titre de la page.';
$string['backcolor'] = 'Couleur de fond';
$string['backcolor_desc'] = 'Couleur de fond';
$string['backgroundimage'] = 'Image de fond';
$string['backgroundimage_desc'] = 'L’image à afficher en arrière-plan du site. L’image d’arrière-plan déposée ici remplacera l’image d’arrière-plan dans les fichiers de préréglage de thème.';
$string['block01button'] = 'Bouton bloc 1';
$string['block01buttondesc'] = 'Ajouter un bouton au bloc 1';
$string['block01buttonlink'] = 'URL du bloc 1';
$string['block01buttonlinkdesc'] = 'Ajouter une URL au bloc 1';
$string['block01caption'] = 'Légende du bloc 1';
$string['block01captiondefault'] = 'Profitez de nos cours en ligne gratuits, où que vous soyez et quand vous le souhaitez. Accédez au contenu du cours sur mobile, tablette ou ordinateur';
$string['block01captiondesc'] = 'Ajouter une légende au bloc 1';
$string['block01color'] = 'Couleur de fond du bloc 1';
$string['block01colordesc'] = 'Ajouter une couleur de fond au bloc 1';
$string['block01enabled'] = 'Activer le bloc 1';
$string['block01enableddesc'] = 'Activer ou désactiver le bloc 1 sur votre page d’accueil';
$string['block01info'] = ': Bloc-1 ZONE DE TITRE';
$string['block01infodesc'] = 'ZONE DE TITRE - Saisir les paramètres du bloc 1';
$string['block02button'] = 'Bouton bloc {$a->block}';
$string['block02buttondesc'] = 'Ajouter un bouton au bloc';
$string['block02buttonlink'] = 'URL du bloc {$a->block}';
$string['block02buttonlinkdesc'] = 'Ajouter une URL au bloc';
$string['block02caption'] = 'Légende du bloc {$a->block}';
$string['block02captiondefault'] = 'Profitez de nos cours en ligne gratuits, où que vous soyez et quand vous le souhaitez. Accédez au contenu du cours sur mobile, tablette ou ordinateur';
$string['block02captiondesc'] = 'Ajouter une légende au bloc';
$string['block02count'] = 'Bloc-2 Nombre';
$string['block02countdesc'] = 'Sélectionner le nombre de zones et cliquer Enregistrer les modifications';
$string['block02enabled'] = 'Activer le bloc 2';
$string['block02enableddesc'] = 'Activer ou désactiver le bloc 2 sur la page d’accueil';
$string['block02icon'] = 'Icône du bloc {$a->block}';
$string['block02icondesc'] = '<a href="https://fontawesome.com/v4.7/icons/" target="_blank">Cliquer pour voir les icônes</a>';
$string['block02imgdesc'] = 'Ajouter une image au bloc';
$string['block02info'] = '! Bloc-2 ZONE D’ICÔNE';
$string['block02infodesc'] = 'ZONE D’ICÔNE - Saisir les paramètres du bloc 2';
$string['block02title'] = 'Titre du bloc {$a->block}';
$string['block02titledefault'] = 'Meilleurs conseillers en placement';
$string['block02titledesc'] = 'Ajouter un titre au bloc';
$string['block03caption'] = 'Légende du bloc 3 {$a->block}';
$string['block03captiondesc'] = 'Ajouter une légende au bloc 3';
$string['block03design'] = 'Conception du bloc 3';
$string['block03designdesc'] = 'Sélectionner la conception du bloc 3 à ajouter';
$string['block03enabled'] = 'Activer le bloc 3';
$string['block03enableddesc'] = 'Activer ou désactiver le bloc 3 sur votre page d’accueil';
$string['block03header'] = 'En-tête du bloc 3';
$string['block03headerdefault'] = 'NOUS SOMMES LES THÈMES AMANDE';
$string['block03headerdesc'] = 'En-tête du bloc 3';
$string['block03icon'] = 'Icône {$a->bloc} du bloc 3';
$string['block03icondefault'] = '';
$string['block03icondefault1'] = '';
$string['block03icondefault2'] = '';
$string['block03icondefault3'] = '';
$string['block03icondefault4'] = '';
$string['block03icondefault5'] = '';
$string['block03icondefault6'] = '';
$string['block03icondesc'] = '<a href="https://fontawesome.com/v4.7/icons/" target="_blank">Cliquer pour afficher les icônes</a>';
$string['block03info'] = '! CARACTÉRISTIQUES du bloc-3';
$string['block03infodesc'] = 'CARACTÉRISTIQUES - Saisir les paramètres du bloc 3';
$string['block03link'] = 'URL {$a->block} du bloc 3';
$string['block03linkdesc'] = 'Ajouter une URL au bloc 3';
$string['block03title'] = 'Titre {$a->bloc} du bloc 3';
$string['block03titledefault'] = 'Conception réactive';
$string['block03titledesc'] = 'Ajouter un titre au bloc 3';
$string['block04button'] = 'Texte du bouton du bloc 4';
$string['block04buttondefault'] = 'Voir tous les cours';
$string['block04buttondesc'] = 'Texte du bouton du bloc 4';
$string['block04buttonlink'] = 'Lien du bouton du bloc 4';
$string['block04buttonlinkdesc'] = 'Lien du bouton du bloc 4';
$string['block04caption'] = 'Légende {$a->bloc} du bloc 4';
$string['block04captiondesc'] = 'Ajouter une légende au bloc 4';
$string['block04design'] = 'Conception du bloc 4';
$string['block04designdesc'] = 'Sélectionner la conception du bloc 4 à ajouter';
$string['block04enabled'] = 'Activer le bloc 4';
$string['block04enableddesc'] = 'Activer ou désactiver le bloc 4 sur la page d’accueil';
$string['block04header'] = 'En-tête du bloc 4';
$string['block04headerdefault'] = 'DERNIERS PROJETS';
$string['block04headerdesc'] = 'En-tête du bloc 4';
$string['block04imgdesc'] = 'Ajouter une image au bloc';
$string['block04info'] = '! Bloc-4 DERNIÈRES';
$string['block04infodesc'] = 'DERNIÈRES - Saisir les paramètres du bloc 4';
$string['block04link'] = 'URL {$a->block} du bloc 4';
$string['block04linkdesc'] = 'Ajouter une URL au bloc 4';
$string['block04title'] = 'Titre {$a->bloc} du bloc 4';
$string['block04titledesc'] = 'Ajouter un titre au bloc 4';
$string['block05caption'] = 'Légende {$a->bloc} du bloc 5';
$string['block05captiondesc'] = 'Ajouter une légende au bloc 5';
$string['block05design'] = 'Conception du bloc 5';
$string['block05designdesc'] = 'Sélectionner la conception du bloc 5 à ajouter';
$string['block05enabled'] = 'Activer le bloc 5';
$string['block05enableddesc'] = 'Activer ou désactiver le bloc 5 sur la page d’accueil';
$string['block05header'] = 'En-tête du bloc 5';
$string['block05headerdefault'] = 'POURQUOI NOUS CHOISIR';
$string['block05headerdesc'] = 'En-tête du bloc 5';
$string['block05icon'] = 'Icône {$a->bloc} du bloc 5';
$string['block05icondesc'] = '<a href="https://fontawesome.com/v4.7/icons/" target="_blank">Cliquer pour afficher les icônes</a>';
$string['block05imgdesc'] = 'Ajouter une image à votre bloc';
$string['block05info'] = '! Bloc-5 POURQUOI NOUS';
$string['block05infodesc'] = 'POURQUOI NOUS - Saisir les paramètres du bloc 5';
$string['block05link'] = 'URL {$a->block} du bloc 5';
$string['block05linkdesc'] = 'Ajouter une URL du bloc 5';
$string['block05title'] = 'Titre {$a->bloc} du bloc 5';
$string['block05titledesc'] = 'Ajouter un titre au bloc 5';
$string['block06button'] = 'URL du bloc 6';
$string['block06buttondesc'] = 'Ajouter une URL au bloc 6';
$string['block06buttonlink'] = 'URL du bloc 6';
$string['block06buttonlinkdesc'] = 'Ajouter une URL au bloc 6';
$string['block06caption'] = 'Légende du bloc 6';
$string['block06captiondefault'] = 'Ajouter une légende par défaut au bloc 6';
$string['block06captiondesc'] = 'Ajouter une légende au bloc 6';
$string['block06color'] = 'Couleur de fond du bloc 6';
$string['block06colordesc'] = 'Ajouter une couleur de fond à votre bloc 6';
$string['block06design'] = 'Conception du bloc 6';
$string['block06designdesc'] = 'Sélectionner la conception du bloc 6 à ajouter';
$string['block06enabled'] = 'Activer le bloc 6';
$string['block06enableddesc'] = 'Activer ou désactiver le bloc 6 sur la page d’accueil';
$string['block06header'] = 'En-tête du bloc 6';
$string['block06headerdefault'] = 'TRAVAILLER AVEC NOUS';
$string['block06headerdesc'] = 'En-tête du bloc 6';
$string['block06imgdesc'] = 'Ajouter une image au bloc';
$string['block06info'] = '! Bloc-6 TRAVAILLER AVEC NOUS';
$string['block06infodesc'] = 'TRAVAILLER AVEC NOUS - Saisir les paramètres du bloc 6';
$string['block07button'] = 'URL du bloc 7';
$string['block07buttondesc'] = 'Ajouter une URL au bloc 7';
$string['block07buttonlink'] = 'URL du bloc 7';
$string['block07buttonlinkdesc'] = 'Ajouter une URL au bloc 7';
$string['block07count'] = 'Compteur du bloc 7';
$string['block07countdefault'] = '7';
$string['block07countdesc'] = 'Nombre de cours à afficher';
$string['block07design'] = 'Conception du bloc 7';
$string['block07designdesc'] = 'Sélectionner la conception du bloc 7 à ajouter';
$string['block07enabled'] = 'Activer le bloc 7';
$string['block07enableddesc'] = 'Activer ou désactiver le bloc 7 sur la page d’accueil';
$string['block07enrol'] = 'Libre';
$string['block07header'] = 'En-tête du bloc 7';
$string['block07headerdefault'] = 'COURS DISPONIBLES';
$string['block07headerdesc'] = 'En-tête du bloc 7';
$string['block07info'] = '! Bloc-7 COURS DISPONIBLES';
$string['block07infodesc'] = 'COURS DISPONIBLES - Saisir les paramètres du bloc 7';
$string['block07priceshow'] = 'Afficher le prix d’inscription au cours';
$string['block07priceshowdesc'] = 'Prix d’inscription au cours activé/désactivé';
$string['block07studentrole'] = 'Bloc 7 rôle étudiant';
$string['block07studentroledesc'] = 'Sélectionnez le rôle de l’étudiant';
$string['block07teacherenabled'] = 'Bloc 7 Enseignant activé';
$string['block07teacherenableddesc'] = 'Afficher l’enseignant ?';
$string['block07teacherrole'] = 'Bloc 7 Rôle de l’enseignant';
$string['block07teacherroledesc'] = 'Sélectionnez le rôle de l’enseignant';
$string['block07title'] = 'Titre du bloc 7';
$string['block07titledefault'] = 'nom abrégé';
$string['block07titledesc'] = 'Type de titre de cours';
$string['block07tooltipcategory'] = 'Catégorie';
$string['block07tooltipenrolled'] = 'Étudiants inscrits';
$string['block07tooltiplastdate'] = 'Date de la dernière modification';
$string['block08caption'] = 'Bloc 8 Légende';
$string['block08captiondefault'] = 'Nous continuons à œuvrer avec notre personnel enseignant impliqué. Rencontrez nos professeurs.';
$string['block08captiondesc'] = 'Légende du bloc 8';
$string['block08count'] = 'Numéro du bloc 8';
$string['block08countdefault'] = '8';
$string['block08countdesc'] = 'Nombre d’enseignants à afficher';
$string['block08description'] = 'Description du bloc 8';
$string['block08descriptiondesc'] = 'Afficher la description de l’utilisateur sur la page.';
$string['block08design'] = 'Conception du bloc 8';
$string['block08designdesc'] = 'Sélectionner la conception du bloc 8 à ajouter';
$string['block08enabled'] = 'Activer le bloc 8';
$string['block08enableddesc'] = 'Activer ou désactiver le bloc 8 sur votre page d’accueil';
$string['block08header'] = 'En-tête du bloc 8';
$string['block08headerdefault'] = 'ENSEIGNANTS';
$string['block08headerdesc'] = 'En-tête du bloc 8';
$string['block08info'] = '! Bloc 8 ENSEIGNANT';
$string['block08infodesc'] = 'ENSEIGNANTS - Saisir les paramètres du bloc 8';
$string['block08showrole'] = 'Bloc 8 Afficher le rôle';
$string['block08showroledesc'] = 'Rôle d’utilisateur à afficher dans le bloc 8';
$string['block08studentrole'] = 'Bloc 8 Rôle de l’étudiant';
$string['block08studentroledesc'] = 'Rôle étudiant';
$string['block08tooltipcourse'] = 'Nombre total de cours de l’enseignant';
$string['block08tooltipstudents'] = 'Nombre total d’étudiants de l’enseignant';
$string['block08total'] = 'Bloc 8 Total';
$string['block08totaldesc'] = 'Afficher le nombre total de cours et d’étudiants';
$string['block09background'] = 'Bloc 9 Arrière plan';
$string['block09backgrounddesc'] = 'Sélectionnez la couleur ou l’image d’arrière-plan du bloc 9';
$string['block09boxshadow'] = 'Bloc 9 Ombre de la zone';
$string['block09boxshadowdesc'] = 'Sélectionnez l’ombre de la zone du bloc 9 activée';
$string['block09caption'] = 'Légende du bloc 9';
$string['block09captiondefault'] = 'Liste des catégories enregistrées';
$string['block09captiondesc'] = 'Légende du bloc 9';
$string['block09count'] = 'Numéro du bloc 9';
$string['block09countdefault'] = '9';
$string['block09countdesc'] = 'Nombre de catégories à afficher';
$string['block09ctgid'] = 'Bloc 9 Identifiant de la catégorie';
$string['block09ctgiddesc'] = 'Bloc 9 Sélection de l’identifiant de catégorie (ex : id = 1 ou id = 2 ou id = 3 …), vider toutes les catégories.';
$string['block09design'] = 'Conception du bloc 9';
$string['block09designdesc'] = 'Sélectionner la conception du bloc 9 à ajouter';
$string['block09enabled'] = 'Activer le bloc 9';
$string['block09enableddesc'] = 'Activer ou désactiver le bloc 9 sur votre page d’accueil';
$string['block09header'] = 'En-tête du bloc 9';
$string['block09headerdefault'] = 'Catégories disponibles';
$string['block09headerdesc'] = 'Bloc 9 Description de l’en-tête';
$string['block09info'] = '! Bloc-9 CATÉGORIES';
$string['block09infodesc'] = 'CATÉGORIES - Saisir les paramètres du bloc 9';
$string['block10caption'] = 'Légende du bloc {$a->block}';
$string['block10captiondesc'] = 'Ajouter une légende à votre bloc';
$string['block10count'] = 'Numéro du bloc 10';
$string['block10countdesc'] = 'Sélectionnez le nombre de zones et appuyez sur le bouton Enregistrer les modifications';
$string['block10design'] = 'Conception du bloc 10';
$string['block10designdesc'] = 'Sélectionner la conception du bloc 10 à ajouter';
$string['block10enabled'] = 'Activer le bloc 10';
$string['block10enableddesc'] = 'Activer ou désactiver le bloc 10 sur votre page d’accueil';
$string['block10header'] = 'En-tête du bloc 10';
$string['block10headerdefault'] = 'TÉMOIGNAGES';
$string['block10headerdesc'] = 'En-tête du bloc 10';
$string['block10imgdesc'] = 'Ajouter une image à votre bloc';
$string['block10info'] = '! Bloc-10 TÉMOIGNAGES';
$string['block10infodesc'] = 'TÉMOIGNAGES - Saisir les paramètres du bloc 10';
$string['block10job'] = 'Bloc 10 tâches {$a->block}';
$string['block10jobdesc'] = 'Tâches du bloc 10';
$string['block10link'] = 'URL {$a->block} du bloc';
$string['block10linkdesc'] = 'Ajouter une URL à votre bloc';
$string['block10name'] = 'Bloc 10 nom {$a->bloc}';
$string['block10namedesc'] = 'Nom du bloc 10';
$string['block11caption'] = 'Légende du bloc 11';
$string['block11captiondefault'] = 'Bienvenue sur les articles du blog Almondb.';
$string['block11captiondesc'] = 'Légende du bloc 11';
$string['block11count'] = 'Numéro du bloc 11';
$string['block11countdesc'] = 'Sélectionner le nombre de blogs à afficher';
$string['block11design'] = 'Conception du bloc 11';
$string['block11designdesc'] = 'Sélectionner la conception du bloc 11 à ajouter';
$string['block11enabled'] = 'Activer le bloc 11';
$string['block11enableddesc'] = 'Activer ou désactiver le bloc 11 sur votre page d’accueil';
$string['block11header'] = 'En-tête du bloc 11';
$string['block11headerdefault'] = 'BLOG AMANDE';
$string['block11headerdesc'] = 'En-tête du bloc 11';
$string['block11info'] = '! Bloc-11 POST DE BLOG';
$string['block11infodesc'] = 'POST DE BLOG - Saisir les paramètres du bloc 11';
$string['block12info'] = '! Bloc-12 Vide';
$string['block13info'] = '! Bloc-13 Vide';
$string['block14info'] = '! Bloc-14 Vide';
$string['block15info'] = '! Bloc-15 Vide';
$string['block16info'] = '! Bloc-16 Vide';
$string['block17info'] = '! Bloc-17 Vide';
$string['block18caption'] = 'Légende du bloc 18';
$string['block18captiondesc'] = 'Légende du bloc 18';
$string['block18css'] = 'CSS du bloc 18';
$string['block18cssdesc'] = 'Bloc 18 ajouter du code css à votre bloc';
$string['block18csslink'] = 'Lien css du bloc 18';
$string['block18csslinkdesc'] = 'Bloc 18 ajouter un lien css à votre bloc';
$string['block18enabled'] = 'Activer le bloc 18';
$string['block18enableddesc'] = 'Activer ou désactiver le bloc 18 sur votre page d’accueil';
$string['block18info'] = '! Bloc-18 BLOC HTML';
$string['block18infodesc'] = 'BLOC HTML - Saisir les paramètres du bloc 18';
$string['block18title'] = 'Titre du bloc 18';
$string['block18titledesc'] = 'Sélectionner le motif du bloc 18 à ajouter';
$string['block19caption'] = 'BLOC HTML - Saisir les paramètres du bloc 18';
$string['block19captiondefault'] = 'C’est un fait établi depuis longtemps qu’un lecteur sera distrait par le contenu lisible d’une page lorsque l’on regarde sa mise en page.';
$string['block19captiondesc'] = 'Légende du bloc 19';
$string['block19design'] = 'Conception du bloc 19';
$string['block19designdesc'] = 'Sélectionner le motif du bloc 19 à ajouter';
$string['block19enabled'] = 'Activer le bloc 19';
$string['block19enableddesc'] = 'Activer ou désactiver le bloc 19 sur votre page d’accueil';
$string['block19header'] = 'En-tête du bloc 19';
$string['block19headerdefault'] = 'NOS PARTENAIRES';
$string['block19headerdesc'] = 'En-tête du bloc 19';
$string['block19headerenabled'] = 'Activer l’en-tête du bloc 19';
$string['block19headerenableddesc'] = 'En-tête activé/désactivé du bloc 19';
$string['block19imgdesc'] = 'Ajouter une image à votre bloc';
$string['block19info'] = '! Bloc-19 MARQUES';
$string['block19infodesc'] = 'MARQUES - Saisir les paramètres du bloc 19';
$string['block19link'] = 'Bloc 19 URL de l’image {$a->block}';
$string['block19linkdesc'] = 'Ajouter une URL pour l’image à votre bloc 19';
$string['block20col1caption'] = 'Légende du bloc 20 colonne 1';
$string['block20col1captiondefault'] = 'C’est un fait établi depuis longtemps qu’un lecteur sera distrait par
                                    le contenu lisible d’une page lorsque l’on regarde sa mise en page.';
$string['block20col1captiondesc'] = 'Légende du bloc 20 colonne 1';
$string['block20col1header'] = 'En-tête du bloc 20 colonne 1';
$string['block20col1headerdesc'] = 'En-tête du bloc 20 colonne 1';
$string['block20col2header'] = 'En-tête du bloc 20 colonne 2';
$string['block20col2headerdesc'] = 'Bloc 20 colonne 2 entrer l’en-tête';
$string['block20col2link'] = 'Lien du bloc 20 colonne 2';
$string['block20col2linkdefault'] = 'À propos de nous|https://themesalmond.com
                                    Notre histoire|https://moodle.org/support
                                    Termes et conditions|https://moodle.org/development
                                    Politique de confidentialité|http://docs.moodle.org|Documentation Moodle
                                    Plan du site|http://docs.moodle.org/fr|Documentation en français|fr
                                    Moodle.com|http://moodle.com/';
$string['block20col2linkdesc'] = 'Bloc 20 colonne 2 zone de lien';
$string['block20col3header'] = 'En-tête du bloc 20 colonne 3';
$string['block20col3headerdesc'] = 'Bloc 20 colonne 3 entrer l’en-tête';
$string['block20col3link'] = 'Lien du bloc 20 colonne 3';
$string['block20col3linkdefault'] = 'À propos de nous|https://themesalmond.com
                                    Notre histoire|https://moodle.org/support
                                    Termes et conditions|https://moodle.org/development
                                    Politique de confidentialité|http://docs.moodle.org|Documentation Moodle
                                    Plan du site|http://docs.moodle.org/fr|Documentation en français|fr
                                    Moodle.com|http://moodle.com/';
$string['block20col3linkdesc'] = 'Bloc 20 colonne 3 zone de lien';
$string['block20col4caption'] = 'Légende du bloc 20 colonne 4';
$string['block20col4captiondefault'] = 'Adresse';
$string['block20col4captiondesc'] = 'Entrer la légende du bloc 20 colonne 4';
$string['block20col4header'] = 'En-tête du bloc 20 colonne 4';
$string['block20col4headerdesc'] = 'Entrer l’en-tête du bloc 20 colonne 4';
$string['block20copyright'] = 'Bloc 20 Droits d’auteur';
$string['block20copyrightdefault'] = 'Copyright © 2022 Conçu par
    <a href="https://www.themealmond.com">themesalmond.com</a>. Tous les droits sont réservés.';
$string['block20copyrightdesc'] = 'Bloc 20 Droits d’auteur';
$string['block20enabled'] = 'Activer le bloc 20';
$string['block20enableddesc'] = 'Activer ou désactiver le bloc 20 sur votre page d’accueil';
$string['block20info'] = '! Bloc-20 PIED DE PAGE';
$string['block20infodesc'] = 'PIED DE PAGE - Saisir les paramètres du bloc 20';
$string['block20logo'] = 'Sélectionner le logo du bloc 20';
$string['block20logodesc'] = 'Sélection du logo du bloc 20';
$string['block20moodle'] = 'Activer le bouton de la page d’accueil';
$string['block20moodledesc'] = 'Activer ou désactiver la page d’accueil originale de Moodle pour le bloc 20';
$string['block20social'] = 'Bloc 20 liens sociaux';
$string['block20socialdesc'] = 'Bloc 20 liens sociaux';
$string['brandcolor'] = 'Couleur de la marque';
$string['brandcolor_desc'] = 'La couleur de fond.';
$string['button'] = 'Bouton';
$string['choosereadme'] = 'amande est un thème moderne hautement personnalisable.';
$string['configtitle'] = 'Amande';
$string['coursesection'] = 'Sections de cours';
$string['coursesummary'] = 'Sommaire du cours';
$string['dashboardnavchoice'] = 'Navigation de la page du tableau de bord';
$string['dashboardnavchoicedesc'] = 'Sélectionner la navigation de la page du tableau de bord à afficher';
$string['footerbackgroundcolor'] = 'Couleur de fond du bas de page';
$string['footerbackgroundcolordesc'] = 'Vous pouvez changer la couleur de fond du pied de page';
$string['footerselect'] = 'Pied de page du tableau de bord';
$string['footerselectdesc'] = 'Sélectionner le style de pied de page du formulaire de tableau de bord';
$string['frontpagealmondb'] = 'Page d’accueil';
$string['frontpagechoice'] = 'Sélectionner la page d’accueil';
$string['frontpagechoicedesc'] = 'Sélectionner la page d’accueil à afficher';
$string['frontpagecolor'] = 'Sélectionner la couleur par défaut de la page d’accueil';
$string['frontpagedesc'] = 'Sélectionner la page d’accueil à afficher';
$string['frontpageend'] = '--Fin--';
$string['frontpageheading'] = '! Choix de la page d’accueil';
$string['frontpageheading1'] = '! SECTION de la page d’accueil';
$string['frontpageheadingdesc1'] = 'section de la page d’accueil sélection numéro un
<br><a href="./../theme/almondb/pix/almondb/slide_01.jpg" target="_blank">Cliquer pour voir les blocs</a>';
$string['frontpagenav'] = ': Choix de l’en-tête de la page d’accueil';
$string['frontpagenavchoice'] = 'Navigation sur la page d’accueil';
$string['frontpagenavchoicedesc'] = 'Sélectionner la navigation de la page d’accueil à afficher';
$string['frontpagenavdesc'] = 'Sélectionner l’en-tête de la page d’accueil à afficher';
$string['frontpagenavlightdark'] = 'Page d’accueil clair-foncé';
$string['frontpagenavlightdarkdesc'] = 'Si vous avez choisi la couleur sombre ci-dessus, choisissez "navbar-dark".';
$string['frontpagenavlink'] = 'Lien de navigation sur la page d’accueil';
$string['frontpagenavlinkdefault'] = 'Fonctionnalités
-En-tête
-Couleurs|/mod/page/view.php?id=113
-Blocs|/mod/page/view.php?id=114
-Facile et rapide|/mod/page/view.php?id=115
-Utiliser maintenant|/mod/page/view.php?id=116
Pages
-À propos|/mod/page/view.php?id=1
-Blog|/blog/
Cours
-Tous les cours|/course/
-Recherche de cours|/course/search.php|_blank
Accès rapide
-Zone de titre|#block01
-Zone d’icônes|#block02
-Caractéristiques|#block03
-Dernier|#block04
-POURQUOI nous|#block05
-Travailler avec nous|#block06
-Cours|#block07
-Enseignant|#block08
-Catégorie|#block09
-Témoignages|#block10|_self
-Articles de blog|#block11|_self
-Bloc HTML|#block18|_self
-Marques|#block19
-Pied de page|#block20
Enseignants|#block08
Documentation|https://doc.themesalmond.com/|_blank';
$string['frontpagenavlinkdesc'] = 'Saisir les liens de la barre de navigation de la page d’accueil';
$string['frontpagesection1_1'] = 'Section 1';
$string['frontpagesection1_10'] = 'Section 10';
$string['frontpagesection1_2'] = 'Section 2';
$string['frontpagesection1_3'] = 'Section 3';
$string['frontpagesection1_4'] = 'Section 4';
$string['frontpagesection1_5'] = 'Section 5';
$string['frontpagesection1_6'] = 'Section 6';
$string['frontpagesection1_7'] = 'Section 7';
$string['frontpagesection1_8'] = 'Section 8';
$string['frontpagesection1_9'] = 'Section 9';
$string['frontpagesectiondesc1_1'] = 'Page d’accueil section 1';
$string['frontpagesectiondesc1_10'] = 'Page d’accueil section 10';
$string['frontpagesectiondesc1_2'] = 'Page d’accueil section 2';
$string['frontpagesectiondesc1_3'] = 'Page d’accueil section 3';
$string['frontpagesectiondesc1_4'] = 'Page d’accueil section 4';
$string['frontpagesectiondesc1_5'] = 'Page d’accueil section 5';
$string['frontpagesectiondesc1_6'] = 'Page d’accueil section 6';
$string['frontpagesectiondesc1_7'] = 'Page d’accueil section 7';
$string['frontpagesectiondesc1_8'] = 'Page d’accueil section 8';
$string['frontpagesectiondesc1_9'] = 'Page d’accueil section 9';
$string['generalsettings'] = 'Paramètres généraux';
$string['header3phone'] = 'Numéro de téléphone';
$string['header3phonedesc'] = 'Numéro de téléphone de contact à afficher dans la barre de navigation.';
$string['headerlogo'] = 'Sélectionner le logo de la barre de navigation';
$string['headerlogodesc'] = 'Sélectionner l’affichage du logo de navigation de la page d’accueil';
$string['imgloginbackground'] = 'Image d’arrière-plan de connexion';
$string['imgloginbackground_desc'] = 'Description de l’image d’arrière-plan de connexion';
$string['loggedinnot'] = 'connexion.';
$string['loginbackgroundimage'] = 'Image d’arrière-plan de la page de connexion';
$string['loginbackgroundimage_desc'] = 'Image à afficher en arrière-plan pour la page de connexion.';
$string['loginposition'] = 'Position du formulaire de connexion';
$string['loginpositiondesc'] = 'Sélectionner la position de l’écran du formulaire de connexion';
$string['navbarcolor'] = 'Couleur arrière de la barre de navigation';
$string['navbarcolor_desc'] = 'Couleur d’arrière-plan de la barre de navigation';
$string['navbarcontainer'] = 'Ajouter un conteneur';
$string['navbarcontainerdesc'] = 'Vous pouvez insérer la barre de navigation à l’intérieur du conteneur';
$string['over'] = 'Plus de';
$string['pluginname'] = 'Amande';
$string['preset'] = 'Préréglages du thème';
$string['preset_desc'] = 'Choisir un préréglage pour modifier largement l’apparence du thème.';
$string['presetfiles'] = 'Fichiers supplémentaires de préréglage du thème';
$string['presetfiles_desc'] = 'Les fichiers prédéfinis peuvent être utilisés pour modifier considérablement l’apparence du thème. Voir <a href="https://docs.moodle.org/dev/almondb_Presets">préréglages amande</a> pour plus d’informations sur la création et le partage de vos propres fichiers de préréglages, et voir le <a href="https:// archive.moodle.net/almondb">Référentiel de préréglages</a> pour les préréglages que d’autres ont partagés.';
$string['privacy:drawerblockclosed'] = 'La préférence actuelle pour le tiroir de blocs est fermé.';
$string['privacy:drawerblockopen'] = 'La préférence actuelle pour le tiroir de blocs est ouvert.';
$string['privacy:drawerindexclosed'] = 'La préférence actuelle pour le tiroir d’index est fermé.';
$string['privacy:drawerindexopen'] = 'La préférence actuelle pour le tiroir d’index est ouvert.';
$string['privacy:metadata'] = 'Le thème amande n’enregistre aucune donnée personnelle sur un utilisateur.';
$string['privacy:metadata:preference:draweropenblock'] = 'La préférence de l’utilisateur pour masquer ou afficher le tiroir avec des blocs.';
$string['privacy:metadata:preference:draweropenindex'] = 'La préférence de l’utilisateur pour masquer ou afficher le tiroir avec l’index des cours.';
$string['privacy:metadata:preference:draweropennav'] = 'La préférence de l’utilisateur pour masquer ou afficher la navigation du menu du tiroir.';
$string['rawscss'] = 'SCSS brut';
$string['rawscss_desc'] = 'Utilisez ce champ pour fournir le code SCSS ou CSS qui sera injecté à la fin de la feuille de style.';
$string['rawscsspre'] = 'SCSS initial brut';
$string['rawscsspre_desc'] = 'Dans ce champ, vous pouvez fournir le code SCSS d’initialisation, il sera injecté avant tout le reste. La plupart du temps, vous utiliserez ce paramètre pour définir des variables.';
$string['region-side-pre'] = 'Droite';
$string['showfooter'] = 'Afficher le pied de page';
$string['sitecolor'] = 'Sélectionner la couleur de la page d’accueil';
$string['sitecolor_desc'] = 'Vous pouvez choisir la couleur que vous voulez sauf la valeur par défaut';
$string['slideno'] = '! Diapositive-{$a->slide}';
$string['slidenodesc'] = 'Saisir les paramètres de la diapositive {$a->slide}.';
$string['sliderbutton'] = 'Bouton du caroussel';
$string['sliderbuttondesc'] = 'Saisir la destination cible du texte du bouton de la diapositive,
soit la clé de la langue, soit le Texte. Par exemple : lang:display ou Display';
$string['sliderbuttonurl'] = 'Lien du bouton de diapositive';
$string['sliderbuttonurldesc'] = 'Saisir la destination cible du lien du bouton de la diapositive';
$string['slidercaption'] = 'Légende du caroussel';
$string['slidercaptiondesc'] = 'Ajouter une légende pour votre diapositive';
$string['slidercount'] = 'Nombre de diapositives';
$string['slidercountdesc'] = 'Sélectionner le nombre de diapositives que vous souhaitez ajouter <strong>puis cliquez sur ENREGISTRER</strong> pour charger les champs de saisie.';
$string['sliderdesign'] = 'Conception de diaporama';
$string['sliderdesigndesc'] = 'Sélectionner le modèle de diapositive à ajouter';
$string['sliderenabled'] = 'Activer le caroussel';
$string['sliderenableddesc'] = 'Activer un caroussel en haut de votre page d’accueil';
$string['sliderimage'] = 'Image du caroussel';
$string['sliderimageblock02img'] = 'Bloc image {$a->block}';
$string['sliderimageblock04img'] = 'Bloc image {$a->block}';
$string['sliderimageblock05img'] = 'Bloc image';
$string['sliderimageblock06img'] = 'Bloc image';
$string['sliderimageblock10img'] = 'Bloc image {$a->block}';
$string['sliderimageblock19img'] = 'Bloc 19 image {$a->block}';
$string['sliderimagedesc'] = 'Ajouter une image pour votre diapositive. La taille recommandée est de 1500px x 500px ou plus.';
$string['slideropacity'] = 'Opacité du caroussel';
$string['slideropacitydesc'] = 'Opacité des couleurs du caroussel de la page d’accueil';
$string['slidershowheight'] = 'Hauteur du diaporama';
$string['slidershowheight_desc'] = 'Régler la hauteur du diaporama sur les pages d’accueil du site.';
$string['slidertitle'] = 'Titre de la diapositive';
$string['slidertitledesc'] = 'Ajouter le titre de la diapositive.';
$string['slideshow'] = 'Caroussel';
$string['slideshowend'] = '--Fin--';
$string['slideshowheading'] = ': Caroussel de la page d’accueil';
$string['slideshowheadingdesc'] = 'Cela crée un diaporama de six diapositives maximum pour vous permettre de promouvoir des éléments importants de votre site. La présentation est adaptative quand la hauteur de l’image est définie en fonction de la taille de l’écran. Si aucune image n’est sélectionnée pour une diapositive, les images par défaut du dossier pix sont utilisées.';
$string['slideshowstart'] = 'Paramètres du caroussel de la page d’accueil';
$string['theme_almondb_frontpageblock'] = 'Bloc';
$string['theme_almondb_frontpageblockdesc'] = 'Paramètres des blocs HTML de la page d’accueil';
$string['theme_almondb_frontpageblockend'] = '--Fin--';
$string['theme_almondb_frontpageblockheading'] = 'Blocs de page d’accueil';
$string['themesettings'] = 'Réglage du thème';
$string['totop'] = 'Aller en haut';
$string['unaddableblocks'] = 'Blocs inutiles';
$string['unaddableblocks_desc'] = 'Les blocs spécifiés ne sont pas nécessaires lors de l’utilisation de ce thème et ne seront pas répertoriés dans le menu « Ajouter un bloc ».';
