<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'moodle', language 'fr', version '4.5'.
 *
 * @package     moodle
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abouttobeinstalled'] = 'prêt à être installé';
$string['accept'] = 'Accepter';
$string['action'] = 'Action';
$string['actionchoice'] = 'Que voulez-vous faire avec le fichier « {$a} » ?';
$string['actions'] = 'Actions';
$string['actionsfor'] = 'Actions pour {$a}';
$string['actionsmenu'] = 'Menu d’actions';
$string['active'] = 'Actif';
$string['activeusers'] = 'Utilisateurs actifs';
$string['activities'] = 'Activités';
$string['activities_help'] = 'Vous pouvez ajouter à votre cours des activités (forums, tests, wikis, etc.) pour le rendre interactif.';
$string['activity'] = 'Activité';
$string['activityclipboard'] = 'Déplacement de l’activité {$a}';
$string['activityheader'] = 'Menu d’activité';
$string['activityicon'] = 'Icône {$a}';
$string['activityiscurrentlyhidden'] = 'Désolé, cette activité n’est pas visible actuellement';
$string['activitymodule'] = 'Module d’activité';
$string['activitymodules'] = 'Modules d’activité';
$string['activitynotready'] = 'Activité pas encore prête';
$string['activityorresource'] = 'Activité ou ressource';
$string['activityreport'] = 'Rapport d’activité';
$string['activityreports'] = 'Rapports d’activité';
$string['activityselect'] = 'Sélectionner cette activité pour la déplacer';
$string['activitysince'] = 'Activité depuis le {$a}';
$string['activitytypetitle'] = '{$a->activity} - {$a->type}';
$string['activityweighted'] = 'Activité par utilisateur';
$string['add'] = 'Ajouter';
$string['addactivity'] = 'Ajouter une activité…';
$string['addactivitytosection'] = 'Ajouter une activité à la section « {$a} »';
$string['addadmin'] = 'Désigner comme administrateur';
$string['addblock'] = 'Ajouter un bloc';
$string['addcomment'] = 'Ajouter un commentaire…';
$string['addcondition'] = 'Ajouter une condition';
$string['addcontent'] = 'Ajouter du contenu';
$string['addcountertousername'] = 'Créer un utilisateur en ajoutant un nombre au nom d’utilisateur';
$string['addcreator'] = 'Désigner comme créateur de cours';
$string['adddots'] = 'Ajouter…';
$string['added'] = '{$a} ajouté(e)';
$string['addedtogroup'] = 'Ajouté au groupe « {$a} »';
$string['addedtogroupnot'] = 'Non ajouté au groupe « {$a} »';
$string['addedtogroupnotenrolled'] = 'Non ajouté au groupe « {$a} », parce que non inscrit au cours';
$string['addfilehere'] = 'Glisser des fichiers ici pour les ajouter en bas de cette section';
$string['addfilesdrop'] = 'Vous pouvez glisser-déposer des fichiers ici ou cliquer pour sélectionner';
$string['addinganew'] = 'Ajout {$a}';
$string['addinganewto'] = 'Ajout {$a->what} à {$a->to}';
$string['addingdatatoexisting'] = 'Ajout à des données existantes';
$string['additionalcustomnav'] = 'Navigation personnalisée additionnelle';
$string['additionalnames'] = 'Noms supplémentaires';
$string['addlinkhere'] = 'Ajouter ici un lien';
$string['addnew'] = 'Ajouter un nouveau {$a}';
$string['addnewcategory'] = 'Ajouter une catégorie de cours';
$string['addnewcourse'] = 'Ajouter un cours';
$string['addnewuser'] = 'Ajouter un utilisateur';
$string['addnousersrecip'] = 'Ajouter à la liste des destinataires les utilisateurs n’ayant pas encore accédé à ce {$a}';
$string['addpagehere'] = 'Ajouter du texte ici';
$string['addresource'] = 'Ajouter une ressource…';
$string['addresourceoractivity'] = 'Ajouter une activité ou ressource';
$string['addresourcetosection'] = 'Ajouter une ressource à la section « {$a} »';
$string['address'] = 'Adresse';
$string['addsections'] = 'Ajouter des sections';
$string['addstudent'] = 'Ajouter un étudiant';
$string['addsubcategory'] = 'Ajouter une sous-catégorie';
$string['addteacher'] = 'Désigner comme enseignant';
$string['admin'] = 'Admin';
$string['adminhelpaddnewuser'] = 'Créer manuellement un nouveau compte d’utilisateur';
$string['adminhelpassignadmins'] = 'Les administrateurs peuvent tout faire et aller partout dans le site';
$string['adminhelpassigncreators'] = 'Les créateurs de cours peuvent créer de nouveaux cours';
$string['adminhelpassignsiteroles'] = 'Attribuer des rôles du site à des utilisateurs';
$string['adminhelpassignstudents'] = 'Choisissez un cours et ajoutez des étudiants (menu Administration)';
$string['adminhelpauthentication'] = 'Il est possible d’utiliser des comptes internes ou ceux d’une base de données externe';
$string['adminhelpbackup'] = 'Configurer les sauvegardes';
$string['adminhelpconfiguration'] = 'Configurer l’aspect et le fonctionnement du site';
$string['adminhelpconfigvariables'] = 'Configurer les paramètres réglant le fonctionnement général du site';
$string['adminhelpcourses'] = 'Définir les cours et les catégories, inscrire des utilisateurs à ces cours, gérer les demandes de cours';
$string['adminhelpeditorsettings'] = 'Définir la configuration de base de l’éditeur HTML';
$string['adminhelpedituser'] = 'Parcourir la liste des comptes des utilisateurs et les modifier';
$string['adminhelpenvironment'] = 'Vérifier que votre serveur possède les spécifications d’une installation actuelle et future';
$string['adminhelpfailurelogs'] = 'Parcourir les journaux des tentatives de connexion';
$string['adminhelplanguage'] = 'Vérifier ou modifier le paquetage de la langue en cours';
$string['adminhelplogs'] = 'Parcourir les journaux de toutes les activités de ce site';
$string['adminhelpmanageblocks'] = 'Gérer les blocs installés et leurs paramètres';
$string['adminhelpmanagedatabase'] = 'Accéder directement à la base de données (DANGER !)';
$string['adminhelpmanagefilters'] = 'Choisir les filtres de texte et leurs paramètres';
$string['adminhelpmanagemodules'] = 'Gérer les modules installés et leurs paramètres';
$string['adminhelpmanageroles'] = 'Créer et définir les rôles pouvant être assigné aux utilisateurs';
$string['adminhelpmymoodle'] = 'Configurer les blocs de Ma page pour les utilisateurs';
$string['adminhelpreports'] = 'Rapports du site';
$string['adminhelpsitefiles'] = 'Publier des fichiers ou télécharger des copies de sauvegarde externes';
$string['adminhelpsitesettings'] = 'Définit l’aspect de la page d’accueil';
$string['adminhelpstickyblocks'] = 'Configurer les blocs fixes pour tout ce serveur Moodle';
$string['adminhelpthemes'] = 'Choisir une interface graphique pour le site (couleurs, polices, etc.)';
$string['adminhelpuploadusers'] = 'Importer de nouveaux comptes utilisateurs';
$string['adminhelpusers'] = 'Définir vos utilisateurs et configurer l’authentification';
$string['adminhelpxmldbeditor'] = 'Interface pour la modification des fichiers XMLDB. Seulement pour les développeurs.';
$string['administration'] = 'Administration';
$string['administrationsite'] = 'Administration du site';
$string['administrator'] = 'Administrateur';
$string['administratordescription'] = 'Les administrateurs peuvent tout faire sur le site, dans tous les cours.';
$string['administrators'] = 'Administrateurs';
$string['administratorsall'] = 'Tous les administrateurs';
$string['administratorsandteachers'] = 'Administrateurs et enseignants';
$string['advanced'] = 'Avancé';
$string['advancedfilter'] = 'Plus de critères';
$string['advancedsettings'] = 'Réglages avancés';
$string['afterresource'] = 'Après la ressource « {$a} »';
$string['aftersection'] = 'Après la section « {$a} »';
$string['again'] = 'à nouveau';
$string['agelocationverification'] = 'Vérification de l’âge et du lieu';
$string['ajaxuse'] = 'AJAX et Javascript';
$string['all'] = 'Tout';
$string['allactions'] = 'Toutes les actions';
$string['allactivities'] = 'Toutes les activités';
$string['allcategories'] = 'Toutes les catégories';
$string['allchanges'] = 'Toutes les modifications';
$string['alldays'] = 'Tous les jours';
$string['allfiles'] = 'Tous les fichiers';
$string['allgroups'] = 'Tous les groupes';
$string['alllogs'] = 'Tous les journaux';
$string['allmods'] = 'Tous les {$a}';
$string['allow'] = 'Autoriser';
$string['allowinternal'] = 'Permettre aussi les méthodes internes';
$string['allownone'] = 'Aucun';
$string['allownot'] = 'Interdire';
$string['allowstealthmodules'] = 'Permettre les activités furtives';
$string['allowstealthmodules_help'] = 'Si ce réglage est activé, les activités peuvent être rendues disponibles, mais invisibles dans des sections visibles sur la page de cours. Dans ce cas, un lien doit être fourni par ailleurs pour accéder à l’activité, par exemple dans une ressource de type page ou une étiquette. Les activités furtives sont affichées dans le carnet de notes et les autres rapports.';
$string['allparticipants'] = 'Tous les participants';
$string['allteachers'] = 'Tous les enseignants';
$string['alphanumerical'] = 'Seuls les lettres, chiffres, tiret (-) et point (.) sont autorisés';
$string['alreadyconfirmed'] = 'L’enregistrement a déjà été confirmé';
$string['alternatename'] = 'Autre nom';
$string['always'] = 'Toujours';
$string['and'] = '{$a->one} et {$a->two}';
$string['answer'] = 'Réponse';
$string['any'] = 'Un au moins';
$string['appearance'] = 'Apparence';
$string['apply'] = 'Appliquer';
$string['applyfilters'] = 'Appliquer les filtres';
$string['approve'] = 'Approuver';
$string['areyousure'] = 'Voulez-vous vraiment continuer ?';
$string['areyousuretorestorethis'] = 'Voulez-vous vraiment restaurer cette sauvegarde ?';
$string['areyousuretorestorethisinfo'] = 'Vous aurez plus tard la possibilité d’ajouter cette sauvegarde à un cours existant ou de créer un nouveau cours avec ces données.';
$string['asc'] = 'Ascendant';
$string['assessment'] = 'Évaluation';
$string['assignadmins'] = 'Choisir les administrateurs';
$string['assigncreators'] = 'Choisir les créateurs de cours';
$string['assignedrolecount'] = '{$a->role} : {$a->count}';
$string['assignsiteroles'] = 'Attribuer les rôles globaux du site';
$string['authenticateduser'] = 'Utilisateur authentifié';
$string['authenticateduserdescription'] = 'Tous les utilisateurs connectés.';
$string['authentication'] = 'Authentification';
$string['authenticationplugins'] = 'Plugins d’authentification';
$string['autosubscribe'] = 'Auto-abonnement aux forums';
$string['autosubscribeno'] = 'Non, ne pas m’abonner automatiquement aux discussions des forums';
$string['autosubscribeyes'] = 'Oui, m’abonner à une discussion si j’y écris un message';
$string['availability'] = 'Disponibilité';
$string['availablecourses'] = 'Cours disponibles';
$string['back'] = 'Retour';
$string['backto'] = 'Retour à {$a}';
$string['backtocourselisting'] = 'Retour à la liste des cours';
$string['backtohome'] = 'Retour à la page d’accueil';
$string['backtopageyouwereon'] = 'Retour à la page d’où vous venez';
$string['backup'] = 'Sauvegarde';
$string['backupactivehelp'] = 'Choisissez d’activer ou non les sauvegardes automatiques.';
$string['backupadhocpending'] = 'Tâche ad hoc de sauvegarde de cours en attente';
$string['backupcancelled'] = 'Sauvegarde annulée';
$string['backupcoursefileshelp'] = 'Une fois cette option activée, les fichiers des cours seront inclus dans les sauvegardes automatiques';
$string['backupdate'] = 'Date de la sauvegarde';
$string['backupdatenew'] = '  {$a->TAG} est maintenant {$a->weekday}, {$a->mday} {$a->month} {$a->year}<br />';
$string['backupdateold'] = '{$a->TAG} était {$a->weekday}, {$a->mday} {$a->month} {$a->year}';
$string['backupdaterecordtype'] = '<br />{$a->recordtype} - {$a->recordname}<br />';
$string['backupdetails'] = 'Détails de la sauvegarde';
$string['backuperrorinvaliddestination'] = 'Le dossier de destination des sauvegardes n’existe pas ou n’est pas atteignable en écriture.';
$string['backupexecuteathelp'] = 'Choisissez l’heure à laquelle les sauvegardes automatiques doivent être lancées.';
$string['backupfailed'] = 'Certains de vos cours n’ont pas été sauvegardés.';
$string['backupfilename'] = 'sauvegarde';
$string['backupfinished'] = 'La sauvegarde s’est déroulée sans erreur';
$string['backupfromthissite'] = 'La sauvegarde a-t-elle été effectuée sur ce site ?';
$string['backupgradebookhistoryhelp'] = 'S’il est activé, l’historique du carnet de notes sera inclus dans les sauvegardes automatiques. Notez que l’historique des notes ne doit pas être désactivé dans les paramètres du serveur (désactiver l’historique des notes) pour que cela fonctionne';
$string['backupincludemoduleshelp'] = 'Choisissez si vous désirez inclure dans les sauvegardes automatiques les modules de cours, avec ou sans les données des utilisateurs';
$string['backupincludemoduleuserdatahelp'] = 'Choisissez si vous désirez inclure dans les sauvegardes automatiques les données utilisateur des modules.';
$string['backupinfo'] = 'Créer une copie de cours, y compris tout son contenu et ses activités. Le fichier de sauvegarde peut être utilisé pour restaurer le cours.';
$string['backuplogdetailed'] = 'Rapport détaillé des exécutions';
$string['backuploglaststatus'] = 'Rapport de la dernière exécution';
$string['backupmissinguserinfoperms'] = 'Remarque : cette sauvegarde ne contient aucune donnée d’utilisateur. Les activités Exercice et Atelier ne seront pas incluses dans la sauvegarde, puisque ces modules ne sont pas compatibles avec de type de sauvegarde.';
$string['backupnext'] = 'Prochaine sauvegarde';
$string['backupnonisowarning'] = 'Attention ! Cette sauvegarde provient d’une version non Unicode de Moodle (antérieure à la version 1.6). Si elle contient des textes en caractères non ISO-8859-1, ceux-ci pourront être ENDOMMAGÉS si vous la restaurez dans cette version Unicode de Moodle. Veuillez consulter la <a href="https://docs.moodle.org/fr/FAQ_de_sauvegarde">FAQ de sauvegarde</a> pour plus d’informations sur la façon de restaurer correctement cette sauvegarde.';
$string['backupnotyetrun'] = 'Sauvegarde automatique en attente';
$string['backuporiginalname'] = 'Nom de la sauvegarde';
$string['backuproleassignments'] = 'Sauvegarder les attributions de rôles pour ces rôles';
$string['backupsavetohelp'] = 'Chemin d’accès complet du dossier où vous voulez enregistrer les sauvegardes';
$string['backupsitefileshelp'] = 'Cochez cette option si vous voulez que les fichiers du site utilisés dans les cours soient inclus dans les sauvegardes automatiques';
$string['backuptakealook'] = 'Veuillez consulter les journaux des sauvegardes : {$a}';
$string['backupuserfileshelp'] = 'Choisissez si vous désirez inclure les fichiers des utilisateurs (par exemple l’image du profil) dans les sauvegardes automatiques';
$string['backupversion'] = 'Version de la sauvegarde';
$string['badges'] = 'Badges';
$string['block'] = 'Bloc';
$string['blockconfiga'] = 'Configuration du bloc « {$a} »';
$string['blockconfigbad'] = 'Ce bloc n’a pas été implémenté correctement et ne fournit donc pas d’interface de configuration.';
$string['blocks'] = 'Blocs';
$string['blocks_main'] = 'Blocs du contenu principal';
$string['blocks_supplementary'] = 'Blocs supplémentaires';
$string['blocksaddedit'] = 'Ajouter/Modifier des blocs';
$string['blockseditoff'] = 'Désactiver l’édition des blocs';
$string['blocksediton'] = 'Activer l’édition des blocs';
$string['blocksetup'] = 'Installation des tables de blocs';
$string['blocksuccess'] = 'Les tables {$a} ont été installées correctement';
$string['brief'] = 'Résumé';
$string['bulkactions'] = 'Actions par lots';
$string['bulkactionselect'] = 'Sélection d’actions par lots pour {$a}';
$string['bulkcancel'] = 'Fermer la modification par lots';
$string['bulkmovecoursessuccess'] = '{$a->courses} cours déplacés dans {$a->category}';
$string['bulkselection'] = '{$a} sélectionnés';
$string['bycourseorder'] = 'Ordre dans le cours';
$string['byname'] = 'par {$a}';
$string['bypassed'] = 'Court-circuité';
$string['cachecontrols'] = 'Réglages du cache';
$string['calltofeedback'] = 'Les auteurs de ce logiciel apprécieraient votre avis sur Moodle.';
$string['calltofeedback_give'] = 'Envoyer un feedback sur ce logiciel';
$string['calltofeedback_remind'] = 'Me rappeler plus tard';
$string['cancel'] = 'Annuler';
$string['cancelled'] = 'Annulé';
$string['categories'] = 'Catégories de cours';
$string['categoriesandcourses'] = 'Catégories de cours et cours';
$string['category'] = 'Catégorie';
$string['categoryadded'] = 'La catégorie « {$a} » a été ajoutée';
$string['categorybulkaction'] = 'Actions par lots pour les catégories sélectionnées';
$string['categorycontents'] = 'Sous-catégories et cours';
$string['categorycurrentcontents'] = 'Contenu de {$a}';
$string['categorydeleted'] = 'La catégorie « {$a} » a été supprimée';
$string['categoryduplicate'] = 'Une catégorie de ce nom (« {$a} ») existe déjà';
$string['categoryheader'] = 'Menu de catégorie';
$string['categoryhidden'] = '(caché)';
$string['categorymodifiedcancel'] = 'La catégorie a été modifiée ! Veuillez annuler et essayer encore.';
$string['categoryname'] = 'Nom de catégorie';
$string['categorypath'] = 'Chemin de catégorie';
$string['categorysubcategoryof'] = '{$a->category} - sous-catégorie de {$a->parentcategory}';
$string['categoryupdated'] = 'La catégorie « {$a} » a été modifiée';
$string['changedpassword'] = 'Mot de passe modifié';
$string['changepassword'] = 'Changer le mot de passe';
$string['changesmade'] = 'Modifications effectuées';
$string['changesmadereallygoaway'] = 'Vous avez effectué des modifications. Voulez-vous vraiment quitter cette page et perdre vos modifications ?';
$string['changessaved'] = 'Modifications enregistrées';
$string['check'] = 'Vérifier';
$string['checkactual'] = 'Effectif';
$string['checkall'] = 'Tout vérifier';
$string['checkerror'] = 'Erreur lors de l’obtention du résultat de la vérification « {$a} ». Consulter la console du navigateur pour en savoir plus.';
$string['checkexpected'] = 'Attendu';
$string['checkingbackup'] = 'Vérification de la sauvegarde';
$string['checkingcourse'] = 'Vérification du cours';
$string['checkingforbbexport'] = 'Vérification pour exportation BlackBoard';
$string['checkinginstances'] = 'Verification des instances';
$string['checkingsections'] = 'Vérification des sections';
$string['checklanguage'] = 'Tester la langue';
$string['checkloading'] = 'Obtention du résultat de la vérification « {$a} »';
$string['checknone'] = 'Ne rien vérifier';
$string['checks'] = 'Vérifications';
$string['checksok'] = 'Toutes les vérifications « {$a} » sont OK';
$string['childcoursenotfound'] = 'Le cours descendant n’a pas été trouvé !';
$string['childcourses'] = 'Cours descendants';
$string['choose'] = 'Choisir';
$string['choosecourse'] = 'Choisir un cours';
$string['choosedots'] = 'Choisir…';
$string['chooselivelogs'] = 'Observer les activités en cours';
$string['chooselogs'] = 'Choisir le journal que vous souhaitez consulter';
$string['choosereportfilter'] = 'Choisir un filtre pour le rapport';
$string['choosetheme'] = 'Choisir un thème';
$string['chooseuser'] = 'Choisir un utilisateur';
$string['city'] = 'Ville';
$string['cleaningtempdata'] = 'Suppression des données temporaires';
$string['clear'] = 'Effacer';
$string['clearall'] = 'Tout effacer';
$string['clearfilterrow'] = 'Retirer la rangée de filtre';
$string['clearfilters'] = 'Réinitialiser les filtres';
$string['clearsearch'] = 'Effacer la saisie de la recherche';
$string['clickhelpiconformoreinfo'] = '… suite … Cliquer sur l’icône d’aide pour lire la totalité de l’article';
$string['clickhere'] = 'Cliquer ici…';
$string['clicktochangeinbrackets'] = '{$a} (Cliquer pour modifier)';
$string['clicktohideshow'] = 'Cliquer pour déplier ou replier';
$string['closeblockdrawer'] = 'Fermer le tiroir des blocs';
$string['closebuttontitle'] = 'Fermer';
$string['closecourseindex'] = 'Fermer l’index du cours';
$string['closedrawer'] = 'Fermer le tiroir';
$string['closewindow'] = 'Fermer cette fenêtre';
$string['collapse'] = 'Replier';
$string['collapseall'] = 'Tout replier';
$string['collapsecategory'] = 'Replier {$a}';
$string['comebacklater'] = 'Veuillez revenir plus tard.';
$string['commentincontext'] = 'Chercher ce commentaire dans le contexte';
$string['comments'] = 'Commentaires';
$string['commentscount'] = 'Commentaires ({$a})';
$string['commentsnotenabled'] = 'La fonctionnalité de commentaires n’est pas activée.';
$string['commentsrequirelogin'] = 'Vous devez vous connecter pour voir les commentaires.';
$string['comparelanguage'] = 'Comparer et modifier la langue active';
$string['complete'] = 'Complet';
$string['completed'] = 'Terminé';
$string['completereport'] = 'Rapport complet';
$string['configuration'] = 'Configuration';
$string['confirm'] = 'Confirmer';
$string['confirmaccount'] = 'Confirmer le compte';
$string['confirmcheckfull'] = 'Voulez-vous vraiment confirmer {$a} ?';
$string['confirmcoursemove'] = 'Voulez-vous vraiment déplacer ce cours ({$a->course}) dans cette catégorie ({$a->category}) ?';
$string['confirmdeletesection'] = 'Voulez-vous vraiment supprimer « {$a} » et toutes les activités qui y sont placées ?';
$string['confirmed'] = 'Votre enregistrement a été confirmé';
$string['confirmednot'] = 'Votre enregistrement n’a pas encore été confirmé. Veuillez vérifier si vous avez reçu un courriel de confirmation.';
$string['considereddigitalminor'] = 'Vous êtes trop jeune pour créer un compte sur ce site.';
$string['content'] = 'Contenu';
$string['contentbank'] = 'Banque de contenus';
$string['contentexport_aboutthiscourse'] = 'Résumé du cours';
$string['contentexport_coursesummary'] = 'Ce fichier fait partie du contenu téléchargé de <a href="{$a->courselink}">{$a->coursename}</a>.';
$string['contentexport_footersummary'] = 'Ce fichier fait partie du contenu téléchargé de <a href="{$a->courselink}">{$a->coursename}</a> par {$a->userfullname} le {$a->date}.';
$string['contentexport_modulesummary'] = 'Cette page fait partie du contenu téléchargé de <a href="{$a->modulelink}">{$a->modulename}</a> le {$a->date}. Certains contenus et tous les fichiers de taille plus grande que {$a->maxfilesize} ne sont pas téléchargés.';
$string['contentexport_viewfilename'] = 'Consulter le fichier {$a}';
$string['context'] = 'Contexte';
$string['contextlevel'] = 'Niveau de contexte';
$string['contextname'] = 'Nom du contexte';
$string['contextparent'] = 'Parent';
$string['contexturl'] = 'URL du contexte';
$string['continue'] = 'Continuer';
$string['continuetocourse'] = 'Cliquer ici pour accéder à votre cours';
$string['convertingwikitomarkdown'] = 'Conversion du format Wiki au Markdown';
$string['cookiesenabled'] = 'Votre navigateur doit prendre en charge les cookies';
$string['cookiesenabled_help'] = 'Ce site utilise deux cookies.

Un cookie essentiel est utilisé pour la session de travail. Il est habituellement appelé MoodleSession. Ce cookie doit être autorisé dans le navigateur afin de pouvoir naviguer sur le site sans avoir à se reconnecter à tout moment. Ce cookie est supprimé (du navigateur et du serveur) lors de la déconnexion du site ou de la fermeture du navigateur.

L’autre cookie rend plus confortable la navigation. Il est habituellement appelé MOODLEID. Il permet de mémoriser dans le navigateur le nom d’utilisateur. Cela signifie que lors d’un retour sur le site, le champ du nom d’utilisateur est pré-rempli. Le refus de ce cookie est sans conséquence : le nom d’utilisateur devra être ressaisi lors de chaque connexion.';
$string['cookiesenabled_help_html'] = 'Ce site utilise deux cookies.<br/><br/>

Un cookie essentiel est utilisé pour la session de travail. Il est habituellement appelé MoodleSession. Ce cookie doit être autorisé dans le navigateur afin de pouvoir naviguer sur le site sans avoir à se reconnecter à tout moment. Ce cookie est supprimé (du navigateur et du serveur) lors de la déconnexion du site ou de la fermeture du navigateur.<br/><br/>

L’autre cookie rend plus confortable la navigation. Il est habituellement appelé MOODLEID. Il permet de mémoriser dans le navigateur le nom d’utilisateur. Cela signifie que lors d’un retour sur le site, le champ du nom d’utilisateur est pré-rempli. Le refus de ce cookie est sans conséquence : le nom d’utilisateur devra être ressaisi lors de chaque connexion.';
$string['cookiesenabledonlysession'] = 'Votre navigateur doit prendre en charge les cookies';
$string['cookiesenabledonlysession_help'] = 'Ce site utilise un cookie de session, appelé usuellement MoodleSession. Vous devez autoriser ce cookie dans votre navigateur afin de pouvoir naviguer sur le site sans avoir à vous reconnecter à tout moment. Ce cookie est supprimé du navigateur et du serveur lorsque vous vous déconnectez ou si vous quittez le navigateur.';
$string['cookiesnotenabled'] = 'La gestion des cookies n’est malheureusement pas activée actuellement dans votre navigateur';
$string['cookiesnotice'] = 'Avis relatif aux cookies';
$string['copy'] = 'copie';
$string['copyasnoun'] = 'copie';
$string['copycourse'] = 'Copier cours';
$string['copyingcoursefiles'] = 'Copie des fichiers du cours';
$string['copyingsitefiles'] = 'Copie des fichiers du site utilisés dans les cours';
$string['copyinguserfiles'] = 'Copie des fichiers utilisateurs';
$string['copyingzipfile'] = 'Copie du fichier compacté (zip)';
$string['copyrightnotice'] = 'Copyright';
$string['copytoclipboard'] = 'Copier dans le presse-papier';
$string['coresystem'] = 'Système';
$string['cost'] = 'Coût';
$string['costdefault'] = 'Coût par défaut';
$string['counteditems'] = '{$a->count} {$a->items}';
$string['country'] = 'Pays';
$string['course'] = 'Cours';
$string['courseadministration'] = 'Administration du cours';
$string['courseapprovedemail'] = 'Le cours demandé a été approuvé, <a href="{$a->url}">{$a->name}</a>, et vous y êtes {$a->teacher}.';
$string['courseapprovedemail2'] = 'Le cours demandé a été approuvé : <a href="{$a->url}">{$a->name}</a>.';
$string['courseapprovedfailed'] = 'La création de ce cours comme approuvé a échoué !';
$string['courseapprovedsubject'] = 'Votre cours a été approuvé.';
$string['courseavailable'] = 'Ce cours est ouvert aux étudiants';
$string['courseavailablenot'] = 'Ce cours n’est pas ouvert aux étudiants';
$string['coursebackup'] = 'Sauvegarde du cours';
$string['coursebulkaction'] = 'Actions par lots pour les cours sélectionnés';
$string['coursecategories'] = 'Catégories de cours';
$string['coursecategory'] = 'Catégorie de cours';
$string['coursecategory_help'] = 'Ce réglage détermine la catégorie dans laquelle le cours apparaîtra dans la liste des cours.';
$string['coursecategorydeleted'] = 'Catégorie de cours {$a} supprimée';
$string['coursecatmanagement'] = 'Gestion des cours et catégories';
$string['coursecompletion'] = 'Achèvement de cours';
$string['coursecompletions'] = 'Achèvements de cours';
$string['coursecreators'] = 'Créateur de cours';
$string['coursecreatorsdescription'] = 'Les créateurs des cours peuvent créer de nouveaux cours.';
$string['coursedeleted'] = 'Cours {$a} supprimé';
$string['coursedetails'] = 'Informations détaillées du cours';
$string['coursedisplay'] = 'Mise en page du cours';
$string['coursedisplay_help'] = 'Les sections peuvent être affichées toutes sur une seule page ou chacune sur sa page.';
$string['coursedisplay_multi'] = 'Afficher une section par page';
$string['coursedisplay_single'] = 'Afficher toutes les sections sur une même page';
$string['courseduration'] = 'Durée du cours';
$string['courseduration_desc'] = 'La durée du cours est utilisée pour calculer la date de fin du cours. Cette date de fin est utilisée pour déterminer si le cours doit être affiché dans la liste des cours de l’utilisateur. Elle peut aussi être utilisée dans des rapports personnalisés. Les utilisateurs pourront entrer dans le cours même après la date de fin du cours.';
$string['courseenddateenabled'] = 'Date de fin de cours activée par défaut';
$string['courseenddateenabled_desc'] = 'Ce réglage détermine si la date de fin du cours doit être activée par défaut pour les nouveaux cours et fixée à la date calculée à partir de la durée du cours.';
$string['courseextendednamedisplay'] = '{$a->shortname} {$a->fullname}';
$string['coursefiles'] = 'Fichiers du cours (obsolète)';
$string['coursefilesedit'] = 'Modifier les fichiers du cours';
$string['coursefileswarning'] = 'Les fichiers du cours sont obsolètes';
$string['coursefileswarning_help'] = 'Les fichiers du cours sont obsolètes à partir de la version 2.0 de Moodle. Veuillez utiliser des dépôts externes autant que faire se peut.';
$string['courseformatdata'] = 'Données du format de cours';
$string['courseformatoptions'] = 'Options du format {$a}';
$string['courseformats'] = 'Formats de cours';
$string['courseformatudpate'] = 'Modifier format';
$string['coursegrades'] = 'Notes du cours';
$string['courseheader'] = 'Menu de cours';
$string['coursehelpcategory'] = 'Positionne le cours dans la liste des cours et le rend plus simple à trouver pour les étudiants.';
$string['coursehelpforce'] = 'Imposer le type de groupe pour chaque activité du cours.';
$string['coursehelpformat'] = 'La page principale du cours sera affichée dans ce format.';
$string['coursehelphiddensections'] = 'Comment les sections cachées du cours seront affichées pour les étudiants.';
$string['coursehelpmaximumupload'] = 'Définit la taille maximale de chaque fichier pouvant être déposé dans le cours. Le maximum est limité par un réglage analogue au niveau du site.';
$string['coursehelpnewsitemsnumber'] = 'Nombre d’annonces récentes affichées sur la page du cours, dans le bloc des nouvelles annonces. Si 0 est indiqué, le forum des annonces ne sera pas créé.';
$string['coursehelpnumberweeks'] = 'Nombre de sections du cours (n’est valable que pour certains formats de cours).';
$string['coursehelpshowgrades'] = 'Active l’affichage du carnet de notes. Ce réglage n’a pas d’influence sur l’affichage des notes dans les diverses activités du cours.';
$string['coursehidden'] = 'Ce cours n’est actuellement pas disponible pour les étudiants';
$string['courseinfo'] = 'Informations du cours';
$string['courselegacyfiles'] = 'Fichiers du cours (obsolète)';
$string['courselegacyfiles_help'] = 'La zone des fichiers du cours fournit une compatibilité descendante avec Moodle versions 1.9 et antérieures. Tous les fichiers de cette zone sont toujours lisibles par tous les participants du cours, qu’un lien pointe vers eux ou non. Il n’y a aucun moyen de savoir si ces fichiers sont utilisés dans Moodle.

Si vous utilisez cette zone pour stocker des fichiers, vous risquez de vous exposer à des questions de protection des données et de sécurité, ainsi que des fichiers manquants dans les sauvegardes, lors d’importations de cours et chaque fois qu’un contenu est partagé ou réutilisé. Il est donc recommandé de ne pas utiliser cette zone, à moins que vous ne sachiez vraiment ce que vous faites.';
$string['courselegacyfiles_link'] = 'coursefiles2';
$string['courselegacyfilesofcourse'] = 'Fichiers de cours obsolètes : {$a}';
$string['coursenotaccessible'] = 'Ce cours n’est pas disponible pour le public';
$string['courseoverview'] = 'Aperçu du cours';
$string['courseoverviewfiles'] = 'Image de cours';
$string['courseoverviewfiles_help'] = 'L’image de cours est affichée dans Mes cours et sur la page d’accueil dans la liste des cours disponibles. Les administrateurs du site peuvent activer d’autres types de fichiers et l’utilisation de plusieurs fichiers. Si plusieurs fichiers sont utilisés, ils seront tous affichés sur la page d’accueil dans la liste des cours disponibles.';
$string['courseoverviewfilesext'] = 'Extensions des fichiers image de cours';
$string['courseoverviewfileslimit'] = 'Limite du nombre de fichiers image de cours';
$string['courseoverviewgraph'] = 'Graphique de l’aperçu du cours';
$string['courseprofiles'] = 'Profils de cours';
$string['coursereasonforrejecting'] = 'Vos raisons de rejeter cette demande';
$string['coursereasonforrejectingemail'] = 'Ceci sera envoyé au demandeur';
$string['coursereject'] = 'Rejeter une demande de cours';
$string['courserejected'] = 'La demande de cours a été rejetée et le requérant en a été notifié.';
$string['courserejectemail'] = 'Désolé, le cours que vous avez demandé n’a pas été créé. Voici la raison pour laquelle votre demande a été rejetée :

{$a}';
$string['courserejectreason'] = 'Résumez vos raisons de rejeter ce cours<br />(ce message sera envoyé au requérant)';
$string['courserejectsubject'] = 'Votre demande d’ouverture de cours a été rejetée';
$string['coursereport'] = 'Rapport de cours';
$string['coursereports'] = 'Rapports du cours';
$string['courserequest'] = 'Demande de création de cours';
$string['courserequestdetails'] = 'Informations du cours que vous demandez';
$string['courserequestfailed'] = 'Votre demande n’a pas pu être enregistrée pour une raison inconnue';
$string['courserequestintro'] = 'Utiliser ce formulaire pour demander l’ouverture d’un cours pour vous.<br />Veuillez remplir toutes les informations possibles pour permettre aux<br />administrateurs de comprendre les raisons de votre demande.';
$string['courserequestreason'] = 'Pourquoi voulez-vous créer ce cours ?';
$string['courserequestroleerror'] = 'La configuration du rôle des créateurs de cours dans les nouveaux cours n’est pas valide. Veuillez corriger ceci dans les <a href="{$a}">politiques utilisateurs</a>.';
$string['courserequestsuccess'] = 'Demande de cours envoyée.';
$string['courserequestsupport'] = 'Informations supplémentaires pour aider l’administrateur à évaluer cette demande';
$string['courserequestwarning'] = 'L’utilisateur ayant demandé ce cours y sera inscrit automatiquement avec le rôle « {$a} ».';
$string['courserestore'] = 'Restauration du cours';
$string['coursereuse'] = 'Réutilisation de cours';
$string['coursereusenavigationmenu'] = 'Menu de navigation de la réutilisation de cours';
$string['courses'] = 'Cours';
$string['coursesearch'] = 'Rechercher des cours';
$string['coursesearch_help'] = 'Vous pouvez saisir plusieurs termes comme critères et affiner votre recherche de la façon suivante :

* terme : rechercher toutes les occurrences du terme dans le texte
* +terme : seules les correspondances exactes du terme (mot entier) seront trouvées
* -terme : ne pas inclure les résultats contenant ce terme';
$string['coursesectionsummaries'] = 'Résumés des sections de cours';
$string['coursesectiontitle'] = '{$a->sectionname} : {$a->sectiontitle} | {$a->course}';
$string['coursesectiontitlebulkediting'] = 'Modifier par lots {$a->sectionname} : {$a->sectiontitle} | {$a->course}';
$string['coursesectiontitleediting'] = 'Modifier {$a->sectionname} : {$a->sectiontitle} | {$a->course}';
$string['coursesettings'] = 'Réglages par défaut des cours';
$string['coursesmovedout'] = 'Cours déplacés hors de {$a}';
$string['coursespending'] = 'Cours en attente d’approbation';
$string['coursestart'] = 'Début du cours';
$string['coursesummary'] = 'Résumé du cours';
$string['coursesummary_help'] = 'Une brève description du cours. Le contenu de ce champ pourra être recherché.';
$string['coursetitle'] = 'Cours : {$a->course}';
$string['coursetitlebulkediting'] = 'Modifier par lots le cours : {$a->course}';
$string['coursetitleediting'] = 'Modifier le cours : {$a->course}';
$string['courseupdates'] = 'Modifications du cours';
$string['coursevisibility'] = 'Visibilité du cours';
$string['coursevisibility_help'] = '* Afficher : le cours apparaît dans la liste des cours et les étudiants peuvent y accéder.
* Cacher : l’accès au cours n’est permis qu’aux enseignants et aux autres utilisateurs ayant la capacité de voir les cours cachés.';
$string['create'] = 'Créer';
$string['createaccount'] = 'Créer mon compte';
$string['createcategory'] = 'Créer catégorie';
$string['createfolder'] = 'Créer un dossier dans {$a}';
$string['createnew'] = 'Nouvelle catégorie';
$string['createnewcategory'] = 'Créer une catégorie';
$string['createnewcourse'] = 'Créer un cours';
$string['createnewsubcategory'] = 'Créer une sous-catégorie';
$string['createsubcategoryof'] = 'Créer une sous-catégorie de {$a}';
$string['createuser'] = 'Créer utilisateur';
$string['createziparchive'] = 'Créer une archive compactée zip';
$string['creatingblocks'] = 'Création des blocs';
$string['creatingblocksroles'] = 'Création des attributions de rôles et des dérogations pour les blocs';
$string['creatingblogsinfo'] = 'Création des informations des blogs';
$string['creatingcategoriesandquestions'] = 'Création des catégories et des questions';
$string['creatingcoursemodules'] = 'Création des modules de cours';
$string['creatingcourseroles'] = 'Création des attributions de rôles et des dérogations pour les cours';
$string['creatingevents'] = 'Création du calendrier';
$string['creatinggradebook'] = 'Création du carnet de notes';
$string['creatinggroupings'] = 'Création des groupements';
$string['creatinggroupingsgroups'] = 'Ajout des groupes dans les groupements';
$string['creatinggroups'] = 'Création des groupes';
$string['creatinglogentries'] = 'Création des journaux';
$string['creatingmessagesinfo'] = 'Création des informations des messages';
$string['creatingmodroles'] = 'Création des attributions de rôles et des dérogations pour les modules';
$string['creatingnewcourse'] = 'Création d’un nouveau cours';
$string['creatingrolesdefinitions'] = 'Création des définitions des rôles';
$string['creatingscales'] = 'Création des barèmes';
$string['creatingsections'] = 'Création des sections';
$string['creatingtemporarystructures'] = 'Création des structures temporaires';
$string['creatinguserroles'] = 'Création des attributions de rôles et des dérogations pour les utilisateurs';
$string['creatingusers'] = 'Création des utilisateurs';
$string['creatingxmlfile'] = 'Création du fichier XML';
$string['currency'] = 'Monnaie';
$string['currentcourse'] = 'Cours actuel';
$string['currentcourseadding'] = 'Cours actuel, en y ajoutant les données';
$string['currentcoursedeleting'] = 'Cours actuel, en le supprimant d’abord';
$string['currentlanguage'] = 'Langue active';
$string['currentlocaltime'] = 'l’heure à l’endroit où vous êtes';
$string['currentpicture'] = 'Image actuelle';
$string['currentrelease'] = 'Information sur la version actuelle';
$string['currenttheme'] = 'Thème actuel';
$string['currentversion'] = 'Version actuelle';
$string['databasechecking'] = 'Mise à jour de la base de données Moodle de la version {$a->oldversion} vers la version {$a->newversion}';
$string['databaseperformance'] = 'Performance de la base de données';
$string['databasesetup'] = 'Installation de la base de données';
$string['databasesuccess'] = 'La base de données a été correctement mise à jour';
$string['databaseupgradebackups'] = 'La version du logiciel de sauvegarde est maintenant {$a}';
$string['databaseupgradeblocks'] = 'La version du logiciel des blocs est maintenant {$a}';
$string['databaseupgradegroups'] = 'La version du logiciel des groupes est maintenant {$a}';
$string['databaseupgradelocal'] = 'La version des modifications locales de la base de données est maintenant {$a}';
$string['databaseupgrades'] = 'Mise à jour de la base de données';
$string['dataformats'] = 'Formats de données';
$string['date'] = 'Date';
$string['datechanged'] = 'Date de modification';
$string['datemostrecentfirst'] = 'Date - la plus récente en premier';
$string['datemostrecentlast'] = 'Date - la plus récente en dernier';
$string['day'] = 'jour';
$string['days'] = 'jours';
$string['decodinginternallinks'] = 'Décodage des liens internes';
$string['default'] = 'Défaut';
$string['defaultcategoryname'] = 'Catégorie 1';
$string['defaultcompetencescale'] = 'Barème de compétence par défaut';
$string['defaultcompetencescaledesc'] = 'Un barème à deux niveaux qui indique si un participant a démontré sa compétence ou non.';
$string['defaultcompetencescalenotproficient'] = 'Pas encore compétent';
$string['defaultcompetencescaleproficient'] = 'Compétent';
$string['defaultcoursestudent'] = 'Étudiant';
$string['defaultcoursestudentdescription'] = 'Les étudiants ont en général moins de privilèges dans un cours.';
$string['defaultcoursestudents'] = 'Étudiants';
$string['defaultcoursesummary'] = 'Écrire un paragraphe concis et précis qui expose le contenu du cours';
$string['defaultcourseteacher'] = 'Enseignant';
$string['defaultcourseteacherdescription'] = 'Les enseignants peuvent tout faire dans un cours, y compris ajouter et modifier les activités et donner des notes aux étudiants.';
$string['defaultcourseteachers'] = 'Enseignants';
$string['defaulteditor'] = 'Éditeur par défaut';
$string['defaulthomepageuser'] = 'Page initiale';
$string['defaulthomepageuser_help'] = 'La page affichée après connexion au site.';
$string['delete'] = 'Supprimer';
$string['deleteablock'] = 'Supprimer un bloc';
$string['deleteall'] = 'Tout supprimer';
$string['deleteallcannotundo'] = 'Tout supprimer - ne peut pas être annulé';
$string['deleteallcomments'] = 'Tous les commentaires';
$string['deleteallratings'] = 'Toutes les évaluations';
$string['deletecategory'] = 'Supprimer la catégorie {$a}';
$string['deletecategorycheck'] = 'Voulez-vous vraiment supprimer la catégorie <strong>« {$a} »</strong>?<br />Tous les cours de cette catégorie seront déplacés la catégorie mère, si elle existe, ou à défaut dans la catégorie Divers.';
$string['deletecategorycheck2'] = 'Si vous supprimez cette catégorie, vous devez choisir que faire avec les cours et sous-catégories qu’elle contient.';
$string['deletecategoryempty'] = 'Cette catégorie est vide.';
$string['deletecheck'] = 'Supprimer {$a} ?';
$string['deletecheckfiles'] = 'Voulez-vous vraiment supprimer ces fichiers ?';
$string['deletecheckfull'] = 'Voulez-vous vraiment supprimer l’utilisateur {$a}, y compris ses données telles informations de profil, inscriptions, affiliations à des groupes et cohortes et données d’activités ?';
$string['deletechecktype'] = 'Voulez-vous vraiment supprimer ce {$a->type} ?';
$string['deletechecktypename'] = 'Voulez-vous vraiment supprimer le {$a->type} « {$a->name} » ?';
$string['deletecheckwarning'] = 'Vous allez supprimer ces fichiers';
$string['deletecommentbyon'] = 'Supprimer le commentaire de {$a->user} écrit le {$a->time}';
$string['deletecompletely'] = 'Supprimer entièrement';
$string['deletecourse'] = 'Supprimer un cours';
$string['deletecoursecheck'] = 'Voulez-vous vraiment supprimer ce cours ainsi que toutes les données qu’il contient ?';
$string['deleted'] = 'Supprimé';
$string['deletedactivity'] = '{$a} supprimé(e)';
$string['deletedcourse'] = '{$a} a été entièrement supprimé';
$string['deletednot'] = 'Impossible de supprimer {$a}.';
$string['deletepicture'] = 'Supprimer';
$string['deletesection'] = 'Supprimer';
$string['deleteselected'] = 'Supprimer les éléments sélectionnés';
$string['deleteselectedkey'] = 'Supprimer la clef sélectionnée';
$string['deletingcourse'] = 'Suppression de {$a}';
$string['deletingexistingcoursedata'] = 'Suppression des données d’un cours existant';
$string['deletingolddata'] = 'Suppression des anciennes données';
$string['department'] = 'Département';
$string['deprecatedeventname'] = '{$a} (n’est plus utilisé)';
$string['desc'] = 'Descendant';
$string['description'] = 'Description';
$string['deselectall'] = 'Tout désélectionner';
$string['deselectnos'] = 'Désélectionner tous les « Non »';
$string['detailedless'] = 'Moins de détails';
$string['detailedmore'] = 'Plus de détails';
$string['details'] = 'Détails';
$string['digitalminor'] = 'Mineur numérique';
$string['digitalminor_desc'] = 'Veuillez demander à votre représentant légal de contacter :';
$string['directory'] = 'Dossier';
$string['disable'] = 'Désactiver';
$string['disabledcomments'] = 'Les commentaires sont désactivés';
$string['dismissnotification'] = 'Ignorer cette notification';
$string['displayingfirst'] = 'Seules les {$a->count} premier(ère)s {$a->things} sont affiché(e)s';
$string['displayingrecords'] = '{$a} enregistrements affichés';
$string['displayingusers'] = 'Affichage des utilisateurs de {$a->start} à {$a->end}';
$string['displayonpage'] = 'Affichage sur la page';
$string['dndcourse'] = 'Vous pouvez glisser-déplacer ce cours pour modifier son ordre de tri ou le déplacer dans une autre catégorie';
$string['dndenabled_inbox'] = 'Vous pouvez glisser des fichiers ici pour les ajouter.';
$string['dndnotsupported'] = 'Le dépôt de fichiers par glisser-déposer n’est pas pris en charge.';
$string['dndnotsupported_help'] = 'Votre navigateur ne prend pas en charge le dépôt de fichiers par glisser-déposer. Cette fonctionnalité est disponible dans les versions récentes de Chrome, Firefox et Safari, ainsi que dans Internet Explorer 10 et versions ultérieures.';
$string['dndnotsupported_insentence'] = 'Glisser-déposer non pris en charge';
$string['dnduploadwithoutcontent'] = 'Ce fichier n’a pas de contenu';
$string['dndworkingfile'] = 'Glisser et déposer des fichiers pour les placer dans les sections du cours';
$string['dndworkingfilelink'] = 'Glisser et déposer des fichiers ou des liens pour les déposer dans les sections du cours';
$string['dndworkingfiletext'] = 'Glisser et déposer des fichiers ou des textes pour les déposer dans les sections du cours';
$string['dndworkingfiletextlink'] = 'Glisser et déposer des fichiers, des textes ou des liens pour les déposer dans les sections du cours';
$string['dndworkinglink'] = 'Glisser et déposer des liens pour les déposer dans les sections du cours';
$string['dndworkingtext'] = 'Glisser et déposer des textes pour les déposer dans les sections du cours';
$string['dndworkingtextlink'] = 'Glisser et déposer des textes ou des liens pour les déposer dans les sections du cours';
$string['documentation'] = 'Documentation de Moodle';
$string['dontsortcategories'] = 'Ne pas trier les catégories';
$string['dontsortcourses'] = 'Ne pas trier les cours';
$string['down'] = 'Vers le bas';
$string['download'] = 'Télécharger';
$string['downloadall'] = 'Tout télécharger';
$string['downloadexcel'] = 'Télécharger en format Excel';
$string['downloadfile'] = 'Télécharger le fichier';
$string['downloadods'] = 'Télécharger en format ODS';
$string['downloadtext'] = 'Télécharger en format texte';
$string['doyouagree'] = 'Avez-vous lu et compris ces conditions ?';
$string['droptoupload'] = 'Lâcher les fichiers ici pour les envoyer';
$string['duplicate'] = 'Dupliquer';
$string['duplicatedmodule'] = '{$a} (copie)';
$string['duplicatedsection'] = '{$a} (copie)';
$string['edhelpaspellpath'] = 'Pour utiliser le correcteur orthographique dans l’éditeur HTML, le programme <strong>aspell</strong> version <strong>0.50</strong> ou ultérieure doit être installé sur le serveur, et son chemin d’accès doit être configuré correctement. Sur les systèmes Unix/Linux, ce chemin d’accès est habituellement <strong>/usr/bin/aspell</strong>.';
$string['edhelpbgcolor'] = 'Couleur de fond de l’éditeur.<br />Des valeurs correctes sont par exemple : #ffffff ou white';
$string['edhelpcleanword'] = 'Ce réglage permet l’activation du filtre spécifique au format Word.';
$string['edhelpenablespelling'] = 'Activation du correcteur orthographique. S’il est activé, le programme <strong>aspell</strong> doit être installé sur le serveur. La seconde valeur est le <strong>dictionnaire par défaut</strong>. Cette valeur sera utilisée si aspell n’a pas de dictionnaire pour la langue de l’utilisateur.';
$string['edhelpfontfamily'] = 'Police ou famille de polices utilisée par défaut dans l’éditeur. Les noms doivent être séparés par des virgules.';
$string['edhelpfontlist'] = 'Définition des polices disponibles dans le menu de l’éditeur.';
$string['edhelpfontsize'] = 'Corps par défaut (taille de la police) utilisé dans l’éditeur.<br />Des valeurs correctes sont par exemple : medium, large, smaller, larger, 10pt, 11px.';
$string['edit'] = 'Modifier';
$string['edita'] = 'Modifier {$a}';
$string['editcategorysettings'] = 'Modifier les paramètres de la catégorie';
$string['editcategorythis'] = 'Modifier cette catégorie';
$string['editcoursesettings'] = 'Modifier les paramètres du cours';
$string['editfiles'] = 'Modifier les fichiers';
$string['editgroupprofile'] = 'Modifier la description du groupe';
$string['editinga'] = 'Modification {$a}';
$string['editingteachershort'] = 'Éditeur';
$string['editlock'] = 'Cette valeur ne peut pas être modifiée !';
$string['editmode'] = 'Mode d’édition';
$string['editmyprofile'] = 'Modifier le profil';
$string['editorbgcolor'] = 'Couleur de fond';
$string['editorcleanonpaste'] = 'Nettoyage du HTML de Word lors du collage';
$string['editorcommonsettings'] = 'Réglages habituels';
$string['editordefaultfont'] = 'Police par défaut';
$string['editorenablespelling'] = 'Activer le correcteur orthographique';
$string['editorfontlist'] = 'Liste des polices';
$string['editorfontsize'] = 'Corps par défaut';
$string['editorpreferences'] = 'Préférences de l’éditeur';
$string['editorresettodefaults'] = 'Rétablir les valeurs par défaut de l’éditeur';
$string['editorsettings'] = 'Éditeur HTML';
$string['editorshortcutkeys'] = 'Raccourcis clavier éditeur';
$string['editsection'] = 'Modifier réglages';
$string['editsectionname'] = 'Modifier le nom de la section';
$string['editsectionsettings'] = 'Modifier les réglages de section';
$string['editsectiontitle'] = 'Modifier la section : {$a}';
$string['editsettings'] = 'Paramètres';
$string['editsummary'] = 'Modifier le résumé';
$string['editthisactivity'] = 'Modifier cette activité';
$string['editthiscategory'] = 'Modifier cette catégorie de cours';
$string['edittitle'] = 'Modifier le titre';
$string['edittitleinstructions'] = 'Esc pour annuler, Entrée pour terminer';
$string['edituser'] = 'Comptes des utilisateurs';
$string['edulevel'] = 'Tous les événements';
$string['edulevel_help'] = '* Enseignement : actions effectuées par un enseignant, p. ex. modification d’une ressource
* Participation : actions effectuées par un étudiant, p. ex. écrire dans un forum
* Autres : actions effectuées par un utilisateur avec un rôle différent d’enseignant ou étudiant';
$string['edulevelother'] = 'Autre';
$string['edulevelparticipating'] = 'Participant';
$string['edulevelteacher'] = 'Enseignant';
$string['email'] = 'Adresse de courriel';
$string['emailactive'] = 'Adresse de courriel activée';
$string['emailagain'] = 'Courriel (confirmation)';
$string['emailalreadysent'] = 'Un message de réinitialisation du mot de passe a déjà été envoyé. Veuillez consulter votre boîte de courriel.';
$string['emailcharset'] = 'Encodage des courriels';
$string['emailconfirm'] = 'Confirmer votre enregistrement';
$string['emailconfirmation'] = 'Bonjour {$a->firstname},

Un nouveau compte a été demandé sur « {$a->sitename} » avec votre adresse de courriel.

Pour confirmer votre nouveau compte, veuillez vous rendre à cette adresse web :

{$a->link}

Dans la plupart des programmes de courriel, ce lien devrait apparaître sous la forme d’un lien bleu sur lequel vous pouvez simplement cliquer. Si cela ne fonctionne pas, veuillez couper et coller l’adresse dans la barre d’adresse en haut de la fenêtre de votre navigateur web.

Si vous avez besoin d’aide, veuillez contacter l’administrateur du site, {$a->admin}';
$string['emailconfirmationresend'] = 'Renvoyer le courriel de confirmation';
$string['emailconfirmationsubject'] = '{$a} : confirmation de l’ouverture du compte';
$string['emailconfirmsent'] = '<p>Un message vous a été envoyé à l’adresse de courriel <strong>{$a}</strong>.</p><p>Il contient les instructions pour terminer votre enregistrement.</p><p>Si vous rencontrez des difficultés, veuillez contacter l’administrateur du site.</p>';
$string['emailconfirmsentfailure'] = 'Échec de l’envoi du courriel de confirmation';
$string['emailconfirmsentsuccess'] = 'Courriel de confirmation envoyé';
$string['emaildigest'] = 'Type de récapitulatif des messages';
$string['emaildigest_help'] = 'Ce réglage détermine le type de notification que les forums utiliseront par défaut pour le récapitulatif des messages.

* Pas de récapitulatif – vous recevrez un courriel pour chaque message de forum.
* Récapitulatif - messages complets – vous recevrez un courriel par jour contenant la totalité de chaque message de forum.
* Récapitulatif - objets seulement – vous recevrez un courriel par jour ne contenant que l’objet de chaque message de forum.

Ce réglage peut être différent pour chaque forum.';
$string['emaildigestcomplete'] = 'Complet (un courriel par jour avec l’intégralité des messages)';
$string['emaildigestoff'] = 'Pas de récapitulatif (un courriel par message)';
$string['emaildigestsubjects'] = 'Objets (un courriel par jour avec les objets des messages)';
$string['emaildisable'] = 'Cette adresse de courriel est désactivée';
$string['emaildisableclick'] = 'Cliquez ici pour désactiver l’envoi de courriels à cette adresse';
$string['emaildisplay'] = 'Visibilité de l’adresse de courriel';
$string['emaildisplay_help'] = '* Cachée - Seuls les utilisateurs aux permissions adéquates, comme les enseignants, peuvent voir votre adresse de courriel.
* Visible pour tout le monde - Tous les utilisateurs du site peuvent voir votre adresse de courriel.
* Visible pour les participants du cours - Seuls les participants aux cours auxquels vous êtes inscrits peuvent voir votre adresse de courriel.';
$string['emaildisplaycourse'] = 'Visible pour les participants du cours';
$string['emaildisplaycoursemembersonly'] = '(visible pour les autres participants au cours)';
$string['emaildisplayeveryone'] = '(visible pour tout le monde)';
$string['emaildisplayhide'] = '(cachée pour tout le monde, sauf pour les utilisateurs avec les permissions appropriées)';
$string['emaildisplayno'] = 'Cachée';
$string['emaildisplayyes'] = 'Visible pour tout le monde';
$string['emailenable'] = 'Cette adresse de courriel est activée';
$string['emailenableclick'] = 'Cliquez ici pour ré-activer l’envoi de courriels à cette adresse';
$string['emailexists'] = 'Cette adresse est déjà enregistrée.';
$string['emailexistshintlink'] = 'Récupérer un nom ou un mot de passe oublié';
$string['emailexistssignuphint'] = 'Vous avez peut-être créé un compte auparavant ? {$a}';
$string['emailformat'] = 'Format des courriels';
$string['emailmustbereal'] = 'Remarque : votre adresse de courriel doit être valide';
$string['emailnotallowed'] = 'Les adresses de courriel de ce domaine ne sont pas autorisées ({$a})';
$string['emailnotfound'] = 'Cette adresse de courriel n’a pas été trouvée dans la base de données';
$string['emailonlyallowed'] = 'Cette adresse de courriel ne peut pas être utilisée. Les domaines autorisés sont : {$a}';
$string['emailpasswordchangeinfo'] = 'Bonjour {$a->firstname},

Quelqu’un (probablement vous) a demandé un nouveau mot de passe pour votre compte « {$a->username} » sur « {$a->sitename} ».

Pour modifier votre mot de passe, visitez la page web suivante :

{$a->link}

Dans la plupart des logiciels de courriel, cette adresse devrait apparaître comme un lien de couleur bleue qu’il vous suffit de cliquer. Si cela ne fonctionne pas, copiez ce lien et collez-le dans la barre d’adresse de votre navigateur web.

Si vous avez besoin d’aide, veuillez contacter l’administrateur du site,
{$a->admin}';
$string['emailpasswordchangeinfodisabled'] = 'Bonjour {$a->firstname},

Quelqu’un (probablement vous) a demandé un nouveau mot de passe pour votre compte sur « {$a->sitename} ».

Malheureusement, votre compte sur ce site est désactivé et le mot de passe ne peut donc pas être réinitialisé. Veuillez contacter l’administrateur du site, {$a->admin}.';
$string['emailpasswordchangeinfofail'] = 'Bonjour {$a->firstname},

Quelqu’un (probablement vous) a demandé un nouveau mot de passe pour votre compte sur « {$a->sitename} ».

Malheureusement, les mots de passe ne peuvent pas être réinitialisés sur ce site. Veuillez contacter l’administrateur du site, {$a->admin}';
$string['emailpasswordchangeinfosubject'] = '{$a} : information sur le changement de mot de passe';
$string['emailpasswordconfirmation'] = 'Bonjour {$a->firstname},

Quelqu’un (probablement vous) a demandé un nouveau mot de passe pour votre compte sur « {$a->sitename} ».

Pour confirmer cette demande et recevoir votre nouveau mot de passe par courriel, visitez la page web suivante :

{$a->link}

Dans la plupart des logiciels de courriel, cette adresse devrait apparaître comme un lien de couleur bleue qu’il vous suffit de cliquer. Si cela ne fonctionne pas, copiez ce lien et collez-le dans la barre d’adresse de votre navigateur web.

Si vous avez besoin d’aide, veuillez contacter l’administrateur du site,
{$a->admin}';
$string['emailpasswordconfirmationsubject'] = '{$a} : confirmation du changement de mot de passe';
$string['emailpasswordconfirmmaybesent'] = '<p>Si vous avez fourni un nom d’utilisateur correct ou une adresse de courriel unique, un message vous a été envoyé par courriel.</p> <p>Ce message contient des instructions simples pour confirmer et terminer la modification du mot de passe. Si vous n’arrivez toujours pas à vous connecter, veuillez contacter l’administrateur du site.</p>';
$string['emailpasswordconfirmnoemail'] = '<p>Le compte utilisateur indiqué n’a pas d’adresse de courriel.</p>
<p>Veuillez contacter l’administrateur du site.</p>';
$string['emailpasswordconfirmnotsent'] = '<p>Les informations fournies ne correspondent pas à un compte utilisateur existant.</p>
<p>Veuillez vérifier les informations saisies et essayer à nouveau. Si cela ne fonctionne toujours pas, veuillez contacter l’administrateur du site.</p>';
$string['emailpasswordconfirmsent'] = '<p>Un message a été envoyé à votre adresse de courriel <strong>{$a}</strong>.</p><p>Ce message décrit la marche à suivre pour confirmer et terminer le changement de mot de passe.</p><p>En cas de difficulté, veuillez contacter l’administrateur du site.</p>';
$string['emailpasswordsent'] = '<p>Merci pour votre confirmation de changement de mot de passe.</p><p>Un message avec votre nouveau mot de passe a été envoyé à votre adresse <strong>{$a->email}</strong>.</p><p>Le nouveau mot de passe a été généré automatiquement. Vous pouvez <a href="{$a->link}">le modifier</a> pour le rendre plus facile à mémoriser.</p>';
$string['emailresetconfirmation'] = 'Bonjour {$a->firstname},

Une réinitialisation de mot de passe a été demandée pour votre compte utilisateur « {$a->username} » sur {$a->sitename}.

Pour confirmer cette demande et définir un nouveau mot de passe, veuillez visiter l’adresse ci-dessous :
<a href="{$a->link}">{$a->link}</a>

Ce lien est valable durant {$a->resetminutes} minutes à partir de la demande de réinitialisation.

Si cette demande de réinitialisation n’a pas été effectuée par vous-même, aucune action n’est nécessaire.

Si vous avez besoin d’aide, veuillez contacter l’administrateur du site,
{$a->admin}';
$string['emailresetconfirmationsubject'] = '{$a} : demande de réinitialisation de mot de passe';
$string['emailresetconfirmsent'] = 'Un courriel vous a été envoyé à l’adresse <b>{$a}</b>.<br />Il contient des instructions simple vous permettant de confirmer et d’effectuer le changement de votre mot de passe.
En cas de difficulté, veuillez contacter l’administrateur du site.';
$string['emailstop'] = 'Désactiver les notifications';
$string['emailtoprivatefiles'] = 'Il est aussi possible d’envoyer par courriel des fichiers directement vers votre zone de fichiers personnels. Il vous suffit de les joindre à un courriel et les envoyer à {$a}';
$string['emailtoprivatefilesdenied'] = 'L’administrateur de votre serveur a désactivé l’option d’envoyer des fichiers vers votre zone de fichiers personnels';
$string['emailvia'] = '{$a->name} (via {$a->siteshortname})';
$string['emojicategoryactivities'] = 'Activités';
$string['emojicategoryanimalsnature'] = 'Animaux & nature';
$string['emojicategoryflags'] = 'Drapeaux';
$string['emojicategoryfooddrink'] = 'Nourriture & boissons';
$string['emojicategoryobjects'] = 'Objets';
$string['emojicategorypeoplebody'] = 'Personnes et corps';
$string['emojicategoryrecent'] = 'Récents';
$string['emojicategorysmileysemotion'] = 'Smileys et émotion';
$string['emojicategorysymbols'] = 'Symboles';
$string['emojicategorytravelplaces'] = 'Voyages & lieux';
$string['emptycmids'] = 'IDs de module de cours vide';
$string['emptydragdropregion'] = 'région vide';
$string['emptysectionids'] = 'IDs de section vide';
$string['enable'] = 'Activer';
$string['encryptedcode'] = 'Code chiffré';
$string['enddate'] = 'Date de fin du cours';
$string['enddate_help'] = 'La date de fin ne restreint pas l’accès des étudiants au cours. Il détermine si le cours est affiché comme « Passé » dans Mes cours.';
$string['enddatewithtaskenabled'] = 'Date de fin du cours';
$string['enddatewithtaskenabled_help'] = 'La date à laquelle le cours est caché automatiquement pour les étudiants, qui ne peuvent alors plus y accéder.';
$string['english'] = 'Anglais';
$string['enrolmentmethods'] = 'Méthodes d’inscription';
$string['entercourse'] = 'Cliquer pour entrer dans le cours';
$string['enteremail'] = 'Tapez votre adresse de courriel';
$string['enteremailaddress'] = 'Tapez votre adresse de courriel afin qu’un nouveau mot de passe vous soit envoyé par courriel';
$string['enterusername'] = 'Tapez votre nom d’utilisateur';
$string['entries'] = 'Article';
$string['error'] = 'Erreur';
$string['errorcreatingactivity'] = 'Impossible de créer une instance de l’activité « {$a} »';
$string['errorfiletoobig'] = 'La taille du fichier dépasse la limite de {$a} octets';
$string['errornouploadrepo'] = 'Aucun dépôt n’est défini pour déposer des fichiers dans ce site';
$string['errorwhenconfirming'] = 'Votre compte n’a pas pu être confirmé en raison d’une erreur. Si vous avez cliqué sur un lien dans un courriel pour parvenir à cette page, assurez-vous que la ligne de ce message n’a pas été coupée. Il vous sera peut-être nécessaire de couper et coller pour reconstruire correctement le lien.';
$string['eventcommentcreated'] = 'Commentaire créé';
$string['eventcommentdeleted'] = 'Commentaire supprimé';
$string['eventcommentsviewed'] = 'Commentaires consultés';
$string['eventconfiglogcreated'] = 'Journal de configuration créé';
$string['eventcontentviewed'] = 'Contenu consulté';
$string['eventcoursebackupcreated'] = 'Sauvegarde de cours créée';
$string['eventcoursecategorycreated'] = 'Catégorie créée';
$string['eventcoursecategorydeleted'] = 'Catégorie supprimée';
$string['eventcoursecategoryupdated'] = 'Catégorie modifiée';
$string['eventcoursecategoryviewed'] = 'Catégorie consultée';
$string['eventcoursecontentdeleted'] = 'Contenu de cours supprimé';
$string['eventcoursecreated'] = 'Cours créé';
$string['eventcoursedeleted'] = 'Cours supprimé';
$string['eventcourseended'] = 'Cours terminé';
$string['eventcourseinformationviewed'] = 'Résumé de cours consulté';
$string['eventcoursemodulecreated'] = 'Module de cours créé';
$string['eventcoursemoduledeleted'] = 'Module de cours supprimé';
$string['eventcoursemoduleinstancelistviewed'] = 'Liste d’instances de module de cours consultée';
$string['eventcoursemoduleupdated'] = 'Module de cours modifié';
$string['eventcoursemoduleviewed'] = 'Module de cours consulté';
$string['eventcourseresetended'] = 'Réinitialisation de cours terminée';
$string['eventcourseresetstarted'] = 'Réinitialisation de cours commencée';
$string['eventcourserestored'] = 'Cours restauré';
$string['eventcoursesectioncreated'] = 'Section de cours créée';
$string['eventcoursesectiondeleted'] = 'Section de cours supprimée';
$string['eventcoursesectionupdated'] = 'Section de cours modifiée';
$string['eventcoursessearched'] = 'Cours recherchés';
$string['eventcoursestarted'] = 'Cours commencé';
$string['eventcourseupdated'] = 'Cours modifié';
$string['eventcourseuserreportviewed'] = 'Rapport de cours utilisateur consulté';
$string['eventcourseviewed'] = 'Cours consulté';
$string['eventdashboardreset'] = 'Réinitialisation du tableau de bord';
$string['eventdashboardsreset'] = 'Réinitialisation des tableaux de bord';
$string['eventdashboardviewed'] = 'Tableau de bord consulté';
$string['eventdatabasetextfieldcontentreplaced'] = 'Recherche et remplacement global dans la base de données';
$string['eventemailfailed'] = 'Envoi de courriel échoué';
$string['eventmycoursesviewed'] = 'Mes cours consulté';
$string['eventname'] = 'Nom de l’événement';
$string['eventrecentactivityviewed'] = 'Activités récentes consultées';
$string['eventsearchindexed'] = 'Données de recherche indéxées';
$string['eventsearchresultsviewed'] = 'Résultats de recherche consultés';
$string['eventsectionviewed'] = 'Section consultée';
$string['eventunknownlogged'] = 'Événement inconnu';
$string['eventurlblocked'] = 'L’URL a été bloqué';
$string['eventusercreated'] = 'Utilisateur créé';
$string['eventuserdeleted'] = 'Utilisateur supprimé';
$string['eventuserfeedbackgiven'] = 'Lien feedback cliqué';
$string['eventuserfeedbackremind'] = 'Lien rappeler plus tard cliqué';
$string['eventuserinfocategorycreated'] = 'Catégorie de champ de profil utilisateur créée';
$string['eventuserinfocategorydeleted'] = 'Catégorie de champ de profil utilisateur supprimée';
$string['eventuserinfocategoryupdated'] = 'Catégorie de champ de profil utilisateur modifiée';
$string['eventuserinfofieldcreated'] = 'Champ de profil utilisateur créé';
$string['eventuserinfofielddeleted'] = 'Champ de profil utilisateur supprimé';
$string['eventuserinfofieldupdated'] = 'Champ de profil utilisateur modifié';
$string['eventuserlistviewed'] = 'Liste d’utilisateurs consultée';
$string['eventuserloggedout'] = 'Utilisateur déconnecté';
$string['eventuserpasswordpolicyfailed'] = 'Mot de passe utilisateur non conforme à la politique des mots de passe';
$string['eventuserpasswordupdated'] = 'Mot de passe utilisateur modifié';
$string['eventuserprofileviewed'] = 'Profil utilisateur consulté';
$string['eventuserupdated'] = 'Utilisateur modifié';
$string['everybody'] = 'Tout le monde';
$string['executeat'] = 'Lancer à';
$string['existing'] = 'Existant';
$string['existingadmins'] = 'Administrateurs existants';
$string['existingcourse'] = 'Cours existant';
$string['existingcourseadding'] = 'Cours existant, en y ajoutant les données';
$string['existingcoursedeleting'] = 'Cours existant, en le supprimant d’abord';
$string['existingcreators'] = 'Créateurs de cours existants';
$string['existingstudents'] = 'Étudiants inscrits';
$string['existingteachers'] = 'Enseignants existants';
$string['expand'] = 'Déplier';
$string['expandall'] = 'Tout déplier';
$string['expandcategory'] = 'Déplier {$a}';
$string['explanation'] = 'Explication';
$string['explanationdigitalminor'] = 'Cette information est requise pour déterminer si vous avez l’âge de la majorité numérique. Cet âge est celui qu’une personne doit avoir pour pouvoir donner son consentement à l’accès et au stockage par un tiers des données personnelles la concernant.';
$string['extendperiod'] = 'Extension de la période d’inscription';
$string['extendsession'] = 'Étendre la durée de la session';
$string['failedloginattempts'] = '{$a->attempts} tentatives de connexion depuis votre dernière connexion';
$string['failedtaskbody'] = '<p>Bonjour {$a->firstname},</p>
<p>La tâche <b>{$a->taskname}</b> a échoué plusieurs fois et requiert votre attention.</p>
<p><a href="{$a->link}">Voir la tâche</a></p>';
$string['failedtaskcontexturlname'] = 'Rapport d’état';
$string['failedtasksubject'] = 'Tâche en échec : {$a}';
$string['favourites'] = 'Favoris';
$string['feedback'] = 'Feedback';
$string['file'] = 'Fichier';
$string['fileexists'] = 'Un fichier de nom {$a} existe déjà';
$string['filemissing'] = '{$a} n’existe pas';
$string['filereaderror'] = 'Impossible de lire le fichier « $a ». Veuillez vérifier qu’il s’agit bien d’un fichier, et non d’un dossier.';
$string['files'] = 'Fichiers';
$string['filesanduploads'] = 'Fichiers et dépôts';
$string['filesfolders'] = 'Fichiers/dossiers';
$string['fileuploadwithcontent'] = 'Lors du dépôt d’un fichier, le paramètre content ne doit pas être inclus';
$string['filloutallfields'] = 'Merci de remplir tous les champs de ce formulaire';
$string['filter'] = 'Filtre';
$string['filteroption'] = '{$a->criteria} : {$a->value}';
$string['filterrowlegend'] = 'Filtre {$a}';
$string['filters'] = 'Filtres';
$string['filtersetmatchdescription'] = 'Comment les filtres multiples doivent être combinés';
$string['filtertype'] = 'Type de filtre';
$string['findmorecourses'] = 'Rechercher d’autres cours…';
$string['first'] = 'Premier';
$string['firstaccess'] = 'Premier accès';
$string['firstname'] = 'Prénom';
$string['firstnamephonetic'] = 'Prénom – phonétique';
$string['firstpage'] = 'Première page';
$string['firstsiteaccess'] = 'Premier accès au site';
$string['firsttime'] = 'Première visite sur ce site ?';
$string['folder'] = 'Dossier';
$string['folderclosed'] = 'Dossier fermé';
$string['folderopened'] = 'Dossier ouvert';
$string['followingoptional'] = 'Les éléments suivants sont facultatifs';
$string['followingrequired'] = 'Les éléments suivants sont requis';
$string['for'] = 'Pour';
$string['force'] = 'Imposer';
$string['forcelanguage'] = 'Imposer la langue';
$string['forceno'] = 'Ne pas imposer';
$string['forcepasswordchange'] = 'Imposer le changement du mot de passe';
$string['forcepasswordchange_help'] = 'Si ce réglage est activé, l’utilisateur sera invité à changer son mot de passe lors de sa prochaine connexion.';
$string['forcepasswordchangecheckfull'] = 'Voulez-vous vraiment imposer un changement de mot de passe à {$a} ?';
$string['forcepasswordchangenot'] = 'Impossible d’imposer un changement de mot de passe à {$a}';
$string['forcepasswordchangenotice'] = 'Vous devez changer votre mot de passe pour continuer.';
$string['forcepasswordresetfailurenotice'] = 'Votre mot mot de passe actuel n’est plus conforme à la politique des mots de passe. Veuillez contacter l’administrateur du site pour plus d’informations.
  {$a}';
$string['forcepasswordresetnotice'] = 'Votre mot mot de passe actuel n’est plus conforme à la politique des mots de passe. Vous devez le réinitialiser pour vous connecter.
  {$a}';
$string['forcetheme'] = 'Imposer le thème';
$string['forgotaccount'] = 'Mot de passe perdu ?';
$string['forgotten'] = 'Nom d’utilisateur ou mot de passe oublié ?';
$string['forgottenduplicate'] = 'Cette adresse de courriel est utilisée dans plusieurs comptes. Veuillez indiquer le nom d’utilisateur en lieu et place';
$string['forgotteninvalidurl'] = 'URL de récupération de mot de passe non valable';
$string['format'] = 'Format';
$string['format_help'] = 'Le format de cours détermine comment est affichée la page de cours.

* Activité unique - Le cours ne contient qu’une seule activité ou ressource.
* Informel – Le cours est construit autour d’un forum principal sur la page de cours. D’autres activités et ressources peuvent être ajouté à l’aide du bloc Activités sociales.
* Sections personnalisées – Le cours est subdivisé en sections personnalisables.
* Sections hebdomadaires – Le cours est subdivisé en sections correspondant chacune à une semaine, à partir de la date de début du cours.';
$string['formathtml'] = 'Format HTML';
$string['formatmarkdown'] = 'Format Markdown';
$string['formatplain'] = 'Format texte';
$string['formattext'] = 'Format Moodle';
$string['forumpreferences'] = 'Préférences de forum';
$string['framesetinfo'] = 'Ce jeu de cadres contient :';
$string['from'] = 'De';
$string['fromdate'] = 'De';
$string['fromsender'] = 'De';
$string['frontpagecategorycombo'] = 'Liste combinée';
$string['frontpagecategorynames'] = 'Liste des catégories de cours';
$string['frontpagecourselist'] = 'Liste des cours';
$string['frontpagecoursesearch'] = 'Zone de recherche de cours';
$string['frontpagedescription'] = 'Résumé sur la page d’accueil';
$string['frontpagedescriptionhelp'] = 'Ce résumé sera affiché sur la page d’accueil dans le bloc résumé du cours/du site.';
$string['frontpageenrolledcourselist'] = 'Cours de l’utilisateur';
$string['frontpageformat'] = 'Format de la page d’accueil';
$string['frontpageformatloggedin'] = 'Format une fois connecté';
$string['frontpagenews'] = 'Annonces';
$string['frontpagesettings'] = 'Réglages page d’accueil';
$string['fulllistofcourses'] = 'Tous les cours';
$string['fullname'] = 'Nom complet';
$string['fullnamecourse'] = 'Nom complet du cours';
$string['fullnamecourse_help'] = 'Le nom affiché dans Mes cours et sur la page d’accueil dans la liste des cours disponibles.';
$string['fullnamedisplay'] = '{$a->firstname} {$a->lastname}';
$string['fullnameuser'] = 'Nom complet de l’utilisateur';
$string['fullprofile'] = 'Profil complet';
$string['fullsitename'] = 'Nom complet du site';
$string['functiondisabled'] = 'Cette fonction est actuellement désactivée';
$string['general'] = 'Général';
$string['geolocation'] = 'latitude - longitude';
$string['gettheselogs'] = 'Consulter ces journaux';
$string['go'] = 'Valider';
$string['gobacktosite'] = 'Retour au site';
$string['gpl'] = 'Copyright (C) 1999 et années ultérieures, Martin Dougiamas (https://moodle.com/)

Ce programme est libre, vous pouvez le redistribuer et/ou le modifier selon les termes de la Licence Publique Générale GNU publiée par la Free Software Foundation (version 2 ou bien toute autre version ultérieure choisie par vous).

Ce programme est distribué car potentiellement utile, mais SANS AUCUNE GARANTIE : sans même la garantie implicite de COMMERCIALISABILITÉ ni d’ADÉQUATION À UN OBJECTIF PARTICULIER.

Pour plus d’infos, reportez-vous à la page d’information sur la Licence Moodle : https://moodledev.io/general/license';
$string['gpl3'] = 'Copyright (C) 1999 et années ultérieures, Martin Dougiamas (https://moodle.com/)

Ce programme est un logiciel libre ; vous pouvez le redistribuer ou le modifier suivant les termes de la GNU General Public License telle que publiée par la Free Software Foundation : soit la version 3 de cette licence, soit (à votre gré) toute version ultérieure.

Ce programme est distribué dans l’espoir qu’il vous sera utile, mais SANS AUCUNE GARANTIE : sans même la garantie implicite de COMMERCIALISABILITÉ ni d’ADÉQUATION À UN OBJECTIF PARTICULIER.

Pour plus d’infos, reportez-vous à la page d’information sur la Licence Moodle : https://moodledev.io/general/license';
$string['gpllicense'] = 'Licence GPL';
$string['gradenoun'] = 'Note';
$string['grades'] = 'Notes';
$string['gradeverb'] = 'Évaluer';
$string['gravatarenabled'] = '<a href="https://www.gravatar.com/"> Gravatar</a> a été activé sur ce site. Si vous ne déposez pas d’image de profil, Moodle essaiera d’afficher pour vous un avatar à partir de Gravatar.';
$string['group'] = 'Groupe';
$string['groupadd'] = 'Ajouter un nouveau groupe';
$string['groupaddusers'] = 'Ajouter les utilisateurs sélectionnés au groupe';
$string['groupfor'] = 'pour le groupe';
$string['groupinfo'] = 'Information sur le groupe sélectionné';
$string['groupinfoedit'] = 'Modifier les réglages du groupe';
$string['groupinfomembers'] = 'Information sur les membres sélectionnés';
$string['groupinfopeople'] = 'Information sur les personnes sélectionnées';
$string['groupmembers'] = 'Membres du groupe';
$string['groupmemberssee'] = 'Afficher les membres du groupe';
$string['groupmembersselected'] = 'Membres du groupe sélectionné';
$string['groupmode'] = 'Type des groupes';
$string['groupmodeforce'] = 'Imposer le type des groupes';
$string['groupmy'] = 'Mon groupe';
$string['groupnonmembers'] = 'Personnes n’appartenant à aucun groupe';
$string['groupnotamember'] = 'Désolé, vous n’êtes pas membre de ce groupe';
$string['grouprandomassign'] = 'Inscrire aléatoirement tout le monde aux groupes';
$string['groupremove'] = 'Retirer le groupe sélectionné';
$string['groupremovemembers'] = 'Retirer du groupe les membres sélectionnés';
$string['groups'] = 'Groupes';
$string['groupsnone'] = 'Aucun groupe';
$string['groupsseparate'] = 'Groupes séparés';
$string['groupsvisible'] = 'Groupes visibles';
$string['guest'] = 'Visiteur anonyme';
$string['guestdescription'] = 'Les visiteurs anonymes ont très peu de privilèges et ne peuvent normalement saisir de texte à aucun endroit.';
$string['guestskey'] = 'Autoriser l’accès anonyme avec clef';
$string['guestsno'] = 'Ne pas autoriser l’accès anonyme';
$string['guestsnotallowed'] = 'Désolé, le cours « {$a} » n’autorise pas l’accès anonyme.';
$string['guestsyes'] = 'Autoriser l’accès anonyme sans clef';
$string['guestuser'] = 'Visiteur anonyme';
$string['guestuserinfo'] = 'Cet utilisateur spécial a accès en lecture seule à certains cours.';
$string['help'] = 'Aide';
$string['helpprefix2'] = 'Aide sur {$a}';
$string['helpwiththis'] = 'Aide sur ceci';
$string['hiddenassign'] = 'Attribution cachée';
$string['hiddenfromstudents'] = 'Caché pour les étudiants';
$string['hiddenoncoursepage'] = 'Disponible, mais pas affiché sur la page de cours';
$string['hiddensections'] = 'Sections cachées';
$string['hiddensections_help'] = 'Les sections cachées peuvent être affichées sur la page de cours comme « non disponibles » ou être complètement invisibles.';
$string['hiddensectionscollapsed'] = 'Sections cachées affichées comme non disponibles';
$string['hiddensectionsinvisible'] = 'Sections cachées invisibles';
$string['hiddenwithbrackets'] = '(caché)';
$string['hide'] = 'Cacher';
$string['hideadvancedsettings'] = 'Cacher les réglages avancés';
$string['hidechartdata'] = 'Cacher les données du graphique';
$string['hidefromstudents'] = 'Cacher sur la page du cours';
$string['hideoncoursepage'] = 'Rendre disponible, mais invisible sur la page du cours';
$string['hidepopoverwindow'] = 'Cacher la fenêtre surgissante';
$string['hidesection'] = 'Cacher section {$a}';
$string['hidesettings'] = 'Cacher les réglages';
$string['hideshowblocks'] = 'Cacher ou afficher les blocs';
$string['highlight'] = 'Marquer la section';
$string['highlighted'] = 'Marqué';
$string['highlightoff'] = 'Retirer le marquage';
$string['hits'] = 'Requêtes';
$string['hitsoncourse'] = 'Nombre de requêtes de {$a->username} sur {$a->coursename}';
$string['hitsoncoursetoday'] = 'Nombre de requêtes de {$a->username} sur {$a->coursename} pour aujourd’hui';
$string['home'] = 'Accueil';
$string['homeheader'] = 'Menu accueil';
$string['hour'] = 'heure';
$string['hours'] = 'heures';
$string['howtomakethemes'] = 'Comment créer de nouveaux thèmes';
$string['htmleditor'] = 'Utiliser l’éditeur HTML';
$string['htmleditoravailable'] = 'L’éditeur HTML est disponible';
$string['htmleditordisabled'] = 'Vous avez désactivé l’utilisation de l’éditeur HTML dans votre profil utilisateur';
$string['htmleditordisabledadmin'] = 'L’administrateur a désactivé l’utilisation de l’éditeur HTML sur ce site';
$string['htmleditordisabledbrowser'] = 'L’éditeur HTML n’est pas disponible car vous n’utilisez pas un navigateur compatible';
$string['htmlfilesonly'] = 'Fichiers HTML seulement';
$string['htmlformat'] = 'Format HTML';
$string['icon'] = 'Icône';
$string['idnumber'] = 'Numéro d’identification';
$string['idnumbercourse'] = 'N° d’identification du cours';
$string['idnumbercourse_help'] = 'Uniquement utilisé pour connecter le cours avec des systèmes externes. À laisser vide s’il n’existe pas de numéro d’identification officiel.';
$string['idnumbercoursecategory'] = 'Numéro d’identifiant de catégorie';
$string['idnumbercoursecategory_help'] = 'L’identifiant de catégorie de cours n’est utilisé que lors de la vérification de correspondance avec des systèmes externes et n’est affiché nulle part sur le site. Si la catégorie est codée de manière officielle, celui-ce devrait être renseigné ici. Sinon, le champ peut être laissé vide.';
$string['idnumbergroup'] = 'Identifiant de groupe';
$string['idnumbergroup_help'] = 'L’identifiant d’un groupe n’est utilisé que lors de l’utilisation de systèmes externes et n’est jamais affiché. On renseigne ce champ si le groupe a un code officiel. Sinon, le champ peut être laissé vide.';
$string['idnumbergrouping'] = 'Identifiant de groupement';
$string['idnumbergrouping_help'] = 'L’identifiant d’un groupement n’est utilisé que lors de l’utilisation de systèmes externes et n’est jamais affiché. On renseigne ce champ si le groupement a un code officiel. Sinon, le champ peut être laissé vide.';
$string['idnumbermod'] = 'Numéro d’identification';
$string['idnumbermod_help'] = 'En définissant un numéro d’identification (ID number), vous fournissez un moyen d’identifier une activité ou une ressource dans le but d’effectuer des calculs de notes ou pour des rapports. Dans le cas contraire, le numéro d’identification peut être laissé vide.

Ce numéro d’identification peut aussi être renseigné dans le carnet de notes. Il ne peut cependant être modifié que sur la page de modification de l’activité.';
$string['idnumbertaken'] = 'Ce n° d’identification est déjà utilisé';
$string['imagealt'] = 'Description de l’image';
$string['import'] = 'Importation';
$string['importdata'] = 'Importer les données d’un cours';
$string['importdataexported'] = 'Les données du cours d’origine ont été exportées correctement.<br />Voulez-vous les importer dans le cours de destination ?';
$string['importdatafinished'] = 'Importation terminée ! Vous pouvez vous rendre sur votre cours';
$string['importdatafrom'] = 'Rechercher un cours à partir duquel importer des données :';
$string['importinfo'] = 'Importer des éléments d’autres cours, comme les activités, blocs ou événements du calendrier. Aucune donnée utilisateur ne sera importée.';
$string['inactive'] = 'Inactif';
$string['include'] = 'Inclure';
$string['includeallusers'] = 'Inclure tous les utilisateurs';
$string['includecoursefiles'] = 'Inclure les fichiers du cours';
$string['includecourseusers'] = 'Inclure les utilisateurs du cours';
$string['included'] = 'Inclus';
$string['includelogentries'] = 'Inclure les journaux';
$string['includemodules'] = 'Inclure les modules';
$string['includemoduleuserdata'] = 'Inclure les données utilisateur des modules';
$string['includeneededusers'] = 'Inclure les utilisateurs s’il y a lieu';
$string['includenoneusers'] = 'Ne pas inclure les utilisateurs';
$string['includeroleassignments'] = 'Inclure les attributions de rôles';
$string['includesitefiles'] = 'Inclure les fichiers du site utilisés dans ce cours';
$string['includesubcategories'] = 'Inclure les sous-catégories';
$string['includeuserfiles'] = 'Inclure les fichiers des utilisateurs';
$string['increasesections'] = 'Augmenter le nombre des sections';
$string['indicator:accessesafterend'] = 'Accès au cours après la date de fin';
$string['indicator:accessesafterend_help'] = 'Cet indicateur montre si l’étudiant a accédé au cours après la date de fin du cours.';
$string['indicator:accessesbeforestart'] = 'Accès au cours avant la date de début';
$string['indicator:accessesbeforestart_help'] = 'Cet indicateur montre si l’étudiant a accédé au cours avant la date de début du cours.';
$string['indicator:activitiesdue'] = 'Activités à effectuer';
$string['indicator:activitiesdue_help'] = 'L’utilisateur a des activités à effectuer';
$string['indicator:anycourseaccess'] = 'Tout accès au cours';
$string['indicator:anycourseaccess_help'] = 'Cet indicateur reflète l’accès à n’importe quel cours auquel l’utilisateur est inscrit.';
$string['indicator:anywrite'] = 'Actions d’écriture';
$string['indicator:anywrite_help'] = 'Cet indicateur représente toute action d’écriture (remise) effectuée par l’étudiant.';
$string['indicator:anywriteincourse'] = 'Toute action d’écriture dans le cours';
$string['indicator:anywriteincourse_help'] = 'Cet indicateur représente toute action d’écriture (remise) effectuée par l’étudiant dans toute activité de cours.';
$string['indicator:completeduserprofile'] = 'Profil utilisateur complété';
$string['indicator:completeduserprofile_help'] = 'Cet indicateur montre que l’étudiant a complété son profil utilisateur.';
$string['indicator:completeduserprofiledef'] = 'Le profil utilisateur est complet';
$string['indicator:completeduserprofiledef_help'] = 'Les politiques du site ont été acceptées et l’utilisateur a rempli les champs suivants : Institution, Département, Adresse, Ville, Pays, URL.';
$string['indicator:completionenabled'] = 'Suivi d’achèvement activé';
$string['indicator:completionenabled_help'] = 'Cet indicateur montre que le suivi d’achèvement a été activé dans ce cours.';
$string['indicator:nostudent'] = 'Inscriptions des étudiants';
$string['indicator:nostudent_help'] = 'Cet indicateur montre la disponibilité d’étudiants dans le cours.';
$string['indicator:noteacher'] = 'Disponibilité d’enseignants';
$string['indicator:noteacher_help'] = 'Cet indicateur montre la disponibilité d’enseignants dans le cours.';
$string['indicator:potentialcognitive'] = 'Niveau cognitif potentiel du cours';
$string['indicator:potentialcognitive_help'] = 'Cet indicateur est basé sur la profondeur cognitive que pourrait atteindre un étudiant qui participe aux activités du cours.';
$string['indicator:potentialcognitivedef'] = 'Niveau cognitif potentiel du cours';
$string['indicator:potentialcognitivedef_help'] = 'Le degré de profondeur d’engagement cognitif offert par le cours, par exemple la remise de travaux en vue de feedback, l’opportunité de consulter le travail d’autres participants, ou l’opportunité de réviser un travail et d’en remettre une nouvelle version.';
$string['indicator:potentialcognitivedef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:potentialsocial'] = 'Interaction sociale potentielle du cours';
$string['indicator:potentialsocial_help'] = 'Cet indicateur se base sur l’interaction sociale que pourrait atteindre un étudiant qui participe aux activités du cours.';
$string['indicator:potentialsocialdef'] = 'Interaction sociale potentielle du cours';
$string['indicator:potentialsocialdef_help'] = 'Le degré de largeur d’engagement social offert par le cours, d’interaction avec les autres participants et la communauté de pratique en dehors de la classe.';
$string['indicator:potentialsocialdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['indicator:readactions'] = 'Actions de lectures';
$string['indicator:readactions_help'] = 'Cet indicateur représente le nombre d’actions de lecture (affichage) effectuées par l’étudiant.';
$string['indicator:userforumstracking'] = 'L’utilisateur suit des forums';
$string['indicator:userforumstracking_help'] = 'Cet indicateur montre si l’étudiant a activé le suivi des messages des forums ou non.';
$string['info'] = 'Information';
$string['inprogress'] = 'En cours';
$string['insertcontentbefore'] = 'Insérer du contenu avant « {$a->activityname} »';
$string['insertcontentsection'] = 'Insérer du contenu dans la section « {$a->sectionname} »';
$string['insertresourceoractivitybefore'] = 'Insérer une activité ou une ressource avant « {$a->activityname} »';
$string['institution'] = 'Institution';
$string['instudentview'] = 'en affichage « étudiant »';
$string['interests'] = 'Centres d’intérêt';
$string['interestslist'] = 'Liste des centres d’intérêt';
$string['interestslist_help'] = 'Veuillez saisir vos centres d’intérêt. Vos centres d’intérêt sont affichés sur votre page de profil comme des tags.';
$string['invalidemail'] = 'Adresse de courriel incorrecte';
$string['invalidlogin'] = 'La connexion a échoué, veuillez réessayer';
$string['invalidtaskclassname'] = 'Classe de tâche {$a} non valide';
$string['invalidtaskid'] = 'ID de tâche non valide';
$string['invalidusername'] = 'Le nom d’utilisateur ne peut comporter que des caractères alphanumériques bas de casse (lettres et chiffres), les caractères souligné (_), tiret (-), point (.) ou arobase (@).';
$string['invalidusernameupload'] = 'Nom d’utilisateur non valide';
$string['ip_address'] = 'Adresse IP';
$string['jump'] = 'Passer';
$string['jumpto'] = 'Aller à…';
$string['keep'] = 'Conserver';
$string['labelvalue'] = '{$a->label} : {$a->value}';
$string['langltr'] = 'La langue est écrite de gauche à droite';
$string['langrtl'] = 'La langue est écrite de droite à gauche';
$string['language'] = 'Langue';
$string['languagegood'] = 'Le paquetage de langue est à jour.';
$string['languageselector'] = 'Sélecteur de langue';
$string['last'] = 'Dernier';
$string['lastaccess'] = 'Dernier accès';
$string['lastcourseaccess'] = 'Dernier accès au cours';
$string['lastedited'] = 'Modifié le';
$string['lastip'] = 'Dernière adresse IP';
$string['lastlogin'] = 'Dernière connexion';
$string['lastmodified'] = 'Modifié le';
$string['lastname'] = 'Nom de famille';
$string['lastnamephonetic'] = 'Nom de famille – phonétique';
$string['lastpage'] = 'Dernière page';
$string['lastsiteaccess'] = 'Dernier accès au site';
$string['lastyear'] = 'Année passée';
$string['latestlanguagepack'] = 'Chercher les derniers paquetages de langue sur moodle.org';
$string['layouttable'] = 'Tableau pour mise en page';
$string['leavetokeep'] = 'Laisser vide pour ne pas changer le mot de passe';
$string['legacylogginginuse'] = 'L’écriture des journaux obsolètes est activée sur ce site. Ceci n’est désormais plus pris en charge. Veuillez modifier les réglages pour enregistrer les journaux d’une manière prise en charge actuellement, par exemple « standard » ou « externe ».';
$string['legacythemeinuse'] = 'Ce site vous est affiché en mode dégradé, car votre navigateur est trop ancien,';
$string['license'] = 'Licence';
$string['licenses'] = 'Licences';
$string['liketologin'] = 'Voulez-vous vous connecter avec un compte utilisateur ?';
$string['list'] = 'Liste';
$string['listfiles'] = 'Liste des fichiers dans {$a}';
$string['listofallpeople'] = 'Liste de tous les utilisateurs';
$string['listofcourses'] = 'Liste des cours';
$string['loading'] = 'Chargement';
$string['loadinghelp'] = 'Chargement…';
$string['local'] = 'Local';
$string['localplugins'] = 'Plugins locaux';
$string['localpluginsmanage'] = 'Gestion des plugins locaux';
$string['location'] = 'Emplacement';
$string['locktimeout'] = 'L’opération s’est interrompue en raison d’un verrou.';
$string['log_excel_date_format'] = 'yyyy mmmm d h:mm';
$string['loggedinas'] = 'Connecté sous le nom « {$a} »';
$string['loggedinasguest'] = 'Vous êtes connecté anonymement';
$string['loggedinnot'] = 'Non connecté.';
$string['login'] = 'Connexion';
$string['login_failure_logs'] = 'Journal des tentatives de connexion';
$string['loginactivity'] = 'Informations de connexion';
$string['loginagain'] = 'Se connecter à nouveau';
$string['loginalready'] = 'Vous êtes déjà connecté';
$string['loginas'] = 'Se connecter sous ce nom';
$string['loginaspasswordexplain'] = '<p>Pour utiliser cette fonction, vous devez saisir un mot de passe spécial « connecté en tant que ».<br />Si vous ne connaissez pas ce mot de passe, prenez contact avec l’administrateur de ce moodle.</p>';
$string['loginguest'] = 'Accéder en tant qu’anonyme';
$string['loginsite'] = 'Se connecter sur le site';
$string['loginsteps'] = 'Pour un accès complet à ce site, veuillez créer un compte utilisateur.';
$string['loginstepsnone'] = '<p>Bonjour !</p><p>Pour un accès complet aux cours vous devez vous créer un compte.</p><p>Pour cela, vous avez seulement besoin de choisir un nom d’utilisateur et un mot de passe à entrer dans le formulaire de cette page.</p><p>Si ce nom d’utilisateur est déjà utilisé, il vous sera demandé d’en choisir un autre.</p>';
$string['loginto'] = 'Connexion à {$a}';
$string['logoof'] = 'Logo de {$a}';
$string['logout'] = 'Déconnexion';
$string['logoutconfirm'] = 'Voulez-vous vraiment vous déconnecter ?';
$string['logs'] = 'Journaux';
$string['logtoomanycourses'] = '[ <a href="{$a->url}">suite</a> ]';
$string['logtoomanyusers'] = '[ <a href="{$a->url}">suite</a> ]';
$string['lookback'] = 'Remonter';
$string['mailadmins'] = 'Informer les administrateurs';
$string['mailstudents'] = 'Informer les étudiants';
$string['mailteachers'] = 'Informer les enseignants';
$string['maincoursepage'] = 'Page d’accueil du cours';
$string['makeafolder'] = 'Créer un dossier';
$string['makeavailable'] = 'Rendre disponible';
$string['makeavailablecmtitle'] = 'Rendre disponible l’activité';
$string['makeeditable'] = 'Si le serveur Web (par exemple Apache) possède un accès en écriture au fichier « {$a} », alors il sera possible de modifier ce fichier directement depuis cette page';
$string['makethismyhome'] = 'Faire de cette page ma page d’accueil';
$string['makeunavailable'] = 'Rendre non disponible';
$string['manageblocks'] = 'Blocs';
$string['managecategories'] = 'Gérer les catégories de cours';
$string['managecategorythis'] = 'Gérer cette catégorie';
$string['managecombined'] = 'Gérer les catégories de cours et les cours';
$string['managecontentbanktypes'] = 'Gérer les types de contenus';
$string['managecourses'] = 'Gestion des cours';
$string['managedatabase'] = 'Base de données';
$string['managedataformats'] = 'Gérer les formats de données';
$string['manageeditorfiles'] = 'Gérer les fichiers utilisés par l’éditeur';
$string['managefilters'] = 'Filtres';
$string['managemodules'] = 'Modules';
$string['manageroles'] = 'Rôles et permissions';
$string['markallread'] = 'Tout marquer comme lu';
$string['markedthistopic'] = 'Cette section est marquée comme section actuelle';
$string['markthistopic'] = 'Marquer cette section';
$string['match'] = 'Correspondance';
$string['matchingsearchandrole'] = 'Correspondant à « {$a->search} » et {$a->role}';
$string['matchofthefollowing'] = 'un des éléments suivants :';
$string['maxareabytesreached'] = 'Le fichier (ou la taille totale de plusieurs fichiers) dépasse l’espace disponible dans cette zone.';
$string['maxfilesize'] = 'Taille maximale des nouveaux fichiers : {$a}';
$string['maxfilesreached'] = 'Vous pouvez joindre un maximum de {$a} fichier(s) à cet élément';
$string['maximumchars'] = '{$a} caractères maximum';
$string['maximumgrade'] = 'Note maximale';
$string['maximumgradex'] = 'Note maximale : {$a}';
$string['maximumshort'] = 'Max';
$string['maximumupload'] = 'Taille maximale des fichiers déposés';
$string['maximumupload_help'] = 'La taille maximale des fichiers pouvant être déposés dans le cours par les étudiants. Il est en outre possible de diminuer cette taille pour chacune des activités.';
$string['maxlengthreached'] = 'Le nombre maximum de caractères de {$a} a été atteint.';
$string['maxnumberweeks'] = 'Nombre maximum de sections';
$string['maxnumberweeks_desc'] = 'La valeur maximum du nombre de sections apparaissant dans le menu déroulant (n’est valable que pour certains formats de cours).';
$string['maxnumcoursesincombo'] = 'Parcourir <a href="{$a->link}">{$a->numberofcourses} cours</a>.';
$string['maxsectionslimit'] = 'Impossible de créer une nouvelle section, car cela ferait dépasser le nombre maximum de sections permises pour ce cours ({$a}).';
$string['maxsize'] = 'Taille maximale : {$a}';
$string['maxsizeandareasize'] = 'Taille maximale pour les nouveaux fichiers : {$a->size}, limite globale : {$a->areasize}';
$string['maxsizeandattachments'] = 'Taille maximale des fichiers : {$a->size} ; nombre maximal de fichiers : {$a->attachments}';
$string['maxsizeandattachmentsandareasize'] = 'Taille maximale des fichiers : {$a->size} ; nombre maximal de fichiers : {$a->attachments} ; limite globale : {$a->areasize}';
$string['memberincourse'] = 'Personnes dans le cours';
$string['menu'] = 'Menu';
$string['message'] = 'Message personnel';
$string['messagebody'] = 'Texte du message';
$string['messagedselectedusers'] = 'Le message a été envoyé aux utilisateurs sélectionnés et la liste des destinataires réinitialisée.';
$string['messagedselectedusersfailed'] = 'Une erreur est survenue lors de l’envoi du message aux utilisateurs sélectionnés. Certains d’entre eux ont peut-être reçu le message.';
$string['messageprovider:asyncbackupnotification'] = 'Notifications de sauvegardes/restaurations asynchrones';
$string['messageprovider:availableupdate'] = 'Notifications de mises à jour disponibles';
$string['messageprovider:backup'] = 'Notifications de sauvegarde';
$string['messageprovider:badgecreatornotice'] = 'Notifications au créateur du badge';
$string['messageprovider:badgerecipientnotice'] = 'Notifications au détenteur du badge';
$string['messageprovider:competencyplancomment'] = 'Commentaire fait sur un plan de formation';
$string['messageprovider:competencyusercompcomment'] = 'Commentaire fait sur une compétence';
$string['messageprovider:coursecompleted'] = 'Cours terminé';
$string['messageprovider:coursecontentupdated'] = 'Modifications de contenu de cours';
$string['messageprovider:courserequestapproved'] = 'Notification de demande d’approbation de création de cours';
$string['messageprovider:courserequested'] = 'Notification de demande de création de cours';
$string['messageprovider:courserequestrejected'] = 'Notification de rejet de création de cours';
$string['messageprovider:enrolcoursewelcomemessage'] = 'Message de bienvenue pour les nouvelles inscriptions';
$string['messageprovider:errors'] = 'Importantes erreurs avec le site';
$string['messageprovider:errors_help'] = 'Ces erreurs sont graves et doivent être annoncées à un administrateur.';
$string['messageprovider:failedtaskmaxdelay'] = 'La tâche a atteint son délai d’échec maximal';
$string['messageprovider:gradenotifications'] = 'Évaluer les notifications';
$string['messageprovider:infected'] = 'Notifications des échecs d’antivirus.';
$string['messageprovider:insights'] = 'Indications générées par les modèles de prédiction';
$string['messageprovider:instantmessage'] = 'Messages personnels entre utilisateurs';
$string['messageprovider:instantmessage_help'] = 'Cette section permet de configurer ce qui se passe avec les messages personnels qui vous sont envoyés par d’autres utilisateurs de ce site.';
$string['messageprovider:messagecontactrequests'] = 'Notification des demandes de contact de messagerie';
$string['messageprovider:newlogin'] = 'Notifications de nouvelle connexion';
$string['messageprovider:notices'] = 'Avertissement de problèmes mineurs';
$string['messageprovider:notices_help'] = 'Ces informations pourraient être intéressantes pour un administrateur.';
$string['messageprovider:reportbuilderschedule'] = 'Programmation de création de rapports personnalisés';
$string['messageselect'] = 'Sélectionner cet utilisateur comme destinataire';
$string['messageselectadd'] = 'Envoyer un message';
$string['middlename'] = 'Second prénom';
$string['migratinggrades'] = 'Migration des notes';
$string['min'] = 'min';
$string['mins'] = 'min';
$string['minute'] = 'minute';
$string['minutes'] = 'minutes';
$string['miscellaneous'] = 'Divers';
$string['missingcategory'] = 'Veuillez choisir une catégorie';
$string['missingdescription'] = 'La description ne peut pas être vide';
$string['missingemail'] = 'L’adresse de courriel ne peut pas être vide';
$string['missingfirstname'] = 'Le prénom ne peut pas être vide';
$string['missingfromdisk'] = 'absent du disque dur';
$string['missingfullname'] = 'Le nom complet ne peut pas être vide';
$string['missinglastname'] = 'Le nom de famille ne peut pas être vide';
$string['missingname'] = 'Le nom ne peut pas être vide';
$string['missingnewpassword'] = 'Le nouveau mot de passe ne peut pas être vide';
$string['missingpassword'] = 'Le mot de passe ne peut pas être vide';
$string['missingrecaptchachallengefield'] = 'Échec du reCAPTCHA, veuillez essayer à nouveau.';
$string['missingreqreason'] = 'Veuillez renseigner la raison';
$string['missingshortname'] = 'Le nom abrégé ne peut pas être vide';
$string['missingshortsitename'] = 'Le nom abrégé du site ne peut pas être vide';
$string['missingsitedescription'] = 'La description du site ne peut pas être vide';
$string['missingsitename'] = 'Le nom du site ne peut pas être vide';
$string['missingstrings'] = 'Chaînes non traduites';
$string['missingstudent'] = 'Vous devez choisir un étudiant';
$string['missingsummary'] = 'Résumé non renseigné';
$string['missingteacher'] = 'Vous devez choisir un enseignant';
$string['missingurl'] = 'L’URL ne peut pas être vide';
$string['missingusername'] = 'Le nom d’utilisateur ne peut pas être vide';
$string['moddoesnotsupporttype'] = 'Le module {$a->modname} ne permet pas le dépôt de fichiers de type {$a->type}';
$string['modhide'] = 'Cacher';
$string['modified'] = 'Modifié';
$string['modshow'] = 'Afficher';
$string['modshowcmtitle'] = 'Afficher l’activité';
$string['moduleintro'] = 'Description';
$string['modulesetup'] = 'Installation des tables des modules';
$string['modulesuccess'] = 'Les tables du module {$a} ont été installées correctement';
$string['modulesused'] = 'Modules utilisés';
$string['modvisible'] = 'Disponibilité';
$string['modvisible_help'] = '* Afficher sur la page du cours : disponible pour les étudiants (éventuellement sujette à des restrictions d’accès définies par l’enseignant).
* Cacher sur la page du cours : non disponible pour les étudiants.';
$string['modvisiblehiddensection'] = 'Disponibilité';
$string['modvisiblehiddensection_help'] = '* Cacher sur la page du cours : non disponible pour les étudiants.
* Rendre disponible, mais invisible sur la page du cours : disponible pour les étudiants si un lien vers l’activité est fourni. L’activité reste visible dans le carnet de notes et les autres rapports.';
$string['modvisiblewithstealth'] = 'Disponibilité';
$string['modvisiblewithstealth_help'] = '* Afficher sur la page du cours : disponible pour les étudiants (éventuellement sujette à des restrictions d’accès définies par l’enseignant).
* Cacher sur la page du cours : non disponible pour les étudiants.
* Rendre disponible, mais invisible sur la page du cours : disponible pour les étudiants si un lien vers l’activité est fourni. L’activité reste visible dans le carnet de notes et les autres rapports.';
$string['month'] = 'mois';
$string['months'] = 'mois';
$string['moodledocs'] = 'Moodle Docs';
$string['moodledocslink'] = 'Documentation pour cette page';
$string['moodlelogo'] = 'Logo Moodle';
$string['moodlenet:cannotconnecttoserver'] = 'Impossible de se connecter au serveur MoodleNet';
$string['moodlenet:columnname'] = 'Nom';
$string['moodlenet:columnsenddate'] = 'Envoyer la date';
$string['moodlenet:columnsendstatus'] = 'Envoyer le statut';
$string['moodlenet:columntype'] = 'Type';
$string['moodlenet:configoauthservice'] = 'Choisir un service MoodleNet OAuth 2 pour activer le partage vers ce site MoodleNet. Si le service n’existe pas encore, vous devez <a href="{$a}">le créer</a>.';
$string['moodlenet:deletedactivity'] = 'Activité supprimée';
$string['moodlenet:deletedcourse'] = 'Cours supprimé';
$string['moodlenet:eventresourceexported'] = 'Ressource exportée';
$string['moodlenet:gotomoodlenet'] = 'Aller vers les brouillons MoodleNet';
$string['moodlenet:issuerisnotauthorized'] = 'L’émetteur MoodleNet n’est pas autorisé';
$string['moodlenet:issuerisnotenabled'] = 'L’émetteur MoodleNet n’est pas activé';
$string['moodlenet:issuerisnotset'] = 'L’émetteur MoodleNet n’est pas réglé dans l’administration du site';
$string['moodlenet:nosharedresources'] = 'Il n’y a pour l’instant pas de ressource partagée à afficher.';
$string['moodlenet:outboundsettings'] = 'Réglage MoodleNet externe';
$string['moodlenet:packagingandsending'] = 'Préparation de votre fichier et envoi vers MoodleNet…';
$string['moodlenet:sharefailtext'] = 'Une erreur est survenue lors du partage de votre contenu vers MoodleNet.<br />Veuillez réessayer plus tard.';
$string['moodlenet:sharefailtextwithsitesupport'] = 'Une erreur est survenue lors du partage de votre contenu vers MoodleNet.<br />Veuillez réessayer plus tard ou <a href="{$a}">contacter l’assistance du site</a>.';
$string['moodlenet:sharefailtitle'] = 'Quelque chose s’est mal passé';
$string['moodlenet:sharefilesizelimitexceeded'] = 'La taille de la ressource partagée ({$a->filesize} octets) dépasse la limite de {$a->filesizelimit} octets.';
$string['moodlenet:sharenoticeactivity'] = 'Cette activité est partagée sur MoodleNet en tant que ressource.';
$string['moodlenet:sharenoticecourse'] = 'Ce cours est partagé sur MoodleNet en tant que ressource.';
$string['moodlenet:sharenoticepartial'] = 'Les activités sélectionnées sont en cours de partage sur MoodleNet en tant que ressource.';
$string['moodlenet:sharenoticepartialactivitynumber'] = '{$a} activités seront incluses dans le cours.';
$string['moodlenet:shareprogress'] = 'Progression du partage MoodleNet';
$string['moodlenet:shareprogressinfo'] = 'La liste montre les cours et activités que vous avez partagé vers MoodleNet.<br>Cliquer le nom de la ressource à afficher dans MoodleNet.';
$string['moodlenet:sharesuccesstext'] = 'Presque fini ! Visitez vos brouillons sur MoodleNet pour finaliser le partage de votre contenu.';
$string['moodlenet:sharesuccesstitle'] = 'Enregistré dans les brouillons de MoodleNet';
$string['moodlenet:sharetomoodlenet'] = 'Partager sur MoodleNet';
$string['moodlenet:sharetyperesource'] = 'ressource';
$string['moodlenet:sharinglargefile'] = 'Les gros fichiers peuvent prendre du temps.';
$string['moodlenet:sharingstatus'] = 'Partage sur MoodleNet';
$string['moodlenet:sharingto'] = 'Partage sur :';
$string['moodlerelease'] = 'Version de Moodle';
$string['moodleservicesandsupport'] = 'Services et assistance';
$string['moodleversion'] = 'Version de Moodle';
$string['more'] = 'suite';
$string['moreactions'] = 'Plus d’actions';
$string['morehelp'] = 'Plus d’aide';
$string['morehelpaboutmodule'] = 'Plus d’aide sur l’activité {$a}';
$string['moreinfo'] = 'Plus d’info';
$string['moreinformation'] = 'Plus d’informations sur cette erreur';
$string['moremenu'] = 'Plus';
$string['morenavigationlinks'] = 'Plus…';
$string['moreprofileinfoneeded'] = 'Veuillez nous en dire plus sur vous-même';
$string['mostrecently'] = 'le plus récemment';
$string['move'] = 'Déplacer';
$string['movecategoriessuccess'] = 'Déplacement de {$a->count} catégories vers la catégorie « {$a->to} » terminé';
$string['movecategoriestotopsuccess'] = '{$a->count} catégories déplacées au niveau racine';
$string['movecategorycontentto'] = 'Déplacer dans';
$string['movecategorysuccess'] = 'Déplacement de la catégorie « {$a->moved} » dans la catégorie « {$a->to} » terminé';
$string['movecategoryto'] = 'Déplacer la catégorie vers :';
$string['movecategorytotopsuccess'] = 'La catégorie « {$a->moved} » a été déplacée au niveau racine';
$string['movecontent'] = 'Déplacer {$a}';
$string['movecontentafter'] = 'Après « {$a} »';
$string['movecontentstoanothercategory'] = 'Déplacer le contenu vers une autre catégorie';
$string['movecontenttothetop'] = 'En haut de la liste';
$string['movecoursemodule'] = 'Déplacer l’activité';
$string['movecoursesection'] = 'Déplacer la section';
$string['movecourseto'] = 'Déplacer le cours vers :';
$string['movedown'] = 'Descendre';
$string['movefilestohere'] = 'Déplacer les fichiers ici';
$string['movefull'] = 'Déplacer {$a} à cet emplacement';
$string['movehere'] = 'Déplacer ici';
$string['moveleft'] = 'Déplacer à gauche';
$string['moveright'] = 'Déplacer à droite';
$string['movesection'] = 'Déplacer section {$a}';
$string['moveselectedcategoriesto'] = 'Déplacer les catégories sélectionnées vers…';
$string['moveselectedcoursesto'] = 'Déplacer les cours sélectionnés vers…';
$string['movetoanotherfolder'] = 'Déplacer vers un autre dossier';
$string['moveup'] = 'Monter';
$string['multipleitemsfound'] = '{$a} éléments trouvés.';
$string['mustchangepassword'] = 'Le nouveau mot de passe doit être différent du mot de passe actuel';
$string['mustconfirm'] = 'Vous devez confirmer l’enregistrement de votre compte';
$string['mycourses'] = 'Mes cours';
$string['myfiles'] = 'Fichiers personnels';
$string['myfilesmanage'] = 'Gérer mes fichiers personnels';
$string['myhome'] = 'Tableau de bord';
$string['mymoodledashboard'] = 'Mon tableau de bord Moodle';
$string['myprofile'] = 'Mon profil';
$string['name'] = 'Nom';
$string['namedfiletoolarge'] = 'Le fichier « {$a->filename} » est trop gros et ne peut pas être déposé.';
$string['nameforlink'] = 'Comment voulez-vous dénommer ce lien ?';
$string['nameforpage'] = 'Nom';
$string['navigation'] = 'Navigation';
$string['needed'] = 'Nécessaire';
$string['networkdropped'] = 'Il a été détecté que votre connexion Internet n’est pas fiable ou a été interrompue.<br />
Certaines modifications ne seront peut-être pas enregistrées correctement jusqu’à l’amélioration de votre connexion.';
$string['never'] = 'Jamais';
$string['neverdeletelogs'] = 'Ne jamais supprimer les journaux';
$string['new'] = 'Nouveau';
$string['newaccount'] = 'Nouveau compte';
$string['newactivityname'] = 'Nouveau nom pour l’activité {$a}';
$string['newcourse'] = 'Nouveau cours';
$string['newloginnotificationbodyfull'] = '<p>Bonjour {$a->userfullname},</p>
<p>Une connexion à votre compte {$a->sitename} vient d’avoir lieu à partir d’un nouvel appareil.</p>
<ul>
<li>Votre compte : {$a->username} {$a->useremail}</li>
<li>{$a->logintime}</li>
<li>Appareil : {$a->logindevice}</li>
<li>Adresse IP : {$a->loginip}</li>
</ul>
<p>Si vous vous êtes bien connecté, aucune action n’est nécessaire.</p>
<p>Si vous n’êtes pas au courant de cette connexion, veuillez <a href="{$a->changepasswordlink}">modifier votre mot de passe</a></p>';
$string['newloginnotificationbodysmall'] = 'Une connexion à votre compte {$a} vient d’avoir lieu à partir d’un nouvel appareil.';
$string['newloginnotificationtitle'] = 'Nouvelle connexion à votre compte {$a}';
$string['newpassword'] = 'Nouveau mot de passe';
$string['newpassword_help'] = 'Saisissez un nouveau mot de passe ou laissez vide pour conserver le mot de passe actuel.';
$string['newpasswordfromlost'] = '<strong>Attention !</strong> Votre <strong>Mot de passe actuel</strong> vous a été envoyé dans le <strong>deuxième</strong> des deux courriels envoyés durant le processus de récupération de mot de passe. Veuillez vous assurer que vous avez bien reçu votre mot de passe de remplacement avant de continuer sur cette page.';
$string['newpasswordtext'] = 'Bonjour {$a->firstname},

Le mot de passe de votre compte sur « {$a->sitename} » a été remplacé par un nouveau mot de passe temporaire.

Les informations pour vous connecter sont désormais :

    nom d’utilisateur : {$a->username}
    mot de passe : {$a->newpassword}

Merci de visiter cette page afin de changer de mot de passe :
    {$a->link}

Dans la plupart des logiciels de courriel, cette adresse devrait apparaître comme un lien de couleur bleue qu’il vous suffit de cliquer. Si cela ne fonctionne pas, copiez ce lien et collez-le dans la barre d’adresse de votre navigateur web.

Si vous avez besoin d’aide, veuillez contacter l’administrateur du site {$a->sitename},
{$a->signoff}';
$string['newpicture'] = 'Nouvelle image';
$string['newpicture_help'] = 'Pour ajouter une image, sélectionnez-en une en format JPG ou PNG, puis cliquez sur « Enregistrer mon profil ». L’image sera redimensionnée en un carré de 100x100 pixels.';
$string['newpictureusernotsetup'] = 'Une image de profil ne peut être ajoutée que lorsque toutes les informations requises pour le profil ont été enregistrées.';
$string['newsectionname'] = 'Nouveau nom pour la section {$a}';
$string['newsitem'] = 'article';
$string['newsitems'] = 'annonces';
$string['newsitemsnumber'] = 'Nombre d’annonces';
$string['newsitemsnumber_help'] = 'Le forum des annonces a par défaut son abonnement imposé. Seules les enseignants et d’autres utilisateurs ayant des permissions adéquates peuvent y poster des messages.

Si un forum d’annonces n’est pas nécessaire, indiquer 0.

Ce réglage détermine aussi le nombre d’annonces récentes affichées dans le bloc des dernières annonces.';
$string['newuser'] = 'Nouvel utilisateur';
$string['newusernewpasswordsubj'] = 'Nouveau compte utilisateur';
$string['newusernewpasswordtext'] = 'Bonjour {$a->firstname},

Un compte a été créé pour vous sur le site « {$a->sitename} ».

   nom d’utilisateur : {$a->username}
   mot de passe : {$a->newpassword}

(Vous devrez changer votre mot de passe lors de votre première connexion.)

Pour commencer à travailler sur « {$a->sitename} », connectez-vous sur
   {$a->link}

Si vous avez besoin d’aide, vous pouvez contacter l’administrateur du site,
{$a->signoff}';
$string['newusers'] = 'Nouveaux utilisateurs';
$string['newwindow'] = 'Nouvelle fenêtre';
$string['next'] = 'Suivant';
$string['nextpage'] = 'Page suivante';
$string['nextsection'] = 'Section suivante';
$string['no'] = 'Non';
$string['noblockstoaddhere'] = 'Il n’y a pas de bloc que vous puissiez ajouter à cette page.';
$string['nobody'] = 'Personne';
$string['nochange'] = 'Aucun changement';
$string['nocomments'] = 'Aucun commentaire';
$string['nocourses'] = 'Aucun cours';
$string['nocoursesfound'] = 'Aucun cours contenant les mots « {$a} » n’a été trouvé';
$string['nocoursestarttime'] = 'Ce cours n’a pas de date de début.';
$string['nocoursesyet'] = 'Il n’y a pas encore de cours';
$string['nodstpresets'] = 'L’administrateur n’a pas activé la prise en charge de l’heure d’été.';
$string['nofilesselected'] = 'Aucun fichier n’a encore été choisi pour être restauré';
$string['nofilesyet'] = 'Aucun fichier n’a encore été déposé dans ce cours';
$string['nofiltersapplied'] = 'Aucun filtre appliqué';
$string['nograde'] = 'Pas de note';
$string['nohelpforactivityorresource'] = 'Il n’y a actuellement pas d’aide associée à cette ressource ou activité.';
$string['noimagesyet'] = 'Aucune image n’a encore été déposée dans ce cours';
$string['noitemsfound'] = 'Aucun élément trouvé.';
$string['nologsfound'] = 'Aucun journal n’a été trouvé';
$string['nomatchingusers'] = 'Aucun utilisateur correspondant à « {$a} »';
$string['nomorecourses'] = 'Aucun cours n’a été trouvé';
$string['nomoreidnumber'] = 'N’utilise pas d’identifiant pour éviter les collisions';
$string['none'] = 'Aucun';
$string['noneditingteacher'] = 'Enseignant non éditeur';
$string['noneditingteacherdescription'] = 'Les enseignants non éditeurs peuvent enseigner dans leur cours et donner des notes aux étudiants, mais ne peuvent ni ajouter, ni modifier des activités.';
$string['nonstandard'] = 'Non standard';
$string['nopendingcourses'] = 'Il n’y a aucun cours en attente d’approbation';
$string['nopotentialadmins'] = 'Aucun administrateur potentiel';
$string['nopotentialcreators'] = 'Aucun créateur de cours potentiel';
$string['nopotentialstudents'] = 'Aucun étudiant potentiel';
$string['nopotentialteachers'] = 'Aucun enseignant potentiel';
$string['norecentactivity'] = 'Aucune activité récente';
$string['noreplybouncemessage'] = 'Vous avez répondu à une adresse de courriel de non-réponse. Si vous essayiez de répondre à un message d’un forum, essayez plutôt d’y répondre dans les forums de {$a}.

Voici une copie de votre message :';
$string['noreplybouncesubject'] = '{$a} - message de rebond.';
$string['noreplyname'] = 'Merci de ne pas répondre à ce courriel';
$string['noresetrecord'] = 'Il n’y a pas de trace de cette requête de réinitialisation. Veuillez effectuer une nouvelle demande de réinitialisation de mot de passe.';
$string['noresults'] = 'Aucun résultat';
$string['noresultsfor'] = 'Pas de résultat pour « {$a} »';
$string['normal'] = 'Normale';
$string['normalfilter'] = 'Moins de critères';
$string['nosite'] = 'Impossible de trouver le cours de site';
$string['nostudentsfound'] = 'Aucun {$a} trouvé';
$string['nostudentsingroup'] = 'Il n’y a pas encore d’étudiant dans ce groupe';
$string['nostudentsyet'] = 'Il n’y a encore aucun étudiant inscrit à ce cours.';
$string['nosuchemail'] = 'Adresse de courriel inconnue';
$string['notavailable'] = 'Non disponible';
$string['notavailablecourse'] = '{$a} n’est pas disponible';
$string['noteachersyet'] = 'Pas encore d’enseignant dans ce cours';
$string['noteachingupcomingcourses'] = 'Des cours à venir n’ont ni enseignant, ni étudiant';
$string['notenrolled'] = '{$a} n’est pas inscrit à ce cours.';
$string['notenrolledprofile'] = 'Ce profil n’est pas disponible, car cet utilisateur n’est pas inscrit à ce cours.';
$string['noteusercannotrolldatesoncontext'] = '<strong>Remarque :</strong> la possibilité de modifier les dates des activités lors de la restauration a été désactivée, car vous n’avez pas les permissions requises.';
$string['noteuserschangednonetocourse'] = '<strong>Remarque :</strong> les utilisateurs du cours doivent être restaurés lors de la restauration de données utilisateur (fichiers ou messages, dans les activités). Ce paramètre a été modifié pour vous.';
$string['nothingnew'] = 'Aucune activité récente';
$string['nothingtodisplay'] = 'Rien à afficher';
$string['notice'] = 'Remarque';
$string['noticenewerbackup'] = 'Ce fichier de sauvegarde a été créé avec la version {$a->backuprelease} ({$a->backupversion}) de Moodle, qui est plus récente que votre installation actuelle de Moodle {$a->serverrelease} ({$a->serverversion}). Ceci peut causer des incohérences, car la compatibilité des fichiers de sauvegarde ne peut dans ce cas pas être garantie.';
$string['notifications'] = 'Notifications';
$string['notifyloginfailuresmessage'] = '{$a->time}, IP : {$a->ip}, utilisateur : {$a->info}, nom complet : {$a->name}';
$string['notifyloginfailuresmessageend'] = 'Vous pouvez consulter ces journaux à l’adresse {$a}';
$string['notifyloginfailuresmessagestart'] = 'Voici une liste des tentatives de connexion au site {$a} depuis la dernière notification';
$string['notifyloginfailuressubject'] = '{$a} :: notification de tentatives de connexion';
$string['notincluded'] = 'Pas inclus';
$string['notingroup'] = 'Désolé, vous devez faire partie d’un groupe pour voir cette page.';
$string['notpublic'] = 'Non public !';
$string['nousersfound'] = 'Aucun utilisateur n’a été trouvé';
$string['nousersmatching'] = 'Aucun utilisateur n’a été trouvé contenant le texte « {$a} ».';
$string['nousersyet'] = 'Il n’y pas encore d’utilisateur';
$string['novalidcourses'] = 'Aucun cours valable à afficher';
$string['now'] = 'maintenant';
$string['numattempts'] = '{$a} tentatives de connexions infructueuses';
$string['numberofcourses'] = 'Nombre de cours';
$string['numberweeks'] = 'Nombre de sections';
$string['numday'] = '{$a} jour';
$string['numdays'] = '{$a} jours';
$string['numhours'] = '{$a} heures';
$string['numletters'] = '{$a} caractères';
$string['numminutes'] = '{$a} minutes';
$string['nummonth'] = '{$a} mois';
$string['nummonths'] = '{$a} mois';
$string['numseconds'] = '{$a} secondes';
$string['numviews'] = '{$a} vues';
$string['numweek'] = '{$a} semaine';
$string['numweeks'] = '{$a} semaines';
$string['numwords'] = '{$a} mots';
$string['numyear'] = '{$a} année';
$string['numyears'] = '{$a} ans';
$string['ok'] = 'OK';
$string['oldpassword'] = 'Mot de passe actuel';
$string['olduserdirectory'] = 'Ceci est l’ancien dossier utilisateur. Il n’est plus utilisé. Vous pouvez le supprimer sans conséquence. Les fichiers qu’il contient ont été copiés dans le nouveau dossier utilisateur.';
$string['oneitemfound'] = '1 élément trouvé.';
$string['opendrawerblocks'] = 'Ouvrir le tiroir des blocs';
$string['opendrawerindex'] = 'Ouvrir l’index du cours';
$string['opensinnewwindow'] = 'S’ouvre dans une nouvelle fenêtre';
$string['operator_and'] = 'et';
$string['operator_andnot'] = 'et';
$string['operator_or'] = 'ou';
$string['optional'] = 'Facultatif';
$string['options'] = 'options';
$string['order'] = 'Ordre';
$string['originalpath'] = 'Chemin original';
$string['orphanedactivitiesinsectionno'] = 'Activités orphelines (section {$a})';
$string['other'] = 'Autre';
$string['outline'] = 'Résumé';
$string['outlinereport'] = 'Rapport résumé';
$string['page'] = 'Page';
$string['pagea'] = 'Page {$a}';
$string['pagedcontentnavigation'] = 'Navigation par pages';
$string['pagedcontentnavigationactiveitem'] = 'Page actuelle, page {$a}';
$string['pagedcontentnavigationitem'] = 'Aller à la page {$a}';
$string['pagedcontentpagingbaritemsperpage'] = 'Afficher {$a} éléments par page';
$string['pageheaderconfigablock'] = 'Configuration d’un bloc dans {$a->fullname}';
$string['pagepath'] = 'Chemin de la page';
$string['pageshouldredirect'] = 'Cette page va vous rediriger automatiquement. Si cela n’arrive pas, veuillez utiliser le lien Continuer ci-dessous.';
$string['parentcategory'] = 'Catégorie supérieure';
$string['parentcoursenotfound'] = 'Le cours parent n’a pas été trouvé !';
$string['parentfolder'] = 'Dossier parent';
$string['participants'] = 'Participants';
$string['participantslist'] = 'Liste des participants';
$string['participationratio'] = 'Proportion de participation';
$string['participationreport'] = 'Rapport de participation';
$string['password'] = 'Mot de passe';
$string['passwordchanged'] = 'Le mot de passe a été changé';
$string['passwordconfirmchange'] = 'Confirmer le changement de mot de passe';
$string['passwordextlink'] = 'Le lien ci-dessous a été mis en place pour vous permettre de retrouver votre mot de passe perdu. En suivant ce lien, vous allez vous déconnecter de Moodle.';
$string['passwordforgotten'] = 'Mot de passe oublié';
$string['passwordforgotteninstructions'] = 'Les informations vous concernant doivent d’abord être trouvées dans la base de données. Veuillez saisir <strong>soit</strong> votre nom d’utilisateur, soit votre adresse de courriel dans le champ adéquat. Il n’est pas nécessaire de saisir les deux.';
$string['passwordforgotteninstructions2'] = 'Pour recevoir un nouveau mot de passe, veuillez indiquer ci-dessous votre adresse de courriel ou votre nom d’utilisateur. Si les données correspondantes se trouvent dans la base de données, un message vous sera envoyé par courriel, avec des instructions vous permettant de vous connecter.';
$string['passwordnohelp'] = 'Aucune aide n’est disponible pour retrouver votre mot de passe perdu. Veuillez contacter l’administrateur de ce Moodle.';
$string['passwordpolicynomatch'] = 'Votre mot mot de passe actuel n’est plus conforme à la politique des mots de passe.
  {$a}';
$string['passwordrecovery'] = 'Récupération de votre mot de passe';
$string['passwordsdiffer'] = 'Les mots de passe ne correspondent pas';
$string['passwordsent'] = 'Le mot de passe a été envoyé';
$string['passwordsenttext'] = '<p>Un message vous a été envoyé à cette adresse : {$a->email}.</p><p><strong>Merci de lire ce message afin de connaître votre nouveau mot de passe</strong></p><p>Ce nouveau mot de passe a été généré automatiquement. Vous voudrez sans doute le <a href="{$a->link}">modifier</a> afin qu’il vous soit plus facile de vous en souvenir.</p>';
$string['passwordset'] = 'Votre mot de passe a été changé.';
$string['path'] = 'Chemin';
$string['pathnotexists'] = 'Ce chemin n’existe pas sur votre serveur !';
$string['pathslasherror'] = 'Le chemin ne doit pas se terminer par une barre oblique.';
$string['paymentinstant'] = 'Le bouton ci-dessous vous permet de payer et de vous inscrire en quelques minutes.';
$string['paymentpending'] = '(<small><b>{$a}</b> en attente</small>)';
$string['paymentrequired'] = 'Un paiement est requis pour accéder à ce cours.';
$string['payments'] = 'Paiements';
$string['paymentsorry'] = 'Merci pour votre paiement ! Une fois qu’il sera traité, vous pourrez accéder au cours {$a->fullname}. Veuillez attendre, puis ré-essayer. Si vous n’arrivez toujours pas à y accéder, merci de contacter l’{$a->teacher} ou l’administrateur du site';
$string['paymentthanks'] = 'Merci pour votre paiement ! Vous êtes dès maintenant inscrit au cours {$a}.';
$string['pendingrequests'] = 'Demandes en attente';
$string['percents'] = '{$a} %';
$string['periodending'] = 'Fin de la période ({$a})';
$string['perpage'] = 'Par page';
$string['perpagea'] = 'Par page : {$a}';
$string['personal'] = 'Personnel';
$string['personalprofile'] = 'Fiche personnelle';
$string['phone'] = 'Téléphone';
$string['phone1'] = 'Téléphone';
$string['phone2'] = 'Téléphone mobile';
$string['phpinfo'] = 'Info PHP';
$string['picture'] = 'Image';
$string['pictureof'] = 'Avatar {$a}';
$string['pictureofuser'] = 'Avatar utilisateur';
$string['placeholdertypeorselect'] = 'Taper ou sélectionner…';
$string['pleaseclose'] = 'Veuillez maintenant fermer cette fenêtre.';
$string['pleasesearchmore'] = 'Veuillez rechercher plus';
$string['pleaseusesearch'] = 'Veuillez utiliser la recherche';
$string['plugin'] = 'Plugin';
$string['pluginarea'] = 'Zone';
$string['plugincheck'] = 'Vérifications plugins';
$string['plugindeletefiles'] = 'Toutes les données associées au plugin « {$a->name} » ont été supprimées de la base de données. Pour empêcher que le plugin ne se réinstalle, veuillez supprimer le dossier « {$a->directory} » de votre serveur.';
$string['pluginitemid'] = 'ID élément';
$string['pluginmissingfromdisk'] = '{$a->name} (absent du disque)';
$string['pluginsetup'] = 'Mise en place des tables de plugins';
$string['policyaccept'] = 'Je comprends et je me déclare d’accord';
$string['policyagree'] = 'Vous devez accepter de vous conformer à cette politique pour continuer à utiliser ce site. Acceptez-vous cette politique ?';
$string['policyagreement'] = 'Acceptation de la politique du site';
$string['policyagreementclick'] = 'Acceptation de la politique du site';
$string['popup'] = 'Fenêtre surgissante';
$string['popupwindow'] = 'Ouvrir le fichier dans une nouvelle fenêtre';
$string['popupwindowname'] = 'Nouvelle fenêtre';
$string['post'] = 'Message';
$string['posts'] = 'Messages';
$string['potentialadmins'] = 'Administrateurs potentiels';
$string['potentialcreators'] = 'Créateurs de cours potentiels';
$string['potentialstudents'] = 'Étudiants potentiels';
$string['potentialteachers'] = 'Enseignants potentiels';
$string['poweredbymoodle'] = 'Fourni par <a href="https://moodle.com">Moodle</a>';
$string['preferences'] = 'Préférences';
$string['preferredlanguage'] = 'Langue préférée';
$string['preferredtheme'] = 'Thème préféré';
$string['preprocessingbackupfile'] = 'Prétraitement du fichier de sauvegarde';
$string['prev'] = 'Précédent';
$string['preview'] = 'Aperçu';
$string['previeworchoose'] = 'Aperçu ou choix d’un thème';
$string['previewthemename'] = 'Prévisualiser le thème « {$a} »';
$string['previous'] = 'Précédent';
$string['previouslyselectedusers'] = 'Utilisateurs sélectionnés précédemment ne correspondant pas à « {$a} »';
$string['previouspage'] = 'Page précédente';
$string['previoussection'] = 'Section précédente';
$string['primaryadminsetup'] = 'Mise en place du compte de l’administrateur';
$string['privacy:metadata:config_log'] = 'Le journal des modifications de configuration.';
$string['privacy:metadata:config_log:name'] = 'Le nom de la modification du réglage.';
$string['privacy:metadata:config_log:oldvalue'] = 'L’ancienne valeur du réglage.';
$string['privacy:metadata:config_log:plugin'] = 'Le plugin modifié.';
$string['privacy:metadata:config_log:timemodified'] = 'La date et l’heure de la modification.';
$string['privacy:metadata:config_log:userid'] = 'L’utilisateur qui a effectué la modification.';
$string['privacy:metadata:config_log:value'] = 'La nouvelle valeur du réglage.';
$string['privacy:metadata:events_queue'] = 'La file d’attente des événements utilisateur en attente de traitement.';
$string['privacy:metadata:events_queue:eventdata'] = 'Les données enregistrées dans l’événement.';
$string['privacy:metadata:events_queue:stackdump'] = 'Toute trace de traitement avec cet événement.';
$string['privacy:metadata:events_queue:timecreated'] = 'La date et l’heure de la création de l’événement.';
$string['privacy:metadata:events_queue:userid'] = 'L’identifiant utilisateur en lien avec cet événement';
$string['privacy:metadata:log'] = 'Une collection des événements passés';
$string['privacy:metadata:log:action'] = 'Une description de l’action';
$string['privacy:metadata:log:cmid'] = 'cmid';
$string['privacy:metadata:log:course'] = 'cours';
$string['privacy:metadata:log:info'] = 'Informations supplémentaires';
$string['privacy:metadata:log:ip'] = 'L’adresse IP utilisée au moment de l’événement';
$string['privacy:metadata:log:module'] = 'module';
$string['privacy:metadata:log:time'] = 'La date et l’heure à laquelle l’action a eu lieu';
$string['privacy:metadata:log:url'] = 'L’URL en lien avec l’événement';
$string['privacy:metadata:log:userid'] = 'L’identifiant de l’utilisateur qui a effectué l’action';
$string['privacy:metadata:moodlenet_share_progress'] = 'Infos de progrès du partage MoodleNet';
$string['privacy:metadata:moodlenet_share_progress:cmid'] = 'L’ID de module de cours associé';
$string['privacy:metadata:moodlenet_share_progress:courseid'] = 'L’ID du cours associé';
$string['privacy:metadata:moodlenet_share_progress:resourceurl'] = 'L’URL retournée par MoodleNet après un partage réussi';
$string['privacy:metadata:moodlenet_share_progress:status'] = 'Le statut résultat d’un partage';
$string['privacy:metadata:moodlenet_share_progress:timecreated'] = 'L’horodatage d’un partage';
$string['privacy:metadata:moodlenet_share_progress:type'] = 'Le type de partage effectué';
$string['privacy:metadata:moodlenet_share_progress:userid'] = 'L’utilisateur qui a effectué le partage';
$string['privacy:metadata:oauth2_refresh_token'] = 'Actualiser le jeton utilisé dans la communication OAuth 2.0';
$string['privacy:metadata:oauth2_refresh_token:issuerid'] = 'L’ID du fournisseur à qui le jeton correspond';
$string['privacy:metadata:oauth2_refresh_token:scopehash'] = 'L’ID de l’utilisateur à qui le jeton correspond';
$string['privacy:metadata:oauth2_refresh_token:timecreated'] = 'La date et l’heure de la création du jeton';
$string['privacy:metadata:oauth2_refresh_token:timemodified'] = 'La date et l’heure de la modification du jeton';
$string['privacy:metadata:oauth2_refresh_token:token'] = 'Le jeton d’actualisation pour les champs d’application et l’utilisateur respectifs';
$string['privacy:metadata:oauth2_refresh_token:userid'] = 'L’ID de l’utilisateur à qui le jeton correspond';
$string['privacy:metadata:task_adhoc'] = 'Le statut des tâches ad hoc.';
$string['privacy:metadata:task_adhoc:component'] = 'Le composant à qui appartient la tâche.';
$string['privacy:metadata:task_adhoc:nextruntime'] = 'La prochaine date et heure de lancement de la tâche.';
$string['privacy:metadata:task_adhoc:userid'] = 'L’utilisateur sous le nom duquel la tâche sera lancée.';
$string['privacy:metadata:task_log'] = 'La sortie d’un journal';
$string['privacy:metadata:task_log:component'] = 'Le composant auquel la tâche appartient.';
$string['privacy:metadata:task_log:userid'] = 'L’utilisateur auquel la tâche appartenait.';
$string['privacy:metadata:upgrade_log'] = 'Le journal de mise à jour.';
$string['privacy:metadata:upgrade_log:backtrace'] = 'Toute trace en lien avec cette étape de la mise à jour.';
$string['privacy:metadata:upgrade_log:details'] = 'Informations supplémentaires en lien avec la mise à jour.';
$string['privacy:metadata:upgrade_log:info'] = 'Les informations principales pour cette étape de la mise à jour.';
$string['privacy:metadata:upgrade_log:plugin'] = 'Le plugin qui a été mis à jour.';
$string['privacy:metadata:upgrade_log:targetversion'] = 'La nouvelle version vers laquelle faire la mise à jour.';
$string['privacy:metadata:upgrade_log:timemodified'] = 'La date et l’heure de la mise à jour.';
$string['privacy:metadata:upgrade_log:type'] = 'Le type d’entrée de journal.';
$string['privacy:metadata:upgrade_log:userid'] = 'L’utilisateur qui a effectué la mise à jour.';
$string['privacy:metadata:upgrade_log:version'] = 'L’ancienne version du plugin.';
$string['private_files_handler'] = 'Ce gestionnaire permet d’enregistrer les annexes de courriel dans la zone de fichiers personnels de l’utilisateur.';
$string['private_files_handler_name'] = 'Envoi par courriel vers les fichiers personnels';
$string['privatefiles'] = 'Fichiers personnels';
$string['privatefilesmanage'] = 'Gérer les fichiers personnels';
$string['proceed'] = 'Continuer';
$string['profile'] = 'Profil';
$string['profilenotshown'] = 'La description de ce profil ne s’affichera que lorsque cet utilisateur sera inscrit dans au moins un cours.';
$string['progress'] = 'Progression';
$string['publicprofile'] = 'Profil public';
$string['publicsitefileswarning'] = 'Remarque : les fichiers déposés ici sont visibles par tout le monde';
$string['publicsitefileswarning2'] = 'Remarque : les fichiers déposés ici sont visibles par tous ceux qui connaissent (ou devinent) l’URL. Pour des raisons de sécurité, il est recommandé que tous les fichiers de sauvegarde soient supprimés immédiatement après que la restauration a été effectuée.';
$string['publicsitefileswarning3'] = 'Remarque : les fichiers déposés ici sont visibles par tous ceux qui connaissent (ou devinent) l’URL. Pour des raisons de sécurité, les fichiers de sauvegarde ne doivent être enregistrés que dans le dossier sécurisé « backupdata ».';
$string['question'] = 'Question';
$string['questionsinthequestionbank'] = 'Questions dans la banque de questions';
$string['queued'] = 'En file d’attente';
$string['quotausage'] = 'Vous utilisez actuellement {$a->used} de votre quota de {$a->total}.';
$string['readinginfofrombackup'] = 'Lecture des informations de la sauvegarde';
$string['readme'] = 'LISEZMOI';
$string['recentactivity'] = 'Activité récente';
$string['recentactivityreport'] = 'Rapport complet des activités récentes…';
$string['recipientslist'] = 'Liste des destinataires';
$string['recommended'] = 'Recommandés';
$string['recreatedcategory'] = 'Catégorie {$a} recréée';
$string['redirect'] = 'Redirection';
$string['reducesections'] = 'Réduire le nombre des sections';
$string['refresh'] = 'Actualiser';
$string['refreshingevents'] = 'Actualisation du calendrier';
$string['registration'] = 'Enregistrement de Moodle';
$string['registrationcontact'] = 'Contact pour le public';
$string['registrationcontactno'] = 'Non, je ne désire pas être contacté par d’autres personnes';
$string['registrationcontactyes'] = 'Oui, veuillez fournir un formulaire permettant à d’autres Moodleurs de me contacter';
$string['registrationemail'] = 'Notifications par courriel';
$string['registrationinfo'] = '<p>Cette page vous permet d’enregistrer votre site Moodle sur moodle.org. L’enregistrement est gratuit. Le principal avantage de l’enregistrement est l’inscription à une liste de distribution courriel utilisée pour d’importantes informations telles que des alertes de sécurité et des mises à jour de Moodle.</p><p>Vos données seront conservées confidentiellement, et ne seront jamais vendues ou divulguées à quiconque. Ces informations ne sont recueillies que pour l’assistance technique et à des fins de statistiques sur la communauté Moodle.</p><p>Si vous le désirez, le nom et l’URL de votre site, ainsi que votre pays peuvent être ajoutés à la liste publique des sites Moodle.</p><p>Les nouveaux enregistrements sont vérifiés manuellement avant d’être ajoutés à la liste. En revanche, une fois dans cette liste, vous pouvez modifier votre enregistrement en tout temps en remplissant et validant à nouveau ce formulaire.</p>';
$string['registrationinfotitle'] = 'Informations d’enregistrement';
$string['registrationsend'] = 'Envoyer les informations d’enregistrement à moodle.org';
$string['registrationyes'] = 'Oui, informez-moi des nouvelles versions de Moodle, des alertes de sécurité et d’autres nouvelles';
$string['reject'] = 'Rejeter';
$string['rejectdots'] = 'Rejeter…';
$string['relativedatesmode'] = 'Mode dates relatives';
$string['relativedatesmode_help'] = 'Afficher les dates du cours relativement à la date de commencement du cours par l’utilisateur.

La date de commencement du cours par l’utilisateur est sa date d’inscription, à moins qu’il n’ait été inscrit avant la date de début du cours, auquel cas la date de commencement est la date de début du cours.

<strong>Attention !</strong> Cette fonctionnalité est expérimentale et toutes les activités ne la prennent pas en charge. Une fois le cours créé, ce réglage ne peut plus être modifié.';
$string['relativedatesmode_warning'] = '<strong>Attention !</strong> Le mode dates relatives ne peut pas être changé une fois que le cours a été créé.';
$string['reload'] = 'Actualiser';
$string['remoteappuser'] = 'Utilisateur distant de {$a}';
$string['remove'] = 'Retirer';
$string['removeadmin'] = 'Supprimer cet administrateur';
$string['removecreator'] = 'Supprimer ce créateur de cours';
$string['removed'] = '{$a} retiré';
$string['removestudent'] = 'Supprimer cet étudiant';
$string['removeteacher'] = 'Supprimer cet enseignant';
$string['rename'] = 'Renommer';
$string['renamefileto'] = 'Renommer <strong>{$a}</strong> en';
$string['report'] = 'Rapport';
$string['reports'] = 'Rapports';
$string['reporttype'] = 'Type de rapport';
$string['repositories'] = 'Dépôts';
$string['requestcourse'] = 'Demander la création d’un cours';
$string['requestedby'] = 'Demandé par';
$string['requestedcourses'] = 'Cours demandés';
$string['requestreason'] = 'Raison de la demande de création';
$string['requests'] = 'Demandes';
$string['required'] = 'Requis';
$string['requirespayment'] = 'Un paiement est requis pour accéder à ce cours';
$string['resendemail'] = 'Renvoyer le courriel de confirmation';
$string['reset'] = 'Réinitialiser';
$string['resetcomponent'] = 'Composant';
$string['resetcourse'] = 'Réinitialiser le cours';
$string['resetcourseconfirm'] = 'Réinitialiser le cours ?';
$string['resetcoursewarning'] = 'Voulez-vous vraiment réinitialiser le cours « {$a} » ?
<br/><br/>
Cette action supprimera les données sélectionnées et réinitialisera le cours à son état original. Il n’est pas possible de l’annuler.';
$string['resetinfo'] = 'Cette fonctionnalité permet de supprimer toutes les données utilisateur et de réinitialiser ce cours à son état d’origine. Les activités et paramètres du cours ne seront pas modifiés.';
$string['resetinfoselect'] = 'Sélectionner les données à supprimer ou à réinitialiser dans les catégories ci-dessous :';
$string['resetnotimplemented'] = 'Réinitialisation non prise en charge';
$string['resetnotimplementedinfo'] = 'Ces activités ne peuvent pas être réinitialisées :';
$string['resetrecordexpired'] = 'Le lien de réinitialisation de mot de passe que vous avez utilisé a été généré il y a {$a} minutes et est désormais échu. Veuillez effectuer une nouvelle demande de réinitialisation de mot de passe.';
$string['resetstartdate'] = 'Réinitialiser la date de début';
$string['resetstatus'] = 'État';
$string['resettable'] = 'Réinitialiser les préférences du tableau';
$string['resettask'] = 'Réinitialiser';
$string['resettodefaults'] = 'Retour aux réglages par défaut';
$string['resortcourses'] = 'Trier les cours';
$string['resortsubcategoriesby'] = 'Trier les catégories par {$a}, ascendant';
$string['resortsubcategoriesbyreverse'] = 'Trier les catégories par {$a}, descendant';
$string['resource'] = 'Ressource';
$string['resourcedisplayauto'] = 'Automatique';
$string['resourcedisplaydownload'] = 'Forcer le téléchargement';
$string['resourcedisplayembed'] = 'Intégrer';
$string['resourcedisplayframe'] = 'Dans un cadre';
$string['resourcedisplaynew'] = 'Nouvelle fenêtre';
$string['resourcedisplayopen'] = 'Ouvrir';
$string['resourcedisplaypopup'] = 'Dans une fenêtre surgissante';
$string['resources'] = 'Ressources';
$string['resources_help'] = 'Les différents types de ressource vous permettent d’insérer dans le cours pratiquement n’importe quelle sorte de contenu.';
$string['restore'] = 'Restauration';
$string['restorecancelled'] = 'Restauration annulée';
$string['restorecannotassignroles'] = 'La restauration nécessite l’attribution de rôles et vous n’avez pas les permissions requises';
$string['restorecannotcreateorassignroles'] = 'La restauration nécessite la création ou l’attribution de rôles et vous n’avez pas les permissions requises';
$string['restorecannotcreateuser'] = 'La restauration nécessite la création de l’utilisateur « {$a} » à partir du fichier de sauvegarde et vous n’avez pas les permissions requises';
$string['restorecannotoverrideperms'] = 'La restauration nécessite la définition de dérogation aux rôles et vous n’avez pas les permissions requises';
$string['restorecoursenow'] = 'Restaurer ce cours maintenant !';
$string['restoredaccount'] = 'Compte restauré';
$string['restoredaccountinfo'] = 'Ce compte a été importé d’un autre serveur et son mot de passe a été perdu. Pour définir un nouveau mot de passe par courriel, veuillez cliquer sur « Continuer »';
$string['restorefinished'] = 'Restauration réussie';
$string['restoreinfo'] = 'Utiliser un fichier de sauvegarde pour restaurer une version antérieure de ce cours ou pour créer un nouveau cours.';
$string['restoremnethostidmismatch'] = 'L’identifiant de l’utilisateur« {$a} » sur le serveur MNet ne correspond pas à l’ID local du serveur MNet.';
$string['restoreto'] = 'Restaurer vers';
$string['restoretositeadding'] = 'Attention ! Vous allez restaurer des données en les ajoutant à la page d’accueil !';
$string['restoretositedeleting'] = 'Attention ! Vous allez restaurer des données sur la page d’accueil, en en supprimant d’abord des données !';
$string['restoreuserconflict'] = 'Une tentative de restaurer l’utilisateur « {$a} » à partir du fichier de sauvegarde sera la cause d’un conflit';
$string['restoreuserinfofailed'] = 'La restauration a été interrompue, car vous n’avez pas les permissions requises pour restaurer les données des utilisateurs.';
$string['restoreusersprecheck'] = 'Vérification des données utilisateur';
$string['restoreusersprecheckerror'] = 'Des problèmes ont été détectés lors de la vérification des données utilisateur';
$string['restricted'] = 'Accès restreint';
$string['resultsfound'] = '{$a} résultats trouvés';
$string['retry'] = 'Réessayer';
$string['returningtosite'] = 'Vous possédez déjà un compte ?';
$string['returntooriginaluser'] = 'Retour à {$a}';
$string['revert'] = 'Version précédente';
$string['role'] = 'Rôle';
$string['roleassignments'] = 'Attributions de rôle';
$string['rolemappings'] = 'Application des rôles';
$string['rolerenaming'] = 'Renommer les rôles';
$string['rolerenaming_help'] = 'Modifier le nom des rôles dans ce cours.';
$string['rolerenaming_success'] = 'Noms des rôles dans ce cours modifiés.';
$string['roles'] = 'Rôles';
$string['rss'] = 'RSS';
$string['rssarticles'] = 'Nombre d’articles RSS récents';
$string['rsserror'] = 'Erreur lors de la lecture de données RSS';
$string['rsserrorauth'] = 'Votre lien RSS ne contient pas de jeton d’authentification valide.';
$string['rsserrorguest'] = 'Ce flux utilise l’accès « Utilisateur anonyme » pour accéder aux données, mais ce rôle n’a pas les permissions requises pour lire les données. Veuillez visiter l’URL de provenance de ce flux en tant qu’utilisateur connecté et obtenir un lien RSS.';
$string['rsskeyshelp'] = '<p>Pour assurer la sécurité et la confidentialité, les URLs des flux RSS contiennent une clef identifiant leur utilisateur. Ceci empêche d’autres utilisateurs d’accéder à des zones de Moodle auxquelles ils ne doivent pas avoir accès au moyen des flux RSS.</p><p>Cette clef est créée automatiquement la première fois que vous accédez à une zone de Moodle qui produit un flux RSS. Si vous avez des raisons de penser que votre clef de flux RSS a été compromise, vous pouvez en générer une nouvelle en cliquant le lien Réinitialiser. Veuillez prendre note que les URLs actuels de vos flux RSS ne seront alors plus valides.</p>';
$string['rsstype'] = 'Flux RSS de cette activité';
$string['save'] = 'Enregistrer';
$string['saveandnext'] = 'Enregistrer et afficher la suite';
$string['savechanges'] = 'Enregistrer';
$string['savechangesanddisplay'] = 'Enregistrer et afficher';
$string['savechangesandreturn'] = 'Enregistrer et revenir';
$string['savechangesandreturntocourse'] = 'Enregistrer et revenir au cours';
$string['savecomment'] = 'Enregistrer le commentaire';
$string['savedat'] = 'Enregistré à';
$string['savepreferences'] = 'Enregistrer les préférences';
$string['saveto'] = 'Enregistrer sous';
$string['scale'] = 'Barème';
$string['scale_help'] = 'Un barème est une échelle d’évaluation ou de la notation du travail fourni dans une activité. Il est défini au moyen d’une liste ordonnées de valeurs, séparées par des virgules, s’étendant du négatif au positif. Par exemple : « Décevant, Pas assez bon, Moyen, Bon, Très bon, Excellent ».';
$string['scale_link'] = 'grade/scale';
$string['scales'] = 'Barèmes';
$string['scalescustom'] = 'Barèmes personnalisés';
$string['scalescustomcreate'] = 'Ajouter un nouveau barème';
$string['scalescustomno'] = 'Aucun barème personnalisé n’a été encore créé';
$string['scalesstandard'] = 'Barèmes standards';
$string['scalestandard'] = 'Barème standard';
$string['scalestandard_help'] = 'Un barème standard est disponible dans tout le site, pour tous les cours.';
$string['scalestandard_link'] = 'grade/scale';
$string['scalestip'] = 'Pour créer des barèmes personnalisés, utilisez le liens « Barèmes… » dans le menu d’administration de votre cours.';
$string['scalestip2'] = 'Pour créer des barèmes personnalisés, cliquez sur le lien Notes dans le menu d’administration du cours, puis sélectionnez Modifier > Barèmes dans le menu déroulant.';
$string['schedule'] = 'Planification';
$string['screenshot'] = 'Copie d’écran';
$string['search'] = 'Rechercher';
$string['search_help'] = 'Pour une recherche simple d’un ou de plusieurs mots n’importe où dans le texte, il suffit de les taper, en les séparant par des espaces. Les mots de moins de 3 caractères sont ignorés.

Pour des critères de recherche plus pointus, cliquez sur le bouton sans taper quoi que ce soit dans les différents champs. Un formulaire complet s’affichera, vous permettant de spécifier plus précisément votre recherche.';
$string['searchactivities'] = 'Rechercher des activités par nom ou par description';
$string['searchagain'] = 'Rechercher de nouveau';
$string['searchbyemail'] = 'Récupération par adresse de courriel';
$string['searchbyusername'] = 'Récupération par nom d’utilisateur';
$string['searchcoursecategories'] = 'Rechercher les catégories';
$string['searchcourses'] = 'Rechercher des cours';
$string['searchgroups'] = 'Rechercher des groupes';
$string['searchitems'] = 'Rechercher des éléments';
$string['searchoptions'] = 'Options de recherche';
$string['searchresults'] = 'Résultats de la recherche';
$string['searchusers'] = 'Chercher utilisateur';
$string['sec'] = 's';
$string['seconds'] = 'secondes';
$string['secondsleft'] = '{$a} s';
$string['secondstotime172800'] = '2 jours';
$string['secondstotime259200'] = '3 jours';
$string['secondstotime345600'] = '4 jours';
$string['secondstotime432000'] = '5 jours';
$string['secondstotime518400'] = '6 jours';
$string['secondstotime604800'] = '1 semaine';
$string['secondstotime86400'] = '1 jour';
$string['secretalreadyused'] = 'Le lien de confirmation du changement de mot de passe a déjà été utilisé. Le mot de passe n’a pas été modifié.';
$string['secs'] = 's';
$string['section'] = 'Section';
$string['sectionactionnotsupported'] = 'L’action de section « {$a} » n’est pas prise en charge ici';
$string['sectionname'] = 'Nom de section';
$string['sectionoutline'] = 'Résumé de section';
$string['sections'] = 'Sections';
$string['seealsostats'] = 'Voir aussi les statistiques';
$string['selctauser'] = 'Sélectionner un utilisateur';
$string['select'] = 'Sélectionner';
$string['selectacategory'] = 'Veuillez sélectionner une catégorie';
$string['selectacountry'] = 'Choisir un pays';
$string['selectacourse'] = 'Sélectionner un cours';
$string['selectacoursesite'] = 'Sélectionner un cours ou un site';
$string['selectagroup'] = 'Sélectionner un groupe';
$string['selectall'] = 'Tout sélectionner';
$string['selectallusersonpage'] = 'Sélectionner tous les utilisateurs sur cette page';
$string['selectalluserswithcount'] = 'Sélectionner les {$a} utilisateurs';
$string['selectamodule'] = 'Veuillez choisir un module d’activité';
$string['selectanaction'] = 'Sélectionner une action';
$string['selectanoptions'] = 'Sélectionner une option';
$string['selectaregion'] = 'Sélectionner une zone';
$string['selectcategorysort'] = 'Quelles catégories voulez-vous trier ?';
$string['selectcategorysortby'] = 'Choisissez comment vous voulez trier les catégories';
$string['selectcoursesortby'] = 'Choisissez comment vous voulez trier les cours';
$string['selectdefault'] = 'Sélection par défaut';
$string['selectedcategories'] = 'Catégories sélectionnées';
$string['selectedfile'] = 'Fichier sélectionné';
$string['selectednowmove'] = '{$a} fichiers sélectionnés pour déplacement. Allez maintenant dans le dossier de destination désiré et cliquez sur « Déplacer les fichiers ici »';
$string['selectfiles'] = 'Sélectionner des fichiers';
$string['selectfiltertype'] = 'Sélectionner';
$string['selectgroupsseparate'] = 'Sélectionner groupes séparés';
$string['selectgroupsvisible'] = 'Sélectionner groupes visibles';
$string['selectitem'] = 'Sélectionner « {$a} »';
$string['selectmoduletoviewhelp'] = 'Sélectionnez une activité ou une ressource pour afficher l’aide à son sujet.

Double-cliquez sur le nom d’une activité ou d’une ressource pour l’ajouter rapidement.';
$string['selectnos'] = 'Sélectionner tous les « Non »';
$string['selectperiod'] = 'Sélectionner une période';
$string['selecttheme'] = 'Choisir ce thème';
$string['selectthemename'] = 'Choisir le thème « {$a} »';
$string['senddetails'] = 'Envoyer un nouveau mot de passe par courriel';
$string['sent'] = 'Envoyé';
$string['separate'] = 'Séparer';
$string['separateandconnected'] = 'Appropriation du savoir liée ou détachée';
$string['separateandconnected1'] = 'Pas très pertinent';
$string['separateandconnected2'] = 'Moyennement intéressant';
$string['separateandconnected3'] = 'Plutôt pertinent';
$string['separateandconnectedinfo'] = 'Ce barème est fondé sur une théorie qui traite de la relation que l’apprenant entretient avec son entourage et ce qu’il doit apprendre : il peut adopter une attitude empathique ou objective (<strong>Theory of separate and connected knowing</strong>).<ul>
<li><strong>Un apprenant « détaché »</strong> reste aussi objectif que possible, ne faisant pas intervenir ses émotions et ses sensations. Dans une discussion avec des interlocuteurs d’avis différents, il préfère défendre ses propres idées, cherchant les failles des arguments de son adversaire à l’aide de la logique.</li>
<li><strong>Un apprenant « lié »</strong> est plus empathique. Il est sensible et tend à écouter et poser des questions aux gens jusqu’à ce qu’il sente qu’il peut être en connexion avec eux et comprendre les choses de leur point de vue. Il apprend en essayant de partager les expériences qui conduisent au savoir qu’elle trouve chez les autres.</li></ul>';
$string['servererror'] = 'Une erreur est survenue lors de la communication avec le serveur';
$string['serverlocaltime'] = 'Heure locale du serveur';
$string['sessionforceclean'] = 'Par mesure de sécurité, les scripts générés par les utilisateurs ont été désactivés pour cette session.';
$string['sessiontimeoutsoon'] = 'Votre session est sur le point d’arriver à échéance. Voulez-vous étendre la durée de la session actuelle ?';
$string['setcategorytheme'] = 'Choisir le thème de la catégorie';
$string['setmode'] = 'Régler le mode';
$string['setpassword'] = 'Définir mot de passe';
$string['setpasswordinstructions'] = 'Veuillez saisir votre nouveau mot de passe ci-dessous, puis enregistrer les modifications.';
$string['settings'] = 'Paramètres';
$string['share'] = 'Partager';
$string['shortname'] = 'Nom abrégé';
$string['shortnamecollisionwarning'] = '[*] = Un cours avec ce nom abrégé existe déjà et devra être modifié lors de l’approbation';
$string['shortnamecourse'] = 'Nom abrégé du cours';
$string['shortnamecourse_help'] = 'Le nom affiché dans des zones où la place est limitée. Ce nom doit être unique.';
$string['shortnametaken'] = 'Ce nom abrégé est déjà utilisé pour un autre cours ({$a})';
$string['shortnameuser'] = 'Nom abrégé de l’utilisateur';
$string['shortsitename'] = 'Nom abrégé du site (p. ex. un mot)';
$string['show'] = 'Afficher';
$string['showactions'] = 'Afficher les actions';
$string['showactivitydates'] = 'Afficher les dates de l’activité';
$string['showactivitydates_help'] = 'Afficher les dates des activités sur la page de cours.';
$string['showadvancededitor'] = 'Avancé';
$string['showadvancedsettings'] = 'Afficher les réglages avancés';
$string['showall'] = 'Afficher tous les {$a}';
$string['showallcourses'] = 'Afficher tous les cours';
$string['showallusers'] = 'Afficher tous les utilisateurs';
$string['showblockcourse'] = 'Afficher les cours contenant le bloc';
$string['showcategory'] = 'Afficher {$a}';
$string['showchartdata'] = 'Afficher les données du graphique';
$string['showcomments'] = 'Afficher/cacher les commentaires';
$string['showcommentsnonjs'] = 'Afficher les commentaires';
$string['showdescription'] = 'Afficher la description sur la page de cours';
$string['showdescription_help'] = 'Si ce réglage est activé, la description ci-dessus sera affichée sur la page du cours, juste au-dessous du lien vers l’activité ou la ressource.';
$string['showgrades'] = 'Afficher le carnet de notes aux étudiants';
$string['showgrades_help'] = 'Permet aux étudiants de voir dans leur page de profil une liste de toutes leurs notes.';
$string['showingacourses'] = 'Affichage de tous les {$a} cours';
$string['showingxofycourses'] = 'Affichage des cours {$a->start} à {$a->end} sur un total de {$a->total} cours';
$string['showless'] = 'Montrer moins';
$string['showlistofcourses'] = 'Afficher la liste des cours';
$string['showmodulecourse'] = 'Afficher les cours contenant l’activité';
$string['showmore'] = 'Montrer plus';
$string['showoncoursepage'] = 'Afficher sur la page de cours';
$string['showonly'] = 'Afficher uniquement';
$string['showperpage'] = 'Afficher {$a} par page';
$string['showpopoverwindow'] = 'Afficher la fenêtre surgissante';
$string['showrecent'] = 'Afficher les événements récents';
$string['showreports'] = 'Afficher les rapports d’activités';
$string['showreports_help'] = 'Permet aux étudiants de voir dans leur page de profil leurs propres rapports d’activités.';
$string['showsettings'] = 'Afficher les réglages';
$string['showtheselogs'] = 'Afficher cet journal';
$string['showthishelpinlanguage'] = 'Afficher cette aide dans la langue : {$a}';
$string['sidepanel'] = 'Panneau latéral';
$string['signoutofotherservices'] = 'Déconnecter de toutes les apps web';
$string['signoutofotherservices_help'] = 'Déconnecter de tous les appareils et systèmes qui utilisent des services web, tels que l’App mobile. Les sessions de navigateur restent activent.';
$string['since'] = 'Depuis';
$string['sincelast'] = 'depuis la dernière connexion';
$string['site'] = 'Site';
$string['sitedefault'] = 'Réglages par défaut du site';
$string['sitedefaultspecified'] = 'Réglage par défaut du site ({$a})';
$string['siteerrors'] = 'Erreurs du site';
$string['sitefiles'] = 'Fichiers du site';
$string['sitefilesused'] = 'Fichiers du site utilisés dans ce cours';
$string['sitehome'] = 'Accueil du site';
$string['sitelegacyfiles'] = 'Fichiers de site obsolètes';
$string['sitelogs'] = 'Journaux du site';
$string['sitenews'] = 'Annonces du site';
$string['sitepages'] = 'Pages du site';
$string['sitepartlist'] = 'Vous n’avez pas les permissions requises pour voir la liste des participants';
$string['sitepartlist0'] = 'Vous devez être enseignant du site pour voir la liste des participants du site';
$string['sitepartlist1'] = 'Vous devez être enseignant pour voir la liste des participants';
$string['sites'] = 'Sites';
$string['sitesection'] = 'Ajouter du contenu personnalisé';
$string['sitesettings'] = 'Administration du site';
$string['siteteachers'] = 'Enseignants de la page d’accueil';
$string['size'] = 'Taille';
$string['sizeb'] = 'octets';
$string['sizegb'] = 'Go';
$string['sizekb'] = 'Ko';
$string['sizemb'] = 'Mo';
$string['sizepb'] = 'Po';
$string['sizetb'] = 'To';
$string['skipped'] = 'Sauté';
$string['skiptocategorylisting'] = 'Passer à la liste des catégories';
$string['skiptocoursedetails'] = 'Passer aux informations détaillées des cours';
$string['skiptocourselisting'] = 'Passer à la liste des cours';
$string['socialheadline'] = 'Forum public - derniers sujets';
$string['someallowguest'] = 'Des cours peuvent être ouverts aux visiteurs anonymes';
$string['someerrorswerefound'] = 'Certaines informations manquent ou sont incorrectes. Voir ci-dessous.';
$string['sort'] = 'Trier';
$string['sortby'] = 'Trier par';
$string['sortbyx'] = 'Tri croissant par {$a}';
$string['sortbyxreverse'] = 'Tri décroissant par {$a}';
$string['sorting'] = 'Tri';
$string['sourcerole'] = 'Rôle source';
$string['specifyname'] = 'Vous devez indiquer un nom.';
$string['standard'] = 'Standard';
$string['starpending'] = '([*] = cours en attente d’approbation)';
$string['startdate'] = 'Date de début du cours';
$string['startdate_help'] = 'Cette date détermine le début de la première semaine d’un cours en format hebdomadaire. C’est aussi la date initiale du journal des événements du cours.

Si le cours est réinitialisé et que la date de début est modifiée, toutes les dates du cours seront adaptées relativement à la nouvelle date de début.';
$string['startdatewithtaskenabled'] = 'Date de début du cours';
$string['startdatewithtaskenabled_help'] = 'La date à laquelle le cours est rendu automatiquement visible pour les étudiants. Avant cette date, il ne pourront pas y accéder.

Cette date détermine aussi la date de la première semaine pour un cours en format hebdomadaire, et c’est la date de début des journaux des activités de cours. Lors de la réinitialisation du cours et du changement de cette date, toutes les dates du cours seront décalées en relation avec la nouvelle date de début.';
$string['startingfrom'] = 'À partir de';
$string['startsignup'] = 'Créer un compte';
$string['state'] = 'Canton, département';
$string['statistics'] = 'Statistiques';
$string['statisticsgraph'] = 'Graphique des statistiques';
$string['stats'] = 'Statistiques';
$string['statslogins'] = 'Connexions';
$string['statsmodedetailed'] = 'Vue détaillée';
$string['statsmodegeneral'] = 'Vue d’ensemble';
$string['statsnodata'] = 'Aucune donnée disponible pour ce cours et cette période.';
$string['statsnodatauser'] = 'Aucune donnée disponible pour ce cours, cet utilisateur et cette période.';
$string['statsoff'] = 'Les statistiques ne sont actuellement pas activées';
$string['statsreads'] = 'Consultations';
$string['statsreport1'] = 'Connexions';
$string['statsreport10'] = 'Activités des utilisateurs';
$string['statsreport11'] = 'Cours les plus actifs';
$string['statsreport12'] = 'Cours les plus actifs (pondérés)';
$string['statsreport13'] = 'Cours avec le plus de participation (inscriptions)';
$string['statsreport14'] = 'Cours avec le plus de participation (interactions/consultations)';
$string['statsreport2'] = 'Consultations (tous les rôles)';
$string['statsreport3'] = 'Interactions (tous les rôles)';
$string['statsreport4'] = 'Toutes les activités (tous les rôles)';
$string['statsreport5'] = 'Toutes les activités (consultations et interactions)';
$string['statsreport7'] = 'Activités des utilisateurs (consultations et interactions)';
$string['statsreport8'] = 'Toutes les activités';
$string['statsreport9'] = 'Connexion (cours de site)';
$string['statsreportactivity'] = 'Toutes les activités (tous les rôles)';
$string['statsreportactivitybyrole'] = 'Toutes les activités (consultations et interactions)';
$string['statsreportforuser'] = 'pour';
$string['statsreportlogins'] = 'Connexions';
$string['statsreportreads'] = 'Consultations (tous les rôles)';
$string['statsreporttype'] = 'Type de rapport';
$string['statsreportwrites'] = 'Interactions (tous les rôles)';
$string['statsstudentactivity'] = 'Activité des étudiants';
$string['statsstudentreads'] = 'Consultations des étudiants';
$string['statsstudentwrites'] = 'Interactions des étudiants';
$string['statsteacheractivity'] = 'Activité des enseignants';
$string['statsteacherreads'] = 'Consultations des enseignants';
$string['statsteacherwrites'] = 'Interactions des enseignants';
$string['statstimeperiod'] = 'Période :';
$string['statsuniquelogins'] = 'Connexions distinctes';
$string['statsuseractivity'] = 'Toutes activités';
$string['statsuserlogins'] = 'Connexions';
$string['statsuserreads'] = 'Consultations';
$string['statsuserwrites'] = 'Interactions';
$string['statswrites'] = 'Interactions';
$string['status'] = 'Statut';
$string['statuschecks'] = 'Vérifications du statut';
$string['statuscritical'] = 'Critique';
$string['statusdone'] = 'Terminé';
$string['statuserror'] = 'Erreur';
$string['statusinfo'] = 'Info';
$string['statusna'] = 'N/A';
$string['statusok'] = 'OK';
$string['statusunknown'] = 'Inconnu';
$string['statuswarning'] = 'Avertissement';
$string['stringsnotset'] = 'Les textes suivants ne sont pas définis dans {$a}';
$string['studentnotallowed'] = 'Désolé, mais vous ne pouvez entrer dans ce cours en tant que « {$a} »';
$string['students'] = 'Étudiants';
$string['studentsandteachers'] = 'Étudiants et enseignants';
$string['subcategories'] = 'Sous-catégories';
$string['subcategory'] = 'Sous-catégorie';
$string['subcategoryof'] = 'Sous-catégorie de {$a}';
$string['subject'] = 'Sujet';
$string['submit'] = 'Envoyer';
$string['subsectionmoveerror'] = 'Impossible de déplacer cette sous-section sur une autre sous-section';
$string['success'] = 'Succès';
$string['successduration'] = 'Succès ({$a} secondes)';
$string['summary'] = 'Résumé';
$string['summary_help'] = 'Le résumé de section est un texte assez bref destiné à préparer les étudiants aux activités présentées dans la section (thématique ou hebdomadaire). Le texte est affiché sur la page du cours, au-dessous du titre de la section.';
$string['summaryof'] = 'Résumé de {$a}';
$string['suspended'] = 'Suspendu';
$string['suspendedusers'] = 'Utilisateurs suspendus';
$string['switchdevicedefault'] = 'Passer au thème standard';
$string['switchdevicerecommended'] = 'Passer au thème recommandé pour votre appareil';
$string['switchrolereturn'] = 'Retour à mon rôle normal';
$string['switchroleto'] = 'Prendre le rôle…';
$string['switchroleto_help'] = 'Choisir un rôle pour se faire une idée de l’affichage du cours en ayant ce rôle.

Cette vue ne reflète pas toujours parfaitement ce que verra réellement un utilisateur avec ce rôle (<a href="https://docs.moodle.org/fr/Prendre_le_rôle">plus d’infos ici</a>).';
$string['tag'] = 'Tag';
$string['tagalready'] = 'Ce tag existe déjà';
$string['tagmanagement'] = 'Ajouter/supprimer des tags…';
$string['tags'] = 'Tags';
$string['targetrole'] = 'Rôle cible';
$string['teacheronly'] = 'pour {$a} uniquement';
$string['teacherroles'] = 'Rôles de {$a}';
$string['teachers'] = 'Enseignants';
$string['textcopiedtoclipboard'] = 'Texte copié dans le presse-papier';
$string['textediting'] = 'Éditeur de texte';
$string['textediting_help'] = 'Si un éditeur WYSIWIG est sélectionné, par exemple Atto ou TinyMCE, les zones de texte présenteront une barre d’outils avec des boutons, afin de permettre une saisie simplifiée de contenus.

Si l’option « Zone de texte pur » est sélectionnée, un format peut être choisi pour les zones de texte, par exemple HTML ou Markdown.

La liste des éditeurs de texte est déterminée par l’administrateur de la plateforme.';
$string['texteditor'] = 'Utiliser les formulaires HTML standard';
$string['textellipsis'] = '{$a}…';
$string['textformat'] = 'Format texte';
$string['thanks'] = 'Merci';
$string['theme'] = 'Thème';
$string['themepreviewdescription'] = 'Description du thème {$a}';
$string['themepreviewimage'] = 'Image de prévisualisation {$a}';
$string['themes'] = 'Thèmes';
$string['themesaved'] = 'Nouveau thème enregistré';
$string['therearecourses'] = 'Il y a {$a} cours';
$string['thereareno'] = 'Il n’y a pas de {$a} dans ce cours';
$string['thiscategory'] = 'Cette catégorie';
$string['thiscategorycontains'] = 'Cette catégorie contient';
$string['time'] = 'Heure';
$string['timecreated'] = 'Date et heure de création';
$string['timecreatedcourse'] = 'Date de création du cours';
$string['timesplitting:deciles'] = 'Dernier dixième';
$string['timesplitting:deciles_help'] = 'Cet intervalle d’analyse divise le cours en dixièmes (10 parties égales), dont chaque prédiction est basée uniquement sur les données du précédent dixième.';
$string['timesplitting:decilesaccum'] = 'Tous les dixièmes précédents';
$string['timesplitting:decilesaccum_help'] = 'Cet intervalle d’analyse divise le cours en dixièmes (10 parties égales), dont chaque prédiction est basée sur les données de tous les précédents dixièmes.';
$string['timesplitting:nosplitting'] = 'Pas de limite de temps';
$string['timesplitting:nosplitting_help'] = 'Aucun intervalle d’analyse n’est définie pour ce modèle.';
$string['timesplitting:onemonthafterstart'] = 'Un mois après le début';
$string['timesplitting:onemonthafterstart_help'] = 'Cet intervalle d’analyse génère une prédiction 1 mois après le début de la période d’analyse.';
$string['timesplitting:oneweekafterstart'] = 'Une semaine après le début';
$string['timesplitting:oneweekafterstart_help'] = 'Cet intervalle d’analyse génère une prédiction 1 semaine après le début de la période d’analyse.';
$string['timesplitting:past3days'] = '3 derniers jours';
$string['timesplitting:past3days_help'] = 'Cet intervalle d’analyse génère une prédiction tous les 3 jours. Les calculs d’indicateurs seront basés sur les 3 derniers jours.';
$string['timesplitting:pastmonth'] = 'Mois passé';
$string['timesplitting:pastmonth_help'] = 'Cet intervalle d’analyse génère une prédiction tous les mois. Les calculs d’indicateurs seront basés sur le mois passé.';
$string['timesplitting:pastweek'] = 'Semaine passée';
$string['timesplitting:pastweek_help'] = 'Cet intervalle d’analyse génère une prédiction toutes les semaines. Les calculs d’indicateurs seront basés sur la semaine passée.';
$string['timesplitting:quarters'] = 'Dernier trimestre';
$string['timesplitting:quarters_help'] = 'Cet intervalle d’analyse divise le cours en quarts (4 parties égales), dont chaque prédiction est basée uniquement sur les données du précédent quart.';
$string['timesplitting:quartersaccum'] = 'Tous les trimestres précédents';
$string['timesplitting:quartersaccum_help'] = 'Cet intervalle d’analyse divise le cours en quarts (4 parties égales), dont chaque prédiction est basée sur les données de tous les précédents quarts.';
$string['timesplitting:singlerange'] = 'Du début à la fin';
$string['timesplitting:singlerange_help'] = 'Cet intervalle d’analyse considère la totalité du cours comme une seule entité.';
$string['timesplitting:tenpercentafterstart'] = '10 % après le début';
$string['timesplitting:tenpercentafterstart_help'] = 'Cet intervalle d’analyse génère une prédiction après qu’un dixième du cours est achevé.';
$string['timesplitting:upcoming3days'] = 'Dans les 3 prochains jours';
$string['timesplitting:upcoming3days_help'] = 'Cet intervalle d’analyse génère des prédictions tous les 3 jours. Les calculs des indicateurs seront basés sur les 3 prochains jours.';
$string['timesplitting:upcomingfortnight'] = 'Dans la prochaine quinzaine';
$string['timesplitting:upcomingfortnight_help'] = 'Cet intervalle d’analyse génère des prédictions toutes les quinzaines. Les calculs des indicateurs seront basés sur la prochaine quinzaine.';
$string['timesplitting:upcomingweek'] = 'Dans la semaine prochaine';
$string['timesplitting:upcomingweek_help'] = 'Cet intervalle d’analyse génère des prédictions toutes les semaines. Les calculs des indicateurs seront basés sur la semaine prochaine.';
$string['timezone'] = 'Fuseau horaire';
$string['to'] = 'À';
$string['tocontent'] = 'Vers l’élément « {$a} »';
$string['tocreatenewaccount'] = 'Procédure de création de compte';
$string['todate'] = 'À';
$string['today'] = 'Aujourd’hui';
$string['todaylogs'] = 'Journaux d’aujourd’hui';
$string['toeveryone'] = 'Pour tout le monde';
$string['toggleemojipicker'] = 'Activer/désactiver le sélecteur d’émojis';
$string['togglesearch'] = 'Activer/désactiver la saisie de recherche';
$string['toomanybounces'] = 'Cette adresse de courriel a généré trop de rebonds. Vous <b>devez</b> la changer pour continuer.';
$string['toomanytags'] = 'Cette recherche comprend trop de tags. Certains ont été ignorés.';
$string['toomanytoshow'] = 'Trop d’utilisateurs pour les afficher tous.';
$string['toomanyusersmatchsearch'] = 'Trop d’utilisateurs ({$a->count}) correspondent à « {$a->search} »';
$string['toomanyuserstoshow'] = 'Trop d’utilisateurs ({$a}) à afficher';
$string['toonly'] = 'Seulement pour les {$a}';
$string['top'] = 'Niveau supérieur';
$string['topic'] = 'Section';
$string['topichide'] = 'Cacher cette section pour {$a}';
$string['topicoutline'] = 'Aperçu des sections';
$string['topicshow'] = 'Afficher cette section pour {$a}';
$string['toplevelcategory'] = 'Catégorie racine';
$string['torecipient'] = 'À';
$string['total'] = 'Total';
$string['totopofsection'] = 'En haut de la section « {$a} »';
$string['trackforums'] = 'Suivi des messages de forum';
$string['trackforumsno'] = 'Non, ne pas signaler les messages non lus';
$string['trackforumsyes'] = 'Oui, me signaler les nouveaux messages';
$string['trysearching'] = 'Essayez plutôt la recherche.';
$string['turneditingoff'] = 'Quitter le mode édition';
$string['turneditingon'] = 'Activer le mode édition';
$string['unabletocopytoclipboard'] = 'Impossible de copier le texte dans le presse-papier';
$string['unauthorisedlogin'] = 'Le compte utilisateur « {$a} » n’est pas disponible sur ce site';
$string['undecided'] = 'Pas d’avis';
$string['unexistingcmid'] = 'ID de module de cours introuvable';
$string['unexistingsectionid'] = 'ID de section de cours introuvable';
$string['unfinished'] = 'Pas terminé';
$string['unknowncategory'] = 'Catégorie de cours inconnue';
$string['unknownerror'] = 'Erreur inconnue';
$string['unknownuser'] = 'Utilisateur inconnu';
$string['unlimited'] = 'Illimité';
$string['unpacking'] = 'Décompactage de {$a}';
$string['unsafepassword'] = 'Ce mot de passe n’est pas sûr. Essayez-en un autre.';
$string['untilcomplete'] = 'Jusqu’à la fin du traitement';
$string['unusedaccounts'] = 'Les comptes qui n’ont pas été utilisés depuis {$a} jours sont automatiquement désinscrits.';
$string['unzip'] = 'Décompacter (zip)';
$string['unzippingbackup'] = 'Décompactage (zip) de la sauvegarde';
$string['up'] = 'Vers le haut';
$string['update'] = 'Modifier';
$string['updated'] = '{$a} modifié(e)';
$string['updatemymoodleoff'] = 'Quitter le mode édition';
$string['updatemymoodleon'] = 'Modifier cette page';
$string['updatemyprofile'] = 'Enregistrer le profil';
$string['updatesevery'] = 'Mise à jour toutes les {$a} secondes';
$string['updatethis'] = 'Modifier {$a}';
$string['updatethiscourse'] = 'Modifier ce cours';
$string['updatinga'] = 'Modification {$a}';
$string['updatingain'] = 'Modification {$a->what} dans {$a->in}';
$string['upload'] = 'Déposer';
$string['uploadafile'] = 'Déposer un fichier';
$string['uploadcantwrite'] = 'Échec de l’écriture du fichier';
$string['uploadedfile'] = 'Le fichier a été déposé avec succès';
$string['uploadedfileto'] = 'Le fichier « {$a->file} » a été déposé dans le dossier « {$a->directory} »';
$string['uploadedfiletoobig'] = 'Ce fichier dépasse la taille maximale (fixée à {$a} octets)';
$string['uploadextension'] = 'Dépôt du fichier arrêté par une extension PHP';
$string['uploadfailednotrecovering'] = 'Le dépôt de votre fichier a échoué car un des fichiers, {$a->name}, a posé problème.<br />Voici une liste des problèmes rencontrés :<br />{$a->problem}<br />Impossible de rattraper l’erreur.';
$string['uploadfilelog'] = 'Journal du dépôt du fichier {$a}';
$string['uploadformlimit'] = 'La taille du fichier déposé {$a} dépasse la limite fixée par le formulaire';
$string['uploadlabel'] = 'Titre :';
$string['uploadlimitwithsize'] = 'Taille limite de dépôt {$a->contextname} ({$a->displaysize})';
$string['uploadnewfile'] = 'Déposer un fichier';
$string['uploadnofilefound'] = 'Aucun fichier trouvé. En avez-vous vraiment choisi un à déposer ?';
$string['uploadnotallowed'] = 'Il n’est pas permis de déposer des fichiers';
$string['uploadnotempdir'] = 'Dossier temporaire manquant';
$string['uploadoldfilesdeleted'] = 'Les anciens fichiers de votre zone de dépôt ont été supprimés';
$string['uploadpartialfile'] = 'Le fichier n’a été que partiellement transféré';
$string['uploadproblem'] = 'Un problème inconnu est survenu lors du dépôt du fichier « {$a} » (peut-être est-il trop gros ?)';
$string['uploadrenamedchars'] = 'Le nom du fichier a été changé de {$a->oldname} à {$a->newname} à cause de caractères non valides.';
$string['uploadrenamedcollision'] = 'Le nom du fichier a été changé de {$a->oldname} à {$a->newname} en raison d’un conflit de nom.';
$string['uploadserverlimit'] = 'La taille du fichier déposé dépasse la taille maximale fixée par le serveur';
$string['uploadthisfile'] = 'Déposer ce fichier';
$string['url'] = 'URL';
$string['used'] = 'Utilisé';
$string['usedinnplaces'] = 'Utilisé à {$a} endroits';
$string['user'] = 'Utilisateur';
$string['useraccount'] = 'Compte utilisateur';
$string['useractivity'] = 'Activité';
$string['userconfirmed'] = 'L’utilisateur {$a} a été confirmé';
$string['userdata'] = 'Données utilisateurs';
$string['userdeleted'] = 'Le compte de cet utilisateur a été supprimé';
$string['userdescription'] = 'Description';
$string['userdescription_help'] = 'Ce champ vous permet d’écrire quelques mots sur vous-même. Le texte sera affiché sur votre page de profil.';
$string['userdetails'] = 'Informations détaillées';
$string['userfiles'] = 'Fichiers utilisateur';
$string['userlist'] = 'Liste des utilisateurs';
$string['usermatchedon'] = 'Cet utilisateur correspond à la recherche par ce champ';
$string['usermenu'] = 'Menu utilisateur';
$string['usermenugoback'] = 'Retour au menu utilisateur';
$string['username'] = 'Nom d’utilisateur';
$string['usernameemail'] = 'Nom d’utilisateur ou courriel';
$string['usernameemailmatch'] = 'Le nom d’utilisateur et l’adresse de courriel données ne correspondent pas au même utilisateur';
$string['usernameexists'] = 'Ce nom d’utilisateur existe déjà, veuillez en choisir un autre';
$string['usernamelowercase'] = 'Seules les minuscules sont autorisées';
$string['usernamenotfound'] = 'Ce nom d’utilisateur n’a pas été trouvé dans la base de données';
$string['usernameoremail'] = 'Veuillez indiquer soit le nom d’utilisateur, soit l’adresse de courriel';
$string['usernotconfirmed'] = 'L’utilisateur {$a} n’a pas pu être confirmé';
$string['userpic'] = 'Image de l’utilisateur';
$string['userpreferences'] = 'Préférences utilisateur';
$string['users'] = 'Utilisateurs';
$string['userselectorautoselectunique'] = 'Si un seul utilisateur correspond à la recherche, le sélectionner automatiquement';
$string['userselectorpreserveselected'] = 'Conserver les utilisateurs sélectionnés, même s’ils ne correspondent plus à la recherche';
$string['userselectorsearchanywhere'] = 'n’importe où';
$string['userselectorsearchexactmatchonly'] = 'seulement correspondances exactes';
$string['userselectorsearchfromstart'] = 'depuis le début';
$string['userselectorsearchmatching'] = 'Correspondance :';
$string['usersnew'] = 'Nouveaux utilisateurs';
$string['usersnoaccesssince'] = 'Inactifs depuis plus de';
$string['userswithfiles'] = 'Utilisateurs avec fichiers';
$string['useruploadtype'] = 'Type de téléchargement d’utilisateurs : {$a}';
$string['userzones'] = 'Zones de l’utilisateur';
$string['usetheme'] = 'Utiliser le thème';
$string['usingexistingcourse'] = 'Avec un cours existant';
$string['validatehtml'] = 'Valider HTML';
$string['valuealreadyused'] = 'Cette valeur est déjà utilisée.';
$string['version'] = 'Version';
$string['view'] = 'Afficher';
$string['viewallcourses'] = 'Afficher tous les cours';
$string['viewallcoursescategories'] = 'Afficher tous les cours et catégories';
$string['viewallresults'] = 'Voir tous les résultats ({$a})';
$string['viewallsubcategories'] = 'Voir toutes les sous-catégories';
$string['viewfileinpopup'] = 'Afficher dans une fenêtre surgissante';
$string['viewing'] = 'Affichage :';
$string['viewmore'] = 'Voir plus';
$string['viewprofile'] = 'Consulter le profil';
$string['viewresults'] = 'Voir les résultats pour {$a}';
$string['views'] = 'Affichages';
$string['viewsolution'] = 'Afficher la solution';
$string['visible'] = 'Visible';
$string['visible_help'] = 'Cette option détermine si le cours apparaît ou non dans la liste des cours. Si le cours n’est pas disponible, seuls les enseignants de ce cours et les administrateurs peuvent y entrer.';
$string['visibletostudents'] = 'Visible pour les étudiants';
$string['warning'] = 'Avertissement';
$string['warningdeleteresource'] = 'Attention ! {$a} est référencé dans une ressource. Voulez-vous mettre à jour la ressource ?';
$string['wcagcheck'] = 'Vérification Web Content Accessibility Guidelines (WCAG)';
$string['webpage'] = 'Page Web';
$string['week'] = 'Semaine';
$string['weekhide'] = 'Cacher cette semaine pour {$a}';
$string['weeklyoutline'] = 'Aperçu des semaines';
$string['weeks'] = 'semaines';
$string['weekshow'] = 'Afficher cette semaine pour {$a}';
$string['welcomeback'] = 'Bonjour {$a->firstname} ! 👋';
$string['welcometocourse'] = 'Bienvenue sur {$a}';
$string['welcometocoursetext'] = 'Bienvenue au cours « {$a->coursename} » !

Si vous ne l’avez pas encore fait, vous devriez compléter votre page de profil :

<a href="{$a->profileurl}">{$a->profileurl}<a>';
$string['welcometosite'] = 'Bienvenue, {$a->firstname} ! 👋';
$string['whatforlink'] = 'Que voulez-vous faire avec ce lien ?';
$string['whatforpage'] = 'Que voulez-vous faire avec ce texte ?';
$string['whatisyourage'] = 'Quel âge avez-vous ?';
$string['whattocallzip'] = 'Quel nom voulez-vous donner au fichier compacté (zip) ?';
$string['whattodo'] = 'Action à effectuer';
$string['wheredoyoulive'] = 'Dans quel pays vivez-vous ?';
$string['whyisthisrequired'] = 'Pourquoi ceci est nécessaire ?';
$string['windowclosing'] = 'Cette fenêtre se fermera automatiquement. Sinon, fermez-la maintenant.';
$string['withchosenfiles'] = 'Avec les fichiers choisis';
$string['withdisablednote'] = '{$a} (désactivé)';
$string['withoutuserdata'] = 'sans les données des utilisateurs';
$string['withselectedusers'] = 'Pour les utilisateurs sélectionnés…';
$string['withuserdata'] = 'avec les données des utilisateurs';
$string['wontrunfuturescheduledtask'] = 'Une tâche qui n’est pas en échec et qui n’est pas programmée avec une date dans le futur n’est pas lancée';
$string['wordforstudent'] = 'Votre terme pour « étudiant »';
$string['wordforstudenteg'] = 'exemples : étudiant, apprenti, participant…';
$string['wordforstudents'] = 'Votre terme pour « étudiants »';
$string['wordforstudentseg'] = 'exemples : étudiants, apprentis, participants…';
$string['wordforteacher'] = 'Votre terme pour « enseignant »';
$string['wordforteachereg'] = 'exemples : enseignant, professeur, gourou…';
$string['wordforteachers'] = 'Votre terme pour « enseignants »';
$string['wordforteacherseg'] = 'exemples : enseignants, professeurs, gourous…';
$string['writingblogsinfo'] = 'Écriture des informations de blogs';
$string['writingcategoriesandquestions'] = 'Écriture des catégories et questions';
$string['writingcoursedata'] = 'Écriture des données du cours';
$string['writingeventsinfo'] = 'Écriture du calendrier';
$string['writinggeneralinfo'] = 'Écriture des informations générales';
$string['writinggradebookinfo'] = 'Écriture des carnets de notes';
$string['writinggroupingsgroupsinfo'] = 'Écriture des infos groupements-groupes';
$string['writinggroupingsinfo'] = 'Écriture des groupements';
$string['writinggroupsinfo'] = 'Écriture des groupes';
$string['writingheader'] = 'Écriture de l’en-tête';
$string['writingloginfo'] = 'Écriture des journaux';
$string['writingmessagesinfo'] = 'Écriture des informations des messages';
$string['writingmoduleinfo'] = 'Écriture des modules';
$string['writingscalesinfo'] = 'Écriture des barèmes';
$string['writinguserinfo'] = 'Écriture des utilisateurs';
$string['wrongpassword'] = 'Mot de passe incorrect pour cet utilisateur';
$string['year'] = 'an';
$string['years'] = 'ans';
$string['yes'] = 'Oui';
$string['youareabouttocreatezip'] = 'Vous allez créer un fichier compacté (zip) contenant';
$string['youaregoingtorestorefrom'] = 'Vous allez restaurer depuis';
$string['youhaveupcomingactivitiesdue'] = 'Vous avez des activités à venir à effectuer';
$string['youhaveupcomingactivitiesdueinfo'] = 'Bonjour {$a},

<br/><br/>Vous devez effectuer des activités :';
$string['youneedtoenrol'] = 'Vous devez vous inscrire à ce cours pour effectuer cette action.';
$string['yourlastlogin'] = 'Votre dernière connexion';
$string['yourself'] = 'vous';
$string['yourteacher'] = 'votre {$a}';
$string['yourwordforx'] = 'Votre terme pour « {$a} »';
$string['zippingbackup'] = 'Compactage (zip) de la sauvegarde';
