<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'enrol_ldap', language 'mn', version '4.5'.
 *
 * @package     enrol_ldap
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['assignrole'] = '\'{$a->course_shortname}\' (id {$a->course_id}) хичээлд \'{$a->user_username}\' хэрэглэгчид \'{$a->role_shortname}\' үүрэг оноох';
$string['assignrolefailed'] = '\'{$a->course_shortname}\' (id {$a->course_id}) хичээлд \'{$a->user_username}\' хэрэглэгчид \'{$a->role_shortname}\' үүрэг оноох үйлдэл ажилтгүй боллоо';
$string['autocreate'] = '<p>Хэрэв автоматаар хичээл үүсгэх үйлдлийг ашиглаж байгаа бол Moodle системд бүртгэлгүй хичээлд элсэлт хийвэл хичээл автоматаар үүсэх боломжтой.</p><p>Энэ тохиолдолд дээр дурдсан дөрвөн хичээлийн талбарт (ID дугаар, товч нэр, бүтэн нэр болон хураангуй) өөрчлөлт оруулахаас урьдчилан сэргийлэхийн тулд холбогдох үүргүүдээс дараах боломжуудыг хасахыг зөвлөж байна: moodle/course:changeidnumber, moodle/course:changeshortname, moodle/course:changefullname болон moodle/course:changesummary.</p>';
$string['autocreate_key'] = 'Автоматаар үүсгэх';
$string['autocreation_settings'] = 'Автоматаар хичээл үүсгэх тохиргоо';
$string['autoupdate_settings'] = 'Автоматаар хичээлийг шинэчлэх тохиргоо';
$string['autoupdate_settings_desc'] = '<p>\'LDAP элсэлтийг синхрончлох\' төлөвлөсөн даалгаврыг ажиллуулж байхад шинэчлэх талбарыг сонгох</p><p>Дор хаяж нэг талбар сонгосон тохиолдолд шинэчлэлийг хийнэ.</p>';
$string['bind_dn'] = 'Хэрвээ хэрэглэгчдийг хайхдаа холбогдсон-хэрэглэгчийг ашиглахыг хүсвэл энд тодорхойлно уу. \'cn=ldapuser,ou=public,o=org\' гэх мэтээр';
$string['bind_dn_key'] = 'Холбогдсон-хэрэглэгчийн ялгагдах нэр';
$string['bind_pw'] = 'Холбогдсон-хэрэглэгчийн нууц үг';
$string['bind_pw_key'] = 'Нууц үг';
$string['bind_settings'] = 'Холбох тохиргоо';
$string['cannotcreatecourse'] = 'Хичээлийг үүсгэх боломжгүй байна: LDAP бичлэгээс шаардлагатай өгөгдөл дутуу байна!';
$string['cannotupdatecourse'] = 'Хичээлийг шинэчлэх боломжгүй байна: LDAP бичлэгээс шаардлагатай өгөгдөл дутуу байна! Хичээлийн ID дугаар: \'{$a->idnumber}\'';
$string['cannotupdatecourse_duplicateshortname'] = 'Хичээлийг шинэчлэх боломжгүй байна: Товч нэр давхардсан байна. \'{$a->idnumber}\' ID дугаартай хичээлийг алгасаж байна ...';
$string['category'] = 'Автоматаар үүсгэсэн хичээлийн ангилал';
$string['category_key'] = 'Ангилал';
$string['contexts'] = 'LDAP хамрах хүрээ';
$string['couldnotfinduser'] = '\'{$a}\' хэрэглэгч олдсонгүй, алгасаж байна';
$string['course_fullname'] = 'Сонголт: Бүтэн нэр авах LDAP атрибут';
$string['course_fullname_key'] = 'Бүтэн нэр';
$string['course_fullname_updateonsync'] = 'Синхрончлох скриптийн үед бүтэн нэрийг шинэчлэх';
$string['course_fullname_updateonsync_key'] = 'Бүтэн нэрийг шинэчлэх';
$string['course_idnumber'] = 'Хичээлийн ID дугаарыг авах LDAP атрибут. Ихэвчлэн \'cn\' эсвэл \'uid\'.';
$string['course_idnumber_key'] = 'ID дугаар';
$string['course_search_sub'] = 'Дэд хамрах хүрээнээс бүлгийн гишүүнчлэл хайх';
$string['course_search_sub_key'] = 'Дэд хамрах хүрээ хайх';
$string['course_settings'] = 'Хичээлийн элсэлтийн тохиргоо';
$string['course_shortname'] = 'Сонголт: Товч нэр авах LDAP атрибут';
$string['course_shortname_key'] = 'Товч нэр';
$string['course_shortname_updateonsync'] = 'Синхрончлох скриптийн үед товч нэрийг шинэчлэх';
$string['course_shortname_updateonsync_key'] = 'Товч нэрийг шинэчлэх';
$string['course_summary'] = 'Сонголт: Хураангуй авах LDAP атрибут';
$string['course_summary_key'] = 'Хураангуй';
$string['course_summary_updateonsync'] = 'Синхрончлох скриптийн үед хураангуйг шинэчлэх';
$string['course_summary_updateonsync_key'] = 'Хураангуйг шинэчлэх';
$string['coursenotexistskip'] = '\'{$a}\' хичээл үүсээгүй бөгөөд автоматаар үүсгэхийг идэвхгүй болгосон тул алгасаж байна';
$string['courseupdated'] = '\'{$a->idnumber}\' ID дугаартай хичээлийг амжилттай шинэчиллээ.';
$string['courseupdateskipped'] = '\'{$a->idnumber}\' ID дугаартай хичээлийг шинэчлэх шаардлагагүй. Алгасаж байна ...';
$string['createcourseextid'] = '\'{$a->courseextid}\' дугаартай үүсээгүй хичээлд элссэн хэрэглэгч ҮҮСГЭХ';
$string['createnotcourseextid'] = '\'{$a->courseextid}\' дугаартай үүсээгүй хичээлд хэрэглэгч элссэн';
$string['creatingcourse'] = '\'{$a}\' хичээлийг үүсгэж байна ...';
$string['duplicateshortname'] = 'Хичээлийг үүсгэх үйлдэл амжилтгүй боллоо. Товч нэр давхардсан байна. \'{$a->idnumber}\' ID дугаартай хичээлийг алгасаж байна...';
$string['editlock'] = 'Утгыг цоожлох';
$string['emptyenrolment'] = '\'{$a->course_shortname}\' хичээлд \'{$a->role_shortname}\' үүрэгтэй хоосон элсэлт';
$string['enrolname'] = 'LDAP';
$string['enroluser'] = '\'{$a->course_shortname}\' (id {$a->course_id}) хичээлд \'{$a->user_username}\' хэрэглэгч элсэх';
$string['enroluserenable'] = '\'{$a->course_shortname}\' (id {$a->course_id}) хичээлд \'{$a->user_username}\' хэрэглэгчийн элсэлтийн идэвхжүүлсэн';
$string['explodegroupusertypenotsupported'] = 'ldap_explode_group() нь сонгогдсон хэрэглэгчийн төрлийг дэмжихгүй байна: {$a}';
$string['extcourseidinvalid'] = 'Хичээлийн гадаад ID буруу байна!';
$string['extremovedsuspend'] = '\'{$a->course_shortname}\' (id {$a->course_id}) хичээлд \'{$a->user_username}\' хэрэглэгчийн элсэлтийн идэвхгүй болгосон';
$string['extremovedsuspendnoroles'] = '\'{$a->course_shortname}\' (id {$a->course_id}) хичээлд \'{$a->user_username}\' хэрэглэгчийн элсэлтийг идэвхгүй болгож үүргийг хассан';
$string['extremovedunenrol'] = '\'{$a->course_shortname}\' (id {$a->course_id}) хичээлээс \'{$a->user_username}\' хэрэглэгчийг хассан';
$string['failed'] = 'Амжилтгүй боллоо!';
$string['general_options'] = 'Ерөнхий тохиргоо';
$string['group_memberofattribute'] = 'Тухайн хэрэглэгч эсвэл бүлэг аль бүлэгт хамаарахыг тодорхойлсон атрибутын нэр (жишээ нь: memberOf, groupMembership гэх мэт)';
$string['group_memberofattribute_key'] = '\'Member of\' атрибут';
$string['host_url'] = 'LDAP хостыг \'ldap://ldap.myorg.com/\'
эсвэл \'ldaps://ldap.myorg.com/\' шиг URL хэлбэртэйгээр тодорхойлох';
$string['host_url_key'] = 'Хостын URL';
$string['idnumber_attribute'] = 'Бүлгийн гишүүнчлэл нь ялгагдах нэр агуулсан бол LDAP баталгаажуулалтын тохиргоонд хэрэглэгчийн \'ID Number\' дугаарыг тохируулах харгалзах атрибутыг зааж өгнө үү.';
$string['idnumber_attribute_key'] = 'ID дугаар атрибут';
$string['ldap:manage'] = 'LDAP элсэлтийн тохиолдлыг удирдах';
$string['ldap_encoding'] = 'LDAP серверийн ашигладаг шифрлэлтийг зааж өгнө үү. Магадгүй utf-8, MS AD v2 нь cp1252, cp1250 гэх мэт өгөгдмөл платформ шифрлэлтийг ашигладаг.';
$string['ldap_encoding_key'] = 'LDAP шифрлэлт';
$string['memberattribute'] = 'LDAP гишүүн атрибут';
$string['memberattribute_isdn'] = 'Бүлгийн гишүүнчлэл нь ялгагдах нэр агуулсан бол тэдгээрийг энд зааж өгөх хэрэгтэй. Хэрэв тийм бол та энэ хэсэгт байгаа үлдсэн тохиргоог мөн тохируулах хэрэгтэй.';
$string['memberattribute_isdn_key'] = 'dn ашигладаг гишүүн атрибут';
$string['nested_groups'] = 'Та элсэлтэд дэд бүлэг (бүлэг доторх бүлэг) ашигламаар байна уу?';
$string['nested_groups_key'] = 'Дэд бүлэг';
$string['nested_groups_settings'] = 'Дэд бүлгийн тохиргоо';
$string['nosuchrole'] = '\'{$a}\' үүрэг байхгүй байна';
$string['objectclass'] = 'objectClass атрибутыг хичээл хайхад ашиглана. Ихэвчлэн \'group\' эсвэл \'posixGroup\' байна.';
$string['objectclass_key'] = 'Объект класс';
$string['ok'] = 'OK!';
$string['opt_deref'] = 'Бүлгийн гишүүнчлэл нь ялгагдах нэр агуулсан бол хайлтын үед зохиомол нэрсийг хэрхэн зохицуулахыг зааж өгнө үү. Дараах утгуудаас нэгийг сонгоно: \'No\' (LDAP_DEREF_NEVER) эсвэл\'Yes\' (LDAP_DEREF_ALWAYS).';
$string['opt_deref_key'] = 'Эш татаагүй зохиомол нэр';
$string['phpldap_noextension'] = 'PHP LPAD модуль байхгүй бололтой. Хэрэв та энэ элсэлтийн нэмэлт хэрэгслийг ашиглахыг хүсвэл үүнийг суулгаж, идэвхжүүлсэн эсэхийг шалгана уу.';
$string['pluginname'] = 'LDAP элсэлт';
$string['pluginname_desc'] = '<p>Та өөрийн элсэлтээ хянахын тулд LDAP серверийг ашиглах боломжтой. LDAP нь хичээлд холбоотой бүлгүүдийг агуулсан мод хэлбэртэй бөгөөд тэдгээр хичээл/бүлгүүдэд бүртгүүлсэн суралцагчийн гишүүнчлэлтэй. </p><p>Хичээл нь LDAP дахь бүлэг байдлаар тодорхойлогдсон бөгөөд бүлэг бүр нь хэрэглэгчийг танихад зориулсан хэд хэдэн гишүүнчлэлийн талбаруудтай (<em>member</em> эсвэл <em>memberUid</em>). </p> <p>LDAP элсэлтийг ашиглахын тулд таны хэрэглэгчид хүчинтэй idnumber талбартай байх <strong>ёстой</strong>. LDAP бүлгүүд тухайн хэрэглэгчийг хичээлд элсүүлэхийн тулд гишүүн талбарт idnumber байх ёстой. Хэрвээ та хэдийн LDAP баталгаажуулалтыг ашиглаж байгаа бол энэ нь ихэвчлэн сайн ажиллана. </p><p>Хэрэглэгч нэвтрэхэд элсэлт шинэчлэгдэх болно. Элсэлтийг синхрончлохын тулд скрипт ажиллуулж болно. <em>enrol/ldap/enrol_ldap_sync.php</em> файлаас үзнэ үү. </p> <p>Энэ нэмэлт хэрэгслийг LDAP дээр шинэ бүлэг үүсэхэд шинэ хичээлийг автоматаар үүсгэдэг байхаар тохируулж болно.</p>';
$string['pluginnotenabled'] = 'Нэмэлт хэрэгслийг идэвхжүүлээгүй байна!';
$string['privacy:metadata'] = 'LDAP элсэлтийн нэмэлт хэрэгсэл нь хувийн өгөгдөл хадгалдаггүй.';
$string['role_mapping'] = '<p>Үүрэг тус бүрийн хувьд хичээлийн бүлгүүд байрлах бүх LDAP хамрах хүрээг тодорхойлж өгөх хэрэгтэй. Ялгаатай хамрах хүрээг цэгтэй таслал (;)-аар тусгаарлана.</p><p>Мөн бүлгийн гишүүдийг хадгалахын тулд LDAP серверт ашиглах атрибутыг зааж өгөх хэрэгтэй. Энэ нь ихэвчлэн \'member\' эсвэл \'memberUid\' байна.</p>';
$string['role_mapping_attribute'] = '{$a} зориулсан LDAP гишүүн атрибут';
$string['role_mapping_context'] = '{$a} зориулсан LDAP хамрах хүрээ';
$string['role_mapping_key'] = 'LDAP-ийн үүргийн дүрслэл';
$string['roles'] = 'Үүрэг харгалзуулан тохируулах';
$string['server_settings'] = 'LDAP серверийн тохиргоо';
$string['synccourserole'] = '== \'{$a->idnumber}\' хичээлд \'{$a->role_shortname}\' үүргийг синхрончилж байна';
$string['syncenrolmentstask'] = 'LDAP элсэлтийг синхрончлох';
$string['template'] = 'Сонголт: Загвар хичээлийн тохиргоог автоматаар үүсгэсэн хичээлд хуулбарлах';
$string['template_key'] = 'Загвар';
$string['unassignrole'] = '\'{$a->course_shortname}\' (id {$a->course_id}) хичээлийн \'{$a->user_username}\' хэрэглэгчийн  \'{$a->role_shortname}\' үүргийг хасах';
$string['unassignrolefailed'] = '\'{$a->course_shortname}\' (id {$a->course_id}) хичээлийн \'{$a->user_username}\' хэрэглэгчийн  \'{$a->role_shortname}\' үүргийг хасахад алдаа гарлаа';
$string['unassignroleid'] = '\'{$a->user_id}\' дугаартай хэрэглэгчийн \'{$a->role_id}\' дугаартай үүргийг хасах';
$string['updatelocal'] = 'Дотоод өгөгдөл шинэчлэх';
$string['user_attribute'] = 'Бүлгийн гишүүнчлэл нь ялгагдах нэрийг агуулж байгаа бол хэрэглэгчийг нэрлэх/хайх атрибутыг зааж өгнө үү. Хэрэв LDAP баталгаажуулалтыг ашиглаж байгаа бол энэ утга нь LDAP баталгаажуулалтын нэмэлт хэрэгслийн"ID Number" -д тодорхойлсон атрибуттай харгалзан тохирч байх ёстой.';
$string['user_attribute_key'] = 'ID дугаар атрибут';
$string['user_contexts'] = 'Бүлгийн гишүүнчлэл нь ялгагдах нэрийг агуулж байгаа бол хэрэглэгчийн байрлаж буй хамрах хүрээний жагсаалтыг зааж өгнө үү. Ялгаатай хамрах хүрээг цэгтэй таслал (;)-аар тусгаарлаж өгнө. Жишээлбэл: \'ou=users,o=org; ou=others,o=org\'.';
$string['user_contexts_key'] = 'Хамрах хүрээ';
$string['user_search_sub'] = 'Бүлгийн гишүүнчлэл нь ялгагдах нэрийг агуулж байгаа бол хэрэглэгчийн хайлтыг дэд хамрах хүрээгээр хийх эсэхийг зааж өгнө үү.';
$string['user_search_sub_key'] = 'Дэд хамрах хүрээгээр хайх';
$string['user_settings'] = 'Хэрэглэгч хайх тохиргоо';
$string['user_type'] = 'Бүлгийн гишүүнчлэл нь ялгагдах нэрийг агуулж байгаа бол хэрэглэгчийг LDAP серверт хэрхэн хадгалахыг зааж өгнө үү';
$string['user_type_key'] = 'Хэрэглэгчийн төрөл';
$string['version'] = 'Таны серверийн хэрэглэж байгаа LDAP протоколын хувилбар';
$string['version_key'] = 'Хувилбар';
