<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'auth_shibboleth', language 'mn', version '4.5'.
 *
 * @package     auth_shibboleth
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['auth_shib_auth_logo'] = 'Баталгаажуулах аргын лого';
$string['auth_shib_auth_logo_description'] = 'Хэрэглэгчийг танил болсон Shibboleth баталгаажуулалтын аргын логог ашиглана. Энэ нь Shibboleth холбооны лого байж болно. Жишээ нь. <tt>SWITCHaai Нэвтрэх</tt> эсвэл <tt>InCommon Нэвтрэх</tt> эсвэл үүнтэй төстэй байж болно.';
$string['auth_shib_auth_method'] = 'Баталгаажуулах аргын нэр';
$string['auth_shib_auth_method_description'] = 'Хэрэглэгчийг танил болсон Shibboleth баталгаажуулалтын аргын нэрийг ашиглана. Энэ нь Shibboleth холбооны нэр байж болно. Жишээ нь. <tt>SWITCHaai Нэвтрэх</tt> эсвэл <tt>InCommon Нэвтрэх</tt> эсвэл үүнтэй төстэй байж болно.';
$string['auth_shib_changepasswordurl'] = 'Нууц үг солих URL хаяг';
$string['auth_shib_contact_administrator'] = 'Хэрэв та тухайн байгууллагатай холбоогүй бөгөөд энэ сервер дээрх хичээлд хандах шаардлагатай бол <a href="mailto:{$a}">Moodle администратор</a>-тай холбогдоно уу.';
$string['auth_shib_convert_data'] = 'Өгөгдлийн өөрчлөлтийн API';
$string['auth_shib_convert_data_description'] = 'Та Shibboleth аргаар гаргасан өгөгдлийг цаашид өөрчлөхийн тулд энэ API-г ашиглаж болно. Нэмэлт зааврыг <a href="{$a}">README</a> файлаас авна уу.';
$string['auth_shib_convert_data_filepath_warning'] = 'Та уг сайтын өгөгдлийн лавлах ($CFG->dataroot) дотор байгаа файлыг өгөгдлийн өөрчлөлтийн API болгон ашиглах боломжгүй.';
$string['auth_shib_convert_data_warning'] = 'Энэ файл байхгүй эсвэл веб сервер унших боломжгүй байна!';
$string['auth_shib_idp_list'] = 'Таниулах үйлчилгээ үзүүлэгч';
$string['auth_shib_idp_list_description'] = 'Нэвтрэх хуудаснаас хэрэглэгчийг сонгох боломжийг олгох Identity Provider entityID жагсаалтыг гаргана.<br />Мөр бүрд IdP-ийн entityID (Shibboleth мета өгөгдлийн файлыг харна уу) болон IdP-ийн нэрийг таслалаар тусгаарласан байх ёстой. Энэ нь нээгдэх жагсаалтад харагдах болно.<br />Нэмэлт гуравдагч параметр болгон Moodle суулгац нь олон холбооны тохиргооны нэг хэсэг байх тохиолдолд Shibboleth сейшн эхлүүлэгчийн байршлыг нэмэх боломжтой.';
$string['auth_shib_instructions'] = 'Танай байгууллага дэмждэг тохиолдолд <a href="{$a}">Shibboleth нэвтрэлт</a> ашиглан Shibboleth аргаар дамжуулан нэвтэрч болно. Эсрэг тохиолдолд энд үзүүлсэн ердийн нэвтрэх маягтыг ашиглана.';
$string['auth_shib_instructions_help'] = 'Энд хэрэглэгчид Shibboleth аргыг тайлбарлах тусгай зааврыг оруулах хэрэгтэй. Энэ нь зааврын хэсэгт нэвтрэх хуудсанд харагдах болно. Зааварт хэрэглэгч нэвтрэхийг хүссэн үедээ дарах "<b>{$a}</b>" холбоосыг агуулсан байх ёстой.';
$string['auth_shib_instructions_key'] = 'Нэвтрэх заавар';
$string['auth_shib_integrated_wayf'] = 'Moodle WAYF сервис';
$string['auth_shib_integrated_wayf_description'] = 'Идэвхжүүлсэн тохиолдолд Moodle нь Shibboleth аргад тохируулсан сервисийн оронд өөрийн WAYF сервисийг ашиглах болно. Moodle өөр нэвтрэх хуудсанд нээгдэх жагсаалтыг гаргах бөгөөд хэрэглэгч өөрийн таниулах үйлчилгээ үзүүлэгчийг сонгох ёстой.';
$string['auth_shib_logout_return_url'] = 'Гарах өөр URL хаяг буцаах';
$string['auth_shib_logout_return_url_description'] = 'Shibboleth хэрэглэгчийг гарсны дараа дахин чиглүүлэх URL хаягийг оруулна.<br />Хоосон орхисон тохиолдолд хэрэглэгчийг Moodle хэрэглэгчийг дахин чиглүүлдэг байршилд дахин чиглүүлэх болно.';
$string['auth_shib_logout_url'] = 'Shibboleth үйлчилгээ үзүүлэгчээс гарах зохицуулагчийн URL хаяг';
$string['auth_shib_logout_url_description'] = 'Shibboleth үйлчилгээ үзүүлэгчээс гарах зохицуулагчид URL хаягийг оруулна. Энэ нь гол төлөв <tt>/Shibboleth.sso/Logout</tt> байна';
$string['auth_shib_no_organizations_warning'] = 'Нэгдсэн WAYF сервисийг ашиглахыг хүсвэл таниулах үйлчилгээ үзүүлэгчийн аж ахуйн нэгжийн ID, нэрийг, сонголтоор сейшн эхлүүлэгчийн таслалаар тусгаарласан жагсаалтыг өгөх ёстой.';
$string['auth_shib_only'] = 'Зөвхөн Shibboleth';
$string['auth_shib_only_description'] = 'Shibboleth баталгаажуулалтыг заавал ашиглах тохиолдолд энэ сонголтыг шалгана уу';
$string['auth_shib_username_description'] = 'Moodle хэрэглэгчийн нэрээр хэрэглэгдэх Shibboleth орчны хувьсагч веб серверийн нэр';
$string['auth_shibboleth_errormsg'] = 'Та гишүүнчлэлтэй байгууллагаа сонгоно уу!';
$string['auth_shibboleth_login'] = 'Shibboleth нэвтрэлт';
$string['auth_shibboleth_login_long'] = 'Shibboleth аргаар дамжуулан Moodle системд нэвтрэх';
$string['auth_shibboleth_manual_login'] = 'Гараар нэвтрэх';
$string['auth_shibboleth_select_member'] = 'Би гишүүн ...';
$string['auth_shibboleth_select_organization'] = 'Shibboleth баталгаажуулалтад нээгдэх цэсээс байгууллагаа сонгоно уу:';
$string['auth_shibbolethdescription'] = 'Энэ аргаар хэрэглэгчийг Shibboleth ашиглан үүсгэж, баталгаажуулдаг. Тохиргооны дэлгэрэнгүй мэдээллийг <a href="{$a}">Shibboleth README</a> файлаас харна уу.';
$string['pluginname'] = 'Shibboleth';
$string['privacy:metadata'] = 'Shibboleth баталгаажуулалтын нэмэлт хэрэгсэл нь хувийн ямар ч мэдээллийг хадгалдаггүй.';
$string['shib_invalid_account_error'] = 'Таныг Shibboleth баталгаажуулсан бололтой, гэхдээ Moodle системд таны хэрэглэгчийн нэрээр хүчинтэй бүртгэл байхгүй байна. Таны бүртгэл байхгүй эсвэл түдгэлзүүлсэн байж магадгүй.';
$string['shib_no_attributes_error'] = 'Таныг Shibboleth баталгаажуулсан бололтой, гэхдээ Moodle систем хэрэглэгчийн ямар ч атрибутыг хүлээн аваагүй байна. Таны таниулагч үйлчилгээ үзүүлэгч нь Moodle үйлчилгээ үзүүлэгчид  шаардлагатай атрибутыг ({$a}) гаргаж байгаа эсэхийг шалгах эсвэл энэ серверийн вебмастерт мэдэгдэнэ үү.';
$string['shib_not_all_attributes_error'] = 'Moodle системд таны тохиолдолд байхгүй зарим Shibboleth атрибут шаардлагатай байна. Атрибут нь: {$a}<br />Энэ серверийн вебмастер эсвэл өөрийн таниулах үйлчилгээ үзүүлэгчтэй холбогдоно уу.';
$string['shib_not_set_up_error'] = 'Энэ хуудсанд Shibboleth орчны хувьсагч байхгүй тул Shibboleth баталгаажуулалтыг зөв тохируулаагүй бололтой. Shibboleth нэвтрэлт танилтыг тохируулах талаарх дэлгэрэнгүй зааврыг <a href="{$a}">README</a> файлаас авах буюу энэ Moodle суулгацын вебмастертай холбогдоно уу.';
