<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_brickfield', language 'da', version '4.5'.
 *
 * @package     tool_brickfield
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessibility'] = 'Tilgængelighed';
$string['accessibilitydisabled'] = 'Brickfield tilgængelighedsværktøjet er ikke aktiveret på dette site. Kontakt venligst din siteadministrator for at aktivere det.';
$string['accessibilityreport'] = 'Værktøjskasse til tilgængelighed';
$string['accessibilitytool'] = 'Brickfield tilgængelighedsværktøj';
$string['accessibilitytools'] = 'Brickfield tilgængelighedsværktøjer';
$string['activate'] = 'Aktiver';
$string['activated'] = 'Pluginet er aktiveret og klar til brug.';
$string['activationform'] = 'Brickfield registrering';
$string['activationheader'] = 'Aktivering af Brickfield';
$string['activationinfo'] = '<p>For at kunne bruge denne plugin, skal du angive gyldige nøgler for dette site i denne formular.</p><p>Venligst <a href="{$a}" data-action="send_info" target="_blank">registrer dig på Brickfield Portal (åbner i nyt vindue)</a> for at modtage disse nøgler, hvis du ikke allerede har dem. </p><p>Når de er aktiveret, vil dine nøgler derefter blive valideret via planlagte cron-opgaver.</p>';
$string['activityresults:pluginname'] = 'Rapport om tilgængelighedsværktøjet til aktivitetsopdeling';
$string['activityresults:toolname'] = 'Oversigt over aktivitetsfordeling';
$string['activityresults:toolshortname'] = 'Aktivitetsopdeling';
$string['advanced:pluginname'] = 'Rapport om avancerede tilgængelighedsværktøjer';
$string['advanced:toolname'] = 'Avanceret oversigt';
$string['advanced:toolshortname'] = 'Avanceret';
$string['allcourses'] = 'Alle gennemgåede kurser ({$a})';
$string['allcoursescat'] = 'Alle gennemgåede kurser for kategori {$a->catname} ({$a->count})';
$string['analysis:byrequest'] = 'Efter anmodning';
$string['analysis:disabled'] = 'Deaktiveret';
$string['analysistype'] = 'Aktiver analyseanmodninger';
$string['analysistype_desc'] = 'Tillad, at der anmodes om analyse af indholdstilgængelighed';
$string['analysistypedisabled'] = 'Analyse af indhold er deaktiveret';
$string['bannercontentone'] = 'Enterprise Accessibility Toolkit har et fuldt sæt af funktioner til at hjælpe din organisation med at forbedre tilgængeligheden af jeres kurser. <a href="{$a}">Kontakt Brickfield Education Labs</a> for at booke en gratis demo af de avancerede funktioner.';
$string['bannercontenttwo'] = 'Byg en effektiv og inkluderende undervisnings- og læringsplatform ved at finde indhold, der ikke opfylder retningslinjerne, rette problemerne og fremtidssikre dit Moodle kursusindhold med tilgængelige filer, redaktør og forbedrede funktioner.';
$string['bannerheadingone'] = 'Opgrader til Enterprise Accessibility Toolkit';
$string['batch'] = 'Batch-grænse';
$string['brickfield'] = 'Brickfield toolkit';
$string['brickfield:viewcoursetools'] = 'Se rapporter pr. kursus';
$string['brickfield:viewsystemtools'] = 'Se rapporter for alle kurser';
$string['bulkprocesscaches'] = 'Behandl bulk caching';
$string['bulkprocesscourses'] = 'Behandl bulk batch tilgængelighedstjek';
$string['buttonone'] = 'Få en gratis demo';
$string['cachepending'] = 'Sammenfatningsdataene bliver samlet';
$string['checkdesc:alinksdontopennewwindow'] = 'Links der åbner i et nyt vindue bør advare brugerne på forhånd.';
$string['checkdesc:amustcontaintext'] = 'Et link skal indeholde tekst for at være perceptibelt.';
$string['checkdesc:areadontopennewwindow'] = 'Områder, der anvendes i billedkort, som åbner i et nyt vindue, bør advare brugerne på forhånd.';
$string['checkdesc:areahasaltvalue'] = 'Områder, der anvendes i billedkort, bør ikke mangle alt (alternativ) tekst, ligesom billeder.';
$string['checkdesc:asuspiciouslinktext'] = 'Linktekst bør være beskrivende og give kontekst om dens destination.';
$string['checkdesc:basefontisnotused'] = 'Basefont-elementer (traditionelt brugt til formatering) er ikke tilgængelige og bør ikke anvendes.';
$string['checkdesc:blinkisnotused'] = 'Blinkende elementer, som blinker til og fra, er ikke tilgængelige og bør ikke anvendes.';
$string['checkdesc:boldisnotused'] = 'Fed (b) elementer bør ikke anvendes; "strong" bør anvendes i stedet.';
$string['checkdesc:contenttoolong'] = 'Den samlede længde af sideindholdet må ikke overstige 500 ord.';
$string['checkdesc:csstexthascontrast'] = 'Farvekontrasten mellem teksten og baggrunden er for lav.';
$string['checkdesc:embedhasassociatednoembed'] = 'Embed-elementer (til indlejring af multimedie) bør ikke mangle deres tilsvarende "noembed"-elementer.';
$string['checkdesc:headerh3'] = 'Overskrifter der følger efter H3-overskrifter (editorens store overskriftsmulighed) bør ikke bryde sideoverskriftshierarkiet.';
$string['checkdesc:headershavetext'] = 'En overskrift skal indeholde tekst for at være perceptibel.';
$string['checkdesc:iisnotused'] = 'Kursiv (i) elementer bør ikke anvendes; "em" bør anvendes i stedet.';
$string['checkdesc:imgaltisdifferent'] = 'Alternativ tekst for billeder bør ikke være billedfilens navn.';
$string['checkdesc:imgaltistoolong'] = 'Sørg for, at billedets alt-tekst (alternativ tekst) er kort nok til at beskrive billedet.';
$string['checkdesc:imgaltnotemptyinanchor'] = 'Alternativ tekst for billeder bør ikke være tom, især når billedet har et link til en anden side.';
$string['checkdesc:imgaltnotplaceholder'] = 'Alternativ tekst for billeder bør ikke være en simpel pladsholdertekst, såsom "billede".';
$string['checkdesc:imghasalt'] = 'Alternativ tekst for billedeelementer bør ikke mangle, medmindre de er rent dekorative uden betydning.';
$string['checkdesc:imgwithmaphasusemap'] = 'Billedkort med klikbare områder kræver matchende "usemap" og "map" elementer.';
$string['checkdesc:legendtextnotempty'] = 'Legend-elementer, der bruges til at captioning fieldset-elementer, bør indeholde tekst.';
$string['checkdesc:marqueeisnotused'] = 'Marquee (auto-scrolling) elementer er ikke tilgængelige og bør ikke anvendes.';
$string['checkdesc:noheadings'] = 'Ingen overskrifter gør indholdet mindre struktureret og sværere at læse.';
$string['checkdesc:objectmusthaveembed'] = 'Objektelementer (til indlejring af eksterne ressourcer) bør ikke mangle deres tilsvarende "embed" elementer.';
$string['checkdesc:objectmusthavetitle'] = 'Objektelementer (til indlejring af eksterne ressourcer) bør ikke mangle deres tilsvarende "titel" beskrivelser.';
$string['checkdesc:objectmusthavevalidtitle'] = 'Objektelementer (til indlejring af eksterne ressourcer) bør have tilsvarende "titler" med tekst.';
$string['checkdesc:strikeisnotused'] = 'Strike (gennemstreget) elementer bør ikke anvendes; "del" (slettet) bør anvendes i stedet.';
$string['checkdesc:tabledatashouldhaveth'] = 'Tabeller bør ideelt set ikke mangle overskrifter.';
$string['checkdesc:tablesummarydoesnotduplicatecaption'] = 'Tabelresuméer og billedtekster bør ikke være identiske.';
$string['checkdesc:tabletdshouldnotmerge'] = 'Tabeller bør ideelt set ikke have nogen sammenflettede celler.';
$string['checkdesc:tablethshouldhavescope'] = 'Tabelrække- eller kolonneomfang (bruges til at kortlægge række og kolonne til hver celle) bør deklareres.';
$string['checkidvalidation'] = 'Opgave til at kontrollere for eventuelle ugyldige checkids';
$string['checkscompleted'] = 'Kontroller fuldført: {$a}';
$string['checktype'] = 'Tjek brugergruppe';
$string['checktype:form'] = 'Formular';
$string['checktype:image'] = 'Billede';
$string['checktype:layout'] = 'Layout';
$string['checktype:link'] = 'Link';
$string['checktype:media'] = 'Medier';
$string['checktype:table'] = 'Tabel';
$string['checktype:text'] = 'Tekst';
$string['checktyperesults:pluginname'] = 'Rapport om tilgængelighed for indholdstyper';
$string['checktyperesults:toolname'] = 'Oversigt over indholdstyper';
$string['checktyperesults:toolshortname'] = 'Indholdstyper';
$string['cmpercent'] = 'Procentdel af aktiviteter samlet set';
$string['cmpercenterrors'] = 'Procentdel af fejl samlet set';
$string['cmpercenttitle'] = 'Overordnet procentfordeling af aktiviteter versus fejl';
$string['confirmationmessage'] = 'Dette kursus er blevet planlagt til analyse. Analysen vil blive afsluttet tidligst muligt.
senest {$a}. Tjek igen efter dette tidspunkt.';
$string['contactadmin'] = 'Kontakt venligst din administrator for at fuldføre registreringen.';
$string['contactus'] = 'Kontakt os';
$string['contentfive'] = 'Automatisk rette forældede HTML-tags.';
$string['contentfour'] = 'Identificer hvilke aktiviteter der har de største tilgængelighedsproblemer for at prioritere indsatsen.';
$string['contentone'] = 'Evaluer automatisk dit kursusindhold og dine vurderinger for tilgængelighedsproblemer.';
$string['contentsix'] = 'Giv lærerne lige-nu tips til at skabe bedre indhold.';
$string['contentthree'] = 'Giv dine studerende indhold i tilgængelige formater, herunder Audio, ePub og Elektronisk Braille.';
$string['contenttwo'] = 'Masseopdatering af uklar eller manglende tekst til weblinks, billedbeskrivelser og video undertekster.';
$string['contenttypeerrors'] = 'Samlede resultater af aktivitetens indholdstest pr. kursus og pr. indholdstype.';
$string['contentyperesults'] = 'Samlet bestået/ikke bestået for indholdsområder pr. kursus.';
$string['contextid'] = 'Contextid';
$string['core_course'] = 'Kursus';
$string['core_question'] = 'Spørgsmål databaser';
$string['count'] = 'Tæl';
$string['country'] = 'Land';
$string['country_help'] = 'Land for siden';
$string['coursecount'] = 'Antal kurser';
$string['deletehistoricaldata'] = 'Slet tidligere tjekresultater';
$string['dependency'] = 'Afhængig af';
$string['emptycategory'] = 'Ingen kurser fundet for kategori {$a}';
$string['emptytagcourses'] = 'Ingen resultater fundet for kurser med konfigurerede tags';
$string['enableaccessibilitytools'] = 'Aktiver værktøjer til tilgængelighed';
$string['enableaccessibilitytools_desc'] = 'Værktøjskassen til tilgængelighed hjælper med at identificere tilgængelighedsproblemer i kurser.';
$string['error:nocoursespecified'] = 'Denne oversigtsrapport kræver et gyldigt kursus-id. Du kan få adgang til tilgængelighedsværktøjskassen fra et kursus.';
$string['errorlink'] = 'Rediger fejlinstans for {$a}';
$string['errors'] = 'Fejl: {$a}';
$string['errors:pluginname'] = 'Fejl liste tilgængelighedsværktøj';
$string['errors:toolname'] = 'Oversigt over fejlliste';
$string['errors:toolshortname'] = 'Fejl liste';
$string['eventanalysis_requested'] = 'Indholdsanalyse anmodet';
$string['eventanalysis_requesteddesc'] = 'Der blev anmodet om indholdsanalysen for kursus {$a}.';
$string['eventreport_downloaded'] = 'Oversigt over tilgængelighed downloadet';
$string['eventreport_downloadeddesc'] = 'Der blev downloadet en oversigt over tilgængelighed for kursus-id {$a}.';
$string['eventreport_viewed'] = 'Tilgængelighedsrapport set';
$string['eventreport_vieweddesc'] = 'En rapport om tilgængelighed er set for kursus id {$a->course}
kategori-id {$a->category}, faneblad {$a->tab}.';
$string['failed'] = 'Mislykkedes';
$string['failedcount'] = 'Fejl: {$a}';
$string['footerheading'] = 'Footer sektion';
$string['fullcachedone'] = 'Deaktiver for at køre caching igen';
$string['hashcorrect'] = 'Den indtastede kode er korrekt.';
$string['hashincorrect'] = 'Den indtastede kode er forkert.';
$string['headingfive'] = 'HTML rettelser';
$string['headingfour'] = 'Fokuser indsatsen';
$string['headingone'] = 'Vurder indhold';
$string['headingsix'] = 'Ydelsesstøtte';
$string['headingthree'] = 'Tilgængelige filformater';
$string['headingtwo'] = 'Reparation';
$string['hideshow'] = 'Skjul/vis';
$string['icon:analytics-custom'] = 'Analyse ikon';
$string['icon:file-edit-custom'] = 'Rediger filikon';
$string['icon:hands-helping-custom'] = 'Ikon med hjælpende hænder';
$string['icon:search-plus-custom'] = 'Søgeikon';
$string['icon:tools-custom'] = 'Værktøjsikon';
$string['icon:wand-magic-custom'] = 'Magisk tryllestav ikon';
$string['inactive'] = 'Pluginet er inaktivt og kan ikke bruges. Indtast venligst gyldige registreringsnøgler, og tryk på "Aktivér".';
$string['innercontextid'] = 'Indre kontekst-id';
$string['installed'] = 'Plugin installeret';
$string['installedcli'] = 'Plugin installeret via kommandolinje';
$string['installeddescription'] = 'Pluginet er blevet installeret, omdiriger til aktiveringsformular.';
$string['invalidaccessibilitytool'] = 'Ugyldig tilgængeligheds underplugin anmodet.';
$string['invalidcategoryid'] = 'Ugyldig kategori, venligst tjek dit input';
$string['invalidcourseid'] = 'Ugyldigt kursus, venligst tjek din indtastning';
$string['invalidlinkphrases'] = 'klik|klik her|her|mere|mere her|info|info her|information|information her|læs mere|læs mere her|yderligere information|yderligere information her|yderligere detaljer|yderligere detaljer her';
$string['language'] = 'Sprog';
$string['language_help'] = 'Sprog for siden';
$string['messageprovider:warningcheckid'] = 'Advarsel om ugyldige tjek-id\'er';
$string['mobileservice'] = 'Mobile tjenester aktiveret ({$a})';
$string['module'] = 'Modul';
$string['modulename'] = 'Navn';
$string['moreinfo'] = 'Mere information';
$string['newwindowphrases'] = 'new window|new-window|new_window';
$string['noerrorsfound'] = 'Der blev ikke fundet almindelige tilgængelighedsfejl for dine søgeparametre. Tillykke!';
$string['norecords'] = 'Der blev ikke fundet relevante poster for dine søgeparametre.';
$string['notregistered'] = 'Dit tilgængelighedsværktøj skal registreres.';
$string['notvalidated'] = 'Dit tilgængelighedsværktøj er funktionelt, mens det bliver valideret.';
$string['numcourses'] = 'Antal kurser ({$a})';
$string['numfactivities'] = 'Antal aktiviteter ({$a})';
$string['numfiles'] = 'Antal filer ({$a})';
$string['numinstances'] = 'Antal instanser';
$string['numusers'] = 'Antal brugere ({$a})';
$string['pagedesc:checktype'] = '<p>For at opsummere og analysere resultaterne af de forskellige udførte kontroller, grupperer vi disse kontroller i forskellige indholdstyper. Derfor er alle resultater fra tilgængelighedskontroller relateret til billeder i gruppen for indholdstype "Billede", alle resultater fra tilgængelighedskontroller relateret til layout i gruppen for indholdstype "Layout", og så videre.</p><p>Aktiviteter inkluderes som enten aktiviteter, ressourcer eller indholdsområder relateret til kurserne selv.</p><p>Indholdstype-diagrammet viser fejlfordelingen pr. indholdstypegruppe: Billede, Layout, Link, Media, Tabel og Tekst.</p>';
$string['pagedesc:pertarget'] = '<p>For at opsummere og analysere kontrolresultaterne pr. aktivitet grupperer vi disse kontrolresultater i de forskellige aktiviteter, der er blevet registreret.</p><p>Aktiviteter inkluderer enten aktiviteter, ressourcer eller andre indholdsområder relateret til kurserne selv. Hver aktivitet uden registrerede fejl tælles som bestået, hver aktivitet med en eller flere registrerede fejl tælles som ikke bestået. Forholdet mellem beståede og ikke beståede aktiviteter vises derefter.</p><p>Aktivitetsopdelingsdiagrammets side viser forholdet mellem beståede og ikke beståede tilfælde i alt, pr. aktivitet, såsom opgave, kursus, label osv.</p>';
$string['pagedesctitle:checktype'] = 'Indholdstyper forklaret';
$string['pagedesctitle:pertarget'] = 'Aktivitetsopdeling forklaret';
$string['passed'] = 'Bestået';
$string['passedcount'] = 'Bestået: {$a}';
$string['passrate'] = 'Beståelsesrate: {$a}%';
$string['pdf:filename'] = 'Brickfield_Summaryreport_CourseID-{$a}';
$string['percheckerrors'] = 'Antal specifikke tests og fejl pr. kontrol pr. kursus.';
$string['perpage'] = 'Elementer, der skal vises pr. side';
$string['pluginname'] = 'Værktøjskasse til tilgængelighed';
$string['printable:downloadpdf'] = 'Download PDF';
$string['printable:pluginname'] = 'Oversigtsrapport rapport om tilgængelighedsværktøj';
$string['printable:printreport'] = 'Udskrivbar rapport';
$string['printable:toolname'] = 'Oversigtsrapport';
$string['printable:toolshortname'] = 'Oversigtsrapport';
$string['privacy:metadata'] = 'Pluginet til rapportering af tilgængelighedstjek gemmer ikke personlige data.';
$string['processanalysisrequests'] = 'Behandl anmodninger om indholdsanalysen';
$string['registernow'] = 'Venligst registrer dig nu.';
$string['registration'] = 'Registreringsformular';
$string['registrationinfo'] = '<p>Denne registreringsproces giver dig mulighed for at bruge Brickfield tilgængelighedsværktøjet starterversion til dit registrerede Moodle-site.</p><p>Denne brug er underlagt <a href="{$a}" target="_blank">Brickfield Education Labs vilkår og betingelser (åbner i nyt vindue)</a>, som du accepterer ved at bruge dette produkt.</p>';
$string['release'] = 'Moodle udgivelse ({$a})';
$string['remaining'] = '({$a} fejl tilbage)';
$string['response:0'] = 'Denne URL peger ikke på noget sted';
$string['response:404'] = 'Denne URL-side blev ikke fundet';
$string['schedule:blocknotscheduled'] = '<p>Dette kursus er endnu ikke blevet planlagt til analyse for at finde fælles tilgængelighedsproblemer.</p>';
$string['schedule:notscheduled'] = '<p>Dette kursus er endnu ikke blevet planlagt til analyse for at finde almindelige tilgængelighedsproblemer.</p><p>Ved at klikke på knappen "Indsend til analyse" bekræfter du, at du ønsker, at alt dit relevante kursus HTML-indhold, såsom beskrivelser af kursussektioner, aktivitetsbeskrivelser, spørgsmål, sider og mere, skal planlægges til analyse.</p><p>Denne analyse vil udføre flere almindelige tilgængelighedstjek på dit kursus HTML-indhold, og disse resultater vil derefter blive vist på disse rapport sider for tilgængelighedsværktøjet. Analysen vil blive behandlet i baggrunden af planlagte opgaver, så hastigheden for færdiggørelse vil afhænge af opgavernes tidsplaner og kørselstider.</p>';
$string['schedule:requestanalysis'] = 'Indsend til analyse';
$string['schedule:scheduled'] = 'Dette kursus er blevet planlagt til analyse.';
$string['schedule:sitenotscheduled'] = '<p>Det globale (kursus-uafhængige) indhold er endnu ikke blevet planlagt til analyse for at finde fælles tilgængelighedsproblemer.</p><p>Ved at klikke på knappen "Indsend til analyse" bekræfter du, at du ønsker, at alt dit relevante globale (kursus-uafhængige) indhold skal planlægges til analyse.</p><p>Denne analyse vil udføre flere almindelige tilgængelighedstjek på dette indhold, og disse resultater vil derefter blive vist på disse rapport sider for tilgængelighedsværktøjet. Analysen vil blive behandlet i baggrunden af planlagte opgaver, så hastigheden for færdiggørelse vil afhænge af opgavernes tidsplaner og kørselsskemaer.</p>';
$string['schedule:sitescheduled'] = 'Det globale (kursus-uafhængige) indhold er blevet planlagt til analyse.';
$string['secretkey'] = 'API nøgle';
$string['secretkey_help'] = 'Denne kode modtages via e-mail efter registreringen.';
$string['sendfollowinginfo'] = '<p>De følgende oplysninger vil blive sendt periodisk for kun at bidrage til de samlede statistikker. De vil ikke blive offentliggjort på nogen central liste.</p> {$a}';
$string['settings'] = 'Indstillinger for tilgængelighedsværktøj';
$string['sitehash'] = 'Hemmelig nøgle';
$string['sitehash_help'] = 'Denne kode modtages via e-mail efter registreringen.';
$string['taberrors'] = 'Tjek fejl';
$string['targetavetitle'] = 'Gennemsnitlige fejl pr. aktivitet';
$string['targetpercentage'] = 'Procentdel af beståede/ikke beståede tilfælde pr. aktivitet';
$string['targetratio'] = 'Aktivitetsbeståelsesforhold';
$string['tblcheck'] = 'Tjek';
$string['tblcheckexample'] = 'Eksempel';
$string['tblcheckfailed'] = 'Kontrollerne fejlede';
$string['tblchecksummary'] = 'Resumé';
$string['tbledit'] = 'Rediger';
$string['tblerrorcount'] = 'Fejl';
$string['tblhtmlcode'] = 'Eksisterende HTML-kode';
$string['tblinstance'] = 'Instans';
$string['tblline'] = 'Linje';
$string['tbloverallpercentage'] = 'Samlede fejl %';
$string['tblpercentage'] = 'Procentdel';
$string['tblpreview'] = 'Forhåndsvisning';
$string['tbltarget'] = 'Aktivitet';
$string['tblupdateto'] = 'Opdater til';
$string['titleactivityresultsall'] = 'Resultater pr. aktivitet: alle gennemgåede kurser ({$a->count} kurser)';
$string['titleactivityresultspartial'] = 'Resultater pr. aktivitet: kursus {$a->name}';
$string['titleall'] = 'Fejl detaljer: alle gennemgåede kurser ({$a->count} kurser)';
$string['titlechecktyperesultsall'] = 'Resultater pr. indholdstype: alle gennemgåede kurser ({$a->count} kurser)';
$string['titlechecktyperesultspartial'] = 'Resultater pr. indholdstype: kursus {$a->name}';
$string['titleerrorsall'] = 'Fejl detaljer: alle gennemgåede kurser ({$a->count} kurser)';
$string['titleerrorscount'] = 'Fejl detaljer: (viser de første {$a} fejl)';
$string['titleerrorspartial'] = 'Fejl detaljer: kursus {$a->name}';
$string['titlepartial'] = 'Fejl detaljer: kursus {$a->name}';
$string['titleprintableall'] = 'Kursus {$a->name}';
$string['titleprintablepartial'] = 'Kursus {$a->name}';
$string['tools'] = 'Rapporter';
$string['toperrors'] = 'Topfejl';
$string['toptargets'] = 'Mislykkedes aktiviteter';
$string['totalactivities'] = 'Samlede aktiviteter';
$string['totalactivitiescount'] = 'Samlede aktiviteter: {$a}';
$string['totalareas'] = 'Samlede områder';
$string['totalerrors'] = 'Samlede fejl';
$string['totalgrouperrors'] = 'Samlet (sum) fejl pr. indholdstype';
$string['updatesummarydata'] = 'Opdater webstedets opsummeringsdata';
$string['usersmobileregistered'] = 'Antal brugere med registrerede mobile enheder ({$a})';
$string['validationerror'] = 'Validering af registreringsnøglen er mislykkedes. Tjek at din registrerede websteds-URL og nøgler er korrekte.';
$string['warningcheckidbody'] = 'There is an issue with a Brickfield check
 which is active but not listed in the database. Please investigate.';
$string['warningcheckidsubject'] = 'Brickfield Toolkit checkID advarsel';
