<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'search_solr', language 'da', version '4.5'.
 *
 * @package     search_solr
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['connectionerror'] = 'Den specificerede Solr-server er ikke tilgængelig eller det specificerede indeks eksisterer ikke';
$string['connectionsettings'] = 'Forbindelsesindstillinger';
$string['errorcreatingschema'] = 'Fejl ved oprettelse af Solr-skema: {$a}';
$string['errorsolr'] = 'Søgemaskinen Solr rapporterede en fejl: {$a}';
$string['errorvalidatingschema'] = 'Fejl ved validering af Solr-skema: feltet {$a->fieldname} eksisterer ikke. Følg <a href="{$a->setupurl}">dette link</a> for at opsætte de krævede felter.';
$string['extensionerror'] = 'Apache Solr PHP-udvidelsen er ikke installeret. Tjek dokumentationen.';
$string['fileindexing'] = 'Aktiver filindeksering';
$string['fileindexing_help'] = 'Hvis din Solr-installation understøtter det, muliggør denne funktion  at Moodle kan sende filer til indeksering.<br/>
Du skal genindeksere al indhold på sitet efter denne aktivering så alle filer bliver tilføjet.';
$string['fileindexsettings'] = 'Indstillinger for filindeksering';
$string['maxindexfilekb'] = 'Maksimal filstørrelse til indeks (kB)';
$string['maxindexfilekb_help'] = 'Filer større end dette antal kilobyte vil ikke tages med i søgeindekseringen. Angives nul, indekseres filer af alle størrelser.';
$string['minimumsolr4'] = 'Moodle kræver mindst Solr 4.0';
$string['missingconfig'] = 'Din Apache Solr-server er endnu ikke konfigureret i Moodle.';
$string['multivaluedfield'] = 'Feltet "{$a}" returnerede et array i stedet for en skalar. Slet det nuværende indeks, opret et nyt og kør setup_schema.php inden du indekserer data i Solr.';
$string['nodatafromserver'] = 'Ingen data fra serveren';
$string['pluginname'] = 'Solr';
$string['privacy:metadata'] = 'Dette plugin sender data eksternt til en linket Solr-søgemaskine. Det gemmer ikke data lokalt.';
$string['privacy:metadata:data'] = 'Personlige data overført fra søgesubsystemet.';
$string['schemafieldautocreated'] = 'Feltet "{$a}" eksisterer allerede i Solr-skemaet. Du har vist glemt at køre dette script inden indeksering af data og felter blev auto-oprettet af Solr. Slet det nuværende indeks, opret et nyt og kør setup_schema.php igen inden du indekserer data i Solr.';
$string['schemasetupfromsolr5'] = 'Din Solr-serverversion er mindre end 5.0. Dette script kan kun opsætte dit skema hvis din Solr-version er 5.0 eller derover. Du skal manuelt opsætte felterne i det skema i overensstemmelse med \\search_solr\\document::get_default_fields_definition().';
$string['searchinfo'] = 'Søgeforespørgsler';
$string['searchinfo_help'] = 'Det område der skal søges i, kan specificeres med et præfiks til forespørgslen med "titel:", "indhold:", "navn:", eller "intro:". Eksempelvis vil en søgning på "titel:nyhed" returnere forekomster med ordet "nyhed" i titlen.

Booleske operatorer ("AND", "OR", "NOT") kan bruges til at kombinere eller ekskludere ord.

Jokertegn ("*" eller "?" ) kan repræsentere tegn i søgestrengen.';
$string['setupok'] = 'Skemaet er klar til brug.';
$string['solrauthpassword'] = 'Adgangskode til http-godkendelse';
$string['solrauthuser'] = 'Brugernavn til http-godkendelse';
$string['solrhttpconnectionport'] = 'Port';
$string['solrhttpconnectiontimeout'] = 'Timeout';
$string['solrhttpconnectiontimeout_desc'] = 'Timeout på http-forbindelsen er den tid i sekunder det højest må tage for en dataoverførsel via http.';
$string['solrindexname'] = 'Indeksnavn';
$string['solrinfo'] = 'Solr';
$string['solrnotselected'] = 'Solr-maskinen er ikke den konfigurerede søgemaskine';
$string['solrsecuremode'] = 'Sikkerhedstilstand';
$string['solrserverhostname'] = 'Værtsnavn';
$string['solrserverhostname_desc'] = 'Solr-serverens domænenavn';
$string['solrsetting'] = 'Solr-indstillinger';
$string['solrsslcainfo'] = 'SSL CA-certifikatsnavne';
$string['solrsslcainfo_desc'] = 'Navn på fil med et eller flere CA-certifikater til verificering af peers';
$string['solrsslcapath'] = 'Sti til SSL CA-certifikater';
$string['solrsslcapath_desc'] = 'Sti til mappen med flere CA-certifikater til verifikation af peers';
$string['solrsslcert'] = 'SSL-certifikat';
$string['solrsslcert_desc'] = 'Filnavn på et PEM-formateret privat certifikat';
$string['solrsslkey'] = 'SSL-nøgle';
$string['solrsslkey_desc'] = 'Filnavn på en PEM-formateret privat nøgle';
$string['solrsslkeypassword'] = 'Adgangskode til SSL-nøgle';
$string['solrsslkeypassword_desc'] = 'Adgangskode til en PEM-formateret privat nøgle';
