<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'bigbluebuttonbn', language 'ro', version '4.5'.
 *
 * @package     bigbluebuttonbn
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acceptdpa'] = 'Înțeleg și accept acordul de prelucrare a datelor';
$string['activityoverview'] = 'Aveți sesiuni bigbluebuttonbn viitoare';
$string['bbbduetimeoverstartingtime'] = 'Termenul de predare trebuie să fie după termenul de începere.';
$string['bbbdurationwarning'] = 'Durata maximă pentru această sesiune este de %duration% minute.';
$string['bbbrecordallfromstartwarning'] = 'Această sesiune este înregistrată de la început.';
$string['bbbrecordwarning'] = 'Această sesiune e posibil să fie înregistrată.';
$string['bigbluebuttonbn'] = 'BigBlueButton';
$string['bigbluebuttonbn:addinstance'] = 'Adaugă o nouă cameră bigbluebuttonbn';
$string['bigbluebuttonbn:addinstancewithmeeting'] = 'Creați o instanță de sesiuni live';
$string['bigbluebuttonbn:addinstancewithrecording'] = 'Crează instanță cu înregistrări';
$string['bigbluebuttonbn:deleterecordings'] = 'Șterge înregistrări';
$string['bigbluebuttonbn:importrecordings'] = 'Importă înregistrări';
$string['bigbluebuttonbn:join'] = 'Înscrie-te la o cameră BigBlueButton';
$string['bigbluebuttonbn:managerecordings'] = 'Administrează înregistrări';
$string['bigbluebuttonbn:protectrecordings'] = 'Protejează accesul la înregistrări';
$string['bigbluebuttonbn:publishrecordings'] = 'Publică înregistrări';
$string['bigbluebuttonbn:seepresentation'] = 'Întotdeauna afișează fișierul de prezentare în pagina activității';
$string['bigbluebuttonbn:unprotectrecordings'] = 'Deprotejați înregistrările';
$string['bigbluebuttonbn:unpublishrecordings'] = 'Anulați publicarea înregistrărilor';
$string['bigbluebuttonbn:view'] = 'Accesează cameră BigBlueButton';
$string['bigbluebuttonbn:viewallrecordingformats'] = 'Vizualizează toate formatele de înregistrare';
$string['bigbluebuttondisablednotification'] = 'Modulul de activitate BigBlueButton a fost dezactivat și nicio activitate existentă în cursul BigBlueButton nu este accesibilă momentan. Înainte de a reactiva acest plugin, vă rugăm să vă asigurați că ați citit și acceptat <a href="{$a}" target="_blank">acordul de procesare a datelor</a> cu Blindside Networks Inc.';
$string['bigbluebuttondisablednotification_subject'] = 'Modulul de activitate BigBlueButton a fost dezactivat.';
$string['cachedef_currentfetch'] = 'Date pentru a enumera orice înregistrare preluată recent.';
$string['cachedef_recordings'] = 'Înregistrarea metadatelor';
$string['cachedef_serverinfo'] = 'Informații despre server la distanță';
$string['cachedef_subplugins'] = 'Memoria Cache folosită de rutinele subplugin-urilor pentru a accelera atunci când este necesar procesul de descoperire a pluginurilor.';
$string['cachedef_validatedurls'] = 'Memoria cache a verificărilor URL validate';
$string['calendarstarts'] = '{$a} este programat pentru';
$string['cannotperformaction'] = 'Nu se poate efectua acțiunea {$a} pentru această înregistrare';
$string['completionattendance'] = 'Necesită prezență (minute)';
$string['completionattendance_desc'] = 'Intră în camera de discuții și rămâi în sesiune pentru cel puțin {$a} minut(e)';
$string['completionattendance_event_desc'] = 'Studentul a intrat în cameră și a rămas în sesiune pentru cel puțin {$a} minut(e)';
$string['completionattendancegroup'] = 'Necesită prezență (minute)';
$string['completionattendancegroup_help'] = 'Participarea la ședință pentru (n) minute este necesară pentru finalizare.';
$string['completionengagement_desc'] = 'Angajare în activități în timpul întâlnirii';
$string['completionengagementchats'] = 'Conversaţii';
$string['completionengagementchats_desc'] = 'Participă la {$a} discuție(i).';
$string['completionengagementchats_event_desc'] = 'A generat {$a} discuție(e)';
$string['completionengagementemojis'] = 'Emojis';
$string['completionengagementemojis_desc'] = 'Și-a modificat emoji de {$a} ori.';
$string['completionengagementemojis_event_desc'] = 'Și-a modificat emoji de {$a} ori';
$string['completionengagementgroup'] = 'Necesită participare';
$string['completionengagementgroup_help'] = 'Participarea activă în timpul sesiunii este necesară pentru finalizare.';
$string['completionengagementpollvotes'] = 'Voturi la sondaj';
$string['completionengagementpollvotes_desc'] = 'Votează în sondaje de {$a} ori.';
$string['completionengagementpollvotes_event_desc'] = 'Are {$a} voturi în sondaj';
$string['completionengagementraisehand'] = 'Necesită mâna ridicată';
$string['completionengagementraisehand_desc'] = 'A ridicat mâna de {$a} ori.';
$string['completionengagementraisehand_event_desc'] = 'A ridicat mâna de {$a} ori';
$string['completionengagementtalks'] = 'Vorbește';
$string['completionengagementtalks_desc'] = 'Timpul {$a} alocat discuției(i).';
$string['completionengagementtalks_event_desc'] = 'A deschis {$a} discuții';
$string['completionupdatestate'] = 'Stare de actualizare de finalizare';
$string['completionvalidatestate'] = 'Validează finalizarea';
$string['completionvalidatestatetriggered'] = 'Finalizarea completării a fost începută.';
$string['completionview'] = 'Este necesară vizualizarea';
$string['completionview_desc'] = 'Vizualizare cameră de discuții';
$string['completionview_event_desc'] = 'A accesat camera de discuții.';
$string['config_checksum_algorithm'] = 'Algoritm de verificare funcționalități BigBlueButton';
$string['config_checksum_algorithm_description'] = 'SHA1 este compatibil cu servere mai vechi. SHA256 and SHA512 sunt mai sigure. SHA512 este compatibil cu FIPS 140-2.';
$string['config_default_messages'] = 'Mesaje implicite';
$string['config_default_messages_description'] = 'Setați valorile implicite ale mesajelor pentru activități';
$string['config_disablecam_default'] = 'Dezactivați camera web activată în mod implicit';
$string['config_disablecam_default_description'] = 'Dacă se activează, camerele web vor fi dezactivate.';
$string['config_disablecam_editable'] = 'Dezactivarea camerei web poate fi editată';
$string['config_disablecam_editable_description'] = 'Dezactivarea camerei web în mod implicit poate fi editată atunci când instanța este adăugată sau actualizată.';
$string['config_disablemic_default'] = 'Dezactivarea microfonului este activată în mod implicit';
$string['config_disablemic_default_description'] = 'Dacă este activată această opțiune, microfoanele vor fi dezactivate.';
$string['config_disablemic_editable'] = 'Dezactivarea microfonului poate fi editată';
$string['config_disablemic_editable_description'] = 'Dezactivarea microfonului în mod implicit poate fi editată când este adăugată sau actualizată o instanță.';
$string['config_disablenote_default'] = 'Dezactivarea notițelor comune este activată în mod implicit';
$string['config_disablenote_default_description'] = 'Dacă este activată această opțiune, notițele comune vor fi dezactivate.';
$string['config_disablenote_editable'] = 'Dezactivarea notițelor comune poate fi editată';
$string['config_disablenote_editable_description'] = 'Dezactivare notițelor comune în mod implicit poate fi editată când instanța este adăugată sau actualizată.';
$string['config_disableprivatechat_default'] = 'Dezactivarea discuției private este activată în mod implicit';
$string['config_disableprivatechat_default_description'] = 'Dacă este activată această opțiune, discuția privată va fi dezactivată.';
$string['config_disableprivatechat_editable'] = 'Dezactivarea discuției private poate fi editată.';
$string['config_disableprivatechat_editable_description'] = 'Dezactivarea discuției private în mod implicit poate fi editată când o instanță este adăugată sau actualizată.';
$string['config_disablepublicchat_default'] = 'Dezactivați discuția publică activată în mod implicit';
$string['config_disablepublicchat_default_description'] = 'Dacă este activată, discuția publică va fi dezactivată.';
$string['config_disablepublicchat_editable'] = 'Dezactivarea discuției publice poate fi editată';
$string['config_disablepublicchat_editable_description'] = 'Dezactivarea discuției publice în mod implicit poate fi editată când o instanță este adăugată sau actualizată.';
$string['config_dpa_note'] = 'Notă: Pentru a îndeplini obligațiile de protecție a datelor, înainte de a utiliza un furnizor de servicii pentru acest plugin, poate fi necesar să te asiguri că ai citit și ai acceptat acordul de prelucrare a datelor al furnizorului de servicii. Pentru serviciul implicit BigBlueButton gratuit oferit de Blindside Networks Inc., te rugăm să citești și să accepți următorul <a href="{$a}" target="_blank">acord de prelucrare a datelor</a>.<br/>
Te rugăm să îți consulți propriii profesioniști în materie de confidențialitate pentru alte sfaturi.';
$string['config_experimental_features'] = 'Funcționalități experimentale';
$string['config_experimental_features_description'] = 'Configurarea funcționalităților experimentale.';
$string['config_extended_capabilities'] = 'Capabilități extinse';
$string['config_extended_capabilities_description'] = 'Configurarea capabilităților extinse când serverul BigBlueButton le furnizează.';
$string['config_general'] = 'Setări generale';
$string['config_general_description'] = 'Pentru configurarea BigBlueButton, poți folosi credențialele tale sau poți să obții credențiale din <a href="https://registration-portal.blindsidenetworks.com/" target="_blank">Blindside Networks Registration Portal ( se deschide într-o fereastră nouă)</a>.';
$string['config_guestaccess_enabled'] = 'Acces pentru vizitatori externi';
$string['config_guestaccess_enabled_description'] = 'Permiteți utilizatorilor fără cont în platformă să acceseze videoconferința.';
$string['config_hideuserlist_default'] = 'Opțiunea Ascunde lista utilizatorilor este activată în mod implicit';
$string['config_hideuserlist_default_description'] = 'Dacă este activată, lista de utilizatori a sesiunii va fi ascunsă.';
$string['config_hideuserlist_editable'] = 'Lista cu utilizatorii ascunși poate fi editată';
$string['config_hideuserlist_editable_description'] = 'Ascunderea listei de utilizatori în mod implicit poate fi editată atunci când instanța este adăugată sau actualizată.';
$string['config_importrecordings'] = 'Importă înregistrările';
$string['config_importrecordings_description'] = 'Aceste setări sunt specifice funcționalității.';
$string['config_importrecordings_enabled'] = 'Este activat importul înregistrărilor';
$string['config_importrecordings_enabled_description'] = 'Când aceasta și caracteristica de înregistrare sunt activate, este posibil să importați înregistrări de la diferite cursuri într-o activitate.';
$string['config_importrecordings_from_deleted_enabled'] = 'Este activat importul înregistrărilor din activități șterse';
$string['config_importrecordings_from_deleted_enabled_description'] = 'Când aceasta și funcția de import de înregistrare sunt activate, este posibil să importați înregistrări din activități care nu mai sunt în curs.';
$string['config_locksettings'] = 'Configurare pentru setările de blocare';
$string['config_locksettings_description'] = 'Aceste setări activează sau dezactivează opțiunile din interfața de utilizare pentru setările de blocare și, de asemenea, definesc valorile implicite pentru aceste opțiuni.';
$string['config_meetingevents_enabled'] = 'Înregistrează sesiuni live';
$string['config_meetingevents_enabled_description'] = 'Dacă este activată, sesiunile live vor fi procesate după încheierea sesiunii. Această caracteristică este necesară pentru finalizarea activității și va funcționa numai dacă serverul BigBlueButton este capabil să proceseze scripturi post_events.';
$string['config_muteonstart'] = 'Sunetul oprit la început';
$string['config_muteonstart_default'] = 'Sunetul oprit la început activat în mod implicit';
$string['config_muteonstart_default_description'] = 'Dacă este activată, sesiunea va avea sunetul oprit la început.';
$string['config_muteonstart_description'] = 'Aceste setări activează sau dezactivează opțiunile din interfața de utilizare și, de asemenea, definesc valorile implicite pentru aceste opțiuni.';
$string['config_muteonstart_editable'] = 'Sunetul oprit la început poate fi editat';
$string['config_muteonstart_editable_description'] = 'Sunetul oprit la început în mod implicit poate fi editat când instanța este adăugată sau actualizată.';
$string['config_participant'] = 'Participanți';
$string['config_participant_description'] = 'Această setare determină rolul implicit al participanților.';
$string['config_participant_moderator_default'] = 'Moderator';
$string['config_participant_moderator_default_description'] = 'Această regulă este folosită în mod implicit când este adăugată o nouă cameră de discuții.';
$string['config_poll_interval'] = 'Interval (în secunde) pentru a reîmprospăta starea camerei';
$string['config_poll_interval_description'] = 'Intervalul trebuie să fie de cel puțin 2 secunde. Dacă este necesar, puteți reduce sarcina de pe server prin creșterea intervalului.';
$string['config_presentation_default'] = 'Fișier implicit pentru prezentări';
$string['config_presentation_default_description'] = 'Un fișier ce poate fi oferit pentru a fi folosit în toate camerele de discuții.';
$string['config_preuploadpresentation'] = 'Fișier de prezentare';
$string['config_preuploadpresentation_description'] = 'Aceste setări activează sau dezactivează opțiunile din interfața de utilizare și, de asemenea, definesc valorile implicite pentru aceste opțiuni. Caracteristica funcționează numai dacă serverul Moodle este accesibil pentru BigBlueButton.';
$string['config_preuploadpresentation_editable'] = 'Fișier de prezentare pe pagina de activitat';
$string['config_preuploadpresentation_editable_description'] = 'Opțiunea din setările activității de încărcare a fișierului de prezentare pentru a fi afișat pe pagina activității.';
$string['config_profile_picture_enabled'] = 'Afișează fotografiile de profil';
$string['config_profile_picture_enabled_description'] = 'Fotografiile de profil ale participanților ar trebui să fie afișate în sesiunile BigBlueButton?';
$string['config_recording'] = 'Înregistrare';
$string['config_recording_all_from_start_default'] = 'Începe să înregistrezi de la început';
$string['config_recording_all_from_start_default_description'] = 'Setarea „Începe înregistrarea de la început” ar trebui să fie activată în mod implicit atunci când adăugați o nouă cameră BigBlueButton?';
$string['config_recording_all_from_start_editable'] = 'Pornește înregistrarea de la începutul discuțiilor poate fi editată';
$string['config_recording_all_from_start_editable_description'] = '„Începe înregistrarea de la început” ar trebui să fie editabil în setările de activitate BigBlueButton?';
$string['config_recording_default'] = 'Înregistrare activată în mod implicit';
$string['config_recording_default_description'] = 'Setarea „Sesiunea poate fi înregistrată” ar trebui să fie activată în mod implicit atunci când adăugați o nouă cameră BigBlueButton?';
$string['config_recording_description'] = 'Aceste setări sunt specifice funcționalității.';
$string['config_recording_editable'] = 'Sesiunea poate avea înregistrarea editabilă';
$string['config_recording_editable_description'] = '„Sesiunea poate fi înregistrată” ar trebui să fie editabilă în setările de activitate BigBlueButton?';
$string['config_recording_hide_button_default'] = 'Ascunde butonul de înregistrare';
$string['config_recording_hide_button_default_description'] = 'Dacă este bifat, butonul pentru înregistrare va fi ascuns';
$string['config_recording_hide_button_editable'] = 'Ascunderea butonului de înregistrare se poate edita';
$string['config_recording_hide_button_editable_description'] = 'Ar trebui să fie editabil „Ascundeți butonul de înregistrare” în setările de activitate BigBlueButton?';
$string['config_recording_protect_editable'] = 'Statusul înregistrărilor protejate poate fi editată';
$string['config_recording_protect_editable_description'] = 'Dacă este bifată, interfața include o opțiune pentru protejarea/deprotejarea înregistrărilor.';
$string['config_recording_refresh_period'] = 'Interval de actualizare a înregistrării (în secunde)';
$string['config_recording_refresh_period_description'] = 'Cât de des ar trebui să fie interogat serverul BigBlueButton pentru a reîmprospăta informațiile de la distanță pentru o înregistrare?';
$string['config_recording_safe_formats'] = 'Formate de înregistrare care pot fi vizualizate de către toți participanții';
$string['config_recording_safe_formats_description'] = 'Selectează formatele care pot fi văzute de toți participanții.
Toate celelalte formate pot fi văzute doar de către profesori și alți utilizatori cu capabilități mod/bigbluebuttonbn:viewallrecordingformats și mod/bigbluebuttonbn:managerecordings.';
$string['config_recordingready_enabled'] = 'Trimiteți o notificare de înregistrare disponibilă';
$string['config_recordingready_enabled_description'] = 'Dacă este activată, va fi trimisă o notificare când este disponibil un link cu înregistrarea. Această caracteristică necesită activarea scriptului post_publish_recording_ready_callback pe serverul BigBlueButton.';
$string['config_recordings'] = 'Afișează înregistrări';
$string['config_recordings_asc_sort'] = 'Sortați înregistrările în ordine cronologică.';
$string['config_recordings_asc_sort_description'] = 'Înregistrările sunt ordonate în funcție de dată, fie în ordine cronologică, fie în ordine cronologică inversă (cea mai recentă înregistrare e prima).';
$string['config_recordings_deleted_default'] = 'Includeți înregistrări din activități șterse, activate în mod implicit';
$string['config_recordings_deleted_default_description'] = 'Dacă este activat, tabelul cu înregistrări va include înregistrări ale tuturor activităților care au fost șterse.';
$string['config_recordings_deleted_editable'] = 'Funcționalitatea Include înregistrări din activitățile șterse poate fi editată';
$string['config_recordings_deleted_editable_description'] = 'Includerea înregistrărilor din activitățile șterse în mod implicit poate fi editată atunci când instanța este adăugată sau actualizată.';
$string['config_recordings_description'] = 'Aceste setări sunt specifice funcționalității.';
$string['config_recordings_general'] = 'Afișați setările înregistrării';
$string['config_recordings_general_description'] = 'Aceste setări sunt utilizate doar când se afișează înregistrări';
$string['config_recordings_imported_default'] = 'Afișați numai linkurile importate activate în mod prestabilit';
$string['config_recordings_imported_default_description'] = 'Dacă este activat, tabelul de înregistrare va include numai legăturile importate către înregistrări.';
$string['config_recordings_imported_editable'] = 'Funcția Afișați numai linkurile importate poate fi editată';
$string['config_recordings_imported_editable_description'] = 'Afișați numai linkurile importate în mod implicit, pot fi editate atunci când instanța este adăugată sau actualizată.';
$string['config_recordings_preview_default'] = 'Previzualizarea este activată în mod implicit';
$string['config_recordings_preview_default_description'] = 'Dacă este activat, tabelul include o previzualizare a prezentării.';
$string['config_recordings_preview_editable'] = 'Funcționalitatea previzualizare poate fi editată';
$string['config_recordings_preview_editable_description'] = 'Caracteristica de previzualizare poate fi editată atunci când instanța este adăugată sau actualizată.';
$string['config_scheduled'] = 'Sesiuni programate';
$string['config_scheduled_description'] = 'Aceste setări definesc funcționalitatea implicită a sesiunilor programate.';
$string['config_scheduled_pre_opening'] = 'Accesibil înainte de ora deschiderii';
$string['config_scheduled_pre_opening_description'] = 'Timpul în minute pentru care camera este deschisă înainte de ora de deschidere programată.';
$string['config_server_url'] = 'Adresa serverului BigBlueButton';
$string['config_server_url_description'] = 'Adresa URL a serverului BigBlueButton.';
$string['config_shared_secret'] = 'Parola de conectare BigBlueButton';
$string['config_shared_secret_description'] = 'Cheia de securitate a serverului BigBlueButton.';
$string['config_showpresentation_default'] = 'Afișează fișierul de prezentare în pagina activității';
$string['config_showpresentation_default_description'] = 'Cursanții ar trebui să aibă acces la fișierul de prezentare înaintea sesiunii? Această setare nu are niciun efect asupra utilizatorilor cu capacitatea „Vedeți întotdeauna fișierul de prezentare pe pagina de activitate” .';
$string['config_showpresentation_editable'] = 'Opțiunea \'Afișează fișierul de prezentare în pagina activității\'';
$string['config_showpresentation_editable_description'] = 'Opțiune în setările activității pentru profesori de a alege dacă afișează fișierul de prezentare cursanților.';
$string['config_uidelegation_enabled'] = 'Asignarea permisiunilor pentru interfața utilizatorului este activată';
$string['config_uidelegation_enabled_description'] = 'Aceste setări activează sau dezactivează delegarea UI către serverul BigBlueButton.';
$string['config_userlimit'] = 'Limită de utilizatori';
$string['config_userlimit_default'] = 'Limita de utilizatori este activată în mod implicit';
$string['config_userlimit_default_description'] = 'Numărul de utilizatori acceptați într-o sesiune în mod implicit cînd este creată o nouă cameră de discuții. Setați la 0 pentru a permite un număr nelimitat de utilizatori.';
$string['config_userlimit_description'] = 'Aceste setări activează sau dezactivează opțiunile din interfața de utilizare și, de asemenea, definesc valorile implicite pentru aceste opțiuni.';
$string['config_userlimit_editable'] = 'Funcționalitatea limită de utilizatori poate fi editată';
$string['config_userlimit_editable_description'] = 'Numărul limită implicit de utilizatori poate fi editat atunci când camera de discuții sau conferința este adăugată sau actualizată.';
$string['config_voicebridge'] = 'Canal de voce';
$string['config_voicebridge_description'] = 'Aceste setări activează sau dezactivează opțiunile din interfața de utilizare și, de asemenea, definesc valorile implicite pentru aceste opțiuni.';
$string['config_voicebridge_editable'] = 'Canalul de voce al conferinței poate fi editat';
$string['config_voicebridge_editable_description'] = 'O modalitate de apelare vocală pentru conferință poate fi alocată permanent unei camere de discuții. Când este atribuit, numărul nu poate fi folosit pentru nicio altă cameră.';
$string['config_waitformoderator'] = 'Așteptați moderatorul';
$string['config_waitformoderator_cache_ttl'] = 'Se așteaptă încărcarea memoriei temporare a moderatorului (secunde)';
$string['config_waitformoderator_cache_ttl_description'] = 'Pentru a suporta o cantitate mare de clienți, acest plugin folosește un cache. Acest parametru definește timpul în care cache-ul va fi păstrat înainte ca următoarea solicitare să fie trimisă către serverul BigBlueButton.';
$string['config_waitformoderator_default'] = 'Funcționalitatea Așteaptă moderatorul activată în mod implicit';
$string['config_waitformoderator_default_description'] = 'Setarea „Așteptați moderatorul” ar trebui să fie activată în mod prestabilit atunci când adăugați o nouă cameră BigBlueButton?';
$string['config_waitformoderator_description'] = 'Aceste setări sunt specifice funcționalității.';
$string['config_waitformoderator_editable'] = 'Funcționalitatea Așteaptă moderatorul poate fi editată';
$string['config_waitformoderator_editable_description'] = 'Ar trebui să fie editabil „Așteptați moderatorul” în setările de activitate BigBlueButton?';
$string['config_waitformoderator_ping_interval'] = 'Asteptați reacția moderatorului (secunde)';
$string['config_waitformoderator_ping_interval_description'] = 'Cât de des ar trebui să fie trimis ping serverului pentru a verifica dacă moderatorul a intrat în cameră?';
$string['config_warning_bigbluebuttonbn_cfg_deprecated'] = 'BigBlueButton folosește config.php cu o variabilă globală care a fost depreciată. Vă rugăm să convertiți fișierul deoarece nu va fi acceptat în versiunile viitoare.';
$string['config_warning_curl_not_installed'] = 'Această caracteristică necesită instalarea și activarea extensiei CURL pentru PHP. Setările vor fi accesibile numai dacă această condiție este îndeplinită.';
$string['config_welcome_default'] = 'Mesaj implicit de bun venit';
$string['config_welcome_default_description'] = 'Mesajul de bun venit este afișat când participanții intră în cameră. Dacă câmpul este lăsat necompletat, atunci este folosit șirul \'mod_form_field_welcome_default\'.';
$string['config_welcome_editable'] = 'Mesajul implicit de bun venit poate să fie editat de către profesori';
$string['config_welcome_editable_description'] = 'Mesajul de bun venit poate fi editat când o instanță este adăugată sau actualizată';
$string['credentials_warning'] = 'Utilizarea credențialelor implicite pentru server va expira în curând (vezi nota de mai sus pentru obținerea de noi credențiale).';
$string['dpainfonotsigned'] = 'Înainte de a activa acest plugin, trebuie să confirmi că ai citit și ai acceptat acordul de prelucrare a datelor <a href="{$a}">Blindside Networks</a>.';
$string['enablingbigbluebutton'] = 'Se activează activitatea BigBlueButton';
$string['enablingbigbluebuttondpainfo'] = 'Pentru a îndeplini obligațiile de protecție a datelor, înainte de a activa acest plugin, poate fi necesar să vă asigurați că ați citit și acceptat <a href="{$a}" target="_blank">acordul de prelucrare a datelor</a> cu Blindside Networks Inc.<br/>
Vă rugăm să consultați specialiștii în materie de confidențialitate pentru mai multe informații.';
$string['end_session_confirm'] = 'Sunteți sigur că doriță să încheiați sesiunea?';
$string['end_session_confirm_title'] = 'Sunteți sigur că doriți să încheiați sesiunea?';
$string['end_session_notification'] = 'Sesiunea s-a închis.';
$string['ends_at'] = 'Se încheie';
$string['event_activity_created'] = 'Activitate creată';
$string['event_activity_deleted'] = 'Activitate ștearsă';
$string['event_activity_updated'] = 'Activitate actualizată';
$string['event_live_session'] = 'Un eveniment live';
$string['event_meeting_created'] = 'Întâlnire creată';
$string['event_meeting_ended'] = 'Întâlnire încheiată forțat';
$string['event_meeting_joined'] = 'Ați intrat în camera de discuții';
$string['event_meeting_left'] = 'A părăsit întâlnirea';
$string['event_recording_deleted'] = 'Înregistrare ștearsă';
$string['event_recording_edited'] = 'Înregistrare editată';
$string['event_recording_imported'] = 'Înregistrare importată';
$string['event_recording_protected'] = 'Înregistrare protejată';
$string['event_recording_published'] = 'Înregistrare publicată';
$string['event_recording_unprotected'] = 'Înregistrare neprotejată';
$string['event_recording_unpublished'] = 'Înregistrare nepublicată';
$string['event_recording_viewed'] = 'Înregistrare văzută';
$string['event_unknown'] = 'Eveniment necunoscut';
$string['general_error_cannot_create_meeting'] = 'Nu se poate crea sesiune.';
$string['general_error_cannot_get_recordings'] = 'Nu se pot accesa înregistrări.';
$string['general_error_no_answer'] = 'Răspuns necompletat. Vă rugăm să verificați adresa URL a serverului BigBlueButton ȘI să vedeți dacă serverul BigBlueButton rulează.';
$string['general_error_not_allowed_to_create_instances'] = 'Utilizatorul nu are permisiunea să creeze niciun fel de instanță.';
$string['general_error_not_found'] = 'Nu se poate găsi activitatea BigBlueButton cu ID-ul {$a}.';
$string['general_error_unable_connect'] = 'Imposibil de realizat conectarea. Vă rugăm să verificați URL-ul serverului BigBlueButton ȘI să verificați dacă serverul BigBlueButton ruleaza.
Detalii : {$a}';
$string['guest_invitation_full_message'] = 'Bună,
<p>Ești invitat la o sesiune BigBlueButton <strong>{$a->name}</strong> în cadrul cursului {$a->course_fullname}.</p>
<p>Link: {$a->guestjoinurl}<br/>
<p>Parolă: {$a->parola pentru oaspeți}</p>
<p>Dacă ai nevoie de ajutor, te rugăm să contactezi {$a->sender}.</p>';
$string['guest_invitation_small_message'] = 'Bună,

Ești invitat la o sesiune BigBlueButton {$a->name} în cursul {$a->course_fullname}.

Link: {$a->guestjoinurl}
Parolă: {$a->guestpassword}

Dacă ai nevoie de ajutor, te rugăm să contactezi {$a->sender}.';
$string['guest_invitation_subject'] = 'Invitație: sesiunea cu denumirea {$a->name} în cursul {$a->course_fullname}';
$string['guestaccess_activitynotfound'] = 'Activitatea nu a fost găsită.';
$string['guestaccess_add'] = 'Adaugă vizitatori';
$string['guestaccess_add_no_id'] = 'Nu a fost furnizat niciun ID de instanță BigBlueButton.';
$string['guestaccess_copy_link'] = 'Copiază link';
$string['guestaccess_copy_password'] = 'Copiază parola';
$string['guestaccess_emails'] = 'Adrese de email ale vizitatorilor';
$string['guestaccess_emails_help'] = 'O listă de adrese de e-mail, separate prin virgule.';
$string['guestaccess_emails_invalidemail'] = 'E-mail nevalid: {$a}';
$string['guestaccess_feature_disabled'] = 'Accesul vizitatorilor este dezactivat.';
$string['guestaccess_invite_failure'] = 'Eroare {$a->errors} la invitarea {$a->emails}.';
$string['guestaccess_invite_success'] = 'O invitatție va fi trimisă la {$a->emails}.';
$string['guestaccess_join_meeting'] = 'Accesează întâlnirea';
$string['guestaccess_meeting_invalid_password'] = 'Parolă incorectă.';
$string['guestaccess_meeting_link'] = 'Link-ul sesiunii';
$string['guestaccess_meeting_not_started'] = 'Întâlnirea nu a început încă. Te rog intoarce-te mai tarziu.';
$string['guestaccess_meeting_password'] = 'Parola întâlnirii';
$string['guestaccess_password'] = 'Parolă';
$string['guestaccess_title'] = 'Adăugați invitați la această întâlnire';
$string['guestaccess_username'] = 'Nume de utilizator invitat';
$string['index_confirm_end'] = 'Doriți încheierea sesiunii?';
$string['index_disabled'] = 'dezactivat';
$string['index_enabled'] = 'activat';
$string['index_ending'] = 'Se închide sesiunea ... va rugăm să așteptați';
$string['index_error_bbtn'] = 'ID-ul BigBlueButton {$a} este incorect';
$string['index_error_checksum'] = 'A apărut o eroare. Verificați că ați introdus corect cheia de securitate.';
$string['index_error_forciblyended'] = 'Înscrierea la această întâlnire este imposibilă, deoarece a fost închisă manual.';
$string['index_error_noinstances'] = 'Nu se găsesc instanțe ale camerei de discuții Bigbluebutton';
$string['index_error_unable_display'] = 'Nu se pot afișa sesiunile. Vă rugăm să verificați URL-ul serverului BigBlueButton ȘI să verificați dacă serverul BigBlueButton este pornit.';
$string['index_heading'] = 'Camere BigBlueButton';
$string['index_heading_actions'] = 'Acțiuni';
$string['index_heading_group'] = 'Grup';
$string['index_heading_moderator'] = 'Moderatori';
$string['index_heading_name'] = 'Cameră';
$string['index_heading_recording'] = 'Înregistrare';
$string['index_heading_users'] = 'Utilizatori';
$string['index_heading_viewer'] = 'Spectatori';
$string['indicator:cognitivedepth'] = 'BigBlueButton cognitiv';
$string['indicator:cognitivedepth_help'] = 'Acest indicator este bazat pe cunoștințele acumulate de cursant într-o activitate BigBlueButton.';
$string['indicator:socialbreadth'] = 'BigBlueButton social';
$string['indicator:socialbreadth_help'] = 'Acest indicator este bazat pe interacțiunea socială realizată de cursant într-o activitate BigBlueButton.';
$string['instance_type_default'] = 'Camera de discuții cu înregistări';
$string['instance_type_recording_only'] = 'Doar înregistrări';
$string['instance_type_room_only'] = 'Doar camera de discuții';
$string['instanceprofilewithoutrecordings'] = 'Acest rol nu are permisiunea sa acceseze înregistrările';
$string['managebbbextplugins'] = 'Administrează extensiile plugin-ului BigBlueButton';
$string['messageprovider:instance_updated'] = 'Sesiune BigBlueButton actualizată';
$string['messageprovider:recording_ready'] = 'Înregistrare BigBlueButton disponibilă';
$string['minute'] = 'minut';
$string['minutes'] = 'minute';
$string['mod_form_block_general'] = 'General';
$string['mod_form_block_guestaccess'] = 'Acces vizitatori';
$string['mod_form_block_participants'] = 'Rol atribuit în timpul sesiunii live';
$string['mod_form_block_presentation'] = 'Conținutul prezentării';
$string['mod_form_block_presentation_default'] = 'Conținutul implicit al prezentării';
$string['mod_form_block_record'] = 'Setări înregistrare';
$string['mod_form_block_recordings'] = 'Vizualizare înregistare';
$string['mod_form_block_room'] = 'Setări cameră';
$string['mod_form_block_schedule'] = 'Durata sesiunii';
$string['mod_form_field_closingtime'] = 'Închide';
$string['mod_form_field_conference_name'] = 'Denumirea sesiunii';
$string['mod_form_field_disablecam'] = 'Dezactivează camere web';
$string['mod_form_field_disablemic'] = 'Dezactivează microfoane';
$string['mod_form_field_disablenote'] = 'Dezactivează notițe comune';
$string['mod_form_field_disableprivatechat'] = 'Dezactivează Camera de discuții privată';
$string['mod_form_field_disablepublicchat'] = 'Dezactivează Camera de discuții publică';
$string['mod_form_field_duration'] = 'Durată';
$string['mod_form_field_duration_help'] = 'Setarea duratei pentru o întâlnire va stabili durata maximă pentru care se menține activă o întâlnire înainte de a termina înregistrarea.';
$string['mod_form_field_guestallowed'] = 'Permite accesul vizitatorilor';
$string['mod_form_field_hideuserlist'] = 'Ascunde lista utilizatorilor';
$string['mod_form_field_instanceprofiles'] = 'Tipul de instanță';
$string['mod_form_field_instanceprofiles_help'] = 'Dacă urmează să fie înregistrată o sesiune, selectați „Cameră cu înregistrări”, în caz contrar, „Numai cameră de discuții”. După ce o sesiune este înregistrată, dacă nu vor mai exista sesiuni, selectați „Numai înregistrări”.';
$string['mod_form_field_intro'] = 'Descriere';
$string['mod_form_field_intro_help'] = 'O scurtă descriere a camerei de discuții.';
$string['mod_form_field_mustapproveuser'] = 'Vizitatorul care accesează întâlnirea trebuie să fie aprobat de moderator.';
$string['mod_form_field_muteonstart'] = 'Opriți sunetul la început';
$string['mod_form_field_name'] = 'Denumire cameră';
$string['mod_form_field_nosettings'] = 'Nicio setare nu poate fi editată';
$string['mod_form_field_openingtime'] = 'Deschide';
$string['mod_form_field_participant_add'] = 'Adaugă participant';
$string['mod_form_field_participant_bbb_role_moderator'] = 'Moderator';
$string['mod_form_field_participant_bbb_role_viewer'] = 'Spectator';
$string['mod_form_field_participant_list'] = 'Participant';
$string['mod_form_field_participant_list_action_add'] = 'Adaugă';
$string['mod_form_field_participant_list_action_remove'] = 'Șterge';
$string['mod_form_field_participant_list_text_as'] = 'participă la sesiune ca';
$string['mod_form_field_participant_list_type_all'] = 'Toți utilizatorii înrolați';
$string['mod_form_field_participant_list_type_owner'] = 'Proprietar';
$string['mod_form_field_participant_list_type_role'] = 'Rol';
$string['mod_form_field_participant_list_type_user'] = 'Utilizator';
$string['mod_form_field_record'] = 'Sesiunea poate să fie înregistrată.';
$string['mod_form_field_recordallfromstart'] = 'Înregistrează tot de la început';
$string['mod_form_field_recordhidebutton'] = 'Ascunde butonul de înregistrare';
$string['mod_form_field_recordings_deleted'] = 'Include înregistrările din activități șterse';
$string['mod_form_field_recordings_html'] = 'Afișați acest tabel în plain HTML';
$string['mod_form_field_recordings_imported'] = 'Afișați doar link-urile importate';
$string['mod_form_field_recordings_preview'] = 'Afișează previzualizarea înregistrării';
$string['mod_form_field_room_name'] = 'Denumirea camerei';
$string['mod_form_field_showpresentation'] = 'Afișează fișierul de prezentare în pagina activității';
$string['mod_form_field_userlimit'] = 'Limita de utilizatori';
$string['mod_form_field_userlimit_help'] = 'Limita maximă de utilizatori acceptați într-o sesiune. Dacă limita este setată la 0, numărul de utilizatori va fi nelimitat.';
$string['mod_form_field_voicebridge'] = 'Pod voce [####]';
$string['mod_form_field_voicebridge_format_error'] = 'Eroare format. Trebuie să inserați un număr între 1 and 9999.';
$string['mod_form_field_voicebridge_help'] = 'Un număr între 1 și 9999 pe care participanții îl introduc pentru a se alătura sesiunii de voce când folosesc apelarea. Dacă valoarea este 0, atunci numărul de punte vocală static va fi ignorat și un număr aleatoriu va fi generat de către BigBlueButton. Un număr 7 va prefixa cele patru cifre tastate.';
$string['mod_form_field_voicebridge_notunique_error'] = 'Nu este o valoare unică. Acest număr este folosit de altă cameră de discuții.';
$string['mod_form_field_wait'] = 'Așteaptă moderatorul';
$string['mod_form_field_wait_help'] = 'Participanții trebuie să aștepte un moderator înainte sa acceseze camera de discuții?';
$string['mod_form_field_welcome'] = 'Mesaj de întâmpinare';
$string['mod_form_field_welcome_default'] = 'Bine ai venit la %%CONFNAME%%.';
$string['mod_form_field_welcome_help'] = 'Mesajul de bun venit este afișat când participanții intră în cameră. Dacă câmpul este lăsat necompletat, se afișează un mesaj implicit setat în administrarea site-ului.';
$string['mod_form_locksettings'] = 'Blocați setările';
$string['modulename'] = 'BigBlueButton';
$string['modulename_help'] = 'BigBlueButton este un sistem de conferințe web open-source conceput pentru învățarea online, care acceptă partajarea în timp real a conținutului audio, video, chat, diapozitive, partajarea ecranului, o tablă albă pentru mai mulți utilizatori, săli de lucru, sondaje și emoji-uri.

Folosind BigBlueButton, puteți crea o cameră de discuții, cum ar fi cursuri online live, ore de birou virtuale sau colaborare în grup cu studenți la distanță. Sesiunea poate fi înregistrată pentru redare ulterioară.';
$string['modulename_link'] = 'BigBlueButton/view';
$string['modulenameplural'] = 'BigBlueButton';
$string['new_bigblubuttonbn_activities'] = 'Activitate BigBlueButton';
$string['nosuchinstance'] = 'Nu apare o asemenea instanță {$a->entity} cu identificatorul: {$a->id}';
$string['notification_instance_created_intro'] = 'Camera de discuții BigBlueButton <a href="{$a->link}">{$a->name}</a>  a fost creată.';
$string['notification_instance_created_small'] = 'O nouă cameră de discuții BigBlueButton denumită {$a->name} a fost creată';
$string['notification_instance_created_subject'] = 'O nouă cameră de discuții BigBlueButton a fost creată';
$string['notification_instance_description'] = 'Descriere';
$string['notification_instance_end_date'] = 'Data încheierii';
$string['notification_instance_name'] = 'Titlu';
$string['notification_instance_start_date'] = 'Data începerii';
$string['notification_instance_updated_intro'] = 'Camera de discuții BigBlueButton <a href="{$a->link}">{$a->name}</a> a fost actualizată.';
$string['notification_instance_updated_small'] = 'Sesiunea BigBlueButton {$a->name} a fost actualizată';
$string['notification_instance_updated_subject'] = 'Camera de discuții BigBlueButton a fost actualizată.';
$string['notification_recording_ready_html'] = 'O înregistrare a sesiunii este acum disponibilă în camera de discuții BigBlueButton <b><a href="{$a->link}">{$a->name}</a></b>.';
$string['notification_recording_ready_plain'] = 'Este disponibilă acum o înregistrare a sesiunii în camera de discuții BigBlueButton  {$a->name}. Mergi la {$a->link} pentru a aceesa link-ul înregistrării.';
$string['notification_recording_ready_small'] = 'Este disponibilă o nouă înregistrare pentru camera de discuții BigBlueButton {$a->name}';
$string['notification_recording_ready_subject'] = 'Înregistrare disponibilă';
$string['pluginadministration'] = 'Adminstrare BigBlueButton';
$string['pluginname'] = 'BigBlueButton';
$string['privacy:metadata:bigbluebutton'] = 'Pentru a crea și a se alătura sesiunilor BigBlueButton, datele utilizatorului trebuie schimbate cu serverul.';
$string['privacy:metadata:bigbluebutton:fullname'] = 'Numele complet al utilizatorului care accesează serverul BigBlueButton.';
$string['privacy:metadata:bigbluebutton:userid'] = 'Idntificatorul utilizatorului care accesează serverul BigBlueButton.';
$string['privacy:metadata:bigbluebuttonbn'] = 'Configurarea sesiunii BigBlueButton';
$string['privacy:metadata:bigbluebuttonbn:participants'] = 'O listă de reguli care definesc rolul pe care îl vor avea utilizatorii în sesiunea BigBlueButton. Un ID de utilizator poate fi stocat, deoarece permisiunile pot fi acordate pentru fiecare rol sau pentru fiecare utilizator.';
$string['privacy:metadata:bigbluebuttonbn_logs'] = 'Stochează evenimentele declanșate atunci când utilizați pluginul.';
$string['privacy:metadata:bigbluebuttonbn_logs:log'] = 'Tipul de eveniment determinat de utilizator.';
$string['privacy:metadata:bigbluebuttonbn_logs:meetingid'] = 'Identificatorul întâlnirii la care utilizatorul are acces.';
$string['privacy:metadata:bigbluebuttonbn_logs:meta'] = 'Stochează evenimentele declanșate atunci când utilizați pluginul.';
$string['privacy:metadata:bigbluebuttonbn_logs:timecreated'] = 'Data când a fost creat jurnalul.';
$string['privacy:metadata:bigbluebuttonbn_logs:userid'] = 'Numărul de identificare al utilizatorului care a declanșat evenimentului.';
$string['privacy:metadata:bigbluebuttonbn_recordings'] = 'Stochează metadate despre înregistrări.';
$string['privacy:metadata:bigbluebuttonbn_recordings:userid'] = 'ID-ul utilizatorului care a modificat ultima dată înregistrarea.';
$string['progress_createbigbluebuttonbn'] = 'Se creează activitate BigBlueButton ({$a})';
$string['recordings_from_deleted_activities'] = 'Înregistrări din activități șterse';
$string['recordingurlnotfound'] = 'URL-ul înregistrării nu este valid.';
$string['removedevents'] = 'Evenimente șterse';
$string['removedlogs'] = 'Jurnalele personalizate au fost șterse';
$string['removedrecordings'] = 'Șterge înregistrări';
$string['removedtags'] = 'Etichetări șterse';
$string['report_join_info'] = '{$a} discuție(i)';
$string['report_play_recording_info'] = '{$a} înregistrare(i) redate';
$string['report_room_view'] = 'vizualizat';
$string['resetevents'] = 'Șterge evenimente';
$string['resetlogs'] = 'Ștergeți jurnalele personalizate';
$string['resetlogs_help'] = 'Ștergerea jurnalelor va duce la pierderea referințelor la înregistrări.';
$string['resetrecordings'] = 'Șterge înregistrări';
$string['resetrecordings_help'] = 'Ștergerea înregistrărilor le va face inaccesibile. Această acțiune nu poate fi anulată!';
$string['resettags'] = 'Șterge etichete';
$string['search:activity'] = 'BigBlueButton - informații despre activitate';
$string['search:tags'] = 'BigBlueButton - informații despre etichete';
$string['sendnotification'] = 'Trimite notificare';
$string['settings'] = 'Setări BigBlueButton';
$string['settings_credential_warning'] = 'Credențialele serverului BigBlueButton vor expira în curând. Vezi <a href="{$a->settingslink}" target="_blank">setări generale BigBlueButton(se deschide în fereastră nouă)</a>.';
$string['settings_credential_warning_no_capability'] = 'Credențialele pentru server vor expira în curând. Vă rugăm să contactați administratorul site-ului.';
$string['started_at'] = 'Început';
$string['starts_at'] = 'Începe';
$string['subplugintype_bbbext'] = 'Extensia activității BigBlueButton';
$string['subplugintype_bbbext_plural'] = 'Extensiile activității BigBlueButton';
$string['taskname:check_dismissed_recordings'] = 'Caută înregistrări care nu au fost găsite încă';
$string['taskname:check_pending_recordings'] = 'Colectați înregistrările în așteptare';
$string['userlimitreached'] = 'A fost atins numărul de utilizatori acceptați la întâlnire.';
$string['view_conference_action_end'] = 'Încheie sesiunea';
$string['view_conference_action_join'] = 'Participați la sesiune';
$string['view_error_action_not_completed'] = 'Acțiunea nu a putut fi încheiată';
$string['view_error_bigbluebutton'] = 'BigBlueButton a dat erori. {$a}';
$string['view_error_create'] = 'Serverul BigBlueButton a dat o eroare. Camera de discuții nu a putut fi creată.';
$string['view_error_current_state_not_found'] = 'Starea actuală nu a fost găsită. Este posibil ca înregistrarea să fi fost ștearsă sau serverul BigBlueButton nu este compatibil cu acțiunea efectuată.';
$string['view_error_import_no_courses'] = 'Nu se găsesc cursuri în care să poată fi căutate înregistrări.';
$string['view_error_import_no_recordings'] = 'Nu sunt înregistrări în acest curs pentru a fi importate.';
$string['view_error_invalid_session'] = 'Sesiunea a expirat. Întoarceți-vă la pagina activității.';
$string['view_error_max_concurrent'] = 'Numărul de sesiuni simultane permise a fost atins.';
$string['view_error_meeting_not_running'] = 'A apărut o eroare: sesiunea nu rulează';
$string['view_error_no_group'] = 'Nu se găsesc grupuri încă. Vă rugăm să creați grupuri înainte de a încerca să vă înscrieți la întâlnire.';
$string['view_error_no_group_student'] = 'Nu ați fost înscris într-un grup. Vă rugăm să contactați profesorul.';
$string['view_error_no_group_teacher'] = 'Nu se găsesc grupuri. Trebuie să creați grupuri.';
$string['view_error_unable_join'] = 'Nu se poate aceesa camera de discuții. Vă rugăm să verificați URL-ul serverului BigBlueButton ȘI să verificați dacă serverul BigBlueButton rulează.';
$string['view_error_unable_join_student'] = 'Nu se poate conecta la server BigBlueButton.';
$string['view_error_unable_join_teacher'] = 'Nu se poate realiza conexiunea la server-ul BigBlueButton. Vă rugăm să contactați un administrator.';
$string['view_error_url_missing_parameters'] = 'Se găsesc parametri lipsă în acest URL';
$string['view_error_userlimit_reached'] = 'A fost atins numărul de utilizatori acceptați într-o sesiune.';
$string['view_groups_nogroups_warning'] = 'Camera de discuții a fost configurată pentru utilizarea de grupuri, dar cursul nu are grupuri definite.';
$string['view_groups_notenrolled_warning'] = 'Camera de discuții a fost configurată pentru utilizarea de grupuri, dar dumeavoastră nu sunteți membru al unui grup.';
$string['view_groups_selection'] = 'Selectați grupul la care doriți să vă înscrieți și confirmați acțiunea';
$string['view_groups_selection_join'] = 'Înscriere';
$string['view_groups_selection_warning'] = 'Există o cameră de discuții pentru fiecare grup iar dumneavoastră aveți acces la mai multe camere de discuții. Asigurați-vă că selectați grupul corect.';
$string['view_login_moderator'] = 'Autentificare în calitate de moderator ...';
$string['view_login_viewer'] = 'Autentificare în calitate de participant ...';
$string['view_message_and'] = 'și';
$string['view_message_conference_has_ended'] = 'Sesiunea s-a încheiat.';
$string['view_message_conference_in_progress'] = 'Sesiunea este în desfășurare.';
$string['view_message_conference_not_started'] = 'Sesiunea nu a început încă.';
$string['view_message_conference_room_ready'] = 'Camera de discuții este pregătită. Acum puteți accesa sesiunea.';
$string['view_message_conference_user_limit_reached'] = 'Numărul de utilizatori acceptați într-o sesiune a fost atins';
$string['view_message_conference_wait_for_moderator'] = 'Așteaptă moderatorul';
$string['view_message_cron_disabled'] = 'Este posibil ca lista înregistrărilor să nu fie actualizată. Te rugăm să contactezi administratorul site-ului cu următoarele informații: {$a}';
$string['view_message_finished'] = 'Activitatea s-a încheiat.';
$string['view_message_has_joined'] = 's-a alăturat';
$string['view_message_have_joined'] = 's-au alăturat';
$string['view_message_hour'] = 'oră';
$string['view_message_hours'] = 'ore';
$string['view_message_importrecordings_disabled'] = 'Link-ul pentru importul înregistrărilor este dezactivat pe server.';
$string['view_message_minute'] = 'minut';
$string['view_message_minutes'] = 'minute';
$string['view_message_moderator'] = 'Moderator';
$string['view_message_moderators'] = 'Moderatori';
$string['view_message_norecordings'] = 'Nu există înregistrări disponibile.';
$string['view_message_notavailableyet'] = 'Această sesiune nu este încă disponibilă.';
$string['view_message_recordings_disabled'] = 'Înregistrările sunt dezactivate pe server. Activitățile BigBlueButton de tip \'Doar înregistrări\' nu pot fi utilizate.';
$string['view_message_room_closed'] = 'Această cameră de discuții este închisă.';
$string['view_message_room_open'] = 'Această cameră de discuții este deschisă.';
$string['view_message_room_ready'] = 'Această cameră de discuții este pregătită.';
$string['view_message_session_for'] = 'sesiunea pentru';
$string['view_message_session_has_user'] = 'Este';
$string['view_message_session_has_users'] = 'Sunt';
$string['view_message_session_no_users'] = 'Nu există utilizatori în această sesiune';
$string['view_message_session_running_for'] = 'Sesiunea rulează de';
$string['view_message_session_started_at'] = 'Sesiunea a început la';
$string['view_message_tab_close'] = 'Tab-ul/fereastra trebuie închisă în mod manual';
$string['view_message_times'] = 'de câte ori';
$string['view_message_user'] = 'Utilizator';
$string['view_message_users'] = 'Utilizatori';
$string['view_message_viewer'] = 'Urmăritor';
$string['view_message_viewers'] = 'Urmăritori';
$string['view_mobile_message_groups_not_supported'] = 'Instanța este activată pentru a funcționa în grupuri dar nu este acceptată încă de aplicația mobilă. Te rugăm să folosești versiunea web.';
$string['view_mobile_message_reload_page_creation_time_meeting'] = 'Ai depășit 45 de secunde pe această pagină. Te rugăm să dai refresh paginii pentru a accesa sesiunea.';
$string['view_noguests'] = 'Camera BigBlueButton nu este accesibilă pentru vizitatori.';
$string['view_nojoin'] = 'Nu ai un rol cu permsiunea de participare la această sesiune.';
$string['view_recording'] = 'se înregistrează';
$string['view_recording_actionbar'] = 'Toolbar';
$string['view_recording_activity'] = 'Activitate';
$string['view_recording_button_import'] = 'Legăturile de import a înregistrării';
$string['view_recording_button_return'] = 'Mergi înapoi!';
$string['view_recording_course'] = 'Curs';
$string['view_recording_date'] = 'Dată';
$string['view_recording_delete_confirmation'] = 'Sunteți sigur că doriți să ștergeți această {$a}?';
$string['view_recording_delete_confirmation_warning_p'] = 'Această înregistrare are asociate link-urile {$a} care au fost importate într-un alt curs sau activitate. Dacă înregistrarea este ștearsă, aceste link-uri vor fi, de asemenea, șterse.';
$string['view_recording_delete_confirmation_warning_s'] = 'Această înregistrare are asociat link-ul {$a} care a fost importat într-un alt curs sau activitate. Dacă înregistrarea este ștearsă, acest link va fi, de asemenea, șters.';
$string['view_recording_description'] = 'Descriere';
$string['view_recording_description_edithint'] = 'O descriere poate fi adaugată pentru a vă ajuta să găsiți înregistrarea mai târziu.';
$string['view_recording_description_editlabel'] = 'Editează descrierea';
$string['view_recording_duration'] = 'Durată';
$string['view_recording_duration_min'] = 'min';
$string['view_recording_format_errror_unreachable'] = 'Adresa URL pentru acest format de înregistrare nu este accesibilă.';
$string['view_recording_format_notes'] = 'Notițe';
$string['view_recording_format_podcast'] = 'Podcast';
$string['view_recording_format_presentation'] = 'Prezentare';
$string['view_recording_format_screenshare'] = 'Screenshare';
$string['view_recording_format_statistics'] = 'Statistici';
$string['view_recording_format_video'] = 'Video';
$string['view_recording_import_confirmation'] = 'Sunteți sigur(ă) că doriți să importați această înregistrare?';
$string['view_recording_length'] = 'Lungime';
$string['view_recording_link'] = 'link importat';
$string['view_recording_link_warning'] = 'Aceasta este o legătură care indică o înregistrare care a fost creată într-un alt curs sau activitate.';
$string['view_recording_list_action_delete'] = 'Se șterge';
$string['view_recording_list_action_edit'] = 'Se actualizează';
$string['view_recording_list_action_play'] = 'Play';
$string['view_recording_list_action_process'] = 'Se procesează';
$string['view_recording_list_action_protect'] = 'Se protejează';
$string['view_recording_list_action_publish'] = 'Se publică';
$string['view_recording_list_action_unprotect'] = 'Se anulează protecția';
$string['view_recording_list_action_unpublish'] = 'Se anulează publicarea';
$string['view_recording_list_action_update'] = 'Se actualizează';
$string['view_recording_list_actionbar'] = 'Bară de unelte';
$string['view_recording_list_actionbar_delete'] = 'Șterge';
$string['view_recording_list_actionbar_edit'] = 'Editează';
$string['view_recording_list_actionbar_hide'] = 'Ascunde';
$string['view_recording_list_actionbar_import'] = 'Import';
$string['view_recording_list_actionbar_protect'] = 'Setați privat';
$string['view_recording_list_actionbar_publish'] = 'Publică';
$string['view_recording_list_actionbar_show'] = 'Arată';
$string['view_recording_list_actionbar_unprotect'] = 'Setați public';
$string['view_recording_list_actionbar_unpublish'] = 'Anulează publicarea';
$string['view_recording_list_activity'] = 'Activitate';
$string['view_recording_list_course'] = 'Curs';
$string['view_recording_list_date'] = 'Dată';
$string['view_recording_list_description'] = 'Descriere';
$string['view_recording_list_duration'] = 'Durată';
$string['view_recording_list_recording'] = 'Înregistrare';
$string['view_recording_meeting'] = 'Întâlnire';
$string['view_recording_modal_button'] = 'Aplică';
$string['view_recording_modal_title'] = 'Setați valori pentru înregistrare';
$string['view_recording_name'] = 'Nume';
$string['view_recording_name_edithint'] = 'Un nume poate fi adăugat pentru a vă ajuta să găsiți înregistrarea mai târziu';
$string['view_recording_name_editlabel'] = 'Editează denumirea';
$string['view_recording_playback'] = 'Playback';
$string['view_recording_preview'] = 'Previzualizare';
$string['view_recording_preview_help'] = 'Plasați cursorul peste o imagine pentru a o vizualiza la dimensiune completă';
$string['view_recording_protect_confirmation'] = 'Sunteți sigur că doriți să protejați această {$a}?';
$string['view_recording_protect_confirmation_warning_p'] = 'Această înregistrare are link-urile asociate {$a} care au fost importate într-un curs sau activitate diferite. Dacă înregistrarea este protejată, va afecta și link-urile importate.';
$string['view_recording_protect_confirmation_warning_s'] = 'Această înregistrare are link-ul asociat {$a} care a fost importat într-un curs sau activitate diferite. Dacă înregistrarea este protejată, va afecta și link-urile importate.';
$string['view_recording_publish_confirmation'] = 'Sunteți sigur că doriți să publicați această {$a}?';
$string['view_recording_publish_confirmation_warning_p'] = 'Această înregistrare are link-urile asociate {$a} care au fost importate în cursuri sau activități diferite. Dacă înregistrarea este publicată, aceste link-uri vor fi, de asemenea, publicate.';
$string['view_recording_publish_confirmation_warning_s'] = 'Această înregistrare are link-ul asociat {$a} care a fost importat într-un curs sau activitate diferite. Dacă înregistrarea este publicată, acest link va fi, de asemenea, publicat.';
$string['view_recording_publish_link_deleted'] = 'Acest link nu poate fi republicat deoarece înregistrarea originală nu există pe sever-ul BigBlueButton. Acest link ar trebui șters.';
$string['view_recording_publish_link_not_published'] = 'Acest link nu poate fi republicat deoarece înregistrarea originală este nepublicată.';
$string['view_recording_recording'] = 'Înregistrare';
$string['view_recording_select_course'] = 'Selectați mai întâi un curs din meniul derulant';
$string['view_recording_tags'] = 'Etichete';
$string['view_recording_unprotect_confirmation'] = 'Sunteți sigur că doriți să anulați protecția acestui {$a}?';
$string['view_recording_unprotect_confirmation_warning_p'] = 'Această înregistrare are link-urile {$a} asociate care au fost importate în cursuri sau activități diferite. Dacă această înregistrare este neprotejată, va afecta, de asemenea, și link-urile importate.';
$string['view_recording_unprotect_confirmation_warning_s'] = 'Această înregistrare are link-ul {$a} asociat care a fost importate într-un curs sau activitate diferită. Dacă această înregistrare este neprotejată, va afecta, de asemenea, și link-urile importate.';
$string['view_recording_unprotect_link_deleted'] = 'Acestei legături nu i se poate anula protecția deoarece înregistrarea originală nu există pe serverul BigBlueButton. Linkul ar trebui eliminat.';
$string['view_recording_unprotect_link_not_unprotected'] = 'Acestui link nu i se poate anula protecția deoarece înregistrarea originală este protejată.';
$string['view_recording_unpublish_confirmation'] = 'Sunteți sigur că doriți să anulați publicarea acestui {$a}?';
$string['view_recording_unpublish_confirmation_warning_p'] = 'Această înregistrare are asociate {$a} linkuri care au fost importate în diferite cursuri sau activități. Dacă înregistrarea este nepublicată, aceste link-uri vor fi, de asemenea, nepublicate.';
$string['view_recording_unpublish_confirmation_warning_s'] = 'Această înregistrare are asociat un link {$a} care a fost importat într-un alt curs sau activitate. Dacă înregistrarea este nepublicată, acest link va fi, de asemenea, nepublicat.';
$string['view_recording_yui_first'] = 'Primul';
$string['view_recording_yui_go'] = 'Mergi mai departe';
$string['view_recording_yui_last'] = 'Ultimul';
$string['view_recording_yui_next'] = 'Următor';
$string['view_recording_yui_page'] = 'Pagină';
$string['view_recording_yui_prev'] = 'Precedent';
$string['view_recording_yui_rows'] = 'Rânduri';
$string['view_recording_yui_show_all'] = 'Afișează tot';
$string['view_room'] = 'Vezi camera de discuții';
$string['view_section_title_presentation'] = 'Fișier de prezentare';
$string['view_section_title_recordings'] = 'Înregistrări';
$string['view_warning_default_server'] = 'Acest site folosește un <a href="https://bigbluebutton.org/free-bigbluebutton-service-for-moodle/" target="_blank">serviciu BigBlueButton gratuit pentru Moodle (se deschide într-o fereastră nouă)</a> furnizat de Blindside Networks cu restricții după cum urmează:
<ol>
<li>Durata maximă pentru fiecare sesiune este de 60 de minute</li>
<li>Numărul maxim de utilizatori simultani pe sesiune este de 25</li>
<li>Înregistrările expiră după șapte (7) zile și nu pot fi descărcate</li>
<li>Camele web ale studenților sunt vizibile numai pentru moderator.</li>
</ol>';
$string['waitformoderator'] = 'Așteptați un moderator.';
