<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_boost_union', language 'pt_br', version '4.5'.
 *
 * @package     theme_boost_union
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutuscontentsetting'] = 'Conteúdo sobre nós';
$string['aboutuscontentsetting_desc'] = 'Nesta configuração, você pode adicionar conteúdo rico em texto que será exibido na página sobre nós.';
$string['aboutusdisabled'] = 'A página sobre nós está desativada para este site. Não há nada para ver aqui.';
$string['aboutusheading'] = 'Sobre nós';
$string['aboutuslinkpositionboth'] = 'Adicionar um link para a página sobre nós na nota de rodapé e no ícone (ponto de interrogação) do rodapé';
$string['aboutuslinkpositionfooter'] = 'Adicionar um link para a página sobre nós no ícone (ponto de interrogação) do rodapé';
$string['aboutuslinkpositionfootnote'] = 'Adicionar um link para a página sobre nós na nota de rodapé';
$string['aboutuslinkpositionnone'] = 'Não mostrar automaticamente um link para a página sobre nós';
$string['aboutuslinkpositionsetting'] = 'Posição do link sobre nós';
$string['aboutuslinkpositionsetting_desc'] = 'Nesta configuração, você pode definir se um link para a página sobre nós deve ser adicionado automaticamente à página do Moodle. Caso não queira mostrar o link automaticamente, você pode adicionar um link para {$a->url} em qualquer lugar do Moodle manualmente.';
$string['aboutuspagetitledefault'] = 'Sobre nós';
$string['aboutuspagetitlesetting'] = 'Título da página sobre nós';
$string['aboutuspagetitlesetting_desc'] = 'Nesta configuração, você pode definir o título da página sobre nós. Este texto também será usado como texto de link para a página sobre nós se você configurar a \'Posição do link Sobre nós\' adequadamente.';
$string['activitiesheading'] = 'Bloco de atividades';
$string['activitiestintenabled'] = 'Colorir ícones de atividades';
$string['activitiestintenabled_desc'] = 'Com esta configuração, você pode colorir os ícones de atividade no bloco de atividades com base no propósito das atividades. Por padrão, o Moodle exibe apenas ícones pretos.';
$string['activitybrandingtab'] = 'Identidade visual das atividades';
$string['activityiconcoloradministrationsetting'] = 'Cor do ícone de atividade para "Administração"';
$string['activityiconcoloradministrationsetting_desc'] = 'Cor do ícone da atividade para "Avaliação"';
$string['activityiconcolorassessmentsetting'] = 'Cor do ícone da atividade para "Avaliação"';
$string['activityiconcolorassessmentsetting_desc'] = 'A cor do ícone da atividade para "Avaliação"';
$string['activityiconcolorcollaborationsetting'] = 'Cor do ícone da atividade para "Colaboração"';
$string['activityiconcolorcollaborationsetting_desc'] = 'A cor do ícone da atividade para "Colaboração';
$string['activityiconcolorcommunicationsetting'] = 'Cor do ícone da atividade para "Comunicação"';
$string['activityiconcolorcommunicationsetting_desc'] = 'A cor do ícone da atividade para "Comunicação"';
$string['activityiconcolorcontentsetting'] = 'Cor do ícone da atividade para "Conteúdo"';
$string['activityiconcolorcontentsetting_desc'] = 'A cor do ícone de atividade para "Conteúdo"';
$string['activityiconcolorfidelity_detailled'] = 'Pesquisa detalhada (até 100 iterações)';
$string['activityiconcolorfidelity_insane'] = 'Busca intensa (até 500 iterações)';
$string['activityiconcolorfidelity_oneshot'] = 'Tentativa única (1 iteração)';
$string['activityiconcolorfidelity_sometries'] = 'Algumas tentativas (até 10 iterações)';
$string['activityiconcolorfidelitysetting'] = 'Fidelidade de cor do ícone de atividade';
$string['activityiconcolorfidelitysetting_desc'] = 'Nas configurações acima, você define uma cor hexadecimal que será usada para colorir o ícone de atividade específico. No entanto, o ícone é colorido com um filtro CSS. O Boost Union usa um algoritmo sofisticado para determinar o filtro CSS que mais se aproxima da cor hexadecimal, mas esse algoritmo é baseado em uma busca aleatória, podendo produzir resultados subótimos se executado apenas uma vez. Com esta configuração, você permite que o Boost Union execute o algoritmo várias vezes e escolha o filtro mais fiel à cor no final. Observe que essa configuração impacta o tempo de limpeza de cache, mas não afeta o tempo de carregamento da página.';
$string['activityiconcolorinteractivecontentsetting'] = 'Cor no ícone de atividade para "Conteúdo interativo"';
$string['activityiconcolorinteractivecontentsetting_desc'] = 'A cor do ícone de atividade para "Conteúdo interativo"';
$string['activityiconcolorinterfacesetting'] = 'Cor do ícone de atividade para "Interface"';
$string['activityiconcolorinterfacesetting_desc'] = 'A cor do ícone de atividade para "Interface"';
$string['activityiconcolorsheading'] = 'Cores dos ícones de atividades';
$string['activitynavigationsetting'] = 'Elementos de navegação de atividades e seções';
$string['activitynavigationsetting_desc'] = 'Com esta configuração, os elementos para saltar para a atividade/recurso anterior e seguinte, bem como o menu suspenso para saltar para uma atividade/recurso distinto, são exibidos. Além disso, nos cursos que utilizam o modo \'uma seção por página\', também são exibidos elementos semelhantes para a seção anterior e seguinte. Elementos de UI como este já existiam no Boost no Moodle Core até o Moodle 3.11, mas foram removidos no 4.0. Com o Boost Union, você pode trazê-los de volta.';
$string['activitypurposeadministration'] = 'Administração';
$string['activitypurposeassessment'] = 'Avaliação';
$string['activitypurposecollaboration'] = 'Colaboração';
$string['activitypurposecommunication'] = 'Comunicação';
$string['activitypurposecontent'] = 'Conteúdo';
$string['activitypurposeheading'] = 'Propósito dos ícones de atividades';
$string['activitypurposeheading_desc'] = 'Com essas configurações, você pode substituir a cor de fundo do ícone de atividade, defina pelo propósito da atividade (um recurso codificado em cada plugin de atividade).';
$string['activitypurposeheadingtechnote'] = 'Nota técnica: Devido à implementação das cores e propósitos das atividades no Moodle, os propósitos das atividades são substituídos apenas com CSS pelo Boost Union. Atualmente, todas as áreas no Moodle que exibem ícones coloridos devem ser cobertas. Se encontrar uma área ou plugin de terceiros que exiba as cores originais, reporte em {$a}.';
$string['activitypurposeinteractivecontent'] = 'Conteúdo interativo';
$string['activitypurposeinterface'] = 'Interface';
$string['activitypurposeother'] = 'Outros';
$string['additionalresourcesfileurlpersistent'] = 'URL (persistente)';
$string['additionalresourcesfileurlrevisioned'] = 'URL (versão)';
$string['additionalresourcesheading'] = 'Recursos adicionais';
$string['additionalresourceslistsetting'] = 'Lista de recursos adicionais';
$string['additionalresourceslistsetting_desc'] = 'Está é a lista de arquivos que você carregou na área de arquivos de recursos adicionais. As URLs fornecidas podem ser usadas para vincular esses arquivos no CSS personalizado, na nota de rodapé ou onde precisar usar arquivos carregados mas não puder carregar diretamente.';
$string['additionalresourcessetting'] = 'Recursos adicionais';
$string['additionalresourcessetting_desc'] = 'Com esta configuração, você pode carregar recursos adicionais no tema. A vantagem de usar esta área de arquivos é que eles podem ser entregues sem verificar se os usuário está logado. Apenas carregue arquivos que não precisem de proteção de login. Assim que pelo menos um arquivo for carregado e as configurações salvas, uma lista aparecerá com as URLs que você pode usar para referência.';
$string['addpreferredlangsetting'] = 'Adicionar link de idioma preferido ao menu de idiomas';
$string['addpreferredlangsetting_desc'] = 'Com esta configuração, você pode adicionar uma configuração \'Definir idioma preferido\' ao menu de idiomas no menu do usuário. Compreensivelmente, esta configuração só será processada se a configuração <a href="{$a->url1}">Exibir menu de idioma</a> estiver ativada e se pelo menos <a href="{$a->url2} ">um segundo pacote de idioma é instalado</a> e <a href="{$a->url3}">oferecido para seleção</a>.';
$string['administrationtab'] = 'Administração';
$string['alternativelogolinkurlsetting'] = 'URL alternativa de link do logotipo';
$string['alternativelogolinkurlsetting_desc'] = 'Com esta configuração, você pode definir uma URL alternativa como link no logotipo da barra de navegação. Isso pode ser usado, por exemplo, para direcionar ao site da sua organização em vez da página inicial do Moodle.';
$string['backgroundimagepositionsetting'] = 'Posição da imagem de fundo';
$string['backgroundimagepositionsetting_desc'] = 'Nesta configuração, você controla o posicionamento da imagem de fundo na janela do navegador. O primeiro valor é a posição horizontal, e o segundo a vertical.';
$string['backgroundimagesetting'] = 'Imagem de fundo';
$string['backgroundimagesetting_desc'] = 'Aqui, você pode carregar uma imagem personalizada para exibir como fundo do site. A imagem aqui carregada substituirá a imagem de fundo dos arquivos de tema.';
$string['backgroundimagesheading'] = 'Imagens de fundo gerais';
$string['backtotop'] = 'Voltar ao topo';
$string['backtotopbuttonsetting'] = 'Botão Voltar ao topo';
$string['backtotopbuttonsetting_desc'] = 'Com esta configuração, um botão de voltar ao topo aparecerá no canto inferior direito da página assim que o usuário rolar para baixo. Esse botão já existia no Boost até o Moodle 3.11, mas foi removido na versão 4.0. Com o Boost Union, é possível recuperá-lo.';
$string['blockdrawerwidthsetting'] = 'Largura da gaveta de blocos';
$string['blockdrawerwidthsetting_desc'] = 'Com esta configuração, você pode ajustar a largura da gaveta de blocos do Moodle sem modificar o SCSS. Por padrão, o Moodle usa uma largura máxima de conteúdo de 315px, mas você pode inserir outros valores em pixels, como 400px.';
$string['blockregionfooterwidth'] = 'Largura da região do bloco para a região \'Rodapé\'';
$string['blockregionfooterwidth_desc'] = 'Com esta configuração, você pode definir a largura da região do bloco \'Rodapé\'. Você pode escolher entre largura total, largura do conteúdo do curso e largura do herói.';
$string['blockregionoutsidebottomwidth'] = 'Largura da região do bloco para a região \'Externa (inferior)\'';
$string['blockregionoutsidebottomwidth_desc'] = 'Com esta configuração, você pode definir a largura da região do bloco \'Externo (inferior)\' que é mostrada abaixo do conteúdo principal. Você pode escolher entre largura total, largura do conteúdo do curso e largura do herói.';
$string['blockregionoutsideleftwidth'] = 'Largura da região do bloco para a região \'Externa (esquerda)\'';
$string['blockregionoutsideleftwidth_desc'] = 'Com esta configuração, você pode definir a largura da região do bloco \'Externo (esquerda)\' que é mostrada no lado esquerdo da área de conteúdo principal. Por padrão, Boost Union usa uma largura de 300px. Você pode inserir outros valores baseados em pixels, como 200px, mas também pode inserir um valor percentual, como 10%, ou um valor de largura da janela de visualização, como 10vw.';
$string['blockregionoutsiderightwidth'] = 'Largura da região do bloco para a região \'Externa (direita)\'';
$string['blockregionoutsiderightwidth_desc'] = 'Com esta configuração, você pode definir a largura da região do bloco \'Externo (direita)\' que é mostrada no lado direito da área de conteúdo principal. Por padrão, Boost Union usa uma largura de 300px. Você pode inserir outros valores baseados em pixels, como 200px, mas também pode inserir um valor percentual, como 10%, ou um valor de largura da janela de visualização, como 10vw.';
$string['blockregionoutsidetopwidth'] = 'Largura da região do bloco para a região \'Externa (superior)\'';
$string['blockregionoutsidetopwidth_desc'] = 'Com esta configuração, você pode definir a largura da região do bloco \'Externo (topo)\' que é mostrada no topo da página. Você pode escolher entre largura total, largura do conteúdo do curso e largura do herói.';
$string['blockregionsforlayout'] = 'Regiões de bloco adicionais para layout \'{$a}\'';
$string['blockregionsforlayout_desc'] = 'Com esta configuração, você pode ativar regiões de bloco adicionais para o layout \'{$a}\'.';
$string['blockregionsheading'] = 'Regiões de blocos adicionais';
$string['blockregionsheading_desc'] = '<p>Boost Union fornece um grande número de regiões de bloco adicionais que podem ser usadas para adicionar e mostrar blocos em toda a página Moodle:</p> <ul><li>As <em>regiões de bloco externas</em> são colocado em todos os quatro lados da página Moodle. Eles podem ser usados para mostrar blocos que acompanham a página Moodle mostrada, mas não pertencem diretamente ao conteúdo principal.</li> <li>A <em>região do bloco de cabeçalho</em> é colocada entre a área externa (superior). e a área de conteúdo principal. Ele pode ser usado para mostrar um bloco como informação de cabeçalho do curso.</li> <li>As <em>regiões do bloco de conteúdo</em> são colocadas diretamente acima e abaixo do conteúdo principal na área de conteúdo principal. Eles podem ser usados para adicionar blocos ao fluxo de conteúdo do curso.</li> <li>As <em>regiões de blocos de rodapé</em> são colocadas na parte inferior da página, entre a área externa (inferior) e a nota de rodapé. Você tem três regiões de rodapé disponíveis para construir colunas, se necessário.</li> <li>A <em>região de bloco fora da tela</em> é de alguma forma especial, pois paira sobre toda a página do Moodle como uma gaveta. A gaveta é aberta pelo ícone de 9 pontos no lado direito da barra de navegação. Você tem três regiões fora da tela disponíveis para construir colunas, se necessário.</li></ul> <p>Observação:</p> <ul><li>Por padrão, todas as regiões de bloco adicionais estão desativadas. Ative as regiões de bloqueio específicas nos layouts de página específicos de acordo com suas necessidades. Tente ser o mais focado possível: muitas regiões de bloqueio podem sobrecarregar os usuários finais.</li> <li>Assim que uma região de bloqueio adicional for ativada, ela ficará visível para todos os usuários autenticados e poderá ser editada por professores e gerentes (dependendo de o fato de um determinado usuário ter permissão para editar a página específica do Moodle, é claro). Mas também existem recursos theme/boost_union:viewregion* e theme/boost_union:editregion* que permitem ajustar o uso de cada região de bloco de acordo com suas necessidades.</li> <li>O Exterior (esquerda), Exterior (direita), conteúdo (superior), conteúdo (inferior) e regiões de bloco de cabeçalho não estão disponíveis para todos os layouts de página.</li></ul>';
$string['blockregionsheading_experimental'] = 'Nota: As regiões de bloco "Fora (esquerda)" e "Fora (direita)" estão em pleno funcionamento, mas são <em>experimentais</em> e podem não ajustar adequadamente em telas de largura média. Por isso, use-as com cuidado. Esse problema será resolvido em uma versão futura.';
$string['blocksgeneralheading'] = 'Blocos gerais';
$string['blockstab'] = 'Blocos';
$string['boost_union:configure'] = 'Para configurar o tema sem ser admin';
$string['boost_union:editregioncontentlower'] = 'Para editar a região de bloco Conteúdo (inferior)';
$string['boost_union:editregioncontentupper'] = 'Para editar a região de bloco Conteúdo (superior)';
$string['boost_union:editregionfootercenter'] = 'Para editar a região de bloco Conteúdo (centro)';
$string['boost_union:editregionfooterleft'] = 'Para editar a região de bloco Conteúdo (esquerda)';
$string['boost_union:editregionfooterright'] = 'Para editar a região de bloco Conteúdo (direita)';
$string['boost_union:editregionheader'] = 'Para editar a região de bloco Cabeçalho';
$string['boost_union:editregionoffcanvascenter'] = 'Para editar a região de bloco Off-canvas (centro)';
$string['boost_union:editregionoffcanvasleft'] = 'Para editar a região de bloco Off-canvas (esquerda)';
$string['boost_union:editregionoffcanvasright'] = 'Para editar a região de bloco Off-canvas (direita)';
$string['boost_union:editregionoutsidebottom'] = 'Permissão para editar a região Outside (inferior) dos blocos';
$string['boost_union:editregionoutsideleft'] = 'Permissão para editar a região Outside (esquerda) dos blocos';
$string['boost_union:editregionoutsideright'] = 'Permissão para editar a região Outside (direita) dos blocos';
$string['boost_union:editregionoutsidetop'] = 'Permissão para editar a região Outside (superior) dos blocos';
$string['boost_union:viewhintcourseselfenrol'] = 'Permissão para ver uma dica de auto-inscrição irrestrita em curso visível.';
$string['boost_union:viewhintinhiddencourse'] = 'Permissão para ver uma dica em curso oculto.';
$string['boost_union:viewregioncontentlower'] = 'Permissão para ver a região Content (inferior) dos blocos';
$string['boost_union:viewregioncontentupper'] = 'Permissão para ver a região Content (superior) dos blocos';
$string['boost_union:viewregionfootercenter'] = 'Permissão para ver a região Footer (central) dos blocos';
$string['boost_union:viewregionfooterleft'] = 'Permissão para ver a região Footer (esquerda) dos blocos';
$string['boost_union:viewregionfooterright'] = 'Permissão para ver a região Footer (direita) dos blocos';
$string['boost_union:viewregionheader'] = 'Permissão para ver a região Header dos blocos';
$string['boost_union:viewregionoffcanvascenter'] = 'Permissão para ver a região Off-canvas (central) dos blocos';
$string['boost_union:viewregionoffcanvasleft'] = 'Permissão para ver a região Off-canvas (esquerda) dos blocos';
$string['boost_union:viewregionoffcanvasright'] = 'Permissão para ver a região Off-canvas (direita) dos blocos';
$string['boost_union:viewregionoutsidebottom'] = 'Permissão para ver a região Outside (inferior) dos blocos';
$string['boost_union:viewregionoutsideleft'] = 'Permissão para ver a região Outside (esquerda) dos blocos';
$string['boost_union:viewregionoutsideright'] = 'Permissão para ver a região Outside (direita) dos blocos';
$string['boost_union:viewregionoutsidetop'] = 'Permissão para ver a região Outside (superior) dos blocos';
$string['bootstrapcolordangersetting'] = 'Cor de "Danger" no Bootstrap';
$string['bootstrapcolordangersetting_desc'] = 'A cor de "Danger" no Bootstrap';
$string['bootstrapcolorinfosetting'] = 'Cor de "Info" no Bootstrap';
$string['bootstrapcolorinfosetting_desc'] = 'A cor de "Info" no Bootstrap';
$string['bootstrapcolorsheading'] = 'Cores do Bootstrap';
$string['bootstrapcolorsuccesssetting'] = 'Cor de "Success" no Bootstrap';
$string['bootstrapcolorsuccesssetting_desc'] = 'A cor de "Success" no Bootstrap';
$string['bootstrapcolorwarningsetting'] = 'Cor de "Warning" no Bootstrap';
$string['bootstrapcolorwarningsetting_desc'] = 'A cor de "Warning" no Bootstrap';
$string['bootstrapdangercolor'] = 'Cor de Danger';
$string['bootstrapdarkcolor'] = 'Cor Dark';
$string['bootstrapinfocolor'] = 'Cor Info';
$string['bootstraplightcolor'] = 'Cor Light';
$string['bootstrapnone'] = 'Sem cor do Bootstrap';
$string['bootstrapprimarycolor'] = 'Cor primária';
$string['bootstrapsecondarycolor'] = 'Cor secundária';
$string['bootstrapsuccesscolor'] = 'Cor Sucesso';
$string['bootstrapwarningcolor'] = 'Cor Warning';
$string['brandcolorsheading'] = 'Cores de marca';
$string['breadcrumbsheading'] = 'Breadcrumbs';
$string['cachedef_flavours'] = 'Presets aplicáveis ao ID da categoria de página para o usuário atual';
$string['cachedef_smartmenu_items'] = 'Itens de menu inteligente';
$string['cachedef_smartmenus'] = 'Menus inteligentes';
$string['cachedef_touchiconsios'] = 'Arquivos de ícone de toque para iOS';
$string['calendareventtypecategory'] = 'Categoria';
$string['calendareventtypecourse'] = 'Curso';
$string['calendareventtypegroup'] = 'Grupo';
$string['calendareventtypeother'] = 'Outro';
$string['calendareventtypesite'] = 'Site';
$string['calendareventtypeuser'] = 'Usuário';
$string['categorybreadcrumbs'] = 'Exibir o caminho da categoria no cabeçalho do curso';
$string['categorybreadcrumbs_desc'] = 'Por padrão, o caminho da categoria não é exibido no cabeçalho. Esta opção ativa a exibição acima do nome do curso.';
$string['categoryindextab'] = 'Índice de categorias / Página inicial';
$string['categorylistingheading'] = 'Listagem de categorias';
$string['categorylistingpresentation'] = 'Apresentação da listagem de categorias';
$string['categorylistingpresentation_boxlist'] = 'Lista de caixas';
$string['choosereadme'] = '<p>Theme Boost Union é um tema filho aprimorado do Boost que tem como objetivo, por um lado, tornar o Boost simplesmente mais configurável e, por outro lado, fornecer recursos adicionais úteis para a operação diária do Moodle de administradores, professores e alunos.</p><p>Boost Union é mantido por<br />Moodle an Hochschulen e.V.,</p><p>em cooperação com<br />lern.link GmbH </p><p>juntamente com<br />bdecent GmbH</p>';
$string['closeoffcanvas'] = 'Fechar o menu Off-canvas';
$string['configtitle'] = 'Boost Union';
$string['configtitleaccessibility'] = 'Acessibilidade';
$string['configtitlecontent'] = 'Conteúdo';
$string['configtitlefeel'] = 'Aparência';
$string['configtitleflavours'] = 'Presets';
$string['configtitlefunctionality'] = 'Funcionalidade';
$string['configtitlelook'] = 'Visual';
$string['contactcontentsetting'] = 'Conteúdo da página de contato';
$string['contactcontentsetting_desc'] = 'Nesta configuração, você pode adicionar conteúdo rich text que será mostrado em uma página de contato (que não é a mesma que a página integrada de \'Contato com o suporte do site\' do Moodle).';
$string['contactdisabled'] = 'A página de contato está desativada para este site.';
$string['contactheading'] = 'Cotneto';
$string['contactlinkpositionboth'] = 'Adicionar link para a página de contato no rodapé e ícone (ponto de interrogação)';
$string['contactlinkpositionfooter'] = 'Adicionar link para a página de contato no ícone (ponto de interrogação) do rodapé';
$string['contactlinkpositionfootnote'] = 'Adicionar link para a página de contato no rodapé';
$string['contactlinkpositionnone'] = 'Não exibir automaticamente o link para a página de contato';
$string['contactlinkpositionsetting'] = 'Posição do link da página de contato';
$string['contactlinkpositionsetting_desc'] = 'Nesta configuração você pode configurar se um link para a página de contato deve ser adicionado automaticamente à página Moodle. Se você não quiser mostrar um link automaticamente, você pode adicionar um link para {$a->url} de qualquer lugar do Moodle manualmente.';
$string['contactpagetitledefault'] = 'Contato';
$string['contactpagetitlesetting'] = 'Título da página de contato';
$string['contactpagetitlesetting_desc'] = 'Nesta configuração, você pode definir o título da página de contato. Este texto também será usado como texto de link para a página de contato se você configurar a \'Posição do link da página de contato\' adequadamente.';
$string['contentwidthheading'] = 'Largura do conteúdo';
$string['coursecardscolumncount'] = 'Quantidade de colunas de "cards" de cursos';
$string['coursecontentmaxwidthsetting'] = 'Largura máxima do conteúdo do curso';
$string['coursecontentmaxwidthsetting_desc'] = 'Controla a largura do conteúdo do curso sem modificações SCSS manuais. A largura padrão é 830px, mas pode ser personalizada com valores em pixels, percentuais ou largura de viewport.';
$string['courseheaderheading'] = 'Cabeçalho do curso';
$string['courseheaderimageenabled'] = 'Exibir a imagem do curso no cabeçalho';
$string['courseheaderimageenabled_desc'] = 'Quando ativado, a imagem do curso (que pode ser carregada nas configurações do curso) é exibida no cabeçalho do curso. As imagens dos cursos são mostradas ali, além da página \'Meus cursos\', onde são sempre mostradas.';
$string['courseheaderimagefallback'] = 'Imagem alternativa para o cabeçalho do curso';
$string['courseheaderimagefallback_desc'] = 'Se você carregar uma imagem nesta configuração, ela será usada como imagem alternativa é exibida no cabeçalho do curso, caso nenhuma imagem específica seja carregada nas configurações desse curso. Se você não carregar uma imagem aqui, uma imagem de cabeçalho será exibida apenas nos cursos que tiverem uma imagem específica configurada em suas respectivas configurações.';
$string['courseheaderimageheight'] = 'Altura da imagem do cabeçalho do curso';
$string['courseheaderimageheight_desc'] = 'Controla a altura da imagem do cabeçalho do curso';
$string['courseheaderimagelayout'] = 'Layout da imagem do cabeçalho do curso';
$string['courseheaderimagelayout_desc'] = 'Controla o layout da imagem e título do curso.';
$string['courseheaderimagelayoutheadingabove'] = 'Título do curso acima da imagem';
$string['courseheaderimagelayoutstackeddark'] = 'Título do curso sobreposto na imagem (fonte branca para imagens escuras)';
$string['courseheaderimagelayoutstackedlight'] = 'Título do curso sobreposto na imagem (fonte branca para imagens claras)';
$string['courseheaderimageposition'] = 'Posição da imagem no cabeçalho do curso';
$string['courseheaderimageposition_desc'] = 'Com essa configuração você controla o posicionamento da imagem de cabeçalho do curso dentro do contêiner da imagem de cabeçalho. O primeiro valor define a posição horizontal e o segundo valor defina a posição vertical.';
$string['courseindexcompletioninfoposition'] = 'Posição da indicação de conclusão de atividade';
$string['courseindexcompletioninfoposition_desc'] = 'Escolha a posição onde a indicação de conclusão será exibida. <em>Fim da linha</em> exibe o indicador padrão de conclusão no final da linha do índice do curso. <em>Início da linha</em> exibe o indicador padrão de conclusão no início da linha no índice do curso. <em>Cor do ícone</em> não exibe o indicador padrão de conclusão, mas codifica a informação de conclusão como plano de fundo do ícone do módulo do curso.';
$string['courseindexcompletioninfopositionendofline'] = 'Fim da linha';
$string['courseindexcompletioninfopositioniconcolor'] = 'Cor do ícone';
$string['courseindexcompletioninfopositionstartofline'] = 'Início da linha';
$string['courseindexdrawerwidthsetting'] = 'Largura da gaveta do índice do curso';
$string['courseindexdrawerwidthsetting_desc'] = 'Com esta configuração, você pode substituir a largura da gaveta do índice do curso do Moodle sem modificações manuais em SCSS. Por padrão, o Moodle usa uma largura de gaveta de 285px. Você pode inserir valores em pixels como 320px, mas valores com outras unidades, como porcentagem ou largura da viewport, não funcionarão.';
$string['courseindexheading'] = 'Índice do curso';
$string['courseindexmodiconenabled'] = 'Exibir ícones de tipo de atividade no índice do curso';
$string['courseindexmodiconenabled_desc'] = 'Quando ativada, o ícone correspondente ao tipo de atividade é exibido na frente da linha do índice com o título da atividade. Isso faz com que o tipo de atividade do curso substitua o indicador de conclusão, que é movido da frente para o final da linha do índice do curso, ou seja colorido pela cor do estado de conclusão.';
$string['courseistingprogressstyle'] = 'Estilo do progresso de conclusão de curso';
$string['courseistingprogressstyle_bar'] = 'Barra de progresso';
$string['courseistingprogressstyle_percentage'] = 'Texto de porcentagem';
$string['courselistingcontacts'] = 'Contato do curso';
$string['courselistinggoto'] = 'Ir para o curso';
$string['courselistingheading'] = 'Listagem de cursos';
$string['courselistinghowcategory'] = 'Mostrar a categoria na listagem de cursos';
$string['courselistinghowgoto'] = 'Mostrar o botão "Ir para" na listagem de cursos';
$string['courselistinghowshortname'] = 'Mostrar o nome breve do curso na listagem de cursos';
$string['courselistingnosummary'] = 'Este curso não tem um sumário';
$string['courselistingpopup'] = 'Detalhes';
$string['courselistingpresentation'] = 'Apresentação da listagem de cursos';
$string['courselistingpresentation_cards'] = 'Cartas de cursos';
$string['courselistingpresentation_list'] = 'Lista de cursos';
$string['courselistingpresentation_nochange'] = 'Pesadelo do designer (sem modificações, como mostrado pelo Moodle "core")';
$string['courselistingselectfields'] = 'Selecione os campos de cursos a serem mostrados na listagem de cursos';
$string['courselistingummary'] = 'Sumário do curso';
$string['courselistingviewprofile'] = 'Ver perfil';
$string['coursemanagementheading'] = 'Gerenciamento do curso';
$string['courseoverviewheading'] = 'Bloco de visão geral do curso';
$string['courseoverviewshowcourseimagessetting'] = 'Mostrar imagens do curso';
$string['courseoverviewshowcourseimagessetting_desc'] = 'Com esta configuração, você pode controlar se a imagem do curso é visível dentro do bloco de visão geral do curso ou não. É possível escolher uma configuração diferente para os modelos de exibição: Cartão, Resumo e Lista.';
$string['courseoverviewshowprogresssetting'] = 'Mostrar progresso de conclusão do curso';
$string['courseoverviewshowprogresssetting_desc'] = 'Com esta configuração, você pode controlar se o progresso de conclusão do curso é visível dentro do bloco de visão geral do curso ou não.';
$string['coursestab'] = 'Cursos';
$string['coursetab'] = 'Curso';
$string['cssh5pheading'] = 'CSS bruto para H5P';
$string['cssh5psetting'] = 'CSS bruto para H5P';
$string['cssh5psetting_desc'] = 'Use este campo para fornecer código CSS que será aplicado à apresentação do conteúdo H5P por mod_h5p e mod_hvp. Inspecione os tipos de conteúdo H5P para encontrar os seletores CSS necessários.';
$string['customfontsfileurlpersistent'] = 'URL (persistente)';
$string['customfontsfileurlrevisioned'] = 'URL (com revisão)';
$string['customfontsheading'] = 'Fontes personalizadas';
$string['customfontslistsetting'] = 'Lista de fontes personalizadas';
$string['customfontslistsetting_desc'] = 'Esta é a lista de fontes que você carregou na área de arquivos de fontes personalizadas. Os trechos de CSS fornecidos podem ser usados para adicionar essas fontes ao seu SCSS personalizado. Observe que você deve definir o valor de formato da fonte, assim como as propriedades CSS de font-family, font-style e font-weight, pois o Boost Union ainda não consegue processar os arquivos de fonte.';
$string['customfontssetting'] = 'Fontes personalizadas';
$string['customfontssetting_desc'] = 'Com esta configuração, você pode carregar fontes personalizadas no tema. A vantagem de carregar fontes nesta área de arquivos é que elas podem ser entregues sem uma verificação de login e podem ser usadas como fontes locais em todo o site. Assim que você carregar pelo menos uma fonte nessa área e salvar as configurações, uma lista aparecerá abaixo fornecendo trechos de CSS que você pode usar como modelo para referenciar fontes específicas em seu SCSS personalizado.';
$string['dashboardtab'] = 'Dashboard / Meus cursos';
$string['dontchange'] = 'Não altere nada';
$string['drawerwidthheading'] = 'Largura da gaveta';
$string['emailbrandinghtmldemobody'] = '<p>Corpo do E-mail começa aqui.</p><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p><p>Id donec ultrices tincidunt arcu non sodales. Id volutpat lacus laoreet non curabitur gravida arcu.</p><p>Cursus turpis massa tincidunt dui. Pellentesque nec nam aliquam sem et tortor consequat id. In ornare quam viverra orci sagittis eu volutpat. Sem nulla pharetra diam sit amet nisl suscipit. Justo donec enim diam vulputate ut pharetra.</p><p>Corpo do E-mail termina aqui.</p>';
$string['emailbrandinghtmlheading'] = 'Pré-visualização do E-mail HTML';
$string['emailbrandinghtmlintro'] = 'Esta é uma pré-visualização de um E-mail HTML baseado nos prefixos e sufixos de marca atualmente definidos no pacote de idioma.';
$string['emailbrandinghtmlnopreview'] = 'Até agora, os E-mails HTML não foram personalizados com este recurso. Os E-mails serão compostos e enviados normalmente.';
$string['emailbrandinginstruction'] = 'Guia de instruções';
$string['emailbrandinginstruction0'] = 'Com este recurso Boost Union, você pode aplicar marca a todos os E-mails enviados pelo Moodle.';
$string['emailbrandinginstructionli1'] = 'Vá para a <a href="{$a->url}" target="_blank">página de configurações de personalização de idioma</a> para abrir o pacote de idiomas <em>{$a->lang}</em> para edição.';
$string['emailbrandinginstructionli2'] = 'Procure e modifique estas strings no pacote de idioma <code>theme_boost_union</code>:';
$string['emailbrandinginstructionli2li1'] = '<code>templateemailhtmlprefix</code>: Este trecho será adicionado <em>no início / antes do corpo</em> de todos os <em>E-mails HTML</em> enviados pelo Moodle.';
$string['emailbrandinginstructionli2li2'] = '<code>templateemailhtmlsuffix</code>: Este trecho será adicionado <em>no final / após o corpo</em> de todos os <em>E-mails HTML</em> enviados pelo Moodle.';
$string['emailbrandinginstructionli2li3'] = '<code>templateemailtextprefix</code>: Este trecho será adicionado <em>no início / antes do corpo</em> de todos os <em>E-mails de texto simples</em> enviados pelo Moodle.';
$string['emailbrandinginstructionli2li4'] = '<code>templateemailtextsuffix</code>: Este trecho será adicionado <em>no final / após o corpo</em> de todos os <em>E-mails de texto simples</em> enviados pelo Moodle.';
$string['emailbrandinginstructionli3'] = 'Salve as alterações no pacote de idioma.';
$string['emailbrandinginstructionli4'] = 'Volte a esta página e verifique as pré-visualizações dos E-mails abaixo.';
$string['emailbrandingintroheading'] = 'Introdução';
$string['emailbrandingintronote'] = 'Observe: Esta é uma funcionalidade avançada que usa algumas soluções alternativas para fornecer opções de marca para E-mails. Siga as instruções cuidadosamente.';
$string['emailbrandingpitfalls'] = 'Armadilhas';
$string['emailbrandingpitfalls0'] = 'Ao usar este recurso, existem algumas armadilhas que você deve estar ciente:';
$string['emailbrandingpitfallsli1'] = 'É obrigatório que você modifique as strings do pacote de idioma da <em>idioma padrão atual</em> deste site. Mesmo que você tenha vários pacotes de idioma instalados, apenas alterações no idioma padrão terão efeito.';
$string['emailbrandingpitfallsli2'] = 'Respeitar o idioma do destinatário não é possível. Portanto, use termos neutros no que se refere a idioma em seus trechos de marca para E-mails.';
$string['emailbrandingpitfallsli3'] = 'Se você alterar o idioma padrão do site no futuro, terá que migrar as strings modificadas para o novo pacote de idioma padrão.';
$string['emailbrandingpitfallsli4'] = 'Nos E-mails de texto simples, uma quebra de linha e uma linha em branco são adicionadas automaticamente após o prefixo, e uma linha em branco é adicionada automaticamente antes do sufixo. Isso garante que o sufixo e o prefixo não fiquem diretamente junto ao corpo do E-mail.';
$string['emailbrandingpitfallsli5'] = 'Nos E-mails HTML, o prefixo e o sufixo são adicionados diretamente antes e acima do corpo do E-mail. Isso garante que você possa trabalhar facilmente com tags HTML, mas será necessário gerenciar todo o espaçamento ao redor do corpo por conta própria.';
$string['emailbrandingpitfallsli6'] = 'Nos E-mails HTML, você pode abrir uma tag HTML no trecho de prefixo e fechar a tag no trecho de sufixo sem problemas. Apenas lembre-se de criar um HTML válido no E-mail resultante.';
$string['emailbrandingtab'] = 'Marca de E-mail';
$string['emailbrandingtextdemobody'] = 'O corpo do e-mail começa aqui.
Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Id donec ultrices tincidunt arcu non sodales. Id volutpat lacus laoreet non curabitur gravida arcu. Cursus turpis massa tincidunt dui. Pellentesque nec nam aliquam sem et tortor consequat id. In ornare quam viverra orci sagittis eu volutpat. Sem nulla pharetra diam sit amet nisl suscipit. Justo donec enim diam vulputate ut pharetra. O corpo do e-mail termina aqui.';
$string['emailbrandingtextheading'] = 'Pré-visualização de E-mail de texto simples';
$string['emailbrandingtextintro'] = 'Esta é uma pré-visualização de um E-mail de texto simples baseada nos prefixos e sufixos de marca atualmente definidos no pacote de idioma.';
$string['emailbrandingtextnopreview'] = 'Até agora, os E-mails de texto simples não foram personalizados com este recurso. Os E-mails serão compostos e enviados normalmente.';
$string['enableaboutussetting'] = 'Habilitar página sobre nós';
$string['enablecontactsetting'] = 'Habilitar página de contato';
$string['enablefooterbutton'] = 'Habilitar rodapé';
$string['enablefooterbutton_desc'] = 'Com "rodapé" entende-se o círculo que contém o ponto de interrogação na parte inferior da página.<br />Ao clicar, o usuário é apresentado a uma sobreposição. Dependendo da configuração do site, o Moodle mostra vários links (como "Documentação para esta página" ou "Resumo de retenção de dados") nesta sobreposição.<br />Com esta configuração, você pode controlar se deseja mostrar ou suprimir o botão de rodapé na parte inferior da página.';
$string['enablefooterbuttonboth'] = 'Habilitar em desktop, tablet e mobile';
$string['enablefooterbuttondesktop'] = 'Habilitar apenas em desktop e tablet, ocultar em mobile (inalterado conforme apresentado pelo núcleo do Moodle)';
$string['enablefooterbuttonhidden'] = 'Ocultar em todos os dispositivos';
$string['enablefooterbuttonmobile'] = 'Habilitar apenas no mobile, ocultar em desktop e tablet';
$string['enablehelpsetting'] = 'Habilitar página de ajuda';
$string['enableimprintsetting'] = 'Habilitar impressão';
$string['enablemaintenancesetting'] = 'Habilitar página de informações de manutenção';
$string['enableofferssetting'] = 'Habilitar página de ofertas';
$string['enablepage1setting'] = 'Habilitar página genérica 1';
$string['enablepage2setting'] = 'Habilitar página genérica 2';
$string['enablepage3setting'] = 'Habilitar página genérica 3';
$string['error:infobannerdismissnonotdismissible'] = 'A faixa de informações fornecida não pode ser descartada';
$string['error:infobannerdismissnonotvalid'] = 'O número da faixa de informações fornecido é inválido';
$string['error:smartmenusmenuitemnotfound'] = 'Item do menu inteligente não encontrado';
$string['error:smartmenusmenunotfound'] = 'Menu inteligente não encontrado';
$string['extscssgithubfilepath_example'] = 'Exemplo: Se você visualizar o arquivo na sua conta do Github em https://github.com/moodle-an-hochschulen/moodle-theme_boost_union-extscsstest/blob/main/extscss.scss, o caminho do arquivo será <em>/extscss.scss</em>.';
$string['extscssgithubpostfilepath'] = 'Caminho do arquivo Github SCSS externo (Post)';
$string['extscssgithubpostfilepath_desc'] = 'O caminho dentro do repositório privado do Github onde o arquivo Post SCSS está localizado.';
$string['extscssgithubprefilepath'] = 'Caminho do arquivo Github SCSS externo (Pre)';
$string['extscssgithubprefilepath_desc'] = 'O caminho dentro do repositório privado do Github onde o arquivo Pre SCSS está localizado.';
$string['extscssgithubrepo'] = 'Repositório Github API SCSS externo';
$string['extscssgithubrepo_desc'] = 'O repositório privado do Github onde os arquivos SCSS estão localizados.';
$string['extscssgithubrepo_example'] = 'Exemplo: Se você visualizar o arquivo na sua conta do Github em https://github.com/moodle-an-hochschulen/moodle-theme_boost_union-extscsstest/blob/main/extscss.scss, o repositório será <em>moodle-theme_boost_union-extscsstest</em>.';
$string['extscssgithubtoken'] = 'Token de API Github SCSS externo';
$string['extscssgithubtoken_desc'] = 'O token da API do Github usado para buscar o código SCSS do repositório privado fornecido.';
$string['extscssgithubtoken_docs'] = 'Acesse <a href="https://github.com/settings/tokens">suas configurações de tokens no Github</a> para gerar um token de API e ver a documentação oficial.';
$string['extscssgithubuser'] = 'Usuário de API Github SCSS externo';
$string['extscssgithubuser_desc'] = 'O usuário ou organização do Github que possui o repositório privado.';
$string['extscssgithubuser_example'] = 'Exemplo: Se você visualizar o arquivo na sua conta do Github em https://github.com/moodle-an-hochschulen/moodle-theme_boost_union-extscsstest/blob/main/extscss.scss, o usuário será <em>moodle-an-hochschulen</em>.';
$string['extscssheading'] = 'SCSS Externo';
$string['extscssheading_desc'] = 'Além das configurações SCSS acima, Boost Union pode carregar SCSS de uma fonte externa. Ele é incluído antes do código SCSS definido acima, permitindo que você gerencie uma base centralizada de código SCSS externo, complementada por adições locais de SCSS.';
$string['extscssheading_drop'] = 'Se o Boost Union não conseguir buscar o arquivo SCSS externo, ele simplesmente ignorará o arquivo para evitar problemas de compilação de SCSS e falhas na interface.';
$string['extscssheading_instr'] = 'Instruções:';
$string['extscssheading_prepost'] = 'Como as configurações de SCSS acima, o SCSS externo é dividido em duas partes: Pre SCSS para inicializar variáveis SCSS e Post SCSS para o código SCSS propriamente dito.';
$string['extscssheading_sources'] = 'Você pode configurar o Boost Union para buscar o SCSS externo de uma URL pública de download (com uma solicitação cURL não autenticada) ou de um repositório privado no Github (acessado com um token da API Github).';
$string['extscssheading_structure'] = 'O SCSS externo deve ser fornecido como um arquivo de texto simples, sem cabeçalhos ou rodapés, contendo apenas o código SCSS.';
$string['extscssheading_task'] = 'Existe uma <a href="{$a}">tarefa agendada theme_boost_union\\task\\purge_cache</a> desativada por padrão, que você pode habilitar para que o Boost Union busque e compile periodicamente o código SCSS externo.';
$string['extscsssource'] = 'Fonte de SCSS Externo';
$string['extscsssource_desc'] = 'Escolha o tipo de fonte de onde deseja buscar o SCSS externo.';
$string['extscsssourcedownload'] = 'URL pública de download';
$string['extscsssourcegithub'] = 'Repositório privado no Github';
$string['extscsssourcenone'] = 'Nenhum';
$string['extscssurlpost'] = 'URL de download do SCSS externo (Post)';
$string['extscssurlpost_desc'] = 'A URL pública de onde o Post SCSS externo deve ser buscado.';
$string['extscssurlpre'] = 'URL de download do SCSS externo (Pre)';
$string['extscssurlpre_desc'] = 'A URL pública de onde o Pre SCSS externo deve ser buscado.';
$string['extscssvalidationsetting'] = 'Validação de SCSS Externo';
$string['extscssvalidationsetting_desc'] = 'Se essa configuração estiver ativada, o SCSS externo é validado para ver se pode ser compilado antes de ser adicionado à pilha SCSS. Código SCSS externo que não pode ser compilado é ignorado silenciosamente. Contudo, essa validação é aplicada apenas ao SCSS externo, não à pilha SCSS combinada. Isso significa que, ao usar variáveis SCSS do Moodle ou Bootstrap, você deve desativar a validação e verificar por si mesmo se o código SCSS é válido para evitar falhas na interface.';
$string['faviconheading'] = 'Favicon';
$string['faviconheading_desc'] = 'Observação: o Boost Union tem seu próprio upload de favicon e não usa o favicon da <a href="{$a}">configuração de favicon do núcleo do Moodle</a>.<br />O Boost Union especialmente permite que você substitua o upload favicon dentro de seus sabores.';
$string['faviconsetting'] = 'Favicon';
$string['faviconsetting_desc'] = 'Aqui, você pode enviar uma imagem personalizada (formato .ico ou .png) que o navegador mostrará como o favicon do seu site Moodle. Se nenhum favicon personalizado for enviado, um favicon padrão do Moodle será usado.';
$string['flavoursappliesto'] = 'Aplica-se a';
$string['flavoursapplytocategories'] = 'Aplicar às categorias de curso';
$string['flavoursapplytocategories_help'] = 'Aqui, você define se este estilo deve ser aplicado às categorias de curso.';
$string['flavoursapplytocategories_ids'] = 'Categorias de curso';
$string['flavoursapplytocategories_ids_help'] = 'Aqui, você define uma ou mais categorias de curso específicas às quais este estilo deve ser aplicado. Assim que a página Moodle renderizada estiver localizada em uma das categorias de curso configuradas, o estilo é aplicado.';
$string['flavoursapplytocohorts'] = 'Aplicar aos coortes';
$string['flavoursapplytocohorts_help'] = 'Aqui, você define se este estilo deve ser aplicado aos coortes.';
$string['flavoursapplytocohorts_ids'] = 'Coortes';
$string['flavoursapplytocohorts_ids_help'] = 'Aqui, você define um ou mais coortes específicos às quais este estilo deve ser aplicado. Assim que o usuário for membro de um dos coortes configurados, o estilo é aplicado.<br /><br />Observe que, se você definir mais de um coorte, não há necessidade de o usuário ser membro de todos eles ao mesmo tempo.<br /><br />Observe também que, no estado atual de implementação, os coortes de categoria são tratados como se fossem coortes do sistema.';
$string['flavoursbackgroundimage'] = 'Imagem de fundo';
$string['flavoursbackgroundimage_help'] = 'Com esta configuração, o estilo substituirá a imagem de fundo configurada nas configurações de aparência do Boost Union.';
$string['flavoursbacktooverview'] = 'Voltar para a visão geral dos estilos';
$string['flavourscreateflavour'] = 'Criar estilo';
$string['flavoursdelete'] = 'Excluir';
$string['flavoursdeleteconfirmation'] = 'Você realmente deseja excluir o estilo <em>{$a}</em>?';
$string['flavoursdeleteflavour'] = 'Excluir estilo';
$string['flavoursdescription'] = 'Descrição';
$string['flavoursdescription_help'] = 'A descrição do estilo é usada apenas internamente para permitir que você identifique um estilo específico na lista de estilos.';
$string['flavoursedit'] = 'Editar';
$string['flavourseditflavour'] = 'Editar estilo';
$string['flavoursfavicon'] = 'Favicon';
$string['flavoursfavicon_help'] = 'Com esta configuração, o estilo substituirá o favicon configurado nas configurações de aparência do Boost Union.';
$string['flavoursflavours'] = 'Estilos';
$string['flavoursgeneralsettings'] = 'Configurações gerais';
$string['flavoursincludesubcategories'] = 'Incluir subcategorias';
$string['flavoursincludesubcategories_help'] = 'Se marcado, o estilo também será aplicado às subcategorias das categorias escolhidas.';
$string['flavourslogo'] = 'Logotipo';
$string['flavourslogo_help'] = 'Com esta configuração, o estilo substituirá o logotipo configurado nas configurações de aparência do Boost Union.';
$string['flavourslogocompact'] = 'Logotipo compacto';
$string['flavourslogocompact_help'] = 'Com esta configuração, o estilo substituirá o logotipo configurado nas configurações de aparência do Boost Union.';
$string['flavoursnothingtodisplay'] = 'Ainda não foram criados estilos. Por favor, crie seu primeiro estilo para começar.';
$string['flavoursnotificationcreated'] = 'O estilo foi criado com sucesso';
$string['flavoursnotificationdeleted'] = 'O estilo foi excluído com sucesso';
$string['flavoursnotificationedited'] = 'O estilo foi editado com sucesso';
$string['flavoursoverview_desc'] = '<p>Os estilos do Boost Union oferecem uma possibilidade de substituir configurações específicas de aparência do Moodle em contextos específicos. Nesta página, você pode criar e gerenciar estilos.</p><p>Dentro de cada estilo, você define se ele deve ser aplicado a categorias de curso específicas ou a coortes específicos. Depois, durante cada renderização de página do Moodle, o Boost Union verifica se algum estilo se aplica. Observe que, para cada renderização de página do Moodle, apenas o primeiro estilo correspondente na lista é aplicado e os demais estilos são ignorados. Portanto, a ordem dos estilos nesta página é crucial.</p><p>Observe também que, após cada alteração que você fizer no conjunto de estilos, o cache do tema é limpo. Isso é necessário para garantir que todos os recursos sejam enviados corretamente e atualizados para o navegador.</p>';
$string['flavourspreview'] = 'Visualizar';
$string['flavourspreviewflavour'] = 'Visualizar estilo';
$string['flavourstitle'] = 'Título';
$string['flavourstitle_help'] = 'O título do estilo é usado apenas internamente para permitir que você documente um estilo específico na lista de estilos.';
$string['footerheading'] = 'Rodapé';
$string['footersuppresschatsetting'] = 'Suprimir o link \'Bate-papo com participantes\' do curso';
$string['footersuppresschatsetting_desc'] = 'Com esta configuração, você pode suprimir totalmente o link \'Bate-papo com participantes do curso\' no rodapé. Caso contrário, esse link apareceria nos cursos assim que uma sala de comunicação fosse adicionada às configurações do curso.';
$string['footersuppresscontactsetting'] = 'Suprimir o link \'Entre em contato com o suporte\' do site';
$string['footersuppresscontactsetting_desc'] = 'Com essa configuração, você pode suprimir totalmente o link ‘Entre em contato com o suporte do site’ no rodapé. Caso contrário, esse link apareceria se o <a href="{$a->url}">link de contato com o suporte do site</a> estivesse definido.';
$string['footersuppresshelpsetting'] = 'Suprimir link \'Documentação para esta página\'';
$string['footersuppresshelpsetting_desc'] = 'Com esta configuração, você pode suprimir totalmente o link ‘Documentação para esta página’ no rodapé. Caso contrário, este link apareceria se uma <a href="{$a->url}">raiz do documento Moodle Docs</a> fosse definida.';
$string['footersuppressiconssetting'] = 'Suprimir ícones à frente dos links do rodapé';
$string['footersuppressiconssetting_desc'] = 'Com esta configuração, você pode suprimir totalmente os ícones à frente dos links do rodapé. \'Documentação para esta página\' tem um ícone de livro, \'Serviços e suporte\' tem um ícone de boia, etc.';
$string['footersuppresslogininfosetting'] = 'Suprimir informações de login';
$string['footersuppresslogininfosetting_desc'] = 'Com esta configuração, você pode suprimir totalmente as informações de login no rodapé. Essas informações normalmente mostrariam links para o perfil do usuário e para a página de logout.';
$string['footersuppresspoweredsetting'] = 'Suprimir link \'Powered by Moodle\'';
$string['footersuppresspoweredsetting_desc'] = 'Com esta configuração, você pode suprimir totalmente o link \'Powered by Moodle\' no rodapé. Caso contrário, este link mostraria a informação de que este site está executando o Moodle e forneceria um link para o Moodle HQ.';
$string['footersuppressservicessetting'] = 'Suprimir link \'Serviços e suporte\'';
$string['footersuppressservicessetting_desc'] = 'Com esta configuração, você pode suprimir totalmente o link \'Serviços e suporte\' no rodapé. Caso contrário, este link mostraria o <a href="{$a->url}">link de serviços e suporte</a> para os administradores.';
$string['footersuppressstandardfooter'] = 'Suprimir a saída do rodapé pelo plugin \'{$a}\'';
$string['footersuppressstandardfooter_desc'] = 'Com esta configuração, você pode suprimir totalmente a saída do rodapé pelo plugin \'{$a}\'. Plugins (mesmo os distribuídos com o núcleo do Moodle, mas que ainda são tecnicamente plugins) podem adicionar conteúdo adicional ao rodapé ao implementar um gancho ou função específica. Este plugin implementou esse gancho/função e pode adicionar conteúdo ao rodapé em determinadas circunstâncias.<br />Observação: Devido à forma como a função de supressão foi implementada, a configuração pode não surtir efeito antes do segundo carregamento da página após salvar a configuração.';
$string['footersuppressstandardfootercore'] = 'Suprimir saída do rodapé pelo componente central \'{$a}\'';
$string['footersuppressstandardfootercore_desc'] = 'Com esta configuração, você pode suprimir totalmente a saída do rodapé pelo componente central \'{$a}\'. Componentes centrais podem adicionar conteúdo adicional ao rodapé ao implementar um hook ou função específica. Este componente central implementou esse hook/função e pode adicionar conteúdo ao rodapé em determinadas circunstâncias.';
$string['footersuppressthemeswitchsetting'] = 'Suprimir links do seletor de tema';
$string['footersuppressthemeswitchsetting_desc'] = 'Com esta configuração, você pode suprimir totalmente os links do seletor de tema no rodapé. O sistema subjacente para temas específicos para dispositivos foi removido no Moodle 4.3, mas as rotinas de saída ainda estão lá, então é melhor prevenir do que remediar.';
$string['footersuppressusertoursetting'] = 'Suprimir o link \'Redefinir tour do usuário nesta página\'';
$string['footersuppressusertoursetting_desc'] = 'Com essa configuração, você pode suprimir totalmente o link ‘Redefinir tour do usuário nesta página’ no rodapé. Caso contrário, este link forneceria a possibilidade de redefinir um tour do usuário em uma página específica.';
$string['footertab'] = 'Rodapé';
$string['footnoteheading'] = 'Nota de rodapé';
$string['footnotesetting'] = 'Nota de rodapé';
$string['footnotesetting_desc'] = 'Tudo o que você adicionar a esta área de texto será exibido no final de uma página, no rodapé (não no rodapé flutuante) em todas as páginas que utilizam os layouts "gavetas", "colunas2" ou "login". O conteúdo nesta área pode ser, por exemplo, os direitos de autor, os termos de utilização ou o nome da sua organização. <br/> Se quiser remover a nota de rodapé novamente, basta esvaziar a área de texto.';
$string['githubissueslink'] = '<a href="https://github.com/moodle-an-hochschulen/moodle-theme_boost_union/issues">Problemas do GitHub</a>
theme_boost_union/githubissueslink';
$string['h5pcontentmaxwidthsetting'] = 'Largura máxima do banco de conteúdo H5P';
$string['h5pcontentmaxwidthsetting_desc'] = 'Com esta configuração, você pode substituir a largura do banco de conteúdo H5P do Moodle sem modificações manuais de SCSS. Esta largura é usada para o editor H5P dentro do banco de conteúdo. Ela <em>não</em> é usada para a largura da atividade H5P. Por padrão, o Moodle usa uma largura máxima de 960px para o banco de conteúdo H5P. Você pode inserir outros valores baseados em pixels, como 1200px, mas também pode inserir um valor baseado em porcentagem, como 100%, ou um valor de largura da viewport, como 90vw.';
$string['h5ptab'] = 'H5P';
$string['helpcontentsetting'] = 'Conteúdo da página de ajuda';
$string['helpcontentsetting_desc'] = 'Nesta configuração, você pode adicionar conteúdo em rich text que será mostrado em uma página de ajuda.';
$string['helpdisabled'] = 'A página de ajuda está desativada para este site. Não há nada para ver aqui.';
$string['helpheading'] = 'Ajuda';
$string['helplinkpositionboth'] = 'Adicionar um link para a página de ajuda na nota de rodapé e no ícone de interrogação do rodapé';
$string['helplinkpositionfooter'] = 'Adicionar um link para a página de ajuda no ícone de interrogação do rodapé';
$string['helplinkpositionfootnote'] = 'Adicionar um link para a página de ajuda na nota de rodapé';
$string['helplinkpositionnone'] = 'Não mostrar automaticamente um link para a página de ajuda';
$string['helplinkpositionsetting'] = 'Posição do link para a página de ajuda';
$string['helplinkpositionsetting_desc'] = 'Nesta configuração você pode configurar se um link para a página de ajuda deve ser adicionado automaticamente à página do Moodle. Se você não quiser mostrar um link automaticamente, você pode adicionar um link para {$a->url} de qualquer lugar do Moodle manualmente.';
$string['helppagetitledefault'] = 'Ajuda';
$string['helppagetitlesetting'] = 'Título da página de ajuda';
$string['helppagetitlesetting_desc'] = 'Nesta configuração você pode definir o título da página de ajuda. Este texto também será usado como texto de link para a página de ajuda se você configurar a \'Posição do link da página de ajuda\' adequadamente.';
$string['hidenodesprimarynavigationsetting'] = 'Ocultar nós na navegação primária';
$string['hidenodesprimarynavigationsetting_desc'] = 'Com esta configuração, você pode ocultar um ou vários nós da navegação primária.<br /><br /> Observação: Aqui, você pode simplesmente remover os nós de navegação. Mas se você quiser adicionar nós de navegação personalizados, considere usar a <a href="{$a->url}">funcionalidade do menu inteligente do Boost Union</a>.';
$string['imprintcontentsetting'] = 'Conteúdo da página de impressão';
$string['imprintcontentsetting_desc'] = 'Nesta configuração, você pode adicionar conteúdo em rich text que será mostrado na página de impressão.';
$string['imprintdisabled'] = 'A página de impressão está desativada para este site. Não há nada para ver aqui.';
$string['imprintheading'] = 'Impressão';
$string['imprintlinkpositionboth'] = 'Adicionar um link para a página de impressão na nota de rodapé e no ícone de interrogação do rodapé';
$string['imprintlinkpositionfooter'] = 'Adicionar um link para a página de impressão no ícone de interrogação do rodapé';
$string['imprintlinkpositionfootnote'] = 'Adicionar um link para a página de impressão na nota de rodapé';
$string['imprintlinkpositionnone'] = 'Não mostrar automaticamente um link para a página de impressão';
$string['imprintlinkpositionsetting'] = 'Posição do link para a impressão';
$string['imprintlinkpositionsetting_desc'] = 'Nesta configuração você pode configurar se um link para a página de impressão deve ser adicionado automaticamente à página do Moodle. Se você não quiser mostrar um link automaticamente, você pode adicionar um link para {$a->url} de qualquer lugar do Moodle manualmente.';
$string['imprintpagetitledefault'] = 'Impressão';
$string['imprintpagetitlesetting'] = 'Título da página de impressão';
$string['imprintpagetitlesetting_desc'] = 'Nesta configuração, você pode definir o título da página de impressão. Este texto também será usado como texto de link para a página de impressão se você configurar a \'Posição do link de impressão\' adequadamente.';
$string['infobannerbsclasssetting'] = 'Banner de informações {$a->no} Classe Bootstrap';
$string['infobannerbsclasssetting_desc'] = 'Com esta configuração, você pode selecionar o estilo Bootstrap com o qual o banner de informações {$a->no} deve ser exibido. Se você escolher a opção \'Sem cor do Bootstrap\', o banner de informações será exibido sem nenhuma cor específica do Bootstrap, o que lhe dá a liberdade de estilizar o banner por conta própria no editor de rich text.';
$string['infobannerclose'] = 'Fechar';
$string['infobannercontentsetting'] = 'Conteúdo do banner informativo {$a->no}';
$string['infobannercontentsetting_desc'] = 'Aqui você insere as informações que devem ser mostradas no banner de informações {$a->no}.';
$string['infobannerdismissconfirm'] = 'Você realmente deseja redefinir a visibilidade do banner informativo {$a->no} e quer mostrá-lo novamente para todos os usuários que o dispensaram?';
$string['infobannerdismissfail'] = 'A redefinição de visibilidade do banner de informações {$a->no} falhou para pelo menos um usuário';
$string['infobannerdismissiblesetting'] = 'Banner informativo {$a->no} dispensável';
$string['infobannerdismissiblesetting_desc'] = 'Com esta configuração, você pode tornar o banner informativo {$a->no} dispensável. Se o usuário clicar no botão x no banner de informações, o banner ficará permanentemente oculto para esse usuário. A visibilidade não é redefinida automaticamente, mesmo se você alterar o conteúdo do banner de informações. Se quiser redefinir a visibilidade do banner de informações, clique no botão \'Redefinir visibilidade\' abaixo.';
$string['infobannerdismissreset'] = 'Redefinir visibilidade do banner de informação dispensado';
$string['infobannerdismissresetbutton'] = 'Redefinir a visibilidade do banner de informações {$a->no}';
$string['infobannerdismisssuccess'] = 'A visibilidade do banner informativo {$a->no} foi redefinida';
$string['infobannerenabledsetting'] = 'Ativar banner de informações {$a->no}';
$string['infobannerenabledsetting_desc'] = 'Com esta configuração, você pode ativar o banner de informações {$a->no}.';
$string['infobannerendsetting'] = 'Banner de informações {$a->no} horário de término';
$string['infobannerendsetting_desc'] = 'Com esta configuração você pode definir até quando o banner informativo {$a->no} deve ser exibido. A hora configurada é interpretada como hora do servidor e não como hora do usuário.';
$string['infobannerheading'] = 'Banner de informações {$a->no}';
$string['infobannermodeperpetual'] = 'Permanente';
$string['infobannermodesetting'] = 'Modo de exibição do banner de informações {$a->no}';
$string['infobannermodesetting_desc'] = 'Com esta configuração você pode definir se o banner informativo {$a->no} deve ser um banner perpétuo (que é sempre mostrado) ou um banner com controle de tempo (que só é mostrado dentro do intervalo de tempo configurado)';
$string['infobannermodetimebased'] = 'Controlado por tempo';
$string['infobannerordersetting'] = 'Banner de informações {$a->no} posição do pedido';
$string['infobannerordersetting_desc'] = 'Com esta configuração você define a posição de ordem do banner informativo {$a->no}. Por padrão, os banners de informações são ordenados de cima para baixo, como você os vê nesta página de configurações aqui. No entanto, você pode decidir atribuir outra posição de pedido com esta configuração. Se você atribuir a mesma posição de pedido a dois ou mais banners informativos, eles serão ordenados novamente de acordo com a ordem nesta página de configurações.';
$string['infobannerpageloginpage'] = 'Página de login';
$string['infobannerpagessetting'] = 'Layouts de página para exibir o banner de informações {$a->no}';
$string['infobannerpagessetting_desc'] = 'Com esta configuração, você pode selecionar os layouts de página nos quais o banner informativo {$a->no} deve ser exibido.';
$string['infobannerstartsetting'] = 'Banner de informações {$a->no} horário de início';
$string['infobannerstartsetting_desc'] = 'Com esta configuração você pode definir a partir de quando o banner informativo {$a->no} deve ser exibido. A hora configurada é interpretada como hora do servidor e não como hora do usuário.';
$string['infobannertab'] = 'Banner de informação';
$string['invalidurl'] = 'A URL fornecida é inválida';
$string['javascriptdisabledhint'] = 'Aviso de JavaScript desativado';
$string['javascriptdisabledhint_desc'] = 'Com esta configuração, um aviso aparecerá no topo da página do Moodle se o JavaScript não estiver ativado. Isso é particularmente útil, pois várias funcionalidades do Moodle não funcionam sem o JavaScript.';
$string['javascriptdisabledhinttext'] = 'JavaScript está desativado no seu navegador.<br />Muitas funcionalidades do Moodle não serão utilizáveis ou aparecerão com problemas.<br />Ative o JavaScript para uma experiência completa no Moodle.';
$string['javascriptheading'] = 'JavaScript';
$string['linkstab'] = 'Links';
$string['loginbackgroundimage'] = 'Imagens de fundo da página de login';
$string['loginbackgroundimage_desc'] = 'As imagens a serem exibidas como fundo da página de login. Uma dessas imagens será selecionada aleatoriamente e exibida quando o usuário visitar a página de login. Por favor, certifique-se de não usar caracteres não-ASCII no nome do arquivo se quiser exibir texto para imagens de fundo de login.';
$string['loginbackgroundimagepositionsetting'] = 'Posição da imagem de fundo da página de login';
$string['loginbackgroundimagepositionsetting_desc'] = 'Com esta configuração, você controla o posicionamento da imagem de fundo da página de login na janela do navegador. O primeiro valor é a posição horizontal e o segundo valor é a posição vertical.';
$string['loginbackgroundimagesheading'] = 'Imagens de fundo da página de login';
$string['loginbackgroundimagetextsetting'] = 'Exibir texto para imagens de fundo de login';
$string['loginbackgroundimagetextsetting_desc'] = 'Com esta configuração opcional você pode adicionar texto, por exemplo. um aviso de direitos autorais para as imagens de fundo enviadas. Este texto aparecerá no topo do rodapé da página de login. No entanto, por motivos de espaço da tela, ele só é mostrado em telas maiores.<br/> Cada linha consiste no identificador do arquivo (o nome do arquivo), o texto que deve ser exibido e a cor do texto, separados por uma barra vertical . Cada declaração precisa ser escrita em uma nova linha. <br/> Por exemplo:<br/> background-image-1.jpg|Copyright: CC0|dark<br/> Como cor do texto, você pode usar os valores "dark" ou "light".<br /> Você pode declarar textos para uma quantidade arbitrária de imagens de fundo de login enviadas. Os textos serão adicionados apenas às imagens que correspondam ao nome do arquivo com o identificador declarado nesta configuração.';
$string['loginformheading'] = 'Formulário de login';
$string['loginformpositionsetting'] = 'Posição do formulário de login';
$string['loginformpositionsetting_center'] = 'Centralizado';
$string['loginformpositionsetting_desc'] = 'Com esta configuração, você pode otimizar o formulário de login para se ajustar a uma maior variedade de imagens de fundo. Por padrão, o formulário de login é exibido centralizado na página de login. Alternativamente, você pode movê-lo para a esquerda ou para a direita da página de login para permitir que outras partes da imagem de fundo fiquem visíveis. Claro, você também pode alterar essa configuração se nenhuma imagem de fundo estiver carregada.';
$string['loginformpositionsetting_left'] = 'Alinhado a Esquerda';
$string['loginformpositionsetting_right'] = 'Alinhado à direita';
$string['loginformtransparencysetting'] = 'Transparência do formulário de login';
$string['loginformtransparencysetting_desc'] = 'Com esta configuração, você pode tornar o formulário de login ligeiramente transparente para que a imagem de fundo fique mais visível.';
$string['loginidpshowintrosetting'] = 'Introdução de login IDP';
$string['loginidpshowintrosetting_desc'] = 'Com esta configuração, você controla se a introdução <em>\'{$a}\'</em> é mostrada acima dos botões de login do IDP ou não. Por padrão, a introdução é mostrada e os usuários serão rapidamente informados sobre o que são os botões IDP. Se você desabilitar esta configuração, a introdução do IDP ficará oculta. Isso permite que você forneça uma interface de login de usuário limpa se você usar apenas provedores de identidade externos como OAuth2 ou OIDC.';
$string['loginlocalintro'] = 'Faça login com sua conta Moodle';
$string['loginlocalloginenablesetting'] = 'Login local';
$string['loginlocalloginenablesetting_desc'] = 'Com esta configuração, você controla se o formulário de login local é exibido na página de login ou não. Por padrão, o formulário de login local é exibido e os usuários podem fazer login no site normalmente. Se você desativar esta configuração, o formulário de login local será ocultado. Isso permite que você forneça apenas botões de login para provedores de identidade externos, como OAuth2 ou OIDC.';
$string['loginlocalloginenablesetting_note'] = 'Observação: assim que você ocultar o formulário de login local, você corre o risco de os administradores não conseguirem mais fazer login com uma conta local se houver um problema com o provedor de identidade externo. Para permitir logins locais nesses casos, uma <a href="{$a->url}">página de login local de entrada lateral</a> é fornecida. Nesta página de login local de entrada lateral, todas as medidas de segurança de login do Moodle também se aplicam.';
$string['loginlocalloginformhead'] = 'Login local';
$string['loginlocalloginlocalnotdisabled'] = 'O login local está habilitado no formulário de login padrão. Não há necessidade de fazer login nesta página de login local aqui. Por favor, use a <a href="{$a->url}">página de login padrão</a> para fazer login.';
$string['loginlocalshowintrosetting'] = 'Introdução de login local';
$string['loginlocalshowintrosetting_desc'] = 'Com esta configuração, você controla se uma introdução <em>\'{$a}\'</em> é mostrada acima do formulário de login local ou não. Por padrão, a introdução não é mostrada. Mas se você habilitá-lo, esta introdução poderá ajudar os usuários a entender quais credenciais usar no formulário de login local, especialmente se você fornecer mais de um método de login ou se tiver alterado a ordem dos métodos de login.';
$string['loginorderfirsttimesignupsetting'] = 'Informações para visitantes de primeira vez & Autoregistro';
$string['loginorderguestsetting'] = 'Login como convidado';
$string['loginorderheading'] = 'Ordem de login';
$string['loginorderheading_desc'] = 'Com estas configurações, você controla a ordem dos métodos de login no formulário de login. A ordem apresentada será definida do menor ao maior número ordinal, ignorando todos os métodos de login e elementos do formulário de login que estão desativados no Moodle.';
$string['loginorderheading_note'] = 'Nota técnica: A ordem apresentada será realizada com ordens do CSS flexbox, sem reorganizar os widgets de login no HTML DOM. Isso deve funcionar em todos os navegadores modernos, mas pode não funcionar em navegadores muito antigos.';
$string['loginorderidpsetting'] = 'Login IDP';
$string['loginorderlocalsetting'] = 'Login local';
$string['loginpagetab'] = 'Página de login';
$string['loginprovidersheading'] = 'Provedores de login';
$string['loginprovidersheading_desc'] = 'Nota: O Boost Union possui suas próprias configurações de provedores de login e não usa a configuração \'{$a->settingname}\' do <a href="{$a->url}">Moodle core\'s authentication setting</a>.';
$string['logocompactsetting'] = 'Logo compacto';
$string['logocompactsetting_desc'] = 'Aqui, você pode enviar uma versão compacta do mesmo logo acima, como um emblema, escudo ou ícone. Esta imagem é especialmente usada na barra de navegação no topo de cada página do Moodle. A imagem deve ser clara mesmo em tamanhos pequenos.';
$string['logosetting'] = 'Logo';
$string['logosetting_desc'] = 'Aqui, você pode enviar um logo completo para ser usado como decoração. Esta imagem é especialmente usada na página de login. Esta imagem pode ter uma resolução bastante alta, pois será redimensionada para uso.';
$string['logosheading'] = 'Logos';
$string['logosheading_desc'] = 'Observação: Boost Union tem seu próprio upload de logotipo e não usa o logotipo da <a href="{$a}">configuração de logotipo do núcleo do Moodle</a>.<br />Boost Union especialmente permite que você carregue mais imagens formatos que o núcleo do Moodle permite e permite que você substitua os logotipos carregados em seus sabores.';
$string['maintenancecontentsetting'] = 'Conteúdo da página de informações de manutenção';
$string['maintenancecontentsetting_desc'] = 'Nesta configuração, você pode adicionar conteúdo em rich text que será mostrado em uma página de informações de manutenção (que não é a mesma página do modo de manutenção integrado do Moodle).';
$string['maintenancedisabled'] = 'A página de informações de manutenção está desativada para este site. Não há nada para ver aqui.';
$string['maintenanceheading'] = 'Manutenção';
$string['maintenancelinkpositionboth'] = 'Adicionar um link para a página de informações de manutenção na nota de rodapé e no ícone de rodapé (ponto de interrogação)';
$string['maintenancelinkpositionfooter'] = 'Adicionar um link para a página de informações de manutenção no ícone de rodapé (ponto de interrogação)';
$string['maintenancelinkpositionfootnote'] = 'Adicionar um link para a página de informações de manutenção na nota de rodapé';
$string['maintenancelinkpositionnone'] = 'Não mostrar automaticamente um link para a página de informações de manutenção';
$string['maintenancelinkpositionsetting'] = 'Posição do link da página de informações de manutenção';
$string['maintenancelinkpositionsetting_desc'] = 'Nesta configuração você pode configurar se um link para a página de informações de manutenção deve ser adicionado automaticamente à página Moodle. Se você não quiser mostrar um link automaticamente, você pode adicionar um link para {$a->url} de qualquer lugar do Moodle manualmente.';
$string['maintenancepagetitledefault'] = 'Manutenção';
$string['maintenancepagetitlesetting'] = 'Título da página de informações de manutenção';
$string['maintenancepagetitlesetting_desc'] = 'Nesta configuração, você pode definir o título da página de informações de manutenção. Este texto também será usado como texto de link para a página de informações de manutenção se você configurar a \'Posição do link da página de informações de manutenção\' adequadamente.';
$string['markbrokenlinkssetting'] = 'Marcar links quebrados';
$string['markbrokenlinkssetting_desc'] = 'Adiciona um ícone de "cadeia quebrada" na frente dos links quebrados (que levam a arquivos de rascunho carregados que não foram processados adequadamente) e marca o link na cor do bootstrap como "perigo". Em contraste com as configurações "Marcar links externos" e "Marcar links mailto", não há possibilidade de limitar o escopo desta configuração, pois marcar links quebrados é um indicador de que algo está quebrado e precisa ser corrigido manualmente.';
$string['markexternallinksscopesetting'] = 'Escopo de marcação de links externos';
$string['markexternallinksscopesetting_desc'] = 'Com esta configuração, você controla o escopo onde o Boost Union deve marcar links externos. Por padrão, o Boost Union marca links externos em toda a página do Moodle e faz o possível para cobrir alguns casos em que o ícone de link externo não faz muito sentido. No entanto, você também pode limitar o escopo para evitar melhor os casos-limite.';
$string['markexternallinkssetting'] = 'Marcar links externos';
$string['markexternallinkssetting_desc'] = 'Adiciona um ícone de "link externo" após links externos (que levam o usuário a um alvo fora do Moodle).';
$string['marklinksscopesetting_coursemain'] = 'Dentro da área de conteúdo principal das páginas principais dos cursos somente';
$string['marklinksscopesetting_wholepage'] = 'toda a página';
$string['markmailtolinksscopesetting'] = 'Escopo de marcação de links mailto';
$string['markmailtolinksscopesetting_desc'] = 'Com esta configuração, você controla o escopo onde o Boost Union deve marcar links mailto. Por padrão, o Boost Union marca links mailto em toda a página do Moodle. No entanto, você também pode limitar o escopo para evitar casos extremos.';
$string['markmailtolinkssetting'] = 'Marcar links mailto';
$string['markmailtolinkssetting_desc'] = 'Adiciona um ícone de "envelope" na frente dos links mailto.';
$string['mediumcontentmaxwidthsetting'] = 'Largura máxima de conteúdo médio';
$string['mediumcontentmaxwidthsetting_desc'] = 'Com esta configuração, você pode substituir a largura de conteúdo médio do Moodle sem modificar manualmente o SCSS. Essa largura de página é usada em certas atividades como a atividade de banco de dados. Por padrão, o Moodle usa uma largura máxima de conteúdo médio de 1120px. Você pode inserir outros valores baseados em pixels, como 1200px, mas também valores baseados em porcentagem, como 100%, ou valores baseados na largura da janela, como 90vw.';
$string['misctab'] = 'Diversos';
$string['mobileappearanceheading'] = 'Aparência móvel';
$string['mobileappheading'] = 'Aplicativo móvel';
$string['mobilecss'] = 'CSS adicional para aplicativo móvel';
$string['mobilecss_desc'] = 'Com esta configuração, você pode escrever código CSS personalizado para customizar a interface do aplicativo móvel. O código CSS será adicionado apenas à representação do aplicativo móvel desta instância do Moodle e não será exibido na versão para navegador. Leia mais sobre este recurso na <a href="https://moodledev.io/general/app/customisation/remote-themes#how-do-remote-themes-work">documentação do desenvolvedor Moodle</a>.';
$string['mobilecss_donotchange'] = 'Este passo é necessário para enviar o código CSS para o aplicativo móvel. Não altere o URL aqui a menos que realmente deseje remover o código CSS do aplicativo móvel novamente.';
$string['mobilecss_overwrite'] = 'Assim que você adicionar qualquer código CSS a esta configuração e salvá-la, a <a href="{$a->url}">configuração principal do Moodle <em>mobilecssurl</em></a> será automaticamente substituída com uma URL do tema Boost Union. Atualmente esta configuração está definida como <a href="{$a->value}">{$a->value}</a>.';
$string['mobilecss_set'] = 'Assim que você adicionar qualquer código CSS a esta configuração e salvá-la, a <a href="{$a->url}">configuração principal do Moodle <em>mobilecssurl</em></a> será definida automaticamente para um URL do tema Boost Union.';
$string['mobiletab'] = 'Móvel';
$string['modiconactivity'] = 'Atividade';
$string['modiconactivityunknown'] = 'Desconhecido';
$string['modicongtmoodle4'] = 'Ícone do Moodle 4';
$string['modiconlistsetting'] = 'Lista de arquivos de ícones personalizados';
$string['modiconlistsetting_desc'] = 'Esta é a lista de arquivos de ícones personalizados que você carregou na área de arquivos de ícones personalizados acima. Todos os arquivos de ícones válidos estão listados aqui. Além disso, outros arquivos que você pode ter carregado, mas que não são ícones válidos, também são exibidos como arquivos corrompidos.';
$string['modiconltmoodle311'] = 'Ícone legado do Moodle 3';
$string['modiconnamefail'] = 'Este arquivo foi carregado na pasta correta para a atividade <em>{$a}</em>, mas o nome do arquivo não é válido. Por favor, altere o nome do arquivo para <em>monologo.svg</em> / <em>monologo.png</em> (para ícones do Moodle 4) ou para <em>icon.svg</em> / <em>icon .png</em> (para ícones legados do Moodle 3).';
$string['modiconnotexist'] = 'Este arquivo foi enviado para um local inadequado, pois é impossível deduzir uma atividade específica a partir do caminho do arquivo <em>{$a}</em>.';
$string['modiconsenablesetting'] = 'Ativar ícones personalizados para atividades e recursos';
$string['modiconsenablesetting_desc'] = 'Com esta configuração, você pode modificar os ícones para atividades e recursos usados pelo Moodle nas páginas de cursos e no seletor de atividades.';
$string['modiconserrorcreatingpath'] = 'A pasta pix_plugins/mod não pôde ser criada no diretório Moodledata.<br />A mensagem de exceção foi: {$a}.';
$string['modiconsfiles'] = 'Arquivos de ícones personalizados';
$string['modiconsfiles_desc'] = 'Aqui, você pode carregar ícones personalizados para todos ou apenas alguns módulos de atividades instalados nesta instância do Moodle.';
$string['modiconsfileshowto'] = 'Para carregar um ícone de atividade personalizado específico, comece criando uma pasta com o nome interno da atividade, por exemplo, <em>assign</em> para a atividade de atribuição. Nessa pasta, carregue o ícone como arquivo SVG chamado monologo.svg e, se possível, como arquivo PNG de fallback chamado monologo.png. Se você quiser personalizar os ícones coloridos que eram usados até o Moodle 3 e que ainda podem ser usados por plugins mais antigos, você também pode carregá-los como arquivos icon.svg e icon.png. No entanto, use ícones SVG monocromáticos, se possível, para obter os melhores resultados. Em seguida, salve a página de configurações. Assim que você salvar a configuração com pelo menos um arquivo, uma lista de arquivos aparecerá abaixo, ajudando a verificar se os ícones personalizados foram carregados corretamente.';
$string['modiconsfilestech'] = 'Nota técnica: Após salvar a configuração, a estrutura de pastas carregada e os arquivos de ícones serão copiados para a pasta pix_plugins/mod no diretório Moodledata. É nesse local que o núcleo do Moodle procura ícones de atividades personalizados. Todos os arquivos de ícones que já existirem nesse local serão sobrescritos ao salvar esta configuração.';
$string['modiconsheading'] = 'Ícones de atividades';
$string['modiconsuccess3x'] = 'Este ícone será usado para a atividade <em>{$a}</em> como ícone legado do Moodle 3.';
$string['modiconsuccess4x'] = 'Este ícone será usado para a atividade <em>{$a}</em> como ícone do Moodle 4.';
$string['modiconversion'] = 'Versão do ícone';
$string['navbarcolorsetting'] = 'Cor da barra de navegação';
$string['navbarcolorsetting_dark'] = 'Barra de navegação escura com cor de fonte clara';
$string['navbarcolorsetting_desc'] = 'Com esta configuração, você pode alterar a cor da barra de navegação da barra padrão clara para uma escura ou colorida.';
$string['navbarcolorsetting_light'] = 'Barra de navegação clara com cor de fonte escura (inalterada, conforme apresentada pelo núcleo do Moodle)';
$string['navbarcolorsetting_primarydark'] = 'Barra de navegação de cor primária com cor de fonte clara';
$string['navbarcolorsetting_primarylight'] = 'Barra de navegação de cor primária com cor de fonte escura';
$string['navbarheading'] = 'Barra de navegação';
$string['navigationheading'] = 'Navegação';
$string['navigationtab'] = 'Navegação';
$string['never'] = 'Nunca';
$string['nochange'] = 'Sem mudança';
$string['offerscontentsetting'] = 'Ofertas de conteúdo';
$string['offerscontentsetting_desc'] = 'Nesta configuração, você pode adicionar conteúdo em rich text que será mostrado na página de ofertas.';
$string['offersdisabled'] = 'A página de ofertas está desativada para este site. Não há nada para ver aqui.';
$string['offersheading'] = 'Ofertas';
$string['offerslinkpositionboth'] = 'Adicionar um link para a página de ofertas na nota de rodapé e no ícone de rodapé (ponto de interrogação)';
$string['offerslinkpositionfooter'] = 'Adicionar um link para a página de ofertas no ícone de rodapé (ponto de interrogação)';
$string['offerslinkpositionfootnote'] = 'Adicionar um link para a página de ofertas na nota de rodapé';
$string['offerslinkpositionnone'] = 'Não mostrar automaticamente um link para a página de ofertas';
$string['offerslinkpositionsetting'] = 'Posição do link de ofertas';
$string['offerslinkpositionsetting_desc'] = 'Nesta configuração, você pode definir se um link para a página de ofertas deve ser adicionado automaticamente à página do Moodle. Se você não quiser exibir um link automaticamente, poderá adicionar um link para {$a->url} manualmente em qualquer lugar no Moodle.';
$string['offerspagetitledefault'] = 'Ofertas';
$string['offerspagetitlesetting'] = 'Título da página de ofertas';
$string['offerspagetitlesetting_desc'] = 'Nesta configuração você pode definir o título da página de ofertas. Este texto também será usado como texto de link para a página de ofertas se você configurar a \'Posição do link de ofertas\' adequadamente.';
$string['openoffcanvas'] = 'Abrir a gaveta fora do canvas';
$string['outsideregionsheading'] = 'Regiões externas';
$string['outsideregionsheading_desc'] = 'As regiões externas podem não apenas ser habilitadas com as configurações de layout acima, mas sua aparência também pode ser personalizada.';
$string['outsideregionsplacement'] = 'Colocação horizontal das regiões externas';
$string['outsideregionsplacement_desc'] = 'Com esta configuração, você pode controlar se, em telas maiores, as regiões de bloco \'Externo (esquerda)\' e \'Externo (direita)\' devem ser colocadas perto da área de conteúdo principal ou perto das bordas da janela.';
$string['outsideregionsplacementnearwindowedges'] = 'Exibir regiões \'Externa (esquerda)\' e \'Externa (direita)\' próximas às bordas da janela';
$string['outsideregionsplacementnextmaincontent'] = 'Exibir regiões \'Externa (esquerda)\' e \'Externa (direita)\' próximas à área de conteúdo principal';
$string['outsideregionswidthcoursecontentwidth'] = 'Largura do conteúdo do curso';
$string['outsideregionswidthfullwidth'] = 'Largura total';
$string['outsideregionswidthherowidth'] = 'Largura hero';
$string['page1contentsetting'] = 'Conteúdo da página genérica 1';
$string['page1contentsetting_desc'] = 'Nesta configuração, você pode adicionar conteúdo em rich text que será exibido na página genérica 1.';
$string['page1disabled'] = 'A página genérica 1 está desativada para este site. Não há nada para ver aqui.';
$string['page1heading'] = 'Página genérica 1';
$string['page1linkpositionboth'] = 'Adicionar um link para a página genérica 1 na nota de rodapé e no ícone de rodapé (ponto de interrogação)';
$string['page1linkpositionfooter'] = 'Adicionar um link para a página genérica 1 no ícone de rodapé (ponto de interrogação)';
$string['page1linkpositionfootnote'] = 'Adicionar um link para a página genérica 1 na nota de rodapé';
$string['page1linkpositionnone'] = 'Não mostrar automaticamente um link para a página genérica 1';
$string['page1linkpositionsetting'] = 'Posição do link da página genérica 1';
$string['page1linkpositionsetting_desc'] = 'Nesta configuração, você pode definir se um link para a página genérica 1 deve ser adicionado automaticamente à página do Moodle. Se você não quiser exibir um link automaticamente, poderá adicionar um link para {$a->url} manualmente em qualquer lugar no Moodle.';
$string['page1pagetitledefault'] = 'Página genérica 1';
$string['page1pagetitlesetting'] = 'Título da página genérica 1';
$string['page1pagetitlesetting_desc'] = 'Nesta configuração, você pode definir o título da página genérica 1. Este texto também será usado como texto do link para a página genérica 1 se você configurar a \'Posição do link da página genérica 1\' adequadamente.';
$string['page2contentsetting'] = 'Conteúdo da página genérica 2';
$string['page2contentsetting_desc'] = 'Nesta configuração, você pode adicionar conteúdo em rich text que será exibido na página genérica 2.';
$string['page2disabled'] = 'A página genérica 2 está desativada para este site. Não há nada para ver aqui.';
$string['page2heading'] = 'Página genérica 2';
$string['page2linkpositionboth'] = 'Adicionar um link para a página genérica 2 na nota de rodapé e no ícone de rodapé (ponto de interrogação)';
$string['page2linkpositionfooter'] = 'Adicionar um link para a página genérica 2 no ícone de rodapé (ponto de interrogação)';
$string['page2linkpositionfootnote'] = 'Adicionar um link para a página genérica 2 na nota de rodapé';
$string['page2linkpositionnone'] = 'Não mostrar automaticamente um link para a página genérica 2';
$string['page2linkpositionsetting'] = 'Posição do link da página genérica 2';
$string['page2linkpositionsetting_desc'] = 'Nesta configuração você pode configurar se um link para a página genérica 2 deve ser adicionado automaticamente à página Moodle. Se você não quiser mostrar um link automaticamente, você pode adicionar um link para {$a->url} de qualquer lugar do Moodle manualmente.';
$string['page2pagetitledefault'] = 'Página genérica 2';
$string['page2pagetitlesetting'] = 'Título da página genérica 2';
$string['page2pagetitlesetting_desc'] = 'Nesta configuração, você pode definir o título da página genérica 2. Este texto também será usado como texto do link para a página genérica 2 se você configurar a \'Posição do link da página genérica 2\' adequadamente.';
$string['page3contentsetting'] = 'Conteúdo da página genérica 3';
$string['page3contentsetting_desc'] = 'Nesta configuração, você pode adicionar conteúdo em rich text que será exibido na página genérica 3.';
$string['page3disabled'] = 'A página genérica 3 está desativada para este site. Não há nada para ver aqui.';
$string['page3heading'] = 'Página genérica 3';
$string['page3linkpositionboth'] = 'Adicionar um link para a página genérica 3 na nota de rodapé e no ícone de rodapé (ponto de interrogação)';
$string['page3linkpositionfooter'] = 'Adicionar um link para a página genérica 3 no ícone de rodapé (ponto de interrogação)';
$string['page3linkpositionfootnote'] = 'Adicionar um link para a página genérica 3 na nota de rodapé';
$string['page3linkpositionnone'] = 'Não mostrar automaticamente um link para a página genérica 3';
$string['page3linkpositionsetting'] = 'Posição do link da página genérica 3';
$string['page3linkpositionsetting_desc'] = 'Nesta configuração você pode configurar se um link para a página genérica 3 deve ser adicionado automaticamente à página Moodle. Se você não quiser mostrar um link automaticamente, você pode adicionar um link para {$a->url} de qualquer lugar do Moodle manualmente.';
$string['page3pagetitledefault'] = 'Página genérica 3';
$string['page3pagetitlesetting'] = 'Título da página genérica 3';
$string['page3pagetitlesetting_desc'] = 'Nesta configuração, você pode definir o título da página genérica 3. Este texto também será usado como texto do link para a página genérica 3 se você configurar a \'Posição do link da página genérica 3\' adequadamente.';
$string['pagelayoutstab'] = 'Layouts de página';
$string['pagetab'] = 'Página';
$string['pagewidthheading'] = 'Largura da página';
$string['pluginname'] = 'Boost Union';
$string['policyheading'] = 'Políticas';
$string['policyoverviewnavigationsetting'] = 'Mostrar navegação na página de visão geral de políticas';
$string['policyoverviewnavigationsetting_desc'] = 'Por padrão, a <a href="{$a->url}">página de visão geral de políticas (fornecida pela ferramenta_policy)</a> não exibe um menu de navegação ou rodapé. Com esta configuração, você pode exibir a navegação principal e o rodapé nessa página.';
$string['presetbutton'] = 'Definir predefinição de tema no Boost';
$string['presetheading'] = 'Predefinições de tema';
$string['presetheading_desc'] = 'As predefinições de tema podem ser usadas para alterar drasticamente a aparência do tema. O Boost Union não reimplementa a configuração de predefinição de tema. Se você quiser usar predefinições de tema, configure-as diretamente no Boost. O Boost Union herdará e usará a predefinição configurada.';
$string['primarynavigationheading'] = 'Navegação principal';
$string['privacy:metadata'] = 'O tema Boost Magnific não armazena nenhum dado pessoal sobre nenhum usuário.';
$string['recentlyaccesseditemsheading'] = 'Bloco de itens acessados recentemente';
$string['recentlyaccesseditemstintenabled'] = 'Colorir os ícones de atividades de itens acessados recentemente';
$string['recentlyaccesseditemstintenabled_desc'] = 'Com esta configuração, você pode colorir os ícones de atividades no bloco de itens acessados recentemente com base nos propósitos das atividades. Por padrão, o núcleo do Moodle os exibe apenas como ícones pretos.';
$string['region-content-lower'] = 'Conteúdo (inferior)';
$string['region-content-upper'] = 'Conteúdo (superior)';
$string['region-footer-center'] = 'Rodapé (centro)';
$string['region-footer-left'] = 'Rodapé (esquerda)';
$string['region-footer-right'] = 'Rodapé (direita)';
$string['region-header'] = 'Cabeçalho';
$string['region-none'] = 'Nenhum';
$string['region-offcanvas-center'] = 'Fora do canvas (centro)';
$string['region-offcanvas-left'] = 'Fora do canvas (esquerda)';
$string['region-offcanvas-right'] = 'Fora do canvas (direita)';
$string['region-outside-bottom'] = 'Externo (inferior)';
$string['region-outside-left'] = 'Externo (esquerda)';
$string['region-outside-right'] = 'Externo (direita)';
$string['region-outside-top'] = 'Externo (superior)';
$string['resourcescachecontrolnote'] = 'Observe que os arquivos são enviados para o navegador com o cabeçalho \'Cache-Control\' definido, que informa ao navegador para armazenar o arquivo em cache. Se tiver certeza de que não alterará o arquivo em um futuro próximo, você poderá usar o URL persistente para vincular ao arquivo. No entanto, se você planeja modificar um arquivo, mas mantém o mesmo nome de vez em quando, você deve usar o URL revisado e vincular novamente o arquivo onde o usou sempre que atualizar o arquivo para evitar que os navegadores mostrem o cache versões desatualizadas do arquivo.';
$string['resourcestab'] = 'Recursos';
$string['scrollspysetting'] = 'Scroll-spy';
$string['scrollspysetting_desc'] = 'Com esta configuração, ao alternar o modo de edição ligado e desligado, a posição de rolagem onde o usuário estava ao realizar a alternância é preservada';
$string['scssheading'] = 'SCSS bruto';
$string['scsstab'] = 'SCSS';
$string['setpreferredlanglink'] = 'Definir idioma preferido';
$string['settingsoverview'] = 'Visão geral das configurações';
$string['settingsoverview_all'] = 'Todas as configurações em uma página';
$string['settingsoverview_all_desc'] = 'Aqui, você pode abrir a página de configurações padrão da categoria Moodle para o Boost Union, que exibe todas as configurações em uma página. Mas atenção, é realmente denso.';
$string['settingsoverview_content_desc'] = 'Configurações para o conteúdo global do seu site Moodle estão localizadas aqui: Rodapé, páginas estáticas, banners informativos, blocos de anúncios e sliders.';
$string['settingsoverview_feel_desc'] = 'Configurações para o comportamento geral do seu site Moodle estão localizadas aqui: Itens de navegação, auxiliares de navegação, blocos e links.';
$string['settingsoverview_flavours_desc'] = 'Com presets, você pode diversificar a aparência do seu site Moodle entre coortes e/ou categorias de cursos.';
$string['settingsoverview_functionality_desc'] = 'Configurações para funcionalidades globais adicionais ou relacionadas a cursos no seu site Moodle estão localizadas aqui.';
$string['settingsoverview_look_desc'] = 'Configurações para personalizar a marca do seu site Moodle estão localizadas aqui: Cores, ícones, imagens, tamanhos e, claro, SCSS personalizado.';
$string['settingsoverview_smartmenus_desc'] = 'Com menus inteligentes, você pode estender os itens de navegação do seu site Moodle no menu principal e nos menus de usuários, bem como introduzir um menu inferior ou um menu superior.';
$string['settingsoverview_title'] = 'Visão geral das configurações do Boost Union';
$string['showfullnameinusermenussetting'] = 'Mostrar nome completo no menu de usuário';
$string['showfullnameinusermenussetting_desc'] = 'Com esta configuração, você pode exibir o nome completo do usuário logado no topo do menu de usuário. Isso pode ser especialmente útil em situações de prova onde professores precisam confirmar que o usuário está logado com sua própria conta, mas também pode ser útil para o próprio usuário. Diferentemente do tema Clássico, que exibe o nome completo do usuário na barra de navegação próximo ao avatar, esta abordagem aqui não ocupa espaço adicional raro na barra de navegação.';
$string['showfullnameinusermenussetting_loggedinas'] = 'Você está logado como:';
$string['showhintcourseguestaccessgeneral'] = 'No momento, você está visualizando este curso como <strong>{$a->role}</strong>.';
$string['showhintcourseguestaccesslink'] = 'Para ter acesso total ao curso, você pode <a href="{$a->url}">inscrever-se neste curso</a>.';
$string['showhintcourseguestaccesssetting_desc'] = 'om esta configuração, uma dica aparecerá no cabeçalho do curso quando um usuário o acessar com o recurso de acesso como convidado. Se o curso oferecer autoinscrição ativa, um link para essa página também será apresentado ao usuário.';
$string['showhintcoursehiddengeneral'] = 'Este curso está atualmente <strong>oculto</strong>. Somente professores inscritos podem acessar este curso quando oculto.';
$string['showhintcoursehiddensetting'] = 'Mostrar dica em cursos ocultos';
$string['showhintcoursehiddensetting_desc'] = 'Com esta configuração, uma dica aparecerá no cabeçalho do curso enquanto a visibilidade do curso estiver oculta. Isso ajuda a identificar o estado de visibilidade de um curso rapidamente, sem a necessidade de verificar as configurações do curso.';
$string['showhintcoursehiddensettingslink'] = 'Você pode alterar a visibilidade nas <a href="{$a->url}">configurações do curso</a>.';
$string['showhintcourseselfenrolfrom'] = 'A instância de inscrição <strong>{$a->name}</strong> permite a autoinscrição irrestrita a partir de {$a->from}.';
$string['showhintcourseselfenrolfromuntil'] = 'A instância de inscrição <strong>{$a->name}</strong> permite a autoinscrição irrestrita de {$a->from} até {$a->until}.';
$string['showhintcourseselfenrolinstancecallforaction'] = 'Se você não quiser que nenhum usuário Moodle tenha acesso livre a este curso, restrinja as configurações de autoinscrição.';
$string['showhintcourseselfenrolsetting'] = 'Mostrar dica para autoinscrição sem chave de inscrição';
$string['showhintcourseselfenrolsetting_desc'] = 'Com esta configuração, uma dica aparecerá no cabeçalho do curso se o curso estiver visível e for possível a inscrição sem chave de inscrição no momento.';
$string['showhintcourseselfenrolsince'] = 'A instância de inscrição <strong>{$a->name}</strong> permite atualmente a autoinscrição irrestrita.';
$string['showhintcourseselfenrolsinceuntil'] = 'A instância de inscrição <strong>{$a->name}</strong> permite a autoinscrição irrestrita até {$a->until}.';
$string['showhintcourseselfenrolstartcurrently'] = 'Este curso está atualmente visível para todos e <strong>autoinscrição sem chave de inscrição</strong> é possível.';
$string['showhintcourseselfenrolstartfuture'] = 'Este curso está atualmente visível para todos e <strong>autoinscrição sem chave de inscrição</strong> está planejada para se tornar possível.';
$string['showhintcourseselfenrolunlimited'] = 'A instância de inscrição <strong>{$a->name}</strong> permite a autoinscrição irrestrita indefinidamente.';
$string['showhintcourseselfenroluntil'] = 'A instância de inscrição <strong>{$a->name}</strong> permite a autoinscrição irrestrita até {$a->until}.';
$string['showhintcoursguestaccesssetting'] = 'Mostrar dica para acesso como convidado';
$string['showhintforumnotifications'] = 'Este curso está atualmente <strong>oculto</strong>. Isso significa que <strong>os estudante não serão notificados</strong> online ou por e-mail de qualquer mensagem que você postar neste fórum.';
$string['showhintforumnotificationssetting'] = 'Mostrar dica para notificações de fórum em cursos ocultos';
$string['showhintforumnotificationssetting_desc'] = 'Com esta configuração, uma dica aparecerá não apenas no cabeçalho do curso, mas também nos fóruns enquanto a visibilidade do curso estiver oculta. Isso é para esclarecer que notificações em um fórum não são enviadas para os estudantes e ajudar os professores a entender essa circunstância.';
$string['shownavbarstarredcourses_config'] = 'Definir cursos marcados com estrela na página \'Meus cursos\\';
$string['shownavbarstarredcourses_label'] = 'Cursos estrelados';
$string['shownavbarstarredcoursessetting'] = 'Mostrar popover de cursos estrelados na barra de navegação';
$string['shownavbarstarredcoursessetting_desc'] = 'Com esta configuração, você pode exibir um menu popover com links para cursos estrelados próximo aos menus de mensagens e notificações.';
$string['showsitehomerighthandblockdraweronfirstloginsetting'] = 'Mostrar gaveta de blocos da página inicial do site à direita no primeiro login';
$string['showsitehomerighthandblockdraweronfirstloginsetting_desc'] = 'Com esta configuração, a gaveta de blocos à direita na página inicial do site será exibida expandida por padrão. Isso se aplica apenas a usuários que fazem login pela primeira vez e não substitui o estado de alternância de cada usuário individual.';
$string['showsitehomerighthandblockdraweronguestloginsetting'] = 'Mostrar gaveta de blocos da página inicial do site à direita no login como convidado';
$string['showsitehomerighthandblockdraweronguestloginsetting_desc'] = 'Com esta configuração, a gaveta de blocos à direita na página inicial do site será exibida expandida por padrão. Isso se aplica apenas a usuários que fazem login como convidados.';
$string['showsitehomerighthandblockdraweronvisitsetting'] = 'Mostrar gaveta de blocos da página inicial do site à direita na visita';
$string['showsitehomerighthandblockdraweronvisitsetting_desc'] = 'Com esta configuração, a gaveta de blocos à direita na página inicial do site será exibida expandida por padrão. Isso se aplica apenas a usuários que não estão logados e não substitui o estado de alternância de cada usuário individual.';
$string['showswitchedroleincoursesetting'] = 'Mostrar dica para papel trocado';
$string['showswitchedroleincoursesetting_desc'] = 'Com esta configuração, uma dica aparecerá no cabeçalho do curso se o usuário tiver trocado o papel no curso. Por padrão, essa informação é exibida apenas próximo ao avatar do usuário no menu de usuário. Ao habilitar esta opção, você pode exibir essa informação - junto com um link para alternar de volta - dentro da página do curso também.';
$string['showviewcourseiconincoursemgntsesetting_desc'] = 'Por padrão, na <a href="{$a}">página de gerenciamento do curso</a>, o Moodle exige que você abra os detalhes do curso ou passe pelas configurações do curso antes de clicar em um elemento adicional da UI para visualizá-lo. o curso. Ao ativar esta configuração, você pode adicionar um ícone “Ver curso” diretamente à listagem de categorias na página de gerenciamento do curso.';
$string['showviewcourseiconincoursemgntsetting'] = 'Mostrar ícone de visualizar curso';
$string['sitebrandingtab'] = 'Marca do site';
$string['sitehomerighthandblockdrawerbehaviour'] = 'Gaveta de blocos à direita na página inicial do site';
$string['slidebackgroundimagealtsetting'] = 'Slide {$a->no} atributo alternativo da imagem de fundo';
$string['slidebackgroundimagealtsetting_desc'] = 'Aqui você pode definir um atributo alt para a imagem do slide {$a->no}. Esta é uma configuração opcional, o slide será mostrado mesmo se você não definir um atributo alt. Observe que não fornecer um atributo alt reduz a acessibilidade.';
$string['slidebackgroundimagesetting'] = 'Imagem de fundo do slide {$a->no}';
$string['slidebackgroundimagesetting_desc'] = 'Aqui você pode fazer upload de um arquivo de imagem que será mostrado como imagem de fundo atrás do conteúdo do slide {$a->no}. Certifique-se ou verifique se o conteúdo ainda pode ser lido na imagem de fundo. Tente também certificar-se de que a proporção das imagens de fundo de todos os slides seja igual (já que a proporção da imagem de fundo controla a altura do slide e você pode querer evitar oscilações quando os slides são alterados). Esta é uma configuração obrigatória, o slide não será mostrado se você não fizer upload de nenhuma imagem de fundo.';
$string['slidecaptionsetting'] = 'Legenda do slide {$a->no}';
$string['slidecaptionsetting_desc'] = 'Aqui você insere a legenda que deverá ser exibida no slide {$a->no}. A legenda é exibida na parte inferior central do slide. Esta é uma configuração opcional, o slide será mostrado mesmo se você não definir uma legenda.';
$string['slidecontentsetting'] = 'Slide {$a->no} conteúdo';
$string['slidecontentsetting_desc'] = 'Aqui você insere o conteúdo que deverá ser exibido no slide {$a->no}. O conteúdo é exibido na parte inferior central do slide. Se uma legenda for definida, o conteúdo será exibido abaixo da legenda. Observe que o editor de rich text produz texto alinhado à esquerda por padrão, mas você pode querer alterá-lo para texto centralizado para uma aparência mais agradável. Evite também adicionar muito conteúdo ao slide e teste-o em dispositivos pequenos, pois o conteúdo que ultrapassar o slide será simplesmente ocultado. Esta é uma configuração opcional, o slide será mostrado mesmo se você não definir nenhum conteúdo.';
$string['slidecontentstylesetting'] = 'Estilo de conteúdo do slide {$a->no}';
$string['slidecontentstylesetting_dark'] = 'Escuro (cor da fonte preta para imagens de fundo claro)';
$string['slidecontentstylesetting_darkshadow'] = 'Escuro & Sombra (cor da fonte preta com uma sombra clara para imagens de fundo claro)';
$string['slidecontentstylesetting_desc'] = 'Aqui você pode modificar o estilo do conteúdo do slide {$a->no}. Por padrão, o estilo do conteúdo é uma fonte de cor branca para imagens de fundo escuro. No entanto, para permitir um estilo fácil e consistente em todos os tipos de imagens de fundo, você pode substituir o estilo aqui. Observe que esta configuração anulará a cor da fonte que você definiu no editor de rich text acima em qualquer caso.';
$string['slidecontentstylesetting_light'] = 'Claro (cor da fonte branca para imagens de fundo escuro)';
$string['slidecontentstylesetting_lightshadow'] = 'Claro & Sombra (cor da fonte branca com uma sombra escura para imagens de fundo escuro)';
$string['slideenabledsetting'] = 'Habilitar slide {$a->no}';
$string['slideenabledsetting_desc'] = 'Com esta configuração, você pode ativar o slide {$a->no}.';
$string['slideheading'] = 'Slide {$a->no}';
$string['slidelinksetting'] = 'Slide {$a->no} link URL';
$string['slidelinksetting_desc'] = 'Aqui, você pode definir uma URL (interna ou externa do Moodle) à qual o conteúdo do slide {$a->no} será vinculado. Esta é uma configuração opcional, o slide será mostrado mesmo se você não definir um URL de link.';
$string['slidelinksourcesetting'] = 'Fonte do link do slide {$a->no}';
$string['slidelinksourcesetting_both'] = 'Imagem de fundo e elementos de texto';
$string['slidelinksourcesetting_desc'] = 'Aqui, você pode controlar quais elementos do slider serão vinculados ao URL fornecido. Você pode escolher entre vincular apenas a imagem de fundo, apenas os elementos de texto do slide (legenda e conteúdo) ou ambos.';
$string['slidelinksourcesetting_image'] = 'Apenas a imagem de fundo';
$string['slidelinksourcesetting_text'] = 'Apenas os elementos de texto';
$string['slidelinktargetsetting'] = 'Slide {$a->no} link alvo';
$string['slidelinktargetsetting_desc'] = 'Aqui, você pode definir o destino do link que será definido para o link do slide assim que você definir um URL de link no slide {$a->no}.';
$string['slidelinktargetsetting_newtab'] = 'Nova aba';
$string['slidelinktargetsetting_samewindow'] = 'Mesma janela';
$string['slidelinktitlesetting'] = 'Título do link do slide {$a->no}';
$string['slidelinktitlesetting_desc'] = 'Aqui, você pode definir um título de link que será apresentado como dica de ferramenta assim que o usuário passar o mouse sobre o slide {$a->no}. Esta é uma configuração opcional, o slide será vinculado mesmo se você não definir um título para o link. Observe que não fornecer um título de link diminui a acessibilidade.';
$string['slideordersetting'] = 'Slide {$a->no} posição do pedido';
$string['slideordersetting_desc'] = 'Com esta configuração você define a posição da ordem do slide {$a->no}. Por padrão, os slides são ordenados conforme você os vê nesta página de configurações aqui. No entanto, você pode decidir atribuir outra posição de pedido com esta configuração. Se você atribuir a mesma posição de ordem a dois ou mais slides, eles serão ordenados novamente de acordo com a ordem nesta página de configurações.';
$string['slideranimationsetting'] = 'Tipo de animação do slider';
$string['slideranimationsetting_desc'] = 'Com esta configuração, você controla a animação do controle deslizante. \'Slide\' aplica uma animação deslizante, \'Fade\' aplica uma animação esmaecida e \'None\' remove todas as animações.';
$string['slideranimationsetting_fade'] = 'Desvanecer';
$string['slideranimationsetting_none'] = 'Nenhuma';
$string['slideranimationsetting_slide'] = 'Slide';
$string['sliderarrownavsetting'] = 'Habilitar navegação por setas';
$string['sliderarrownavsetting_desc'] = 'Com esta configuração, você pode adicionar setas de navegação em ambos os lados do slider.';
$string['sliderfrontpagepositionsetting'] = 'Posição do slider na página inicial do site';
$string['sliderfrontpagepositionsetting_afterafter'] = 'Após o conteúdo da página inicial (e após os blocos de anúncios)';
$string['sliderfrontpagepositionsetting_afterbefore'] = 'Após o conteúdo da página inicial (mas antes dos blocos de anúncios)';
$string['sliderfrontpagepositionsetting_beforeafter'] = 'Antes do conteúdo da página inicial (e após os blocos de anúncios)';
$string['sliderfrontpagepositionsetting_beforebefore'] = 'Antes do conteúdo da página inicial (mas antes dos blocos de anúncios)';
$string['sliderfrontpagepositionsetting_desc'] = 'O controle deslizante é mostrado apenas na página inicial do site. Com essa configuração, você controla se o controle deslizante é exibido antes do conteúdo inicial do site ou depois do conteúdo inicial do site. Se você quiser mostrar apenas o controle deslizante na página inicial do site e nada mais, todos os outros conteúdos da página inicial do site poderão ser removidos alterando as <a href="{$a->url}">configurações da página inicial do site</a>.';
$string['slidergeneralheading'] = 'Slider geral';
$string['sliderindicatornavsetting'] = 'Ativar a navegação do indicador deslizante';
$string['sliderindicatornavsetting_desc'] = 'Com esta configuração, você pode adicionar indicadores de navegação na parte inferior do slider.';
$string['sliderintervalsetting'] = 'Velocidade do intervalo do slider';
$string['sliderintervalsetting_desc'] = 'Com esta configuração, você controla por quanto tempo um slide é exibido em milissegundos. O valor mínimo é 1000 (um segundo) e o valor máximo é 10000 (10 segundos).';
$string['sliderkeyboardsetting'] = 'Permitir interação por teclado no slider';
$string['sliderkeyboardsetting_desc'] = 'Com esta configuração, você habilita entradas de teclado (teclas de seta) para controlar o slider. Note que desabilitar esta opção reduz a acessibilidade.';
$string['sliderpausesetting'] = 'Pausar o slider ao passar o mouse';
$string['sliderpausesetting_desc'] = 'Com esta configuração, você impede que o slider alterne os slides enquanto o usuário passa o mouse sobre um slide. Note que desabilitar esta opção reduz a acessibilidade.';
$string['sliderridesetting'] = 'Alternar slides';
$string['sliderridesetting_afterinteraction'] = 'Após a interação';
$string['sliderridesetting_desc'] = 'Com esta configuração, você controla o comportamento do ciclo do controle deslizante. \'No carregamento da página\' começa a percorrer os slides após o término do carregamento da página, \'Após a interação\' começará a circular depois que um usuário interagir com o controle deslizante. \'Nunca\' desativa totalmente o ciclo automático de slides, exigindo a entrada do usuário para percorrer os slides.';
$string['sliderridesetting_never'] = 'Nunca';
$string['sliderridesetting_onpageload'] = 'Ao carregar a página';
$string['slidertab'] = 'Slider';
$string['sliderwrapsetting'] = 'Percorrer continuamente os slides';
$string['sliderwrapsetting_desc'] = 'Com esta configuração, você permite que o slider alterne todos os slides. Se desativar esta opção, o slider parará no último slide.';
$string['smartmenus'] = 'Menus inteligentes';
$string['smartmenus_desc'] = '<p>Os menus inteligentes permitem que os administradores do site criem menus personalizáveis que podem ser colocados em diferentes locais do site, como o menu principal, o menu inferior em dispositivos móveis e o menu de usuários. Os menus podem ser configurados para exibir diferentes tipos de conteúdo, incluindo links para outras páginas ou recursos, links de categorias ou links de perfis de usuários.</p><p>Os administradores do site podem criar um novo menu, especificar os itens do menu e definir configurações de exibição. O administrador também pode escolher onde o menu será exibido no site e se será visível para todos os usuários ou apenas para certos papéis de usuário.</p>';
$string['smartmenusbyadmin'] = 'Mostrar para';
$string['smartmenusbyadmin_admins'] = 'Apenas administradores do site';
$string['smartmenusbyadmin_all'] = 'Todos os usuários';
$string['smartmenusbycohort'] = 'Por coorte';
$string['smartmenusbycohort_help'] = 'Restringir a visibilidade com base nas coortes do usuário.';
$string['smartmenusbydate'] = 'Por data';
$string['smartmenusbydate_help'] = 'Restringir a visibilidade com base na data';
$string['smartmenusbydatefrom'] = 'A partir de';
$string['smartmenusbydatefrom_help'] = 'Restringir a visibilidade antes da data especificada ser alcançada';
$string['smartmenusbydateuntil'] = 'Até';
$string['smartmenusbydateuntil_help'] = 'Restringir a visibilidade após a data especificada ser alcançada';
$string['smartmenusbylanguage'] = 'Por idioma';
$string['smartmenusbylanguage_help'] = 'Restringir a visibilidade com base no idioma do usuário';
$string['smartmenusbyrole'] = 'Por papel';
$string['smartmenusbyrole_help'] = 'Restringir a visibilidade com base nos papéis do usuário.';
$string['smartmenusdynamiccoursescompletionstatus'] = 'Status de conclusão';
$string['smartmenusdynamiccoursescompletionstatus_help'] = 'A lista de itens do menu de cursos dinâmicos conterá todos os cursos do usuário que correspondem ao status de conclusão selecionado. Por exemplo, se você selecionar \'Em andamento\' como status de conclusão, a lista de itens do menu de cursos dinâmicos conterá apenas os cursos nos quais o usuário atual está trabalhando.';
$string['smartmenusdynamiccoursescompletionstatuscompleted'] = 'Concluído';
$string['smartmenusdynamiccoursescompletionstatusenrolled'] = 'Inscrito';
$string['smartmenusdynamiccoursescompletionstatusinprogress'] = 'Em andamento';
$string['smartmenusdynamiccoursescoursecategory'] = 'Categoria do curso';
$string['smartmenusdynamiccoursescoursecategory_help'] = 'A lista dinâmica de itens de menu de cursos conterá todos os cursos das categorias de curso selecionadas.';
$string['smartmenusdynamiccoursescoursecategorysubcats'] = 'Incluir subcategorias';
$string['smartmenusdynamiccoursescoursecategorysubcats_help'] = 'Se marcado, o menu dinâmico de cursos também conterá todos os cursos das subcategorias das categorias de curso selecionadas.';
$string['smartmenusdynamiccoursesdaterange'] = 'Intervalo de datas';
$string['smartmenusdynamiccoursesdaterange_help'] = 'A lista dinâmica de itens de menu de cursos conterá todos os cursos que estejam dentro do intervalo de datas selecionado.';
$string['smartmenusdynamiccoursesdaterangefuture'] = 'Futuro';
$string['smartmenusdynamiccoursesdaterangepast'] = 'Passado';
$string['smartmenusdynamiccoursesdaterangepresent'] = 'Presente';
$string['smartmenusdynamiccoursesenrolmentrole'] = 'Papel de inscrição';
$string['smartmenusdynamiccoursesenrolmentrole_help'] = 'A lista dinâmica de itens de menu de cursos conterá todos os cursos onde o usuário está inscrito com o papel selecionado.';
$string['smartmenusexperimental'] = 'Observação: A funcionalidade de menus inteligentes é totalmente utilizável no estado atual de implementação, mas deve ser <em>considerada experimental</em> devido à grande quantidade de combinações de configurações que ainda podem gerar problemas inesperados. Nesse contexto, teste seus menus inteligentes com suas configurações individuais cuidadosamente. Se encontrar problemas com menus inteligentes, relate-os no <a href="https://github.com/moodle-an-hochschulen/moodle-theme_boost_union/issues">Github</a> com etapas claras para reproduzir o problema.';
$string['smartmenusgeneralsectionheader'] = 'Configurações gerais';
$string['smartmenusmenuaddnewitem'] = 'Adicionar item ao menu';
$string['smartmenusmenucardform'] = 'Formato do card';
$string['smartmenusmenucardform_help'] = 'Selecione o formato do card para menus em estilo card, escolhendo entre quadrado, retrato, paisagem ou largura total.';
$string['smartmenusmenucardformfullwidth'] = 'Largura total';
$string['smartmenusmenucardformlandscape'] = 'Paisagem';
$string['smartmenusmenucardformportrait'] = 'Retrato';
$string['smartmenusmenucardformsquare'] = 'Quadrado';
$string['smartmenusmenucardoverflowbehavior'] = 'Comportamento de transbordamento do card';
$string['smartmenusmenucardoverflowbehavior_help'] = 'Selecione como o menu deve se comportar quando ultrapassar seu contêiner, escolhendo entre exibir uma barra de rolagem ou ajustar os itens excedentes.';
$string['smartmenusmenucardoverflowbehaviornowrap'] = 'Não ajustar';
$string['smartmenusmenucardoverflowbehaviorwrap'] = 'Ajustar';
$string['smartmenusmenucardsize'] = 'Tamanho do card';
$string['smartmenusmenucardsize_help'] = 'Selecione o tamanho do card para menus em estilo card, escolhendo entre pequeno, médio, grande ou muito grande.';
$string['smartmenusmenucardsizelarge'] = 'Muito grande';
$string['smartmenusmenucardsizemedium'] = 'Médio';
$string['smartmenusmenucardsizesmall'] = 'Pequeno';
$string['smartmenusmenucardsizetiny'] = 'Minúsculo';
$string['smartmenusmenucreate'] = 'Criar menu';
$string['smartmenusmenucreatesuccess'] = 'Menu inteligente criado com sucesso';
$string['smartmenusmenucssclass'] = 'Classe CSS';
$string['smartmenusmenucssclass_help'] = 'Insira uma classe CSS para o menu. Isso pode ser usado para aplicar estilos personalizados ao menu.';
$string['smartmenusmenudeleteconfirm'] = 'Tem certeza de que deseja excluir este menu dos menus inteligentes?';
$string['smartmenusmenudeletesuccess'] = 'Menu inteligente excluído com sucesso';
$string['smartmenusmenudescription'] = 'Descrição';
$string['smartmenusmenudescription_help'] = 'A descrição do cardápio. Isto será usado principalmente como documentação interna, mas você também pode exibi-lo no menu usando a opção ‘Mostrar descrição’.';
$string['smartmenusmenuduplicate'] = 'Duplicar menu e seus itens';
$string['smartmenusmenuduplicatesuccess'] = 'Menu e seus itens duplicados com sucesso';
$string['smartmenusmenuedit'] = 'Editar menu';
$string['smartmenusmenueditsuccess'] = 'Menu inteligente atualizado com sucesso';
$string['smartmenusmenuitemcardappearanceheader'] = 'Aparência do cartão';
$string['smartmenusmenuitemcardbackgroundcolor'] = 'Cor de fundo do cartão';
$string['smartmenusmenuitemcardbackgroundcolor_help'] = 'Selecione a cor de fundo para o cartão do item de menu';
$string['smartmenusmenuitemcardimage'] = 'Imagem do cartão';
$string['smartmenusmenuitemcardimage_help'] = 'Selecione uma imagem para exibir ao lado do título do item de menu no cartão.';
$string['smartmenusmenuitemcardtextcolor'] = 'Cor do texto do cartão';
$string['smartmenusmenuitemcardtextcolor_help'] = 'Selecione a cor do texto para o cartão do item de menu.';
$string['smartmenusmenuitemcreate'] = 'Criar item de menu';
$string['smartmenusmenuitemcreatesuccess'] = 'Item de menu inteligente criado com sucesso';
$string['smartmenusmenuitemcssclass'] = 'Classe CSS';
$string['smartmenusmenuitemcssclass_help'] = 'Insira uma classe CSS para o item de menu. Isso pode ser usado para aplicar estilos personalizados ao item de menu.';
$string['smartmenusmenuitemdeleteconfirm'] = 'Tem certeza de que deseja excluir este item de menu do menu inteligente?';
$string['smartmenusmenuitemdeletesuccess'] = 'Item de menu inteligente excluído com sucesso';
$string['smartmenusmenuitemdisplayallcourses'] = 'Mostrar cursos ocultos';
$string['smartmenusmenuitemdisplayfield'] = 'Apresentação do nome do curso';
$string['smartmenusmenuitemdisplayfield_help'] = 'O nome do curso que será usado como título dos itens de menu de cursos dinâmicos. Escolha entre o nome completo do curso e o nome curto do curso';
$string['smartmenusmenuitemdisplayfieldcoursefullname'] = 'Nome completo do curso';
$string['smartmenusmenuitemdisplayfieldcourseshortname'] = 'Nome curto do curso';
$string['smartmenusmenuitemdisplayoptions'] = 'Apresentação do título';
$string['smartmenusmenuitemdisplayoptions_help'] = 'Escolha como deseja que o título do item de menu seja exibido.';
$string['smartmenusmenuitemdisplayoptionshidetitle'] = 'Ocultar texto do título e mostrar apenas o ícone (em todos os dispositivos)';
$string['smartmenusmenuitemdisplayoptionshidetitlemobile'] = 'Ocultar texto do título e mostrar apenas o ícone (em dispositivos móveis)';
$string['smartmenusmenuitemdisplayoptionsshowtitleicon'] = 'Mostrar texto e ícone como título';
$string['smartmenusmenuitemduplicate'] = 'Duplicar item de menu';
$string['smartmenusmenuitemduplicatesuccess'] = 'Item de menu duplicado com sucesso';
$string['smartmenusmenuitemedit'] = 'Editar item de menu';
$string['smartmenusmenuitemeditsuccess'] = 'Item de menu inteligente atualizado com sucesso';
$string['smartmenusmenuitemhidehiddencourses'] = 'Esconder cursos ocultos';
$string['smartmenusmenuitemicon'] = 'Ícone';
$string['smartmenusmenuitemicon_help'] = 'O ícone a ser exibido ao lado do título do item de menu.';
$string['smartmenusmenuitemlinktarget'] = 'Destino do link';
$string['smartmenusmenuitemlinktarget_help'] = 'O destino para o link do item de menu. O link do item de menu será aberto neste destino ao ser clicado (por exemplo, na mesma janela ou em uma nova aba).';
$string['smartmenusmenuitemlinktargetnewtab'] = 'Nova aba';
$string['smartmenusmenuitemlinktargetsamewindow'] = 'Mesma janela';
$string['smartmenusmenuitemlistsort'] = 'Ordenação da lista de cursos';
$string['smartmenusmenuitemlistsort_help'] = 'A lista de cursos será ordenada pelos critérios e ordem selecionados. Escolha entre nome completo, nome curto, ID do curso e número do ID do curso como critérios em combinação com a ordem crescente ou decrescente.';
$string['smartmenusmenuitemlistsortcourseidasc'] = 'ID do curso ascendente';
$string['smartmenusmenuitemlistsortcourseiddesc'] = 'ID do curso descendente';
$string['smartmenusmenuitemlistsortcourseidnumberasc'] = 'Número do ID do curso ascendente';
$string['smartmenusmenuitemlistsortcourseidnumberdesc'] = 'Número do ID do curso descendente';
$string['smartmenusmenuitemlistsortfullnameasc'] = 'Nome completo do curso ascendente';
$string['smartmenusmenuitemlistsortfullnamedesc'] = 'Nome completo do curso descendente';
$string['smartmenusmenuitemlistsortshortnameasc'] = 'Nome curto do curso ascendente';
$string['smartmenusmenuitemlistsortshortnamedesc'] = 'Nome curto do curso descendente';
$string['smartmenusmenuitemmode'] = 'Modo do item de menu';
$string['smartmenusmenuitemmode_help'] = '<p>Selecione o modo como o item de menu deve ser exibido dentro do menu.</p><ul><li>Em linha: O item de menu é exibido como um item de menu regular dentro do menu. Esta é a opção padrão.</li><li>Submenu: O item de menu é exibido como um item de submenu, que pode ser expandido ou recolhido clicando no item pai. Este modo é útil para construir um terceiro nível de navegação, bem como para itens de menu de cursos dinâmicos, onde listas de cursos podem ser exibidas como submenus deste item de menu. O título deste item de menu é usado como texto para o item de submenu.</li></ul>';
$string['smartmenusmenuitemnothingtodisplay'] = 'Ainda não há itens adicionados a este menu inteligente. Por favor, adicione um item a este menu.';
$string['smartmenusmenuitemorder'] = 'Ordem';
$string['smartmenusmenuitemorder_help'] = 'Reorganize a posição do item, se necessário. Todos os itens do menu serão ordenados por este valor de ordem.';
$string['smartmenusmenuitempresentationheader'] = 'Apresentação do item de menu';
$string['smartmenusmenuitemresponsive'] = 'Ocultação responsiva';
$string['smartmenusmenuitemresponsive_help'] = 'Ao habilitar qualquer uma destas caixas de seleção, o item de menu será oculto em dispositivos com o tamanho de tela selecionado.';
$string['smartmenusmenuitemresponsivedesktop'] = 'Desktop';
$string['smartmenusmenuitemresponsivemobile'] = 'Móvel';
$string['smartmenusmenuitemresponsivetablet'] = 'Tablet';
$string['smartmenusmenuitemrestriction'] = 'Regras de acesso';
$string['smartmenusmenuitems'] = 'Itens de menu';
$string['smartmenusmenuitemstructureheader'] = 'Estrutura do item de menu';
$string['smartmenusmenuitemtextcount'] = 'Número de palavras';
$string['smartmenusmenuitemtextcount_help'] = 'Especifique o número máximo de palavras a serem exibidas como título nos itens de menu de cursos dinâmicos. Se você deixar este campo vazio, o título será exibido em comprimento total.';
$string['smartmenusmenuitemtextposition'] = 'Posição do texto do cartão';
$string['smartmenusmenuitemtextposition_help'] = '<p>Selecione a posição do texto do item de menu em relação à imagem do cartão, escolhendo entre abaixo da imagem, sobreposição superior e sobreposição inferior.</p><ul><li>Sobreposição superior: Exibe o título do item de menu sobre a sobreposição e na parte superior do cartão.</li><li>Sobreposição inferior: Exibe o título do item de menu sobre a sobreposição e na parte inferior do cartão.</li><li>Abaixo da imagem: Exibe o título do item de menu abaixo da imagem do cartão.</li></ul>';
$string['smartmenusmenuitemtextpositionbelowimage'] = 'Abaixo da imagem';
$string['smartmenusmenuitemtextpositionoverlaybottom'] = 'Sobreposição inferior';
$string['smartmenusmenuitemtextpositionoverlaytop'] = 'Sobreposição superior';
$string['smartmenusmenuitemtitle'] = 'Título';
$string['smartmenusmenuitemtitle_help'] = 'O título do menu. Isso será usado como rótulo deste item de menu. Se você deseja exibir um separador no menu, escolha Cabeçalho como tipo e use sinais de cerquilha (###) como título.';
$string['smartmenusmenuitemtooltip'] = 'Dica de ferramenta';
$string['smartmenusmenuitemtooltip_help'] = 'A dica de ferramenta que será exibida quando o usuário passar o mouse sobre o item de menu.';
$string['smartmenusmenuitemtype'] = 'Tipo de item de menu';
$string['smartmenusmenuitemtype_help'] = '<p>Selecione o tipo de item de menu que deseja criar, escolhendo entre estático, cabeçalho e cursos dinâmicos.</p><ul><li>Estático: Um item de menu estático é simplesmente um link para uma URL fixa que não muda.</li><li>Cabeçalho: Um item de menu cabeçalho é usado para agrupar itens de menu relacionados sob um cabeçalho comum. Não possui link e não é clicável.</li><li>Cursos dinâmicos: Um item de menu de cursos dinâmicos é usado para exibir uma lista de cursos com base em certos critérios, como categoria do curso, papel de inscrição no curso, status de conclusão do curso ou intervalo de datas. O conteúdo exibido em um item de menu de cursos dinâmicos será atualizado automaticamente conforme os critérios mudam.</li></ul>';
$string['smartmenusmenuitemtypedocs'] = 'Documentação do Moodle';
$string['smartmenusmenuitemtypedynamiccourses'] = 'Cursos dinâmicos';
$string['smartmenusmenuitemtypeheading'] = 'Cabeçalho';
$string['smartmenusmenuitemtypestatic'] = 'Estático';
$string['smartmenusmenuitemurl'] = 'URL do item de menu';
$string['smartmenusmenuitemurl_help'] = 'A URL estática para o item de menu. Este é o link que será seguido quando o item de menu for clicado.';
$string['smartmenusmenulocation'] = 'Localização do menu';
$string['smartmenusmenulocation_help'] = '<p>Selecione os locais onde deseja que o menu apareça na página:</p><ul><li>A navegação principal está no topo da página onde o núcleo do Moodle já exibe os itens de navegação Início, Painel, Meus cursos e Administração do site.</li><li>A barra de menus está localizada acima da navegação principal, na parte superior da página.</li><li>O menu do usuário pode ser acessado clicando no avatar do usuário na barra de navegação.</li><li>A barra inferior é colocada na parte inferior da tela e pode ser usada para implementar uma navegação por polegar para facilitar o acesso a áreas importantes, como o painel, a página Meus cursos ou a página inicial.</li></ul><p>Observe que, ao habilitar a barra inferior, o ícone de hambúrguer será substituído pelo logotipo do seu site, porque os usuários poderão acessar a navegação principal usando a barra inferior.</p>';
$string['smartmenusmenulocationbottom'] = 'Barra inferior';
$string['smartmenusmenulocationmain'] = 'Navegação principal';
$string['smartmenusmenulocationmenu'] = 'Barra de menus';
$string['smartmenusmenulocationuser'] = 'Menu do usuário';
$string['smartmenusmenumode'] = 'Modo do menu';
$string['smartmenusmenumode_help'] = '<p>Selecione o modo como os itens do menu devem ser exibidos.</p><ul><li>Submenu: Os itens do menu são exibidos como um submenu com o título do menu como nó pai. Esta é a opção padrão.</li><li>Em linha: Os itens do menu são exibidos diretamente na navegação, um após o outro. Observe que esta opção não é suportada para menus do tipo cartão.</li></ul>';
$string['smartmenusmenumoremenubehavior'] = 'Comportamento do menu mais';
$string['smartmenusmenumoremenubehavior_help'] = '<p>Selecione o que deve acontecer se houver muitos menus para caber na localização do menu.</p><ul><li>Não alterar nada: Nenhum comportamento particular será imposto, os menus em excesso serão movidos automaticamente para o menu \'Mais\'.</li><li>Forçar para o menu mais: Este modo move o menu diretamente para o menu \'Mais\', mesmo que ainda haja espaço.</li><li>Manter fora do menu mais: Este modo mantém o menu fora do menu \'Mais\' pelo maior tempo possível – movendo outros menus subsequentes para o menu mais, se necessário.</li></ul><p>Observe que esta configuração afeta apenas menus localizados na navegação principal ou na área da barra de menus.</p>';
$string['smartmenusmenumoremenubehaviorforceinto'] = 'Forçar para o menu mais';
$string['smartmenusmenumoremenubehaviorkeepoutside'] = 'Manter fora do menu mais';
$string['smartmenusmenunothingtodisplay'] = 'Ainda não existem menus inteligentes criados. Por favor, crie seu primeiro menu inteligente para começar.';
$string['smartmenusmenupresentationheader'] = 'Apresentação do Menu';
$string['smartmenusmenushowdescription'] = 'Mostrar descrição';
$string['smartmenusmenushowdescription_help'] = '<p>Selecione se/como a descrição deve ser exibida no menu, escolhendo entre Nunca, Acima, Abaixo e Ajuda.</p><ul><li>Nunca: Não exibe a descrição no menu e a usa apenas para fins internos. Esta é a opção padrão.</li><li>Acima: Exibe a descrição no topo da lista de itens do menu.</li><li>Abaixo: Exibe a descrição no final da lista de itens do menu.</li><li>Ajuda: Exibe a descrição como ícone de ajuda próximo à lista de itens do menu.</li></ul>';
$string['smartmenusmenushowdescriptionabove'] = 'Acima';
$string['smartmenusmenushowdescriptionbelow'] = 'Abaixo';
$string['smartmenusmenushowdescriptionhelp'] = 'Ajuda';
$string['smartmenusmenushowdescriptionnever'] = 'Nunca';
$string['smartmenusmenustructureheader'] = 'Estrutura do menu';
$string['smartmenusmenutitle'] = 'Título';
$string['smartmenusmenutitle_help'] = 'O título do menu. Este será usado como o rótulo do nó pai deste menu.';
$string['smartmenusmenutype'] = 'Tipo de apresentação';
$string['smartmenusmenutype_help'] = '<p>Selecione o tipo de apresentação do menu, escolhendo entre lista e cartão.</p><ul><li>Lista: Um menu em lista é composto por links de texto simples. Esta é a opção padrão.</li><li>Cartão: Um menu de cartões é composto por cartões.</li></ul>';
$string['smartmenusmenutypecard'] = 'Cartão';
$string['smartmenusmenutypelist'] = 'Lista';
$string['smartmenusmodeinline'] = 'Inline';
$string['smartmenusmodesubmenu'] = 'Submenu';
$string['smartmenusnorestrict'] = 'Não restrito';
$string['smartmenusoperator'] = 'Operador';
$string['smartmenusoperator_help'] = 'Selecione o operador para a condição de coorte (Qualquer ou Todos)';
$string['smartmenusrestrictbycohortsheader'] = 'Restringir visibilidade por coortes';
$string['smartmenusrestrictbydateheader'] = 'Restringir visibilidade por data';
$string['smartmenusrestrictbylanguageheader'] = 'Restringir visibilidade por idioma';
$string['smartmenusrestrictbyrolesheader'] = 'Restringir visibilidade por papéis';
$string['smartmenusrolecontext'] = 'Contexto';
$string['smartmenusrolecontext_help'] = 'Selecione o contexto para o qual o papel do usuário deve ser verificado (Qualquer contexto ou apenas contexto do sistema)';
$string['smartmenussavechangesandconfigure'] = 'Salvar e configurar itens';
$string['smartmenussettings'] = 'Configurações do menu inteligente';
$string['speciallinksmarkupheading'] = 'Marcação de links especiais';
$string['staticpagestab'] = 'Páginas estáticas';
$string['switchedroleto'] = 'Você está visualizando este curso atualmente com a função: <strong>{$a->role}</strong>';
$string['task_purgecache'] = 'Limpar cache do tema';
$string['tilebackgroundimagepositionsetting'] = 'Posição da imagem de fundo do bloco de anúncio {$a->no}';
$string['tilebackgroundimagepositionsetting_desc'] = 'Com esta configuração, você controla o posicionamento da imagem de fundo dentro do contêiner do bloco de anúncio {$a->no}. O primeiro valor é a posição horizontal, o segundo valor é a posição vertical.';
$string['tilebackgroundimagesetting'] = 'Imagem de fundo do bloco de anúncio {$a->no}';
$string['tilebackgroundimagesetting_desc'] = 'Aqui, você pode fazer upload de um arquivo de imagem que será mostrado como imagem de fundo atrás do conteúdo do bloco de anúncio {$a->no}. Certifique-se ou verifique se o conteúdo ainda pode ser lido na imagem de fundo. Esta é uma configuração opcional, o bloco de anúncio funcionará mesmo se você não carregar nenhuma imagem de fundo.';
$string['tilecolumnssetting'] = 'Número de colunas de blocos de anúncio por linha';
$string['tilecolumnssetting_desc'] = 'Aqui, você define o número de colunas por linha na grade apresentada de blocos de anúncio. Note que esse número de colunas se aplica a desktops/telas maiores. Em telas menores e dispositivos móveis, as colunas de blocos de anúncio são automaticamente ajustadas.';
$string['tilecontentsetting'] = 'Bloco de anúncio {$a->no} conteúdo';
$string['tilecontentsetting_desc'] = 'Aqui, você insere o conteúdo que deve ser exibido no bloco de anúncio {$a->no}. O conteúdo é exibido no meio do bloco. Esta é uma configuração opcional, o bloco será mostrado mesmo sem conteúdo definido.';
$string['tilecontentstylesetting'] = 'Estilo do conteúdo do bloco de anúncio {$a->no}';
$string['tilecontentstylesetting_dark'] = 'Escuro (cor da fonte preta para imagens de fundo claras)';
$string['tilecontentstylesetting_darkshadow'] = 'Escuro e sombra (cor da fonte preta com sombra clara para imagens de fundo claras)';
$string['tilecontentstylesetting_desc'] = 'Aqui você pode modificar o estilo do conteúdo do bloco de anúncio {$a->no}. Por padrão, o estilo do conteúdo é controlado pelo estilo definido no editor de rich text acima. No entanto, para permitir um estilo fácil e consistente, especialmente ao usar texto em imagens de fundo, você pode substituir o estilo aqui.';
$string['tilecontentstylesetting_light'] = 'Claro (cor da fonte branca para imagens de fundo escuras)';
$string['tilecontentstylesetting_lightshadow'] = 'Claro e sombra (cor da fonte branca com sombra escura para imagens de fundo escuras)';
$string['tilecontentstylesetting_nochange'] = 'Sem alteração (controle todo o estilo no editor de texto avançado)';
$string['tileenabledsetting'] = 'Ativar bloco de anúncio {$a->no}';
$string['tileenabledsetting_desc'] = 'Com esta configuração, você pode ativar o bloco de anúncio {$a->no}.';
$string['tilefrontpagepositionsetting'] = 'Posição dos blocos de anúncio na página inicial';
$string['tilefrontpagepositionsetting_after'] = 'Após o conteúdo da página inicial';
$string['tilefrontpagepositionsetting_before'] = 'Antes do conteúdo da página inicial';
$string['tilefrontpagepositionsetting_desc'] = 'Os blocos de anúncios são exibidos apenas na página inicial do site. Com essa configuração, você controla se os blocos de anúncios serão exibidos antes do conteúdo inicial do site ou depois do conteúdo inicial do site. Se você quiser mostrar apenas os blocos de anúncios na página inicial do site e nada mais, todos os outros conteúdos da página inicial do site poderão ser removidos alterando as <a href="{$a->url}">configurações da página inicial do site</a>.';
$string['tileheading'] = 'Bloco de anúncio {$a->no}';
$string['tileheightsetting'] = 'Altura dos blocos de anúncio';
$string['tileheightsetting_desc'] = 'Com esta configuração, você controla a altura dos blocos de anúncio. A altura configurada é a mínima de cada bloco. Se o conteúdo de um bloco for maior, toda a linha será automaticamente ajustada para acomodar.';
$string['tilelinksetting'] = 'URL do link do bloco de anúncio {$a->no}';
$string['tilelinksetting_desc'] = 'Aqui, você pode definir uma URL (interna ou externa do Moodle) que será oferecida como botão de link no final do bloco de anúncio {$a->no}. Esta é uma configuração opcional, o bloco de anúncio funcionará mesmo se você não definir nenhum URL de link.';
$string['tilelinktargetsetting'] = 'Bloco de anúncio {$a->no} link target';
$string['tilelinktargetsetting_desc'] = 'Aqui, você pode definir o destino do link definido para o botão do link assim que definir um URL de link no bloco de anúncio {$a->no}.';
$string['tilelinktargetsetting_newtab'] = 'Nova aba';
$string['tilelinktargetsetting_samewindow'] = 'Mesma janela';
$string['tilelinktitlefallback'] = 'Link';
$string['tilelinktitlesetting'] = 'Título do link do bloco de anúncio {$a->no}';
$string['tilelinktitlesetting_desc'] = 'Aqui, você pode definir um título de link que será usado como rótulo do botão de link assim que você definir um URL de link no bloco de anúncio {$a->no}. Observe que se você definir um URL de link, mas não definir um título para o link, o botão do link será rotulado apenas como \'Link\'.';
$string['tileordersetting'] = 'Bloco de anúncio {$a->no} posição do pedido';
$string['tileordersetting_desc'] = 'Com esta configuração, você define a posição de ordem do bloco de anúncio {$a->no}. Por padrão, os blocos de anúncios são ordenados de cima para baixo e da esquerda para a direita, como você os vê nesta página de configurações aqui. No entanto, você pode decidir atribuir outra posição de pedido com esta configuração. Se você atribuir a mesma posição de pedido a dois ou mais blocos de anúncios, eles serão ordenados novamente de acordo com a ordem nesta página de configurações.';
$string['tilesgeneralheading'] = 'Configuração geral dos blocos de anúncio';
$string['tilestab'] = 'Blocos de anúncio';
$string['tiletitlesetting'] = 'Título do bloco de anúncio {$a->no}';
$string['tiletitlesetting_desc'] = 'Aqui, você insere o título que deve ser exibido no bloco de anúncio {$a->no}. Esta é uma configuração opcional, o bloco de anúncio será mostrado mesmo se você não definir um título.';
$string['timelineheading'] = 'Bloco de linha do tempo';
$string['timelinetintenabled'] = 'Colorir ícones de atividades na linha do tempo';
$string['timelinetintenabled_desc'] = 'Com esta configuração, você pode colorir os ícones de atividades no bloco de linha do tempo com base nos propósitos da atividade. Por padrão, o Moodle exibe-os como ícones pretos.';
$string['touchiconfilesios'] = 'Arquivos de ícones de toque para iOS';
$string['touchiconfilesios_desc'] = 'Nesta configuração, você pode fazer upload de arquivos usados como ícones de tela inicial quando o site Moodle é adicionado como favorito na tela inicial do iOS.';
$string['touchiconfilesios_example'] = 'Exemplo de nome de arquivo: apple-icon-152x152.png';
$string['touchiconfilesios_note'] = 'Os arquivos recomendados têm um bom tamanho para serem exibidos adequadamente em dispositivos iOS atuais e devem ser fornecidos. Arquivos opcionais são (ou já foram) suportados por dispositivos iOS, mas devem ser considerados opcionais, a menos que você precise dar suporte a dispositivos legados específicos.';
$string['touchiconfilesios_optional'] = 'Arquivos opcionais para iOS:';
$string['touchiconfilesios_recommended'] = 'Arquivos recomendados para iOS:';
$string['touchiconfilesioslist'] = 'Lista de arquivos de ícones de toque para iOS';
$string['touchiconfilesioslist_desc'] = 'Esta é a lista de arquivos que você carregou na área de arquivos de ícones de toque para iOS.';
$string['touchiconlistiosoptionalmissing'] = 'Este é um arquivo opcional para ser usado como ícone de toque em dispositivos iOS, mas não foi carregado.';
$string['touchiconlistiosoptionaluploaded'] = 'Este é um arquivo opcional para ser usado como ícone de toque em dispositivos iOS e foi carregado.';
$string['touchiconlistiosrecommendedmissing'] = 'Este é um arquivo recomendado para ser usado como ícone de toque em dispositivos iOS, mas não foi carregado corretamente.';
$string['touchiconlistiosrecommendeduploaded'] = 'Este é um arquivo recomendado para ser usado como ícone de toque em dispositivos iOS e foi carregado.';
$string['upcomingeventsheading'] = 'Bloco de eventos futuros';
$string['upcomingeventstintenabled'] = 'Colorir ícones de atividades em eventos futuros';
$string['upcomingeventstintenabled_desc'] = 'Com esta configuração, você pode colorir os ícones de atividades no bloco de eventos futuros com base nos propósitos da atividade. Por padrão, o Moodle exibe-os como ícones pretos.';
$string['upgradenotice_2022080922'] = 'A partir desta versão, Boost Union tem suas próprias configurações de logotipo e logotipo compacto e não usa mais esses arquivos das configurações do núcleo do Moodle.';
$string['upgradenotice_2022080922_copied'] = 'O <strong>{$a}</strong> existente nas configurações principais do Moodle foi copiado para a configuração Boost Union {$a} durante esta atualização. Verifique novamente o resultado.';
$string['upgradenotice_2022080922_logo'] = 'logotipo';
$string['upgradenotice_2022080922_logocompact'] = 'logotipo compacto';
$string['upgradenotice_2022080922_notcopied'] = 'A configuração <strong>{$a}</strong> em Boost Union está vazia agora. Se você quiser usar um {$a} dentro do Boost Union a partir de agora, basta carregá-lo na configuração Boost Union {$a} mais tarde.';
$string['usermenuheading'] = 'Menu do usuário';
