<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'appointment', language 'pt_br', version '4.5'.
 *
 * @package     appointment
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addingappointment'] = 'Adicionar reunião';
$string['addingappointments'] = 'Adicionar reuniões';
$string['addremoveattendees'] = 'Adicionar/remover participantes';
$string['addsession'] = 'Adicionar sessão';
$string['addtimeframe'] = 'Adicionar período de tempo';
$string['advanced'] = 'Avançado';
$string['allowcancellations'] = 'Permitir cancelamento';
$string['allowcancellations_help'] = 'Se marcado, os participantes da sessão poderão cancelar suas inscrições';
$string['allowcancellationsdefault'] = 'Permitir cancelamento padrão';
$string['allowcancellationsdefault_help'] = 'Se marcado, a configuração padrão ao criar novas sessões para esta atividade será permitir o cancelamento de inscrições';
$string['allowwaitlist'] = 'Permitir lista de espera';
$string['allowwaitlist_help'] = 'Quando "Permitir lista de espera" estiver marcado, os estudantes poderão se inscrever para uma sessão de Reunião, mesmo que já esteja cheia.<br />

Quando um estudante se inscreve para uma sessão que já está cheia, ele receberá um e-mail avisando que foi colocado na lista de espera para a sessão e será notificado quando uma reserva estiver disponível.';
$string['alreadysignedup'] = 'Você já se inscreveu para esta atividade de Reunião.';
$string['appointment'] = 'Reunião';
$string['appointment:addattendees'] = 'Adicionar participantes em uma sessão de Reunião';
$string['appointment:addinstance'] = 'Adicionar instância';
$string['appointment:configurecancellation'] = 'Permitir a configuração de cancelamentos de inscrição, ao adicionar/editar uma atividade de reunião.';
$string['appointment:editsessions'] = 'Adicionar, editar, copiar e apagar sessões de Reunião';
$string['appointment:managecustomfields'] = 'Gerenciar campos personalizados para a sessão de Reunião.';
$string['appointment:overbook'] = 'Inscreva-se em sessões completas que não tenham lista de espera ativada.';
$string['appointment:removeattendees'] = 'Retirar os participantes de uma sessão de Reunião';
$string['appointment:signup'] = 'Inscreva-se para uma sessão';
$string['appointment:takeattendance'] = 'Assistir';
$string['appointment:view'] = 'Visualizar Atividades e sessões de Reunião';
$string['appointment:viewattendees'] = 'Visualizar lista de presença e participantes';
$string['appointment:viewcancellations'] = 'Visualizar cancelamentos';
$string['appointmentactivity'] = 'Atividade de Reunião';
$string['appointmentcustomfields'] = 'Campos personalizados de Reunião';
$string['appointmentname'] = 'Nome da Reunião';
$string['appointments'] = 'Reuniões';
$string['appointmentsession'] = 'Sessão de Reunião';
$string['appointmentsessiondates'] = 'Datas das sessões de Reunião';
$string['appointmentsessions'] = 'Sessões de Reunião';
$string['appointmentsettings'] = 'Configurações de Reunião';
$string['approvalreqd'] = 'Aprovação necessária';
$string['approvalreqd_help'] = 'Quando a opção "Aprovação necessária" estiver marcada, o estudante precisará da aprovação de seu gerente para poder participar de uma sessão de reunião.';
$string['approve'] = 'Aprovar';
$string['attendance'] = 'Presença';
$string['attendanceinstructions'] = 'Selecione os usuários que participaram da sessão:';
$string['attendedsession'] = 'Presente na sessão';
$string['attendees'] = 'Participantes';
$string['attendeestablesummary'] = 'Pessoas que planejam ou já participaram desta sessão.';
$string['availableplaceholders'] = 'Espaços reservados disponíveis';
$string['availableseats'] = '{$a} vagas disponíveis';
$string['book'] = 'Livro';
$string['bookedat'] = '<strong>Reservado:</strong> {$a}';
$string['bookedvscapacity'] = 'Reservado / Capacidade';
$string['bookingcancelled'] = 'Sua Reserva foi cancelada';
$string['bookingcompleted'] = 'Sua Reserva foi concluída';
$string['bookingfull'] = 'Cheio';
$string['bookingopen'] = 'Aberto';
$string['break'] = 'Pausa';
$string['break_help'] = 'Esta configuração define o tempo de intervalo entre as sessões. Definir como 0 significa que nenhuma pausa é necessária.';
$string['calendareventdescriptionbooking'] = 'Você está agendado para esta <a href="{$a}">sessão agendada</a>.';
$string['calendareventdescriptionsession'] = 'Você criou esta <a href="{$a}">Sessão de compromisso</a>.';
$string['calendaroptions'] = 'Opções do calendário';
$string['cancel'] = 'Cancelar';
$string['cancelbooking'] = 'Cancelar reseva';
$string['cancellationinstrmngr'] = '# Aviso para o gerente';
$string['cancellationinstrmngr_help'] = 'Quando **Enviar aviso ao gerente** está marcado, o texto no campo **Aviso ao gerente** é enviado ao gerente de um estudante informando que ele cancelou uma reserva de compromisso.';
$string['cancellationmessage'] = 'Mensagem de cancelamento';
$string['cancellationmessage_help'] = 'Esta mensagem é enviada sempre que os usuários cancelam sua reserva para uma sessão.';
$string['cancellations'] = 'Cancelamentos';
$string['cancellationstablesummary'] = 'Lista de pessoas que cancelaram suas inscrições na sessão.';
$string['cancelreason'] = 'Razão para cancelamento';
$string['cannotapproveatcapacity'] = 'Você não pode aprovar mais participantes, pois esta sessão está cheia.';
$string['cannotsignupsessioninprogress'] = 'Você não pode se inscrever, esta sessão está em andamento';
$string['cannotsignupsessionover'] = 'Você não pode se inscrever, esta sessão acabou.';
$string['capacity'] = 'Capacidade';
$string['capacity_help'] = '**Capacidade** é o número de vagas disponíveis em uma sessão.

Quando uma sessão de compromisso atinge a capacidade, os detalhes da sessão não aparecem na página do curso. Os detalhes aparecerão em cinza na página \'Visualizar todas as sessões\' e o estudante não poderá se inscrever na sessão.
&nbsp;';
$string['closed'] = 'Fechado';
$string['completionattended'] = 'Agende um horário e compareça';
$string['completionattended_help'] = 'Se ativado, a atividade será considerada concluída se a frequência reservada do estudante estiver marcada como "Totalmente atendida" ou "Parcialmente atendida".';
$string['completionbooked'] = 'O estudante deve agendar um horário para concluir esta atividade';
$string['completionbooked_help'] = 'Se ativado, a atividade será considerada concluída se o status do estudante for "Agendado", "Atendido totalmente" ou "Atendido parcialmente". Caso o estudante tenha cancelado, esteja em lista de espera ou sua presença esteja marcada como “Não comparecimento”, a atividade não será considerada concluída.';
$string['completiondetail:attended'] = 'Comparecer a um compromisso';
$string['completiondetail:booked'] = 'Agendar um horário';
$string['confirmationinstrmngr'] = '# Aviso para o gerente';
$string['confirmationinstrmngr_help'] = 'Quando a opção "Enviar aviso ao gerente" está marcada, o texto no campo "Aviso ao gerente" é enviado a um gerente informando que um funcionário se inscreveu para uma sessão de compromisso.';
$string['confirmationmessage'] = 'Mensagem de confirmação';
$string['confirmationmessage_help'] = 'Esta mensagem é enviada sempre que os usuários se inscrevem em uma sessão.';
$string['confirmcancelbooking'] = 'Confirmar cancelamento';
$string['courseresetsessions'] = 'Remover todas as sessões';
$string['courseresetsignups'] = 'Remover todas as inscrições de sessão';
$string['crontask'] = 'Tarefas de manutenção da reunião';
$string['currentstatus'] = 'Status atual';
$string['customisednotifications'] = 'Notificações personalizadas';
$string['date'] = 'Data';
$string['decidelater'] = 'Decidir depois';
$string['decline'] = 'Rejeitar';
$string['delete'] = 'Excluir';
$string['deleteappointmentconfirm'] = 'Tem certeza de que deseja excluir esta reunião e todas as suas reservas?';
$string['deletesession'] = 'Excluir sessão';
$string['deletetimeframe'] = 'Excluir calendário';
$string['details'] = 'Detalhes';
$string['duplicate'] = 'Duplicar';
$string['duplicateappointment'] = 'Duplicar reunião';
$string['editingappointment'] = 'Editando reunião';
$string['email:message'] = 'Mensagem';
$string['email:subject'] = 'Assunto';
$string['emailmanager'] = 'Enviar notificação ao gerente';
$string['emailmanagercancellation'] = '# Enviar notificação ao gerente';
$string['emailmanagercancellation_help'] = 'Quando a opção "Enviar notificação ao gerente" estiver marcada, um e-mail será enviado ao gerente do estudante informando que a reserva da reunião foi cancelada.';
$string['emailmanagerconfirmation'] = '# Enviar notificação para o gerente';
$string['emailmanagerconfirmation_help'] = 'Quando "Enviar notificação ao gerente" estiver marcado, um e-mail de confirmação será enviado ao gerente do estudante quando o estudante se inscrever para uma sessão da reunião.';
$string['emailmanagerreminder'] = '# Enviar notificação ao gerente';
$string['emailmanagerreminder_help'] = 'Quando "Enviar notificação ao gerente" estiver marcado, uma mensagem de lembrete será enviada ao gerente do estudante alguns dias antes da data de início da sessão da reunião.';
$string['empty'] = 'Vazio';
$string['endtime'] = 'Encerramento';
$string['entitiysession'] = 'Sessão';
$string['error:cancellationsnotallowed'] = 'Você não tem permissão para cancelar esta inscrição.';
$string['error:canttakeattendanceforunstartedsession'] = 'Não é possível atender a uma sessão que ainda não começou.';
$string['error:eventoccurred'] = 'Você não pode cancelar um evento que já ocorreu.';
$string['error:invaliduserid'] = 'ID de usuário inválido';
$string['error:manageremailaddressmissing'] = 'Atualmente você não está atribuído como um gerente no sistema. Entre em contato com o administrador do site.';
$string['error:sessionsplitexceeds'] = 'O tempo parcial da sessão excede a duração da sessão.';
$string['error:sessionstartafterend'] = 'O horário de início da sessão é posterior ao horário de término da sessão.';
$string['errorcannoteditsessions'] = 'Você não tem permissão para editar sessões';
$string['errorcannotviewappointment'] = 'Você não tem permissão para visualizar este compromisso';
$string['errorcannotviewattendees'] = 'Você não tem permissão para ver os participantes';
$string['eventaddsession'] = 'Sessão adicionada';
$string['eventapproverequests'] = 'Solicitações de aprovação de sessão';
$string['eventattendancetaken'] = 'Participação na sessão realizada';
$string['eventattendeesviewed'] = 'Participantes da sessão visualizados';
$string['eventcancelbooking'] = 'Sessão reserva cancelada';
$string['eventcourseappointmentviewed'] = 'Instâncias de agendamento de curso visualizadas';
$string['eventcoursemoduleviewed'] = 'Instância do módulo de agendamento visualizada';
$string['eventdeletesession'] = 'Sessão excluída';
$string['eventsignup'] = 'Inscrição na sessão';
$string['eventupdatesession'] = 'Sessão atualizada';
$string['full'] = 'A data está ocupada';
$string['fullfilter'] = 'Completa';
$string['fullybooked'] = 'Totalmente reservado';
$string['goback'] = 'Voltar';
$string['icalendarheading'] = 'Anexos iCalendar';
$string['joinwaitlist'] = 'Entrar na lista de espera';
$string['location'] = 'Localização';
$string['managecustomfields'] = 'Gerenciar campos personalizados';
$string['modulename'] = 'Marcação de compromissos';
$string['modulename_help'] = 'O agendamento é um módulo de atividades para os professores acompanharem as atividades presenciais.

Ele permite que o professor configure um sistema de reserva para uma ou mais sessões presenciais ou em sala de aula, para os estudantes se inscreverem.

Este módulo de atividades é adequado para sessões individuais ou atividades multisessões, como seminários.

As sessões podem ter diversas datas e horários em uma única atividade de Compromisso e podem ser criadas em massa usando os intervalos de tempo especificados na configuração.

A atividade permite o acompanhamento de frequência.';
$string['modulename_link'] = 'Compromissos';
$string['modulenameplural'] = 'Compromissos';
$string['multipleappointments'] = 'Múltiplos compromissos';
$string['noactionableunapprovedrequests'] = 'Nenhuma solicitação não aprovada sem ação';
$string['noremindersneedtobesent'] = 'Nenhum lembrete precisa ser enviado.';
$string['nosignedupusers'] = 'Nenhum usuário se inscreveu nesta sessão.';
$string['notset'] = 'Não definido';
$string['notsignedup'] = 'Você não está inscrito nesta sessão.';
$string['partiallyfull'] = 'Parcialmente cheio';
$string['placeholder:alldates'] = '';
$string['placeholdersdesc'] = 'Espaços reservados';
$string['placeholdersdesc_help'] = 'Os espaços reservados permitem adicionar um conteúdo dinâmico, por exemplo. O espaço reservado [firstname] será substituído pelo nome do usuário na notificação entregue ao usuário.';
$string['pluginadministration'] = 'Administração de Reuniões';
$string['pluginname'] = 'Compromisso';
$string['potentialattendees'] = 'Potenciais participantes';
$string['privacy:metadata:appointment_signups'] = 'Inscrições de usuários em sessões de reuniões';
$string['privacy:metadata:appointment_signups:id'] = 'O id da inscrição';
$string['privacy:metadata:appointment_signups:mailedreminder'] = 'A hora em que um lembrete foi enviado pela última vez';
$string['privacy:metadata:appointment_signups:sessionid'] = 'O ID da sessão';
$string['privacy:metadata:appointment_signups_status'] = 'O status da inscrição de um usuário em uma sessão';
$string['privacy:metadata:appointment_signups_status:grade'] = 'A nota atribuída pela participação na sessão';
$string['privacy:metadata:appointment_signups_status:note'] = 'Armazena o motivo de uma sessão cancelada';
$string['privacy:metadata:appointment_signups_status:signupid'] = 'O id da inscrição';
$string['privacy:metadata:appointment_signups_status:statuscode'] = 'O status da inscrição, por exemplo, cancelada,recusada,totalmente atendida';
$string['privacy:metadata:appointment_signups_status:timecreated'] = 'A hora em que a inscrição foi criada.';
$string['privacy:metadata:userid'] = 'O ID do usuário que acessou a atividade Reunião';
$string['remindermessage'] = 'Mensagem de lembrete';
$string['remindermessage_help'] = 'Esta mensagem é enviada alguns dias antes da data de início de uma sessão.';
$string['reminderperiod'] = 'Dias antes da mensagem ser enviada';
$string['reminderperiod_help'] = 'A mensagem de lembrete será enviada alguns dias antes do início da sessão.';
$string['requestmessage'] = 'Mensagem de solicitação';
$string['requestmessage_help'] = 'Quando **Aprovação necessária** está ativada, a seção **Mensagem de solicitação** fica disponível.

A seção **Mensagem de solicitação** exibe os avisos enviados ao estudante e seu gerente em relação ao processo de aprovação para o estudante participar da sessão de agendamento.

**Assunto:** é a linha de assunto que aparece nos e-mails de aprovação de solicitação enviados ao gerente e ao estudante.

**Mensagem:** é o texto do e-mail enviado ao estudante informando que sua solicitação para participar da sessão de agendamento foi enviada ao gerente para aprovação.

**Aviso ao gerente:** é o texto do e-mail enviado ao gerente do estudante solicitando aprovação para participar da sessão de agendamento.';
$string['requeststablesummary'] = 'Pessoas que solicitaram participar desta sessão.';
$string['room'] = 'Sala';
$string['saveattendance'] = 'Salvar presença';
$string['search:activity'] = 'Atividades de marcação de compromisso';
$string['seatsavailable'] = 'Lugares disponíveis';
$string['seatsbooked'] = 'Lugares reservados';
$string['sessionavailability'] = 'Sessões disponíveis';
$string['sessiondatetime'] = 'Data/hora da sessão';
$string['sessiondescription'] = 'Descrição';
$string['sessionduration'] = 'Duração da sessão';
$string['sessionfinished'] = 'Finalizada';
$string['sessionfinishtime'] = 'Hora de término da reunião';
$string['sessioninprogress'] = 'reunião em andamento';
$string['sessionisfull'] = 'Esta reunião agora está cheia. Você precisará escolher outro horário ou conversar com o instrutor.';
$string['sessionnotstarted'] = 'Não iniciado';
$string['sessionrequiresmanagerapproval'] = 'Esta reunião requer aprovação do gerente para ser reservada.';
$string['sessions'] = 'Reuniões';
$string['sessionsdetailstablesummary'] = 'Descrição completa da reunião atual.';
$string['sessionstartdate'] = 'Data de início da reunião';
$string['sessionstarttime'] = 'Hora de início da sessão';
$string['sessionstatus'] = 'Status da sessão';
$string['setting:defaultcancellationmessagedefault'] = 'Segue a notificação de que sua reserva para o seguinte reunião foi cancelada:<br><br>
***RESERVA CANCELADA***<br><br>
Participante: [firstname] [lastname]<br>
Compromisso: [appointmentname]<br><br>
Data(s):<br>
[alldates]<br><br>
Local: [session]<br>
Localização: [session]<br>
Sala: [session]';
$string['setting:defaultcancellationsubjectdefault'] = 'Cancelamento de agendamento de compromisso';
$string['setting:defaultconfirmationmessagedefault'] = 'Segue a confirmação de que você está agendado para o seguinte reunião:<br><br>
Participante: [firstname] [lastname]<br>
Compromisso: [appointmentname]<br><br>
Data(s):<br> [alldates]<br><br> Local: [session]<br>
Localização: [session]<br>
Sala: [session]<br><br>
***Por favor, chegue dez minutos antes do início do compromisso***<br><br>
Para reagendar ou cancelar sua reserva<br>
Para reagendar sua reserva, você precisará cancelar esta reserva e, em seguida, reservar uma nova sessão.<br>
Para cancelar sua reserva, retorne à página do compromisso e selecione \'Cancelar\'.<br><br>
[details]<br><br>
Você receberá um lembrete [reminderperiod] dias úteis antes deste compromisso.<br><br>';
$string['setting:defaultconfirmationsubjectdefault'] = 'Confirmação de agendamento de conpromisso: [appointmentname], [starttime]-[finishtime], [sessiondate]';
$string['setting:defaultremindermessagedefault'] = 'Este é um lembrete de que você está agendado para o seguinte compromisso:<br><br>
Participante: [firstname] [lastname]<br>
Compromisso:  [appointmentname]<br><br>
Data(s):<br>
[alldates]<br><br>
Local:  [session:location]<br>
Ponto de encontro:  [session:venue]<br>
Sala:  [session:room]<br><br>
***Chegue dez minutos antes do início do conpromisso***<br><br>
Para remarcar ou cancelar sua reserva<br>
Para reagendar sua reserva, você precisa cancelar esta reserva e remarcar uma nova sessão.<br>
Para cancelar sua reserva, retorne à página de agendamento e selecione \'Cancelar\'.<br><br>
[details]';
$string['status'] = 'Status';
$string['status_approved'] = 'Aprovado';
$string['status_booked'] = 'Reservado';
$string['status_declined'] = 'Recusado';
$string['status_fully_attended'] = 'Totalmente atendido';
$string['status_waitlisted'] = 'Lista de espera';
$string['suppressemail_help'] = 'Use esta opção se desejar adicionar/remover usuários silenciosamente de uma sessão de compromisso. Quando esta opção é alternada, o e-mail normal a confirmação não é enviada aos usuários selecionados.';
$string['timestart'] = 'Horário de início';
$string['unknowndate'] = '(data desconhecida)';
$string['unknowntime'] = '(hora desconhecida)';
$string['updatemessage'] = 'Mensagem de atualização';
$string['venue'] = 'Ponto de encontro';
