<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'grades', language 'mn', version '4.4'.
 *
 * @package     grades
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activities'] = 'Үйл ажиллагаа';
$string['addcategory'] = 'Ангилал нэмэх';
$string['addcategoryerror'] = 'Ангилал нэмэх боломжгүй.';
$string['addexceptionerror'] = 'userid:gradeitem тухайд тайлбар нэмэх үед гарсан алдаа';
$string['addfeedback'] = 'Санал хүсэлт нэмэх';
$string['addgradeletter'] = 'Үсгэн үнэлгээ нэмэх';
$string['addidnumbers'] = 'ID дугаар нэмэх';
$string['additem'] = 'Дүгнэх зүйл нэмэх';
$string['additionalfeedback'] = 'Нэмэлт санал хүсэлт';
$string['addoutcome'] = 'Үр дүн нэмэх';
$string['addoutcomeitem'] = 'Үр дүнгийн зүйл нэмэх';
$string['addscale'] = 'Хэмжээс нэмэх';
$string['adjustedweight'] = 'Жинг тохируулсан';
$string['aggregateextracreditmean'] = 'Үнэлгээний дундаж (нэмэлт кредиттэй)';
$string['aggregatemax'] = 'Хамгийн дээд үнэлгээ';
$string['aggregatemean'] = 'Үнэлгээний дундаж';
$string['aggregatemedian'] = 'Дундаж үнэлгээ';
$string['aggregatemin'] = 'Хамгийн доод үнэлгээ';
$string['aggregatemode'] = 'Үнэлгээний горим';
$string['aggregatenotonlygraded'] = 'Хоосон дүнг оруулах';
$string['aggregateonlygraded'] = 'Хоосон дүнг оруулахгүй';
$string['aggregateonlygraded_help'] = 'Хоосон дүн гэдэг нь журналд байхгүй дүн юм. Энэ нь үнэлээгүй байгаа даалгавар, эсвэл өгөөгүй шалгалт зэрэг байж болно.

Энэ тохиргоо нь хоосон дүнг нэгтгэлд оруулаагүй эсвэл хамгийн бага үнэлгээнд тооцогдох эсэхийг тодорхойлно. Жишээ нь 0-ээс 100 хүртэлх үнэлгээтэй даалгаврын хувьд 0 байна.';
$string['aggregateoutcomes'] = 'Үр дүнг нэгтгэлд оруулах';
$string['aggregateoutcomes_help'] = 'Идэвхжүүлсэн тохиолдолд үр дүнг нэгтгэлд оруулна. Энэ нь таамаглаагүй нийт ангилалд хүргэж болзошгүй.';
$string['aggregatesonly'] = 'Зөвхөн нийт дүнг харуулах';
$string['aggregatesubcatsupgradedgrades'] = 'Тайлбар: "Дэд ангиллыг оруулан нэгтгэх" тохиргоог сайтын шинэчлэлийн хүрээнд хассан. "Дэд ангиллыг оруулан нэгтгэх" тохигоог өмнө нь энэ хичээлд ашиглаж байсан тул журналд энэ өөрчлөлтийг нягтлахыг зөвлөж байна.';
$string['aggregatesum'] = 'Хэвийн';
$string['aggregateweightedmean'] = 'Жинлэсэн үнэлгээний дундаж';
$string['aggregateweightedmean2'] = 'Энгийн жинлэсэн үнэлгээний дундаж';
$string['aggregation'] = 'Нэгтгэл';
$string['aggregation_help'] = 'Нэгтгэл нь тухайн ангиллын үнэлгээг хэрхэн нэгтгэхийг тодорхойлдог, тухайлбал

* Үнэлгээний дундаж - Нийт үнэлгээг бүх үнэлгээний тоонд хуваасан утга
* Дундаж үнэлгээ - Үнэлгээг хэмжээгээр нь эрэмбэлсэн дундаж үнэлгээ
* Хамгийн доод үнэлгээ
* Хамгийн дээд үнэлгээ
* Үнэлгээний горим - Хамгийн олон удаа гардаг үнэлгээ
* Хэвийн - Жингээр хуваасан бүх үнэлгээний утгуудын нийлбэр';
$string['aggregation_link'] = 'grade/aggregation';
$string['aggregationcoef'] = 'Нэгтгэх коэффициент';
$string['aggregationcoefextra'] = 'Нэмэлт кредит';
$string['aggregationcoefextra_help'] = 'Нэгтгэл нь "Хэвийн" эсвэл "Энгийн жинлэсэн дундаж" бөгөөд нэмэлт кредитийн нүдийг сонгосон тохиолдолд тухайн үнэлгээний хамгийн дээд үнэлгээг ангиллын дээд үнэлгээнд нэмэхгүй. Энэ нь бүх ангиллын хамгийн дээд үнэлгээгүйгээр тухайн ангилалд хамгийн өндөр үнэлгээ авах боломжийг бий болгоно. Сайтын админ дээд хэмжээнээс дээших үнэлгээг идэвхжүүлсэн тохиолдолд дээд хэмжээнээс давсан үнэлгээ байж болно.
Нэгтгэл нь "Үнэлгээний дундаж (нэмэлт кредиттэй)" бөгөөд нэмэлт кредитийг тэгээс их утгаар тохируулсан тохиолдолд нэмэлт кредит нь үнэлгээг тооцоолсны дараа үнэлгээг нийт үнэлгээ дээр нэмэхээс өмнө үржүүлэх хүчин зүйл болно гэсэн үг.';
$string['aggregationcoefextra_link'] = 'grade/aggregation';
$string['aggregationcoefextrasum'] = 'Нэмэлт кредит';
$string['aggregationcoefextrasum_help'] = 'Нэмэлт кредитийн нүдийг сонгосон тохиолдолд тухайн ангиллын хамгийн дээд үнэлгээг нэмэхгүй, энэ нь тухайн ангилалд хамгийн дээд үнэлгээгүйгээр (эсвэл сайтын администратор идэвхжүүлсэн бол дээд хэмжээнээс дээших үнэлгээ) тухайн ангилалд хамгийн их үнэлгээ авах боломжтой болно.';
$string['aggregationcoefextrasum_link'] = 'grade/aggregation';
$string['aggregationcoefextrasumabbr'] = '+';
$string['aggregationcoefextraweight'] = 'Нэмэлт кредитийн жин';
$string['aggregationcoefextraweight_help'] = 'Нэмэлт кредит жинг тэгээс их утгаар тохируулсан тохиолдолд үнэлгээг нэгтгэх явцад нэмэлт кредит үүрэг гүйцэтгэдэг. Тоо гэдэг нь дундаж утгыг тооцоолоход нийт үнэлгээг нэмэхээс өмнө дүнг үржүүлсэн хүчин зүйл юм.';
$string['aggregationcoefextraweight_link'] = 'grade/aggregation';
$string['aggregationcoefweight'] = 'Зүйлийн жин';
$string['aggregationcoefweight_help'] = 'Зүйлийн жинг тухайн ангилалд буй бусад зүйлстэй харьцуулахад тухайн зүйлийн ач холбогдлыг харуулахын тулд ангиллыг нэгтгэхэд ашигладаг.';
$string['aggregationcoefweight_link'] = 'grade/aggregation';
$string['aggregationhintdropped'] = '( Унасан )';
$string['aggregationhintexcluded'] = '( Хассан )';
$string['aggregationhintextra'] = '( Нэмэлт кредит )';
$string['aggregationhintnovalue'] = '( Хоосон )';
$string['aggregationofa'] = '{$a}-н нэгтгэл';
$string['aggregationposition'] = 'Нэгтгэх байрлал';
$string['aggregationposition_help'] = 'Энэ тохиргоо нь ангилал болон хичээлийн нийт багана нь журналын тайланд эхэнд эсвэл сүүлд харагдах эсэхийг тодорхойлно.';
$string['aggregationsvisible'] = 'Боломжит нэгтгэх төрлүүд';
$string['aggregationsvisiblehelp'] = 'Боломжит бүх нэгтгэх төрлийг сонгоно уу. Хэд хэдэн зүйлийг сонгохын тулд Ctrl товчийг дарна уу.';
$string['allgrades'] = 'Ангиллаарх бүх үнэлгээ';
$string['allstudents'] = 'Бүх суралцагч';
$string['allusers'] = 'Бүх хэрэглэгч';
$string['aria-toggledropdown'] = 'Дараах нээгдэх цэсийг сонгоно уу';
$string['autosort'] = 'Автоматаар эрэмбэлэх';
$string['availableidnumbers'] = 'Боломжит ID дугаарууд';
$string['average'] = 'Дундаж';
$string['averagesdecimalpoints'] = 'Багана дахь дундаж аравтын тоо';
$string['averagesdecimalpoints_help'] = 'Энэ тохиргоо нь дундаж тус бүрийн аравтын бутархайн тоог харуулах эсвэл ангилал, үнэлгээний зүйлд аравтын бутархайн тохиргоог ашигласан эсэхийг (удамших) тодорхойлно.';
$string['averagesdisplaytype'] = 'Баганын дунджийг харуулах төрөл';
$string['averagesdisplaytype_help'] = 'Энэ тохиргоо нь дундаж нь бодит үнэлгээ, хувь эсвэл үсгэн үнэлгээгээр харуулах, эсвэл ашиглаж (удамших) буй ангилал эсвэл үнэлгээний зүйлийг харуулах төрлийг тодорхойлдог.';
$string['backupwithoutgradebook'] = 'Нөөцлөлтөд журналын тохиргоо байхгүй';
$string['badgrade'] = 'Оруулсан үнэлгээ хүчингүй';
$string['badlyformattedscale'] = 'Таслалаар тусгаарласан утгуудын жагсаалтыг оруулна уу (хамгийн багадаа хоёр утга шаардлагатай).';
$string['baduser'] = 'Оруулсан хэрэглэгч хүчингүй байна';
$string['bonuspoints'] = 'Урамшууллын оноо';
$string['bulkcheckboxes'] = 'Олон тооны сонгох талбар';
$string['calculatedgrade'] = 'Тооцоолсон үнэлгээ';
$string['calculation'] = 'Тооцоолол';
$string['calculation_help'] = 'Үнэлгээний тооцоолол гэдэг нь үнэлгээг тодорхойлох томьёо юм. Томьёо нь тэнцүү (=) тэмдгээр эхлэх ёстой бөгөөд max, min, sum зэрэг нийтлэг математик операторыг ашиглаж болно. Шаардлагатай бол ID дугаарыг давхар дөрвөлжин хаалтад бичиж бусад үнэлгээний зүйлийг тооцоололд оруулж болно.';
$string['calculation_link'] = 'grade/calculation';
$string['calculationadd'] = 'Тооцоолол нэмэх';
$string['calculationedit'] = 'Тооцооллыг засварлах';
$string['calculationsaved'] = 'Тооцооллыг хадгалах';
$string['calculationview'] = 'Тооцооллыг харах';
$string['cannotaccessgroup'] = 'Сонгосон бүлгийн үнэлгээнд хандах боломжгүй, уучлаарай.';
$string['categories'] = 'Ангиллууд';
$string['category'] = 'Ангилал';
$string['categoryedit'] = 'Ангиллыг засварлах';
$string['categoryname'] = 'Ангиллын нэр';
$string['categorytotal'] = 'Нийт ангилал';
$string['categorytotalfull'] = 'Нийт {$a->category}';
$string['categorytotalname'] = 'Нийт ангиллын нэр';
$string['changedefaults'] = 'Өгөгдмөл тохиргоог өөрчлөх';
$string['changereportdefaults'] = 'Тайлангийн өгөгдмөл тохиргоог өөрчлөх';
$string['chooseaction'] = 'Үйлдэл сонгох ...';
$string['choosecategory'] = 'Ангилал сонгох';
$string['collapsecriterion'] = 'Шалгуурыг бууруулах';
$string['compact'] = 'Шахах';
$string['componentcontrolsvisibility'] = 'Үнэлгээний зүйлийг нуух эсэхийг үйл ажиллагааны тохиргоогоор удирдана.';
$string['contract'] = 'Гэрээний ангилал';
$string['contributiontocoursetotal'] = 'Нийт хичээлд оруулсан хувь нэмэр';
$string['controls'] = 'Хяналтууд';
$string['courseavg'] = 'Хичээлийн дундаж';
$string['coursegradecategory'] = 'Хичээлийн үнэлгээний ангилал';
$string['coursegradedisplaytype'] = 'Хичээлийн үнэлгээг харуулах төрөл';
$string['coursegradedisplayupdated'] = 'Хичээлийн үнэлгээг харуулах төрлийг шинэчилсэн.';
$string['coursegradesettings'] = 'Хичээлийн үнэлгээний тохиргоо';
$string['coursename'] = 'Хичээлийн нэр';
$string['coursescales'] = 'Хичээлийн хэмжээсүүд';
$string['coursesettings'] = 'Хичээлийн тохиргоо';
$string['coursesettingsexplanation'] = 'Хичээлийн үнэлгээний тохиргоо нь тухайн хичээлд хамрагдсан бүх оролцогчид журнал хэрхэн харагдахыг тодорхойлдог.';
$string['coursesiamtaking'] = 'Миний судалж буй хичээлүүд';
$string['coursesiamteaching'] = 'Миний зааж буй хичээлүүд';
$string['coursetotal'] = 'Нийт хичээл';
$string['createcategory'] = 'Ангилал үүсгэх';
$string['createcategoryerror'] = 'Шинэ ангилал үүсгэж чадсангүй';
$string['creatinggradebooksettings'] = 'Журналын тохиргоог үүсгэх';
$string['csv'] = 'CSV';
$string['currentparentaggregation'] = 'Одоогийн үндсэн нэгтгэл';
$string['curveto'] = 'Муруйлгах';
$string['decimalpoints'] = 'Нийт аравтын орон';
$string['decimalpoints_help'] = 'Энэ тохиргоо нь үнэлгээ тус бүрээр харуулах аравтын бутархайн тоог тодорхойлдог. Энэ нь 5 аравтын орны нарийвчлалтайгаар хийсэн үнэлгээний тооцоололд ямар ч нөлөө үзүүлэхгүй.';
$string['default'] = 'Өгөгдмөл';
$string['defaultprev'] = 'Өгөгдмөл ({$a})';
$string['deletecategory'] = 'Ангиллыг устгах';
$string['deletescale'] = 'Хэмжээсийг устгах';
$string['disablegradehistory'] = 'Үнэлгээний түүхийг идэвхгүй болгох';
$string['disablegradehistory_help'] = 'Үнэлгээтэй холбоотой хүснэгтийн өөрчлөлтийн түүхийг хянахыг идэвхгүй болгоно. Энэ нь серверийн хурдыг бага зэрэг нэмэгдүүлж, өгөгдлийн сангийн зайг хэмнэх болно.';
$string['displaylettergrade'] = 'Үсгэн үнэлгээг харуулах';
$string['displaypercent'] = 'Хувийг харуулах';
$string['displaypoints'] = 'Оноог харуулах';
$string['displayweighted'] = 'Жинлэсэн үнэлгээг харуулах';
$string['droplow'] = 'Хамгийн доод талыг нь хаях';
$string['droplow_help'] = 'Энэ тохиргоо нь хамгийн доод үнэлгээний тодорхойлсон тоог нэгтгэхээс хасах боломжийг олгодог.';
$string['droplowestvalue'] = 'Хаях хамгийн доод үнэлгээний утгыг тохируулах';
$string['droplowestvalues'] = 'Хамгийн бага {$a} утгыг хаях';
$string['dropped'] = 'Хаясан';
$string['dropxlowest'] = 'X хамгийн багыг хаях арга';
$string['dropxlowestwarning'] = 'Тэмдэглэгээ: Нэг ангилал доторх бүх зүйл нь ижил оноотой бол Х хамгийн багыг хаях аргыг ашиглана. Хэрвээ оноо нь ялгаатай бол үр дүнг урьдчилаж хэлэх боломжгүй.';
$string['duplicatedgradeitem'] = '{$a} (хуулах)';
$string['duplicatescale'] = 'Хэмжээсийг хувилах';
$string['edit'] = 'Засварлах';
$string['editcalculation'] = 'Тооцооллыг засварлах';
$string['editcalculationverbose'] = '{$a->category} {$a->itemmodule} {$a->itemname} тооцооллыг засварлах';
$string['editfeedback'] = 'Санал хүсэлтийг засварлах';
$string['editgrade'] = 'Үнэлгээг засварлах';
$string['editgradeletters'] = 'Үсгэн үнэлгээг засварлах';
$string['editoutcome'] = 'Үр дүнг засварлах';
$string['editoutcomes'] = 'Үр дүнг засварлах';
$string['editscale'] = 'Хэмжээсийг засварлах';
$string['edittree'] = 'Тохируулах';
$string['editverbose'] = '{$a->category} {$a->itemmodule} {$a->itemname} засварлах';
$string['enableajax'] = 'AJAX идэвхжүүлэх';
$string['enableajax_help'] = 'Үнэлгээний задаргааны тайланд AJAX функцийн давхаргыг нэмж, нийтлэг үйлдлийг хялбарчилж, хурдасгадаг. Хэрэглэгчийн хөтчийн түвшинд жаваскриптыг идэвхжүүлсэн эсэхээс хамаарна.';
$string['enableoutcomes'] = 'Үр дүнг идэвхжүүлэх';
$string['enableoutcomes_help'] = 'Идэвхжүүлсэн тохиолдолд үр дүнгийн мэдэгдэлд холбосон нэг буюу хэд хэдэн хэмжээсийг ашиглан үнэлгээний зүйлийг үнэлж болно.';
$string['encoding'] = 'Кодлох';
$string['encoding_help'] = 'Өгөгдөлд ашигласан тэмдэгтийн кодчиллыг сонгоно. (Стандарт кодчилол нь UTF-8.) Буруу кодчиллыг алдаж сонгосон тохиолдолд энэ нь импортын өгөгдлийг урьдчилан харах үед мэдэгдэх болно.';
$string['errorcalculationbroken'] = '{$a} үнэлгээний зүйлийг тооцоолоход алдаа гарлаа.';
$string['errorcalculationnoequal'] = 'Томьёо нь тэнцүү (=1+2) тэмдгээр эхлэх ёстой';
$string['errorcalculationunknown'] = 'Хүчингүй томьёо';
$string['errorgradevaluenonnumeric'] = 'Бага эсвэл өндөр үнэлгээний хувьд тоон бус үнэлгээг хүлээн авсан';
$string['errornocalculationallowed'] = 'Энэ зүйлийн хувьд тооцоолол хийхийг зөвшөөрөхгүй';
$string['errornocategorisedid'] = 'Ангилалгүй id дугаарыг авч чадсангүй!';
$string['errornocourse'] = 'Хичээлийн мэдээллийг авч чадсангүй';
$string['errorreprintheadersnonnumeric'] = 'Дахин хэвлэх толгой хэсгийн тоон бус утгыг хүлээж авсан';
$string['errorsavegrade'] = 'Үнэлгээг хадгалж чадсангүй, уучлаарай.';
$string['errorsettinggrade'] = '{$a->userid} хэрэглэгчийн "{$a->itemname}" үнэлгээг хадгалахад алдаа гарлаа';
$string['errorupdatinggradecategoryaggregateonlygraded'] = 'Үнэлгээний ID {$a->id} ангиллын "Зөвхөн хоосон бус үнэлгээг нэгтгэх" тохиргоог шинэчлэхэд алдаа гарлаа';
$string['errorupdatinggradecategoryaggregateoutcomes'] = 'Үнэлгээний ID {$a->id} ангиллын "Үр дүнг нэгтгэлд оруулах" тохиргоог шинэчлэхэд алдаа гарлаа';
$string['errorupdatinggradecategoryaggregation'] = 'Үнэлгээний ID {$a->id}  ангиллын нэгтгэлийн төрлийг шинэчлэхэд алдаа гарлаа';
$string['errorupdatinggradeitemaggregationcoef'] = 'Үнэлгээний ID {$a->id} зүйлийн дугаарын нэгтгэх коэффициентийг (жин эсвэл нэмэлт кредит) шинэчлэхэд алдаа гарлаа';
$string['eventgradedeleted'] = 'Үнэлгээг устгасан';
$string['eventgradeitemcreated'] = 'Үнэлгээний зүйлийг үүсгэсэн';
$string['eventgradeitemdeleted'] = 'Үнэлгээний зүйлийг устгасан';
$string['eventgradeitemupdated'] = 'Үнэлгээний зүйлийг шинэчилсэн';
$string['eventgradelettercreated'] = 'Үсгэн үнэлгээг үүсгэсэн';
$string['eventgradeletterdeleted'] = 'Үсгэн үнэлгээг устгасан';
$string['eventgradeletterupdated'] = 'Үсгэн үнэлгээг шинэчилсэн';
$string['eventgradeviewed'] = 'Журналд үнэлгээг харуулдаг байсан';
$string['eventscalecreated'] = 'Хэмжээсийг үүсгэсэн';
$string['eventscaledeleted'] = 'Хэмжээсийг устгасан';
$string['eventscaleupdated'] = 'Хэмжээсийг шинэчилсэн';
$string['eventusergraded'] = 'Хэрэглэгчийн үнэлгээ';
$string['excluded'] = 'Хасагдсан';
$string['excluded_help'] = 'Сонгосон тохиолдолд үнэлгээг ямар ч нэгтгэлд оруулахгүй.';
$string['expand'] = 'Ангиллыг өргөтгөх';
$string['expandcriterion'] = 'Шалгуурыг өргөтгөх';
$string['export'] = 'Экспорт';
$string['exportalloutcomes'] = 'Бүх үр дүнг экспортлох';
$string['exportas'] = 'байдлаар экспортлох';
$string['exportfeedback'] = 'Экспортод санал хүсэлтийг оруулах';
$string['exportfeedback_desc'] = 'Экспортын явцад үүнийг хүчингүй болгож болно.';
$string['exportformatoptions'] = 'Экспортын форматын сонголтууд';
$string['exportonlyactive'] = 'Түдгэлзүүлсэн хэрэглэгчийг оруулахгүй';
$string['exportonlyactive_help'] = 'Зөвхөн бүртгэл нь идэвхтэй, түдгэлзүүлээгүй суралцагчийг экспортод оруулна';
$string['exportplugins'] = 'Экспортын нэмэлт хэрэгсэл';
$string['exportsettings'] = 'Экспортын тохиргоо';
$string['exportto'] = 'Экспортлох';
$string['externalurl'] = 'Гадаад URL хаяг';
$string['externalurl_desc'] = 'Гадаад журналыг ашиглаж байгаа тохиролдолд энд URL хаягийг зааж өгөх шаардлагатай.';
$string['extracreditvalue'] = 'Нэмэлт кредитийн утга {$a}';
$string['extracreditwarning'] = 'Тайлбар: Ангиллын бүх зүйлийг нэмэлт кредит болгон тохируулснаар тэдгээрийг үнэлгээний тооцооллоос хасах болно. Нийт оноо байхгүй болно';
$string['fail'] = 'Амжилтгүй';
$string['feedback'] = 'Санал хүсэлт';
$string['feedback_help'] = 'Энэ талбар нь үнэлгээний талаарх санал хүсэлтийг нэмэх боломжийг олгоно.';
$string['feedbackadd'] = 'Санал хүсэлт нэмэх';
$string['feedbackedit'] = 'Санал хүсэлтийг засварлах';
$string['feedbackfiles'] = 'Санал хүсэлтийн файлууд';
$string['feedbackforgradeitems'] = '{$a}-н санал хүсэлт';
$string['feedbackhistoryfiles'] = 'Санал хүсэлтийн түүхийн файлууд';
$string['feedbackprovided'] = 'Санал хүсэлтийг өгсөн';
$string['feedbacks'] = 'Санал хүсэлтүүд';
$string['feedbacksaved'] = 'Санал хүсэлтийг хадгалсан';
$string['feedbackview'] = 'Санал хүсэлтийг харсан';
$string['filterbothactive'] = 'Эхний ({$a->first}) Сүүлийн ({$a->last})';
$string['filterbyname'] = 'Нэрээр шүүх';
$string['filterfirstactive'] = 'Эхний ({$a->first})';
$string['filterlastactive'] = 'Сүүлийн ({$a->last})';
$string['finalgrade'] = 'Эцсийн үнэлгээ';
$string['finalgrade_help'] = 'Хүчингүй болгох талбарыг сонгосон тохиолдолд үнэлгээ нэмэх эсвэл өөрчлөх боломжтой.';
$string['fixedstudents'] = 'Суралцагчийн статик багана';
$string['fixedstudents_help'] = 'Үнэлгээг хөдөлгөөнгүй болгох замаар суралцагчийн баганыг хэвтээ чиглэлд гүйлгэх боломжийг олгоно.';
$string['forceimport'] = 'Хүчээр импортлох';
$string['forceimport_help'] = 'Импортын файлыг экспортолсны дараа үнэлгээ шинэчлэгдсэн байсан ч үнэлгээг хүчээр импортлох';
$string['forceoff'] = 'Хүчлэх: Унтраах';
$string['forceon'] = 'Хүчлэх: Асаах';
$string['forelementtypes'] = 'сонгосон {$a} хувьд';
$string['forstudents'] = 'Суралцагчдад';
$string['full'] = 'Бүрэн';
$string['fullmode'] = 'Үнэлгээ болон нийт дүнг харуулах';
$string['generalsettings'] = 'Ерөнхий тохиргоо';
$string['grade'] = 'Үнэлгээ';
$string['grade_help'] = 'Суралцагчийн ажлыг урамшуулах үнэлгээ.';
$string['gradeadministration'] = 'Үнэлгээний удирдлага';
$string['gradealreadyupdated'] = 'Импортын файл дахь дүн нь үнэлгээний задаргааны тайлангаас хуучин байгаа тул {$a} дүнг импортлоогүй. Ямар ч тохиолдолд үнэлгээний импортыг үргэлжлүүлэх бол хүчээр импортлох сонголтыг ашиглана уу.';
$string['gradeanalysis'] = 'Үнэлгээний шинжилгээ';
$string['gradebook'] = 'Журнал';
$string['gradebookcalculationsfixbutton'] = 'Үнэлгээний өөрчлөлтийг хүлээн зөвшөөрч, тооцооллын алдааг засах';
$string['gradebookcalculationsuptodate'] = 'Журнал дээрх тооцооллыг шинэчилсэн. Та өөрчлөлтийг харахын тулд энэ хуудсыг дахин ачаалах шаардлагатай байж магадгүй.';
$string['gradebookcalculationswarning'] = 'Жич: Журналд харуулж буй үнэлгээг тооцоолоход зарим алдаа илэрсэн. Таны хичээл эхлээгүй эсвэл үргэлжилж байгаа бол доорх товчийг дарж алдаагаа засахыг зөвлөж байна. Гэхдээ энэ нь зарим үнэлгээг өөрчлөх болно. Таны хичээл дуусаж, үнэлгээгээ илгээсэн бол энэ асуудлыг засах шаардлагагүй байж болох юм.

Шинэ хувилбар нь {$a->currentversion}; Та журналын {$a->gradebookversion} хувилбарыг ашиглаж байна. Та өөрчлөлтийн жагсаалтыг <a href="{$a->url}">Журналын тооцооллын өөрчлөлт</a> хэсгээс харж болно.';
$string['gradebookhiddenerror'] = 'Журналыг суралцагчдад бүх зүйлийг харуулахгүй байхаар тохируулсан байна.';
$string['gradebookhistories'] = 'Үнэлгээний түүх';
$string['gradebooknavigationmenu'] = 'Журналын удирдлагын цэс';
$string['gradebooksetup'] = 'Журналын тохиргоо';
$string['gradeboundary'] = 'Үсгэн үнэлгээний хязгаар';
$string['gradeboundary_help'] = 'Энэ тохиргоо нь үсгэн үнэлгээнд оноох хамгийн бага хувийг тодорхойлдог.';
$string['gradecategories'] = 'Үнэлгээний ангиллууд';
$string['gradecategory'] = 'Үнэлгээний ангилал';
$string['gradecategoryonmodform'] = 'Үнэлгээний ангилал';
$string['gradecategoryonmodform_help'] = 'Энэ тохиргоо нь журналд буй энэ үйл ажиллагааны үнэлгээг байршуулах ангиллыг хянадаг.';
$string['gradecategorysettings'] = 'Үнэлгээний ангиллын тохиргоо';
$string['gradedisplay'] = 'Үнэлгээг харуулах';
$string['gradedisplaytype'] = 'Үнэлгээг харуулах төрөл';
$string['gradedisplaytype_help'] = 'Энэ тохиргоо нь үнэлгээний задаргааны болон хэрэглэгчийн тайланд үнэлгээг хэрхэн харуулахыг тодорхойлдог.

* Үсэг - Журналын тохиргооны "Үсгүүд" хэсэгт тодорхойлсноор  үнэлгээний хязгаарыг илэрхийлэхийн тулд үсэг эсвэл үгийг ашиглана.
* Хувь - Дээд ба доод үнэлгээтэй харьцуулсан хувь
* Бодит - Бодит үнэлгээ эсвэл хэмжээсийн утга';
$string['gradedon'] = 'Үнэлэгдсэн: {$a}';
$string['gradeexport'] = 'Үнэлгээний экспорт';
$string['gradeexportcolumntype'] = '{$a->name} ({$a->extra})';
$string['gradeexportcustomprofilefields'] = 'Тусгай профайлын талбарын үнэлгээний экспорт';
$string['gradeexportcustomprofilefields_desc'] = 'Эдгээр тусгай профайлын талбарыг таслалаар тусгаарлан үнэлгээний экспортод оруулна уу.';
$string['gradeexportdecimalpoints'] = 'Үнэлгээний экспортын аравтын бутархай';
$string['gradeexportdecimalpoints_desc'] = 'Экспортод харуулах аравтын орны тоо. Экспортын үед үүнийг хүчингүй болгож болно.';
$string['gradeexportdisplaytype'] = 'Үнэлгээний экспортыг харуулах төрөл';
$string['gradeexportdisplaytype_desc'] = 'Экспортын үед үнэлгээг бодит дүн, хувиар (хамгийн бага ба дээд үнэлгээнд харгалзуулан) эсвэл үсгээр (A, B, C гэх мэт) харуулж болно. Үүнийг экспортлох үед хүчингүй болгож болно.';
$string['gradeexportdisplaytypes'] = 'Үнэлгээний экспортыг харуулах төрлүүд';
$string['gradeexportuserprofilefields'] = 'Хэрэглэгчийн профайлын талбарын үнэлгээний экспорт';
$string['gradeexportuserprofilefields_desc'] = 'Эдгээр хэрэглэгчийн профайлын талбарыг таслалаар тусгаарлан үнэлгээний экспортод оруулна уу.';
$string['gradeforstudent'] = '{$a->student}<br />{$a->item}{$a->feedback}';
$string['gradegrademinmax'] = 'Анхны хамгийн бага ба дээд үнэлгээ';
$string['gradehelp'] = 'Үнэлгээний тусламж';
$string['gradehistorylifetime'] = 'Үнэлгээний түүхийн хугацаа';
$string['gradehistorylifetime_help'] = 'Энэ нь үнэлгээтэй холбоотой хүснэгтэд гарсан өөрчлөлтийн түүхийг хадгалах хугацааг заадаг. Үүнийг аль болох удаан хадгалахыг зөвлөж байна. Гүйцэтгэлийн асуудалтай эсвэл өгөгдлийн сангийн зай хязгаарлагдмал бол бага утгаар тохируулаарай.';
$string['gradeimport'] = 'Үнэлгээний импорт';
$string['gradeimportfailed'] = 'Даалгаврын явцад үнэлгээний импорт амжилтгүй болсон. Дэлгэрэнгүй:';
$string['gradeitem'] = 'Зүйлийг үнэлэх';
$string['gradeitemaddusers'] = 'Үнэлгээнээс хасах';
$string['gradeitemadvanced'] = 'Нарийвчилсан үнэлгээний зүйлийн сонголтууд';
$string['gradeitemadvanced_help'] = 'Үнэлгээний зүйлийг засварлахдаа нарийвчилсан байдлаар харуулах бүх элементийг сонгоно уу.';
$string['gradeitemislocked'] = 'Энэ үйл ажиллагааг журналд түгжсэн. Энэ үйл ажиллагааны үнэлгээнд хийсэн өөрчлөлтийг нээх хүртэл журналд хуулахгүй.';
$string['gradeitemlocked'] = 'Үнэлгээг түгжсэн';
$string['gradeitemmembersselected'] = 'Үнэлгээнээс хассан';
$string['gradeitemminmax'] = 'Үнэлгээний зүйлийн тохиргоонд заасан хамгийн бага ба хамгийн их үнэлгээ';
$string['gradeitemnonmembers'] = 'Үнэлгээнд багтсан';
$string['gradeitemremovemembers'] = 'Үнэлгээнд багтаах';
$string['gradeitems'] = 'Зүйлийг үнэлэх';
$string['gradeitemsettings'] = 'Үнэлгээний зүйлийн тохиргоо';
$string['gradeitemsinc'] = 'Багтаах үнэлгээний зүйл';
$string['gradeletter'] = 'Үсгэн үнэлгээ';
$string['gradeletter_help'] = 'Үсгэн үнэлгээ нь A, B, C, ... үсгүүд эсвэл үнэлгээний хязгаарыг илэрхийлэхэд хэрэглэдэг Шилдэг, Сайн, Тэнцсэн ... зэрэг үг болно.';
$string['gradeletternote'] = 'Үсгэн үнэлгээг устгахын тулд тухайн үсгийн<br /> гурван бичвэр хэсгийн аль нэгийг нь хоосон болгоод илгээх дээр дарна.';
$string['gradeletteroverridden'] = 'Өгөгдмөл үсгэн үнэлгээ нь одоогоор хүчингүй байна.';
$string['gradeletters'] = 'Үсгэн үнэлгээ';
$string['gradelocked'] = 'Үнэлгээг түгжсэн';
$string['gradelong'] = '{$a->grade} / {$a->max}';
$string['grademax'] = 'Хамгийн дээд үнэлгээ';
$string['grademax_help'] = 'Энэ тохиргоо нь үнэлгээний утгын төрлийг ашиглах үеийн хамгийн дээд үнэлгээг тодорхойлдог. Үйл ажиллагаанд суурилсан үнэлгээний зүйлийн дээд үнэлгээг үйл ажиллагааны тохиргооны хуудсанд тохируулна.';
$string['grademin'] = 'Хамгийн доод үнэлгээ';
$string['grademin_help'] = 'Энэ тохиргоо нь үнэлгээний утгын төрлийг ашиглах үеийн хамгийн доод үнэлгээг тодорхойлдог.';
$string['gradenotificationmessage'] = 'Танд "{$a}" ажлын талаарх шинэ санал хүсэлт байна';
$string['gradenotificationsubject'] = 'Таныг үнэлсэн байна';
$string['gradeoutcomeitem'] = 'Үнэлгээний үр дүнгийн зүйл';
$string['gradeoutcomes'] = 'Үр дүн';
$string['gradeoutcomescourses'] = 'Хичээлийн үр дүн';
$string['gradepass'] = 'Тэнцэх үнэлгээ';
$string['gradepass_help'] = 'Энэ тохиргоо нь тэнцэхэд шаардагдах хамгийн бага үнэлгээг тодорхойлдог. Энэ утгыг үйл ажиллагаа, хичээлийн гүйцэтгэлд ашиглах ба тэнцсэн үнэлгээг ногоон өнгөөр, амжилтгүй үнэлгээг улаан өнгөөр тодруулсан журналд ашигладаг.';
$string['gradepassgreaterthangrade'] = 'Тэнцэх үнэлгээ нь боломжит дээд {$a} утгаас их байж болохгүй.';
$string['gradepointdefault'] = 'Үнэлгээний онооны өгөгдмөл утга';
$string['gradepointdefault_help'] = 'Энэ тохиргоо нь үнэлгээний зүйлд байгаа үнэлгээний онооны өгөгдмөл утгыг тодорхойлдог.';
$string['gradepointdefault_validateerror'] = 'Энэ тохиргоо нь 1 ба дээд онооны хооронд бүхэл тоо байх ёстой.';
$string['gradepointmax'] = 'Хамгийн дээд оноо';
$string['gradepointmax_help'] = 'Энэ тохиргоо нь үйл ажиллагаанд байх хамгийн дээд онооны утгыг тодорхойлдог.';
$string['gradepointmax_validateerror'] = 'Энэ тохиргоо нь 1-ээс 10000 хооронд бүхэл тоо байх ёстой.';
$string['gradepreferences'] = 'Үнэлгээний сонголт';
$string['gradepreferenceshelp'] = 'Үнэлгээний сонголтын тусламж';
$string['gradepublishing'] = 'Нийтлэхийг идэвхжүүлэх';
$string['gradepublishing_help'] = 'Үнэлгээг нийтлэх гэдэг нь Moodle системд нэвтрэхгүйгээр URL хаягаар дамжуулан үнэлгээг импортлох, экспортлох арга юм. Идэвхжүүлсэн тохиолдолд үнэлгээг нийтлэх зөвшөөрөлтэй администратор, хэрэглэгч (өгөгдмөл тохиргоогоор зөвхөн менежерийн үүрэг бүхий хэрэглэгч) хичээлийн журнал тус бүрд үнэлгээг экспортлох нийтлэх тохиргоог хийнэ.';
$string['gradepublishinglink'] = 'Татан авах: {$a}';
$string['gradereport'] = 'Үнэлгээний тайлан';
$string['graderreport'] = 'Үнэлгээний задаргааны тайлан';
$string['grades'] = 'Үнэлгээ';
$string['gradesforuser'] = '{$a->user} хэрэглэгчийн үнэлгээ';
$string['gradesmoduledeletionpendingwarning'] = 'Анхааруулга: Үйл ажиллагааг устгаж байна! Зарим үнэлгээг хасах гэж байна.';
$string['gradesmoduledeletionprefix'] = '[Устгаж байна]';
$string['gradesonly'] = 'Зөвхөн үнэлгээг харуулах';
$string['gradessettings'] = 'Үнэлгээний тохиргоо';
$string['gradetype'] = 'Үнэлгээний төрөл';
$string['gradetype_help'] = 'Үнэлгээний 4 төрал байдаг. Үүнд:

* Байхгүй - Дүгнэх боломжгүй
* Утга - Хамгийн их ба хамгийн бага утгатай тоон утга
* Хэмжээс - Жагсаалтын зүйл
* Бичвэр - Зөвхөн санал хүсэлт

Зөвхөн утга болон үнэлгээний хэмжээсийн төрлийг нэгтгэж болно. Үйл ажиллагаанд суурилсан үнэлгээний зүйлийн үнэлгээний төрлийг үйл ажиллагааны тохиргооны хуудсанд тохируулна.';
$string['gradevaluetoobig'] = 'Үнэлгээний утгын нэг нь зөвшөөрөгдөх дээд {$a} утгаас их байна';
$string['gradeview'] = 'Үнэлгээг харах';
$string['gradewasmodifiedduringediting'] = '{$a->username}-н {$an->item name}-д оруулсан үнэлгээг хэн нэгэн нь саяхан шинэчилсэн тул хэрэгсэхгүй болгосон.';
$string['gradeweighthelp'] = 'Үнэлгээний жингийн тусламж';
$string['gradingmodulename'] = 'Үнэлгээ ({$a})';
$string['groupavg'] = 'Бүлгийн дундаж';
$string['hidden'] = 'Нууцсан';
$string['hidden_help'] = 'Сонгосон тохиолдолд үнэлгээг суралцагчаас нууна. Үнэлгээ дууссаны дараа үнэлгээг харуулахдаа шаардлагатай огноог хүртэл нууцлахаар тохируулж болно.';
$string['hiddenasdate'] = 'Нуусан үнэлгээг илгээсэн огноог харуулах';
$string['hiddenasdate_help'] = 'Хэрэглэгч нуусан үнэлгээг харах боломжгүй бол \'-\'-ын оронд илгээсэн огноог харуулна.';
$string['hiddenuntil'] = 'Хүртэл нуусан';
$string['hiddenuntildate'] = '{$a} хүртэл нуусан';
$string['hideadvanced'] = 'Нарийвчилсан функцийг нуух';
$string['hideaverages'] = 'Дунджийг нуух';
$string['hidecalculations'] = 'Тооцооллыг нуух';
$string['hidecategory'] = 'Нуусан';
$string['hideeyecons'] = 'Харуулах/нуух дүрсийг нуух';
$string['hidefeedback'] = 'Санал хүсэлтийг нуух';
$string['hideforcedsettings'] = 'Албадан тохиргоог нуух';
$string['hideforcedsettings_help'] = 'UI үнэлгээнд албадан тохиргоог харуулахгүй.';
$string['hidegroups'] = 'Бүлгийг нуух';
$string['hidelocks'] = 'Түгжээг нуух';
$string['hidenooutcomes'] = 'Үр дүнг харуулах';
$string['hidequickfeedback'] = 'Шуурхай санал хүсэлтийг нуух';
$string['hideranges'] = 'Хязгаарыг нуух';
$string['hidetotalifhiddenitems'] = 'Нуусан зүйл байгаа бол нийт дүнг нуух';
$string['hidetotalifhiddenitems_help'] = 'Энэ тохиргоо нь нуусан үнэлгээний зүйлийг агуулсан нийт дүнг суралцагчид харуулах эсвэл (-) зураасаар солих эсэхийг заана. Харуулах тохиолдолд нийт дүнг нуусан зүйлсийг оруулах эсвэл оруулахгүйгээр тооцоолж болно.

Нуусан зүйлийг хассан тохиолдолд багш үргэлж нуусан болон нуугаагүй бүх зүйлээс тооцоолсон нийлбэр дүнг хардаг тул нийт дүн нь багшийн үнэлгээний тайланд харсан үнэлгээнээс өөр байх болно. Нуусан зүйлийг оруулсан бол суралцагч нуусан зүйлийг тооцоолох боломжтой.';
$string['hidetotalshowexhiddenitems'] = 'Нуусан зүйлийг оруулахгүйгээр нийт дүнг харуулах';
$string['hidetotalshowinchiddenitems'] = 'Нуусан зүйлийг оруулж нийт дүнг харуулах';
$string['hideverbose'] = '{$a->category} {$a->itemmodule} {$a->itemname} нуух';
$string['highgradeascending'] = 'Өндөр үнэлгээг өсөх дарааллаар эрэмбэлэх';
$string['highgradedescending'] = 'Өндөр үнэлгээг буурах дарааллаар эрэмбэлэх';
$string['highgradeletter'] = 'Өндөр';
$string['identifier'] = 'Хэрэглэгчийг тодорхойлох';
$string['idnumbers'] = 'ID дугаар';
$string['ignore'] = 'Татгалзах';
$string['import'] = 'Импортлох';
$string['importas'] = 'байдлаар импортлох';
$string['importcsv'] = 'CSV импортлох';
$string['importcsv_help'] = 'Үнэлгээг CSV файлаар дараах форматаар импортлох боломжтой. Үүнд:

* Файлын мөр бүр нэг бичлэг агуулна
* Бичлэг бүр нь сонгосон тусгаарлагчаар тусгаарлагдсан өгөгдлийн цуврал болно
* Эхний бичлэг нь бусад файлын форматыг тодорхойлсон талбарын нэрсийн жагсаалтыг агуулна
* Хэрэглэгчийг таних өгөгдлийг агуулсан талбарын нэр шаардлагатай - хэрэглэгчийн нэр эсвэл ID дугаар эсвэл цахим шуудангийн хаяг

Эхлээд зарим үнэлгээг экспортлох замаар зөв форматтай файлыг авч болно. Ингэснээр файлыг засварлаж, CSV файл болгон хадгалах боломжтой.';
$string['importcsv_link'] = 'grade/import/csv/index';
$string['importcustom'] = 'Тусгай үр дүн болгон импортлох (зөвхөн энэ хичээл)';
$string['importdata'] = 'Өгөгдөл';
$string['importdata_help'] = 'Үнэлгээг OpenDocument эсвэл Excel хүснэгтээс дараах форматаар шууд буулгаж болно. Үүнд:

* Хамгийн багадаа нэг баганад хэрэглэгчийн нэр, цахим шуудангийн хаяг эсвэл ID дугаар гэсэн хэрэглэгчийн хувийн мэдээллийг агуулсан байх ёстой.
* Бусад багана нь одоо байгаа үйл ажиллагаа эсвэл үнэлгээний зүйлийн гарчигтай байх ёстой.

Зөв форматтай хүснэгтийг эхлээд зарим үнэлгээг экспортлох замаар олж авч болно. Дараа нь хүснэгтийг засварлаж, илүү олон үнэлгээг нэмж, хадгалж болно.

Хүснэгтээс импортлохыг хүссэн баганаа сонгоод хуулж аваад энэ талбарт буулгана.';
$string['importerror'] = 'Алдаа гарлаа, энэ скриптийг зөв параметрээр дуудаагүй.';
$string['importfailed'] = 'Импортолж чадсангүй. Ямар ч өгөгдлийг импортлоогүй.';
$string['importfeedback'] = 'Санал хүсэлтийг импортлох';
$string['importfile'] = 'Файлыг импортлох';
$string['importfilemissing'] = 'Ямар ч файл хүлээж аваагүй тул маягтад буцаж очоод хүчинтэй файлыг байршуулна уу.';
$string['importfrom'] = 'Импортлох';
$string['importoutcomenofile'] = 'Байршуулсан файл хоосон эсвэл эвдрэлтэй байна. Энэ файлыг хүчинтэй эсэхийг шалгана уу. {$a} мөрөнд асуудал илэрсэн, энэ нь өгөгдлийн мөрүүд нь эхний мөр (толгой мөр) шиг олон баганагүй эсвэл импортолсон файлд хүлээгдэж буй толгой дутуу байгаа тохиолдолд үүсдэг. Хүчинтэй толгой бүхий файлын жишээг экспортолсон файлаас харна уу.';
$string['importoutcomes'] = 'Үр дүнг импортлох';
$string['importoutcomes_help'] = 'Үр дүнг экспортын үр дүнгийн csv файл формат бүхий csv файлаар импортлох боломжтой.';
$string['importoutcomes_link'] = 'grade/outcome';
$string['importoutcomesuccess'] = '#{$a->id} ID дугаар бүхий "{$a->name}" импортолсон үр дүн';
$string['importplugins'] = 'Импортлох нэмэлт хэрэгсэл';
$string['importpreview'] = 'Импортыг урьдчилан харах';
$string['importsettings'] = 'Импортын тохиргоо';
$string['importskippednomanagescale'] = 'Танд шинэ хэмжээс нэмэх зөвшөөрөл байхгүй тул "{$a}" үр дүн нь шинэ хэмжээс үүсгэх шаардлагатай тул алгассан болно.';
$string['importskippedoutcome'] = 'Энэ хүрээнд "{$a}" товч нэртэй үр дүн байгаа бөгөөд импортолсон файл дахь үр дүнг алгассан байна.';
$string['importstandard'] = 'Стандарт үр дүн болгон импортлох';
$string['importsuccess'] = 'Импортын амжилтыг үнэлэх';
$string['importxml'] = 'XML импортлох';
$string['includescalesinaggregation'] = 'Хэмжээсийг нэгтгэлд оруулах';
$string['includescalesinaggregation_help'] = 'Та хэмжээсийг бүх хичээлийн бүх журналд нэгтгэсэн үнэлгээний тоо болгон оруулах эсэхийг өөрчилж болно. АНХААРУУЛГА: Энэ тохиргоог өөрчилснөөр бүх нэгтгэсэн үнэлгээг дахин тооцоолох шаардлагатай болно.';
$string['incorrectcourseid'] = 'Хичээлийн ID буруу байна';
$string['incorrectcustomscale'] = '(Тусгай хэмжээс буруу байна, өөрчилнө үү.)';
$string['incorrectminmax'] = 'Хамгийн бага нь хамгийн их хэмжээнээс бага байх ёстой';
$string['inherit'] = 'Удамших';
$string['intersectioninfo'] = 'Суралцагч/Үнэлгээний мэдээлэл';
$string['invalidgradeexporteddate'] = 'Экспортын огноо нь жилээс өмнө эсвэл ирээдүйд эсвэл формат буруу байгаа тул хүчингүй болно.';
$string['item'] = 'Зүйл';
$string['iteminfo'] = 'Зүйлийн мэдээлэл';
$string['iteminfo_help'] = 'Энэ тохиргоо нь тухайн зүйлийн талаарх мэдээллийг оруулах зайг өгдөг. Мэдээллийг өөр хаана ч харуулахгүй.';
$string['itemname'] = 'Зүйлийн нэр';
$string['itemnamehelp'] = 'Модульд оруулсан энэ зүйлийн нэр.';
$string['items'] = 'Зүйлc';
$string['itemsedit'] = 'Үнэлгээний зүйлийг засах';
$string['keephigh'] = 'Хамгийн дээд утгыг хадгалах';
$string['keephigh_help'] = 'Тохируулсан тохиолдолд энэ сонголт нь зөвхөн X хамгийн өндөр үнэлгээг хадгалах ба X нь энэ сонголтын сонгосон утга болно.';
$string['keephighestvalues'] = '{$a} хамгийн дээд утгыг хадгалах';
$string['keymanager'] = 'Гол зохицуулагч';
$string['lessthanmin'] = '{$a->username} хэрэглэгчийн {$an->item name} зүйлд оруулсан үнэлгээ нь зөвшөөрөгдсөн доод хэмжээнээс бага байна';
$string['letter'] = 'Үсэг';
$string['lettergrade'] = 'Үсгэн үнэлгээ';
$string['lettergradenonnumber'] = 'Бага ба/эсвэл өндөр үнэлгээ нь тоон бус байсан';
$string['letterpercentage'] = 'Үсэг (хувь)';
$string['letterreal'] = 'Үсэг (бодит)';
$string['letters'] = 'Үсгүүд';
$string['linkedactivity'] = 'Холбоотой үйл ажиллагаа';
$string['linkedactivity_help'] = 'Энэ тохиргоо нь энэ үнэлгээний зүйлтэй холбоотой үйл ажиллагааг тодорхойлдог. Үүнийг үйл ажиллагааны үнэлгээгээр үнэлдэггүй шалгуураар суралцагчийн гүйцэтгэлийг хэмжихэд ашиглаж болно.';
$string['linktoactivity'] = '{$a->name} үйл ажиллагаа {$a->title} руу холбох';
$string['lock'] = 'Түгжих';
$string['locked'] = 'Түгжсэн';
$string['locked_help'] = 'Сонгосон тохиолдолд үнэлгээг холбогдох үйл ажиллагаанаас автоматаар шинэчлэх боломжгүй.';
$string['locktime'] = 'Дараа нь түгжих';
$string['locktimedate'] = 'Дараа нь түгжсэн: {$a}';
$string['lockverbose'] = '{$a->category} {$a->itemmodule} {$a->itemname} түгжих';
$string['lowest'] = 'Хамгийн бага';
$string['lowgradeletter'] = 'Бага';
$string['manageoutcomes'] = 'Үр дүнг удирдах';
$string['manualitem'] = 'Хөтөлбөрийн зүйл';
$string['mapfrom'] = 'Буулгах';
$string['mapfrom_help'] = 'Хүснэгтээс хэрэглэгчийн нэр, хэрэглэгчийн ID эсвэл цахим шуудангийн хаяг гэх мэт хэрэглэгчийг тодорхойлох өгөгдлийг агуулсан баганыг сонгоно.';
$string['mappings'] = 'Үнэлгээний зүйлийг буулгах';
$string['mappings_help'] = 'Хүснэгтийн үнэлгээний багана бүрийн хувьд үнэлгээг импортлохын тулд харгалзах үнэлгээний зүйлийг сонгоно.';
$string['mapto'] = 'Буулгах';
$string['mapto_help'] = '\'Буулгах\' хэсэгт сонгосон ижил таних өгөгдлийг сонгоно.';
$string['max'] = 'Хамгийн өндөр';
$string['maxgrade'] = 'Хамгийн өндөр үнэлгээ';
$string['meanall'] = 'Бүх үнэлгээ';
$string['meangraded'] = 'Хоосон бус үнэлгээ';
$string['meanselection'] = 'Баганын дунджаар сонгосон үнэлгээ';
$string['meanselection_help'] = 'Энэ тохиргоо нь ангилал эсвэл үнэлгээний зүйл бүрийн дунджийг тооцоолохдоо үнэлгээгүй нүдийг оруулах эсэхийг тодорхойлно.';
$string['median'] = 'Дундаж';
$string['min'] = 'Хамгийн бага';
$string['minimum_show'] = 'Хамгийн бага үнэлгээг харуулах';
$string['minimum_show_help'] = 'Үнэлгээ, жингийн тооцоололд хамгийн бага үнэлгээг ашигладаг. Хэрэв харагдахгүй бол хамгийн бага үнэлгээ нь өгөгдмөл тохиргоогоор тэг байх ба засварлах боломжгүй байна.';
$string['minmaxtouse'] = 'Тооцоололд ашигласан хамгийн бага ба хамгийн дээд үнэлгээ';
$string['minmaxtouse_desc'] = 'Энэ тохиргоо нь журналд харуулсан үнэлгээг тооцоолохдоо тухайн үнэлгээ өгсөн үеийн хамгийн доод ба хамгийн дээд үнэлгээг ашиглах, эсвэл тухайн зүйлийн тохиргоонд заасан хамгийн доод ба хамгийн дээд үнэлгээг ашиглах эсэхийг тодорхойлно. Энэ тохиргоог ачаалал ихтэй үед өөрчлөхийг зөвлөж байна. Учир нь бүх үнэлгээг дахин тооцоолох ба энэ нь серверийн ачааллыг нэмэгдүүлж болзошгүй.';
$string['minmaxtouse_help'] = 'Энэ тохиргоо нь журналд харуулсан үнэлгээг тооцоолохдоо тухайн үнэлгээ өгсөн үеийн хамгийн доод ба хамгийн дээд үнэлгээг ашиглах, эсвэл тухайн зүйлийн тохиргоонд заасан хамгийн доод ба хамгийн дээд үнэлгээг ашиглах эсэхийг тодорхойлно.';
$string['minmaxtouse_link'] = 'Grades_min_max';
$string['minmaxupgradedgrades'] = 'Тайлбар: Харуулсан үнэлгээг тооцоолоход ашигласан хамгийн доод ба дээд үнэлгээний өөрчлөлтөөс үүдэн журналд гарсан зөрүүг арилгахын тулд зарим үнэлгээг өөрчилсөн болно. Өөрчлөлтийг хянаж, хүлээн зөвшөөрөхийг зөвлөж байна.';
$string['minmaxupgradefixbutton'] = 'Зөрчлийг шийдвэрлэх';
$string['minmaxupgradewarning'] = 'Тайлбар: Журналд харуулсан үнэлгээг тооцоолоход ашигласан хамгийн доод ба дээд үнэлгээг өөрчилсний улмаас зарим үнэлгээнд зөрчил илэрсэн. Доорх товчлуур дээр дарж зөрчлийг арилгана уу. Гэхдээ энэ нь зарим үнэлгээг өөрчилж болзошгүй.';
$string['missingitemtypeoreid'] = 'grade_edit_tree_column_select::get_item_cell($item, $params) дахь 2 дахь параметрт массивын түлхүүр (itemtype эсвэл eid) байхгүй байна';
$string['missingscale'] = 'Хэмжээсийг сонгох ёстой';
$string['mode'] = 'Горим';
$string['modgrade'] = 'Үнэлгээ';
$string['modgrade_help'] = 'Энэ үйл ажиллагаанд ашигласан үнэлгээний төрлийг сонгоно уу. Хэрэв  \'хэмжээс\' сонгогдсон бол нээгдэх цэсээс хэмжээсийг сонгох боломжтой. Онооны үнэлгээг ашиглах тохиолдолд уг үйл ажиллагаанд боломжит хамгийн дээд үнэлгээг оруулж болно.';
$string['modgradecantchangegradetype'] = 'Энэ зүйлийн үнэлгээ байгаа тул та төрлийг өөрчлөх боломжгүй.';
$string['modgradecantchangegradetypemsg'] = 'Зарим үнэлгээг өгсөн байгаа тул үнэлгээний төрлийг өөрчлөх боломжгүй. Хамгийн дээд үнэлгээг өөрчлөхийг хүсвэл эхлээд одоогийн үнэлгээний хэмжээсийг өөрчлөх эсэхийг сонгох шаардлагатай.';
$string['modgradecantchangegradetyporscalemsg'] = 'Зарим үнэлгээг өгсөн байгаа тул үнэлгээний төрөл, хэмжээсийг өөрчлөх боломжгүй.';
$string['modgradecantchangeratingmaxgrade'] = 'Үнэлгээ бүхий үйл ажиллагааны үнэлгээг өгсөн үед хамгийн дээд үнэлгээг өөрчлөх боломжгүй.';
$string['modgradecantchangescale'] = 'Энэ зүйлийн үнэлгээг өгсөн байгаа тул хэмжээсийг өөрчлөх боломжгүй.';
$string['modgradecategorycantchangegradetypemsg'] = 'Энэ ангилалд хүчингүй болсон үнэлгээний зүйл байна. Иймд зарим үнэлгээг өгсөн байгаа тул үнэлгээний төрлийг өөрчлөх боломжгүй. Хамгийн дээд үнэлгээг өөрчлөхийг хүсвэл эхлээд одоогийн үнэлгээний хэмжээсийг өөрчлөх эсэхийг сонгох шаардлагатай.';
$string['modgradecategorycantchangegradetyporscalemsg'] = 'Энэ ангилалд хүчингүй болсон үнэлгээний зүйл байна. Иймд зарим үнэлгээг хэдийнэ өгсөн байгаа тул үнэлгээний төрөл, хэмжээсийг өөрчлөх боломжгүй.';
$string['modgradecategoryrescalegrades'] = 'Хүчингүй болсон үнэлгээний хэмжээсийг өөрчлөх';
$string['modgradecategoryrescalegrades_help'] = 'Журнал дээрх хамгийн дээд үнэлгээг өөрчлөхдөө энэ нь одоогийн үнэлгээний хувийг өөрчлөх эсэхийг тодорхойлох шаардлагатай.

Үүнийг \'Тийм\' гэж тохируулсан тохиолдолд одоогийн дурын хүчингүй болгосон үнэлгээний хэмжээсийг өөрчлөх ба ингэснээр үнэлгээний хувь хэвээр үлдэнэ.

Жишээлбэл, энэ сонголтыг \'Тийм\' гэж тохируулбал тухайн зүйлийн хамгийн дээд үнэлгээг 10-аас 20 болгон өөрчилснөөр 6/10 (60%) үнэлгээг 12/20 (60%) болгон өөрчилнө. Энэ сонголтыг \'Үгүй\' гэж тохируулбал үнэлгээ өөрчлөгдөхгүй хэвээр байх ба зөв оноо авахын тулд үнэлгээний зүйлийг гараар тохируулах шаардлагатай болно.';
$string['modgradedonotmodify'] = 'Одоо байгаа үнэлгээг өөрчилж болохгүй';
$string['modgradeerrorbadpoint'] = 'Үнэлгээний хүчингүй утга. Энэ нь 1 ба {$a} хооронд бүхэл тоо байх ёстой';
$string['modgradeerrorbadscale'] = 'Хүчингүй хэмжээсийг сонгосон. Доорх сонголтоос хэмжээсийг  сонгоно.';
$string['modgrademaxgrade'] = 'Хамгийн дээд үнэлгээ';
$string['modgraderescalegrades'] = 'Одоогийн үнэлгээний хэмжээсийг өөрчлөх';
$string['modgraderescalegrades_help'] = 'Журнал дээрх хамгийн дээд үнэлгээг өөрчлөхдөө энэ нь одоогийн үнэлгээний хувийг өөрчлөх эсэхийг тодорхойлох шаардлагатай.

Үүнийг \'Тийм\'  гэж тохируулсан тохиолдолд одоогийн бүх үнэлгээг өөрчлөх ба ингэснээр үнэлгээний хувь хэвээр үлдэнэ.

Жишээлбэл, энэ сонголтыг \'Тийм\' гэж тохируулбал тухайн зүйлийн хамгийн дээд үнэлгээг 10-аас 20 болгон өөрчилснөөр 6/10 (60%) үнэлгээг 12/20 (60%) болгон өөрчилнө. Энэ сонголтыг \'Үгүй\' гэж тохируулбал үнэлгээ 6/10 (60%)-аас 6/20 (30%) болж өөрчлөгдөх ба зөв оноо авахын тулд үнэлгээний зүйлийг гараар тохируулах шаардлагатай болно.';
$string['modgradetype'] = 'Төрөл';
$string['modgradetypenone'] = 'Байхгүй';
$string['modgradetypepoint'] = 'Оноо';
$string['modgradetypescale'] = 'Хэмжээс';
$string['morethanmax'] = '{$a->username} хэрэглэгчийн {$an->item name} зүйлд оруулсан үнэлгээ нь зөвшөөрөгдсөн дээд хэмжээнээс их байна';
$string['moveselectedto'] = 'Сонгосон зүйлийг зөөх';
$string['movingelement'] = '{$a}-г зөөж байна';
$string['multfactor'] = 'Үржүүлэгч';
$string['multfactor_help'] = 'Үржүүлэгч нь энэ үнэлгээний бүх дүнг хамгийн дээд үнэлгээний утгаар үржүүлэх хүчин зүйл юм. Жишээлбэл, үржүүлэгч нь 2, хамгийн дээд үнэлгээ нь 100 байвал 50-иас дооших оноог 2-оор үржүүлж, 50 ба түүнээс дээших оноог 100 болгон өөрчилнө.';
$string['multfactorvalue'] = '{$a} үржүүлэгчийн утга';
$string['mustchooserescaleyesorno'] = 'Та одоогийн үнэлгээний хэмжээсийг өөрчлөх эсэхээ сонгох ёстой.';
$string['mygrades'] = 'Хэрэглэгчийн цэсийн үнэлгээний холбоос';
$string['mygrades_desc'] = 'Энэ тохиргоо нь хэрэглэгчийн цэсээс гадаад журналтай холбогдох сонголтыг зөвшөөрдөг.';
$string['mypreferences'] = 'Миний тохиргоо';
$string['myreportpreferences'] = 'Миний тайлангийн тохиргоо';
$string['myself'] = 'Би өөрөө';
$string['neverdeletehistory'] = 'Түүхийг хэзээ ч бүү устга';
$string['newcategory'] = 'Шинэ ангилал';
$string['newitem'] = 'Шинэ үнэлгээний зүйл';
$string['newoutcomeitem'] = 'Шинэ үр дүнгийн зүйл';
$string['no'] = 'Үгүй';
$string['nocategories'] = 'Энэ хичээлийн үнэлгээний ангиллыг нэмэх боломжгүй эсвэл олдохгүй байна.';
$string['nocategoryname'] = 'Ангиллын нэрийг өгөөгүй.';
$string['nocategoryview'] = 'Харах ангилал байхгүй';
$string['nocourses'] = 'Одоогоор хичээл байхгүй байна';
$string['noexistingoutcomes'] = 'Ашиглаж буй үр дүн байхгүй.';
$string['noexistingscales'] = 'Ашиглаж буй хэмжээс байхгүй.';
$string['noforce'] = 'Албадах шаардлагагүй';
$string['nogradeletters'] = 'Үсгэн үнэлгээг тохируулаагүй';
$string['nogradesreturned'] = 'Буцаасан үнэлгээ байхгүй';
$string['noidnumber'] = 'ID дугаар байхгүй';
$string['nolettergrade'] = 'Үсгэн үнэлгээ байхгүй';
$string['nomode'] = 'Байхгүй';
$string['nonnumericweight'] = 'Тоон бус үнэлгээг хүлээн авсан';
$string['nonunhideableverbose'] = 'Энэ үнэлгээг харуулахын тулд {$a->itemname} зүйлийг ил гаргах хэрэгтэй.';
$string['nonunlockableverbose'] = 'Энэ үнэлгээний түгжээг тайлахын тулд {$a->itemname} зүйлийн түгжээг тайлах хэрэгтэй.';
$string['nonweightedpct'] = 'жингүй %';
$string['nooutcome'] = 'Үр дүн байхгүй';
$string['nooutcomes'] = 'Үр дүнгийн зүйл нь сургалтын үр дүнтэй холбоотой байх ёстой, гэвч энэ хичээлийн үр дүн байхгүй. Та нэмэхийг хүсэж байна уу?';
$string['nopermissiontoresetweights'] = 'Жинг дахин тохируулах зөвшөөрөл байхгүй';
$string['nopublish'] = 'Нийтлэхгүй';
$string['noreports'] = 'Та энэ сайтад бүртгүүлээгүй, ямар нэгэн хичээл заагаагүй байна.';
$string['norolesdefined'] = 'Удирдлага > Үнэлгээ > Ерөнхий тохиргоо > Үнэлгээтэй үүрэг хэсэгт ямар ч үүргийг тодорхойлоогүй';
$string['noscales'] = 'Үр дүн нь хичээлийн хэмжээс эсвэл нээлттэй хэмжээстэй холбоотой байх ёстой, гэвч аль нь ч байхгүй байна. Та нэгийг нэмэхийг хүсэж байна уу?';
$string['noselectedcategories'] = 'ангиллыг сонгоогүй байна.';
$string['noselecteditems'] = 'зүйлийг сонгоогүй байна.';
$string['notenrolled'] = 'Та одоогоор ямар ч хичээлд хамрагдаагүй байна.';
$string['notteachererror'] = 'Энэ функцийг ашиглахын тулд та багш байх ёстой.';
$string['nousersloaded'] = 'Ямар ч хэрэглэгч ачаалагдаагүй';
$string['nouserstograde'] = 'Үнэлэх хэрэглэгч байхгүй';
$string['numberofgrades'] = 'Үнэлгээний тоо';
$string['onascaleof'] = '{$a->grademin}-аас {$a->grademax} хүртэлх хэмжээсээр';
$string['operations'] = 'Үйлдлүүд';
$string['options'] = 'Сонголтууд';
$string['others'] = 'Бусад';
$string['otheruser'] = 'Хэрэглэгч';
$string['outcome'] = 'Үр дүн';
$string['outcome_help'] = 'Энэ тохиргоо нь журналд энэ үнэлгээний зүйл ямар үр дүнг харуулахыг тодорхойлдог.';
$string['outcomeassigntocourse'] = 'Энэ хичээлд өөр үр дүнг оноох';
$string['outcomecategory'] = 'Ангилалд үр дүнг үүсгэх';
$string['outcomecategorynew'] = 'Шинэ ангилал';
$string['outcomeconfirmdelete'] = 'Та "{$a}" үр дүнг устгахдаа итгэлтэй байна уу?';
$string['outcomecreate'] = 'Шинэ үр дүн нэмэх';
$string['outcomedelete'] = 'Үр дүнг устгах';
$string['outcomefullname'] = 'Бүтэн нэр';
$string['outcomeitem'] = 'Үр дүнгийн зүйл';
$string['outcomeitemsedit'] = 'Үр дүнгийн зүйлийг засварлах';
$string['outcomereport'] = 'Үр дүнгийн тайлан';
$string['outcomes'] = 'Үр дүн';
$string['outcomescourse'] = 'Хичээлд ашигласан үр дүн';
$string['outcomescoursecustom'] = 'Тусгайлан ашигласан (устгахгүй)';
$string['outcomescoursenotused'] = 'Стандарт хэрэглээгүй';
$string['outcomescourseused'] = 'Стандарт ашигласан (устгахгүй)';
$string['outcomescustom'] = 'Тусгай үр дүн';
$string['outcomesdisabled'] = 'Үр дүнг идэвхжүүлээгүй байна';
$string['outcomeshortname'] = 'Товч нэр';
$string['outcomesstandard'] = 'Стандарт үр дүн';
$string['outcomesstandardavailable'] = 'Боломжит стандарт үр дүн';
$string['outcomestandard'] = 'Стандарт үр дүн';
$string['outcomestandard_help'] = 'Стандарт үр дүнг бүх хичээлийн хувьд сайтын хэмжээнд авах боломжтой.';
$string['overallaverage'] = 'Нийт дундаж';
$string['overridden'] = 'Хүчингүй';
$string['overridden_help'] = 'Сонгосон тохиолдолд холбогдох үйл ажиллагаа дотроос үнэлгээг өөрчлөх боломжгүй.

Үнэлгээний задаргааны тайланд үнэлгээг засварлах үед хүчингүй болгослн нүдийг автоматаар сонгоно. Гэвч холбогдох үйл ажиллагаагаар үнэлгээг өөрчлөхийг зөвшөөрөхийн тулд сонголтыг идэвхгүй болгоно.';
$string['overriddennotice'] = 'Таны энэ үйл ажиллагааны эцсийн үнэлгээг гараар тохируулсан.';
$string['overridecat'] = 'Үнэлгээний ангиллыг гараар хүчингүй болгохыг зөвшөөрөх';
$string['overridecat_help'] = 'Энэ тохиргоог идэвхгүй болгосноор хэрэглэгч ангиллын үнэлгээг хүчингүй болгох боломжгүй болно.';
$string['overridesitedefaultgradedisplaytype'] = 'Сайтын өгөгдмөл тохиргоог хүчингүй болгох';
$string['overridesitedefaultgradedisplaytype_help'] = 'Сонгосон тохиолдолд сайтын өгөгдмөл тохиргоог ашиглахын оронд тухайн хичээлийн үсгэн үнэлгээ, хил хязгаарыг тохируулж болно.';
$string['overrideweightofa'] = '{$a} жинг хүчингүй болгох';
$string['parentcategory'] = 'Үндсэн ангилал';
$string['pass'] = 'Тэнцэх';
$string['pctoftotalgrade'] = 'нийт үнэлгээний %';
$string['percent'] = 'Хувь';
$string['percentage'] = 'Хувь хэмжээ';
$string['percentageletter'] = 'Хувь (үсэг)';
$string['percentagereal'] = 'Хувь (бодит)';
$string['percentascending'] = 'Хувийг өсөх дарааллаар эрэмбэлэх';
$string['percentdescending'] = 'Хувийг буурах дарааллаар эрэмбэлэх';
$string['percentshort'] = '%';
$string['plusfactor'] = 'Тэнцүүлэгч';
$string['plusfactor_help'] = 'Тэнцүүлэгч гэдэг нь үржүүлэгчийг хэрэглэсний дараа тухайн үнэлгээний дүн болгонд нэмдэг тоо юм.';
$string['plusfactorvalue'] = '{$a} тэнцүүлэгч утга';
$string['points'] = 'оноо';
$string['pointsascending'] = 'Оноог өсөх дарааллаар эрэмбэлэх';
$string['pointsdescending'] = 'Оноог буурах дарааллаар эрэмбэлэх';
$string['positionfirst'] = 'Эхний';
$string['positionlast'] = 'Сүүлийн';
$string['preferences'] = 'Тохиргоо';
$string['prefgeneral'] = 'Ерөнхий';
$string['prefletters'] = 'Үсгэн үнэлгээ ба хил хязгаар';
$string['prefrows'] = 'Тусгай эгнээ';
$string['prefshow'] = 'Шилжүүлэгчийг харуулах/нуух';
$string['previewrows'] = 'Мөрийг урьдчилан харах';
$string['privacy:metadata:categorieshistory'] = 'Үнэлгээний ангиллын өмнөх хувилбарын бүртгэл';
$string['privacy:metadata:filepurpose'] = 'Хэрэглэгчийн журналд хадгалагдсан санал хүсэлтийн файлууд.';
$string['privacy:metadata:grade_import_newitem'] = 'Үнэлгээний импортын шинэ grade_item нэрийг хадгалах түр хүснэгт';
$string['privacy:metadata:grade_import_newitem:importcode'] = 'Импортын нэг багцыг тодорхойлох өвөрмөц багц код';
$string['privacy:metadata:grade_import_newitem:importer'] = 'Хэрэглэгч өгөгдлийг импортолж байна';
$string['privacy:metadata:grade_import_newitem:itemname'] = 'Шинэ үнэлгээний зүйлийн нэр';
$string['privacy:metadata:grade_import_values'] = 'Үнэлгээг импортлох түр хүснэгт';
$string['privacy:metadata:grade_import_values:feedback'] = 'Үнэлгээний санал хүсэлт';
$string['privacy:metadata:grade_import_values:finalgrade'] = 'Боловсруулаагүй үнэлгээний утга';
$string['privacy:metadata:grade_import_values:importcode'] = 'Импортын нэг багцыг тодорхойлох өвөрмөц багц код';
$string['privacy:metadata:grade_import_values:importer'] = 'Хэрэглэгч өгөгдлийг импортолж байна';
$string['privacy:metadata:grade_import_values:importonlyfeedback'] = 'Зөвхөн санал хүсэлтийг импортолсон бол тэмдэглэнэ';
$string['privacy:metadata:grade_import_values:userid'] = 'Үнэлгээг нь импортолсон хэрэглэгч';
$string['privacy:metadata:grades'] = 'Үнэлгээний бүртгэл';
$string['privacy:metadata:grades:aggregationstatus'] = 'Нэгтгэх төлөв';
$string['privacy:metadata:grades:aggregationweight'] = 'Нэгтгэлийн жин';
$string['privacy:metadata:grades:feedback'] = 'Санал хүсэлт';
$string['privacy:metadata:grades:finalgrade'] = 'Үнэлгээ';
$string['privacy:metadata:grades:information'] = 'Үнэлгээний талаарх нэмэлт мэдээлэл';
$string['privacy:metadata:grades:timemodified'] = 'Үнэлгээг хамгийн сүүлд өөрчилсөн цаг';
$string['privacy:metadata:grades:userid'] = 'Үнэлэгдсэн хэрэглэгчийн ID дугаар';
$string['privacy:metadata:grades:usermodified'] = 'Бүртгэлийг хамгийн сүүлд өөрчилсөн хэрэглэгчийн ID дугаар';
$string['privacy:metadata:gradeshistory'] = 'Өмнөх үнэлгээний бүртгэл';
$string['privacy:metadata:history:loggeduser'] = 'Хувилбар гаргах үед нэвтэрсэн хэрэглэгчийн ID дугаар';
$string['privacy:metadata:history:timemodified'] = 'Үнэлгээний хувилбарыг гаргасан цаг';
$string['privacy:metadata:itemshistory'] = 'Үнэлгээний зүйлийн өмнөх хувилбарын бүртгэл';
$string['privacy:metadata:outcomes'] = 'Үр дүнгийн бүртгэл';
$string['privacy:metadata:outcomes:timemodified'] = 'Бүртгэлийг өөрчилсөн цаг';
$string['privacy:metadata:outcomes:usermodified'] = 'Бүртгэлийг хамгийн сүүлд өөрчилсөн хэрэглэгч';
$string['privacy:metadata:outcomeshistory'] = 'Үр дүнгийн өмнөх хувилбарын бүртгэл';
$string['privacy:metadata:scale'] = 'Хэмжээсийн бүртгэл';
$string['privacy:metadata:scale:timemodified'] = 'Бүртгэлийг хамгийн сүүлд өөрчилсөн цаг';
$string['privacy:metadata:scale:userid'] = 'Бүртгэлийг хамгийн сүүлд өөрчилсөн хэрэглэгч';
$string['privacy:metadata:scalehistory'] = 'Хэмжээсийн өмнөх хувилбарын бүртгэл';
$string['privacy:path:relatedtome'] = 'Надтай холбоотой';
$string['privacy:request:historyactiondelete'] = 'Устгах';
$string['privacy:request:historyactioninsert'] = 'Оруулах';
$string['privacy:request:historyactionupdate'] = 'Шинэчлэх';
$string['privacy:request:unknowndeletedgradeitem'] = 'Тодорхойгүй (үнэлгээний зүйлийг устгасан)';
$string['profilereport'] = 'Хэрэглэгчийн профайлын тайлан';
$string['profilereport_help'] = 'Хэрэглэгчийн профайл хуудсанд ашигласан үнэлгээний тайлан.';
$string['publishing'] = 'Нийтлэх';
$string['publishingoptions'] = 'Үнэлгээг нийтлэх сонголтууд';
$string['quickfeedback'] = 'Шуурхай санал хүсэлт';
$string['quickgrading'] = 'Хялбаршуулсан үнэлгээ';
$string['quickgrading_help'] = 'Идэвхжүүлсэн тохиолдолд засварыг идэвхтэй болгосон үед үнэлгээ тус бүрд бичвэр оруулах талбар гарах ба энэ нь олон дүнг нэгэн зэрэг засах боломжийг олгоно. Шинэчлэх товчийг дарж өөрчлөлтийг хадгалж, тодруулна.

Үнэлгээний задаргааны тайланд засварлах үед хүчингүй болгосон тэмдэглэгээ тавигдах ба энэ нь тухайн үнэлгээг холбогдох үйл ажиллагаа дотроос өөрчлөх боломжгүй гэдгийг анхаарна уу.';
$string['range'] = 'Муж';
$string['rangedecimals'] = 'Аравтын орны муж';
$string['rangedecimals_help'] = 'Мужид харуулах аравтын орны тоо.';
$string['rangesdecimalpoints'] = 'Мужид харуулсан аравтын тоо';
$string['rangesdecimalpoints_help'] = 'Энэ тохиргоо нь муж тус бүрийн аравтын бутархайн тоог харуулах эсвэл ангилал эсвэл үнэлгээний зүйлийн аравтын бутархайн нийт тохиргоог ашигласан эсэхийг (удамших) тодорхойлно.';
$string['rangesdisplaytype'] = 'Мужийг харуулах төрөл';
$string['rangesdisplaytype_help'] = 'Энэ тохиргоо нь мужийг бодит үнэлгээ, хувь эсвэл үсгээр харуулах эсэх, эсвэл ангилал эсвэл үнэлгээний зүйлийг харуулах төрлийг ашигласан эсэхийг (удамших) тодорхойлно.';
$string['rank'] = 'Зэрэглэл';
$string['rawpct'] = 'Боловсруулаагүй %';
$string['real'] = 'Бодит';
$string['realletter'] = 'Бодит (үсэг)';
$string['realpercentage'] = 'Бодит (хувь)';
$string['recalculatinggrades'] = 'Үнэлгээг дахин тооцоолох';
$string['recovergradesdefault'] = 'Үнэлгээг өгөгдмөл тохиргоогоор сэргээх';
$string['recovergradesdefault_help'] = 'Хэрэглэгчийг хичээлд дахин бүртгүүлэхэд хуучин үнэлгээг өгөгдмөл тохиргоогоор сэргээнэ.';
$string['refreshpreview'] = 'Урьдчилан харахыг сэргээх';
$string['regradeanyway'] = 'Ямар ч байсан дахин үнэлэх';
$string['removeallcoursegrades'] = 'Бүх үнэлгээг устгах';
$string['removeallcoursegrades_help'] = 'Сонгосон тохиолдолд журналд гараар нэмсэн бүх оноо, дүн, хүчингүй болгосон, хассан, нуусан, түгжсэн дүнгийн өгөгдөл устах болно. Зөвхөн үйл ажиллагаатай холбоотой үнэлгээний зүйл, үнэлгээ үлдэнэ.';
$string['removeallcourseitems'] = 'Бүх зүйл, ангиллыг устгах';
$string['removeallcourseitems_help'] = 'Сонгосон тохиолдолд журналд гараар нэмсэн бүх ангилал, дүнгийн зүйл нь хүчингүй болгосон, хассан, нуусан, түгжсэн үнэлгээний болон өгөгдөлтэй хамт устах болно. Зөвхөн үйл ажиллагаатай холбоотой үнэлгээний зүйл үлдэх болно.';
$string['report'] = 'Тайлан';
$string['reportdefault'] = 'Өгөгдмөл тайлан ({$a})';
$string['reportplugins'] = 'Тайлангийн нэмэлт хэрэгсэл';
$string['reportsettings'] = 'Тайлангийн тохиргоо';
$string['reprintheaders'] = 'Толгой хэсгийг дахин хэвлэх';
$string['resetweights'] = '{$a->itemname} жинг дахин тохируулах';
$string['resetweightsshort'] = 'Жинг дахин тохируулах';
$string['respectingcurrentdata'] = 'одоогийн тохиргоог өөрчлөхгүйгээр үлдээх';
$string['rowpreviewnum'] = 'Мөрийг урьдчилан харах';
$string['rowpreviewnum_help'] = 'Импортыг баталгаажуулахын өмнө импортлох өгөгдлийг урьдчилан харж болно. Энэ тохиргоо нь урьдчилан харуулах мөрийн тоог тодорхойлдог.';
$string['savechanges'] = 'Өөрчлөлтийг хадгалах';
$string['savepreferences'] = 'Тохиргоог хадгалах';
$string['scaleconfirmdelete'] = 'Та "{$a}" хэмжээсийг устгахдаа итгэлтэй байна уу?';
$string['scaledpct'] = 'Хэмжээстэй %';
$string['searchcollapsedcolumns'] = 'Хураангуйлагдсан багануудыг хайх';
$string['seeallcoursegrades'] = 'Бүх хичээлийн үнэлгээг харах';
$string['select'] = '{$a} сонгох';
$string['selectalloroneuser'] = 'Бүгдийг эсвэл нэг хэрэглэгчийг сонгох';
$string['selectauser'] = 'Хэрэглэгчийг сонгох';
$string['selectdestination'] = '{$a} хүрэх газрыг сонгох';
$string['selectgrouplink'] = 'Бүлэг сонгох';
$string['selectuserlink'] = 'Хэрэглэгчийг сонгох';
$string['separator'] = 'Тусгаарлагч';
$string['separator_help'] = 'CSV файлд ашигласан тусгаарлагчийг сонгоно уу. (Ихэвчлэн энэ нь таслал байна.)';
$string['sepcolon'] = 'Тодорхойлох цэг';
$string['sepcomma'] = 'Таслал';
$string['sepsemicolon'] = 'Цэгтэй таслал';
$string['septab'] = 'Таб';
$string['setcategories'] = 'Ангилал тогтоох';
$string['setcategorieserror'] = 'Та хичээлдээ жинг өгөхөөсөө өмнө хичээллийн ангиллаа тохируулах шаардлагатай.';
$string['setgradeletters'] = 'Үсгэн үнэлгээг тогтоох';
$string['setpreferences'] = 'Сонголтыг тохируулах';
$string['setting'] = 'Тохиргоо';
$string['settings'] = 'Тохиргоо';
$string['setup'] = 'Тохируулах';
$string['setweights'] = 'Жинг тохируулах';
$string['showactivityicons'] = 'Үйл ажиллагааны дүрс тэмдгийг харуулах';
$string['showactivityicons_help'] = 'Идэвхжүүлсэн тохиолдолд үйл ажиллагааны нэрийн хажууд тухайн үйл ажиллагааны дүрс тэмдэг харагдана.';
$string['showallgrades'] = 'Бүх үнэлгээг харуулах';
$string['showallhidden'] = 'Нуусанг харуулах';
$string['showallstudents'] = 'Бүх суралцагчийг харуулах';
$string['showanalysisicon'] = 'Шинжилгээний дүрс тэмдгийг харуулах';
$string['showanalysisicon_desc'] = 'Шинжилгээний дүрс тэмдгийг өгөгдмөл тохиргоогоор харуулах эсэх. Үүнийг үйл ажиллагааны модуль дэмждэг бол үнэлгээний шинжилгээний дүрс тэмдэг нь үнэлгээ, түүний талаарх дэлгэрэнгүй тайлбар бүхий хуудас руу холбоно.';
$string['showanalysisicon_help'] = 'Үүнийг үйл ажиллагааны модуль дэмждэг бол үнэлгээний шинжилгээний дүрс тэмдэг нь үнэлгээ, түүний талаарх дэлгэрэнгүй тайлбар бүхий хуудас руу холбоно.';
$string['showaverage'] = 'Дунджийг харуулах';
$string['showaverage_help'] = 'Дундаж баганыг харуулах эсэх. Цөөн тооны үнэлгээнээс дунджийг тооцоолох тохиолдолд оролцогчид бусдын үнэлгээг тооцоолох боломжтой болохыг анхаарна уу. Гүйцэтгэлийн шалтгааны улмаас дундаж нь ямар нэг далд зүйлээс хамааралтай бол ойролцоо байна.';
$string['showaverages'] = 'Баганын дунджийг харуулах';
$string['showaverages_help'] = 'Идэвхжүүлсэн тохиолдолд үнэлгээний задаргааны тайланд ангилал болон үнэлгээний зүйл бүрийн дунджийг харуулсан нэмэлт мөр байх болно.';
$string['showcalculations'] = 'Тооцооллыг харуулах';
$string['showcalculations_help'] = 'Идэвхжүүлсэн тохиолдолд засварлах үед үнэлгээний зүйл, ангилал тус бүрд үнэлгээний зүйлийг тооцоолж байгааг харуулах үзүүлэлт бүхий тооны машины дүрсийг харуулна.';
$string['showcontributiontocoursetotal'] = 'Хичээлийн нийт оролцоог харуулах';
$string['showcontributiontocoursetotal_help'] = 'Хэрэглэгчийн хичээлийн нийт хувьд үнэлгээний зүйл тус бүр хэр их хувь нэмэр оруулж байгааг харуулсан хувийн баганыг харуулах эсэх (жинлэсний дараа).';
$string['showeyecons'] = 'Харуулах/нуух дүрс тэмдгийг харуулах';
$string['showeyecons_help'] = 'Идэвхжүүлсэн тохиолдолд засвар идэвхтэй үед суралцагчийн харагдах байдлыг хянах зорилгоор үнэлгээ тус бүрд харуулах/нуух дүрс тэмдгийг харуулна.';
$string['showfeedback'] = 'Санал хүсэлтийг харуулах';
$string['showfeedback_help'] = 'Санал хүсэлтийн баганыг харуулах эсэх.';
$string['showgrade'] = 'Үнэлгээг харуулах';
$string['showgrade_help'] = 'Үнэлгээний баганыг харуулах эсэх.';
$string['showgroups'] = 'Бүлгийг харуулах';
$string['showhiddenitems'] = 'Нуусан зүйлсийг харуулах';
$string['showhiddenitems_help'] = 'Нуусан үнэлгээний зүйлийг бүхэлд нь нуусан эсвэл нуусан үнэлгээний зүйлийн нэр нь суралцагчид харагдаж байгаа эсэх.

* Нуусныг харуулах - Нуусан үнэлгээний зүйлийн нэрийг харуулсан боловч суралцагчийн үнэлгээг нуусан
* Зөвхөн энэ хүртэл нуусан - "хүртэл нуух" гэсэн огноотой үнэлгээний зүйлийг тогтоосон огноо хүртэл бүрэн нууж, дараа нь бүх зүйлийг харуулах болно.
* Бүү харуул - Нуусан үнэлгээний зүйлийг бүрэн нуусан';
$string['showhiddenuntilonly'] = 'Зөвхөн энэ хүртэл нуусан';
$string['showingaggregatesonly'] = 'Зөвхөн нийт дүнг харуулж байна';
$string['showingfullmode'] = 'Үнэлгээ болон нийт дүнг харуулж байна';
$string['showinggradesonly'] = 'Зөвхөн үнэлгээг харуулж байна';
$string['showlettergrade'] = 'Үсгэн үнэлгээг харуулах';
$string['showlettergrade_help'] = 'Үсгийн үнэлгээний баганыг харуулах эсэх.';
$string['showlocks'] = 'Түгжээг харуулах';
$string['showlocks_help'] = 'Идэвхжүүлсэн тохиолдолд засварлахыг идэвхжүүлсэн үед холбогдох үйл ажиллагаагаар үнэлгээг автоматаар шинэчлэх боломжтой эсэхийг хянах үүднээс үнэлгээ тус бүрд түгжих/түгжээг тайлах дүрс гарч ирнэ.';
$string['shownohidden'] = 'Харуулахгүй';
$string['shownooutcomes'] = 'Үр дүнг нуух';
$string['shownumberofgrades'] = 'Дунджаар үнэлгээний тоог харуулах';
$string['shownumberofgrades_help'] = 'Идэвхжүүлсэн тохиолдолд дунджийг тооцоолоход ашигласан үнэлгээний тоог дундаж бүрийн дараа хаалтад харуулна.';
$string['showonlyactiveenrol'] = 'Зөвхөн идэвхтэй бүртгэлийг харуулах';
$string['showonlyactiveenrol_help'] = 'Энэ тохиргоо нь журналын тайланд зөвхөн идэвхтэй бүртгүүлсэн хэрэглэгчийг харуулах эсэхийг тодорхойлно. Идэвхжүүлсэн тохиолдолд түдгэлзүүлсэн хэрэглэгчийг журналд харуулахгүй.';
$string['showpercentage'] = 'Хувийг харуулах';
$string['showpercentage_help'] = 'Үнэлгээний зүйл бүрийн хувийн утгыг харуулах эсэх.';
$string['showquickfeedback'] = 'Шуурхай санал хүсэлтийг харуулах';
$string['showquickfeedback_help'] = 'Идэвхжүүлсэн тохиолдолд засварлахыг идэвхжүүлсэн үед үнэлгээ тус бүрд тасархай хүрээтэй санал хүсэлтийн бичвэр оруулах талбар гарах ба энэ нь олон үнэлгээний санал хүсэлтийг нэгэн зэрэг засварлах боломжийг олгоно. Шинэчлэх товчоор өөрчлөлтийг хадгалж, тодруулна.

Үнэлгээний задаргааны тайланд санал хүсэлтийг засварлах үед хүчингүй тэмдгийг тохируулах ба энэ нь холбогдох үйл ажиллагаа дотроос санал хүсэлтийг өөрчлөх боломжгүй болгохыг анхаарна уу.';
$string['showrange'] = 'Мужийг харуулах';
$string['showrange_help'] = 'Мужийн баганыг харуулах эсэх.';
$string['showranges'] = 'Мужийг харуулах';
$string['showranges_help'] = 'Идэвхжүүлсэн тохиолдолд үнэлгээний задаргааны тайланд ангилал,  үнэлгээний зүйл бүрийн мужийг харуулсан нэмэлт мөрийг харуулна.';
$string['showrank'] = 'Зэрэглэлийг харуулах';
$string['showrank_help'] = 'Суралцагчийн байрыг бусадтай харьцуулан үнэлгээний зүйл тус бүрээр харуулах эсэх.';
$string['showuserimage'] = 'Хэрэглэгчийн профайлын зургийг харуулах';
$string['showuserimage_help'] = 'Үнэлгээний задаргааны тайланд нэрийн хажууд хэрэглэгчийн профайлын зургийг харуулах эсэх.';
$string['showverbose'] = '{$a->category} {$a->itemmodule} {$a->itemname} харуулах';
$string['showweight'] = 'Жинг харуулах';
$string['showweight_help'] = 'Үнэлгээний жингийн баганыг харуулах эсэх.';
$string['simpleview'] = 'Нэг харагдац';
$string['sitewide'] = 'Сайтын хэмжээнд';
$string['sort'] = 'эрэмбэлэх';
$string['sortasc'] = 'Өсөх дарааллаар эрэмбэлэх';
$string['sortbyfirstname'] = 'Нэрээр эрэмбэлэх';
$string['sortbylastname'] = 'Овгоор эрэмбэлэх';
$string['sortdesc'] = 'Буурах дарааллаар эрэмбэлэх';
$string['standarddeviation'] = 'Стандарт хэлбэлзэл';
$string['stats'] = 'Статистик';
$string['statslink'] = 'Статистик';
$string['student'] = 'Суралцагч';
$string['studentsperpage'] = 'Нэг хуудсанд харуулах суралцагчийн тоо';
$string['studentsperpage_help'] = 'Энэ тохиргоо нь үнэлгээний задаргааны тайланд нэг хуудсанд харуулах суралцагчийн тоог тодорхойлдог.';
$string['studentsperpagereduced'] = 'Нэг хуудсанд харуулах суралцагчийн хамгийн их тоог {$a->originalstudentsperpage}-аас {$a->studentsperpage} болгон багасгасан. PHP тохиргоог {$a->maxinputvars}-аас max_input_vars нэмэгдүүлж болно.';
$string['subcategory'] = 'Энгийн ангилал';
$string['submissions'] = 'Илгээсэн зүйл';
$string['submittedon'] = 'Илгээсэн: {$a}';
$string['sumofgradesupgradedgrades'] = 'Тайлбар: Сайтын шинэчлэлийн хүрээнд "Үнэлгээний нийлбэр" нэгтгэх аргыг "Энгийн" болгон өөрчилсөн. Өмнө нь энэ хичээлд "Үнэлгээний нийлбэр" аргыг ашиглаж байсан тул журналд энэ өөрчлөлтийг нягтлахыг зөвлөж байна.';
$string['switchtofullview'] = 'Бүрэн харагдацад шилжих';
$string['switchtosimpleview'] = 'Энгийн харагдацаар харуулах';
$string['topcategory'] = 'Супер ангилал';
$string['total'] = 'Нийт';
$string['totalweight100'] = 'Нийт жин нь 100-тай тэнцүү байна';
$string['totalweightnot100'] = 'Нийт жин нь 100-тай тэнцүү биш байна';
$string['turnfeedbackoff'] = 'Санал хүсэлтийг идэвхгүй болгох';
$string['turnfeedbackon'] = 'Санал хүсэлтийг идэвхтэй болгох';
$string['typenone'] = 'Байхгүй';
$string['typescale'] = 'Хэмжээс';
$string['typescale_help'] = 'Энэ тохиргоо нь үнэлгээний хэмжээсийн төрлийг ашиглах үед хэрэглэх хэмжээсийг тодорхойлно. Үйл ажиллагаанд суурилсан үнэлгээний зүйлийн хэмжээсийг үйл ажиллагааны тохиргооны хуудсанд тохируулдаг.';
$string['typetext'] = 'Бичвэр';
$string['typevalue'] = 'Утга';
$string['uncategorised'] = 'Ангилаагүй';
$string['unchangedgrade'] = 'Үнэлгээг өөрчлөгдөөгүй';
$string['unenrolledusersinimport'] = 'Энэ импортод одоогоор энэ хичээлд хамрагдаагүй хэрэглэгчийн  дараах үнэлгээ орсон: {$a}';
$string['unlimitedgrades'] = 'Хязгааргүй үнэлгээ';
$string['unlimitedgrades_help'] = 'Өгөгдмөл тохиргоогоор үнэлгээний зүйлийн хамгийн дээд ба доод утгаар үнэлгээг хязгаарладаг. Энэ тохиргоог идэвхжүүлснээр уг хязгаарыг арилгаж, 100%-иас дээш үнэлгээг журналд шууд оруулах боломжийг олгоно.';
$string['unlock'] = 'Түгжээг тайлах';
$string['unlockverbose'] = '{$a->category} {$a->itemmodule} {$a->itemname} түгжээг тайлах';
$string['unused'] = 'Ашиглаагүй';
$string['updatedgradesonly'] = 'Зөвхөн шинэ эсвэл шинэчилсэн үнэлгээг экспортлох';
$string['upgradedgradeshidemessage'] = 'Мэдэгдлийг хэрэгсэхгүй болгох';
$string['upgradedminmaxrevertmessage'] = 'Өөрчлөлтийг буцаах';
$string['uploadgrades'] = 'Үнэлгээг байршуулах';
$string['useadvanced'] = 'Нарийвчилсан функцийг ашиглах';
$string['usedcourses'] = 'Ашигласан хичээлүүд';
$string['usedgradeitem'] = 'Ашигласан үнэлгээний зүйл';
$string['usenooutcome'] = 'Үр дүнг ашиглахгүй';
$string['usenoscale'] = 'Хэмжээсийг ашиглахгүй';
$string['usepercent'] = 'Хувийг ашиглах';
$string['user'] = 'Хэрэглэгч';
$string['userenrolmentsuspended'] = 'Хэрэглэгчийн бүртгэлийг түдгэлзүүлсэн';
$string['userfields_show'] = 'Хэрэглэгчийн талбарыг харуулах';
$string['userfields_show_help'] = 'Үнэлгээний задаргааны тайланд цахим шуудангийн хаяг гэх мэт хэрэглэгчийн нэмэлт талбарыг харуулна. Харуулсан тодорхой талбарыг showuseridentity сайтын тохиргоогоор удирддаг';
$string['usergrade'] = '{$a->gradeidnumber} зүйл дээрх {$a->fullname} ({$a->useridnumber}) хэрэглэгч';
$string['userid'] = 'Хэрэглэгчийн ID дугаар';
$string['useridnumberwarning'] = 'ID дугааргүй хэрэглэгчийг импортлох боломжгүй тул экспортоос хасна';
$string['usermappingerror'] = 'Хэрэглэгчийн буулгалтын алдаа: "{$a->value}"-н {$a->field} талбартай хэрэглэгчийг олж чадсангүй.';
$string['usermappingerrorcurrentgroup'] = 'Хэрэглэгч нь тухайн бүлгийн гишүүн биш байна.';
$string['usermappingerrormultipleusersfound'] = 'Хэрэглэгчийн буулгалтын алдаа: "{$a->value}"-н {$a->field} талбартай олон хэрэглэгч олдсон. Илүү онцлог буулгалтын талбарыг ашиглана уу.';
$string['usermappingerrorusernotfound'] = 'Хэрэглэгчийн буулгалтын алдаа. Хэрэглэгчийг олж чадсангүй.';
$string['userpreferences'] = 'Хэрэглэгчийн сонголтууд';
$string['useweighted'] = 'Жинг ашиглах';
$string['verbosescales'] = 'Нарийвчилсан хэмжээс';
$string['verbosescales_help'] = 'Нарийвчилсан хэмжээс нь тооноос илүү үгийг ашигладаг. Тоон болон нарийвчилсан хэмжээсийг хоёуланг нь импортлох бол \'Тийм\' гэж тохируулна. Зөвхөн тоон хэмжээсийг импортлох бол \'Үгүй\' гэж тохируулна.';
$string['viewas'] = 'Тайланг дараах байдлаар харах';
$string['viewbygroup'] = 'Бүлэг';
$string['viewfeedback'] = 'Санал хүсэлтийг харах';
$string['viewgrades'] = 'Үнэлгээг харах';
$string['weight'] = 'Жин';
$string['weight_help'] = 'Ангилал эсвэл хичээлийн хэд хэдэн үнэлгээний зүйлийн харьцангуй утгыг тодорхойлоход ашигладаг утга.';
$string['weightcourse'] = 'Хичээлд жинлэсэн үнэлгээг ашиглах';
$string['weightedascending'] = 'Жинлэсэн хувийг өсөх дарааллаар эрэмбэлэх';
$string['weighteddescending'] = 'Жинлэсэн хувийг буурах дарааллаар эрэмбэлэх';
$string['weightedpct'] = 'жинлэсэн %';
$string['weightedpctcontribution'] = 'жинлэсэн % оролцоо';
$string['weightofa'] = '{$a} жин';
$string['weightorextracredit'] = 'Жин эсвэл нэмэлт кредит';
$string['weightoverride'] = 'жингийн тохируулга';
$string['weightoverride_help'] = 'Үнэлгээний зүйлийн жинг автоматаар тооцоолсон утгад дахин тохируулахын тулд энэ тэмдэглэгээг арилгана. Үүнийг шалгах нь жинг автоматаар тохируулахаас сэргийлнэ.';
$string['weights'] = 'Жин';
$string['weightsadjusted'] = 'Таны жинг нийт 100 болгож тохируулсан.';
$string['weightsedit'] = 'Жин ба нэмэлт кредитийг тохируулах';
$string['weightuc'] = 'Тооцоолсон жин';
$string['writinggradebookinfo'] = 'Журнал хөтлөх тохиргоо';
$string['xml'] = 'XML';
$string['yes'] = 'Тийм';
$string['yourgrade'] = 'Таны үнэлгээ';
