<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'data', language 'id', version '4.4'.
 *
 * @package     data
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Aksi';
$string['actionsmenu'] = 'Menu aksi';
$string['add'] = 'Tambahkan entri';
$string['addcomment'] = 'Tambahkan komentar';
$string['addedby'] = 'Ditambahkan oleh';
$string['addentries'] = 'Tambahkan entri';
$string['addtemplate'] = 'Tambahkan templat entri';
$string['advancedsearch'] = 'Pencarian lanjutan';
$string['allowcomments'] = 'Izinkan komentar pada entri';
$string['alttext'] = 'Teks alternatif';
$string['approvalstatus'] = 'Status persetujuan';
$string['approve'] = 'Menyetujui';
$string['approved'] = 'Disetujui';
$string['areacontent'] = 'Kolom';
$string['ascending'] = 'Urut naik';
$string['asearchtemplate'] = 'Templat pencarian lanjutan';
$string['atmaxentry'] = 'Anda telah memasukkan jumlah entri maksimum yang diizinkan!';
$string['authorfirstname'] = 'Nama depan';
$string['authorlastname'] = 'Nama belakang';
$string['autogenallforms'] = 'Hasilkan semua templat bawaan';
$string['autolinkurl'] = 'Tautan otomatis ke URL';
$string['availablefromdate'] = 'Tersedia dari';
$string['availabletags'] = 'Label yang tersedia';
$string['availabletags_help'] = 'Label adalah tempat penampung di templat, yang akan digantikan oleh data atau item lain, seperti ikon edit, saat entri diedit atau dilihat. Bidang memiliki format [[nama bidang]]. Semua label lainnya memiliki format ##label##. Hanya label yang ada dalam daftar "Label yang tersedia" yang dapat digunakan untuk templat saat ini.';
$string['availabletodate'] = 'Tersedia sampai';
$string['availabletodatevalidation'] = 'Yang tersedia hingga saat ini tidak boleh sebelum yang tersedia dari tanggal.';
$string['blank'] = 'Kosong';
$string['buttons'] = 'Aksi';
$string['bynameondate'] = 'oleh {$a->name} - {$a->date}';
$string['calendarend'] = '{$a} akan berakhir';
$string['calendarstart'] = '{$a} buka';
$string['cancel'] = 'Batal';
$string['cannotaccesspresentsother'] = 'Anda tidak diperbolehkan mengakses preset dari pengguna lain';
$string['cannotadd'] = 'Tidak dapat menambahkan entri!';
$string['cannotapplypreset'] = 'Galat saat menerapkan preset.';
$string['cannotdeletepreset'] = 'Galat saat menghapus preset!';
$string['cannotoverwritepreset'] = 'Galat menimpa preset';
$string['cannotunziptopreset'] = 'Tidak dapat mengurai zip ke direktori preset';
$string['checkbox'] = 'Kotak centang';
$string['chooseexportfields'] = 'Pilih kolom yang akan Anda ekspor';
$string['chooseexportformat'] = 'Pilih format yang akan Anda ekspor';
$string['chooseorupload'] = 'Pilih berkas';
$string['choosepreset'] = 'Berkas preset';
$string['closebeforeopen'] = 'Anda telah menentukan tanggal akhir sebelum tanggal mulai.';
$string['columns'] = 'kolom';
$string['comment'] = 'Komentar';
$string['commentdeleted'] = 'Komentar dihapus';
$string['commentempty'] = 'Komentar kosong';
$string['comments'] = 'Komentar';
$string['commentsaved'] = 'Komenter tersimpan';
$string['commentsn'] = '{$a} komentar';
$string['commentsoff'] = 'Fitur komenter tidak diaktifkan';
$string['completiondetail:entries'] = 'Membuat entri: {$a}';
$string['completionentries'] = 'Entri dibutuhkan';
$string['completionentriescount'] = 'Tambahkan entri';
$string['completionentriesdesc'] = 'Jumlah minimum entri yang diperlukan: {$a}';
$string['configenablerssfeeds'] = 'Tombol ini akan mengaktifkan kemungkinan umpan RSS untuk semua basis data. Anda masih perlu mengaktifkan umpan secara manual di setelan untuk setiap basis data.';
$string['confirmdeletefield'] = 'Anda akan menghapus kolom ini, apakah Anda yakin?';
$string['confirmdeleterecord'] = 'Apakah Anda yakin ingin menghapus entri ini?';
$string['confirmdeleterecords'] = 'Anda yakin ingin menghapus entri ini?';
$string['createactivity'] = 'Buat kolom Anda sendiri untuk mengumpulkan data, atau gunakan preset yang sudah menyertakan kolom.';
$string['createfields'] = 'Buat kolom Anda sendiri untuk mengumpulkan data, atau gunakan preset yang sudah menyertakan kolom.';
$string['createtemplates'] = 'Templat menentukan antarmuka aktivitas Anda. Setelah Anda membuat kolom, templat akan dibuat secara otomatis. Alternatifnya, Anda dapat menggunakan preset, yang mencakup kolom dan templat.';
$string['csstemplate'] = 'CSS kustom';
$string['csvfailed'] = 'Tidak dapat membaca data mentah dari berkas CSV';
$string['csvfile'] = 'CSV atau ZIP yang berisi berkas CSV';
$string['csvimport'] = 'Impor berkas CSV';
$string['csvimport_help'] = 'Entri dapat diimpor melalui berkas teks biasa dengan daftar nama kolom sebagai baris pertama, kemudian data, dengan satu data per baris.';
$string['csvwithselecteddelimiter'] = '<abbr title="Comma Separated Values">CSV</abbr>';
$string['data:addinstance'] = 'Tambahkan basis data baru';
$string['data:approve'] = 'Menyetujui dan membatalkan entri yang disetujui';
$string['data:comment'] = 'Tulis komentar';
$string['data:exportallentries'] = 'Ekspor semua entri basis data';
$string['data:exportentry'] = 'Ekspor entri basis data';
$string['data:exportownentry'] = 'Ekspor entri basis data sendiri';
$string['data:exportuserinfo'] = 'Ekspor informasi pengguna';
$string['data:managecomments'] = 'Kelola komentar';
$string['data:manageentries'] = 'Kelola entri';
$string['data:managetemplates'] = 'Kelola templat';
$string['data:manageuserpresets'] = 'Kelola semua preset templat';
$string['data:rate'] = 'Nilai entri';
$string['data:readentry'] = 'Baca entri';
$string['data:view'] = 'Lihat aktivitas basis data';
$string['data:viewallratings'] = 'Lihat semua peringkat mentah yang diberikan oleh individu';
$string['data:viewalluserpresets'] = 'Lihat preset dari semua pengguna';
$string['data:viewanyrating'] = 'Lihat total peringkat yang diterima siapa pun';
$string['data:viewentry'] = 'Lihat entri';
$string['data:viewrating'] = 'Lihat total peringkat yang Anda terima';
$string['data:writeentry'] = 'Tulis entri';
$string['date'] = 'Tanggal';
$string['dateentered'] = 'Tanggal masuk';
$string['datemodified'] = 'Terakhir diubah:';
$string['defaultfielddelimiter'] = '(bawaan adalah karakter koma)';
$string['defaultfieldenclosure'] = '(bawaan kosong)';
$string['defaultsortfield'] = 'Kolom pengurutan bawaan';
$string['delcheck'] = 'Hapus kotak centang secara massal';
$string['delete'] = 'Hapus';
$string['deleteallentries'] = 'Hapus semua entri';
$string['deletecomment'] = 'Anda yakin ingin menghapus komentar ini?';
$string['deleteconfirm'] = 'Hapus preset {$a}?';
$string['deleted'] = 'dihapus';
$string['deleteentry'] = 'Hapus entri';
$string['deletefield'] = 'Hapus kolom';
$string['deletenotenrolled'] = 'Hapus entri oleh pengguna yang tidak terdaftar';
$string['deletewarning'] = 'Menghapus preset akan menghapusnya dari daftar preset yang tersedia di semua kursus.';
$string['descending'] = 'urut turun';
$string['directorynotapreset'] = '{$a->directory} Bukan preset: file hilang: {$a->missing_files}';
$string['disapprove'] = 'Batalkan persetujuan';
$string['download'] = 'Unduh';
$string['edit'] = 'Edit';
$string['editcomment'] = 'Edit komentar';
$string['editentry'] = 'Edit entri';
$string['editfield'] = 'Edit kolom';
$string['editordisable'] = 'Nonaktifkan editor';
$string['editorenable'] = 'Aktifkan editor kode';
$string['editpreset'] = 'Edit preset';
$string['emptyadd'] = 'Tambahkan templat kosong, menghasilkan formulir bawaan...';
$string['emptyaddform'] = 'Anda tidak mengisi kolom apa pun!';
$string['emptypresetname'] = 'Nama atau file preset tidak boleh kosong';
$string['enabletemplateeditorcheck'] = 'Yakin ingin mengaktifkan editor? Hal ini dapat mengakibatkan konten diubah saat templat disimpan.';
$string['entries'] = 'Entri';
$string['entrieslefttoadd'] = 'Anda harus menambahkan {$a->entriesleft} entri lagi untuk menyelesaikan aktivitas ini.';
$string['entrieslefttoaddtoview'] = 'Anda harus menambahkan {{$a->entrieslefttoview} lebih banyak entri/entri sebelum Anda dapat melihat entri peserta lain.';
$string['entry'] = 'Entri';
$string['entrysaved'] = 'Entri Anda telah tersimpan';
$string['errordatafilenotfound'] = 'Berkas tidak dapat diimpor. Jenis berkas yang diterima adalah CSV atau ZIP yang berisi berkas CSV dalam format yang digunakan untuk mengekspor entri.';
$string['errormustbeteacher'] = 'Anda harus menjadi pengajar untuk menggunakan halaman ini!';
$string['errormustsupplyvalue'] = 'Anda harus memberikan nilai di sini.';
$string['errorpresetexists'] = 'Preset dengan nama ini sudah ada.';
$string['errorpresetexistsbutnotoverwrite'] = 'Preset dengan nama ini sudah ada. Pilih nama yang berbeda.';
$string['errorpresetnotfound'] = 'Preset dengan nama {$a} tidak ditemukan.';
$string['eventfieldcreated'] = 'Membuat kolom';
$string['eventfielddeleted'] = 'Menghapus kolom';
$string['eventfieldupdated'] = 'Memperbarui kolom';
$string['eventrecordcreated'] = 'Membuat rekaman';
$string['eventrecorddeleted'] = 'Menghapus rekaman';
$string['eventrecordupdated'] = 'Memperbarui rekaman';
$string['eventtemplateupdated'] = 'Memperbarui templat';
$string['eventtemplateviewed'] = 'Melihat templat';
$string['example'] = 'Contoh modul basis data';
$string['excel'] = 'Excel';
$string['expired'] = 'Maaf, aktivitas ini ditutup pada {$a} dan tidak lagi tersedia';
$string['export'] = 'Ekspor';
$string['exportaszip'] = 'Ekspor sebagai zip';
$string['exportaszip_help'] = 'Fitur ekspor sebagai zip memungkinkan Anda untuk menyimpan templat dan kolom sebagai zip yang telah ditetapkan untuk diunduh. Zip kemudian dapat diimpor ke kursus lain.';
$string['exportedtozip'] = 'Diekspor ke zip sementara...';
$string['exportentries'] = 'Ekspor entri';
$string['exportformat'] = 'Format ekspor';
$string['exportoptions'] = 'Opsi ekspor';
$string['exportownentries'] = 'Ekspor entri Anda sendiri saja? ({$a->mine}/{$a->all})';
$string['exportpreset'] = 'Ekspor preset';
$string['failedpresetdelete'] = 'Galat saat mencoba menghapus preset.';
$string['fieldadded'] = 'Kolom ditambahkan';
$string['fieldallowautolink'] = 'Izinkan tautan otomatis';
$string['fielddeleted'] = 'Kolom dihapus';
$string['fielddelimiter'] = 'Pembatas kolom';
$string['fielddescription'] = 'Deskripsi kolom';
$string['fieldenclosure'] = 'Penutup kolom';
$string['fieldheight'] = 'Tinggi';
$string['fieldheightlistview'] = 'Tinggi (dalam piksel) dalam tampilan daftar';
$string['fieldheightsingleview'] = 'Tinggi (dalam piksel) dalam tampilan tunggal';
$string['fieldids'] = 'ID kolom';
$string['fieldmappings'] = 'Pemetaan kolom';
$string['fieldmappings_help'] = 'Menu ini memungkinkan Anda untuk menyimpan data dari basis data yang ada. Untuk mempertahankan data dalam suatu bidang, Anda harus memetakannya ke bidang baru, tempat data akan muncul. Bidang apa pun juga dapat dikosongkan, tanpa informasi yang disalin ke dalamnya. Bidang lama apa pun yang tidak dipetakan ke bidang baru akan hilang dan semua datanya dihapus.
Anda hanya dapat memetakan bidang dengan jenis yang sama, sehingga setiap menu tarik-turun akan memiliki bidang yang berbeda di dalamnya. Juga, Anda harus berhati-hati untuk tidak mencoba dan memetakan satu bidang lama ke lebih dari satu bidang baru.';
$string['fieldname'] = 'Nama kolom';
$string['fieldnametype'] = '{$a->name} ({$a->type})';
$string['fieldnotmatched'] = 'Kolom berikut dalam file berkas tidak dikenal dalam basis data ini: {$a}';
$string['fieldoptions'] = 'Opsi (satu per baris)';
$string['fields'] = 'Kolom';
$string['fieldshelp'] = 'Buat kolom untuk mengumpulkan berbagai jenis data. Kolom menentukan struktur entri dalam basis data Anda.';
$string['fieldsinformationtags'] = 'Informasi kolom';
$string['fieldsnavigation'] = 'Kolom navigasi tersier';
$string['fieldtagdescription'] = 'deskripsi {$a}';
$string['fieldtagid'] = 'ID {$a}';
$string['fieldtagname'] = 'nama {$a}';
$string['fieldupdated'] = 'Kolom diperbarui';
$string['fieldwidth'] = 'Lebar';
$string['fieldwidthlistview'] = 'Lebar (dalam piksel) dalam tampilan daftar';
$string['fieldwidthsingleview'] = 'Lebar (dalam piksel) dalam satu tampilan';
$string['file'] = 'Berkas';
$string['fileencoding'] = 'Pengodean';
$string['filesnotgenerated'] = 'Tidak semua berkas dihasilkan: {$a}';
$string['filtername'] = 'Tautan otomatis basis data';
$string['footer'] = 'Catatan kaki';
$string['forcelinkname'] = 'Nama paksa untuk tautan';
$string['foundnorecords'] = 'Tidak ada catatan yang ditemukan. <a href="{$a->reseturl}">Hapus semua</a>';
$string['foundrecords'] = 'Ditemukan {$a->num} dari {$a->max} rekaman. <a href="{$a->reseturl}">Hapus semua</a>';
$string['fromfile'] = 'Impor dari berkas zip';
$string['fromfile_help'] = 'Fitur impor dari berkas zip memungkinkan Anda menelusuri dan mengunggah zip templat dan kolom yang telah ditetapkan sebelumnya.';
$string['generateerror'] = 'Tidak semua berkas dihasilkan!';
$string['header'] = 'Tajuk';
$string['headeraddtemplate'] = 'Tentukan antarmuka untuk menambahkan atau mengedit entri.';
$string['headerasearchtemplate'] = 'Tentukan antarmuka untuk pencarian lanjutan.';
$string['headercsstemplate'] = 'Tambahkan CSS kustom ke templat.';
$string['headerjstemplate'] = 'Tambahkan JavaScript kustom untuk templat Daftar, Tunggal, atau Tambahkan entri.';
$string['headerlisttemplate'] = 'Tentukan antarmuka tampilan daftar.';
$string['headerrsstemplate'] = 'Tentukan tampilan entri di umpan RSS.';
$string['headersingletemplate'] = 'Tentukan antarmuka Tampilan tunggal.';
$string['id'] = 'ID entri';
$string['importandapply'] = 'Impor preset dan terapkan';
$string['importapreset'] = 'Impor preset';
$string['importentries'] = 'Impor entri';
$string['importpreset'] = 'Impor preset';
$string['importpreset_desc'] = 'Preset akan diterapkan ke aktivitas ini, membuat kolom dan templat. Itu tidak akan muncul dalam daftar preset.';
$string['importpresetmissingcapability'] = 'Anda tidak memiliki izin untuk mengimpor preset.';
$string['importsuccess'] = 'Preset diterapkan.';
$string['includeapproval'] = 'Sertakan status persetujuan';
$string['includefiles'] = 'Sertakan berkas dalam ekspor';
$string['includetags'] = 'Sertakan label';
$string['includetime'] = 'Sertakan waktu yang ditambahkan/dimodifikasi';
$string['includeuserdetails'] = 'Sertakan detail pengguna';
$string['indicator:cognitivedepth'] = 'Basis data kognitif';
$string['indicator:cognitivedepth_help'] = 'Indikator ini didasarkan pada kedalaman kognitif yang dicapai siswa dalam aktivitas basis data.';
$string['indicator:cognitivedepthdef'] = 'Basis data kognitif';
$string['indicator:cognitivedepthdef_help'] = 'Peserta telah mencapai persentase keterlibatan kognitif yang ditawarkan oleh aktivitas basis data selama interval analisis ini (Tingkat = Tidak ada tampilan, Lihat, Ajukan)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Basis data sosial';
$string['indicator:socialbreadth_help'] = 'Indikator ini didasarkan pada keluasan sosial yang dicapai siswa dalam suatu aktivitas basis Data.';
$string['indicator:socialbreadthdef'] = 'Basis data sosial';
$string['indicator:socialbreadthdef_help'] = 'Peserta telah mencapai persentase keterlibatan sosial yang ditawarkan oleh aktivitas basis data selama interval analisis ini (Tingkat = Tidak ada partisipasi, Peserta saja)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['insufficiententries'] = 'lebih banyak entri diperlukan untuk melihat basis data ini';
$string['intro'] = 'Deskripsi';
$string['invalidaccess'] = 'Halaman ini tidak diakses dengan benar';
$string['invalidfieldid'] = 'ID ruas salah';
$string['invalidfieldname'] = 'Silakan pilih nama lain untuk ruas ini';
$string['invalidfieldtype'] = 'Tipe ruas  salah';
$string['invalidid'] = 'ID data salah';
$string['invalidpreset'] = '{$a} bukan preset.';
$string['invalidrecord'] = 'Rekaman salah';
$string['invalidurl'] = 'URL yang baru saja Anda masukkan tidak valid';
$string['jstemplate'] = 'Javascript kustom';
$string['latitude'] = 'Garis lintang';
$string['latlong'] = 'Garis lintang/Garis bujur';
$string['latlongboth'] = 'Diperlukan garis lintang dan bujur.';
$string['latlongdownloadallhint'] = 'Unduh tautan untuk semua entri sebagai KML';
$string['latlongkmllabelling'] = 'Cara memberi label item dalam berkas KML (Google Earth)';
$string['latlonglinkservicesdisplayed'] = 'Layanan tautan keluar untuk ditampilkan';
$string['latlongotherfields'] = 'Ruas lainnya';
$string['list'] = 'Daftar tampilan';
$string['listtemplate'] = 'Templat tampilan daftar';
$string['listview'] = 'Tampilan daftar';
$string['longitude'] = 'Garis bujur';
$string['manageapproved'] = 'Izinkan pengeditan entri yang disetujui';
$string['manageapproved_help'] = 'Izinkan siswa untuk mengedit atau menghapus entri mereka setelah disetujui. Entri yang diedit perlu disetujui kembali.';
$string['managefields'] = 'Kelola ruas';
$string['mapexistingfield'] = 'Petakan ke {$a}';
$string['mapnewfield'] = 'Buat ruas baru';
$string['mapping:applypresets'] = 'Terapkan preset';
$string['mapping:dialogtitle:usepreset'] = 'Terapkan preset {$a}?';
$string['mapping:fieldstocreate'] = 'Ruas yang akan dibuat: {$a}';
$string['mapping:fieldstodelete'] = 'Ruas yang ada untuk dihapus: {$a}';
$string['mapping:mapfields'] = 'Ruas peta';
$string['mapping:warningmessagedelete'] = 'Jika ruas yang akan dihapus memiliki jenis yang sama dengan ruas baru di preset yang Anda terapkan, Anda mungkin dapat memetakannya di ruas Peta.';
$string['mapping:warningmessagedeleteandcreate'] = 'Jika ruas yang akan dihapus memiliki jenis yang sama dengan ruas yang akan dibuat, Anda mungkin dapat memetakannya di ruas Peta.';
$string['mappingwarning'] = 'Semua ruas lama yang tidak dipetakan ke ruas baru akan hilang dan semua data di ruas tersebut akan dihapus.';
$string['maxentries'] = 'Jumlah entri maksimum';
$string['maxentries_help'] = 'Jumlah maksimum entri yang boleh diajukan oleh siswa untuk aktivitas ini.';
$string['maxsize'] = 'Ukuran maksimum';
$string['menu'] = 'Menu';
$string['menuchoose'] = 'Pilih...';
$string['missingdata'] = 'ID data atau objek harus disediakan untuk ruas kelas.';
$string['missingfield'] = 'Kesalahan pemrogram: Anda harus menentukan bidang dan/atau data saat menentukan kelas bidang.';
$string['missingfieldtype'] = 'Jenis ruas untuk {$a->name} tidak ditemukan';
$string['missingfieldtypeimport'] = 'Ruas berikut tidak diimpor karena jenis ruas yang sesuai tidak dipasang:';
$string['missingfieldtypes'] = 'Ruas berikut tidak memiliki jenis ruas terkait yang diinstal dan tidak akan disertakan dalam formulir Tambahkan entri. Anda perlu mencentang Add entry templat dan menghapus semua nama ruas.';
$string['modulename'] = 'Basis data';
$string['modulename_help'] = 'Modul aktivitas basis data memungkinkan peserta untuk membuat, memelihara, dan mencari kumpulan entri (mis. Catatan). Struktur entri didefinisikan oleh pengajar sebagai sejumlah bidang. Jenis bidang termasuk kotak centang, tombol radio, menu dropdown, area teks, URL, gambar dan file yang diunggah.

Tata letak visual informasi ketika mendaftar, melihat atau mengedit entri basis data dapat dikendalikan oleh templat basis data. Kegiatan basis data dapat dibagi antarkursus sebagai preset dan pengajar juga dapat mengimpor dan mengekspor entri basis data.

Jika filter tautan otomatis basis data diaktifkan, setiap entri dalam basis data akan secara otomatis ditautkan di mana kata atau frasa muncul dalam kursus.

Pengajar dapat mengizinkan komentar pada entri. Entri juga dapat dinilai oleh pengajar atau siswa (evaluasi rekan sejawat). Peringkat dapat dikumpulkan untuk membentuk nilai akhir yang dicatat dalam buku angka.

Aktivitas  basis data memiliki banyak kegunaan, seperti

* Kumpulan kolaboratif tautan web, buku, ulasan buku, referensi jurnal, dll.
* Untuk menampilkan foto, poster, situs web, atau puisi yang dibuat siswa untuk komentar dan ulasan rekan sejawat.';
$string['modulename_link'] = 'mod/data/view';
$string['modulenameplural'] = 'Basis data';
$string['more'] = 'Lebih';
$string['moreurl'] = 'URL lanjutan';
$string['movezipfailed'] = 'Tidak dapat pindahkan zip';
$string['multientry'] = 'Entri berulang';
$string['multimenu'] = 'Menu (Multi-pilihan)';
$string['multipletags'] = 'Beberapa label ditemukan! Templat tidak disimpan';
$string['newentry'] = 'Entri baru';
$string['newfield'] = 'Buat ruas baru';
$string['newfield_help'] = 'Sebuah ruas memungkinkan input data. Setiap entri dalam aktivitas basis data dapat memiliki beberapa ruas dari beberapa jenis seperti ruas tanggal, yang memungkinkan peserta untuk memilih hari, bulan, dan tahun dari menu tarik-turun, bidang gambar, yang memungkinkan peserta untuk mengunggah berkas gambar, atau ruas kotak centang, yang memungkinkan peserta untuk memilih satu atau beberapa opsi.

Setiap ruas harus memiliki nama ruas yang unik. Deskripsi ruas adalah opsional.';
$string['noaccess'] = 'Anda tidak memiliki akses ke halaman ini';
$string['nodefinedfields'] = 'Preset baru tidak memiliki ruas yang ditentukan!';
$string['nofieldcontent'] = 'Konten ruas tidak ditemukan';
$string['nofieldindatabase'] = 'Tidak ada ruas yang ditentukan untuk basis data ini.';
$string['nofields'] = 'Belum ada ruas';
$string['nolisttemplate'] = 'Daftar templat belum ditentukan';
$string['nomatch'] = 'Tidak ada entri yang cocok ditemukan!';
$string['nomaximum'] = 'Tidak maksimum';
$string['nopreviewavailable'] = 'Tidak ada pratinjau {$a}';
$string['norecords'] = 'Belum ada entri';
$string['nosingletemplate'] = 'Templat tunggal belum ditentukan';
$string['notapproved'] = 'Menunggu persetujuan';
$string['notapprovederror'] = 'Entri belum disetujui';
$string['notemplates'] = 'Belum ada templat';
$string['notinjectivemap'] = 'Bukan peta injeksi';
$string['notopenyet'] = 'Maaf, aktivitas ini tidak tersedia hingga {$a}';
$string['number'] = 'Jumlah';
$string['numberrssarticles'] = 'Entri di umpan RSS';
$string['numnotapproved'] = 'Ditangguhkan';
$string['numrecords'] = '{$a} entri';
$string['ods'] = '<abbr title="OpenDocument Spreadsheet">ODS</abbr>&nbsp;(OpenOffice)';
$string['openafterclose'] = 'Anda telah menentukan tanggal buka setelah tanggal tutup';
$string['optionaldescription'] = 'Deskripsi singkat (opsional)';
$string['optionalfilename'] = 'Nama berkas (opsional)';
$string['other'] = 'Lainnya';
$string['otherfields'] = 'Semua ruas lainnya';
$string['overrwritedesc'] = 'Ganti preset yang ada dengan nama ini dan timpa isinya';
$string['overwrite'] = 'Timpa';
$string['overwritesettings'] = 'Timpa setalan saat ini seperti komentar, peringkat, dll.';
$string['page-mod-data-x'] = 'Setiap halaman modul aktivitas basis data';
$string['pagesize'] = 'Entri per halaman';
$string['participants'] = 'Peserta';
$string['picture'] = 'Gambar';
$string['pleaseaddsome'] = 'Harap buat beberapa di bawah ini atau <a href="{$a}">pilih set yang telah ditentukan</a> untuk memulai.';
$string['pluginadministration'] = 'Administrasi aktivitas basis data';
$string['pluginname'] = 'Basis data';
$string['portfolionotfile'] = 'Ekspor ke portofolio daripada berkas (hanya csv dan leap2a)';
$string['presetdeleted'] = 'Preset dihapus.';
$string['presetinfo'] = 'Menyimpan sebagai preset akan menerbitkan templat ini. Pengguna lain mungkin dapat menggunakannya di basis data mereka.';
$string['presetnotselected'] = 'Tidak ada preset yang dipilih.';
$string['presets'] = 'Preset';
$string['presetshelp'] = 'Pilih preset untuk digunakan sebagai titik awal.';
$string['preview'] = 'Pratinjau {$a}';
$string['previewaction'] = 'Pratinjau';
$string['privacy:metadata:commentpurpose'] = 'Komentar pada rekaman basis data';
$string['privacy:metadata:data_content'] = 'Konten bidang';
$string['privacy:metadata:data_content:content'] = 'Konten';
$string['privacy:metadata:data_content:content1'] = 'Konten tambahan 1';
$string['privacy:metadata:data_content:content2'] = 'Konten tambahan 2';
$string['privacy:metadata:data_content:content3'] = 'Konten tambahan 3';
$string['privacy:metadata:data_content:content4'] = 'Konten tambahan 3';
$string['privacy:metadata:data_content:fieldid'] = 'ID definisi ruas';
$string['privacy:metadata:data_records'] = 'Rekaman dalam aktivitas basis data';
$string['privacy:metadata:data_records:approved'] = 'Status persetujuan';
$string['privacy:metadata:data_records:groupid'] = 'Grup';
$string['privacy:metadata:data_records:timecreated'] = 'Waktu ketika rekaman dibuat';
$string['privacy:metadata:data_records:timemodified'] = 'Waktu ketika rekaman terakhir dimodifikasi';
$string['privacy:metadata:data_records:userid'] = 'Pengguna yang membuat rekaman';
$string['privacy:metadata:datafieldnpluginsummary'] = 'Ruas untuk modul aktivitas basis data';
$string['privacy:metadata:filepurpose'] = 'Berkas dilampirkan ke rekaman basis data';
$string['privacy:metadata:ratingpurpose'] = 'Peringkat pada rekaman basis data';
$string['privacy:metadata:tagpurpose'] = 'Label pada rekaman basis data';
$string['radiobutton'] = 'Tombol radio';
$string['recordapproved'] = 'Entri disetujui';
$string['recorddeleted'] = 'Entri dihapus';
$string['recorddisapproved'] = 'Entri tidak disetujui';
$string['recordsnotsaved'] = 'Tidak ada entri yang disimpan. Silakan periksa format berkas yang diunggah.';
$string['recordssaved'] = 'entri tersimpan';
$string['removealldatatags'] = 'Hapus semua label basis data';
$string['requireapproval'] = 'Diperlukan persetujuan';
$string['requireapproval_help'] = 'Pengajar harus menyetujui entri sebelum dapat dilihat oleh semua orang.';
$string['required'] = 'Dibutuhkan';
$string['requiredentries'] = 'Entri yang diperlukan untuk penyelesaian (lama)';
$string['requiredentries_help'] = 'Jika diatur, sebuah pesan ditampilkan yang menyatakan jumlah entri yang diperlukan untuk penyelesaian. Perhatikan bahwa setelan ini tidak terhubung ke penyelesaian aktivitas. Untuk entri yang diperlukan untuk penyelesaian aktivitas, setelan penyelesaian Aktivitas baru \'Memerlukan entri\' harus digunakan. Untuk menghapus setelan ini sepenuhnya, setel ke tidak ada, lalu simpan perubahan. Silakan gunakan ruas entri yang diperlukan di bagian penyelesaian aktivitas sebagai gantinya.';
$string['requiredentriestoview'] = 'Entri diperlukan sebelum melihat';
$string['requiredentriestoview_help'] = 'Jumlah entri yang harus ditambahkan siswa sebelum mereka dapat melihat entri dari siswa lain.

Ini tidak kompatibel dengan filter penautan otomatis basis data.';
$string['requiredentrieswarning'] = 'Setelan ini telah diganti dengan setelan penyelesaian Aktivitas "Memerlukan entri"';
$string['requiredfield'] = 'Membutuhkan ruas';
$string['resetalltemplates'] = 'Reset semua templat';
$string['resetalltemplatesconfirm'] = 'Anda akan menghapus semua templat untuk preset Anda saat ini. Jika nanti Anda ingin mengembalikan templat, Anda harus memilih preset lagi di tab \'Preset\'.';
$string['resetalltemplatesconfirmtitle'] = 'Reset semua templat?';
$string['resetsettings'] = 'Reset filter';
$string['resettemplate'] = 'Reset templat';
$string['resettemplateconfirm'] = 'Ini akan secara permanen menghapus {$a} untuk preset Anda saat ini.';
$string['resettemplateconfirmtitle'] = 'Reset templat?';
$string['resizingimages'] = 'Mengubah ukuran gambar mini...';
$string['rows'] = 'baris';
$string['rssglobaldisabled'] = 'Dinonaktifkan. Lihat variabel konfigurasi situs.';
$string['rsstemplate'] = 'Templat RSS';
$string['rsstitletemplate'] = 'Judul templat RSS';
$string['rsstype'] = 'Umpan RSS untuk aktivitas ini';
$string['save'] = 'Simpan';
$string['saveandadd'] = 'Simpan dan tambahkan lainnya';
$string['saveandview'] = 'Simpan dan lihat';
$string['saveaspreset'] = 'Publikasikan preset di situs ini';
$string['saveaspreset_help'] = 'Fitur simpan sebagai preset menerbitkan templat dan ruas sebagai preset yang kemudian dapat digunakan orang lain di situs. (Anda dapat menghapusnya dari daftar preset kapan saja.)';
$string['saveaspresetmissingcapability'] = 'Pengguna tidak memiliki izin yang tepat untuk menyimpan basis data sebagai preset.';
$string['savedataaspreset'] = 'Simpan semua ruas dan templat dan publikasikan sebagai preset di situs ini';
$string['savesettings'] = 'Simpan setelan';
$string['savesuccess'] = 'Preset tersimpan. <a href="{$a->url}">Pratinjau preset</a>';
$string['savetemplate'] = 'Simpan templat';
$string['search'] = 'Cari';
$string['search:activity'] = 'Basis data - Informasi aktivitas';
$string['search:entry'] = 'Basis data - entri';
$string['searchresults'] = 'Entri yang mengandung "{$a}"';
$string['selectedrequired'] = 'Semua yang dipilih wajib diisi';
$string['selectexportoptions'] = 'Pilih opsi ekspor';
$string['selectfields'] = 'Pilih ruas';
$string['selectfordeletion'] = 'Pilih entri untuk dihapus';
$string['showall'] = 'Tampilkan semua entri';
$string['showmore'] = 'tampilkan lebih banyak';
$string['single'] = 'Tampilan Tunggal';
$string['singletemplate'] = 'Templat tampilan tunggal';
$string['singleview'] = 'Tampilan tunggal';
$string['startbuilding'] = 'Mulailah membangun aktivitas Anda';
$string['subplugintype_datafield'] = 'Tipe ruas basis data';
$string['subplugintype_datafield_plural'] = 'Tipe ruas basis data';
$string['subplugintype_datapreset'] = 'Preset';
$string['subplugintype_datapreset_plural'] = 'Preset';
$string['tagarea_data_records'] = 'Rekaman data';
$string['tags'] = 'Label';
$string['tagsdeleted'] = 'Label basis data telah dihapus';
$string['teachersandstudents'] = '{$a->teachers} dan {$a->students}';
$string['templatereset'] = 'Reset templat';
$string['templateresetall'] = 'Semua templat direset';
$string['templates'] = 'Templat';
$string['templatesaved'] = 'Templat tersimpan';
$string['templatesnavigation'] = 'Navigasi tersier templat';
$string['text'] = 'Teks';
$string['textarea'] = 'Area teks';
$string['timeadded'] = 'Waktu ditambahkan';
$string['timemodified'] = 'Waktu diperbarui';
$string['todatabase'] = 'untuk basis data ini.';
$string['type'] = 'TIpe ruas';
$string['undefinedprocessactionmethod'] = 'Tidak ada metode tindakan yang ditentukan di Data_Preset untuk menangani tindakan "{$a}".';
$string['unknown'] = 'ruas tidak diketahui';
$string['unsupportedfields'] = 'Ruas yang tidak didukung';
$string['unsupportedfieldslist'] = 'Ruas berikut tidak dapat diekspor:';
$string['updatefield'] = 'Perbarui ruas yang ada';
$string['uploadfile'] = 'Unggah berkas';
$string['uploadrecords'] = 'Impor entri';
$string['uploadrecords_help'] = 'Impor entri yang telah Anda ekspor dari basis data lain, baik melalui CSV atau ZIP yang berisi berkas CSV (jika berkas disertakan dalam ekspor).

Cara lainnya, untuk membuat berkas CSV untuk diimpor, tambahkan satu entri ke basis data, lalu ekspor. Edit berkas CSV dan tambahkan lebih banyak entri.';
$string['uploadrecords_link'] = 'mod/data/import';
$string['url'] = 'URL';
$string['usedate'] = 'Sertakan dalam pencarian.';
$string['usepredefinedset'] = 'Gunakan set yang telah ditentukan';
$string['usepreset'] = 'Gunakan preset';
$string['usestandard'] = 'Gunakan preset';
$string['usestandard_help'] = 'Untuk menggunakan preset yang tersedia untuk seluruh situs, pilih dari daftar. (Jika Anda telah menambahkan preset ke daftar menggunakan fitur simpan sebagai preset, maka Anda memiliki opsi untuk menghapusnya.)';
$string['viewfromdate'] = 'Hanya baca dari';
$string['viewnavigation'] = 'Lihat mode navigasi tersier';
$string['viewtemplates'] = 'Lihat templat';
$string['viewtodate'] = 'Hanya baca sampai';
$string['viewtodatevalidation'] = 'Tanggal mulai hanya baca tidak boleh sebelum tanggal hanya bacar berakhir.';
$string['wrongdataid'] = 'ID data yang diberikan salah';
