<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodlemobileapp', language 'lt', version '4.4'.
 *
 * @package     local_moodlemobileapp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addon.block_myoverview.browseallcourses'] = 'Naršyti visus kursus';
$string['addon.block_myoverview.nocoursesenrolled'] = 'Dar nesate įregistruoti į jokius kursus.';
$string['addon.block_myoverview.nocoursesenrolleddescription'] = 'Peržiūrėkite visus žemiau esančius kursus ir pradėkite mokytis.';
$string['addon.block_myoverview.noresult'] = 'Jūsų paieška neatitiko jokių kursų.';
$string['addon.block_myoverview.noresultdescription'] = 'Pabandykite pritaikyti filtrus arba toliau peržiūrėkite visus kursus.';
$string['addon.blog.errorloadentries'] = 'Klaida įkeliant tinklaraščio įrašus.';
$string['addon.blog.showonlyyourentries'] = 'Rodyti tik jūsų įrašus';
$string['addon.calendar.calendarevent'] = 'Kalendoriaus įvykis';
$string['addon.calendar.calendarevents'] = 'Kalendoriaus įvykiai';
$string['addon.calendar.calendarreminders'] = 'Kalendoriaus priminimai';
$string['addon.calendar.currentmonth'] = 'Dabartinis mėnuo';
$string['addon.calendar.defaultnotificationtime'] = 'Numatytasis pranešimo laikas';
$string['addon.calendar.errorloadevent'] = 'Klaida įkeliant įvykį.';
$string['addon.calendar.errorloadevents'] = 'Klaida įkeliant įvykius.';
$string['addon.calendar.monthlyview'] = 'Mėnesio vaizdas';
$string['addon.calendar.noevents'] = 'Įvykių nėra';
$string['addon.calendar.reminders'] = 'Priminimai';
$string['addon.calendar.setnewreminder'] = 'Nustatyti naują priminimą';
$string['addon.competency.errornocompetenciesfound'] = 'Kompetencijų nerasta';
$string['addon.competency.nocompetencies'] = 'Nėra kompetencijų';
$string['addon.coursecompletion.complete'] = 'Baigta';
$string['addon.coursecompletion.couldnotloadreport'] = 'Nepavyko įkelti kurso užbaigimo ataskaitos. Prašome pabandyti vėliau.';
$string['addon.enrol_self.confirmselfenrol'] = 'Ar tikrai norite įsiregistruoti į šį kursą?';
$string['addon.enrol_self.errorselfenrol'] = 'Savarankiškai registruojantis įvyko klaida.';
$string['addon.messageoutput_airnotifier.processorsettingsdesc'] = 'Konfigūruoti įrenginius';
$string['addon.messageoutput_airnotifier.pushdisabledwarning'] = 'Jūsų naudotojai negauna jokių pranešimų iš šios svetainės savo mobiliuosiuose įrenginiuose. Įjunkite mobiliuosius pranešimus pranešimų nustatymų puslapyje.';
$string['addon.messages.contactlistempty'] = 'Kontaktų sąrašas yra tuščias';
$string['addon.messages.contactname'] = 'Kontakto vardas';
$string['addon.messages.deletemessage'] = 'Ištrinti žinutę';
$string['addon.messages.deletemessageconfirmation'] = 'Ar tikrai norite ištrinti šią žinutę? Ji bus ištrinta tik iš jūsų žinučių istorijos ir ją vis dar galės matyti žinutę siuntęs arba gavęs naudotojas.';
$string['addon.messages.errordeletemessage'] = 'Klaida trinant žinutę.';
$string['addon.messages.errorwhileretrievingcontacts'] = 'Klaida nuskaitant kontaktus iš serverio.';
$string['addon.messages.errorwhileretrievingdiscussions'] = 'Klaida nuskaitant diskusijas iš serverio.';
$string['addon.messages.errorwhileretrievingmessages'] = 'Klaida nuskaitant žinutes iš serverio.';
$string['addon.messages.errorwhileretrievingusers'] = 'Klaida nuskaitant naudotojus iš serverio.';
$string['addon.messages.messagenotsent'] = 'Žinutė nebuvo išsiųsta. Prašome pabandyti vėliau.';
$string['addon.messages.newmessages'] = 'Naujos žinutės';
$string['addon.messages.nousersfound'] = 'Naudotojų nerasta';
$string['addon.messages.showdeletemessages'] = 'Rodyti ištrintas žinutes';
$string['addon.messages.type_blocked'] = 'Užblokuota';
$string['addon.messages.type_offline'] = 'Neprisjungę';
$string['addon.messages.type_online'] = 'Prisijungę';
$string['addon.messages.type_search'] = 'Paieškos rezultatai';
$string['addon.messages.type_strangers'] = 'Kiti';
$string['addon.messages.useentertosenddescdesktop'] = 'Jei ši funkcija išjungta, pranešimą galite išsiųsti naudodami Ctrl+Enter.';
$string['addon.messages.useentertosenddescmac'] = 'Jei ši funkcija išjungta, žinutę galite išsiųsti naudodami Cmd+Enter.';
$string['addon.messages.warningconversationmessagenotsent'] = 'Nepavyko išsiųsti žinutės (-čių) {{conversation}} pokalbyje. {{error}}';
$string['addon.messages.warningmessagenotsent'] = 'Nepavyko išsiųsti pranešimo (-ų) naudotojui {{naudotojas}}. {{{error}}';
$string['addon.mod_assign.acceptsubmissionstatement'] = 'Priimkite pateikimo išrašą.';
$string['addon.mod_assign.allowsubmissionsanddescriptionfromdatesummary'] = 'Išsamią informaciją apie užduotį ir jos pateikimo formą rasite <strong>{{{$a}}</strong>.';
$string['addon.mod_assign.allowsubmissionsfromdatesummary'] = 'Šį užduotis galės būti pateikta nuo <strong>{{$a}}</strong>';
$string['addon.mod_assign.cannoteditduetostatementsubmission'] = 'Programėlėje negalite pridėti arba redaguoti pateikimo, nes pateikimo išrašo nepavyko gauti iš svetainės.';
$string['addon.mod_assign.cannotgradefromapp'] = 'Keli vertinimo metodai nėra palaikomi programėlėje ir negali būti pakeisti.';
$string['addon.mod_assign.cannotsubmitduetostatementsubmission'] = 'Programėlėje negalite pateikti pateikimo, nes iš svetainės nepavyko gauti pateikimo išrašo.';
$string['addon.mod_assign.duedateno'] = 'Terminas nenurodytas';
$string['addon.mod_assign.erroreditpluginsnotsupported'] = 'Programėlėje negalite pridėti ar redaguoti pateikimo, nes tam tikri papildiniai dar nepalaikomi redagavimui.';
$string['addon.mod_assign.errorshowinginformation'] = 'Pateikimo informacijos parodyti negalima.';
$string['addon.mod_assign.feedbacknotsupported'] = 'Programėlė grįžtamojo ryšio nepalaiko ir negali pateikti visos informacijos.';
$string['addon.mod_assign.gradenotsynced'] = 'Įvertinimas nesinchronizuojamas';
$string['addon.mod_assign.notallparticipantsareshown'] = 'Dalyviai, kurie nepateikė pateikimų, nerodomi.';
$string['addon.mod_assign.numberofdraftsubmissionscountdescription'] = 'Yra {{count}} juodraščių.';
$string['addon.mod_assign.numberofparticipantscountdescription'] = 'Yra {{count}} dalyvių.';
$string['addon.mod_assign.numberofsubmissionsneedgradingcountdescription'] = 'Yra  {{count}} pateiktų darbų, kuriuos reikia įvertinti.';
$string['addon.mod_assign.numberofsubmittedassignmentscountdescription'] = 'Yra {{{count}} pateiktų užduočių.';
$string['addon.mod_assign.numberofteamscountdescription'] = 'Yra {{{count}} komandų.';
$string['addon.mod_assign.submissionnotsupported'] = 'Šis pateikimas nėra palaikomas programėlės ir jame gali būti pateikta ne visa informacija.';
$string['addon.mod_assign.syncblockedusercomponent'] = 'naudotojo įvertinimas';
$string['addon.mod_assign.warningsubmissiongrademodified'] = 'Pateikimo įvertinimas buvo pakeistas svetainėje.';
$string['addon.mod_assign.warningsubmissionmodified'] = 'Naudotojo pateikimas buvo pakeistas svetainėje.';
$string['addon.mod_chat.confirmloss'] = 'Ar esate tikri? Pokalbių istorija gali būti prarasta.';
$string['addon.mod_chat.errorwhileconnecting'] = 'Klaida jungiantis prie pokalbio.';
$string['addon.mod_chat.errorwhilegettingchatdata'] = 'Klaida gaunant pokalbio duomenis.';
$string['addon.mod_chat.errorwhilegettingchatusers'] = 'Klaida gaunant pokalbio dalyvius.';
$string['addon.mod_chat.errorwhileretrievingmessages'] = 'Klaida gaunant žinutes iš serverio.';
$string['addon.mod_chat.errorwhilesendingmessage'] = 'Klaida siunčiant žinutę.';
$string['addon.mod_chat.mustbeonlinetosendmessages'] = 'Norėdami siųsti žinutes, turite būti prisijungę.';
$string['addon.mod_chat.nosessionsfound'] = 'Sesijų nerasta';
$string['addon.mod_chat.showincompletesessions'] = 'Rodyti nebaigtas sesijas';
$string['addon.mod_choice.errorgetchoice'] = 'Klaida gaunant pasirinkimo duomenis.';
$string['addon.mod_choice.responsesresultgraphdescription'] = '{{number}}% naudotojų pasirinko šią parinktį: {{text}}.';
$string['addon.mod_choice.resultsnotsynced'] = 'Jūsų paskutinis atsakymas turi būti sinchronizuotas, kad būtų įtrauktas į rezultatus.';
$string['addon.mod_data.edittagsnotsupported'] = 'Atsiprašome, programėlė nepalaiko žymų redagavimo.';
$string['addon.mod_data.errorapproving'] = 'Klaida tvirtinant arba netvirtinant įrašo.';
$string['addon.mod_data.errordeleting'] = 'Klaida trinant įrašą.';
$string['addon.mod_data.gettinglocation'] = 'Vietos nustatymas';
$string['addon.mod_data.locationnotenabled'] = 'Vieta neįjungta';
$string['addon.mod_data.locationpermissiondenied'] = 'Leidimas pasiekti jūsų buvimo vietą buvo atmestas.';
$string['addon.mod_data.mylocation'] = 'Mano vieta';
$string['addon.mod_data.searchbytagsnotsupported'] = 'Atsiprašome, programėlė nepalaiko paieškos pagal žymas.';
$string['addon.mod_feedback.captchaofflinewarning'] = 'Grįžtamojo ryšio su CAPTCHA negalima užpildyti neprisijungus prie interneto arba jei jis nesukonfigūruotas, arba jei serveris neveikia.';
$string['addon.mod_feedback.completedfeedbackscountdescription'] = 'Yra {{count}} pateiktų atsakymų.';
$string['addon.mod_feedback.feedback_submitted_offline'] = 'Šis atsiliepimas buvo išsaugotas, kad būtų pateiktas vėliau.';
$string['addon.mod_feedback.questionscountdescription'] = 'Yra {{count}} klausimų';
$string['addon.mod_folder.emptyfilelist'] = 'Nėra rodomų failų.';
$string['addon.mod_forum.errorgetforum'] = 'Klaida gaunant forumo duomenis.';
$string['addon.mod_forum.errorgetgroups'] = 'Klaida gaunant grupės nustatymus.';
$string['addon.mod_forum.errorloadingsortingorder'] = 'Forumas neprieinamas šia rūšiavimo tvarka';
$string['addon.mod_forum.errorloadingsortingorderdetails'] = 'Pabandykite pakeisti rūšiavimo tvarką arba eikite į internetą ir peržiūrėkite šį forumą.';
$string['addon.mod_forum.errorposttoallgroups'] = 'Nepavyko sukurti naujos diskusijos visoms grupėms.';
$string['addon.mod_forum.forumnodiscussionsyet'] = 'Šiame forume dar nėra diskusijų.';
$string['addon.mod_forum.group'] = 'Grupė';
$string['addon.mod_forum.numdiscussions'] = '{{numdiscussions}} diskusijos';
$string['addon.mod_forum.numreplies'] = '{{numreplies}} atsakymų';
$string['addon.mod_forum.postingroup'] = 'Skelbiama grupėje „{{groupname}}“.';
$string['addon.mod_forum.refreshposts'] = 'Atnaujinti įrašus';
$string['addon.mod_glossary.browsemode'] = 'Peržiūrėti įrašus';
$string['addon.mod_glossary.byalphabet'] = 'Pagal abėcėlę';
$string['addon.mod_glossary.byauthor'] = 'Pagal autorių';
$string['addon.mod_glossary.bycategory'] = 'Pagal kategoriją';
$string['addon.mod_glossary.bynewestfirst'] = 'Pirma naujausi';
$string['addon.mod_glossary.byrecentlyupdated'] = 'Neseniai atnaujinti';
$string['addon.mod_glossary.bysearch'] = 'Paieška';
$string['addon.mod_glossary.cannoteditentry'] = 'Negalima redaguoti įrašo';
$string['addon.mod_glossary.entriestobesynced'] = 'Įrašai, kuriuos reikia sinchronizuoti';
$string['addon.mod_glossary.entrypendingapproval'] = 'Šis įrašas laukia patvirtinimo.';
$string['addon.mod_glossary.errordeleting'] = 'Klaida trinant įrašą.';
$string['addon.mod_glossary.errorloadingentries'] = 'Klaida keliant įrašus.';
$string['addon.mod_glossary.errorloadingentry'] = 'Klaida įkeliant įrašą.';
$string['addon.mod_glossary.errorloadingglossary'] = 'Klaida įkeliant žodynėlį.';
$string['addon.mod_glossary.noentriesfound'] = 'Įrašų nėra.';
$string['addon.mod_glossary.searchquery'] = 'Paieškos užklausa';
$string['addon.mod_h5pactivity.downloadh5pfile'] = 'Atsisiųsti H5P failą';
$string['addon.mod_h5pactivity.errorgetactivity'] = 'Klaida gaunant H5P veiklos duomenis.';
$string['addon.mod_h5pactivity.filestatenotdownloaded'] = 'H5P paketas nebuvo atsisiųstas. Kad galėtumėte jį naudoti, turite jį atsisiųsti.';
$string['addon.mod_h5pactivity.filestateoutdated'] = 'Nuo paskutinio atsisiuntimo H5P paketas buvo pakeistas. Kad galėtumėte jį naudoti, turite jį atsisiųsti iš naujo.';
$string['addon.mod_h5pactivity.offlinedisabledwarning'] = 'Norėdami peržiūrėti H5P paketą, turite būti prisijungę.';
$string['addon.mod_h5pactivity.viewattempt'] = 'Peržiūrėti bandymą {{$a}}';
$string['addon.mod_imscp.showmoduledescription'] = 'Rodyti aprašymą';
$string['addon.mod_lesson.errorprefetchrandombranch'] = 'Šioje pamokoje yra peršokimas į atsitiktinį turinio puslapį. Jo negalima bandyti atlikti programėlėje, kol ji nepradėta naudoti interneto naršyklėje.';
$string['addon.mod_lesson.errorreviewretakenotlast'] = 'Šis bandymas nebegali būti peržiūrėtas, nes baigtas kitas bandymas.';
$string['addon.mod_lesson.finishretakeoffline'] = 'Šis bandymas buvo baigtas neprisijungus.';
$string['addon.mod_lesson.retakefinishedinsync'] = 'Bandymas neprisijungus sinchronizuotas. Ar norite jį peržiūrėti?';
$string['addon.mod_lesson.retakelabelfull'] = '{{retake}}: {{grade}} {{timestart}} ({{duration}})';
$string['addon.mod_lesson.retakelabelshort'] = '{{retake}}: {{grade}} {{timestart}}';
$string['addon.mod_lesson.warningretakefinished'] = 'Bandymas buvo baigtas svetainėje.';
$string['addon.mod_lti.errorgetlti'] = 'Klaida gaunant modulio duomenis.';
$string['addon.mod_lti.errorinvalidlaunchurl'] = 'Paleidimo URL negalioja.';
$string['addon.mod_lti.launchactivity'] = 'Paleisti veiklą';
$string['addon.mod_page.errorwhileloadingthepage'] = 'Klaida įkeliant puslapio turinį.';
$string['addon.mod_quiz.canattemptbutnotsubmit'] = 'Šį testą galite bandyti atlikti programėlėje, tačiau bandymą reikės pateikti naršyklėje dėl toliau nurodytų priežasčių:';
$string['addon.mod_quiz.cannotsubmitquizdueto'] = 'Šio testo bandymo negalima pateikti dėl šių priežasčių:';
$string['addon.mod_quiz.confirmcontinueoffline'] = 'Šis bandymas nebuvo sinchronizuotas nuo {{$a}}. Jei nuo to laiko tęsėte šį bandymą kitame įrenginyje, galite prarasti duomenis.';
$string['addon.mod_quiz.confirmleavequizonerror'] = 'Išsaugant atsakymus įvyko klaida. Ar tikrai norite palikti testą?';
$string['addon.mod_quiz.errorbehaviournotsupported'] = 'Šis testas negali būti bandomas programėlėje, nes programėlė nepalaiko klausimų elgsenos:';
$string['addon.mod_quiz.errordownloading'] = 'Klaida atsisiunčiant reikiamus duomenis.';
$string['addon.mod_quiz.errorgetattempt'] = 'Klaida gaunant bandymo duomenis.';
$string['addon.mod_quiz.errorgetquestions'] = 'Klaida gaunant klausimus.';
$string['addon.mod_quiz.errorgetquiz'] = 'Klaida gaunant testo duomenis.';
$string['addon.mod_quiz.errorparsequestions'] = 'Skaitant klausimus įvyko klaida. Bandykite atlikti šį testą interneto naršyklėje.';
$string['addon.mod_quiz.errorquestionsnotsupported'] = 'Šio testo negalima bandyti atlikti programėlėje, nes joje yra programėlėje nepalaikomų klausimų:';
$string['addon.mod_quiz.errorrulesnotsupported'] = 'Šio testo negalima bandyti atlikti programėlėje, nes jo prieigos taisyklės nepalaikomos programėlėje:';
$string['addon.mod_quiz.errorsaveattempt'] = 'Išsaugant bandymo duomenis įvyko klaida.';
$string['addon.mod_quiz.finishedofflinenotice'] = 'Jūsų bandymas buvo pateiktas ir išsaugotas. Jis bus išsiųstas į svetainę, kai vėl būsite prisijungę.';
$string['addon.mod_quiz.finishnotsynced'] = 'Baigta, bet nesinchronizuota';
$string['addon.mod_quiz.opentoc'] = 'Atidaryti naršymo skirtuką';
$string['addon.mod_quiz.warningattemptfinished'] = 'Bandymas neprisijungus prie interneto atmestas, nes jis buvo baigtas svetainėje arba nerastas.';
$string['addon.mod_quiz.warningdatadiscarded'] = 'Kai kurie atsakymai neprisijungus prie interneto buvo atmesti, nes klausimai buvo pakeisti internetu.';
$string['addon.mod_quiz.warningdatadiscardedfromfinished'] = 'Bandymas nebaigtas, nes kai kurie atsakymai neprisijungus buvo atmesti. Peržiūrėkite savo atsakymus ir iš naujo pateikite bandymą.';
$string['addon.mod_quiz.warningquestionsnotsupported'] = 'Šiame teste yra klausimų, kurių programėlė nepalaiko:';
$string['addon.mod_resource.errorwhileloadingthecontent'] = 'Klaida įkeliant turinį.';
$string['addon.mod_resource.openthefile'] = 'Atidaryti';
$string['addon.mod_resource.resourcestatusoutdated'] = 'Šis failas pasikeitė nuo tada, kai paskutinį kartą jį atidarėte.';
$string['addon.mod_resource.resourcestatusoutdatedconfirm'] = 'Yra naujesnė šio failo versija. Norėdami jį peržiūrėti, prijunkite įrenginį prie interneto.';
$string['addon.mod_scorm.cannotcalculategrade'] = 'Negalima apskaičiuoti įvertinimo.';
$string['addon.mod_scorm.dataattemptshown'] = 'Duomenys priklauso bandymui Nr. {{number}}.';
$string['addon.mod_scorm.errorcreateofflineattempt'] = 'Kuriant naują bandymą neprisijungus prie interneto įvyko klaida. Bandykite dar kartą.';
$string['addon.mod_scorm.errordownloadscorm'] = 'Klaida atsiunčiant SCORM: „{{name}}“.';
$string['addon.mod_scorm.errorgetscorm'] = 'Klaida gaunant SCORM duomenis.';
$string['addon.mod_scorm.errorinvalidversion'] = 'Atsiprašome, programėlė palaiko tik SCROM 1.2. versiją.';
$string['addon.mod_scorm.errornotdownloadable'] = 'Jūsų mokykla arba mokymosi paslaugų teikėjas išjungė SCORM paketų atsisiuntimą.';
$string['addon.mod_scorm.errornovalidsco'] = 'Šiame SCORM pakete nėra matomo SCO, kurį būtų galima įkelti.';
$string['addon.mod_scorm.errorpackagefile'] = 'Atsiprašome, programėlė palaiko tik ZIP paketus.';
$string['addon.mod_scorm.errorsyncscorm'] = 'Sinchronizuojant įvyko klaida. Bandykite dar kartą.';
$string['addon.mod_scorm.offlineattemptnote'] = 'Šis bandymas turi duomenų, kurie nebuvo sinchronizuoti.';
$string['addon.mod_scorm.offlineattemptovermax'] = 'Šis bandymas negali būti išsiųstas, nes viršijote maksimalų bandymų skaičių.';
$string['addon.mod_scorm.scormstatusnotdownloaded'] = 'Šis SCORM paketas nėra atsisiunčiamas. Jis bus atsisiųstas automatiškai, kai jį atidarysite.';
$string['addon.mod_scorm.scormstatusoutdated'] = 'Nuo paskutinio atsisiuntimo šis SCORM paketas buvo pakeistas. Jis bus automatiškai atsisiųstas, kai jį atidarysite.';
$string['addon.mod_scorm.warningofflinedatadeleted'] = 'Kai kurie neprijungti  bandymo {{number}} duomenys  buvo ištrinti, nes jie negalėjo būti perkelti į naują bandymą.';
$string['addon.mod_scorm.warningsynconlineincomplete'] = 'Kaikurie bandymai negali būti sinchronizuoti su svetaine dėl to, kad paskutiniai prisijungimo duomenys nebuvo pabaigti. Prašome pabaigti.';
$string['addon.mod_survey.cannotsubmitsurvey'] = 'Atsiprašome, kilo problemų pateikiant apklausą. Prašome pabandyti dar kartą.';
$string['addon.mod_survey.errorgetsurvey'] = 'Apklausos duomenų gavimo klaida.';
$string['addon.mod_survey.results'] = 'Rezultatai';
$string['addon.mod_url.accessurl'] = 'URL prieiga';
$string['addon.mod_url.pointingtourl'] = 'URL, į kurį nukreipia išteklius.';
$string['addon.mod_wiki.errorloadingpage'] = 'Įkeliant puslapį įvyko klaida.';
$string['addon.mod_wiki.errornowikiavailable'] = 'Šiame viki dar nėra jokio turinio.';
$string['addon.mod_wiki.gowikihome'] = 'Eiti į pirmąjį viki puslapį';
$string['addon.mod_wiki.subwiki'] = 'Sub-vikis';
$string['addon.mod_wiki.titleshouldnotbeempty'] = 'Pavadinimo eilutė neturi būti tuščia';
$string['addon.mod_wiki.viewpage'] = 'Peržiūrėti puslapį';
$string['addon.mod_wiki.wikipage'] = 'Wiki puslapis';
$string['addon.mod_workshop.assessmentstrategynotsupported'] = 'Vertinimo strategija {{$a}} nepalaikoma';
$string['addon.mod_workshop.submissionrequiredtitle'] = 'Reikia įvesti pavadinimą.';
$string['addon.mod_workshop.warningassessmentmodified'] = 'Pateikimas buvo pakeistas svetainėje.';
$string['addon.mod_workshop.warningsubmissionmodified'] = 'Įvertinimas buvo pakeistas svetainėje.';
$string['addon.notes.warningnotenotsent'] = 'Nepavyko pridėti arba ištrinti pastabos (-ų). {{error}}';
$string['addon.notifications.allownotifications'] = 'Leisti pranešimus';
$string['addon.notifications.errorgetnotifications'] = 'Klaida gaunant pranešimus.';
$string['addon.notifications.notifications'] = 'Pranešimai';
$string['addon.notifications.playsound'] = 'Groti garsą';
$string['addon.notifications.therearentnotificationsyet'] = 'Pranešimų nėra.';
$string['addon.notifications.typeofnotification'] = 'Pranešimo tipas';
$string['addon.privatefiles.couldnotloadfiles'] = 'Nepavyko įkelti failų sąrašo.';
$string['addon.privatefiles.emptyfilelist'] = 'Nėra rodomų failų.';
$string['addon.privatefiles.erroruploadnotworking'] = 'Deja, šiuo metu nėra galimybės įkelti failų į jūsų svetainę.';
$string['addon.storagemanager.confirmdeleteallsitedata'] = 'Ištrinti visus svetainės atsisiųstus duomenis?';
$string['addon.storagemanager.confirmdeletedatafrom'] = 'Ištrinti visus atsisiųstus duomenis iš „{{name}}“?';
$string['addon.storagemanager.coursedownloads'] = 'Kurso atsisiuntimai';
$string['addon.storagemanager.deleteallsitedata'] = 'Ištrinti visus svetainės atsisiųstus duomenis';
$string['addon.storagemanager.deletedata'] = 'Ištrinti atsisiųstus duomenis';
$string['addon.storagemanager.downloaddatafrom'] = 'Atsisiųsti {{name}}';
$string['addon.storagemanager.downloadedcourses'] = 'Atsisiųsti kursai';
$string['addon.storagemanager.downloads'] = 'Atsisiuntimai';
$string['addon.storagemanager.managedownloads'] = 'Tvarkyti atsisiuntimus';
$string['addon.storagemanager.totaldownloads'] = 'Visi atsisiuntimai';
$string['appstoredescription'] = 'PASTABA: Ši oficiali Moodle Mobile App veiks TIK per Moodle svetaines, kurios buvo sukurtos gavus leidimą. Jei yra kokių nors prisijungimo problemų, prašome kreiptis į savo Moodle administratorių.

Jei jūsų Moodle svetainė sukonfigūruota teisingai, šią programą galite naudoti:

-	naršyti po savo kursų turinį net  neprisijungę;
-	gauti momentinius pranešimus ar  informaciją apie kitus renginius;
-	greitai rasti ir susisiekti su kitais jūsų kursų žmonėmis;
-	įkelti nuotraukas, garso, vaizdo ir kitus failus iš savo mobiliojo prietaiso;
-	peržiūrėti savo kursų klases;
-	ir dar daugiau!

Visą naujausią informaciją rasite: http://docs.moodle.org/en/Mobile_app

Mes labai vertiname gerus atsiliepimus apie  šios programos funkcionalumą, tad siųskite mums pasiūlymus, ką dar norėtumėte daryti šioje programoje!

Šiam App veikti reikalingos šios programinės prieigos:
Garso įrašų – įrašus įkelti į Moodle;
Galimybė skaityti ir keisti savo SD kortelės turinį – jis bus perkeltas į SD kortelę, todėl jūs galėsite matyti jį net neprisijungę;
Tinklo prieiga, kad galėtumėte susisiekti su savo Moodle svetaine ir patikrinti, ar esate prijungtas, ar ne, pereiti prie rėžimo „Neprisijungęs“;
Paleisti programą esant įjungtam telefonui – gauti pranešimus, net app esant ekrano  fone;
Neleisti telefonui užmigti – gausite naujienas ar pranešimus bet kuriuo metu.';
$string['assets.mimetypes.application/vnd.google-apps.audio'] = 'Google Disko garso įrašai';
$string['assets.mimetypes.application/vnd.google-apps.document'] = 'Google Dokumentai';
$string['assets.mimetypes.application/vnd.google-apps.file'] = '„Google“ disko failas';
$string['assets.mimetypes.application/vnd.google-apps.folder'] = '„Google“ disko aplankas';
$string['assets.mimetypes.application/vnd.google-apps.form'] = '„Google“ formos';
$string['assets.mimetypes.application/vnd.google-apps.presentation'] = '„Google“ skaidrės';
$string['assets.mimetypes.application/vnd.google-apps.site'] = '„Google“ svetainės';
$string['assets.mimetypes.application/vnd.google-apps.spreadsheet'] = '„Google“ lentelės';
$string['assets.mimetypes.application/vnd.google-apps.video'] = '„Google Drive“ vaizdo įrašai';
$string['core.browser'] = 'Naršyklė';
$string['core.calculating'] = 'Skaičiavimas';
$string['core.cannotconnect'] = 'Nepavyksta prisijungti prie svetainės';
$string['core.cannotdownloadfiles'] = 'Jūsų mokykla arba mokymosi paslaugų teikėjas išjungė failų atsisiuntimo funkciją.';
$string['core.captureaudio'] = 'Garso įrašymas';
$string['core.clearsearch'] = 'Išvalyti peišką';
$string['core.clearstoreddata'] = 'Išvalyti saugyklą {{$a}}';
$string['core.clicktoseefull'] = 'Spustelėkite, jei norite pamatyti visą turinį.';
$string['core.comments.warningcommentsnotsent'] = 'Nepavyko sinchronizuoti komentarų. {{error}}';
$string['core.confirmcanceledit'] = 'Ar tikrai norite palikti šį puslapį? Visi pakeitimai bus prarasti.';
$string['core.confirmloss'] = 'Ar tikrai? Visi pakeitimai bus prarasti.';
$string['core.confirmopeninbrowser'] = 'Ar norite tai atidaryti naršyklėje?';
$string['core.connectionlost'] = 'Nutrūko ryšys su svetaine';
$string['core.contactsupport'] = 'Susisiekti su palaikymo komanda';
$string['core.contenteditingsynced'] = 'Turinys, kurį taisote, sinchronizuojamas.';
$string['core.contentlinks.chooseaccount'] = 'Pasirinkti paskyrą';
$string['core.contentlinks.chooseaccounttoopenlink'] = 'Pasirinkite paskyrą, su kuria atidarysite nuorodą.';
$string['core.contentlinks.confirmurlothersite'] = 'Nuoroda priklauso kitai svetainei. Ar norite ją atidaryti?';
$string['core.contentlinks.errornoactions'] = 'Nepavyko atlikti veiksmo su šia nuoroda.';
$string['core.contentlinks.errornosites'] = 'Nepavyko rasti svetainės šiuo adresu.';
$string['core.copiedtoclipboard'] = 'Tekstas nukopijuotas į iškarpinę';
$string['core.copytoclipboard'] = 'Kopijuoti į iškarpinę';
$string['core.course.activitynotyetviewableremoteaddon'] = 'Jūsų įstaiga įdiegė papildinį, kuris dar nėra palaikomas.';
$string['core.course.allsections'] = 'Visos sekcijos';
$string['core.course.aria:sectionprogress'] = 'Dalies pažanga:';
$string['core.course.confirmdownload'] = 'Norite atsisiųsti {{size}}. {{availableSpace}} Ar norite tęsti?';
$string['core.course.confirmdownloadunknownsize'] = 'Negalima apskaičiuoti failo, kurį norite atsisiųsti, dydžio. Ar tikrai norite atsisiųsti?';
$string['core.course.confirmdownloadzerosize'] = 'Netrukus pradėsite atsisiuntimą.{{availableSpace}} Ar tikrai norite tęsti?';
$string['core.course.confirmlimiteddownload'] = 'Šiuo metu nesate prisijungę prie „Wi-Fi“.';
$string['core.course.confirmpartialdownloadsize'] = 'Jūs ruošiatės atsisiųsti <strong>mažiausiai</strong> {{size}}.{{availableSpace}} Ar tikrai norite tęsti?';
$string['core.course.couldnotloadsectioncontent'] = 'Nepavyko įkelti dalies turinio. Prašome pabandyti vėliau.';
$string['core.course.couldnotloadsections'] = 'Nepavyko įkelti dalių. Prašome pabandyti vėliau.';
$string['core.course.downloadcoursesprogressdescription'] = 'Atsisiunčiami kursai: atsisiųsta {{count}} iš {{total}}.';
$string['core.course.downloadsectionprogressdescription'] = 'Atsisiunčiamos dalys: atsisiųsta {{count}} iš {{total}}.';
$string['core.course.errordownloadingcourse'] = 'Klaida atsisiunčiant kursą.';
$string['core.course.errordownloadingsection'] = 'Klaida atsisiunčiant dalį.';
$string['core.course.errorgetmodule'] = 'Klaida gaunant veiklos duomenis.';
$string['core.course.lastaccessedactivity'] = 'Paskutinė aplankyta veikla';
$string['core.course.manualcompletionnotsynced'] = 'Rankinis užbaigimas nesinchronizuojamas.';
$string['core.course.modulenotfound'] = 'Išteklius arba veikla nerasta, patikrinkite, ar esate prisijungę ir ar ji vis dar prieinama.';
$string['core.course.nextactivity'] = 'Kita veikla';
$string['core.course.nextactivitynotfound'] = 'Kita veikla nerasta. Gali būti, kad ji buvo paslėpta arba ištrinta.';
$string['core.course.nocontentavailable'] = 'Šiuo metu turinio nėra.';
$string['core.course.previousactivity'] = 'Ankstesnė veikla';
$string['core.course.previousactivitynotfound'] = 'Ankstesnė veikla nerasta. Gali būti, kad ji buvo paslėpta arba ištrinta.';
$string['core.course.refreshcourse'] = 'Atnaujinti kursą';
$string['core.course.useactivityonbrowser'] = 'Galite naudoti savo naršyklėje.';
$string['core.coursenogroups'] = 'Nesate nė vienos šio kurso grupės narys.';
$string['core.courses.downloadcourses'] = 'Atsisiųsti visus kursus';
$string['core.courses.enrolme'] = 'Įregistruoti mane';
$string['core.courses.errorloadcategories'] = 'Įkeliant kategorijas įvyko klaida.';
$string['core.courses.errorloadcourses'] = 'Įkeliant kursus įvyko klaida.';
$string['core.courses.errorsearching'] = 'Paieškos klaida.';
$string['core.courses.filtermycourses'] = 'Filtruoti mano kursus';
$string['core.courses.notenrollable'] = 'Negalite įsiregistruoti į šį kursą.';
$string['core.courses.password'] = 'Įsirašymo raktas';
$string['core.courses.refreshcourses'] = 'Atnaujinti kursus';
$string['core.courses.searchcoursesadvice'] = 'Jūs galite naudoti kursų paieškos mygtuką ieškant kursų su svečio prieiga arba įrašyti save į kursus, kurie yra prieinami.';
$string['core.courses.totalcoursesearchresults'] = 'Visi kursai: {{$a}}';
$string['core.currentdevice'] = 'Dabartinis įrenginys';
$string['core.datastoredoffline'] = 'Duomenys saugomi įrenginyje, nes šiuo metu negalima išsiųsti. Bus vėlaiu išsiųsti automatiškai.';
$string['core.deletedoffline'] = 'Ištrinta neprisijungus';
$string['core.deleting'] = 'Trinama';
$string['core.desktop'] = 'Darbalaukis';
$string['core.dfdaymonthyear'] = 'YYYY-MM-DD';
$string['core.dfdayweekmonth'] = 'MMM D, ddd';
$string['core.dflastweekdate'] = 'ddd';
$string['core.dfmediumdate'] = 'LLL';
$string['core.dftimedate'] = 'v:mm';
$string['core.discard'] = 'Atmesti';
$string['core.dismiss'] = 'Atmesti';
$string['core.dontshowagain'] = 'Daugiau nerodyti.';
$string['core.downloaded'] = 'Atsisiųsta';
$string['core.downloading'] = 'Siunčiama';
$string['core.editor.hidetoolbar'] = 'Slėpti įrankių juostą';
$string['core.editor.toggle'] = 'Perjungti redaktorių';
$string['core.endingtime'] = 'Pabaigos laikas: {{$a}}';
$string['core.errorchangecompletion'] = 'Klaida keičiant baigimo būseną. Pabandykite dar kartą.';
$string['core.errorcode'] = 'Klaidos kodas: {{errorCode}}';
$string['core.errordeletefile'] = 'Klaida trinant failą. Bandykite dar kartą.';
$string['core.errordetailshide'] = 'Slėpti klaidos informaciją';
$string['core.errordetailsshow'] = 'Rodyti klaidos informaciją';
$string['core.errordownloading'] = 'Klaida atsisiunčiant failą.';
$string['core.errordownloadingsomefiles'] = 'Klaida atsisiunčiant failus. Jų gali trūkti.';
$string['core.errorfileexistssamename'] = 'Failas tokiu pavadinimu jau yra.';
$string['core.errorinvalidform'] = 'Formoje trūksta duomenų. Prašome užpildyti visus būtinus laukus galiojančia informacija.';
$string['core.errorinvalidresponse'] = 'Gautas neteisingas atsakas. Susisiekite su Moodle administratoriumi jeigu tai kartojasi.';
$string['core.errorloadingcontent'] = 'Klaida įkeliant turinį.';
$string['core.errorofflinedisabled'] = 'Jūsų svetainėje išjungtas naršymas neprisijungus prie interneto. Norėdami naudotis programėle, turite būti prisijungę prie interneto.';
$string['core.erroropenfiledownloading'] = 'Klaida atidarant failą: reikia palaukti, kol atsisiuntimas bus baigtas.';
$string['core.erroropenfilenoapp'] = 'Klaida atidarant failą: nėra tinkamos programėlės jam atidaryti.';
$string['core.erroropenfilenoextension'] = 'Klaida atidarant failą: jis neturi plėtinio.';
$string['core.erroropenpopup'] = 'Šis veiksmas bus atidarytas atskirame lange. Programėlė to nepalaiko.';
$string['core.errorrenamefile'] = 'Klaida pervadinant failą. Bandykite dar kartą.';
$string['core.errorsitesupport'] = 'Jei problema išlieka, kreipkitės į svetainės palaikymo komandą.';
$string['core.errorsync'] = 'Klaida sinchronizuojant. Bandykite dar kartą.';
$string['core.errorsyncblocked'] = 'Dėl tebevykstančių procesų {{$a}} negali būti sinchronizuojama dabar. Bandykite dar kartą. Jei nepavyksta, bandykite iš naujo paleisti programą.';
$string['core.exactalarmsturnedoff'] = 'Realaus laiko pranešimai išjungti';
$string['core.filedeletedsuccessfully'] = 'Sėkmingai ištrynėte „{{filename}}“';
$string['core.filenameexist'] = 'Failas tokiu pavadinimu jau yra: {{$a}}';
$string['core.fileuploader.audio'] = 'Garsas';
$string['core.fileuploader.camera'] = 'Kamera';
$string['core.fileuploader.confirmuploadfile'] = 'Ketinate įkelti {{size}}. Ar tikrai norite tęsti?';
$string['core.fileuploader.confirmuploadunknownsize'] = 'Negalima apskaičiuoti failo, kurį norite įkelti, dydžio. Ar tikrai norite tęsti?';
$string['core.fileuploader.errorcapturingaudio'] = 'Klaida įrašant garsą.';
$string['core.fileuploader.errorcapturingimage'] = 'Klaida darant paveiksliuką.';
$string['core.fileuploader.errorcapturingvideo'] = 'Klaida įrašant video.';
$string['core.fileuploader.errorgettingimagealbum'] = 'Klaida gaunant paveiksliuką iš albumo.';
$string['core.fileuploader.errormustbeonlinetoupload'] = 'Norėdami įkelti failus, turite būti prisijungę prie interneto.';
$string['core.fileuploader.errornoapp'] = 'Jūs neturite programėlės šiam veiksmui atlikti.';
$string['core.fileuploader.errorreadingfile'] = 'Klaida nuskaitant failą.';
$string['core.fileuploader.errorwhileuploading'] = 'Klaida įkeliant failą.';
$string['core.fileuploader.file'] = 'Failas';
$string['core.fileuploader.fileuploaded'] = 'Failas sėkmingai įkeltas.';
$string['core.fileuploader.maxbytesfile'] = 'Failas {{$a.file}} ) per didelis. Galite įkelti failus iki {{$a.size}}.';
$string['core.fileuploader.microphonepermissiondenied'] = 'Leidimas prisijungti prie mikrofono buvo atmestas.';
$string['core.fileuploader.microphonepermissionrestricted'] = 'Prieiga prie mikrofono yra ribota.';
$string['core.fileuploader.pauserecording'] = 'Pristabdyti įrašymą';
$string['core.fileuploader.photoalbums'] = 'Nuotraukų albumai';
$string['core.fileuploader.readingfile'] = 'Skaitomas failas';
$string['core.fileuploader.readingfileperc'] = 'Skaitomas failas: {{$a}}%';
$string['core.fileuploader.resumerecording'] = 'Atnaujinti įrašymą';
$string['core.fileuploader.selectafile'] = 'Pasirinkite failą';
$string['core.fileuploader.startrecordinginstructions'] = 'Spragtelėkite, kad pradėti įrašymą';
$string['core.fileuploader.uploadafile'] = 'Įkelti failą';
$string['core.fileuploader.uploading'] = 'Įkeliama';
$string['core.fileuploader.uploadingperc'] = 'Įkeliama: {{$a}}%';
$string['core.fileuploader.video'] = 'Video';
$string['core.fullnameandsitename'] = '{{fullname}} ({{sitename}})';
$string['core.goto'] = 'Eiti į {{$a}}';
$string['core.h5p.errorgetemail'] = 'Klaida gaunant naudotojo el. pašto adresą. Patikrinkite ryšį ir bandykite dar kartą.';
$string['core.h5p.offlinedisabled'] = 'Svetainė neleidžia atsisiųsti H5P paketų.';
$string['core.h5p.play'] = 'Paleisti H5P';
$string['core.hasdatatosync'] = '{{$a}} turi duomenis, kuriuos reikia sinchronizuoti.';
$string['core.humanreadablesize'] = '{{size}} {{unit}}';
$string['core.iframehelp'] = 'Ar šis turinys neveikia?';
$string['core.image'] = 'Paveiksliukas';
$string['core.imageviewer'] = 'Paveiksliukų peržiūra';
$string['core.lastdownloaded'] = 'Paskutinį kartą atsisiųsta';
$string['core.lastsync'] = 'Paskutinis sinchronizavimas';
$string['core.loadmore'] = 'Rodyti daugiau';
$string['core.login.authenticating'] = 'Autentifikuojama';
$string['core.login.changepasswordbutton'] = 'Keisti slaptažodį';
$string['core.login.changepasswordhelp'] = 'Jei nepavyksta pakeisti slaptažodžio, pabandykite tai padaryti vėliau arba kreipkitės į mokyklą ar mokymosi paslaugų teikėją.';
$string['core.login.changepasswordreconnectinstructions'] = 'Jei neteisingai pakeitėte slaptažodį, būsite paprašyti tai padaryti dar kartą.';
$string['core.login.changepasswordsupportsubject'] = 'Reikia pagalbos keičiant slaptažodį';
$string['core.login.confirmdeletesite'] = 'Ar tikrai norite pašalinti paskyrą iš {{sitename}}?';
$string['core.login.connect'] = 'Prisijungta!';
$string['core.login.connecttomoodle'] = 'Prisijungti prie Moodle';
$string['core.login.connecttomoodleapp'] = 'Bandote prisijungti prie įprastos „Moodle“ svetainės. Norėdami prisijungti prie šios svetainės, atsisiųskite oficialią „Moodle“ programėlę.';
$string['core.login.connecttoworkplaceapp'] = 'Bandote prisijungti prie „Moodle Workplace“ svetainės. Norėdami prisijungti prie šios svetainės, atsisiųskite „Moodle Workplace“ programėlę.';
$string['core.login.credentialsdescription'] = 'Norėdami prisijungti, nurodykite savo naudotojo vardą ir slaptažodį.';
$string['core.login.credentialshelp'] = 'Jei kyla problemų prisijungiant, bandykite prisijungti vėliau arba kreipkitės į mokyklą ar mokymosi paslaugų teikėją.';
$string['core.login.credentialssupportsubject'] = 'Reikia pagalbos prisijungiant';
$string['core.login.emailconfirmsentnoemail'] = '<p>Jūsų el. pašto adresu turėjo būti išsiųstas el. laiškas.</p><p>Jame pateikiamos paprastos instrukcijos, kaip užbaigti registraciją.</p>';
$string['core.login.emailnotmatch'] = 'El. paštas nesutampa';
$string['core.login.erroraccesscontrolalloworigin'] = 'Kryžminis veiksmas buvo atmestas. Patikrinkite: https://docs.moodle.org/dev/Moodle_Mobile_development_using_Chrome_or_Chromium';
$string['core.login.errordeletesite'] = 'Klaida trinant šią svetainę. Prašome mėginti vėl.';
$string['core.login.errorqrnoscheme'] = 'Šis URL nėra galiojantis prisijungimo URL.';
$string['core.login.errorupdatesite'] = 'Klaida atnaujinant svetainės kodą.';
$string['core.login.exceededloginattemptsrecoverpassword'] = 'slaptažodžio atkūrimas';
$string['core.login.exceededloginattemptssupportsubject'] = 'Negaliu prisijungti';
$string['core.login.exceededloginattemptswithoutsupport'] = 'Reikia pagalbos prisijungiant? Išbandykite {{recoverPassword}}.';
$string['core.login.exceededpasswordresetattempts'] = 'Atrodo, kad jums nepavyksta prisijungti prie paskyros. Galite susisiekti su savo mokykla ar mokymosi paslaugų teikėju arba pabandyti vėliau.';
$string['core.login.exceededpasswordresetattemptssupportsubject'] = 'Negaliu iš naujo nustatyti savo slaptažodžio';
$string['core.login.faqcannotfindmysiteanswer'] = 'Jei bandėte ieškoti pagal URL adresą ir vis tiek nerandate savo „Moodle“ svetainės, susisiekite su asmeniu, kuris jūsų mokykloje ar mokymosi organizacijoje rūpinasi „Moodle“.';
$string['core.login.faqcannotfindmysitequestion'] = 'Negaliu rasti savo svetainės pagal URL adresą.';
$string['core.login.faqcantloginquestion'] = 'Negaliu prisijungti.';
$string['core.login.faqsetupsitelinktitle'] = 'Pradėti.';
$string['core.login.faqsetupsitequestion'] = 'Noriu sukurti savo „Moodle“ svetainę.';
$string['core.login.faqtestappquestion'] = 'Ar galiu išbandyti programėlę demonstracinėje svetainėje?';
$string['core.login.faqwhatisurlquestion'] = 'Kaip galiu rasti savo svetainę?';
$string['core.login.faqwhereisqrcode'] = 'Kur rasti QR kodą?';
$string['core.login.findyoursite'] = 'Rasti savo svetainę';
$string['core.login.invalidaccount'] = 'Prašome patikrinti prisijungimo duomenis arba paprašyti administratoriaus patikrinti svetainės nustatymus.';
$string['core.login.invalidmoodleversion'] = 'Negaliojanti Moodle versija. Turi būti ne senesnė nei {{$a}}.';
$string['core.login.invalidsite'] = 'URL adresas netinkamas.';
$string['core.login.invalidtime'] = 'Netinkamas laikas';
$string['core.login.invalidvaluemax'] = 'Didžiausia vertė {{$a}}';
$string['core.login.invalidvaluemin'] = 'Mažiausia vertė {{$a}}';
$string['core.login.loginbutton'] = 'Prisijungti';
$string['core.login.mobileservicesnotenabled'] = 'Mobilios paslaugos svetainėje neįgalintos.';
$string['core.login.notloggedin'] = 'Turite prisijungti';
$string['core.login.onboardingcreatemanagecourses'] = 'Kurkite ir tvarkykite kursus';
$string['core.login.onboardinggetstarted'] = 'Pradėkite dirbti su „Moodle';
$string['core.login.onboardingialreadyhaveasite'] = 'Jau turiu „Moodle“ svetainę';
$string['core.login.onboardingimalearner'] = 'Aš besimokantysis';
$string['core.login.onboardingimaneducator'] = 'Aš pedagogas';
$string['core.login.onboardingineedasite'] = 'Man reikia „Moodle“ svetainės';
$string['core.login.or'] = 'Arba';
$string['core.login.passwordrequired'] = 'Reikalingas slaptažodis';
$string['core.login.reconnect'] = 'Jungtis pakartotinai';
$string['core.login.removeaccount'] = 'Pašalinti paskyrą';
$string['core.login.searchby'] = 'Paieška pagal:';
$string['core.login.selectsite'] = 'Pasirinkite savo paskyrą:';
$string['core.login.signupplugindisabled'] = '{{$a}} neįjungtas.';
$string['core.login.siteaddress'] = 'Jūsų svetainė';
$string['core.login.siteinmaintenance'] = 'Svetainė palaikymo rėžime';
$string['core.login.siteurl'] = 'Svetainės URL';
$string['core.login.siteurlrequired'] = 'Reikalingas URL adresas, pvz., <i>http://www.yourmoodlesite.abc arba https://www.yourmoodlesite.efg</i>';
$string['core.login.stillcantconnect'] = 'Vis dar negalite prisijungti?';
$string['core.login.toggleremove'] = 'Redaguoti paskyrų sąrašą';
$string['core.login.unsupportedsite'] = 'Svetainė nepasiekiama per programėlę';
$string['core.login.usernamerequired'] = 'Reikalingas naudotojo vardas';
$string['core.login.visitchangepassword'] = 'Ar norite apsilankyti svetainėje ir pakeisti slaptažodį?';
$string['core.login.webservicesnotenabled'] = 'Tinklo paslaugos neįgalintos. Susisiekite su Moodle administratoriumi jeigu manote, kad  reikalinga įgalinti.';
$string['core.login.youcanstillconnectwithcredentials'] = 'Vis dar galite prisijungti prie svetainės įvesdami savo naudotojo vardą ir slaptažodį.';
$string['core.login.yourenteredsite'] = 'Prisijunkite prie savo svetainės';
$string['core.lostconnection'] = 'Jūsų atpažinimo kodas neteisingas arba negalioja, turėsite vėl prisijungti prie svetainės.';
$string['core.mainmenu.switchaccount'] = 'Perjungti paskyrą';
$string['core.needhelp'] = 'Reikia pagalbos?';
$string['core.networkerrormsg'] = 'Kilo problemų prisijungiant prie svetainės. Patikrinkite ryšį ir bandykite dar kartą.';
$string['core.nopasswordchangeforced'] = 'Nepakeitę slaptažodžio negalėsite tęsti.';
$string['core.nopermissionerror'] = 'Atsiprašome, bet šiuo metu neturite leidimų tai daryti.';
$string['core.notapplicable'] = 'netaikoma';
$string['core.notdownloadable'] = 'Neatsisiunčiama';
$string['core.notnow'] = 'Ne dabar';
$string['core.notsent'] = 'Neišsiųsta';
$string['core.nummore'] = '{{$a}} daugiau';
$string['core.openfile'] = 'Atidaryti failą';
$string['core.openfilewithextension'] = 'Atidaryti {{extension}} failą';
$string['core.openfullimage'] = 'Spustelėkite čia, jei norite rodyti viso dydžio paveikslėlį';
$string['core.openinbrowser'] = 'Atidaryti naršyklėje';
$string['core.openmodinbrowser'] = 'Atidaryti {{$a}} naršyklėje';
$string['core.opensettings'] = 'Atidaryti nustatymus';
$string['core.openwith'] = 'Atidaryti su...';
$string['core.percentagenumber'] = '{{$a}}%';
$string['core.policy.havereadandagreepolicy'] = 'Perskaičiau ir sutinku su {{policyname}}';
$string['core.policy.nopoliciesyet'] = 'Politikos ir susitarimų dar nėra.';
$string['core.policy.policyacceptmandatory'] = 'Suprantu ir sutinku su privalomomis svetainės taisyklėmis';
$string['core.policy.viewpolicy'] = 'Žiūrėti politiką {{policyname}}.';
$string['core.pulltorefresh'] = 'Atnaujinti';
$string['core.qrscanner'] = 'QR skaitytuvas';
$string['core.question.cannotdeterminestatus'] = 'Negalima nustatyti būsenos';
$string['core.question.errorattachmentsnotsupportedinsite'] = 'Jūsų svetainė dar nepalaiko failų pridėjimo prie atsakymų.';
$string['core.question.errorquestionnotsupported'] = 'Šis klausimo tipas programėlėje nepalaikomas: {{$a}}.';
$string['core.question.howtodraganddrop'] = 'Spragtelkite pasirinkimui, tada spragtelkite numetimui.';
$string['core.question.questionmessage'] = 'Klausimas {{$a}}: {{$b}}';
$string['core.redirectingtosite'] = 'Būsite nukreipti į svetainę.';
$string['core.reminders.atthetime'] = 'Įvykio metu';
$string['core.reminders.custom'] = 'Pasirinktinis...';
$string['core.reminders.customreminder'] = 'Pasirinktinis priminimas';
$string['core.reminders.delete'] = 'Ištrinti priminimą';
$string['core.reminders.reminderset'] = 'Nustatytas priminimas {{$a}}';
$string['core.reminders.reminderunset'] = 'Priminimas ištrintas';
$string['core.reminders.setareminder'] = 'Nustatyti priminimą';
$string['core.reminders.setareminderfor'] = 'Nustatyti priminimą „{{title}}“ ({{label}})';
$string['core.reminders.setreminder'] = 'Nustatyti priminimą';
$string['core.reminders.timebefore'] = '{{value}} {{units}} prieš';
$string['core.reminders.value'] = 'Reikšmė';
$string['core.removedownloadeddata'] = 'Pašalinti atsisiųstus duomenis';
$string['core.removefiles'] = 'Pašalinti failus {{$a}}';
$string['core.reportbuilder.hidecolumns'] = 'Slėpti stulpelius';
$string['core.reportbuilder.showcolumns'] = 'Rodyti stulpelius';
$string['core.requireduserdatamissing'] = 'Trūkta vartotojo duomenų.  Prašome užpildyti duomenis Moodle ir pabandyti dar kartą.<br>{{$a}}';
$string['core.retry'] = 'Bandyti dar kartą';
$string['core.scanqr'] = 'Nuskaityti QR kodą';
$string['core.scrollbackward'] = 'Slinkti atgal';
$string['core.scrollforward'] = 'Slinkti pirmyn';
$string['core.search.allcategories'] = 'Visos kategorijos';
$string['core.search.empty'] = 'Ko ieškote?';
$string['core.search.filtercategories'] = 'Filtruoti rezultatus pagal';
$string['core.search.filtercourses'] = 'Ieškoti';
$string['core.search.noresults'] = 'Nėra rezultatų „{{$a}}“';
$string['core.search.noresultshelp'] = 'Patikrinkite, ar nėra rašybos klaidų, arba pabandykite naudoti kitus raktažodžius.';
$string['core.search.resultby'] = '{{$a}}';
$string['core.searching'] = 'Ieškoma';
$string['core.serverconnection'] = 'Klaida jungiantis prie serverio: {{details}}';
$string['core.settings.about'] = 'Apie';
$string['core.settings.appsettings'] = 'Programėlės nustatymai';
$string['core.settings.appversion'] = 'Programėlės versija';
$string['core.settings.cannotsyncoffline'] = 'Svetainės sinchronizacija nepavyko, nes jūsų įrenginys neprijungtas prie interneto.';
$string['core.settings.cannotsyncwithoutwifi'] = 'Jūsų įrenginys neprijungtas prie „Wi-Fi“. Prisijunkite prie „Wi-Fi“ tinklo arba programėlės nustatymuose išjunkite „Duomenų taupymas“.';
$string['core.settings.changelanguage'] = 'Pakeisti į {{$a}}';
$string['core.settings.changelanguagealert'] = 'Pakeitus kalbą, programėlė bus paleista iš naujo.';
$string['core.settings.colorscheme'] = 'Spalvų schema';
$string['core.settings.colorscheme-dark'] = 'Tamsi';
$string['core.settings.colorscheme-light'] = 'Šviesi';
$string['core.settings.colorscheme-system'] = 'Sistemos numatytieji nustatymai';
$string['core.settings.colorscheme-system-notice'] = 'Sistemos numatytasis režimas priklauso nuo jūsų įrenginio palaikymo.';
$string['core.settings.connecttosync'] = 'Jūsų įrenginys yra neprisijungęs. Prisijunkite prie interneto, kad sinchronizuotumėte svetaines.';
$string['core.settings.connectwifitosync'] = 'Prisijunkite prie „Wi-Fi“ tinklo arba išjunkite duomenų taupymą, kad sinchronizuotumėte svetaines.';
$string['core.settings.copyinfo'] = 'Įrenginio informacijos kopijavimas į iškarpinę';
$string['core.settings.cordovadevicemodel'] = 'Cordova įrenginio modelis';
$string['core.settings.cordovadeviceosversion'] = 'Cordova įrenginio OS versija';
$string['core.settings.cordovadeviceplatform'] = 'Cordova įrenginio platforma';
$string['core.settings.cordovadeviceuuid'] = 'Cordova įrenginio UUID';
$string['core.settings.cordovaversion'] = 'Cordova versija';
$string['core.settings.deviceinfo'] = 'Įrenginio informacija';
$string['core.settings.deviceos'] = 'Įrenginio OS';
$string['core.settings.displayformat'] = 'Rodyti formatą';
$string['core.settings.enableanalytics'] = 'Įjungti analitiką';
$string['core.settings.enabledownloadsection'] = 'Įjungti dalių parsiuntimą';
$string['core.settings.enablerichtexteditor'] = 'Įjungti teksto redaktorių';
$string['core.settings.enablerichtexteditordescription'] = 'Jeigu įgalinta, teksto redaktorius bus rodomas leidžiamose vietose.';
$string['core.settings.entriesincache'] = '{{$a}} įrašai talpykloje';
$string['core.settings.estimatedfreespace'] = 'Laisva vieta';
$string['core.settings.filesystemroot'] = 'Failų sistemos šakninis';
$string['core.settings.fontsize'] = 'Teksto dydis';
$string['core.settings.localnotifavailable'] = 'Galimi vietiniai pranešimai';
$string['core.settings.locationhref'] = 'Žiniatinklio peržiūros URL';
$string['core.settings.logintosync'] = 'Prisijunkite, kad sinchronizuotumėte';
$string['core.settings.navigatorlanguage'] = 'Navigatoriaus kalba';
$string['core.settings.navigatoruseragent'] = 'Navigatorius userAgent';
$string['core.settings.networkstatus'] = 'Interneto ryšio būsena';
$string['core.settings.opensourcelicenses'] = 'Atvirojo kodo licencijos';
$string['core.settings.privacypolicy'] = 'Privatumo politika';
$string['core.settings.reportinbackground'] = 'Automatiškai pranešti apie klaidas';
$string['core.settings.screen'] = 'Ekrano informacija';
$string['core.settings.showdownloadoptions'] = 'Rodyti atsisiuntimo parinktis';
$string['core.settings.siteinfo'] = 'Svetainės info';
$string['core.settings.sitesynccompleted'] = 'Svetainės sinchronizavimas baigtas.';
$string['core.settings.sitesyncfailed'] = 'Svetainės sinchronizavimas nepavyko';
$string['core.settings.spaceusage'] = 'Vietos naudojimas';
$string['core.settings.syncdatasaver'] = 'Duomenų taupymas: Sinchronizuoti tik tada, kai naudojamasi Wi-Fi';
$string['core.settings.synchronization'] = 'Sinchronizavimas';
$string['core.settings.synchronizenow'] = 'Sinchronizuoti dabar';
$string['core.settings.syncsettings'] = 'Sinchronizavimo nustatymai';
$string['core.settings.wificonnection'] = 'WiFi ryšys';
$string['core.settings.youradev'] = 'Dabar esate kūrėjas';
$string['core.sharedfiles.chooseaccountstorefile'] = 'Pasirinkite paskyrą, kurioje norite saugoti failą.';
$string['core.sharedfiles.chooseactionrepeatedfile'] = 'Failas tokiu pavadinimu jau yra. Ar norite pakeisti esantį ar jį pervadinti "{{$a}}"?';
$string['core.sharedfiles.errorreceivefilenosites'] = 'Svetainės nėra saugomos. Prieš dalintis failu, pridėkite svetainės nuorodą.';
$string['core.sharedfiles.nosharedfiles'] = 'Šioje svetainėje nėra bendrinamų failų.';
$string['core.sharedfiles.nosharedfilestoupload'] = 'Nėra įkeltų failų. Jeigu norite juos įkelti iš kitos programėlės, pažymėkite ir paspauskite mygtuką „Atidaryti“.';
$string['core.sharedfiles.rename'] = 'Pervadinti';
$string['core.sharedfiles.replace'] = 'Pakeisti';
$string['core.sharedfiles.sharedfiles'] = 'Bendrai naudojami failai';
$string['core.sharedfiles.successstorefile'] = 'Failas sėkmingai patalpintas. Galite jį perkelti į savo asmeninį aplanką arba įkelti tam tikrosiose veiklose.';
$string['core.sizetb'] = 'TB';
$string['core.sorry'] = 'Atsiprašome...';
$string['core.start'] = 'Pradėti';
$string['core.startingtime'] = 'Pradžios laikas: {{$a}}';
$string['core.storingfiles'] = 'Saugomi failai';
$string['core.submittedoffline'] = 'Pateikta (Neprisijungus)';
$string['core.swipenavigationtourdescription'] = 'Braukite kairėn ir dešinėn, kad naršytumėte.';
$string['core.tablet'] = 'Planšetė';
$string['core.tag.errorareanotsupported'] = 'Ši žymių sritis programėlėje nepalaikoma.';
$string['core.tag.tagareabadgedescription'] = 'Yra {{count}} elementų.';
$string['core.tag.warningareasnotsupported'] = 'Kai kurios žymių sritys nerodomos, nes programėlė jų nepalaiko.';
$string['core.tryagain'] = 'Bandyti dar kartą';
$string['core.turnon'] = 'Įjungti';
$string['core.turnonexactalarms'] = 'Įjungti įspėjimus realiuoju laiku';
$string['core.turnonnotifications'] = 'Įjungti pranešimus';
$string['core.twoparagraphs'] = '{{p1}}<br><br>{{p2}}';
$string['core.uhoh'] = 'Oho!';
$string['core.unexpectederror'] = 'Netikėta klaida. Uždarykite ir vėl atidarykite programėlę, tada bandykite dar kartą.';
$string['core.unknown'] = 'Nežinomas';
$string['core.unzipping'] = 'Išskleidžiama';
$string['core.user.contact'] = 'Kontaktai';
$string['core.user.detailsnotavailable'] = 'Šio naudotojo duomenys jums neprieinami.';
$string['core.user.errorloaduser'] = 'Klaida įkeliant naudotoją.';
$string['core.user.sendemail'] = 'El. paštas';
$string['core.user.support'] = 'Susisiekite su svetainės palaikymo komanda';
$string['core.user.supportsubject'] = '[App] {{subject}}';
$string['core.user.userwithid'] = 'Naudotojas, kurio ID {{id}}';
$string['core.usernologin'] = 'Šios paskyros autentifikavimo patvirtinimas buvo atšauktas';
$string['core.viewcode'] = 'Žiūrėti kodą';
$string['core.vieweditor'] = 'Žiūrėti redaktorių';
$string['core.viewembeddedcontent'] = 'Žiūrėti įterptąjį turinį';
$string['core.wanttochangesite'] = 'Norite pakeisti svetainę arba atsijungti?';
$string['core.warningofflinedatadeleted'] = 'Neprisijungus prie interneto atliekami pakeitimai {{component}} \'{{name}}\' buvo atmesti. {{error}}';
$string['core.warningofflinedatadeletedreason'] = 'Naujausi šios veiklos pakeitimai buvo atlikti iš kito įrenginio.';
$string['core.whyisthishappening'] = 'Kodėl taip atsitiko?';
$string['core.wsfunctionnotavailable'] = 'Interneto paslaugų funkcija nepasiekiama.';
$string['core.youreoffline'] = 'Jūsų įrenginys neprisijungęs';
$string['core.youreonline'] = 'Jūsų įrenginys prisijungęs';
$string['core.zoomin'] = 'Priartinti';
$string['core.zoomout'] = 'Tolinti';
$string['freemium.biometriclogin'] = 'Biometrinis prisijungimas';
$string['freemium.biometriclogindescription'] = 'Pridėkite pirštą prie pirštų atspaudų skaitytuvo.';
$string['freemium.biometricloginenablefaceid'] = 'Įjungti „FaceID';
$string['freemium.biometricloginenablefingerprint'] = 'Įjungti pirštų antspaudus';
$string['freemium.biometricloginenabletouchid'] = 'Įjungti „TouchID';
$string['freemium.biometricloginloginwithfaceid'] = 'Prisijungimas su FaceID';
$string['freemium.biometricloginloginwithfingerprint'] = 'Prisijungimas su pirštų antspaudais';
$string['freemium.biometricloginloginwithtouchid'] = 'Prisijungimas su „TouchID';
$string['freemium.biometricloginskip'] = 'Kol kas praleisti';
$string['freemium.biometricloginsuccessfullyenabled'] = '{{ biometricMethod }} įjungtas.';
$string['freemium.biometricloginturnoff'] = 'Šią funkciją galite bet kada įjungti ir išjungti nustatymų dalyje.';
$string['freemium.biometriclogintypefaceid'] = '„FaceID“';
$string['freemium.biometriclogintypefingerprint'] = 'Piršto antspaudas';
$string['freemium.biometriclogintypetouchid'] = '„TouchID“';
$string['freemium.biometricloginwithfingerorface'] = 'Naudokite biometrinį prisijungimą su piršto antspaudu arba veidu.';
$string['freemium.change'] = 'Keisti';
$string['freemium.feature_biometriclogin'] = 'Biometrinis prisijungimas';
$string['freemium.feature_coursesdownload'] = 'Atsisiųsti kursai';
$string['freemium.feature_remotethemes'] = 'Nuotolinės temos';
$string['freemium.feature_sitelogo'] = 'Svetainės logo';
$string['freemium.notallowed'] = 'Neleidžiama';
$string['freemium.nottoday'] = 'Ne šiandien';
$string['freemium.ratetheapp'] = 'Ar jums patinka mūsų programėlė?';
$string['freemium.ratetheapp_feedbackko'] = 'Papasakokite, kas nepavyko';
$string['freemium.ratetheapp_feedbackmessage'] = 'Jūsų atsiliepimas bus anoniminis.';
$string['freemium.ratetheapp_feedbackok'] = 'Siųsti atsiliepimą';
$string['freemium.ratetheapp_feedbackplaceholder'] = 'Parašykite čia ką nors';
$string['freemium.ratetheapp_feedbacksent'] = 'Ačiū! Jūsų atsiliepimas buvo sėkmingai išsiųstas.';
$string['freemium.ratetheapp_sendtostore'] = 'Ar turėtumėte akimirką ir įvertintumėte mūsų programėlę? Tai padės mums ją tobulinti.';
$string['freemium.remindmelater'] = 'Priminti man vėliau';
$string['freemium.settingsoptionsfacial'] = 'Įjungti prisijungimą naudojant veidą';
$string['freemium.settingsoptionsfingerprint'] = 'Įjungti prisijungimą pirštų antspaudais';
$string['freemium.subscription'] = 'Svetainės prenumerata';
$string['freemium.subscriptiondetails'] = 'Prenumeratos informacija';
$string['freemium.subscriptionfeature_unlimited'] = 'Neribota';
$string['freemium.subscriptionplan'] = 'Prenumeratos planas';
$string['freemium.subscriptionplan_expired'] = 'baigėsi';
$string['freemium.subscriptionplan_free'] = 'Nemokama';
$string['freemium.subscriptionplan_upgrade'] = 'Atnaujinti savo planą';
$string['freemium.upsell_upgradefreeaccept'] = 'Atnaujinti';
$string['freemium.upsell_upgradefreepostpone'] = 'Vėliau';
$string['pluginname'] = '"Moodle" programėlės kalbos eilutės';
