<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'role', language 'lo', version '4.4'.
 *
 * @package     role
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addinganewrole'] = 'ກຳລັງເພີ່ມໜ້າທີ່ໃໝ່';
$string['addrole'] = 'ເພີ່ມໜ້າທີ່ໃໝ່';
$string['advancedoverride'] = 'ການລົບລ້າງໜ້າທີ່ຂັ້ນສູງ';
$string['allow'] = 'ອະນຸຍາດ';
$string['allowassign'] = 'ອະນຸຍາດການມອບໝາຍໜ້າທີ່';
$string['allowed'] = 'ອະນຸຍາດແລ້ວ';
$string['allowoverride'] = 'ອະນຸຍາດການລົບລ້າງໜ້າທີ່';
$string['allowroletoassign'] = 'ອະນຸຍາດຜູ້ໃຊ້ກັບໜ້າທີ່ {$a->fromrole} ເພື່ອແຕ່ງຕັ້ງໜ້າທີ່ {$a->targetrole}';
$string['allowroletooverride'] = 'ອະນຸຍາດຜູ້ໃຊ້ກັບໜ້າທີ່ {$a->fromrole} ເພື່ອລົບລ້າງໜ້າທີ່ {$a->targetrole}';
$string['allowroletoswitch'] = 'ອະນຸຍາດຜູ້ໃຊ້ກັບໜ້າທີ່ {$a->fromrole} ເພື່ອປ່ຽນໜ້າທີ່ໄປຫາໜ້າທີ່ {$a->targetrole}';
$string['allowroletoview'] = 'ອະນຸຍາດຜູ້ໃຊ້ກັບໜ້າທີ່ {$a->fromrole} ເພື່ອເບິ່ງໜ້າທີ່ {$a->targetrole}';
$string['allowswitch'] = 'ອະນຸຍາດການປ່ຽນໜ້າທີ່';
$string['allowview'] = 'ອະນຸຍາດໜ້າທີ່ໃຫ້ເບິ່ງ';
$string['allsiteusers'] = 'ຜູ້ໃຊ້ເວັບໄຊທ໌ທັງໝົດ';
$string['analytics:listinsights'] = 'ລາຍການຂໍ້ມູນເລິກເຊີງ';
$string['analytics:listowninsights'] = 'ລາຍການຂໍ້ມູນເລິກເຊີງທີ່ເປັນເຈົ້າຂອງ';
$string['analytics:managemodels'] = 'ແບບຢ່າງການຈັດການ';
$string['archetype'] = 'ໜ້າທີ່ຕົວແບບ';
$string['archetype_help'] = 'ຕົວແບບເດີມຂອງໜ້າທີ່ ກຳນົດການອະນຸຍາດເມື່ອໜ້າທີ່ຖືກຕັ້ງຄ່າຄືນໃໝ່ເປັນຄ່າເລີ່ມຕົ້ນ. ມັນຍັງກຳນົດການອະນຸຍາດໃໝ່ສຳລັບໜ້າທີ່ເມື່ອເວັບໄຊທ໌ໄດ້ຮັບການຍົກລະດັບ.';
$string['archetypecoursecreator'] = 'ຕົວຢ່າງເດີມ: ຜູ້ສ້າງລາຍວິຊາ';
$string['archetypeeditingteacher'] = 'ຕົວຢ່າງເດີມ: ຄູສອນ (ການແກ້ໄຂ)';
$string['archetypefrontpage'] = 'ARCHETYPE: ກວດສອບຄວາມຖືກຕ້ອງຜູ້ໃຊ້ຢູ່ໃນໜ້າຫຼັກເວັບໄຊທ໌';
$string['archetypeguest'] = 'ຕົວຢ່າງເດີມ: ແຂກ';
$string['archetypemanager'] = 'ຕົວຢ່າງເດີມ: ຜູ້ຈັດການ';
$string['archetypestudent'] = 'ຕົວຢ່າງເດີມ: ນັກຮຽນ';
$string['archetypeteacher'] = 'ຕົວຢ່າງເດີມ: ຄູສອນ (ບໍ່ໄດ້ແກ້ໄຂ)';
$string['archetypeuser'] = 'ຕົວຢ່າງເດີມ: ພິສູດຢືນຢັນຜູ້ໃຊ້';
$string['assignanotherrole'] = 'ແຕ່ງຕັ້ງໜ້າທີ່ອື່ນ';
$string['assignedroles'] = 'ແຕ່ງຕັ້ງໜ້າທີ່';
$string['assignerror'] = 'ເກີດຂໍ້ຄວາມຜິດພາດໃນຂະນະທີ່ແຕ່ງຕັ້ງໜ້າທີ່ {$a->role} ໃຫ້ຜູ້ໃຊ້ {$a->user}.';
$string['assignglobalroles'] = 'ແຕ່ງຕັ້ງລະບົບໜ້າທີ່';
$string['assignmentcontext'] = 'ບໍລິບົດການແຕ່ງຕັ້ງ';
$string['assignmentoptions'] = 'ທາງເລືອກການແຕ່ງຕັ້ງ';
$string['assignrole'] = 'ແຕ່ງຕັ້ງໜ້າທີ່';
$string['assignrolenameincontext'] = 'ແຕ່ງຕັ້ງໜ້າທີ່ \'{$a->role}\' ໃນ {$a->context}';
$string['assignroles'] = 'ແຕ່ງຕັ້ງບັນດາໜ້າທີ່';
$string['assignroles_help'] = 'ໂດຍການມອບໝາຍໜ້າທີ່ໃຫ້ກັບຜູ້ໃຊ້ໃນບໍລິບົດ, ທ່ານກໍາລັງໃຫ້ການອະນຸຍາດທີ່ມີຢູ່ໃນໜ້າທີ່ນັ້ນ, ສໍາລັບສະພາບການປະຈຸບັນ ແລະ ທຸກສະພາບການຕ່ຳ. ຕົວຢ່າງ: ຖ້າຜູ້ໃຊ້ຖືກແຕ່ງຕັ້ງໜ້າທີ່ຂອງນັກຮຽນໃນລາຍວິຊາ, ເຂົາເຈົ້າຈະມີບົດບາດຂອງນັກຮຽນສໍາລັບທຸກກິດຈະກໍາ ແລະ ການປິດກັ້ນພາຍໃນລາຍວິຊາ.';
$string['assignroles_link'] = 'admin/roles/assign';
$string['assignrolesin'] = 'ແຕ່ງຕັ້ງບັນດາໜ້າທີ່ໃນ {$a}';
$string['assignrolesrelativetothisuser'] = 'ແຕ່ງຕັ້ງບັນດາໜ້າທີ່ກ່ຽວຂ້ອງກັບຜູ້ໃຊ້ນີ້';
$string['backtoallroles'] = 'ກັບຄືນສູ່ລາຍການໜ້າທີ່ທັງໝົດ';
$string['backup:anonymise'] = 'ປິດບັງຂໍ້ມູນຜູ້ໃຊ້ໃນການສຳຮອງຂໍ້ມູນ';
$string['backup:backupactivity'] = 'ກິດຈະກຳການສຳຮອງຂໍ້ມູນ';
$string['backup:backupcourse'] = 'ວິຊາການສຳຮອງຂໍ້ມູນ';
$string['backup:backupsection'] = 'ພາກສ່ວນການສຳຮອງຂໍ້ມູນ';
$string['backup:backuptargetimport'] = 'ການສຳຮອງຂໍ້ມູນສຳລັບນຳເຂົ້າ';
$string['backup:configure'] = 'ການກຳນົດທາງເລືອກການສຳຮອງຂໍ້ມູນ';
$string['backup:downloadfile'] = 'ດາວໂຫຼດໄຟລ໌ຈາກພື້ນທີ່ການສຳຮອງຂໍ້ມູນ';
$string['backup:userinfo'] = 'ການສຳຮອງຂໍ້ມູນຜູ້ໃຊ້';
$string['badges:awardbadge'] = 'ປ້າຍລາວງວັນໃຫ້ກັບຜູ້ໃຊ້';
$string['badges:configurecriteria'] = 'ການຕັ້ງຄ່າ/ແກ້ໄຂ ເກນຂອງການໄດ້ຮັບປ້າຍ';
$string['badges:configuredetails'] = 'ການຕັ້ງຄ່າ/ແກ້ໄຂ ລາຍລະອຽດປ້າຍ';
$string['badges:configuremessages'] = 'ກຳນົດຄ່າຂໍ້ຄວາມປ້າຍ';
$string['badges:createbadge'] = 'ສ້າງ/ເຮັດຊ້ຳ ປ້າຍ';
$string['badges:deletebadge'] = 'ລຶບປ້າຍ';
$string['badges:earnbadge'] = 'ຮັບປ້າຍ';
$string['badges:manageglobalsettings'] = 'ການຕັ້ງຄ່າທົ່ວໂລກການຈັດການປ້າຍ';
$string['badges:manageownbadges'] = 'ເບິ່ງ ແລະ ຈັດການປ້າຍທີ່ໄດ້ຮັບຂອງຕົວເອງ';
$string['badges:revokebadge'] = 'ຖອນປ້າຍຈາກຜູ້ໃຊ້';
$string['badges:viewawarded'] = 'ເບິ່ງຜູ້ໃຊ້ທີ່ໄດ້ຮັບປ້າຍສະເພາະໂດຍບໍ່ສາມາດໃຫ້ລາງວັນປ້າຍໄດ້';
$string['badges:viewbadges'] = 'ເບິ່ງປ້າຍທີ່ມີໃຫ້ໂດຍບໍ່ໄດ້ຮັບມັນເທື່ອ';
$string['badges:viewotherbadges'] = 'ເບິ່ງປ້າຍສາທາລະນະໃນໂປຼໄຟລ໌ຂອງຜູ້ໃຊ້ອື່ນ';
$string['block:edit'] = 'ແກ້ໄຂການຕັ້ງຄ່າການປິດກັ້ນ';
$string['block:view'] = 'ເບິ່ງການປິດກັ້ນ';
$string['blog:create'] = 'ສ້າງລາຍການບລ໋ອກໃໝ່';
$string['blog:manageentries'] = 'ແກ້ໄຂ ແລະ ຈັດການການປ້ອນເຂົ້າ';
$string['blog:manageexternal'] = 'ແກ້ໄຂ ແລະ ຈັດການບລ໋ອກພາຍນອກ';
$string['blog:search'] = 'ຊອກຫາລາຍການບລ໋ອກ';
$string['blog:view'] = 'ເບິ່ງລາຍການບລ໋ອກ';
$string['blog:viewdrafts'] = 'ເບິ່ງສະບັບຮ່າງລາຍການບລ໋ອກ';
$string['calendar:manageentries'] = 'ຈັດການກັບລາຍການປະຕິທິນໃດໜຶ່ງ';
$string['calendar:managegroupentries'] = 'ຈັດການກັບກຸ່ມລາຍການປະຕິທິນ';
$string['calendar:manageownentries'] = 'ຈັດການກັບລາຍການປະຕິທິນຂອງຕົວເອງ';
$string['capabilities'] = 'ຄວາມສາມາດ';
$string['capability'] = 'ຄວາມສາມາດ';
$string['category:create'] = 'ສ້າງປະເພດ';
$string['category:delete'] = 'ລຶບປະເພດ';
$string['category:manage'] = 'ຈັດການກັບປະເພດ';
$string['category:update'] = 'ປັບປຸງປະເພດຕ່າງໆ';
$string['category:viewcourselist'] = 'ເບິ່ງປະເພດລາຍວິຊາ ແລະ ວິຊາພາຍໃນມັນ';
$string['category:viewhiddencategories'] = 'ເບິ່ງບັນດາປະເພດທີ່ເຊື່ອງໄວ້';
$string['category:visibility'] = 'ເບິ່ງບັນດາປະເພດທີ່ເຊື່ອງໄວ້';
$string['checkglobalpermissions'] = 'ກວດສອບການອະນຸຍາດລະບົບ';
$string['checkpermissions'] = 'ກວດສອບການອະນຸຍາດ';
$string['checkpermissionsin'] = 'ກວດສອບການອະນຸຍາດໃນ {$a}';
$string['checksystempermissionsfor'] = 'ກວດສອບການອະນຸຍາດສຳລັບ {$a->fullname}';
$string['checkuserspermissionshere'] = 'ກວດສອບການອະນຸຍາດສຳລັບ {$a->fullname} ທີ່ຢູ່ໃນ {$a->contextlevel} ນີ້';
$string['chooseroletoassign'] = 'ກະລຸນາເລືອກໜ້າທີ່ເພື່ອແຕ່ງຕັ້ງ';
$string['cohort:assign'] = 'ເພີ່ມ ແລະ ລຶບສະມາຊິກກຸ່ມ';
$string['cohort:manage'] = 'ສ້າງ, ລຶບ ແລະ ຍ້າຍກຸ່ມ';
$string['cohort:view'] = 'ເບິ່ງກຸ່ມທົ່ວເວັບໄຊທ໌';
$string['comment:delete'] = 'ລຶບຄຳເຫັນ';
$string['comment:post'] = 'ໂພສຄຳເຫັນ';
$string['comment:view'] = 'ເບິ່ງຄຳເຫັນ';
$string['competency:competencygrade'] = 'ການຕັ້ງຄ່າການຈັດອັນດັບຄວາມສາມາດ';
$string['competency:competencymanage'] = 'ຈັດການຂອບວຽກຄວາມສາມາດ';
$string['competency:competencyview'] = 'ເບິ່ງຂອບວຽກຄວາມສາມາດ';
$string['competency:coursecompetencyconfigure'] = 'ກຳນົດຄ່າການຕັ້ງຄ່າຄວາມສາມາດລາຍວິຊາ';
$string['competency:coursecompetencygradable'] = 'ຮັບເຄື່ອງໝາຍຄວາມສາມາດ';
$string['competency:coursecompetencymanage'] = 'ຈັດການຄວາມສາມາດລາຍວິຊາ';
$string['competency:coursecompetencyview'] = 'ເບິ່ງຄວາມສາມາດລາຍວິຊາ';
$string['competency:evidencedelete'] = 'ລຶບຫຼັກຖານ';
$string['competency:plancomment'] = 'ໃຫ້ຄຳເຫັນເທິງແຜນການຮຽນຮູ້';
$string['competency:plancommentown'] = 'ໃຫ້ຄຳເຫັນເທິງແຜນການຮຽນຮູ້ຂອງຕົວເອງ';
$string['competency:planmanage'] = 'ຈັດການແຜນການຮຽນຮູ້';
$string['competency:planmanagedraft'] = 'ຈັດການແຜນການຮຽນຮູ້ສະບັບຮ່າງ';
$string['competency:planmanageown'] = 'ຈັດການແຜນການຮຽນຮູ້ຂອງຕົວເອງ';
$string['competency:planmanageowndraft'] = 'ຈັດການແຜນການຮຽນຮູ້ສະບັບຮ່າງຂອງຕົວເອງ';
$string['competency:planrequestreview'] = 'ຮ້ອງຂໍທົບທວນແຜນການຮຽນຮູ້';
$string['competency:planrequestreviewown'] = 'ຮ້ອງຂໍທົບທວນແຜນການຮຽນຮູ້ຂອງຕົວເອງ';
$string['competency:planreview'] = 'ທົບທວນແຜນການຮຽນຮູ້';
$string['competency:planview'] = 'ເບິ່ງແຜນການຮຽນຮູ້ທັງໝົດ';
$string['competency:planviewdraft'] = 'ເບິ່ງແຜນການຮຽນຮູ້ສະບັບຮ່າງ';
$string['competency:planviewown'] = 'ເບິ່ງແຜນການຮຽນຮູ້ຂອງຕົວເອງ';
$string['competency:planviewowndraft'] = 'ເບິ່ງແຜນການຮຽນຮູ້ສະບັບຮ່າງຂອງຕົວເອງ';
$string['competency:templatemanage'] = 'ຈັດການແມ່ແບບແຜນການຮຽນຮູ້';
$string['competency:templateview'] = 'ເບິ່ງແມ່ແບບແຜນການຮຽນຮູ້';
$string['competency:usercompetencycomment'] = 'ໃຫ້ຄຳເຫັນເທິງຄວາມສາມາດຜູ້ໃຊ້';
$string['competency:usercompetencycommentown'] = 'ໃຫ້ຄຳເຫັນເທິງຄວາມສາມາດຜູ້ໃຊ້ຂອງຕົວເອງ';
$string['competency:usercompetencyrequestreview'] = 'ຮ້ອງຂໍທົບທວນຄວາມສາມາດຜູ້ໃຊ້';
$string['competency:usercompetencyrequestreviewown'] = 'ຮ້ອງຂໍທົບທວນຄວາມສາມາດຜູ້ໃຊ້ຂອງຕົວເອງ';
$string['competency:usercompetencyreview'] = 'ທົບທວນຄວາມສາມາດຜູ້ໃຊ້';
$string['competency:usercompetencyview'] = 'ເບິ່ງຄວາມສາມາດຜູ້ໃຊ້';
$string['competency:userevidencemanage'] = 'ຈັດການຫຼັກຖາານກ່ອນການຮຽນຮູ້';
$string['competency:userevidencemanageown'] = 'ຈັດການຫຼັກຖາານກ່ອນການຮຽນຮູ້ຂອງຕົວເອງ';
$string['competency:userevidenceview'] = 'ເບິ່ງຫຼັກຖານກ່ອນການຮຽນຮູ້ຂອງຜູ້ໃຊ້';
$string['confirmaddadmin'] = 'ທ່ານຕ້ອງການເພີ່ມຜູ້ໃຊ້ <strong>{$a}</strong> ເປັນຜູ້ເບິ່ງແຍງເວັບໄຊທ໌ໃໝ່ແທ້ບໍ?';
$string['confirmdeladmin'] = 'ທ່ານຕ້ອງການເອົາຜູ້ໃຊ້ <strong>{$a}</strong> ອອກຈາກລາຍການຜູ້ເບິ່ງແຍງເວັບໄຊທ໌ແທ້ບໍ?';
$string['confirmroleprevent'] = 'ທ່ານຕ້ອງການເອົາ <strong>"{$a->role}"</strong> ອອກຈາກລາຍການທີ່ອະນຸຍາດໜ້າທີ່ສຳລັບຄວາມສາມາດ "{$a->cap}" ໃນບໍລິບົດ "{$a->context}" ແທ້ບໍ?';
$string['confirmroleunprohibit'] = 'ທ່ານຕ້ອງການເອົາ <strong>"{$a->role}"</strong> ອອກຈາກລາຍການທີ່ຫ້າມໜ້າທີ່ສຳລັບຄວາມສາມາດ "{$a->cap}" ໃນບໍລິບົດ "{$a->context}" ແທ້ບໍ?';
$string['confirmunassign'] = 'ທ່ານແນ່ໃຈບໍ່ວ່າ ທ່ານຕ້ອງການເອົາໜ້າທີ່ນີ້ອອກຈາກຜູ້ໃຊ້ນີ້?';
$string['confirmunassignno'] = 'ຍົກເລີກ';
$string['confirmunassigntitle'] = 'ຢືນຢັນການປ່ຽນແປງໜ້າທີ່';
$string['confirmunassignyes'] = 'ຍ້າຍອອກ';
$string['contentbank:access'] = 'ເຂົ້າເຖິງທະນາຄານເນື້ອໃນ';
$string['contentbank:deleteanycontent'] = 'ລຶບເນື້ອໃນໃດໜຶ່ງອອກຈາກທະນາຄານເນື້ອໃນ';
$string['contentbank:deleteowncontent'] = 'ລຶບເນື້ອໃນອອກຈາກທະນາຄານເນື້ອໃນຂອງຕົວເອງ';
$string['contentbank:downloadcontent'] = 'ດາວໂຫຼດເນື້ອໃນຈາກທະນາຄານເນື້ອໃນ';
$string['contentbank:manageanycontent'] = 'ຈັດການເນືອໃນໃດໜຶ່ງຈາກທະນາຄານເນື້ອໃນ';
$string['contentbank:manageowncontent'] = 'ຈັດການເນື້ອໃນຈາກທະນາຄານເນື້ອໃນຂອງຕົວເອງ';
$string['contentbank:upload'] = 'ອັບໂຫຼດເນື້ອໃນໃໝ່ໄປຫາທະນາຄານເນື້ອໃນ';
$string['contentbank:useeditor'] = 'ສ້າງ ຫຼື ແກ້ໄຂເນື້ອໃນໂດຍການນຳໃຊ້ຕົວແກ້ໄຂປະເພດເນື້ອໃນ';
$string['contentbank:viewunlistedcontent'] = 'ເບິ່ງເນື້ອໃນທີ່ບໍ່ຢູ່ໃນລາຍການຈາກທະນາຄານເນື້ອໃນ';
$string['context'] = 'ບໍລິບົດ';
$string['contextrolenotallowed'] = 'ບົດບາດ <b>{$a}</b> ບໍ່ອະນຸຍາດໃນບໍລິບົດນີ້.';
$string['course:activityvisibility'] = 'ເຊື່ອງ/ສະແດງກິດຈະກຳ';
$string['course:bulkmessaging'] = 'ສົ່ງຂໍ້ຄວາມໃຫ້ຫຼາຍຄົນ';
$string['course:changecategory'] = 'ປ່ຽນແປງປະເພດລາຍວິຊາ';
$string['course:changefullname'] = 'ປ່ຽນແປງຊື່ເຕັມລາຍວິຊາ';
$string['course:changeidnumber'] = 'ປ່ຽນແປງໝາຍເລກລະຫັດປະຈຳຕົວລາຍວິຊາ';
$string['course:changelockedcustomfields'] = 'ປ່ຽນແປງຊ່ອງຂໍ້ມູນກຳນົດເອງທີ່ຖືກລັອກ';
$string['course:changeshortname'] = 'ປ່ຽນແປງຊື່ຫຍໍ້ລາຍວິຊາ';
$string['course:changesummary'] = 'ປ່ຽນແປງການສະຫຼຸບລາຍວິຊາ';
$string['course:configurecustomfields'] = 'ກຳນົດຄ່າຊ່ອງຂໍ້ມູນກຳນົດເອງ';
$string['course:configuredownloadcontent'] = 'ກຳນົດຄ່າການດາວໂຫຼດເນື້ອໃນລາຍວິຊາ';
$string['course:create'] = 'ສ້າງວິຊາ';
$string['course:creategroupconversations'] = 'ສ້າງກຸ່ມສົນທະນາ';
$string['course:delete'] = 'ລຶບລາຍວິຊາ';
$string['course:downloadcoursecontent'] = 'ດາວໂຫຼດເນື້ອໃນລາຍວິຊາ';
$string['course:enrolconfig'] = 'ກຳນົດຄ່າຕົວຢ່າງການລົງທະບຽນຮຽນໃນລາຍວິຊາ';
$string['course:enrolreview'] = 'ທົບທົວນການລົງທະບຽນຮຽນໃນລາຍວິຊາ';
$string['course:ignoreavailabilityrestrictions'] = 'ບໍ່ສົນໃຈຂໍ້ຈຳກັດການມີໃຫ້';
$string['course:ignorefilesizelimits'] = 'ໃຊ້ໄຟລ໌ທີ່ໃຫຍ່ກວ່າການຈຳກັດຂະໜາດໄຟລ໌ໃດໜຶ່ງ';
$string['course:isincompletionreports'] = 'ສະແດງໃຫ້ເຫັນໃນບົດລາຍງານການສໍາເລັດ';
$string['course:manageactivities'] = 'ຈັດການກິດຈະກຳ';
$string['course:managefiles'] = 'ຈັດການໄຟລ໌';
$string['course:managegrades'] = 'ຈັດການຄະແນນ';
$string['course:managegroups'] = 'ຈັດການກຸ່ມ';
$string['course:managescales'] = 'ຈັດການມາດຕາສ່ວນ';
$string['course:markcomplete'] = 'ໝາຍຜູ້ໃຊ້ວ່າສຳເລັດໃນການສຳເລັດລາຍວິຊາ';
$string['course:movesections'] = 'ຍ້າຍພາກສ່ວນ';
$string['course:overridecompletion'] = 'ລົບລ້າງສະຖານະການສຳເລັດກິດຈະ ກຳ';
$string['course:recommendactivity'] = 'ກິດຈະກຳແນະນຳໃນຕົວເລືອກກິດຈະກຳ';
$string['course:renameroles'] = 'ປ່ຽນຊື່ໜ້າທີ່';
$string['course:request'] = 'ຮ້ອງຂໍວິຊາໃໝ່';
$string['course:reset'] = 'ຕັ້ງຄ່າວິຊາໃໝ່';
$string['course:reviewotherusers'] = 'ເບິ່ງຜູ້ໃຊ້ອື່ນ';
$string['course:sectionvisibility'] = 'ຄວບຄຸມພາກສ່ວນທີ່ເບິ່ງເຫັນ';
$string['course:setcurrentsection'] = 'ຕັ້ງພາກສ່ວນໃນປະຈຸບັນ';
$string['course:setforcedlanguage'] = 'ບັງຄັບໃຊ້ພາສາລາຍວິຊາ';
$string['course:tag'] = 'ປ່ຽນແປງແທັກລາຍວິຊາ';
$string['course:togglecompletion'] = 'ໝາຍກິດຈະກຳວ່າສຳເລັດດ້ວຍຕົວເອງ';
$string['course:update'] = 'ປັບປຸງການຕັ້ງຄ່າລາຍວິຊາ';
$string['course:useremail'] = 'ເປີດໃຊ້ງານ/ປິດໃຊ້ງານທີ່ຢູ່ອີເມລ';
$string['course:view'] = 'ເບິ່ງວິຊາໂດຍບໍມີຜູ້ເຂົ້າຮ່ວມ';
$string['course:viewcoursegrades'] = 'ເບິ່ງຄະແນນວິຊາ';
$string['course:viewhiddenactivities'] = 'ເບິ່ງກິດຈະກຳທີ່ເຊື່ອງໄວ້';
$string['course:viewhiddencourses'] = 'ເບິ່ງວິຊາທີ່ເຊື່ອງໄວ້';
$string['course:viewhiddensections'] = 'ເບິ່ງພາກສ່ວນທີ່ເຊື່ອງໄວ້';
$string['course:viewhiddenuserfields'] = 'ເບິ່ງຊ່ອງຂໍ້ມູນຜູ້ໃຊ້ທີ່ເຊື່ອງໄວ້';
$string['course:viewparticipants'] = 'ເບິ່ງຜູ້ເຂົ້າຮ່ວມ';
$string['course:viewscales'] = 'ເບິ່ງມາດຕາສ່ວນ';
$string['course:viewsuspendedusers'] = 'ເບິ່ງຜູ້ໃຊ້ທີ່ຖືກລະງັບ';
$string['course:visibility'] = 'ເຊື່ອງ/ສະແດງວິຊາ';
$string['createrolebycopying'] = 'ສ້າງໜ້າທີ່ໃໝ່ໂດຍການສຳເນົາ {$a}';
$string['createthisrole'] = 'ສ້າງໜ້າທີ່ນີ້';
$string['currentcontext'] = 'ບໍລິບົດປະຈຸບັນ';
$string['currentrole'] = 'ໜ້າທີ່ປະຈຸບັນ';
$string['customroledescription'] = 'ລາຍລະອຽດທີ່ກໍານົດເອງ';
$string['customroledescription_help'] = 'ຄໍາອະທິບາຍກ່ຽວກັບໜ້າທີ່ມາດຕະຖານຖືກແປເປັນພາສາອັດຕະໂນມັດ ຖ້າຄໍາອະທິບາຍແບບກໍານົດເອງຫວ່າງເປົ່າ.';
$string['customrolename'] = 'ຊື່ເຕັມທີ່ກຳນົດເອງ';
$string['customrolename_help'] = 'ຊື່ຂອງໜ້າທີ່ມາດຕະຖານຖືກແປໂດຍອັດຕະໂນມັດ ຖ້າຊື່ທີ່ກໍານົດເອງຫວ່າງເປົ່າ. ທ່ານຕ້ອງລະບຸຊື່ເຕັມສຳລັບໜ້າທີ່ກຳນົດເອງທັງົດ.';
$string['defaultrole'] = 'ໜ້າທີ່ເລີ່ມຕົ້ນ';
$string['defaultx'] = 'ຄ່າເລີ່ມຕົ້ນ: {$a}';
$string['defineroles'] = 'ກຳນົດໜ້າທີ່';
$string['deletecourseoverrides'] = 'ລຶບການລົບລ້າງທັງໝົດໃນລາຍວິຊາ';
$string['deletelocalroles'] = 'ລຶບການແຕ່ງຕັ້ງໜ້າທີ່ທ້ອງຖີ່ນທັງໝົດ';
$string['deleterolesure'] = '<p>ທ່ານແນ່ໃຈບໍ່ວ່າທ່ານຕ້ອງການລຶບໜ້າທີ່ "{$a->name} ({$a->shortname})"?</p><p>ປະຈຸບັນໜ້າທີ່ນີ້ຖືກແຕ່ງຕັ້ງເປັນ {$a->count} ຜູ້ໃຊ້.</p>';
$string['deletexrole'] = 'ລຶບ {$a} ໜ້າທີ່';
$string['duplicaterole'] = 'ໜ້າທີ່ຊ້ຳກັນ';
$string['duplicaterolesure'] = '<p>ທ່ານແນ່ໃຈບໍ່ວ່າທ່ານຕ້ອງການໃຫ້ໜ້າທີ່ຊ້ຳກັນ "{$a->name} ({$a->shortname})"?</p>';
$string['editingrolex'] = 'ກຳລັງແກ້ໄຂໜ້າທີ່ \'{$a}\'';
$string['editrole'] = 'ແກ້ໄຂໜ້າທີ່';
$string['editxrole'] = 'ແກ້ໄຂ {$a} ໜ້າທີ່';
$string['errorbadrolename'] = 'ຊື່ໜ້າທີ່ບໍ່ຖືກຕ້ອງ';
$string['errorbadroleshortname'] = 'ຊື່ຫຍໍ້ໜ້າທີ່ບໍ່ຖືກຕ້ອງ';
$string['errorexistsrolename'] = 'ຊື່ໜ້າທີ່ມີແລ້ວ';
$string['errorexistsroleshortname'] = 'ຊື່ໜ້າທີ່ມີແລ້ວ';
$string['errorroleshortnametoolong'] = 'ຊື່ຫຍໍ້ຕ້ອງບໍ່ເກີນ 100 ຕົວອັກສອນ';
$string['eventcapabilityassigned'] = 'ແຕ່ງຕັ້ງຄວາມສາມາດແລ້ວ';
$string['eventcapabilityunassigned'] = 'ບໍ່ໄດ້ແຕ່ງຕັ້ງຄວາມສາມາດ';
$string['eventroleallowassignupdated'] = 'ອະນຸຍາດການແຕ່ງຕັ້ງໜ້າທີ່';
$string['eventroleallowoverrideupdated'] = 'ອະນຸຍາດການລົບລ້າງໜ້າທີ່';
$string['eventroleallowswitchupdated'] = 'ອະນຸຍາດການປ່ຽນໜ້າທີ່';
$string['eventroleallowviewupdated'] = 'ອະນຸຍາດເບິ່ງໜ້າທີ່';
$string['eventroleassigned'] = 'ແຕ່ງຕັ້ງໜ້າທີ່ແລ້ວ';
$string['eventrolecapabilitiesupdated'] = 'ປັບປຸງຄວາມສາມາດຂອງໜ້າທີ່ແລ້ວ';
$string['eventroledeleted'] = 'ລຶບໜ້າທີ່ແລ້ວ';
$string['eventroleunassigned'] = 'ບໍ່ໄດ້ແຕ່ງຕັ້ງໜ້າທີ່';
$string['eventroleupdated'] = 'ປັບປຸງໜ້າທີ່ແລ້ວ';
$string['existingadmins'] = 'ຜູ້ເບິ່ງແຍງເວັບໄຊທ໌ປະຈຸບັນ';
$string['existingusers'] = '{$a} ຜູ້ໃຊ້ທີ່ມີຢູ່';
$string['explanation'] = 'ການອະທິບາຍ';
$string['export'] = 'ສົ່ງອອກ';
$string['extusers'] = 'ຜູ້ໃຊ້ທີ່ມີຢູ່';
$string['extusersmatching'] = 'ຜູ້ໃຊ້ທີ່ມີຢູ່ກົງກັບ \'{$a}\'';
$string['filter:manage'] = 'ຈັດການການຕັ້ງຄ່າຕົວກັ່ນຕອງທ້ອງຖີ່ນ';
$string['frontpageuser'] = 'ກວດສອບຄວາມຖືກຕ້ອງຜູ້ໃຊ້ຢູ່ໃນໜ້າຫຼັກເວັບໄຊທ໌';
$string['frontpageuserdescription'] = 'ຜູ້ໃຊ້ທີ່ລົງຊື່ເຂົ້າໃຊ້ທັງໝົດໃນໜ້າຫຼັກເວັບໄຊທ໌ຂອງລາຍວິຊາ.';
$string['globalrole'] = 'ໜ້າທີ່ລະບົບ';
$string['globalroleswarning'] = 'ຄຳເຕືອນ: ໜ້າທີ່ໃດໜຶ່ງທີ່ທ່ານແຕ່ງຕັ້ງຈາກໜ້ານີ້ ຈະນຳໃຊ້ກັບຜູ້ໃຊ້ຕະຫຼອດທັງລະບົບລວມທັງໜ້າຫຼັກເວັບໄຊທ໌ ແລະ ວິຊາທັງໝົດ.';
$string['gotoassignroles'] = 'ໄປທີ່ ການແຕ່ງຕັ້ງໜ້າທີ່ ສຳລັບ {$a->contextlevel} ນີ້';
$string['gotoassignsystemroles'] = 'ໄປທີ່ ການແຕ່ງຕັ້ງລະບົບໜ້າທີ່';
$string['grade:edit'] = 'ແກ້ໄຂຄະແນນ';
$string['grade:export'] = 'ສົ່ງອອກຄະແນນ';
$string['grade:hide'] = 'ເຊື່ອງ/ຢຸດເຊື່ອງຄະແນນ ຫຼື ລາຍການ';
$string['grade:import'] = 'ນຳເຂົ້າຄະແນນ';
$string['grade:lock'] = 'ລັອກຄະແນນ ຫຼື ລາຍການ';
$string['grade:manage'] = 'ຈັດການລາຍການຄະແນນ';
$string['grade:managegradingforms'] = 'ຈັດການວິທີການໃຫ້ຄະແນນຂັ້ນສູງ';
$string['grade:manageletters'] = 'ຈັດການຄະແນນຕົວໜັງສື';
$string['grade:manageoutcomes'] = 'ຈັດການຜົນໄດ້ຮັບຄະແນນ';
$string['grade:managesharedforms'] = 'ຈັດການການໃຫ້ຄະແນນຂັ້ນສູງຈາກແມ່ແບບ';
$string['grade:override'] = 'ລົບລ້າງຄະແນນ';
$string['grade:sharegradingforms'] = 'ແບ່ງປັນການໃຫ້ຄະແນນຂັ້ນສູງຈາກແມ່ແບບ';
$string['grade:unlock'] = 'ລັອກຄະແນນ ຫຼື ລາຍການ';
$string['grade:view'] = 'ເບິ່ງຄະແນນຕົວເອງ';
$string['grade:viewall'] = 'ເບິ່ງຄະແນນຂອງຜູ້ໃຊ້ອື່ນ';
$string['grade:viewhidden'] = 'ເບິ່ງຄະແນນທີ່ເຊື່ອງໄວ້ສຳລັບຕົວເອງ';
$string['h5p:deploy'] = 'ນຳໃຊ້ເນື້ອໃນ H5P';
$string['h5p:setdisplayoptions'] = 'ຕັ້ງຕົວເລືອກການສະແດງຜົນ H5P';
$string['h5p:updatelibraries'] = 'ຈັດການປະເພດເນື້ອໃນ H5P';
$string['highlightedcellsshowdefault'] = 'ການອະນຸຍາດທີ່ໄດ້ເນັ້ນໃຫ້ເຫັນຢູ່ໃນຕາຕະລາງລຸ່ມນີ້ ແມ່ນຄ່າເລີ່ມຕົ້ນສໍາລັບຕົວແບບເດີມຂອງໜ້າທີ່ທີ່ເລືອກຢູ່ຂ້າງເທິງ.';
$string['highlightedcellsshowinherit'] = 'ຕາຕະລາງທີ່ເນັ້ນຢູ່ໃນຕາຕະລາງລຸ່ມນີ້ ສະແດງການອະນຸຍາດ (ຖ້າມີ) ທີ່ຈະສືບທອດມາ. ນອກ ເໜືອຈາກຄວາມສາມາດທີ່ມີການອະນຸຍາດທີ່ທ່ານຕ້ອງການປ່ຽນແປງຕົວຈິງ, ທ່ານຄວນປ່ອຍໃຫ້ທຸກຢ່າງຖືກຕັ້ງເປັນມໍລະດົກ.';
$string['inactiveformorethan'] = 'ບໍມີການເຄື່ອນໄຫວສຳລັບຫຼາຍກວ່າ {$a->timeperiod}';
$string['ingroup'] = 'ໃນກຸ່ມ "{$a->group}"';
$string['inherit'] = 'ສືບທອດ';
$string['invalidpresetfile'] = 'ໄຟລ໌ຄວາມໝາຍຂອງນ້າທີ່ບໍ່ຖືກຕ້ອງ';
$string['legacy:admin'] = 'ໜ້າທີ່ເດີມ: ຜູ້ບໍລິຫານ';
$string['legacy:coursecreator'] = 'ໜ້າທີ່ເດີມ: ຜູ້ສ້າງລາຍວິຊາ';
$string['legacy:editingteacher'] = 'ໜ້າທີ່ເດີມ: ຄູສອນ (ແກ້ໄຂ)';
$string['legacy:guest'] = 'ໜ້າທີ່ເດີມ: ແຂກ';
$string['legacy:student'] = 'ໜ້າທີ່ເດີມ: ນັກຮຽນ';
$string['legacy:teacher'] = 'ໜ້າທີ່ເດີມ: ຄູສອນ (ບໍ່ໄດ້ແກ້ໄຂ)';
$string['legacy:user'] = 'ໜ້າທີ່ເດີມ: ກວດສອບຄວາມຖືກຕ້ອງຜູ້ໃຊ້ແລ້ວ';
$string['legacytype'] = 'ປະເພດໜ້າທີ່ເດີມ';
$string['listallroles'] = 'ລາຍການໜ້າທີ່ທັງໝົດ';
$string['localroles'] = 'ໜ້າທີ່ທີ່ຖືກແຕ່ງຕັ້ງໃນທ້ອງຖີ່ນ';
$string['mainadmin'] = 'ຜູ້ບໍລິຫານຫຼັກ';
$string['mainadminset'] = 'ຕັ້ງຄ່າຜູ້ບໍລິຫານຫຼັກ';
$string['manageadmins'] = 'ຈັດການຜູ້ເບິ່ງແຍງເວັບໄຊທ໌';
$string['manager'] = 'ຜູ້ຈັດການ';
$string['managerdescription'] = 'ຜູ້ຈັດການສາມາດເຂົ້າຫາວິຊາ ແລະ ດັດແປງພວກມັນໄດ້, ແຕ່ໂດຍປົກກະຕິແລ້ວບໍ່ເຂົ້າຮ່ວມໃນວິຊາເຫຼົ່ານັ້ນ.';
$string['manageroles'] = 'ຈັດການໜ້າທີ່';
$string['maybeassignedin'] = 'ປະເພດບໍລິບົດທີ່ໜ້າທີ່ນີ້ຖືກແຕ່ງຕັ້ງ';
$string['morethan'] = 'ຫຼາຍກວ່າ {$a}';
$string['multipleroles'] = 'ຫຼາຍໜ້າທີ່';
$string['my:configsyspages'] = 'ກຳນົດຄ່າລະບົບແມ່ແບບສຳລັບໜ້າແຜງໜ້າປັດ';
$string['my:manageblocks'] = 'ຈັດການບລັອກໜ້າແຜງໜ້າປັດ';
$string['neededroles'] = 'ໜ້າທີ່ກັບການອະນຸຍາດ';
$string['nocapabilitiesincontext'] = 'ບໍ່ມີຄວາມສາມາດໃຫ້ໃນບໍລິບົດນີ້';
$string['noneinthisx'] = 'ບໍ່ມີໃນ {$a} ນີ້';
$string['noneinthisxmatching'] = 'ບໍ່ມີຜູ້ໃຊ້ກົງກັບ \'{$a->search}\' ໃນ {$a->contexttype} ນີ້';
$string['norole'] = 'ບໍ່ມີໜ້າທີ່';
$string['noroleassignments'] = 'ຜູ້ໃຊ້ນີ້ບໍ່ມີການແຕ່ງຕັ້ງໜ້າທີ່ໃດໆຢູ່ໃນເວົບໄຊທ໌ນີ້.';
$string['noroles'] = 'ບໍ່ມີບັນດາໜ້າທີ່';
$string['notabletoassignroleshere'] = 'ການມອບໝາຍໜ້າທີ່ໃນບໍລິບົດນີ້ບໍ່ໄດ້ຖືກເປີດໃຊ້ໂດຍຜູ້ເບິ່ງແຍງລະບົບ.';
$string['notabletooverrideroleshere'] = 'ທ່ານບໍ່ສາມາດລົບລ້າງການອະນຸຍາດໃນໜ້າທີ່ໃດໆຢູ່ທີ່ນີ້';
$string['notes:manage'] = 'ຈັດການກັບບັນທຶກ';
$string['notes:view'] = 'ເບິ່ງບັນທຶກ';
$string['notset'] = 'ບໍ່ໄດ້ຕັ້ງຄ່າ';
$string['novisibleroles'] = 'ບໍ່ມີໜ້າທີ່';
$string['overrideanotherrole'] = 'ການລົບລ້າງໜ້າທີ່ອື່ນ';
$string['overridecontext'] = 'ການລົບລ້າງບໍລິບົດ';
$string['overridepermissions'] = 'ການລົບລ້າງການອະນຸຍາດ';
$string['overridepermissions_help'] = 'ການລົບລ້າງການອະນຸຍາດເຮັດໃຫ້ຄວາມສາມາດທີ່ເລືອກໄດ້ຮັບອະນຸຍາດ ຫຼື ປ້ອງກັນໄດ້ຢູ່ໃນບໍລິບົດສະເພາະ.';
$string['overridepermissions_link'] = 'admin/roles/override';
$string['overridepermissionsforrole'] = 'ການລົບລ້າງການອະນຸຍາດສຳລັບໜ້າທີ່ \'{$a->role}\' ໃນ {$a->context}';
$string['overridepermissionsin'] = 'ການລົບລ້າງການອະນຸຍາດໃນ {$a}';
$string['overrideroles'] = 'ການລົບລ້າງໜ້າທີ່';
$string['overriderolesin'] = 'ການລົບລ້າງໜ້າທີ່ໃນ {$a}';
$string['overrides'] = 'ການລົບລ້າງ';
$string['overridesbycontext'] = 'ການລົບລ້າງ (ໂດຍບໍລິບົດ)';
$string['payment:manageaccounts'] = 'ຈັດການບັນຊີ';
$string['payment:viewpayments'] = 'ເບິ່ງການຊຳລະ';
$string['permission'] = 'ການອະນຸຍາດ';
$string['permission_help'] = 'ການອະນຸຍາດແມ່ນການຕັ້ງຄ່າຄວາມສາມາດ. ມີ 4 ທາງເລືອກ:

* ບໍ່ໄດ້ຕັ້ງຄ່າ
* ອະນຸຍາດ - ການອະນຸຍາດແມ່ນອະນຸມັດໃຫ້ສໍາລັບຄວາມສາມາດ
* ປ້ອງກັນ - ການອະນຸຍາດຖືກເອົາອອກສໍາລັບຄວາມສາມາດ, ເຖິງແມ່ນວ່າຈະອະນຸຍາດໃຫ້ຢູ່ໃນສະພາບທີ່ສູງກວ່າກໍ່ຕາມ
* ຂໍ້ຫ້າມ - ການອະນຸຍາດຖືກປະຕິເສດຢ່າງສົມບູນ ແລະ ບໍ່ສາມາດລົບລ້າງໄດ້ຢູ່ໃນບໍລິບົດການທີ່ຕໍ່າກວ່າ (ສະເພາະເຈາະຈົງເພີ່ມຕື່ມ)';
$string['permissions'] = 'ການອະນຸຍາດ';
$string['permissionsforuser'] = 'ການອະນຸຍາດສຳລັບຜູ້ໃຊ້ {$a}';
$string['permissionsincontext'] = 'ການອະນຸຍາດໃນ {$a}';
$string['portfolio:export'] = 'ສົ່ງອອກໄປທີ່ແຟ້ມຜົນງານ';
$string['potentialusers'] = '{$a} ຜູ້ໃຊ້ທີ່ມີທ່າແຮງ';
$string['potusers'] = 'ຜູ້ໃຊ້ທີ່ມີທ່າແຮງ';
$string['potusersmatching'] = 'ຜູ້ໃຊ້ທີ່ມີທ່າແຮງກົງກັບ \'{$a}\'';
$string['prevent'] = 'ການປ້ອງກັນ';
$string['privacy:metadata:preference:showadvanced'] = 'ຈັດການປຸ່ມສະຫຼັບແບບຂັ້ນສູງ.';
$string['privacy:metadata:role_assignments'] = 'ການແຕ່ງຕັ້ງໜ້າທີ່';
$string['privacy:metadata:role_assignments:component'] = 'ຄວາມຮັບຜິດຊອບປລັກອິນສຳລັບການຮັບຜິດຊອບໜ້າທີ່, ເປົ່າຫວ່າງເມື່ອແຕ່ງຕັ້ງດ້ວຍຕົວເອງ.';
$string['privacy:metadata:role_assignments:itemid'] = 'ລະຫັດປະຈຳຕົວຂອງຕົວຢ່າງການລົງທະບຽນຮຽນ/auth ຮັບຜິດຊອບສຳລັບການແຕ່ງຕັ້ງໜ້າທີ່ນີ້';
$string['privacy:metadata:role_assignments:modifierid'] = 'ລະຫັດປະຈຳຕົວຂອງຜູ້ທີ່ສ້າງ ຫຼື ດັດແກ້ການແຕ່ງຕັ້ໜ້າທີ່ນີ້';
$string['privacy:metadata:role_assignments:roleid'] = 'ລະຫັດປະຈຳຕົວຂອງໜ້າທີ່';
$string['privacy:metadata:role_assignments:tableexplanation'] = 'ຕາຕະລາງນີ້ເກັບຮັກສາໜ້າທີ່ທີ່ຖືກແຕ່ງຕັ້ງໃນແຕ່ລະບໍລິບົດ.';
$string['privacy:metadata:role_assignments:timemodified'] = 'ວັນທີເມື່ອການແຕ່ງຕັ້ງໜ້າທີ່ຖືກສ້າງ ຫຼື ດັດແກ້.';
$string['privacy:metadata:role_assignments:userid'] = 'ລະຫັດປະຈຳຕົວຂອງຜູ້ໃຊ້';
$string['privacy:metadata:role_capabilities'] = 'ຄວາມສາມາດຂອງໜ້າທີ່';
$string['privacy:metadata:role_capabilities:capability'] = 'ຊື່ຂອງຄວາມສາມາດ.';
$string['privacy:metadata:role_capabilities:modifierid'] = 'ລະຫັດປະຈຳຕົວຂອງຜູ້ໃຊ້ທີ່ສ້າງ ຫຼື ດັດແກ້ຄວາມສາມາດ';
$string['privacy:metadata:role_capabilities:permission'] = 'ການອະນຸຍາດສຳລັບຄວາມສາມາດ: ສືບທອດ, ອະນຸຍາດ, ປ້ອງກັນ ຫຼື ຂໍ້ຫ້າມ.';
$string['privacy:metadata:role_capabilities:roleid'] = 'ລະຫັດປະຈຳຕົວຂອງໜ້າທີ່';
$string['privacy:metadata:role_capabilities:tableexplanation'] = 'ຄວາມສາມາດ ແລະ ການລົບລ້າງຄວາມສາມາດສຳລັບໜ້າທີ່ສະເພາະໃນບໍລິບົດສະເພາະ';
$string['privacy:metadata:role_capabilities:timemodified'] = 'ວັນທີເມື່ອຄວາມສາມາດຖືກສ້າງ ຫຼື ດັດແກ້.';
$string['privacy:metadata:role_cohortroles'] = 'ໜ້າທີ່ຕໍ່ກຸ່ມ';
$string['prohibit'] = 'ຂໍ້ຫ້າມ';
$string['prohibitedroles'] = 'ຂໍ້ຫ້າມ';
$string['question:add'] = 'ເພີ່ມຄຳຖາມໃໝ່';
$string['question:commentall'] = 'ຄຳເຫັນໃນຄຳຖາມທັງໝົດ';
$string['question:commentmine'] = 'ຄຳເຫັນໃນຄຳຖາມຂອງຕົວທ່ານເອງ';
$string['question:config'] = 'ກຳນົດຄ່າປະເພດຄຳຖາມ';
$string['question:editall'] = 'ແກ້ໄຂຄຳຖາມທັງໝົດ';
$string['question:editmine'] = 'ແກ້ໄຂຄຳຖາມຂອງຕົວທ່ານເອງ';
$string['question:flag'] = 'ໝາຍທຸງຄຳຖາມໃນເວລາທີ່ພະຍາຍາມຕອບພວກມັນ';
$string['question:managecategory'] = 'ແກ້ໄຂປະເພດຄຳຖາມ';
$string['question:moveall'] = 'ຍ້າຍຄຳຖາມທັງໝົດ';
$string['question:movemine'] = 'ຍ້າຍຄຳຖາມຂອງຕົວທ່ານເອງ';
$string['question:tagall'] = 'ແທັກຄຳຖາມທັງໝົດ';
$string['question:tagmine'] = 'ແທັກຄຳຖາມຂອງຕົວທ່ານເອງ';
$string['question:useall'] = 'ໃຊ້ຄຳຖາມທັງໝົດ';
$string['question:usemine'] = 'ໃຊ້ຄຳຖາມຂອງຕົວທ່ານເອງ';
$string['question:viewall'] = 'ເບິ່ງຄຳຖາມທັງໝົດ';
$string['question:viewmine'] = 'ເບິ່ງຄຳຖາມຂອງຕົວທ່ານເອງ';
$string['rating:rate'] = 'ເພີ່ມການຈັດອັນດັບກັບລາຍການ';
$string['rating:view'] = 'ເບິ່ງການຈັດອັນດັບທັງໝົດທີ່ທ່ານໄດ້ຮັບ';
$string['rating:viewall'] = 'ເບິ່ງການຈັດອັນດັບດິບທັງໝົດທີ່ໃຫ້ໂດຍບຸກຄົນ';
$string['rating:viewany'] = 'ເບິ່ງການຈັດອັນດັບທັງໝົດທີ່ທຸກຄົນໄດ້ຮັບ';
$string['reportbuilder:edit'] = 'ແກ້ໄຂລາຍງານປັບແຕ່ງດ້ວຍຕົວທ່ານເອງ';
$string['reportbuilder:editall'] = 'ແກ້ໄຂລາຍງານປັບແຕ່ງເອງທັງໝົດ';
$string['reportbuilder:scheduleviewas'] = 'ລາຍງານກຳນົດເວລາ ເພື່ອເບິ່ງຜູ້ໃຊ້ອື່ນໆ';
$string['reportbuilder:view'] = 'ເບິ່ງລາຍງານປັບແຕ່ງເອງ';
$string['resetrole'] = 'ຕັ້ງຄ່າຄືນໃໝ່';
$string['resettingrole'] = 'ຕັ້ງຄ່າໜ້າທີ່ຄືນໃໝ່ \'{$a}\'';
$string['restore:configure'] = 'ກຳນົດຄ່າທາງເລືອກການກູ້ຄືນ';
$string['restore:createuser'] = 'ສ້າງຜູ້ໃຊ້ໃນການກູ້ຄືນ';
$string['restore:restoreactivity'] = 'ກູ້ຄືນກິດຈະກຳ';
$string['restore:restorecourse'] = 'ກູ້ຄືນວິຊາ';
$string['restore:restoresection'] = 'ກູ້ຄືນພາກສ່ວນ';
$string['restore:restoretargetimport'] = 'ກູ້ຄືນຈາກໄຟລ໌ເປົ້າໝາຍເປັນການນຳເຂົ້າ';
$string['restore:rolldates'] = 'ອະນຸຍາດໃຫ້ມ້ວນວັນທີການຕັ້ງຄ່າກິດຈະກໍາໃນການກູ້ຄືນ';
$string['restore:uploadfile'] = 'ອັບໂຫຼດໄຟລ໌ໄປພື້ນທີ່ການສຳຮອງຂໍ້ມູນ';
$string['restore:userinfo'] = 'ກູ້ຄືນຂໍ້ມູນຜູ້ໃຊ້';
$string['restore:viewautomatedfilearea'] = 'ກູ້ຄືນວິຊາຈາກການສຳຮອງຂໍ້ມູນອັດຕະໂນມັດ';
$string['risks'] = 'ສ່ຽງ';
$string['role:assign'] = 'ແຕ່ງຕັ້ງໜ້າທີ່ໃຫ້ຜູ້ໃຊ້';
$string['role:manage'] = 'ສ້າງ ແລະ ຈັດການໜ້າທີ່';
$string['role:override'] = 'ລົບລ້າງການອະນຸຍາດສຳລັບຜູ້ອື່ນ';
$string['role:review'] = 'ທົບທວນການອະນຸຍາດສຳລັບຜູ້ອື່ນ';
$string['role:safeoverride'] = 'ລົບລ້າງການອະນຸຍາດຄວາມປອດໄພສຳລັບຜູ້ອື່ນ';
$string['role:switchroles'] = 'ປ່ຽນໄປໜ້າທີ່ອື່ນ';
$string['roleallowheader'] = 'ອະນຸຍາດໜ້າທີ່:';
$string['roleallowinfo'] = 'ເລືອກໜ້າທີ່ທີ່ຈະເພີ່ມໃສ່ລາຍການຂອງໜ້າທີ່ອະນຸຍາດໃນບໍລິບົດ "{$a->context}", ຄວາມສາມາດ "{$a->cap}":';
$string['roleassignments'] = 'ການແຕ່ງຕັ້ງໜ້າທີ່';
$string['roledefinitions'] = 'ຄວາມໝາຍຂອງໜ້າທີ່';
$string['rolefullname'] = 'ຊື່ໜ້າທີ່';
$string['roleincontext'] = '{$a->role} ໃນ {$a->context}';
$string['roleprohibitheader'] = 'ໜ້າທີ່ຕ້ອງຫ້າມ';
$string['roleprohibitinfo'] = 'ເລືອກໜ້າທີ່ທີ່ຈະເພີ່ມໃສ່ລາຍການຂອງໜ້າທີ່ຕ້ອງຫ້າມໃນບໍລິບົດ "{$a->context}", ຄວາມສາມາດ "{$a->cap}":';
$string['rolerepreset'] = 'ໃຊ້ໜ້າທີ່ທີ່ຕັ້ງຄ່າໄວ້ລ່ວງໜ້າ';
$string['roleresetdefaults'] = 'ຄ່າເລີ່ມຕົ້ນ';
$string['roleresetrole'] = 'ໃຊ້ບົດບາດ ຫຼື ຕົວຢ່າງເດີມ';
$string['rolerisks'] = 'ຄວາມສ່ຽງດ້ານໜ້າທີ່';
$string['roles'] = 'ໜ້າທີ່';
$string['roles_help'] = 'ໜ້າທີ່ແມ່ນການເກັບກຳຂອງການອະນຸຍາດທີ່ກຳນົດສຳລັບລະບົບທັງໝົດທີ່ທ່ານສາມາດແຕ່ງຕັ້ງໃຫ້ຜູ້ໃຊ້ສະເພາະໃນບໍລິບົດສະເພາະ.';
$string['roles_link'] = 'roles';
$string['roleselect'] = 'ເລືອກໜ້າທີ່';
$string['rolesforuser'] = 'ໜ້າທີ່ສຳລັບຜູ້ໃຊ້ {$a}';
$string['roleshortname'] = 'ຊື່ຫຍໍ້';
$string['roleshortname_help'] = 'ຊື່ຫຍໍ້ຂອງໜ້າທີ່ແມ່ນຕົວລະບຸໜ້າທີ່ລະດັບຕໍ່າ ເຊິ່ງອະນຸຍາດໃຫ້ໃຊ້ຕົວອັກສອນ ແລະ ຕົວໜັງສືເປັນຕົວເລກ ASCII ເທົ່ານັ້ນ.';
$string['roletoassign'] = 'ໜ້າທີ່ທີ່ຈະແຕ່ງຕັ້ງ';
$string['roletooverride'] = 'ໜ້າທີ່ທີ່ຈະລົບລ້າງ';
$string['safeoverridenotice'] = 'ໝາຍເຫດ: ຄວາມສາມາດທີ່ມີຄວາມສ່ຽງສູງກວ່າຈະຖືກລັອກໄວ້ ເພາະວ່າທ່ານໄດ້ຮັບອະນຸຍາດໃຫ້ລົບລ້າງຄວາມສາມາດທີ່ປອດໄພເທົ່ານັ້ນ.';
$string['search:query'] = 'ປະຕິບັດການຊອກຫາທົ່ວເວັບໄຊທ໌';
$string['selectanotheruser'] = 'ເລືອກຜູ້ໃຊ້ອື່ນ';
$string['selectauser'] = 'ເລືອກຜູ້ໃຊ້';
$string['selectrole'] = 'ເລືອກໜ້າທີ່';
$string['showallroles'] = 'ສະແດງໜ້າທີ່ທັງໝົດ';
$string['showthisuserspermissions'] = 'ສະແດງການອະນຸຍາດຂອງຜູ້ໃຊ້ນີ້';
$string['site:accessallgroups'] = 'ເຂົ້າຫາທຸກກຸ່ມ';
$string['site:approvecourse'] = 'ອະນຸຍາດການສ້າງລາຍວິຊາ';
$string['site:backup'] = 'ການສຳຮອງຂໍ້ມູນລາຍວິຊາ';
$string['site:config'] = 'ປ່ຽນແປງການຕັ້ງຄ່າເວັບໄຊທ໌';
$string['site:configview'] = 'ເບິ່ງຕົ້ນໄມ້ບໍລິຫານເວັບໄຊທ໌ (ແຕ່ບໍ່ແມ່ນໝົດທຸກໜ້າໃນມັນ)';
$string['site:deleteanymessage'] = 'ລຶບຂໍ້ມູນໃດໜຶ່ງເທິງເວັບໄຊທ໌';
$string['site:deleteownmessage'] = 'ລຶບຂໍ້ມູນທີ່ສົ່ງໂດຍ ແລະ ໄປຫາຜູ້ໃຊ້';
$string['site:doanything'] = 'ອະນຸຍາດໃຫ້ເຮັດທຸກຢ່າງ';
$string['site:doclinks'] = 'ສະແດງລິ້ງໄປຫາເອກະສານນອກສະຖານທີ່';
$string['site:forcelanguage'] = 'ລົບລ້າງພາສາລາຍວິຊາ';
$string['site:import'] = 'ນຳເຂົ້າວິຊາອື່ນເຂົ້າໃນລາຍວິຊາ';
$string['site:maintenanceaccess'] = 'ເຂົ້າຫາເວັບໄຊທ໌ໃນຂະນະທີ່ຢູ່ໃນໂໝດການບຳລຸງຮັກສາ';
$string['site:manageallmessaging'] = 'ເພີ່ມ, ຍົກຍ້າຍ, ປິດກັ້ນ ແລະ ຢຸດປິດກັ້ນສຳລັບຜູ້ໃຊ້ໃດໜຶ່ງ';
$string['site:manageblocks'] = 'ຈັດການປິດກັ້ນເທິງໜ້າ';
$string['site:managecontextlocks'] = 'ຈັດການການແຊ່ເຢັນຂອງບໍລິບົດ';
$string['site:messageanyuser'] = 'ຂ້າມການຕັ້ງຄ່າຄວາມເປັນສ່ວນຕົວຂອງຜູ້ໃຊ້ ເພື່ອສົ່ງຂໍ້ຄວາມຫາຜູ້ໃຊ້ຄົນໃດໜຶ່ງ';
$string['site:mnetloginfromremote'] = 'ລົງຊື່ເຂົ້າໃຊ້ຈາກໂປຼແກຼມທາງໄກຜ່ານ MNet';
$string['site:mnetlogintoremote'] = 'ໃຊ້ເຄື່ອຂ່າຍໂຣມຈາກໂປຼແກຼມທາງໄກຜ່ານ MNet';
$string['site:readallmessages'] = 'ອ່ານຂໍ້ຄວາມທັງໝົດເທິງເວັບໄຊທ໌';
$string['site:restore'] = 'ກູ້ຄືນວິຊາ';
$string['site:senderrormessage'] = 'ສົ່ງຂໍ້ຄວາມຫາຜູ້ໃຊ້ສະໜັບສະໜູນຈາກໜ້າທີ່ມີຄວາມຜິດພາດ';
$string['site:sendmessage'] = 'ສົ່ງຂໍ້ຄວາມຫາຜູ້ໃຊ້ໃດໜຶ່ງ';
$string['site:trustcontent'] = 'ເນື້ອໃນທີ່ສົ່ງຄວາມເຊື່ອຖື';
$string['site:uploadusers'] = 'ອັບໂຫຼດຜູ້ໃຊ້ໃໝ່ຈາກໄຟລ໌';
$string['site:viewanonymousevents'] = 'ເບິ່ງນັດໝາຍທີ່ບໍ່ເປີດເຜີຍຊື່ໃນລາຍງານ';
$string['site:viewfullnames'] = 'ເບິ່ງຊື່ເຕັມຂອງຜູ້ໃຊ້ສະເໝີ';
$string['site:viewparticipants'] = 'ເບິ່ງຜູ້ເຂົ້າຮ່ວມ';
$string['site:viewreports'] = 'ເບິ່ງລາຍງານ';
$string['site:viewuseridentity'] = 'ເບິ່ງການລະບູຕົວຕົນເຕັມຂອງຜູ້ໃຊ້ໃນລາຍການ';
$string['siteadministrators'] = 'ຜູ້ເບິ່ງແຍງເວັບໄຊທ໌';
$string['tag:edit'] = 'ແກ້ໄຂແທັກທີ່ມີຢູ່';
$string['tag:editblocks'] = 'ແກ້ໄຂການປິດກັ້ນໃນໜ້າແທັກ';
$string['tag:flag'] = 'ໝາຍທຸງແທັກຖ້າຫາກບໍ່ເໝາະສົມ';
$string['tag:manage'] = 'ຈັດການແທັກທັງໝົດ';
$string['thisnewrole'] = 'ໜ້າທີ່ໃໝ່ນີ້';
$string['thisusersroles'] = 'ການແຕ່ງຕັ້ງໜ້າທີ່ຂອງຜູ້ໃຊ້ນີ້';
$string['unassignarole'] = 'ບໍ່ແຕ່ງຕັ້ງໜ້າທີ່ {$a}';
$string['unassignconfirm'] = 'ທ່ານຕ້ອງການທີ່ຈະບໍ່ແຕ່ງຕັ້ງໜ້າທີ່ "{$a->role}" ຈາກຜູ້ໃຊ້ "{$a->user}" ແທ້ບໍ?';
$string['unassignerror'] = 'ມີຄວາມຜິດພາດໃນການບໍ່ແຕ່ງຕັ້ງໜ້າທີ່ {$a->role} ຈາກຜູ້ໃຊ້ {$a->user}';
$string['user:changeownpassword'] = 'ປ່ຽນແປງລະຫັດຜ່ານຂອງຕົວເອງ';
$string['user:create'] = 'ສ້າງຜູ້ໃຊ້';
$string['user:delete'] = 'ລຶບຜູ້ໃຊ້';
$string['user:editmessageprofile'] = 'ແກ້ໄຂໂປຼໄຟລ໌ການສົ່ງຂໍ້ຄວາມຂອງຜູ້ໃຊ້';
$string['user:editownmessageprofile'] = 'ແກ້ໄຂໂປຼໄຟລ໌ການສົ່ງຂໍ້ຄວາມຂອງຜູ້ໃຊ້ຕົວເອງ';
$string['user:editownprofile'] = 'ແກ້ໄຂໂປຼໄຟລ໌ຂອງຜູ້ໃຊ້ຕົວເອງ';
$string['user:editprofile'] = 'ແກ້ໄຂໂປຼໄຟລ໌ຜູ້ໃຊ້';
$string['user:ignoreuserquota'] = 'ບໍ່ສົນໃຈຂີດຈຳກັດໂຄຕ້າຜູ້ໃຊ້';
$string['user:loginas'] = 'ລົງຊື່ເຂົ້າໃຊ້ເປັນຜູ້ໃຊ້ອື່ນ';
$string['user:manageblocks'] = 'ຈັດການການປິດກັ້ນເທິງໂປຼໄຟລ໌ຜູ້ໃຊ້ຂອງຜູ້ໃຊ້ອື່ນ';
$string['user:manageownblocks'] = 'ຈັດການການປິດກັ້ນເທິງໂປຼໄຟລ໌ຜູ້ໃຊ້ຂອງຕົວເອງ';
$string['user:manageownfiles'] = 'ຈັດການໄຟລ໌ເທິງພື້ນທີ່ໄຟລ໌ສ່ວນຕົວຂອງຕົວເອງ';
$string['user:managesyspages'] = 'ກຳນົດຄ່າເລີ່ມຕົ້ນໂຄງຮ່າງໜ້າສຳລັບໂປຼໄຟລ໌ຜູ້ໃຊ້ສາທາລະນະ';
$string['user:readuserblogs'] = 'ເບິ່ງບລ໋ອກຜູ້ໃຊ້ທັງໝົດ';
$string['user:readuserposts'] = 'ເບິ່ງໂພສບົດສົນທະນາຂອງຜູ້ໃຊ້ທັງໝົດ';
$string['user:update'] = 'ປັບປຸງໂປຼໄຟລ໌ຜູ້ໃຊ້';
$string['user:viewalldetails'] = 'ເບິ່ງຂໍ້ມູນເຕັມຂອງຜູ້ໃຊ້';
$string['user:viewdetails'] = 'ເບິ່ງໂປຼໄຟລ໌ຜູ້ໃຊ້';
$string['user:viewhiddendetails'] = 'ເບິ່ງຂໍ້ມູນທີ່ເຊື່ອງໄວ້ຂອງຜູ້ໃຊ້';
$string['user:viewlastip'] = 'ເບິ່ງທີ່ຢູ່ ip ຫຼ້າສຸດຂອງຜູ້ໃຊ້';
$string['user:viewuseractivitiesreport'] = 'ເບິ່ງລາຍງານກິດຈະກຳຂອງຜູ້ໃຊ້';
$string['user:viewusergrades'] = 'ເບິ່ງຄະແນນຂອງຜູ້ໃຊ້';
$string['usersfrom'] = 'ຜູ້ໃຊ້ຈາກ {$a}';
$string['usersfrommatching'] = 'ຜູ້ໃຊ້ຈາກ {$a->contextname} ກົງກັບ \'{$a->search}\'';
$string['usersinthisx'] = 'ຜູ້ໃຊ້ໃນ {$a} ນີ້';
$string['usersinthisxmatching'] = 'ຜູ້ໃຊ້ໃນ {$a->contexttype} ນີ້ກົງກັບ \'{$a->search}\'';
$string['userswithrole'] = 'ຜູ້ໃຊ້ທັງໝົດກັບໜ້າທີ່';
$string['userswiththisrole'] = 'ຜູ້ໃຊ້ກັບໜ້າທີ່';
$string['useshowadvancedtochange'] = 'ນຳໃຊ້ \'ສະແດງຂັ້ນສູງ\' ເພື່ອປ່ຽນແປງ';
$string['viewingdefinitionofrolex'] = 'ການເບິ່ງຄວາມໝາຍຂອງໜ້າທີ່ \'{$a}\'';
$string['viewrole'] = 'ເບິ່ງລາຍລະອຽດຂອງໜ້າທີ່';
$string['webservice:createmobiletoken'] = 'ສ້າງໂທເຄັນບໍລິການເວັບໄຊທ໌ສຳລັບການເຂົ້າຫາແບບເຄື່ອນທີ່';
$string['webservice:createtoken'] = 'ສ້າງໂທເຄັນບໍລິການເວັບໄຊທ໌';
$string['webservice:managealltokens'] = 'ຈັດການເຄັນບໍລິການເວັບໄຊທ໌ຂອງຜູ້ໃຊ້';
$string['whydoesuserhavecap'] = 'ເປັນຫຍັງ {$a->fullname} ມີຄວາມສາມາດ {$a->capability} ໃນບໍລິບົດ {$a->context}?';
$string['whydoesusernothavecap'] = 'ເປັນຫຍັງ {$a->fullname} ບໍ່ມີຄວາມສາມາດ {$a->capability} ໃນບໍລິບົດ {$a->context}?';
$string['xroleassignments'] = 'ການແຕ່ງຕັ້ງໜ້າທີ່ຂອງ {$a}';
$string['xuserswiththerole'] = 'ຜູ້ໃຊ້ກັບໜ້າທີ່ "{$a->role}"';
